/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/clouddms.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Request message for 'DescribeDatabaseEntities' request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest}
 */
public final class DescribeDatabaseEntitiesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest)
    DescribeDatabaseEntitiesRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DescribeDatabaseEntitiesRequest.newBuilder() to construct.
  private DescribeDatabaseEntitiesRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DescribeDatabaseEntitiesRequest() {
    conversionWorkspace_ = "";
    pageToken_ = "";
    tree_ = 0;
    commitId_ = "";
    filter_ = "";
    view_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DescribeDatabaseEntitiesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ClouddmsProto
        .internal_static_google_cloud_clouddms_v1_DescribeDatabaseEntitiesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ClouddmsProto
        .internal_static_google_cloud_clouddms_v1_DescribeDatabaseEntitiesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.class,
            com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of a tree to return
   * </pre>
   *
   * Protobuf enum {@code google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType}
   */
  public enum DBTreeType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified tree type.
     * </pre>
     *
     * <code>DB_TREE_TYPE_UNSPECIFIED = 0;</code>
     */
    DB_TREE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The source database tree.
     * </pre>
     *
     * <code>SOURCE_TREE = 1;</code>
     */
    SOURCE_TREE(1),
    /**
     *
     *
     * <pre>
     * The draft database tree.
     * </pre>
     *
     * <code>DRAFT_TREE = 2;</code>
     */
    DRAFT_TREE(2),
    /**
     *
     *
     * <pre>
     * The destination database tree.
     * </pre>
     *
     * <code>DESTINATION_TREE = 3;</code>
     */
    DESTINATION_TREE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified tree type.
     * </pre>
     *
     * <code>DB_TREE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int DB_TREE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The source database tree.
     * </pre>
     *
     * <code>SOURCE_TREE = 1;</code>
     */
    public static final int SOURCE_TREE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The draft database tree.
     * </pre>
     *
     * <code>DRAFT_TREE = 2;</code>
     */
    public static final int DRAFT_TREE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The destination database tree.
     * </pre>
     *
     * <code>DESTINATION_TREE = 3;</code>
     */
    public static final int DESTINATION_TREE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DBTreeType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DBTreeType forNumber(int value) {
      switch (value) {
        case 0:
          return DB_TREE_TYPE_UNSPECIFIED;
        case 1:
          return SOURCE_TREE;
        case 2:
          return DRAFT_TREE;
        case 3:
          return DESTINATION_TREE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DBTreeType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DBTreeType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DBTreeType>() {
          public DBTreeType findValueByNumber(int number) {
            return DBTreeType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final DBTreeType[] VALUES = values();

    public static DBTreeType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DBTreeType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType)
  }

  public static final int CONVERSION_WORKSPACE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object conversionWorkspace_ = "";
  /**
   *
   *
   * <pre>
   * Required. Name of the conversion workspace resource whose database entities
   * are described. Must be in the form of:
   * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
   * </pre>
   *
   * <code>
   * string conversion_workspace = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The conversionWorkspace.
   */
  @java.lang.Override
  public java.lang.String getConversionWorkspace() {
    java.lang.Object ref = conversionWorkspace_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      conversionWorkspace_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the conversion workspace resource whose database entities
   * are described. Must be in the form of:
   * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
   * </pre>
   *
   * <code>
   * string conversion_workspace = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for conversionWorkspace.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConversionWorkspaceBytes() {
    java.lang.Object ref = conversionWorkspace_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      conversionWorkspace_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 3;
  private int pageSize_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The maximum number of entities to return. The service may return
   * fewer entities than the value specifies.
   * </pre>
   *
   * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The nextPageToken value received in the previous call to
   * conversionWorkspace.describeDatabaseEntities, used in the subsequent
   * request to retrieve the next page of results. On first call this should be
   * left blank. When paginating, all other parameters provided to
   * conversionWorkspace.describeDatabaseEntities must match the call that
   * provided the page token.
   * </pre>
   *
   * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The nextPageToken value received in the previous call to
   * conversionWorkspace.describeDatabaseEntities, used in the subsequent
   * request to retrieve the next page of results. On first call this should be
   * left blank. When paginating, all other parameters provided to
   * conversionWorkspace.describeDatabaseEntities must match the call that
   * provided the page token.
   * </pre>
   *
   * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TREE_FIELD_NUMBER = 6;
  private int tree_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The tree to fetch.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType tree = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for tree.
   */
  @java.lang.Override
  public int getTreeValue() {
    return tree_;
  }
  /**
   *
   *
   * <pre>
   * Required. The tree to fetch.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType tree = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The tree.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType getTree() {
    com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType result =
        com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType.forNumber(tree_);
    return result == null
        ? com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType.UNRECOGNIZED
        : result;
  }

  public static final int UNCOMMITTED_FIELD_NUMBER = 11;
  private boolean uncommitted_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Whether to retrieve the latest committed version of the entities
   * or the latest version. This field is ignored if a specific commit_id is
   * specified.
   * </pre>
   *
   * <code>bool uncommitted = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The uncommitted.
   */
  @java.lang.Override
  public boolean getUncommitted() {
    return uncommitted_;
  }

  public static final int COMMIT_ID_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object commitId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Request a specific commit ID. If not specified, the entities from
   * the latest commit are returned.
   * </pre>
   *
   * <code>string commit_id = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The commitId.
   */
  @java.lang.Override
  public java.lang.String getCommitId() {
    java.lang.Object ref = commitId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      commitId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Request a specific commit ID. If not specified, the entities from
   * the latest commit are returned.
   * </pre>
   *
   * <code>string commit_id = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for commitId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCommitIdBytes() {
    java.lang.Object ref = commitId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      commitId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Filter the returned entities based on AIP-160 standard.
   * </pre>
   *
   * <code>string filter = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Filter the returned entities based on AIP-160 standard.
   * </pre>
   *
   * <code>string filter = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VIEW_FIELD_NUMBER = 14;
  private int view_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Results view based on AIP-157
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.DatabaseEntityView view = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for view.
   */
  @java.lang.Override
  public int getViewValue() {
    return view_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Results view based on AIP-157
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.DatabaseEntityView view = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The view.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DatabaseEntityView getView() {
    com.google.cloud.clouddms.v1.DatabaseEntityView result =
        com.google.cloud.clouddms.v1.DatabaseEntityView.forNumber(view_);
    return result == null ? com.google.cloud.clouddms.v1.DatabaseEntityView.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversionWorkspace_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, conversionWorkspace_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(3, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, pageToken_);
    }
    if (tree_
        != com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType
            .DB_TREE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, tree_);
    }
    if (uncommitted_ != false) {
      output.writeBool(11, uncommitted_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(commitId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, commitId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, filter_);
    }
    if (view_
        != com.google.cloud.clouddms.v1.DatabaseEntityView.DATABASE_ENTITY_VIEW_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(14, view_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversionWorkspace_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, conversionWorkspace_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, pageToken_);
    }
    if (tree_
        != com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType
            .DB_TREE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, tree_);
    }
    if (uncommitted_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, uncommitted_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(commitId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, commitId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, filter_);
    }
    if (view_
        != com.google.cloud.clouddms.v1.DatabaseEntityView.DATABASE_ENTITY_VIEW_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(14, view_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest other =
        (com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest) obj;

    if (!getConversionWorkspace().equals(other.getConversionWorkspace())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (tree_ != other.tree_) return false;
    if (getUncommitted() != other.getUncommitted()) return false;
    if (!getCommitId().equals(other.getCommitId())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (view_ != other.view_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CONVERSION_WORKSPACE_FIELD_NUMBER;
    hash = (53 * hash) + getConversionWorkspace().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (37 * hash) + TREE_FIELD_NUMBER;
    hash = (53 * hash) + tree_;
    hash = (37 * hash) + UNCOMMITTED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUncommitted());
    hash = (37 * hash) + COMMIT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getCommitId().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + VIEW_FIELD_NUMBER;
    hash = (53 * hash) + view_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for 'DescribeDatabaseEntities' request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest)
      com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_DescribeDatabaseEntitiesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_DescribeDatabaseEntitiesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.class,
              com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      conversionWorkspace_ = "";
      pageSize_ = 0;
      pageToken_ = "";
      tree_ = 0;
      uncommitted_ = false;
      commitId_ = "";
      filter_ = "";
      view_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_DescribeDatabaseEntitiesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest
        getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest build() {
      com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest buildPartial() {
      com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest result =
          new com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.conversionWorkspace_ = conversionWorkspace_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pageToken_ = pageToken_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.tree_ = tree_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.uncommitted_ = uncommitted_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.commitId_ = commitId_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.view_ = view_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest) {
        return mergeFrom((com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest other) {
      if (other
          == com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.getDefaultInstance())
        return this;
      if (!other.getConversionWorkspace().isEmpty()) {
        conversionWorkspace_ = other.conversionWorkspace_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.tree_ != 0) {
        setTreeValue(other.getTreeValue());
      }
      if (other.getUncommitted() != false) {
        setUncommitted(other.getUncommitted());
      }
      if (!other.getCommitId().isEmpty()) {
        commitId_ = other.commitId_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.view_ != 0) {
        setViewValue(other.getViewValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                conversionWorkspace_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 24:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 24
            case 34:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 48:
              {
                tree_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 48
            case 88:
              {
                uncommitted_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 88
            case 98:
              {
                commitId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 98
            case 106:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 106
            case 112:
              {
                view_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 112
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object conversionWorkspace_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the conversion workspace resource whose database entities
     * are described. Must be in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>
     * string conversion_workspace = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The conversionWorkspace.
     */
    public java.lang.String getConversionWorkspace() {
      java.lang.Object ref = conversionWorkspace_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        conversionWorkspace_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the conversion workspace resource whose database entities
     * are described. Must be in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>
     * string conversion_workspace = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for conversionWorkspace.
     */
    public com.google.protobuf.ByteString getConversionWorkspaceBytes() {
      java.lang.Object ref = conversionWorkspace_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        conversionWorkspace_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the conversion workspace resource whose database entities
     * are described. Must be in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>
     * string conversion_workspace = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The conversionWorkspace to set.
     * @return This builder for chaining.
     */
    public Builder setConversionWorkspace(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      conversionWorkspace_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the conversion workspace resource whose database entities
     * are described. Must be in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>
     * string conversion_workspace = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConversionWorkspace() {
      conversionWorkspace_ = getDefaultInstance().getConversionWorkspace();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the conversion workspace resource whose database entities
     * are described. Must be in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>
     * string conversion_workspace = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for conversionWorkspace to set.
     * @return This builder for chaining.
     */
    public Builder setConversionWorkspaceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      conversionWorkspace_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * Optional. The maximum number of entities to return. The service may return
     * fewer entities than the value specifies.
     * </pre>
     *
     * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum number of entities to return. The service may return
     * fewer entities than the value specifies.
     * </pre>
     *
     * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The maximum number of entities to return. The service may return
     * fewer entities than the value specifies.
     * </pre>
     *
     * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000002);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The nextPageToken value received in the previous call to
     * conversionWorkspace.describeDatabaseEntities, used in the subsequent
     * request to retrieve the next page of results. On first call this should be
     * left blank. When paginating, all other parameters provided to
     * conversionWorkspace.describeDatabaseEntities must match the call that
     * provided the page token.
     * </pre>
     *
     * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The nextPageToken value received in the previous call to
     * conversionWorkspace.describeDatabaseEntities, used in the subsequent
     * request to retrieve the next page of results. On first call this should be
     * left blank. When paginating, all other parameters provided to
     * conversionWorkspace.describeDatabaseEntities must match the call that
     * provided the page token.
     * </pre>
     *
     * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The nextPageToken value received in the previous call to
     * conversionWorkspace.describeDatabaseEntities, used in the subsequent
     * request to retrieve the next page of results. On first call this should be
     * left blank. When paginating, all other parameters provided to
     * conversionWorkspace.describeDatabaseEntities must match the call that
     * provided the page token.
     * </pre>
     *
     * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The nextPageToken value received in the previous call to
     * conversionWorkspace.describeDatabaseEntities, used in the subsequent
     * request to retrieve the next page of results. On first call this should be
     * left blank. When paginating, all other parameters provided to
     * conversionWorkspace.describeDatabaseEntities must match the call that
     * provided the page token.
     * </pre>
     *
     * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The nextPageToken value received in the previous call to
     * conversionWorkspace.describeDatabaseEntities, used in the subsequent
     * request to retrieve the next page of results. On first call this should be
     * left blank. When paginating, all other parameters provided to
     * conversionWorkspace.describeDatabaseEntities must match the call that
     * provided the page token.
     * </pre>
     *
     * <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int tree_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The tree to fetch.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType tree = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for tree.
     */
    @java.lang.Override
    public int getTreeValue() {
      return tree_;
    }
    /**
     *
     *
     * <pre>
     * Required. The tree to fetch.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType tree = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for tree to set.
     * @return This builder for chaining.
     */
    public Builder setTreeValue(int value) {
      tree_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The tree to fetch.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType tree = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The tree.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType getTree() {
      com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType result =
          com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType.forNumber(tree_);
      return result == null
          ? com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The tree to fetch.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType tree = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The tree to set.
     * @return This builder for chaining.
     */
    public Builder setTree(
        com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      tree_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The tree to fetch.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType tree = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTree() {
      bitField0_ = (bitField0_ & ~0x00000008);
      tree_ = 0;
      onChanged();
      return this;
    }

    private boolean uncommitted_;
    /**
     *
     *
     * <pre>
     * Optional. Whether to retrieve the latest committed version of the entities
     * or the latest version. This field is ignored if a specific commit_id is
     * specified.
     * </pre>
     *
     * <code>bool uncommitted = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The uncommitted.
     */
    @java.lang.Override
    public boolean getUncommitted() {
      return uncommitted_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether to retrieve the latest committed version of the entities
     * or the latest version. This field is ignored if a specific commit_id is
     * specified.
     * </pre>
     *
     * <code>bool uncommitted = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The uncommitted to set.
     * @return This builder for chaining.
     */
    public Builder setUncommitted(boolean value) {

      uncommitted_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether to retrieve the latest committed version of the entities
     * or the latest version. This field is ignored if a specific commit_id is
     * specified.
     * </pre>
     *
     * <code>bool uncommitted = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUncommitted() {
      bitField0_ = (bitField0_ & ~0x00000010);
      uncommitted_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object commitId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Request a specific commit ID. If not specified, the entities from
     * the latest commit are returned.
     * </pre>
     *
     * <code>string commit_id = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The commitId.
     */
    public java.lang.String getCommitId() {
      java.lang.Object ref = commitId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        commitId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Request a specific commit ID. If not specified, the entities from
     * the latest commit are returned.
     * </pre>
     *
     * <code>string commit_id = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for commitId.
     */
    public com.google.protobuf.ByteString getCommitIdBytes() {
      java.lang.Object ref = commitId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        commitId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Request a specific commit ID. If not specified, the entities from
     * the latest commit are returned.
     * </pre>
     *
     * <code>string commit_id = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The commitId to set.
     * @return This builder for chaining.
     */
    public Builder setCommitId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      commitId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Request a specific commit ID. If not specified, the entities from
     * the latest commit are returned.
     * </pre>
     *
     * <code>string commit_id = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCommitId() {
      commitId_ = getDefaultInstance().getCommitId();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Request a specific commit ID. If not specified, the entities from
     * the latest commit are returned.
     * </pre>
     *
     * <code>string commit_id = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for commitId to set.
     * @return This builder for chaining.
     */
    public Builder setCommitIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      commitId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Filter the returned entities based on AIP-160 standard.
     * </pre>
     *
     * <code>string filter = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter the returned entities based on AIP-160 standard.
     * </pre>
     *
     * <code>string filter = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter the returned entities based on AIP-160 standard.
     * </pre>
     *
     * <code>string filter = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter the returned entities based on AIP-160 standard.
     * </pre>
     *
     * <code>string filter = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter the returned entities based on AIP-160 standard.
     * </pre>
     *
     * <code>string filter = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private int view_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Results view based on AIP-157
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEntityView view = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for view.
     */
    @java.lang.Override
    public int getViewValue() {
      return view_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Results view based on AIP-157
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEntityView view = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for view to set.
     * @return This builder for chaining.
     */
    public Builder setViewValue(int value) {
      view_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Results view based on AIP-157
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEntityView view = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The view.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.DatabaseEntityView getView() {
      com.google.cloud.clouddms.v1.DatabaseEntityView result =
          com.google.cloud.clouddms.v1.DatabaseEntityView.forNumber(view_);
      return result == null ? com.google.cloud.clouddms.v1.DatabaseEntityView.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Results view based on AIP-157
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEntityView view = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The view to set.
     * @return This builder for chaining.
     */
    public Builder setView(com.google.cloud.clouddms.v1.DatabaseEntityView value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      view_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Results view based on AIP-157
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEntityView view = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearView() {
      bitField0_ = (bitField0_ & ~0x00000080);
      view_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest)
  private static final com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest();
  }

  public static com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DescribeDatabaseEntitiesRequest> PARSER =
      new com.google.protobuf.AbstractParser<DescribeDatabaseEntitiesRequest>() {
        @java.lang.Override
        public DescribeDatabaseEntitiesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DescribeDatabaseEntitiesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DescribeDatabaseEntitiesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
