/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * A single DDL statement for a specific entity
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.EntityDdl}
 */
public final class EntityDdl extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.EntityDdl)
    EntityDdlOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EntityDdl.newBuilder() to construct.
  private EntityDdl(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EntityDdl() {
    ddlType_ = "";
    entity_ = "";
    ddl_ = "";
    entityType_ = 0;
    issueId_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EntityDdl();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_EntityDdl_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_EntityDdl_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.EntityDdl.class,
            com.google.cloud.clouddms.v1.EntityDdl.Builder.class);
  }

  public static final int DDL_TYPE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ddlType_ = "";
  /**
   *
   *
   * <pre>
   * Type of DDL (Create, Alter).
   * </pre>
   *
   * <code>string ddl_type = 1;</code>
   *
   * @return The ddlType.
   */
  @java.lang.Override
  public java.lang.String getDdlType() {
    java.lang.Object ref = ddlType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ddlType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Type of DDL (Create, Alter).
   * </pre>
   *
   * <code>string ddl_type = 1;</code>
   *
   * @return The bytes for ddlType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDdlTypeBytes() {
    java.lang.Object ref = ddlType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ddlType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENTITY_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object entity_ = "";
  /**
   *
   *
   * <pre>
   * The name of the database entity the ddl refers to.
   * </pre>
   *
   * <code>string entity = 2;</code>
   *
   * @return The entity.
   */
  @java.lang.Override
  public java.lang.String getEntity() {
    java.lang.Object ref = entity_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entity_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the database entity the ddl refers to.
   * </pre>
   *
   * <code>string entity = 2;</code>
   *
   * @return The bytes for entity.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntityBytes() {
    java.lang.Object ref = entity_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entity_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DDL_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ddl_ = "";
  /**
   *
   *
   * <pre>
   * The actual ddl code.
   * </pre>
   *
   * <code>string ddl = 3;</code>
   *
   * @return The ddl.
   */
  @java.lang.Override
  public java.lang.String getDdl() {
    java.lang.Object ref = ddl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ddl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The actual ddl code.
   * </pre>
   *
   * <code>string ddl = 3;</code>
   *
   * @return The bytes for ddl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDdlBytes() {
    java.lang.Object ref = ddl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ddl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENTITY_TYPE_FIELD_NUMBER = 4;
  private int entityType_ = 0;
  /**
   *
   *
   * <pre>
   * The entity type (if the DDL is for a sub entity).
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 4;</code>
   *
   * @return The enum numeric value on the wire for entityType.
   */
  @java.lang.Override
  public int getEntityTypeValue() {
    return entityType_;
  }
  /**
   *
   *
   * <pre>
   * The entity type (if the DDL is for a sub entity).
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 4;</code>
   *
   * @return The entityType.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DatabaseEntityType getEntityType() {
    com.google.cloud.clouddms.v1.DatabaseEntityType result =
        com.google.cloud.clouddms.v1.DatabaseEntityType.forNumber(entityType_);
    return result == null ? com.google.cloud.clouddms.v1.DatabaseEntityType.UNRECOGNIZED : result;
  }

  public static final int ISSUE_ID_FIELD_NUMBER = 100;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList issueId_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * EntityIssues found for this ddl.
   * </pre>
   *
   * <code>repeated string issue_id = 100;</code>
   *
   * @return A list containing the issueId.
   */
  public com.google.protobuf.ProtocolStringList getIssueIdList() {
    return issueId_;
  }
  /**
   *
   *
   * <pre>
   * EntityIssues found for this ddl.
   * </pre>
   *
   * <code>repeated string issue_id = 100;</code>
   *
   * @return The count of issueId.
   */
  public int getIssueIdCount() {
    return issueId_.size();
  }
  /**
   *
   *
   * <pre>
   * EntityIssues found for this ddl.
   * </pre>
   *
   * <code>repeated string issue_id = 100;</code>
   *
   * @param index The index of the element to return.
   * @return The issueId at the given index.
   */
  public java.lang.String getIssueId(int index) {
    return issueId_.get(index);
  }
  /**
   *
   *
   * <pre>
   * EntityIssues found for this ddl.
   * </pre>
   *
   * <code>repeated string issue_id = 100;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the issueId at the given index.
   */
  public com.google.protobuf.ByteString getIssueIdBytes(int index) {
    return issueId_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ddlType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, ddlType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entity_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, entity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ddl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, ddl_);
    }
    if (entityType_
        != com.google.cloud.clouddms.v1.DatabaseEntityType.DATABASE_ENTITY_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, entityType_);
    }
    for (int i = 0; i < issueId_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 100, issueId_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ddlType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, ddlType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entity_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, entity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ddl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, ddl_);
    }
    if (entityType_
        != com.google.cloud.clouddms.v1.DatabaseEntityType.DATABASE_ENTITY_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, entityType_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < issueId_.size(); i++) {
        dataSize += computeStringSizeNoTag(issueId_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getIssueIdList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.EntityDdl)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.EntityDdl other = (com.google.cloud.clouddms.v1.EntityDdl) obj;

    if (!getDdlType().equals(other.getDdlType())) return false;
    if (!getEntity().equals(other.getEntity())) return false;
    if (!getDdl().equals(other.getDdl())) return false;
    if (entityType_ != other.entityType_) return false;
    if (!getIssueIdList().equals(other.getIssueIdList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DDL_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getDdlType().hashCode();
    hash = (37 * hash) + ENTITY_FIELD_NUMBER;
    hash = (53 * hash) + getEntity().hashCode();
    hash = (37 * hash) + DDL_FIELD_NUMBER;
    hash = (53 * hash) + getDdl().hashCode();
    hash = (37 * hash) + ENTITY_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + entityType_;
    if (getIssueIdCount() > 0) {
      hash = (37 * hash) + ISSUE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getIssueIdList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.EntityDdl parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.EntityDdl parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.EntityDdl parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.EntityDdl parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.EntityDdl parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.EntityDdl parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.EntityDdl parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.EntityDdl parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.EntityDdl parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.EntityDdl parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.EntityDdl parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.EntityDdl parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.EntityDdl prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A single DDL statement for a specific entity
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.EntityDdl}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.EntityDdl)
      com.google.cloud.clouddms.v1.EntityDdlOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_EntityDdl_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_EntityDdl_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.EntityDdl.class,
              com.google.cloud.clouddms.v1.EntityDdl.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.EntityDdl.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      ddlType_ = "";
      entity_ = "";
      ddl_ = "";
      entityType_ = 0;
      issueId_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_EntityDdl_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.EntityDdl getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.EntityDdl.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.EntityDdl build() {
      com.google.cloud.clouddms.v1.EntityDdl result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.EntityDdl buildPartial() {
      com.google.cloud.clouddms.v1.EntityDdl result =
          new com.google.cloud.clouddms.v1.EntityDdl(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.EntityDdl result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.ddlType_ = ddlType_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.entity_ = entity_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.ddl_ = ddl_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.entityType_ = entityType_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        issueId_.makeImmutable();
        result.issueId_ = issueId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.EntityDdl) {
        return mergeFrom((com.google.cloud.clouddms.v1.EntityDdl) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.EntityDdl other) {
      if (other == com.google.cloud.clouddms.v1.EntityDdl.getDefaultInstance()) return this;
      if (!other.getDdlType().isEmpty()) {
        ddlType_ = other.ddlType_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getEntity().isEmpty()) {
        entity_ = other.entity_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDdl().isEmpty()) {
        ddl_ = other.ddl_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.entityType_ != 0) {
        setEntityTypeValue(other.getEntityTypeValue());
      }
      if (!other.issueId_.isEmpty()) {
        if (issueId_.isEmpty()) {
          issueId_ = other.issueId_;
          bitField0_ |= 0x00000010;
        } else {
          ensureIssueIdIsMutable();
          issueId_.addAll(other.issueId_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                ddlType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                entity_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                ddl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                entityType_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 802:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIssueIdIsMutable();
                issueId_.add(s);
                break;
              } // case 802
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object ddlType_ = "";
    /**
     *
     *
     * <pre>
     * Type of DDL (Create, Alter).
     * </pre>
     *
     * <code>string ddl_type = 1;</code>
     *
     * @return The ddlType.
     */
    public java.lang.String getDdlType() {
      java.lang.Object ref = ddlType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ddlType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of DDL (Create, Alter).
     * </pre>
     *
     * <code>string ddl_type = 1;</code>
     *
     * @return The bytes for ddlType.
     */
    public com.google.protobuf.ByteString getDdlTypeBytes() {
      java.lang.Object ref = ddlType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ddlType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of DDL (Create, Alter).
     * </pre>
     *
     * <code>string ddl_type = 1;</code>
     *
     * @param value The ddlType to set.
     * @return This builder for chaining.
     */
    public Builder setDdlType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ddlType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of DDL (Create, Alter).
     * </pre>
     *
     * <code>string ddl_type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDdlType() {
      ddlType_ = getDefaultInstance().getDdlType();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of DDL (Create, Alter).
     * </pre>
     *
     * <code>string ddl_type = 1;</code>
     *
     * @param value The bytes for ddlType to set.
     * @return This builder for chaining.
     */
    public Builder setDdlTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ddlType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object entity_ = "";
    /**
     *
     *
     * <pre>
     * The name of the database entity the ddl refers to.
     * </pre>
     *
     * <code>string entity = 2;</code>
     *
     * @return The entity.
     */
    public java.lang.String getEntity() {
      java.lang.Object ref = entity_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entity_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the database entity the ddl refers to.
     * </pre>
     *
     * <code>string entity = 2;</code>
     *
     * @return The bytes for entity.
     */
    public com.google.protobuf.ByteString getEntityBytes() {
      java.lang.Object ref = entity_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entity_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the database entity the ddl refers to.
     * </pre>
     *
     * <code>string entity = 2;</code>
     *
     * @param value The entity to set.
     * @return This builder for chaining.
     */
    public Builder setEntity(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      entity_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the database entity the ddl refers to.
     * </pre>
     *
     * <code>string entity = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntity() {
      entity_ = getDefaultInstance().getEntity();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the database entity the ddl refers to.
     * </pre>
     *
     * <code>string entity = 2;</code>
     *
     * @param value The bytes for entity to set.
     * @return This builder for chaining.
     */
    public Builder setEntityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      entity_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object ddl_ = "";
    /**
     *
     *
     * <pre>
     * The actual ddl code.
     * </pre>
     *
     * <code>string ddl = 3;</code>
     *
     * @return The ddl.
     */
    public java.lang.String getDdl() {
      java.lang.Object ref = ddl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ddl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The actual ddl code.
     * </pre>
     *
     * <code>string ddl = 3;</code>
     *
     * @return The bytes for ddl.
     */
    public com.google.protobuf.ByteString getDdlBytes() {
      java.lang.Object ref = ddl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ddl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The actual ddl code.
     * </pre>
     *
     * <code>string ddl = 3;</code>
     *
     * @param value The ddl to set.
     * @return This builder for chaining.
     */
    public Builder setDdl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ddl_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The actual ddl code.
     * </pre>
     *
     * <code>string ddl = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDdl() {
      ddl_ = getDefaultInstance().getDdl();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The actual ddl code.
     * </pre>
     *
     * <code>string ddl = 3;</code>
     *
     * @param value The bytes for ddl to set.
     * @return This builder for chaining.
     */
    public Builder setDdlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ddl_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int entityType_ = 0;
    /**
     *
     *
     * <pre>
     * The entity type (if the DDL is for a sub entity).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 4;</code>
     *
     * @return The enum numeric value on the wire for entityType.
     */
    @java.lang.Override
    public int getEntityTypeValue() {
      return entityType_;
    }
    /**
     *
     *
     * <pre>
     * The entity type (if the DDL is for a sub entity).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 4;</code>
     *
     * @param value The enum numeric value on the wire for entityType to set.
     * @return This builder for chaining.
     */
    public Builder setEntityTypeValue(int value) {
      entityType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity type (if the DDL is for a sub entity).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 4;</code>
     *
     * @return The entityType.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.DatabaseEntityType getEntityType() {
      com.google.cloud.clouddms.v1.DatabaseEntityType result =
          com.google.cloud.clouddms.v1.DatabaseEntityType.forNumber(entityType_);
      return result == null ? com.google.cloud.clouddms.v1.DatabaseEntityType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The entity type (if the DDL is for a sub entity).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 4;</code>
     *
     * @param value The entityType to set.
     * @return This builder for chaining.
     */
    public Builder setEntityType(com.google.cloud.clouddms.v1.DatabaseEntityType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      entityType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity type (if the DDL is for a sub entity).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntityType() {
      bitField0_ = (bitField0_ & ~0x00000008);
      entityType_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList issueId_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureIssueIdIsMutable() {
      if (!issueId_.isModifiable()) {
        issueId_ = new com.google.protobuf.LazyStringArrayList(issueId_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * EntityIssues found for this ddl.
     * </pre>
     *
     * <code>repeated string issue_id = 100;</code>
     *
     * @return A list containing the issueId.
     */
    public com.google.protobuf.ProtocolStringList getIssueIdList() {
      issueId_.makeImmutable();
      return issueId_;
    }
    /**
     *
     *
     * <pre>
     * EntityIssues found for this ddl.
     * </pre>
     *
     * <code>repeated string issue_id = 100;</code>
     *
     * @return The count of issueId.
     */
    public int getIssueIdCount() {
      return issueId_.size();
    }
    /**
     *
     *
     * <pre>
     * EntityIssues found for this ddl.
     * </pre>
     *
     * <code>repeated string issue_id = 100;</code>
     *
     * @param index The index of the element to return.
     * @return The issueId at the given index.
     */
    public java.lang.String getIssueId(int index) {
      return issueId_.get(index);
    }
    /**
     *
     *
     * <pre>
     * EntityIssues found for this ddl.
     * </pre>
     *
     * <code>repeated string issue_id = 100;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the issueId at the given index.
     */
    public com.google.protobuf.ByteString getIssueIdBytes(int index) {
      return issueId_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * EntityIssues found for this ddl.
     * </pre>
     *
     * <code>repeated string issue_id = 100;</code>
     *
     * @param index The index to set the value at.
     * @param value The issueId to set.
     * @return This builder for chaining.
     */
    public Builder setIssueId(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIssueIdIsMutable();
      issueId_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * EntityIssues found for this ddl.
     * </pre>
     *
     * <code>repeated string issue_id = 100;</code>
     *
     * @param value The issueId to add.
     * @return This builder for chaining.
     */
    public Builder addIssueId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIssueIdIsMutable();
      issueId_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * EntityIssues found for this ddl.
     * </pre>
     *
     * <code>repeated string issue_id = 100;</code>
     *
     * @param values The issueId to add.
     * @return This builder for chaining.
     */
    public Builder addAllIssueId(java.lang.Iterable<java.lang.String> values) {
      ensureIssueIdIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, issueId_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * EntityIssues found for this ddl.
     * </pre>
     *
     * <code>repeated string issue_id = 100;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIssueId() {
      issueId_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * EntityIssues found for this ddl.
     * </pre>
     *
     * <code>repeated string issue_id = 100;</code>
     *
     * @param value The bytes of the issueId to add.
     * @return This builder for chaining.
     */
    public Builder addIssueIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIssueIdIsMutable();
      issueId_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.EntityDdl)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.EntityDdl)
  private static final com.google.cloud.clouddms.v1.EntityDdl DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.EntityDdl();
  }

  public static com.google.cloud.clouddms.v1.EntityDdl getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EntityDdl> PARSER =
      new com.google.protobuf.AbstractParser<EntityDdl>() {
        @java.lang.Override
        public EntityDdl parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EntityDdl> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EntityDdl> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.EntityDdl getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
