/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Issue related to the entity.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.EntityIssue}
 */
public final class EntityIssue extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.EntityIssue)
    EntityIssueOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EntityIssue.newBuilder() to construct.
  private EntityIssue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EntityIssue() {
    id_ = "";
    type_ = 0;
    severity_ = 0;
    message_ = "";
    code_ = "";
    ddl_ = "";
    entityType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EntityIssue();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_EntityIssue_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_EntityIssue_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.EntityIssue.class,
            com.google.cloud.clouddms.v1.EntityIssue.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Type of issue.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.clouddms.v1.EntityIssue.IssueType}
   */
  public enum IssueType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified issue type.
     * </pre>
     *
     * <code>ISSUE_TYPE_UNSPECIFIED = 0;</code>
     */
    ISSUE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Issue originated from the DDL
     * </pre>
     *
     * <code>ISSUE_TYPE_DDL = 1;</code>
     */
    ISSUE_TYPE_DDL(1),
    /**
     *
     *
     * <pre>
     * Issue originated during the apply process
     * </pre>
     *
     * <code>ISSUE_TYPE_APPLY = 2;</code>
     */
    ISSUE_TYPE_APPLY(2),
    /**
     *
     *
     * <pre>
     * Issue originated during the convert process
     * </pre>
     *
     * <code>ISSUE_TYPE_CONVERT = 3;</code>
     */
    ISSUE_TYPE_CONVERT(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified issue type.
     * </pre>
     *
     * <code>ISSUE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int ISSUE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Issue originated from the DDL
     * </pre>
     *
     * <code>ISSUE_TYPE_DDL = 1;</code>
     */
    public static final int ISSUE_TYPE_DDL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Issue originated during the apply process
     * </pre>
     *
     * <code>ISSUE_TYPE_APPLY = 2;</code>
     */
    public static final int ISSUE_TYPE_APPLY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Issue originated during the convert process
     * </pre>
     *
     * <code>ISSUE_TYPE_CONVERT = 3;</code>
     */
    public static final int ISSUE_TYPE_CONVERT_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IssueType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IssueType forNumber(int value) {
      switch (value) {
        case 0:
          return ISSUE_TYPE_UNSPECIFIED;
        case 1:
          return ISSUE_TYPE_DDL;
        case 2:
          return ISSUE_TYPE_APPLY;
        case 3:
          return ISSUE_TYPE_CONVERT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IssueType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IssueType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<IssueType>() {
          public IssueType findValueByNumber(int number) {
            return IssueType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.EntityIssue.getDescriptor().getEnumTypes().get(0);
    }

    private static final IssueType[] VALUES = values();

    public static IssueType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IssueType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.clouddms.v1.EntityIssue.IssueType)
  }

  /**
   *
   *
   * <pre>
   * Severity of issue.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.clouddms.v1.EntityIssue.IssueSeverity}
   */
  public enum IssueSeverity implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified issue severity
     * </pre>
     *
     * <code>ISSUE_SEVERITY_UNSPECIFIED = 0;</code>
     */
    ISSUE_SEVERITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Info
     * </pre>
     *
     * <code>ISSUE_SEVERITY_INFO = 1;</code>
     */
    ISSUE_SEVERITY_INFO(1),
    /**
     *
     *
     * <pre>
     * Warning
     * </pre>
     *
     * <code>ISSUE_SEVERITY_WARNING = 2;</code>
     */
    ISSUE_SEVERITY_WARNING(2),
    /**
     *
     *
     * <pre>
     * Error
     * </pre>
     *
     * <code>ISSUE_SEVERITY_ERROR = 3;</code>
     */
    ISSUE_SEVERITY_ERROR(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified issue severity
     * </pre>
     *
     * <code>ISSUE_SEVERITY_UNSPECIFIED = 0;</code>
     */
    public static final int ISSUE_SEVERITY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Info
     * </pre>
     *
     * <code>ISSUE_SEVERITY_INFO = 1;</code>
     */
    public static final int ISSUE_SEVERITY_INFO_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Warning
     * </pre>
     *
     * <code>ISSUE_SEVERITY_WARNING = 2;</code>
     */
    public static final int ISSUE_SEVERITY_WARNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Error
     * </pre>
     *
     * <code>ISSUE_SEVERITY_ERROR = 3;</code>
     */
    public static final int ISSUE_SEVERITY_ERROR_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IssueSeverity valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IssueSeverity forNumber(int value) {
      switch (value) {
        case 0:
          return ISSUE_SEVERITY_UNSPECIFIED;
        case 1:
          return ISSUE_SEVERITY_INFO;
        case 2:
          return ISSUE_SEVERITY_WARNING;
        case 3:
          return ISSUE_SEVERITY_ERROR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IssueSeverity> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IssueSeverity> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<IssueSeverity>() {
          public IssueSeverity findValueByNumber(int number) {
            return IssueSeverity.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.EntityIssue.getDescriptor().getEnumTypes().get(1);
    }

    private static final IssueSeverity[] VALUES = values();

    public static IssueSeverity valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IssueSeverity(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.clouddms.v1.EntityIssue.IssueSeverity)
  }

  public interface PositionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.clouddms.v1.EntityIssue.Position)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Issue line number
     * </pre>
     *
     * <code>int32 line = 1;</code>
     *
     * @return The line.
     */
    int getLine();

    /**
     *
     *
     * <pre>
     * Issue column number
     * </pre>
     *
     * <code>int32 column = 2;</code>
     *
     * @return The column.
     */
    int getColumn();

    /**
     *
     *
     * <pre>
     * Issue offset
     * </pre>
     *
     * <code>int32 offset = 3;</code>
     *
     * @return The offset.
     */
    int getOffset();

    /**
     *
     *
     * <pre>
     * Issue length
     * </pre>
     *
     * <code>int32 length = 4;</code>
     *
     * @return The length.
     */
    int getLength();
  }
  /**
   *
   *
   * <pre>
   * Issue position.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.EntityIssue.Position}
   */
  public static final class Position extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.EntityIssue.Position)
      PositionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Position.newBuilder() to construct.
    private Position(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Position() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Position();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_EntityIssue_Position_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_EntityIssue_Position_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.EntityIssue.Position.class,
              com.google.cloud.clouddms.v1.EntityIssue.Position.Builder.class);
    }

    public static final int LINE_FIELD_NUMBER = 1;
    private int line_ = 0;
    /**
     *
     *
     * <pre>
     * Issue line number
     * </pre>
     *
     * <code>int32 line = 1;</code>
     *
     * @return The line.
     */
    @java.lang.Override
    public int getLine() {
      return line_;
    }

    public static final int COLUMN_FIELD_NUMBER = 2;
    private int column_ = 0;
    /**
     *
     *
     * <pre>
     * Issue column number
     * </pre>
     *
     * <code>int32 column = 2;</code>
     *
     * @return The column.
     */
    @java.lang.Override
    public int getColumn() {
      return column_;
    }

    public static final int OFFSET_FIELD_NUMBER = 3;
    private int offset_ = 0;
    /**
     *
     *
     * <pre>
     * Issue offset
     * </pre>
     *
     * <code>int32 offset = 3;</code>
     *
     * @return The offset.
     */
    @java.lang.Override
    public int getOffset() {
      return offset_;
    }

    public static final int LENGTH_FIELD_NUMBER = 4;
    private int length_ = 0;
    /**
     *
     *
     * <pre>
     * Issue length
     * </pre>
     *
     * <code>int32 length = 4;</code>
     *
     * @return The length.
     */
    @java.lang.Override
    public int getLength() {
      return length_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (line_ != 0) {
        output.writeInt32(1, line_);
      }
      if (column_ != 0) {
        output.writeInt32(2, column_);
      }
      if (offset_ != 0) {
        output.writeInt32(3, offset_);
      }
      if (length_ != 0) {
        output.writeInt32(4, length_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (line_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, line_);
      }
      if (column_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, column_);
      }
      if (offset_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, offset_);
      }
      if (length_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, length_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.clouddms.v1.EntityIssue.Position)) {
        return super.equals(obj);
      }
      com.google.cloud.clouddms.v1.EntityIssue.Position other =
          (com.google.cloud.clouddms.v1.EntityIssue.Position) obj;

      if (getLine() != other.getLine()) return false;
      if (getColumn() != other.getColumn()) return false;
      if (getOffset() != other.getOffset()) return false;
      if (getLength() != other.getLength()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LINE_FIELD_NUMBER;
      hash = (53 * hash) + getLine();
      hash = (37 * hash) + COLUMN_FIELD_NUMBER;
      hash = (53 * hash) + getColumn();
      hash = (37 * hash) + OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + getOffset();
      hash = (37 * hash) + LENGTH_FIELD_NUMBER;
      hash = (53 * hash) + getLength();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.clouddms.v1.EntityIssue.Position parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.EntityIssue.Position parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.EntityIssue.Position parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.EntityIssue.Position parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.EntityIssue.Position parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.EntityIssue.Position parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.EntityIssue.Position parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.EntityIssue.Position parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.EntityIssue.Position parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.EntityIssue.Position parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.EntityIssue.Position parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.EntityIssue.Position parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.clouddms.v1.EntityIssue.Position prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Issue position.
     * </pre>
     *
     * Protobuf type {@code google.cloud.clouddms.v1.EntityIssue.Position}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.EntityIssue.Position)
        com.google.cloud.clouddms.v1.EntityIssue.PositionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
            .internal_static_google_cloud_clouddms_v1_EntityIssue_Position_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
            .internal_static_google_cloud_clouddms_v1_EntityIssue_Position_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.clouddms.v1.EntityIssue.Position.class,
                com.google.cloud.clouddms.v1.EntityIssue.Position.Builder.class);
      }

      // Construct using com.google.cloud.clouddms.v1.EntityIssue.Position.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        line_ = 0;
        column_ = 0;
        offset_ = 0;
        length_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
            .internal_static_google_cloud_clouddms_v1_EntityIssue_Position_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.EntityIssue.Position getDefaultInstanceForType() {
        return com.google.cloud.clouddms.v1.EntityIssue.Position.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.EntityIssue.Position build() {
        com.google.cloud.clouddms.v1.EntityIssue.Position result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.EntityIssue.Position buildPartial() {
        com.google.cloud.clouddms.v1.EntityIssue.Position result =
            new com.google.cloud.clouddms.v1.EntityIssue.Position(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.clouddms.v1.EntityIssue.Position result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.line_ = line_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.column_ = column_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.offset_ = offset_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.length_ = length_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.clouddms.v1.EntityIssue.Position) {
          return mergeFrom((com.google.cloud.clouddms.v1.EntityIssue.Position) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.clouddms.v1.EntityIssue.Position other) {
        if (other == com.google.cloud.clouddms.v1.EntityIssue.Position.getDefaultInstance())
          return this;
        if (other.getLine() != 0) {
          setLine(other.getLine());
        }
        if (other.getColumn() != 0) {
          setColumn(other.getColumn());
        }
        if (other.getOffset() != 0) {
          setOffset(other.getOffset());
        }
        if (other.getLength() != 0) {
          setLength(other.getLength());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  line_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  column_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  offset_ = input.readInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 32:
                {
                  length_ = input.readInt32();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int line_;
      /**
       *
       *
       * <pre>
       * Issue line number
       * </pre>
       *
       * <code>int32 line = 1;</code>
       *
       * @return The line.
       */
      @java.lang.Override
      public int getLine() {
        return line_;
      }
      /**
       *
       *
       * <pre>
       * Issue line number
       * </pre>
       *
       * <code>int32 line = 1;</code>
       *
       * @param value The line to set.
       * @return This builder for chaining.
       */
      public Builder setLine(int value) {

        line_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Issue line number
       * </pre>
       *
       * <code>int32 line = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLine() {
        bitField0_ = (bitField0_ & ~0x00000001);
        line_ = 0;
        onChanged();
        return this;
      }

      private int column_;
      /**
       *
       *
       * <pre>
       * Issue column number
       * </pre>
       *
       * <code>int32 column = 2;</code>
       *
       * @return The column.
       */
      @java.lang.Override
      public int getColumn() {
        return column_;
      }
      /**
       *
       *
       * <pre>
       * Issue column number
       * </pre>
       *
       * <code>int32 column = 2;</code>
       *
       * @param value The column to set.
       * @return This builder for chaining.
       */
      public Builder setColumn(int value) {

        column_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Issue column number
       * </pre>
       *
       * <code>int32 column = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearColumn() {
        bitField0_ = (bitField0_ & ~0x00000002);
        column_ = 0;
        onChanged();
        return this;
      }

      private int offset_;
      /**
       *
       *
       * <pre>
       * Issue offset
       * </pre>
       *
       * <code>int32 offset = 3;</code>
       *
       * @return The offset.
       */
      @java.lang.Override
      public int getOffset() {
        return offset_;
      }
      /**
       *
       *
       * <pre>
       * Issue offset
       * </pre>
       *
       * <code>int32 offset = 3;</code>
       *
       * @param value The offset to set.
       * @return This builder for chaining.
       */
      public Builder setOffset(int value) {

        offset_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Issue offset
       * </pre>
       *
       * <code>int32 offset = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOffset() {
        bitField0_ = (bitField0_ & ~0x00000004);
        offset_ = 0;
        onChanged();
        return this;
      }

      private int length_;
      /**
       *
       *
       * <pre>
       * Issue length
       * </pre>
       *
       * <code>int32 length = 4;</code>
       *
       * @return The length.
       */
      @java.lang.Override
      public int getLength() {
        return length_;
      }
      /**
       *
       *
       * <pre>
       * Issue length
       * </pre>
       *
       * <code>int32 length = 4;</code>
       *
       * @param value The length to set.
       * @return This builder for chaining.
       */
      public Builder setLength(int value) {

        length_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Issue length
       * </pre>
       *
       * <code>int32 length = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLength() {
        bitField0_ = (bitField0_ & ~0x00000008);
        length_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.EntityIssue.Position)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.EntityIssue.Position)
    private static final com.google.cloud.clouddms.v1.EntityIssue.Position DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.EntityIssue.Position();
    }

    public static com.google.cloud.clouddms.v1.EntityIssue.Position getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Position> PARSER =
        new com.google.protobuf.AbstractParser<Position>() {
          @java.lang.Override
          public Position parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Position> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Position> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.EntityIssue.Position getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Unique Issue ID.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Unique Issue ID.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * The type of the issue.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.EntityIssue.IssueType type = 2;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * The type of the issue.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.EntityIssue.IssueType type = 2;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.EntityIssue.IssueType getType() {
    com.google.cloud.clouddms.v1.EntityIssue.IssueType result =
        com.google.cloud.clouddms.v1.EntityIssue.IssueType.forNumber(type_);
    return result == null
        ? com.google.cloud.clouddms.v1.EntityIssue.IssueType.UNRECOGNIZED
        : result;
  }

  public static final int SEVERITY_FIELD_NUMBER = 3;
  private int severity_ = 0;
  /**
   *
   *
   * <pre>
   * Severity of the issue
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.EntityIssue.IssueSeverity severity = 3;</code>
   *
   * @return The enum numeric value on the wire for severity.
   */
  @java.lang.Override
  public int getSeverityValue() {
    return severity_;
  }
  /**
   *
   *
   * <pre>
   * Severity of the issue
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.EntityIssue.IssueSeverity severity = 3;</code>
   *
   * @return The severity.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.EntityIssue.IssueSeverity getSeverity() {
    com.google.cloud.clouddms.v1.EntityIssue.IssueSeverity result =
        com.google.cloud.clouddms.v1.EntityIssue.IssueSeverity.forNumber(severity_);
    return result == null
        ? com.google.cloud.clouddms.v1.EntityIssue.IssueSeverity.UNRECOGNIZED
        : result;
  }

  public static final int MESSAGE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object message_ = "";
  /**
   *
   *
   * <pre>
   * Issue detailed message
   * </pre>
   *
   * <code>string message = 4;</code>
   *
   * @return The message.
   */
  @java.lang.Override
  public java.lang.String getMessage() {
    java.lang.Object ref = message_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      message_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Issue detailed message
   * </pre>
   *
   * <code>string message = 4;</code>
   *
   * @return The bytes for message.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMessageBytes() {
    java.lang.Object ref = message_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      message_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CODE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object code_ = "";
  /**
   *
   *
   * <pre>
   * Error/Warning code
   * </pre>
   *
   * <code>string code = 5;</code>
   *
   * @return The code.
   */
  @java.lang.Override
  public java.lang.String getCode() {
    java.lang.Object ref = code_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      code_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Error/Warning code
   * </pre>
   *
   * <code>string code = 5;</code>
   *
   * @return The bytes for code.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCodeBytes() {
    java.lang.Object ref = code_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      code_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DDL_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ddl_ = "";
  /**
   *
   *
   * <pre>
   * The ddl which caused the issue, if relevant.
   * </pre>
   *
   * <code>optional string ddl = 6;</code>
   *
   * @return Whether the ddl field is set.
   */
  @java.lang.Override
  public boolean hasDdl() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The ddl which caused the issue, if relevant.
   * </pre>
   *
   * <code>optional string ddl = 6;</code>
   *
   * @return The ddl.
   */
  @java.lang.Override
  public java.lang.String getDdl() {
    java.lang.Object ref = ddl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ddl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The ddl which caused the issue, if relevant.
   * </pre>
   *
   * <code>optional string ddl = 6;</code>
   *
   * @return The bytes for ddl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDdlBytes() {
    java.lang.Object ref = ddl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ddl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POSITION_FIELD_NUMBER = 7;
  private com.google.cloud.clouddms.v1.EntityIssue.Position position_;
  /**
   *
   *
   * <pre>
   * The position of the issue found, if relevant.
   * </pre>
   *
   * <code>optional .google.cloud.clouddms.v1.EntityIssue.Position position = 7;</code>
   *
   * @return Whether the position field is set.
   */
  @java.lang.Override
  public boolean hasPosition() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The position of the issue found, if relevant.
   * </pre>
   *
   * <code>optional .google.cloud.clouddms.v1.EntityIssue.Position position = 7;</code>
   *
   * @return The position.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.EntityIssue.Position getPosition() {
    return position_ == null
        ? com.google.cloud.clouddms.v1.EntityIssue.Position.getDefaultInstance()
        : position_;
  }
  /**
   *
   *
   * <pre>
   * The position of the issue found, if relevant.
   * </pre>
   *
   * <code>optional .google.cloud.clouddms.v1.EntityIssue.Position position = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.EntityIssue.PositionOrBuilder getPositionOrBuilder() {
    return position_ == null
        ? com.google.cloud.clouddms.v1.EntityIssue.Position.getDefaultInstance()
        : position_;
  }

  public static final int ENTITY_TYPE_FIELD_NUMBER = 8;
  private int entityType_ = 0;
  /**
   *
   *
   * <pre>
   * The entity type (if the DDL is for a sub entity).
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 8;</code>
   *
   * @return The enum numeric value on the wire for entityType.
   */
  @java.lang.Override
  public int getEntityTypeValue() {
    return entityType_;
  }
  /**
   *
   *
   * <pre>
   * The entity type (if the DDL is for a sub entity).
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 8;</code>
   *
   * @return The entityType.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DatabaseEntityType getEntityType() {
    com.google.cloud.clouddms.v1.DatabaseEntityType result =
        com.google.cloud.clouddms.v1.DatabaseEntityType.forNumber(entityType_);
    return result == null ? com.google.cloud.clouddms.v1.DatabaseEntityType.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (type_
        != com.google.cloud.clouddms.v1.EntityIssue.IssueType.ISSUE_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, type_);
    }
    if (severity_
        != com.google.cloud.clouddms.v1.EntityIssue.IssueSeverity.ISSUE_SEVERITY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, severity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, message_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(code_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, code_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, ddl_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getPosition());
    }
    if (entityType_
        != com.google.cloud.clouddms.v1.DatabaseEntityType.DATABASE_ENTITY_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, entityType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (type_
        != com.google.cloud.clouddms.v1.EntityIssue.IssueType.ISSUE_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
    }
    if (severity_
        != com.google.cloud.clouddms.v1.EntityIssue.IssueSeverity.ISSUE_SEVERITY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, severity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, message_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(code_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, code_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, ddl_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getPosition());
    }
    if (entityType_
        != com.google.cloud.clouddms.v1.DatabaseEntityType.DATABASE_ENTITY_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, entityType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.EntityIssue)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.EntityIssue other = (com.google.cloud.clouddms.v1.EntityIssue) obj;

    if (!getId().equals(other.getId())) return false;
    if (type_ != other.type_) return false;
    if (severity_ != other.severity_) return false;
    if (!getMessage().equals(other.getMessage())) return false;
    if (!getCode().equals(other.getCode())) return false;
    if (hasDdl() != other.hasDdl()) return false;
    if (hasDdl()) {
      if (!getDdl().equals(other.getDdl())) return false;
    }
    if (hasPosition() != other.hasPosition()) return false;
    if (hasPosition()) {
      if (!getPosition().equals(other.getPosition())) return false;
    }
    if (entityType_ != other.entityType_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + SEVERITY_FIELD_NUMBER;
    hash = (53 * hash) + severity_;
    hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getMessage().hashCode();
    hash = (37 * hash) + CODE_FIELD_NUMBER;
    hash = (53 * hash) + getCode().hashCode();
    if (hasDdl()) {
      hash = (37 * hash) + DDL_FIELD_NUMBER;
      hash = (53 * hash) + getDdl().hashCode();
    }
    if (hasPosition()) {
      hash = (37 * hash) + POSITION_FIELD_NUMBER;
      hash = (53 * hash) + getPosition().hashCode();
    }
    hash = (37 * hash) + ENTITY_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + entityType_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.EntityIssue parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.EntityIssue parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.EntityIssue parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.EntityIssue parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.EntityIssue parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.EntityIssue parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.EntityIssue parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.EntityIssue parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.EntityIssue parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.EntityIssue parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.EntityIssue parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.EntityIssue parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.EntityIssue prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Issue related to the entity.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.EntityIssue}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.EntityIssue)
      com.google.cloud.clouddms.v1.EntityIssueOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_EntityIssue_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_EntityIssue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.EntityIssue.class,
              com.google.cloud.clouddms.v1.EntityIssue.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.EntityIssue.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPositionFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      id_ = "";
      type_ = 0;
      severity_ = 0;
      message_ = "";
      code_ = "";
      ddl_ = "";
      position_ = null;
      if (positionBuilder_ != null) {
        positionBuilder_.dispose();
        positionBuilder_ = null;
      }
      entityType_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_EntityIssue_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.EntityIssue getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.EntityIssue.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.EntityIssue build() {
      com.google.cloud.clouddms.v1.EntityIssue result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.EntityIssue buildPartial() {
      com.google.cloud.clouddms.v1.EntityIssue result =
          new com.google.cloud.clouddms.v1.EntityIssue(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.EntityIssue result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.severity_ = severity_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.message_ = message_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.code_ = code_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.ddl_ = ddl_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.position_ = positionBuilder_ == null ? position_ : positionBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.entityType_ = entityType_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.EntityIssue) {
        return mergeFrom((com.google.cloud.clouddms.v1.EntityIssue) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.EntityIssue other) {
      if (other == com.google.cloud.clouddms.v1.EntityIssue.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.severity_ != 0) {
        setSeverityValue(other.getSeverityValue());
      }
      if (!other.getMessage().isEmpty()) {
        message_ = other.message_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getCode().isEmpty()) {
        code_ = other.code_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasDdl()) {
        ddl_ = other.ddl_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasPosition()) {
        mergePosition(other.getPosition());
      }
      if (other.entityType_ != 0) {
        setEntityTypeValue(other.getEntityTypeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                severity_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                message_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                code_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                ddl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getPositionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                entityType_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Unique Issue ID.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique Issue ID.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique Issue ID.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique Issue ID.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique Issue ID.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The type of the issue.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.EntityIssue.IssueType type = 2;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The type of the issue.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.EntityIssue.IssueType type = 2;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the issue.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.EntityIssue.IssueType type = 2;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.EntityIssue.IssueType getType() {
      com.google.cloud.clouddms.v1.EntityIssue.IssueType result =
          com.google.cloud.clouddms.v1.EntityIssue.IssueType.forNumber(type_);
      return result == null
          ? com.google.cloud.clouddms.v1.EntityIssue.IssueType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The type of the issue.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.EntityIssue.IssueType type = 2;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.clouddms.v1.EntityIssue.IssueType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the issue.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.EntityIssue.IssueType type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      type_ = 0;
      onChanged();
      return this;
    }

    private int severity_ = 0;
    /**
     *
     *
     * <pre>
     * Severity of the issue
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.EntityIssue.IssueSeverity severity = 3;</code>
     *
     * @return The enum numeric value on the wire for severity.
     */
    @java.lang.Override
    public int getSeverityValue() {
      return severity_;
    }
    /**
     *
     *
     * <pre>
     * Severity of the issue
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.EntityIssue.IssueSeverity severity = 3;</code>
     *
     * @param value The enum numeric value on the wire for severity to set.
     * @return This builder for chaining.
     */
    public Builder setSeverityValue(int value) {
      severity_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Severity of the issue
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.EntityIssue.IssueSeverity severity = 3;</code>
     *
     * @return The severity.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.EntityIssue.IssueSeverity getSeverity() {
      com.google.cloud.clouddms.v1.EntityIssue.IssueSeverity result =
          com.google.cloud.clouddms.v1.EntityIssue.IssueSeverity.forNumber(severity_);
      return result == null
          ? com.google.cloud.clouddms.v1.EntityIssue.IssueSeverity.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Severity of the issue
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.EntityIssue.IssueSeverity severity = 3;</code>
     *
     * @param value The severity to set.
     * @return This builder for chaining.
     */
    public Builder setSeverity(com.google.cloud.clouddms.v1.EntityIssue.IssueSeverity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      severity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Severity of the issue
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.EntityIssue.IssueSeverity severity = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSeverity() {
      bitField0_ = (bitField0_ & ~0x00000004);
      severity_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object message_ = "";
    /**
     *
     *
     * <pre>
     * Issue detailed message
     * </pre>
     *
     * <code>string message = 4;</code>
     *
     * @return The message.
     */
    public java.lang.String getMessage() {
      java.lang.Object ref = message_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        message_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Issue detailed message
     * </pre>
     *
     * <code>string message = 4;</code>
     *
     * @return The bytes for message.
     */
    public com.google.protobuf.ByteString getMessageBytes() {
      java.lang.Object ref = message_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        message_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Issue detailed message
     * </pre>
     *
     * <code>string message = 4;</code>
     *
     * @param value The message to set.
     * @return This builder for chaining.
     */
    public Builder setMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      message_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Issue detailed message
     * </pre>
     *
     * <code>string message = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMessage() {
      message_ = getDefaultInstance().getMessage();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Issue detailed message
     * </pre>
     *
     * <code>string message = 4;</code>
     *
     * @param value The bytes for message to set.
     * @return This builder for chaining.
     */
    public Builder setMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      message_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object code_ = "";
    /**
     *
     *
     * <pre>
     * Error/Warning code
     * </pre>
     *
     * <code>string code = 5;</code>
     *
     * @return The code.
     */
    public java.lang.String getCode() {
      java.lang.Object ref = code_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        code_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Error/Warning code
     * </pre>
     *
     * <code>string code = 5;</code>
     *
     * @return The bytes for code.
     */
    public com.google.protobuf.ByteString getCodeBytes() {
      java.lang.Object ref = code_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        code_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Error/Warning code
     * </pre>
     *
     * <code>string code = 5;</code>
     *
     * @param value The code to set.
     * @return This builder for chaining.
     */
    public Builder setCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      code_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Error/Warning code
     * </pre>
     *
     * <code>string code = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCode() {
      code_ = getDefaultInstance().getCode();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Error/Warning code
     * </pre>
     *
     * <code>string code = 5;</code>
     *
     * @param value The bytes for code to set.
     * @return This builder for chaining.
     */
    public Builder setCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      code_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object ddl_ = "";
    /**
     *
     *
     * <pre>
     * The ddl which caused the issue, if relevant.
     * </pre>
     *
     * <code>optional string ddl = 6;</code>
     *
     * @return Whether the ddl field is set.
     */
    public boolean hasDdl() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The ddl which caused the issue, if relevant.
     * </pre>
     *
     * <code>optional string ddl = 6;</code>
     *
     * @return The ddl.
     */
    public java.lang.String getDdl() {
      java.lang.Object ref = ddl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ddl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ddl which caused the issue, if relevant.
     * </pre>
     *
     * <code>optional string ddl = 6;</code>
     *
     * @return The bytes for ddl.
     */
    public com.google.protobuf.ByteString getDdlBytes() {
      java.lang.Object ref = ddl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ddl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ddl which caused the issue, if relevant.
     * </pre>
     *
     * <code>optional string ddl = 6;</code>
     *
     * @param value The ddl to set.
     * @return This builder for chaining.
     */
    public Builder setDdl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ddl_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ddl which caused the issue, if relevant.
     * </pre>
     *
     * <code>optional string ddl = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDdl() {
      ddl_ = getDefaultInstance().getDdl();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ddl which caused the issue, if relevant.
     * </pre>
     *
     * <code>optional string ddl = 6;</code>
     *
     * @param value The bytes for ddl to set.
     * @return This builder for chaining.
     */
    public Builder setDdlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ddl_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.clouddms.v1.EntityIssue.Position position_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.EntityIssue.Position,
            com.google.cloud.clouddms.v1.EntityIssue.Position.Builder,
            com.google.cloud.clouddms.v1.EntityIssue.PositionOrBuilder>
        positionBuilder_;
    /**
     *
     *
     * <pre>
     * The position of the issue found, if relevant.
     * </pre>
     *
     * <code>optional .google.cloud.clouddms.v1.EntityIssue.Position position = 7;</code>
     *
     * @return Whether the position field is set.
     */
    public boolean hasPosition() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The position of the issue found, if relevant.
     * </pre>
     *
     * <code>optional .google.cloud.clouddms.v1.EntityIssue.Position position = 7;</code>
     *
     * @return The position.
     */
    public com.google.cloud.clouddms.v1.EntityIssue.Position getPosition() {
      if (positionBuilder_ == null) {
        return position_ == null
            ? com.google.cloud.clouddms.v1.EntityIssue.Position.getDefaultInstance()
            : position_;
      } else {
        return positionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The position of the issue found, if relevant.
     * </pre>
     *
     * <code>optional .google.cloud.clouddms.v1.EntityIssue.Position position = 7;</code>
     */
    public Builder setPosition(com.google.cloud.clouddms.v1.EntityIssue.Position value) {
      if (positionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        position_ = value;
      } else {
        positionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The position of the issue found, if relevant.
     * </pre>
     *
     * <code>optional .google.cloud.clouddms.v1.EntityIssue.Position position = 7;</code>
     */
    public Builder setPosition(
        com.google.cloud.clouddms.v1.EntityIssue.Position.Builder builderForValue) {
      if (positionBuilder_ == null) {
        position_ = builderForValue.build();
      } else {
        positionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The position of the issue found, if relevant.
     * </pre>
     *
     * <code>optional .google.cloud.clouddms.v1.EntityIssue.Position position = 7;</code>
     */
    public Builder mergePosition(com.google.cloud.clouddms.v1.EntityIssue.Position value) {
      if (positionBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && position_ != null
            && position_
                != com.google.cloud.clouddms.v1.EntityIssue.Position.getDefaultInstance()) {
          getPositionBuilder().mergeFrom(value);
        } else {
          position_ = value;
        }
      } else {
        positionBuilder_.mergeFrom(value);
      }
      if (position_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The position of the issue found, if relevant.
     * </pre>
     *
     * <code>optional .google.cloud.clouddms.v1.EntityIssue.Position position = 7;</code>
     */
    public Builder clearPosition() {
      bitField0_ = (bitField0_ & ~0x00000040);
      position_ = null;
      if (positionBuilder_ != null) {
        positionBuilder_.dispose();
        positionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The position of the issue found, if relevant.
     * </pre>
     *
     * <code>optional .google.cloud.clouddms.v1.EntityIssue.Position position = 7;</code>
     */
    public com.google.cloud.clouddms.v1.EntityIssue.Position.Builder getPositionBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getPositionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The position of the issue found, if relevant.
     * </pre>
     *
     * <code>optional .google.cloud.clouddms.v1.EntityIssue.Position position = 7;</code>
     */
    public com.google.cloud.clouddms.v1.EntityIssue.PositionOrBuilder getPositionOrBuilder() {
      if (positionBuilder_ != null) {
        return positionBuilder_.getMessageOrBuilder();
      } else {
        return position_ == null
            ? com.google.cloud.clouddms.v1.EntityIssue.Position.getDefaultInstance()
            : position_;
      }
    }
    /**
     *
     *
     * <pre>
     * The position of the issue found, if relevant.
     * </pre>
     *
     * <code>optional .google.cloud.clouddms.v1.EntityIssue.Position position = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.EntityIssue.Position,
            com.google.cloud.clouddms.v1.EntityIssue.Position.Builder,
            com.google.cloud.clouddms.v1.EntityIssue.PositionOrBuilder>
        getPositionFieldBuilder() {
      if (positionBuilder_ == null) {
        positionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.EntityIssue.Position,
                com.google.cloud.clouddms.v1.EntityIssue.Position.Builder,
                com.google.cloud.clouddms.v1.EntityIssue.PositionOrBuilder>(
                getPosition(), getParentForChildren(), isClean());
        position_ = null;
      }
      return positionBuilder_;
    }

    private int entityType_ = 0;
    /**
     *
     *
     * <pre>
     * The entity type (if the DDL is for a sub entity).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 8;</code>
     *
     * @return The enum numeric value on the wire for entityType.
     */
    @java.lang.Override
    public int getEntityTypeValue() {
      return entityType_;
    }
    /**
     *
     *
     * <pre>
     * The entity type (if the DDL is for a sub entity).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 8;</code>
     *
     * @param value The enum numeric value on the wire for entityType to set.
     * @return This builder for chaining.
     */
    public Builder setEntityTypeValue(int value) {
      entityType_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity type (if the DDL is for a sub entity).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 8;</code>
     *
     * @return The entityType.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.DatabaseEntityType getEntityType() {
      com.google.cloud.clouddms.v1.DatabaseEntityType result =
          com.google.cloud.clouddms.v1.DatabaseEntityType.forNumber(entityType_);
      return result == null ? com.google.cloud.clouddms.v1.DatabaseEntityType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The entity type (if the DDL is for a sub entity).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 8;</code>
     *
     * @param value The entityType to set.
     * @return This builder for chaining.
     */
    public Builder setEntityType(com.google.cloud.clouddms.v1.DatabaseEntityType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      entityType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity type (if the DDL is for a sub entity).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType entity_type = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntityType() {
      bitField0_ = (bitField0_ & ~0x00000080);
      entityType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.EntityIssue)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.EntityIssue)
  private static final com.google.cloud.clouddms.v1.EntityIssue DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.EntityIssue();
  }

  public static com.google.cloud.clouddms.v1.EntityIssue getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EntityIssue> PARSER =
      new com.google.protobuf.AbstractParser<EntityIssue>() {
        @java.lang.Override
        public EntityIssue parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EntityIssue> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EntityIssue> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.EntityIssue getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
