/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Details of the mappings of a database entity.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.EntityMapping}
 */
public final class EntityMapping extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.EntityMapping)
    EntityMappingOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EntityMapping.newBuilder() to construct.
  private EntityMapping(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EntityMapping() {
    sourceEntity_ = "";
    draftEntity_ = "";
    sourceType_ = 0;
    draftType_ = 0;
    mappingLog_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EntityMapping();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_EntityMapping_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_EntityMapping_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.EntityMapping.class,
            com.google.cloud.clouddms.v1.EntityMapping.Builder.class);
  }

  public static final int SOURCE_ENTITY_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceEntity_ = "";
  /**
   *
   *
   * <pre>
   * Source entity full name.
   * The source entity can also be a column, index or constraint using the
   * same naming notation schema.table.column.
   * </pre>
   *
   * <code>string source_entity = 1;</code>
   *
   * @return The sourceEntity.
   */
  @java.lang.Override
  public java.lang.String getSourceEntity() {
    java.lang.Object ref = sourceEntity_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceEntity_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Source entity full name.
   * The source entity can also be a column, index or constraint using the
   * same naming notation schema.table.column.
   * </pre>
   *
   * <code>string source_entity = 1;</code>
   *
   * @return The bytes for sourceEntity.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceEntityBytes() {
    java.lang.Object ref = sourceEntity_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceEntity_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DRAFT_ENTITY_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object draftEntity_ = "";
  /**
   *
   *
   * <pre>
   * Target entity full name.
   * The draft entity can also include a column, index or constraint using the
   * same naming notation schema.table.column.
   * </pre>
   *
   * <code>string draft_entity = 2;</code>
   *
   * @return The draftEntity.
   */
  @java.lang.Override
  public java.lang.String getDraftEntity() {
    java.lang.Object ref = draftEntity_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      draftEntity_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Target entity full name.
   * The draft entity can also include a column, index or constraint using the
   * same naming notation schema.table.column.
   * </pre>
   *
   * <code>string draft_entity = 2;</code>
   *
   * @return The bytes for draftEntity.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDraftEntityBytes() {
    java.lang.Object ref = draftEntity_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      draftEntity_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_TYPE_FIELD_NUMBER = 4;
  private int sourceType_ = 0;
  /**
   *
   *
   * <pre>
   * Type of source entity.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseEntityType source_type = 4;</code>
   *
   * @return The enum numeric value on the wire for sourceType.
   */
  @java.lang.Override
  public int getSourceTypeValue() {
    return sourceType_;
  }
  /**
   *
   *
   * <pre>
   * Type of source entity.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseEntityType source_type = 4;</code>
   *
   * @return The sourceType.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DatabaseEntityType getSourceType() {
    com.google.cloud.clouddms.v1.DatabaseEntityType result =
        com.google.cloud.clouddms.v1.DatabaseEntityType.forNumber(sourceType_);
    return result == null ? com.google.cloud.clouddms.v1.DatabaseEntityType.UNRECOGNIZED : result;
  }

  public static final int DRAFT_TYPE_FIELD_NUMBER = 5;
  private int draftType_ = 0;
  /**
   *
   *
   * <pre>
   * Type of draft entity.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseEntityType draft_type = 5;</code>
   *
   * @return The enum numeric value on the wire for draftType.
   */
  @java.lang.Override
  public int getDraftTypeValue() {
    return draftType_;
  }
  /**
   *
   *
   * <pre>
   * Type of draft entity.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseEntityType draft_type = 5;</code>
   *
   * @return The draftType.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DatabaseEntityType getDraftType() {
    com.google.cloud.clouddms.v1.DatabaseEntityType result =
        com.google.cloud.clouddms.v1.DatabaseEntityType.forNumber(draftType_);
    return result == null ? com.google.cloud.clouddms.v1.DatabaseEntityType.UNRECOGNIZED : result;
  }

  public static final int MAPPING_LOG_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.clouddms.v1.EntityMappingLogEntry> mappingLog_;
  /**
   *
   *
   * <pre>
   * Entity mapping log entries.
   * Multiple rules can be effective and contribute changes to a converted
   * entity, such as a rule can handle the entity name, another rule can handle
   * an entity type. In addition, rules which did not change the entity are also
   * logged along with the reason preventing them to do so.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.clouddms.v1.EntityMappingLogEntry> getMappingLogList() {
    return mappingLog_;
  }
  /**
   *
   *
   * <pre>
   * Entity mapping log entries.
   * Multiple rules can be effective and contribute changes to a converted
   * entity, such as a rule can handle the entity name, another rule can handle
   * an entity type. In addition, rules which did not change the entity are also
   * logged along with the reason preventing them to do so.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.clouddms.v1.EntityMappingLogEntryOrBuilder>
      getMappingLogOrBuilderList() {
    return mappingLog_;
  }
  /**
   *
   *
   * <pre>
   * Entity mapping log entries.
   * Multiple rules can be effective and contribute changes to a converted
   * entity, such as a rule can handle the entity name, another rule can handle
   * an entity type. In addition, rules which did not change the entity are also
   * logged along with the reason preventing them to do so.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
   */
  @java.lang.Override
  public int getMappingLogCount() {
    return mappingLog_.size();
  }
  /**
   *
   *
   * <pre>
   * Entity mapping log entries.
   * Multiple rules can be effective and contribute changes to a converted
   * entity, such as a rule can handle the entity name, another rule can handle
   * an entity type. In addition, rules which did not change the entity are also
   * logged along with the reason preventing them to do so.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.EntityMappingLogEntry getMappingLog(int index) {
    return mappingLog_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Entity mapping log entries.
   * Multiple rules can be effective and contribute changes to a converted
   * entity, such as a rule can handle the entity name, another rule can handle
   * an entity type. In addition, rules which did not change the entity are also
   * logged along with the reason preventing them to do so.
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.EntityMappingLogEntryOrBuilder getMappingLogOrBuilder(
      int index) {
    return mappingLog_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceEntity_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, sourceEntity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(draftEntity_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, draftEntity_);
    }
    for (int i = 0; i < mappingLog_.size(); i++) {
      output.writeMessage(3, mappingLog_.get(i));
    }
    if (sourceType_
        != com.google.cloud.clouddms.v1.DatabaseEntityType.DATABASE_ENTITY_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, sourceType_);
    }
    if (draftType_
        != com.google.cloud.clouddms.v1.DatabaseEntityType.DATABASE_ENTITY_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, draftType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceEntity_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, sourceEntity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(draftEntity_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, draftEntity_);
    }
    for (int i = 0; i < mappingLog_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, mappingLog_.get(i));
    }
    if (sourceType_
        != com.google.cloud.clouddms.v1.DatabaseEntityType.DATABASE_ENTITY_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, sourceType_);
    }
    if (draftType_
        != com.google.cloud.clouddms.v1.DatabaseEntityType.DATABASE_ENTITY_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, draftType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.EntityMapping)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.EntityMapping other =
        (com.google.cloud.clouddms.v1.EntityMapping) obj;

    if (!getSourceEntity().equals(other.getSourceEntity())) return false;
    if (!getDraftEntity().equals(other.getDraftEntity())) return false;
    if (sourceType_ != other.sourceType_) return false;
    if (draftType_ != other.draftType_) return false;
    if (!getMappingLogList().equals(other.getMappingLogList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SOURCE_ENTITY_FIELD_NUMBER;
    hash = (53 * hash) + getSourceEntity().hashCode();
    hash = (37 * hash) + DRAFT_ENTITY_FIELD_NUMBER;
    hash = (53 * hash) + getDraftEntity().hashCode();
    hash = (37 * hash) + SOURCE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + sourceType_;
    hash = (37 * hash) + DRAFT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + draftType_;
    if (getMappingLogCount() > 0) {
      hash = (37 * hash) + MAPPING_LOG_FIELD_NUMBER;
      hash = (53 * hash) + getMappingLogList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.EntityMapping parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.EntityMapping parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.EntityMapping parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.EntityMapping parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.EntityMapping parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.EntityMapping parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.EntityMapping parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.EntityMapping parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.EntityMapping parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.EntityMapping parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.EntityMapping parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.EntityMapping parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.EntityMapping prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details of the mappings of a database entity.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.EntityMapping}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.EntityMapping)
      com.google.cloud.clouddms.v1.EntityMappingOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_EntityMapping_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_EntityMapping_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.EntityMapping.class,
              com.google.cloud.clouddms.v1.EntityMapping.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.EntityMapping.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      sourceEntity_ = "";
      draftEntity_ = "";
      sourceType_ = 0;
      draftType_ = 0;
      if (mappingLogBuilder_ == null) {
        mappingLog_ = java.util.Collections.emptyList();
      } else {
        mappingLog_ = null;
        mappingLogBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_EntityMapping_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.EntityMapping getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.EntityMapping.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.EntityMapping build() {
      com.google.cloud.clouddms.v1.EntityMapping result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.EntityMapping buildPartial() {
      com.google.cloud.clouddms.v1.EntityMapping result =
          new com.google.cloud.clouddms.v1.EntityMapping(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.clouddms.v1.EntityMapping result) {
      if (mappingLogBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          mappingLog_ = java.util.Collections.unmodifiableList(mappingLog_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.mappingLog_ = mappingLog_;
      } else {
        result.mappingLog_ = mappingLogBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.EntityMapping result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.sourceEntity_ = sourceEntity_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.draftEntity_ = draftEntity_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.sourceType_ = sourceType_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.draftType_ = draftType_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.EntityMapping) {
        return mergeFrom((com.google.cloud.clouddms.v1.EntityMapping) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.EntityMapping other) {
      if (other == com.google.cloud.clouddms.v1.EntityMapping.getDefaultInstance()) return this;
      if (!other.getSourceEntity().isEmpty()) {
        sourceEntity_ = other.sourceEntity_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDraftEntity().isEmpty()) {
        draftEntity_ = other.draftEntity_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.sourceType_ != 0) {
        setSourceTypeValue(other.getSourceTypeValue());
      }
      if (other.draftType_ != 0) {
        setDraftTypeValue(other.getDraftTypeValue());
      }
      if (mappingLogBuilder_ == null) {
        if (!other.mappingLog_.isEmpty()) {
          if (mappingLog_.isEmpty()) {
            mappingLog_ = other.mappingLog_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureMappingLogIsMutable();
            mappingLog_.addAll(other.mappingLog_);
          }
          onChanged();
        }
      } else {
        if (!other.mappingLog_.isEmpty()) {
          if (mappingLogBuilder_.isEmpty()) {
            mappingLogBuilder_.dispose();
            mappingLogBuilder_ = null;
            mappingLog_ = other.mappingLog_;
            bitField0_ = (bitField0_ & ~0x00000010);
            mappingLogBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMappingLogFieldBuilder()
                    : null;
          } else {
            mappingLogBuilder_.addAllMessages(other.mappingLog_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                sourceEntity_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                draftEntity_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.clouddms.v1.EntityMappingLogEntry m =
                    input.readMessage(
                        com.google.cloud.clouddms.v1.EntityMappingLogEntry.parser(),
                        extensionRegistry);
                if (mappingLogBuilder_ == null) {
                  ensureMappingLogIsMutable();
                  mappingLog_.add(m);
                } else {
                  mappingLogBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 32:
              {
                sourceType_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            case 40:
              {
                draftType_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object sourceEntity_ = "";
    /**
     *
     *
     * <pre>
     * Source entity full name.
     * The source entity can also be a column, index or constraint using the
     * same naming notation schema.table.column.
     * </pre>
     *
     * <code>string source_entity = 1;</code>
     *
     * @return The sourceEntity.
     */
    public java.lang.String getSourceEntity() {
      java.lang.Object ref = sourceEntity_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceEntity_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Source entity full name.
     * The source entity can also be a column, index or constraint using the
     * same naming notation schema.table.column.
     * </pre>
     *
     * <code>string source_entity = 1;</code>
     *
     * @return The bytes for sourceEntity.
     */
    public com.google.protobuf.ByteString getSourceEntityBytes() {
      java.lang.Object ref = sourceEntity_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceEntity_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Source entity full name.
     * The source entity can also be a column, index or constraint using the
     * same naming notation schema.table.column.
     * </pre>
     *
     * <code>string source_entity = 1;</code>
     *
     * @param value The sourceEntity to set.
     * @return This builder for chaining.
     */
    public Builder setSourceEntity(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceEntity_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source entity full name.
     * The source entity can also be a column, index or constraint using the
     * same naming notation schema.table.column.
     * </pre>
     *
     * <code>string source_entity = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceEntity() {
      sourceEntity_ = getDefaultInstance().getSourceEntity();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source entity full name.
     * The source entity can also be a column, index or constraint using the
     * same naming notation schema.table.column.
     * </pre>
     *
     * <code>string source_entity = 1;</code>
     *
     * @param value The bytes for sourceEntity to set.
     * @return This builder for chaining.
     */
    public Builder setSourceEntityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceEntity_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object draftEntity_ = "";
    /**
     *
     *
     * <pre>
     * Target entity full name.
     * The draft entity can also include a column, index or constraint using the
     * same naming notation schema.table.column.
     * </pre>
     *
     * <code>string draft_entity = 2;</code>
     *
     * @return The draftEntity.
     */
    public java.lang.String getDraftEntity() {
      java.lang.Object ref = draftEntity_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        draftEntity_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Target entity full name.
     * The draft entity can also include a column, index or constraint using the
     * same naming notation schema.table.column.
     * </pre>
     *
     * <code>string draft_entity = 2;</code>
     *
     * @return The bytes for draftEntity.
     */
    public com.google.protobuf.ByteString getDraftEntityBytes() {
      java.lang.Object ref = draftEntity_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        draftEntity_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Target entity full name.
     * The draft entity can also include a column, index or constraint using the
     * same naming notation schema.table.column.
     * </pre>
     *
     * <code>string draft_entity = 2;</code>
     *
     * @param value The draftEntity to set.
     * @return This builder for chaining.
     */
    public Builder setDraftEntity(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      draftEntity_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target entity full name.
     * The draft entity can also include a column, index or constraint using the
     * same naming notation schema.table.column.
     * </pre>
     *
     * <code>string draft_entity = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDraftEntity() {
      draftEntity_ = getDefaultInstance().getDraftEntity();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target entity full name.
     * The draft entity can also include a column, index or constraint using the
     * same naming notation schema.table.column.
     * </pre>
     *
     * <code>string draft_entity = 2;</code>
     *
     * @param value The bytes for draftEntity to set.
     * @return This builder for chaining.
     */
    public Builder setDraftEntityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      draftEntity_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int sourceType_ = 0;
    /**
     *
     *
     * <pre>
     * Type of source entity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType source_type = 4;</code>
     *
     * @return The enum numeric value on the wire for sourceType.
     */
    @java.lang.Override
    public int getSourceTypeValue() {
      return sourceType_;
    }
    /**
     *
     *
     * <pre>
     * Type of source entity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType source_type = 4;</code>
     *
     * @param value The enum numeric value on the wire for sourceType to set.
     * @return This builder for chaining.
     */
    public Builder setSourceTypeValue(int value) {
      sourceType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of source entity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType source_type = 4;</code>
     *
     * @return The sourceType.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.DatabaseEntityType getSourceType() {
      com.google.cloud.clouddms.v1.DatabaseEntityType result =
          com.google.cloud.clouddms.v1.DatabaseEntityType.forNumber(sourceType_);
      return result == null ? com.google.cloud.clouddms.v1.DatabaseEntityType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Type of source entity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType source_type = 4;</code>
     *
     * @param value The sourceType to set.
     * @return This builder for chaining.
     */
    public Builder setSourceType(com.google.cloud.clouddms.v1.DatabaseEntityType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      sourceType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of source entity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType source_type = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      sourceType_ = 0;
      onChanged();
      return this;
    }

    private int draftType_ = 0;
    /**
     *
     *
     * <pre>
     * Type of draft entity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType draft_type = 5;</code>
     *
     * @return The enum numeric value on the wire for draftType.
     */
    @java.lang.Override
    public int getDraftTypeValue() {
      return draftType_;
    }
    /**
     *
     *
     * <pre>
     * Type of draft entity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType draft_type = 5;</code>
     *
     * @param value The enum numeric value on the wire for draftType to set.
     * @return This builder for chaining.
     */
    public Builder setDraftTypeValue(int value) {
      draftType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of draft entity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType draft_type = 5;</code>
     *
     * @return The draftType.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.DatabaseEntityType getDraftType() {
      com.google.cloud.clouddms.v1.DatabaseEntityType result =
          com.google.cloud.clouddms.v1.DatabaseEntityType.forNumber(draftType_);
      return result == null ? com.google.cloud.clouddms.v1.DatabaseEntityType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Type of draft entity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType draft_type = 5;</code>
     *
     * @param value The draftType to set.
     * @return This builder for chaining.
     */
    public Builder setDraftType(com.google.cloud.clouddms.v1.DatabaseEntityType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      draftType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of draft entity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseEntityType draft_type = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDraftType() {
      bitField0_ = (bitField0_ & ~0x00000008);
      draftType_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.clouddms.v1.EntityMappingLogEntry> mappingLog_ =
        java.util.Collections.emptyList();

    private void ensureMappingLogIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        mappingLog_ =
            new java.util.ArrayList<com.google.cloud.clouddms.v1.EntityMappingLogEntry>(
                mappingLog_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.clouddms.v1.EntityMappingLogEntry,
            com.google.cloud.clouddms.v1.EntityMappingLogEntry.Builder,
            com.google.cloud.clouddms.v1.EntityMappingLogEntryOrBuilder>
        mappingLogBuilder_;

    /**
     *
     *
     * <pre>
     * Entity mapping log entries.
     * Multiple rules can be effective and contribute changes to a converted
     * entity, such as a rule can handle the entity name, another rule can handle
     * an entity type. In addition, rules which did not change the entity are also
     * logged along with the reason preventing them to do so.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
     */
    public java.util.List<com.google.cloud.clouddms.v1.EntityMappingLogEntry> getMappingLogList() {
      if (mappingLogBuilder_ == null) {
        return java.util.Collections.unmodifiableList(mappingLog_);
      } else {
        return mappingLogBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Entity mapping log entries.
     * Multiple rules can be effective and contribute changes to a converted
     * entity, such as a rule can handle the entity name, another rule can handle
     * an entity type. In addition, rules which did not change the entity are also
     * logged along with the reason preventing them to do so.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
     */
    public int getMappingLogCount() {
      if (mappingLogBuilder_ == null) {
        return mappingLog_.size();
      } else {
        return mappingLogBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Entity mapping log entries.
     * Multiple rules can be effective and contribute changes to a converted
     * entity, such as a rule can handle the entity name, another rule can handle
     * an entity type. In addition, rules which did not change the entity are also
     * logged along with the reason preventing them to do so.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
     */
    public com.google.cloud.clouddms.v1.EntityMappingLogEntry getMappingLog(int index) {
      if (mappingLogBuilder_ == null) {
        return mappingLog_.get(index);
      } else {
        return mappingLogBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Entity mapping log entries.
     * Multiple rules can be effective and contribute changes to a converted
     * entity, such as a rule can handle the entity name, another rule can handle
     * an entity type. In addition, rules which did not change the entity are also
     * logged along with the reason preventing them to do so.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
     */
    public Builder setMappingLog(
        int index, com.google.cloud.clouddms.v1.EntityMappingLogEntry value) {
      if (mappingLogBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMappingLogIsMutable();
        mappingLog_.set(index, value);
        onChanged();
      } else {
        mappingLogBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity mapping log entries.
     * Multiple rules can be effective and contribute changes to a converted
     * entity, such as a rule can handle the entity name, another rule can handle
     * an entity type. In addition, rules which did not change the entity are also
     * logged along with the reason preventing them to do so.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
     */
    public Builder setMappingLog(
        int index, com.google.cloud.clouddms.v1.EntityMappingLogEntry.Builder builderForValue) {
      if (mappingLogBuilder_ == null) {
        ensureMappingLogIsMutable();
        mappingLog_.set(index, builderForValue.build());
        onChanged();
      } else {
        mappingLogBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity mapping log entries.
     * Multiple rules can be effective and contribute changes to a converted
     * entity, such as a rule can handle the entity name, another rule can handle
     * an entity type. In addition, rules which did not change the entity are also
     * logged along with the reason preventing them to do so.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
     */
    public Builder addMappingLog(com.google.cloud.clouddms.v1.EntityMappingLogEntry value) {
      if (mappingLogBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMappingLogIsMutable();
        mappingLog_.add(value);
        onChanged();
      } else {
        mappingLogBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity mapping log entries.
     * Multiple rules can be effective and contribute changes to a converted
     * entity, such as a rule can handle the entity name, another rule can handle
     * an entity type. In addition, rules which did not change the entity are also
     * logged along with the reason preventing them to do so.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
     */
    public Builder addMappingLog(
        int index, com.google.cloud.clouddms.v1.EntityMappingLogEntry value) {
      if (mappingLogBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMappingLogIsMutable();
        mappingLog_.add(index, value);
        onChanged();
      } else {
        mappingLogBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity mapping log entries.
     * Multiple rules can be effective and contribute changes to a converted
     * entity, such as a rule can handle the entity name, another rule can handle
     * an entity type. In addition, rules which did not change the entity are also
     * logged along with the reason preventing them to do so.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
     */
    public Builder addMappingLog(
        com.google.cloud.clouddms.v1.EntityMappingLogEntry.Builder builderForValue) {
      if (mappingLogBuilder_ == null) {
        ensureMappingLogIsMutable();
        mappingLog_.add(builderForValue.build());
        onChanged();
      } else {
        mappingLogBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity mapping log entries.
     * Multiple rules can be effective and contribute changes to a converted
     * entity, such as a rule can handle the entity name, another rule can handle
     * an entity type. In addition, rules which did not change the entity are also
     * logged along with the reason preventing them to do so.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
     */
    public Builder addMappingLog(
        int index, com.google.cloud.clouddms.v1.EntityMappingLogEntry.Builder builderForValue) {
      if (mappingLogBuilder_ == null) {
        ensureMappingLogIsMutable();
        mappingLog_.add(index, builderForValue.build());
        onChanged();
      } else {
        mappingLogBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity mapping log entries.
     * Multiple rules can be effective and contribute changes to a converted
     * entity, such as a rule can handle the entity name, another rule can handle
     * an entity type. In addition, rules which did not change the entity are also
     * logged along with the reason preventing them to do so.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
     */
    public Builder addAllMappingLog(
        java.lang.Iterable<? extends com.google.cloud.clouddms.v1.EntityMappingLogEntry> values) {
      if (mappingLogBuilder_ == null) {
        ensureMappingLogIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, mappingLog_);
        onChanged();
      } else {
        mappingLogBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity mapping log entries.
     * Multiple rules can be effective and contribute changes to a converted
     * entity, such as a rule can handle the entity name, another rule can handle
     * an entity type. In addition, rules which did not change the entity are also
     * logged along with the reason preventing them to do so.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
     */
    public Builder clearMappingLog() {
      if (mappingLogBuilder_ == null) {
        mappingLog_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        mappingLogBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity mapping log entries.
     * Multiple rules can be effective and contribute changes to a converted
     * entity, such as a rule can handle the entity name, another rule can handle
     * an entity type. In addition, rules which did not change the entity are also
     * logged along with the reason preventing them to do so.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
     */
    public Builder removeMappingLog(int index) {
      if (mappingLogBuilder_ == null) {
        ensureMappingLogIsMutable();
        mappingLog_.remove(index);
        onChanged();
      } else {
        mappingLogBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity mapping log entries.
     * Multiple rules can be effective and contribute changes to a converted
     * entity, such as a rule can handle the entity name, another rule can handle
     * an entity type. In addition, rules which did not change the entity are also
     * logged along with the reason preventing them to do so.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
     */
    public com.google.cloud.clouddms.v1.EntityMappingLogEntry.Builder getMappingLogBuilder(
        int index) {
      return getMappingLogFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Entity mapping log entries.
     * Multiple rules can be effective and contribute changes to a converted
     * entity, such as a rule can handle the entity name, another rule can handle
     * an entity type. In addition, rules which did not change the entity are also
     * logged along with the reason preventing them to do so.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
     */
    public com.google.cloud.clouddms.v1.EntityMappingLogEntryOrBuilder getMappingLogOrBuilder(
        int index) {
      if (mappingLogBuilder_ == null) {
        return mappingLog_.get(index);
      } else {
        return mappingLogBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Entity mapping log entries.
     * Multiple rules can be effective and contribute changes to a converted
     * entity, such as a rule can handle the entity name, another rule can handle
     * an entity type. In addition, rules which did not change the entity are also
     * logged along with the reason preventing them to do so.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.clouddms.v1.EntityMappingLogEntryOrBuilder>
        getMappingLogOrBuilderList() {
      if (mappingLogBuilder_ != null) {
        return mappingLogBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(mappingLog_);
      }
    }
    /**
     *
     *
     * <pre>
     * Entity mapping log entries.
     * Multiple rules can be effective and contribute changes to a converted
     * entity, such as a rule can handle the entity name, another rule can handle
     * an entity type. In addition, rules which did not change the entity are also
     * logged along with the reason preventing them to do so.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
     */
    public com.google.cloud.clouddms.v1.EntityMappingLogEntry.Builder addMappingLogBuilder() {
      return getMappingLogFieldBuilder()
          .addBuilder(com.google.cloud.clouddms.v1.EntityMappingLogEntry.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Entity mapping log entries.
     * Multiple rules can be effective and contribute changes to a converted
     * entity, such as a rule can handle the entity name, another rule can handle
     * an entity type. In addition, rules which did not change the entity are also
     * logged along with the reason preventing them to do so.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
     */
    public com.google.cloud.clouddms.v1.EntityMappingLogEntry.Builder addMappingLogBuilder(
        int index) {
      return getMappingLogFieldBuilder()
          .addBuilder(
              index, com.google.cloud.clouddms.v1.EntityMappingLogEntry.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Entity mapping log entries.
     * Multiple rules can be effective and contribute changes to a converted
     * entity, such as a rule can handle the entity name, another rule can handle
     * an entity type. In addition, rules which did not change the entity are also
     * logged along with the reason preventing them to do so.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.EntityMappingLogEntry mapping_log = 3;</code>
     */
    public java.util.List<com.google.cloud.clouddms.v1.EntityMappingLogEntry.Builder>
        getMappingLogBuilderList() {
      return getMappingLogFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.clouddms.v1.EntityMappingLogEntry,
            com.google.cloud.clouddms.v1.EntityMappingLogEntry.Builder,
            com.google.cloud.clouddms.v1.EntityMappingLogEntryOrBuilder>
        getMappingLogFieldBuilder() {
      if (mappingLogBuilder_ == null) {
        mappingLogBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.clouddms.v1.EntityMappingLogEntry,
                com.google.cloud.clouddms.v1.EntityMappingLogEntry.Builder,
                com.google.cloud.clouddms.v1.EntityMappingLogEntryOrBuilder>(
                mappingLog_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        mappingLog_ = null;
      }
      return mappingLogBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.EntityMapping)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.EntityMapping)
  private static final com.google.cloud.clouddms.v1.EntityMapping DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.EntityMapping();
  }

  public static com.google.cloud.clouddms.v1.EntityMapping getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EntityMapping> PARSER =
      new com.google.protobuf.AbstractParser<EntityMapping>() {
        @java.lang.Override
        public EntityMapping parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EntityMapping> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EntityMapping> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.EntityMapping getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
