/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Options to configure rule type FilterTableColumns.
 * The rule is used to filter the list of columns to include or exclude from a
 * table.
 *
 * The rule filter field can refer to one entity.
 *
 * The rule scope can be: Table
 *
 * Only one of the two lists can be specified for the rule.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.FilterTableColumns}
 */
public final class FilterTableColumns extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.FilterTableColumns)
    FilterTableColumnsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FilterTableColumns.newBuilder() to construct.
  private FilterTableColumns(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FilterTableColumns() {
    includeColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
    excludeColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FilterTableColumns();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_FilterTableColumns_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_FilterTableColumns_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.FilterTableColumns.class,
            com.google.cloud.clouddms.v1.FilterTableColumns.Builder.class);
  }

  public static final int INCLUDE_COLUMNS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList includeColumns_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. List of columns to be included for a particular table.
   * </pre>
   *
   * <code>repeated string include_columns = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the includeColumns.
   */
  public com.google.protobuf.ProtocolStringList getIncludeColumnsList() {
    return includeColumns_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of columns to be included for a particular table.
   * </pre>
   *
   * <code>repeated string include_columns = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of includeColumns.
   */
  public int getIncludeColumnsCount() {
    return includeColumns_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. List of columns to be included for a particular table.
   * </pre>
   *
   * <code>repeated string include_columns = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The includeColumns at the given index.
   */
  public java.lang.String getIncludeColumns(int index) {
    return includeColumns_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. List of columns to be included for a particular table.
   * </pre>
   *
   * <code>repeated string include_columns = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the includeColumns at the given index.
   */
  public com.google.protobuf.ByteString getIncludeColumnsBytes(int index) {
    return includeColumns_.getByteString(index);
  }

  public static final int EXCLUDE_COLUMNS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList excludeColumns_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. List of columns to be excluded for a particular table.
   * </pre>
   *
   * <code>repeated string exclude_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the excludeColumns.
   */
  public com.google.protobuf.ProtocolStringList getExcludeColumnsList() {
    return excludeColumns_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of columns to be excluded for a particular table.
   * </pre>
   *
   * <code>repeated string exclude_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of excludeColumns.
   */
  public int getExcludeColumnsCount() {
    return excludeColumns_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. List of columns to be excluded for a particular table.
   * </pre>
   *
   * <code>repeated string exclude_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The excludeColumns at the given index.
   */
  public java.lang.String getExcludeColumns(int index) {
    return excludeColumns_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. List of columns to be excluded for a particular table.
   * </pre>
   *
   * <code>repeated string exclude_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the excludeColumns at the given index.
   */
  public com.google.protobuf.ByteString getExcludeColumnsBytes(int index) {
    return excludeColumns_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < includeColumns_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, includeColumns_.getRaw(i));
    }
    for (int i = 0; i < excludeColumns_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, excludeColumns_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < includeColumns_.size(); i++) {
        dataSize += computeStringSizeNoTag(includeColumns_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getIncludeColumnsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < excludeColumns_.size(); i++) {
        dataSize += computeStringSizeNoTag(excludeColumns_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getExcludeColumnsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.FilterTableColumns)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.FilterTableColumns other =
        (com.google.cloud.clouddms.v1.FilterTableColumns) obj;

    if (!getIncludeColumnsList().equals(other.getIncludeColumnsList())) return false;
    if (!getExcludeColumnsList().equals(other.getExcludeColumnsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getIncludeColumnsCount() > 0) {
      hash = (37 * hash) + INCLUDE_COLUMNS_FIELD_NUMBER;
      hash = (53 * hash) + getIncludeColumnsList().hashCode();
    }
    if (getExcludeColumnsCount() > 0) {
      hash = (37 * hash) + EXCLUDE_COLUMNS_FIELD_NUMBER;
      hash = (53 * hash) + getExcludeColumnsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.FilterTableColumns parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.FilterTableColumns parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.FilterTableColumns parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.FilterTableColumns parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.FilterTableColumns parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.FilterTableColumns parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.FilterTableColumns parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.FilterTableColumns parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.FilterTableColumns parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.FilterTableColumns parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.FilterTableColumns parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.FilterTableColumns parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.FilterTableColumns prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Options to configure rule type FilterTableColumns.
   * The rule is used to filter the list of columns to include or exclude from a
   * table.
   *
   * The rule filter field can refer to one entity.
   *
   * The rule scope can be: Table
   *
   * Only one of the two lists can be specified for the rule.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.FilterTableColumns}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.FilterTableColumns)
      com.google.cloud.clouddms.v1.FilterTableColumnsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_FilterTableColumns_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_FilterTableColumns_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.FilterTableColumns.class,
              com.google.cloud.clouddms.v1.FilterTableColumns.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.FilterTableColumns.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      includeColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
      excludeColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_FilterTableColumns_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.FilterTableColumns getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.FilterTableColumns.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.FilterTableColumns build() {
      com.google.cloud.clouddms.v1.FilterTableColumns result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.FilterTableColumns buildPartial() {
      com.google.cloud.clouddms.v1.FilterTableColumns result =
          new com.google.cloud.clouddms.v1.FilterTableColumns(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.FilterTableColumns result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        includeColumns_.makeImmutable();
        result.includeColumns_ = includeColumns_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        excludeColumns_.makeImmutable();
        result.excludeColumns_ = excludeColumns_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.FilterTableColumns) {
        return mergeFrom((com.google.cloud.clouddms.v1.FilterTableColumns) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.FilterTableColumns other) {
      if (other == com.google.cloud.clouddms.v1.FilterTableColumns.getDefaultInstance())
        return this;
      if (!other.includeColumns_.isEmpty()) {
        if (includeColumns_.isEmpty()) {
          includeColumns_ = other.includeColumns_;
          bitField0_ |= 0x00000001;
        } else {
          ensureIncludeColumnsIsMutable();
          includeColumns_.addAll(other.includeColumns_);
        }
        onChanged();
      }
      if (!other.excludeColumns_.isEmpty()) {
        if (excludeColumns_.isEmpty()) {
          excludeColumns_ = other.excludeColumns_;
          bitField0_ |= 0x00000002;
        } else {
          ensureExcludeColumnsIsMutable();
          excludeColumns_.addAll(other.excludeColumns_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIncludeColumnsIsMutable();
                includeColumns_.add(s);
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureExcludeColumnsIsMutable();
                excludeColumns_.add(s);
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList includeColumns_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureIncludeColumnsIsMutable() {
      if (!includeColumns_.isModifiable()) {
        includeColumns_ = new com.google.protobuf.LazyStringArrayList(includeColumns_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns to be included for a particular table.
     * </pre>
     *
     * <code>repeated string include_columns = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the includeColumns.
     */
    public com.google.protobuf.ProtocolStringList getIncludeColumnsList() {
      includeColumns_.makeImmutable();
      return includeColumns_;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns to be included for a particular table.
     * </pre>
     *
     * <code>repeated string include_columns = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of includeColumns.
     */
    public int getIncludeColumnsCount() {
      return includeColumns_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns to be included for a particular table.
     * </pre>
     *
     * <code>repeated string include_columns = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The includeColumns at the given index.
     */
    public java.lang.String getIncludeColumns(int index) {
      return includeColumns_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns to be included for a particular table.
     * </pre>
     *
     * <code>repeated string include_columns = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the includeColumns at the given index.
     */
    public com.google.protobuf.ByteString getIncludeColumnsBytes(int index) {
      return includeColumns_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns to be included for a particular table.
     * </pre>
     *
     * <code>repeated string include_columns = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The includeColumns to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeColumns(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncludeColumnsIsMutable();
      includeColumns_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns to be included for a particular table.
     * </pre>
     *
     * <code>repeated string include_columns = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The includeColumns to add.
     * @return This builder for chaining.
     */
    public Builder addIncludeColumns(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncludeColumnsIsMutable();
      includeColumns_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns to be included for a particular table.
     * </pre>
     *
     * <code>repeated string include_columns = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The includeColumns to add.
     * @return This builder for chaining.
     */
    public Builder addAllIncludeColumns(java.lang.Iterable<java.lang.String> values) {
      ensureIncludeColumnsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, includeColumns_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns to be included for a particular table.
     * </pre>
     *
     * <code>repeated string include_columns = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludeColumns() {
      includeColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns to be included for a particular table.
     * </pre>
     *
     * <code>repeated string include_columns = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the includeColumns to add.
     * @return This builder for chaining.
     */
    public Builder addIncludeColumnsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIncludeColumnsIsMutable();
      includeColumns_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList excludeColumns_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureExcludeColumnsIsMutable() {
      if (!excludeColumns_.isModifiable()) {
        excludeColumns_ = new com.google.protobuf.LazyStringArrayList(excludeColumns_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns to be excluded for a particular table.
     * </pre>
     *
     * <code>repeated string exclude_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the excludeColumns.
     */
    public com.google.protobuf.ProtocolStringList getExcludeColumnsList() {
      excludeColumns_.makeImmutable();
      return excludeColumns_;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns to be excluded for a particular table.
     * </pre>
     *
     * <code>repeated string exclude_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of excludeColumns.
     */
    public int getExcludeColumnsCount() {
      return excludeColumns_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns to be excluded for a particular table.
     * </pre>
     *
     * <code>repeated string exclude_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The excludeColumns at the given index.
     */
    public java.lang.String getExcludeColumns(int index) {
      return excludeColumns_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns to be excluded for a particular table.
     * </pre>
     *
     * <code>repeated string exclude_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludeColumns at the given index.
     */
    public com.google.protobuf.ByteString getExcludeColumnsBytes(int index) {
      return excludeColumns_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns to be excluded for a particular table.
     * </pre>
     *
     * <code>repeated string exclude_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The excludeColumns to set.
     * @return This builder for chaining.
     */
    public Builder setExcludeColumns(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExcludeColumnsIsMutable();
      excludeColumns_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns to be excluded for a particular table.
     * </pre>
     *
     * <code>repeated string exclude_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The excludeColumns to add.
     * @return This builder for chaining.
     */
    public Builder addExcludeColumns(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExcludeColumnsIsMutable();
      excludeColumns_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns to be excluded for a particular table.
     * </pre>
     *
     * <code>repeated string exclude_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The excludeColumns to add.
     * @return This builder for chaining.
     */
    public Builder addAllExcludeColumns(java.lang.Iterable<java.lang.String> values) {
      ensureExcludeColumnsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, excludeColumns_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns to be excluded for a particular table.
     * </pre>
     *
     * <code>repeated string exclude_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExcludeColumns() {
      excludeColumns_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of columns to be excluded for a particular table.
     * </pre>
     *
     * <code>repeated string exclude_columns = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the excludeColumns to add.
     * @return This builder for chaining.
     */
    public Builder addExcludeColumnsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureExcludeColumnsIsMutable();
      excludeColumns_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.FilterTableColumns)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.FilterTableColumns)
  private static final com.google.cloud.clouddms.v1.FilterTableColumns DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.FilterTableColumns();
  }

  public static com.google.cloud.clouddms.v1.FilterTableColumns getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FilterTableColumns> PARSER =
      new com.google.protobuf.AbstractParser<FilterTableColumns>() {
        @java.lang.Override
        public FilterTableColumns parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FilterTableColumns> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FilterTableColumns> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.FilterTableColumns getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
