/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/clouddms.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Request message for 'GenerateSshScript' request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.GenerateSshScriptRequest}
 */
public final class GenerateSshScriptRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.GenerateSshScriptRequest)
    GenerateSshScriptRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GenerateSshScriptRequest.newBuilder() to construct.
  private GenerateSshScriptRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GenerateSshScriptRequest() {
    migrationJob_ = "";
    vm_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GenerateSshScriptRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ClouddmsProto
        .internal_static_google_cloud_clouddms_v1_GenerateSshScriptRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ClouddmsProto
        .internal_static_google_cloud_clouddms_v1_GenerateSshScriptRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.GenerateSshScriptRequest.class,
            com.google.cloud.clouddms.v1.GenerateSshScriptRequest.Builder.class);
  }

  private int vmConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object vmConfig_;

  public enum VmConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    VM_CREATION_CONFIG(100),
    VM_SELECTION_CONFIG(101),
    VMCONFIG_NOT_SET(0);
    private final int value;

    private VmConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VmConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static VmConfigCase forNumber(int value) {
      switch (value) {
        case 100:
          return VM_CREATION_CONFIG;
        case 101:
          return VM_SELECTION_CONFIG;
        case 0:
          return VMCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public VmConfigCase getVmConfigCase() {
    return VmConfigCase.forNumber(vmConfigCase_);
  }

  public static final int MIGRATION_JOB_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object migrationJob_ = "";
  /**
   *
   *
   * <pre>
   * Name of the migration job resource to generate the SSH script.
   * </pre>
   *
   * <code>string migration_job = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The migrationJob.
   */
  @java.lang.Override
  public java.lang.String getMigrationJob() {
    java.lang.Object ref = migrationJob_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      migrationJob_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the migration job resource to generate the SSH script.
   * </pre>
   *
   * <code>string migration_job = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for migrationJob.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMigrationJobBytes() {
    java.lang.Object ref = migrationJob_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      migrationJob_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VM_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object vm_ = "";
  /**
   *
   *
   * <pre>
   * Required. Bastion VM Instance name to use or to create.
   * </pre>
   *
   * <code>string vm = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The vm.
   */
  @java.lang.Override
  public java.lang.String getVm() {
    java.lang.Object ref = vm_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      vm_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Bastion VM Instance name to use or to create.
   * </pre>
   *
   * <code>string vm = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for vm.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVmBytes() {
    java.lang.Object ref = vm_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      vm_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VM_CREATION_CONFIG_FIELD_NUMBER = 100;
  /**
   *
   *
   * <pre>
   * The VM creation configuration
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.VmCreationConfig vm_creation_config = 100;</code>
   *
   * @return Whether the vmCreationConfig field is set.
   */
  @java.lang.Override
  public boolean hasVmCreationConfig() {
    return vmConfigCase_ == 100;
  }
  /**
   *
   *
   * <pre>
   * The VM creation configuration
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.VmCreationConfig vm_creation_config = 100;</code>
   *
   * @return The vmCreationConfig.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.VmCreationConfig getVmCreationConfig() {
    if (vmConfigCase_ == 100) {
      return (com.google.cloud.clouddms.v1.VmCreationConfig) vmConfig_;
    }
    return com.google.cloud.clouddms.v1.VmCreationConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The VM creation configuration
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.VmCreationConfig vm_creation_config = 100;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.VmCreationConfigOrBuilder getVmCreationConfigOrBuilder() {
    if (vmConfigCase_ == 100) {
      return (com.google.cloud.clouddms.v1.VmCreationConfig) vmConfig_;
    }
    return com.google.cloud.clouddms.v1.VmCreationConfig.getDefaultInstance();
  }

  public static final int VM_SELECTION_CONFIG_FIELD_NUMBER = 101;
  /**
   *
   *
   * <pre>
   * The VM selection configuration
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.VmSelectionConfig vm_selection_config = 101;</code>
   *
   * @return Whether the vmSelectionConfig field is set.
   */
  @java.lang.Override
  public boolean hasVmSelectionConfig() {
    return vmConfigCase_ == 101;
  }
  /**
   *
   *
   * <pre>
   * The VM selection configuration
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.VmSelectionConfig vm_selection_config = 101;</code>
   *
   * @return The vmSelectionConfig.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.VmSelectionConfig getVmSelectionConfig() {
    if (vmConfigCase_ == 101) {
      return (com.google.cloud.clouddms.v1.VmSelectionConfig) vmConfig_;
    }
    return com.google.cloud.clouddms.v1.VmSelectionConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The VM selection configuration
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.VmSelectionConfig vm_selection_config = 101;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.VmSelectionConfigOrBuilder getVmSelectionConfigOrBuilder() {
    if (vmConfigCase_ == 101) {
      return (com.google.cloud.clouddms.v1.VmSelectionConfig) vmConfig_;
    }
    return com.google.cloud.clouddms.v1.VmSelectionConfig.getDefaultInstance();
  }

  public static final int VM_PORT_FIELD_NUMBER = 3;
  private int vmPort_ = 0;
  /**
   *
   *
   * <pre>
   * The port that will be open on the bastion host.
   * </pre>
   *
   * <code>int32 vm_port = 3;</code>
   *
   * @return The vmPort.
   */
  @java.lang.Override
  public int getVmPort() {
    return vmPort_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(migrationJob_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, migrationJob_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vm_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, vm_);
    }
    if (vmPort_ != 0) {
      output.writeInt32(3, vmPort_);
    }
    if (vmConfigCase_ == 100) {
      output.writeMessage(100, (com.google.cloud.clouddms.v1.VmCreationConfig) vmConfig_);
    }
    if (vmConfigCase_ == 101) {
      output.writeMessage(101, (com.google.cloud.clouddms.v1.VmSelectionConfig) vmConfig_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(migrationJob_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, migrationJob_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vm_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, vm_);
    }
    if (vmPort_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, vmPort_);
    }
    if (vmConfigCase_ == 100) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              100, (com.google.cloud.clouddms.v1.VmCreationConfig) vmConfig_);
    }
    if (vmConfigCase_ == 101) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              101, (com.google.cloud.clouddms.v1.VmSelectionConfig) vmConfig_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.GenerateSshScriptRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.GenerateSshScriptRequest other =
        (com.google.cloud.clouddms.v1.GenerateSshScriptRequest) obj;

    if (!getMigrationJob().equals(other.getMigrationJob())) return false;
    if (!getVm().equals(other.getVm())) return false;
    if (getVmPort() != other.getVmPort()) return false;
    if (!getVmConfigCase().equals(other.getVmConfigCase())) return false;
    switch (vmConfigCase_) {
      case 100:
        if (!getVmCreationConfig().equals(other.getVmCreationConfig())) return false;
        break;
      case 101:
        if (!getVmSelectionConfig().equals(other.getVmSelectionConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MIGRATION_JOB_FIELD_NUMBER;
    hash = (53 * hash) + getMigrationJob().hashCode();
    hash = (37 * hash) + VM_FIELD_NUMBER;
    hash = (53 * hash) + getVm().hashCode();
    hash = (37 * hash) + VM_PORT_FIELD_NUMBER;
    hash = (53 * hash) + getVmPort();
    switch (vmConfigCase_) {
      case 100:
        hash = (37 * hash) + VM_CREATION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getVmCreationConfig().hashCode();
        break;
      case 101:
        hash = (37 * hash) + VM_SELECTION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getVmSelectionConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.GenerateSshScriptRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.GenerateSshScriptRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.GenerateSshScriptRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.GenerateSshScriptRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.GenerateSshScriptRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.GenerateSshScriptRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.GenerateSshScriptRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.GenerateSshScriptRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.GenerateSshScriptRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.GenerateSshScriptRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.GenerateSshScriptRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.GenerateSshScriptRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.clouddms.v1.GenerateSshScriptRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for 'GenerateSshScript' request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.GenerateSshScriptRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.GenerateSshScriptRequest)
      com.google.cloud.clouddms.v1.GenerateSshScriptRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_GenerateSshScriptRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_GenerateSshScriptRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.GenerateSshScriptRequest.class,
              com.google.cloud.clouddms.v1.GenerateSshScriptRequest.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.GenerateSshScriptRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      migrationJob_ = "";
      vm_ = "";
      if (vmCreationConfigBuilder_ != null) {
        vmCreationConfigBuilder_.clear();
      }
      if (vmSelectionConfigBuilder_ != null) {
        vmSelectionConfigBuilder_.clear();
      }
      vmPort_ = 0;
      vmConfigCase_ = 0;
      vmConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_GenerateSshScriptRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.GenerateSshScriptRequest getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.GenerateSshScriptRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.GenerateSshScriptRequest build() {
      com.google.cloud.clouddms.v1.GenerateSshScriptRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.GenerateSshScriptRequest buildPartial() {
      com.google.cloud.clouddms.v1.GenerateSshScriptRequest result =
          new com.google.cloud.clouddms.v1.GenerateSshScriptRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.GenerateSshScriptRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.migrationJob_ = migrationJob_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.vm_ = vm_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.vmPort_ = vmPort_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.clouddms.v1.GenerateSshScriptRequest result) {
      result.vmConfigCase_ = vmConfigCase_;
      result.vmConfig_ = this.vmConfig_;
      if (vmConfigCase_ == 100 && vmCreationConfigBuilder_ != null) {
        result.vmConfig_ = vmCreationConfigBuilder_.build();
      }
      if (vmConfigCase_ == 101 && vmSelectionConfigBuilder_ != null) {
        result.vmConfig_ = vmSelectionConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.GenerateSshScriptRequest) {
        return mergeFrom((com.google.cloud.clouddms.v1.GenerateSshScriptRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.GenerateSshScriptRequest other) {
      if (other == com.google.cloud.clouddms.v1.GenerateSshScriptRequest.getDefaultInstance())
        return this;
      if (!other.getMigrationJob().isEmpty()) {
        migrationJob_ = other.migrationJob_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getVm().isEmpty()) {
        vm_ = other.vm_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getVmPort() != 0) {
        setVmPort(other.getVmPort());
      }
      switch (other.getVmConfigCase()) {
        case VM_CREATION_CONFIG:
          {
            mergeVmCreationConfig(other.getVmCreationConfig());
            break;
          }
        case VM_SELECTION_CONFIG:
          {
            mergeVmSelectionConfig(other.getVmSelectionConfig());
            break;
          }
        case VMCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                migrationJob_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                vm_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                vmPort_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 24
            case 802:
              {
                input.readMessage(
                    getVmCreationConfigFieldBuilder().getBuilder(), extensionRegistry);
                vmConfigCase_ = 100;
                break;
              } // case 802
            case 810:
              {
                input.readMessage(
                    getVmSelectionConfigFieldBuilder().getBuilder(), extensionRegistry);
                vmConfigCase_ = 101;
                break;
              } // case 810
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int vmConfigCase_ = 0;
    private java.lang.Object vmConfig_;

    public VmConfigCase getVmConfigCase() {
      return VmConfigCase.forNumber(vmConfigCase_);
    }

    public Builder clearVmConfig() {
      vmConfigCase_ = 0;
      vmConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object migrationJob_ = "";
    /**
     *
     *
     * <pre>
     * Name of the migration job resource to generate the SSH script.
     * </pre>
     *
     * <code>string migration_job = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The migrationJob.
     */
    public java.lang.String getMigrationJob() {
      java.lang.Object ref = migrationJob_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        migrationJob_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the migration job resource to generate the SSH script.
     * </pre>
     *
     * <code>string migration_job = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for migrationJob.
     */
    public com.google.protobuf.ByteString getMigrationJobBytes() {
      java.lang.Object ref = migrationJob_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        migrationJob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the migration job resource to generate the SSH script.
     * </pre>
     *
     * <code>string migration_job = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The migrationJob to set.
     * @return This builder for chaining.
     */
    public Builder setMigrationJob(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      migrationJob_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the migration job resource to generate the SSH script.
     * </pre>
     *
     * <code>string migration_job = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMigrationJob() {
      migrationJob_ = getDefaultInstance().getMigrationJob();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the migration job resource to generate the SSH script.
     * </pre>
     *
     * <code>string migration_job = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for migrationJob to set.
     * @return This builder for chaining.
     */
    public Builder setMigrationJobBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      migrationJob_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object vm_ = "";
    /**
     *
     *
     * <pre>
     * Required. Bastion VM Instance name to use or to create.
     * </pre>
     *
     * <code>string vm = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The vm.
     */
    public java.lang.String getVm() {
      java.lang.Object ref = vm_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        vm_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Bastion VM Instance name to use or to create.
     * </pre>
     *
     * <code>string vm = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for vm.
     */
    public com.google.protobuf.ByteString getVmBytes() {
      java.lang.Object ref = vm_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        vm_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Bastion VM Instance name to use or to create.
     * </pre>
     *
     * <code>string vm = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The vm to set.
     * @return This builder for chaining.
     */
    public Builder setVm(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      vm_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Bastion VM Instance name to use or to create.
     * </pre>
     *
     * <code>string vm = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVm() {
      vm_ = getDefaultInstance().getVm();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Bastion VM Instance name to use or to create.
     * </pre>
     *
     * <code>string vm = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for vm to set.
     * @return This builder for chaining.
     */
    public Builder setVmBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      vm_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.VmCreationConfig,
            com.google.cloud.clouddms.v1.VmCreationConfig.Builder,
            com.google.cloud.clouddms.v1.VmCreationConfigOrBuilder>
        vmCreationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The VM creation configuration
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VmCreationConfig vm_creation_config = 100;</code>
     *
     * @return Whether the vmCreationConfig field is set.
     */
    @java.lang.Override
    public boolean hasVmCreationConfig() {
      return vmConfigCase_ == 100;
    }
    /**
     *
     *
     * <pre>
     * The VM creation configuration
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VmCreationConfig vm_creation_config = 100;</code>
     *
     * @return The vmCreationConfig.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.VmCreationConfig getVmCreationConfig() {
      if (vmCreationConfigBuilder_ == null) {
        if (vmConfigCase_ == 100) {
          return (com.google.cloud.clouddms.v1.VmCreationConfig) vmConfig_;
        }
        return com.google.cloud.clouddms.v1.VmCreationConfig.getDefaultInstance();
      } else {
        if (vmConfigCase_ == 100) {
          return vmCreationConfigBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.VmCreationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The VM creation configuration
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VmCreationConfig vm_creation_config = 100;</code>
     */
    public Builder setVmCreationConfig(com.google.cloud.clouddms.v1.VmCreationConfig value) {
      if (vmCreationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vmConfig_ = value;
        onChanged();
      } else {
        vmCreationConfigBuilder_.setMessage(value);
      }
      vmConfigCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The VM creation configuration
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VmCreationConfig vm_creation_config = 100;</code>
     */
    public Builder setVmCreationConfig(
        com.google.cloud.clouddms.v1.VmCreationConfig.Builder builderForValue) {
      if (vmCreationConfigBuilder_ == null) {
        vmConfig_ = builderForValue.build();
        onChanged();
      } else {
        vmCreationConfigBuilder_.setMessage(builderForValue.build());
      }
      vmConfigCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The VM creation configuration
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VmCreationConfig vm_creation_config = 100;</code>
     */
    public Builder mergeVmCreationConfig(com.google.cloud.clouddms.v1.VmCreationConfig value) {
      if (vmCreationConfigBuilder_ == null) {
        if (vmConfigCase_ == 100
            && vmConfig_ != com.google.cloud.clouddms.v1.VmCreationConfig.getDefaultInstance()) {
          vmConfig_ =
              com.google.cloud.clouddms.v1.VmCreationConfig.newBuilder(
                      (com.google.cloud.clouddms.v1.VmCreationConfig) vmConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          vmConfig_ = value;
        }
        onChanged();
      } else {
        if (vmConfigCase_ == 100) {
          vmCreationConfigBuilder_.mergeFrom(value);
        } else {
          vmCreationConfigBuilder_.setMessage(value);
        }
      }
      vmConfigCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The VM creation configuration
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VmCreationConfig vm_creation_config = 100;</code>
     */
    public Builder clearVmCreationConfig() {
      if (vmCreationConfigBuilder_ == null) {
        if (vmConfigCase_ == 100) {
          vmConfigCase_ = 0;
          vmConfig_ = null;
          onChanged();
        }
      } else {
        if (vmConfigCase_ == 100) {
          vmConfigCase_ = 0;
          vmConfig_ = null;
        }
        vmCreationConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The VM creation configuration
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VmCreationConfig vm_creation_config = 100;</code>
     */
    public com.google.cloud.clouddms.v1.VmCreationConfig.Builder getVmCreationConfigBuilder() {
      return getVmCreationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The VM creation configuration
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VmCreationConfig vm_creation_config = 100;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.VmCreationConfigOrBuilder getVmCreationConfigOrBuilder() {
      if ((vmConfigCase_ == 100) && (vmCreationConfigBuilder_ != null)) {
        return vmCreationConfigBuilder_.getMessageOrBuilder();
      } else {
        if (vmConfigCase_ == 100) {
          return (com.google.cloud.clouddms.v1.VmCreationConfig) vmConfig_;
        }
        return com.google.cloud.clouddms.v1.VmCreationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The VM creation configuration
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VmCreationConfig vm_creation_config = 100;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.VmCreationConfig,
            com.google.cloud.clouddms.v1.VmCreationConfig.Builder,
            com.google.cloud.clouddms.v1.VmCreationConfigOrBuilder>
        getVmCreationConfigFieldBuilder() {
      if (vmCreationConfigBuilder_ == null) {
        if (!(vmConfigCase_ == 100)) {
          vmConfig_ = com.google.cloud.clouddms.v1.VmCreationConfig.getDefaultInstance();
        }
        vmCreationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.VmCreationConfig,
                com.google.cloud.clouddms.v1.VmCreationConfig.Builder,
                com.google.cloud.clouddms.v1.VmCreationConfigOrBuilder>(
                (com.google.cloud.clouddms.v1.VmCreationConfig) vmConfig_,
                getParentForChildren(),
                isClean());
        vmConfig_ = null;
      }
      vmConfigCase_ = 100;
      onChanged();
      return vmCreationConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.VmSelectionConfig,
            com.google.cloud.clouddms.v1.VmSelectionConfig.Builder,
            com.google.cloud.clouddms.v1.VmSelectionConfigOrBuilder>
        vmSelectionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The VM selection configuration
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VmSelectionConfig vm_selection_config = 101;</code>
     *
     * @return Whether the vmSelectionConfig field is set.
     */
    @java.lang.Override
    public boolean hasVmSelectionConfig() {
      return vmConfigCase_ == 101;
    }
    /**
     *
     *
     * <pre>
     * The VM selection configuration
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VmSelectionConfig vm_selection_config = 101;</code>
     *
     * @return The vmSelectionConfig.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.VmSelectionConfig getVmSelectionConfig() {
      if (vmSelectionConfigBuilder_ == null) {
        if (vmConfigCase_ == 101) {
          return (com.google.cloud.clouddms.v1.VmSelectionConfig) vmConfig_;
        }
        return com.google.cloud.clouddms.v1.VmSelectionConfig.getDefaultInstance();
      } else {
        if (vmConfigCase_ == 101) {
          return vmSelectionConfigBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.VmSelectionConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The VM selection configuration
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VmSelectionConfig vm_selection_config = 101;</code>
     */
    public Builder setVmSelectionConfig(com.google.cloud.clouddms.v1.VmSelectionConfig value) {
      if (vmSelectionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vmConfig_ = value;
        onChanged();
      } else {
        vmSelectionConfigBuilder_.setMessage(value);
      }
      vmConfigCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The VM selection configuration
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VmSelectionConfig vm_selection_config = 101;</code>
     */
    public Builder setVmSelectionConfig(
        com.google.cloud.clouddms.v1.VmSelectionConfig.Builder builderForValue) {
      if (vmSelectionConfigBuilder_ == null) {
        vmConfig_ = builderForValue.build();
        onChanged();
      } else {
        vmSelectionConfigBuilder_.setMessage(builderForValue.build());
      }
      vmConfigCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The VM selection configuration
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VmSelectionConfig vm_selection_config = 101;</code>
     */
    public Builder mergeVmSelectionConfig(com.google.cloud.clouddms.v1.VmSelectionConfig value) {
      if (vmSelectionConfigBuilder_ == null) {
        if (vmConfigCase_ == 101
            && vmConfig_ != com.google.cloud.clouddms.v1.VmSelectionConfig.getDefaultInstance()) {
          vmConfig_ =
              com.google.cloud.clouddms.v1.VmSelectionConfig.newBuilder(
                      (com.google.cloud.clouddms.v1.VmSelectionConfig) vmConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          vmConfig_ = value;
        }
        onChanged();
      } else {
        if (vmConfigCase_ == 101) {
          vmSelectionConfigBuilder_.mergeFrom(value);
        } else {
          vmSelectionConfigBuilder_.setMessage(value);
        }
      }
      vmConfigCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The VM selection configuration
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VmSelectionConfig vm_selection_config = 101;</code>
     */
    public Builder clearVmSelectionConfig() {
      if (vmSelectionConfigBuilder_ == null) {
        if (vmConfigCase_ == 101) {
          vmConfigCase_ = 0;
          vmConfig_ = null;
          onChanged();
        }
      } else {
        if (vmConfigCase_ == 101) {
          vmConfigCase_ = 0;
          vmConfig_ = null;
        }
        vmSelectionConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The VM selection configuration
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VmSelectionConfig vm_selection_config = 101;</code>
     */
    public com.google.cloud.clouddms.v1.VmSelectionConfig.Builder getVmSelectionConfigBuilder() {
      return getVmSelectionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The VM selection configuration
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VmSelectionConfig vm_selection_config = 101;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.VmSelectionConfigOrBuilder getVmSelectionConfigOrBuilder() {
      if ((vmConfigCase_ == 101) && (vmSelectionConfigBuilder_ != null)) {
        return vmSelectionConfigBuilder_.getMessageOrBuilder();
      } else {
        if (vmConfigCase_ == 101) {
          return (com.google.cloud.clouddms.v1.VmSelectionConfig) vmConfig_;
        }
        return com.google.cloud.clouddms.v1.VmSelectionConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The VM selection configuration
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VmSelectionConfig vm_selection_config = 101;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.VmSelectionConfig,
            com.google.cloud.clouddms.v1.VmSelectionConfig.Builder,
            com.google.cloud.clouddms.v1.VmSelectionConfigOrBuilder>
        getVmSelectionConfigFieldBuilder() {
      if (vmSelectionConfigBuilder_ == null) {
        if (!(vmConfigCase_ == 101)) {
          vmConfig_ = com.google.cloud.clouddms.v1.VmSelectionConfig.getDefaultInstance();
        }
        vmSelectionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.VmSelectionConfig,
                com.google.cloud.clouddms.v1.VmSelectionConfig.Builder,
                com.google.cloud.clouddms.v1.VmSelectionConfigOrBuilder>(
                (com.google.cloud.clouddms.v1.VmSelectionConfig) vmConfig_,
                getParentForChildren(),
                isClean());
        vmConfig_ = null;
      }
      vmConfigCase_ = 101;
      onChanged();
      return vmSelectionConfigBuilder_;
    }

    private int vmPort_;
    /**
     *
     *
     * <pre>
     * The port that will be open on the bastion host.
     * </pre>
     *
     * <code>int32 vm_port = 3;</code>
     *
     * @return The vmPort.
     */
    @java.lang.Override
    public int getVmPort() {
      return vmPort_;
    }
    /**
     *
     *
     * <pre>
     * The port that will be open on the bastion host.
     * </pre>
     *
     * <code>int32 vm_port = 3;</code>
     *
     * @param value The vmPort to set.
     * @return This builder for chaining.
     */
    public Builder setVmPort(int value) {

      vmPort_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The port that will be open on the bastion host.
     * </pre>
     *
     * <code>int32 vm_port = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVmPort() {
      bitField0_ = (bitField0_ & ~0x00000010);
      vmPort_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.GenerateSshScriptRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.GenerateSshScriptRequest)
  private static final com.google.cloud.clouddms.v1.GenerateSshScriptRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.GenerateSshScriptRequest();
  }

  public static com.google.cloud.clouddms.v1.GenerateSshScriptRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenerateSshScriptRequest> PARSER =
      new com.google.protobuf.AbstractParser<GenerateSshScriptRequest>() {
        @java.lang.Override
        public GenerateSshScriptRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GenerateSshScriptRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenerateSshScriptRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.GenerateSshScriptRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
