/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/clouddms.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Request message for 'ImportMappingRules' request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.ImportMappingRulesRequest}
 */
public final class ImportMappingRulesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.ImportMappingRulesRequest)
    ImportMappingRulesRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportMappingRulesRequest.newBuilder() to construct.
  private ImportMappingRulesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportMappingRulesRequest() {
    parent_ = "";
    rulesFormat_ = 0;
    rulesFiles_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportMappingRulesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ClouddmsProto
        .internal_static_google_cloud_clouddms_v1_ImportMappingRulesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ClouddmsProto
        .internal_static_google_cloud_clouddms_v1_ImportMappingRulesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.ImportMappingRulesRequest.class,
            com.google.cloud.clouddms.v1.ImportMappingRulesRequest.Builder.class);
  }

  public interface RulesFileOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The filename of the rules that needs to be converted. The
     * filename is used mainly so that future logs of the import rules job
     * contain it, and can therefore be searched by it.
     * </pre>
     *
     * <code>string rules_source_filename = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The rulesSourceFilename.
     */
    java.lang.String getRulesSourceFilename();
    /**
     *
     *
     * <pre>
     * Required. The filename of the rules that needs to be converted. The
     * filename is used mainly so that future logs of the import rules job
     * contain it, and can therefore be searched by it.
     * </pre>
     *
     * <code>string rules_source_filename = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for rulesSourceFilename.
     */
    com.google.protobuf.ByteString getRulesSourceFilenameBytes();

    /**
     *
     *
     * <pre>
     * Required. The text content of the rules that needs to be converted.
     * </pre>
     *
     * <code>string rules_content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The rulesContent.
     */
    java.lang.String getRulesContent();
    /**
     *
     *
     * <pre>
     * Required. The text content of the rules that needs to be converted.
     * </pre>
     *
     * <code>string rules_content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for rulesContent.
     */
    com.google.protobuf.ByteString getRulesContentBytes();
  }
  /**
   *
   *
   * <pre>
   * Details of a single rules file.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile}
   */
  public static final class RulesFile extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile)
      RulesFileOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RulesFile.newBuilder() to construct.
    private RulesFile(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RulesFile() {
      rulesSourceFilename_ = "";
      rulesContent_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RulesFile();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_ImportMappingRulesRequest_RulesFile_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_ImportMappingRulesRequest_RulesFile_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile.class,
              com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile.Builder.class);
    }

    public static final int RULES_SOURCE_FILENAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object rulesSourceFilename_ = "";
    /**
     *
     *
     * <pre>
     * Required. The filename of the rules that needs to be converted. The
     * filename is used mainly so that future logs of the import rules job
     * contain it, and can therefore be searched by it.
     * </pre>
     *
     * <code>string rules_source_filename = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The rulesSourceFilename.
     */
    @java.lang.Override
    public java.lang.String getRulesSourceFilename() {
      java.lang.Object ref = rulesSourceFilename_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rulesSourceFilename_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The filename of the rules that needs to be converted. The
     * filename is used mainly so that future logs of the import rules job
     * contain it, and can therefore be searched by it.
     * </pre>
     *
     * <code>string rules_source_filename = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for rulesSourceFilename.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRulesSourceFilenameBytes() {
      java.lang.Object ref = rulesSourceFilename_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rulesSourceFilename_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RULES_CONTENT_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object rulesContent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The text content of the rules that needs to be converted.
     * </pre>
     *
     * <code>string rules_content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The rulesContent.
     */
    @java.lang.Override
    public java.lang.String getRulesContent() {
      java.lang.Object ref = rulesContent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rulesContent_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The text content of the rules that needs to be converted.
     * </pre>
     *
     * <code>string rules_content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for rulesContent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRulesContentBytes() {
      java.lang.Object ref = rulesContent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rulesContent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rulesSourceFilename_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, rulesSourceFilename_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rulesContent_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, rulesContent_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rulesSourceFilename_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, rulesSourceFilename_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rulesContent_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, rulesContent_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile)) {
        return super.equals(obj);
      }
      com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile other =
          (com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile) obj;

      if (!getRulesSourceFilename().equals(other.getRulesSourceFilename())) return false;
      if (!getRulesContent().equals(other.getRulesContent())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RULES_SOURCE_FILENAME_FIELD_NUMBER;
      hash = (53 * hash) + getRulesSourceFilename().hashCode();
      hash = (37 * hash) + RULES_CONTENT_FIELD_NUMBER;
      hash = (53 * hash) + getRulesContent().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Details of a single rules file.
     * </pre>
     *
     * Protobuf type {@code google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile)
        com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFileOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.clouddms.v1.ClouddmsProto
            .internal_static_google_cloud_clouddms_v1_ImportMappingRulesRequest_RulesFile_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.clouddms.v1.ClouddmsProto
            .internal_static_google_cloud_clouddms_v1_ImportMappingRulesRequest_RulesFile_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile.class,
                com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile.Builder.class);
      }

      // Construct using
      // com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        rulesSourceFilename_ = "";
        rulesContent_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.clouddms.v1.ClouddmsProto
            .internal_static_google_cloud_clouddms_v1_ImportMappingRulesRequest_RulesFile_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile
          getDefaultInstanceForType() {
        return com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile build() {
        com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile buildPartial() {
        com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile result =
            new com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.rulesSourceFilename_ = rulesSourceFilename_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.rulesContent_ = rulesContent_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile) {
          return mergeFrom(
              (com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile other) {
        if (other
            == com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile
                .getDefaultInstance()) return this;
        if (!other.getRulesSourceFilename().isEmpty()) {
          rulesSourceFilename_ = other.rulesSourceFilename_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getRulesContent().isEmpty()) {
          rulesContent_ = other.rulesContent_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  rulesSourceFilename_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  rulesContent_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object rulesSourceFilename_ = "";
      /**
       *
       *
       * <pre>
       * Required. The filename of the rules that needs to be converted. The
       * filename is used mainly so that future logs of the import rules job
       * contain it, and can therefore be searched by it.
       * </pre>
       *
       * <code>string rules_source_filename = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The rulesSourceFilename.
       */
      public java.lang.String getRulesSourceFilename() {
        java.lang.Object ref = rulesSourceFilename_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          rulesSourceFilename_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The filename of the rules that needs to be converted. The
       * filename is used mainly so that future logs of the import rules job
       * contain it, and can therefore be searched by it.
       * </pre>
       *
       * <code>string rules_source_filename = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for rulesSourceFilename.
       */
      public com.google.protobuf.ByteString getRulesSourceFilenameBytes() {
        java.lang.Object ref = rulesSourceFilename_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          rulesSourceFilename_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The filename of the rules that needs to be converted. The
       * filename is used mainly so that future logs of the import rules job
       * contain it, and can therefore be searched by it.
       * </pre>
       *
       * <code>string rules_source_filename = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The rulesSourceFilename to set.
       * @return This builder for chaining.
       */
      public Builder setRulesSourceFilename(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        rulesSourceFilename_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The filename of the rules that needs to be converted. The
       * filename is used mainly so that future logs of the import rules job
       * contain it, and can therefore be searched by it.
       * </pre>
       *
       * <code>string rules_source_filename = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRulesSourceFilename() {
        rulesSourceFilename_ = getDefaultInstance().getRulesSourceFilename();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The filename of the rules that needs to be converted. The
       * filename is used mainly so that future logs of the import rules job
       * contain it, and can therefore be searched by it.
       * </pre>
       *
       * <code>string rules_source_filename = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for rulesSourceFilename to set.
       * @return This builder for chaining.
       */
      public Builder setRulesSourceFilenameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        rulesSourceFilename_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object rulesContent_ = "";
      /**
       *
       *
       * <pre>
       * Required. The text content of the rules that needs to be converted.
       * </pre>
       *
       * <code>string rules_content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The rulesContent.
       */
      public java.lang.String getRulesContent() {
        java.lang.Object ref = rulesContent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          rulesContent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The text content of the rules that needs to be converted.
       * </pre>
       *
       * <code>string rules_content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for rulesContent.
       */
      public com.google.protobuf.ByteString getRulesContentBytes() {
        java.lang.Object ref = rulesContent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          rulesContent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The text content of the rules that needs to be converted.
       * </pre>
       *
       * <code>string rules_content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The rulesContent to set.
       * @return This builder for chaining.
       */
      public Builder setRulesContent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        rulesContent_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The text content of the rules that needs to be converted.
       * </pre>
       *
       * <code>string rules_content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRulesContent() {
        rulesContent_ = getDefaultInstance().getRulesContent();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The text content of the rules that needs to be converted.
       * </pre>
       *
       * <code>string rules_content = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for rulesContent to set.
       * @return This builder for chaining.
       */
      public Builder setRulesContentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        rulesContent_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile)
    private static final com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile();
    }

    public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RulesFile> PARSER =
        new com.google.protobuf.AbstractParser<RulesFile>() {
          @java.lang.Override
          public RulesFile parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RulesFile> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RulesFile> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. Name of the conversion workspace resource to import the rules to
   * in the form of:
   * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the conversion workspace resource to import the rules to
   * in the form of:
   * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RULES_FORMAT_FIELD_NUMBER = 2;
  private int rulesFormat_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The format of the rules content file.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.ImportRulesFileFormat rules_format = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for rulesFormat.
   */
  @java.lang.Override
  public int getRulesFormatValue() {
    return rulesFormat_;
  }
  /**
   *
   *
   * <pre>
   * Required. The format of the rules content file.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.ImportRulesFileFormat rules_format = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The rulesFormat.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ImportRulesFileFormat getRulesFormat() {
    com.google.cloud.clouddms.v1.ImportRulesFileFormat result =
        com.google.cloud.clouddms.v1.ImportRulesFileFormat.forNumber(rulesFormat_);
    return result == null
        ? com.google.cloud.clouddms.v1.ImportRulesFileFormat.UNRECOGNIZED
        : result;
  }

  public static final int RULES_FILES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile>
      rulesFiles_;
  /**
   *
   *
   * <pre>
   * Required. One or more rules files.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile>
      getRulesFilesList() {
    return rulesFiles_;
  }
  /**
   *
   *
   * <pre>
   * Required. One or more rules files.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFileOrBuilder>
      getRulesFilesOrBuilderList() {
    return rulesFiles_;
  }
  /**
   *
   *
   * <pre>
   * Required. One or more rules files.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getRulesFilesCount() {
    return rulesFiles_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. One or more rules files.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile getRulesFiles(int index) {
    return rulesFiles_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. One or more rules files.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFileOrBuilder
      getRulesFilesOrBuilder(int index) {
    return rulesFiles_.get(index);
  }

  public static final int AUTO_COMMIT_FIELD_NUMBER = 6;
  private boolean autoCommit_ = false;
  /**
   *
   *
   * <pre>
   * Required. Should the conversion workspace be committed automatically after
   * the import operation.
   * </pre>
   *
   * <code>bool auto_commit = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The autoCommit.
   */
  @java.lang.Override
  public boolean getAutoCommit() {
    return autoCommit_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (rulesFormat_
        != com.google.cloud.clouddms.v1.ImportRulesFileFormat.IMPORT_RULES_FILE_FORMAT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, rulesFormat_);
    }
    for (int i = 0; i < rulesFiles_.size(); i++) {
      output.writeMessage(3, rulesFiles_.get(i));
    }
    if (autoCommit_ != false) {
      output.writeBool(6, autoCommit_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (rulesFormat_
        != com.google.cloud.clouddms.v1.ImportRulesFileFormat.IMPORT_RULES_FILE_FORMAT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, rulesFormat_);
    }
    for (int i = 0; i < rulesFiles_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, rulesFiles_.get(i));
    }
    if (autoCommit_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, autoCommit_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.ImportMappingRulesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.ImportMappingRulesRequest other =
        (com.google.cloud.clouddms.v1.ImportMappingRulesRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (rulesFormat_ != other.rulesFormat_) return false;
    if (!getRulesFilesList().equals(other.getRulesFilesList())) return false;
    if (getAutoCommit() != other.getAutoCommit()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + RULES_FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + rulesFormat_;
    if (getRulesFilesCount() > 0) {
      hash = (37 * hash) + RULES_FILES_FIELD_NUMBER;
      hash = (53 * hash) + getRulesFilesList().hashCode();
    }
    hash = (37 * hash) + AUTO_COMMIT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAutoCommit());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.clouddms.v1.ImportMappingRulesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for 'ImportMappingRules' request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.ImportMappingRulesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.ImportMappingRulesRequest)
      com.google.cloud.clouddms.v1.ImportMappingRulesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_ImportMappingRulesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_ImportMappingRulesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.ImportMappingRulesRequest.class,
              com.google.cloud.clouddms.v1.ImportMappingRulesRequest.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.ImportMappingRulesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      rulesFormat_ = 0;
      if (rulesFilesBuilder_ == null) {
        rulesFiles_ = java.util.Collections.emptyList();
      } else {
        rulesFiles_ = null;
        rulesFilesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      autoCommit_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_ImportMappingRulesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ImportMappingRulesRequest getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.ImportMappingRulesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ImportMappingRulesRequest build() {
      com.google.cloud.clouddms.v1.ImportMappingRulesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ImportMappingRulesRequest buildPartial() {
      com.google.cloud.clouddms.v1.ImportMappingRulesRequest result =
          new com.google.cloud.clouddms.v1.ImportMappingRulesRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.clouddms.v1.ImportMappingRulesRequest result) {
      if (rulesFilesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          rulesFiles_ = java.util.Collections.unmodifiableList(rulesFiles_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.rulesFiles_ = rulesFiles_;
      } else {
        result.rulesFiles_ = rulesFilesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.ImportMappingRulesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.rulesFormat_ = rulesFormat_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.autoCommit_ = autoCommit_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.ImportMappingRulesRequest) {
        return mergeFrom((com.google.cloud.clouddms.v1.ImportMappingRulesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.ImportMappingRulesRequest other) {
      if (other == com.google.cloud.clouddms.v1.ImportMappingRulesRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.rulesFormat_ != 0) {
        setRulesFormatValue(other.getRulesFormatValue());
      }
      if (rulesFilesBuilder_ == null) {
        if (!other.rulesFiles_.isEmpty()) {
          if (rulesFiles_.isEmpty()) {
            rulesFiles_ = other.rulesFiles_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureRulesFilesIsMutable();
            rulesFiles_.addAll(other.rulesFiles_);
          }
          onChanged();
        }
      } else {
        if (!other.rulesFiles_.isEmpty()) {
          if (rulesFilesBuilder_.isEmpty()) {
            rulesFilesBuilder_.dispose();
            rulesFilesBuilder_ = null;
            rulesFiles_ = other.rulesFiles_;
            bitField0_ = (bitField0_ & ~0x00000004);
            rulesFilesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRulesFilesFieldBuilder()
                    : null;
          } else {
            rulesFilesBuilder_.addAllMessages(other.rulesFiles_);
          }
        }
      }
      if (other.getAutoCommit() != false) {
        setAutoCommit(other.getAutoCommit());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                rulesFormat_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile m =
                    input.readMessage(
                        com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile.parser(),
                        extensionRegistry);
                if (rulesFilesBuilder_ == null) {
                  ensureRulesFilesIsMutable();
                  rulesFiles_.add(m);
                } else {
                  rulesFilesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 48:
              {
                autoCommit_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the conversion workspace resource to import the rules to
     * in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the conversion workspace resource to import the rules to
     * in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the conversion workspace resource to import the rules to
     * in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the conversion workspace resource to import the rules to
     * in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the conversion workspace resource to import the rules to
     * in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int rulesFormat_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The format of the rules content file.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ImportRulesFileFormat rules_format = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for rulesFormat.
     */
    @java.lang.Override
    public int getRulesFormatValue() {
      return rulesFormat_;
    }
    /**
     *
     *
     * <pre>
     * Required. The format of the rules content file.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ImportRulesFileFormat rules_format = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for rulesFormat to set.
     * @return This builder for chaining.
     */
    public Builder setRulesFormatValue(int value) {
      rulesFormat_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The format of the rules content file.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ImportRulesFileFormat rules_format = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The rulesFormat.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.ImportRulesFileFormat getRulesFormat() {
      com.google.cloud.clouddms.v1.ImportRulesFileFormat result =
          com.google.cloud.clouddms.v1.ImportRulesFileFormat.forNumber(rulesFormat_);
      return result == null
          ? com.google.cloud.clouddms.v1.ImportRulesFileFormat.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The format of the rules content file.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ImportRulesFileFormat rules_format = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The rulesFormat to set.
     * @return This builder for chaining.
     */
    public Builder setRulesFormat(com.google.cloud.clouddms.v1.ImportRulesFileFormat value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      rulesFormat_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The format of the rules content file.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ImportRulesFileFormat rules_format = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRulesFormat() {
      bitField0_ = (bitField0_ & ~0x00000002);
      rulesFormat_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile>
        rulesFiles_ = java.util.Collections.emptyList();

    private void ensureRulesFilesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        rulesFiles_ =
            new java.util.ArrayList<
                com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile>(rulesFiles_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile,
            com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile.Builder,
            com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFileOrBuilder>
        rulesFilesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. One or more rules files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile>
        getRulesFilesList() {
      if (rulesFilesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rulesFiles_);
      } else {
        return rulesFilesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. One or more rules files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getRulesFilesCount() {
      if (rulesFilesBuilder_ == null) {
        return rulesFiles_.size();
      } else {
        return rulesFilesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. One or more rules files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile getRulesFiles(
        int index) {
      if (rulesFilesBuilder_ == null) {
        return rulesFiles_.get(index);
      } else {
        return rulesFilesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. One or more rules files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRulesFiles(
        int index, com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile value) {
      if (rulesFilesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesFilesIsMutable();
        rulesFiles_.set(index, value);
        onChanged();
      } else {
        rulesFilesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. One or more rules files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRulesFiles(
        int index,
        com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile.Builder builderForValue) {
      if (rulesFilesBuilder_ == null) {
        ensureRulesFilesIsMutable();
        rulesFiles_.set(index, builderForValue.build());
        onChanged();
      } else {
        rulesFilesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. One or more rules files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRulesFiles(
        com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile value) {
      if (rulesFilesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesFilesIsMutable();
        rulesFiles_.add(value);
        onChanged();
      } else {
        rulesFilesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. One or more rules files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRulesFiles(
        int index, com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile value) {
      if (rulesFilesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesFilesIsMutable();
        rulesFiles_.add(index, value);
        onChanged();
      } else {
        rulesFilesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. One or more rules files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRulesFiles(
        com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile.Builder builderForValue) {
      if (rulesFilesBuilder_ == null) {
        ensureRulesFilesIsMutable();
        rulesFiles_.add(builderForValue.build());
        onChanged();
      } else {
        rulesFilesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. One or more rules files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRulesFiles(
        int index,
        com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile.Builder builderForValue) {
      if (rulesFilesBuilder_ == null) {
        ensureRulesFilesIsMutable();
        rulesFiles_.add(index, builderForValue.build());
        onChanged();
      } else {
        rulesFilesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. One or more rules files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllRulesFiles(
        java.lang.Iterable<
                ? extends com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile>
            values) {
      if (rulesFilesBuilder_ == null) {
        ensureRulesFilesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rulesFiles_);
        onChanged();
      } else {
        rulesFilesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. One or more rules files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearRulesFiles() {
      if (rulesFilesBuilder_ == null) {
        rulesFiles_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        rulesFilesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. One or more rules files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeRulesFiles(int index) {
      if (rulesFilesBuilder_ == null) {
        ensureRulesFilesIsMutable();
        rulesFiles_.remove(index);
        onChanged();
      } else {
        rulesFilesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. One or more rules files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile.Builder
        getRulesFilesBuilder(int index) {
      return getRulesFilesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. One or more rules files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFileOrBuilder
        getRulesFilesOrBuilder(int index) {
      if (rulesFilesBuilder_ == null) {
        return rulesFiles_.get(index);
      } else {
        return rulesFilesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. One or more rules files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFileOrBuilder>
        getRulesFilesOrBuilderList() {
      if (rulesFilesBuilder_ != null) {
        return rulesFilesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rulesFiles_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. One or more rules files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile.Builder
        addRulesFilesBuilder() {
      return getRulesFilesFieldBuilder()
          .addBuilder(
              com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. One or more rules files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile.Builder
        addRulesFilesBuilder(int index) {
      return getRulesFilesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. One or more rules files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile rules_files = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile.Builder>
        getRulesFilesBuilderList() {
      return getRulesFilesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile,
            com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile.Builder,
            com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFileOrBuilder>
        getRulesFilesFieldBuilder() {
      if (rulesFilesBuilder_ == null) {
        rulesFilesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile,
                com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile.Builder,
                com.google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFileOrBuilder>(
                rulesFiles_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        rulesFiles_ = null;
      }
      return rulesFilesBuilder_;
    }

    private boolean autoCommit_;
    /**
     *
     *
     * <pre>
     * Required. Should the conversion workspace be committed automatically after
     * the import operation.
     * </pre>
     *
     * <code>bool auto_commit = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The autoCommit.
     */
    @java.lang.Override
    public boolean getAutoCommit() {
      return autoCommit_;
    }
    /**
     *
     *
     * <pre>
     * Required. Should the conversion workspace be committed automatically after
     * the import operation.
     * </pre>
     *
     * <code>bool auto_commit = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The autoCommit to set.
     * @return This builder for chaining.
     */
    public Builder setAutoCommit(boolean value) {

      autoCommit_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Should the conversion workspace be committed automatically after
     * the import operation.
     * </pre>
     *
     * <code>bool auto_commit = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutoCommit() {
      bitField0_ = (bitField0_ & ~0x00000008);
      autoCommit_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.ImportMappingRulesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.ImportMappingRulesRequest)
  private static final com.google.cloud.clouddms.v1.ImportMappingRulesRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.ImportMappingRulesRequest();
  }

  public static com.google.cloud.clouddms.v1.ImportMappingRulesRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportMappingRulesRequest> PARSER =
      new com.google.protobuf.AbstractParser<ImportMappingRulesRequest>() {
        @java.lang.Override
        public ImportMappingRulesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportMappingRulesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportMappingRulesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.ImportMappingRulesRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
