/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Definition of a transformation that is to be applied to a group of entities
 * in the source schema. Several such transformations can be applied to an
 * entity sequentially to define the corresponding entity in the target schema.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.MappingRule}
 */
public final class MappingRule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.MappingRule)
    MappingRuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MappingRule.newBuilder() to construct.
  private MappingRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MappingRule() {
    name_ = "";
    displayName_ = "";
    state_ = 0;
    ruleScope_ = 0;
    revisionId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MappingRule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_MappingRule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_MappingRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.MappingRule.class,
            com.google.cloud.clouddms.v1.MappingRule.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The current mapping rule state such as enabled, disabled or deleted.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.clouddms.v1.MappingRule.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The state of the mapping rule is unknown.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The rule is enabled.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    ENABLED(1),
    /**
     *
     *
     * <pre>
     * The rule is disabled.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    DISABLED(2),
    /**
     *
     *
     * <pre>
     * The rule is logically deleted.
     * </pre>
     *
     * <code>DELETED = 3;</code>
     */
    DELETED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The state of the mapping rule is unknown.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The rule is enabled.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    public static final int ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The rule is disabled.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    public static final int DISABLED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The rule is logically deleted.
     * </pre>
     *
     * <code>DELETED = 3;</code>
     */
    public static final int DELETED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return ENABLED;
        case 2:
          return DISABLED;
        case 3:
          return DELETED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.MappingRule.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.clouddms.v1.MappingRule.State)
  }

  private int bitField0_;
  private int detailsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object details_;

  public enum DetailsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SINGLE_ENTITY_RENAME(102),
    MULTI_ENTITY_RENAME(103),
    ENTITY_MOVE(105),
    SINGLE_COLUMN_CHANGE(106),
    MULTI_COLUMN_DATA_TYPE_CHANGE(107),
    CONDITIONAL_COLUMN_SET_VALUE(108),
    CONVERT_ROWID_COLUMN(114),
    SET_TABLE_PRIMARY_KEY(115),
    SINGLE_PACKAGE_CHANGE(116),
    SOURCE_SQL_CHANGE(117),
    FILTER_TABLE_COLUMNS(118),
    DETAILS_NOT_SET(0);
    private final int value;

    private DetailsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DetailsCase valueOf(int value) {
      return forNumber(value);
    }

    public static DetailsCase forNumber(int value) {
      switch (value) {
        case 102:
          return SINGLE_ENTITY_RENAME;
        case 103:
          return MULTI_ENTITY_RENAME;
        case 105:
          return ENTITY_MOVE;
        case 106:
          return SINGLE_COLUMN_CHANGE;
        case 107:
          return MULTI_COLUMN_DATA_TYPE_CHANGE;
        case 108:
          return CONDITIONAL_COLUMN_SET_VALUE;
        case 114:
          return CONVERT_ROWID_COLUMN;
        case 115:
          return SET_TABLE_PRIMARY_KEY;
        case 116:
          return SINGLE_PACKAGE_CHANGE;
        case 117:
          return SOURCE_SQL_CHANGE;
        case 118:
          return FILTER_TABLE_COLUMNS;
        case 0:
          return DETAILS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DetailsCase getDetailsCase() {
    return DetailsCase.forNumber(detailsCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Full name of the mapping rule resource, in the form of:
   * projects/{project}/locations/{location}/conversionWorkspaces/{set}/mappingRule/{rule}.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Full name of the mapping rule resource, in the form of:
   * projects/{project}/locations/{location}/conversionWorkspaces/{set}/mappingRule/{rule}.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A human readable name
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A human readable name
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 3;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The mapping rule state
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MappingRule.State state = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The mapping rule state
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MappingRule.State state = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MappingRule.State getState() {
    com.google.cloud.clouddms.v1.MappingRule.State result =
        com.google.cloud.clouddms.v1.MappingRule.State.forNumber(state_);
    return result == null ? com.google.cloud.clouddms.v1.MappingRule.State.UNRECOGNIZED : result;
  }

  public static final int RULE_SCOPE_FIELD_NUMBER = 4;
  private int ruleScope_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The rule scope
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.DatabaseEntityType rule_scope = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for ruleScope.
   */
  @java.lang.Override
  public int getRuleScopeValue() {
    return ruleScope_;
  }
  /**
   *
   *
   * <pre>
   * Required. The rule scope
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.DatabaseEntityType rule_scope = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The ruleScope.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DatabaseEntityType getRuleScope() {
    com.google.cloud.clouddms.v1.DatabaseEntityType result =
        com.google.cloud.clouddms.v1.DatabaseEntityType.forNumber(ruleScope_);
    return result == null ? com.google.cloud.clouddms.v1.DatabaseEntityType.UNRECOGNIZED : result;
  }

  public static final int FILTER_FIELD_NUMBER = 5;
  private com.google.cloud.clouddms.v1.MappingRuleFilter filter_;
  /**
   *
   *
   * <pre>
   * Required. The rule filter
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MappingRuleFilter filter = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the filter field is set.
   */
  @java.lang.Override
  public boolean hasFilter() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The rule filter
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MappingRuleFilter filter = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MappingRuleFilter getFilter() {
    return filter_ == null
        ? com.google.cloud.clouddms.v1.MappingRuleFilter.getDefaultInstance()
        : filter_;
  }
  /**
   *
   *
   * <pre>
   * Required. The rule filter
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MappingRuleFilter filter = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MappingRuleFilterOrBuilder getFilterOrBuilder() {
    return filter_ == null
        ? com.google.cloud.clouddms.v1.MappingRuleFilter.getDefaultInstance()
        : filter_;
  }

  public static final int RULE_ORDER_FIELD_NUMBER = 6;
  private long ruleOrder_ = 0L;
  /**
   *
   *
   * <pre>
   * Required. The order in which the rule is applied. Lower order rules are
   * applied before higher value rules so they may end up being overridden.
   * </pre>
   *
   * <code>int64 rule_order = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The ruleOrder.
   */
  @java.lang.Override
  public long getRuleOrder() {
    return ruleOrder_;
  }

  public static final int REVISION_ID_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object revisionId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The revision ID of the mapping rule.
   * A new revision is committed whenever the mapping rule is changed in any
   * way. The format is an 8-character hexadecimal string.
   * </pre>
   *
   * <code>string revision_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The revisionId.
   */
  @java.lang.Override
  public java.lang.String getRevisionId() {
    java.lang.Object ref = revisionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      revisionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The revision ID of the mapping rule.
   * A new revision is committed whenever the mapping rule is changed in any
   * way. The format is an 8-character hexadecimal string.
   * </pre>
   *
   * <code>string revision_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for revisionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRevisionIdBytes() {
    java.lang.Object ref = revisionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      revisionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REVISION_CREATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp revisionCreateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp that the revision was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp revision_create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the revisionCreateTime field is set.
   */
  @java.lang.Override
  public boolean hasRevisionCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp that the revision was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp revision_create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The revisionCreateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getRevisionCreateTime() {
    return revisionCreateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : revisionCreateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp that the revision was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp revision_create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getRevisionCreateTimeOrBuilder() {
    return revisionCreateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : revisionCreateTime_;
  }

  public static final int SINGLE_ENTITY_RENAME_FIELD_NUMBER = 102;
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how a single entity should be renamed.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SingleEntityRename single_entity_rename = 102 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the singleEntityRename field is set.
   */
  @java.lang.Override
  public boolean hasSingleEntityRename() {
    return detailsCase_ == 102;
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how a single entity should be renamed.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SingleEntityRename single_entity_rename = 102 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The singleEntityRename.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SingleEntityRename getSingleEntityRename() {
    if (detailsCase_ == 102) {
      return (com.google.cloud.clouddms.v1.SingleEntityRename) details_;
    }
    return com.google.cloud.clouddms.v1.SingleEntityRename.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how a single entity should be renamed.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SingleEntityRename single_entity_rename = 102 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SingleEntityRenameOrBuilder getSingleEntityRenameOrBuilder() {
    if (detailsCase_ == 102) {
      return (com.google.cloud.clouddms.v1.SingleEntityRename) details_;
    }
    return com.google.cloud.clouddms.v1.SingleEntityRename.getDefaultInstance();
  }

  public static final int MULTI_ENTITY_RENAME_FIELD_NUMBER = 103;
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how multiple entities should be renamed.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MultiEntityRename multi_entity_rename = 103 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the multiEntityRename field is set.
   */
  @java.lang.Override
  public boolean hasMultiEntityRename() {
    return detailsCase_ == 103;
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how multiple entities should be renamed.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MultiEntityRename multi_entity_rename = 103 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The multiEntityRename.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MultiEntityRename getMultiEntityRename() {
    if (detailsCase_ == 103) {
      return (com.google.cloud.clouddms.v1.MultiEntityRename) details_;
    }
    return com.google.cloud.clouddms.v1.MultiEntityRename.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how multiple entities should be renamed.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MultiEntityRename multi_entity_rename = 103 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MultiEntityRenameOrBuilder getMultiEntityRenameOrBuilder() {
    if (detailsCase_ == 103) {
      return (com.google.cloud.clouddms.v1.MultiEntityRename) details_;
    }
    return com.google.cloud.clouddms.v1.MultiEntityRename.getDefaultInstance();
  }

  public static final int ENTITY_MOVE_FIELD_NUMBER = 105;
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how multiple entities should be relocated into
   * a different schema.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.EntityMove entity_move = 105 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the entityMove field is set.
   */
  @java.lang.Override
  public boolean hasEntityMove() {
    return detailsCase_ == 105;
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how multiple entities should be relocated into
   * a different schema.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.EntityMove entity_move = 105 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The entityMove.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.EntityMove getEntityMove() {
    if (detailsCase_ == 105) {
      return (com.google.cloud.clouddms.v1.EntityMove) details_;
    }
    return com.google.cloud.clouddms.v1.EntityMove.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how multiple entities should be relocated into
   * a different schema.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.EntityMove entity_move = 105 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.EntityMoveOrBuilder getEntityMoveOrBuilder() {
    if (detailsCase_ == 105) {
      return (com.google.cloud.clouddms.v1.EntityMove) details_;
    }
    return com.google.cloud.clouddms.v1.EntityMove.getDefaultInstance();
  }

  public static final int SINGLE_COLUMN_CHANGE_FIELD_NUMBER = 106;
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how a single column is converted.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SingleColumnChange single_column_change = 106 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the singleColumnChange field is set.
   */
  @java.lang.Override
  public boolean hasSingleColumnChange() {
    return detailsCase_ == 106;
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how a single column is converted.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SingleColumnChange single_column_change = 106 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The singleColumnChange.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SingleColumnChange getSingleColumnChange() {
    if (detailsCase_ == 106) {
      return (com.google.cloud.clouddms.v1.SingleColumnChange) details_;
    }
    return com.google.cloud.clouddms.v1.SingleColumnChange.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how a single column is converted.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SingleColumnChange single_column_change = 106 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SingleColumnChangeOrBuilder getSingleColumnChangeOrBuilder() {
    if (detailsCase_ == 106) {
      return (com.google.cloud.clouddms.v1.SingleColumnChange) details_;
    }
    return com.google.cloud.clouddms.v1.SingleColumnChange.getDefaultInstance();
  }

  public static final int MULTI_COLUMN_DATA_TYPE_CHANGE_FIELD_NUMBER = 107;
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how multiple columns should be converted to a
   * different data type.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MultiColumnDatatypeChange multi_column_data_type_change = 107 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the multiColumnDataTypeChange field is set.
   */
  @java.lang.Override
  public boolean hasMultiColumnDataTypeChange() {
    return detailsCase_ == 107;
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how multiple columns should be converted to a
   * different data type.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MultiColumnDatatypeChange multi_column_data_type_change = 107 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The multiColumnDataTypeChange.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MultiColumnDatatypeChange getMultiColumnDataTypeChange() {
    if (detailsCase_ == 107) {
      return (com.google.cloud.clouddms.v1.MultiColumnDatatypeChange) details_;
    }
    return com.google.cloud.clouddms.v1.MultiColumnDatatypeChange.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how multiple columns should be converted to a
   * different data type.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MultiColumnDatatypeChange multi_column_data_type_change = 107 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MultiColumnDatatypeChangeOrBuilder
      getMultiColumnDataTypeChangeOrBuilder() {
    if (detailsCase_ == 107) {
      return (com.google.cloud.clouddms.v1.MultiColumnDatatypeChange) details_;
    }
    return com.google.cloud.clouddms.v1.MultiColumnDatatypeChange.getDefaultInstance();
  }

  public static final int CONDITIONAL_COLUMN_SET_VALUE_FIELD_NUMBER = 108;
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how the data contained in a column should be
   * transformed (such as trimmed, rounded, etc) provided that the data meets
   * certain criteria.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.ConditionalColumnSetValue conditional_column_set_value = 108 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the conditionalColumnSetValue field is set.
   */
  @java.lang.Override
  public boolean hasConditionalColumnSetValue() {
    return detailsCase_ == 108;
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how the data contained in a column should be
   * transformed (such as trimmed, rounded, etc) provided that the data meets
   * certain criteria.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.ConditionalColumnSetValue conditional_column_set_value = 108 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The conditionalColumnSetValue.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ConditionalColumnSetValue getConditionalColumnSetValue() {
    if (detailsCase_ == 108) {
      return (com.google.cloud.clouddms.v1.ConditionalColumnSetValue) details_;
    }
    return com.google.cloud.clouddms.v1.ConditionalColumnSetValue.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how the data contained in a column should be
   * transformed (such as trimmed, rounded, etc) provided that the data meets
   * certain criteria.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.ConditionalColumnSetValue conditional_column_set_value = 108 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ConditionalColumnSetValueOrBuilder
      getConditionalColumnSetValueOrBuilder() {
    if (detailsCase_ == 108) {
      return (com.google.cloud.clouddms.v1.ConditionalColumnSetValue) details_;
    }
    return com.google.cloud.clouddms.v1.ConditionalColumnSetValue.getDefaultInstance();
  }

  public static final int CONVERT_ROWID_COLUMN_FIELD_NUMBER = 114;
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how multiple tables should be converted with an
   * additional rowid column.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.ConvertRowIdToColumn convert_rowid_column = 114 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the convertRowidColumn field is set.
   */
  @java.lang.Override
  public boolean hasConvertRowidColumn() {
    return detailsCase_ == 114;
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how multiple tables should be converted with an
   * additional rowid column.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.ConvertRowIdToColumn convert_rowid_column = 114 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The convertRowidColumn.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ConvertRowIdToColumn getConvertRowidColumn() {
    if (detailsCase_ == 114) {
      return (com.google.cloud.clouddms.v1.ConvertRowIdToColumn) details_;
    }
    return com.google.cloud.clouddms.v1.ConvertRowIdToColumn.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how multiple tables should be converted with an
   * additional rowid column.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.ConvertRowIdToColumn convert_rowid_column = 114 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ConvertRowIdToColumnOrBuilder
      getConvertRowidColumnOrBuilder() {
    if (detailsCase_ == 114) {
      return (com.google.cloud.clouddms.v1.ConvertRowIdToColumn) details_;
    }
    return com.google.cloud.clouddms.v1.ConvertRowIdToColumn.getDefaultInstance();
  }

  public static final int SET_TABLE_PRIMARY_KEY_FIELD_NUMBER = 115;
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify the primary key for a table
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SetTablePrimaryKey set_table_primary_key = 115 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the setTablePrimaryKey field is set.
   */
  @java.lang.Override
  public boolean hasSetTablePrimaryKey() {
    return detailsCase_ == 115;
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify the primary key for a table
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SetTablePrimaryKey set_table_primary_key = 115 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The setTablePrimaryKey.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SetTablePrimaryKey getSetTablePrimaryKey() {
    if (detailsCase_ == 115) {
      return (com.google.cloud.clouddms.v1.SetTablePrimaryKey) details_;
    }
    return com.google.cloud.clouddms.v1.SetTablePrimaryKey.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify the primary key for a table
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SetTablePrimaryKey set_table_primary_key = 115 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SetTablePrimaryKeyOrBuilder getSetTablePrimaryKeyOrBuilder() {
    if (detailsCase_ == 115) {
      return (com.google.cloud.clouddms.v1.SetTablePrimaryKey) details_;
    }
    return com.google.cloud.clouddms.v1.SetTablePrimaryKey.getDefaultInstance();
  }

  public static final int SINGLE_PACKAGE_CHANGE_FIELD_NUMBER = 116;
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how a single package is converted.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SinglePackageChange single_package_change = 116 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the singlePackageChange field is set.
   */
  @java.lang.Override
  public boolean hasSinglePackageChange() {
    return detailsCase_ == 116;
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how a single package is converted.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SinglePackageChange single_package_change = 116 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The singlePackageChange.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SinglePackageChange getSinglePackageChange() {
    if (detailsCase_ == 116) {
      return (com.google.cloud.clouddms.v1.SinglePackageChange) details_;
    }
    return com.google.cloud.clouddms.v1.SinglePackageChange.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify how a single package is converted.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SinglePackageChange single_package_change = 116 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SinglePackageChangeOrBuilder
      getSinglePackageChangeOrBuilder() {
    if (detailsCase_ == 116) {
      return (com.google.cloud.clouddms.v1.SinglePackageChange) details_;
    }
    return com.google.cloud.clouddms.v1.SinglePackageChange.getDefaultInstance();
  }

  public static final int SOURCE_SQL_CHANGE_FIELD_NUMBER = 117;
  /**
   *
   *
   * <pre>
   * Optional. Rule to change the sql code for an entity, for example,
   * function, procedure.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SourceSqlChange source_sql_change = 117 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the sourceSqlChange field is set.
   */
  @java.lang.Override
  public boolean hasSourceSqlChange() {
    return detailsCase_ == 117;
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to change the sql code for an entity, for example,
   * function, procedure.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SourceSqlChange source_sql_change = 117 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The sourceSqlChange.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SourceSqlChange getSourceSqlChange() {
    if (detailsCase_ == 117) {
      return (com.google.cloud.clouddms.v1.SourceSqlChange) details_;
    }
    return com.google.cloud.clouddms.v1.SourceSqlChange.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to change the sql code for an entity, for example,
   * function, procedure.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SourceSqlChange source_sql_change = 117 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SourceSqlChangeOrBuilder getSourceSqlChangeOrBuilder() {
    if (detailsCase_ == 117) {
      return (com.google.cloud.clouddms.v1.SourceSqlChange) details_;
    }
    return com.google.cloud.clouddms.v1.SourceSqlChange.getDefaultInstance();
  }

  public static final int FILTER_TABLE_COLUMNS_FIELD_NUMBER = 118;
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify the list of columns to include or exclude from
   * a table.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.FilterTableColumns filter_table_columns = 118 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the filterTableColumns field is set.
   */
  @java.lang.Override
  public boolean hasFilterTableColumns() {
    return detailsCase_ == 118;
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify the list of columns to include or exclude from
   * a table.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.FilterTableColumns filter_table_columns = 118 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The filterTableColumns.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.FilterTableColumns getFilterTableColumns() {
    if (detailsCase_ == 118) {
      return (com.google.cloud.clouddms.v1.FilterTableColumns) details_;
    }
    return com.google.cloud.clouddms.v1.FilterTableColumns.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Rule to specify the list of columns to include or exclude from
   * a table.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.FilterTableColumns filter_table_columns = 118 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.FilterTableColumnsOrBuilder getFilterTableColumnsOrBuilder() {
    if (detailsCase_ == 118) {
      return (com.google.cloud.clouddms.v1.FilterTableColumns) details_;
    }
    return com.google.cloud.clouddms.v1.FilterTableColumns.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (state_ != com.google.cloud.clouddms.v1.MappingRule.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, state_);
    }
    if (ruleScope_
        != com.google.cloud.clouddms.v1.DatabaseEntityType.DATABASE_ENTITY_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, ruleScope_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getFilter());
    }
    if (ruleOrder_ != 0L) {
      output.writeInt64(6, ruleOrder_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(revisionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, revisionId_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getRevisionCreateTime());
    }
    if (detailsCase_ == 102) {
      output.writeMessage(102, (com.google.cloud.clouddms.v1.SingleEntityRename) details_);
    }
    if (detailsCase_ == 103) {
      output.writeMessage(103, (com.google.cloud.clouddms.v1.MultiEntityRename) details_);
    }
    if (detailsCase_ == 105) {
      output.writeMessage(105, (com.google.cloud.clouddms.v1.EntityMove) details_);
    }
    if (detailsCase_ == 106) {
      output.writeMessage(106, (com.google.cloud.clouddms.v1.SingleColumnChange) details_);
    }
    if (detailsCase_ == 107) {
      output.writeMessage(107, (com.google.cloud.clouddms.v1.MultiColumnDatatypeChange) details_);
    }
    if (detailsCase_ == 108) {
      output.writeMessage(108, (com.google.cloud.clouddms.v1.ConditionalColumnSetValue) details_);
    }
    if (detailsCase_ == 114) {
      output.writeMessage(114, (com.google.cloud.clouddms.v1.ConvertRowIdToColumn) details_);
    }
    if (detailsCase_ == 115) {
      output.writeMessage(115, (com.google.cloud.clouddms.v1.SetTablePrimaryKey) details_);
    }
    if (detailsCase_ == 116) {
      output.writeMessage(116, (com.google.cloud.clouddms.v1.SinglePackageChange) details_);
    }
    if (detailsCase_ == 117) {
      output.writeMessage(117, (com.google.cloud.clouddms.v1.SourceSqlChange) details_);
    }
    if (detailsCase_ == 118) {
      output.writeMessage(118, (com.google.cloud.clouddms.v1.FilterTableColumns) details_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (state_ != com.google.cloud.clouddms.v1.MappingRule.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
    }
    if (ruleScope_
        != com.google.cloud.clouddms.v1.DatabaseEntityType.DATABASE_ENTITY_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, ruleScope_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getFilter());
    }
    if (ruleOrder_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, ruleOrder_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(revisionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, revisionId_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getRevisionCreateTime());
    }
    if (detailsCase_ == 102) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              102, (com.google.cloud.clouddms.v1.SingleEntityRename) details_);
    }
    if (detailsCase_ == 103) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              103, (com.google.cloud.clouddms.v1.MultiEntityRename) details_);
    }
    if (detailsCase_ == 105) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              105, (com.google.cloud.clouddms.v1.EntityMove) details_);
    }
    if (detailsCase_ == 106) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              106, (com.google.cloud.clouddms.v1.SingleColumnChange) details_);
    }
    if (detailsCase_ == 107) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              107, (com.google.cloud.clouddms.v1.MultiColumnDatatypeChange) details_);
    }
    if (detailsCase_ == 108) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              108, (com.google.cloud.clouddms.v1.ConditionalColumnSetValue) details_);
    }
    if (detailsCase_ == 114) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              114, (com.google.cloud.clouddms.v1.ConvertRowIdToColumn) details_);
    }
    if (detailsCase_ == 115) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              115, (com.google.cloud.clouddms.v1.SetTablePrimaryKey) details_);
    }
    if (detailsCase_ == 116) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              116, (com.google.cloud.clouddms.v1.SinglePackageChange) details_);
    }
    if (detailsCase_ == 117) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              117, (com.google.cloud.clouddms.v1.SourceSqlChange) details_);
    }
    if (detailsCase_ == 118) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              118, (com.google.cloud.clouddms.v1.FilterTableColumns) details_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.MappingRule)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.MappingRule other = (com.google.cloud.clouddms.v1.MappingRule) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (state_ != other.state_) return false;
    if (ruleScope_ != other.ruleScope_) return false;
    if (hasFilter() != other.hasFilter()) return false;
    if (hasFilter()) {
      if (!getFilter().equals(other.getFilter())) return false;
    }
    if (getRuleOrder() != other.getRuleOrder()) return false;
    if (!getRevisionId().equals(other.getRevisionId())) return false;
    if (hasRevisionCreateTime() != other.hasRevisionCreateTime()) return false;
    if (hasRevisionCreateTime()) {
      if (!getRevisionCreateTime().equals(other.getRevisionCreateTime())) return false;
    }
    if (!getDetailsCase().equals(other.getDetailsCase())) return false;
    switch (detailsCase_) {
      case 102:
        if (!getSingleEntityRename().equals(other.getSingleEntityRename())) return false;
        break;
      case 103:
        if (!getMultiEntityRename().equals(other.getMultiEntityRename())) return false;
        break;
      case 105:
        if (!getEntityMove().equals(other.getEntityMove())) return false;
        break;
      case 106:
        if (!getSingleColumnChange().equals(other.getSingleColumnChange())) return false;
        break;
      case 107:
        if (!getMultiColumnDataTypeChange().equals(other.getMultiColumnDataTypeChange()))
          return false;
        break;
      case 108:
        if (!getConditionalColumnSetValue().equals(other.getConditionalColumnSetValue()))
          return false;
        break;
      case 114:
        if (!getConvertRowidColumn().equals(other.getConvertRowidColumn())) return false;
        break;
      case 115:
        if (!getSetTablePrimaryKey().equals(other.getSetTablePrimaryKey())) return false;
        break;
      case 116:
        if (!getSinglePackageChange().equals(other.getSinglePackageChange())) return false;
        break;
      case 117:
        if (!getSourceSqlChange().equals(other.getSourceSqlChange())) return false;
        break;
      case 118:
        if (!getFilterTableColumns().equals(other.getFilterTableColumns())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + RULE_SCOPE_FIELD_NUMBER;
    hash = (53 * hash) + ruleScope_;
    if (hasFilter()) {
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
    }
    hash = (37 * hash) + RULE_ORDER_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRuleOrder());
    hash = (37 * hash) + REVISION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRevisionId().hashCode();
    if (hasRevisionCreateTime()) {
      hash = (37 * hash) + REVISION_CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getRevisionCreateTime().hashCode();
    }
    switch (detailsCase_) {
      case 102:
        hash = (37 * hash) + SINGLE_ENTITY_RENAME_FIELD_NUMBER;
        hash = (53 * hash) + getSingleEntityRename().hashCode();
        break;
      case 103:
        hash = (37 * hash) + MULTI_ENTITY_RENAME_FIELD_NUMBER;
        hash = (53 * hash) + getMultiEntityRename().hashCode();
        break;
      case 105:
        hash = (37 * hash) + ENTITY_MOVE_FIELD_NUMBER;
        hash = (53 * hash) + getEntityMove().hashCode();
        break;
      case 106:
        hash = (37 * hash) + SINGLE_COLUMN_CHANGE_FIELD_NUMBER;
        hash = (53 * hash) + getSingleColumnChange().hashCode();
        break;
      case 107:
        hash = (37 * hash) + MULTI_COLUMN_DATA_TYPE_CHANGE_FIELD_NUMBER;
        hash = (53 * hash) + getMultiColumnDataTypeChange().hashCode();
        break;
      case 108:
        hash = (37 * hash) + CONDITIONAL_COLUMN_SET_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getConditionalColumnSetValue().hashCode();
        break;
      case 114:
        hash = (37 * hash) + CONVERT_ROWID_COLUMN_FIELD_NUMBER;
        hash = (53 * hash) + getConvertRowidColumn().hashCode();
        break;
      case 115:
        hash = (37 * hash) + SET_TABLE_PRIMARY_KEY_FIELD_NUMBER;
        hash = (53 * hash) + getSetTablePrimaryKey().hashCode();
        break;
      case 116:
        hash = (37 * hash) + SINGLE_PACKAGE_CHANGE_FIELD_NUMBER;
        hash = (53 * hash) + getSinglePackageChange().hashCode();
        break;
      case 117:
        hash = (37 * hash) + SOURCE_SQL_CHANGE_FIELD_NUMBER;
        hash = (53 * hash) + getSourceSqlChange().hashCode();
        break;
      case 118:
        hash = (37 * hash) + FILTER_TABLE_COLUMNS_FIELD_NUMBER;
        hash = (53 * hash) + getFilterTableColumns().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.MappingRule parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.MappingRule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MappingRule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.MappingRule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MappingRule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.MappingRule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MappingRule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.MappingRule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MappingRule parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.MappingRule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MappingRule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.MappingRule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.MappingRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Definition of a transformation that is to be applied to a group of entities
   * in the source schema. Several such transformations can be applied to an
   * entity sequentially to define the corresponding entity in the target schema.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.MappingRule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.MappingRule)
      com.google.cloud.clouddms.v1.MappingRuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_MappingRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_MappingRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.MappingRule.class,
              com.google.cloud.clouddms.v1.MappingRule.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.MappingRule.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFilterFieldBuilder();
        getRevisionCreateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      state_ = 0;
      ruleScope_ = 0;
      filter_ = null;
      if (filterBuilder_ != null) {
        filterBuilder_.dispose();
        filterBuilder_ = null;
      }
      ruleOrder_ = 0L;
      revisionId_ = "";
      revisionCreateTime_ = null;
      if (revisionCreateTimeBuilder_ != null) {
        revisionCreateTimeBuilder_.dispose();
        revisionCreateTimeBuilder_ = null;
      }
      if (singleEntityRenameBuilder_ != null) {
        singleEntityRenameBuilder_.clear();
      }
      if (multiEntityRenameBuilder_ != null) {
        multiEntityRenameBuilder_.clear();
      }
      if (entityMoveBuilder_ != null) {
        entityMoveBuilder_.clear();
      }
      if (singleColumnChangeBuilder_ != null) {
        singleColumnChangeBuilder_.clear();
      }
      if (multiColumnDataTypeChangeBuilder_ != null) {
        multiColumnDataTypeChangeBuilder_.clear();
      }
      if (conditionalColumnSetValueBuilder_ != null) {
        conditionalColumnSetValueBuilder_.clear();
      }
      if (convertRowidColumnBuilder_ != null) {
        convertRowidColumnBuilder_.clear();
      }
      if (setTablePrimaryKeyBuilder_ != null) {
        setTablePrimaryKeyBuilder_.clear();
      }
      if (singlePackageChangeBuilder_ != null) {
        singlePackageChangeBuilder_.clear();
      }
      if (sourceSqlChangeBuilder_ != null) {
        sourceSqlChangeBuilder_.clear();
      }
      if (filterTableColumnsBuilder_ != null) {
        filterTableColumnsBuilder_.clear();
      }
      detailsCase_ = 0;
      details_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_MappingRule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MappingRule getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.MappingRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MappingRule build() {
      com.google.cloud.clouddms.v1.MappingRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MappingRule buildPartial() {
      com.google.cloud.clouddms.v1.MappingRule result =
          new com.google.cloud.clouddms.v1.MappingRule(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.MappingRule result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.ruleScope_ = ruleScope_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.filter_ = filterBuilder_ == null ? filter_ : filterBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.ruleOrder_ = ruleOrder_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.revisionId_ = revisionId_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.revisionCreateTime_ =
            revisionCreateTimeBuilder_ == null
                ? revisionCreateTime_
                : revisionCreateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.clouddms.v1.MappingRule result) {
      result.detailsCase_ = detailsCase_;
      result.details_ = this.details_;
      if (detailsCase_ == 102 && singleEntityRenameBuilder_ != null) {
        result.details_ = singleEntityRenameBuilder_.build();
      }
      if (detailsCase_ == 103 && multiEntityRenameBuilder_ != null) {
        result.details_ = multiEntityRenameBuilder_.build();
      }
      if (detailsCase_ == 105 && entityMoveBuilder_ != null) {
        result.details_ = entityMoveBuilder_.build();
      }
      if (detailsCase_ == 106 && singleColumnChangeBuilder_ != null) {
        result.details_ = singleColumnChangeBuilder_.build();
      }
      if (detailsCase_ == 107 && multiColumnDataTypeChangeBuilder_ != null) {
        result.details_ = multiColumnDataTypeChangeBuilder_.build();
      }
      if (detailsCase_ == 108 && conditionalColumnSetValueBuilder_ != null) {
        result.details_ = conditionalColumnSetValueBuilder_.build();
      }
      if (detailsCase_ == 114 && convertRowidColumnBuilder_ != null) {
        result.details_ = convertRowidColumnBuilder_.build();
      }
      if (detailsCase_ == 115 && setTablePrimaryKeyBuilder_ != null) {
        result.details_ = setTablePrimaryKeyBuilder_.build();
      }
      if (detailsCase_ == 116 && singlePackageChangeBuilder_ != null) {
        result.details_ = singlePackageChangeBuilder_.build();
      }
      if (detailsCase_ == 117 && sourceSqlChangeBuilder_ != null) {
        result.details_ = sourceSqlChangeBuilder_.build();
      }
      if (detailsCase_ == 118 && filterTableColumnsBuilder_ != null) {
        result.details_ = filterTableColumnsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.MappingRule) {
        return mergeFrom((com.google.cloud.clouddms.v1.MappingRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.MappingRule other) {
      if (other == com.google.cloud.clouddms.v1.MappingRule.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.ruleScope_ != 0) {
        setRuleScopeValue(other.getRuleScopeValue());
      }
      if (other.hasFilter()) {
        mergeFilter(other.getFilter());
      }
      if (other.getRuleOrder() != 0L) {
        setRuleOrder(other.getRuleOrder());
      }
      if (!other.getRevisionId().isEmpty()) {
        revisionId_ = other.revisionId_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasRevisionCreateTime()) {
        mergeRevisionCreateTime(other.getRevisionCreateTime());
      }
      switch (other.getDetailsCase()) {
        case SINGLE_ENTITY_RENAME:
          {
            mergeSingleEntityRename(other.getSingleEntityRename());
            break;
          }
        case MULTI_ENTITY_RENAME:
          {
            mergeMultiEntityRename(other.getMultiEntityRename());
            break;
          }
        case ENTITY_MOVE:
          {
            mergeEntityMove(other.getEntityMove());
            break;
          }
        case SINGLE_COLUMN_CHANGE:
          {
            mergeSingleColumnChange(other.getSingleColumnChange());
            break;
          }
        case MULTI_COLUMN_DATA_TYPE_CHANGE:
          {
            mergeMultiColumnDataTypeChange(other.getMultiColumnDataTypeChange());
            break;
          }
        case CONDITIONAL_COLUMN_SET_VALUE:
          {
            mergeConditionalColumnSetValue(other.getConditionalColumnSetValue());
            break;
          }
        case CONVERT_ROWID_COLUMN:
          {
            mergeConvertRowidColumn(other.getConvertRowidColumn());
            break;
          }
        case SET_TABLE_PRIMARY_KEY:
          {
            mergeSetTablePrimaryKey(other.getSetTablePrimaryKey());
            break;
          }
        case SINGLE_PACKAGE_CHANGE:
          {
            mergeSinglePackageChange(other.getSinglePackageChange());
            break;
          }
        case SOURCE_SQL_CHANGE:
          {
            mergeSourceSqlChange(other.getSourceSqlChange());
            break;
          }
        case FILTER_TABLE_COLUMNS:
          {
            mergeFilterTableColumns(other.getFilterTableColumns());
            break;
          }
        case DETAILS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                ruleScope_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getFilterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                ruleOrder_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                revisionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getRevisionCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 818:
              {
                input.readMessage(
                    getSingleEntityRenameFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 102;
                break;
              } // case 818
            case 826:
              {
                input.readMessage(
                    getMultiEntityRenameFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 103;
                break;
              } // case 826
            case 842:
              {
                input.readMessage(getEntityMoveFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 105;
                break;
              } // case 842
            case 850:
              {
                input.readMessage(
                    getSingleColumnChangeFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 106;
                break;
              } // case 850
            case 858:
              {
                input.readMessage(
                    getMultiColumnDataTypeChangeFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 107;
                break;
              } // case 858
            case 866:
              {
                input.readMessage(
                    getConditionalColumnSetValueFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 108;
                break;
              } // case 866
            case 914:
              {
                input.readMessage(
                    getConvertRowidColumnFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 114;
                break;
              } // case 914
            case 922:
              {
                input.readMessage(
                    getSetTablePrimaryKeyFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 115;
                break;
              } // case 922
            case 930:
              {
                input.readMessage(
                    getSinglePackageChangeFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 116;
                break;
              } // case 930
            case 938:
              {
                input.readMessage(getSourceSqlChangeFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 117;
                break;
              } // case 938
            case 946:
              {
                input.readMessage(
                    getFilterTableColumnsFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 118;
                break;
              } // case 946
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int detailsCase_ = 0;
    private java.lang.Object details_;

    public DetailsCase getDetailsCase() {
      return DetailsCase.forNumber(detailsCase_);
    }

    public Builder clearDetails() {
      detailsCase_ = 0;
      details_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Full name of the mapping rule resource, in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{set}/mappingRule/{rule}.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Full name of the mapping rule resource, in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{set}/mappingRule/{rule}.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Full name of the mapping rule resource, in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{set}/mappingRule/{rule}.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Full name of the mapping rule resource, in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{set}/mappingRule/{rule}.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Full name of the mapping rule resource, in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{set}/mappingRule/{rule}.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A human readable name
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A human readable name
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A human readable name
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A human readable name
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A human readable name
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The mapping rule state
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MappingRule.State state = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The mapping rule state
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MappingRule.State state = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The mapping rule state
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MappingRule.State state = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.MappingRule.State getState() {
      com.google.cloud.clouddms.v1.MappingRule.State result =
          com.google.cloud.clouddms.v1.MappingRule.State.forNumber(state_);
      return result == null ? com.google.cloud.clouddms.v1.MappingRule.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The mapping rule state
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MappingRule.State state = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.clouddms.v1.MappingRule.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The mapping rule state
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MappingRule.State state = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      state_ = 0;
      onChanged();
      return this;
    }

    private int ruleScope_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The rule scope
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEntityType rule_scope = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for ruleScope.
     */
    @java.lang.Override
    public int getRuleScopeValue() {
      return ruleScope_;
    }
    /**
     *
     *
     * <pre>
     * Required. The rule scope
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEntityType rule_scope = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for ruleScope to set.
     * @return This builder for chaining.
     */
    public Builder setRuleScopeValue(int value) {
      ruleScope_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The rule scope
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEntityType rule_scope = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The ruleScope.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.DatabaseEntityType getRuleScope() {
      com.google.cloud.clouddms.v1.DatabaseEntityType result =
          com.google.cloud.clouddms.v1.DatabaseEntityType.forNumber(ruleScope_);
      return result == null ? com.google.cloud.clouddms.v1.DatabaseEntityType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The rule scope
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEntityType rule_scope = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The ruleScope to set.
     * @return This builder for chaining.
     */
    public Builder setRuleScope(com.google.cloud.clouddms.v1.DatabaseEntityType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      ruleScope_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The rule scope
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DatabaseEntityType rule_scope = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRuleScope() {
      bitField0_ = (bitField0_ & ~0x00000008);
      ruleScope_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.clouddms.v1.MappingRuleFilter filter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.MappingRuleFilter,
            com.google.cloud.clouddms.v1.MappingRuleFilter.Builder,
            com.google.cloud.clouddms.v1.MappingRuleFilterOrBuilder>
        filterBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The rule filter
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MappingRuleFilter filter = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the filter field is set.
     */
    public boolean hasFilter() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The rule filter
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MappingRuleFilter filter = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The filter.
     */
    public com.google.cloud.clouddms.v1.MappingRuleFilter getFilter() {
      if (filterBuilder_ == null) {
        return filter_ == null
            ? com.google.cloud.clouddms.v1.MappingRuleFilter.getDefaultInstance()
            : filter_;
      } else {
        return filterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The rule filter
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MappingRuleFilter filter = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setFilter(com.google.cloud.clouddms.v1.MappingRuleFilter value) {
      if (filterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
      } else {
        filterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The rule filter
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MappingRuleFilter filter = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setFilter(
        com.google.cloud.clouddms.v1.MappingRuleFilter.Builder builderForValue) {
      if (filterBuilder_ == null) {
        filter_ = builderForValue.build();
      } else {
        filterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The rule filter
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MappingRuleFilter filter = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeFilter(com.google.cloud.clouddms.v1.MappingRuleFilter value) {
      if (filterBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && filter_ != null
            && filter_ != com.google.cloud.clouddms.v1.MappingRuleFilter.getDefaultInstance()) {
          getFilterBuilder().mergeFrom(value);
        } else {
          filter_ = value;
        }
      } else {
        filterBuilder_.mergeFrom(value);
      }
      if (filter_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The rule filter
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MappingRuleFilter filter = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearFilter() {
      bitField0_ = (bitField0_ & ~0x00000010);
      filter_ = null;
      if (filterBuilder_ != null) {
        filterBuilder_.dispose();
        filterBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The rule filter
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MappingRuleFilter filter = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.clouddms.v1.MappingRuleFilter.Builder getFilterBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The rule filter
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MappingRuleFilter filter = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.clouddms.v1.MappingRuleFilterOrBuilder getFilterOrBuilder() {
      if (filterBuilder_ != null) {
        return filterBuilder_.getMessageOrBuilder();
      } else {
        return filter_ == null
            ? com.google.cloud.clouddms.v1.MappingRuleFilter.getDefaultInstance()
            : filter_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The rule filter
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MappingRuleFilter filter = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.MappingRuleFilter,
            com.google.cloud.clouddms.v1.MappingRuleFilter.Builder,
            com.google.cloud.clouddms.v1.MappingRuleFilterOrBuilder>
        getFilterFieldBuilder() {
      if (filterBuilder_ == null) {
        filterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.MappingRuleFilter,
                com.google.cloud.clouddms.v1.MappingRuleFilter.Builder,
                com.google.cloud.clouddms.v1.MappingRuleFilterOrBuilder>(
                getFilter(), getParentForChildren(), isClean());
        filter_ = null;
      }
      return filterBuilder_;
    }

    private long ruleOrder_;
    /**
     *
     *
     * <pre>
     * Required. The order in which the rule is applied. Lower order rules are
     * applied before higher value rules so they may end up being overridden.
     * </pre>
     *
     * <code>int64 rule_order = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The ruleOrder.
     */
    @java.lang.Override
    public long getRuleOrder() {
      return ruleOrder_;
    }
    /**
     *
     *
     * <pre>
     * Required. The order in which the rule is applied. Lower order rules are
     * applied before higher value rules so they may end up being overridden.
     * </pre>
     *
     * <code>int64 rule_order = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The ruleOrder to set.
     * @return This builder for chaining.
     */
    public Builder setRuleOrder(long value) {

      ruleOrder_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The order in which the rule is applied. Lower order rules are
     * applied before higher value rules so they may end up being overridden.
     * </pre>
     *
     * <code>int64 rule_order = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRuleOrder() {
      bitField0_ = (bitField0_ & ~0x00000020);
      ruleOrder_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object revisionId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The revision ID of the mapping rule.
     * A new revision is committed whenever the mapping rule is changed in any
     * way. The format is an 8-character hexadecimal string.
     * </pre>
     *
     * <code>string revision_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The revisionId.
     */
    public java.lang.String getRevisionId() {
      java.lang.Object ref = revisionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        revisionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The revision ID of the mapping rule.
     * A new revision is committed whenever the mapping rule is changed in any
     * way. The format is an 8-character hexadecimal string.
     * </pre>
     *
     * <code>string revision_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for revisionId.
     */
    public com.google.protobuf.ByteString getRevisionIdBytes() {
      java.lang.Object ref = revisionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        revisionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The revision ID of the mapping rule.
     * A new revision is committed whenever the mapping rule is changed in any
     * way. The format is an 8-character hexadecimal string.
     * </pre>
     *
     * <code>string revision_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The revisionId to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      revisionId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The revision ID of the mapping rule.
     * A new revision is committed whenever the mapping rule is changed in any
     * way. The format is an 8-character hexadecimal string.
     * </pre>
     *
     * <code>string revision_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRevisionId() {
      revisionId_ = getDefaultInstance().getRevisionId();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The revision ID of the mapping rule.
     * A new revision is committed whenever the mapping rule is changed in any
     * way. The format is an 8-character hexadecimal string.
     * </pre>
     *
     * <code>string revision_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for revisionId to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      revisionId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp revisionCreateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        revisionCreateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the revisionCreateTime field is set.
     */
    public boolean hasRevisionCreateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The revisionCreateTime.
     */
    public com.google.protobuf.Timestamp getRevisionCreateTime() {
      if (revisionCreateTimeBuilder_ == null) {
        return revisionCreateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : revisionCreateTime_;
      } else {
        return revisionCreateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRevisionCreateTime(com.google.protobuf.Timestamp value) {
      if (revisionCreateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        revisionCreateTime_ = value;
      } else {
        revisionCreateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRevisionCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (revisionCreateTimeBuilder_ == null) {
        revisionCreateTime_ = builderForValue.build();
      } else {
        revisionCreateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRevisionCreateTime(com.google.protobuf.Timestamp value) {
      if (revisionCreateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && revisionCreateTime_ != null
            && revisionCreateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getRevisionCreateTimeBuilder().mergeFrom(value);
        } else {
          revisionCreateTime_ = value;
        }
      } else {
        revisionCreateTimeBuilder_.mergeFrom(value);
      }
      if (revisionCreateTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRevisionCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      revisionCreateTime_ = null;
      if (revisionCreateTimeBuilder_ != null) {
        revisionCreateTimeBuilder_.dispose();
        revisionCreateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getRevisionCreateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getRevisionCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getRevisionCreateTimeOrBuilder() {
      if (revisionCreateTimeBuilder_ != null) {
        return revisionCreateTimeBuilder_.getMessageOrBuilder();
      } else {
        return revisionCreateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : revisionCreateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getRevisionCreateTimeFieldBuilder() {
      if (revisionCreateTimeBuilder_ == null) {
        revisionCreateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getRevisionCreateTime(), getParentForChildren(), isClean());
        revisionCreateTime_ = null;
      }
      return revisionCreateTimeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SingleEntityRename,
            com.google.cloud.clouddms.v1.SingleEntityRename.Builder,
            com.google.cloud.clouddms.v1.SingleEntityRenameOrBuilder>
        singleEntityRenameBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single entity should be renamed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SingleEntityRename single_entity_rename = 102 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the singleEntityRename field is set.
     */
    @java.lang.Override
    public boolean hasSingleEntityRename() {
      return detailsCase_ == 102;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single entity should be renamed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SingleEntityRename single_entity_rename = 102 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The singleEntityRename.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SingleEntityRename getSingleEntityRename() {
      if (singleEntityRenameBuilder_ == null) {
        if (detailsCase_ == 102) {
          return (com.google.cloud.clouddms.v1.SingleEntityRename) details_;
        }
        return com.google.cloud.clouddms.v1.SingleEntityRename.getDefaultInstance();
      } else {
        if (detailsCase_ == 102) {
          return singleEntityRenameBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.SingleEntityRename.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single entity should be renamed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SingleEntityRename single_entity_rename = 102 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSingleEntityRename(com.google.cloud.clouddms.v1.SingleEntityRename value) {
      if (singleEntityRenameBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        singleEntityRenameBuilder_.setMessage(value);
      }
      detailsCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single entity should be renamed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SingleEntityRename single_entity_rename = 102 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSingleEntityRename(
        com.google.cloud.clouddms.v1.SingleEntityRename.Builder builderForValue) {
      if (singleEntityRenameBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        singleEntityRenameBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single entity should be renamed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SingleEntityRename single_entity_rename = 102 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSingleEntityRename(com.google.cloud.clouddms.v1.SingleEntityRename value) {
      if (singleEntityRenameBuilder_ == null) {
        if (detailsCase_ == 102
            && details_ != com.google.cloud.clouddms.v1.SingleEntityRename.getDefaultInstance()) {
          details_ =
              com.google.cloud.clouddms.v1.SingleEntityRename.newBuilder(
                      (com.google.cloud.clouddms.v1.SingleEntityRename) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 102) {
          singleEntityRenameBuilder_.mergeFrom(value);
        } else {
          singleEntityRenameBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single entity should be renamed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SingleEntityRename single_entity_rename = 102 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSingleEntityRename() {
      if (singleEntityRenameBuilder_ == null) {
        if (detailsCase_ == 102) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 102) {
          detailsCase_ = 0;
          details_ = null;
        }
        singleEntityRenameBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single entity should be renamed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SingleEntityRename single_entity_rename = 102 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.SingleEntityRename.Builder getSingleEntityRenameBuilder() {
      return getSingleEntityRenameFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single entity should be renamed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SingleEntityRename single_entity_rename = 102 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SingleEntityRenameOrBuilder
        getSingleEntityRenameOrBuilder() {
      if ((detailsCase_ == 102) && (singleEntityRenameBuilder_ != null)) {
        return singleEntityRenameBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 102) {
          return (com.google.cloud.clouddms.v1.SingleEntityRename) details_;
        }
        return com.google.cloud.clouddms.v1.SingleEntityRename.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single entity should be renamed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SingleEntityRename single_entity_rename = 102 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SingleEntityRename,
            com.google.cloud.clouddms.v1.SingleEntityRename.Builder,
            com.google.cloud.clouddms.v1.SingleEntityRenameOrBuilder>
        getSingleEntityRenameFieldBuilder() {
      if (singleEntityRenameBuilder_ == null) {
        if (!(detailsCase_ == 102)) {
          details_ = com.google.cloud.clouddms.v1.SingleEntityRename.getDefaultInstance();
        }
        singleEntityRenameBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.SingleEntityRename,
                com.google.cloud.clouddms.v1.SingleEntityRename.Builder,
                com.google.cloud.clouddms.v1.SingleEntityRenameOrBuilder>(
                (com.google.cloud.clouddms.v1.SingleEntityRename) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 102;
      onChanged();
      return singleEntityRenameBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.MultiEntityRename,
            com.google.cloud.clouddms.v1.MultiEntityRename.Builder,
            com.google.cloud.clouddms.v1.MultiEntityRenameOrBuilder>
        multiEntityRenameBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple entities should be renamed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MultiEntityRename multi_entity_rename = 103 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the multiEntityRename field is set.
     */
    @java.lang.Override
    public boolean hasMultiEntityRename() {
      return detailsCase_ == 103;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple entities should be renamed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MultiEntityRename multi_entity_rename = 103 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The multiEntityRename.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.MultiEntityRename getMultiEntityRename() {
      if (multiEntityRenameBuilder_ == null) {
        if (detailsCase_ == 103) {
          return (com.google.cloud.clouddms.v1.MultiEntityRename) details_;
        }
        return com.google.cloud.clouddms.v1.MultiEntityRename.getDefaultInstance();
      } else {
        if (detailsCase_ == 103) {
          return multiEntityRenameBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.MultiEntityRename.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple entities should be renamed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MultiEntityRename multi_entity_rename = 103 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMultiEntityRename(com.google.cloud.clouddms.v1.MultiEntityRename value) {
      if (multiEntityRenameBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        multiEntityRenameBuilder_.setMessage(value);
      }
      detailsCase_ = 103;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple entities should be renamed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MultiEntityRename multi_entity_rename = 103 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMultiEntityRename(
        com.google.cloud.clouddms.v1.MultiEntityRename.Builder builderForValue) {
      if (multiEntityRenameBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        multiEntityRenameBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 103;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple entities should be renamed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MultiEntityRename multi_entity_rename = 103 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMultiEntityRename(com.google.cloud.clouddms.v1.MultiEntityRename value) {
      if (multiEntityRenameBuilder_ == null) {
        if (detailsCase_ == 103
            && details_ != com.google.cloud.clouddms.v1.MultiEntityRename.getDefaultInstance()) {
          details_ =
              com.google.cloud.clouddms.v1.MultiEntityRename.newBuilder(
                      (com.google.cloud.clouddms.v1.MultiEntityRename) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 103) {
          multiEntityRenameBuilder_.mergeFrom(value);
        } else {
          multiEntityRenameBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 103;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple entities should be renamed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MultiEntityRename multi_entity_rename = 103 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMultiEntityRename() {
      if (multiEntityRenameBuilder_ == null) {
        if (detailsCase_ == 103) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 103) {
          detailsCase_ = 0;
          details_ = null;
        }
        multiEntityRenameBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple entities should be renamed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MultiEntityRename multi_entity_rename = 103 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.MultiEntityRename.Builder getMultiEntityRenameBuilder() {
      return getMultiEntityRenameFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple entities should be renamed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MultiEntityRename multi_entity_rename = 103 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.MultiEntityRenameOrBuilder getMultiEntityRenameOrBuilder() {
      if ((detailsCase_ == 103) && (multiEntityRenameBuilder_ != null)) {
        return multiEntityRenameBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 103) {
          return (com.google.cloud.clouddms.v1.MultiEntityRename) details_;
        }
        return com.google.cloud.clouddms.v1.MultiEntityRename.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple entities should be renamed.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MultiEntityRename multi_entity_rename = 103 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.MultiEntityRename,
            com.google.cloud.clouddms.v1.MultiEntityRename.Builder,
            com.google.cloud.clouddms.v1.MultiEntityRenameOrBuilder>
        getMultiEntityRenameFieldBuilder() {
      if (multiEntityRenameBuilder_ == null) {
        if (!(detailsCase_ == 103)) {
          details_ = com.google.cloud.clouddms.v1.MultiEntityRename.getDefaultInstance();
        }
        multiEntityRenameBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.MultiEntityRename,
                com.google.cloud.clouddms.v1.MultiEntityRename.Builder,
                com.google.cloud.clouddms.v1.MultiEntityRenameOrBuilder>(
                (com.google.cloud.clouddms.v1.MultiEntityRename) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 103;
      onChanged();
      return multiEntityRenameBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.EntityMove,
            com.google.cloud.clouddms.v1.EntityMove.Builder,
            com.google.cloud.clouddms.v1.EntityMoveOrBuilder>
        entityMoveBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple entities should be relocated into
     * a different schema.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.EntityMove entity_move = 105 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the entityMove field is set.
     */
    @java.lang.Override
    public boolean hasEntityMove() {
      return detailsCase_ == 105;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple entities should be relocated into
     * a different schema.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.EntityMove entity_move = 105 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The entityMove.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.EntityMove getEntityMove() {
      if (entityMoveBuilder_ == null) {
        if (detailsCase_ == 105) {
          return (com.google.cloud.clouddms.v1.EntityMove) details_;
        }
        return com.google.cloud.clouddms.v1.EntityMove.getDefaultInstance();
      } else {
        if (detailsCase_ == 105) {
          return entityMoveBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.EntityMove.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple entities should be relocated into
     * a different schema.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.EntityMove entity_move = 105 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEntityMove(com.google.cloud.clouddms.v1.EntityMove value) {
      if (entityMoveBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        entityMoveBuilder_.setMessage(value);
      }
      detailsCase_ = 105;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple entities should be relocated into
     * a different schema.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.EntityMove entity_move = 105 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEntityMove(com.google.cloud.clouddms.v1.EntityMove.Builder builderForValue) {
      if (entityMoveBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        entityMoveBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 105;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple entities should be relocated into
     * a different schema.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.EntityMove entity_move = 105 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEntityMove(com.google.cloud.clouddms.v1.EntityMove value) {
      if (entityMoveBuilder_ == null) {
        if (detailsCase_ == 105
            && details_ != com.google.cloud.clouddms.v1.EntityMove.getDefaultInstance()) {
          details_ =
              com.google.cloud.clouddms.v1.EntityMove.newBuilder(
                      (com.google.cloud.clouddms.v1.EntityMove) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 105) {
          entityMoveBuilder_.mergeFrom(value);
        } else {
          entityMoveBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 105;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple entities should be relocated into
     * a different schema.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.EntityMove entity_move = 105 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEntityMove() {
      if (entityMoveBuilder_ == null) {
        if (detailsCase_ == 105) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 105) {
          detailsCase_ = 0;
          details_ = null;
        }
        entityMoveBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple entities should be relocated into
     * a different schema.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.EntityMove entity_move = 105 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.EntityMove.Builder getEntityMoveBuilder() {
      return getEntityMoveFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple entities should be relocated into
     * a different schema.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.EntityMove entity_move = 105 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.EntityMoveOrBuilder getEntityMoveOrBuilder() {
      if ((detailsCase_ == 105) && (entityMoveBuilder_ != null)) {
        return entityMoveBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 105) {
          return (com.google.cloud.clouddms.v1.EntityMove) details_;
        }
        return com.google.cloud.clouddms.v1.EntityMove.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple entities should be relocated into
     * a different schema.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.EntityMove entity_move = 105 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.EntityMove,
            com.google.cloud.clouddms.v1.EntityMove.Builder,
            com.google.cloud.clouddms.v1.EntityMoveOrBuilder>
        getEntityMoveFieldBuilder() {
      if (entityMoveBuilder_ == null) {
        if (!(detailsCase_ == 105)) {
          details_ = com.google.cloud.clouddms.v1.EntityMove.getDefaultInstance();
        }
        entityMoveBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.EntityMove,
                com.google.cloud.clouddms.v1.EntityMove.Builder,
                com.google.cloud.clouddms.v1.EntityMoveOrBuilder>(
                (com.google.cloud.clouddms.v1.EntityMove) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 105;
      onChanged();
      return entityMoveBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SingleColumnChange,
            com.google.cloud.clouddms.v1.SingleColumnChange.Builder,
            com.google.cloud.clouddms.v1.SingleColumnChangeOrBuilder>
        singleColumnChangeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single column is converted.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SingleColumnChange single_column_change = 106 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the singleColumnChange field is set.
     */
    @java.lang.Override
    public boolean hasSingleColumnChange() {
      return detailsCase_ == 106;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single column is converted.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SingleColumnChange single_column_change = 106 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The singleColumnChange.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SingleColumnChange getSingleColumnChange() {
      if (singleColumnChangeBuilder_ == null) {
        if (detailsCase_ == 106) {
          return (com.google.cloud.clouddms.v1.SingleColumnChange) details_;
        }
        return com.google.cloud.clouddms.v1.SingleColumnChange.getDefaultInstance();
      } else {
        if (detailsCase_ == 106) {
          return singleColumnChangeBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.SingleColumnChange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single column is converted.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SingleColumnChange single_column_change = 106 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSingleColumnChange(com.google.cloud.clouddms.v1.SingleColumnChange value) {
      if (singleColumnChangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        singleColumnChangeBuilder_.setMessage(value);
      }
      detailsCase_ = 106;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single column is converted.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SingleColumnChange single_column_change = 106 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSingleColumnChange(
        com.google.cloud.clouddms.v1.SingleColumnChange.Builder builderForValue) {
      if (singleColumnChangeBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        singleColumnChangeBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 106;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single column is converted.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SingleColumnChange single_column_change = 106 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSingleColumnChange(com.google.cloud.clouddms.v1.SingleColumnChange value) {
      if (singleColumnChangeBuilder_ == null) {
        if (detailsCase_ == 106
            && details_ != com.google.cloud.clouddms.v1.SingleColumnChange.getDefaultInstance()) {
          details_ =
              com.google.cloud.clouddms.v1.SingleColumnChange.newBuilder(
                      (com.google.cloud.clouddms.v1.SingleColumnChange) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 106) {
          singleColumnChangeBuilder_.mergeFrom(value);
        } else {
          singleColumnChangeBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 106;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single column is converted.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SingleColumnChange single_column_change = 106 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSingleColumnChange() {
      if (singleColumnChangeBuilder_ == null) {
        if (detailsCase_ == 106) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 106) {
          detailsCase_ = 0;
          details_ = null;
        }
        singleColumnChangeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single column is converted.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SingleColumnChange single_column_change = 106 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.SingleColumnChange.Builder getSingleColumnChangeBuilder() {
      return getSingleColumnChangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single column is converted.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SingleColumnChange single_column_change = 106 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SingleColumnChangeOrBuilder
        getSingleColumnChangeOrBuilder() {
      if ((detailsCase_ == 106) && (singleColumnChangeBuilder_ != null)) {
        return singleColumnChangeBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 106) {
          return (com.google.cloud.clouddms.v1.SingleColumnChange) details_;
        }
        return com.google.cloud.clouddms.v1.SingleColumnChange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single column is converted.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SingleColumnChange single_column_change = 106 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SingleColumnChange,
            com.google.cloud.clouddms.v1.SingleColumnChange.Builder,
            com.google.cloud.clouddms.v1.SingleColumnChangeOrBuilder>
        getSingleColumnChangeFieldBuilder() {
      if (singleColumnChangeBuilder_ == null) {
        if (!(detailsCase_ == 106)) {
          details_ = com.google.cloud.clouddms.v1.SingleColumnChange.getDefaultInstance();
        }
        singleColumnChangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.SingleColumnChange,
                com.google.cloud.clouddms.v1.SingleColumnChange.Builder,
                com.google.cloud.clouddms.v1.SingleColumnChangeOrBuilder>(
                (com.google.cloud.clouddms.v1.SingleColumnChange) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 106;
      onChanged();
      return singleColumnChangeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.MultiColumnDatatypeChange,
            com.google.cloud.clouddms.v1.MultiColumnDatatypeChange.Builder,
            com.google.cloud.clouddms.v1.MultiColumnDatatypeChangeOrBuilder>
        multiColumnDataTypeChangeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple columns should be converted to a
     * different data type.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MultiColumnDatatypeChange multi_column_data_type_change = 107 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the multiColumnDataTypeChange field is set.
     */
    @java.lang.Override
    public boolean hasMultiColumnDataTypeChange() {
      return detailsCase_ == 107;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple columns should be converted to a
     * different data type.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MultiColumnDatatypeChange multi_column_data_type_change = 107 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The multiColumnDataTypeChange.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.MultiColumnDatatypeChange getMultiColumnDataTypeChange() {
      if (multiColumnDataTypeChangeBuilder_ == null) {
        if (detailsCase_ == 107) {
          return (com.google.cloud.clouddms.v1.MultiColumnDatatypeChange) details_;
        }
        return com.google.cloud.clouddms.v1.MultiColumnDatatypeChange.getDefaultInstance();
      } else {
        if (detailsCase_ == 107) {
          return multiColumnDataTypeChangeBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.MultiColumnDatatypeChange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple columns should be converted to a
     * different data type.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MultiColumnDatatypeChange multi_column_data_type_change = 107 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMultiColumnDataTypeChange(
        com.google.cloud.clouddms.v1.MultiColumnDatatypeChange value) {
      if (multiColumnDataTypeChangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        multiColumnDataTypeChangeBuilder_.setMessage(value);
      }
      detailsCase_ = 107;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple columns should be converted to a
     * different data type.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MultiColumnDatatypeChange multi_column_data_type_change = 107 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMultiColumnDataTypeChange(
        com.google.cloud.clouddms.v1.MultiColumnDatatypeChange.Builder builderForValue) {
      if (multiColumnDataTypeChangeBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        multiColumnDataTypeChangeBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 107;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple columns should be converted to a
     * different data type.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MultiColumnDatatypeChange multi_column_data_type_change = 107 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMultiColumnDataTypeChange(
        com.google.cloud.clouddms.v1.MultiColumnDatatypeChange value) {
      if (multiColumnDataTypeChangeBuilder_ == null) {
        if (detailsCase_ == 107
            && details_
                != com.google.cloud.clouddms.v1.MultiColumnDatatypeChange.getDefaultInstance()) {
          details_ =
              com.google.cloud.clouddms.v1.MultiColumnDatatypeChange.newBuilder(
                      (com.google.cloud.clouddms.v1.MultiColumnDatatypeChange) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 107) {
          multiColumnDataTypeChangeBuilder_.mergeFrom(value);
        } else {
          multiColumnDataTypeChangeBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 107;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple columns should be converted to a
     * different data type.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MultiColumnDatatypeChange multi_column_data_type_change = 107 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMultiColumnDataTypeChange() {
      if (multiColumnDataTypeChangeBuilder_ == null) {
        if (detailsCase_ == 107) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 107) {
          detailsCase_ = 0;
          details_ = null;
        }
        multiColumnDataTypeChangeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple columns should be converted to a
     * different data type.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MultiColumnDatatypeChange multi_column_data_type_change = 107 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.MultiColumnDatatypeChange.Builder
        getMultiColumnDataTypeChangeBuilder() {
      return getMultiColumnDataTypeChangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple columns should be converted to a
     * different data type.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MultiColumnDatatypeChange multi_column_data_type_change = 107 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.MultiColumnDatatypeChangeOrBuilder
        getMultiColumnDataTypeChangeOrBuilder() {
      if ((detailsCase_ == 107) && (multiColumnDataTypeChangeBuilder_ != null)) {
        return multiColumnDataTypeChangeBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 107) {
          return (com.google.cloud.clouddms.v1.MultiColumnDatatypeChange) details_;
        }
        return com.google.cloud.clouddms.v1.MultiColumnDatatypeChange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple columns should be converted to a
     * different data type.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MultiColumnDatatypeChange multi_column_data_type_change = 107 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.MultiColumnDatatypeChange,
            com.google.cloud.clouddms.v1.MultiColumnDatatypeChange.Builder,
            com.google.cloud.clouddms.v1.MultiColumnDatatypeChangeOrBuilder>
        getMultiColumnDataTypeChangeFieldBuilder() {
      if (multiColumnDataTypeChangeBuilder_ == null) {
        if (!(detailsCase_ == 107)) {
          details_ = com.google.cloud.clouddms.v1.MultiColumnDatatypeChange.getDefaultInstance();
        }
        multiColumnDataTypeChangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.MultiColumnDatatypeChange,
                com.google.cloud.clouddms.v1.MultiColumnDatatypeChange.Builder,
                com.google.cloud.clouddms.v1.MultiColumnDatatypeChangeOrBuilder>(
                (com.google.cloud.clouddms.v1.MultiColumnDatatypeChange) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 107;
      onChanged();
      return multiColumnDataTypeChangeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.ConditionalColumnSetValue,
            com.google.cloud.clouddms.v1.ConditionalColumnSetValue.Builder,
            com.google.cloud.clouddms.v1.ConditionalColumnSetValueOrBuilder>
        conditionalColumnSetValueBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how the data contained in a column should be
     * transformed (such as trimmed, rounded, etc) provided that the data meets
     * certain criteria.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConditionalColumnSetValue conditional_column_set_value = 108 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the conditionalColumnSetValue field is set.
     */
    @java.lang.Override
    public boolean hasConditionalColumnSetValue() {
      return detailsCase_ == 108;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how the data contained in a column should be
     * transformed (such as trimmed, rounded, etc) provided that the data meets
     * certain criteria.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConditionalColumnSetValue conditional_column_set_value = 108 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The conditionalColumnSetValue.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.ConditionalColumnSetValue getConditionalColumnSetValue() {
      if (conditionalColumnSetValueBuilder_ == null) {
        if (detailsCase_ == 108) {
          return (com.google.cloud.clouddms.v1.ConditionalColumnSetValue) details_;
        }
        return com.google.cloud.clouddms.v1.ConditionalColumnSetValue.getDefaultInstance();
      } else {
        if (detailsCase_ == 108) {
          return conditionalColumnSetValueBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.ConditionalColumnSetValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how the data contained in a column should be
     * transformed (such as trimmed, rounded, etc) provided that the data meets
     * certain criteria.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConditionalColumnSetValue conditional_column_set_value = 108 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConditionalColumnSetValue(
        com.google.cloud.clouddms.v1.ConditionalColumnSetValue value) {
      if (conditionalColumnSetValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        conditionalColumnSetValueBuilder_.setMessage(value);
      }
      detailsCase_ = 108;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how the data contained in a column should be
     * transformed (such as trimmed, rounded, etc) provided that the data meets
     * certain criteria.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConditionalColumnSetValue conditional_column_set_value = 108 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConditionalColumnSetValue(
        com.google.cloud.clouddms.v1.ConditionalColumnSetValue.Builder builderForValue) {
      if (conditionalColumnSetValueBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        conditionalColumnSetValueBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 108;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how the data contained in a column should be
     * transformed (such as trimmed, rounded, etc) provided that the data meets
     * certain criteria.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConditionalColumnSetValue conditional_column_set_value = 108 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeConditionalColumnSetValue(
        com.google.cloud.clouddms.v1.ConditionalColumnSetValue value) {
      if (conditionalColumnSetValueBuilder_ == null) {
        if (detailsCase_ == 108
            && details_
                != com.google.cloud.clouddms.v1.ConditionalColumnSetValue.getDefaultInstance()) {
          details_ =
              com.google.cloud.clouddms.v1.ConditionalColumnSetValue.newBuilder(
                      (com.google.cloud.clouddms.v1.ConditionalColumnSetValue) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 108) {
          conditionalColumnSetValueBuilder_.mergeFrom(value);
        } else {
          conditionalColumnSetValueBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 108;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how the data contained in a column should be
     * transformed (such as trimmed, rounded, etc) provided that the data meets
     * certain criteria.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConditionalColumnSetValue conditional_column_set_value = 108 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearConditionalColumnSetValue() {
      if (conditionalColumnSetValueBuilder_ == null) {
        if (detailsCase_ == 108) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 108) {
          detailsCase_ = 0;
          details_ = null;
        }
        conditionalColumnSetValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how the data contained in a column should be
     * transformed (such as trimmed, rounded, etc) provided that the data meets
     * certain criteria.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConditionalColumnSetValue conditional_column_set_value = 108 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.ConditionalColumnSetValue.Builder
        getConditionalColumnSetValueBuilder() {
      return getConditionalColumnSetValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how the data contained in a column should be
     * transformed (such as trimmed, rounded, etc) provided that the data meets
     * certain criteria.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConditionalColumnSetValue conditional_column_set_value = 108 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.ConditionalColumnSetValueOrBuilder
        getConditionalColumnSetValueOrBuilder() {
      if ((detailsCase_ == 108) && (conditionalColumnSetValueBuilder_ != null)) {
        return conditionalColumnSetValueBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 108) {
          return (com.google.cloud.clouddms.v1.ConditionalColumnSetValue) details_;
        }
        return com.google.cloud.clouddms.v1.ConditionalColumnSetValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how the data contained in a column should be
     * transformed (such as trimmed, rounded, etc) provided that the data meets
     * certain criteria.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConditionalColumnSetValue conditional_column_set_value = 108 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.ConditionalColumnSetValue,
            com.google.cloud.clouddms.v1.ConditionalColumnSetValue.Builder,
            com.google.cloud.clouddms.v1.ConditionalColumnSetValueOrBuilder>
        getConditionalColumnSetValueFieldBuilder() {
      if (conditionalColumnSetValueBuilder_ == null) {
        if (!(detailsCase_ == 108)) {
          details_ = com.google.cloud.clouddms.v1.ConditionalColumnSetValue.getDefaultInstance();
        }
        conditionalColumnSetValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.ConditionalColumnSetValue,
                com.google.cloud.clouddms.v1.ConditionalColumnSetValue.Builder,
                com.google.cloud.clouddms.v1.ConditionalColumnSetValueOrBuilder>(
                (com.google.cloud.clouddms.v1.ConditionalColumnSetValue) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 108;
      onChanged();
      return conditionalColumnSetValueBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.ConvertRowIdToColumn,
            com.google.cloud.clouddms.v1.ConvertRowIdToColumn.Builder,
            com.google.cloud.clouddms.v1.ConvertRowIdToColumnOrBuilder>
        convertRowidColumnBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple tables should be converted with an
     * additional rowid column.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConvertRowIdToColumn convert_rowid_column = 114 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the convertRowidColumn field is set.
     */
    @java.lang.Override
    public boolean hasConvertRowidColumn() {
      return detailsCase_ == 114;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple tables should be converted with an
     * additional rowid column.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConvertRowIdToColumn convert_rowid_column = 114 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The convertRowidColumn.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.ConvertRowIdToColumn getConvertRowidColumn() {
      if (convertRowidColumnBuilder_ == null) {
        if (detailsCase_ == 114) {
          return (com.google.cloud.clouddms.v1.ConvertRowIdToColumn) details_;
        }
        return com.google.cloud.clouddms.v1.ConvertRowIdToColumn.getDefaultInstance();
      } else {
        if (detailsCase_ == 114) {
          return convertRowidColumnBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.ConvertRowIdToColumn.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple tables should be converted with an
     * additional rowid column.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConvertRowIdToColumn convert_rowid_column = 114 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConvertRowidColumn(com.google.cloud.clouddms.v1.ConvertRowIdToColumn value) {
      if (convertRowidColumnBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        convertRowidColumnBuilder_.setMessage(value);
      }
      detailsCase_ = 114;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple tables should be converted with an
     * additional rowid column.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConvertRowIdToColumn convert_rowid_column = 114 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConvertRowidColumn(
        com.google.cloud.clouddms.v1.ConvertRowIdToColumn.Builder builderForValue) {
      if (convertRowidColumnBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        convertRowidColumnBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 114;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple tables should be converted with an
     * additional rowid column.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConvertRowIdToColumn convert_rowid_column = 114 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeConvertRowidColumn(
        com.google.cloud.clouddms.v1.ConvertRowIdToColumn value) {
      if (convertRowidColumnBuilder_ == null) {
        if (detailsCase_ == 114
            && details_ != com.google.cloud.clouddms.v1.ConvertRowIdToColumn.getDefaultInstance()) {
          details_ =
              com.google.cloud.clouddms.v1.ConvertRowIdToColumn.newBuilder(
                      (com.google.cloud.clouddms.v1.ConvertRowIdToColumn) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 114) {
          convertRowidColumnBuilder_.mergeFrom(value);
        } else {
          convertRowidColumnBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 114;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple tables should be converted with an
     * additional rowid column.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConvertRowIdToColumn convert_rowid_column = 114 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearConvertRowidColumn() {
      if (convertRowidColumnBuilder_ == null) {
        if (detailsCase_ == 114) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 114) {
          detailsCase_ = 0;
          details_ = null;
        }
        convertRowidColumnBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple tables should be converted with an
     * additional rowid column.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConvertRowIdToColumn convert_rowid_column = 114 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.ConvertRowIdToColumn.Builder
        getConvertRowidColumnBuilder() {
      return getConvertRowidColumnFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple tables should be converted with an
     * additional rowid column.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConvertRowIdToColumn convert_rowid_column = 114 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.ConvertRowIdToColumnOrBuilder
        getConvertRowidColumnOrBuilder() {
      if ((detailsCase_ == 114) && (convertRowidColumnBuilder_ != null)) {
        return convertRowidColumnBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 114) {
          return (com.google.cloud.clouddms.v1.ConvertRowIdToColumn) details_;
        }
        return com.google.cloud.clouddms.v1.ConvertRowIdToColumn.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how multiple tables should be converted with an
     * additional rowid column.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConvertRowIdToColumn convert_rowid_column = 114 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.ConvertRowIdToColumn,
            com.google.cloud.clouddms.v1.ConvertRowIdToColumn.Builder,
            com.google.cloud.clouddms.v1.ConvertRowIdToColumnOrBuilder>
        getConvertRowidColumnFieldBuilder() {
      if (convertRowidColumnBuilder_ == null) {
        if (!(detailsCase_ == 114)) {
          details_ = com.google.cloud.clouddms.v1.ConvertRowIdToColumn.getDefaultInstance();
        }
        convertRowidColumnBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.ConvertRowIdToColumn,
                com.google.cloud.clouddms.v1.ConvertRowIdToColumn.Builder,
                com.google.cloud.clouddms.v1.ConvertRowIdToColumnOrBuilder>(
                (com.google.cloud.clouddms.v1.ConvertRowIdToColumn) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 114;
      onChanged();
      return convertRowidColumnBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SetTablePrimaryKey,
            com.google.cloud.clouddms.v1.SetTablePrimaryKey.Builder,
            com.google.cloud.clouddms.v1.SetTablePrimaryKeyOrBuilder>
        setTablePrimaryKeyBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify the primary key for a table
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SetTablePrimaryKey set_table_primary_key = 115 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the setTablePrimaryKey field is set.
     */
    @java.lang.Override
    public boolean hasSetTablePrimaryKey() {
      return detailsCase_ == 115;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify the primary key for a table
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SetTablePrimaryKey set_table_primary_key = 115 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The setTablePrimaryKey.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SetTablePrimaryKey getSetTablePrimaryKey() {
      if (setTablePrimaryKeyBuilder_ == null) {
        if (detailsCase_ == 115) {
          return (com.google.cloud.clouddms.v1.SetTablePrimaryKey) details_;
        }
        return com.google.cloud.clouddms.v1.SetTablePrimaryKey.getDefaultInstance();
      } else {
        if (detailsCase_ == 115) {
          return setTablePrimaryKeyBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.SetTablePrimaryKey.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify the primary key for a table
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SetTablePrimaryKey set_table_primary_key = 115 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSetTablePrimaryKey(com.google.cloud.clouddms.v1.SetTablePrimaryKey value) {
      if (setTablePrimaryKeyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        setTablePrimaryKeyBuilder_.setMessage(value);
      }
      detailsCase_ = 115;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify the primary key for a table
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SetTablePrimaryKey set_table_primary_key = 115 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSetTablePrimaryKey(
        com.google.cloud.clouddms.v1.SetTablePrimaryKey.Builder builderForValue) {
      if (setTablePrimaryKeyBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        setTablePrimaryKeyBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 115;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify the primary key for a table
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SetTablePrimaryKey set_table_primary_key = 115 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSetTablePrimaryKey(com.google.cloud.clouddms.v1.SetTablePrimaryKey value) {
      if (setTablePrimaryKeyBuilder_ == null) {
        if (detailsCase_ == 115
            && details_ != com.google.cloud.clouddms.v1.SetTablePrimaryKey.getDefaultInstance()) {
          details_ =
              com.google.cloud.clouddms.v1.SetTablePrimaryKey.newBuilder(
                      (com.google.cloud.clouddms.v1.SetTablePrimaryKey) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 115) {
          setTablePrimaryKeyBuilder_.mergeFrom(value);
        } else {
          setTablePrimaryKeyBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 115;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify the primary key for a table
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SetTablePrimaryKey set_table_primary_key = 115 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSetTablePrimaryKey() {
      if (setTablePrimaryKeyBuilder_ == null) {
        if (detailsCase_ == 115) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 115) {
          detailsCase_ = 0;
          details_ = null;
        }
        setTablePrimaryKeyBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify the primary key for a table
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SetTablePrimaryKey set_table_primary_key = 115 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.SetTablePrimaryKey.Builder getSetTablePrimaryKeyBuilder() {
      return getSetTablePrimaryKeyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify the primary key for a table
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SetTablePrimaryKey set_table_primary_key = 115 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SetTablePrimaryKeyOrBuilder
        getSetTablePrimaryKeyOrBuilder() {
      if ((detailsCase_ == 115) && (setTablePrimaryKeyBuilder_ != null)) {
        return setTablePrimaryKeyBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 115) {
          return (com.google.cloud.clouddms.v1.SetTablePrimaryKey) details_;
        }
        return com.google.cloud.clouddms.v1.SetTablePrimaryKey.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify the primary key for a table
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SetTablePrimaryKey set_table_primary_key = 115 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SetTablePrimaryKey,
            com.google.cloud.clouddms.v1.SetTablePrimaryKey.Builder,
            com.google.cloud.clouddms.v1.SetTablePrimaryKeyOrBuilder>
        getSetTablePrimaryKeyFieldBuilder() {
      if (setTablePrimaryKeyBuilder_ == null) {
        if (!(detailsCase_ == 115)) {
          details_ = com.google.cloud.clouddms.v1.SetTablePrimaryKey.getDefaultInstance();
        }
        setTablePrimaryKeyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.SetTablePrimaryKey,
                com.google.cloud.clouddms.v1.SetTablePrimaryKey.Builder,
                com.google.cloud.clouddms.v1.SetTablePrimaryKeyOrBuilder>(
                (com.google.cloud.clouddms.v1.SetTablePrimaryKey) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 115;
      onChanged();
      return setTablePrimaryKeyBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SinglePackageChange,
            com.google.cloud.clouddms.v1.SinglePackageChange.Builder,
            com.google.cloud.clouddms.v1.SinglePackageChangeOrBuilder>
        singlePackageChangeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single package is converted.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SinglePackageChange single_package_change = 116 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the singlePackageChange field is set.
     */
    @java.lang.Override
    public boolean hasSinglePackageChange() {
      return detailsCase_ == 116;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single package is converted.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SinglePackageChange single_package_change = 116 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The singlePackageChange.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SinglePackageChange getSinglePackageChange() {
      if (singlePackageChangeBuilder_ == null) {
        if (detailsCase_ == 116) {
          return (com.google.cloud.clouddms.v1.SinglePackageChange) details_;
        }
        return com.google.cloud.clouddms.v1.SinglePackageChange.getDefaultInstance();
      } else {
        if (detailsCase_ == 116) {
          return singlePackageChangeBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.SinglePackageChange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single package is converted.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SinglePackageChange single_package_change = 116 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSinglePackageChange(com.google.cloud.clouddms.v1.SinglePackageChange value) {
      if (singlePackageChangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        singlePackageChangeBuilder_.setMessage(value);
      }
      detailsCase_ = 116;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single package is converted.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SinglePackageChange single_package_change = 116 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSinglePackageChange(
        com.google.cloud.clouddms.v1.SinglePackageChange.Builder builderForValue) {
      if (singlePackageChangeBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        singlePackageChangeBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 116;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single package is converted.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SinglePackageChange single_package_change = 116 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSinglePackageChange(
        com.google.cloud.clouddms.v1.SinglePackageChange value) {
      if (singlePackageChangeBuilder_ == null) {
        if (detailsCase_ == 116
            && details_ != com.google.cloud.clouddms.v1.SinglePackageChange.getDefaultInstance()) {
          details_ =
              com.google.cloud.clouddms.v1.SinglePackageChange.newBuilder(
                      (com.google.cloud.clouddms.v1.SinglePackageChange) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 116) {
          singlePackageChangeBuilder_.mergeFrom(value);
        } else {
          singlePackageChangeBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 116;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single package is converted.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SinglePackageChange single_package_change = 116 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSinglePackageChange() {
      if (singlePackageChangeBuilder_ == null) {
        if (detailsCase_ == 116) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 116) {
          detailsCase_ = 0;
          details_ = null;
        }
        singlePackageChangeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single package is converted.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SinglePackageChange single_package_change = 116 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.SinglePackageChange.Builder
        getSinglePackageChangeBuilder() {
      return getSinglePackageChangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single package is converted.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SinglePackageChange single_package_change = 116 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SinglePackageChangeOrBuilder
        getSinglePackageChangeOrBuilder() {
      if ((detailsCase_ == 116) && (singlePackageChangeBuilder_ != null)) {
        return singlePackageChangeBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 116) {
          return (com.google.cloud.clouddms.v1.SinglePackageChange) details_;
        }
        return com.google.cloud.clouddms.v1.SinglePackageChange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify how a single package is converted.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SinglePackageChange single_package_change = 116 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SinglePackageChange,
            com.google.cloud.clouddms.v1.SinglePackageChange.Builder,
            com.google.cloud.clouddms.v1.SinglePackageChangeOrBuilder>
        getSinglePackageChangeFieldBuilder() {
      if (singlePackageChangeBuilder_ == null) {
        if (!(detailsCase_ == 116)) {
          details_ = com.google.cloud.clouddms.v1.SinglePackageChange.getDefaultInstance();
        }
        singlePackageChangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.SinglePackageChange,
                com.google.cloud.clouddms.v1.SinglePackageChange.Builder,
                com.google.cloud.clouddms.v1.SinglePackageChangeOrBuilder>(
                (com.google.cloud.clouddms.v1.SinglePackageChange) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 116;
      onChanged();
      return singlePackageChangeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SourceSqlChange,
            com.google.cloud.clouddms.v1.SourceSqlChange.Builder,
            com.google.cloud.clouddms.v1.SourceSqlChangeOrBuilder>
        sourceSqlChangeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Rule to change the sql code for an entity, for example,
     * function, procedure.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceSqlChange source_sql_change = 117 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sourceSqlChange field is set.
     */
    @java.lang.Override
    public boolean hasSourceSqlChange() {
      return detailsCase_ == 117;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to change the sql code for an entity, for example,
     * function, procedure.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceSqlChange source_sql_change = 117 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sourceSqlChange.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SourceSqlChange getSourceSqlChange() {
      if (sourceSqlChangeBuilder_ == null) {
        if (detailsCase_ == 117) {
          return (com.google.cloud.clouddms.v1.SourceSqlChange) details_;
        }
        return com.google.cloud.clouddms.v1.SourceSqlChange.getDefaultInstance();
      } else {
        if (detailsCase_ == 117) {
          return sourceSqlChangeBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.SourceSqlChange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to change the sql code for an entity, for example,
     * function, procedure.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceSqlChange source_sql_change = 117 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSourceSqlChange(com.google.cloud.clouddms.v1.SourceSqlChange value) {
      if (sourceSqlChangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        sourceSqlChangeBuilder_.setMessage(value);
      }
      detailsCase_ = 117;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to change the sql code for an entity, for example,
     * function, procedure.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceSqlChange source_sql_change = 117 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSourceSqlChange(
        com.google.cloud.clouddms.v1.SourceSqlChange.Builder builderForValue) {
      if (sourceSqlChangeBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        sourceSqlChangeBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 117;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to change the sql code for an entity, for example,
     * function, procedure.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceSqlChange source_sql_change = 117 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSourceSqlChange(com.google.cloud.clouddms.v1.SourceSqlChange value) {
      if (sourceSqlChangeBuilder_ == null) {
        if (detailsCase_ == 117
            && details_ != com.google.cloud.clouddms.v1.SourceSqlChange.getDefaultInstance()) {
          details_ =
              com.google.cloud.clouddms.v1.SourceSqlChange.newBuilder(
                      (com.google.cloud.clouddms.v1.SourceSqlChange) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 117) {
          sourceSqlChangeBuilder_.mergeFrom(value);
        } else {
          sourceSqlChangeBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 117;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to change the sql code for an entity, for example,
     * function, procedure.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceSqlChange source_sql_change = 117 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSourceSqlChange() {
      if (sourceSqlChangeBuilder_ == null) {
        if (detailsCase_ == 117) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 117) {
          detailsCase_ = 0;
          details_ = null;
        }
        sourceSqlChangeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to change the sql code for an entity, for example,
     * function, procedure.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceSqlChange source_sql_change = 117 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.SourceSqlChange.Builder getSourceSqlChangeBuilder() {
      return getSourceSqlChangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to change the sql code for an entity, for example,
     * function, procedure.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceSqlChange source_sql_change = 117 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SourceSqlChangeOrBuilder getSourceSqlChangeOrBuilder() {
      if ((detailsCase_ == 117) && (sourceSqlChangeBuilder_ != null)) {
        return sourceSqlChangeBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 117) {
          return (com.google.cloud.clouddms.v1.SourceSqlChange) details_;
        }
        return com.google.cloud.clouddms.v1.SourceSqlChange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to change the sql code for an entity, for example,
     * function, procedure.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceSqlChange source_sql_change = 117 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SourceSqlChange,
            com.google.cloud.clouddms.v1.SourceSqlChange.Builder,
            com.google.cloud.clouddms.v1.SourceSqlChangeOrBuilder>
        getSourceSqlChangeFieldBuilder() {
      if (sourceSqlChangeBuilder_ == null) {
        if (!(detailsCase_ == 117)) {
          details_ = com.google.cloud.clouddms.v1.SourceSqlChange.getDefaultInstance();
        }
        sourceSqlChangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.SourceSqlChange,
                com.google.cloud.clouddms.v1.SourceSqlChange.Builder,
                com.google.cloud.clouddms.v1.SourceSqlChangeOrBuilder>(
                (com.google.cloud.clouddms.v1.SourceSqlChange) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 117;
      onChanged();
      return sourceSqlChangeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.FilterTableColumns,
            com.google.cloud.clouddms.v1.FilterTableColumns.Builder,
            com.google.cloud.clouddms.v1.FilterTableColumnsOrBuilder>
        filterTableColumnsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify the list of columns to include or exclude from
     * a table.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.FilterTableColumns filter_table_columns = 118 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the filterTableColumns field is set.
     */
    @java.lang.Override
    public boolean hasFilterTableColumns() {
      return detailsCase_ == 118;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify the list of columns to include or exclude from
     * a table.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.FilterTableColumns filter_table_columns = 118 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The filterTableColumns.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.FilterTableColumns getFilterTableColumns() {
      if (filterTableColumnsBuilder_ == null) {
        if (detailsCase_ == 118) {
          return (com.google.cloud.clouddms.v1.FilterTableColumns) details_;
        }
        return com.google.cloud.clouddms.v1.FilterTableColumns.getDefaultInstance();
      } else {
        if (detailsCase_ == 118) {
          return filterTableColumnsBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.FilterTableColumns.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify the list of columns to include or exclude from
     * a table.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.FilterTableColumns filter_table_columns = 118 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFilterTableColumns(com.google.cloud.clouddms.v1.FilterTableColumns value) {
      if (filterTableColumnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        filterTableColumnsBuilder_.setMessage(value);
      }
      detailsCase_ = 118;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify the list of columns to include or exclude from
     * a table.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.FilterTableColumns filter_table_columns = 118 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFilterTableColumns(
        com.google.cloud.clouddms.v1.FilterTableColumns.Builder builderForValue) {
      if (filterTableColumnsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        filterTableColumnsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 118;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify the list of columns to include or exclude from
     * a table.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.FilterTableColumns filter_table_columns = 118 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeFilterTableColumns(com.google.cloud.clouddms.v1.FilterTableColumns value) {
      if (filterTableColumnsBuilder_ == null) {
        if (detailsCase_ == 118
            && details_ != com.google.cloud.clouddms.v1.FilterTableColumns.getDefaultInstance()) {
          details_ =
              com.google.cloud.clouddms.v1.FilterTableColumns.newBuilder(
                      (com.google.cloud.clouddms.v1.FilterTableColumns) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 118) {
          filterTableColumnsBuilder_.mergeFrom(value);
        } else {
          filterTableColumnsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 118;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify the list of columns to include or exclude from
     * a table.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.FilterTableColumns filter_table_columns = 118 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFilterTableColumns() {
      if (filterTableColumnsBuilder_ == null) {
        if (detailsCase_ == 118) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 118) {
          detailsCase_ = 0;
          details_ = null;
        }
        filterTableColumnsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify the list of columns to include or exclude from
     * a table.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.FilterTableColumns filter_table_columns = 118 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.FilterTableColumns.Builder getFilterTableColumnsBuilder() {
      return getFilterTableColumnsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify the list of columns to include or exclude from
     * a table.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.FilterTableColumns filter_table_columns = 118 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.FilterTableColumnsOrBuilder
        getFilterTableColumnsOrBuilder() {
      if ((detailsCase_ == 118) && (filterTableColumnsBuilder_ != null)) {
        return filterTableColumnsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 118) {
          return (com.google.cloud.clouddms.v1.FilterTableColumns) details_;
        }
        return com.google.cloud.clouddms.v1.FilterTableColumns.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rule to specify the list of columns to include or exclude from
     * a table.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.FilterTableColumns filter_table_columns = 118 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.FilterTableColumns,
            com.google.cloud.clouddms.v1.FilterTableColumns.Builder,
            com.google.cloud.clouddms.v1.FilterTableColumnsOrBuilder>
        getFilterTableColumnsFieldBuilder() {
      if (filterTableColumnsBuilder_ == null) {
        if (!(detailsCase_ == 118)) {
          details_ = com.google.cloud.clouddms.v1.FilterTableColumns.getDefaultInstance();
        }
        filterTableColumnsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.FilterTableColumns,
                com.google.cloud.clouddms.v1.FilterTableColumns.Builder,
                com.google.cloud.clouddms.v1.FilterTableColumnsOrBuilder>(
                (com.google.cloud.clouddms.v1.FilterTableColumns) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 118;
      onChanged();
      return filterTableColumnsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.MappingRule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.MappingRule)
  private static final com.google.cloud.clouddms.v1.MappingRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.MappingRule();
  }

  public static com.google.cloud.clouddms.v1.MappingRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MappingRule> PARSER =
      new com.google.protobuf.AbstractParser<MappingRule>() {
        @java.lang.Override
        public MappingRule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MappingRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MappingRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.MappingRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
