/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * A filter defining the entities that a mapping rule should be applied to.
 * When more than one field is specified, the rule is applied only to
 * entities which match all the fields.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.MappingRuleFilter}
 */
public final class MappingRuleFilter extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.MappingRuleFilter)
    MappingRuleFilterOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MappingRuleFilter.newBuilder() to construct.
  private MappingRuleFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MappingRuleFilter() {
    parentEntity_ = "";
    entityNamePrefix_ = "";
    entityNameSuffix_ = "";
    entityNameContains_ = "";
    entities_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MappingRuleFilter();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_MappingRuleFilter_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_MappingRuleFilter_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.MappingRuleFilter.class,
            com.google.cloud.clouddms.v1.MappingRuleFilter.Builder.class);
  }

  public static final int PARENT_ENTITY_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parentEntity_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to entities whose parent entity
   * (fully qualified name) matches the given value.
   * For example, if the rule applies to a table entity, the expected value
   * should be a schema (schema). If the rule applies to a column or index
   * entity, the expected value can be either a schema (schema) or a table
   * (schema.table)
   * </pre>
   *
   * <code>string parent_entity = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The parentEntity.
   */
  @java.lang.Override
  public java.lang.String getParentEntity() {
    java.lang.Object ref = parentEntity_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parentEntity_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to entities whose parent entity
   * (fully qualified name) matches the given value.
   * For example, if the rule applies to a table entity, the expected value
   * should be a schema (schema). If the rule applies to a column or index
   * entity, the expected value can be either a schema (schema) or a table
   * (schema.table)
   * </pre>
   *
   * <code>string parent_entity = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for parentEntity.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentEntityBytes() {
    java.lang.Object ref = parentEntity_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parentEntity_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENTITY_NAME_PREFIX_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object entityNamePrefix_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to entities whose non-qualified name
   * starts with the given prefix.
   * </pre>
   *
   * <code>string entity_name_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The entityNamePrefix.
   */
  @java.lang.Override
  public java.lang.String getEntityNamePrefix() {
    java.lang.Object ref = entityNamePrefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entityNamePrefix_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to entities whose non-qualified name
   * starts with the given prefix.
   * </pre>
   *
   * <code>string entity_name_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for entityNamePrefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntityNamePrefixBytes() {
    java.lang.Object ref = entityNamePrefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entityNamePrefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENTITY_NAME_SUFFIX_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object entityNameSuffix_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to entities whose non-qualified name
   * ends with the given suffix.
   * </pre>
   *
   * <code>string entity_name_suffix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The entityNameSuffix.
   */
  @java.lang.Override
  public java.lang.String getEntityNameSuffix() {
    java.lang.Object ref = entityNameSuffix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entityNameSuffix_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to entities whose non-qualified name
   * ends with the given suffix.
   * </pre>
   *
   * <code>string entity_name_suffix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for entityNameSuffix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntityNameSuffixBytes() {
    java.lang.Object ref = entityNameSuffix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entityNameSuffix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENTITY_NAME_CONTAINS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object entityNameContains_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to entities whose non-qualified name
   * contains the given string.
   * </pre>
   *
   * <code>string entity_name_contains = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The entityNameContains.
   */
  @java.lang.Override
  public java.lang.String getEntityNameContains() {
    java.lang.Object ref = entityNameContains_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entityNameContains_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to entities whose non-qualified name
   * contains the given string.
   * </pre>
   *
   * <code>string entity_name_contains = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for entityNameContains.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntityNameContainsBytes() {
    java.lang.Object ref = entityNameContains_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entityNameContains_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENTITIES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList entities_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to specific entities defined by their
   * fully qualified names.
   * </pre>
   *
   * <code>repeated string entities = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the entities.
   */
  public com.google.protobuf.ProtocolStringList getEntitiesList() {
    return entities_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to specific entities defined by their
   * fully qualified names.
   * </pre>
   *
   * <code>repeated string entities = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of entities.
   */
  public int getEntitiesCount() {
    return entities_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to specific entities defined by their
   * fully qualified names.
   * </pre>
   *
   * <code>repeated string entities = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The entities at the given index.
   */
  public java.lang.String getEntities(int index) {
    return entities_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to specific entities defined by their
   * fully qualified names.
   * </pre>
   *
   * <code>repeated string entities = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the entities at the given index.
   */
  public com.google.protobuf.ByteString getEntitiesBytes(int index) {
    return entities_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentEntity_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parentEntity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityNamePrefix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, entityNamePrefix_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityNameSuffix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, entityNameSuffix_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityNameContains_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, entityNameContains_);
    }
    for (int i = 0; i < entities_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, entities_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentEntity_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parentEntity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityNamePrefix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, entityNamePrefix_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityNameSuffix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, entityNameSuffix_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityNameContains_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, entityNameContains_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < entities_.size(); i++) {
        dataSize += computeStringSizeNoTag(entities_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getEntitiesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.MappingRuleFilter)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.MappingRuleFilter other =
        (com.google.cloud.clouddms.v1.MappingRuleFilter) obj;

    if (!getParentEntity().equals(other.getParentEntity())) return false;
    if (!getEntityNamePrefix().equals(other.getEntityNamePrefix())) return false;
    if (!getEntityNameSuffix().equals(other.getEntityNameSuffix())) return false;
    if (!getEntityNameContains().equals(other.getEntityNameContains())) return false;
    if (!getEntitiesList().equals(other.getEntitiesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_ENTITY_FIELD_NUMBER;
    hash = (53 * hash) + getParentEntity().hashCode();
    hash = (37 * hash) + ENTITY_NAME_PREFIX_FIELD_NUMBER;
    hash = (53 * hash) + getEntityNamePrefix().hashCode();
    hash = (37 * hash) + ENTITY_NAME_SUFFIX_FIELD_NUMBER;
    hash = (53 * hash) + getEntityNameSuffix().hashCode();
    hash = (37 * hash) + ENTITY_NAME_CONTAINS_FIELD_NUMBER;
    hash = (53 * hash) + getEntityNameContains().hashCode();
    if (getEntitiesCount() > 0) {
      hash = (37 * hash) + ENTITIES_FIELD_NUMBER;
      hash = (53 * hash) + getEntitiesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.MappingRuleFilter parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.MappingRuleFilter parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MappingRuleFilter parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.MappingRuleFilter parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MappingRuleFilter parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.MappingRuleFilter parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MappingRuleFilter parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.MappingRuleFilter parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MappingRuleFilter parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.MappingRuleFilter parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MappingRuleFilter parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.MappingRuleFilter parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.MappingRuleFilter prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A filter defining the entities that a mapping rule should be applied to.
   * When more than one field is specified, the rule is applied only to
   * entities which match all the fields.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.MappingRuleFilter}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.MappingRuleFilter)
      com.google.cloud.clouddms.v1.MappingRuleFilterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_MappingRuleFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_MappingRuleFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.MappingRuleFilter.class,
              com.google.cloud.clouddms.v1.MappingRuleFilter.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.MappingRuleFilter.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parentEntity_ = "";
      entityNamePrefix_ = "";
      entityNameSuffix_ = "";
      entityNameContains_ = "";
      entities_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_MappingRuleFilter_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MappingRuleFilter getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.MappingRuleFilter.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MappingRuleFilter build() {
      com.google.cloud.clouddms.v1.MappingRuleFilter result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MappingRuleFilter buildPartial() {
      com.google.cloud.clouddms.v1.MappingRuleFilter result =
          new com.google.cloud.clouddms.v1.MappingRuleFilter(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.MappingRuleFilter result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parentEntity_ = parentEntity_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.entityNamePrefix_ = entityNamePrefix_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.entityNameSuffix_ = entityNameSuffix_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.entityNameContains_ = entityNameContains_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        entities_.makeImmutable();
        result.entities_ = entities_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.MappingRuleFilter) {
        return mergeFrom((com.google.cloud.clouddms.v1.MappingRuleFilter) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.MappingRuleFilter other) {
      if (other == com.google.cloud.clouddms.v1.MappingRuleFilter.getDefaultInstance()) return this;
      if (!other.getParentEntity().isEmpty()) {
        parentEntity_ = other.parentEntity_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getEntityNamePrefix().isEmpty()) {
        entityNamePrefix_ = other.entityNamePrefix_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getEntityNameSuffix().isEmpty()) {
        entityNameSuffix_ = other.entityNameSuffix_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getEntityNameContains().isEmpty()) {
        entityNameContains_ = other.entityNameContains_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.entities_.isEmpty()) {
        if (entities_.isEmpty()) {
          entities_ = other.entities_;
          bitField0_ |= 0x00000010;
        } else {
          ensureEntitiesIsMutable();
          entities_.addAll(other.entities_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parentEntity_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                entityNamePrefix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                entityNameSuffix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                entityNameContains_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureEntitiesIsMutable();
                entities_.add(s);
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parentEntity_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to entities whose parent entity
     * (fully qualified name) matches the given value.
     * For example, if the rule applies to a table entity, the expected value
     * should be a schema (schema). If the rule applies to a column or index
     * entity, the expected value can be either a schema (schema) or a table
     * (schema.table)
     * </pre>
     *
     * <code>string parent_entity = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The parentEntity.
     */
    public java.lang.String getParentEntity() {
      java.lang.Object ref = parentEntity_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parentEntity_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to entities whose parent entity
     * (fully qualified name) matches the given value.
     * For example, if the rule applies to a table entity, the expected value
     * should be a schema (schema). If the rule applies to a column or index
     * entity, the expected value can be either a schema (schema) or a table
     * (schema.table)
     * </pre>
     *
     * <code>string parent_entity = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for parentEntity.
     */
    public com.google.protobuf.ByteString getParentEntityBytes() {
      java.lang.Object ref = parentEntity_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parentEntity_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to entities whose parent entity
     * (fully qualified name) matches the given value.
     * For example, if the rule applies to a table entity, the expected value
     * should be a schema (schema). If the rule applies to a column or index
     * entity, the expected value can be either a schema (schema) or a table
     * (schema.table)
     * </pre>
     *
     * <code>string parent_entity = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The parentEntity to set.
     * @return This builder for chaining.
     */
    public Builder setParentEntity(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parentEntity_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to entities whose parent entity
     * (fully qualified name) matches the given value.
     * For example, if the rule applies to a table entity, the expected value
     * should be a schema (schema). If the rule applies to a column or index
     * entity, the expected value can be either a schema (schema) or a table
     * (schema.table)
     * </pre>
     *
     * <code>string parent_entity = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParentEntity() {
      parentEntity_ = getDefaultInstance().getParentEntity();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to entities whose parent entity
     * (fully qualified name) matches the given value.
     * For example, if the rule applies to a table entity, the expected value
     * should be a schema (schema). If the rule applies to a column or index
     * entity, the expected value can be either a schema (schema) or a table
     * (schema.table)
     * </pre>
     *
     * <code>string parent_entity = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for parentEntity to set.
     * @return This builder for chaining.
     */
    public Builder setParentEntityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parentEntity_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object entityNamePrefix_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to entities whose non-qualified name
     * starts with the given prefix.
     * </pre>
     *
     * <code>string entity_name_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The entityNamePrefix.
     */
    public java.lang.String getEntityNamePrefix() {
      java.lang.Object ref = entityNamePrefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entityNamePrefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to entities whose non-qualified name
     * starts with the given prefix.
     * </pre>
     *
     * <code>string entity_name_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for entityNamePrefix.
     */
    public com.google.protobuf.ByteString getEntityNamePrefixBytes() {
      java.lang.Object ref = entityNamePrefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entityNamePrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to entities whose non-qualified name
     * starts with the given prefix.
     * </pre>
     *
     * <code>string entity_name_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The entityNamePrefix to set.
     * @return This builder for chaining.
     */
    public Builder setEntityNamePrefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      entityNamePrefix_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to entities whose non-qualified name
     * starts with the given prefix.
     * </pre>
     *
     * <code>string entity_name_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntityNamePrefix() {
      entityNamePrefix_ = getDefaultInstance().getEntityNamePrefix();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to entities whose non-qualified name
     * starts with the given prefix.
     * </pre>
     *
     * <code>string entity_name_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for entityNamePrefix to set.
     * @return This builder for chaining.
     */
    public Builder setEntityNamePrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      entityNamePrefix_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object entityNameSuffix_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to entities whose non-qualified name
     * ends with the given suffix.
     * </pre>
     *
     * <code>string entity_name_suffix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The entityNameSuffix.
     */
    public java.lang.String getEntityNameSuffix() {
      java.lang.Object ref = entityNameSuffix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entityNameSuffix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to entities whose non-qualified name
     * ends with the given suffix.
     * </pre>
     *
     * <code>string entity_name_suffix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for entityNameSuffix.
     */
    public com.google.protobuf.ByteString getEntityNameSuffixBytes() {
      java.lang.Object ref = entityNameSuffix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entityNameSuffix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to entities whose non-qualified name
     * ends with the given suffix.
     * </pre>
     *
     * <code>string entity_name_suffix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The entityNameSuffix to set.
     * @return This builder for chaining.
     */
    public Builder setEntityNameSuffix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      entityNameSuffix_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to entities whose non-qualified name
     * ends with the given suffix.
     * </pre>
     *
     * <code>string entity_name_suffix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntityNameSuffix() {
      entityNameSuffix_ = getDefaultInstance().getEntityNameSuffix();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to entities whose non-qualified name
     * ends with the given suffix.
     * </pre>
     *
     * <code>string entity_name_suffix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for entityNameSuffix to set.
     * @return This builder for chaining.
     */
    public Builder setEntityNameSuffixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      entityNameSuffix_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object entityNameContains_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to entities whose non-qualified name
     * contains the given string.
     * </pre>
     *
     * <code>string entity_name_contains = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The entityNameContains.
     */
    public java.lang.String getEntityNameContains() {
      java.lang.Object ref = entityNameContains_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entityNameContains_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to entities whose non-qualified name
     * contains the given string.
     * </pre>
     *
     * <code>string entity_name_contains = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for entityNameContains.
     */
    public com.google.protobuf.ByteString getEntityNameContainsBytes() {
      java.lang.Object ref = entityNameContains_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entityNameContains_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to entities whose non-qualified name
     * contains the given string.
     * </pre>
     *
     * <code>string entity_name_contains = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The entityNameContains to set.
     * @return This builder for chaining.
     */
    public Builder setEntityNameContains(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      entityNameContains_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to entities whose non-qualified name
     * contains the given string.
     * </pre>
     *
     * <code>string entity_name_contains = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntityNameContains() {
      entityNameContains_ = getDefaultInstance().getEntityNameContains();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to entities whose non-qualified name
     * contains the given string.
     * </pre>
     *
     * <code>string entity_name_contains = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for entityNameContains to set.
     * @return This builder for chaining.
     */
    public Builder setEntityNameContainsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      entityNameContains_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList entities_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureEntitiesIsMutable() {
      if (!entities_.isModifiable()) {
        entities_ = new com.google.protobuf.LazyStringArrayList(entities_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to specific entities defined by their
     * fully qualified names.
     * </pre>
     *
     * <code>repeated string entities = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the entities.
     */
    public com.google.protobuf.ProtocolStringList getEntitiesList() {
      entities_.makeImmutable();
      return entities_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to specific entities defined by their
     * fully qualified names.
     * </pre>
     *
     * <code>repeated string entities = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of entities.
     */
    public int getEntitiesCount() {
      return entities_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to specific entities defined by their
     * fully qualified names.
     * </pre>
     *
     * <code>repeated string entities = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The entities at the given index.
     */
    public java.lang.String getEntities(int index) {
      return entities_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to specific entities defined by their
     * fully qualified names.
     * </pre>
     *
     * <code>repeated string entities = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the entities at the given index.
     */
    public com.google.protobuf.ByteString getEntitiesBytes(int index) {
      return entities_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to specific entities defined by their
     * fully qualified names.
     * </pre>
     *
     * <code>repeated string entities = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The entities to set.
     * @return This builder for chaining.
     */
    public Builder setEntities(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEntitiesIsMutable();
      entities_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to specific entities defined by their
     * fully qualified names.
     * </pre>
     *
     * <code>repeated string entities = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The entities to add.
     * @return This builder for chaining.
     */
    public Builder addEntities(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEntitiesIsMutable();
      entities_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to specific entities defined by their
     * fully qualified names.
     * </pre>
     *
     * <code>repeated string entities = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The entities to add.
     * @return This builder for chaining.
     */
    public Builder addAllEntities(java.lang.Iterable<java.lang.String> values) {
      ensureEntitiesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, entities_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to specific entities defined by their
     * fully qualified names.
     * </pre>
     *
     * <code>repeated string entities = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntities() {
      entities_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rule should be applied to specific entities defined by their
     * fully qualified names.
     * </pre>
     *
     * <code>repeated string entities = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the entities to add.
     * @return This builder for chaining.
     */
    public Builder addEntitiesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureEntitiesIsMutable();
      entities_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.MappingRuleFilter)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.MappingRuleFilter)
  private static final com.google.cloud.clouddms.v1.MappingRuleFilter DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.MappingRuleFilter();
  }

  public static com.google.cloud.clouddms.v1.MappingRuleFilter getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MappingRuleFilter> PARSER =
      new com.google.protobuf.AbstractParser<MappingRuleFilter>() {
        @java.lang.Override
        public MappingRuleFilter parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MappingRuleFilter> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MappingRuleFilter> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.MappingRuleFilter getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
