/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

public interface MappingRuleFilterOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.clouddms.v1.MappingRuleFilter)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to entities whose parent entity
   * (fully qualified name) matches the given value.
   * For example, if the rule applies to a table entity, the expected value
   * should be a schema (schema). If the rule applies to a column or index
   * entity, the expected value can be either a schema (schema) or a table
   * (schema.table)
   * </pre>
   *
   * <code>string parent_entity = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The parentEntity.
   */
  java.lang.String getParentEntity();
  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to entities whose parent entity
   * (fully qualified name) matches the given value.
   * For example, if the rule applies to a table entity, the expected value
   * should be a schema (schema). If the rule applies to a column or index
   * entity, the expected value can be either a schema (schema) or a table
   * (schema.table)
   * </pre>
   *
   * <code>string parent_entity = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for parentEntity.
   */
  com.google.protobuf.ByteString getParentEntityBytes();

  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to entities whose non-qualified name
   * starts with the given prefix.
   * </pre>
   *
   * <code>string entity_name_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The entityNamePrefix.
   */
  java.lang.String getEntityNamePrefix();
  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to entities whose non-qualified name
   * starts with the given prefix.
   * </pre>
   *
   * <code>string entity_name_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for entityNamePrefix.
   */
  com.google.protobuf.ByteString getEntityNamePrefixBytes();

  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to entities whose non-qualified name
   * ends with the given suffix.
   * </pre>
   *
   * <code>string entity_name_suffix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The entityNameSuffix.
   */
  java.lang.String getEntityNameSuffix();
  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to entities whose non-qualified name
   * ends with the given suffix.
   * </pre>
   *
   * <code>string entity_name_suffix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for entityNameSuffix.
   */
  com.google.protobuf.ByteString getEntityNameSuffixBytes();

  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to entities whose non-qualified name
   * contains the given string.
   * </pre>
   *
   * <code>string entity_name_contains = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The entityNameContains.
   */
  java.lang.String getEntityNameContains();
  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to entities whose non-qualified name
   * contains the given string.
   * </pre>
   *
   * <code>string entity_name_contains = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for entityNameContains.
   */
  com.google.protobuf.ByteString getEntityNameContainsBytes();

  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to specific entities defined by their
   * fully qualified names.
   * </pre>
   *
   * <code>repeated string entities = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the entities.
   */
  java.util.List<java.lang.String> getEntitiesList();
  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to specific entities defined by their
   * fully qualified names.
   * </pre>
   *
   * <code>repeated string entities = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of entities.
   */
  int getEntitiesCount();
  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to specific entities defined by their
   * fully qualified names.
   * </pre>
   *
   * <code>repeated string entities = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The entities at the given index.
   */
  java.lang.String getEntities(int index);
  /**
   *
   *
   * <pre>
   * Optional. The rule should be applied to specific entities defined by their
   * fully qualified names.
   * </pre>
   *
   * <code>repeated string entities = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the entities at the given index.
   */
  com.google.protobuf.ByteString getEntitiesBytes(int index);
}
