/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/clouddms_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Represents a Database Migration Service migration job object.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.MigrationJob}
 */
public final class MigrationJob extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.MigrationJob)
    MigrationJobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MigrationJob.newBuilder() to construct.
  private MigrationJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MigrationJob() {
    name_ = "";
    displayName_ = "";
    state_ = 0;
    phase_ = 0;
    type_ = 0;
    dumpPath_ = "";
    source_ = "";
    destination_ = "";
    filter_ = "";
    cmekKeyName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MigrationJob();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
        .internal_static_google_cloud_clouddms_v1_MigrationJob_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
        .internal_static_google_cloud_clouddms_v1_MigrationJob_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.MigrationJob.class,
            com.google.cloud.clouddms.v1.MigrationJob.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The current migration job states.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.clouddms.v1.MigrationJob.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The state of the migration job is unknown.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The migration job is down for maintenance.
     * </pre>
     *
     * <code>MAINTENANCE = 1;</code>
     */
    MAINTENANCE(1),
    /**
     *
     *
     * <pre>
     * The migration job is in draft mode and no resources are created.
     * </pre>
     *
     * <code>DRAFT = 2;</code>
     */
    DRAFT(2),
    /**
     *
     *
     * <pre>
     * The migration job is being created.
     * </pre>
     *
     * <code>CREATING = 3;</code>
     */
    CREATING(3),
    /**
     *
     *
     * <pre>
     * The migration job is created and not started.
     * </pre>
     *
     * <code>NOT_STARTED = 4;</code>
     */
    NOT_STARTED(4),
    /**
     *
     *
     * <pre>
     * The migration job is running.
     * </pre>
     *
     * <code>RUNNING = 5;</code>
     */
    RUNNING(5),
    /**
     *
     *
     * <pre>
     * The migration job failed.
     * </pre>
     *
     * <code>FAILED = 6;</code>
     */
    FAILED(6),
    /**
     *
     *
     * <pre>
     * The migration job has been completed.
     * </pre>
     *
     * <code>COMPLETED = 7;</code>
     */
    COMPLETED(7),
    /**
     *
     *
     * <pre>
     * The migration job is being deleted.
     * </pre>
     *
     * <code>DELETING = 8;</code>
     */
    DELETING(8),
    /**
     *
     *
     * <pre>
     * The migration job is being stopped.
     * </pre>
     *
     * <code>STOPPING = 9;</code>
     */
    STOPPING(9),
    /**
     *
     *
     * <pre>
     * The migration job is currently stopped.
     * </pre>
     *
     * <code>STOPPED = 10;</code>
     */
    STOPPED(10),
    /**
     *
     *
     * <pre>
     * The migration job has been deleted.
     * </pre>
     *
     * <code>DELETED = 11;</code>
     */
    DELETED(11),
    /**
     *
     *
     * <pre>
     * The migration job is being updated.
     * </pre>
     *
     * <code>UPDATING = 12;</code>
     */
    UPDATING(12),
    /**
     *
     *
     * <pre>
     * The migration job is starting.
     * </pre>
     *
     * <code>STARTING = 13;</code>
     */
    STARTING(13),
    /**
     *
     *
     * <pre>
     * The migration job is restarting.
     * </pre>
     *
     * <code>RESTARTING = 14;</code>
     */
    RESTARTING(14),
    /**
     *
     *
     * <pre>
     * The migration job is resuming.
     * </pre>
     *
     * <code>RESUMING = 15;</code>
     */
    RESUMING(15),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The state of the migration job is unknown.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The migration job is down for maintenance.
     * </pre>
     *
     * <code>MAINTENANCE = 1;</code>
     */
    public static final int MAINTENANCE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The migration job is in draft mode and no resources are created.
     * </pre>
     *
     * <code>DRAFT = 2;</code>
     */
    public static final int DRAFT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The migration job is being created.
     * </pre>
     *
     * <code>CREATING = 3;</code>
     */
    public static final int CREATING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The migration job is created and not started.
     * </pre>
     *
     * <code>NOT_STARTED = 4;</code>
     */
    public static final int NOT_STARTED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The migration job is running.
     * </pre>
     *
     * <code>RUNNING = 5;</code>
     */
    public static final int RUNNING_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The migration job failed.
     * </pre>
     *
     * <code>FAILED = 6;</code>
     */
    public static final int FAILED_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The migration job has been completed.
     * </pre>
     *
     * <code>COMPLETED = 7;</code>
     */
    public static final int COMPLETED_VALUE = 7;
    /**
     *
     *
     * <pre>
     * The migration job is being deleted.
     * </pre>
     *
     * <code>DELETING = 8;</code>
     */
    public static final int DELETING_VALUE = 8;
    /**
     *
     *
     * <pre>
     * The migration job is being stopped.
     * </pre>
     *
     * <code>STOPPING = 9;</code>
     */
    public static final int STOPPING_VALUE = 9;
    /**
     *
     *
     * <pre>
     * The migration job is currently stopped.
     * </pre>
     *
     * <code>STOPPED = 10;</code>
     */
    public static final int STOPPED_VALUE = 10;
    /**
     *
     *
     * <pre>
     * The migration job has been deleted.
     * </pre>
     *
     * <code>DELETED = 11;</code>
     */
    public static final int DELETED_VALUE = 11;
    /**
     *
     *
     * <pre>
     * The migration job is being updated.
     * </pre>
     *
     * <code>UPDATING = 12;</code>
     */
    public static final int UPDATING_VALUE = 12;
    /**
     *
     *
     * <pre>
     * The migration job is starting.
     * </pre>
     *
     * <code>STARTING = 13;</code>
     */
    public static final int STARTING_VALUE = 13;
    /**
     *
     *
     * <pre>
     * The migration job is restarting.
     * </pre>
     *
     * <code>RESTARTING = 14;</code>
     */
    public static final int RESTARTING_VALUE = 14;
    /**
     *
     *
     * <pre>
     * The migration job is resuming.
     * </pre>
     *
     * <code>RESUMING = 15;</code>
     */
    public static final int RESUMING_VALUE = 15;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return MAINTENANCE;
        case 2:
          return DRAFT;
        case 3:
          return CREATING;
        case 4:
          return NOT_STARTED;
        case 5:
          return RUNNING;
        case 6:
          return FAILED;
        case 7:
          return COMPLETED;
        case 8:
          return DELETING;
        case 9:
          return STOPPING;
        case 10:
          return STOPPED;
        case 11:
          return DELETED;
        case 12:
          return UPDATING;
        case 13:
          return STARTING;
        case 14:
          return RESTARTING;
        case 15:
          return RESUMING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.MigrationJob.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.clouddms.v1.MigrationJob.State)
  }

  /**
   *
   *
   * <pre>
   * The current migration job phase.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.clouddms.v1.MigrationJob.Phase}
   */
  public enum Phase implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The phase of the migration job is unknown.
     * </pre>
     *
     * <code>PHASE_UNSPECIFIED = 0;</code>
     */
    PHASE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The migration job is in the full dump phase.
     * </pre>
     *
     * <code>FULL_DUMP = 1;</code>
     */
    FULL_DUMP(1),
    /**
     *
     *
     * <pre>
     * The migration job is CDC phase.
     * </pre>
     *
     * <code>CDC = 2;</code>
     */
    CDC(2),
    /**
     *
     *
     * <pre>
     * The migration job is running the promote phase.
     * </pre>
     *
     * <code>PROMOTE_IN_PROGRESS = 3;</code>
     */
    PROMOTE_IN_PROGRESS(3),
    /**
     *
     *
     * <pre>
     * Only RDS flow - waiting for source writes to stop
     * </pre>
     *
     * <code>WAITING_FOR_SOURCE_WRITES_TO_STOP = 4;</code>
     */
    WAITING_FOR_SOURCE_WRITES_TO_STOP(4),
    /**
     *
     *
     * <pre>
     * Only RDS flow - the sources writes stopped, waiting for dump to begin
     * </pre>
     *
     * <code>PREPARING_THE_DUMP = 5;</code>
     */
    PREPARING_THE_DUMP(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The phase of the migration job is unknown.
     * </pre>
     *
     * <code>PHASE_UNSPECIFIED = 0;</code>
     */
    public static final int PHASE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The migration job is in the full dump phase.
     * </pre>
     *
     * <code>FULL_DUMP = 1;</code>
     */
    public static final int FULL_DUMP_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The migration job is CDC phase.
     * </pre>
     *
     * <code>CDC = 2;</code>
     */
    public static final int CDC_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The migration job is running the promote phase.
     * </pre>
     *
     * <code>PROMOTE_IN_PROGRESS = 3;</code>
     */
    public static final int PROMOTE_IN_PROGRESS_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Only RDS flow - waiting for source writes to stop
     * </pre>
     *
     * <code>WAITING_FOR_SOURCE_WRITES_TO_STOP = 4;</code>
     */
    public static final int WAITING_FOR_SOURCE_WRITES_TO_STOP_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Only RDS flow - the sources writes stopped, waiting for dump to begin
     * </pre>
     *
     * <code>PREPARING_THE_DUMP = 5;</code>
     */
    public static final int PREPARING_THE_DUMP_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Phase valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Phase forNumber(int value) {
      switch (value) {
        case 0:
          return PHASE_UNSPECIFIED;
        case 1:
          return FULL_DUMP;
        case 2:
          return CDC;
        case 3:
          return PROMOTE_IN_PROGRESS;
        case 4:
          return WAITING_FOR_SOURCE_WRITES_TO_STOP;
        case 5:
          return PREPARING_THE_DUMP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Phase> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Phase> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Phase>() {
          public Phase findValueByNumber(int number) {
            return Phase.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.MigrationJob.getDescriptor().getEnumTypes().get(1);
    }

    private static final Phase[] VALUES = values();

    public static Phase valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Phase(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.clouddms.v1.MigrationJob.Phase)
  }

  /**
   *
   *
   * <pre>
   * The type of migration job (one-time or continuous).
   * </pre>
   *
   * Protobuf enum {@code google.cloud.clouddms.v1.MigrationJob.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The type of the migration job is unknown.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The migration job is a one time migration.
     * </pre>
     *
     * <code>ONE_TIME = 1;</code>
     */
    ONE_TIME(1),
    /**
     *
     *
     * <pre>
     * The migration job is a continuous migration.
     * </pre>
     *
     * <code>CONTINUOUS = 2;</code>
     */
    CONTINUOUS(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The type of the migration job is unknown.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The migration job is a one time migration.
     * </pre>
     *
     * <code>ONE_TIME = 1;</code>
     */
    public static final int ONE_TIME_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The migration job is a continuous migration.
     * </pre>
     *
     * <code>CONTINUOUS = 2;</code>
     */
    public static final int CONTINUOUS_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return ONE_TIME;
        case 2:
          return CONTINUOUS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.MigrationJob.getDescriptor().getEnumTypes().get(2);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.clouddms.v1.MigrationJob.Type)
  }

  public interface DumpFlagOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.clouddms.v1.MigrationJob.DumpFlag)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the flag
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * The name of the flag
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * The value of the flag.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return The value.
     */
    java.lang.String getValue();
    /**
     *
     *
     * <pre>
     * The value of the flag.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return The bytes for value.
     */
    com.google.protobuf.ByteString getValueBytes();
  }
  /**
   *
   *
   * <pre>
   * Dump flag definition.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.MigrationJob.DumpFlag}
   */
  public static final class DumpFlag extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.MigrationJob.DumpFlag)
      DumpFlagOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DumpFlag.newBuilder() to construct.
    private DumpFlag(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DumpFlag() {
      name_ = "";
      value_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DumpFlag();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_MigrationJob_DumpFlag_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_MigrationJob_DumpFlag_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.MigrationJob.DumpFlag.class,
              com.google.cloud.clouddms.v1.MigrationJob.DumpFlag.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the flag
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the flag
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object value_ = "";
    /**
     *
     *
     * <pre>
     * The value of the flag.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        value_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The value of the flag.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return The bytes for value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, value_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.clouddms.v1.MigrationJob.DumpFlag)) {
        return super.equals(obj);
      }
      com.google.cloud.clouddms.v1.MigrationJob.DumpFlag other =
          (com.google.cloud.clouddms.v1.MigrationJob.DumpFlag) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getValue().equals(other.getValue())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlag parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlag parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlag parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlag parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlag parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlag parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlag parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlag parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlag parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlag parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlag parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlag parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.clouddms.v1.MigrationJob.DumpFlag prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Dump flag definition.
     * </pre>
     *
     * Protobuf type {@code google.cloud.clouddms.v1.MigrationJob.DumpFlag}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.MigrationJob.DumpFlag)
        com.google.cloud.clouddms.v1.MigrationJob.DumpFlagOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
            .internal_static_google_cloud_clouddms_v1_MigrationJob_DumpFlag_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
            .internal_static_google_cloud_clouddms_v1_MigrationJob_DumpFlag_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.clouddms.v1.MigrationJob.DumpFlag.class,
                com.google.cloud.clouddms.v1.MigrationJob.DumpFlag.Builder.class);
      }

      // Construct using com.google.cloud.clouddms.v1.MigrationJob.DumpFlag.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        value_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
            .internal_static_google_cloud_clouddms_v1_MigrationJob_DumpFlag_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.MigrationJob.DumpFlag getDefaultInstanceForType() {
        return com.google.cloud.clouddms.v1.MigrationJob.DumpFlag.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.MigrationJob.DumpFlag build() {
        com.google.cloud.clouddms.v1.MigrationJob.DumpFlag result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.MigrationJob.DumpFlag buildPartial() {
        com.google.cloud.clouddms.v1.MigrationJob.DumpFlag result =
            new com.google.cloud.clouddms.v1.MigrationJob.DumpFlag(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.clouddms.v1.MigrationJob.DumpFlag result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.value_ = value_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.clouddms.v1.MigrationJob.DumpFlag) {
          return mergeFrom((com.google.cloud.clouddms.v1.MigrationJob.DumpFlag) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.clouddms.v1.MigrationJob.DumpFlag other) {
        if (other == com.google.cloud.clouddms.v1.MigrationJob.DumpFlag.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getValue().isEmpty()) {
          value_ = other.value_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  value_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * The name of the flag
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the flag
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the flag
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the flag
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the flag
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object value_ = "";
      /**
       *
       *
       * <pre>
       * The value of the flag.
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          value_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The value of the flag.
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The value of the flag.
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value of the flag.
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        value_ = getDefaultInstance().getValue();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value of the flag.
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @param value The bytes for value to set.
       * @return This builder for chaining.
       */
      public Builder setValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        value_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.MigrationJob.DumpFlag)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.MigrationJob.DumpFlag)
    private static final com.google.cloud.clouddms.v1.MigrationJob.DumpFlag DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.MigrationJob.DumpFlag();
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlag getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DumpFlag> PARSER =
        new com.google.protobuf.AbstractParser<DumpFlag>() {
          @java.lang.Override
          public DumpFlag parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DumpFlag> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DumpFlag> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MigrationJob.DumpFlag getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DumpFlagsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.clouddms.v1.MigrationJob.DumpFlags)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The flags for the initial dump.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
     */
    java.util.List<com.google.cloud.clouddms.v1.MigrationJob.DumpFlag> getDumpFlagsList();
    /**
     *
     *
     * <pre>
     * The flags for the initial dump.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
     */
    com.google.cloud.clouddms.v1.MigrationJob.DumpFlag getDumpFlags(int index);
    /**
     *
     *
     * <pre>
     * The flags for the initial dump.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
     */
    int getDumpFlagsCount();
    /**
     *
     *
     * <pre>
     * The flags for the initial dump.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
     */
    java.util.List<? extends com.google.cloud.clouddms.v1.MigrationJob.DumpFlagOrBuilder>
        getDumpFlagsOrBuilderList();
    /**
     *
     *
     * <pre>
     * The flags for the initial dump.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
     */
    com.google.cloud.clouddms.v1.MigrationJob.DumpFlagOrBuilder getDumpFlagsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Dump flags definition.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.MigrationJob.DumpFlags}
   */
  public static final class DumpFlags extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.MigrationJob.DumpFlags)
      DumpFlagsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DumpFlags.newBuilder() to construct.
    private DumpFlags(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DumpFlags() {
      dumpFlags_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DumpFlags();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_MigrationJob_DumpFlags_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_MigrationJob_DumpFlags_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.MigrationJob.DumpFlags.class,
              com.google.cloud.clouddms.v1.MigrationJob.DumpFlags.Builder.class);
    }

    public static final int DUMP_FLAGS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.clouddms.v1.MigrationJob.DumpFlag> dumpFlags_;
    /**
     *
     *
     * <pre>
     * The flags for the initial dump.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.clouddms.v1.MigrationJob.DumpFlag> getDumpFlagsList() {
      return dumpFlags_;
    }
    /**
     *
     *
     * <pre>
     * The flags for the initial dump.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.clouddms.v1.MigrationJob.DumpFlagOrBuilder>
        getDumpFlagsOrBuilderList() {
      return dumpFlags_;
    }
    /**
     *
     *
     * <pre>
     * The flags for the initial dump.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
     */
    @java.lang.Override
    public int getDumpFlagsCount() {
      return dumpFlags_.size();
    }
    /**
     *
     *
     * <pre>
     * The flags for the initial dump.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.MigrationJob.DumpFlag getDumpFlags(int index) {
      return dumpFlags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The flags for the initial dump.
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.MigrationJob.DumpFlagOrBuilder getDumpFlagsOrBuilder(
        int index) {
      return dumpFlags_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < dumpFlags_.size(); i++) {
        output.writeMessage(1, dumpFlags_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < dumpFlags_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, dumpFlags_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.clouddms.v1.MigrationJob.DumpFlags)) {
        return super.equals(obj);
      }
      com.google.cloud.clouddms.v1.MigrationJob.DumpFlags other =
          (com.google.cloud.clouddms.v1.MigrationJob.DumpFlags) obj;

      if (!getDumpFlagsList().equals(other.getDumpFlagsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDumpFlagsCount() > 0) {
        hash = (37 * hash) + DUMP_FLAGS_FIELD_NUMBER;
        hash = (53 * hash) + getDumpFlagsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlags parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlags parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlags parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlags parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlags parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlags parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlags parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlags parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlags parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlags parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlags parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlags parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.clouddms.v1.MigrationJob.DumpFlags prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Dump flags definition.
     * </pre>
     *
     * Protobuf type {@code google.cloud.clouddms.v1.MigrationJob.DumpFlags}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.MigrationJob.DumpFlags)
        com.google.cloud.clouddms.v1.MigrationJob.DumpFlagsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
            .internal_static_google_cloud_clouddms_v1_MigrationJob_DumpFlags_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
            .internal_static_google_cloud_clouddms_v1_MigrationJob_DumpFlags_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.clouddms.v1.MigrationJob.DumpFlags.class,
                com.google.cloud.clouddms.v1.MigrationJob.DumpFlags.Builder.class);
      }

      // Construct using com.google.cloud.clouddms.v1.MigrationJob.DumpFlags.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (dumpFlagsBuilder_ == null) {
          dumpFlags_ = java.util.Collections.emptyList();
        } else {
          dumpFlags_ = null;
          dumpFlagsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
            .internal_static_google_cloud_clouddms_v1_MigrationJob_DumpFlags_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.MigrationJob.DumpFlags getDefaultInstanceForType() {
        return com.google.cloud.clouddms.v1.MigrationJob.DumpFlags.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.MigrationJob.DumpFlags build() {
        com.google.cloud.clouddms.v1.MigrationJob.DumpFlags result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.MigrationJob.DumpFlags buildPartial() {
        com.google.cloud.clouddms.v1.MigrationJob.DumpFlags result =
            new com.google.cloud.clouddms.v1.MigrationJob.DumpFlags(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.clouddms.v1.MigrationJob.DumpFlags result) {
        if (dumpFlagsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            dumpFlags_ = java.util.Collections.unmodifiableList(dumpFlags_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.dumpFlags_ = dumpFlags_;
        } else {
          result.dumpFlags_ = dumpFlagsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.clouddms.v1.MigrationJob.DumpFlags result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.clouddms.v1.MigrationJob.DumpFlags) {
          return mergeFrom((com.google.cloud.clouddms.v1.MigrationJob.DumpFlags) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.clouddms.v1.MigrationJob.DumpFlags other) {
        if (other == com.google.cloud.clouddms.v1.MigrationJob.DumpFlags.getDefaultInstance())
          return this;
        if (dumpFlagsBuilder_ == null) {
          if (!other.dumpFlags_.isEmpty()) {
            if (dumpFlags_.isEmpty()) {
              dumpFlags_ = other.dumpFlags_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureDumpFlagsIsMutable();
              dumpFlags_.addAll(other.dumpFlags_);
            }
            onChanged();
          }
        } else {
          if (!other.dumpFlags_.isEmpty()) {
            if (dumpFlagsBuilder_.isEmpty()) {
              dumpFlagsBuilder_.dispose();
              dumpFlagsBuilder_ = null;
              dumpFlags_ = other.dumpFlags_;
              bitField0_ = (bitField0_ & ~0x00000001);
              dumpFlagsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDumpFlagsFieldBuilder()
                      : null;
            } else {
              dumpFlagsBuilder_.addAllMessages(other.dumpFlags_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.clouddms.v1.MigrationJob.DumpFlag m =
                      input.readMessage(
                          com.google.cloud.clouddms.v1.MigrationJob.DumpFlag.parser(),
                          extensionRegistry);
                  if (dumpFlagsBuilder_ == null) {
                    ensureDumpFlagsIsMutable();
                    dumpFlags_.add(m);
                  } else {
                    dumpFlagsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.clouddms.v1.MigrationJob.DumpFlag> dumpFlags_ =
          java.util.Collections.emptyList();

      private void ensureDumpFlagsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          dumpFlags_ =
              new java.util.ArrayList<com.google.cloud.clouddms.v1.MigrationJob.DumpFlag>(
                  dumpFlags_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.clouddms.v1.MigrationJob.DumpFlag,
              com.google.cloud.clouddms.v1.MigrationJob.DumpFlag.Builder,
              com.google.cloud.clouddms.v1.MigrationJob.DumpFlagOrBuilder>
          dumpFlagsBuilder_;

      /**
       *
       *
       * <pre>
       * The flags for the initial dump.
       * </pre>
       *
       * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
       */
      public java.util.List<com.google.cloud.clouddms.v1.MigrationJob.DumpFlag> getDumpFlagsList() {
        if (dumpFlagsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(dumpFlags_);
        } else {
          return dumpFlagsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The flags for the initial dump.
       * </pre>
       *
       * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
       */
      public int getDumpFlagsCount() {
        if (dumpFlagsBuilder_ == null) {
          return dumpFlags_.size();
        } else {
          return dumpFlagsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The flags for the initial dump.
       * </pre>
       *
       * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
       */
      public com.google.cloud.clouddms.v1.MigrationJob.DumpFlag getDumpFlags(int index) {
        if (dumpFlagsBuilder_ == null) {
          return dumpFlags_.get(index);
        } else {
          return dumpFlagsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The flags for the initial dump.
       * </pre>
       *
       * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
       */
      public Builder setDumpFlags(
          int index, com.google.cloud.clouddms.v1.MigrationJob.DumpFlag value) {
        if (dumpFlagsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDumpFlagsIsMutable();
          dumpFlags_.set(index, value);
          onChanged();
        } else {
          dumpFlagsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The flags for the initial dump.
       * </pre>
       *
       * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
       */
      public Builder setDumpFlags(
          int index, com.google.cloud.clouddms.v1.MigrationJob.DumpFlag.Builder builderForValue) {
        if (dumpFlagsBuilder_ == null) {
          ensureDumpFlagsIsMutable();
          dumpFlags_.set(index, builderForValue.build());
          onChanged();
        } else {
          dumpFlagsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The flags for the initial dump.
       * </pre>
       *
       * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
       */
      public Builder addDumpFlags(com.google.cloud.clouddms.v1.MigrationJob.DumpFlag value) {
        if (dumpFlagsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDumpFlagsIsMutable();
          dumpFlags_.add(value);
          onChanged();
        } else {
          dumpFlagsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The flags for the initial dump.
       * </pre>
       *
       * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
       */
      public Builder addDumpFlags(
          int index, com.google.cloud.clouddms.v1.MigrationJob.DumpFlag value) {
        if (dumpFlagsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDumpFlagsIsMutable();
          dumpFlags_.add(index, value);
          onChanged();
        } else {
          dumpFlagsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The flags for the initial dump.
       * </pre>
       *
       * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
       */
      public Builder addDumpFlags(
          com.google.cloud.clouddms.v1.MigrationJob.DumpFlag.Builder builderForValue) {
        if (dumpFlagsBuilder_ == null) {
          ensureDumpFlagsIsMutable();
          dumpFlags_.add(builderForValue.build());
          onChanged();
        } else {
          dumpFlagsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The flags for the initial dump.
       * </pre>
       *
       * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
       */
      public Builder addDumpFlags(
          int index, com.google.cloud.clouddms.v1.MigrationJob.DumpFlag.Builder builderForValue) {
        if (dumpFlagsBuilder_ == null) {
          ensureDumpFlagsIsMutable();
          dumpFlags_.add(index, builderForValue.build());
          onChanged();
        } else {
          dumpFlagsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The flags for the initial dump.
       * </pre>
       *
       * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
       */
      public Builder addAllDumpFlags(
          java.lang.Iterable<? extends com.google.cloud.clouddms.v1.MigrationJob.DumpFlag> values) {
        if (dumpFlagsBuilder_ == null) {
          ensureDumpFlagsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dumpFlags_);
          onChanged();
        } else {
          dumpFlagsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The flags for the initial dump.
       * </pre>
       *
       * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
       */
      public Builder clearDumpFlags() {
        if (dumpFlagsBuilder_ == null) {
          dumpFlags_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          dumpFlagsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The flags for the initial dump.
       * </pre>
       *
       * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
       */
      public Builder removeDumpFlags(int index) {
        if (dumpFlagsBuilder_ == null) {
          ensureDumpFlagsIsMutable();
          dumpFlags_.remove(index);
          onChanged();
        } else {
          dumpFlagsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The flags for the initial dump.
       * </pre>
       *
       * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
       */
      public com.google.cloud.clouddms.v1.MigrationJob.DumpFlag.Builder getDumpFlagsBuilder(
          int index) {
        return getDumpFlagsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The flags for the initial dump.
       * </pre>
       *
       * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
       */
      public com.google.cloud.clouddms.v1.MigrationJob.DumpFlagOrBuilder getDumpFlagsOrBuilder(
          int index) {
        if (dumpFlagsBuilder_ == null) {
          return dumpFlags_.get(index);
        } else {
          return dumpFlagsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The flags for the initial dump.
       * </pre>
       *
       * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
       */
      public java.util.List<? extends com.google.cloud.clouddms.v1.MigrationJob.DumpFlagOrBuilder>
          getDumpFlagsOrBuilderList() {
        if (dumpFlagsBuilder_ != null) {
          return dumpFlagsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(dumpFlags_);
        }
      }
      /**
       *
       *
       * <pre>
       * The flags for the initial dump.
       * </pre>
       *
       * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
       */
      public com.google.cloud.clouddms.v1.MigrationJob.DumpFlag.Builder addDumpFlagsBuilder() {
        return getDumpFlagsFieldBuilder()
            .addBuilder(com.google.cloud.clouddms.v1.MigrationJob.DumpFlag.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The flags for the initial dump.
       * </pre>
       *
       * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
       */
      public com.google.cloud.clouddms.v1.MigrationJob.DumpFlag.Builder addDumpFlagsBuilder(
          int index) {
        return getDumpFlagsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.clouddms.v1.MigrationJob.DumpFlag.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The flags for the initial dump.
       * </pre>
       *
       * <code>repeated .google.cloud.clouddms.v1.MigrationJob.DumpFlag dump_flags = 1;</code>
       */
      public java.util.List<com.google.cloud.clouddms.v1.MigrationJob.DumpFlag.Builder>
          getDumpFlagsBuilderList() {
        return getDumpFlagsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.clouddms.v1.MigrationJob.DumpFlag,
              com.google.cloud.clouddms.v1.MigrationJob.DumpFlag.Builder,
              com.google.cloud.clouddms.v1.MigrationJob.DumpFlagOrBuilder>
          getDumpFlagsFieldBuilder() {
        if (dumpFlagsBuilder_ == null) {
          dumpFlagsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.clouddms.v1.MigrationJob.DumpFlag,
                  com.google.cloud.clouddms.v1.MigrationJob.DumpFlag.Builder,
                  com.google.cloud.clouddms.v1.MigrationJob.DumpFlagOrBuilder>(
                  dumpFlags_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          dumpFlags_ = null;
        }
        return dumpFlagsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.MigrationJob.DumpFlags)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.MigrationJob.DumpFlags)
    private static final com.google.cloud.clouddms.v1.MigrationJob.DumpFlags DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.MigrationJob.DumpFlags();
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.DumpFlags getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DumpFlags> PARSER =
        new com.google.protobuf.AbstractParser<DumpFlags>() {
          @java.lang.Override
          public DumpFlags parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DumpFlags> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DumpFlags> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MigrationJob.DumpFlags getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PerformanceConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.clouddms.v1.MigrationJob.PerformanceConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Initial dump parallelism level.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel dump_parallel_level = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for dumpParallelLevel.
     */
    int getDumpParallelLevelValue();
    /**
     *
     *
     * <pre>
     * Initial dump parallelism level.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel dump_parallel_level = 1;
     * </code>
     *
     * @return The dumpParallelLevel.
     */
    com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel
        getDumpParallelLevel();
  }
  /**
   *
   *
   * <pre>
   * Performance configuration definition.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.MigrationJob.PerformanceConfig}
   */
  public static final class PerformanceConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.MigrationJob.PerformanceConfig)
      PerformanceConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PerformanceConfig.newBuilder() to construct.
    private PerformanceConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PerformanceConfig() {
      dumpParallelLevel_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PerformanceConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_MigrationJob_PerformanceConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_MigrationJob_PerformanceConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.class,
              com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Describes the parallelism level during initial dump.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel}
     */
    public enum DumpParallelLevel implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unknown dump parallel level. Will be defaulted to OPTIMAL.
       * </pre>
       *
       * <code>DUMP_PARALLEL_LEVEL_UNSPECIFIED = 0;</code>
       */
      DUMP_PARALLEL_LEVEL_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Minimal parallel level.
       * </pre>
       *
       * <code>MIN = 1;</code>
       */
      MIN(1),
      /**
       *
       *
       * <pre>
       * Optimal parallel level.
       * </pre>
       *
       * <code>OPTIMAL = 2;</code>
       */
      OPTIMAL(2),
      /**
       *
       *
       * <pre>
       * Maximum parallel level.
       * </pre>
       *
       * <code>MAX = 3;</code>
       */
      MAX(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unknown dump parallel level. Will be defaulted to OPTIMAL.
       * </pre>
       *
       * <code>DUMP_PARALLEL_LEVEL_UNSPECIFIED = 0;</code>
       */
      public static final int DUMP_PARALLEL_LEVEL_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Minimal parallel level.
       * </pre>
       *
       * <code>MIN = 1;</code>
       */
      public static final int MIN_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Optimal parallel level.
       * </pre>
       *
       * <code>OPTIMAL = 2;</code>
       */
      public static final int OPTIMAL_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Maximum parallel level.
       * </pre>
       *
       * <code>MAX = 3;</code>
       */
      public static final int MAX_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DumpParallelLevel valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static DumpParallelLevel forNumber(int value) {
        switch (value) {
          case 0:
            return DUMP_PARALLEL_LEVEL_UNSPECIFIED;
          case 1:
            return MIN;
          case 2:
            return OPTIMAL;
          case 3:
            return MAX;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<DumpParallelLevel>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<DumpParallelLevel>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<DumpParallelLevel>() {
                public DumpParallelLevel findValueByNumber(int number) {
                  return DumpParallelLevel.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final DumpParallelLevel[] VALUES = values();

      public static DumpParallelLevel valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private DumpParallelLevel(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel)
    }

    public static final int DUMP_PARALLEL_LEVEL_FIELD_NUMBER = 1;
    private int dumpParallelLevel_ = 0;
    /**
     *
     *
     * <pre>
     * Initial dump parallelism level.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel dump_parallel_level = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for dumpParallelLevel.
     */
    @java.lang.Override
    public int getDumpParallelLevelValue() {
      return dumpParallelLevel_;
    }
    /**
     *
     *
     * <pre>
     * Initial dump parallelism level.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel dump_parallel_level = 1;
     * </code>
     *
     * @return The dumpParallelLevel.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel
        getDumpParallelLevel() {
      com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel result =
          com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel.forNumber(
              dumpParallelLevel_);
      return result == null
          ? com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (dumpParallelLevel_
          != com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel
              .DUMP_PARALLEL_LEVEL_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, dumpParallelLevel_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (dumpParallelLevel_
          != com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel
              .DUMP_PARALLEL_LEVEL_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, dumpParallelLevel_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig other =
          (com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig) obj;

      if (dumpParallelLevel_ != other.dumpParallelLevel_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DUMP_PARALLEL_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + dumpParallelLevel_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Performance configuration definition.
     * </pre>
     *
     * Protobuf type {@code google.cloud.clouddms.v1.MigrationJob.PerformanceConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.MigrationJob.PerformanceConfig)
        com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
            .internal_static_google_cloud_clouddms_v1_MigrationJob_PerformanceConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
            .internal_static_google_cloud_clouddms_v1_MigrationJob_PerformanceConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.class,
                com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.Builder.class);
      }

      // Construct using com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        dumpParallelLevel_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
            .internal_static_google_cloud_clouddms_v1_MigrationJob_PerformanceConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig
          getDefaultInstanceForType() {
        return com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig build() {
        com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig buildPartial() {
        com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig result =
            new com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.dumpParallelLevel_ = dumpParallelLevel_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig) {
          return mergeFrom((com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig other) {
        if (other
            == com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.getDefaultInstance())
          return this;
        if (other.dumpParallelLevel_ != 0) {
          setDumpParallelLevelValue(other.getDumpParallelLevelValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  dumpParallelLevel_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int dumpParallelLevel_ = 0;
      /**
       *
       *
       * <pre>
       * Initial dump parallelism level.
       * </pre>
       *
       * <code>
       * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel dump_parallel_level = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for dumpParallelLevel.
       */
      @java.lang.Override
      public int getDumpParallelLevelValue() {
        return dumpParallelLevel_;
      }
      /**
       *
       *
       * <pre>
       * Initial dump parallelism level.
       * </pre>
       *
       * <code>
       * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel dump_parallel_level = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for dumpParallelLevel to set.
       * @return This builder for chaining.
       */
      public Builder setDumpParallelLevelValue(int value) {
        dumpParallelLevel_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Initial dump parallelism level.
       * </pre>
       *
       * <code>
       * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel dump_parallel_level = 1;
       * </code>
       *
       * @return The dumpParallelLevel.
       */
      @java.lang.Override
      public com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel
          getDumpParallelLevel() {
        com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel result =
            com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel.forNumber(
                dumpParallelLevel_);
        return result == null
            ? com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Initial dump parallelism level.
       * </pre>
       *
       * <code>
       * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel dump_parallel_level = 1;
       * </code>
       *
       * @param value The dumpParallelLevel to set.
       * @return This builder for chaining.
       */
      public Builder setDumpParallelLevel(
          com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        dumpParallelLevel_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Initial dump parallelism level.
       * </pre>
       *
       * <code>
       * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.DumpParallelLevel dump_parallel_level = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDumpParallelLevel() {
        bitField0_ = (bitField0_ & ~0x00000001);
        dumpParallelLevel_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.MigrationJob.PerformanceConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.MigrationJob.PerformanceConfig)
    private static final com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig();
    }

    public static com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PerformanceConfig> PARSER =
        new com.google.protobuf.AbstractParser<PerformanceConfig>() {
          @java.lang.Override
          public PerformanceConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PerformanceConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PerformanceConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int connectivityCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object connectivity_;

  public enum ConnectivityCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    REVERSE_SSH_CONNECTIVITY(101),
    VPC_PEERING_CONNECTIVITY(102),
    STATIC_IP_CONNECTIVITY(103),
    CONNECTIVITY_NOT_SET(0);
    private final int value;

    private ConnectivityCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConnectivityCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConnectivityCase forNumber(int value) {
      switch (value) {
        case 101:
          return REVERSE_SSH_CONNECTIVITY;
        case 102:
          return VPC_PEERING_CONNECTIVITY;
        case 103:
          return STATIC_IP_CONNECTIVITY;
        case 0:
          return CONNECTIVITY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConnectivityCase getConnectivityCase() {
    return ConnectivityCase.forNumber(connectivityCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name (URI) of this migration job resource, in the form of:
   * projects/{project}/locations/{location}/migrationJobs/{migrationJob}.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name (URI) of this migration job resource, in the form of:
   * projects/{project}/locations/{location}/migrationJobs/{migrationJob}.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the migration job resource was created.
   * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
   * Example: "2014-10-02T15:01:23.045123456Z".
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the migration job resource was created.
   * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
   * Example: "2014-10-02T15:01:23.045123456Z".
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the migration job resource was created.
   * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
   * Example: "2014-10-02T15:01:23.045123456Z".
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the migration job resource was last
   * updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
   * Example: "2014-10-02T15:01:23.045123456Z".
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the migration job resource was last
   * updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
   * Example: "2014-10-02T15:01:23.045123456Z".
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the migration job resource was last
   * updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
   * Example: "2014-10-02T15:01:23.045123456Z".
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.clouddms.v1.ClouddmsResourcesProto
                .internal_static_google_cloud_clouddms_v1_MigrationJob_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The resource labels for migration job to use to annotate any related
   * underlying resources such as Compute Engine VMs. An object containing a
   * list of "key": "value" pairs.
   *
   * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The resource labels for migration job to use to annotate any related
   * underlying resources such as Compute Engine VMs. An object containing a
   * list of "key": "value" pairs.
   *
   * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The resource labels for migration job to use to annotate any related
   * underlying resources such as Compute Engine VMs. An object containing a
   * list of "key": "value" pairs.
   *
   * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The resource labels for migration job to use to annotate any related
   * underlying resources such as Compute Engine VMs. An object containing a
   * list of "key": "value" pairs.
   *
   * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The migration job display name.
   * </pre>
   *
   * <code>string display_name = 5;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The migration job display name.
   * </pre>
   *
   * <code>string display_name = 5;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 6;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * The current migration job state.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.MigrationJob.State state = 6;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * The current migration job state.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.MigrationJob.State state = 6;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MigrationJob.State getState() {
    com.google.cloud.clouddms.v1.MigrationJob.State result =
        com.google.cloud.clouddms.v1.MigrationJob.State.forNumber(state_);
    return result == null ? com.google.cloud.clouddms.v1.MigrationJob.State.UNRECOGNIZED : result;
  }

  public static final int PHASE_FIELD_NUMBER = 7;
  private int phase_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current migration job phase.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MigrationJob.Phase phase = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for phase.
   */
  @java.lang.Override
  public int getPhaseValue() {
    return phase_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current migration job phase.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MigrationJob.Phase phase = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The phase.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MigrationJob.Phase getPhase() {
    com.google.cloud.clouddms.v1.MigrationJob.Phase result =
        com.google.cloud.clouddms.v1.MigrationJob.Phase.forNumber(phase_);
    return result == null ? com.google.cloud.clouddms.v1.MigrationJob.Phase.UNRECOGNIZED : result;
  }

  public static final int TYPE_FIELD_NUMBER = 8;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The migration job type.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MigrationJob.Type type = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Required. The migration job type.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MigrationJob.Type type = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MigrationJob.Type getType() {
    com.google.cloud.clouddms.v1.MigrationJob.Type result =
        com.google.cloud.clouddms.v1.MigrationJob.Type.forNumber(type_);
    return result == null ? com.google.cloud.clouddms.v1.MigrationJob.Type.UNRECOGNIZED : result;
  }

  public static final int DUMP_PATH_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dumpPath_ = "";
  /**
   *
   *
   * <pre>
   * The path to the dump file in Google Cloud Storage,
   * in the format: (gs://[BUCKET_NAME]/[OBJECT_NAME]).
   * This field and the "dump_flags" field are mutually exclusive.
   * </pre>
   *
   * <code>string dump_path = 9;</code>
   *
   * @return The dumpPath.
   */
  @java.lang.Override
  public java.lang.String getDumpPath() {
    java.lang.Object ref = dumpPath_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dumpPath_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The path to the dump file in Google Cloud Storage,
   * in the format: (gs://[BUCKET_NAME]/[OBJECT_NAME]).
   * This field and the "dump_flags" field are mutually exclusive.
   * </pre>
   *
   * <code>string dump_path = 9;</code>
   *
   * @return The bytes for dumpPath.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDumpPathBytes() {
    java.lang.Object ref = dumpPath_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dumpPath_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DUMP_FLAGS_FIELD_NUMBER = 17;
  private com.google.cloud.clouddms.v1.MigrationJob.DumpFlags dumpFlags_;
  /**
   *
   *
   * <pre>
   * The initial dump flags.
   * This field and the "dump_path" field are mutually exclusive.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.MigrationJob.DumpFlags dump_flags = 17;</code>
   *
   * @return Whether the dumpFlags field is set.
   */
  @java.lang.Override
  public boolean hasDumpFlags() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The initial dump flags.
   * This field and the "dump_path" field are mutually exclusive.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.MigrationJob.DumpFlags dump_flags = 17;</code>
   *
   * @return The dumpFlags.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MigrationJob.DumpFlags getDumpFlags() {
    return dumpFlags_ == null
        ? com.google.cloud.clouddms.v1.MigrationJob.DumpFlags.getDefaultInstance()
        : dumpFlags_;
  }
  /**
   *
   *
   * <pre>
   * The initial dump flags.
   * This field and the "dump_path" field are mutually exclusive.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.MigrationJob.DumpFlags dump_flags = 17;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MigrationJob.DumpFlagsOrBuilder getDumpFlagsOrBuilder() {
    return dumpFlags_ == null
        ? com.google.cloud.clouddms.v1.MigrationJob.DumpFlags.getDefaultInstance()
        : dumpFlags_;
  }

  public static final int SOURCE_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object source_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name (URI) of the source connection profile.
   * </pre>
   *
   * <code>string source = 10 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The source.
   */
  @java.lang.Override
  public java.lang.String getSource() {
    java.lang.Object ref = source_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      source_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name (URI) of the source connection profile.
   * </pre>
   *
   * <code>string source = 10 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for source.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceBytes() {
    java.lang.Object ref = source_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      source_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESTINATION_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object destination_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name (URI) of the destination connection profile.
   * </pre>
   *
   * <code>string destination = 11 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The destination.
   */
  @java.lang.Override
  public java.lang.String getDestination() {
    java.lang.Object ref = destination_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      destination_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name (URI) of the destination connection profile.
   * </pre>
   *
   * <code>string destination = 11 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for destination.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDestinationBytes() {
    java.lang.Object ref = destination_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      destination_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REVERSE_SSH_CONNECTIVITY_FIELD_NUMBER = 101;
  /**
   *
   *
   * <pre>
   * The details needed to communicate to the source over Reverse SSH
   * tunnel connectivity.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.ReverseSshConnectivity reverse_ssh_connectivity = 101;</code>
   *
   * @return Whether the reverseSshConnectivity field is set.
   */
  @java.lang.Override
  public boolean hasReverseSshConnectivity() {
    return connectivityCase_ == 101;
  }
  /**
   *
   *
   * <pre>
   * The details needed to communicate to the source over Reverse SSH
   * tunnel connectivity.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.ReverseSshConnectivity reverse_ssh_connectivity = 101;</code>
   *
   * @return The reverseSshConnectivity.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ReverseSshConnectivity getReverseSshConnectivity() {
    if (connectivityCase_ == 101) {
      return (com.google.cloud.clouddms.v1.ReverseSshConnectivity) connectivity_;
    }
    return com.google.cloud.clouddms.v1.ReverseSshConnectivity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The details needed to communicate to the source over Reverse SSH
   * tunnel connectivity.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.ReverseSshConnectivity reverse_ssh_connectivity = 101;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ReverseSshConnectivityOrBuilder
      getReverseSshConnectivityOrBuilder() {
    if (connectivityCase_ == 101) {
      return (com.google.cloud.clouddms.v1.ReverseSshConnectivity) connectivity_;
    }
    return com.google.cloud.clouddms.v1.ReverseSshConnectivity.getDefaultInstance();
  }

  public static final int VPC_PEERING_CONNECTIVITY_FIELD_NUMBER = 102;
  /**
   *
   *
   * <pre>
   * The details of the VPC network that the source database is located in.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.VpcPeeringConnectivity vpc_peering_connectivity = 102;</code>
   *
   * @return Whether the vpcPeeringConnectivity field is set.
   */
  @java.lang.Override
  public boolean hasVpcPeeringConnectivity() {
    return connectivityCase_ == 102;
  }
  /**
   *
   *
   * <pre>
   * The details of the VPC network that the source database is located in.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.VpcPeeringConnectivity vpc_peering_connectivity = 102;</code>
   *
   * @return The vpcPeeringConnectivity.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.VpcPeeringConnectivity getVpcPeeringConnectivity() {
    if (connectivityCase_ == 102) {
      return (com.google.cloud.clouddms.v1.VpcPeeringConnectivity) connectivity_;
    }
    return com.google.cloud.clouddms.v1.VpcPeeringConnectivity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The details of the VPC network that the source database is located in.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.VpcPeeringConnectivity vpc_peering_connectivity = 102;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.VpcPeeringConnectivityOrBuilder
      getVpcPeeringConnectivityOrBuilder() {
    if (connectivityCase_ == 102) {
      return (com.google.cloud.clouddms.v1.VpcPeeringConnectivity) connectivity_;
    }
    return com.google.cloud.clouddms.v1.VpcPeeringConnectivity.getDefaultInstance();
  }

  public static final int STATIC_IP_CONNECTIVITY_FIELD_NUMBER = 103;
  /**
   *
   *
   * <pre>
   * static ip connectivity data (default, no additional details needed).
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.StaticIpConnectivity static_ip_connectivity = 103;</code>
   *
   * @return Whether the staticIpConnectivity field is set.
   */
  @java.lang.Override
  public boolean hasStaticIpConnectivity() {
    return connectivityCase_ == 103;
  }
  /**
   *
   *
   * <pre>
   * static ip connectivity data (default, no additional details needed).
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.StaticIpConnectivity static_ip_connectivity = 103;</code>
   *
   * @return The staticIpConnectivity.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.StaticIpConnectivity getStaticIpConnectivity() {
    if (connectivityCase_ == 103) {
      return (com.google.cloud.clouddms.v1.StaticIpConnectivity) connectivity_;
    }
    return com.google.cloud.clouddms.v1.StaticIpConnectivity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * static ip connectivity data (default, no additional details needed).
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.StaticIpConnectivity static_ip_connectivity = 103;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.StaticIpConnectivityOrBuilder
      getStaticIpConnectivityOrBuilder() {
    if (connectivityCase_ == 103) {
      return (com.google.cloud.clouddms.v1.StaticIpConnectivity) connectivity_;
    }
    return com.google.cloud.clouddms.v1.StaticIpConnectivity.getDefaultInstance();
  }

  public static final int DURATION_FIELD_NUMBER = 12;
  private com.google.protobuf.Duration duration_;
  /**
   *
   *
   * <pre>
   * Output only. The duration of the migration job (in seconds). A duration in
   * seconds with up to nine fractional digits, terminated by 's'. Example:
   * "3.5s".
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the duration field is set.
   */
  @java.lang.Override
  public boolean hasDuration() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The duration of the migration job (in seconds). A duration in
   * seconds with up to nine fractional digits, terminated by 's'. Example:
   * "3.5s".
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The duration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getDuration() {
    return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The duration of the migration job (in seconds). A duration in
   * seconds with up to nine fractional digits, terminated by 's'. Example:
   * "3.5s".
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
    return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
  }

  public static final int ERROR_FIELD_NUMBER = 13;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * Output only. The error details in case of state FAILED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The error details in case of state FAILED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The error details in case of state FAILED.
   * </pre>
   *
   * <code>.google.rpc.Status error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }

  public static final int SOURCE_DATABASE_FIELD_NUMBER = 14;
  private com.google.cloud.clouddms.v1.DatabaseType sourceDatabase_;
  /**
   *
   *
   * <pre>
   * The database engine type and provider of the source.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseType source_database = 14;</code>
   *
   * @return Whether the sourceDatabase field is set.
   */
  @java.lang.Override
  public boolean hasSourceDatabase() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * The database engine type and provider of the source.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseType source_database = 14;</code>
   *
   * @return The sourceDatabase.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DatabaseType getSourceDatabase() {
    return sourceDatabase_ == null
        ? com.google.cloud.clouddms.v1.DatabaseType.getDefaultInstance()
        : sourceDatabase_;
  }
  /**
   *
   *
   * <pre>
   * The database engine type and provider of the source.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseType source_database = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DatabaseTypeOrBuilder getSourceDatabaseOrBuilder() {
    return sourceDatabase_ == null
        ? com.google.cloud.clouddms.v1.DatabaseType.getDefaultInstance()
        : sourceDatabase_;
  }

  public static final int DESTINATION_DATABASE_FIELD_NUMBER = 15;
  private com.google.cloud.clouddms.v1.DatabaseType destinationDatabase_;
  /**
   *
   *
   * <pre>
   * The database engine type and provider of the destination.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseType destination_database = 15;</code>
   *
   * @return Whether the destinationDatabase field is set.
   */
  @java.lang.Override
  public boolean hasDestinationDatabase() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * The database engine type and provider of the destination.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseType destination_database = 15;</code>
   *
   * @return The destinationDatabase.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DatabaseType getDestinationDatabase() {
    return destinationDatabase_ == null
        ? com.google.cloud.clouddms.v1.DatabaseType.getDefaultInstance()
        : destinationDatabase_;
  }
  /**
   *
   *
   * <pre>
   * The database engine type and provider of the destination.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.DatabaseType destination_database = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DatabaseTypeOrBuilder getDestinationDatabaseOrBuilder() {
    return destinationDatabase_ == null
        ? com.google.cloud.clouddms.v1.DatabaseType.getDefaultInstance()
        : destinationDatabase_;
  }

  public static final int END_TIME_FIELD_NUMBER = 16;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. If the migration job is completed, the time when it was
   * completed.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. If the migration job is completed, the time when it was
   * completed.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. If the migration job is completed, the time when it was
   * completed.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int CONVERSION_WORKSPACE_FIELD_NUMBER = 18;
  private com.google.cloud.clouddms.v1.ConversionWorkspaceInfo conversionWorkspace_;
  /**
   *
   *
   * <pre>
   * The conversion workspace used by the migration.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.ConversionWorkspaceInfo conversion_workspace = 18;</code>
   *
   * @return Whether the conversionWorkspace field is set.
   */
  @java.lang.Override
  public boolean hasConversionWorkspace() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * The conversion workspace used by the migration.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.ConversionWorkspaceInfo conversion_workspace = 18;</code>
   *
   * @return The conversionWorkspace.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ConversionWorkspaceInfo getConversionWorkspace() {
    return conversionWorkspace_ == null
        ? com.google.cloud.clouddms.v1.ConversionWorkspaceInfo.getDefaultInstance()
        : conversionWorkspace_;
  }
  /**
   *
   *
   * <pre>
   * The conversion workspace used by the migration.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.ConversionWorkspaceInfo conversion_workspace = 18;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ConversionWorkspaceInfoOrBuilder
      getConversionWorkspaceOrBuilder() {
    return conversionWorkspace_ == null
        ? com.google.cloud.clouddms.v1.ConversionWorkspaceInfo.getDefaultInstance()
        : conversionWorkspace_;
  }

  public static final int FILTER_FIELD_NUMBER = 20;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";
  /**
   *
   *
   * <pre>
   * This field can be used to select the entities to migrate as part of
   * the migration job. It uses AIP-160 notation to select a subset of the
   * entities configured on the associated conversion-workspace. This field
   * should not be set on migration-jobs that are not associated with a
   * conversion workspace.
   * </pre>
   *
   * <code>string filter = 20;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This field can be used to select the entities to migrate as part of
   * the migration job. It uses AIP-160 notation to select a subset of the
   * entities configured on the associated conversion-workspace. This field
   * should not be set on migration-jobs that are not associated with a
   * conversion workspace.
   * </pre>
   *
   * <code>string filter = 20;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CMEK_KEY_NAME_FIELD_NUMBER = 21;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cmekKeyName_ = "";
  /**
   *
   *
   * <pre>
   * The CMEK (customer-managed encryption key) fully qualified key name used
   * for the migration job.
   * This field supports all migration jobs types except for:
   * * Mysql to Mysql (use the cmek field in the cloudsql connection profile
   * instead).
   * * PostrgeSQL to PostgreSQL (use the cmek field in the cloudsql
   * connection profile instead).
   * * PostgreSQL to AlloyDB (use the kms_key_name field in the alloydb
   * connection profile instead).
   * Each Cloud CMEK key has the following format:
   * projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
   * </pre>
   *
   * <code>string cmek_key_name = 21;</code>
   *
   * @return The cmekKeyName.
   */
  @java.lang.Override
  public java.lang.String getCmekKeyName() {
    java.lang.Object ref = cmekKeyName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cmekKeyName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The CMEK (customer-managed encryption key) fully qualified key name used
   * for the migration job.
   * This field supports all migration jobs types except for:
   * * Mysql to Mysql (use the cmek field in the cloudsql connection profile
   * instead).
   * * PostrgeSQL to PostgreSQL (use the cmek field in the cloudsql
   * connection profile instead).
   * * PostgreSQL to AlloyDB (use the kms_key_name field in the alloydb
   * connection profile instead).
   * Each Cloud CMEK key has the following format:
   * projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
   * </pre>
   *
   * <code>string cmek_key_name = 21;</code>
   *
   * @return The bytes for cmekKeyName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCmekKeyNameBytes() {
    java.lang.Object ref = cmekKeyName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cmekKeyName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PERFORMANCE_CONFIG_FIELD_NUMBER = 22;
  private com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig performanceConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Data dump parallelism settings used by the migration.
   * Currently applicable only for MySQL to Cloud SQL for MySQL migrations only.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig performance_config = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the performanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasPerformanceConfig() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Data dump parallelism settings used by the migration.
   * Currently applicable only for MySQL to Cloud SQL for MySQL migrations only.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig performance_config = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The performanceConfig.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig getPerformanceConfig() {
    return performanceConfig_ == null
        ? com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.getDefaultInstance()
        : performanceConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Data dump parallelism settings used by the migration.
   * Currently applicable only for MySQL to Cloud SQL for MySQL migrations only.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig performance_config = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfigOrBuilder
      getPerformanceConfigOrBuilder() {
    return performanceConfig_ == null
        ? com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.getDefaultInstance()
        : performanceConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, displayName_);
    }
    if (state_ != com.google.cloud.clouddms.v1.MigrationJob.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, state_);
    }
    if (phase_ != com.google.cloud.clouddms.v1.MigrationJob.Phase.PHASE_UNSPECIFIED.getNumber()) {
      output.writeEnum(7, phase_);
    }
    if (type_ != com.google.cloud.clouddms.v1.MigrationJob.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(8, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dumpPath_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, dumpPath_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(source_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, source_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destination_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, destination_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(12, getDuration());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(13, getError());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(14, getSourceDatabase());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(15, getDestinationDatabase());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(16, getEndTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(17, getDumpFlags());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(18, getConversionWorkspace());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 20, filter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cmekKeyName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 21, cmekKeyName_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(22, getPerformanceConfig());
    }
    if (connectivityCase_ == 101) {
      output.writeMessage(101, (com.google.cloud.clouddms.v1.ReverseSshConnectivity) connectivity_);
    }
    if (connectivityCase_ == 102) {
      output.writeMessage(102, (com.google.cloud.clouddms.v1.VpcPeeringConnectivity) connectivity_);
    }
    if (connectivityCase_ == 103) {
      output.writeMessage(103, (com.google.cloud.clouddms.v1.StaticIpConnectivity) connectivity_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, displayName_);
    }
    if (state_ != com.google.cloud.clouddms.v1.MigrationJob.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, state_);
    }
    if (phase_ != com.google.cloud.clouddms.v1.MigrationJob.Phase.PHASE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, phase_);
    }
    if (type_ != com.google.cloud.clouddms.v1.MigrationJob.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dumpPath_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, dumpPath_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(source_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, source_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destination_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, destination_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getDuration());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getError());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getSourceDatabase());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(15, getDestinationDatabase());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getEndTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getDumpFlags());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(18, getConversionWorkspace());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(20, filter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cmekKeyName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(21, cmekKeyName_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, getPerformanceConfig());
    }
    if (connectivityCase_ == 101) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              101, (com.google.cloud.clouddms.v1.ReverseSshConnectivity) connectivity_);
    }
    if (connectivityCase_ == 102) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              102, (com.google.cloud.clouddms.v1.VpcPeeringConnectivity) connectivity_);
    }
    if (connectivityCase_ == 103) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              103, (com.google.cloud.clouddms.v1.StaticIpConnectivity) connectivity_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.MigrationJob)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.MigrationJob other =
        (com.google.cloud.clouddms.v1.MigrationJob) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (state_ != other.state_) return false;
    if (phase_ != other.phase_) return false;
    if (type_ != other.type_) return false;
    if (!getDumpPath().equals(other.getDumpPath())) return false;
    if (hasDumpFlags() != other.hasDumpFlags()) return false;
    if (hasDumpFlags()) {
      if (!getDumpFlags().equals(other.getDumpFlags())) return false;
    }
    if (!getSource().equals(other.getSource())) return false;
    if (!getDestination().equals(other.getDestination())) return false;
    if (hasDuration() != other.hasDuration()) return false;
    if (hasDuration()) {
      if (!getDuration().equals(other.getDuration())) return false;
    }
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (hasSourceDatabase() != other.hasSourceDatabase()) return false;
    if (hasSourceDatabase()) {
      if (!getSourceDatabase().equals(other.getSourceDatabase())) return false;
    }
    if (hasDestinationDatabase() != other.hasDestinationDatabase()) return false;
    if (hasDestinationDatabase()) {
      if (!getDestinationDatabase().equals(other.getDestinationDatabase())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasConversionWorkspace() != other.hasConversionWorkspace()) return false;
    if (hasConversionWorkspace()) {
      if (!getConversionWorkspace().equals(other.getConversionWorkspace())) return false;
    }
    if (!getFilter().equals(other.getFilter())) return false;
    if (!getCmekKeyName().equals(other.getCmekKeyName())) return false;
    if (hasPerformanceConfig() != other.hasPerformanceConfig()) return false;
    if (hasPerformanceConfig()) {
      if (!getPerformanceConfig().equals(other.getPerformanceConfig())) return false;
    }
    if (!getConnectivityCase().equals(other.getConnectivityCase())) return false;
    switch (connectivityCase_) {
      case 101:
        if (!getReverseSshConnectivity().equals(other.getReverseSshConnectivity())) return false;
        break;
      case 102:
        if (!getVpcPeeringConnectivity().equals(other.getVpcPeeringConnectivity())) return false;
        break;
      case 103:
        if (!getStaticIpConnectivity().equals(other.getStaticIpConnectivity())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + PHASE_FIELD_NUMBER;
    hash = (53 * hash) + phase_;
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + DUMP_PATH_FIELD_NUMBER;
    hash = (53 * hash) + getDumpPath().hashCode();
    if (hasDumpFlags()) {
      hash = (37 * hash) + DUMP_FLAGS_FIELD_NUMBER;
      hash = (53 * hash) + getDumpFlags().hashCode();
    }
    hash = (37 * hash) + SOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getSource().hashCode();
    hash = (37 * hash) + DESTINATION_FIELD_NUMBER;
    hash = (53 * hash) + getDestination().hashCode();
    if (hasDuration()) {
      hash = (37 * hash) + DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getDuration().hashCode();
    }
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    if (hasSourceDatabase()) {
      hash = (37 * hash) + SOURCE_DATABASE_FIELD_NUMBER;
      hash = (53 * hash) + getSourceDatabase().hashCode();
    }
    if (hasDestinationDatabase()) {
      hash = (37 * hash) + DESTINATION_DATABASE_FIELD_NUMBER;
      hash = (53 * hash) + getDestinationDatabase().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasConversionWorkspace()) {
      hash = (37 * hash) + CONVERSION_WORKSPACE_FIELD_NUMBER;
      hash = (53 * hash) + getConversionWorkspace().hashCode();
    }
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + CMEK_KEY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getCmekKeyName().hashCode();
    if (hasPerformanceConfig()) {
      hash = (37 * hash) + PERFORMANCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPerformanceConfig().hashCode();
    }
    switch (connectivityCase_) {
      case 101:
        hash = (37 * hash) + REVERSE_SSH_CONNECTIVITY_FIELD_NUMBER;
        hash = (53 * hash) + getReverseSshConnectivity().hashCode();
        break;
      case 102:
        hash = (37 * hash) + VPC_PEERING_CONNECTIVITY_FIELD_NUMBER;
        hash = (53 * hash) + getVpcPeeringConnectivity().hashCode();
        break;
      case 103:
        hash = (37 * hash) + STATIC_IP_CONNECTIVITY_FIELD_NUMBER;
        hash = (53 * hash) + getStaticIpConnectivity().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.MigrationJob parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.MigrationJob parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MigrationJob parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.MigrationJob parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MigrationJob parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.MigrationJob parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MigrationJob parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.MigrationJob parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MigrationJob parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.MigrationJob parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MigrationJob parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.MigrationJob parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.MigrationJob prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a Database Migration Service migration job object.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.MigrationJob}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.MigrationJob)
      com.google.cloud.clouddms.v1.MigrationJobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_MigrationJob_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_MigrationJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.MigrationJob.class,
              com.google.cloud.clouddms.v1.MigrationJob.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.MigrationJob.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getDumpFlagsFieldBuilder();
        getDurationFieldBuilder();
        getErrorFieldBuilder();
        getSourceDatabaseFieldBuilder();
        getDestinationDatabaseFieldBuilder();
        getEndTimeFieldBuilder();
        getConversionWorkspaceFieldBuilder();
        getPerformanceConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      displayName_ = "";
      state_ = 0;
      phase_ = 0;
      type_ = 0;
      dumpPath_ = "";
      dumpFlags_ = null;
      if (dumpFlagsBuilder_ != null) {
        dumpFlagsBuilder_.dispose();
        dumpFlagsBuilder_ = null;
      }
      source_ = "";
      destination_ = "";
      if (reverseSshConnectivityBuilder_ != null) {
        reverseSshConnectivityBuilder_.clear();
      }
      if (vpcPeeringConnectivityBuilder_ != null) {
        vpcPeeringConnectivityBuilder_.clear();
      }
      if (staticIpConnectivityBuilder_ != null) {
        staticIpConnectivityBuilder_.clear();
      }
      duration_ = null;
      if (durationBuilder_ != null) {
        durationBuilder_.dispose();
        durationBuilder_ = null;
      }
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      sourceDatabase_ = null;
      if (sourceDatabaseBuilder_ != null) {
        sourceDatabaseBuilder_.dispose();
        sourceDatabaseBuilder_ = null;
      }
      destinationDatabase_ = null;
      if (destinationDatabaseBuilder_ != null) {
        destinationDatabaseBuilder_.dispose();
        destinationDatabaseBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      conversionWorkspace_ = null;
      if (conversionWorkspaceBuilder_ != null) {
        conversionWorkspaceBuilder_.dispose();
        conversionWorkspaceBuilder_ = null;
      }
      filter_ = "";
      cmekKeyName_ = "";
      performanceConfig_ = null;
      if (performanceConfigBuilder_ != null) {
        performanceConfigBuilder_.dispose();
        performanceConfigBuilder_ = null;
      }
      connectivityCase_ = 0;
      connectivity_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_MigrationJob_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MigrationJob getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.MigrationJob.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MigrationJob build() {
      com.google.cloud.clouddms.v1.MigrationJob result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MigrationJob buildPartial() {
      com.google.cloud.clouddms.v1.MigrationJob result =
          new com.google.cloud.clouddms.v1.MigrationJob(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.MigrationJob result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.phase_ = phase_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.dumpPath_ = dumpPath_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.dumpFlags_ = dumpFlagsBuilder_ == null ? dumpFlags_ : dumpFlagsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.source_ = source_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.destination_ = destination_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.duration_ = durationBuilder_ == null ? duration_ : durationBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.sourceDatabase_ =
            sourceDatabaseBuilder_ == null ? sourceDatabase_ : sourceDatabaseBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.destinationDatabase_ =
            destinationDatabaseBuilder_ == null
                ? destinationDatabase_
                : destinationDatabaseBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.conversionWorkspace_ =
            conversionWorkspaceBuilder_ == null
                ? conversionWorkspace_
                : conversionWorkspaceBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.cmekKeyName_ = cmekKeyName_;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.performanceConfig_ =
            performanceConfigBuilder_ == null
                ? performanceConfig_
                : performanceConfigBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.clouddms.v1.MigrationJob result) {
      result.connectivityCase_ = connectivityCase_;
      result.connectivity_ = this.connectivity_;
      if (connectivityCase_ == 101 && reverseSshConnectivityBuilder_ != null) {
        result.connectivity_ = reverseSshConnectivityBuilder_.build();
      }
      if (connectivityCase_ == 102 && vpcPeeringConnectivityBuilder_ != null) {
        result.connectivity_ = vpcPeeringConnectivityBuilder_.build();
      }
      if (connectivityCase_ == 103 && staticIpConnectivityBuilder_ != null) {
        result.connectivity_ = staticIpConnectivityBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.MigrationJob) {
        return mergeFrom((com.google.cloud.clouddms.v1.MigrationJob) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.MigrationJob other) {
      if (other == com.google.cloud.clouddms.v1.MigrationJob.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000008;
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.phase_ != 0) {
        setPhaseValue(other.getPhaseValue());
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (!other.getDumpPath().isEmpty()) {
        dumpPath_ = other.dumpPath_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasDumpFlags()) {
        mergeDumpFlags(other.getDumpFlags());
      }
      if (!other.getSource().isEmpty()) {
        source_ = other.source_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (!other.getDestination().isEmpty()) {
        destination_ = other.destination_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasDuration()) {
        mergeDuration(other.getDuration());
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      if (other.hasSourceDatabase()) {
        mergeSourceDatabase(other.getSourceDatabase());
      }
      if (other.hasDestinationDatabase()) {
        mergeDestinationDatabase(other.getDestinationDatabase());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasConversionWorkspace()) {
        mergeConversionWorkspace(other.getConversionWorkspace());
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00200000;
        onChanged();
      }
      if (!other.getCmekKeyName().isEmpty()) {
        cmekKeyName_ = other.cmekKeyName_;
        bitField0_ |= 0x00400000;
        onChanged();
      }
      if (other.hasPerformanceConfig()) {
        mergePerformanceConfig(other.getPerformanceConfig());
      }
      switch (other.getConnectivityCase()) {
        case REVERSE_SSH_CONNECTIVITY:
          {
            mergeReverseSshConnectivity(other.getReverseSshConnectivity());
            break;
          }
        case VPC_PEERING_CONNECTIVITY:
          {
            mergeVpcPeeringConnectivity(other.getVpcPeeringConnectivity());
            break;
          }
        case STATIC_IP_CONNECTIVITY:
          {
            mergeStaticIpConnectivity(other.getStaticIpConnectivity());
            break;
          }
        case CONNECTIVITY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                phase_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 64:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 74:
              {
                dumpPath_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                source_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 82
            case 90:
              {
                destination_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getSourceDatabaseFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(
                    getDestinationDatabaseFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(getDumpFlagsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(
                    getConversionWorkspaceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case 146
            case 162:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00200000;
                break;
              } // case 162
            case 170:
              {
                cmekKeyName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00400000;
                break;
              } // case 170
            case 178:
              {
                input.readMessage(
                    getPerformanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00800000;
                break;
              } // case 178
            case 810:
              {
                input.readMessage(
                    getReverseSshConnectivityFieldBuilder().getBuilder(), extensionRegistry);
                connectivityCase_ = 101;
                break;
              } // case 810
            case 818:
              {
                input.readMessage(
                    getVpcPeeringConnectivityFieldBuilder().getBuilder(), extensionRegistry);
                connectivityCase_ = 102;
                break;
              } // case 818
            case 826:
              {
                input.readMessage(
                    getStaticIpConnectivityFieldBuilder().getBuilder(), extensionRegistry);
                connectivityCase_ = 103;
                break;
              } // case 826
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int connectivityCase_ = 0;
    private java.lang.Object connectivity_;

    public ConnectivityCase getConnectivityCase() {
      return ConnectivityCase.forNumber(connectivityCase_);
    }

    public Builder clearConnectivity() {
      connectivityCase_ = 0;
      connectivity_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name (URI) of this migration job resource, in the form of:
     * projects/{project}/locations/{location}/migrationJobs/{migrationJob}.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name (URI) of this migration job resource, in the form of:
     * projects/{project}/locations/{location}/migrationJobs/{migrationJob}.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name (URI) of this migration job resource, in the form of:
     * projects/{project}/locations/{location}/migrationJobs/{migrationJob}.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name (URI) of this migration job resource, in the form of:
     * projects/{project}/locations/{location}/migrationJobs/{migrationJob}.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name (URI) of this migration job resource, in the form of:
     * projects/{project}/locations/{location}/migrationJobs/{migrationJob}.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the migration job resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the migration job resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the migration job resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the migration job resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the migration job resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the migration job resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the migration job resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the migration job resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the migration job resource was created.
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the migration job resource was last
     * updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the migration job resource was last
     * updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the migration job resource was last
     * updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the migration job resource was last
     * updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the migration job resource was last
     * updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the migration job resource was last
     * updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the migration job resource was last
     * updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the migration job resource was last
     * updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the migration job resource was last
     * updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
     * Example: "2014-10-02T15:01:23.045123456Z".
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for migration job to use to annotate any related
     * underlying resources such as Compute Engine VMs. An object containing a
     * list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for migration job to use to annotate any related
     * underlying resources such as Compute Engine VMs. An object containing a
     * list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for migration job to use to annotate any related
     * underlying resources such as Compute Engine VMs. An object containing a
     * list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for migration job to use to annotate any related
     * underlying resources such as Compute Engine VMs. An object containing a
     * list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for migration job to use to annotate any related
     * underlying resources such as Compute Engine VMs. An object containing a
     * list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The resource labels for migration job to use to annotate any related
     * underlying resources such as Compute Engine VMs. An object containing a
     * list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource labels for migration job to use to annotate any related
     * underlying resources such as Compute Engine VMs. An object containing a
     * list of "key": "value" pairs.
     *
     * Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The migration job display name.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The migration job display name.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The migration job display name.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The migration job display name.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The migration job display name.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * The current migration job state.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MigrationJob.State state = 6;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * The current migration job state.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MigrationJob.State state = 6;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current migration job state.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MigrationJob.State state = 6;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.MigrationJob.State getState() {
      com.google.cloud.clouddms.v1.MigrationJob.State result =
          com.google.cloud.clouddms.v1.MigrationJob.State.forNumber(state_);
      return result == null ? com.google.cloud.clouddms.v1.MigrationJob.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The current migration job state.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MigrationJob.State state = 6;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.clouddms.v1.MigrationJob.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current migration job state.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MigrationJob.State state = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      state_ = 0;
      onChanged();
      return this;
    }

    private int phase_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current migration job phase.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.Phase phase = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for phase.
     */
    @java.lang.Override
    public int getPhaseValue() {
      return phase_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current migration job phase.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.Phase phase = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for phase to set.
     * @return This builder for chaining.
     */
    public Builder setPhaseValue(int value) {
      phase_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current migration job phase.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.Phase phase = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The phase.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.MigrationJob.Phase getPhase() {
      com.google.cloud.clouddms.v1.MigrationJob.Phase result =
          com.google.cloud.clouddms.v1.MigrationJob.Phase.forNumber(phase_);
      return result == null ? com.google.cloud.clouddms.v1.MigrationJob.Phase.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current migration job phase.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.Phase phase = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The phase to set.
     * @return This builder for chaining.
     */
    public Builder setPhase(com.google.cloud.clouddms.v1.MigrationJob.Phase value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      phase_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current migration job phase.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.Phase phase = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPhase() {
      bitField0_ = (bitField0_ & ~0x00000040);
      phase_ = 0;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The migration job type.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.Type type = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Required. The migration job type.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.Type type = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The migration job type.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.Type type = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.MigrationJob.Type getType() {
      com.google.cloud.clouddms.v1.MigrationJob.Type result =
          com.google.cloud.clouddms.v1.MigrationJob.Type.forNumber(type_);
      return result == null ? com.google.cloud.clouddms.v1.MigrationJob.Type.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The migration job type.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.Type type = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.clouddms.v1.MigrationJob.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The migration job type.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.Type type = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000080);
      type_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object dumpPath_ = "";
    /**
     *
     *
     * <pre>
     * The path to the dump file in Google Cloud Storage,
     * in the format: (gs://[BUCKET_NAME]/[OBJECT_NAME]).
     * This field and the "dump_flags" field are mutually exclusive.
     * </pre>
     *
     * <code>string dump_path = 9;</code>
     *
     * @return The dumpPath.
     */
    public java.lang.String getDumpPath() {
      java.lang.Object ref = dumpPath_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dumpPath_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The path to the dump file in Google Cloud Storage,
     * in the format: (gs://[BUCKET_NAME]/[OBJECT_NAME]).
     * This field and the "dump_flags" field are mutually exclusive.
     * </pre>
     *
     * <code>string dump_path = 9;</code>
     *
     * @return The bytes for dumpPath.
     */
    public com.google.protobuf.ByteString getDumpPathBytes() {
      java.lang.Object ref = dumpPath_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dumpPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The path to the dump file in Google Cloud Storage,
     * in the format: (gs://[BUCKET_NAME]/[OBJECT_NAME]).
     * This field and the "dump_flags" field are mutually exclusive.
     * </pre>
     *
     * <code>string dump_path = 9;</code>
     *
     * @param value The dumpPath to set.
     * @return This builder for chaining.
     */
    public Builder setDumpPath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dumpPath_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The path to the dump file in Google Cloud Storage,
     * in the format: (gs://[BUCKET_NAME]/[OBJECT_NAME]).
     * This field and the "dump_flags" field are mutually exclusive.
     * </pre>
     *
     * <code>string dump_path = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDumpPath() {
      dumpPath_ = getDefaultInstance().getDumpPath();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The path to the dump file in Google Cloud Storage,
     * in the format: (gs://[BUCKET_NAME]/[OBJECT_NAME]).
     * This field and the "dump_flags" field are mutually exclusive.
     * </pre>
     *
     * <code>string dump_path = 9;</code>
     *
     * @param value The bytes for dumpPath to set.
     * @return This builder for chaining.
     */
    public Builder setDumpPathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dumpPath_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.cloud.clouddms.v1.MigrationJob.DumpFlags dumpFlags_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.MigrationJob.DumpFlags,
            com.google.cloud.clouddms.v1.MigrationJob.DumpFlags.Builder,
            com.google.cloud.clouddms.v1.MigrationJob.DumpFlagsOrBuilder>
        dumpFlagsBuilder_;
    /**
     *
     *
     * <pre>
     * The initial dump flags.
     * This field and the "dump_path" field are mutually exclusive.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MigrationJob.DumpFlags dump_flags = 17;</code>
     *
     * @return Whether the dumpFlags field is set.
     */
    public boolean hasDumpFlags() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * The initial dump flags.
     * This field and the "dump_path" field are mutually exclusive.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MigrationJob.DumpFlags dump_flags = 17;</code>
     *
     * @return The dumpFlags.
     */
    public com.google.cloud.clouddms.v1.MigrationJob.DumpFlags getDumpFlags() {
      if (dumpFlagsBuilder_ == null) {
        return dumpFlags_ == null
            ? com.google.cloud.clouddms.v1.MigrationJob.DumpFlags.getDefaultInstance()
            : dumpFlags_;
      } else {
        return dumpFlagsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The initial dump flags.
     * This field and the "dump_path" field are mutually exclusive.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MigrationJob.DumpFlags dump_flags = 17;</code>
     */
    public Builder setDumpFlags(com.google.cloud.clouddms.v1.MigrationJob.DumpFlags value) {
      if (dumpFlagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dumpFlags_ = value;
      } else {
        dumpFlagsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The initial dump flags.
     * This field and the "dump_path" field are mutually exclusive.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MigrationJob.DumpFlags dump_flags = 17;</code>
     */
    public Builder setDumpFlags(
        com.google.cloud.clouddms.v1.MigrationJob.DumpFlags.Builder builderForValue) {
      if (dumpFlagsBuilder_ == null) {
        dumpFlags_ = builderForValue.build();
      } else {
        dumpFlagsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The initial dump flags.
     * This field and the "dump_path" field are mutually exclusive.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MigrationJob.DumpFlags dump_flags = 17;</code>
     */
    public Builder mergeDumpFlags(com.google.cloud.clouddms.v1.MigrationJob.DumpFlags value) {
      if (dumpFlagsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && dumpFlags_ != null
            && dumpFlags_
                != com.google.cloud.clouddms.v1.MigrationJob.DumpFlags.getDefaultInstance()) {
          getDumpFlagsBuilder().mergeFrom(value);
        } else {
          dumpFlags_ = value;
        }
      } else {
        dumpFlagsBuilder_.mergeFrom(value);
      }
      if (dumpFlags_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The initial dump flags.
     * This field and the "dump_path" field are mutually exclusive.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MigrationJob.DumpFlags dump_flags = 17;</code>
     */
    public Builder clearDumpFlags() {
      bitField0_ = (bitField0_ & ~0x00000200);
      dumpFlags_ = null;
      if (dumpFlagsBuilder_ != null) {
        dumpFlagsBuilder_.dispose();
        dumpFlagsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The initial dump flags.
     * This field and the "dump_path" field are mutually exclusive.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MigrationJob.DumpFlags dump_flags = 17;</code>
     */
    public com.google.cloud.clouddms.v1.MigrationJob.DumpFlags.Builder getDumpFlagsBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getDumpFlagsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The initial dump flags.
     * This field and the "dump_path" field are mutually exclusive.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MigrationJob.DumpFlags dump_flags = 17;</code>
     */
    public com.google.cloud.clouddms.v1.MigrationJob.DumpFlagsOrBuilder getDumpFlagsOrBuilder() {
      if (dumpFlagsBuilder_ != null) {
        return dumpFlagsBuilder_.getMessageOrBuilder();
      } else {
        return dumpFlags_ == null
            ? com.google.cloud.clouddms.v1.MigrationJob.DumpFlags.getDefaultInstance()
            : dumpFlags_;
      }
    }
    /**
     *
     *
     * <pre>
     * The initial dump flags.
     * This field and the "dump_path" field are mutually exclusive.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.MigrationJob.DumpFlags dump_flags = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.MigrationJob.DumpFlags,
            com.google.cloud.clouddms.v1.MigrationJob.DumpFlags.Builder,
            com.google.cloud.clouddms.v1.MigrationJob.DumpFlagsOrBuilder>
        getDumpFlagsFieldBuilder() {
      if (dumpFlagsBuilder_ == null) {
        dumpFlagsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.MigrationJob.DumpFlags,
                com.google.cloud.clouddms.v1.MigrationJob.DumpFlags.Builder,
                com.google.cloud.clouddms.v1.MigrationJob.DumpFlagsOrBuilder>(
                getDumpFlags(), getParentForChildren(), isClean());
        dumpFlags_ = null;
      }
      return dumpFlagsBuilder_;
    }

    private java.lang.Object source_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name (URI) of the source connection profile.
     * </pre>
     *
     * <code>string source = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The source.
     */
    public java.lang.String getSource() {
      java.lang.Object ref = source_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        source_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name (URI) of the source connection profile.
     * </pre>
     *
     * <code>string source = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for source.
     */
    public com.google.protobuf.ByteString getSourceBytes() {
      java.lang.Object ref = source_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        source_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name (URI) of the source connection profile.
     * </pre>
     *
     * <code>string source = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The source to set.
     * @return This builder for chaining.
     */
    public Builder setSource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      source_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name (URI) of the source connection profile.
     * </pre>
     *
     * <code>string source = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSource() {
      source_ = getDefaultInstance().getSource();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name (URI) of the source connection profile.
     * </pre>
     *
     * <code>string source = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for source to set.
     * @return This builder for chaining.
     */
    public Builder setSourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      source_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object destination_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name (URI) of the destination connection profile.
     * </pre>
     *
     * <code>string destination = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The destination.
     */
    public java.lang.String getDestination() {
      java.lang.Object ref = destination_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destination_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name (URI) of the destination connection profile.
     * </pre>
     *
     * <code>string destination = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for destination.
     */
    public com.google.protobuf.ByteString getDestinationBytes() {
      java.lang.Object ref = destination_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destination_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name (URI) of the destination connection profile.
     * </pre>
     *
     * <code>string destination = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The destination to set.
     * @return This builder for chaining.
     */
    public Builder setDestination(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destination_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name (URI) of the destination connection profile.
     * </pre>
     *
     * <code>string destination = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestination() {
      destination_ = getDefaultInstance().getDestination();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name (URI) of the destination connection profile.
     * </pre>
     *
     * <code>string destination = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for destination to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destination_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.ReverseSshConnectivity,
            com.google.cloud.clouddms.v1.ReverseSshConnectivity.Builder,
            com.google.cloud.clouddms.v1.ReverseSshConnectivityOrBuilder>
        reverseSshConnectivityBuilder_;
    /**
     *
     *
     * <pre>
     * The details needed to communicate to the source over Reverse SSH
     * tunnel connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ReverseSshConnectivity reverse_ssh_connectivity = 101;</code>
     *
     * @return Whether the reverseSshConnectivity field is set.
     */
    @java.lang.Override
    public boolean hasReverseSshConnectivity() {
      return connectivityCase_ == 101;
    }
    /**
     *
     *
     * <pre>
     * The details needed to communicate to the source over Reverse SSH
     * tunnel connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ReverseSshConnectivity reverse_ssh_connectivity = 101;</code>
     *
     * @return The reverseSshConnectivity.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.ReverseSshConnectivity getReverseSshConnectivity() {
      if (reverseSshConnectivityBuilder_ == null) {
        if (connectivityCase_ == 101) {
          return (com.google.cloud.clouddms.v1.ReverseSshConnectivity) connectivity_;
        }
        return com.google.cloud.clouddms.v1.ReverseSshConnectivity.getDefaultInstance();
      } else {
        if (connectivityCase_ == 101) {
          return reverseSshConnectivityBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.ReverseSshConnectivity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The details needed to communicate to the source over Reverse SSH
     * tunnel connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ReverseSshConnectivity reverse_ssh_connectivity = 101;</code>
     */
    public Builder setReverseSshConnectivity(
        com.google.cloud.clouddms.v1.ReverseSshConnectivity value) {
      if (reverseSshConnectivityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectivity_ = value;
        onChanged();
      } else {
        reverseSshConnectivityBuilder_.setMessage(value);
      }
      connectivityCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The details needed to communicate to the source over Reverse SSH
     * tunnel connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ReverseSshConnectivity reverse_ssh_connectivity = 101;</code>
     */
    public Builder setReverseSshConnectivity(
        com.google.cloud.clouddms.v1.ReverseSshConnectivity.Builder builderForValue) {
      if (reverseSshConnectivityBuilder_ == null) {
        connectivity_ = builderForValue.build();
        onChanged();
      } else {
        reverseSshConnectivityBuilder_.setMessage(builderForValue.build());
      }
      connectivityCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The details needed to communicate to the source over Reverse SSH
     * tunnel connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ReverseSshConnectivity reverse_ssh_connectivity = 101;</code>
     */
    public Builder mergeReverseSshConnectivity(
        com.google.cloud.clouddms.v1.ReverseSshConnectivity value) {
      if (reverseSshConnectivityBuilder_ == null) {
        if (connectivityCase_ == 101
            && connectivity_
                != com.google.cloud.clouddms.v1.ReverseSshConnectivity.getDefaultInstance()) {
          connectivity_ =
              com.google.cloud.clouddms.v1.ReverseSshConnectivity.newBuilder(
                      (com.google.cloud.clouddms.v1.ReverseSshConnectivity) connectivity_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          connectivity_ = value;
        }
        onChanged();
      } else {
        if (connectivityCase_ == 101) {
          reverseSshConnectivityBuilder_.mergeFrom(value);
        } else {
          reverseSshConnectivityBuilder_.setMessage(value);
        }
      }
      connectivityCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The details needed to communicate to the source over Reverse SSH
     * tunnel connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ReverseSshConnectivity reverse_ssh_connectivity = 101;</code>
     */
    public Builder clearReverseSshConnectivity() {
      if (reverseSshConnectivityBuilder_ == null) {
        if (connectivityCase_ == 101) {
          connectivityCase_ = 0;
          connectivity_ = null;
          onChanged();
        }
      } else {
        if (connectivityCase_ == 101) {
          connectivityCase_ = 0;
          connectivity_ = null;
        }
        reverseSshConnectivityBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The details needed to communicate to the source over Reverse SSH
     * tunnel connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ReverseSshConnectivity reverse_ssh_connectivity = 101;</code>
     */
    public com.google.cloud.clouddms.v1.ReverseSshConnectivity.Builder
        getReverseSshConnectivityBuilder() {
      return getReverseSshConnectivityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The details needed to communicate to the source over Reverse SSH
     * tunnel connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ReverseSshConnectivity reverse_ssh_connectivity = 101;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.ReverseSshConnectivityOrBuilder
        getReverseSshConnectivityOrBuilder() {
      if ((connectivityCase_ == 101) && (reverseSshConnectivityBuilder_ != null)) {
        return reverseSshConnectivityBuilder_.getMessageOrBuilder();
      } else {
        if (connectivityCase_ == 101) {
          return (com.google.cloud.clouddms.v1.ReverseSshConnectivity) connectivity_;
        }
        return com.google.cloud.clouddms.v1.ReverseSshConnectivity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The details needed to communicate to the source over Reverse SSH
     * tunnel connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ReverseSshConnectivity reverse_ssh_connectivity = 101;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.ReverseSshConnectivity,
            com.google.cloud.clouddms.v1.ReverseSshConnectivity.Builder,
            com.google.cloud.clouddms.v1.ReverseSshConnectivityOrBuilder>
        getReverseSshConnectivityFieldBuilder() {
      if (reverseSshConnectivityBuilder_ == null) {
        if (!(connectivityCase_ == 101)) {
          connectivity_ = com.google.cloud.clouddms.v1.ReverseSshConnectivity.getDefaultInstance();
        }
        reverseSshConnectivityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.ReverseSshConnectivity,
                com.google.cloud.clouddms.v1.ReverseSshConnectivity.Builder,
                com.google.cloud.clouddms.v1.ReverseSshConnectivityOrBuilder>(
                (com.google.cloud.clouddms.v1.ReverseSshConnectivity) connectivity_,
                getParentForChildren(),
                isClean());
        connectivity_ = null;
      }
      connectivityCase_ = 101;
      onChanged();
      return reverseSshConnectivityBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.VpcPeeringConnectivity,
            com.google.cloud.clouddms.v1.VpcPeeringConnectivity.Builder,
            com.google.cloud.clouddms.v1.VpcPeeringConnectivityOrBuilder>
        vpcPeeringConnectivityBuilder_;
    /**
     *
     *
     * <pre>
     * The details of the VPC network that the source database is located in.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VpcPeeringConnectivity vpc_peering_connectivity = 102;</code>
     *
     * @return Whether the vpcPeeringConnectivity field is set.
     */
    @java.lang.Override
    public boolean hasVpcPeeringConnectivity() {
      return connectivityCase_ == 102;
    }
    /**
     *
     *
     * <pre>
     * The details of the VPC network that the source database is located in.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VpcPeeringConnectivity vpc_peering_connectivity = 102;</code>
     *
     * @return The vpcPeeringConnectivity.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.VpcPeeringConnectivity getVpcPeeringConnectivity() {
      if (vpcPeeringConnectivityBuilder_ == null) {
        if (connectivityCase_ == 102) {
          return (com.google.cloud.clouddms.v1.VpcPeeringConnectivity) connectivity_;
        }
        return com.google.cloud.clouddms.v1.VpcPeeringConnectivity.getDefaultInstance();
      } else {
        if (connectivityCase_ == 102) {
          return vpcPeeringConnectivityBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.VpcPeeringConnectivity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The details of the VPC network that the source database is located in.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VpcPeeringConnectivity vpc_peering_connectivity = 102;</code>
     */
    public Builder setVpcPeeringConnectivity(
        com.google.cloud.clouddms.v1.VpcPeeringConnectivity value) {
      if (vpcPeeringConnectivityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectivity_ = value;
        onChanged();
      } else {
        vpcPeeringConnectivityBuilder_.setMessage(value);
      }
      connectivityCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The details of the VPC network that the source database is located in.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VpcPeeringConnectivity vpc_peering_connectivity = 102;</code>
     */
    public Builder setVpcPeeringConnectivity(
        com.google.cloud.clouddms.v1.VpcPeeringConnectivity.Builder builderForValue) {
      if (vpcPeeringConnectivityBuilder_ == null) {
        connectivity_ = builderForValue.build();
        onChanged();
      } else {
        vpcPeeringConnectivityBuilder_.setMessage(builderForValue.build());
      }
      connectivityCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The details of the VPC network that the source database is located in.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VpcPeeringConnectivity vpc_peering_connectivity = 102;</code>
     */
    public Builder mergeVpcPeeringConnectivity(
        com.google.cloud.clouddms.v1.VpcPeeringConnectivity value) {
      if (vpcPeeringConnectivityBuilder_ == null) {
        if (connectivityCase_ == 102
            && connectivity_
                != com.google.cloud.clouddms.v1.VpcPeeringConnectivity.getDefaultInstance()) {
          connectivity_ =
              com.google.cloud.clouddms.v1.VpcPeeringConnectivity.newBuilder(
                      (com.google.cloud.clouddms.v1.VpcPeeringConnectivity) connectivity_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          connectivity_ = value;
        }
        onChanged();
      } else {
        if (connectivityCase_ == 102) {
          vpcPeeringConnectivityBuilder_.mergeFrom(value);
        } else {
          vpcPeeringConnectivityBuilder_.setMessage(value);
        }
      }
      connectivityCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The details of the VPC network that the source database is located in.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VpcPeeringConnectivity vpc_peering_connectivity = 102;</code>
     */
    public Builder clearVpcPeeringConnectivity() {
      if (vpcPeeringConnectivityBuilder_ == null) {
        if (connectivityCase_ == 102) {
          connectivityCase_ = 0;
          connectivity_ = null;
          onChanged();
        }
      } else {
        if (connectivityCase_ == 102) {
          connectivityCase_ = 0;
          connectivity_ = null;
        }
        vpcPeeringConnectivityBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The details of the VPC network that the source database is located in.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VpcPeeringConnectivity vpc_peering_connectivity = 102;</code>
     */
    public com.google.cloud.clouddms.v1.VpcPeeringConnectivity.Builder
        getVpcPeeringConnectivityBuilder() {
      return getVpcPeeringConnectivityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The details of the VPC network that the source database is located in.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VpcPeeringConnectivity vpc_peering_connectivity = 102;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.VpcPeeringConnectivityOrBuilder
        getVpcPeeringConnectivityOrBuilder() {
      if ((connectivityCase_ == 102) && (vpcPeeringConnectivityBuilder_ != null)) {
        return vpcPeeringConnectivityBuilder_.getMessageOrBuilder();
      } else {
        if (connectivityCase_ == 102) {
          return (com.google.cloud.clouddms.v1.VpcPeeringConnectivity) connectivity_;
        }
        return com.google.cloud.clouddms.v1.VpcPeeringConnectivity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The details of the VPC network that the source database is located in.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.VpcPeeringConnectivity vpc_peering_connectivity = 102;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.VpcPeeringConnectivity,
            com.google.cloud.clouddms.v1.VpcPeeringConnectivity.Builder,
            com.google.cloud.clouddms.v1.VpcPeeringConnectivityOrBuilder>
        getVpcPeeringConnectivityFieldBuilder() {
      if (vpcPeeringConnectivityBuilder_ == null) {
        if (!(connectivityCase_ == 102)) {
          connectivity_ = com.google.cloud.clouddms.v1.VpcPeeringConnectivity.getDefaultInstance();
        }
        vpcPeeringConnectivityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.VpcPeeringConnectivity,
                com.google.cloud.clouddms.v1.VpcPeeringConnectivity.Builder,
                com.google.cloud.clouddms.v1.VpcPeeringConnectivityOrBuilder>(
                (com.google.cloud.clouddms.v1.VpcPeeringConnectivity) connectivity_,
                getParentForChildren(),
                isClean());
        connectivity_ = null;
      }
      connectivityCase_ = 102;
      onChanged();
      return vpcPeeringConnectivityBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.StaticIpConnectivity,
            com.google.cloud.clouddms.v1.StaticIpConnectivity.Builder,
            com.google.cloud.clouddms.v1.StaticIpConnectivityOrBuilder>
        staticIpConnectivityBuilder_;
    /**
     *
     *
     * <pre>
     * static ip connectivity data (default, no additional details needed).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.StaticIpConnectivity static_ip_connectivity = 103;</code>
     *
     * @return Whether the staticIpConnectivity field is set.
     */
    @java.lang.Override
    public boolean hasStaticIpConnectivity() {
      return connectivityCase_ == 103;
    }
    /**
     *
     *
     * <pre>
     * static ip connectivity data (default, no additional details needed).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.StaticIpConnectivity static_ip_connectivity = 103;</code>
     *
     * @return The staticIpConnectivity.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.StaticIpConnectivity getStaticIpConnectivity() {
      if (staticIpConnectivityBuilder_ == null) {
        if (connectivityCase_ == 103) {
          return (com.google.cloud.clouddms.v1.StaticIpConnectivity) connectivity_;
        }
        return com.google.cloud.clouddms.v1.StaticIpConnectivity.getDefaultInstance();
      } else {
        if (connectivityCase_ == 103) {
          return staticIpConnectivityBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.StaticIpConnectivity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * static ip connectivity data (default, no additional details needed).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.StaticIpConnectivity static_ip_connectivity = 103;</code>
     */
    public Builder setStaticIpConnectivity(
        com.google.cloud.clouddms.v1.StaticIpConnectivity value) {
      if (staticIpConnectivityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectivity_ = value;
        onChanged();
      } else {
        staticIpConnectivityBuilder_.setMessage(value);
      }
      connectivityCase_ = 103;
      return this;
    }
    /**
     *
     *
     * <pre>
     * static ip connectivity data (default, no additional details needed).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.StaticIpConnectivity static_ip_connectivity = 103;</code>
     */
    public Builder setStaticIpConnectivity(
        com.google.cloud.clouddms.v1.StaticIpConnectivity.Builder builderForValue) {
      if (staticIpConnectivityBuilder_ == null) {
        connectivity_ = builderForValue.build();
        onChanged();
      } else {
        staticIpConnectivityBuilder_.setMessage(builderForValue.build());
      }
      connectivityCase_ = 103;
      return this;
    }
    /**
     *
     *
     * <pre>
     * static ip connectivity data (default, no additional details needed).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.StaticIpConnectivity static_ip_connectivity = 103;</code>
     */
    public Builder mergeStaticIpConnectivity(
        com.google.cloud.clouddms.v1.StaticIpConnectivity value) {
      if (staticIpConnectivityBuilder_ == null) {
        if (connectivityCase_ == 103
            && connectivity_
                != com.google.cloud.clouddms.v1.StaticIpConnectivity.getDefaultInstance()) {
          connectivity_ =
              com.google.cloud.clouddms.v1.StaticIpConnectivity.newBuilder(
                      (com.google.cloud.clouddms.v1.StaticIpConnectivity) connectivity_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          connectivity_ = value;
        }
        onChanged();
      } else {
        if (connectivityCase_ == 103) {
          staticIpConnectivityBuilder_.mergeFrom(value);
        } else {
          staticIpConnectivityBuilder_.setMessage(value);
        }
      }
      connectivityCase_ = 103;
      return this;
    }
    /**
     *
     *
     * <pre>
     * static ip connectivity data (default, no additional details needed).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.StaticIpConnectivity static_ip_connectivity = 103;</code>
     */
    public Builder clearStaticIpConnectivity() {
      if (staticIpConnectivityBuilder_ == null) {
        if (connectivityCase_ == 103) {
          connectivityCase_ = 0;
          connectivity_ = null;
          onChanged();
        }
      } else {
        if (connectivityCase_ == 103) {
          connectivityCase_ = 0;
          connectivity_ = null;
        }
        staticIpConnectivityBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * static ip connectivity data (default, no additional details needed).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.StaticIpConnectivity static_ip_connectivity = 103;</code>
     */
    public com.google.cloud.clouddms.v1.StaticIpConnectivity.Builder
        getStaticIpConnectivityBuilder() {
      return getStaticIpConnectivityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * static ip connectivity data (default, no additional details needed).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.StaticIpConnectivity static_ip_connectivity = 103;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.StaticIpConnectivityOrBuilder
        getStaticIpConnectivityOrBuilder() {
      if ((connectivityCase_ == 103) && (staticIpConnectivityBuilder_ != null)) {
        return staticIpConnectivityBuilder_.getMessageOrBuilder();
      } else {
        if (connectivityCase_ == 103) {
          return (com.google.cloud.clouddms.v1.StaticIpConnectivity) connectivity_;
        }
        return com.google.cloud.clouddms.v1.StaticIpConnectivity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * static ip connectivity data (default, no additional details needed).
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.StaticIpConnectivity static_ip_connectivity = 103;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.StaticIpConnectivity,
            com.google.cloud.clouddms.v1.StaticIpConnectivity.Builder,
            com.google.cloud.clouddms.v1.StaticIpConnectivityOrBuilder>
        getStaticIpConnectivityFieldBuilder() {
      if (staticIpConnectivityBuilder_ == null) {
        if (!(connectivityCase_ == 103)) {
          connectivity_ = com.google.cloud.clouddms.v1.StaticIpConnectivity.getDefaultInstance();
        }
        staticIpConnectivityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.StaticIpConnectivity,
                com.google.cloud.clouddms.v1.StaticIpConnectivity.Builder,
                com.google.cloud.clouddms.v1.StaticIpConnectivityOrBuilder>(
                (com.google.cloud.clouddms.v1.StaticIpConnectivity) connectivity_,
                getParentForChildren(),
                isClean());
        connectivity_ = null;
      }
      connectivityCase_ = 103;
      onChanged();
      return staticIpConnectivityBuilder_;
    }

    private com.google.protobuf.Duration duration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        durationBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The duration of the migration job (in seconds). A duration in
     * seconds with up to nine fractional digits, terminated by 's'. Example:
     * "3.5s".
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the duration field is set.
     */
    public boolean hasDuration() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The duration of the migration job (in seconds). A duration in
     * seconds with up to nine fractional digits, terminated by 's'. Example:
     * "3.5s".
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The duration.
     */
    public com.google.protobuf.Duration getDuration() {
      if (durationBuilder_ == null) {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      } else {
        return durationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The duration of the migration job (in seconds). A duration in
     * seconds with up to nine fractional digits, terminated by 's'. Example:
     * "3.5s".
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDuration(com.google.protobuf.Duration value) {
      if (durationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        duration_ = value;
      } else {
        durationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The duration of the migration job (in seconds). A duration in
     * seconds with up to nine fractional digits, terminated by 's'. Example:
     * "3.5s".
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (durationBuilder_ == null) {
        duration_ = builderForValue.build();
      } else {
        durationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The duration of the migration job (in seconds). A duration in
     * seconds with up to nine fractional digits, terminated by 's'. Example:
     * "3.5s".
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDuration(com.google.protobuf.Duration value) {
      if (durationBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && duration_ != null
            && duration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getDurationBuilder().mergeFrom(value);
        } else {
          duration_ = value;
        }
      } else {
        durationBuilder_.mergeFrom(value);
      }
      if (duration_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The duration of the migration job (in seconds). A duration in
     * seconds with up to nine fractional digits, terminated by 's'. Example:
     * "3.5s".
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDuration() {
      bitField0_ = (bitField0_ & ~0x00008000);
      duration_ = null;
      if (durationBuilder_ != null) {
        durationBuilder_.dispose();
        durationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The duration of the migration job (in seconds). A duration in
     * seconds with up to nine fractional digits, terminated by 's'. Example:
     * "3.5s".
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getDurationBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The duration of the migration job (in seconds). A duration in
     * seconds with up to nine fractional digits, terminated by 's'. Example:
     * "3.5s".
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
      if (durationBuilder_ != null) {
        return durationBuilder_.getMessageOrBuilder();
      } else {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The duration of the migration job (in seconds). A duration in
     * seconds with up to nine fractional digits, terminated by 's'. Example:
     * "3.5s".
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getDurationFieldBuilder() {
      if (durationBuilder_ == null) {
        durationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getDuration(), getParentForChildren(), isClean());
        duration_ = null;
      }
      return durationBuilder_;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The error details in case of state FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details in case of state FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details in case of state FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details in case of state FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details in case of state FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && error_ != null
            && error_ != com.google.rpc.Status.getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      if (error_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details in case of state FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00010000);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details in case of state FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details in case of state FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details in case of state FAILED.
     * </pre>
     *
     * <code>.google.rpc.Status error = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private com.google.cloud.clouddms.v1.DatabaseType sourceDatabase_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.DatabaseType,
            com.google.cloud.clouddms.v1.DatabaseType.Builder,
            com.google.cloud.clouddms.v1.DatabaseTypeOrBuilder>
        sourceDatabaseBuilder_;
    /**
     *
     *
     * <pre>
     * The database engine type and provider of the source.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseType source_database = 14;</code>
     *
     * @return Whether the sourceDatabase field is set.
     */
    public boolean hasSourceDatabase() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The database engine type and provider of the source.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseType source_database = 14;</code>
     *
     * @return The sourceDatabase.
     */
    public com.google.cloud.clouddms.v1.DatabaseType getSourceDatabase() {
      if (sourceDatabaseBuilder_ == null) {
        return sourceDatabase_ == null
            ? com.google.cloud.clouddms.v1.DatabaseType.getDefaultInstance()
            : sourceDatabase_;
      } else {
        return sourceDatabaseBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The database engine type and provider of the source.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseType source_database = 14;</code>
     */
    public Builder setSourceDatabase(com.google.cloud.clouddms.v1.DatabaseType value) {
      if (sourceDatabaseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceDatabase_ = value;
      } else {
        sourceDatabaseBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database engine type and provider of the source.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseType source_database = 14;</code>
     */
    public Builder setSourceDatabase(
        com.google.cloud.clouddms.v1.DatabaseType.Builder builderForValue) {
      if (sourceDatabaseBuilder_ == null) {
        sourceDatabase_ = builderForValue.build();
      } else {
        sourceDatabaseBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database engine type and provider of the source.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseType source_database = 14;</code>
     */
    public Builder mergeSourceDatabase(com.google.cloud.clouddms.v1.DatabaseType value) {
      if (sourceDatabaseBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && sourceDatabase_ != null
            && sourceDatabase_ != com.google.cloud.clouddms.v1.DatabaseType.getDefaultInstance()) {
          getSourceDatabaseBuilder().mergeFrom(value);
        } else {
          sourceDatabase_ = value;
        }
      } else {
        sourceDatabaseBuilder_.mergeFrom(value);
      }
      if (sourceDatabase_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database engine type and provider of the source.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseType source_database = 14;</code>
     */
    public Builder clearSourceDatabase() {
      bitField0_ = (bitField0_ & ~0x00020000);
      sourceDatabase_ = null;
      if (sourceDatabaseBuilder_ != null) {
        sourceDatabaseBuilder_.dispose();
        sourceDatabaseBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database engine type and provider of the source.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseType source_database = 14;</code>
     */
    public com.google.cloud.clouddms.v1.DatabaseType.Builder getSourceDatabaseBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getSourceDatabaseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The database engine type and provider of the source.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseType source_database = 14;</code>
     */
    public com.google.cloud.clouddms.v1.DatabaseTypeOrBuilder getSourceDatabaseOrBuilder() {
      if (sourceDatabaseBuilder_ != null) {
        return sourceDatabaseBuilder_.getMessageOrBuilder();
      } else {
        return sourceDatabase_ == null
            ? com.google.cloud.clouddms.v1.DatabaseType.getDefaultInstance()
            : sourceDatabase_;
      }
    }
    /**
     *
     *
     * <pre>
     * The database engine type and provider of the source.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseType source_database = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.DatabaseType,
            com.google.cloud.clouddms.v1.DatabaseType.Builder,
            com.google.cloud.clouddms.v1.DatabaseTypeOrBuilder>
        getSourceDatabaseFieldBuilder() {
      if (sourceDatabaseBuilder_ == null) {
        sourceDatabaseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.DatabaseType,
                com.google.cloud.clouddms.v1.DatabaseType.Builder,
                com.google.cloud.clouddms.v1.DatabaseTypeOrBuilder>(
                getSourceDatabase(), getParentForChildren(), isClean());
        sourceDatabase_ = null;
      }
      return sourceDatabaseBuilder_;
    }

    private com.google.cloud.clouddms.v1.DatabaseType destinationDatabase_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.DatabaseType,
            com.google.cloud.clouddms.v1.DatabaseType.Builder,
            com.google.cloud.clouddms.v1.DatabaseTypeOrBuilder>
        destinationDatabaseBuilder_;
    /**
     *
     *
     * <pre>
     * The database engine type and provider of the destination.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseType destination_database = 15;</code>
     *
     * @return Whether the destinationDatabase field is set.
     */
    public boolean hasDestinationDatabase() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The database engine type and provider of the destination.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseType destination_database = 15;</code>
     *
     * @return The destinationDatabase.
     */
    public com.google.cloud.clouddms.v1.DatabaseType getDestinationDatabase() {
      if (destinationDatabaseBuilder_ == null) {
        return destinationDatabase_ == null
            ? com.google.cloud.clouddms.v1.DatabaseType.getDefaultInstance()
            : destinationDatabase_;
      } else {
        return destinationDatabaseBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The database engine type and provider of the destination.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseType destination_database = 15;</code>
     */
    public Builder setDestinationDatabase(com.google.cloud.clouddms.v1.DatabaseType value) {
      if (destinationDatabaseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destinationDatabase_ = value;
      } else {
        destinationDatabaseBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database engine type and provider of the destination.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseType destination_database = 15;</code>
     */
    public Builder setDestinationDatabase(
        com.google.cloud.clouddms.v1.DatabaseType.Builder builderForValue) {
      if (destinationDatabaseBuilder_ == null) {
        destinationDatabase_ = builderForValue.build();
      } else {
        destinationDatabaseBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database engine type and provider of the destination.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseType destination_database = 15;</code>
     */
    public Builder mergeDestinationDatabase(com.google.cloud.clouddms.v1.DatabaseType value) {
      if (destinationDatabaseBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && destinationDatabase_ != null
            && destinationDatabase_
                != com.google.cloud.clouddms.v1.DatabaseType.getDefaultInstance()) {
          getDestinationDatabaseBuilder().mergeFrom(value);
        } else {
          destinationDatabase_ = value;
        }
      } else {
        destinationDatabaseBuilder_.mergeFrom(value);
      }
      if (destinationDatabase_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database engine type and provider of the destination.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseType destination_database = 15;</code>
     */
    public Builder clearDestinationDatabase() {
      bitField0_ = (bitField0_ & ~0x00040000);
      destinationDatabase_ = null;
      if (destinationDatabaseBuilder_ != null) {
        destinationDatabaseBuilder_.dispose();
        destinationDatabaseBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database engine type and provider of the destination.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseType destination_database = 15;</code>
     */
    public com.google.cloud.clouddms.v1.DatabaseType.Builder getDestinationDatabaseBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getDestinationDatabaseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The database engine type and provider of the destination.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseType destination_database = 15;</code>
     */
    public com.google.cloud.clouddms.v1.DatabaseTypeOrBuilder getDestinationDatabaseOrBuilder() {
      if (destinationDatabaseBuilder_ != null) {
        return destinationDatabaseBuilder_.getMessageOrBuilder();
      } else {
        return destinationDatabase_ == null
            ? com.google.cloud.clouddms.v1.DatabaseType.getDefaultInstance()
            : destinationDatabase_;
      }
    }
    /**
     *
     *
     * <pre>
     * The database engine type and provider of the destination.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.DatabaseType destination_database = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.DatabaseType,
            com.google.cloud.clouddms.v1.DatabaseType.Builder,
            com.google.cloud.clouddms.v1.DatabaseTypeOrBuilder>
        getDestinationDatabaseFieldBuilder() {
      if (destinationDatabaseBuilder_ == null) {
        destinationDatabaseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.DatabaseType,
                com.google.cloud.clouddms.v1.DatabaseType.Builder,
                com.google.cloud.clouddms.v1.DatabaseTypeOrBuilder>(
                getDestinationDatabase(), getParentForChildren(), isClean());
        destinationDatabase_ = null;
      }
      return destinationDatabaseBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. If the migration job is completed, the time when it was
     * completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. If the migration job is completed, the time when it was
     * completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If the migration job is completed, the time when it was
     * completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If the migration job is completed, the time when it was
     * completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If the migration job is completed, the time when it was
     * completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If the migration job is completed, the time when it was
     * completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00080000);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If the migration job is completed, the time when it was
     * completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. If the migration job is completed, the time when it was
     * completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If the migration job is completed, the time when it was
     * completed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.cloud.clouddms.v1.ConversionWorkspaceInfo conversionWorkspace_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.ConversionWorkspaceInfo,
            com.google.cloud.clouddms.v1.ConversionWorkspaceInfo.Builder,
            com.google.cloud.clouddms.v1.ConversionWorkspaceInfoOrBuilder>
        conversionWorkspaceBuilder_;
    /**
     *
     *
     * <pre>
     * The conversion workspace used by the migration.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ConversionWorkspaceInfo conversion_workspace = 18;</code>
     *
     * @return Whether the conversionWorkspace field is set.
     */
    public boolean hasConversionWorkspace() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The conversion workspace used by the migration.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ConversionWorkspaceInfo conversion_workspace = 18;</code>
     *
     * @return The conversionWorkspace.
     */
    public com.google.cloud.clouddms.v1.ConversionWorkspaceInfo getConversionWorkspace() {
      if (conversionWorkspaceBuilder_ == null) {
        return conversionWorkspace_ == null
            ? com.google.cloud.clouddms.v1.ConversionWorkspaceInfo.getDefaultInstance()
            : conversionWorkspace_;
      } else {
        return conversionWorkspaceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The conversion workspace used by the migration.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ConversionWorkspaceInfo conversion_workspace = 18;</code>
     */
    public Builder setConversionWorkspace(
        com.google.cloud.clouddms.v1.ConversionWorkspaceInfo value) {
      if (conversionWorkspaceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        conversionWorkspace_ = value;
      } else {
        conversionWorkspaceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversion workspace used by the migration.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ConversionWorkspaceInfo conversion_workspace = 18;</code>
     */
    public Builder setConversionWorkspace(
        com.google.cloud.clouddms.v1.ConversionWorkspaceInfo.Builder builderForValue) {
      if (conversionWorkspaceBuilder_ == null) {
        conversionWorkspace_ = builderForValue.build();
      } else {
        conversionWorkspaceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversion workspace used by the migration.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ConversionWorkspaceInfo conversion_workspace = 18;</code>
     */
    public Builder mergeConversionWorkspace(
        com.google.cloud.clouddms.v1.ConversionWorkspaceInfo value) {
      if (conversionWorkspaceBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && conversionWorkspace_ != null
            && conversionWorkspace_
                != com.google.cloud.clouddms.v1.ConversionWorkspaceInfo.getDefaultInstance()) {
          getConversionWorkspaceBuilder().mergeFrom(value);
        } else {
          conversionWorkspace_ = value;
        }
      } else {
        conversionWorkspaceBuilder_.mergeFrom(value);
      }
      if (conversionWorkspace_ != null) {
        bitField0_ |= 0x00100000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversion workspace used by the migration.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ConversionWorkspaceInfo conversion_workspace = 18;</code>
     */
    public Builder clearConversionWorkspace() {
      bitField0_ = (bitField0_ & ~0x00100000);
      conversionWorkspace_ = null;
      if (conversionWorkspaceBuilder_ != null) {
        conversionWorkspaceBuilder_.dispose();
        conversionWorkspaceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversion workspace used by the migration.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ConversionWorkspaceInfo conversion_workspace = 18;</code>
     */
    public com.google.cloud.clouddms.v1.ConversionWorkspaceInfo.Builder
        getConversionWorkspaceBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getConversionWorkspaceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The conversion workspace used by the migration.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ConversionWorkspaceInfo conversion_workspace = 18;</code>
     */
    public com.google.cloud.clouddms.v1.ConversionWorkspaceInfoOrBuilder
        getConversionWorkspaceOrBuilder() {
      if (conversionWorkspaceBuilder_ != null) {
        return conversionWorkspaceBuilder_.getMessageOrBuilder();
      } else {
        return conversionWorkspace_ == null
            ? com.google.cloud.clouddms.v1.ConversionWorkspaceInfo.getDefaultInstance()
            : conversionWorkspace_;
      }
    }
    /**
     *
     *
     * <pre>
     * The conversion workspace used by the migration.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ConversionWorkspaceInfo conversion_workspace = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.ConversionWorkspaceInfo,
            com.google.cloud.clouddms.v1.ConversionWorkspaceInfo.Builder,
            com.google.cloud.clouddms.v1.ConversionWorkspaceInfoOrBuilder>
        getConversionWorkspaceFieldBuilder() {
      if (conversionWorkspaceBuilder_ == null) {
        conversionWorkspaceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.ConversionWorkspaceInfo,
                com.google.cloud.clouddms.v1.ConversionWorkspaceInfo.Builder,
                com.google.cloud.clouddms.v1.ConversionWorkspaceInfoOrBuilder>(
                getConversionWorkspace(), getParentForChildren(), isClean());
        conversionWorkspace_ = null;
      }
      return conversionWorkspaceBuilder_;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * This field can be used to select the entities to migrate as part of
     * the migration job. It uses AIP-160 notation to select a subset of the
     * entities configured on the associated conversion-workspace. This field
     * should not be set on migration-jobs that are not associated with a
     * conversion workspace.
     * </pre>
     *
     * <code>string filter = 20;</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field can be used to select the entities to migrate as part of
     * the migration job. It uses AIP-160 notation to select a subset of the
     * entities configured on the associated conversion-workspace. This field
     * should not be set on migration-jobs that are not associated with a
     * conversion workspace.
     * </pre>
     *
     * <code>string filter = 20;</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field can be used to select the entities to migrate as part of
     * the migration job. It uses AIP-160 notation to select a subset of the
     * entities configured on the associated conversion-workspace. This field
     * should not be set on migration-jobs that are not associated with a
     * conversion workspace.
     * </pre>
     *
     * <code>string filter = 20;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can be used to select the entities to migrate as part of
     * the migration job. It uses AIP-160 notation to select a subset of the
     * entities configured on the associated conversion-workspace. This field
     * should not be set on migration-jobs that are not associated with a
     * conversion workspace.
     * </pre>
     *
     * <code>string filter = 20;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00200000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can be used to select the entities to migrate as part of
     * the migration job. It uses AIP-160 notation to select a subset of the
     * entities configured on the associated conversion-workspace. This field
     * should not be set on migration-jobs that are not associated with a
     * conversion workspace.
     * </pre>
     *
     * <code>string filter = 20;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    private java.lang.Object cmekKeyName_ = "";
    /**
     *
     *
     * <pre>
     * The CMEK (customer-managed encryption key) fully qualified key name used
     * for the migration job.
     * This field supports all migration jobs types except for:
     * * Mysql to Mysql (use the cmek field in the cloudsql connection profile
     * instead).
     * * PostrgeSQL to PostgreSQL (use the cmek field in the cloudsql
     * connection profile instead).
     * * PostgreSQL to AlloyDB (use the kms_key_name field in the alloydb
     * connection profile instead).
     * Each Cloud CMEK key has the following format:
     * projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
     * </pre>
     *
     * <code>string cmek_key_name = 21;</code>
     *
     * @return The cmekKeyName.
     */
    public java.lang.String getCmekKeyName() {
      java.lang.Object ref = cmekKeyName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cmekKeyName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The CMEK (customer-managed encryption key) fully qualified key name used
     * for the migration job.
     * This field supports all migration jobs types except for:
     * * Mysql to Mysql (use the cmek field in the cloudsql connection profile
     * instead).
     * * PostrgeSQL to PostgreSQL (use the cmek field in the cloudsql
     * connection profile instead).
     * * PostgreSQL to AlloyDB (use the kms_key_name field in the alloydb
     * connection profile instead).
     * Each Cloud CMEK key has the following format:
     * projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
     * </pre>
     *
     * <code>string cmek_key_name = 21;</code>
     *
     * @return The bytes for cmekKeyName.
     */
    public com.google.protobuf.ByteString getCmekKeyNameBytes() {
      java.lang.Object ref = cmekKeyName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cmekKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The CMEK (customer-managed encryption key) fully qualified key name used
     * for the migration job.
     * This field supports all migration jobs types except for:
     * * Mysql to Mysql (use the cmek field in the cloudsql connection profile
     * instead).
     * * PostrgeSQL to PostgreSQL (use the cmek field in the cloudsql
     * connection profile instead).
     * * PostgreSQL to AlloyDB (use the kms_key_name field in the alloydb
     * connection profile instead).
     * Each Cloud CMEK key has the following format:
     * projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
     * </pre>
     *
     * <code>string cmek_key_name = 21;</code>
     *
     * @param value The cmekKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setCmekKeyName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cmekKeyName_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CMEK (customer-managed encryption key) fully qualified key name used
     * for the migration job.
     * This field supports all migration jobs types except for:
     * * Mysql to Mysql (use the cmek field in the cloudsql connection profile
     * instead).
     * * PostrgeSQL to PostgreSQL (use the cmek field in the cloudsql
     * connection profile instead).
     * * PostgreSQL to AlloyDB (use the kms_key_name field in the alloydb
     * connection profile instead).
     * Each Cloud CMEK key has the following format:
     * projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
     * </pre>
     *
     * <code>string cmek_key_name = 21;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCmekKeyName() {
      cmekKeyName_ = getDefaultInstance().getCmekKeyName();
      bitField0_ = (bitField0_ & ~0x00400000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CMEK (customer-managed encryption key) fully qualified key name used
     * for the migration job.
     * This field supports all migration jobs types except for:
     * * Mysql to Mysql (use the cmek field in the cloudsql connection profile
     * instead).
     * * PostrgeSQL to PostgreSQL (use the cmek field in the cloudsql
     * connection profile instead).
     * * PostgreSQL to AlloyDB (use the kms_key_name field in the alloydb
     * connection profile instead).
     * Each Cloud CMEK key has the following format:
     * projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME]
     * </pre>
     *
     * <code>string cmek_key_name = 21;</code>
     *
     * @param value The bytes for cmekKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setCmekKeyNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cmekKeyName_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    private com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig performanceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig,
            com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.Builder,
            com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfigOrBuilder>
        performanceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Data dump parallelism settings used by the migration.
     * Currently applicable only for MySQL to Cloud SQL for MySQL migrations only.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig performance_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the performanceConfig field is set.
     */
    public boolean hasPerformanceConfig() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Data dump parallelism settings used by the migration.
     * Currently applicable only for MySQL to Cloud SQL for MySQL migrations only.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig performance_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The performanceConfig.
     */
    public com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig getPerformanceConfig() {
      if (performanceConfigBuilder_ == null) {
        return performanceConfig_ == null
            ? com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.getDefaultInstance()
            : performanceConfig_;
      } else {
        return performanceConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Data dump parallelism settings used by the migration.
     * Currently applicable only for MySQL to Cloud SQL for MySQL migrations only.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig performance_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPerformanceConfig(
        com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig value) {
      if (performanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        performanceConfig_ = value;
      } else {
        performanceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data dump parallelism settings used by the migration.
     * Currently applicable only for MySQL to Cloud SQL for MySQL migrations only.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig performance_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPerformanceConfig(
        com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.Builder builderForValue) {
      if (performanceConfigBuilder_ == null) {
        performanceConfig_ = builderForValue.build();
      } else {
        performanceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data dump parallelism settings used by the migration.
     * Currently applicable only for MySQL to Cloud SQL for MySQL migrations only.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig performance_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePerformanceConfig(
        com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig value) {
      if (performanceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00800000) != 0)
            && performanceConfig_ != null
            && performanceConfig_
                != com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig
                    .getDefaultInstance()) {
          getPerformanceConfigBuilder().mergeFrom(value);
        } else {
          performanceConfig_ = value;
        }
      } else {
        performanceConfigBuilder_.mergeFrom(value);
      }
      if (performanceConfig_ != null) {
        bitField0_ |= 0x00800000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data dump parallelism settings used by the migration.
     * Currently applicable only for MySQL to Cloud SQL for MySQL migrations only.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig performance_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPerformanceConfig() {
      bitField0_ = (bitField0_ & ~0x00800000);
      performanceConfig_ = null;
      if (performanceConfigBuilder_ != null) {
        performanceConfigBuilder_.dispose();
        performanceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data dump parallelism settings used by the migration.
     * Currently applicable only for MySQL to Cloud SQL for MySQL migrations only.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig performance_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.Builder
        getPerformanceConfigBuilder() {
      bitField0_ |= 0x00800000;
      onChanged();
      return getPerformanceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Data dump parallelism settings used by the migration.
     * Currently applicable only for MySQL to Cloud SQL for MySQL migrations only.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig performance_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfigOrBuilder
        getPerformanceConfigOrBuilder() {
      if (performanceConfigBuilder_ != null) {
        return performanceConfigBuilder_.getMessageOrBuilder();
      } else {
        return performanceConfig_ == null
            ? com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.getDefaultInstance()
            : performanceConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Data dump parallelism settings used by the migration.
     * Currently applicable only for MySQL to Cloud SQL for MySQL migrations only.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJob.PerformanceConfig performance_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig,
            com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.Builder,
            com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfigOrBuilder>
        getPerformanceConfigFieldBuilder() {
      if (performanceConfigBuilder_ == null) {
        performanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig,
                com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfig.Builder,
                com.google.cloud.clouddms.v1.MigrationJob.PerformanceConfigOrBuilder>(
                getPerformanceConfig(), getParentForChildren(), isClean());
        performanceConfig_ = null;
      }
      return performanceConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.MigrationJob)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.MigrationJob)
  private static final com.google.cloud.clouddms.v1.MigrationJob DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.MigrationJob();
  }

  public static com.google.cloud.clouddms.v1.MigrationJob getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MigrationJob> PARSER =
      new com.google.protobuf.AbstractParser<MigrationJob>() {
        @java.lang.Override
        public MigrationJob parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MigrationJob> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MigrationJob> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.MigrationJob getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
