/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/clouddms_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Error message of a verification Migration job.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.MigrationJobVerificationError}
 */
public final class MigrationJobVerificationError extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.MigrationJobVerificationError)
    MigrationJobVerificationErrorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MigrationJobVerificationError.newBuilder() to construct.
  private MigrationJobVerificationError(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MigrationJobVerificationError() {
    errorCode_ = 0;
    errorMessage_ = "";
    errorDetailMessage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MigrationJobVerificationError();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
        .internal_static_google_cloud_clouddms_v1_MigrationJobVerificationError_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
        .internal_static_google_cloud_clouddms_v1_MigrationJobVerificationError_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.MigrationJobVerificationError.class,
            com.google.cloud.clouddms.v1.MigrationJobVerificationError.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * A general error code describing the type of error that occurred.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode}
   */
  public enum ErrorCode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * An unknown error occurred
     * </pre>
     *
     * <code>ERROR_CODE_UNSPECIFIED = 0;</code>
     */
    ERROR_CODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * We failed to connect to one of the connection profile.
     * </pre>
     *
     * <code>CONNECTION_FAILURE = 1;</code>
     */
    CONNECTION_FAILURE(1),
    /**
     *
     *
     * <pre>
     * We failed to authenticate to one of the connection profile.
     * </pre>
     *
     * <code>AUTHENTICATION_FAILURE = 2;</code>
     */
    AUTHENTICATION_FAILURE(2),
    /**
     *
     *
     * <pre>
     * One of the involved connection profiles has an invalid configuration.
     * </pre>
     *
     * <code>INVALID_CONNECTION_PROFILE_CONFIG = 3;</code>
     */
    INVALID_CONNECTION_PROFILE_CONFIG(3),
    /**
     *
     *
     * <pre>
     * The versions of the source and the destination are incompatible.
     * </pre>
     *
     * <code>VERSION_INCOMPATIBILITY = 4;</code>
     */
    VERSION_INCOMPATIBILITY(4),
    /**
     *
     *
     * <pre>
     * The types of the source and the destination are incompatible.
     * </pre>
     *
     * <code>CONNECTION_PROFILE_TYPES_INCOMPATIBILITY = 5;</code>
     */
    CONNECTION_PROFILE_TYPES_INCOMPATIBILITY(5),
    /**
     *
     *
     * <pre>
     * No pglogical extension installed on databases, applicable for postgres.
     * </pre>
     *
     * <code>NO_PGLOGICAL_INSTALLED = 7;</code>
     */
    NO_PGLOGICAL_INSTALLED(7),
    /**
     *
     *
     * <pre>
     * pglogical node already exists on databases, applicable for postgres.
     * </pre>
     *
     * <code>PGLOGICAL_NODE_ALREADY_EXISTS = 8;</code>
     */
    PGLOGICAL_NODE_ALREADY_EXISTS(8),
    /**
     *
     *
     * <pre>
     * The value of parameter wal_level is not set to logical.
     * </pre>
     *
     * <code>INVALID_WAL_LEVEL = 9;</code>
     */
    INVALID_WAL_LEVEL(9),
    /**
     *
     *
     * <pre>
     * The value of parameter shared_preload_libraries does not include
     * pglogical.
     * </pre>
     *
     * <code>INVALID_SHARED_PRELOAD_LIBRARY = 10;</code>
     */
    INVALID_SHARED_PRELOAD_LIBRARY(10),
    /**
     *
     *
     * <pre>
     * The value of parameter max_replication_slots is not sufficient.
     * </pre>
     *
     * <code>INSUFFICIENT_MAX_REPLICATION_SLOTS = 11;</code>
     */
    INSUFFICIENT_MAX_REPLICATION_SLOTS(11),
    /**
     *
     *
     * <pre>
     * The value of parameter max_wal_senders is not sufficient.
     * </pre>
     *
     * <code>INSUFFICIENT_MAX_WAL_SENDERS = 12;</code>
     */
    INSUFFICIENT_MAX_WAL_SENDERS(12),
    /**
     *
     *
     * <pre>
     * The value of parameter max_worker_processes is not sufficient.
     * </pre>
     *
     * <code>INSUFFICIENT_MAX_WORKER_PROCESSES = 13;</code>
     */
    INSUFFICIENT_MAX_WORKER_PROCESSES(13),
    /**
     *
     *
     * <pre>
     * Extensions installed are either not supported or having unsupported
     * versions.
     * </pre>
     *
     * <code>UNSUPPORTED_EXTENSIONS = 14;</code>
     */
    UNSUPPORTED_EXTENSIONS(14),
    /**
     *
     *
     * <pre>
     * Unsupported migration type.
     * </pre>
     *
     * <code>UNSUPPORTED_MIGRATION_TYPE = 15;</code>
     */
    UNSUPPORTED_MIGRATION_TYPE(15),
    /**
     *
     *
     * <pre>
     * Invalid RDS logical replication.
     * </pre>
     *
     * <code>INVALID_RDS_LOGICAL_REPLICATION = 16;</code>
     */
    INVALID_RDS_LOGICAL_REPLICATION(16),
    /**
     *
     *
     * <pre>
     * The gtid_mode is not supported, applicable for MySQL.
     * </pre>
     *
     * <code>UNSUPPORTED_GTID_MODE = 17;</code>
     */
    UNSUPPORTED_GTID_MODE(17),
    /**
     *
     *
     * <pre>
     * The table definition is not support due to missing primary key or replica
     * identity.
     * </pre>
     *
     * <code>UNSUPPORTED_TABLE_DEFINITION = 18;</code>
     */
    UNSUPPORTED_TABLE_DEFINITION(18),
    /**
     *
     *
     * <pre>
     * The definer is not supported.
     * </pre>
     *
     * <code>UNSUPPORTED_DEFINER = 19;</code>
     */
    UNSUPPORTED_DEFINER(19),
    /**
     *
     *
     * <pre>
     * Migration is already running at the time of restart request.
     * </pre>
     *
     * <code>CANT_RESTART_RUNNING_MIGRATION = 21;</code>
     */
    CANT_RESTART_RUNNING_MIGRATION(21),
    /**
     *
     *
     * <pre>
     * The source already has a replication setup.
     * </pre>
     *
     * <code>SOURCE_ALREADY_SETUP = 23;</code>
     */
    SOURCE_ALREADY_SETUP(23),
    /**
     *
     *
     * <pre>
     * The source has tables with limited support.
     * E.g. PostgreSQL tables without primary keys.
     * </pre>
     *
     * <code>TABLES_WITH_LIMITED_SUPPORT = 24;</code>
     */
    TABLES_WITH_LIMITED_SUPPORT(24),
    /**
     *
     *
     * <pre>
     * The source uses an unsupported locale.
     * </pre>
     *
     * <code>UNSUPPORTED_DATABASE_LOCALE = 25;</code>
     */
    UNSUPPORTED_DATABASE_LOCALE(25),
    /**
     *
     *
     * <pre>
     * The source uses an unsupported Foreign Data Wrapper configuration.
     * </pre>
     *
     * <code>UNSUPPORTED_DATABASE_FDW_CONFIG = 26;</code>
     */
    UNSUPPORTED_DATABASE_FDW_CONFIG(26),
    /**
     *
     *
     * <pre>
     * There was an underlying RDBMS error.
     * </pre>
     *
     * <code>ERROR_RDBMS = 27;</code>
     */
    ERROR_RDBMS(27),
    /**
     *
     *
     * <pre>
     * The source DB size in Bytes exceeds a certain threshold. The migration
     * might require an increase of quota, or might not be supported.
     * </pre>
     *
     * <code>SOURCE_SIZE_EXCEEDS_THRESHOLD = 28;</code>
     */
    SOURCE_SIZE_EXCEEDS_THRESHOLD(28),
    /**
     *
     *
     * <pre>
     * The destination DB contains existing databases that are conflicting with
     * those in the source DB.
     * </pre>
     *
     * <code>EXISTING_CONFLICTING_DATABASES = 29;</code>
     */
    EXISTING_CONFLICTING_DATABASES(29),
    /**
     *
     *
     * <pre>
     * Insufficient privilege to enable the parallelism configuration.
     * </pre>
     *
     * <code>PARALLEL_IMPORT_INSUFFICIENT_PRIVILEGE = 30;</code>
     */
    PARALLEL_IMPORT_INSUFFICIENT_PRIVILEGE(30),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * An unknown error occurred
     * </pre>
     *
     * <code>ERROR_CODE_UNSPECIFIED = 0;</code>
     */
    public static final int ERROR_CODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * We failed to connect to one of the connection profile.
     * </pre>
     *
     * <code>CONNECTION_FAILURE = 1;</code>
     */
    public static final int CONNECTION_FAILURE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * We failed to authenticate to one of the connection profile.
     * </pre>
     *
     * <code>AUTHENTICATION_FAILURE = 2;</code>
     */
    public static final int AUTHENTICATION_FAILURE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * One of the involved connection profiles has an invalid configuration.
     * </pre>
     *
     * <code>INVALID_CONNECTION_PROFILE_CONFIG = 3;</code>
     */
    public static final int INVALID_CONNECTION_PROFILE_CONFIG_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The versions of the source and the destination are incompatible.
     * </pre>
     *
     * <code>VERSION_INCOMPATIBILITY = 4;</code>
     */
    public static final int VERSION_INCOMPATIBILITY_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The types of the source and the destination are incompatible.
     * </pre>
     *
     * <code>CONNECTION_PROFILE_TYPES_INCOMPATIBILITY = 5;</code>
     */
    public static final int CONNECTION_PROFILE_TYPES_INCOMPATIBILITY_VALUE = 5;
    /**
     *
     *
     * <pre>
     * No pglogical extension installed on databases, applicable for postgres.
     * </pre>
     *
     * <code>NO_PGLOGICAL_INSTALLED = 7;</code>
     */
    public static final int NO_PGLOGICAL_INSTALLED_VALUE = 7;
    /**
     *
     *
     * <pre>
     * pglogical node already exists on databases, applicable for postgres.
     * </pre>
     *
     * <code>PGLOGICAL_NODE_ALREADY_EXISTS = 8;</code>
     */
    public static final int PGLOGICAL_NODE_ALREADY_EXISTS_VALUE = 8;
    /**
     *
     *
     * <pre>
     * The value of parameter wal_level is not set to logical.
     * </pre>
     *
     * <code>INVALID_WAL_LEVEL = 9;</code>
     */
    public static final int INVALID_WAL_LEVEL_VALUE = 9;
    /**
     *
     *
     * <pre>
     * The value of parameter shared_preload_libraries does not include
     * pglogical.
     * </pre>
     *
     * <code>INVALID_SHARED_PRELOAD_LIBRARY = 10;</code>
     */
    public static final int INVALID_SHARED_PRELOAD_LIBRARY_VALUE = 10;
    /**
     *
     *
     * <pre>
     * The value of parameter max_replication_slots is not sufficient.
     * </pre>
     *
     * <code>INSUFFICIENT_MAX_REPLICATION_SLOTS = 11;</code>
     */
    public static final int INSUFFICIENT_MAX_REPLICATION_SLOTS_VALUE = 11;
    /**
     *
     *
     * <pre>
     * The value of parameter max_wal_senders is not sufficient.
     * </pre>
     *
     * <code>INSUFFICIENT_MAX_WAL_SENDERS = 12;</code>
     */
    public static final int INSUFFICIENT_MAX_WAL_SENDERS_VALUE = 12;
    /**
     *
     *
     * <pre>
     * The value of parameter max_worker_processes is not sufficient.
     * </pre>
     *
     * <code>INSUFFICIENT_MAX_WORKER_PROCESSES = 13;</code>
     */
    public static final int INSUFFICIENT_MAX_WORKER_PROCESSES_VALUE = 13;
    /**
     *
     *
     * <pre>
     * Extensions installed are either not supported or having unsupported
     * versions.
     * </pre>
     *
     * <code>UNSUPPORTED_EXTENSIONS = 14;</code>
     */
    public static final int UNSUPPORTED_EXTENSIONS_VALUE = 14;
    /**
     *
     *
     * <pre>
     * Unsupported migration type.
     * </pre>
     *
     * <code>UNSUPPORTED_MIGRATION_TYPE = 15;</code>
     */
    public static final int UNSUPPORTED_MIGRATION_TYPE_VALUE = 15;
    /**
     *
     *
     * <pre>
     * Invalid RDS logical replication.
     * </pre>
     *
     * <code>INVALID_RDS_LOGICAL_REPLICATION = 16;</code>
     */
    public static final int INVALID_RDS_LOGICAL_REPLICATION_VALUE = 16;
    /**
     *
     *
     * <pre>
     * The gtid_mode is not supported, applicable for MySQL.
     * </pre>
     *
     * <code>UNSUPPORTED_GTID_MODE = 17;</code>
     */
    public static final int UNSUPPORTED_GTID_MODE_VALUE = 17;
    /**
     *
     *
     * <pre>
     * The table definition is not support due to missing primary key or replica
     * identity.
     * </pre>
     *
     * <code>UNSUPPORTED_TABLE_DEFINITION = 18;</code>
     */
    public static final int UNSUPPORTED_TABLE_DEFINITION_VALUE = 18;
    /**
     *
     *
     * <pre>
     * The definer is not supported.
     * </pre>
     *
     * <code>UNSUPPORTED_DEFINER = 19;</code>
     */
    public static final int UNSUPPORTED_DEFINER_VALUE = 19;
    /**
     *
     *
     * <pre>
     * Migration is already running at the time of restart request.
     * </pre>
     *
     * <code>CANT_RESTART_RUNNING_MIGRATION = 21;</code>
     */
    public static final int CANT_RESTART_RUNNING_MIGRATION_VALUE = 21;
    /**
     *
     *
     * <pre>
     * The source already has a replication setup.
     * </pre>
     *
     * <code>SOURCE_ALREADY_SETUP = 23;</code>
     */
    public static final int SOURCE_ALREADY_SETUP_VALUE = 23;
    /**
     *
     *
     * <pre>
     * The source has tables with limited support.
     * E.g. PostgreSQL tables without primary keys.
     * </pre>
     *
     * <code>TABLES_WITH_LIMITED_SUPPORT = 24;</code>
     */
    public static final int TABLES_WITH_LIMITED_SUPPORT_VALUE = 24;
    /**
     *
     *
     * <pre>
     * The source uses an unsupported locale.
     * </pre>
     *
     * <code>UNSUPPORTED_DATABASE_LOCALE = 25;</code>
     */
    public static final int UNSUPPORTED_DATABASE_LOCALE_VALUE = 25;
    /**
     *
     *
     * <pre>
     * The source uses an unsupported Foreign Data Wrapper configuration.
     * </pre>
     *
     * <code>UNSUPPORTED_DATABASE_FDW_CONFIG = 26;</code>
     */
    public static final int UNSUPPORTED_DATABASE_FDW_CONFIG_VALUE = 26;
    /**
     *
     *
     * <pre>
     * There was an underlying RDBMS error.
     * </pre>
     *
     * <code>ERROR_RDBMS = 27;</code>
     */
    public static final int ERROR_RDBMS_VALUE = 27;
    /**
     *
     *
     * <pre>
     * The source DB size in Bytes exceeds a certain threshold. The migration
     * might require an increase of quota, or might not be supported.
     * </pre>
     *
     * <code>SOURCE_SIZE_EXCEEDS_THRESHOLD = 28;</code>
     */
    public static final int SOURCE_SIZE_EXCEEDS_THRESHOLD_VALUE = 28;
    /**
     *
     *
     * <pre>
     * The destination DB contains existing databases that are conflicting with
     * those in the source DB.
     * </pre>
     *
     * <code>EXISTING_CONFLICTING_DATABASES = 29;</code>
     */
    public static final int EXISTING_CONFLICTING_DATABASES_VALUE = 29;
    /**
     *
     *
     * <pre>
     * Insufficient privilege to enable the parallelism configuration.
     * </pre>
     *
     * <code>PARALLEL_IMPORT_INSUFFICIENT_PRIVILEGE = 30;</code>
     */
    public static final int PARALLEL_IMPORT_INSUFFICIENT_PRIVILEGE_VALUE = 30;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ErrorCode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ErrorCode forNumber(int value) {
      switch (value) {
        case 0:
          return ERROR_CODE_UNSPECIFIED;
        case 1:
          return CONNECTION_FAILURE;
        case 2:
          return AUTHENTICATION_FAILURE;
        case 3:
          return INVALID_CONNECTION_PROFILE_CONFIG;
        case 4:
          return VERSION_INCOMPATIBILITY;
        case 5:
          return CONNECTION_PROFILE_TYPES_INCOMPATIBILITY;
        case 7:
          return NO_PGLOGICAL_INSTALLED;
        case 8:
          return PGLOGICAL_NODE_ALREADY_EXISTS;
        case 9:
          return INVALID_WAL_LEVEL;
        case 10:
          return INVALID_SHARED_PRELOAD_LIBRARY;
        case 11:
          return INSUFFICIENT_MAX_REPLICATION_SLOTS;
        case 12:
          return INSUFFICIENT_MAX_WAL_SENDERS;
        case 13:
          return INSUFFICIENT_MAX_WORKER_PROCESSES;
        case 14:
          return UNSUPPORTED_EXTENSIONS;
        case 15:
          return UNSUPPORTED_MIGRATION_TYPE;
        case 16:
          return INVALID_RDS_LOGICAL_REPLICATION;
        case 17:
          return UNSUPPORTED_GTID_MODE;
        case 18:
          return UNSUPPORTED_TABLE_DEFINITION;
        case 19:
          return UNSUPPORTED_DEFINER;
        case 21:
          return CANT_RESTART_RUNNING_MIGRATION;
        case 23:
          return SOURCE_ALREADY_SETUP;
        case 24:
          return TABLES_WITH_LIMITED_SUPPORT;
        case 25:
          return UNSUPPORTED_DATABASE_LOCALE;
        case 26:
          return UNSUPPORTED_DATABASE_FDW_CONFIG;
        case 27:
          return ERROR_RDBMS;
        case 28:
          return SOURCE_SIZE_EXCEEDS_THRESHOLD;
        case 29:
          return EXISTING_CONFLICTING_DATABASES;
        case 30:
          return PARALLEL_IMPORT_INSUFFICIENT_PRIVILEGE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ErrorCode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ErrorCode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ErrorCode>() {
          public ErrorCode findValueByNumber(int number) {
            return ErrorCode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.MigrationJobVerificationError.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ErrorCode[] VALUES = values();

    public static ErrorCode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ErrorCode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode)
  }

  public static final int ERROR_CODE_FIELD_NUMBER = 1;
  private int errorCode_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. An instance of ErrorCode specifying the error that occurred.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode error_code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for errorCode.
   */
  @java.lang.Override
  public int getErrorCodeValue() {
    return errorCode_;
  }
  /**
   *
   *
   * <pre>
   * Output only. An instance of ErrorCode specifying the error that occurred.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode error_code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The errorCode.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode getErrorCode() {
    com.google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode result =
        com.google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode.forNumber(errorCode_);
    return result == null
        ? com.google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode.UNRECOGNIZED
        : result;
  }

  public static final int ERROR_MESSAGE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object errorMessage_ = "";
  /**
   *
   *
   * <pre>
   * Output only. A formatted message with further details about the error and a
   * CTA.
   * </pre>
   *
   * <code>string error_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The errorMessage.
   */
  @java.lang.Override
  public java.lang.String getErrorMessage() {
    java.lang.Object ref = errorMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      errorMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. A formatted message with further details about the error and a
   * CTA.
   * </pre>
   *
   * <code>string error_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for errorMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getErrorMessageBytes() {
    java.lang.Object ref = errorMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      errorMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERROR_DETAIL_MESSAGE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object errorDetailMessage_ = "";
  /**
   *
   *
   * <pre>
   * Output only. A specific detailed error message, if supplied by the engine.
   * </pre>
   *
   * <code>string error_detail_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The errorDetailMessage.
   */
  @java.lang.Override
  public java.lang.String getErrorDetailMessage() {
    java.lang.Object ref = errorDetailMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      errorDetailMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. A specific detailed error message, if supplied by the engine.
   * </pre>
   *
   * <code>string error_detail_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for errorDetailMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getErrorDetailMessageBytes() {
    java.lang.Object ref = errorDetailMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      errorDetailMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (errorCode_
        != com.google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode
            .ERROR_CODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, errorCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, errorMessage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorDetailMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, errorDetailMessage_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (errorCode_
        != com.google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode
            .ERROR_CODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, errorCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, errorMessage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorDetailMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, errorDetailMessage_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.MigrationJobVerificationError)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.MigrationJobVerificationError other =
        (com.google.cloud.clouddms.v1.MigrationJobVerificationError) obj;

    if (errorCode_ != other.errorCode_) return false;
    if (!getErrorMessage().equals(other.getErrorMessage())) return false;
    if (!getErrorDetailMessage().equals(other.getErrorDetailMessage())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ERROR_CODE_FIELD_NUMBER;
    hash = (53 * hash) + errorCode_;
    hash = (37 * hash) + ERROR_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getErrorMessage().hashCode();
    hash = (37 * hash) + ERROR_DETAIL_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getErrorDetailMessage().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.MigrationJobVerificationError parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.MigrationJobVerificationError parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MigrationJobVerificationError parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.MigrationJobVerificationError parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MigrationJobVerificationError parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.MigrationJobVerificationError parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MigrationJobVerificationError parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.MigrationJobVerificationError parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MigrationJobVerificationError parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.MigrationJobVerificationError parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MigrationJobVerificationError parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.MigrationJobVerificationError parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.clouddms.v1.MigrationJobVerificationError prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Error message of a verification Migration job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.MigrationJobVerificationError}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.MigrationJobVerificationError)
      com.google.cloud.clouddms.v1.MigrationJobVerificationErrorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_MigrationJobVerificationError_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_MigrationJobVerificationError_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.MigrationJobVerificationError.class,
              com.google.cloud.clouddms.v1.MigrationJobVerificationError.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.MigrationJobVerificationError.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      errorCode_ = 0;
      errorMessage_ = "";
      errorDetailMessage_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_MigrationJobVerificationError_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MigrationJobVerificationError getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.MigrationJobVerificationError.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MigrationJobVerificationError build() {
      com.google.cloud.clouddms.v1.MigrationJobVerificationError result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MigrationJobVerificationError buildPartial() {
      com.google.cloud.clouddms.v1.MigrationJobVerificationError result =
          new com.google.cloud.clouddms.v1.MigrationJobVerificationError(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.MigrationJobVerificationError result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.errorCode_ = errorCode_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.errorMessage_ = errorMessage_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.errorDetailMessage_ = errorDetailMessage_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.MigrationJobVerificationError) {
        return mergeFrom((com.google.cloud.clouddms.v1.MigrationJobVerificationError) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.MigrationJobVerificationError other) {
      if (other == com.google.cloud.clouddms.v1.MigrationJobVerificationError.getDefaultInstance())
        return this;
      if (other.errorCode_ != 0) {
        setErrorCodeValue(other.getErrorCodeValue());
      }
      if (!other.getErrorMessage().isEmpty()) {
        errorMessage_ = other.errorMessage_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getErrorDetailMessage().isEmpty()) {
        errorDetailMessage_ = other.errorDetailMessage_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                errorCode_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                errorMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                errorDetailMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int errorCode_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. An instance of ErrorCode specifying the error that occurred.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode error_code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for errorCode.
     */
    @java.lang.Override
    public int getErrorCodeValue() {
      return errorCode_;
    }
    /**
     *
     *
     * <pre>
     * Output only. An instance of ErrorCode specifying the error that occurred.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode error_code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for errorCode to set.
     * @return This builder for chaining.
     */
    public Builder setErrorCodeValue(int value) {
      errorCode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An instance of ErrorCode specifying the error that occurred.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode error_code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The errorCode.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode getErrorCode() {
      com.google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode result =
          com.google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode.forNumber(
              errorCode_);
      return result == null
          ? com.google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. An instance of ErrorCode specifying the error that occurred.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode error_code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The errorCode to set.
     * @return This builder for chaining.
     */
    public Builder setErrorCode(
        com.google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      errorCode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An instance of ErrorCode specifying the error that occurred.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode error_code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorCode() {
      bitField0_ = (bitField0_ & ~0x00000001);
      errorCode_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object errorMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. A formatted message with further details about the error and a
     * CTA.
     * </pre>
     *
     * <code>string error_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The errorMessage.
     */
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A formatted message with further details about the error and a
     * CTA.
     * </pre>
     *
     * <code>string error_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for errorMessage.
     */
    public com.google.protobuf.ByteString getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A formatted message with further details about the error and a
     * CTA.
     * </pre>
     *
     * <code>string error_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The errorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      errorMessage_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A formatted message with further details about the error and a
     * CTA.
     * </pre>
     *
     * <code>string error_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorMessage() {
      errorMessage_ = getDefaultInstance().getErrorMessage();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A formatted message with further details about the error and a
     * CTA.
     * </pre>
     *
     * <code>string error_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for errorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      errorMessage_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object errorDetailMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. A specific detailed error message, if supplied by the engine.
     * </pre>
     *
     * <code>string error_detail_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The errorDetailMessage.
     */
    public java.lang.String getErrorDetailMessage() {
      java.lang.Object ref = errorDetailMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorDetailMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A specific detailed error message, if supplied by the engine.
     * </pre>
     *
     * <code>string error_detail_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for errorDetailMessage.
     */
    public com.google.protobuf.ByteString getErrorDetailMessageBytes() {
      java.lang.Object ref = errorDetailMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorDetailMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A specific detailed error message, if supplied by the engine.
     * </pre>
     *
     * <code>string error_detail_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The errorDetailMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorDetailMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      errorDetailMessage_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A specific detailed error message, if supplied by the engine.
     * </pre>
     *
     * <code>string error_detail_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorDetailMessage() {
      errorDetailMessage_ = getDefaultInstance().getErrorDetailMessage();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A specific detailed error message, if supplied by the engine.
     * </pre>
     *
     * <code>string error_detail_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for errorDetailMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorDetailMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      errorDetailMessage_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.MigrationJobVerificationError)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.MigrationJobVerificationError)
  private static final com.google.cloud.clouddms.v1.MigrationJobVerificationError DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.MigrationJobVerificationError();
  }

  public static com.google.cloud.clouddms.v1.MigrationJobVerificationError getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MigrationJobVerificationError> PARSER =
      new com.google.protobuf.AbstractParser<MigrationJobVerificationError>() {
        @java.lang.Override
        public MigrationJobVerificationError parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MigrationJobVerificationError> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MigrationJobVerificationError> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.MigrationJobVerificationError getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
