/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Options to configure rule type MultiColumnDatatypeChange.
 * The rule is used to change the data type and associated properties of
 * multiple columns at once.
 *
 * The rule filter field can refer to one or more entities.
 *
 * The rule scope can be one of:Column.
 *
 * This rule requires additional filters to be specified beyond the basic rule
 * filter field, which is the source data type, but the rule supports additional
 * filtering capabilities such as the minimum and maximum field length. All
 * additional filters which are specified are required to be met in order for
 * the rule to be applied (logical AND between the fields).
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.MultiColumnDatatypeChange}
 */
public final class MultiColumnDatatypeChange extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.MultiColumnDatatypeChange)
    MultiColumnDatatypeChangeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MultiColumnDatatypeChange.newBuilder() to construct.
  private MultiColumnDatatypeChange(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MultiColumnDatatypeChange() {
    sourceDataTypeFilter_ = "";
    newDataType_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MultiColumnDatatypeChange();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_MultiColumnDatatypeChange_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_MultiColumnDatatypeChange_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.MultiColumnDatatypeChange.class,
            com.google.cloud.clouddms.v1.MultiColumnDatatypeChange.Builder.class);
  }

  private int bitField0_;
  private int sourceFilterCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object sourceFilter_;

  public enum SourceFilterCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SOURCE_TEXT_FILTER(100),
    SOURCE_NUMERIC_FILTER(101),
    SOURCEFILTER_NOT_SET(0);
    private final int value;

    private SourceFilterCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceFilterCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceFilterCase forNumber(int value) {
      switch (value) {
        case 100:
          return SOURCE_TEXT_FILTER;
        case 101:
          return SOURCE_NUMERIC_FILTER;
        case 0:
          return SOURCEFILTER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceFilterCase getSourceFilterCase() {
    return SourceFilterCase.forNumber(sourceFilterCase_);
  }

  public static final int SOURCE_DATA_TYPE_FILTER_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceDataTypeFilter_ = "";
  /**
   *
   *
   * <pre>
   * Required. Filter on source data type.
   * </pre>
   *
   * <code>string source_data_type_filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The sourceDataTypeFilter.
   */
  @java.lang.Override
  public java.lang.String getSourceDataTypeFilter() {
    java.lang.Object ref = sourceDataTypeFilter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceDataTypeFilter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Filter on source data type.
   * </pre>
   *
   * <code>string source_data_type_filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for sourceDataTypeFilter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceDataTypeFilterBytes() {
    java.lang.Object ref = sourceDataTypeFilter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceDataTypeFilter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_TEXT_FILTER_FIELD_NUMBER = 100;
  /**
   *
   *
   * <pre>
   * Optional. Filter for text-based data types like varchar.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the sourceTextFilter field is set.
   */
  @java.lang.Override
  public boolean hasSourceTextFilter() {
    return sourceFilterCase_ == 100;
  }
  /**
   *
   *
   * <pre>
   * Optional. Filter for text-based data types like varchar.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The sourceTextFilter.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SourceTextFilter getSourceTextFilter() {
    if (sourceFilterCase_ == 100) {
      return (com.google.cloud.clouddms.v1.SourceTextFilter) sourceFilter_;
    }
    return com.google.cloud.clouddms.v1.SourceTextFilter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Filter for text-based data types like varchar.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SourceTextFilterOrBuilder getSourceTextFilterOrBuilder() {
    if (sourceFilterCase_ == 100) {
      return (com.google.cloud.clouddms.v1.SourceTextFilter) sourceFilter_;
    }
    return com.google.cloud.clouddms.v1.SourceTextFilter.getDefaultInstance();
  }

  public static final int SOURCE_NUMERIC_FILTER_FIELD_NUMBER = 101;
  /**
   *
   *
   * <pre>
   * Optional. Filter for fixed point number data types such as
   * NUMERIC/NUMBER.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the sourceNumericFilter field is set.
   */
  @java.lang.Override
  public boolean hasSourceNumericFilter() {
    return sourceFilterCase_ == 101;
  }
  /**
   *
   *
   * <pre>
   * Optional. Filter for fixed point number data types such as
   * NUMERIC/NUMBER.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The sourceNumericFilter.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SourceNumericFilter getSourceNumericFilter() {
    if (sourceFilterCase_ == 101) {
      return (com.google.cloud.clouddms.v1.SourceNumericFilter) sourceFilter_;
    }
    return com.google.cloud.clouddms.v1.SourceNumericFilter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Filter for fixed point number data types such as
   * NUMERIC/NUMBER.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SourceNumericFilterOrBuilder
      getSourceNumericFilterOrBuilder() {
    if (sourceFilterCase_ == 101) {
      return (com.google.cloud.clouddms.v1.SourceNumericFilter) sourceFilter_;
    }
    return com.google.cloud.clouddms.v1.SourceNumericFilter.getDefaultInstance();
  }

  public static final int NEW_DATA_TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object newDataType_ = "";
  /**
   *
   *
   * <pre>
   * Required. New data type.
   * </pre>
   *
   * <code>string new_data_type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The newDataType.
   */
  @java.lang.Override
  public java.lang.String getNewDataType() {
    java.lang.Object ref = newDataType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      newDataType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. New data type.
   * </pre>
   *
   * <code>string new_data_type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for newDataType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNewDataTypeBytes() {
    java.lang.Object ref = newDataType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      newDataType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OVERRIDE_LENGTH_FIELD_NUMBER = 3;
  private long overrideLength_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional. Column length - e.g. varchar (50) - if not specified and relevant
   * uses the source column length.
   * </pre>
   *
   * <code>int64 override_length = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The overrideLength.
   */
  @java.lang.Override
  public long getOverrideLength() {
    return overrideLength_;
  }

  public static final int OVERRIDE_SCALE_FIELD_NUMBER = 4;
  private int overrideScale_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Column scale - when relevant - if not specified and relevant
   * uses the source column scale.
   * </pre>
   *
   * <code>int32 override_scale = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The overrideScale.
   */
  @java.lang.Override
  public int getOverrideScale() {
    return overrideScale_;
  }

  public static final int OVERRIDE_PRECISION_FIELD_NUMBER = 5;
  private int overridePrecision_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Column precision - when relevant - if not specified and relevant
   * uses the source column precision.
   * </pre>
   *
   * <code>int32 override_precision = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The overridePrecision.
   */
  @java.lang.Override
  public int getOverridePrecision() {
    return overridePrecision_;
  }

  public static final int OVERRIDE_FRACTIONAL_SECONDS_PRECISION_FIELD_NUMBER = 6;
  private int overrideFractionalSecondsPrecision_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Column fractional seconds precision - used only for timestamp
   * based datatypes - if not specified and relevant uses the source column
   * fractional seconds precision.
   * </pre>
   *
   * <code>
   * int32 override_fractional_seconds_precision = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The overrideFractionalSecondsPrecision.
   */
  @java.lang.Override
  public int getOverrideFractionalSecondsPrecision() {
    return overrideFractionalSecondsPrecision_;
  }

  public static final int CUSTOM_FEATURES_FIELD_NUMBER = 7;
  private com.google.protobuf.Struct customFeatures_;
  /**
   *
   *
   * <pre>
   * Optional. Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the customFeatures field is set.
   */
  @java.lang.Override
  public boolean hasCustomFeatures() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The customFeatures.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getCustomFeatures() {
    return customFeatures_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : customFeatures_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getCustomFeaturesOrBuilder() {
    return customFeatures_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : customFeatures_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceDataTypeFilter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, sourceDataTypeFilter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(newDataType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, newDataType_);
    }
    if (overrideLength_ != 0L) {
      output.writeInt64(3, overrideLength_);
    }
    if (overrideScale_ != 0) {
      output.writeInt32(4, overrideScale_);
    }
    if (overridePrecision_ != 0) {
      output.writeInt32(5, overridePrecision_);
    }
    if (overrideFractionalSecondsPrecision_ != 0) {
      output.writeInt32(6, overrideFractionalSecondsPrecision_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getCustomFeatures());
    }
    if (sourceFilterCase_ == 100) {
      output.writeMessage(100, (com.google.cloud.clouddms.v1.SourceTextFilter) sourceFilter_);
    }
    if (sourceFilterCase_ == 101) {
      output.writeMessage(101, (com.google.cloud.clouddms.v1.SourceNumericFilter) sourceFilter_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceDataTypeFilter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, sourceDataTypeFilter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(newDataType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, newDataType_);
    }
    if (overrideLength_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, overrideLength_);
    }
    if (overrideScale_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, overrideScale_);
    }
    if (overridePrecision_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, overridePrecision_);
    }
    if (overrideFractionalSecondsPrecision_ != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              6, overrideFractionalSecondsPrecision_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCustomFeatures());
    }
    if (sourceFilterCase_ == 100) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              100, (com.google.cloud.clouddms.v1.SourceTextFilter) sourceFilter_);
    }
    if (sourceFilterCase_ == 101) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              101, (com.google.cloud.clouddms.v1.SourceNumericFilter) sourceFilter_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.MultiColumnDatatypeChange)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.MultiColumnDatatypeChange other =
        (com.google.cloud.clouddms.v1.MultiColumnDatatypeChange) obj;

    if (!getSourceDataTypeFilter().equals(other.getSourceDataTypeFilter())) return false;
    if (!getNewDataType().equals(other.getNewDataType())) return false;
    if (getOverrideLength() != other.getOverrideLength()) return false;
    if (getOverrideScale() != other.getOverrideScale()) return false;
    if (getOverridePrecision() != other.getOverridePrecision()) return false;
    if (getOverrideFractionalSecondsPrecision() != other.getOverrideFractionalSecondsPrecision())
      return false;
    if (hasCustomFeatures() != other.hasCustomFeatures()) return false;
    if (hasCustomFeatures()) {
      if (!getCustomFeatures().equals(other.getCustomFeatures())) return false;
    }
    if (!getSourceFilterCase().equals(other.getSourceFilterCase())) return false;
    switch (sourceFilterCase_) {
      case 100:
        if (!getSourceTextFilter().equals(other.getSourceTextFilter())) return false;
        break;
      case 101:
        if (!getSourceNumericFilter().equals(other.getSourceNumericFilter())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SOURCE_DATA_TYPE_FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getSourceDataTypeFilter().hashCode();
    hash = (37 * hash) + NEW_DATA_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getNewDataType().hashCode();
    hash = (37 * hash) + OVERRIDE_LENGTH_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getOverrideLength());
    hash = (37 * hash) + OVERRIDE_SCALE_FIELD_NUMBER;
    hash = (53 * hash) + getOverrideScale();
    hash = (37 * hash) + OVERRIDE_PRECISION_FIELD_NUMBER;
    hash = (53 * hash) + getOverridePrecision();
    hash = (37 * hash) + OVERRIDE_FRACTIONAL_SECONDS_PRECISION_FIELD_NUMBER;
    hash = (53 * hash) + getOverrideFractionalSecondsPrecision();
    if (hasCustomFeatures()) {
      hash = (37 * hash) + CUSTOM_FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getCustomFeatures().hashCode();
    }
    switch (sourceFilterCase_) {
      case 100:
        hash = (37 * hash) + SOURCE_TEXT_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getSourceTextFilter().hashCode();
        break;
      case 101:
        hash = (37 * hash) + SOURCE_NUMERIC_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getSourceNumericFilter().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.MultiColumnDatatypeChange parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.MultiColumnDatatypeChange parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MultiColumnDatatypeChange parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.MultiColumnDatatypeChange parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MultiColumnDatatypeChange parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.MultiColumnDatatypeChange parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MultiColumnDatatypeChange parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.MultiColumnDatatypeChange parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MultiColumnDatatypeChange parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.MultiColumnDatatypeChange parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MultiColumnDatatypeChange parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.MultiColumnDatatypeChange parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.clouddms.v1.MultiColumnDatatypeChange prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Options to configure rule type MultiColumnDatatypeChange.
   * The rule is used to change the data type and associated properties of
   * multiple columns at once.
   *
   * The rule filter field can refer to one or more entities.
   *
   * The rule scope can be one of:Column.
   *
   * This rule requires additional filters to be specified beyond the basic rule
   * filter field, which is the source data type, but the rule supports additional
   * filtering capabilities such as the minimum and maximum field length. All
   * additional filters which are specified are required to be met in order for
   * the rule to be applied (logical AND between the fields).
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.MultiColumnDatatypeChange}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.MultiColumnDatatypeChange)
      com.google.cloud.clouddms.v1.MultiColumnDatatypeChangeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_MultiColumnDatatypeChange_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_MultiColumnDatatypeChange_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.MultiColumnDatatypeChange.class,
              com.google.cloud.clouddms.v1.MultiColumnDatatypeChange.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.MultiColumnDatatypeChange.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCustomFeaturesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      sourceDataTypeFilter_ = "";
      if (sourceTextFilterBuilder_ != null) {
        sourceTextFilterBuilder_.clear();
      }
      if (sourceNumericFilterBuilder_ != null) {
        sourceNumericFilterBuilder_.clear();
      }
      newDataType_ = "";
      overrideLength_ = 0L;
      overrideScale_ = 0;
      overridePrecision_ = 0;
      overrideFractionalSecondsPrecision_ = 0;
      customFeatures_ = null;
      if (customFeaturesBuilder_ != null) {
        customFeaturesBuilder_.dispose();
        customFeaturesBuilder_ = null;
      }
      sourceFilterCase_ = 0;
      sourceFilter_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_MultiColumnDatatypeChange_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MultiColumnDatatypeChange getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.MultiColumnDatatypeChange.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MultiColumnDatatypeChange build() {
      com.google.cloud.clouddms.v1.MultiColumnDatatypeChange result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MultiColumnDatatypeChange buildPartial() {
      com.google.cloud.clouddms.v1.MultiColumnDatatypeChange result =
          new com.google.cloud.clouddms.v1.MultiColumnDatatypeChange(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.MultiColumnDatatypeChange result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.sourceDataTypeFilter_ = sourceDataTypeFilter_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.newDataType_ = newDataType_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.overrideLength_ = overrideLength_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.overrideScale_ = overrideScale_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.overridePrecision_ = overridePrecision_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.overrideFractionalSecondsPrecision_ = overrideFractionalSecondsPrecision_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.customFeatures_ =
            customFeaturesBuilder_ == null ? customFeatures_ : customFeaturesBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.clouddms.v1.MultiColumnDatatypeChange result) {
      result.sourceFilterCase_ = sourceFilterCase_;
      result.sourceFilter_ = this.sourceFilter_;
      if (sourceFilterCase_ == 100 && sourceTextFilterBuilder_ != null) {
        result.sourceFilter_ = sourceTextFilterBuilder_.build();
      }
      if (sourceFilterCase_ == 101 && sourceNumericFilterBuilder_ != null) {
        result.sourceFilter_ = sourceNumericFilterBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.MultiColumnDatatypeChange) {
        return mergeFrom((com.google.cloud.clouddms.v1.MultiColumnDatatypeChange) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.MultiColumnDatatypeChange other) {
      if (other == com.google.cloud.clouddms.v1.MultiColumnDatatypeChange.getDefaultInstance())
        return this;
      if (!other.getSourceDataTypeFilter().isEmpty()) {
        sourceDataTypeFilter_ = other.sourceDataTypeFilter_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getNewDataType().isEmpty()) {
        newDataType_ = other.newDataType_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getOverrideLength() != 0L) {
        setOverrideLength(other.getOverrideLength());
      }
      if (other.getOverrideScale() != 0) {
        setOverrideScale(other.getOverrideScale());
      }
      if (other.getOverridePrecision() != 0) {
        setOverridePrecision(other.getOverridePrecision());
      }
      if (other.getOverrideFractionalSecondsPrecision() != 0) {
        setOverrideFractionalSecondsPrecision(other.getOverrideFractionalSecondsPrecision());
      }
      if (other.hasCustomFeatures()) {
        mergeCustomFeatures(other.getCustomFeatures());
      }
      switch (other.getSourceFilterCase()) {
        case SOURCE_TEXT_FILTER:
          {
            mergeSourceTextFilter(other.getSourceTextFilter());
            break;
          }
        case SOURCE_NUMERIC_FILTER:
          {
            mergeSourceNumericFilter(other.getSourceNumericFilter());
            break;
          }
        case SOURCEFILTER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                sourceDataTypeFilter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                newDataType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 24:
              {
                overrideLength_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 24
            case 32:
              {
                overrideScale_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 32
            case 40:
              {
                overridePrecision_ = input.readInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 40
            case 48:
              {
                overrideFractionalSecondsPrecision_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 48
            case 58:
              {
                input.readMessage(getCustomFeaturesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 58
            case 802:
              {
                input.readMessage(
                    getSourceTextFilterFieldBuilder().getBuilder(), extensionRegistry);
                sourceFilterCase_ = 100;
                break;
              } // case 802
            case 810:
              {
                input.readMessage(
                    getSourceNumericFilterFieldBuilder().getBuilder(), extensionRegistry);
                sourceFilterCase_ = 101;
                break;
              } // case 810
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceFilterCase_ = 0;
    private java.lang.Object sourceFilter_;

    public SourceFilterCase getSourceFilterCase() {
      return SourceFilterCase.forNumber(sourceFilterCase_);
    }

    public Builder clearSourceFilter() {
      sourceFilterCase_ = 0;
      sourceFilter_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object sourceDataTypeFilter_ = "";
    /**
     *
     *
     * <pre>
     * Required. Filter on source data type.
     * </pre>
     *
     * <code>string source_data_type_filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The sourceDataTypeFilter.
     */
    public java.lang.String getSourceDataTypeFilter() {
      java.lang.Object ref = sourceDataTypeFilter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceDataTypeFilter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Filter on source data type.
     * </pre>
     *
     * <code>string source_data_type_filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for sourceDataTypeFilter.
     */
    public com.google.protobuf.ByteString getSourceDataTypeFilterBytes() {
      java.lang.Object ref = sourceDataTypeFilter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceDataTypeFilter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Filter on source data type.
     * </pre>
     *
     * <code>string source_data_type_filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The sourceDataTypeFilter to set.
     * @return This builder for chaining.
     */
    public Builder setSourceDataTypeFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceDataTypeFilter_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Filter on source data type.
     * </pre>
     *
     * <code>string source_data_type_filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceDataTypeFilter() {
      sourceDataTypeFilter_ = getDefaultInstance().getSourceDataTypeFilter();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Filter on source data type.
     * </pre>
     *
     * <code>string source_data_type_filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for sourceDataTypeFilter to set.
     * @return This builder for chaining.
     */
    public Builder setSourceDataTypeFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceDataTypeFilter_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SourceTextFilter,
            com.google.cloud.clouddms.v1.SourceTextFilter.Builder,
            com.google.cloud.clouddms.v1.SourceTextFilterOrBuilder>
        sourceTextFilterBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Filter for text-based data types like varchar.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sourceTextFilter field is set.
     */
    @java.lang.Override
    public boolean hasSourceTextFilter() {
      return sourceFilterCase_ == 100;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter for text-based data types like varchar.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sourceTextFilter.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SourceTextFilter getSourceTextFilter() {
      if (sourceTextFilterBuilder_ == null) {
        if (sourceFilterCase_ == 100) {
          return (com.google.cloud.clouddms.v1.SourceTextFilter) sourceFilter_;
        }
        return com.google.cloud.clouddms.v1.SourceTextFilter.getDefaultInstance();
      } else {
        if (sourceFilterCase_ == 100) {
          return sourceTextFilterBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.SourceTextFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter for text-based data types like varchar.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSourceTextFilter(com.google.cloud.clouddms.v1.SourceTextFilter value) {
      if (sourceTextFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceFilter_ = value;
        onChanged();
      } else {
        sourceTextFilterBuilder_.setMessage(value);
      }
      sourceFilterCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter for text-based data types like varchar.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSourceTextFilter(
        com.google.cloud.clouddms.v1.SourceTextFilter.Builder builderForValue) {
      if (sourceTextFilterBuilder_ == null) {
        sourceFilter_ = builderForValue.build();
        onChanged();
      } else {
        sourceTextFilterBuilder_.setMessage(builderForValue.build());
      }
      sourceFilterCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter for text-based data types like varchar.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSourceTextFilter(com.google.cloud.clouddms.v1.SourceTextFilter value) {
      if (sourceTextFilterBuilder_ == null) {
        if (sourceFilterCase_ == 100
            && sourceFilter_
                != com.google.cloud.clouddms.v1.SourceTextFilter.getDefaultInstance()) {
          sourceFilter_ =
              com.google.cloud.clouddms.v1.SourceTextFilter.newBuilder(
                      (com.google.cloud.clouddms.v1.SourceTextFilter) sourceFilter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sourceFilter_ = value;
        }
        onChanged();
      } else {
        if (sourceFilterCase_ == 100) {
          sourceTextFilterBuilder_.mergeFrom(value);
        } else {
          sourceTextFilterBuilder_.setMessage(value);
        }
      }
      sourceFilterCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter for text-based data types like varchar.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSourceTextFilter() {
      if (sourceTextFilterBuilder_ == null) {
        if (sourceFilterCase_ == 100) {
          sourceFilterCase_ = 0;
          sourceFilter_ = null;
          onChanged();
        }
      } else {
        if (sourceFilterCase_ == 100) {
          sourceFilterCase_ = 0;
          sourceFilter_ = null;
        }
        sourceTextFilterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter for text-based data types like varchar.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.SourceTextFilter.Builder getSourceTextFilterBuilder() {
      return getSourceTextFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter for text-based data types like varchar.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SourceTextFilterOrBuilder getSourceTextFilterOrBuilder() {
      if ((sourceFilterCase_ == 100) && (sourceTextFilterBuilder_ != null)) {
        return sourceTextFilterBuilder_.getMessageOrBuilder();
      } else {
        if (sourceFilterCase_ == 100) {
          return (com.google.cloud.clouddms.v1.SourceTextFilter) sourceFilter_;
        }
        return com.google.cloud.clouddms.v1.SourceTextFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter for text-based data types like varchar.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceTextFilter source_text_filter = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SourceTextFilter,
            com.google.cloud.clouddms.v1.SourceTextFilter.Builder,
            com.google.cloud.clouddms.v1.SourceTextFilterOrBuilder>
        getSourceTextFilterFieldBuilder() {
      if (sourceTextFilterBuilder_ == null) {
        if (!(sourceFilterCase_ == 100)) {
          sourceFilter_ = com.google.cloud.clouddms.v1.SourceTextFilter.getDefaultInstance();
        }
        sourceTextFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.SourceTextFilter,
                com.google.cloud.clouddms.v1.SourceTextFilter.Builder,
                com.google.cloud.clouddms.v1.SourceTextFilterOrBuilder>(
                (com.google.cloud.clouddms.v1.SourceTextFilter) sourceFilter_,
                getParentForChildren(),
                isClean());
        sourceFilter_ = null;
      }
      sourceFilterCase_ = 100;
      onChanged();
      return sourceTextFilterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SourceNumericFilter,
            com.google.cloud.clouddms.v1.SourceNumericFilter.Builder,
            com.google.cloud.clouddms.v1.SourceNumericFilterOrBuilder>
        sourceNumericFilterBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Filter for fixed point number data types such as
     * NUMERIC/NUMBER.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sourceNumericFilter field is set.
     */
    @java.lang.Override
    public boolean hasSourceNumericFilter() {
      return sourceFilterCase_ == 101;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter for fixed point number data types such as
     * NUMERIC/NUMBER.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sourceNumericFilter.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SourceNumericFilter getSourceNumericFilter() {
      if (sourceNumericFilterBuilder_ == null) {
        if (sourceFilterCase_ == 101) {
          return (com.google.cloud.clouddms.v1.SourceNumericFilter) sourceFilter_;
        }
        return com.google.cloud.clouddms.v1.SourceNumericFilter.getDefaultInstance();
      } else {
        if (sourceFilterCase_ == 101) {
          return sourceNumericFilterBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.SourceNumericFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter for fixed point number data types such as
     * NUMERIC/NUMBER.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSourceNumericFilter(com.google.cloud.clouddms.v1.SourceNumericFilter value) {
      if (sourceNumericFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceFilter_ = value;
        onChanged();
      } else {
        sourceNumericFilterBuilder_.setMessage(value);
      }
      sourceFilterCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter for fixed point number data types such as
     * NUMERIC/NUMBER.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSourceNumericFilter(
        com.google.cloud.clouddms.v1.SourceNumericFilter.Builder builderForValue) {
      if (sourceNumericFilterBuilder_ == null) {
        sourceFilter_ = builderForValue.build();
        onChanged();
      } else {
        sourceNumericFilterBuilder_.setMessage(builderForValue.build());
      }
      sourceFilterCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter for fixed point number data types such as
     * NUMERIC/NUMBER.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSourceNumericFilter(
        com.google.cloud.clouddms.v1.SourceNumericFilter value) {
      if (sourceNumericFilterBuilder_ == null) {
        if (sourceFilterCase_ == 101
            && sourceFilter_
                != com.google.cloud.clouddms.v1.SourceNumericFilter.getDefaultInstance()) {
          sourceFilter_ =
              com.google.cloud.clouddms.v1.SourceNumericFilter.newBuilder(
                      (com.google.cloud.clouddms.v1.SourceNumericFilter) sourceFilter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sourceFilter_ = value;
        }
        onChanged();
      } else {
        if (sourceFilterCase_ == 101) {
          sourceNumericFilterBuilder_.mergeFrom(value);
        } else {
          sourceNumericFilterBuilder_.setMessage(value);
        }
      }
      sourceFilterCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter for fixed point number data types such as
     * NUMERIC/NUMBER.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSourceNumericFilter() {
      if (sourceNumericFilterBuilder_ == null) {
        if (sourceFilterCase_ == 101) {
          sourceFilterCase_ = 0;
          sourceFilter_ = null;
          onChanged();
        }
      } else {
        if (sourceFilterCase_ == 101) {
          sourceFilterCase_ = 0;
          sourceFilter_ = null;
        }
        sourceNumericFilterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter for fixed point number data types such as
     * NUMERIC/NUMBER.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.SourceNumericFilter.Builder
        getSourceNumericFilterBuilder() {
      return getSourceNumericFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter for fixed point number data types such as
     * NUMERIC/NUMBER.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SourceNumericFilterOrBuilder
        getSourceNumericFilterOrBuilder() {
      if ((sourceFilterCase_ == 101) && (sourceNumericFilterBuilder_ != null)) {
        return sourceNumericFilterBuilder_.getMessageOrBuilder();
      } else {
        if (sourceFilterCase_ == 101) {
          return (com.google.cloud.clouddms.v1.SourceNumericFilter) sourceFilter_;
        }
        return com.google.cloud.clouddms.v1.SourceNumericFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter for fixed point number data types such as
     * NUMERIC/NUMBER.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SourceNumericFilter source_numeric_filter = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SourceNumericFilter,
            com.google.cloud.clouddms.v1.SourceNumericFilter.Builder,
            com.google.cloud.clouddms.v1.SourceNumericFilterOrBuilder>
        getSourceNumericFilterFieldBuilder() {
      if (sourceNumericFilterBuilder_ == null) {
        if (!(sourceFilterCase_ == 101)) {
          sourceFilter_ = com.google.cloud.clouddms.v1.SourceNumericFilter.getDefaultInstance();
        }
        sourceNumericFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.SourceNumericFilter,
                com.google.cloud.clouddms.v1.SourceNumericFilter.Builder,
                com.google.cloud.clouddms.v1.SourceNumericFilterOrBuilder>(
                (com.google.cloud.clouddms.v1.SourceNumericFilter) sourceFilter_,
                getParentForChildren(),
                isClean());
        sourceFilter_ = null;
      }
      sourceFilterCase_ = 101;
      onChanged();
      return sourceNumericFilterBuilder_;
    }

    private java.lang.Object newDataType_ = "";
    /**
     *
     *
     * <pre>
     * Required. New data type.
     * </pre>
     *
     * <code>string new_data_type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The newDataType.
     */
    public java.lang.String getNewDataType() {
      java.lang.Object ref = newDataType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        newDataType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. New data type.
     * </pre>
     *
     * <code>string new_data_type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for newDataType.
     */
    public com.google.protobuf.ByteString getNewDataTypeBytes() {
      java.lang.Object ref = newDataType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        newDataType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. New data type.
     * </pre>
     *
     * <code>string new_data_type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The newDataType to set.
     * @return This builder for chaining.
     */
    public Builder setNewDataType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      newDataType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. New data type.
     * </pre>
     *
     * <code>string new_data_type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNewDataType() {
      newDataType_ = getDefaultInstance().getNewDataType();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. New data type.
     * </pre>
     *
     * <code>string new_data_type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for newDataType to set.
     * @return This builder for chaining.
     */
    public Builder setNewDataTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      newDataType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private long overrideLength_;
    /**
     *
     *
     * <pre>
     * Optional. Column length - e.g. varchar (50) - if not specified and relevant
     * uses the source column length.
     * </pre>
     *
     * <code>int64 override_length = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The overrideLength.
     */
    @java.lang.Override
    public long getOverrideLength() {
      return overrideLength_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Column length - e.g. varchar (50) - if not specified and relevant
     * uses the source column length.
     * </pre>
     *
     * <code>int64 override_length = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The overrideLength to set.
     * @return This builder for chaining.
     */
    public Builder setOverrideLength(long value) {

      overrideLength_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Column length - e.g. varchar (50) - if not specified and relevant
     * uses the source column length.
     * </pre>
     *
     * <code>int64 override_length = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOverrideLength() {
      bitField0_ = (bitField0_ & ~0x00000010);
      overrideLength_ = 0L;
      onChanged();
      return this;
    }

    private int overrideScale_;
    /**
     *
     *
     * <pre>
     * Optional. Column scale - when relevant - if not specified and relevant
     * uses the source column scale.
     * </pre>
     *
     * <code>int32 override_scale = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The overrideScale.
     */
    @java.lang.Override
    public int getOverrideScale() {
      return overrideScale_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Column scale - when relevant - if not specified and relevant
     * uses the source column scale.
     * </pre>
     *
     * <code>int32 override_scale = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The overrideScale to set.
     * @return This builder for chaining.
     */
    public Builder setOverrideScale(int value) {

      overrideScale_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Column scale - when relevant - if not specified and relevant
     * uses the source column scale.
     * </pre>
     *
     * <code>int32 override_scale = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOverrideScale() {
      bitField0_ = (bitField0_ & ~0x00000020);
      overrideScale_ = 0;
      onChanged();
      return this;
    }

    private int overridePrecision_;
    /**
     *
     *
     * <pre>
     * Optional. Column precision - when relevant - if not specified and relevant
     * uses the source column precision.
     * </pre>
     *
     * <code>int32 override_precision = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The overridePrecision.
     */
    @java.lang.Override
    public int getOverridePrecision() {
      return overridePrecision_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Column precision - when relevant - if not specified and relevant
     * uses the source column precision.
     * </pre>
     *
     * <code>int32 override_precision = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The overridePrecision to set.
     * @return This builder for chaining.
     */
    public Builder setOverridePrecision(int value) {

      overridePrecision_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Column precision - when relevant - if not specified and relevant
     * uses the source column precision.
     * </pre>
     *
     * <code>int32 override_precision = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOverridePrecision() {
      bitField0_ = (bitField0_ & ~0x00000040);
      overridePrecision_ = 0;
      onChanged();
      return this;
    }

    private int overrideFractionalSecondsPrecision_;
    /**
     *
     *
     * <pre>
     * Optional. Column fractional seconds precision - used only for timestamp
     * based datatypes - if not specified and relevant uses the source column
     * fractional seconds precision.
     * </pre>
     *
     * <code>
     * int32 override_fractional_seconds_precision = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The overrideFractionalSecondsPrecision.
     */
    @java.lang.Override
    public int getOverrideFractionalSecondsPrecision() {
      return overrideFractionalSecondsPrecision_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Column fractional seconds precision - used only for timestamp
     * based datatypes - if not specified and relevant uses the source column
     * fractional seconds precision.
     * </pre>
     *
     * <code>
     * int32 override_fractional_seconds_precision = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The overrideFractionalSecondsPrecision to set.
     * @return This builder for chaining.
     */
    public Builder setOverrideFractionalSecondsPrecision(int value) {

      overrideFractionalSecondsPrecision_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Column fractional seconds precision - used only for timestamp
     * based datatypes - if not specified and relevant uses the source column
     * fractional seconds precision.
     * </pre>
     *
     * <code>
     * int32 override_fractional_seconds_precision = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOverrideFractionalSecondsPrecision() {
      bitField0_ = (bitField0_ & ~0x00000080);
      overrideFractionalSecondsPrecision_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct customFeatures_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        customFeaturesBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the customFeatures field is set.
     */
    public boolean hasCustomFeatures() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The customFeatures.
     */
    public com.google.protobuf.Struct getCustomFeatures() {
      if (customFeaturesBuilder_ == null) {
        return customFeatures_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : customFeatures_;
      } else {
        return customFeaturesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCustomFeatures(com.google.protobuf.Struct value) {
      if (customFeaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        customFeatures_ = value;
      } else {
        customFeaturesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCustomFeatures(com.google.protobuf.Struct.Builder builderForValue) {
      if (customFeaturesBuilder_ == null) {
        customFeatures_ = builderForValue.build();
      } else {
        customFeaturesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCustomFeatures(com.google.protobuf.Struct value) {
      if (customFeaturesBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && customFeatures_ != null
            && customFeatures_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getCustomFeaturesBuilder().mergeFrom(value);
        } else {
          customFeatures_ = value;
        }
      } else {
        customFeaturesBuilder_.mergeFrom(value);
      }
      if (customFeatures_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCustomFeatures() {
      bitField0_ = (bitField0_ & ~0x00000100);
      customFeatures_ = null;
      if (customFeaturesBuilder_ != null) {
        customFeaturesBuilder_.dispose();
        customFeaturesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Struct.Builder getCustomFeaturesBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getCustomFeaturesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.StructOrBuilder getCustomFeaturesOrBuilder() {
      if (customFeaturesBuilder_ != null) {
        return customFeaturesBuilder_.getMessageOrBuilder();
      } else {
        return customFeatures_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : customFeatures_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getCustomFeaturesFieldBuilder() {
      if (customFeaturesBuilder_ == null) {
        customFeaturesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getCustomFeatures(), getParentForChildren(), isClean());
        customFeatures_ = null;
      }
      return customFeaturesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.MultiColumnDatatypeChange)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.MultiColumnDatatypeChange)
  private static final com.google.cloud.clouddms.v1.MultiColumnDatatypeChange DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.MultiColumnDatatypeChange();
  }

  public static com.google.cloud.clouddms.v1.MultiColumnDatatypeChange getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MultiColumnDatatypeChange> PARSER =
      new com.google.protobuf.AbstractParser<MultiColumnDatatypeChange>() {
        @java.lang.Override
        public MultiColumnDatatypeChange parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MultiColumnDatatypeChange> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MultiColumnDatatypeChange> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.MultiColumnDatatypeChange getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
