/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/clouddms_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Specifies connection parameters required specifically for MySQL databases.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.MySqlConnectionProfile}
 */
public final class MySqlConnectionProfile extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.MySqlConnectionProfile)
    MySqlConnectionProfileOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MySqlConnectionProfile.newBuilder() to construct.
  private MySqlConnectionProfile(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MySqlConnectionProfile() {
    host_ = "";
    username_ = "";
    password_ = "";
    cloudSqlId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MySqlConnectionProfile();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
        .internal_static_google_cloud_clouddms_v1_MySqlConnectionProfile_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
        .internal_static_google_cloud_clouddms_v1_MySqlConnectionProfile_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.MySqlConnectionProfile.class,
            com.google.cloud.clouddms.v1.MySqlConnectionProfile.Builder.class);
  }

  private int bitField0_;
  public static final int HOST_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object host_ = "";
  /**
   *
   *
   * <pre>
   * Required. The IP or hostname of the source MySQL database.
   * </pre>
   *
   * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The host.
   */
  @java.lang.Override
  public java.lang.String getHost() {
    java.lang.Object ref = host_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      host_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The IP or hostname of the source MySQL database.
   * </pre>
   *
   * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for host.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHostBytes() {
    java.lang.Object ref = host_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      host_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PORT_FIELD_NUMBER = 2;
  private int port_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The network port of the source MySQL database.
   * </pre>
   *
   * <code>int32 port = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The port.
   */
  @java.lang.Override
  public int getPort() {
    return port_;
  }

  public static final int USERNAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object username_ = "";
  /**
   *
   *
   * <pre>
   * Required. The username that Database Migration Service will use to connect
   * to the database. The value is encrypted when stored in Database Migration
   * Service.
   * </pre>
   *
   * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The username.
   */
  @java.lang.Override
  public java.lang.String getUsername() {
    java.lang.Object ref = username_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      username_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The username that Database Migration Service will use to connect
   * to the database. The value is encrypted when stored in Database Migration
   * Service.
   * </pre>
   *
   * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for username.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUsernameBytes() {
    java.lang.Object ref = username_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      username_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PASSWORD_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object password_ = "";
  /**
   *
   *
   * <pre>
   * Required. Input only. The password for the user that Database Migration
   * Service will be using to connect to the database. This field is not
   * returned on request, and the value is encrypted when stored in Database
   * Migration Service.
   * </pre>
   *
   * <code>
   * string password = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The password.
   */
  @java.lang.Override
  public java.lang.String getPassword() {
    java.lang.Object ref = password_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      password_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Input only. The password for the user that Database Migration
   * Service will be using to connect to the database. This field is not
   * returned on request, and the value is encrypted when stored in Database
   * Migration Service.
   * </pre>
   *
   * <code>
   * string password = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The bytes for password.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPasswordBytes() {
    java.lang.Object ref = password_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      password_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PASSWORD_SET_FIELD_NUMBER = 5;
  private boolean passwordSet_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Indicates If this connection profile password is stored.
   * </pre>
   *
   * <code>bool password_set = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The passwordSet.
   */
  @java.lang.Override
  public boolean getPasswordSet() {
    return passwordSet_;
  }

  public static final int SSL_FIELD_NUMBER = 6;
  private com.google.cloud.clouddms.v1.SslConfig ssl_;
  /**
   *
   *
   * <pre>
   * SSL configuration for the destination to connect to the source database.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SslConfig ssl = 6;</code>
   *
   * @return Whether the ssl field is set.
   */
  @java.lang.Override
  public boolean hasSsl() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * SSL configuration for the destination to connect to the source database.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SslConfig ssl = 6;</code>
   *
   * @return The ssl.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SslConfig getSsl() {
    return ssl_ == null ? com.google.cloud.clouddms.v1.SslConfig.getDefaultInstance() : ssl_;
  }
  /**
   *
   *
   * <pre>
   * SSL configuration for the destination to connect to the source database.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SslConfig ssl = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SslConfigOrBuilder getSslOrBuilder() {
    return ssl_ == null ? com.google.cloud.clouddms.v1.SslConfig.getDefaultInstance() : ssl_;
  }

  public static final int CLOUD_SQL_ID_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cloudSqlId_ = "";
  /**
   *
   *
   * <pre>
   * If the source is a Cloud SQL database, use this field to
   * provide the Cloud SQL instance ID of the source.
   * </pre>
   *
   * <code>string cloud_sql_id = 7;</code>
   *
   * @return The cloudSqlId.
   */
  @java.lang.Override
  public java.lang.String getCloudSqlId() {
    java.lang.Object ref = cloudSqlId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cloudSqlId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If the source is a Cloud SQL database, use this field to
   * provide the Cloud SQL instance ID of the source.
   * </pre>
   *
   * <code>string cloud_sql_id = 7;</code>
   *
   * @return The bytes for cloudSqlId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCloudSqlIdBytes() {
    java.lang.Object ref = cloudSqlId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cloudSqlId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(host_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, host_);
    }
    if (port_ != 0) {
      output.writeInt32(2, port_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, username_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, password_);
    }
    if (passwordSet_ != false) {
      output.writeBool(5, passwordSet_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getSsl());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cloudSqlId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, cloudSqlId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(host_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, host_);
    }
    if (port_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, port_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, username_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, password_);
    }
    if (passwordSet_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, passwordSet_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getSsl());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cloudSqlId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, cloudSqlId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.MySqlConnectionProfile)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.MySqlConnectionProfile other =
        (com.google.cloud.clouddms.v1.MySqlConnectionProfile) obj;

    if (!getHost().equals(other.getHost())) return false;
    if (getPort() != other.getPort()) return false;
    if (!getUsername().equals(other.getUsername())) return false;
    if (!getPassword().equals(other.getPassword())) return false;
    if (getPasswordSet() != other.getPasswordSet()) return false;
    if (hasSsl() != other.hasSsl()) return false;
    if (hasSsl()) {
      if (!getSsl().equals(other.getSsl())) return false;
    }
    if (!getCloudSqlId().equals(other.getCloudSqlId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + HOST_FIELD_NUMBER;
    hash = (53 * hash) + getHost().hashCode();
    hash = (37 * hash) + PORT_FIELD_NUMBER;
    hash = (53 * hash) + getPort();
    hash = (37 * hash) + USERNAME_FIELD_NUMBER;
    hash = (53 * hash) + getUsername().hashCode();
    hash = (37 * hash) + PASSWORD_FIELD_NUMBER;
    hash = (53 * hash) + getPassword().hashCode();
    hash = (37 * hash) + PASSWORD_SET_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPasswordSet());
    if (hasSsl()) {
      hash = (37 * hash) + SSL_FIELD_NUMBER;
      hash = (53 * hash) + getSsl().hashCode();
    }
    hash = (37 * hash) + CLOUD_SQL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getCloudSqlId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.MySqlConnectionProfile parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.MySqlConnectionProfile parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MySqlConnectionProfile parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.MySqlConnectionProfile parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MySqlConnectionProfile parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.MySqlConnectionProfile parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MySqlConnectionProfile parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.MySqlConnectionProfile parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MySqlConnectionProfile parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.MySqlConnectionProfile parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.MySqlConnectionProfile parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.MySqlConnectionProfile parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.MySqlConnectionProfile prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies connection parameters required specifically for MySQL databases.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.MySqlConnectionProfile}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.MySqlConnectionProfile)
      com.google.cloud.clouddms.v1.MySqlConnectionProfileOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_MySqlConnectionProfile_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_MySqlConnectionProfile_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.MySqlConnectionProfile.class,
              com.google.cloud.clouddms.v1.MySqlConnectionProfile.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.MySqlConnectionProfile.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSslFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      host_ = "";
      port_ = 0;
      username_ = "";
      password_ = "";
      passwordSet_ = false;
      ssl_ = null;
      if (sslBuilder_ != null) {
        sslBuilder_.dispose();
        sslBuilder_ = null;
      }
      cloudSqlId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_MySqlConnectionProfile_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MySqlConnectionProfile getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.MySqlConnectionProfile.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MySqlConnectionProfile build() {
      com.google.cloud.clouddms.v1.MySqlConnectionProfile result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.MySqlConnectionProfile buildPartial() {
      com.google.cloud.clouddms.v1.MySqlConnectionProfile result =
          new com.google.cloud.clouddms.v1.MySqlConnectionProfile(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.MySqlConnectionProfile result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.host_ = host_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.port_ = port_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.username_ = username_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.password_ = password_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.passwordSet_ = passwordSet_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.ssl_ = sslBuilder_ == null ? ssl_ : sslBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.cloudSqlId_ = cloudSqlId_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.MySqlConnectionProfile) {
        return mergeFrom((com.google.cloud.clouddms.v1.MySqlConnectionProfile) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.MySqlConnectionProfile other) {
      if (other == com.google.cloud.clouddms.v1.MySqlConnectionProfile.getDefaultInstance())
        return this;
      if (!other.getHost().isEmpty()) {
        host_ = other.host_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getPort() != 0) {
        setPort(other.getPort());
      }
      if (!other.getUsername().isEmpty()) {
        username_ = other.username_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getPassword().isEmpty()) {
        password_ = other.password_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getPasswordSet() != false) {
        setPasswordSet(other.getPasswordSet());
      }
      if (other.hasSsl()) {
        mergeSsl(other.getSsl());
      }
      if (!other.getCloudSqlId().isEmpty()) {
        cloudSqlId_ = other.cloudSqlId_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                host_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                port_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                username_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                password_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                passwordSet_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getSslFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                cloudSqlId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object host_ = "";
    /**
     *
     *
     * <pre>
     * Required. The IP or hostname of the source MySQL database.
     * </pre>
     *
     * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The host.
     */
    public java.lang.String getHost() {
      java.lang.Object ref = host_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        host_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The IP or hostname of the source MySQL database.
     * </pre>
     *
     * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for host.
     */
    public com.google.protobuf.ByteString getHostBytes() {
      java.lang.Object ref = host_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        host_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The IP or hostname of the source MySQL database.
     * </pre>
     *
     * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The host to set.
     * @return This builder for chaining.
     */
    public Builder setHost(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      host_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The IP or hostname of the source MySQL database.
     * </pre>
     *
     * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHost() {
      host_ = getDefaultInstance().getHost();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The IP or hostname of the source MySQL database.
     * </pre>
     *
     * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for host to set.
     * @return This builder for chaining.
     */
    public Builder setHostBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      host_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int port_;
    /**
     *
     *
     * <pre>
     * Required. The network port of the source MySQL database.
     * </pre>
     *
     * <code>int32 port = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The port.
     */
    @java.lang.Override
    public int getPort() {
      return port_;
    }
    /**
     *
     *
     * <pre>
     * Required. The network port of the source MySQL database.
     * </pre>
     *
     * <code>int32 port = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The port to set.
     * @return This builder for chaining.
     */
    public Builder setPort(int value) {

      port_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The network port of the source MySQL database.
     * </pre>
     *
     * <code>int32 port = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPort() {
      bitField0_ = (bitField0_ & ~0x00000002);
      port_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object username_ = "";
    /**
     *
     *
     * <pre>
     * Required. The username that Database Migration Service will use to connect
     * to the database. The value is encrypted when stored in Database Migration
     * Service.
     * </pre>
     *
     * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The username.
     */
    public java.lang.String getUsername() {
      java.lang.Object ref = username_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        username_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The username that Database Migration Service will use to connect
     * to the database. The value is encrypted when stored in Database Migration
     * Service.
     * </pre>
     *
     * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for username.
     */
    public com.google.protobuf.ByteString getUsernameBytes() {
      java.lang.Object ref = username_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        username_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The username that Database Migration Service will use to connect
     * to the database. The value is encrypted when stored in Database Migration
     * Service.
     * </pre>
     *
     * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The username to set.
     * @return This builder for chaining.
     */
    public Builder setUsername(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      username_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The username that Database Migration Service will use to connect
     * to the database. The value is encrypted when stored in Database Migration
     * Service.
     * </pre>
     *
     * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUsername() {
      username_ = getDefaultInstance().getUsername();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The username that Database Migration Service will use to connect
     * to the database. The value is encrypted when stored in Database Migration
     * Service.
     * </pre>
     *
     * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for username to set.
     * @return This builder for chaining.
     */
    public Builder setUsernameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      username_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object password_ = "";
    /**
     *
     *
     * <pre>
     * Required. Input only. The password for the user that Database Migration
     * Service will be using to connect to the database. This field is not
     * returned on request, and the value is encrypted when stored in Database
     * Migration Service.
     * </pre>
     *
     * <code>
     * string password = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The password.
     */
    public java.lang.String getPassword() {
      java.lang.Object ref = password_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        password_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. The password for the user that Database Migration
     * Service will be using to connect to the database. This field is not
     * returned on request, and the value is encrypted when stored in Database
     * Migration Service.
     * </pre>
     *
     * <code>
     * string password = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The bytes for password.
     */
    public com.google.protobuf.ByteString getPasswordBytes() {
      java.lang.Object ref = password_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        password_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. The password for the user that Database Migration
     * Service will be using to connect to the database. This field is not
     * returned on request, and the value is encrypted when stored in Database
     * Migration Service.
     * </pre>
     *
     * <code>
     * string password = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The password to set.
     * @return This builder for chaining.
     */
    public Builder setPassword(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      password_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. The password for the user that Database Migration
     * Service will be using to connect to the database. This field is not
     * returned on request, and the value is encrypted when stored in Database
     * Migration Service.
     * </pre>
     *
     * <code>
     * string password = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPassword() {
      password_ = getDefaultInstance().getPassword();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. The password for the user that Database Migration
     * Service will be using to connect to the database. This field is not
     * returned on request, and the value is encrypted when stored in Database
     * Migration Service.
     * </pre>
     *
     * <code>
     * string password = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The bytes for password to set.
     * @return This builder for chaining.
     */
    public Builder setPasswordBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      password_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean passwordSet_;
    /**
     *
     *
     * <pre>
     * Output only. Indicates If this connection profile password is stored.
     * </pre>
     *
     * <code>bool password_set = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The passwordSet.
     */
    @java.lang.Override
    public boolean getPasswordSet() {
      return passwordSet_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates If this connection profile password is stored.
     * </pre>
     *
     * <code>bool password_set = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The passwordSet to set.
     * @return This builder for chaining.
     */
    public Builder setPasswordSet(boolean value) {

      passwordSet_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates If this connection profile password is stored.
     * </pre>
     *
     * <code>bool password_set = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPasswordSet() {
      bitField0_ = (bitField0_ & ~0x00000010);
      passwordSet_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.clouddms.v1.SslConfig ssl_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SslConfig,
            com.google.cloud.clouddms.v1.SslConfig.Builder,
            com.google.cloud.clouddms.v1.SslConfigOrBuilder>
        sslBuilder_;
    /**
     *
     *
     * <pre>
     * SSL configuration for the destination to connect to the source database.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SslConfig ssl = 6;</code>
     *
     * @return Whether the ssl field is set.
     */
    public boolean hasSsl() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * SSL configuration for the destination to connect to the source database.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SslConfig ssl = 6;</code>
     *
     * @return The ssl.
     */
    public com.google.cloud.clouddms.v1.SslConfig getSsl() {
      if (sslBuilder_ == null) {
        return ssl_ == null ? com.google.cloud.clouddms.v1.SslConfig.getDefaultInstance() : ssl_;
      } else {
        return sslBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * SSL configuration for the destination to connect to the source database.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SslConfig ssl = 6;</code>
     */
    public Builder setSsl(com.google.cloud.clouddms.v1.SslConfig value) {
      if (sslBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ssl_ = value;
      } else {
        sslBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * SSL configuration for the destination to connect to the source database.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SslConfig ssl = 6;</code>
     */
    public Builder setSsl(com.google.cloud.clouddms.v1.SslConfig.Builder builderForValue) {
      if (sslBuilder_ == null) {
        ssl_ = builderForValue.build();
      } else {
        sslBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * SSL configuration for the destination to connect to the source database.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SslConfig ssl = 6;</code>
     */
    public Builder mergeSsl(com.google.cloud.clouddms.v1.SslConfig value) {
      if (sslBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && ssl_ != null
            && ssl_ != com.google.cloud.clouddms.v1.SslConfig.getDefaultInstance()) {
          getSslBuilder().mergeFrom(value);
        } else {
          ssl_ = value;
        }
      } else {
        sslBuilder_.mergeFrom(value);
      }
      if (ssl_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * SSL configuration for the destination to connect to the source database.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SslConfig ssl = 6;</code>
     */
    public Builder clearSsl() {
      bitField0_ = (bitField0_ & ~0x00000020);
      ssl_ = null;
      if (sslBuilder_ != null) {
        sslBuilder_.dispose();
        sslBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * SSL configuration for the destination to connect to the source database.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SslConfig ssl = 6;</code>
     */
    public com.google.cloud.clouddms.v1.SslConfig.Builder getSslBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getSslFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * SSL configuration for the destination to connect to the source database.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SslConfig ssl = 6;</code>
     */
    public com.google.cloud.clouddms.v1.SslConfigOrBuilder getSslOrBuilder() {
      if (sslBuilder_ != null) {
        return sslBuilder_.getMessageOrBuilder();
      } else {
        return ssl_ == null ? com.google.cloud.clouddms.v1.SslConfig.getDefaultInstance() : ssl_;
      }
    }
    /**
     *
     *
     * <pre>
     * SSL configuration for the destination to connect to the source database.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SslConfig ssl = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SslConfig,
            com.google.cloud.clouddms.v1.SslConfig.Builder,
            com.google.cloud.clouddms.v1.SslConfigOrBuilder>
        getSslFieldBuilder() {
      if (sslBuilder_ == null) {
        sslBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.SslConfig,
                com.google.cloud.clouddms.v1.SslConfig.Builder,
                com.google.cloud.clouddms.v1.SslConfigOrBuilder>(
                getSsl(), getParentForChildren(), isClean());
        ssl_ = null;
      }
      return sslBuilder_;
    }

    private java.lang.Object cloudSqlId_ = "";
    /**
     *
     *
     * <pre>
     * If the source is a Cloud SQL database, use this field to
     * provide the Cloud SQL instance ID of the source.
     * </pre>
     *
     * <code>string cloud_sql_id = 7;</code>
     *
     * @return The cloudSqlId.
     */
    public java.lang.String getCloudSqlId() {
      java.lang.Object ref = cloudSqlId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cloudSqlId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If the source is a Cloud SQL database, use this field to
     * provide the Cloud SQL instance ID of the source.
     * </pre>
     *
     * <code>string cloud_sql_id = 7;</code>
     *
     * @return The bytes for cloudSqlId.
     */
    public com.google.protobuf.ByteString getCloudSqlIdBytes() {
      java.lang.Object ref = cloudSqlId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cloudSqlId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If the source is a Cloud SQL database, use this field to
     * provide the Cloud SQL instance ID of the source.
     * </pre>
     *
     * <code>string cloud_sql_id = 7;</code>
     *
     * @param value The cloudSqlId to set.
     * @return This builder for chaining.
     */
    public Builder setCloudSqlId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cloudSqlId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the source is a Cloud SQL database, use this field to
     * provide the Cloud SQL instance ID of the source.
     * </pre>
     *
     * <code>string cloud_sql_id = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCloudSqlId() {
      cloudSqlId_ = getDefaultInstance().getCloudSqlId();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the source is a Cloud SQL database, use this field to
     * provide the Cloud SQL instance ID of the source.
     * </pre>
     *
     * <code>string cloud_sql_id = 7;</code>
     *
     * @param value The bytes for cloudSqlId to set.
     * @return This builder for chaining.
     */
    public Builder setCloudSqlIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cloudSqlId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.MySqlConnectionProfile)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.MySqlConnectionProfile)
  private static final com.google.cloud.clouddms.v1.MySqlConnectionProfile DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.MySqlConnectionProfile();
  }

  public static com.google.cloud.clouddms.v1.MySqlConnectionProfile getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MySqlConnectionProfile> PARSER =
      new com.google.protobuf.AbstractParser<MySqlConnectionProfile>() {
        @java.lang.Override
        public MySqlConnectionProfile parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MySqlConnectionProfile> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MySqlConnectionProfile> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.MySqlConnectionProfile getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
