/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/clouddms_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Specifies connection parameters required specifically for Oracle
 * databases.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.OracleConnectionProfile}
 */
public final class OracleConnectionProfile extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.OracleConnectionProfile)
    OracleConnectionProfileOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OracleConnectionProfile.newBuilder() to construct.
  private OracleConnectionProfile(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OracleConnectionProfile() {
    host_ = "";
    username_ = "";
    password_ = "";
    databaseService_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OracleConnectionProfile();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
        .internal_static_google_cloud_clouddms_v1_OracleConnectionProfile_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
        .internal_static_google_cloud_clouddms_v1_OracleConnectionProfile_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.OracleConnectionProfile.class,
            com.google.cloud.clouddms.v1.OracleConnectionProfile.Builder.class);
  }

  private int bitField0_;
  private int connectivityCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object connectivity_;

  public enum ConnectivityCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STATIC_SERVICE_IP_CONNECTIVITY(100),
    FORWARD_SSH_CONNECTIVITY(101),
    PRIVATE_CONNECTIVITY(102),
    CONNECTIVITY_NOT_SET(0);
    private final int value;

    private ConnectivityCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConnectivityCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConnectivityCase forNumber(int value) {
      switch (value) {
        case 100:
          return STATIC_SERVICE_IP_CONNECTIVITY;
        case 101:
          return FORWARD_SSH_CONNECTIVITY;
        case 102:
          return PRIVATE_CONNECTIVITY;
        case 0:
          return CONNECTIVITY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConnectivityCase getConnectivityCase() {
    return ConnectivityCase.forNumber(connectivityCase_);
  }

  public static final int HOST_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object host_ = "";
  /**
   *
   *
   * <pre>
   * Required. The IP or hostname of the source Oracle database.
   * </pre>
   *
   * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The host.
   */
  @java.lang.Override
  public java.lang.String getHost() {
    java.lang.Object ref = host_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      host_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The IP or hostname of the source Oracle database.
   * </pre>
   *
   * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for host.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHostBytes() {
    java.lang.Object ref = host_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      host_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PORT_FIELD_NUMBER = 2;
  private int port_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The network port of the source Oracle database.
   * </pre>
   *
   * <code>int32 port = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The port.
   */
  @java.lang.Override
  public int getPort() {
    return port_;
  }

  public static final int USERNAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object username_ = "";
  /**
   *
   *
   * <pre>
   * Required. The username that Database Migration Service will use to connect
   * to the database. The value is encrypted when stored in Database Migration
   * Service.
   * </pre>
   *
   * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The username.
   */
  @java.lang.Override
  public java.lang.String getUsername() {
    java.lang.Object ref = username_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      username_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The username that Database Migration Service will use to connect
   * to the database. The value is encrypted when stored in Database Migration
   * Service.
   * </pre>
   *
   * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for username.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUsernameBytes() {
    java.lang.Object ref = username_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      username_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PASSWORD_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object password_ = "";
  /**
   *
   *
   * <pre>
   * Required. Input only. The password for the user that Database Migration
   * Service will be using to connect to the database. This field is not
   * returned on request, and the value is encrypted when stored in Database
   * Migration Service.
   * </pre>
   *
   * <code>
   * string password = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The password.
   */
  @java.lang.Override
  public java.lang.String getPassword() {
    java.lang.Object ref = password_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      password_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Input only. The password for the user that Database Migration
   * Service will be using to connect to the database. This field is not
   * returned on request, and the value is encrypted when stored in Database
   * Migration Service.
   * </pre>
   *
   * <code>
   * string password = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The bytes for password.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPasswordBytes() {
    java.lang.Object ref = password_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      password_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PASSWORD_SET_FIELD_NUMBER = 5;
  private boolean passwordSet_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Indicates whether a new password is included in the request.
   * </pre>
   *
   * <code>bool password_set = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The passwordSet.
   */
  @java.lang.Override
  public boolean getPasswordSet() {
    return passwordSet_;
  }

  public static final int DATABASE_SERVICE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object databaseService_ = "";
  /**
   *
   *
   * <pre>
   * Required. Database service for the Oracle connection.
   * </pre>
   *
   * <code>string database_service = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The databaseService.
   */
  @java.lang.Override
  public java.lang.String getDatabaseService() {
    java.lang.Object ref = databaseService_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      databaseService_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Database service for the Oracle connection.
   * </pre>
   *
   * <code>string database_service = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for databaseService.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseServiceBytes() {
    java.lang.Object ref = databaseService_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      databaseService_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SSL_FIELD_NUMBER = 7;
  private com.google.cloud.clouddms.v1.SslConfig ssl_;
  /**
   *
   *
   * <pre>
   * SSL configuration for the connection to the source Oracle database.
   *
   *  * Only `SERVER_ONLY` configuration is supported for Oracle SSL.
   *  * SSL is supported for Oracle versions 12 and above.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SslConfig ssl = 7;</code>
   *
   * @return Whether the ssl field is set.
   */
  @java.lang.Override
  public boolean hasSsl() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * SSL configuration for the connection to the source Oracle database.
   *
   *  * Only `SERVER_ONLY` configuration is supported for Oracle SSL.
   *  * SSL is supported for Oracle versions 12 and above.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SslConfig ssl = 7;</code>
   *
   * @return The ssl.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SslConfig getSsl() {
    return ssl_ == null ? com.google.cloud.clouddms.v1.SslConfig.getDefaultInstance() : ssl_;
  }
  /**
   *
   *
   * <pre>
   * SSL configuration for the connection to the source Oracle database.
   *
   *  * Only `SERVER_ONLY` configuration is supported for Oracle SSL.
   *  * SSL is supported for Oracle versions 12 and above.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SslConfig ssl = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SslConfigOrBuilder getSslOrBuilder() {
    return ssl_ == null ? com.google.cloud.clouddms.v1.SslConfig.getDefaultInstance() : ssl_;
  }

  public static final int STATIC_SERVICE_IP_CONNECTIVITY_FIELD_NUMBER = 100;
  /**
   *
   *
   * <pre>
   * Static Service IP connectivity.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.StaticServiceIpConnectivity static_service_ip_connectivity = 100;
   * </code>
   *
   * @return Whether the staticServiceIpConnectivity field is set.
   */
  @java.lang.Override
  public boolean hasStaticServiceIpConnectivity() {
    return connectivityCase_ == 100;
  }
  /**
   *
   *
   * <pre>
   * Static Service IP connectivity.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.StaticServiceIpConnectivity static_service_ip_connectivity = 100;
   * </code>
   *
   * @return The staticServiceIpConnectivity.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.StaticServiceIpConnectivity getStaticServiceIpConnectivity() {
    if (connectivityCase_ == 100) {
      return (com.google.cloud.clouddms.v1.StaticServiceIpConnectivity) connectivity_;
    }
    return com.google.cloud.clouddms.v1.StaticServiceIpConnectivity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Static Service IP connectivity.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.StaticServiceIpConnectivity static_service_ip_connectivity = 100;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.StaticServiceIpConnectivityOrBuilder
      getStaticServiceIpConnectivityOrBuilder() {
    if (connectivityCase_ == 100) {
      return (com.google.cloud.clouddms.v1.StaticServiceIpConnectivity) connectivity_;
    }
    return com.google.cloud.clouddms.v1.StaticServiceIpConnectivity.getDefaultInstance();
  }

  public static final int FORWARD_SSH_CONNECTIVITY_FIELD_NUMBER = 101;
  /**
   *
   *
   * <pre>
   * Forward SSH tunnel connectivity.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 101;
   * </code>
   *
   * @return Whether the forwardSshConnectivity field is set.
   */
  @java.lang.Override
  public boolean hasForwardSshConnectivity() {
    return connectivityCase_ == 101;
  }
  /**
   *
   *
   * <pre>
   * Forward SSH tunnel connectivity.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 101;
   * </code>
   *
   * @return The forwardSshConnectivity.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity getForwardSshConnectivity() {
    if (connectivityCase_ == 101) {
      return (com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity) connectivity_;
    }
    return com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Forward SSH tunnel connectivity.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 101;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivityOrBuilder
      getForwardSshConnectivityOrBuilder() {
    if (connectivityCase_ == 101) {
      return (com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity) connectivity_;
    }
    return com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity.getDefaultInstance();
  }

  public static final int PRIVATE_CONNECTIVITY_FIELD_NUMBER = 102;
  /**
   *
   *
   * <pre>
   * Private connectivity.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.PrivateConnectivity private_connectivity = 102;</code>
   *
   * @return Whether the privateConnectivity field is set.
   */
  @java.lang.Override
  public boolean hasPrivateConnectivity() {
    return connectivityCase_ == 102;
  }
  /**
   *
   *
   * <pre>
   * Private connectivity.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.PrivateConnectivity private_connectivity = 102;</code>
   *
   * @return The privateConnectivity.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.PrivateConnectivity getPrivateConnectivity() {
    if (connectivityCase_ == 102) {
      return (com.google.cloud.clouddms.v1.PrivateConnectivity) connectivity_;
    }
    return com.google.cloud.clouddms.v1.PrivateConnectivity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Private connectivity.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.PrivateConnectivity private_connectivity = 102;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.PrivateConnectivityOrBuilder
      getPrivateConnectivityOrBuilder() {
    if (connectivityCase_ == 102) {
      return (com.google.cloud.clouddms.v1.PrivateConnectivity) connectivity_;
    }
    return com.google.cloud.clouddms.v1.PrivateConnectivity.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(host_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, host_);
    }
    if (port_ != 0) {
      output.writeInt32(2, port_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, username_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, password_);
    }
    if (passwordSet_ != false) {
      output.writeBool(5, passwordSet_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(databaseService_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, databaseService_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getSsl());
    }
    if (connectivityCase_ == 100) {
      output.writeMessage(
          100, (com.google.cloud.clouddms.v1.StaticServiceIpConnectivity) connectivity_);
    }
    if (connectivityCase_ == 101) {
      output.writeMessage(
          101, (com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity) connectivity_);
    }
    if (connectivityCase_ == 102) {
      output.writeMessage(102, (com.google.cloud.clouddms.v1.PrivateConnectivity) connectivity_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(host_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, host_);
    }
    if (port_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, port_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, username_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, password_);
    }
    if (passwordSet_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, passwordSet_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(databaseService_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, databaseService_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getSsl());
    }
    if (connectivityCase_ == 100) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              100, (com.google.cloud.clouddms.v1.StaticServiceIpConnectivity) connectivity_);
    }
    if (connectivityCase_ == 101) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              101, (com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity) connectivity_);
    }
    if (connectivityCase_ == 102) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              102, (com.google.cloud.clouddms.v1.PrivateConnectivity) connectivity_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.OracleConnectionProfile)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.OracleConnectionProfile other =
        (com.google.cloud.clouddms.v1.OracleConnectionProfile) obj;

    if (!getHost().equals(other.getHost())) return false;
    if (getPort() != other.getPort()) return false;
    if (!getUsername().equals(other.getUsername())) return false;
    if (!getPassword().equals(other.getPassword())) return false;
    if (getPasswordSet() != other.getPasswordSet()) return false;
    if (!getDatabaseService().equals(other.getDatabaseService())) return false;
    if (hasSsl() != other.hasSsl()) return false;
    if (hasSsl()) {
      if (!getSsl().equals(other.getSsl())) return false;
    }
    if (!getConnectivityCase().equals(other.getConnectivityCase())) return false;
    switch (connectivityCase_) {
      case 100:
        if (!getStaticServiceIpConnectivity().equals(other.getStaticServiceIpConnectivity()))
          return false;
        break;
      case 101:
        if (!getForwardSshConnectivity().equals(other.getForwardSshConnectivity())) return false;
        break;
      case 102:
        if (!getPrivateConnectivity().equals(other.getPrivateConnectivity())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + HOST_FIELD_NUMBER;
    hash = (53 * hash) + getHost().hashCode();
    hash = (37 * hash) + PORT_FIELD_NUMBER;
    hash = (53 * hash) + getPort();
    hash = (37 * hash) + USERNAME_FIELD_NUMBER;
    hash = (53 * hash) + getUsername().hashCode();
    hash = (37 * hash) + PASSWORD_FIELD_NUMBER;
    hash = (53 * hash) + getPassword().hashCode();
    hash = (37 * hash) + PASSWORD_SET_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPasswordSet());
    hash = (37 * hash) + DATABASE_SERVICE_FIELD_NUMBER;
    hash = (53 * hash) + getDatabaseService().hashCode();
    if (hasSsl()) {
      hash = (37 * hash) + SSL_FIELD_NUMBER;
      hash = (53 * hash) + getSsl().hashCode();
    }
    switch (connectivityCase_) {
      case 100:
        hash = (37 * hash) + STATIC_SERVICE_IP_CONNECTIVITY_FIELD_NUMBER;
        hash = (53 * hash) + getStaticServiceIpConnectivity().hashCode();
        break;
      case 101:
        hash = (37 * hash) + FORWARD_SSH_CONNECTIVITY_FIELD_NUMBER;
        hash = (53 * hash) + getForwardSshConnectivity().hashCode();
        break;
      case 102:
        hash = (37 * hash) + PRIVATE_CONNECTIVITY_FIELD_NUMBER;
        hash = (53 * hash) + getPrivateConnectivity().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.OracleConnectionProfile parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.OracleConnectionProfile parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.OracleConnectionProfile parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.OracleConnectionProfile parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.OracleConnectionProfile parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.OracleConnectionProfile parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.OracleConnectionProfile parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.OracleConnectionProfile parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.OracleConnectionProfile parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.OracleConnectionProfile parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.OracleConnectionProfile parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.OracleConnectionProfile parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.OracleConnectionProfile prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies connection parameters required specifically for Oracle
   * databases.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.OracleConnectionProfile}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.OracleConnectionProfile)
      com.google.cloud.clouddms.v1.OracleConnectionProfileOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_OracleConnectionProfile_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_OracleConnectionProfile_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.OracleConnectionProfile.class,
              com.google.cloud.clouddms.v1.OracleConnectionProfile.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.OracleConnectionProfile.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSslFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      host_ = "";
      port_ = 0;
      username_ = "";
      password_ = "";
      passwordSet_ = false;
      databaseService_ = "";
      ssl_ = null;
      if (sslBuilder_ != null) {
        sslBuilder_.dispose();
        sslBuilder_ = null;
      }
      if (staticServiceIpConnectivityBuilder_ != null) {
        staticServiceIpConnectivityBuilder_.clear();
      }
      if (forwardSshConnectivityBuilder_ != null) {
        forwardSshConnectivityBuilder_.clear();
      }
      if (privateConnectivityBuilder_ != null) {
        privateConnectivityBuilder_.clear();
      }
      connectivityCase_ = 0;
      connectivity_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_OracleConnectionProfile_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.OracleConnectionProfile getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.OracleConnectionProfile.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.OracleConnectionProfile build() {
      com.google.cloud.clouddms.v1.OracleConnectionProfile result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.OracleConnectionProfile buildPartial() {
      com.google.cloud.clouddms.v1.OracleConnectionProfile result =
          new com.google.cloud.clouddms.v1.OracleConnectionProfile(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.OracleConnectionProfile result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.host_ = host_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.port_ = port_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.username_ = username_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.password_ = password_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.passwordSet_ = passwordSet_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.databaseService_ = databaseService_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.ssl_ = sslBuilder_ == null ? ssl_ : sslBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.clouddms.v1.OracleConnectionProfile result) {
      result.connectivityCase_ = connectivityCase_;
      result.connectivity_ = this.connectivity_;
      if (connectivityCase_ == 100 && staticServiceIpConnectivityBuilder_ != null) {
        result.connectivity_ = staticServiceIpConnectivityBuilder_.build();
      }
      if (connectivityCase_ == 101 && forwardSshConnectivityBuilder_ != null) {
        result.connectivity_ = forwardSshConnectivityBuilder_.build();
      }
      if (connectivityCase_ == 102 && privateConnectivityBuilder_ != null) {
        result.connectivity_ = privateConnectivityBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.OracleConnectionProfile) {
        return mergeFrom((com.google.cloud.clouddms.v1.OracleConnectionProfile) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.OracleConnectionProfile other) {
      if (other == com.google.cloud.clouddms.v1.OracleConnectionProfile.getDefaultInstance())
        return this;
      if (!other.getHost().isEmpty()) {
        host_ = other.host_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getPort() != 0) {
        setPort(other.getPort());
      }
      if (!other.getUsername().isEmpty()) {
        username_ = other.username_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getPassword().isEmpty()) {
        password_ = other.password_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getPasswordSet() != false) {
        setPasswordSet(other.getPasswordSet());
      }
      if (!other.getDatabaseService().isEmpty()) {
        databaseService_ = other.databaseService_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasSsl()) {
        mergeSsl(other.getSsl());
      }
      switch (other.getConnectivityCase()) {
        case STATIC_SERVICE_IP_CONNECTIVITY:
          {
            mergeStaticServiceIpConnectivity(other.getStaticServiceIpConnectivity());
            break;
          }
        case FORWARD_SSH_CONNECTIVITY:
          {
            mergeForwardSshConnectivity(other.getForwardSshConnectivity());
            break;
          }
        case PRIVATE_CONNECTIVITY:
          {
            mergePrivateConnectivity(other.getPrivateConnectivity());
            break;
          }
        case CONNECTIVITY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                host_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                port_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                username_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                password_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                passwordSet_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                databaseService_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getSslFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 802:
              {
                input.readMessage(
                    getStaticServiceIpConnectivityFieldBuilder().getBuilder(), extensionRegistry);
                connectivityCase_ = 100;
                break;
              } // case 802
            case 810:
              {
                input.readMessage(
                    getForwardSshConnectivityFieldBuilder().getBuilder(), extensionRegistry);
                connectivityCase_ = 101;
                break;
              } // case 810
            case 818:
              {
                input.readMessage(
                    getPrivateConnectivityFieldBuilder().getBuilder(), extensionRegistry);
                connectivityCase_ = 102;
                break;
              } // case 818
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int connectivityCase_ = 0;
    private java.lang.Object connectivity_;

    public ConnectivityCase getConnectivityCase() {
      return ConnectivityCase.forNumber(connectivityCase_);
    }

    public Builder clearConnectivity() {
      connectivityCase_ = 0;
      connectivity_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object host_ = "";
    /**
     *
     *
     * <pre>
     * Required. The IP or hostname of the source Oracle database.
     * </pre>
     *
     * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The host.
     */
    public java.lang.String getHost() {
      java.lang.Object ref = host_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        host_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The IP or hostname of the source Oracle database.
     * </pre>
     *
     * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for host.
     */
    public com.google.protobuf.ByteString getHostBytes() {
      java.lang.Object ref = host_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        host_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The IP or hostname of the source Oracle database.
     * </pre>
     *
     * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The host to set.
     * @return This builder for chaining.
     */
    public Builder setHost(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      host_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The IP or hostname of the source Oracle database.
     * </pre>
     *
     * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHost() {
      host_ = getDefaultInstance().getHost();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The IP or hostname of the source Oracle database.
     * </pre>
     *
     * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for host to set.
     * @return This builder for chaining.
     */
    public Builder setHostBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      host_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int port_;
    /**
     *
     *
     * <pre>
     * Required. The network port of the source Oracle database.
     * </pre>
     *
     * <code>int32 port = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The port.
     */
    @java.lang.Override
    public int getPort() {
      return port_;
    }
    /**
     *
     *
     * <pre>
     * Required. The network port of the source Oracle database.
     * </pre>
     *
     * <code>int32 port = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The port to set.
     * @return This builder for chaining.
     */
    public Builder setPort(int value) {

      port_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The network port of the source Oracle database.
     * </pre>
     *
     * <code>int32 port = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPort() {
      bitField0_ = (bitField0_ & ~0x00000002);
      port_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object username_ = "";
    /**
     *
     *
     * <pre>
     * Required. The username that Database Migration Service will use to connect
     * to the database. The value is encrypted when stored in Database Migration
     * Service.
     * </pre>
     *
     * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The username.
     */
    public java.lang.String getUsername() {
      java.lang.Object ref = username_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        username_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The username that Database Migration Service will use to connect
     * to the database. The value is encrypted when stored in Database Migration
     * Service.
     * </pre>
     *
     * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for username.
     */
    public com.google.protobuf.ByteString getUsernameBytes() {
      java.lang.Object ref = username_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        username_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The username that Database Migration Service will use to connect
     * to the database. The value is encrypted when stored in Database Migration
     * Service.
     * </pre>
     *
     * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The username to set.
     * @return This builder for chaining.
     */
    public Builder setUsername(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      username_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The username that Database Migration Service will use to connect
     * to the database. The value is encrypted when stored in Database Migration
     * Service.
     * </pre>
     *
     * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUsername() {
      username_ = getDefaultInstance().getUsername();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The username that Database Migration Service will use to connect
     * to the database. The value is encrypted when stored in Database Migration
     * Service.
     * </pre>
     *
     * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for username to set.
     * @return This builder for chaining.
     */
    public Builder setUsernameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      username_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object password_ = "";
    /**
     *
     *
     * <pre>
     * Required. Input only. The password for the user that Database Migration
     * Service will be using to connect to the database. This field is not
     * returned on request, and the value is encrypted when stored in Database
     * Migration Service.
     * </pre>
     *
     * <code>
     * string password = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The password.
     */
    public java.lang.String getPassword() {
      java.lang.Object ref = password_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        password_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. The password for the user that Database Migration
     * Service will be using to connect to the database. This field is not
     * returned on request, and the value is encrypted when stored in Database
     * Migration Service.
     * </pre>
     *
     * <code>
     * string password = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The bytes for password.
     */
    public com.google.protobuf.ByteString getPasswordBytes() {
      java.lang.Object ref = password_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        password_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. The password for the user that Database Migration
     * Service will be using to connect to the database. This field is not
     * returned on request, and the value is encrypted when stored in Database
     * Migration Service.
     * </pre>
     *
     * <code>
     * string password = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The password to set.
     * @return This builder for chaining.
     */
    public Builder setPassword(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      password_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. The password for the user that Database Migration
     * Service will be using to connect to the database. This field is not
     * returned on request, and the value is encrypted when stored in Database
     * Migration Service.
     * </pre>
     *
     * <code>
     * string password = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPassword() {
      password_ = getDefaultInstance().getPassword();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. The password for the user that Database Migration
     * Service will be using to connect to the database. This field is not
     * returned on request, and the value is encrypted when stored in Database
     * Migration Service.
     * </pre>
     *
     * <code>
     * string password = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The bytes for password to set.
     * @return This builder for chaining.
     */
    public Builder setPasswordBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      password_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean passwordSet_;
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether a new password is included in the request.
     * </pre>
     *
     * <code>bool password_set = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The passwordSet.
     */
    @java.lang.Override
    public boolean getPasswordSet() {
      return passwordSet_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether a new password is included in the request.
     * </pre>
     *
     * <code>bool password_set = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The passwordSet to set.
     * @return This builder for chaining.
     */
    public Builder setPasswordSet(boolean value) {

      passwordSet_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether a new password is included in the request.
     * </pre>
     *
     * <code>bool password_set = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPasswordSet() {
      bitField0_ = (bitField0_ & ~0x00000010);
      passwordSet_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object databaseService_ = "";
    /**
     *
     *
     * <pre>
     * Required. Database service for the Oracle connection.
     * </pre>
     *
     * <code>string database_service = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The databaseService.
     */
    public java.lang.String getDatabaseService() {
      java.lang.Object ref = databaseService_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        databaseService_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Database service for the Oracle connection.
     * </pre>
     *
     * <code>string database_service = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for databaseService.
     */
    public com.google.protobuf.ByteString getDatabaseServiceBytes() {
      java.lang.Object ref = databaseService_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        databaseService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Database service for the Oracle connection.
     * </pre>
     *
     * <code>string database_service = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The databaseService to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      databaseService_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Database service for the Oracle connection.
     * </pre>
     *
     * <code>string database_service = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabaseService() {
      databaseService_ = getDefaultInstance().getDatabaseService();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Database service for the Oracle connection.
     * </pre>
     *
     * <code>string database_service = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for databaseService to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      databaseService_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.clouddms.v1.SslConfig ssl_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SslConfig,
            com.google.cloud.clouddms.v1.SslConfig.Builder,
            com.google.cloud.clouddms.v1.SslConfigOrBuilder>
        sslBuilder_;
    /**
     *
     *
     * <pre>
     * SSL configuration for the connection to the source Oracle database.
     *
     *  * Only `SERVER_ONLY` configuration is supported for Oracle SSL.
     *  * SSL is supported for Oracle versions 12 and above.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SslConfig ssl = 7;</code>
     *
     * @return Whether the ssl field is set.
     */
    public boolean hasSsl() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * SSL configuration for the connection to the source Oracle database.
     *
     *  * Only `SERVER_ONLY` configuration is supported for Oracle SSL.
     *  * SSL is supported for Oracle versions 12 and above.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SslConfig ssl = 7;</code>
     *
     * @return The ssl.
     */
    public com.google.cloud.clouddms.v1.SslConfig getSsl() {
      if (sslBuilder_ == null) {
        return ssl_ == null ? com.google.cloud.clouddms.v1.SslConfig.getDefaultInstance() : ssl_;
      } else {
        return sslBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * SSL configuration for the connection to the source Oracle database.
     *
     *  * Only `SERVER_ONLY` configuration is supported for Oracle SSL.
     *  * SSL is supported for Oracle versions 12 and above.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SslConfig ssl = 7;</code>
     */
    public Builder setSsl(com.google.cloud.clouddms.v1.SslConfig value) {
      if (sslBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ssl_ = value;
      } else {
        sslBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * SSL configuration for the connection to the source Oracle database.
     *
     *  * Only `SERVER_ONLY` configuration is supported for Oracle SSL.
     *  * SSL is supported for Oracle versions 12 and above.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SslConfig ssl = 7;</code>
     */
    public Builder setSsl(com.google.cloud.clouddms.v1.SslConfig.Builder builderForValue) {
      if (sslBuilder_ == null) {
        ssl_ = builderForValue.build();
      } else {
        sslBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * SSL configuration for the connection to the source Oracle database.
     *
     *  * Only `SERVER_ONLY` configuration is supported for Oracle SSL.
     *  * SSL is supported for Oracle versions 12 and above.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SslConfig ssl = 7;</code>
     */
    public Builder mergeSsl(com.google.cloud.clouddms.v1.SslConfig value) {
      if (sslBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && ssl_ != null
            && ssl_ != com.google.cloud.clouddms.v1.SslConfig.getDefaultInstance()) {
          getSslBuilder().mergeFrom(value);
        } else {
          ssl_ = value;
        }
      } else {
        sslBuilder_.mergeFrom(value);
      }
      if (ssl_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * SSL configuration for the connection to the source Oracle database.
     *
     *  * Only `SERVER_ONLY` configuration is supported for Oracle SSL.
     *  * SSL is supported for Oracle versions 12 and above.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SslConfig ssl = 7;</code>
     */
    public Builder clearSsl() {
      bitField0_ = (bitField0_ & ~0x00000040);
      ssl_ = null;
      if (sslBuilder_ != null) {
        sslBuilder_.dispose();
        sslBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * SSL configuration for the connection to the source Oracle database.
     *
     *  * Only `SERVER_ONLY` configuration is supported for Oracle SSL.
     *  * SSL is supported for Oracle versions 12 and above.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SslConfig ssl = 7;</code>
     */
    public com.google.cloud.clouddms.v1.SslConfig.Builder getSslBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getSslFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * SSL configuration for the connection to the source Oracle database.
     *
     *  * Only `SERVER_ONLY` configuration is supported for Oracle SSL.
     *  * SSL is supported for Oracle versions 12 and above.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SslConfig ssl = 7;</code>
     */
    public com.google.cloud.clouddms.v1.SslConfigOrBuilder getSslOrBuilder() {
      if (sslBuilder_ != null) {
        return sslBuilder_.getMessageOrBuilder();
      } else {
        return ssl_ == null ? com.google.cloud.clouddms.v1.SslConfig.getDefaultInstance() : ssl_;
      }
    }
    /**
     *
     *
     * <pre>
     * SSL configuration for the connection to the source Oracle database.
     *
     *  * Only `SERVER_ONLY` configuration is supported for Oracle SSL.
     *  * SSL is supported for Oracle versions 12 and above.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.SslConfig ssl = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.SslConfig,
            com.google.cloud.clouddms.v1.SslConfig.Builder,
            com.google.cloud.clouddms.v1.SslConfigOrBuilder>
        getSslFieldBuilder() {
      if (sslBuilder_ == null) {
        sslBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.SslConfig,
                com.google.cloud.clouddms.v1.SslConfig.Builder,
                com.google.cloud.clouddms.v1.SslConfigOrBuilder>(
                getSsl(), getParentForChildren(), isClean());
        ssl_ = null;
      }
      return sslBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.StaticServiceIpConnectivity,
            com.google.cloud.clouddms.v1.StaticServiceIpConnectivity.Builder,
            com.google.cloud.clouddms.v1.StaticServiceIpConnectivityOrBuilder>
        staticServiceIpConnectivityBuilder_;
    /**
     *
     *
     * <pre>
     * Static Service IP connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.StaticServiceIpConnectivity static_service_ip_connectivity = 100;
     * </code>
     *
     * @return Whether the staticServiceIpConnectivity field is set.
     */
    @java.lang.Override
    public boolean hasStaticServiceIpConnectivity() {
      return connectivityCase_ == 100;
    }
    /**
     *
     *
     * <pre>
     * Static Service IP connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.StaticServiceIpConnectivity static_service_ip_connectivity = 100;
     * </code>
     *
     * @return The staticServiceIpConnectivity.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.StaticServiceIpConnectivity
        getStaticServiceIpConnectivity() {
      if (staticServiceIpConnectivityBuilder_ == null) {
        if (connectivityCase_ == 100) {
          return (com.google.cloud.clouddms.v1.StaticServiceIpConnectivity) connectivity_;
        }
        return com.google.cloud.clouddms.v1.StaticServiceIpConnectivity.getDefaultInstance();
      } else {
        if (connectivityCase_ == 100) {
          return staticServiceIpConnectivityBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.StaticServiceIpConnectivity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Static Service IP connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.StaticServiceIpConnectivity static_service_ip_connectivity = 100;
     * </code>
     */
    public Builder setStaticServiceIpConnectivity(
        com.google.cloud.clouddms.v1.StaticServiceIpConnectivity value) {
      if (staticServiceIpConnectivityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectivity_ = value;
        onChanged();
      } else {
        staticServiceIpConnectivityBuilder_.setMessage(value);
      }
      connectivityCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Static Service IP connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.StaticServiceIpConnectivity static_service_ip_connectivity = 100;
     * </code>
     */
    public Builder setStaticServiceIpConnectivity(
        com.google.cloud.clouddms.v1.StaticServiceIpConnectivity.Builder builderForValue) {
      if (staticServiceIpConnectivityBuilder_ == null) {
        connectivity_ = builderForValue.build();
        onChanged();
      } else {
        staticServiceIpConnectivityBuilder_.setMessage(builderForValue.build());
      }
      connectivityCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Static Service IP connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.StaticServiceIpConnectivity static_service_ip_connectivity = 100;
     * </code>
     */
    public Builder mergeStaticServiceIpConnectivity(
        com.google.cloud.clouddms.v1.StaticServiceIpConnectivity value) {
      if (staticServiceIpConnectivityBuilder_ == null) {
        if (connectivityCase_ == 100
            && connectivity_
                != com.google.cloud.clouddms.v1.StaticServiceIpConnectivity.getDefaultInstance()) {
          connectivity_ =
              com.google.cloud.clouddms.v1.StaticServiceIpConnectivity.newBuilder(
                      (com.google.cloud.clouddms.v1.StaticServiceIpConnectivity) connectivity_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          connectivity_ = value;
        }
        onChanged();
      } else {
        if (connectivityCase_ == 100) {
          staticServiceIpConnectivityBuilder_.mergeFrom(value);
        } else {
          staticServiceIpConnectivityBuilder_.setMessage(value);
        }
      }
      connectivityCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Static Service IP connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.StaticServiceIpConnectivity static_service_ip_connectivity = 100;
     * </code>
     */
    public Builder clearStaticServiceIpConnectivity() {
      if (staticServiceIpConnectivityBuilder_ == null) {
        if (connectivityCase_ == 100) {
          connectivityCase_ = 0;
          connectivity_ = null;
          onChanged();
        }
      } else {
        if (connectivityCase_ == 100) {
          connectivityCase_ = 0;
          connectivity_ = null;
        }
        staticServiceIpConnectivityBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Static Service IP connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.StaticServiceIpConnectivity static_service_ip_connectivity = 100;
     * </code>
     */
    public com.google.cloud.clouddms.v1.StaticServiceIpConnectivity.Builder
        getStaticServiceIpConnectivityBuilder() {
      return getStaticServiceIpConnectivityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Static Service IP connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.StaticServiceIpConnectivity static_service_ip_connectivity = 100;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.StaticServiceIpConnectivityOrBuilder
        getStaticServiceIpConnectivityOrBuilder() {
      if ((connectivityCase_ == 100) && (staticServiceIpConnectivityBuilder_ != null)) {
        return staticServiceIpConnectivityBuilder_.getMessageOrBuilder();
      } else {
        if (connectivityCase_ == 100) {
          return (com.google.cloud.clouddms.v1.StaticServiceIpConnectivity) connectivity_;
        }
        return com.google.cloud.clouddms.v1.StaticServiceIpConnectivity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Static Service IP connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.StaticServiceIpConnectivity static_service_ip_connectivity = 100;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.StaticServiceIpConnectivity,
            com.google.cloud.clouddms.v1.StaticServiceIpConnectivity.Builder,
            com.google.cloud.clouddms.v1.StaticServiceIpConnectivityOrBuilder>
        getStaticServiceIpConnectivityFieldBuilder() {
      if (staticServiceIpConnectivityBuilder_ == null) {
        if (!(connectivityCase_ == 100)) {
          connectivity_ =
              com.google.cloud.clouddms.v1.StaticServiceIpConnectivity.getDefaultInstance();
        }
        staticServiceIpConnectivityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.StaticServiceIpConnectivity,
                com.google.cloud.clouddms.v1.StaticServiceIpConnectivity.Builder,
                com.google.cloud.clouddms.v1.StaticServiceIpConnectivityOrBuilder>(
                (com.google.cloud.clouddms.v1.StaticServiceIpConnectivity) connectivity_,
                getParentForChildren(),
                isClean());
        connectivity_ = null;
      }
      connectivityCase_ = 100;
      onChanged();
      return staticServiceIpConnectivityBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity,
            com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity.Builder,
            com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivityOrBuilder>
        forwardSshConnectivityBuilder_;
    /**
     *
     *
     * <pre>
     * Forward SSH tunnel connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 101;
     * </code>
     *
     * @return Whether the forwardSshConnectivity field is set.
     */
    @java.lang.Override
    public boolean hasForwardSshConnectivity() {
      return connectivityCase_ == 101;
    }
    /**
     *
     *
     * <pre>
     * Forward SSH tunnel connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 101;
     * </code>
     *
     * @return The forwardSshConnectivity.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity getForwardSshConnectivity() {
      if (forwardSshConnectivityBuilder_ == null) {
        if (connectivityCase_ == 101) {
          return (com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity) connectivity_;
        }
        return com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity.getDefaultInstance();
      } else {
        if (connectivityCase_ == 101) {
          return forwardSshConnectivityBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Forward SSH tunnel connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 101;
     * </code>
     */
    public Builder setForwardSshConnectivity(
        com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity value) {
      if (forwardSshConnectivityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectivity_ = value;
        onChanged();
      } else {
        forwardSshConnectivityBuilder_.setMessage(value);
      }
      connectivityCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Forward SSH tunnel connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 101;
     * </code>
     */
    public Builder setForwardSshConnectivity(
        com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity.Builder builderForValue) {
      if (forwardSshConnectivityBuilder_ == null) {
        connectivity_ = builderForValue.build();
        onChanged();
      } else {
        forwardSshConnectivityBuilder_.setMessage(builderForValue.build());
      }
      connectivityCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Forward SSH tunnel connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 101;
     * </code>
     */
    public Builder mergeForwardSshConnectivity(
        com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity value) {
      if (forwardSshConnectivityBuilder_ == null) {
        if (connectivityCase_ == 101
            && connectivity_
                != com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity.getDefaultInstance()) {
          connectivity_ =
              com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity.newBuilder(
                      (com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity) connectivity_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          connectivity_ = value;
        }
        onChanged();
      } else {
        if (connectivityCase_ == 101) {
          forwardSshConnectivityBuilder_.mergeFrom(value);
        } else {
          forwardSshConnectivityBuilder_.setMessage(value);
        }
      }
      connectivityCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Forward SSH tunnel connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 101;
     * </code>
     */
    public Builder clearForwardSshConnectivity() {
      if (forwardSshConnectivityBuilder_ == null) {
        if (connectivityCase_ == 101) {
          connectivityCase_ = 0;
          connectivity_ = null;
          onChanged();
        }
      } else {
        if (connectivityCase_ == 101) {
          connectivityCase_ = 0;
          connectivity_ = null;
        }
        forwardSshConnectivityBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Forward SSH tunnel connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 101;
     * </code>
     */
    public com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity.Builder
        getForwardSshConnectivityBuilder() {
      return getForwardSshConnectivityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Forward SSH tunnel connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 101;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivityOrBuilder
        getForwardSshConnectivityOrBuilder() {
      if ((connectivityCase_ == 101) && (forwardSshConnectivityBuilder_ != null)) {
        return forwardSshConnectivityBuilder_.getMessageOrBuilder();
      } else {
        if (connectivityCase_ == 101) {
          return (com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity) connectivity_;
        }
        return com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Forward SSH tunnel connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 101;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity,
            com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity.Builder,
            com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivityOrBuilder>
        getForwardSshConnectivityFieldBuilder() {
      if (forwardSshConnectivityBuilder_ == null) {
        if (!(connectivityCase_ == 101)) {
          connectivity_ =
              com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity.getDefaultInstance();
        }
        forwardSshConnectivityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity,
                com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity.Builder,
                com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivityOrBuilder>(
                (com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity) connectivity_,
                getParentForChildren(),
                isClean());
        connectivity_ = null;
      }
      connectivityCase_ = 101;
      onChanged();
      return forwardSshConnectivityBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.PrivateConnectivity,
            com.google.cloud.clouddms.v1.PrivateConnectivity.Builder,
            com.google.cloud.clouddms.v1.PrivateConnectivityOrBuilder>
        privateConnectivityBuilder_;
    /**
     *
     *
     * <pre>
     * Private connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PrivateConnectivity private_connectivity = 102;</code>
     *
     * @return Whether the privateConnectivity field is set.
     */
    @java.lang.Override
    public boolean hasPrivateConnectivity() {
      return connectivityCase_ == 102;
    }
    /**
     *
     *
     * <pre>
     * Private connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PrivateConnectivity private_connectivity = 102;</code>
     *
     * @return The privateConnectivity.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.PrivateConnectivity getPrivateConnectivity() {
      if (privateConnectivityBuilder_ == null) {
        if (connectivityCase_ == 102) {
          return (com.google.cloud.clouddms.v1.PrivateConnectivity) connectivity_;
        }
        return com.google.cloud.clouddms.v1.PrivateConnectivity.getDefaultInstance();
      } else {
        if (connectivityCase_ == 102) {
          return privateConnectivityBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.PrivateConnectivity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Private connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PrivateConnectivity private_connectivity = 102;</code>
     */
    public Builder setPrivateConnectivity(com.google.cloud.clouddms.v1.PrivateConnectivity value) {
      if (privateConnectivityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectivity_ = value;
        onChanged();
      } else {
        privateConnectivityBuilder_.setMessage(value);
      }
      connectivityCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Private connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PrivateConnectivity private_connectivity = 102;</code>
     */
    public Builder setPrivateConnectivity(
        com.google.cloud.clouddms.v1.PrivateConnectivity.Builder builderForValue) {
      if (privateConnectivityBuilder_ == null) {
        connectivity_ = builderForValue.build();
        onChanged();
      } else {
        privateConnectivityBuilder_.setMessage(builderForValue.build());
      }
      connectivityCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Private connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PrivateConnectivity private_connectivity = 102;</code>
     */
    public Builder mergePrivateConnectivity(
        com.google.cloud.clouddms.v1.PrivateConnectivity value) {
      if (privateConnectivityBuilder_ == null) {
        if (connectivityCase_ == 102
            && connectivity_
                != com.google.cloud.clouddms.v1.PrivateConnectivity.getDefaultInstance()) {
          connectivity_ =
              com.google.cloud.clouddms.v1.PrivateConnectivity.newBuilder(
                      (com.google.cloud.clouddms.v1.PrivateConnectivity) connectivity_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          connectivity_ = value;
        }
        onChanged();
      } else {
        if (connectivityCase_ == 102) {
          privateConnectivityBuilder_.mergeFrom(value);
        } else {
          privateConnectivityBuilder_.setMessage(value);
        }
      }
      connectivityCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Private connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PrivateConnectivity private_connectivity = 102;</code>
     */
    public Builder clearPrivateConnectivity() {
      if (privateConnectivityBuilder_ == null) {
        if (connectivityCase_ == 102) {
          connectivityCase_ = 0;
          connectivity_ = null;
          onChanged();
        }
      } else {
        if (connectivityCase_ == 102) {
          connectivityCase_ = 0;
          connectivity_ = null;
        }
        privateConnectivityBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Private connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PrivateConnectivity private_connectivity = 102;</code>
     */
    public com.google.cloud.clouddms.v1.PrivateConnectivity.Builder
        getPrivateConnectivityBuilder() {
      return getPrivateConnectivityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Private connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PrivateConnectivity private_connectivity = 102;</code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.PrivateConnectivityOrBuilder
        getPrivateConnectivityOrBuilder() {
      if ((connectivityCase_ == 102) && (privateConnectivityBuilder_ != null)) {
        return privateConnectivityBuilder_.getMessageOrBuilder();
      } else {
        if (connectivityCase_ == 102) {
          return (com.google.cloud.clouddms.v1.PrivateConnectivity) connectivity_;
        }
        return com.google.cloud.clouddms.v1.PrivateConnectivity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Private connectivity.
     * </pre>
     *
     * <code>.google.cloud.clouddms.v1.PrivateConnectivity private_connectivity = 102;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.PrivateConnectivity,
            com.google.cloud.clouddms.v1.PrivateConnectivity.Builder,
            com.google.cloud.clouddms.v1.PrivateConnectivityOrBuilder>
        getPrivateConnectivityFieldBuilder() {
      if (privateConnectivityBuilder_ == null) {
        if (!(connectivityCase_ == 102)) {
          connectivity_ = com.google.cloud.clouddms.v1.PrivateConnectivity.getDefaultInstance();
        }
        privateConnectivityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.PrivateConnectivity,
                com.google.cloud.clouddms.v1.PrivateConnectivity.Builder,
                com.google.cloud.clouddms.v1.PrivateConnectivityOrBuilder>(
                (com.google.cloud.clouddms.v1.PrivateConnectivity) connectivity_,
                getParentForChildren(),
                isClean());
        connectivity_ = null;
      }
      connectivityCase_ = 102;
      onChanged();
      return privateConnectivityBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.OracleConnectionProfile)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.OracleConnectionProfile)
  private static final com.google.cloud.clouddms.v1.OracleConnectionProfile DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.OracleConnectionProfile();
  }

  public static com.google.cloud.clouddms.v1.OracleConnectionProfile getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OracleConnectionProfile> PARSER =
      new com.google.protobuf.AbstractParser<OracleConnectionProfile>() {
        @java.lang.Override
        public OracleConnectionProfile parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OracleConnectionProfile> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OracleConnectionProfile> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.OracleConnectionProfile getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
