/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/clouddms_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

public interface OracleConnectionProfileOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.clouddms.v1.OracleConnectionProfile)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The IP or hostname of the source Oracle database.
   * </pre>
   *
   * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The host.
   */
  java.lang.String getHost();
  /**
   *
   *
   * <pre>
   * Required. The IP or hostname of the source Oracle database.
   * </pre>
   *
   * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for host.
   */
  com.google.protobuf.ByteString getHostBytes();

  /**
   *
   *
   * <pre>
   * Required. The network port of the source Oracle database.
   * </pre>
   *
   * <code>int32 port = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The port.
   */
  int getPort();

  /**
   *
   *
   * <pre>
   * Required. The username that Database Migration Service will use to connect
   * to the database. The value is encrypted when stored in Database Migration
   * Service.
   * </pre>
   *
   * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The username.
   */
  java.lang.String getUsername();
  /**
   *
   *
   * <pre>
   * Required. The username that Database Migration Service will use to connect
   * to the database. The value is encrypted when stored in Database Migration
   * Service.
   * </pre>
   *
   * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for username.
   */
  com.google.protobuf.ByteString getUsernameBytes();

  /**
   *
   *
   * <pre>
   * Required. Input only. The password for the user that Database Migration
   * Service will be using to connect to the database. This field is not
   * returned on request, and the value is encrypted when stored in Database
   * Migration Service.
   * </pre>
   *
   * <code>
   * string password = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The password.
   */
  java.lang.String getPassword();
  /**
   *
   *
   * <pre>
   * Required. Input only. The password for the user that Database Migration
   * Service will be using to connect to the database. This field is not
   * returned on request, and the value is encrypted when stored in Database
   * Migration Service.
   * </pre>
   *
   * <code>
   * string password = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The bytes for password.
   */
  com.google.protobuf.ByteString getPasswordBytes();

  /**
   *
   *
   * <pre>
   * Output only. Indicates whether a new password is included in the request.
   * </pre>
   *
   * <code>bool password_set = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The passwordSet.
   */
  boolean getPasswordSet();

  /**
   *
   *
   * <pre>
   * Required. Database service for the Oracle connection.
   * </pre>
   *
   * <code>string database_service = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The databaseService.
   */
  java.lang.String getDatabaseService();
  /**
   *
   *
   * <pre>
   * Required. Database service for the Oracle connection.
   * </pre>
   *
   * <code>string database_service = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for databaseService.
   */
  com.google.protobuf.ByteString getDatabaseServiceBytes();

  /**
   *
   *
   * <pre>
   * SSL configuration for the connection to the source Oracle database.
   *
   *  * Only `SERVER_ONLY` configuration is supported for Oracle SSL.
   *  * SSL is supported for Oracle versions 12 and above.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SslConfig ssl = 7;</code>
   *
   * @return Whether the ssl field is set.
   */
  boolean hasSsl();
  /**
   *
   *
   * <pre>
   * SSL configuration for the connection to the source Oracle database.
   *
   *  * Only `SERVER_ONLY` configuration is supported for Oracle SSL.
   *  * SSL is supported for Oracle versions 12 and above.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SslConfig ssl = 7;</code>
   *
   * @return The ssl.
   */
  com.google.cloud.clouddms.v1.SslConfig getSsl();
  /**
   *
   *
   * <pre>
   * SSL configuration for the connection to the source Oracle database.
   *
   *  * Only `SERVER_ONLY` configuration is supported for Oracle SSL.
   *  * SSL is supported for Oracle versions 12 and above.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.SslConfig ssl = 7;</code>
   */
  com.google.cloud.clouddms.v1.SslConfigOrBuilder getSslOrBuilder();

  /**
   *
   *
   * <pre>
   * Static Service IP connectivity.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.StaticServiceIpConnectivity static_service_ip_connectivity = 100;
   * </code>
   *
   * @return Whether the staticServiceIpConnectivity field is set.
   */
  boolean hasStaticServiceIpConnectivity();
  /**
   *
   *
   * <pre>
   * Static Service IP connectivity.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.StaticServiceIpConnectivity static_service_ip_connectivity = 100;
   * </code>
   *
   * @return The staticServiceIpConnectivity.
   */
  com.google.cloud.clouddms.v1.StaticServiceIpConnectivity getStaticServiceIpConnectivity();
  /**
   *
   *
   * <pre>
   * Static Service IP connectivity.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.StaticServiceIpConnectivity static_service_ip_connectivity = 100;
   * </code>
   */
  com.google.cloud.clouddms.v1.StaticServiceIpConnectivityOrBuilder
      getStaticServiceIpConnectivityOrBuilder();

  /**
   *
   *
   * <pre>
   * Forward SSH tunnel connectivity.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 101;
   * </code>
   *
   * @return Whether the forwardSshConnectivity field is set.
   */
  boolean hasForwardSshConnectivity();
  /**
   *
   *
   * <pre>
   * Forward SSH tunnel connectivity.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 101;
   * </code>
   *
   * @return The forwardSshConnectivity.
   */
  com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity getForwardSshConnectivity();
  /**
   *
   *
   * <pre>
   * Forward SSH tunnel connectivity.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 101;
   * </code>
   */
  com.google.cloud.clouddms.v1.ForwardSshTunnelConnectivityOrBuilder
      getForwardSshConnectivityOrBuilder();

  /**
   *
   *
   * <pre>
   * Private connectivity.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.PrivateConnectivity private_connectivity = 102;</code>
   *
   * @return Whether the privateConnectivity field is set.
   */
  boolean hasPrivateConnectivity();
  /**
   *
   *
   * <pre>
   * Private connectivity.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.PrivateConnectivity private_connectivity = 102;</code>
   *
   * @return The privateConnectivity.
   */
  com.google.cloud.clouddms.v1.PrivateConnectivity getPrivateConnectivity();
  /**
   *
   *
   * <pre>
   * Private connectivity.
   * </pre>
   *
   * <code>.google.cloud.clouddms.v1.PrivateConnectivity private_connectivity = 102;</code>
   */
  com.google.cloud.clouddms.v1.PrivateConnectivityOrBuilder getPrivateConnectivityOrBuilder();

  com.google.cloud.clouddms.v1.OracleConnectionProfile.ConnectivityCase getConnectivityCase();
}
