/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/clouddms.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Request message for 'SeedConversionWorkspace' request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.SeedConversionWorkspaceRequest}
 */
public final class SeedConversionWorkspaceRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.SeedConversionWorkspaceRequest)
    SeedConversionWorkspaceRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SeedConversionWorkspaceRequest.newBuilder() to construct.
  private SeedConversionWorkspaceRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SeedConversionWorkspaceRequest() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SeedConversionWorkspaceRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ClouddmsProto
        .internal_static_google_cloud_clouddms_v1_SeedConversionWorkspaceRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ClouddmsProto
        .internal_static_google_cloud_clouddms_v1_SeedConversionWorkspaceRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest.class,
            com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest.Builder.class);
  }

  private int seedFromCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object seedFrom_;

  public enum SeedFromCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SOURCE_CONNECTION_PROFILE(100),
    DESTINATION_CONNECTION_PROFILE(101),
    SEEDFROM_NOT_SET(0);
    private final int value;

    private SeedFromCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SeedFromCase valueOf(int value) {
      return forNumber(value);
    }

    public static SeedFromCase forNumber(int value) {
      switch (value) {
        case 100:
          return SOURCE_CONNECTION_PROFILE;
        case 101:
          return DESTINATION_CONNECTION_PROFILE;
        case 0:
          return SEEDFROM_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SeedFromCase getSeedFromCase() {
    return SeedFromCase.forNumber(seedFromCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of the conversion workspace resource to seed with new database
   * structure, in the form of:
   * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the conversion workspace resource to seed with new database
   * structure, in the form of:
   * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUTO_COMMIT_FIELD_NUMBER = 2;
  private boolean autoCommit_ = false;
  /**
   *
   *
   * <pre>
   * Should the conversion workspace be committed automatically after the
   * seed operation.
   * </pre>
   *
   * <code>bool auto_commit = 2;</code>
   *
   * @return The autoCommit.
   */
  @java.lang.Override
  public boolean getAutoCommit() {
    return autoCommit_;
  }

  public static final int SOURCE_CONNECTION_PROFILE_FIELD_NUMBER = 100;
  /**
   *
   *
   * <pre>
   * Optional. Fully qualified (Uri) name of the source connection profile.
   * </pre>
   *
   * <code>string source_connection_profile = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the sourceConnectionProfile field is set.
   */
  public boolean hasSourceConnectionProfile() {
    return seedFromCase_ == 100;
  }
  /**
   *
   *
   * <pre>
   * Optional. Fully qualified (Uri) name of the source connection profile.
   * </pre>
   *
   * <code>string source_connection_profile = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The sourceConnectionProfile.
   */
  public java.lang.String getSourceConnectionProfile() {
    java.lang.Object ref = "";
    if (seedFromCase_ == 100) {
      ref = seedFrom_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (seedFromCase_ == 100) {
        seedFrom_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Fully qualified (Uri) name of the source connection profile.
   * </pre>
   *
   * <code>string source_connection_profile = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for sourceConnectionProfile.
   */
  public com.google.protobuf.ByteString getSourceConnectionProfileBytes() {
    java.lang.Object ref = "";
    if (seedFromCase_ == 100) {
      ref = seedFrom_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (seedFromCase_ == 100) {
        seedFrom_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESTINATION_CONNECTION_PROFILE_FIELD_NUMBER = 101;
  /**
   *
   *
   * <pre>
   * Optional. Fully qualified (Uri) name of the destination connection
   * profile.
   * </pre>
   *
   * <code>string destination_connection_profile = 101 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the destinationConnectionProfile field is set.
   */
  public boolean hasDestinationConnectionProfile() {
    return seedFromCase_ == 101;
  }
  /**
   *
   *
   * <pre>
   * Optional. Fully qualified (Uri) name of the destination connection
   * profile.
   * </pre>
   *
   * <code>string destination_connection_profile = 101 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The destinationConnectionProfile.
   */
  public java.lang.String getDestinationConnectionProfile() {
    java.lang.Object ref = "";
    if (seedFromCase_ == 101) {
      ref = seedFrom_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (seedFromCase_ == 101) {
        seedFrom_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Fully qualified (Uri) name of the destination connection
   * profile.
   * </pre>
   *
   * <code>string destination_connection_profile = 101 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bytes for destinationConnectionProfile.
   */
  public com.google.protobuf.ByteString getDestinationConnectionProfileBytes() {
    java.lang.Object ref = "";
    if (seedFromCase_ == 101) {
      ref = seedFrom_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (seedFromCase_ == 101) {
        seedFrom_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (autoCommit_ != false) {
      output.writeBool(2, autoCommit_);
    }
    if (seedFromCase_ == 100) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 100, seedFrom_);
    }
    if (seedFromCase_ == 101) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 101, seedFrom_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (autoCommit_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, autoCommit_);
    }
    if (seedFromCase_ == 100) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(100, seedFrom_);
    }
    if (seedFromCase_ == 101) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(101, seedFrom_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest other =
        (com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (getAutoCommit() != other.getAutoCommit()) return false;
    if (!getSeedFromCase().equals(other.getSeedFromCase())) return false;
    switch (seedFromCase_) {
      case 100:
        if (!getSourceConnectionProfile().equals(other.getSourceConnectionProfile())) return false;
        break;
      case 101:
        if (!getDestinationConnectionProfile().equals(other.getDestinationConnectionProfile()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + AUTO_COMMIT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAutoCommit());
    switch (seedFromCase_) {
      case 100:
        hash = (37 * hash) + SOURCE_CONNECTION_PROFILE_FIELD_NUMBER;
        hash = (53 * hash) + getSourceConnectionProfile().hashCode();
        break;
      case 101:
        hash = (37 * hash) + DESTINATION_CONNECTION_PROFILE_FIELD_NUMBER;
        hash = (53 * hash) + getDestinationConnectionProfile().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for 'SeedConversionWorkspace' request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.SeedConversionWorkspaceRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.SeedConversionWorkspaceRequest)
      com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_SeedConversionWorkspaceRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_SeedConversionWorkspaceRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest.class,
              com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      autoCommit_ = false;
      seedFromCase_ = 0;
      seedFrom_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_SeedConversionWorkspaceRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest build() {
      com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest buildPartial() {
      com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest result =
          new com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.autoCommit_ = autoCommit_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest result) {
      result.seedFromCase_ = seedFromCase_;
      result.seedFrom_ = this.seedFrom_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest) {
        return mergeFrom((com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest other) {
      if (other == com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getAutoCommit() != false) {
        setAutoCommit(other.getAutoCommit());
      }
      switch (other.getSeedFromCase()) {
        case SOURCE_CONNECTION_PROFILE:
          {
            seedFromCase_ = 100;
            seedFrom_ = other.seedFrom_;
            onChanged();
            break;
          }
        case DESTINATION_CONNECTION_PROFILE:
          {
            seedFromCase_ = 101;
            seedFrom_ = other.seedFrom_;
            onChanged();
            break;
          }
        case SEEDFROM_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                autoCommit_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 802:
              {
                java.lang.String s = input.readStringRequireUtf8();
                seedFromCase_ = 100;
                seedFrom_ = s;
                break;
              } // case 802
            case 810:
              {
                java.lang.String s = input.readStringRequireUtf8();
                seedFromCase_ = 101;
                seedFrom_ = s;
                break;
              } // case 810
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int seedFromCase_ = 0;
    private java.lang.Object seedFrom_;

    public SeedFromCase getSeedFromCase() {
      return SeedFromCase.forNumber(seedFromCase_);
    }

    public Builder clearSeedFrom() {
      seedFromCase_ = 0;
      seedFrom_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the conversion workspace resource to seed with new database
     * structure, in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the conversion workspace resource to seed with new database
     * structure, in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the conversion workspace resource to seed with new database
     * structure, in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the conversion workspace resource to seed with new database
     * structure, in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the conversion workspace resource to seed with new database
     * structure, in the form of:
     * projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean autoCommit_;
    /**
     *
     *
     * <pre>
     * Should the conversion workspace be committed automatically after the
     * seed operation.
     * </pre>
     *
     * <code>bool auto_commit = 2;</code>
     *
     * @return The autoCommit.
     */
    @java.lang.Override
    public boolean getAutoCommit() {
      return autoCommit_;
    }
    /**
     *
     *
     * <pre>
     * Should the conversion workspace be committed automatically after the
     * seed operation.
     * </pre>
     *
     * <code>bool auto_commit = 2;</code>
     *
     * @param value The autoCommit to set.
     * @return This builder for chaining.
     */
    public Builder setAutoCommit(boolean value) {

      autoCommit_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Should the conversion workspace be committed automatically after the
     * seed operation.
     * </pre>
     *
     * <code>bool auto_commit = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutoCommit() {
      bitField0_ = (bitField0_ & ~0x00000002);
      autoCommit_ = false;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Fully qualified (Uri) name of the source connection profile.
     * </pre>
     *
     * <code>string source_connection_profile = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sourceConnectionProfile field is set.
     */
    @java.lang.Override
    public boolean hasSourceConnectionProfile() {
      return seedFromCase_ == 100;
    }
    /**
     *
     *
     * <pre>
     * Optional. Fully qualified (Uri) name of the source connection profile.
     * </pre>
     *
     * <code>string source_connection_profile = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sourceConnectionProfile.
     */
    @java.lang.Override
    public java.lang.String getSourceConnectionProfile() {
      java.lang.Object ref = "";
      if (seedFromCase_ == 100) {
        ref = seedFrom_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (seedFromCase_ == 100) {
          seedFrom_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Fully qualified (Uri) name of the source connection profile.
     * </pre>
     *
     * <code>string source_connection_profile = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bytes for sourceConnectionProfile.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSourceConnectionProfileBytes() {
      java.lang.Object ref = "";
      if (seedFromCase_ == 100) {
        ref = seedFrom_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (seedFromCase_ == 100) {
          seedFrom_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Fully qualified (Uri) name of the source connection profile.
     * </pre>
     *
     * <code>string source_connection_profile = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The sourceConnectionProfile to set.
     * @return This builder for chaining.
     */
    public Builder setSourceConnectionProfile(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      seedFromCase_ = 100;
      seedFrom_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Fully qualified (Uri) name of the source connection profile.
     * </pre>
     *
     * <code>string source_connection_profile = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceConnectionProfile() {
      if (seedFromCase_ == 100) {
        seedFromCase_ = 0;
        seedFrom_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Fully qualified (Uri) name of the source connection profile.
     * </pre>
     *
     * <code>string source_connection_profile = 100 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes for sourceConnectionProfile to set.
     * @return This builder for chaining.
     */
    public Builder setSourceConnectionProfileBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      seedFromCase_ = 100;
      seedFrom_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Fully qualified (Uri) name of the destination connection
     * profile.
     * </pre>
     *
     * <code>string destination_connection_profile = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the destinationConnectionProfile field is set.
     */
    @java.lang.Override
    public boolean hasDestinationConnectionProfile() {
      return seedFromCase_ == 101;
    }
    /**
     *
     *
     * <pre>
     * Optional. Fully qualified (Uri) name of the destination connection
     * profile.
     * </pre>
     *
     * <code>string destination_connection_profile = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The destinationConnectionProfile.
     */
    @java.lang.Override
    public java.lang.String getDestinationConnectionProfile() {
      java.lang.Object ref = "";
      if (seedFromCase_ == 101) {
        ref = seedFrom_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (seedFromCase_ == 101) {
          seedFrom_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Fully qualified (Uri) name of the destination connection
     * profile.
     * </pre>
     *
     * <code>string destination_connection_profile = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bytes for destinationConnectionProfile.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDestinationConnectionProfileBytes() {
      java.lang.Object ref = "";
      if (seedFromCase_ == 101) {
        ref = seedFrom_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (seedFromCase_ == 101) {
          seedFrom_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Fully qualified (Uri) name of the destination connection
     * profile.
     * </pre>
     *
     * <code>string destination_connection_profile = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The destinationConnectionProfile to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationConnectionProfile(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      seedFromCase_ = 101;
      seedFrom_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Fully qualified (Uri) name of the destination connection
     * profile.
     * </pre>
     *
     * <code>string destination_connection_profile = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestinationConnectionProfile() {
      if (seedFromCase_ == 101) {
        seedFromCase_ = 0;
        seedFrom_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Fully qualified (Uri) name of the destination connection
     * profile.
     * </pre>
     *
     * <code>string destination_connection_profile = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes for destinationConnectionProfile to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationConnectionProfileBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      seedFromCase_ = 101;
      seedFrom_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.SeedConversionWorkspaceRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.SeedConversionWorkspaceRequest)
  private static final com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest();
  }

  public static com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SeedConversionWorkspaceRequest> PARSER =
      new com.google.protobuf.AbstractParser<SeedConversionWorkspaceRequest>() {
        @java.lang.Override
        public SeedConversionWorkspaceRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SeedConversionWorkspaceRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SeedConversionWorkspaceRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
