/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Options to configure rule type SingleColumnChange.
 * The rule is used to change the properties of a column.
 *
 * The rule filter field can refer to one entity.
 *
 * The rule scope can be one of: Column.
 *
 * When using this rule, if a field is not specified than the destination
 * column's configuration will be the same as the one in the source column..
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.SingleColumnChange}
 */
public final class SingleColumnChange extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.SingleColumnChange)
    SingleColumnChangeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SingleColumnChange.newBuilder() to construct.
  private SingleColumnChange(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SingleColumnChange() {
    dataType_ = "";
    charset_ = "";
    collation_ = "";
    setValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
    comment_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SingleColumnChange();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_SingleColumnChange_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_SingleColumnChange_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.SingleColumnChange.class,
            com.google.cloud.clouddms.v1.SingleColumnChange.Builder.class);
  }

  private int bitField0_;
  public static final int DATA_TYPE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataType_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Column data type name.
   * </pre>
   *
   * <code>string data_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The dataType.
   */
  @java.lang.Override
  public java.lang.String getDataType() {
    java.lang.Object ref = dataType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Column data type name.
   * </pre>
   *
   * <code>string data_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for dataType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDataTypeBytes() {
    java.lang.Object ref = dataType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CHARSET_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object charset_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Charset override - instead of table level charset.
   * </pre>
   *
   * <code>string charset = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The charset.
   */
  @java.lang.Override
  public java.lang.String getCharset() {
    java.lang.Object ref = charset_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      charset_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Charset override - instead of table level charset.
   * </pre>
   *
   * <code>string charset = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for charset.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCharsetBytes() {
    java.lang.Object ref = charset_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      charset_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COLLATION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object collation_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Collation override - instead of table level collation.
   * </pre>
   *
   * <code>string collation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The collation.
   */
  @java.lang.Override
  public java.lang.String getCollation() {
    java.lang.Object ref = collation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      collation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Collation override - instead of table level collation.
   * </pre>
   *
   * <code>string collation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for collation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCollationBytes() {
    java.lang.Object ref = collation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      collation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LENGTH_FIELD_NUMBER = 4;
  private long length_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional. Column length - e.g. 50 as in varchar (50) - when relevant.
   * </pre>
   *
   * <code>int64 length = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The length.
   */
  @java.lang.Override
  public long getLength() {
    return length_;
  }

  public static final int PRECISION_FIELD_NUMBER = 5;
  private int precision_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Column precision - e.g. 8 as in double (8,2) - when relevant.
   * </pre>
   *
   * <code>int32 precision = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The precision.
   */
  @java.lang.Override
  public int getPrecision() {
    return precision_;
  }

  public static final int SCALE_FIELD_NUMBER = 6;
  private int scale_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Column scale - e.g. 2 as in double (8,2) - when relevant.
   * </pre>
   *
   * <code>int32 scale = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The scale.
   */
  @java.lang.Override
  public int getScale() {
    return scale_;
  }

  public static final int FRACTIONAL_SECONDS_PRECISION_FIELD_NUMBER = 7;
  private int fractionalSecondsPrecision_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Column fractional seconds precision - e.g. 2 as in timestamp (2)
   * - when relevant.
   * </pre>
   *
   * <code>int32 fractional_seconds_precision = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The fractionalSecondsPrecision.
   */
  @java.lang.Override
  public int getFractionalSecondsPrecision() {
    return fractionalSecondsPrecision_;
  }

  public static final int ARRAY_FIELD_NUMBER = 8;
  private boolean array_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Is the column of array type.
   * </pre>
   *
   * <code>bool array = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The array.
   */
  @java.lang.Override
  public boolean getArray() {
    return array_;
  }

  public static final int ARRAY_LENGTH_FIELD_NUMBER = 9;
  private int arrayLength_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The length of the array, only relevant if the column type is an
   * array.
   * </pre>
   *
   * <code>int32 array_length = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The arrayLength.
   */
  @java.lang.Override
  public int getArrayLength() {
    return arrayLength_;
  }

  public static final int NULLABLE_FIELD_NUMBER = 10;
  private boolean nullable_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Is the column nullable.
   * </pre>
   *
   * <code>bool nullable = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The nullable.
   */
  @java.lang.Override
  public boolean getNullable() {
    return nullable_;
  }

  public static final int AUTO_GENERATED_FIELD_NUMBER = 11;
  private boolean autoGenerated_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Is the column auto-generated/identity.
   * </pre>
   *
   * <code>bool auto_generated = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The autoGenerated.
   */
  @java.lang.Override
  public boolean getAutoGenerated() {
    return autoGenerated_;
  }

  public static final int UDT_FIELD_NUMBER = 12;
  private boolean udt_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Is the column a UDT (User-defined Type).
   * </pre>
   *
   * <code>bool udt = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The udt.
   */
  @java.lang.Override
  public boolean getUdt() {
    return udt_;
  }

  public static final int CUSTOM_FEATURES_FIELD_NUMBER = 13;
  private com.google.protobuf.Struct customFeatures_;
  /**
   *
   *
   * <pre>
   * Optional. Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the customFeatures field is set.
   */
  @java.lang.Override
  public boolean hasCustomFeatures() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The customFeatures.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getCustomFeatures() {
    return customFeatures_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : customFeatures_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getCustomFeaturesOrBuilder() {
    return customFeatures_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : customFeatures_;
  }

  public static final int SET_VALUES_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList setValues_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Specifies the list of values allowed in the column.
   * </pre>
   *
   * <code>repeated string set_values = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the setValues.
   */
  public com.google.protobuf.ProtocolStringList getSetValuesList() {
    return setValues_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies the list of values allowed in the column.
   * </pre>
   *
   * <code>repeated string set_values = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of setValues.
   */
  public int getSetValuesCount() {
    return setValues_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies the list of values allowed in the column.
   * </pre>
   *
   * <code>repeated string set_values = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The setValues at the given index.
   */
  public java.lang.String getSetValues(int index) {
    return setValues_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies the list of values allowed in the column.
   * </pre>
   *
   * <code>repeated string set_values = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the setValues at the given index.
   */
  public com.google.protobuf.ByteString getSetValuesBytes(int index) {
    return setValues_.getByteString(index);
  }

  public static final int COMMENT_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object comment_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Comment associated with the column.
   * </pre>
   *
   * <code>string comment = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The comment.
   */
  @java.lang.Override
  public java.lang.String getComment() {
    java.lang.Object ref = comment_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      comment_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Comment associated with the column.
   * </pre>
   *
   * <code>string comment = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for comment.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCommentBytes() {
    java.lang.Object ref = comment_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      comment_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dataType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(charset_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, charset_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(collation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, collation_);
    }
    if (length_ != 0L) {
      output.writeInt64(4, length_);
    }
    if (precision_ != 0) {
      output.writeInt32(5, precision_);
    }
    if (scale_ != 0) {
      output.writeInt32(6, scale_);
    }
    if (fractionalSecondsPrecision_ != 0) {
      output.writeInt32(7, fractionalSecondsPrecision_);
    }
    if (array_ != false) {
      output.writeBool(8, array_);
    }
    if (arrayLength_ != 0) {
      output.writeInt32(9, arrayLength_);
    }
    if (nullable_ != false) {
      output.writeBool(10, nullable_);
    }
    if (autoGenerated_ != false) {
      output.writeBool(11, autoGenerated_);
    }
    if (udt_ != false) {
      output.writeBool(12, udt_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(13, getCustomFeatures());
    }
    for (int i = 0; i < setValues_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, setValues_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(comment_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, comment_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dataType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(charset_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, charset_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(collation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, collation_);
    }
    if (length_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, length_);
    }
    if (precision_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, precision_);
    }
    if (scale_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, scale_);
    }
    if (fractionalSecondsPrecision_ != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(7, fractionalSecondsPrecision_);
    }
    if (array_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, array_);
    }
    if (arrayLength_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(9, arrayLength_);
    }
    if (nullable_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(10, nullable_);
    }
    if (autoGenerated_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, autoGenerated_);
    }
    if (udt_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(12, udt_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getCustomFeatures());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < setValues_.size(); i++) {
        dataSize += computeStringSizeNoTag(setValues_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSetValuesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(comment_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, comment_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.SingleColumnChange)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.SingleColumnChange other =
        (com.google.cloud.clouddms.v1.SingleColumnChange) obj;

    if (!getDataType().equals(other.getDataType())) return false;
    if (!getCharset().equals(other.getCharset())) return false;
    if (!getCollation().equals(other.getCollation())) return false;
    if (getLength() != other.getLength()) return false;
    if (getPrecision() != other.getPrecision()) return false;
    if (getScale() != other.getScale()) return false;
    if (getFractionalSecondsPrecision() != other.getFractionalSecondsPrecision()) return false;
    if (getArray() != other.getArray()) return false;
    if (getArrayLength() != other.getArrayLength()) return false;
    if (getNullable() != other.getNullable()) return false;
    if (getAutoGenerated() != other.getAutoGenerated()) return false;
    if (getUdt() != other.getUdt()) return false;
    if (hasCustomFeatures() != other.hasCustomFeatures()) return false;
    if (hasCustomFeatures()) {
      if (!getCustomFeatures().equals(other.getCustomFeatures())) return false;
    }
    if (!getSetValuesList().equals(other.getSetValuesList())) return false;
    if (!getComment().equals(other.getComment())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATA_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getDataType().hashCode();
    hash = (37 * hash) + CHARSET_FIELD_NUMBER;
    hash = (53 * hash) + getCharset().hashCode();
    hash = (37 * hash) + COLLATION_FIELD_NUMBER;
    hash = (53 * hash) + getCollation().hashCode();
    hash = (37 * hash) + LENGTH_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getLength());
    hash = (37 * hash) + PRECISION_FIELD_NUMBER;
    hash = (53 * hash) + getPrecision();
    hash = (37 * hash) + SCALE_FIELD_NUMBER;
    hash = (53 * hash) + getScale();
    hash = (37 * hash) + FRACTIONAL_SECONDS_PRECISION_FIELD_NUMBER;
    hash = (53 * hash) + getFractionalSecondsPrecision();
    hash = (37 * hash) + ARRAY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getArray());
    hash = (37 * hash) + ARRAY_LENGTH_FIELD_NUMBER;
    hash = (53 * hash) + getArrayLength();
    hash = (37 * hash) + NULLABLE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getNullable());
    hash = (37 * hash) + AUTO_GENERATED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAutoGenerated());
    hash = (37 * hash) + UDT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUdt());
    if (hasCustomFeatures()) {
      hash = (37 * hash) + CUSTOM_FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getCustomFeatures().hashCode();
    }
    if (getSetValuesCount() > 0) {
      hash = (37 * hash) + SET_VALUES_FIELD_NUMBER;
      hash = (53 * hash) + getSetValuesList().hashCode();
    }
    hash = (37 * hash) + COMMENT_FIELD_NUMBER;
    hash = (53 * hash) + getComment().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.SingleColumnChange parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.SingleColumnChange parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.SingleColumnChange parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.SingleColumnChange parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.SingleColumnChange parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.SingleColumnChange parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.SingleColumnChange parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.SingleColumnChange parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.SingleColumnChange parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.SingleColumnChange parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.SingleColumnChange parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.SingleColumnChange parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.SingleColumnChange prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Options to configure rule type SingleColumnChange.
   * The rule is used to change the properties of a column.
   *
   * The rule filter field can refer to one entity.
   *
   * The rule scope can be one of: Column.
   *
   * When using this rule, if a field is not specified than the destination
   * column's configuration will be the same as the one in the source column..
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.SingleColumnChange}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.SingleColumnChange)
      com.google.cloud.clouddms.v1.SingleColumnChangeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_SingleColumnChange_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_SingleColumnChange_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.SingleColumnChange.class,
              com.google.cloud.clouddms.v1.SingleColumnChange.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.SingleColumnChange.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCustomFeaturesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      dataType_ = "";
      charset_ = "";
      collation_ = "";
      length_ = 0L;
      precision_ = 0;
      scale_ = 0;
      fractionalSecondsPrecision_ = 0;
      array_ = false;
      arrayLength_ = 0;
      nullable_ = false;
      autoGenerated_ = false;
      udt_ = false;
      customFeatures_ = null;
      if (customFeaturesBuilder_ != null) {
        customFeaturesBuilder_.dispose();
        customFeaturesBuilder_ = null;
      }
      setValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
      comment_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_SingleColumnChange_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.SingleColumnChange getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.SingleColumnChange.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.SingleColumnChange build() {
      com.google.cloud.clouddms.v1.SingleColumnChange result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.SingleColumnChange buildPartial() {
      com.google.cloud.clouddms.v1.SingleColumnChange result =
          new com.google.cloud.clouddms.v1.SingleColumnChange(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.SingleColumnChange result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.dataType_ = dataType_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.charset_ = charset_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.collation_ = collation_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.length_ = length_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.precision_ = precision_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.scale_ = scale_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.fractionalSecondsPrecision_ = fractionalSecondsPrecision_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.array_ = array_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.arrayLength_ = arrayLength_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.nullable_ = nullable_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.autoGenerated_ = autoGenerated_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.udt_ = udt_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.customFeatures_ =
            customFeaturesBuilder_ == null ? customFeatures_ : customFeaturesBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        setValues_.makeImmutable();
        result.setValues_ = setValues_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.comment_ = comment_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.SingleColumnChange) {
        return mergeFrom((com.google.cloud.clouddms.v1.SingleColumnChange) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.SingleColumnChange other) {
      if (other == com.google.cloud.clouddms.v1.SingleColumnChange.getDefaultInstance())
        return this;
      if (!other.getDataType().isEmpty()) {
        dataType_ = other.dataType_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getCharset().isEmpty()) {
        charset_ = other.charset_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getCollation().isEmpty()) {
        collation_ = other.collation_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getLength() != 0L) {
        setLength(other.getLength());
      }
      if (other.getPrecision() != 0) {
        setPrecision(other.getPrecision());
      }
      if (other.getScale() != 0) {
        setScale(other.getScale());
      }
      if (other.getFractionalSecondsPrecision() != 0) {
        setFractionalSecondsPrecision(other.getFractionalSecondsPrecision());
      }
      if (other.getArray() != false) {
        setArray(other.getArray());
      }
      if (other.getArrayLength() != 0) {
        setArrayLength(other.getArrayLength());
      }
      if (other.getNullable() != false) {
        setNullable(other.getNullable());
      }
      if (other.getAutoGenerated() != false) {
        setAutoGenerated(other.getAutoGenerated());
      }
      if (other.getUdt() != false) {
        setUdt(other.getUdt());
      }
      if (other.hasCustomFeatures()) {
        mergeCustomFeatures(other.getCustomFeatures());
      }
      if (!other.setValues_.isEmpty()) {
        if (setValues_.isEmpty()) {
          setValues_ = other.setValues_;
          bitField0_ |= 0x00002000;
        } else {
          ensureSetValuesIsMutable();
          setValues_.addAll(other.setValues_);
        }
        onChanged();
      }
      if (!other.getComment().isEmpty()) {
        comment_ = other.comment_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                dataType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                charset_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                collation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                length_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                precision_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                scale_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                fractionalSecondsPrecision_ = input.readInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 64:
              {
                array_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 72:
              {
                arrayLength_ = input.readInt32();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 80:
              {
                nullable_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            case 88:
              {
                autoGenerated_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 88
            case 96:
              {
                udt_ = input.readBool();
                bitField0_ |= 0x00000800;
                break;
              } // case 96
            case 106:
              {
                input.readMessage(getCustomFeaturesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            case 114:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSetValuesIsMutable();
                setValues_.add(s);
                break;
              } // case 114
            case 122:
              {
                comment_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object dataType_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Column data type name.
     * </pre>
     *
     * <code>string data_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The dataType.
     */
    public java.lang.String getDataType() {
      java.lang.Object ref = dataType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Column data type name.
     * </pre>
     *
     * <code>string data_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for dataType.
     */
    public com.google.protobuf.ByteString getDataTypeBytes() {
      java.lang.Object ref = dataType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Column data type name.
     * </pre>
     *
     * <code>string data_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The dataType to set.
     * @return This builder for chaining.
     */
    public Builder setDataType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Column data type name.
     * </pre>
     *
     * <code>string data_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataType() {
      dataType_ = getDefaultInstance().getDataType();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Column data type name.
     * </pre>
     *
     * <code>string data_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for dataType to set.
     * @return This builder for chaining.
     */
    public Builder setDataTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object charset_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Charset override - instead of table level charset.
     * </pre>
     *
     * <code>string charset = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The charset.
     */
    public java.lang.String getCharset() {
      java.lang.Object ref = charset_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        charset_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Charset override - instead of table level charset.
     * </pre>
     *
     * <code>string charset = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for charset.
     */
    public com.google.protobuf.ByteString getCharsetBytes() {
      java.lang.Object ref = charset_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        charset_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Charset override - instead of table level charset.
     * </pre>
     *
     * <code>string charset = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The charset to set.
     * @return This builder for chaining.
     */
    public Builder setCharset(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      charset_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Charset override - instead of table level charset.
     * </pre>
     *
     * <code>string charset = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCharset() {
      charset_ = getDefaultInstance().getCharset();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Charset override - instead of table level charset.
     * </pre>
     *
     * <code>string charset = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for charset to set.
     * @return This builder for chaining.
     */
    public Builder setCharsetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      charset_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object collation_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Collation override - instead of table level collation.
     * </pre>
     *
     * <code>string collation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The collation.
     */
    public java.lang.String getCollation() {
      java.lang.Object ref = collation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        collation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Collation override - instead of table level collation.
     * </pre>
     *
     * <code>string collation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for collation.
     */
    public com.google.protobuf.ByteString getCollationBytes() {
      java.lang.Object ref = collation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        collation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Collation override - instead of table level collation.
     * </pre>
     *
     * <code>string collation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The collation to set.
     * @return This builder for chaining.
     */
    public Builder setCollation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      collation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Collation override - instead of table level collation.
     * </pre>
     *
     * <code>string collation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCollation() {
      collation_ = getDefaultInstance().getCollation();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Collation override - instead of table level collation.
     * </pre>
     *
     * <code>string collation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for collation to set.
     * @return This builder for chaining.
     */
    public Builder setCollationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      collation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private long length_;
    /**
     *
     *
     * <pre>
     * Optional. Column length - e.g. 50 as in varchar (50) - when relevant.
     * </pre>
     *
     * <code>int64 length = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The length.
     */
    @java.lang.Override
    public long getLength() {
      return length_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Column length - e.g. 50 as in varchar (50) - when relevant.
     * </pre>
     *
     * <code>int64 length = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The length to set.
     * @return This builder for chaining.
     */
    public Builder setLength(long value) {

      length_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Column length - e.g. 50 as in varchar (50) - when relevant.
     * </pre>
     *
     * <code>int64 length = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLength() {
      bitField0_ = (bitField0_ & ~0x00000008);
      length_ = 0L;
      onChanged();
      return this;
    }

    private int precision_;
    /**
     *
     *
     * <pre>
     * Optional. Column precision - e.g. 8 as in double (8,2) - when relevant.
     * </pre>
     *
     * <code>int32 precision = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The precision.
     */
    @java.lang.Override
    public int getPrecision() {
      return precision_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Column precision - e.g. 8 as in double (8,2) - when relevant.
     * </pre>
     *
     * <code>int32 precision = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The precision to set.
     * @return This builder for chaining.
     */
    public Builder setPrecision(int value) {

      precision_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Column precision - e.g. 8 as in double (8,2) - when relevant.
     * </pre>
     *
     * <code>int32 precision = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrecision() {
      bitField0_ = (bitField0_ & ~0x00000010);
      precision_ = 0;
      onChanged();
      return this;
    }

    private int scale_;
    /**
     *
     *
     * <pre>
     * Optional. Column scale - e.g. 2 as in double (8,2) - when relevant.
     * </pre>
     *
     * <code>int32 scale = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The scale.
     */
    @java.lang.Override
    public int getScale() {
      return scale_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Column scale - e.g. 2 as in double (8,2) - when relevant.
     * </pre>
     *
     * <code>int32 scale = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The scale to set.
     * @return This builder for chaining.
     */
    public Builder setScale(int value) {

      scale_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Column scale - e.g. 2 as in double (8,2) - when relevant.
     * </pre>
     *
     * <code>int32 scale = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScale() {
      bitField0_ = (bitField0_ & ~0x00000020);
      scale_ = 0;
      onChanged();
      return this;
    }

    private int fractionalSecondsPrecision_;
    /**
     *
     *
     * <pre>
     * Optional. Column fractional seconds precision - e.g. 2 as in timestamp (2)
     * - when relevant.
     * </pre>
     *
     * <code>int32 fractional_seconds_precision = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The fractionalSecondsPrecision.
     */
    @java.lang.Override
    public int getFractionalSecondsPrecision() {
      return fractionalSecondsPrecision_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Column fractional seconds precision - e.g. 2 as in timestamp (2)
     * - when relevant.
     * </pre>
     *
     * <code>int32 fractional_seconds_precision = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The fractionalSecondsPrecision to set.
     * @return This builder for chaining.
     */
    public Builder setFractionalSecondsPrecision(int value) {

      fractionalSecondsPrecision_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Column fractional seconds precision - e.g. 2 as in timestamp (2)
     * - when relevant.
     * </pre>
     *
     * <code>int32 fractional_seconds_precision = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFractionalSecondsPrecision() {
      bitField0_ = (bitField0_ & ~0x00000040);
      fractionalSecondsPrecision_ = 0;
      onChanged();
      return this;
    }

    private boolean array_;
    /**
     *
     *
     * <pre>
     * Optional. Is the column of array type.
     * </pre>
     *
     * <code>bool array = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The array.
     */
    @java.lang.Override
    public boolean getArray() {
      return array_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Is the column of array type.
     * </pre>
     *
     * <code>bool array = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The array to set.
     * @return This builder for chaining.
     */
    public Builder setArray(boolean value) {

      array_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Is the column of array type.
     * </pre>
     *
     * <code>bool array = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArray() {
      bitField0_ = (bitField0_ & ~0x00000080);
      array_ = false;
      onChanged();
      return this;
    }

    private int arrayLength_;
    /**
     *
     *
     * <pre>
     * Optional. The length of the array, only relevant if the column type is an
     * array.
     * </pre>
     *
     * <code>int32 array_length = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The arrayLength.
     */
    @java.lang.Override
    public int getArrayLength() {
      return arrayLength_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The length of the array, only relevant if the column type is an
     * array.
     * </pre>
     *
     * <code>int32 array_length = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The arrayLength to set.
     * @return This builder for chaining.
     */
    public Builder setArrayLength(int value) {

      arrayLength_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The length of the array, only relevant if the column type is an
     * array.
     * </pre>
     *
     * <code>int32 array_length = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArrayLength() {
      bitField0_ = (bitField0_ & ~0x00000100);
      arrayLength_ = 0;
      onChanged();
      return this;
    }

    private boolean nullable_;
    /**
     *
     *
     * <pre>
     * Optional. Is the column nullable.
     * </pre>
     *
     * <code>bool nullable = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The nullable.
     */
    @java.lang.Override
    public boolean getNullable() {
      return nullable_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Is the column nullable.
     * </pre>
     *
     * <code>bool nullable = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The nullable to set.
     * @return This builder for chaining.
     */
    public Builder setNullable(boolean value) {

      nullable_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Is the column nullable.
     * </pre>
     *
     * <code>bool nullable = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNullable() {
      bitField0_ = (bitField0_ & ~0x00000200);
      nullable_ = false;
      onChanged();
      return this;
    }

    private boolean autoGenerated_;
    /**
     *
     *
     * <pre>
     * Optional. Is the column auto-generated/identity.
     * </pre>
     *
     * <code>bool auto_generated = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The autoGenerated.
     */
    @java.lang.Override
    public boolean getAutoGenerated() {
      return autoGenerated_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Is the column auto-generated/identity.
     * </pre>
     *
     * <code>bool auto_generated = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The autoGenerated to set.
     * @return This builder for chaining.
     */
    public Builder setAutoGenerated(boolean value) {

      autoGenerated_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Is the column auto-generated/identity.
     * </pre>
     *
     * <code>bool auto_generated = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutoGenerated() {
      bitField0_ = (bitField0_ & ~0x00000400);
      autoGenerated_ = false;
      onChanged();
      return this;
    }

    private boolean udt_;
    /**
     *
     *
     * <pre>
     * Optional. Is the column a UDT (User-defined Type).
     * </pre>
     *
     * <code>bool udt = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The udt.
     */
    @java.lang.Override
    public boolean getUdt() {
      return udt_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Is the column a UDT (User-defined Type).
     * </pre>
     *
     * <code>bool udt = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The udt to set.
     * @return This builder for chaining.
     */
    public Builder setUdt(boolean value) {

      udt_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Is the column a UDT (User-defined Type).
     * </pre>
     *
     * <code>bool udt = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUdt() {
      bitField0_ = (bitField0_ & ~0x00000800);
      udt_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct customFeatures_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        customFeaturesBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the customFeatures field is set.
     */
    public boolean hasCustomFeatures() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The customFeatures.
     */
    public com.google.protobuf.Struct getCustomFeatures() {
      if (customFeaturesBuilder_ == null) {
        return customFeatures_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : customFeatures_;
      } else {
        return customFeaturesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCustomFeatures(com.google.protobuf.Struct value) {
      if (customFeaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        customFeatures_ = value;
      } else {
        customFeaturesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCustomFeatures(com.google.protobuf.Struct.Builder builderForValue) {
      if (customFeaturesBuilder_ == null) {
        customFeatures_ = builderForValue.build();
      } else {
        customFeaturesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCustomFeatures(com.google.protobuf.Struct value) {
      if (customFeaturesBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && customFeatures_ != null
            && customFeatures_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getCustomFeaturesBuilder().mergeFrom(value);
        } else {
          customFeatures_ = value;
        }
      } else {
        customFeaturesBuilder_.mergeFrom(value);
      }
      if (customFeatures_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCustomFeatures() {
      bitField0_ = (bitField0_ & ~0x00001000);
      customFeatures_ = null;
      if (customFeaturesBuilder_ != null) {
        customFeaturesBuilder_.dispose();
        customFeaturesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Struct.Builder getCustomFeaturesBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getCustomFeaturesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.StructOrBuilder getCustomFeaturesOrBuilder() {
      if (customFeaturesBuilder_ != null) {
        return customFeaturesBuilder_.getMessageOrBuilder();
      } else {
        return customFeatures_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : customFeatures_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getCustomFeaturesFieldBuilder() {
      if (customFeaturesBuilder_ == null) {
        customFeaturesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getCustomFeatures(), getParentForChildren(), isClean());
        customFeatures_ = null;
      }
      return customFeaturesBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList setValues_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSetValuesIsMutable() {
      if (!setValues_.isModifiable()) {
        setValues_ = new com.google.protobuf.LazyStringArrayList(setValues_);
      }
      bitField0_ |= 0x00002000;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the list of values allowed in the column.
     * </pre>
     *
     * <code>repeated string set_values = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the setValues.
     */
    public com.google.protobuf.ProtocolStringList getSetValuesList() {
      setValues_.makeImmutable();
      return setValues_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the list of values allowed in the column.
     * </pre>
     *
     * <code>repeated string set_values = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of setValues.
     */
    public int getSetValuesCount() {
      return setValues_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the list of values allowed in the column.
     * </pre>
     *
     * <code>repeated string set_values = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The setValues at the given index.
     */
    public java.lang.String getSetValues(int index) {
      return setValues_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the list of values allowed in the column.
     * </pre>
     *
     * <code>repeated string set_values = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the setValues at the given index.
     */
    public com.google.protobuf.ByteString getSetValuesBytes(int index) {
      return setValues_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the list of values allowed in the column.
     * </pre>
     *
     * <code>repeated string set_values = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The setValues to set.
     * @return This builder for chaining.
     */
    public Builder setSetValues(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSetValuesIsMutable();
      setValues_.set(index, value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the list of values allowed in the column.
     * </pre>
     *
     * <code>repeated string set_values = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The setValues to add.
     * @return This builder for chaining.
     */
    public Builder addSetValues(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSetValuesIsMutable();
      setValues_.add(value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the list of values allowed in the column.
     * </pre>
     *
     * <code>repeated string set_values = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The setValues to add.
     * @return This builder for chaining.
     */
    public Builder addAllSetValues(java.lang.Iterable<java.lang.String> values) {
      ensureSetValuesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, setValues_);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the list of values allowed in the column.
     * </pre>
     *
     * <code>repeated string set_values = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSetValues() {
      setValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00002000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the list of values allowed in the column.
     * </pre>
     *
     * <code>repeated string set_values = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the setValues to add.
     * @return This builder for chaining.
     */
    public Builder addSetValuesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSetValuesIsMutable();
      setValues_.add(value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object comment_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Comment associated with the column.
     * </pre>
     *
     * <code>string comment = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The comment.
     */
    public java.lang.String getComment() {
      java.lang.Object ref = comment_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        comment_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Comment associated with the column.
     * </pre>
     *
     * <code>string comment = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for comment.
     */
    public com.google.protobuf.ByteString getCommentBytes() {
      java.lang.Object ref = comment_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        comment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Comment associated with the column.
     * </pre>
     *
     * <code>string comment = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The comment to set.
     * @return This builder for chaining.
     */
    public Builder setComment(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      comment_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Comment associated with the column.
     * </pre>
     *
     * <code>string comment = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearComment() {
      comment_ = getDefaultInstance().getComment();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Comment associated with the column.
     * </pre>
     *
     * <code>string comment = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for comment to set.
     * @return This builder for chaining.
     */
    public Builder setCommentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      comment_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.SingleColumnChange)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.SingleColumnChange)
  private static final com.google.cloud.clouddms.v1.SingleColumnChange DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.SingleColumnChange();
  }

  public static com.google.cloud.clouddms.v1.SingleColumnChange getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SingleColumnChange> PARSER =
      new com.google.protobuf.AbstractParser<SingleColumnChange>() {
        @java.lang.Override
        public SingleColumnChange parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SingleColumnChange> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SingleColumnChange> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.SingleColumnChange getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
