/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/clouddms_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * IP Management configuration.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.SqlIpConfig}
 */
public final class SqlIpConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.SqlIpConfig)
    SqlIpConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SqlIpConfig.newBuilder() to construct.
  private SqlIpConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SqlIpConfig() {
    privateNetwork_ = "";
    allocatedIpRange_ = "";
    authorizedNetworks_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SqlIpConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
        .internal_static_google_cloud_clouddms_v1_SqlIpConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
        .internal_static_google_cloud_clouddms_v1_SqlIpConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.SqlIpConfig.class,
            com.google.cloud.clouddms.v1.SqlIpConfig.Builder.class);
  }

  private int bitField0_;
  public static final int ENABLE_IPV4_FIELD_NUMBER = 1;
  private com.google.protobuf.BoolValue enableIpv4_;
  /**
   *
   *
   * <pre>
   * Whether the instance should be assigned an IPv4 address or not.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue enable_ipv4 = 1;</code>
   *
   * @return Whether the enableIpv4 field is set.
   */
  @java.lang.Override
  public boolean hasEnableIpv4() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Whether the instance should be assigned an IPv4 address or not.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue enable_ipv4 = 1;</code>
   *
   * @return The enableIpv4.
   */
  @java.lang.Override
  public com.google.protobuf.BoolValue getEnableIpv4() {
    return enableIpv4_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : enableIpv4_;
  }
  /**
   *
   *
   * <pre>
   * Whether the instance should be assigned an IPv4 address or not.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue enable_ipv4 = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.BoolValueOrBuilder getEnableIpv4OrBuilder() {
    return enableIpv4_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : enableIpv4_;
  }

  public static final int PRIVATE_NETWORK_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object privateNetwork_ = "";
  /**
   *
   *
   * <pre>
   * The resource link for the VPC network from which the Cloud SQL instance is
   * accessible for private IP. For example,
   * `projects/myProject/global/networks/default`. This setting can
   * be updated, but it cannot be removed after it is set.
   * </pre>
   *
   * <code>string private_network = 2;</code>
   *
   * @return The privateNetwork.
   */
  @java.lang.Override
  public java.lang.String getPrivateNetwork() {
    java.lang.Object ref = privateNetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      privateNetwork_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource link for the VPC network from which the Cloud SQL instance is
   * accessible for private IP. For example,
   * `projects/myProject/global/networks/default`. This setting can
   * be updated, but it cannot be removed after it is set.
   * </pre>
   *
   * <code>string private_network = 2;</code>
   *
   * @return The bytes for privateNetwork.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrivateNetworkBytes() {
    java.lang.Object ref = privateNetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      privateNetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALLOCATED_IP_RANGE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object allocatedIpRange_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The name of the allocated IP address range for the private IP
   * Cloud SQL instance. This name refers to an already allocated IP range
   * address. If set, the instance IP address will be created in the allocated
   * range. Note that this IP address range can't be modified after the instance
   * is created. If you change the VPC when configuring connectivity settings
   * for the migration job, this field is not relevant.
   * </pre>
   *
   * <code>string allocated_ip_range = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The allocatedIpRange.
   */
  @java.lang.Override
  public java.lang.String getAllocatedIpRange() {
    java.lang.Object ref = allocatedIpRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      allocatedIpRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of the allocated IP address range for the private IP
   * Cloud SQL instance. This name refers to an already allocated IP range
   * address. If set, the instance IP address will be created in the allocated
   * range. Note that this IP address range can't be modified after the instance
   * is created. If you change the VPC when configuring connectivity settings
   * for the migration job, this field is not relevant.
   * </pre>
   *
   * <code>string allocated_ip_range = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for allocatedIpRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAllocatedIpRangeBytes() {
    java.lang.Object ref = allocatedIpRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      allocatedIpRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUIRE_SSL_FIELD_NUMBER = 3;
  private com.google.protobuf.BoolValue requireSsl_;
  /**
   *
   *
   * <pre>
   * Whether SSL connections over IP should be enforced or not.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue require_ssl = 3;</code>
   *
   * @return Whether the requireSsl field is set.
   */
  @java.lang.Override
  public boolean hasRequireSsl() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Whether SSL connections over IP should be enforced or not.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue require_ssl = 3;</code>
   *
   * @return The requireSsl.
   */
  @java.lang.Override
  public com.google.protobuf.BoolValue getRequireSsl() {
    return requireSsl_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : requireSsl_;
  }
  /**
   *
   *
   * <pre>
   * Whether SSL connections over IP should be enforced or not.
   * </pre>
   *
   * <code>.google.protobuf.BoolValue require_ssl = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.BoolValueOrBuilder getRequireSslOrBuilder() {
    return requireSsl_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : requireSsl_;
  }

  public static final int AUTHORIZED_NETWORKS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.clouddms.v1.SqlAclEntry> authorizedNetworks_;
  /**
   *
   *
   * <pre>
   * The list of external networks that are allowed to connect to the instance
   * using the IP. See
   * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
   * 'slash' notation (e.g. `192.168.100.0/24`).
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.clouddms.v1.SqlAclEntry> getAuthorizedNetworksList() {
    return authorizedNetworks_;
  }
  /**
   *
   *
   * <pre>
   * The list of external networks that are allowed to connect to the instance
   * using the IP. See
   * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
   * 'slash' notation (e.g. `192.168.100.0/24`).
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.clouddms.v1.SqlAclEntryOrBuilder>
      getAuthorizedNetworksOrBuilderList() {
    return authorizedNetworks_;
  }
  /**
   *
   *
   * <pre>
   * The list of external networks that are allowed to connect to the instance
   * using the IP. See
   * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
   * 'slash' notation (e.g. `192.168.100.0/24`).
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
   */
  @java.lang.Override
  public int getAuthorizedNetworksCount() {
    return authorizedNetworks_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of external networks that are allowed to connect to the instance
   * using the IP. See
   * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
   * 'slash' notation (e.g. `192.168.100.0/24`).
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SqlAclEntry getAuthorizedNetworks(int index) {
    return authorizedNetworks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of external networks that are allowed to connect to the instance
   * using the IP. See
   * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
   * 'slash' notation (e.g. `192.168.100.0/24`).
   * </pre>
   *
   * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SqlAclEntryOrBuilder getAuthorizedNetworksOrBuilder(
      int index) {
    return authorizedNetworks_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getEnableIpv4());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(privateNetwork_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, privateNetwork_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getRequireSsl());
    }
    for (int i = 0; i < authorizedNetworks_.size(); i++) {
      output.writeMessage(4, authorizedNetworks_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(allocatedIpRange_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, allocatedIpRange_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEnableIpv4());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(privateNetwork_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, privateNetwork_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRequireSsl());
    }
    for (int i = 0; i < authorizedNetworks_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, authorizedNetworks_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(allocatedIpRange_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, allocatedIpRange_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.SqlIpConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.SqlIpConfig other = (com.google.cloud.clouddms.v1.SqlIpConfig) obj;

    if (hasEnableIpv4() != other.hasEnableIpv4()) return false;
    if (hasEnableIpv4()) {
      if (!getEnableIpv4().equals(other.getEnableIpv4())) return false;
    }
    if (!getPrivateNetwork().equals(other.getPrivateNetwork())) return false;
    if (!getAllocatedIpRange().equals(other.getAllocatedIpRange())) return false;
    if (hasRequireSsl() != other.hasRequireSsl()) return false;
    if (hasRequireSsl()) {
      if (!getRequireSsl().equals(other.getRequireSsl())) return false;
    }
    if (!getAuthorizedNetworksList().equals(other.getAuthorizedNetworksList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasEnableIpv4()) {
      hash = (37 * hash) + ENABLE_IPV4_FIELD_NUMBER;
      hash = (53 * hash) + getEnableIpv4().hashCode();
    }
    hash = (37 * hash) + PRIVATE_NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getPrivateNetwork().hashCode();
    hash = (37 * hash) + ALLOCATED_IP_RANGE_FIELD_NUMBER;
    hash = (53 * hash) + getAllocatedIpRange().hashCode();
    if (hasRequireSsl()) {
      hash = (37 * hash) + REQUIRE_SSL_FIELD_NUMBER;
      hash = (53 * hash) + getRequireSsl().hashCode();
    }
    if (getAuthorizedNetworksCount() > 0) {
      hash = (37 * hash) + AUTHORIZED_NETWORKS_FIELD_NUMBER;
      hash = (53 * hash) + getAuthorizedNetworksList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.SqlIpConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.SqlIpConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.SqlIpConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.SqlIpConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.SqlIpConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.SqlIpConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.SqlIpConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.SqlIpConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.SqlIpConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.SqlIpConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.SqlIpConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.SqlIpConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.SqlIpConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * IP Management configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.SqlIpConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.SqlIpConfig)
      com.google.cloud.clouddms.v1.SqlIpConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_SqlIpConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_SqlIpConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.SqlIpConfig.class,
              com.google.cloud.clouddms.v1.SqlIpConfig.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.SqlIpConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEnableIpv4FieldBuilder();
        getRequireSslFieldBuilder();
        getAuthorizedNetworksFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      enableIpv4_ = null;
      if (enableIpv4Builder_ != null) {
        enableIpv4Builder_.dispose();
        enableIpv4Builder_ = null;
      }
      privateNetwork_ = "";
      allocatedIpRange_ = "";
      requireSsl_ = null;
      if (requireSslBuilder_ != null) {
        requireSslBuilder_.dispose();
        requireSslBuilder_ = null;
      }
      if (authorizedNetworksBuilder_ == null) {
        authorizedNetworks_ = java.util.Collections.emptyList();
      } else {
        authorizedNetworks_ = null;
        authorizedNetworksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_SqlIpConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.SqlIpConfig getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.SqlIpConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.SqlIpConfig build() {
      com.google.cloud.clouddms.v1.SqlIpConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.SqlIpConfig buildPartial() {
      com.google.cloud.clouddms.v1.SqlIpConfig result =
          new com.google.cloud.clouddms.v1.SqlIpConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.clouddms.v1.SqlIpConfig result) {
      if (authorizedNetworksBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          authorizedNetworks_ = java.util.Collections.unmodifiableList(authorizedNetworks_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.authorizedNetworks_ = authorizedNetworks_;
      } else {
        result.authorizedNetworks_ = authorizedNetworksBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.SqlIpConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.enableIpv4_ = enableIpv4Builder_ == null ? enableIpv4_ : enableIpv4Builder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.privateNetwork_ = privateNetwork_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.allocatedIpRange_ = allocatedIpRange_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.requireSsl_ = requireSslBuilder_ == null ? requireSsl_ : requireSslBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.SqlIpConfig) {
        return mergeFrom((com.google.cloud.clouddms.v1.SqlIpConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.SqlIpConfig other) {
      if (other == com.google.cloud.clouddms.v1.SqlIpConfig.getDefaultInstance()) return this;
      if (other.hasEnableIpv4()) {
        mergeEnableIpv4(other.getEnableIpv4());
      }
      if (!other.getPrivateNetwork().isEmpty()) {
        privateNetwork_ = other.privateNetwork_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getAllocatedIpRange().isEmpty()) {
        allocatedIpRange_ = other.allocatedIpRange_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasRequireSsl()) {
        mergeRequireSsl(other.getRequireSsl());
      }
      if (authorizedNetworksBuilder_ == null) {
        if (!other.authorizedNetworks_.isEmpty()) {
          if (authorizedNetworks_.isEmpty()) {
            authorizedNetworks_ = other.authorizedNetworks_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureAuthorizedNetworksIsMutable();
            authorizedNetworks_.addAll(other.authorizedNetworks_);
          }
          onChanged();
        }
      } else {
        if (!other.authorizedNetworks_.isEmpty()) {
          if (authorizedNetworksBuilder_.isEmpty()) {
            authorizedNetworksBuilder_.dispose();
            authorizedNetworksBuilder_ = null;
            authorizedNetworks_ = other.authorizedNetworks_;
            bitField0_ = (bitField0_ & ~0x00000010);
            authorizedNetworksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAuthorizedNetworksFieldBuilder()
                    : null;
          } else {
            authorizedNetworksBuilder_.addAllMessages(other.authorizedNetworks_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getEnableIpv4FieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                privateNetwork_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getRequireSslFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.clouddms.v1.SqlAclEntry m =
                    input.readMessage(
                        com.google.cloud.clouddms.v1.SqlAclEntry.parser(), extensionRegistry);
                if (authorizedNetworksBuilder_ == null) {
                  ensureAuthorizedNetworksIsMutable();
                  authorizedNetworks_.add(m);
                } else {
                  authorizedNetworksBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                allocatedIpRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.BoolValue enableIpv4_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.BoolValue,
            com.google.protobuf.BoolValue.Builder,
            com.google.protobuf.BoolValueOrBuilder>
        enableIpv4Builder_;
    /**
     *
     *
     * <pre>
     * Whether the instance should be assigned an IPv4 address or not.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enable_ipv4 = 1;</code>
     *
     * @return Whether the enableIpv4 field is set.
     */
    public boolean hasEnableIpv4() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Whether the instance should be assigned an IPv4 address or not.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enable_ipv4 = 1;</code>
     *
     * @return The enableIpv4.
     */
    public com.google.protobuf.BoolValue getEnableIpv4() {
      if (enableIpv4Builder_ == null) {
        return enableIpv4_ == null
            ? com.google.protobuf.BoolValue.getDefaultInstance()
            : enableIpv4_;
      } else {
        return enableIpv4Builder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Whether the instance should be assigned an IPv4 address or not.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enable_ipv4 = 1;</code>
     */
    public Builder setEnableIpv4(com.google.protobuf.BoolValue value) {
      if (enableIpv4Builder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        enableIpv4_ = value;
      } else {
        enableIpv4Builder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the instance should be assigned an IPv4 address or not.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enable_ipv4 = 1;</code>
     */
    public Builder setEnableIpv4(com.google.protobuf.BoolValue.Builder builderForValue) {
      if (enableIpv4Builder_ == null) {
        enableIpv4_ = builderForValue.build();
      } else {
        enableIpv4Builder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the instance should be assigned an IPv4 address or not.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enable_ipv4 = 1;</code>
     */
    public Builder mergeEnableIpv4(com.google.protobuf.BoolValue value) {
      if (enableIpv4Builder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && enableIpv4_ != null
            && enableIpv4_ != com.google.protobuf.BoolValue.getDefaultInstance()) {
          getEnableIpv4Builder().mergeFrom(value);
        } else {
          enableIpv4_ = value;
        }
      } else {
        enableIpv4Builder_.mergeFrom(value);
      }
      if (enableIpv4_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the instance should be assigned an IPv4 address or not.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enable_ipv4 = 1;</code>
     */
    public Builder clearEnableIpv4() {
      bitField0_ = (bitField0_ & ~0x00000001);
      enableIpv4_ = null;
      if (enableIpv4Builder_ != null) {
        enableIpv4Builder_.dispose();
        enableIpv4Builder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the instance should be assigned an IPv4 address or not.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enable_ipv4 = 1;</code>
     */
    public com.google.protobuf.BoolValue.Builder getEnableIpv4Builder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getEnableIpv4FieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Whether the instance should be assigned an IPv4 address or not.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enable_ipv4 = 1;</code>
     */
    public com.google.protobuf.BoolValueOrBuilder getEnableIpv4OrBuilder() {
      if (enableIpv4Builder_ != null) {
        return enableIpv4Builder_.getMessageOrBuilder();
      } else {
        return enableIpv4_ == null
            ? com.google.protobuf.BoolValue.getDefaultInstance()
            : enableIpv4_;
      }
    }
    /**
     *
     *
     * <pre>
     * Whether the instance should be assigned an IPv4 address or not.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue enable_ipv4 = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.BoolValue,
            com.google.protobuf.BoolValue.Builder,
            com.google.protobuf.BoolValueOrBuilder>
        getEnableIpv4FieldBuilder() {
      if (enableIpv4Builder_ == null) {
        enableIpv4Builder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.BoolValue,
                com.google.protobuf.BoolValue.Builder,
                com.google.protobuf.BoolValueOrBuilder>(
                getEnableIpv4(), getParentForChildren(), isClean());
        enableIpv4_ = null;
      }
      return enableIpv4Builder_;
    }

    private java.lang.Object privateNetwork_ = "";
    /**
     *
     *
     * <pre>
     * The resource link for the VPC network from which the Cloud SQL instance is
     * accessible for private IP. For example,
     * `projects/myProject/global/networks/default`. This setting can
     * be updated, but it cannot be removed after it is set.
     * </pre>
     *
     * <code>string private_network = 2;</code>
     *
     * @return The privateNetwork.
     */
    public java.lang.String getPrivateNetwork() {
      java.lang.Object ref = privateNetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        privateNetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource link for the VPC network from which the Cloud SQL instance is
     * accessible for private IP. For example,
     * `projects/myProject/global/networks/default`. This setting can
     * be updated, but it cannot be removed after it is set.
     * </pre>
     *
     * <code>string private_network = 2;</code>
     *
     * @return The bytes for privateNetwork.
     */
    public com.google.protobuf.ByteString getPrivateNetworkBytes() {
      java.lang.Object ref = privateNetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        privateNetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource link for the VPC network from which the Cloud SQL instance is
     * accessible for private IP. For example,
     * `projects/myProject/global/networks/default`. This setting can
     * be updated, but it cannot be removed after it is set.
     * </pre>
     *
     * <code>string private_network = 2;</code>
     *
     * @param value The privateNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      privateNetwork_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource link for the VPC network from which the Cloud SQL instance is
     * accessible for private IP. For example,
     * `projects/myProject/global/networks/default`. This setting can
     * be updated, but it cannot be removed after it is set.
     * </pre>
     *
     * <code>string private_network = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrivateNetwork() {
      privateNetwork_ = getDefaultInstance().getPrivateNetwork();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource link for the VPC network from which the Cloud SQL instance is
     * accessible for private IP. For example,
     * `projects/myProject/global/networks/default`. This setting can
     * be updated, but it cannot be removed after it is set.
     * </pre>
     *
     * <code>string private_network = 2;</code>
     *
     * @param value The bytes for privateNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      privateNetwork_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object allocatedIpRange_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The name of the allocated IP address range for the private IP
     * Cloud SQL instance. This name refers to an already allocated IP range
     * address. If set, the instance IP address will be created in the allocated
     * range. Note that this IP address range can't be modified after the instance
     * is created. If you change the VPC when configuring connectivity settings
     * for the migration job, this field is not relevant.
     * </pre>
     *
     * <code>string allocated_ip_range = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The allocatedIpRange.
     */
    public java.lang.String getAllocatedIpRange() {
      java.lang.Object ref = allocatedIpRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        allocatedIpRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the allocated IP address range for the private IP
     * Cloud SQL instance. This name refers to an already allocated IP range
     * address. If set, the instance IP address will be created in the allocated
     * range. Note that this IP address range can't be modified after the instance
     * is created. If you change the VPC when configuring connectivity settings
     * for the migration job, this field is not relevant.
     * </pre>
     *
     * <code>string allocated_ip_range = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for allocatedIpRange.
     */
    public com.google.protobuf.ByteString getAllocatedIpRangeBytes() {
      java.lang.Object ref = allocatedIpRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        allocatedIpRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the allocated IP address range for the private IP
     * Cloud SQL instance. This name refers to an already allocated IP range
     * address. If set, the instance IP address will be created in the allocated
     * range. Note that this IP address range can't be modified after the instance
     * is created. If you change the VPC when configuring connectivity settings
     * for the migration job, this field is not relevant.
     * </pre>
     *
     * <code>string allocated_ip_range = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The allocatedIpRange to set.
     * @return This builder for chaining.
     */
    public Builder setAllocatedIpRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      allocatedIpRange_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the allocated IP address range for the private IP
     * Cloud SQL instance. This name refers to an already allocated IP range
     * address. If set, the instance IP address will be created in the allocated
     * range. Note that this IP address range can't be modified after the instance
     * is created. If you change the VPC when configuring connectivity settings
     * for the migration job, this field is not relevant.
     * </pre>
     *
     * <code>string allocated_ip_range = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllocatedIpRange() {
      allocatedIpRange_ = getDefaultInstance().getAllocatedIpRange();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the allocated IP address range for the private IP
     * Cloud SQL instance. This name refers to an already allocated IP range
     * address. If set, the instance IP address will be created in the allocated
     * range. Note that this IP address range can't be modified after the instance
     * is created. If you change the VPC when configuring connectivity settings
     * for the migration job, this field is not relevant.
     * </pre>
     *
     * <code>string allocated_ip_range = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for allocatedIpRange to set.
     * @return This builder for chaining.
     */
    public Builder setAllocatedIpRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      allocatedIpRange_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.BoolValue requireSsl_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.BoolValue,
            com.google.protobuf.BoolValue.Builder,
            com.google.protobuf.BoolValueOrBuilder>
        requireSslBuilder_;
    /**
     *
     *
     * <pre>
     * Whether SSL connections over IP should be enforced or not.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue require_ssl = 3;</code>
     *
     * @return Whether the requireSsl field is set.
     */
    public boolean hasRequireSsl() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Whether SSL connections over IP should be enforced or not.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue require_ssl = 3;</code>
     *
     * @return The requireSsl.
     */
    public com.google.protobuf.BoolValue getRequireSsl() {
      if (requireSslBuilder_ == null) {
        return requireSsl_ == null
            ? com.google.protobuf.BoolValue.getDefaultInstance()
            : requireSsl_;
      } else {
        return requireSslBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Whether SSL connections over IP should be enforced or not.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue require_ssl = 3;</code>
     */
    public Builder setRequireSsl(com.google.protobuf.BoolValue value) {
      if (requireSslBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requireSsl_ = value;
      } else {
        requireSslBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether SSL connections over IP should be enforced or not.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue require_ssl = 3;</code>
     */
    public Builder setRequireSsl(com.google.protobuf.BoolValue.Builder builderForValue) {
      if (requireSslBuilder_ == null) {
        requireSsl_ = builderForValue.build();
      } else {
        requireSslBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether SSL connections over IP should be enforced or not.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue require_ssl = 3;</code>
     */
    public Builder mergeRequireSsl(com.google.protobuf.BoolValue value) {
      if (requireSslBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && requireSsl_ != null
            && requireSsl_ != com.google.protobuf.BoolValue.getDefaultInstance()) {
          getRequireSslBuilder().mergeFrom(value);
        } else {
          requireSsl_ = value;
        }
      } else {
        requireSslBuilder_.mergeFrom(value);
      }
      if (requireSsl_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether SSL connections over IP should be enforced or not.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue require_ssl = 3;</code>
     */
    public Builder clearRequireSsl() {
      bitField0_ = (bitField0_ & ~0x00000008);
      requireSsl_ = null;
      if (requireSslBuilder_ != null) {
        requireSslBuilder_.dispose();
        requireSslBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether SSL connections over IP should be enforced or not.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue require_ssl = 3;</code>
     */
    public com.google.protobuf.BoolValue.Builder getRequireSslBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRequireSslFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Whether SSL connections over IP should be enforced or not.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue require_ssl = 3;</code>
     */
    public com.google.protobuf.BoolValueOrBuilder getRequireSslOrBuilder() {
      if (requireSslBuilder_ != null) {
        return requireSslBuilder_.getMessageOrBuilder();
      } else {
        return requireSsl_ == null
            ? com.google.protobuf.BoolValue.getDefaultInstance()
            : requireSsl_;
      }
    }
    /**
     *
     *
     * <pre>
     * Whether SSL connections over IP should be enforced or not.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue require_ssl = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.BoolValue,
            com.google.protobuf.BoolValue.Builder,
            com.google.protobuf.BoolValueOrBuilder>
        getRequireSslFieldBuilder() {
      if (requireSslBuilder_ == null) {
        requireSslBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.BoolValue,
                com.google.protobuf.BoolValue.Builder,
                com.google.protobuf.BoolValueOrBuilder>(
                getRequireSsl(), getParentForChildren(), isClean());
        requireSsl_ = null;
      }
      return requireSslBuilder_;
    }

    private java.util.List<com.google.cloud.clouddms.v1.SqlAclEntry> authorizedNetworks_ =
        java.util.Collections.emptyList();

    private void ensureAuthorizedNetworksIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        authorizedNetworks_ =
            new java.util.ArrayList<com.google.cloud.clouddms.v1.SqlAclEntry>(authorizedNetworks_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.clouddms.v1.SqlAclEntry,
            com.google.cloud.clouddms.v1.SqlAclEntry.Builder,
            com.google.cloud.clouddms.v1.SqlAclEntryOrBuilder>
        authorizedNetworksBuilder_;

    /**
     *
     *
     * <pre>
     * The list of external networks that are allowed to connect to the instance
     * using the IP. See
     * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
     * 'slash' notation (e.g. `192.168.100.0/24`).
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
     */
    public java.util.List<com.google.cloud.clouddms.v1.SqlAclEntry> getAuthorizedNetworksList() {
      if (authorizedNetworksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(authorizedNetworks_);
      } else {
        return authorizedNetworksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of external networks that are allowed to connect to the instance
     * using the IP. See
     * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
     * 'slash' notation (e.g. `192.168.100.0/24`).
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
     */
    public int getAuthorizedNetworksCount() {
      if (authorizedNetworksBuilder_ == null) {
        return authorizedNetworks_.size();
      } else {
        return authorizedNetworksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of external networks that are allowed to connect to the instance
     * using the IP. See
     * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
     * 'slash' notation (e.g. `192.168.100.0/24`).
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
     */
    public com.google.cloud.clouddms.v1.SqlAclEntry getAuthorizedNetworks(int index) {
      if (authorizedNetworksBuilder_ == null) {
        return authorizedNetworks_.get(index);
      } else {
        return authorizedNetworksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of external networks that are allowed to connect to the instance
     * using the IP. See
     * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
     * 'slash' notation (e.g. `192.168.100.0/24`).
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
     */
    public Builder setAuthorizedNetworks(
        int index, com.google.cloud.clouddms.v1.SqlAclEntry value) {
      if (authorizedNetworksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAuthorizedNetworksIsMutable();
        authorizedNetworks_.set(index, value);
        onChanged();
      } else {
        authorizedNetworksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of external networks that are allowed to connect to the instance
     * using the IP. See
     * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
     * 'slash' notation (e.g. `192.168.100.0/24`).
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
     */
    public Builder setAuthorizedNetworks(
        int index, com.google.cloud.clouddms.v1.SqlAclEntry.Builder builderForValue) {
      if (authorizedNetworksBuilder_ == null) {
        ensureAuthorizedNetworksIsMutable();
        authorizedNetworks_.set(index, builderForValue.build());
        onChanged();
      } else {
        authorizedNetworksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of external networks that are allowed to connect to the instance
     * using the IP. See
     * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
     * 'slash' notation (e.g. `192.168.100.0/24`).
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
     */
    public Builder addAuthorizedNetworks(com.google.cloud.clouddms.v1.SqlAclEntry value) {
      if (authorizedNetworksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAuthorizedNetworksIsMutable();
        authorizedNetworks_.add(value);
        onChanged();
      } else {
        authorizedNetworksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of external networks that are allowed to connect to the instance
     * using the IP. See
     * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
     * 'slash' notation (e.g. `192.168.100.0/24`).
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
     */
    public Builder addAuthorizedNetworks(
        int index, com.google.cloud.clouddms.v1.SqlAclEntry value) {
      if (authorizedNetworksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAuthorizedNetworksIsMutable();
        authorizedNetworks_.add(index, value);
        onChanged();
      } else {
        authorizedNetworksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of external networks that are allowed to connect to the instance
     * using the IP. See
     * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
     * 'slash' notation (e.g. `192.168.100.0/24`).
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
     */
    public Builder addAuthorizedNetworks(
        com.google.cloud.clouddms.v1.SqlAclEntry.Builder builderForValue) {
      if (authorizedNetworksBuilder_ == null) {
        ensureAuthorizedNetworksIsMutable();
        authorizedNetworks_.add(builderForValue.build());
        onChanged();
      } else {
        authorizedNetworksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of external networks that are allowed to connect to the instance
     * using the IP. See
     * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
     * 'slash' notation (e.g. `192.168.100.0/24`).
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
     */
    public Builder addAuthorizedNetworks(
        int index, com.google.cloud.clouddms.v1.SqlAclEntry.Builder builderForValue) {
      if (authorizedNetworksBuilder_ == null) {
        ensureAuthorizedNetworksIsMutable();
        authorizedNetworks_.add(index, builderForValue.build());
        onChanged();
      } else {
        authorizedNetworksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of external networks that are allowed to connect to the instance
     * using the IP. See
     * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
     * 'slash' notation (e.g. `192.168.100.0/24`).
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
     */
    public Builder addAllAuthorizedNetworks(
        java.lang.Iterable<? extends com.google.cloud.clouddms.v1.SqlAclEntry> values) {
      if (authorizedNetworksBuilder_ == null) {
        ensureAuthorizedNetworksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, authorizedNetworks_);
        onChanged();
      } else {
        authorizedNetworksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of external networks that are allowed to connect to the instance
     * using the IP. See
     * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
     * 'slash' notation (e.g. `192.168.100.0/24`).
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
     */
    public Builder clearAuthorizedNetworks() {
      if (authorizedNetworksBuilder_ == null) {
        authorizedNetworks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        authorizedNetworksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of external networks that are allowed to connect to the instance
     * using the IP. See
     * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
     * 'slash' notation (e.g. `192.168.100.0/24`).
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
     */
    public Builder removeAuthorizedNetworks(int index) {
      if (authorizedNetworksBuilder_ == null) {
        ensureAuthorizedNetworksIsMutable();
        authorizedNetworks_.remove(index);
        onChanged();
      } else {
        authorizedNetworksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of external networks that are allowed to connect to the instance
     * using the IP. See
     * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
     * 'slash' notation (e.g. `192.168.100.0/24`).
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
     */
    public com.google.cloud.clouddms.v1.SqlAclEntry.Builder getAuthorizedNetworksBuilder(
        int index) {
      return getAuthorizedNetworksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of external networks that are allowed to connect to the instance
     * using the IP. See
     * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
     * 'slash' notation (e.g. `192.168.100.0/24`).
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
     */
    public com.google.cloud.clouddms.v1.SqlAclEntryOrBuilder getAuthorizedNetworksOrBuilder(
        int index) {
      if (authorizedNetworksBuilder_ == null) {
        return authorizedNetworks_.get(index);
      } else {
        return authorizedNetworksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of external networks that are allowed to connect to the instance
     * using the IP. See
     * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
     * 'slash' notation (e.g. `192.168.100.0/24`).
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.clouddms.v1.SqlAclEntryOrBuilder>
        getAuthorizedNetworksOrBuilderList() {
      if (authorizedNetworksBuilder_ != null) {
        return authorizedNetworksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(authorizedNetworks_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of external networks that are allowed to connect to the instance
     * using the IP. See
     * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
     * 'slash' notation (e.g. `192.168.100.0/24`).
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
     */
    public com.google.cloud.clouddms.v1.SqlAclEntry.Builder addAuthorizedNetworksBuilder() {
      return getAuthorizedNetworksFieldBuilder()
          .addBuilder(com.google.cloud.clouddms.v1.SqlAclEntry.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of external networks that are allowed to connect to the instance
     * using the IP. See
     * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
     * 'slash' notation (e.g. `192.168.100.0/24`).
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
     */
    public com.google.cloud.clouddms.v1.SqlAclEntry.Builder addAuthorizedNetworksBuilder(
        int index) {
      return getAuthorizedNetworksFieldBuilder()
          .addBuilder(index, com.google.cloud.clouddms.v1.SqlAclEntry.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of external networks that are allowed to connect to the instance
     * using the IP. See
     * https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
     * 'slash' notation (e.g. `192.168.100.0/24`).
     * </pre>
     *
     * <code>repeated .google.cloud.clouddms.v1.SqlAclEntry authorized_networks = 4;</code>
     */
    public java.util.List<com.google.cloud.clouddms.v1.SqlAclEntry.Builder>
        getAuthorizedNetworksBuilderList() {
      return getAuthorizedNetworksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.clouddms.v1.SqlAclEntry,
            com.google.cloud.clouddms.v1.SqlAclEntry.Builder,
            com.google.cloud.clouddms.v1.SqlAclEntryOrBuilder>
        getAuthorizedNetworksFieldBuilder() {
      if (authorizedNetworksBuilder_ == null) {
        authorizedNetworksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.clouddms.v1.SqlAclEntry,
                com.google.cloud.clouddms.v1.SqlAclEntry.Builder,
                com.google.cloud.clouddms.v1.SqlAclEntryOrBuilder>(
                authorizedNetworks_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        authorizedNetworks_ = null;
      }
      return authorizedNetworksBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.SqlIpConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.SqlIpConfig)
  private static final com.google.cloud.clouddms.v1.SqlIpConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.SqlIpConfig();
  }

  public static com.google.cloud.clouddms.v1.SqlIpConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SqlIpConfig> PARSER =
      new com.google.protobuf.AbstractParser<SqlIpConfig>() {
        @java.lang.Override
        public SqlIpConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SqlIpConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SqlIpConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.SqlIpConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
