/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/clouddms_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * SSL configuration information.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.SslConfig}
 */
public final class SslConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.SslConfig)
    SslConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SslConfig.newBuilder() to construct.
  private SslConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SslConfig() {
    type_ = 0;
    clientKey_ = "";
    clientCertificate_ = "";
    caCertificate_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SslConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
        .internal_static_google_cloud_clouddms_v1_SslConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
        .internal_static_google_cloud_clouddms_v1_SslConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.SslConfig.class,
            com.google.cloud.clouddms.v1.SslConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies The kind of ssl configuration used.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.clouddms.v1.SslConfig.SslType}
   */
  public enum SslType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>SSL_TYPE_UNSPECIFIED = 0;</code>
     */
    SSL_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Only 'ca_certificate' specified.
     * </pre>
     *
     * <code>SERVER_ONLY = 1;</code>
     */
    SERVER_ONLY(1),
    /**
     *
     *
     * <pre>
     * Both server ('ca_certificate'), and client ('client_key',
     * 'client_certificate') specified.
     * </pre>
     *
     * <code>SERVER_CLIENT = 2;</code>
     */
    SERVER_CLIENT(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>SSL_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int SSL_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Only 'ca_certificate' specified.
     * </pre>
     *
     * <code>SERVER_ONLY = 1;</code>
     */
    public static final int SERVER_ONLY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Both server ('ca_certificate'), and client ('client_key',
     * 'client_certificate') specified.
     * </pre>
     *
     * <code>SERVER_CLIENT = 2;</code>
     */
    public static final int SERVER_CLIENT_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SslType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SslType forNumber(int value) {
      switch (value) {
        case 0:
          return SSL_TYPE_UNSPECIFIED;
        case 1:
          return SERVER_ONLY;
        case 2:
          return SERVER_CLIENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SslType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SslType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SslType>() {
          public SslType findValueByNumber(int number) {
            return SslType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.SslConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final SslType[] VALUES = values();

    public static SslType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SslType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.clouddms.v1.SslConfig.SslType)
  }

  public static final int TYPE_FIELD_NUMBER = 1;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The ssl config type according to 'client_key',
   * 'client_certificate' and 'ca_certificate'.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SslConfig.SslType type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The ssl config type according to 'client_key',
   * 'client_certificate' and 'ca_certificate'.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.SslConfig.SslType type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.SslConfig.SslType getType() {
    com.google.cloud.clouddms.v1.SslConfig.SslType result =
        com.google.cloud.clouddms.v1.SslConfig.SslType.forNumber(type_);
    return result == null ? com.google.cloud.clouddms.v1.SslConfig.SslType.UNRECOGNIZED : result;
  }

  public static final int CLIENT_KEY_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clientKey_ = "";
  /**
   *
   *
   * <pre>
   * Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key
   * associated with the Client Certificate. If this field is used then the
   * 'client_certificate' field is mandatory.
   * </pre>
   *
   * <code>string client_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The clientKey.
   */
  @java.lang.Override
  public java.lang.String getClientKey() {
    java.lang.Object ref = clientKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clientKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key
   * associated with the Client Certificate. If this field is used then the
   * 'client_certificate' field is mandatory.
   * </pre>
   *
   * <code>string client_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The bytes for clientKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClientKeyBytes() {
    java.lang.Object ref = clientKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clientKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLIENT_CERTIFICATE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clientCertificate_ = "";
  /**
   *
   *
   * <pre>
   * Input only. The x509 PEM-encoded certificate that will be used by the
   * replica to authenticate against the source database server.If this field is
   * used then the 'client_key' field is mandatory.
   * </pre>
   *
   * <code>string client_certificate = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The clientCertificate.
   */
  @java.lang.Override
  public java.lang.String getClientCertificate() {
    java.lang.Object ref = clientCertificate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clientCertificate_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Input only. The x509 PEM-encoded certificate that will be used by the
   * replica to authenticate against the source database server.If this field is
   * used then the 'client_key' field is mandatory.
   * </pre>
   *
   * <code>string client_certificate = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The bytes for clientCertificate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClientCertificateBytes() {
    java.lang.Object ref = clientCertificate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clientCertificate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CA_CERTIFICATE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object caCertificate_ = "";
  /**
   *
   *
   * <pre>
   * Required. Input only. The x509 PEM-encoded certificate of the CA that
   * signed the source database server's certificate. The replica will use this
   * certificate to verify it's connecting to the right host.
   * </pre>
   *
   * <code>
   * string ca_certificate = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The caCertificate.
   */
  @java.lang.Override
  public java.lang.String getCaCertificate() {
    java.lang.Object ref = caCertificate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      caCertificate_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Input only. The x509 PEM-encoded certificate of the CA that
   * signed the source database server's certificate. The replica will use this
   * certificate to verify it's connecting to the right host.
   * </pre>
   *
   * <code>
   * string ca_certificate = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The bytes for caCertificate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCaCertificateBytes() {
    java.lang.Object ref = caCertificate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      caCertificate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (type_ != com.google.cloud.clouddms.v1.SslConfig.SslType.SSL_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, clientKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientCertificate_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, clientCertificate_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(caCertificate_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, caCertificate_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (type_ != com.google.cloud.clouddms.v1.SslConfig.SslType.SSL_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, clientKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientCertificate_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, clientCertificate_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(caCertificate_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, caCertificate_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.SslConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.SslConfig other = (com.google.cloud.clouddms.v1.SslConfig) obj;

    if (type_ != other.type_) return false;
    if (!getClientKey().equals(other.getClientKey())) return false;
    if (!getClientCertificate().equals(other.getClientCertificate())) return false;
    if (!getCaCertificate().equals(other.getCaCertificate())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + CLIENT_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getClientKey().hashCode();
    hash = (37 * hash) + CLIENT_CERTIFICATE_FIELD_NUMBER;
    hash = (53 * hash) + getClientCertificate().hashCode();
    hash = (37 * hash) + CA_CERTIFICATE_FIELD_NUMBER;
    hash = (53 * hash) + getCaCertificate().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.SslConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.SslConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.SslConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.SslConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.SslConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.SslConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.SslConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.SslConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.SslConfig parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.SslConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.SslConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.SslConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.SslConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * SSL configuration information.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.SslConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.SslConfig)
      com.google.cloud.clouddms.v1.SslConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_SslConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_SslConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.SslConfig.class,
              com.google.cloud.clouddms.v1.SslConfig.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.SslConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      type_ = 0;
      clientKey_ = "";
      clientCertificate_ = "";
      caCertificate_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ClouddmsResourcesProto
          .internal_static_google_cloud_clouddms_v1_SslConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.SslConfig getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.SslConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.SslConfig build() {
      com.google.cloud.clouddms.v1.SslConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.SslConfig buildPartial() {
      com.google.cloud.clouddms.v1.SslConfig result =
          new com.google.cloud.clouddms.v1.SslConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.SslConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.clientKey_ = clientKey_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.clientCertificate_ = clientCertificate_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.caCertificate_ = caCertificate_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.SslConfig) {
        return mergeFrom((com.google.cloud.clouddms.v1.SslConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.SslConfig other) {
      if (other == com.google.cloud.clouddms.v1.SslConfig.getDefaultInstance()) return this;
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (!other.getClientKey().isEmpty()) {
        clientKey_ = other.clientKey_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getClientCertificate().isEmpty()) {
        clientCertificate_ = other.clientCertificate_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getCaCertificate().isEmpty()) {
        caCertificate_ = other.caCertificate_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                clientKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                clientCertificate_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                caCertificate_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The ssl config type according to 'client_key',
     * 'client_certificate' and 'ca_certificate'.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SslConfig.SslType type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ssl config type according to 'client_key',
     * 'client_certificate' and 'ca_certificate'.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SslConfig.SslType type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ssl config type according to 'client_key',
     * 'client_certificate' and 'ca_certificate'.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SslConfig.SslType type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.SslConfig.SslType getType() {
      com.google.cloud.clouddms.v1.SslConfig.SslType result =
          com.google.cloud.clouddms.v1.SslConfig.SslType.forNumber(type_);
      return result == null ? com.google.cloud.clouddms.v1.SslConfig.SslType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ssl config type according to 'client_key',
     * 'client_certificate' and 'ca_certificate'.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SslConfig.SslType type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.clouddms.v1.SslConfig.SslType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ssl config type according to 'client_key',
     * 'client_certificate' and 'ca_certificate'.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.SslConfig.SslType type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      type_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object clientKey_ = "";
    /**
     *
     *
     * <pre>
     * Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key
     * associated with the Client Certificate. If this field is used then the
     * 'client_certificate' field is mandatory.
     * </pre>
     *
     * <code>string client_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The clientKey.
     */
    public java.lang.String getClientKey() {
      java.lang.Object ref = clientKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clientKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key
     * associated with the Client Certificate. If this field is used then the
     * 'client_certificate' field is mandatory.
     * </pre>
     *
     * <code>string client_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The bytes for clientKey.
     */
    public com.google.protobuf.ByteString getClientKeyBytes() {
      java.lang.Object ref = clientKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clientKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key
     * associated with the Client Certificate. If this field is used then the
     * 'client_certificate' field is mandatory.
     * </pre>
     *
     * <code>string client_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The clientKey to set.
     * @return This builder for chaining.
     */
    public Builder setClientKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clientKey_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key
     * associated with the Client Certificate. If this field is used then the
     * 'client_certificate' field is mandatory.
     * </pre>
     *
     * <code>string client_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClientKey() {
      clientKey_ = getDefaultInstance().getClientKey();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key
     * associated with the Client Certificate. If this field is used then the
     * 'client_certificate' field is mandatory.
     * </pre>
     *
     * <code>string client_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The bytes for clientKey to set.
     * @return This builder for chaining.
     */
    public Builder setClientKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clientKey_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object clientCertificate_ = "";
    /**
     *
     *
     * <pre>
     * Input only. The x509 PEM-encoded certificate that will be used by the
     * replica to authenticate against the source database server.If this field is
     * used then the 'client_key' field is mandatory.
     * </pre>
     *
     * <code>string client_certificate = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The clientCertificate.
     */
    public java.lang.String getClientCertificate() {
      java.lang.Object ref = clientCertificate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clientCertificate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The x509 PEM-encoded certificate that will be used by the
     * replica to authenticate against the source database server.If this field is
     * used then the 'client_key' field is mandatory.
     * </pre>
     *
     * <code>string client_certificate = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The bytes for clientCertificate.
     */
    public com.google.protobuf.ByteString getClientCertificateBytes() {
      java.lang.Object ref = clientCertificate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clientCertificate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The x509 PEM-encoded certificate that will be used by the
     * replica to authenticate against the source database server.If this field is
     * used then the 'client_key' field is mandatory.
     * </pre>
     *
     * <code>string client_certificate = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The clientCertificate to set.
     * @return This builder for chaining.
     */
    public Builder setClientCertificate(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clientCertificate_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The x509 PEM-encoded certificate that will be used by the
     * replica to authenticate against the source database server.If this field is
     * used then the 'client_key' field is mandatory.
     * </pre>
     *
     * <code>string client_certificate = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClientCertificate() {
      clientCertificate_ = getDefaultInstance().getClientCertificate();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The x509 PEM-encoded certificate that will be used by the
     * replica to authenticate against the source database server.If this field is
     * used then the 'client_key' field is mandatory.
     * </pre>
     *
     * <code>string client_certificate = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The bytes for clientCertificate to set.
     * @return This builder for chaining.
     */
    public Builder setClientCertificateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clientCertificate_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object caCertificate_ = "";
    /**
     *
     *
     * <pre>
     * Required. Input only. The x509 PEM-encoded certificate of the CA that
     * signed the source database server's certificate. The replica will use this
     * certificate to verify it's connecting to the right host.
     * </pre>
     *
     * <code>
     * string ca_certificate = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The caCertificate.
     */
    public java.lang.String getCaCertificate() {
      java.lang.Object ref = caCertificate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        caCertificate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. The x509 PEM-encoded certificate of the CA that
     * signed the source database server's certificate. The replica will use this
     * certificate to verify it's connecting to the right host.
     * </pre>
     *
     * <code>
     * string ca_certificate = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The bytes for caCertificate.
     */
    public com.google.protobuf.ByteString getCaCertificateBytes() {
      java.lang.Object ref = caCertificate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        caCertificate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. The x509 PEM-encoded certificate of the CA that
     * signed the source database server's certificate. The replica will use this
     * certificate to verify it's connecting to the right host.
     * </pre>
     *
     * <code>
     * string ca_certificate = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The caCertificate to set.
     * @return This builder for chaining.
     */
    public Builder setCaCertificate(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      caCertificate_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. The x509 PEM-encoded certificate of the CA that
     * signed the source database server's certificate. The replica will use this
     * certificate to verify it's connecting to the right host.
     * </pre>
     *
     * <code>
     * string ca_certificate = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCaCertificate() {
      caCertificate_ = getDefaultInstance().getCaCertificate();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. The x509 PEM-encoded certificate of the CA that
     * signed the source database server's certificate. The replica will use this
     * certificate to verify it's connecting to the right host.
     * </pre>
     *
     * <code>
     * string ca_certificate = 4 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The bytes for caCertificate to set.
     * @return This builder for chaining.
     */
    public Builder setCaCertificateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      caCertificate_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.SslConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.SslConfig)
  private static final com.google.cloud.clouddms.v1.SslConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.SslConfig();
  }

  public static com.google.cloud.clouddms.v1.SslConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SslConfig> PARSER =
      new com.google.protobuf.AbstractParser<SslConfig>() {
        @java.lang.Override
        public SslConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SslConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SslConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.SslConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
