/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Trigger is not used as an independent entity, it is retrieved as part of a
 * Table entity.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.TriggerEntity}
 */
public final class TriggerEntity extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.TriggerEntity)
    TriggerEntityOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TriggerEntity.newBuilder() to construct.
  private TriggerEntity(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TriggerEntity() {
    name_ = "";
    triggeringEvents_ = com.google.protobuf.LazyStringArrayList.emptyList();
    triggerType_ = "";
    sqlCode_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TriggerEntity();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_TriggerEntity_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_TriggerEntity_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.TriggerEntity.class,
            com.google.cloud.clouddms.v1.TriggerEntity.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name of the trigger.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the trigger.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRIGGERING_EVENTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList triggeringEvents_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The DML, DDL, or database events that fire the trigger, for example
   * INSERT, UPDATE.
   * </pre>
   *
   * <code>repeated string triggering_events = 2;</code>
   *
   * @return A list containing the triggeringEvents.
   */
  public com.google.protobuf.ProtocolStringList getTriggeringEventsList() {
    return triggeringEvents_;
  }
  /**
   *
   *
   * <pre>
   * The DML, DDL, or database events that fire the trigger, for example
   * INSERT, UPDATE.
   * </pre>
   *
   * <code>repeated string triggering_events = 2;</code>
   *
   * @return The count of triggeringEvents.
   */
  public int getTriggeringEventsCount() {
    return triggeringEvents_.size();
  }
  /**
   *
   *
   * <pre>
   * The DML, DDL, or database events that fire the trigger, for example
   * INSERT, UPDATE.
   * </pre>
   *
   * <code>repeated string triggering_events = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The triggeringEvents at the given index.
   */
  public java.lang.String getTriggeringEvents(int index) {
    return triggeringEvents_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The DML, DDL, or database events that fire the trigger, for example
   * INSERT, UPDATE.
   * </pre>
   *
   * <code>repeated string triggering_events = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the triggeringEvents at the given index.
   */
  public com.google.protobuf.ByteString getTriggeringEventsBytes(int index) {
    return triggeringEvents_.getByteString(index);
  }

  public static final int TRIGGER_TYPE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object triggerType_ = "";
  /**
   *
   *
   * <pre>
   * Indicates when the trigger fires, for example BEFORE STATEMENT, AFTER EACH
   * ROW.
   * </pre>
   *
   * <code>string trigger_type = 3;</code>
   *
   * @return The triggerType.
   */
  @java.lang.Override
  public java.lang.String getTriggerType() {
    java.lang.Object ref = triggerType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      triggerType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Indicates when the trigger fires, for example BEFORE STATEMENT, AFTER EACH
   * ROW.
   * </pre>
   *
   * <code>string trigger_type = 3;</code>
   *
   * @return The bytes for triggerType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTriggerTypeBytes() {
    java.lang.Object ref = triggerType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      triggerType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SQL_CODE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sqlCode_ = "";
  /**
   *
   *
   * <pre>
   * The SQL code which creates the trigger.
   * </pre>
   *
   * <code>string sql_code = 4;</code>
   *
   * @return The sqlCode.
   */
  @java.lang.Override
  public java.lang.String getSqlCode() {
    java.lang.Object ref = sqlCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sqlCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The SQL code which creates the trigger.
   * </pre>
   *
   * <code>string sql_code = 4;</code>
   *
   * @return The bytes for sqlCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSqlCodeBytes() {
    java.lang.Object ref = sqlCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sqlCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOM_FEATURES_FIELD_NUMBER = 5;
  private com.google.protobuf.Struct customFeatures_;
  /**
   *
   *
   * <pre>
   * Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 5;</code>
   *
   * @return Whether the customFeatures field is set.
   */
  @java.lang.Override
  public boolean hasCustomFeatures() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 5;</code>
   *
   * @return The customFeatures.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getCustomFeatures() {
    return customFeatures_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : customFeatures_;
  }
  /**
   *
   *
   * <pre>
   * Custom engine specific features.
   * </pre>
   *
   * <code>.google.protobuf.Struct custom_features = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getCustomFeaturesOrBuilder() {
    return customFeatures_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : customFeatures_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < triggeringEvents_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, triggeringEvents_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(triggerType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, triggerType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sqlCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, sqlCode_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getCustomFeatures());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < triggeringEvents_.size(); i++) {
        dataSize += computeStringSizeNoTag(triggeringEvents_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTriggeringEventsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(triggerType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, triggerType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sqlCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, sqlCode_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCustomFeatures());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.TriggerEntity)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.TriggerEntity other =
        (com.google.cloud.clouddms.v1.TriggerEntity) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getTriggeringEventsList().equals(other.getTriggeringEventsList())) return false;
    if (!getTriggerType().equals(other.getTriggerType())) return false;
    if (!getSqlCode().equals(other.getSqlCode())) return false;
    if (hasCustomFeatures() != other.hasCustomFeatures()) return false;
    if (hasCustomFeatures()) {
      if (!getCustomFeatures().equals(other.getCustomFeatures())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getTriggeringEventsCount() > 0) {
      hash = (37 * hash) + TRIGGERING_EVENTS_FIELD_NUMBER;
      hash = (53 * hash) + getTriggeringEventsList().hashCode();
    }
    hash = (37 * hash) + TRIGGER_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getTriggerType().hashCode();
    hash = (37 * hash) + SQL_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getSqlCode().hashCode();
    if (hasCustomFeatures()) {
      hash = (37 * hash) + CUSTOM_FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getCustomFeatures().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.TriggerEntity parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.TriggerEntity parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.TriggerEntity parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.TriggerEntity parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.TriggerEntity parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.TriggerEntity parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.TriggerEntity parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.TriggerEntity parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.TriggerEntity parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.TriggerEntity parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.TriggerEntity parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.TriggerEntity parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.TriggerEntity prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Trigger is not used as an independent entity, it is retrieved as part of a
   * Table entity.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.TriggerEntity}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.TriggerEntity)
      com.google.cloud.clouddms.v1.TriggerEntityOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_TriggerEntity_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_TriggerEntity_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.TriggerEntity.class,
              com.google.cloud.clouddms.v1.TriggerEntity.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.TriggerEntity.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCustomFeaturesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      triggeringEvents_ = com.google.protobuf.LazyStringArrayList.emptyList();
      triggerType_ = "";
      sqlCode_ = "";
      customFeatures_ = null;
      if (customFeaturesBuilder_ != null) {
        customFeaturesBuilder_.dispose();
        customFeaturesBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_TriggerEntity_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.TriggerEntity getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.TriggerEntity.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.TriggerEntity build() {
      com.google.cloud.clouddms.v1.TriggerEntity result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.TriggerEntity buildPartial() {
      com.google.cloud.clouddms.v1.TriggerEntity result =
          new com.google.cloud.clouddms.v1.TriggerEntity(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.TriggerEntity result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        triggeringEvents_.makeImmutable();
        result.triggeringEvents_ = triggeringEvents_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.triggerType_ = triggerType_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.sqlCode_ = sqlCode_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.customFeatures_ =
            customFeaturesBuilder_ == null ? customFeatures_ : customFeaturesBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.TriggerEntity) {
        return mergeFrom((com.google.cloud.clouddms.v1.TriggerEntity) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.TriggerEntity other) {
      if (other == com.google.cloud.clouddms.v1.TriggerEntity.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.triggeringEvents_.isEmpty()) {
        if (triggeringEvents_.isEmpty()) {
          triggeringEvents_ = other.triggeringEvents_;
          bitField0_ |= 0x00000002;
        } else {
          ensureTriggeringEventsIsMutable();
          triggeringEvents_.addAll(other.triggeringEvents_);
        }
        onChanged();
      }
      if (!other.getTriggerType().isEmpty()) {
        triggerType_ = other.triggerType_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getSqlCode().isEmpty()) {
        sqlCode_ = other.sqlCode_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasCustomFeatures()) {
        mergeCustomFeatures(other.getCustomFeatures());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTriggeringEventsIsMutable();
                triggeringEvents_.add(s);
                break;
              } // case 18
            case 26:
              {
                triggerType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                sqlCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCustomFeaturesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the trigger.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the trigger.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the trigger.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the trigger.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the trigger.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList triggeringEvents_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTriggeringEventsIsMutable() {
      if (!triggeringEvents_.isModifiable()) {
        triggeringEvents_ = new com.google.protobuf.LazyStringArrayList(triggeringEvents_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * The DML, DDL, or database events that fire the trigger, for example
     * INSERT, UPDATE.
     * </pre>
     *
     * <code>repeated string triggering_events = 2;</code>
     *
     * @return A list containing the triggeringEvents.
     */
    public com.google.protobuf.ProtocolStringList getTriggeringEventsList() {
      triggeringEvents_.makeImmutable();
      return triggeringEvents_;
    }
    /**
     *
     *
     * <pre>
     * The DML, DDL, or database events that fire the trigger, for example
     * INSERT, UPDATE.
     * </pre>
     *
     * <code>repeated string triggering_events = 2;</code>
     *
     * @return The count of triggeringEvents.
     */
    public int getTriggeringEventsCount() {
      return triggeringEvents_.size();
    }
    /**
     *
     *
     * <pre>
     * The DML, DDL, or database events that fire the trigger, for example
     * INSERT, UPDATE.
     * </pre>
     *
     * <code>repeated string triggering_events = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The triggeringEvents at the given index.
     */
    public java.lang.String getTriggeringEvents(int index) {
      return triggeringEvents_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The DML, DDL, or database events that fire the trigger, for example
     * INSERT, UPDATE.
     * </pre>
     *
     * <code>repeated string triggering_events = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the triggeringEvents at the given index.
     */
    public com.google.protobuf.ByteString getTriggeringEventsBytes(int index) {
      return triggeringEvents_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The DML, DDL, or database events that fire the trigger, for example
     * INSERT, UPDATE.
     * </pre>
     *
     * <code>repeated string triggering_events = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The triggeringEvents to set.
     * @return This builder for chaining.
     */
    public Builder setTriggeringEvents(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTriggeringEventsIsMutable();
      triggeringEvents_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DML, DDL, or database events that fire the trigger, for example
     * INSERT, UPDATE.
     * </pre>
     *
     * <code>repeated string triggering_events = 2;</code>
     *
     * @param value The triggeringEvents to add.
     * @return This builder for chaining.
     */
    public Builder addTriggeringEvents(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTriggeringEventsIsMutable();
      triggeringEvents_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DML, DDL, or database events that fire the trigger, for example
     * INSERT, UPDATE.
     * </pre>
     *
     * <code>repeated string triggering_events = 2;</code>
     *
     * @param values The triggeringEvents to add.
     * @return This builder for chaining.
     */
    public Builder addAllTriggeringEvents(java.lang.Iterable<java.lang.String> values) {
      ensureTriggeringEventsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, triggeringEvents_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DML, DDL, or database events that fire the trigger, for example
     * INSERT, UPDATE.
     * </pre>
     *
     * <code>repeated string triggering_events = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTriggeringEvents() {
      triggeringEvents_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DML, DDL, or database events that fire the trigger, for example
     * INSERT, UPDATE.
     * </pre>
     *
     * <code>repeated string triggering_events = 2;</code>
     *
     * @param value The bytes of the triggeringEvents to add.
     * @return This builder for chaining.
     */
    public Builder addTriggeringEventsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTriggeringEventsIsMutable();
      triggeringEvents_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object triggerType_ = "";
    /**
     *
     *
     * <pre>
     * Indicates when the trigger fires, for example BEFORE STATEMENT, AFTER EACH
     * ROW.
     * </pre>
     *
     * <code>string trigger_type = 3;</code>
     *
     * @return The triggerType.
     */
    public java.lang.String getTriggerType() {
      java.lang.Object ref = triggerType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        triggerType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates when the trigger fires, for example BEFORE STATEMENT, AFTER EACH
     * ROW.
     * </pre>
     *
     * <code>string trigger_type = 3;</code>
     *
     * @return The bytes for triggerType.
     */
    public com.google.protobuf.ByteString getTriggerTypeBytes() {
      java.lang.Object ref = triggerType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        triggerType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates when the trigger fires, for example BEFORE STATEMENT, AFTER EACH
     * ROW.
     * </pre>
     *
     * <code>string trigger_type = 3;</code>
     *
     * @param value The triggerType to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      triggerType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates when the trigger fires, for example BEFORE STATEMENT, AFTER EACH
     * ROW.
     * </pre>
     *
     * <code>string trigger_type = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTriggerType() {
      triggerType_ = getDefaultInstance().getTriggerType();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates when the trigger fires, for example BEFORE STATEMENT, AFTER EACH
     * ROW.
     * </pre>
     *
     * <code>string trigger_type = 3;</code>
     *
     * @param value The bytes for triggerType to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      triggerType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object sqlCode_ = "";
    /**
     *
     *
     * <pre>
     * The SQL code which creates the trigger.
     * </pre>
     *
     * <code>string sql_code = 4;</code>
     *
     * @return The sqlCode.
     */
    public java.lang.String getSqlCode() {
      java.lang.Object ref = sqlCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sqlCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The SQL code which creates the trigger.
     * </pre>
     *
     * <code>string sql_code = 4;</code>
     *
     * @return The bytes for sqlCode.
     */
    public com.google.protobuf.ByteString getSqlCodeBytes() {
      java.lang.Object ref = sqlCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sqlCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The SQL code which creates the trigger.
     * </pre>
     *
     * <code>string sql_code = 4;</code>
     *
     * @param value The sqlCode to set.
     * @return This builder for chaining.
     */
    public Builder setSqlCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sqlCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The SQL code which creates the trigger.
     * </pre>
     *
     * <code>string sql_code = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSqlCode() {
      sqlCode_ = getDefaultInstance().getSqlCode();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The SQL code which creates the trigger.
     * </pre>
     *
     * <code>string sql_code = 4;</code>
     *
     * @param value The bytes for sqlCode to set.
     * @return This builder for chaining.
     */
    public Builder setSqlCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sqlCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct customFeatures_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        customFeaturesBuilder_;
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 5;</code>
     *
     * @return Whether the customFeatures field is set.
     */
    public boolean hasCustomFeatures() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 5;</code>
     *
     * @return The customFeatures.
     */
    public com.google.protobuf.Struct getCustomFeatures() {
      if (customFeaturesBuilder_ == null) {
        return customFeatures_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : customFeatures_;
      } else {
        return customFeaturesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 5;</code>
     */
    public Builder setCustomFeatures(com.google.protobuf.Struct value) {
      if (customFeaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        customFeatures_ = value;
      } else {
        customFeaturesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 5;</code>
     */
    public Builder setCustomFeatures(com.google.protobuf.Struct.Builder builderForValue) {
      if (customFeaturesBuilder_ == null) {
        customFeatures_ = builderForValue.build();
      } else {
        customFeaturesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 5;</code>
     */
    public Builder mergeCustomFeatures(com.google.protobuf.Struct value) {
      if (customFeaturesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && customFeatures_ != null
            && customFeatures_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getCustomFeaturesBuilder().mergeFrom(value);
        } else {
          customFeatures_ = value;
        }
      } else {
        customFeaturesBuilder_.mergeFrom(value);
      }
      if (customFeatures_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 5;</code>
     */
    public Builder clearCustomFeatures() {
      bitField0_ = (bitField0_ & ~0x00000010);
      customFeatures_ = null;
      if (customFeaturesBuilder_ != null) {
        customFeaturesBuilder_.dispose();
        customFeaturesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 5;</code>
     */
    public com.google.protobuf.Struct.Builder getCustomFeaturesBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCustomFeaturesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 5;</code>
     */
    public com.google.protobuf.StructOrBuilder getCustomFeaturesOrBuilder() {
      if (customFeaturesBuilder_ != null) {
        return customFeaturesBuilder_.getMessageOrBuilder();
      } else {
        return customFeatures_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : customFeatures_;
      }
    }
    /**
     *
     *
     * <pre>
     * Custom engine specific features.
     * </pre>
     *
     * <code>.google.protobuf.Struct custom_features = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getCustomFeaturesFieldBuilder() {
      if (customFeaturesBuilder_ == null) {
        customFeaturesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getCustomFeatures(), getParentForChildren(), isClean());
        customFeatures_ = null;
      }
      return customFeaturesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.TriggerEntity)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.TriggerEntity)
  private static final com.google.cloud.clouddms.v1.TriggerEntity DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.TriggerEntity();
  }

  public static com.google.cloud.clouddms.v1.TriggerEntity getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TriggerEntity> PARSER =
      new com.google.protobuf.AbstractParser<TriggerEntity>() {
        @java.lang.Override
        public TriggerEntity parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TriggerEntity> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TriggerEntity> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.TriggerEntity getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
