/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/clouddms.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Request message for 'UpdateConnectionProfile' request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.UpdateConnectionProfileRequest}
 */
public final class UpdateConnectionProfileRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.UpdateConnectionProfileRequest)
    UpdateConnectionProfileRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UpdateConnectionProfileRequest.newBuilder() to construct.
  private UpdateConnectionProfileRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpdateConnectionProfileRequest() {
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpdateConnectionProfileRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ClouddmsProto
        .internal_static_google_cloud_clouddms_v1_UpdateConnectionProfileRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ClouddmsProto
        .internal_static_google_cloud_clouddms_v1_UpdateConnectionProfileRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest.class,
            com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest.Builder.class);
  }

  private int bitField0_;
  public static final int UPDATE_MASK_FIELD_NUMBER = 1;
  private com.google.protobuf.FieldMask updateMask_;
  /**
   *
   *
   * <pre>
   * Required. Field mask is used to specify the fields to be overwritten by the
   * update in the conversion workspace resource.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the updateMask field is set.
   */
  @java.lang.Override
  public boolean hasUpdateMask() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Field mask is used to specify the fields to be overwritten by the
   * update in the conversion workspace resource.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The updateMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getUpdateMask() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }
  /**
   *
   *
   * <pre>
   * Required. Field mask is used to specify the fields to be overwritten by the
   * update in the conversion workspace resource.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }

  public static final int CONNECTION_PROFILE_FIELD_NUMBER = 2;
  private com.google.cloud.clouddms.v1.ConnectionProfile connectionProfile_;
  /**
   *
   *
   * <pre>
   * Required. The connection profile parameters to update.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.ConnectionProfile connection_profile = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the connectionProfile field is set.
   */
  @java.lang.Override
  public boolean hasConnectionProfile() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The connection profile parameters to update.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.ConnectionProfile connection_profile = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The connectionProfile.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ConnectionProfile getConnectionProfile() {
    return connectionProfile_ == null
        ? com.google.cloud.clouddms.v1.ConnectionProfile.getDefaultInstance()
        : connectionProfile_;
  }
  /**
   *
   *
   * <pre>
   * Required. The connection profile parameters to update.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.ConnectionProfile connection_profile = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ConnectionProfileOrBuilder getConnectionProfileOrBuilder() {
    return connectionProfile_ == null
        ? com.google.cloud.clouddms.v1.ConnectionProfile.getDefaultInstance()
        : connectionProfile_;
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A unique ID used to identify the request. If the server receives
   * two requests with the same ID, then the second request is ignored.
   *
   * It is recommended to always set this value to a UUID.
   *
   * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
   * (_), and hyphens (-). The maximum length is 40 characters.
   * </pre>
   *
   * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A unique ID used to identify the request. If the server receives
   * two requests with the same ID, then the second request is ignored.
   *
   * It is recommended to always set this value to a UUID.
   *
   * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
   * (_), and hyphens (-). The maximum length is 40 characters.
   * </pre>
   *
   * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALIDATE_ONLY_FIELD_NUMBER = 4;
  private boolean validateOnly_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Only validate the connection profile, but don't update any
   * resources. The default is false. Only supported for Oracle connection
   * profiles.
   * </pre>
   *
   * <code>bool validate_only = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The validateOnly.
   */
  @java.lang.Override
  public boolean getValidateOnly() {
    return validateOnly_;
  }

  public static final int SKIP_VALIDATION_FIELD_NUMBER = 5;
  private boolean skipValidation_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Update the connection profile without validating it.
   * The default is false.
   * Only supported for Oracle connection profiles.
   * </pre>
   *
   * <code>bool skip_validation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The skipValidation.
   */
  @java.lang.Override
  public boolean getSkipValidation() {
    return skipValidation_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getUpdateMask());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getConnectionProfile());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, requestId_);
    }
    if (validateOnly_ != false) {
      output.writeBool(4, validateOnly_);
    }
    if (skipValidation_ != false) {
      output.writeBool(5, skipValidation_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getUpdateMask());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getConnectionProfile());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, requestId_);
    }
    if (validateOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, validateOnly_);
    }
    if (skipValidation_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, skipValidation_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest other =
        (com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest) obj;

    if (hasUpdateMask() != other.hasUpdateMask()) return false;
    if (hasUpdateMask()) {
      if (!getUpdateMask().equals(other.getUpdateMask())) return false;
    }
    if (hasConnectionProfile() != other.hasConnectionProfile()) return false;
    if (hasConnectionProfile()) {
      if (!getConnectionProfile().equals(other.getConnectionProfile())) return false;
    }
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (getValidateOnly() != other.getValidateOnly()) return false;
    if (getSkipValidation() != other.getSkipValidation()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasUpdateMask()) {
      hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateMask().hashCode();
    }
    if (hasConnectionProfile()) {
      hash = (37 * hash) + CONNECTION_PROFILE_FIELD_NUMBER;
      hash = (53 * hash) + getConnectionProfile().hashCode();
    }
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (37 * hash) + VALIDATE_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getValidateOnly());
    hash = (37 * hash) + SKIP_VALIDATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSkipValidation());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for 'UpdateConnectionProfile' request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.UpdateConnectionProfileRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.UpdateConnectionProfileRequest)
      com.google.cloud.clouddms.v1.UpdateConnectionProfileRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_UpdateConnectionProfileRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_UpdateConnectionProfileRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest.class,
              com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUpdateMaskFieldBuilder();
        getConnectionProfileFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      connectionProfile_ = null;
      if (connectionProfileBuilder_ != null) {
        connectionProfileBuilder_.dispose();
        connectionProfileBuilder_ = null;
      }
      requestId_ = "";
      validateOnly_ = false;
      skipValidation_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ClouddmsProto
          .internal_static_google_cloud_clouddms_v1_UpdateConnectionProfileRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest build() {
      com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest buildPartial() {
      com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest result =
          new com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.updateMask_ = updateMaskBuilder_ == null ? updateMask_ : updateMaskBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.connectionProfile_ =
            connectionProfileBuilder_ == null
                ? connectionProfile_
                : connectionProfileBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.requestId_ = requestId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.validateOnly_ = validateOnly_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.skipValidation_ = skipValidation_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest) {
        return mergeFrom((com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest other) {
      if (other == com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest.getDefaultInstance())
        return this;
      if (other.hasUpdateMask()) {
        mergeUpdateMask(other.getUpdateMask());
      }
      if (other.hasConnectionProfile()) {
        mergeConnectionProfile(other.getConnectionProfile());
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getValidateOnly() != false) {
        setValidateOnly(other.getValidateOnly());
      }
      if (other.getSkipValidation() != false) {
        setSkipValidation(other.getSkipValidation());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getConnectionProfileFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                validateOnly_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                skipValidation_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.FieldMask updateMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        updateMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Field mask is used to specify the fields to be overwritten by the
     * update in the conversion workspace resource.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the updateMask field is set.
     */
    public boolean hasUpdateMask() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Field mask is used to specify the fields to be overwritten by the
     * update in the conversion workspace resource.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The updateMask.
     */
    public com.google.protobuf.FieldMask getUpdateMask() {
      if (updateMaskBuilder_ == null) {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      } else {
        return updateMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Field mask is used to specify the fields to be overwritten by the
     * update in the conversion workspace resource.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateMask_ = value;
      } else {
        updateMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Field mask is used to specify the fields to be overwritten by the
     * update in the conversion workspace resource.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (updateMaskBuilder_ == null) {
        updateMask_ = builderForValue.build();
      } else {
        updateMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Field mask is used to specify the fields to be overwritten by the
     * update in the conversion workspace resource.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && updateMask_ != null
            && updateMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getUpdateMaskBuilder().mergeFrom(value);
        } else {
          updateMask_ = value;
        }
      } else {
        updateMaskBuilder_.mergeFrom(value);
      }
      if (updateMask_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Field mask is used to specify the fields to be overwritten by the
     * update in the conversion workspace resource.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearUpdateMask() {
      bitField0_ = (bitField0_ & ~0x00000001);
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Field mask is used to specify the fields to be overwritten by the
     * update in the conversion workspace resource.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.FieldMask.Builder getUpdateMaskBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getUpdateMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Field mask is used to specify the fields to be overwritten by the
     * update in the conversion workspace resource.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
      if (updateMaskBuilder_ != null) {
        return updateMaskBuilder_.getMessageOrBuilder();
      } else {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Field mask is used to specify the fields to be overwritten by the
     * update in the conversion workspace resource.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getUpdateMaskFieldBuilder() {
      if (updateMaskBuilder_ == null) {
        updateMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getUpdateMask(), getParentForChildren(), isClean());
        updateMask_ = null;
      }
      return updateMaskBuilder_;
    }

    private com.google.cloud.clouddms.v1.ConnectionProfile connectionProfile_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.ConnectionProfile,
            com.google.cloud.clouddms.v1.ConnectionProfile.Builder,
            com.google.cloud.clouddms.v1.ConnectionProfileOrBuilder>
        connectionProfileBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The connection profile parameters to update.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConnectionProfile connection_profile = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the connectionProfile field is set.
     */
    public boolean hasConnectionProfile() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The connection profile parameters to update.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConnectionProfile connection_profile = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The connectionProfile.
     */
    public com.google.cloud.clouddms.v1.ConnectionProfile getConnectionProfile() {
      if (connectionProfileBuilder_ == null) {
        return connectionProfile_ == null
            ? com.google.cloud.clouddms.v1.ConnectionProfile.getDefaultInstance()
            : connectionProfile_;
      } else {
        return connectionProfileBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The connection profile parameters to update.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConnectionProfile connection_profile = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setConnectionProfile(com.google.cloud.clouddms.v1.ConnectionProfile value) {
      if (connectionProfileBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectionProfile_ = value;
      } else {
        connectionProfileBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The connection profile parameters to update.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConnectionProfile connection_profile = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setConnectionProfile(
        com.google.cloud.clouddms.v1.ConnectionProfile.Builder builderForValue) {
      if (connectionProfileBuilder_ == null) {
        connectionProfile_ = builderForValue.build();
      } else {
        connectionProfileBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The connection profile parameters to update.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConnectionProfile connection_profile = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeConnectionProfile(com.google.cloud.clouddms.v1.ConnectionProfile value) {
      if (connectionProfileBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && connectionProfile_ != null
            && connectionProfile_
                != com.google.cloud.clouddms.v1.ConnectionProfile.getDefaultInstance()) {
          getConnectionProfileBuilder().mergeFrom(value);
        } else {
          connectionProfile_ = value;
        }
      } else {
        connectionProfileBuilder_.mergeFrom(value);
      }
      if (connectionProfile_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The connection profile parameters to update.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConnectionProfile connection_profile = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearConnectionProfile() {
      bitField0_ = (bitField0_ & ~0x00000002);
      connectionProfile_ = null;
      if (connectionProfileBuilder_ != null) {
        connectionProfileBuilder_.dispose();
        connectionProfileBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The connection profile parameters to update.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConnectionProfile connection_profile = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.clouddms.v1.ConnectionProfile.Builder getConnectionProfileBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getConnectionProfileFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The connection profile parameters to update.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConnectionProfile connection_profile = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.clouddms.v1.ConnectionProfileOrBuilder getConnectionProfileOrBuilder() {
      if (connectionProfileBuilder_ != null) {
        return connectionProfileBuilder_.getMessageOrBuilder();
      } else {
        return connectionProfile_ == null
            ? com.google.cloud.clouddms.v1.ConnectionProfile.getDefaultInstance()
            : connectionProfile_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The connection profile parameters to update.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ConnectionProfile connection_profile = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.ConnectionProfile,
            com.google.cloud.clouddms.v1.ConnectionProfile.Builder,
            com.google.cloud.clouddms.v1.ConnectionProfileOrBuilder>
        getConnectionProfileFieldBuilder() {
      if (connectionProfileBuilder_ == null) {
        connectionProfileBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.ConnectionProfile,
                com.google.cloud.clouddms.v1.ConnectionProfile.Builder,
                com.google.cloud.clouddms.v1.ConnectionProfileOrBuilder>(
                getConnectionProfile(), getParentForChildren(), isClean());
        connectionProfile_ = null;
      }
      return connectionProfileBuilder_;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A unique ID used to identify the request. If the server receives
     * two requests with the same ID, then the second request is ignored.
     *
     * It is recommended to always set this value to a UUID.
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     * (_), and hyphens (-). The maximum length is 40 characters.
     * </pre>
     *
     * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique ID used to identify the request. If the server receives
     * two requests with the same ID, then the second request is ignored.
     *
     * It is recommended to always set this value to a UUID.
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     * (_), and hyphens (-). The maximum length is 40 characters.
     * </pre>
     *
     * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique ID used to identify the request. If the server receives
     * two requests with the same ID, then the second request is ignored.
     *
     * It is recommended to always set this value to a UUID.
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     * (_), and hyphens (-). The maximum length is 40 characters.
     * </pre>
     *
     * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique ID used to identify the request. If the server receives
     * two requests with the same ID, then the second request is ignored.
     *
     * It is recommended to always set this value to a UUID.
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     * (_), and hyphens (-). The maximum length is 40 characters.
     * </pre>
     *
     * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique ID used to identify the request. If the server receives
     * two requests with the same ID, then the second request is ignored.
     *
     * It is recommended to always set this value to a UUID.
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     * (_), and hyphens (-). The maximum length is 40 characters.
     * </pre>
     *
     * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean validateOnly_;
    /**
     *
     *
     * <pre>
     * Optional. Only validate the connection profile, but don't update any
     * resources. The default is false. Only supported for Oracle connection
     * profiles.
     * </pre>
     *
     * <code>bool validate_only = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The validateOnly.
     */
    @java.lang.Override
    public boolean getValidateOnly() {
      return validateOnly_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Only validate the connection profile, but don't update any
     * resources. The default is false. Only supported for Oracle connection
     * profiles.
     * </pre>
     *
     * <code>bool validate_only = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The validateOnly to set.
     * @return This builder for chaining.
     */
    public Builder setValidateOnly(boolean value) {

      validateOnly_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Only validate the connection profile, but don't update any
     * resources. The default is false. Only supported for Oracle connection
     * profiles.
     * </pre>
     *
     * <code>bool validate_only = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidateOnly() {
      bitField0_ = (bitField0_ & ~0x00000008);
      validateOnly_ = false;
      onChanged();
      return this;
    }

    private boolean skipValidation_;
    /**
     *
     *
     * <pre>
     * Optional. Update the connection profile without validating it.
     * The default is false.
     * Only supported for Oracle connection profiles.
     * </pre>
     *
     * <code>bool skip_validation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The skipValidation.
     */
    @java.lang.Override
    public boolean getSkipValidation() {
      return skipValidation_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Update the connection profile without validating it.
     * The default is false.
     * Only supported for Oracle connection profiles.
     * </pre>
     *
     * <code>bool skip_validation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The skipValidation to set.
     * @return This builder for chaining.
     */
    public Builder setSkipValidation(boolean value) {

      skipValidation_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Update the connection profile without validating it.
     * The default is false.
     * Only supported for Oracle connection profiles.
     * </pre>
     *
     * <code>bool skip_validation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSkipValidation() {
      bitField0_ = (bitField0_ & ~0x00000010);
      skipValidation_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.UpdateConnectionProfileRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.UpdateConnectionProfileRequest)
  private static final com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest();
  }

  public static com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpdateConnectionProfileRequest> PARSER =
      new com.google.protobuf.AbstractParser<UpdateConnectionProfileRequest>() {
        @java.lang.Override
        public UpdateConnectionProfileRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpdateConnectionProfileRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpdateConnectionProfileRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
