/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.clouddms.v1;

/**
 *
 *
 * <pre>
 * Description of data transformation during migration as part of the
 * ConditionalColumnSetValue.
 * </pre>
 *
 * Protobuf type {@code google.cloud.clouddms.v1.ValueTransformation}
 */
public final class ValueTransformation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.clouddms.v1.ValueTransformation)
    ValueTransformationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ValueTransformation.newBuilder() to construct.
  private ValueTransformation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ValueTransformation() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ValueTransformation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_ValueTransformation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
        .internal_static_google_cloud_clouddms_v1_ValueTransformation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.clouddms.v1.ValueTransformation.class,
            com.google.cloud.clouddms.v1.ValueTransformation.Builder.class);
  }

  private int filterCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object filter_;

  public enum FilterCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    IS_NULL(100),
    VALUE_LIST(101),
    INT_COMPARISON(102),
    DOUBLE_COMPARISON(103),
    FILTER_NOT_SET(0);
    private final int value;

    private FilterCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FilterCase valueOf(int value) {
      return forNumber(value);
    }

    public static FilterCase forNumber(int value) {
      switch (value) {
        case 100:
          return IS_NULL;
        case 101:
          return VALUE_LIST;
        case 102:
          return INT_COMPARISON;
        case 103:
          return DOUBLE_COMPARISON;
        case 0:
          return FILTER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public FilterCase getFilterCase() {
    return FilterCase.forNumber(filterCase_);
  }

  private int actionCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object action_;

  public enum ActionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ASSIGN_NULL(200),
    ASSIGN_SPECIFIC_VALUE(201),
    ASSIGN_MIN_VALUE(202),
    ASSIGN_MAX_VALUE(203),
    ROUND_SCALE(204),
    APPLY_HASH(205),
    ACTION_NOT_SET(0);
    private final int value;

    private ActionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ActionCase valueOf(int value) {
      return forNumber(value);
    }

    public static ActionCase forNumber(int value) {
      switch (value) {
        case 200:
          return ASSIGN_NULL;
        case 201:
          return ASSIGN_SPECIFIC_VALUE;
        case 202:
          return ASSIGN_MIN_VALUE;
        case 203:
          return ASSIGN_MAX_VALUE;
        case 204:
          return ROUND_SCALE;
        case 205:
          return APPLY_HASH;
        case 0:
          return ACTION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ActionCase getActionCase() {
    return ActionCase.forNumber(actionCase_);
  }

  public static final int IS_NULL_FIELD_NUMBER = 100;
  /**
   *
   *
   * <pre>
   * Optional. Value is null
   * </pre>
   *
   * <code>.google.protobuf.Empty is_null = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the isNull field is set.
   */
  @java.lang.Override
  public boolean hasIsNull() {
    return filterCase_ == 100;
  }
  /**
   *
   *
   * <pre>
   * Optional. Value is null
   * </pre>
   *
   * <code>.google.protobuf.Empty is_null = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The isNull.
   */
  @java.lang.Override
  public com.google.protobuf.Empty getIsNull() {
    if (filterCase_ == 100) {
      return (com.google.protobuf.Empty) filter_;
    }
    return com.google.protobuf.Empty.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Value is null
   * </pre>
   *
   * <code>.google.protobuf.Empty is_null = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public com.google.protobuf.EmptyOrBuilder getIsNullOrBuilder() {
    if (filterCase_ == 100) {
      return (com.google.protobuf.Empty) filter_;
    }
    return com.google.protobuf.Empty.getDefaultInstance();
  }

  public static final int VALUE_LIST_FIELD_NUMBER = 101;
  /**
   *
   *
   * <pre>
   * Optional. Value is found in the specified list.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.ValueListFilter value_list = 101 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the valueList field is set.
   */
  @java.lang.Override
  public boolean hasValueList() {
    return filterCase_ == 101;
  }
  /**
   *
   *
   * <pre>
   * Optional. Value is found in the specified list.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.ValueListFilter value_list = 101 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The valueList.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ValueListFilter getValueList() {
    if (filterCase_ == 101) {
      return (com.google.cloud.clouddms.v1.ValueListFilter) filter_;
    }
    return com.google.cloud.clouddms.v1.ValueListFilter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Value is found in the specified list.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.ValueListFilter value_list = 101 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ValueListFilterOrBuilder getValueListOrBuilder() {
    if (filterCase_ == 101) {
      return (com.google.cloud.clouddms.v1.ValueListFilter) filter_;
    }
    return com.google.cloud.clouddms.v1.ValueListFilter.getDefaultInstance();
  }

  public static final int INT_COMPARISON_FIELD_NUMBER = 102;
  /**
   *
   *
   * <pre>
   * Optional. Filter on relation between source value and compare value of
   * type integer.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.IntComparisonFilter int_comparison = 102 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the intComparison field is set.
   */
  @java.lang.Override
  public boolean hasIntComparison() {
    return filterCase_ == 102;
  }
  /**
   *
   *
   * <pre>
   * Optional. Filter on relation between source value and compare value of
   * type integer.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.IntComparisonFilter int_comparison = 102 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The intComparison.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.IntComparisonFilter getIntComparison() {
    if (filterCase_ == 102) {
      return (com.google.cloud.clouddms.v1.IntComparisonFilter) filter_;
    }
    return com.google.cloud.clouddms.v1.IntComparisonFilter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Filter on relation between source value and compare value of
   * type integer.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.IntComparisonFilter int_comparison = 102 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.IntComparisonFilterOrBuilder getIntComparisonOrBuilder() {
    if (filterCase_ == 102) {
      return (com.google.cloud.clouddms.v1.IntComparisonFilter) filter_;
    }
    return com.google.cloud.clouddms.v1.IntComparisonFilter.getDefaultInstance();
  }

  public static final int DOUBLE_COMPARISON_FIELD_NUMBER = 103;
  /**
   *
   *
   * <pre>
   * Optional. Filter on relation between source value and compare value of
   * type double.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.DoubleComparisonFilter double_comparison = 103 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the doubleComparison field is set.
   */
  @java.lang.Override
  public boolean hasDoubleComparison() {
    return filterCase_ == 103;
  }
  /**
   *
   *
   * <pre>
   * Optional. Filter on relation between source value and compare value of
   * type double.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.DoubleComparisonFilter double_comparison = 103 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The doubleComparison.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DoubleComparisonFilter getDoubleComparison() {
    if (filterCase_ == 103) {
      return (com.google.cloud.clouddms.v1.DoubleComparisonFilter) filter_;
    }
    return com.google.cloud.clouddms.v1.DoubleComparisonFilter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Filter on relation between source value and compare value of
   * type double.
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.DoubleComparisonFilter double_comparison = 103 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.DoubleComparisonFilterOrBuilder
      getDoubleComparisonOrBuilder() {
    if (filterCase_ == 103) {
      return (com.google.cloud.clouddms.v1.DoubleComparisonFilter) filter_;
    }
    return com.google.cloud.clouddms.v1.DoubleComparisonFilter.getDefaultInstance();
  }

  public static final int ASSIGN_NULL_FIELD_NUMBER = 200;
  /**
   *
   *
   * <pre>
   * Optional. Set to null
   * </pre>
   *
   * <code>.google.protobuf.Empty assign_null = 200 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the assignNull field is set.
   */
  @java.lang.Override
  public boolean hasAssignNull() {
    return actionCase_ == 200;
  }
  /**
   *
   *
   * <pre>
   * Optional. Set to null
   * </pre>
   *
   * <code>.google.protobuf.Empty assign_null = 200 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The assignNull.
   */
  @java.lang.Override
  public com.google.protobuf.Empty getAssignNull() {
    if (actionCase_ == 200) {
      return (com.google.protobuf.Empty) action_;
    }
    return com.google.protobuf.Empty.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Set to null
   * </pre>
   *
   * <code>.google.protobuf.Empty assign_null = 200 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.EmptyOrBuilder getAssignNullOrBuilder() {
    if (actionCase_ == 200) {
      return (com.google.protobuf.Empty) action_;
    }
    return com.google.protobuf.Empty.getDefaultInstance();
  }

  public static final int ASSIGN_SPECIFIC_VALUE_FIELD_NUMBER = 201;
  /**
   *
   *
   * <pre>
   * Optional. Set to a specific value (value is converted to fit the target
   * data type)
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.AssignSpecificValue assign_specific_value = 201 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the assignSpecificValue field is set.
   */
  @java.lang.Override
  public boolean hasAssignSpecificValue() {
    return actionCase_ == 201;
  }
  /**
   *
   *
   * <pre>
   * Optional. Set to a specific value (value is converted to fit the target
   * data type)
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.AssignSpecificValue assign_specific_value = 201 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The assignSpecificValue.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.AssignSpecificValue getAssignSpecificValue() {
    if (actionCase_ == 201) {
      return (com.google.cloud.clouddms.v1.AssignSpecificValue) action_;
    }
    return com.google.cloud.clouddms.v1.AssignSpecificValue.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Set to a specific value (value is converted to fit the target
   * data type)
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.AssignSpecificValue assign_specific_value = 201 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.AssignSpecificValueOrBuilder
      getAssignSpecificValueOrBuilder() {
    if (actionCase_ == 201) {
      return (com.google.cloud.clouddms.v1.AssignSpecificValue) action_;
    }
    return com.google.cloud.clouddms.v1.AssignSpecificValue.getDefaultInstance();
  }

  public static final int ASSIGN_MIN_VALUE_FIELD_NUMBER = 202;
  /**
   *
   *
   * <pre>
   * Optional. Set to min_value - if integer or numeric, will use
   * int.minvalue, etc
   * </pre>
   *
   * <code>.google.protobuf.Empty assign_min_value = 202 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the assignMinValue field is set.
   */
  @java.lang.Override
  public boolean hasAssignMinValue() {
    return actionCase_ == 202;
  }
  /**
   *
   *
   * <pre>
   * Optional. Set to min_value - if integer or numeric, will use
   * int.minvalue, etc
   * </pre>
   *
   * <code>.google.protobuf.Empty assign_min_value = 202 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The assignMinValue.
   */
  @java.lang.Override
  public com.google.protobuf.Empty getAssignMinValue() {
    if (actionCase_ == 202) {
      return (com.google.protobuf.Empty) action_;
    }
    return com.google.protobuf.Empty.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Set to min_value - if integer or numeric, will use
   * int.minvalue, etc
   * </pre>
   *
   * <code>.google.protobuf.Empty assign_min_value = 202 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.EmptyOrBuilder getAssignMinValueOrBuilder() {
    if (actionCase_ == 202) {
      return (com.google.protobuf.Empty) action_;
    }
    return com.google.protobuf.Empty.getDefaultInstance();
  }

  public static final int ASSIGN_MAX_VALUE_FIELD_NUMBER = 203;
  /**
   *
   *
   * <pre>
   * Optional. Set to max_value - if integer or numeric, will use
   * int.maxvalue, etc
   * </pre>
   *
   * <code>.google.protobuf.Empty assign_max_value = 203 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the assignMaxValue field is set.
   */
  @java.lang.Override
  public boolean hasAssignMaxValue() {
    return actionCase_ == 203;
  }
  /**
   *
   *
   * <pre>
   * Optional. Set to max_value - if integer or numeric, will use
   * int.maxvalue, etc
   * </pre>
   *
   * <code>.google.protobuf.Empty assign_max_value = 203 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The assignMaxValue.
   */
  @java.lang.Override
  public com.google.protobuf.Empty getAssignMaxValue() {
    if (actionCase_ == 203) {
      return (com.google.protobuf.Empty) action_;
    }
    return com.google.protobuf.Empty.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Set to max_value - if integer or numeric, will use
   * int.maxvalue, etc
   * </pre>
   *
   * <code>.google.protobuf.Empty assign_max_value = 203 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.EmptyOrBuilder getAssignMaxValueOrBuilder() {
    if (actionCase_ == 203) {
      return (com.google.protobuf.Empty) action_;
    }
    return com.google.protobuf.Empty.getDefaultInstance();
  }

  public static final int ROUND_SCALE_FIELD_NUMBER = 204;
  /**
   *
   *
   * <pre>
   * Optional. Allows the data to change scale
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.RoundToScale round_scale = 204 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the roundScale field is set.
   */
  @java.lang.Override
  public boolean hasRoundScale() {
    return actionCase_ == 204;
  }
  /**
   *
   *
   * <pre>
   * Optional. Allows the data to change scale
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.RoundToScale round_scale = 204 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The roundScale.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.RoundToScale getRoundScale() {
    if (actionCase_ == 204) {
      return (com.google.cloud.clouddms.v1.RoundToScale) action_;
    }
    return com.google.cloud.clouddms.v1.RoundToScale.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Allows the data to change scale
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.RoundToScale round_scale = 204 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.RoundToScaleOrBuilder getRoundScaleOrBuilder() {
    if (actionCase_ == 204) {
      return (com.google.cloud.clouddms.v1.RoundToScale) action_;
    }
    return com.google.cloud.clouddms.v1.RoundToScale.getDefaultInstance();
  }

  public static final int APPLY_HASH_FIELD_NUMBER = 205;
  /**
   *
   *
   * <pre>
   * Optional. Applies a hash function on the data
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.ApplyHash apply_hash = 205 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the applyHash field is set.
   */
  @java.lang.Override
  public boolean hasApplyHash() {
    return actionCase_ == 205;
  }
  /**
   *
   *
   * <pre>
   * Optional. Applies a hash function on the data
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.ApplyHash apply_hash = 205 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The applyHash.
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ApplyHash getApplyHash() {
    if (actionCase_ == 205) {
      return (com.google.cloud.clouddms.v1.ApplyHash) action_;
    }
    return com.google.cloud.clouddms.v1.ApplyHash.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Applies a hash function on the data
   * </pre>
   *
   * <code>
   * .google.cloud.clouddms.v1.ApplyHash apply_hash = 205 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.clouddms.v1.ApplyHashOrBuilder getApplyHashOrBuilder() {
    if (actionCase_ == 205) {
      return (com.google.cloud.clouddms.v1.ApplyHash) action_;
    }
    return com.google.cloud.clouddms.v1.ApplyHash.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (filterCase_ == 100) {
      output.writeMessage(100, (com.google.protobuf.Empty) filter_);
    }
    if (filterCase_ == 101) {
      output.writeMessage(101, (com.google.cloud.clouddms.v1.ValueListFilter) filter_);
    }
    if (filterCase_ == 102) {
      output.writeMessage(102, (com.google.cloud.clouddms.v1.IntComparisonFilter) filter_);
    }
    if (filterCase_ == 103) {
      output.writeMessage(103, (com.google.cloud.clouddms.v1.DoubleComparisonFilter) filter_);
    }
    if (actionCase_ == 200) {
      output.writeMessage(200, (com.google.protobuf.Empty) action_);
    }
    if (actionCase_ == 201) {
      output.writeMessage(201, (com.google.cloud.clouddms.v1.AssignSpecificValue) action_);
    }
    if (actionCase_ == 202) {
      output.writeMessage(202, (com.google.protobuf.Empty) action_);
    }
    if (actionCase_ == 203) {
      output.writeMessage(203, (com.google.protobuf.Empty) action_);
    }
    if (actionCase_ == 204) {
      output.writeMessage(204, (com.google.cloud.clouddms.v1.RoundToScale) action_);
    }
    if (actionCase_ == 205) {
      output.writeMessage(205, (com.google.cloud.clouddms.v1.ApplyHash) action_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (filterCase_ == 100) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              100, (com.google.protobuf.Empty) filter_);
    }
    if (filterCase_ == 101) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              101, (com.google.cloud.clouddms.v1.ValueListFilter) filter_);
    }
    if (filterCase_ == 102) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              102, (com.google.cloud.clouddms.v1.IntComparisonFilter) filter_);
    }
    if (filterCase_ == 103) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              103, (com.google.cloud.clouddms.v1.DoubleComparisonFilter) filter_);
    }
    if (actionCase_ == 200) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              200, (com.google.protobuf.Empty) action_);
    }
    if (actionCase_ == 201) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              201, (com.google.cloud.clouddms.v1.AssignSpecificValue) action_);
    }
    if (actionCase_ == 202) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              202, (com.google.protobuf.Empty) action_);
    }
    if (actionCase_ == 203) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              203, (com.google.protobuf.Empty) action_);
    }
    if (actionCase_ == 204) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              204, (com.google.cloud.clouddms.v1.RoundToScale) action_);
    }
    if (actionCase_ == 205) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              205, (com.google.cloud.clouddms.v1.ApplyHash) action_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.clouddms.v1.ValueTransformation)) {
      return super.equals(obj);
    }
    com.google.cloud.clouddms.v1.ValueTransformation other =
        (com.google.cloud.clouddms.v1.ValueTransformation) obj;

    if (!getFilterCase().equals(other.getFilterCase())) return false;
    switch (filterCase_) {
      case 100:
        if (!getIsNull().equals(other.getIsNull())) return false;
        break;
      case 101:
        if (!getValueList().equals(other.getValueList())) return false;
        break;
      case 102:
        if (!getIntComparison().equals(other.getIntComparison())) return false;
        break;
      case 103:
        if (!getDoubleComparison().equals(other.getDoubleComparison())) return false;
        break;
      case 0:
      default:
    }
    if (!getActionCase().equals(other.getActionCase())) return false;
    switch (actionCase_) {
      case 200:
        if (!getAssignNull().equals(other.getAssignNull())) return false;
        break;
      case 201:
        if (!getAssignSpecificValue().equals(other.getAssignSpecificValue())) return false;
        break;
      case 202:
        if (!getAssignMinValue().equals(other.getAssignMinValue())) return false;
        break;
      case 203:
        if (!getAssignMaxValue().equals(other.getAssignMaxValue())) return false;
        break;
      case 204:
        if (!getRoundScale().equals(other.getRoundScale())) return false;
        break;
      case 205:
        if (!getApplyHash().equals(other.getApplyHash())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (filterCase_) {
      case 100:
        hash = (37 * hash) + IS_NULL_FIELD_NUMBER;
        hash = (53 * hash) + getIsNull().hashCode();
        break;
      case 101:
        hash = (37 * hash) + VALUE_LIST_FIELD_NUMBER;
        hash = (53 * hash) + getValueList().hashCode();
        break;
      case 102:
        hash = (37 * hash) + INT_COMPARISON_FIELD_NUMBER;
        hash = (53 * hash) + getIntComparison().hashCode();
        break;
      case 103:
        hash = (37 * hash) + DOUBLE_COMPARISON_FIELD_NUMBER;
        hash = (53 * hash) + getDoubleComparison().hashCode();
        break;
      case 0:
      default:
    }
    switch (actionCase_) {
      case 200:
        hash = (37 * hash) + ASSIGN_NULL_FIELD_NUMBER;
        hash = (53 * hash) + getAssignNull().hashCode();
        break;
      case 201:
        hash = (37 * hash) + ASSIGN_SPECIFIC_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getAssignSpecificValue().hashCode();
        break;
      case 202:
        hash = (37 * hash) + ASSIGN_MIN_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getAssignMinValue().hashCode();
        break;
      case 203:
        hash = (37 * hash) + ASSIGN_MAX_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getAssignMaxValue().hashCode();
        break;
      case 204:
        hash = (37 * hash) + ROUND_SCALE_FIELD_NUMBER;
        hash = (53 * hash) + getRoundScale().hashCode();
        break;
      case 205:
        hash = (37 * hash) + APPLY_HASH_FIELD_NUMBER;
        hash = (53 * hash) + getApplyHash().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.clouddms.v1.ValueTransformation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ValueTransformation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ValueTransformation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ValueTransformation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ValueTransformation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.clouddms.v1.ValueTransformation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ValueTransformation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ValueTransformation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ValueTransformation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ValueTransformation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.clouddms.v1.ValueTransformation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.clouddms.v1.ValueTransformation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.clouddms.v1.ValueTransformation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Description of data transformation during migration as part of the
   * ConditionalColumnSetValue.
   * </pre>
   *
   * Protobuf type {@code google.cloud.clouddms.v1.ValueTransformation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.clouddms.v1.ValueTransformation)
      com.google.cloud.clouddms.v1.ValueTransformationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_ValueTransformation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_ValueTransformation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.clouddms.v1.ValueTransformation.class,
              com.google.cloud.clouddms.v1.ValueTransformation.Builder.class);
    }

    // Construct using com.google.cloud.clouddms.v1.ValueTransformation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (isNullBuilder_ != null) {
        isNullBuilder_.clear();
      }
      if (valueListBuilder_ != null) {
        valueListBuilder_.clear();
      }
      if (intComparisonBuilder_ != null) {
        intComparisonBuilder_.clear();
      }
      if (doubleComparisonBuilder_ != null) {
        doubleComparisonBuilder_.clear();
      }
      if (assignNullBuilder_ != null) {
        assignNullBuilder_.clear();
      }
      if (assignSpecificValueBuilder_ != null) {
        assignSpecificValueBuilder_.clear();
      }
      if (assignMinValueBuilder_ != null) {
        assignMinValueBuilder_.clear();
      }
      if (assignMaxValueBuilder_ != null) {
        assignMaxValueBuilder_.clear();
      }
      if (roundScaleBuilder_ != null) {
        roundScaleBuilder_.clear();
      }
      if (applyHashBuilder_ != null) {
        applyHashBuilder_.clear();
      }
      filterCase_ = 0;
      filter_ = null;
      actionCase_ = 0;
      action_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.clouddms.v1.ConversionWorkspaceResourcesProto
          .internal_static_google_cloud_clouddms_v1_ValueTransformation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ValueTransformation getDefaultInstanceForType() {
      return com.google.cloud.clouddms.v1.ValueTransformation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ValueTransformation build() {
      com.google.cloud.clouddms.v1.ValueTransformation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.clouddms.v1.ValueTransformation buildPartial() {
      com.google.cloud.clouddms.v1.ValueTransformation result =
          new com.google.cloud.clouddms.v1.ValueTransformation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.clouddms.v1.ValueTransformation result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.clouddms.v1.ValueTransformation result) {
      result.filterCase_ = filterCase_;
      result.filter_ = this.filter_;
      if (filterCase_ == 100 && isNullBuilder_ != null) {
        result.filter_ = isNullBuilder_.build();
      }
      if (filterCase_ == 101 && valueListBuilder_ != null) {
        result.filter_ = valueListBuilder_.build();
      }
      if (filterCase_ == 102 && intComparisonBuilder_ != null) {
        result.filter_ = intComparisonBuilder_.build();
      }
      if (filterCase_ == 103 && doubleComparisonBuilder_ != null) {
        result.filter_ = doubleComparisonBuilder_.build();
      }
      result.actionCase_ = actionCase_;
      result.action_ = this.action_;
      if (actionCase_ == 200 && assignNullBuilder_ != null) {
        result.action_ = assignNullBuilder_.build();
      }
      if (actionCase_ == 201 && assignSpecificValueBuilder_ != null) {
        result.action_ = assignSpecificValueBuilder_.build();
      }
      if (actionCase_ == 202 && assignMinValueBuilder_ != null) {
        result.action_ = assignMinValueBuilder_.build();
      }
      if (actionCase_ == 203 && assignMaxValueBuilder_ != null) {
        result.action_ = assignMaxValueBuilder_.build();
      }
      if (actionCase_ == 204 && roundScaleBuilder_ != null) {
        result.action_ = roundScaleBuilder_.build();
      }
      if (actionCase_ == 205 && applyHashBuilder_ != null) {
        result.action_ = applyHashBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.clouddms.v1.ValueTransformation) {
        return mergeFrom((com.google.cloud.clouddms.v1.ValueTransformation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.clouddms.v1.ValueTransformation other) {
      if (other == com.google.cloud.clouddms.v1.ValueTransformation.getDefaultInstance())
        return this;
      switch (other.getFilterCase()) {
        case IS_NULL:
          {
            mergeIsNull(other.getIsNull());
            break;
          }
        case VALUE_LIST:
          {
            mergeValueList(other.getValueList());
            break;
          }
        case INT_COMPARISON:
          {
            mergeIntComparison(other.getIntComparison());
            break;
          }
        case DOUBLE_COMPARISON:
          {
            mergeDoubleComparison(other.getDoubleComparison());
            break;
          }
        case FILTER_NOT_SET:
          {
            break;
          }
      }
      switch (other.getActionCase()) {
        case ASSIGN_NULL:
          {
            mergeAssignNull(other.getAssignNull());
            break;
          }
        case ASSIGN_SPECIFIC_VALUE:
          {
            mergeAssignSpecificValue(other.getAssignSpecificValue());
            break;
          }
        case ASSIGN_MIN_VALUE:
          {
            mergeAssignMinValue(other.getAssignMinValue());
            break;
          }
        case ASSIGN_MAX_VALUE:
          {
            mergeAssignMaxValue(other.getAssignMaxValue());
            break;
          }
        case ROUND_SCALE:
          {
            mergeRoundScale(other.getRoundScale());
            break;
          }
        case APPLY_HASH:
          {
            mergeApplyHash(other.getApplyHash());
            break;
          }
        case ACTION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 802:
              {
                input.readMessage(getIsNullFieldBuilder().getBuilder(), extensionRegistry);
                filterCase_ = 100;
                break;
              } // case 802
            case 810:
              {
                input.readMessage(getValueListFieldBuilder().getBuilder(), extensionRegistry);
                filterCase_ = 101;
                break;
              } // case 810
            case 818:
              {
                input.readMessage(getIntComparisonFieldBuilder().getBuilder(), extensionRegistry);
                filterCase_ = 102;
                break;
              } // case 818
            case 826:
              {
                input.readMessage(
                    getDoubleComparisonFieldBuilder().getBuilder(), extensionRegistry);
                filterCase_ = 103;
                break;
              } // case 826
            case 1602:
              {
                input.readMessage(getAssignNullFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 200;
                break;
              } // case 1602
            case 1610:
              {
                input.readMessage(
                    getAssignSpecificValueFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 201;
                break;
              } // case 1610
            case 1618:
              {
                input.readMessage(getAssignMinValueFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 202;
                break;
              } // case 1618
            case 1626:
              {
                input.readMessage(getAssignMaxValueFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 203;
                break;
              } // case 1626
            case 1634:
              {
                input.readMessage(getRoundScaleFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 204;
                break;
              } // case 1634
            case 1642:
              {
                input.readMessage(getApplyHashFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 205;
                break;
              } // case 1642
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int filterCase_ = 0;
    private java.lang.Object filter_;

    public FilterCase getFilterCase() {
      return FilterCase.forNumber(filterCase_);
    }

    public Builder clearFilter() {
      filterCase_ = 0;
      filter_ = null;
      onChanged();
      return this;
    }

    private int actionCase_ = 0;
    private java.lang.Object action_;

    public ActionCase getActionCase() {
      return ActionCase.forNumber(actionCase_);
    }

    public Builder clearAction() {
      actionCase_ = 0;
      action_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Empty,
            com.google.protobuf.Empty.Builder,
            com.google.protobuf.EmptyOrBuilder>
        isNullBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Value is null
     * </pre>
     *
     * <code>.google.protobuf.Empty is_null = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the isNull field is set.
     */
    @java.lang.Override
    public boolean hasIsNull() {
      return filterCase_ == 100;
    }
    /**
     *
     *
     * <pre>
     * Optional. Value is null
     * </pre>
     *
     * <code>.google.protobuf.Empty is_null = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The isNull.
     */
    @java.lang.Override
    public com.google.protobuf.Empty getIsNull() {
      if (isNullBuilder_ == null) {
        if (filterCase_ == 100) {
          return (com.google.protobuf.Empty) filter_;
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      } else {
        if (filterCase_ == 100) {
          return isNullBuilder_.getMessage();
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Value is null
     * </pre>
     *
     * <code>.google.protobuf.Empty is_null = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setIsNull(com.google.protobuf.Empty value) {
      if (isNullBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        isNullBuilder_.setMessage(value);
      }
      filterCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Value is null
     * </pre>
     *
     * <code>.google.protobuf.Empty is_null = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setIsNull(com.google.protobuf.Empty.Builder builderForValue) {
      if (isNullBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        isNullBuilder_.setMessage(builderForValue.build());
      }
      filterCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Value is null
     * </pre>
     *
     * <code>.google.protobuf.Empty is_null = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder mergeIsNull(com.google.protobuf.Empty value) {
      if (isNullBuilder_ == null) {
        if (filterCase_ == 100 && filter_ != com.google.protobuf.Empty.getDefaultInstance()) {
          filter_ =
              com.google.protobuf.Empty.newBuilder((com.google.protobuf.Empty) filter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        if (filterCase_ == 100) {
          isNullBuilder_.mergeFrom(value);
        } else {
          isNullBuilder_.setMessage(value);
        }
      }
      filterCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Value is null
     * </pre>
     *
     * <code>.google.protobuf.Empty is_null = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder clearIsNull() {
      if (isNullBuilder_ == null) {
        if (filterCase_ == 100) {
          filterCase_ = 0;
          filter_ = null;
          onChanged();
        }
      } else {
        if (filterCase_ == 100) {
          filterCase_ = 0;
          filter_ = null;
        }
        isNullBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Value is null
     * </pre>
     *
     * <code>.google.protobuf.Empty is_null = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.google.protobuf.Empty.Builder getIsNullBuilder() {
      return getIsNullFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Value is null
     * </pre>
     *
     * <code>.google.protobuf.Empty is_null = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public com.google.protobuf.EmptyOrBuilder getIsNullOrBuilder() {
      if ((filterCase_ == 100) && (isNullBuilder_ != null)) {
        return isNullBuilder_.getMessageOrBuilder();
      } else {
        if (filterCase_ == 100) {
          return (com.google.protobuf.Empty) filter_;
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Value is null
     * </pre>
     *
     * <code>.google.protobuf.Empty is_null = 100 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Empty,
            com.google.protobuf.Empty.Builder,
            com.google.protobuf.EmptyOrBuilder>
        getIsNullFieldBuilder() {
      if (isNullBuilder_ == null) {
        if (!(filterCase_ == 100)) {
          filter_ = com.google.protobuf.Empty.getDefaultInstance();
        }
        isNullBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Empty,
                com.google.protobuf.Empty.Builder,
                com.google.protobuf.EmptyOrBuilder>(
                (com.google.protobuf.Empty) filter_, getParentForChildren(), isClean());
        filter_ = null;
      }
      filterCase_ = 100;
      onChanged();
      return isNullBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.ValueListFilter,
            com.google.cloud.clouddms.v1.ValueListFilter.Builder,
            com.google.cloud.clouddms.v1.ValueListFilterOrBuilder>
        valueListBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Value is found in the specified list.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ValueListFilter value_list = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the valueList field is set.
     */
    @java.lang.Override
    public boolean hasValueList() {
      return filterCase_ == 101;
    }
    /**
     *
     *
     * <pre>
     * Optional. Value is found in the specified list.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ValueListFilter value_list = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The valueList.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.ValueListFilter getValueList() {
      if (valueListBuilder_ == null) {
        if (filterCase_ == 101) {
          return (com.google.cloud.clouddms.v1.ValueListFilter) filter_;
        }
        return com.google.cloud.clouddms.v1.ValueListFilter.getDefaultInstance();
      } else {
        if (filterCase_ == 101) {
          return valueListBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.ValueListFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Value is found in the specified list.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ValueListFilter value_list = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setValueList(com.google.cloud.clouddms.v1.ValueListFilter value) {
      if (valueListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        valueListBuilder_.setMessage(value);
      }
      filterCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Value is found in the specified list.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ValueListFilter value_list = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setValueList(
        com.google.cloud.clouddms.v1.ValueListFilter.Builder builderForValue) {
      if (valueListBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        valueListBuilder_.setMessage(builderForValue.build());
      }
      filterCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Value is found in the specified list.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ValueListFilter value_list = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeValueList(com.google.cloud.clouddms.v1.ValueListFilter value) {
      if (valueListBuilder_ == null) {
        if (filterCase_ == 101
            && filter_ != com.google.cloud.clouddms.v1.ValueListFilter.getDefaultInstance()) {
          filter_ =
              com.google.cloud.clouddms.v1.ValueListFilter.newBuilder(
                      (com.google.cloud.clouddms.v1.ValueListFilter) filter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        if (filterCase_ == 101) {
          valueListBuilder_.mergeFrom(value);
        } else {
          valueListBuilder_.setMessage(value);
        }
      }
      filterCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Value is found in the specified list.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ValueListFilter value_list = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearValueList() {
      if (valueListBuilder_ == null) {
        if (filterCase_ == 101) {
          filterCase_ = 0;
          filter_ = null;
          onChanged();
        }
      } else {
        if (filterCase_ == 101) {
          filterCase_ = 0;
          filter_ = null;
        }
        valueListBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Value is found in the specified list.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ValueListFilter value_list = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.ValueListFilter.Builder getValueListBuilder() {
      return getValueListFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Value is found in the specified list.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ValueListFilter value_list = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.ValueListFilterOrBuilder getValueListOrBuilder() {
      if ((filterCase_ == 101) && (valueListBuilder_ != null)) {
        return valueListBuilder_.getMessageOrBuilder();
      } else {
        if (filterCase_ == 101) {
          return (com.google.cloud.clouddms.v1.ValueListFilter) filter_;
        }
        return com.google.cloud.clouddms.v1.ValueListFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Value is found in the specified list.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ValueListFilter value_list = 101 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.ValueListFilter,
            com.google.cloud.clouddms.v1.ValueListFilter.Builder,
            com.google.cloud.clouddms.v1.ValueListFilterOrBuilder>
        getValueListFieldBuilder() {
      if (valueListBuilder_ == null) {
        if (!(filterCase_ == 101)) {
          filter_ = com.google.cloud.clouddms.v1.ValueListFilter.getDefaultInstance();
        }
        valueListBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.ValueListFilter,
                com.google.cloud.clouddms.v1.ValueListFilter.Builder,
                com.google.cloud.clouddms.v1.ValueListFilterOrBuilder>(
                (com.google.cloud.clouddms.v1.ValueListFilter) filter_,
                getParentForChildren(),
                isClean());
        filter_ = null;
      }
      filterCase_ = 101;
      onChanged();
      return valueListBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.IntComparisonFilter,
            com.google.cloud.clouddms.v1.IntComparisonFilter.Builder,
            com.google.cloud.clouddms.v1.IntComparisonFilterOrBuilder>
        intComparisonBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Filter on relation between source value and compare value of
     * type integer.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.IntComparisonFilter int_comparison = 102 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the intComparison field is set.
     */
    @java.lang.Override
    public boolean hasIntComparison() {
      return filterCase_ == 102;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter on relation between source value and compare value of
     * type integer.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.IntComparisonFilter int_comparison = 102 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The intComparison.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.IntComparisonFilter getIntComparison() {
      if (intComparisonBuilder_ == null) {
        if (filterCase_ == 102) {
          return (com.google.cloud.clouddms.v1.IntComparisonFilter) filter_;
        }
        return com.google.cloud.clouddms.v1.IntComparisonFilter.getDefaultInstance();
      } else {
        if (filterCase_ == 102) {
          return intComparisonBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.IntComparisonFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter on relation between source value and compare value of
     * type integer.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.IntComparisonFilter int_comparison = 102 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setIntComparison(com.google.cloud.clouddms.v1.IntComparisonFilter value) {
      if (intComparisonBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        intComparisonBuilder_.setMessage(value);
      }
      filterCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter on relation between source value and compare value of
     * type integer.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.IntComparisonFilter int_comparison = 102 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setIntComparison(
        com.google.cloud.clouddms.v1.IntComparisonFilter.Builder builderForValue) {
      if (intComparisonBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        intComparisonBuilder_.setMessage(builderForValue.build());
      }
      filterCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter on relation between source value and compare value of
     * type integer.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.IntComparisonFilter int_comparison = 102 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeIntComparison(com.google.cloud.clouddms.v1.IntComparisonFilter value) {
      if (intComparisonBuilder_ == null) {
        if (filterCase_ == 102
            && filter_ != com.google.cloud.clouddms.v1.IntComparisonFilter.getDefaultInstance()) {
          filter_ =
              com.google.cloud.clouddms.v1.IntComparisonFilter.newBuilder(
                      (com.google.cloud.clouddms.v1.IntComparisonFilter) filter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        if (filterCase_ == 102) {
          intComparisonBuilder_.mergeFrom(value);
        } else {
          intComparisonBuilder_.setMessage(value);
        }
      }
      filterCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter on relation between source value and compare value of
     * type integer.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.IntComparisonFilter int_comparison = 102 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearIntComparison() {
      if (intComparisonBuilder_ == null) {
        if (filterCase_ == 102) {
          filterCase_ = 0;
          filter_ = null;
          onChanged();
        }
      } else {
        if (filterCase_ == 102) {
          filterCase_ = 0;
          filter_ = null;
        }
        intComparisonBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter on relation between source value and compare value of
     * type integer.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.IntComparisonFilter int_comparison = 102 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.IntComparisonFilter.Builder getIntComparisonBuilder() {
      return getIntComparisonFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter on relation between source value and compare value of
     * type integer.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.IntComparisonFilter int_comparison = 102 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.IntComparisonFilterOrBuilder getIntComparisonOrBuilder() {
      if ((filterCase_ == 102) && (intComparisonBuilder_ != null)) {
        return intComparisonBuilder_.getMessageOrBuilder();
      } else {
        if (filterCase_ == 102) {
          return (com.google.cloud.clouddms.v1.IntComparisonFilter) filter_;
        }
        return com.google.cloud.clouddms.v1.IntComparisonFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter on relation between source value and compare value of
     * type integer.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.IntComparisonFilter int_comparison = 102 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.IntComparisonFilter,
            com.google.cloud.clouddms.v1.IntComparisonFilter.Builder,
            com.google.cloud.clouddms.v1.IntComparisonFilterOrBuilder>
        getIntComparisonFieldBuilder() {
      if (intComparisonBuilder_ == null) {
        if (!(filterCase_ == 102)) {
          filter_ = com.google.cloud.clouddms.v1.IntComparisonFilter.getDefaultInstance();
        }
        intComparisonBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.IntComparisonFilter,
                com.google.cloud.clouddms.v1.IntComparisonFilter.Builder,
                com.google.cloud.clouddms.v1.IntComparisonFilterOrBuilder>(
                (com.google.cloud.clouddms.v1.IntComparisonFilter) filter_,
                getParentForChildren(),
                isClean());
        filter_ = null;
      }
      filterCase_ = 102;
      onChanged();
      return intComparisonBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.DoubleComparisonFilter,
            com.google.cloud.clouddms.v1.DoubleComparisonFilter.Builder,
            com.google.cloud.clouddms.v1.DoubleComparisonFilterOrBuilder>
        doubleComparisonBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Filter on relation between source value and compare value of
     * type double.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DoubleComparisonFilter double_comparison = 103 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the doubleComparison field is set.
     */
    @java.lang.Override
    public boolean hasDoubleComparison() {
      return filterCase_ == 103;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter on relation between source value and compare value of
     * type double.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DoubleComparisonFilter double_comparison = 103 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The doubleComparison.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.DoubleComparisonFilter getDoubleComparison() {
      if (doubleComparisonBuilder_ == null) {
        if (filterCase_ == 103) {
          return (com.google.cloud.clouddms.v1.DoubleComparisonFilter) filter_;
        }
        return com.google.cloud.clouddms.v1.DoubleComparisonFilter.getDefaultInstance();
      } else {
        if (filterCase_ == 103) {
          return doubleComparisonBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.DoubleComparisonFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter on relation between source value and compare value of
     * type double.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DoubleComparisonFilter double_comparison = 103 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDoubleComparison(com.google.cloud.clouddms.v1.DoubleComparisonFilter value) {
      if (doubleComparisonBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        doubleComparisonBuilder_.setMessage(value);
      }
      filterCase_ = 103;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter on relation between source value and compare value of
     * type double.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DoubleComparisonFilter double_comparison = 103 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDoubleComparison(
        com.google.cloud.clouddms.v1.DoubleComparisonFilter.Builder builderForValue) {
      if (doubleComparisonBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        doubleComparisonBuilder_.setMessage(builderForValue.build());
      }
      filterCase_ = 103;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter on relation between source value and compare value of
     * type double.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DoubleComparisonFilter double_comparison = 103 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDoubleComparison(
        com.google.cloud.clouddms.v1.DoubleComparisonFilter value) {
      if (doubleComparisonBuilder_ == null) {
        if (filterCase_ == 103
            && filter_
                != com.google.cloud.clouddms.v1.DoubleComparisonFilter.getDefaultInstance()) {
          filter_ =
              com.google.cloud.clouddms.v1.DoubleComparisonFilter.newBuilder(
                      (com.google.cloud.clouddms.v1.DoubleComparisonFilter) filter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        if (filterCase_ == 103) {
          doubleComparisonBuilder_.mergeFrom(value);
        } else {
          doubleComparisonBuilder_.setMessage(value);
        }
      }
      filterCase_ = 103;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter on relation between source value and compare value of
     * type double.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DoubleComparisonFilter double_comparison = 103 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDoubleComparison() {
      if (doubleComparisonBuilder_ == null) {
        if (filterCase_ == 103) {
          filterCase_ = 0;
          filter_ = null;
          onChanged();
        }
      } else {
        if (filterCase_ == 103) {
          filterCase_ = 0;
          filter_ = null;
        }
        doubleComparisonBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter on relation between source value and compare value of
     * type double.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DoubleComparisonFilter double_comparison = 103 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.DoubleComparisonFilter.Builder
        getDoubleComparisonBuilder() {
      return getDoubleComparisonFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter on relation between source value and compare value of
     * type double.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DoubleComparisonFilter double_comparison = 103 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.DoubleComparisonFilterOrBuilder
        getDoubleComparisonOrBuilder() {
      if ((filterCase_ == 103) && (doubleComparisonBuilder_ != null)) {
        return doubleComparisonBuilder_.getMessageOrBuilder();
      } else {
        if (filterCase_ == 103) {
          return (com.google.cloud.clouddms.v1.DoubleComparisonFilter) filter_;
        }
        return com.google.cloud.clouddms.v1.DoubleComparisonFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter on relation between source value and compare value of
     * type double.
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.DoubleComparisonFilter double_comparison = 103 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.DoubleComparisonFilter,
            com.google.cloud.clouddms.v1.DoubleComparisonFilter.Builder,
            com.google.cloud.clouddms.v1.DoubleComparisonFilterOrBuilder>
        getDoubleComparisonFieldBuilder() {
      if (doubleComparisonBuilder_ == null) {
        if (!(filterCase_ == 103)) {
          filter_ = com.google.cloud.clouddms.v1.DoubleComparisonFilter.getDefaultInstance();
        }
        doubleComparisonBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.DoubleComparisonFilter,
                com.google.cloud.clouddms.v1.DoubleComparisonFilter.Builder,
                com.google.cloud.clouddms.v1.DoubleComparisonFilterOrBuilder>(
                (com.google.cloud.clouddms.v1.DoubleComparisonFilter) filter_,
                getParentForChildren(),
                isClean());
        filter_ = null;
      }
      filterCase_ = 103;
      onChanged();
      return doubleComparisonBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Empty,
            com.google.protobuf.Empty.Builder,
            com.google.protobuf.EmptyOrBuilder>
        assignNullBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Set to null
     * </pre>
     *
     * <code>.google.protobuf.Empty assign_null = 200 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the assignNull field is set.
     */
    @java.lang.Override
    public boolean hasAssignNull() {
      return actionCase_ == 200;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to null
     * </pre>
     *
     * <code>.google.protobuf.Empty assign_null = 200 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The assignNull.
     */
    @java.lang.Override
    public com.google.protobuf.Empty getAssignNull() {
      if (assignNullBuilder_ == null) {
        if (actionCase_ == 200) {
          return (com.google.protobuf.Empty) action_;
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      } else {
        if (actionCase_ == 200) {
          return assignNullBuilder_.getMessage();
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to null
     * </pre>
     *
     * <code>.google.protobuf.Empty assign_null = 200 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAssignNull(com.google.protobuf.Empty value) {
      if (assignNullBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        assignNullBuilder_.setMessage(value);
      }
      actionCase_ = 200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to null
     * </pre>
     *
     * <code>.google.protobuf.Empty assign_null = 200 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAssignNull(com.google.protobuf.Empty.Builder builderForValue) {
      if (assignNullBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        assignNullBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to null
     * </pre>
     *
     * <code>.google.protobuf.Empty assign_null = 200 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAssignNull(com.google.protobuf.Empty value) {
      if (assignNullBuilder_ == null) {
        if (actionCase_ == 200 && action_ != com.google.protobuf.Empty.getDefaultInstance()) {
          action_ =
              com.google.protobuf.Empty.newBuilder((com.google.protobuf.Empty) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 200) {
          assignNullBuilder_.mergeFrom(value);
        } else {
          assignNullBuilder_.setMessage(value);
        }
      }
      actionCase_ = 200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to null
     * </pre>
     *
     * <code>.google.protobuf.Empty assign_null = 200 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAssignNull() {
      if (assignNullBuilder_ == null) {
        if (actionCase_ == 200) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 200) {
          actionCase_ = 0;
          action_ = null;
        }
        assignNullBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to null
     * </pre>
     *
     * <code>.google.protobuf.Empty assign_null = 200 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Empty.Builder getAssignNullBuilder() {
      return getAssignNullFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to null
     * </pre>
     *
     * <code>.google.protobuf.Empty assign_null = 200 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.EmptyOrBuilder getAssignNullOrBuilder() {
      if ((actionCase_ == 200) && (assignNullBuilder_ != null)) {
        return assignNullBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 200) {
          return (com.google.protobuf.Empty) action_;
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to null
     * </pre>
     *
     * <code>.google.protobuf.Empty assign_null = 200 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Empty,
            com.google.protobuf.Empty.Builder,
            com.google.protobuf.EmptyOrBuilder>
        getAssignNullFieldBuilder() {
      if (assignNullBuilder_ == null) {
        if (!(actionCase_ == 200)) {
          action_ = com.google.protobuf.Empty.getDefaultInstance();
        }
        assignNullBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Empty,
                com.google.protobuf.Empty.Builder,
                com.google.protobuf.EmptyOrBuilder>(
                (com.google.protobuf.Empty) action_, getParentForChildren(), isClean());
        action_ = null;
      }
      actionCase_ = 200;
      onChanged();
      return assignNullBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.AssignSpecificValue,
            com.google.cloud.clouddms.v1.AssignSpecificValue.Builder,
            com.google.cloud.clouddms.v1.AssignSpecificValueOrBuilder>
        assignSpecificValueBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Set to a specific value (value is converted to fit the target
     * data type)
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AssignSpecificValue assign_specific_value = 201 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the assignSpecificValue field is set.
     */
    @java.lang.Override
    public boolean hasAssignSpecificValue() {
      return actionCase_ == 201;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to a specific value (value is converted to fit the target
     * data type)
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AssignSpecificValue assign_specific_value = 201 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The assignSpecificValue.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.AssignSpecificValue getAssignSpecificValue() {
      if (assignSpecificValueBuilder_ == null) {
        if (actionCase_ == 201) {
          return (com.google.cloud.clouddms.v1.AssignSpecificValue) action_;
        }
        return com.google.cloud.clouddms.v1.AssignSpecificValue.getDefaultInstance();
      } else {
        if (actionCase_ == 201) {
          return assignSpecificValueBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.AssignSpecificValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to a specific value (value is converted to fit the target
     * data type)
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AssignSpecificValue assign_specific_value = 201 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAssignSpecificValue(com.google.cloud.clouddms.v1.AssignSpecificValue value) {
      if (assignSpecificValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        assignSpecificValueBuilder_.setMessage(value);
      }
      actionCase_ = 201;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to a specific value (value is converted to fit the target
     * data type)
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AssignSpecificValue assign_specific_value = 201 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAssignSpecificValue(
        com.google.cloud.clouddms.v1.AssignSpecificValue.Builder builderForValue) {
      if (assignSpecificValueBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        assignSpecificValueBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 201;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to a specific value (value is converted to fit the target
     * data type)
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AssignSpecificValue assign_specific_value = 201 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAssignSpecificValue(
        com.google.cloud.clouddms.v1.AssignSpecificValue value) {
      if (assignSpecificValueBuilder_ == null) {
        if (actionCase_ == 201
            && action_ != com.google.cloud.clouddms.v1.AssignSpecificValue.getDefaultInstance()) {
          action_ =
              com.google.cloud.clouddms.v1.AssignSpecificValue.newBuilder(
                      (com.google.cloud.clouddms.v1.AssignSpecificValue) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 201) {
          assignSpecificValueBuilder_.mergeFrom(value);
        } else {
          assignSpecificValueBuilder_.setMessage(value);
        }
      }
      actionCase_ = 201;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to a specific value (value is converted to fit the target
     * data type)
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AssignSpecificValue assign_specific_value = 201 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAssignSpecificValue() {
      if (assignSpecificValueBuilder_ == null) {
        if (actionCase_ == 201) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 201) {
          actionCase_ = 0;
          action_ = null;
        }
        assignSpecificValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to a specific value (value is converted to fit the target
     * data type)
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AssignSpecificValue assign_specific_value = 201 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.AssignSpecificValue.Builder
        getAssignSpecificValueBuilder() {
      return getAssignSpecificValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to a specific value (value is converted to fit the target
     * data type)
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AssignSpecificValue assign_specific_value = 201 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.AssignSpecificValueOrBuilder
        getAssignSpecificValueOrBuilder() {
      if ((actionCase_ == 201) && (assignSpecificValueBuilder_ != null)) {
        return assignSpecificValueBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 201) {
          return (com.google.cloud.clouddms.v1.AssignSpecificValue) action_;
        }
        return com.google.cloud.clouddms.v1.AssignSpecificValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to a specific value (value is converted to fit the target
     * data type)
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.AssignSpecificValue assign_specific_value = 201 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.AssignSpecificValue,
            com.google.cloud.clouddms.v1.AssignSpecificValue.Builder,
            com.google.cloud.clouddms.v1.AssignSpecificValueOrBuilder>
        getAssignSpecificValueFieldBuilder() {
      if (assignSpecificValueBuilder_ == null) {
        if (!(actionCase_ == 201)) {
          action_ = com.google.cloud.clouddms.v1.AssignSpecificValue.getDefaultInstance();
        }
        assignSpecificValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.AssignSpecificValue,
                com.google.cloud.clouddms.v1.AssignSpecificValue.Builder,
                com.google.cloud.clouddms.v1.AssignSpecificValueOrBuilder>(
                (com.google.cloud.clouddms.v1.AssignSpecificValue) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 201;
      onChanged();
      return assignSpecificValueBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Empty,
            com.google.protobuf.Empty.Builder,
            com.google.protobuf.EmptyOrBuilder>
        assignMinValueBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Set to min_value - if integer or numeric, will use
     * int.minvalue, etc
     * </pre>
     *
     * <code>
     * .google.protobuf.Empty assign_min_value = 202 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the assignMinValue field is set.
     */
    @java.lang.Override
    public boolean hasAssignMinValue() {
      return actionCase_ == 202;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to min_value - if integer or numeric, will use
     * int.minvalue, etc
     * </pre>
     *
     * <code>
     * .google.protobuf.Empty assign_min_value = 202 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The assignMinValue.
     */
    @java.lang.Override
    public com.google.protobuf.Empty getAssignMinValue() {
      if (assignMinValueBuilder_ == null) {
        if (actionCase_ == 202) {
          return (com.google.protobuf.Empty) action_;
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      } else {
        if (actionCase_ == 202) {
          return assignMinValueBuilder_.getMessage();
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to min_value - if integer or numeric, will use
     * int.minvalue, etc
     * </pre>
     *
     * <code>
     * .google.protobuf.Empty assign_min_value = 202 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAssignMinValue(com.google.protobuf.Empty value) {
      if (assignMinValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        assignMinValueBuilder_.setMessage(value);
      }
      actionCase_ = 202;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to min_value - if integer or numeric, will use
     * int.minvalue, etc
     * </pre>
     *
     * <code>
     * .google.protobuf.Empty assign_min_value = 202 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAssignMinValue(com.google.protobuf.Empty.Builder builderForValue) {
      if (assignMinValueBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        assignMinValueBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 202;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to min_value - if integer or numeric, will use
     * int.minvalue, etc
     * </pre>
     *
     * <code>
     * .google.protobuf.Empty assign_min_value = 202 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAssignMinValue(com.google.protobuf.Empty value) {
      if (assignMinValueBuilder_ == null) {
        if (actionCase_ == 202 && action_ != com.google.protobuf.Empty.getDefaultInstance()) {
          action_ =
              com.google.protobuf.Empty.newBuilder((com.google.protobuf.Empty) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 202) {
          assignMinValueBuilder_.mergeFrom(value);
        } else {
          assignMinValueBuilder_.setMessage(value);
        }
      }
      actionCase_ = 202;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to min_value - if integer or numeric, will use
     * int.minvalue, etc
     * </pre>
     *
     * <code>
     * .google.protobuf.Empty assign_min_value = 202 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAssignMinValue() {
      if (assignMinValueBuilder_ == null) {
        if (actionCase_ == 202) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 202) {
          actionCase_ = 0;
          action_ = null;
        }
        assignMinValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to min_value - if integer or numeric, will use
     * int.minvalue, etc
     * </pre>
     *
     * <code>
     * .google.protobuf.Empty assign_min_value = 202 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Empty.Builder getAssignMinValueBuilder() {
      return getAssignMinValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to min_value - if integer or numeric, will use
     * int.minvalue, etc
     * </pre>
     *
     * <code>
     * .google.protobuf.Empty assign_min_value = 202 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.EmptyOrBuilder getAssignMinValueOrBuilder() {
      if ((actionCase_ == 202) && (assignMinValueBuilder_ != null)) {
        return assignMinValueBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 202) {
          return (com.google.protobuf.Empty) action_;
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to min_value - if integer or numeric, will use
     * int.minvalue, etc
     * </pre>
     *
     * <code>
     * .google.protobuf.Empty assign_min_value = 202 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Empty,
            com.google.protobuf.Empty.Builder,
            com.google.protobuf.EmptyOrBuilder>
        getAssignMinValueFieldBuilder() {
      if (assignMinValueBuilder_ == null) {
        if (!(actionCase_ == 202)) {
          action_ = com.google.protobuf.Empty.getDefaultInstance();
        }
        assignMinValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Empty,
                com.google.protobuf.Empty.Builder,
                com.google.protobuf.EmptyOrBuilder>(
                (com.google.protobuf.Empty) action_, getParentForChildren(), isClean());
        action_ = null;
      }
      actionCase_ = 202;
      onChanged();
      return assignMinValueBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Empty,
            com.google.protobuf.Empty.Builder,
            com.google.protobuf.EmptyOrBuilder>
        assignMaxValueBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Set to max_value - if integer or numeric, will use
     * int.maxvalue, etc
     * </pre>
     *
     * <code>
     * .google.protobuf.Empty assign_max_value = 203 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the assignMaxValue field is set.
     */
    @java.lang.Override
    public boolean hasAssignMaxValue() {
      return actionCase_ == 203;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to max_value - if integer or numeric, will use
     * int.maxvalue, etc
     * </pre>
     *
     * <code>
     * .google.protobuf.Empty assign_max_value = 203 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The assignMaxValue.
     */
    @java.lang.Override
    public com.google.protobuf.Empty getAssignMaxValue() {
      if (assignMaxValueBuilder_ == null) {
        if (actionCase_ == 203) {
          return (com.google.protobuf.Empty) action_;
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      } else {
        if (actionCase_ == 203) {
          return assignMaxValueBuilder_.getMessage();
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to max_value - if integer or numeric, will use
     * int.maxvalue, etc
     * </pre>
     *
     * <code>
     * .google.protobuf.Empty assign_max_value = 203 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAssignMaxValue(com.google.protobuf.Empty value) {
      if (assignMaxValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        assignMaxValueBuilder_.setMessage(value);
      }
      actionCase_ = 203;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to max_value - if integer or numeric, will use
     * int.maxvalue, etc
     * </pre>
     *
     * <code>
     * .google.protobuf.Empty assign_max_value = 203 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAssignMaxValue(com.google.protobuf.Empty.Builder builderForValue) {
      if (assignMaxValueBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        assignMaxValueBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 203;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to max_value - if integer or numeric, will use
     * int.maxvalue, etc
     * </pre>
     *
     * <code>
     * .google.protobuf.Empty assign_max_value = 203 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAssignMaxValue(com.google.protobuf.Empty value) {
      if (assignMaxValueBuilder_ == null) {
        if (actionCase_ == 203 && action_ != com.google.protobuf.Empty.getDefaultInstance()) {
          action_ =
              com.google.protobuf.Empty.newBuilder((com.google.protobuf.Empty) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 203) {
          assignMaxValueBuilder_.mergeFrom(value);
        } else {
          assignMaxValueBuilder_.setMessage(value);
        }
      }
      actionCase_ = 203;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to max_value - if integer or numeric, will use
     * int.maxvalue, etc
     * </pre>
     *
     * <code>
     * .google.protobuf.Empty assign_max_value = 203 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAssignMaxValue() {
      if (assignMaxValueBuilder_ == null) {
        if (actionCase_ == 203) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 203) {
          actionCase_ = 0;
          action_ = null;
        }
        assignMaxValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to max_value - if integer or numeric, will use
     * int.maxvalue, etc
     * </pre>
     *
     * <code>
     * .google.protobuf.Empty assign_max_value = 203 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Empty.Builder getAssignMaxValueBuilder() {
      return getAssignMaxValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to max_value - if integer or numeric, will use
     * int.maxvalue, etc
     * </pre>
     *
     * <code>
     * .google.protobuf.Empty assign_max_value = 203 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.EmptyOrBuilder getAssignMaxValueOrBuilder() {
      if ((actionCase_ == 203) && (assignMaxValueBuilder_ != null)) {
        return assignMaxValueBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 203) {
          return (com.google.protobuf.Empty) action_;
        }
        return com.google.protobuf.Empty.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Set to max_value - if integer or numeric, will use
     * int.maxvalue, etc
     * </pre>
     *
     * <code>
     * .google.protobuf.Empty assign_max_value = 203 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Empty,
            com.google.protobuf.Empty.Builder,
            com.google.protobuf.EmptyOrBuilder>
        getAssignMaxValueFieldBuilder() {
      if (assignMaxValueBuilder_ == null) {
        if (!(actionCase_ == 203)) {
          action_ = com.google.protobuf.Empty.getDefaultInstance();
        }
        assignMaxValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Empty,
                com.google.protobuf.Empty.Builder,
                com.google.protobuf.EmptyOrBuilder>(
                (com.google.protobuf.Empty) action_, getParentForChildren(), isClean());
        action_ = null;
      }
      actionCase_ = 203;
      onChanged();
      return assignMaxValueBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.RoundToScale,
            com.google.cloud.clouddms.v1.RoundToScale.Builder,
            com.google.cloud.clouddms.v1.RoundToScaleOrBuilder>
        roundScaleBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Allows the data to change scale
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.RoundToScale round_scale = 204 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the roundScale field is set.
     */
    @java.lang.Override
    public boolean hasRoundScale() {
      return actionCase_ == 204;
    }
    /**
     *
     *
     * <pre>
     * Optional. Allows the data to change scale
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.RoundToScale round_scale = 204 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The roundScale.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.RoundToScale getRoundScale() {
      if (roundScaleBuilder_ == null) {
        if (actionCase_ == 204) {
          return (com.google.cloud.clouddms.v1.RoundToScale) action_;
        }
        return com.google.cloud.clouddms.v1.RoundToScale.getDefaultInstance();
      } else {
        if (actionCase_ == 204) {
          return roundScaleBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.RoundToScale.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Allows the data to change scale
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.RoundToScale round_scale = 204 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRoundScale(com.google.cloud.clouddms.v1.RoundToScale value) {
      if (roundScaleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        roundScaleBuilder_.setMessage(value);
      }
      actionCase_ = 204;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Allows the data to change scale
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.RoundToScale round_scale = 204 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRoundScale(
        com.google.cloud.clouddms.v1.RoundToScale.Builder builderForValue) {
      if (roundScaleBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        roundScaleBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 204;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Allows the data to change scale
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.RoundToScale round_scale = 204 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRoundScale(com.google.cloud.clouddms.v1.RoundToScale value) {
      if (roundScaleBuilder_ == null) {
        if (actionCase_ == 204
            && action_ != com.google.cloud.clouddms.v1.RoundToScale.getDefaultInstance()) {
          action_ =
              com.google.cloud.clouddms.v1.RoundToScale.newBuilder(
                      (com.google.cloud.clouddms.v1.RoundToScale) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 204) {
          roundScaleBuilder_.mergeFrom(value);
        } else {
          roundScaleBuilder_.setMessage(value);
        }
      }
      actionCase_ = 204;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Allows the data to change scale
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.RoundToScale round_scale = 204 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRoundScale() {
      if (roundScaleBuilder_ == null) {
        if (actionCase_ == 204) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 204) {
          actionCase_ = 0;
          action_ = null;
        }
        roundScaleBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Allows the data to change scale
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.RoundToScale round_scale = 204 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.RoundToScale.Builder getRoundScaleBuilder() {
      return getRoundScaleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Allows the data to change scale
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.RoundToScale round_scale = 204 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.RoundToScaleOrBuilder getRoundScaleOrBuilder() {
      if ((actionCase_ == 204) && (roundScaleBuilder_ != null)) {
        return roundScaleBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 204) {
          return (com.google.cloud.clouddms.v1.RoundToScale) action_;
        }
        return com.google.cloud.clouddms.v1.RoundToScale.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Allows the data to change scale
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.RoundToScale round_scale = 204 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.RoundToScale,
            com.google.cloud.clouddms.v1.RoundToScale.Builder,
            com.google.cloud.clouddms.v1.RoundToScaleOrBuilder>
        getRoundScaleFieldBuilder() {
      if (roundScaleBuilder_ == null) {
        if (!(actionCase_ == 204)) {
          action_ = com.google.cloud.clouddms.v1.RoundToScale.getDefaultInstance();
        }
        roundScaleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.RoundToScale,
                com.google.cloud.clouddms.v1.RoundToScale.Builder,
                com.google.cloud.clouddms.v1.RoundToScaleOrBuilder>(
                (com.google.cloud.clouddms.v1.RoundToScale) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 204;
      onChanged();
      return roundScaleBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.ApplyHash,
            com.google.cloud.clouddms.v1.ApplyHash.Builder,
            com.google.cloud.clouddms.v1.ApplyHashOrBuilder>
        applyHashBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Applies a hash function on the data
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ApplyHash apply_hash = 205 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the applyHash field is set.
     */
    @java.lang.Override
    public boolean hasApplyHash() {
      return actionCase_ == 205;
    }
    /**
     *
     *
     * <pre>
     * Optional. Applies a hash function on the data
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ApplyHash apply_hash = 205 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The applyHash.
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.ApplyHash getApplyHash() {
      if (applyHashBuilder_ == null) {
        if (actionCase_ == 205) {
          return (com.google.cloud.clouddms.v1.ApplyHash) action_;
        }
        return com.google.cloud.clouddms.v1.ApplyHash.getDefaultInstance();
      } else {
        if (actionCase_ == 205) {
          return applyHashBuilder_.getMessage();
        }
        return com.google.cloud.clouddms.v1.ApplyHash.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Applies a hash function on the data
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ApplyHash apply_hash = 205 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setApplyHash(com.google.cloud.clouddms.v1.ApplyHash value) {
      if (applyHashBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        applyHashBuilder_.setMessage(value);
      }
      actionCase_ = 205;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Applies a hash function on the data
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ApplyHash apply_hash = 205 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setApplyHash(com.google.cloud.clouddms.v1.ApplyHash.Builder builderForValue) {
      if (applyHashBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        applyHashBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 205;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Applies a hash function on the data
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ApplyHash apply_hash = 205 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeApplyHash(com.google.cloud.clouddms.v1.ApplyHash value) {
      if (applyHashBuilder_ == null) {
        if (actionCase_ == 205
            && action_ != com.google.cloud.clouddms.v1.ApplyHash.getDefaultInstance()) {
          action_ =
              com.google.cloud.clouddms.v1.ApplyHash.newBuilder(
                      (com.google.cloud.clouddms.v1.ApplyHash) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 205) {
          applyHashBuilder_.mergeFrom(value);
        } else {
          applyHashBuilder_.setMessage(value);
        }
      }
      actionCase_ = 205;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Applies a hash function on the data
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ApplyHash apply_hash = 205 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearApplyHash() {
      if (applyHashBuilder_ == null) {
        if (actionCase_ == 205) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 205) {
          actionCase_ = 0;
          action_ = null;
        }
        applyHashBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Applies a hash function on the data
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ApplyHash apply_hash = 205 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.clouddms.v1.ApplyHash.Builder getApplyHashBuilder() {
      return getApplyHashFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Applies a hash function on the data
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ApplyHash apply_hash = 205 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.clouddms.v1.ApplyHashOrBuilder getApplyHashOrBuilder() {
      if ((actionCase_ == 205) && (applyHashBuilder_ != null)) {
        return applyHashBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 205) {
          return (com.google.cloud.clouddms.v1.ApplyHash) action_;
        }
        return com.google.cloud.clouddms.v1.ApplyHash.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Applies a hash function on the data
     * </pre>
     *
     * <code>
     * .google.cloud.clouddms.v1.ApplyHash apply_hash = 205 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.clouddms.v1.ApplyHash,
            com.google.cloud.clouddms.v1.ApplyHash.Builder,
            com.google.cloud.clouddms.v1.ApplyHashOrBuilder>
        getApplyHashFieldBuilder() {
      if (applyHashBuilder_ == null) {
        if (!(actionCase_ == 205)) {
          action_ = com.google.cloud.clouddms.v1.ApplyHash.getDefaultInstance();
        }
        applyHashBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.clouddms.v1.ApplyHash,
                com.google.cloud.clouddms.v1.ApplyHash.Builder,
                com.google.cloud.clouddms.v1.ApplyHashOrBuilder>(
                (com.google.cloud.clouddms.v1.ApplyHash) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 205;
      onChanged();
      return applyHashBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.clouddms.v1.ValueTransformation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.clouddms.v1.ValueTransformation)
  private static final com.google.cloud.clouddms.v1.ValueTransformation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.clouddms.v1.ValueTransformation();
  }

  public static com.google.cloud.clouddms.v1.ValueTransformation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ValueTransformation> PARSER =
      new com.google.protobuf.AbstractParser<ValueTransformation>() {
        @java.lang.Override
        public ValueTransformation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ValueTransformation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ValueTransformation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.clouddms.v1.ValueTransformation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
