/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProcessorVersionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PROCESSOR_PROCESSOR_VERSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String processor;
    private final String processorVersion;

    @Deprecated
    protected ProcessorVersionName() {
        this.project = null;
        this.location = null;
        this.processor = null;
        this.processorVersion = null;
    }

    private ProcessorVersionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.processor = (String)Preconditions.checkNotNull((Object)builder.getProcessor());
        this.processorVersion = (String)Preconditions.checkNotNull((Object)builder.getProcessorVersion());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProcessor() {
        return this.processor;
    }

    public String getProcessorVersion() {
        return this.processorVersion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ProcessorVersionName of(String project, String location, String processor, String processorVersion) {
        return ProcessorVersionName.newBuilder().setProject(project).setLocation(location).setProcessor(processor).setProcessorVersion(processorVersion).build();
    }

    public static String format(String project, String location, String processor, String processorVersion) {
        return ProcessorVersionName.newBuilder().setProject(project).setLocation(location).setProcessor(processor).setProcessorVersion(processorVersion).build().toString();
    }

    public static ProcessorVersionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PROCESSOR_PROCESSOR_VERSION.validatedMatch(formattedString, "ProcessorVersionName.parse: formattedString not in valid format");
        return ProcessorVersionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("processor"), (String)matchMap.get("processor_version"));
    }

    public static List<ProcessorVersionName> parseList(List<String> formattedStrings) {
        ArrayList<ProcessorVersionName> list = new ArrayList<ProcessorVersionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProcessorVersionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProcessorVersionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProcessorVersionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PROCESSOR_PROCESSOR_VERSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProcessorVersionName processorVersionName = this;
            synchronized (processorVersionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.processor != null) {
                        fieldMapBuilder.put((Object)"processor", (Object)this.processor);
                    }
                    if (this.processorVersion != null) {
                        fieldMapBuilder.put((Object)"processor_version", (Object)this.processorVersion);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PROCESSOR_PROCESSOR_VERSION.instantiate(new String[]{"project", this.project, "location", this.location, "processor", this.processor, "processor_version", this.processorVersion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ProcessorVersionName that = (ProcessorVersionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.processor, that.processor) && Objects.equals(this.processorVersion, that.processorVersion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.processor);
        h *= 1000003;
        return h ^= Objects.hashCode(this.processorVersion);
    }

    public static class Builder {
        private String project;
        private String location;
        private String processor;
        private String processorVersion;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getProcessor() {
            return this.processor;
        }

        public String getProcessorVersion() {
            return this.processorVersion;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setProcessor(String processor) {
            this.processor = processor;
            return this;
        }

        public Builder setProcessorVersion(String processorVersion) {
            this.processorVersion = processorVersion;
            return this;
        }

        private Builder(ProcessorVersionName processorVersionName) {
            this.project = processorVersionName.project;
            this.location = processorVersionName.location;
            this.processor = processorVersionName.processor;
            this.processorVersion = processorVersionName.processorVersion;
        }

        public ProcessorVersionName build() {
            return new ProcessorVersionName(this);
        }
    }
}

