/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta1/document_understanding.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.documentai.v1beta1;

/**
 *
 *
 * <pre>
 * Parameters to control form extraction behavior.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta1.FormExtractionParams}
 */
public final class FormExtractionParams extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta1.FormExtractionParams)
    FormExtractionParamsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FormExtractionParams.newBuilder() to construct.
  private FormExtractionParams(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FormExtractionParams() {
    keyValuePairHints_ = java.util.Collections.emptyList();
    modelVersion_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FormExtractionParams();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta1.DocumentAiProto
        .internal_static_google_cloud_documentai_v1beta1_FormExtractionParams_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta1.DocumentAiProto
        .internal_static_google_cloud_documentai_v1beta1_FormExtractionParams_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta1.FormExtractionParams.class,
            com.google.cloud.documentai.v1beta1.FormExtractionParams.Builder.class);
  }

  public static final int ENABLED_FIELD_NUMBER = 1;
  private boolean enabled_ = false;
  /**
   *
   *
   * <pre>
   * Whether to enable form extraction.
   * </pre>
   *
   * <code>bool enabled = 1;</code>
   *
   * @return The enabled.
   */
  @java.lang.Override
  public boolean getEnabled() {
    return enabled_;
  }

  public static final int KEY_VALUE_PAIR_HINTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.documentai.v1beta1.KeyValuePairHint> keyValuePairHints_;
  /**
   *
   *
   * <pre>
   * User can provide pairs of (key text, value type) to improve the parsing
   * result.
   *
   * For example, if a document has a field called "Date" that holds a date
   * value and a field called "Amount" that may hold either a currency value
   * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
   * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
   * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
   *
   * If the value type is unknown, but you want to provide hints for the keys,
   * you can leave the value_types field blank. e.g. {"key": "Date",
   * "value_types": []}
   * </pre>
   *
   * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.documentai.v1beta1.KeyValuePairHint>
      getKeyValuePairHintsList() {
    return keyValuePairHints_;
  }
  /**
   *
   *
   * <pre>
   * User can provide pairs of (key text, value type) to improve the parsing
   * result.
   *
   * For example, if a document has a field called "Date" that holds a date
   * value and a field called "Amount" that may hold either a currency value
   * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
   * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
   * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
   *
   * If the value type is unknown, but you want to provide hints for the keys,
   * you can leave the value_types field blank. e.g. {"key": "Date",
   * "value_types": []}
   * </pre>
   *
   * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.documentai.v1beta1.KeyValuePairHintOrBuilder>
      getKeyValuePairHintsOrBuilderList() {
    return keyValuePairHints_;
  }
  /**
   *
   *
   * <pre>
   * User can provide pairs of (key text, value type) to improve the parsing
   * result.
   *
   * For example, if a document has a field called "Date" that holds a date
   * value and a field called "Amount" that may hold either a currency value
   * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
   * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
   * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
   *
   * If the value type is unknown, but you want to provide hints for the keys,
   * you can leave the value_types field blank. e.g. {"key": "Date",
   * "value_types": []}
   * </pre>
   *
   * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
   * </code>
   */
  @java.lang.Override
  public int getKeyValuePairHintsCount() {
    return keyValuePairHints_.size();
  }
  /**
   *
   *
   * <pre>
   * User can provide pairs of (key text, value type) to improve the parsing
   * result.
   *
   * For example, if a document has a field called "Date" that holds a date
   * value and a field called "Amount" that may hold either a currency value
   * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
   * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
   * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
   *
   * If the value type is unknown, but you want to provide hints for the keys,
   * you can leave the value_types field blank. e.g. {"key": "Date",
   * "value_types": []}
   * </pre>
   *
   * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta1.KeyValuePairHint getKeyValuePairHints(int index) {
    return keyValuePairHints_.get(index);
  }
  /**
   *
   *
   * <pre>
   * User can provide pairs of (key text, value type) to improve the parsing
   * result.
   *
   * For example, if a document has a field called "Date" that holds a date
   * value and a field called "Amount" that may hold either a currency value
   * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
   * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
   * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
   *
   * If the value type is unknown, but you want to provide hints for the keys,
   * you can leave the value_types field blank. e.g. {"key": "Date",
   * "value_types": []}
   * </pre>
   *
   * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta1.KeyValuePairHintOrBuilder
      getKeyValuePairHintsOrBuilder(int index) {
    return keyValuePairHints_.get(index);
  }

  public static final int MODEL_VERSION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelVersion_ = "";
  /**
   *
   *
   * <pre>
   * Model version of the form extraction system. Default is
   * "builtin/stable". Specify "builtin/latest" for the latest model.
   * </pre>
   *
   * <code>string model_version = 3;</code>
   *
   * @return The modelVersion.
   */
  @java.lang.Override
  public java.lang.String getModelVersion() {
    java.lang.Object ref = modelVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Model version of the form extraction system. Default is
   * "builtin/stable". Specify "builtin/latest" for the latest model.
   * </pre>
   *
   * <code>string model_version = 3;</code>
   *
   * @return The bytes for modelVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelVersionBytes() {
    java.lang.Object ref = modelVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (enabled_ != false) {
      output.writeBool(1, enabled_);
    }
    for (int i = 0; i < keyValuePairHints_.size(); i++) {
      output.writeMessage(2, keyValuePairHints_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, modelVersion_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (enabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
    }
    for (int i = 0; i < keyValuePairHints_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, keyValuePairHints_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, modelVersion_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta1.FormExtractionParams)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta1.FormExtractionParams other =
        (com.google.cloud.documentai.v1beta1.FormExtractionParams) obj;

    if (getEnabled() != other.getEnabled()) return false;
    if (!getKeyValuePairHintsList().equals(other.getKeyValuePairHintsList())) return false;
    if (!getModelVersion().equals(other.getModelVersion())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
    if (getKeyValuePairHintsCount() > 0) {
      hash = (37 * hash) + KEY_VALUE_PAIR_HINTS_FIELD_NUMBER;
      hash = (53 * hash) + getKeyValuePairHintsList().hashCode();
    }
    hash = (37 * hash) + MODEL_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getModelVersion().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta1.FormExtractionParams parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta1.FormExtractionParams parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta1.FormExtractionParams parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta1.FormExtractionParams parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta1.FormExtractionParams parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta1.FormExtractionParams parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta1.FormExtractionParams parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta1.FormExtractionParams parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta1.FormExtractionParams parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta1.FormExtractionParams parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta1.FormExtractionParams parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta1.FormExtractionParams parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.documentai.v1beta1.FormExtractionParams prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Parameters to control form extraction behavior.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta1.FormExtractionParams}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta1.FormExtractionParams)
      com.google.cloud.documentai.v1beta1.FormExtractionParamsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta1.DocumentAiProto
          .internal_static_google_cloud_documentai_v1beta1_FormExtractionParams_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta1.DocumentAiProto
          .internal_static_google_cloud_documentai_v1beta1_FormExtractionParams_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta1.FormExtractionParams.class,
              com.google.cloud.documentai.v1beta1.FormExtractionParams.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta1.FormExtractionParams.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      enabled_ = false;
      if (keyValuePairHintsBuilder_ == null) {
        keyValuePairHints_ = java.util.Collections.emptyList();
      } else {
        keyValuePairHints_ = null;
        keyValuePairHintsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      modelVersion_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta1.DocumentAiProto
          .internal_static_google_cloud_documentai_v1beta1_FormExtractionParams_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.FormExtractionParams getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta1.FormExtractionParams.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.FormExtractionParams build() {
      com.google.cloud.documentai.v1beta1.FormExtractionParams result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.FormExtractionParams buildPartial() {
      com.google.cloud.documentai.v1beta1.FormExtractionParams result =
          new com.google.cloud.documentai.v1beta1.FormExtractionParams(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.documentai.v1beta1.FormExtractionParams result) {
      if (keyValuePairHintsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          keyValuePairHints_ = java.util.Collections.unmodifiableList(keyValuePairHints_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.keyValuePairHints_ = keyValuePairHints_;
      } else {
        result.keyValuePairHints_ = keyValuePairHintsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta1.FormExtractionParams result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.enabled_ = enabled_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.modelVersion_ = modelVersion_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta1.FormExtractionParams) {
        return mergeFrom((com.google.cloud.documentai.v1beta1.FormExtractionParams) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta1.FormExtractionParams other) {
      if (other == com.google.cloud.documentai.v1beta1.FormExtractionParams.getDefaultInstance())
        return this;
      if (other.getEnabled() != false) {
        setEnabled(other.getEnabled());
      }
      if (keyValuePairHintsBuilder_ == null) {
        if (!other.keyValuePairHints_.isEmpty()) {
          if (keyValuePairHints_.isEmpty()) {
            keyValuePairHints_ = other.keyValuePairHints_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureKeyValuePairHintsIsMutable();
            keyValuePairHints_.addAll(other.keyValuePairHints_);
          }
          onChanged();
        }
      } else {
        if (!other.keyValuePairHints_.isEmpty()) {
          if (keyValuePairHintsBuilder_.isEmpty()) {
            keyValuePairHintsBuilder_.dispose();
            keyValuePairHintsBuilder_ = null;
            keyValuePairHints_ = other.keyValuePairHints_;
            bitField0_ = (bitField0_ & ~0x00000002);
            keyValuePairHintsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getKeyValuePairHintsFieldBuilder()
                    : null;
          } else {
            keyValuePairHintsBuilder_.addAllMessages(other.keyValuePairHints_);
          }
        }
      }
      if (!other.getModelVersion().isEmpty()) {
        modelVersion_ = other.modelVersion_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                enabled_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                com.google.cloud.documentai.v1beta1.KeyValuePairHint m =
                    input.readMessage(
                        com.google.cloud.documentai.v1beta1.KeyValuePairHint.parser(),
                        extensionRegistry);
                if (keyValuePairHintsBuilder_ == null) {
                  ensureKeyValuePairHintsIsMutable();
                  keyValuePairHints_.add(m);
                } else {
                  keyValuePairHintsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                modelVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean enabled_;
    /**
     *
     *
     * <pre>
     * Whether to enable form extraction.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }
    /**
     *
     *
     * <pre>
     * Whether to enable form extraction.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @param value The enabled to set.
     * @return This builder for chaining.
     */
    public Builder setEnabled(boolean value) {

      enabled_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to enable form extraction.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnabled() {
      bitField0_ = (bitField0_ & ~0x00000001);
      enabled_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.documentai.v1beta1.KeyValuePairHint>
        keyValuePairHints_ = java.util.Collections.emptyList();

    private void ensureKeyValuePairHintsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        keyValuePairHints_ =
            new java.util.ArrayList<com.google.cloud.documentai.v1beta1.KeyValuePairHint>(
                keyValuePairHints_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta1.KeyValuePairHint,
            com.google.cloud.documentai.v1beta1.KeyValuePairHint.Builder,
            com.google.cloud.documentai.v1beta1.KeyValuePairHintOrBuilder>
        keyValuePairHintsBuilder_;

    /**
     *
     *
     * <pre>
     * User can provide pairs of (key text, value type) to improve the parsing
     * result.
     *
     * For example, if a document has a field called "Date" that holds a date
     * value and a field called "Amount" that may hold either a currency value
     * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
     * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
     * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
     *
     * If the value type is unknown, but you want to provide hints for the keys,
     * you can leave the value_types field blank. e.g. {"key": "Date",
     * "value_types": []}
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.documentai.v1beta1.KeyValuePairHint>
        getKeyValuePairHintsList() {
      if (keyValuePairHintsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(keyValuePairHints_);
      } else {
        return keyValuePairHintsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * User can provide pairs of (key text, value type) to improve the parsing
     * result.
     *
     * For example, if a document has a field called "Date" that holds a date
     * value and a field called "Amount" that may hold either a currency value
     * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
     * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
     * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
     *
     * If the value type is unknown, but you want to provide hints for the keys,
     * you can leave the value_types field blank. e.g. {"key": "Date",
     * "value_types": []}
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
     * </code>
     */
    public int getKeyValuePairHintsCount() {
      if (keyValuePairHintsBuilder_ == null) {
        return keyValuePairHints_.size();
      } else {
        return keyValuePairHintsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * User can provide pairs of (key text, value type) to improve the parsing
     * result.
     *
     * For example, if a document has a field called "Date" that holds a date
     * value and a field called "Amount" that may hold either a currency value
     * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
     * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
     * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
     *
     * If the value type is unknown, but you want to provide hints for the keys,
     * you can leave the value_types field blank. e.g. {"key": "Date",
     * "value_types": []}
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
     * </code>
     */
    public com.google.cloud.documentai.v1beta1.KeyValuePairHint getKeyValuePairHints(int index) {
      if (keyValuePairHintsBuilder_ == null) {
        return keyValuePairHints_.get(index);
      } else {
        return keyValuePairHintsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * User can provide pairs of (key text, value type) to improve the parsing
     * result.
     *
     * For example, if a document has a field called "Date" that holds a date
     * value and a field called "Amount" that may hold either a currency value
     * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
     * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
     * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
     *
     * If the value type is unknown, but you want to provide hints for the keys,
     * you can leave the value_types field blank. e.g. {"key": "Date",
     * "value_types": []}
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
     * </code>
     */
    public Builder setKeyValuePairHints(
        int index, com.google.cloud.documentai.v1beta1.KeyValuePairHint value) {
      if (keyValuePairHintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureKeyValuePairHintsIsMutable();
        keyValuePairHints_.set(index, value);
        onChanged();
      } else {
        keyValuePairHintsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User can provide pairs of (key text, value type) to improve the parsing
     * result.
     *
     * For example, if a document has a field called "Date" that holds a date
     * value and a field called "Amount" that may hold either a currency value
     * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
     * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
     * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
     *
     * If the value type is unknown, but you want to provide hints for the keys,
     * you can leave the value_types field blank. e.g. {"key": "Date",
     * "value_types": []}
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
     * </code>
     */
    public Builder setKeyValuePairHints(
        int index, com.google.cloud.documentai.v1beta1.KeyValuePairHint.Builder builderForValue) {
      if (keyValuePairHintsBuilder_ == null) {
        ensureKeyValuePairHintsIsMutable();
        keyValuePairHints_.set(index, builderForValue.build());
        onChanged();
      } else {
        keyValuePairHintsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User can provide pairs of (key text, value type) to improve the parsing
     * result.
     *
     * For example, if a document has a field called "Date" that holds a date
     * value and a field called "Amount" that may hold either a currency value
     * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
     * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
     * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
     *
     * If the value type is unknown, but you want to provide hints for the keys,
     * you can leave the value_types field blank. e.g. {"key": "Date",
     * "value_types": []}
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
     * </code>
     */
    public Builder addKeyValuePairHints(
        com.google.cloud.documentai.v1beta1.KeyValuePairHint value) {
      if (keyValuePairHintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureKeyValuePairHintsIsMutable();
        keyValuePairHints_.add(value);
        onChanged();
      } else {
        keyValuePairHintsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User can provide pairs of (key text, value type) to improve the parsing
     * result.
     *
     * For example, if a document has a field called "Date" that holds a date
     * value and a field called "Amount" that may hold either a currency value
     * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
     * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
     * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
     *
     * If the value type is unknown, but you want to provide hints for the keys,
     * you can leave the value_types field blank. e.g. {"key": "Date",
     * "value_types": []}
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
     * </code>
     */
    public Builder addKeyValuePairHints(
        int index, com.google.cloud.documentai.v1beta1.KeyValuePairHint value) {
      if (keyValuePairHintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureKeyValuePairHintsIsMutable();
        keyValuePairHints_.add(index, value);
        onChanged();
      } else {
        keyValuePairHintsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User can provide pairs of (key text, value type) to improve the parsing
     * result.
     *
     * For example, if a document has a field called "Date" that holds a date
     * value and a field called "Amount" that may hold either a currency value
     * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
     * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
     * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
     *
     * If the value type is unknown, but you want to provide hints for the keys,
     * you can leave the value_types field blank. e.g. {"key": "Date",
     * "value_types": []}
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
     * </code>
     */
    public Builder addKeyValuePairHints(
        com.google.cloud.documentai.v1beta1.KeyValuePairHint.Builder builderForValue) {
      if (keyValuePairHintsBuilder_ == null) {
        ensureKeyValuePairHintsIsMutable();
        keyValuePairHints_.add(builderForValue.build());
        onChanged();
      } else {
        keyValuePairHintsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User can provide pairs of (key text, value type) to improve the parsing
     * result.
     *
     * For example, if a document has a field called "Date" that holds a date
     * value and a field called "Amount" that may hold either a currency value
     * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
     * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
     * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
     *
     * If the value type is unknown, but you want to provide hints for the keys,
     * you can leave the value_types field blank. e.g. {"key": "Date",
     * "value_types": []}
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
     * </code>
     */
    public Builder addKeyValuePairHints(
        int index, com.google.cloud.documentai.v1beta1.KeyValuePairHint.Builder builderForValue) {
      if (keyValuePairHintsBuilder_ == null) {
        ensureKeyValuePairHintsIsMutable();
        keyValuePairHints_.add(index, builderForValue.build());
        onChanged();
      } else {
        keyValuePairHintsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User can provide pairs of (key text, value type) to improve the parsing
     * result.
     *
     * For example, if a document has a field called "Date" that holds a date
     * value and a field called "Amount" that may hold either a currency value
     * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
     * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
     * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
     *
     * If the value type is unknown, but you want to provide hints for the keys,
     * you can leave the value_types field blank. e.g. {"key": "Date",
     * "value_types": []}
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
     * </code>
     */
    public Builder addAllKeyValuePairHints(
        java.lang.Iterable<? extends com.google.cloud.documentai.v1beta1.KeyValuePairHint> values) {
      if (keyValuePairHintsBuilder_ == null) {
        ensureKeyValuePairHintsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, keyValuePairHints_);
        onChanged();
      } else {
        keyValuePairHintsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User can provide pairs of (key text, value type) to improve the parsing
     * result.
     *
     * For example, if a document has a field called "Date" that holds a date
     * value and a field called "Amount" that may hold either a currency value
     * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
     * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
     * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
     *
     * If the value type is unknown, but you want to provide hints for the keys,
     * you can leave the value_types field blank. e.g. {"key": "Date",
     * "value_types": []}
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
     * </code>
     */
    public Builder clearKeyValuePairHints() {
      if (keyValuePairHintsBuilder_ == null) {
        keyValuePairHints_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        keyValuePairHintsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User can provide pairs of (key text, value type) to improve the parsing
     * result.
     *
     * For example, if a document has a field called "Date" that holds a date
     * value and a field called "Amount" that may hold either a currency value
     * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
     * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
     * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
     *
     * If the value type is unknown, but you want to provide hints for the keys,
     * you can leave the value_types field blank. e.g. {"key": "Date",
     * "value_types": []}
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
     * </code>
     */
    public Builder removeKeyValuePairHints(int index) {
      if (keyValuePairHintsBuilder_ == null) {
        ensureKeyValuePairHintsIsMutable();
        keyValuePairHints_.remove(index);
        onChanged();
      } else {
        keyValuePairHintsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User can provide pairs of (key text, value type) to improve the parsing
     * result.
     *
     * For example, if a document has a field called "Date" that holds a date
     * value and a field called "Amount" that may hold either a currency value
     * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
     * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
     * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
     *
     * If the value type is unknown, but you want to provide hints for the keys,
     * you can leave the value_types field blank. e.g. {"key": "Date",
     * "value_types": []}
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
     * </code>
     */
    public com.google.cloud.documentai.v1beta1.KeyValuePairHint.Builder getKeyValuePairHintsBuilder(
        int index) {
      return getKeyValuePairHintsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * User can provide pairs of (key text, value type) to improve the parsing
     * result.
     *
     * For example, if a document has a field called "Date" that holds a date
     * value and a field called "Amount" that may hold either a currency value
     * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
     * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
     * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
     *
     * If the value type is unknown, but you want to provide hints for the keys,
     * you can leave the value_types field blank. e.g. {"key": "Date",
     * "value_types": []}
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
     * </code>
     */
    public com.google.cloud.documentai.v1beta1.KeyValuePairHintOrBuilder
        getKeyValuePairHintsOrBuilder(int index) {
      if (keyValuePairHintsBuilder_ == null) {
        return keyValuePairHints_.get(index);
      } else {
        return keyValuePairHintsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * User can provide pairs of (key text, value type) to improve the parsing
     * result.
     *
     * For example, if a document has a field called "Date" that holds a date
     * value and a field called "Amount" that may hold either a currency value
     * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
     * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
     * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
     *
     * If the value type is unknown, but you want to provide hints for the keys,
     * you can leave the value_types field blank. e.g. {"key": "Date",
     * "value_types": []}
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.documentai.v1beta1.KeyValuePairHintOrBuilder>
        getKeyValuePairHintsOrBuilderList() {
      if (keyValuePairHintsBuilder_ != null) {
        return keyValuePairHintsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(keyValuePairHints_);
      }
    }
    /**
     *
     *
     * <pre>
     * User can provide pairs of (key text, value type) to improve the parsing
     * result.
     *
     * For example, if a document has a field called "Date" that holds a date
     * value and a field called "Amount" that may hold either a currency value
     * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
     * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
     * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
     *
     * If the value type is unknown, but you want to provide hints for the keys,
     * you can leave the value_types field blank. e.g. {"key": "Date",
     * "value_types": []}
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
     * </code>
     */
    public com.google.cloud.documentai.v1beta1.KeyValuePairHint.Builder
        addKeyValuePairHintsBuilder() {
      return getKeyValuePairHintsFieldBuilder()
          .addBuilder(com.google.cloud.documentai.v1beta1.KeyValuePairHint.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * User can provide pairs of (key text, value type) to improve the parsing
     * result.
     *
     * For example, if a document has a field called "Date" that holds a date
     * value and a field called "Amount" that may hold either a currency value
     * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
     * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
     * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
     *
     * If the value type is unknown, but you want to provide hints for the keys,
     * you can leave the value_types field blank. e.g. {"key": "Date",
     * "value_types": []}
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
     * </code>
     */
    public com.google.cloud.documentai.v1beta1.KeyValuePairHint.Builder addKeyValuePairHintsBuilder(
        int index) {
      return getKeyValuePairHintsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.documentai.v1beta1.KeyValuePairHint.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * User can provide pairs of (key text, value type) to improve the parsing
     * result.
     *
     * For example, if a document has a field called "Date" that holds a date
     * value and a field called "Amount" that may hold either a currency value
     * (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
     * following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
     * "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
     *
     * If the value type is unknown, but you want to provide hints for the keys,
     * you can leave the value_types field blank. e.g. {"key": "Date",
     * "value_types": []}
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.KeyValuePairHint key_value_pair_hints = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.documentai.v1beta1.KeyValuePairHint.Builder>
        getKeyValuePairHintsBuilderList() {
      return getKeyValuePairHintsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta1.KeyValuePairHint,
            com.google.cloud.documentai.v1beta1.KeyValuePairHint.Builder,
            com.google.cloud.documentai.v1beta1.KeyValuePairHintOrBuilder>
        getKeyValuePairHintsFieldBuilder() {
      if (keyValuePairHintsBuilder_ == null) {
        keyValuePairHintsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.KeyValuePairHint,
                com.google.cloud.documentai.v1beta1.KeyValuePairHint.Builder,
                com.google.cloud.documentai.v1beta1.KeyValuePairHintOrBuilder>(
                keyValuePairHints_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        keyValuePairHints_ = null;
      }
      return keyValuePairHintsBuilder_;
    }

    private java.lang.Object modelVersion_ = "";
    /**
     *
     *
     * <pre>
     * Model version of the form extraction system. Default is
     * "builtin/stable". Specify "builtin/latest" for the latest model.
     * </pre>
     *
     * <code>string model_version = 3;</code>
     *
     * @return The modelVersion.
     */
    public java.lang.String getModelVersion() {
      java.lang.Object ref = modelVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Model version of the form extraction system. Default is
     * "builtin/stable". Specify "builtin/latest" for the latest model.
     * </pre>
     *
     * <code>string model_version = 3;</code>
     *
     * @return The bytes for modelVersion.
     */
    public com.google.protobuf.ByteString getModelVersionBytes() {
      java.lang.Object ref = modelVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Model version of the form extraction system. Default is
     * "builtin/stable". Specify "builtin/latest" for the latest model.
     * </pre>
     *
     * <code>string model_version = 3;</code>
     *
     * @param value The modelVersion to set.
     * @return This builder for chaining.
     */
    public Builder setModelVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelVersion_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model version of the form extraction system. Default is
     * "builtin/stable". Specify "builtin/latest" for the latest model.
     * </pre>
     *
     * <code>string model_version = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelVersion() {
      modelVersion_ = getDefaultInstance().getModelVersion();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model version of the form extraction system. Default is
     * "builtin/stable". Specify "builtin/latest" for the latest model.
     * </pre>
     *
     * <code>string model_version = 3;</code>
     *
     * @param value The bytes for modelVersion to set.
     * @return This builder for chaining.
     */
    public Builder setModelVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelVersion_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta1.FormExtractionParams)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta1.FormExtractionParams)
  private static final com.google.cloud.documentai.v1beta1.FormExtractionParams DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta1.FormExtractionParams();
  }

  public static com.google.cloud.documentai.v1beta1.FormExtractionParams getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FormExtractionParams> PARSER =
      new com.google.protobuf.AbstractParser<FormExtractionParams>() {
        @java.lang.Override
        public FormExtractionParams parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FormExtractionParams> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FormExtractionParams> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta1.FormExtractionParams getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
