/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta1/document.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.documentai.v1beta1;

/**
 *
 *
 * <pre>
 * Document represents the canonical document resource in Document Understanding
 * AI.
 * It is an interchange format that provides insights into documents and allows
 * for collaboration between users and Document Understanding AI to iterate and
 * optimize for quality.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta1.Document}
 */
public final class Document extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta1.Document)
    DocumentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Document.newBuilder() to construct.
  private Document(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Document() {
    mimeType_ = "";
    text_ = "";
    textStyles_ = java.util.Collections.emptyList();
    pages_ = java.util.Collections.emptyList();
    entities_ = java.util.Collections.emptyList();
    entityRelations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Document();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta1.DocumentProto
        .internal_static_google_cloud_documentai_v1beta1_Document_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta1.DocumentProto
        .internal_static_google_cloud_documentai_v1beta1_Document_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta1.Document.class,
            com.google.cloud.documentai.v1beta1.Document.Builder.class);
  }

  public interface ShardInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta1.Document.ShardInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The 0-based index of this shard.
     * </pre>
     *
     * <code>int64 shard_index = 1;</code>
     *
     * @return The shardIndex.
     */
    long getShardIndex();

    /**
     *
     *
     * <pre>
     * Total number of shards.
     * </pre>
     *
     * <code>int64 shard_count = 2;</code>
     *
     * @return The shardCount.
     */
    long getShardCount();

    /**
     *
     *
     * <pre>
     * The index of the first character in
     * [Document.text][google.cloud.documentai.v1beta1.Document.text] in the
     * overall document global text.
     * </pre>
     *
     * <code>int64 text_offset = 3;</code>
     *
     * @return The textOffset.
     */
    long getTextOffset();
  }
  /**
   *
   *
   * <pre>
   * For a large document, sharding may be performed to produce several
   * document shards. Each document shard contains this field to detail which
   * shard it is.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta1.Document.ShardInfo}
   */
  public static final class ShardInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta1.Document.ShardInfo)
      ShardInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ShardInfo.newBuilder() to construct.
    private ShardInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ShardInfo() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ShardInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta1.DocumentProto
          .internal_static_google_cloud_documentai_v1beta1_Document_ShardInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta1.DocumentProto
          .internal_static_google_cloud_documentai_v1beta1_Document_ShardInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta1.Document.ShardInfo.class,
              com.google.cloud.documentai.v1beta1.Document.ShardInfo.Builder.class);
    }

    public static final int SHARD_INDEX_FIELD_NUMBER = 1;
    private long shardIndex_ = 0L;
    /**
     *
     *
     * <pre>
     * The 0-based index of this shard.
     * </pre>
     *
     * <code>int64 shard_index = 1;</code>
     *
     * @return The shardIndex.
     */
    @java.lang.Override
    public long getShardIndex() {
      return shardIndex_;
    }

    public static final int SHARD_COUNT_FIELD_NUMBER = 2;
    private long shardCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Total number of shards.
     * </pre>
     *
     * <code>int64 shard_count = 2;</code>
     *
     * @return The shardCount.
     */
    @java.lang.Override
    public long getShardCount() {
      return shardCount_;
    }

    public static final int TEXT_OFFSET_FIELD_NUMBER = 3;
    private long textOffset_ = 0L;
    /**
     *
     *
     * <pre>
     * The index of the first character in
     * [Document.text][google.cloud.documentai.v1beta1.Document.text] in the
     * overall document global text.
     * </pre>
     *
     * <code>int64 text_offset = 3;</code>
     *
     * @return The textOffset.
     */
    @java.lang.Override
    public long getTextOffset() {
      return textOffset_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (shardIndex_ != 0L) {
        output.writeInt64(1, shardIndex_);
      }
      if (shardCount_ != 0L) {
        output.writeInt64(2, shardCount_);
      }
      if (textOffset_ != 0L) {
        output.writeInt64(3, textOffset_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (shardIndex_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, shardIndex_);
      }
      if (shardCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, shardCount_);
      }
      if (textOffset_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, textOffset_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta1.Document.ShardInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta1.Document.ShardInfo other =
          (com.google.cloud.documentai.v1beta1.Document.ShardInfo) obj;

      if (getShardIndex() != other.getShardIndex()) return false;
      if (getShardCount() != other.getShardCount()) return false;
      if (getTextOffset() != other.getTextOffset()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SHARD_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getShardIndex());
      hash = (37 * hash) + SHARD_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getShardCount());
      hash = (37 * hash) + TEXT_OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTextOffset());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta1.Document.ShardInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta1.Document.ShardInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta1.Document.ShardInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta1.Document.ShardInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta1.Document.ShardInfo parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta1.Document.ShardInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta1.Document.ShardInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta1.Document.ShardInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta1.Document.ShardInfo parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta1.Document.ShardInfo parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta1.Document.ShardInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta1.Document.ShardInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta1.Document.ShardInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * For a large document, sharding may be performed to produce several
     * document shards. Each document shard contains this field to detail which
     * shard it is.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta1.Document.ShardInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta1.Document.ShardInfo)
        com.google.cloud.documentai.v1beta1.Document.ShardInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_ShardInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_ShardInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta1.Document.ShardInfo.class,
                com.google.cloud.documentai.v1beta1.Document.ShardInfo.Builder.class);
      }

      // Construct using com.google.cloud.documentai.v1beta1.Document.ShardInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        shardIndex_ = 0L;
        shardCount_ = 0L;
        textOffset_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_ShardInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.ShardInfo getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta1.Document.ShardInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.ShardInfo build() {
        com.google.cloud.documentai.v1beta1.Document.ShardInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.ShardInfo buildPartial() {
        com.google.cloud.documentai.v1beta1.Document.ShardInfo result =
            new com.google.cloud.documentai.v1beta1.Document.ShardInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.documentai.v1beta1.Document.ShardInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.shardIndex_ = shardIndex_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.shardCount_ = shardCount_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.textOffset_ = textOffset_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1beta1.Document.ShardInfo) {
          return mergeFrom((com.google.cloud.documentai.v1beta1.Document.ShardInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.documentai.v1beta1.Document.ShardInfo other) {
        if (other == com.google.cloud.documentai.v1beta1.Document.ShardInfo.getDefaultInstance())
          return this;
        if (other.getShardIndex() != 0L) {
          setShardIndex(other.getShardIndex());
        }
        if (other.getShardCount() != 0L) {
          setShardCount(other.getShardCount());
        }
        if (other.getTextOffset() != 0L) {
          setTextOffset(other.getTextOffset());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  shardIndex_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  shardCount_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  textOffset_ = input.readInt64();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long shardIndex_;
      /**
       *
       *
       * <pre>
       * The 0-based index of this shard.
       * </pre>
       *
       * <code>int64 shard_index = 1;</code>
       *
       * @return The shardIndex.
       */
      @java.lang.Override
      public long getShardIndex() {
        return shardIndex_;
      }
      /**
       *
       *
       * <pre>
       * The 0-based index of this shard.
       * </pre>
       *
       * <code>int64 shard_index = 1;</code>
       *
       * @param value The shardIndex to set.
       * @return This builder for chaining.
       */
      public Builder setShardIndex(long value) {

        shardIndex_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The 0-based index of this shard.
       * </pre>
       *
       * <code>int64 shard_index = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearShardIndex() {
        bitField0_ = (bitField0_ & ~0x00000001);
        shardIndex_ = 0L;
        onChanged();
        return this;
      }

      private long shardCount_;
      /**
       *
       *
       * <pre>
       * Total number of shards.
       * </pre>
       *
       * <code>int64 shard_count = 2;</code>
       *
       * @return The shardCount.
       */
      @java.lang.Override
      public long getShardCount() {
        return shardCount_;
      }
      /**
       *
       *
       * <pre>
       * Total number of shards.
       * </pre>
       *
       * <code>int64 shard_count = 2;</code>
       *
       * @param value The shardCount to set.
       * @return This builder for chaining.
       */
      public Builder setShardCount(long value) {

        shardCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total number of shards.
       * </pre>
       *
       * <code>int64 shard_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearShardCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        shardCount_ = 0L;
        onChanged();
        return this;
      }

      private long textOffset_;
      /**
       *
       *
       * <pre>
       * The index of the first character in
       * [Document.text][google.cloud.documentai.v1beta1.Document.text] in the
       * overall document global text.
       * </pre>
       *
       * <code>int64 text_offset = 3;</code>
       *
       * @return The textOffset.
       */
      @java.lang.Override
      public long getTextOffset() {
        return textOffset_;
      }
      /**
       *
       *
       * <pre>
       * The index of the first character in
       * [Document.text][google.cloud.documentai.v1beta1.Document.text] in the
       * overall document global text.
       * </pre>
       *
       * <code>int64 text_offset = 3;</code>
       *
       * @param value The textOffset to set.
       * @return This builder for chaining.
       */
      public Builder setTextOffset(long value) {

        textOffset_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The index of the first character in
       * [Document.text][google.cloud.documentai.v1beta1.Document.text] in the
       * overall document global text.
       * </pre>
       *
       * <code>int64 text_offset = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTextOffset() {
        bitField0_ = (bitField0_ & ~0x00000004);
        textOffset_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta1.Document.ShardInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta1.Document.ShardInfo)
    private static final com.google.cloud.documentai.v1beta1.Document.ShardInfo DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta1.Document.ShardInfo();
    }

    public static com.google.cloud.documentai.v1beta1.Document.ShardInfo getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ShardInfo> PARSER =
        new com.google.protobuf.AbstractParser<ShardInfo>() {
          @java.lang.Override
          public ShardInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ShardInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ShardInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.ShardInfo getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface StyleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta1.Document.Style)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Text anchor indexing into the
     * [Document.text][google.cloud.documentai.v1beta1.Document.text].
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
     *
     * @return Whether the textAnchor field is set.
     */
    boolean hasTextAnchor();
    /**
     *
     *
     * <pre>
     * Text anchor indexing into the
     * [Document.text][google.cloud.documentai.v1beta1.Document.text].
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
     *
     * @return The textAnchor.
     */
    com.google.cloud.documentai.v1beta1.Document.TextAnchor getTextAnchor();
    /**
     *
     *
     * <pre>
     * Text anchor indexing into the
     * [Document.text][google.cloud.documentai.v1beta1.Document.text].
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
     */
    com.google.cloud.documentai.v1beta1.Document.TextAnchorOrBuilder getTextAnchorOrBuilder();

    /**
     *
     *
     * <pre>
     * Text color.
     * </pre>
     *
     * <code>.google.type.Color color = 2;</code>
     *
     * @return Whether the color field is set.
     */
    boolean hasColor();
    /**
     *
     *
     * <pre>
     * Text color.
     * </pre>
     *
     * <code>.google.type.Color color = 2;</code>
     *
     * @return The color.
     */
    com.google.type.Color getColor();
    /**
     *
     *
     * <pre>
     * Text color.
     * </pre>
     *
     * <code>.google.type.Color color = 2;</code>
     */
    com.google.type.ColorOrBuilder getColorOrBuilder();

    /**
     *
     *
     * <pre>
     * Text background color.
     * </pre>
     *
     * <code>.google.type.Color background_color = 3;</code>
     *
     * @return Whether the backgroundColor field is set.
     */
    boolean hasBackgroundColor();
    /**
     *
     *
     * <pre>
     * Text background color.
     * </pre>
     *
     * <code>.google.type.Color background_color = 3;</code>
     *
     * @return The backgroundColor.
     */
    com.google.type.Color getBackgroundColor();
    /**
     *
     *
     * <pre>
     * Text background color.
     * </pre>
     *
     * <code>.google.type.Color background_color = 3;</code>
     */
    com.google.type.ColorOrBuilder getBackgroundColorOrBuilder();

    /**
     *
     *
     * <pre>
     * Font weight. Possible values are normal, bold, bolder, and lighter.
     * https://www.w3schools.com/cssref/pr_font_weight.asp
     * </pre>
     *
     * <code>string font_weight = 4;</code>
     *
     * @return The fontWeight.
     */
    java.lang.String getFontWeight();
    /**
     *
     *
     * <pre>
     * Font weight. Possible values are normal, bold, bolder, and lighter.
     * https://www.w3schools.com/cssref/pr_font_weight.asp
     * </pre>
     *
     * <code>string font_weight = 4;</code>
     *
     * @return The bytes for fontWeight.
     */
    com.google.protobuf.ByteString getFontWeightBytes();

    /**
     *
     *
     * <pre>
     * Text style. Possible values are normal, italic, and oblique.
     * https://www.w3schools.com/cssref/pr_font_font-style.asp
     * </pre>
     *
     * <code>string text_style = 5;</code>
     *
     * @return The textStyle.
     */
    java.lang.String getTextStyle();
    /**
     *
     *
     * <pre>
     * Text style. Possible values are normal, italic, and oblique.
     * https://www.w3schools.com/cssref/pr_font_font-style.asp
     * </pre>
     *
     * <code>string text_style = 5;</code>
     *
     * @return The bytes for textStyle.
     */
    com.google.protobuf.ByteString getTextStyleBytes();

    /**
     *
     *
     * <pre>
     * Text decoration. Follows CSS standard.
     * &lt;text-decoration-line&gt; &lt;text-decoration-color&gt; &lt;text-decoration-style&gt;
     * https://www.w3schools.com/cssref/pr_text_text-decoration.asp
     * </pre>
     *
     * <code>string text_decoration = 6;</code>
     *
     * @return The textDecoration.
     */
    java.lang.String getTextDecoration();
    /**
     *
     *
     * <pre>
     * Text decoration. Follows CSS standard.
     * &lt;text-decoration-line&gt; &lt;text-decoration-color&gt; &lt;text-decoration-style&gt;
     * https://www.w3schools.com/cssref/pr_text_text-decoration.asp
     * </pre>
     *
     * <code>string text_decoration = 6;</code>
     *
     * @return The bytes for textDecoration.
     */
    com.google.protobuf.ByteString getTextDecorationBytes();

    /**
     *
     *
     * <pre>
     * Font size.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.Style.FontSize font_size = 7;</code>
     *
     * @return Whether the fontSize field is set.
     */
    boolean hasFontSize();
    /**
     *
     *
     * <pre>
     * Font size.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.Style.FontSize font_size = 7;</code>
     *
     * @return The fontSize.
     */
    com.google.cloud.documentai.v1beta1.Document.Style.FontSize getFontSize();
    /**
     *
     *
     * <pre>
     * Font size.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.Style.FontSize font_size = 7;</code>
     */
    com.google.cloud.documentai.v1beta1.Document.Style.FontSizeOrBuilder getFontSizeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Annotation for common text style attributes. This adheres to CSS
   * conventions as much as possible.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Style}
   */
  public static final class Style extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta1.Document.Style)
      StyleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Style.newBuilder() to construct.
    private Style(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Style() {
      fontWeight_ = "";
      textStyle_ = "";
      textDecoration_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Style();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta1.DocumentProto
          .internal_static_google_cloud_documentai_v1beta1_Document_Style_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta1.DocumentProto
          .internal_static_google_cloud_documentai_v1beta1_Document_Style_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta1.Document.Style.class,
              com.google.cloud.documentai.v1beta1.Document.Style.Builder.class);
    }

    public interface FontSizeOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta1.Document.Style.FontSize)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Font size for the text.
       * </pre>
       *
       * <code>float size = 1;</code>
       *
       * @return The size.
       */
      float getSize();

      /**
       *
       *
       * <pre>
       * Unit for the font size. Follows CSS naming (in, px, pt, etc.).
       * </pre>
       *
       * <code>string unit = 2;</code>
       *
       * @return The unit.
       */
      java.lang.String getUnit();
      /**
       *
       *
       * <pre>
       * Unit for the font size. Follows CSS naming (in, px, pt, etc.).
       * </pre>
       *
       * <code>string unit = 2;</code>
       *
       * @return The bytes for unit.
       */
      com.google.protobuf.ByteString getUnitBytes();
    }
    /**
     *
     *
     * <pre>
     * Font size with unit.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Style.FontSize}
     */
    public static final class FontSize extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta1.Document.Style.FontSize)
        FontSizeOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use FontSize.newBuilder() to construct.
      private FontSize(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private FontSize() {
        unit_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new FontSize();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Style_FontSize_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Style_FontSize_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta1.Document.Style.FontSize.class,
                com.google.cloud.documentai.v1beta1.Document.Style.FontSize.Builder.class);
      }

      public static final int SIZE_FIELD_NUMBER = 1;
      private float size_ = 0F;
      /**
       *
       *
       * <pre>
       * Font size for the text.
       * </pre>
       *
       * <code>float size = 1;</code>
       *
       * @return The size.
       */
      @java.lang.Override
      public float getSize() {
        return size_;
      }

      public static final int UNIT_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object unit_ = "";
      /**
       *
       *
       * <pre>
       * Unit for the font size. Follows CSS naming (in, px, pt, etc.).
       * </pre>
       *
       * <code>string unit = 2;</code>
       *
       * @return The unit.
       */
      @java.lang.Override
      public java.lang.String getUnit() {
        java.lang.Object ref = unit_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          unit_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Unit for the font size. Follows CSS naming (in, px, pt, etc.).
       * </pre>
       *
       * <code>string unit = 2;</code>
       *
       * @return The bytes for unit.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUnitBytes() {
        java.lang.Object ref = unit_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          unit_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (java.lang.Float.floatToRawIntBits(size_) != 0) {
          output.writeFloat(1, size_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, unit_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (java.lang.Float.floatToRawIntBits(size_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, size_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, unit_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta1.Document.Style.FontSize)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta1.Document.Style.FontSize other =
            (com.google.cloud.documentai.v1beta1.Document.Style.FontSize) obj;

        if (java.lang.Float.floatToIntBits(getSize())
            != java.lang.Float.floatToIntBits(other.getSize())) return false;
        if (!getUnit().equals(other.getUnit())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + SIZE_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getSize());
        hash = (37 * hash) + UNIT_FIELD_NUMBER;
        hash = (53 * hash) + getUnit().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta1.Document.Style.FontSize parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Style.FontSize parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Style.FontSize parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Style.FontSize parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Style.FontSize parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Style.FontSize parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Style.FontSize parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Style.FontSize parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Style.FontSize parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Style.FontSize parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Style.FontSize parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Style.FontSize parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta1.Document.Style.FontSize prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Font size with unit.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Style.FontSize}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta1.Document.Style.FontSize)
          com.google.cloud.documentai.v1beta1.Document.Style.FontSizeOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Style_FontSize_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Style_FontSize_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta1.Document.Style.FontSize.class,
                  com.google.cloud.documentai.v1beta1.Document.Style.FontSize.Builder.class);
        }

        // Construct using com.google.cloud.documentai.v1beta1.Document.Style.FontSize.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          size_ = 0F;
          unit_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Style_FontSize_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Style.FontSize
            getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta1.Document.Style.FontSize.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Style.FontSize build() {
          com.google.cloud.documentai.v1beta1.Document.Style.FontSize result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Style.FontSize buildPartial() {
          com.google.cloud.documentai.v1beta1.Document.Style.FontSize result =
              new com.google.cloud.documentai.v1beta1.Document.Style.FontSize(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.documentai.v1beta1.Document.Style.FontSize result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.size_ = size_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.unit_ = unit_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta1.Document.Style.FontSize) {
            return mergeFrom((com.google.cloud.documentai.v1beta1.Document.Style.FontSize) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.documentai.v1beta1.Document.Style.FontSize other) {
          if (other
              == com.google.cloud.documentai.v1beta1.Document.Style.FontSize.getDefaultInstance())
            return this;
          if (other.getSize() != 0F) {
            setSize(other.getSize());
          }
          if (!other.getUnit().isEmpty()) {
            unit_ = other.unit_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 13:
                  {
                    size_ = input.readFloat();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 13
                case 18:
                  {
                    unit_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private float size_;
        /**
         *
         *
         * <pre>
         * Font size for the text.
         * </pre>
         *
         * <code>float size = 1;</code>
         *
         * @return The size.
         */
        @java.lang.Override
        public float getSize() {
          return size_;
        }
        /**
         *
         *
         * <pre>
         * Font size for the text.
         * </pre>
         *
         * <code>float size = 1;</code>
         *
         * @param value The size to set.
         * @return This builder for chaining.
         */
        public Builder setSize(float value) {

          size_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Font size for the text.
         * </pre>
         *
         * <code>float size = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSize() {
          bitField0_ = (bitField0_ & ~0x00000001);
          size_ = 0F;
          onChanged();
          return this;
        }

        private java.lang.Object unit_ = "";
        /**
         *
         *
         * <pre>
         * Unit for the font size. Follows CSS naming (in, px, pt, etc.).
         * </pre>
         *
         * <code>string unit = 2;</code>
         *
         * @return The unit.
         */
        public java.lang.String getUnit() {
          java.lang.Object ref = unit_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            unit_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Unit for the font size. Follows CSS naming (in, px, pt, etc.).
         * </pre>
         *
         * <code>string unit = 2;</code>
         *
         * @return The bytes for unit.
         */
        public com.google.protobuf.ByteString getUnitBytes() {
          java.lang.Object ref = unit_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            unit_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Unit for the font size. Follows CSS naming (in, px, pt, etc.).
         * </pre>
         *
         * <code>string unit = 2;</code>
         *
         * @param value The unit to set.
         * @return This builder for chaining.
         */
        public Builder setUnit(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          unit_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Unit for the font size. Follows CSS naming (in, px, pt, etc.).
         * </pre>
         *
         * <code>string unit = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUnit() {
          unit_ = getDefaultInstance().getUnit();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Unit for the font size. Follows CSS naming (in, px, pt, etc.).
         * </pre>
         *
         * <code>string unit = 2;</code>
         *
         * @param value The bytes for unit to set.
         * @return This builder for chaining.
         */
        public Builder setUnitBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          unit_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta1.Document.Style.FontSize)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta1.Document.Style.FontSize)
      private static final com.google.cloud.documentai.v1beta1.Document.Style.FontSize
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta1.Document.Style.FontSize();
      }

      public static com.google.cloud.documentai.v1beta1.Document.Style.FontSize
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<FontSize> PARSER =
          new com.google.protobuf.AbstractParser<FontSize>() {
            @java.lang.Override
            public FontSize parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<FontSize> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<FontSize> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Style.FontSize
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int TEXT_ANCHOR_FIELD_NUMBER = 1;
    private com.google.cloud.documentai.v1beta1.Document.TextAnchor textAnchor_;
    /**
     *
     *
     * <pre>
     * Text anchor indexing into the
     * [Document.text][google.cloud.documentai.v1beta1.Document.text].
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
     *
     * @return Whether the textAnchor field is set.
     */
    @java.lang.Override
    public boolean hasTextAnchor() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Text anchor indexing into the
     * [Document.text][google.cloud.documentai.v1beta1.Document.text].
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
     *
     * @return The textAnchor.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.TextAnchor getTextAnchor() {
      return textAnchor_ == null
          ? com.google.cloud.documentai.v1beta1.Document.TextAnchor.getDefaultInstance()
          : textAnchor_;
    }
    /**
     *
     *
     * <pre>
     * Text anchor indexing into the
     * [Document.text][google.cloud.documentai.v1beta1.Document.text].
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.TextAnchorOrBuilder
        getTextAnchorOrBuilder() {
      return textAnchor_ == null
          ? com.google.cloud.documentai.v1beta1.Document.TextAnchor.getDefaultInstance()
          : textAnchor_;
    }

    public static final int COLOR_FIELD_NUMBER = 2;
    private com.google.type.Color color_;
    /**
     *
     *
     * <pre>
     * Text color.
     * </pre>
     *
     * <code>.google.type.Color color = 2;</code>
     *
     * @return Whether the color field is set.
     */
    @java.lang.Override
    public boolean hasColor() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Text color.
     * </pre>
     *
     * <code>.google.type.Color color = 2;</code>
     *
     * @return The color.
     */
    @java.lang.Override
    public com.google.type.Color getColor() {
      return color_ == null ? com.google.type.Color.getDefaultInstance() : color_;
    }
    /**
     *
     *
     * <pre>
     * Text color.
     * </pre>
     *
     * <code>.google.type.Color color = 2;</code>
     */
    @java.lang.Override
    public com.google.type.ColorOrBuilder getColorOrBuilder() {
      return color_ == null ? com.google.type.Color.getDefaultInstance() : color_;
    }

    public static final int BACKGROUND_COLOR_FIELD_NUMBER = 3;
    private com.google.type.Color backgroundColor_;
    /**
     *
     *
     * <pre>
     * Text background color.
     * </pre>
     *
     * <code>.google.type.Color background_color = 3;</code>
     *
     * @return Whether the backgroundColor field is set.
     */
    @java.lang.Override
    public boolean hasBackgroundColor() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Text background color.
     * </pre>
     *
     * <code>.google.type.Color background_color = 3;</code>
     *
     * @return The backgroundColor.
     */
    @java.lang.Override
    public com.google.type.Color getBackgroundColor() {
      return backgroundColor_ == null
          ? com.google.type.Color.getDefaultInstance()
          : backgroundColor_;
    }
    /**
     *
     *
     * <pre>
     * Text background color.
     * </pre>
     *
     * <code>.google.type.Color background_color = 3;</code>
     */
    @java.lang.Override
    public com.google.type.ColorOrBuilder getBackgroundColorOrBuilder() {
      return backgroundColor_ == null
          ? com.google.type.Color.getDefaultInstance()
          : backgroundColor_;
    }

    public static final int FONT_WEIGHT_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object fontWeight_ = "";
    /**
     *
     *
     * <pre>
     * Font weight. Possible values are normal, bold, bolder, and lighter.
     * https://www.w3schools.com/cssref/pr_font_weight.asp
     * </pre>
     *
     * <code>string font_weight = 4;</code>
     *
     * @return The fontWeight.
     */
    @java.lang.Override
    public java.lang.String getFontWeight() {
      java.lang.Object ref = fontWeight_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fontWeight_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Font weight. Possible values are normal, bold, bolder, and lighter.
     * https://www.w3schools.com/cssref/pr_font_weight.asp
     * </pre>
     *
     * <code>string font_weight = 4;</code>
     *
     * @return The bytes for fontWeight.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFontWeightBytes() {
      java.lang.Object ref = fontWeight_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fontWeight_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TEXT_STYLE_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object textStyle_ = "";
    /**
     *
     *
     * <pre>
     * Text style. Possible values are normal, italic, and oblique.
     * https://www.w3schools.com/cssref/pr_font_font-style.asp
     * </pre>
     *
     * <code>string text_style = 5;</code>
     *
     * @return The textStyle.
     */
    @java.lang.Override
    public java.lang.String getTextStyle() {
      java.lang.Object ref = textStyle_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        textStyle_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Text style. Possible values are normal, italic, and oblique.
     * https://www.w3schools.com/cssref/pr_font_font-style.asp
     * </pre>
     *
     * <code>string text_style = 5;</code>
     *
     * @return The bytes for textStyle.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextStyleBytes() {
      java.lang.Object ref = textStyle_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        textStyle_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TEXT_DECORATION_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object textDecoration_ = "";
    /**
     *
     *
     * <pre>
     * Text decoration. Follows CSS standard.
     * &lt;text-decoration-line&gt; &lt;text-decoration-color&gt; &lt;text-decoration-style&gt;
     * https://www.w3schools.com/cssref/pr_text_text-decoration.asp
     * </pre>
     *
     * <code>string text_decoration = 6;</code>
     *
     * @return The textDecoration.
     */
    @java.lang.Override
    public java.lang.String getTextDecoration() {
      java.lang.Object ref = textDecoration_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        textDecoration_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Text decoration. Follows CSS standard.
     * &lt;text-decoration-line&gt; &lt;text-decoration-color&gt; &lt;text-decoration-style&gt;
     * https://www.w3schools.com/cssref/pr_text_text-decoration.asp
     * </pre>
     *
     * <code>string text_decoration = 6;</code>
     *
     * @return The bytes for textDecoration.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextDecorationBytes() {
      java.lang.Object ref = textDecoration_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        textDecoration_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FONT_SIZE_FIELD_NUMBER = 7;
    private com.google.cloud.documentai.v1beta1.Document.Style.FontSize fontSize_;
    /**
     *
     *
     * <pre>
     * Font size.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.Style.FontSize font_size = 7;</code>
     *
     * @return Whether the fontSize field is set.
     */
    @java.lang.Override
    public boolean hasFontSize() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Font size.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.Style.FontSize font_size = 7;</code>
     *
     * @return The fontSize.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Style.FontSize getFontSize() {
      return fontSize_ == null
          ? com.google.cloud.documentai.v1beta1.Document.Style.FontSize.getDefaultInstance()
          : fontSize_;
    }
    /**
     *
     *
     * <pre>
     * Font size.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.Style.FontSize font_size = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Style.FontSizeOrBuilder
        getFontSizeOrBuilder() {
      return fontSize_ == null
          ? com.google.cloud.documentai.v1beta1.Document.Style.FontSize.getDefaultInstance()
          : fontSize_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getTextAnchor());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getColor());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(3, getBackgroundColor());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fontWeight_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, fontWeight_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(textStyle_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, textStyle_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(textDecoration_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, textDecoration_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeMessage(7, getFontSize());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTextAnchor());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getColor());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getBackgroundColor());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fontWeight_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, fontWeight_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(textStyle_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, textStyle_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(textDecoration_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, textDecoration_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getFontSize());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta1.Document.Style)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta1.Document.Style other =
          (com.google.cloud.documentai.v1beta1.Document.Style) obj;

      if (hasTextAnchor() != other.hasTextAnchor()) return false;
      if (hasTextAnchor()) {
        if (!getTextAnchor().equals(other.getTextAnchor())) return false;
      }
      if (hasColor() != other.hasColor()) return false;
      if (hasColor()) {
        if (!getColor().equals(other.getColor())) return false;
      }
      if (hasBackgroundColor() != other.hasBackgroundColor()) return false;
      if (hasBackgroundColor()) {
        if (!getBackgroundColor().equals(other.getBackgroundColor())) return false;
      }
      if (!getFontWeight().equals(other.getFontWeight())) return false;
      if (!getTextStyle().equals(other.getTextStyle())) return false;
      if (!getTextDecoration().equals(other.getTextDecoration())) return false;
      if (hasFontSize() != other.hasFontSize()) return false;
      if (hasFontSize()) {
        if (!getFontSize().equals(other.getFontSize())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasTextAnchor()) {
        hash = (37 * hash) + TEXT_ANCHOR_FIELD_NUMBER;
        hash = (53 * hash) + getTextAnchor().hashCode();
      }
      if (hasColor()) {
        hash = (37 * hash) + COLOR_FIELD_NUMBER;
        hash = (53 * hash) + getColor().hashCode();
      }
      if (hasBackgroundColor()) {
        hash = (37 * hash) + BACKGROUND_COLOR_FIELD_NUMBER;
        hash = (53 * hash) + getBackgroundColor().hashCode();
      }
      hash = (37 * hash) + FONT_WEIGHT_FIELD_NUMBER;
      hash = (53 * hash) + getFontWeight().hashCode();
      hash = (37 * hash) + TEXT_STYLE_FIELD_NUMBER;
      hash = (53 * hash) + getTextStyle().hashCode();
      hash = (37 * hash) + TEXT_DECORATION_FIELD_NUMBER;
      hash = (53 * hash) + getTextDecoration().hashCode();
      if (hasFontSize()) {
        hash = (37 * hash) + FONT_SIZE_FIELD_NUMBER;
        hash = (53 * hash) + getFontSize().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta1.Document.Style parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Style parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Style parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Style parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Style parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Style parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Style parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Style parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Style parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Style parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Style parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Style parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.documentai.v1beta1.Document.Style prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Annotation for common text style attributes. This adheres to CSS
     * conventions as much as possible.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Style}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta1.Document.Style)
        com.google.cloud.documentai.v1beta1.Document.StyleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Style_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Style_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta1.Document.Style.class,
                com.google.cloud.documentai.v1beta1.Document.Style.Builder.class);
      }

      // Construct using com.google.cloud.documentai.v1beta1.Document.Style.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getTextAnchorFieldBuilder();
          getColorFieldBuilder();
          getBackgroundColorFieldBuilder();
          getFontSizeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        textAnchor_ = null;
        if (textAnchorBuilder_ != null) {
          textAnchorBuilder_.dispose();
          textAnchorBuilder_ = null;
        }
        color_ = null;
        if (colorBuilder_ != null) {
          colorBuilder_.dispose();
          colorBuilder_ = null;
        }
        backgroundColor_ = null;
        if (backgroundColorBuilder_ != null) {
          backgroundColorBuilder_.dispose();
          backgroundColorBuilder_ = null;
        }
        fontWeight_ = "";
        textStyle_ = "";
        textDecoration_ = "";
        fontSize_ = null;
        if (fontSizeBuilder_ != null) {
          fontSizeBuilder_.dispose();
          fontSizeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Style_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Style getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta1.Document.Style.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Style build() {
        com.google.cloud.documentai.v1beta1.Document.Style result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Style buildPartial() {
        com.google.cloud.documentai.v1beta1.Document.Style result =
            new com.google.cloud.documentai.v1beta1.Document.Style(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.documentai.v1beta1.Document.Style result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.textAnchor_ =
              textAnchorBuilder_ == null ? textAnchor_ : textAnchorBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.color_ = colorBuilder_ == null ? color_ : colorBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.backgroundColor_ =
              backgroundColorBuilder_ == null ? backgroundColor_ : backgroundColorBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.fontWeight_ = fontWeight_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.textStyle_ = textStyle_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.textDecoration_ = textDecoration_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.fontSize_ = fontSizeBuilder_ == null ? fontSize_ : fontSizeBuilder_.build();
          to_bitField0_ |= 0x00000008;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1beta1.Document.Style) {
          return mergeFrom((com.google.cloud.documentai.v1beta1.Document.Style) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.documentai.v1beta1.Document.Style other) {
        if (other == com.google.cloud.documentai.v1beta1.Document.Style.getDefaultInstance())
          return this;
        if (other.hasTextAnchor()) {
          mergeTextAnchor(other.getTextAnchor());
        }
        if (other.hasColor()) {
          mergeColor(other.getColor());
        }
        if (other.hasBackgroundColor()) {
          mergeBackgroundColor(other.getBackgroundColor());
        }
        if (!other.getFontWeight().isEmpty()) {
          fontWeight_ = other.fontWeight_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getTextStyle().isEmpty()) {
          textStyle_ = other.textStyle_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (!other.getTextDecoration().isEmpty()) {
          textDecoration_ = other.textDecoration_;
          bitField0_ |= 0x00000020;
          onChanged();
        }
        if (other.hasFontSize()) {
          mergeFontSize(other.getFontSize());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getTextAnchorFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getColorFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getBackgroundColorFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  fontWeight_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  textStyle_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  textDecoration_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(getFontSizeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000040;
                  break;
                } // case 58
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.documentai.v1beta1.Document.TextAnchor textAnchor_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta1.Document.TextAnchor,
              com.google.cloud.documentai.v1beta1.Document.TextAnchor.Builder,
              com.google.cloud.documentai.v1beta1.Document.TextAnchorOrBuilder>
          textAnchorBuilder_;
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta1.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
       *
       * @return Whether the textAnchor field is set.
       */
      public boolean hasTextAnchor() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta1.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
       *
       * @return The textAnchor.
       */
      public com.google.cloud.documentai.v1beta1.Document.TextAnchor getTextAnchor() {
        if (textAnchorBuilder_ == null) {
          return textAnchor_ == null
              ? com.google.cloud.documentai.v1beta1.Document.TextAnchor.getDefaultInstance()
              : textAnchor_;
        } else {
          return textAnchorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta1.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
       */
      public Builder setTextAnchor(com.google.cloud.documentai.v1beta1.Document.TextAnchor value) {
        if (textAnchorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          textAnchor_ = value;
        } else {
          textAnchorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta1.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
       */
      public Builder setTextAnchor(
          com.google.cloud.documentai.v1beta1.Document.TextAnchor.Builder builderForValue) {
        if (textAnchorBuilder_ == null) {
          textAnchor_ = builderForValue.build();
        } else {
          textAnchorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta1.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
       */
      public Builder mergeTextAnchor(
          com.google.cloud.documentai.v1beta1.Document.TextAnchor value) {
        if (textAnchorBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && textAnchor_ != null
              && textAnchor_
                  != com.google.cloud.documentai.v1beta1.Document.TextAnchor.getDefaultInstance()) {
            getTextAnchorBuilder().mergeFrom(value);
          } else {
            textAnchor_ = value;
          }
        } else {
          textAnchorBuilder_.mergeFrom(value);
        }
        if (textAnchor_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta1.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
       */
      public Builder clearTextAnchor() {
        bitField0_ = (bitField0_ & ~0x00000001);
        textAnchor_ = null;
        if (textAnchorBuilder_ != null) {
          textAnchorBuilder_.dispose();
          textAnchorBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta1.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.TextAnchor.Builder
          getTextAnchorBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getTextAnchorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta1.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.TextAnchorOrBuilder
          getTextAnchorOrBuilder() {
        if (textAnchorBuilder_ != null) {
          return textAnchorBuilder_.getMessageOrBuilder();
        } else {
          return textAnchor_ == null
              ? com.google.cloud.documentai.v1beta1.Document.TextAnchor.getDefaultInstance()
              : textAnchor_;
        }
      }
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta1.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta1.Document.TextAnchor,
              com.google.cloud.documentai.v1beta1.Document.TextAnchor.Builder,
              com.google.cloud.documentai.v1beta1.Document.TextAnchorOrBuilder>
          getTextAnchorFieldBuilder() {
        if (textAnchorBuilder_ == null) {
          textAnchorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta1.Document.TextAnchor,
                  com.google.cloud.documentai.v1beta1.Document.TextAnchor.Builder,
                  com.google.cloud.documentai.v1beta1.Document.TextAnchorOrBuilder>(
                  getTextAnchor(), getParentForChildren(), isClean());
          textAnchor_ = null;
        }
        return textAnchorBuilder_;
      }

      private com.google.type.Color color_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Color, com.google.type.Color.Builder, com.google.type.ColorOrBuilder>
          colorBuilder_;
      /**
       *
       *
       * <pre>
       * Text color.
       * </pre>
       *
       * <code>.google.type.Color color = 2;</code>
       *
       * @return Whether the color field is set.
       */
      public boolean hasColor() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Text color.
       * </pre>
       *
       * <code>.google.type.Color color = 2;</code>
       *
       * @return The color.
       */
      public com.google.type.Color getColor() {
        if (colorBuilder_ == null) {
          return color_ == null ? com.google.type.Color.getDefaultInstance() : color_;
        } else {
          return colorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Text color.
       * </pre>
       *
       * <code>.google.type.Color color = 2;</code>
       */
      public Builder setColor(com.google.type.Color value) {
        if (colorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          color_ = value;
        } else {
          colorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text color.
       * </pre>
       *
       * <code>.google.type.Color color = 2;</code>
       */
      public Builder setColor(com.google.type.Color.Builder builderForValue) {
        if (colorBuilder_ == null) {
          color_ = builderForValue.build();
        } else {
          colorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text color.
       * </pre>
       *
       * <code>.google.type.Color color = 2;</code>
       */
      public Builder mergeColor(com.google.type.Color value) {
        if (colorBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && color_ != null
              && color_ != com.google.type.Color.getDefaultInstance()) {
            getColorBuilder().mergeFrom(value);
          } else {
            color_ = value;
          }
        } else {
          colorBuilder_.mergeFrom(value);
        }
        if (color_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text color.
       * </pre>
       *
       * <code>.google.type.Color color = 2;</code>
       */
      public Builder clearColor() {
        bitField0_ = (bitField0_ & ~0x00000002);
        color_ = null;
        if (colorBuilder_ != null) {
          colorBuilder_.dispose();
          colorBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text color.
       * </pre>
       *
       * <code>.google.type.Color color = 2;</code>
       */
      public com.google.type.Color.Builder getColorBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getColorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Text color.
       * </pre>
       *
       * <code>.google.type.Color color = 2;</code>
       */
      public com.google.type.ColorOrBuilder getColorOrBuilder() {
        if (colorBuilder_ != null) {
          return colorBuilder_.getMessageOrBuilder();
        } else {
          return color_ == null ? com.google.type.Color.getDefaultInstance() : color_;
        }
      }
      /**
       *
       *
       * <pre>
       * Text color.
       * </pre>
       *
       * <code>.google.type.Color color = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Color, com.google.type.Color.Builder, com.google.type.ColorOrBuilder>
          getColorFieldBuilder() {
        if (colorBuilder_ == null) {
          colorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Color,
                  com.google.type.Color.Builder,
                  com.google.type.ColorOrBuilder>(getColor(), getParentForChildren(), isClean());
          color_ = null;
        }
        return colorBuilder_;
      }

      private com.google.type.Color backgroundColor_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Color, com.google.type.Color.Builder, com.google.type.ColorOrBuilder>
          backgroundColorBuilder_;
      /**
       *
       *
       * <pre>
       * Text background color.
       * </pre>
       *
       * <code>.google.type.Color background_color = 3;</code>
       *
       * @return Whether the backgroundColor field is set.
       */
      public boolean hasBackgroundColor() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Text background color.
       * </pre>
       *
       * <code>.google.type.Color background_color = 3;</code>
       *
       * @return The backgroundColor.
       */
      public com.google.type.Color getBackgroundColor() {
        if (backgroundColorBuilder_ == null) {
          return backgroundColor_ == null
              ? com.google.type.Color.getDefaultInstance()
              : backgroundColor_;
        } else {
          return backgroundColorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Text background color.
       * </pre>
       *
       * <code>.google.type.Color background_color = 3;</code>
       */
      public Builder setBackgroundColor(com.google.type.Color value) {
        if (backgroundColorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          backgroundColor_ = value;
        } else {
          backgroundColorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text background color.
       * </pre>
       *
       * <code>.google.type.Color background_color = 3;</code>
       */
      public Builder setBackgroundColor(com.google.type.Color.Builder builderForValue) {
        if (backgroundColorBuilder_ == null) {
          backgroundColor_ = builderForValue.build();
        } else {
          backgroundColorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text background color.
       * </pre>
       *
       * <code>.google.type.Color background_color = 3;</code>
       */
      public Builder mergeBackgroundColor(com.google.type.Color value) {
        if (backgroundColorBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && backgroundColor_ != null
              && backgroundColor_ != com.google.type.Color.getDefaultInstance()) {
            getBackgroundColorBuilder().mergeFrom(value);
          } else {
            backgroundColor_ = value;
          }
        } else {
          backgroundColorBuilder_.mergeFrom(value);
        }
        if (backgroundColor_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text background color.
       * </pre>
       *
       * <code>.google.type.Color background_color = 3;</code>
       */
      public Builder clearBackgroundColor() {
        bitField0_ = (bitField0_ & ~0x00000004);
        backgroundColor_ = null;
        if (backgroundColorBuilder_ != null) {
          backgroundColorBuilder_.dispose();
          backgroundColorBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text background color.
       * </pre>
       *
       * <code>.google.type.Color background_color = 3;</code>
       */
      public com.google.type.Color.Builder getBackgroundColorBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getBackgroundColorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Text background color.
       * </pre>
       *
       * <code>.google.type.Color background_color = 3;</code>
       */
      public com.google.type.ColorOrBuilder getBackgroundColorOrBuilder() {
        if (backgroundColorBuilder_ != null) {
          return backgroundColorBuilder_.getMessageOrBuilder();
        } else {
          return backgroundColor_ == null
              ? com.google.type.Color.getDefaultInstance()
              : backgroundColor_;
        }
      }
      /**
       *
       *
       * <pre>
       * Text background color.
       * </pre>
       *
       * <code>.google.type.Color background_color = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Color, com.google.type.Color.Builder, com.google.type.ColorOrBuilder>
          getBackgroundColorFieldBuilder() {
        if (backgroundColorBuilder_ == null) {
          backgroundColorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Color,
                  com.google.type.Color.Builder,
                  com.google.type.ColorOrBuilder>(
                  getBackgroundColor(), getParentForChildren(), isClean());
          backgroundColor_ = null;
        }
        return backgroundColorBuilder_;
      }

      private java.lang.Object fontWeight_ = "";
      /**
       *
       *
       * <pre>
       * Font weight. Possible values are normal, bold, bolder, and lighter.
       * https://www.w3schools.com/cssref/pr_font_weight.asp
       * </pre>
       *
       * <code>string font_weight = 4;</code>
       *
       * @return The fontWeight.
       */
      public java.lang.String getFontWeight() {
        java.lang.Object ref = fontWeight_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fontWeight_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Font weight. Possible values are normal, bold, bolder, and lighter.
       * https://www.w3schools.com/cssref/pr_font_weight.asp
       * </pre>
       *
       * <code>string font_weight = 4;</code>
       *
       * @return The bytes for fontWeight.
       */
      public com.google.protobuf.ByteString getFontWeightBytes() {
        java.lang.Object ref = fontWeight_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fontWeight_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Font weight. Possible values are normal, bold, bolder, and lighter.
       * https://www.w3schools.com/cssref/pr_font_weight.asp
       * </pre>
       *
       * <code>string font_weight = 4;</code>
       *
       * @param value The fontWeight to set.
       * @return This builder for chaining.
       */
      public Builder setFontWeight(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        fontWeight_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Font weight. Possible values are normal, bold, bolder, and lighter.
       * https://www.w3schools.com/cssref/pr_font_weight.asp
       * </pre>
       *
       * <code>string font_weight = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFontWeight() {
        fontWeight_ = getDefaultInstance().getFontWeight();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Font weight. Possible values are normal, bold, bolder, and lighter.
       * https://www.w3schools.com/cssref/pr_font_weight.asp
       * </pre>
       *
       * <code>string font_weight = 4;</code>
       *
       * @param value The bytes for fontWeight to set.
       * @return This builder for chaining.
       */
      public Builder setFontWeightBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        fontWeight_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object textStyle_ = "";
      /**
       *
       *
       * <pre>
       * Text style. Possible values are normal, italic, and oblique.
       * https://www.w3schools.com/cssref/pr_font_font-style.asp
       * </pre>
       *
       * <code>string text_style = 5;</code>
       *
       * @return The textStyle.
       */
      public java.lang.String getTextStyle() {
        java.lang.Object ref = textStyle_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          textStyle_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Text style. Possible values are normal, italic, and oblique.
       * https://www.w3schools.com/cssref/pr_font_font-style.asp
       * </pre>
       *
       * <code>string text_style = 5;</code>
       *
       * @return The bytes for textStyle.
       */
      public com.google.protobuf.ByteString getTextStyleBytes() {
        java.lang.Object ref = textStyle_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          textStyle_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Text style. Possible values are normal, italic, and oblique.
       * https://www.w3schools.com/cssref/pr_font_font-style.asp
       * </pre>
       *
       * <code>string text_style = 5;</code>
       *
       * @param value The textStyle to set.
       * @return This builder for chaining.
       */
      public Builder setTextStyle(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        textStyle_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text style. Possible values are normal, italic, and oblique.
       * https://www.w3schools.com/cssref/pr_font_font-style.asp
       * </pre>
       *
       * <code>string text_style = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTextStyle() {
        textStyle_ = getDefaultInstance().getTextStyle();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text style. Possible values are normal, italic, and oblique.
       * https://www.w3schools.com/cssref/pr_font_font-style.asp
       * </pre>
       *
       * <code>string text_style = 5;</code>
       *
       * @param value The bytes for textStyle to set.
       * @return This builder for chaining.
       */
      public Builder setTextStyleBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        textStyle_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private java.lang.Object textDecoration_ = "";
      /**
       *
       *
       * <pre>
       * Text decoration. Follows CSS standard.
       * &lt;text-decoration-line&gt; &lt;text-decoration-color&gt; &lt;text-decoration-style&gt;
       * https://www.w3schools.com/cssref/pr_text_text-decoration.asp
       * </pre>
       *
       * <code>string text_decoration = 6;</code>
       *
       * @return The textDecoration.
       */
      public java.lang.String getTextDecoration() {
        java.lang.Object ref = textDecoration_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          textDecoration_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Text decoration. Follows CSS standard.
       * &lt;text-decoration-line&gt; &lt;text-decoration-color&gt; &lt;text-decoration-style&gt;
       * https://www.w3schools.com/cssref/pr_text_text-decoration.asp
       * </pre>
       *
       * <code>string text_decoration = 6;</code>
       *
       * @return The bytes for textDecoration.
       */
      public com.google.protobuf.ByteString getTextDecorationBytes() {
        java.lang.Object ref = textDecoration_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          textDecoration_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Text decoration. Follows CSS standard.
       * &lt;text-decoration-line&gt; &lt;text-decoration-color&gt; &lt;text-decoration-style&gt;
       * https://www.w3schools.com/cssref/pr_text_text-decoration.asp
       * </pre>
       *
       * <code>string text_decoration = 6;</code>
       *
       * @param value The textDecoration to set.
       * @return This builder for chaining.
       */
      public Builder setTextDecoration(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        textDecoration_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text decoration. Follows CSS standard.
       * &lt;text-decoration-line&gt; &lt;text-decoration-color&gt; &lt;text-decoration-style&gt;
       * https://www.w3schools.com/cssref/pr_text_text-decoration.asp
       * </pre>
       *
       * <code>string text_decoration = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTextDecoration() {
        textDecoration_ = getDefaultInstance().getTextDecoration();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text decoration. Follows CSS standard.
       * &lt;text-decoration-line&gt; &lt;text-decoration-color&gt; &lt;text-decoration-style&gt;
       * https://www.w3schools.com/cssref/pr_text_text-decoration.asp
       * </pre>
       *
       * <code>string text_decoration = 6;</code>
       *
       * @param value The bytes for textDecoration to set.
       * @return This builder for chaining.
       */
      public Builder setTextDecorationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        textDecoration_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      private com.google.cloud.documentai.v1beta1.Document.Style.FontSize fontSize_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta1.Document.Style.FontSize,
              com.google.cloud.documentai.v1beta1.Document.Style.FontSize.Builder,
              com.google.cloud.documentai.v1beta1.Document.Style.FontSizeOrBuilder>
          fontSizeBuilder_;
      /**
       *
       *
       * <pre>
       * Font size.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Style.FontSize font_size = 7;</code>
       *
       * @return Whether the fontSize field is set.
       */
      public boolean hasFontSize() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       *
       *
       * <pre>
       * Font size.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Style.FontSize font_size = 7;</code>
       *
       * @return The fontSize.
       */
      public com.google.cloud.documentai.v1beta1.Document.Style.FontSize getFontSize() {
        if (fontSizeBuilder_ == null) {
          return fontSize_ == null
              ? com.google.cloud.documentai.v1beta1.Document.Style.FontSize.getDefaultInstance()
              : fontSize_;
        } else {
          return fontSizeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Font size.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Style.FontSize font_size = 7;</code>
       */
      public Builder setFontSize(
          com.google.cloud.documentai.v1beta1.Document.Style.FontSize value) {
        if (fontSizeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          fontSize_ = value;
        } else {
          fontSizeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Font size.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Style.FontSize font_size = 7;</code>
       */
      public Builder setFontSize(
          com.google.cloud.documentai.v1beta1.Document.Style.FontSize.Builder builderForValue) {
        if (fontSizeBuilder_ == null) {
          fontSize_ = builderForValue.build();
        } else {
          fontSizeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Font size.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Style.FontSize font_size = 7;</code>
       */
      public Builder mergeFontSize(
          com.google.cloud.documentai.v1beta1.Document.Style.FontSize value) {
        if (fontSizeBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)
              && fontSize_ != null
              && fontSize_
                  != com.google.cloud.documentai.v1beta1.Document.Style.FontSize
                      .getDefaultInstance()) {
            getFontSizeBuilder().mergeFrom(value);
          } else {
            fontSize_ = value;
          }
        } else {
          fontSizeBuilder_.mergeFrom(value);
        }
        if (fontSize_ != null) {
          bitField0_ |= 0x00000040;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Font size.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Style.FontSize font_size = 7;</code>
       */
      public Builder clearFontSize() {
        bitField0_ = (bitField0_ & ~0x00000040);
        fontSize_ = null;
        if (fontSizeBuilder_ != null) {
          fontSizeBuilder_.dispose();
          fontSizeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Font size.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Style.FontSize font_size = 7;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Style.FontSize.Builder
          getFontSizeBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getFontSizeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Font size.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Style.FontSize font_size = 7;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Style.FontSizeOrBuilder
          getFontSizeOrBuilder() {
        if (fontSizeBuilder_ != null) {
          return fontSizeBuilder_.getMessageOrBuilder();
        } else {
          return fontSize_ == null
              ? com.google.cloud.documentai.v1beta1.Document.Style.FontSize.getDefaultInstance()
              : fontSize_;
        }
      }
      /**
       *
       *
       * <pre>
       * Font size.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Style.FontSize font_size = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta1.Document.Style.FontSize,
              com.google.cloud.documentai.v1beta1.Document.Style.FontSize.Builder,
              com.google.cloud.documentai.v1beta1.Document.Style.FontSizeOrBuilder>
          getFontSizeFieldBuilder() {
        if (fontSizeBuilder_ == null) {
          fontSizeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta1.Document.Style.FontSize,
                  com.google.cloud.documentai.v1beta1.Document.Style.FontSize.Builder,
                  com.google.cloud.documentai.v1beta1.Document.Style.FontSizeOrBuilder>(
                  getFontSize(), getParentForChildren(), isClean());
          fontSize_ = null;
        }
        return fontSizeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta1.Document.Style)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta1.Document.Style)
    private static final com.google.cloud.documentai.v1beta1.Document.Style DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta1.Document.Style();
    }

    public static com.google.cloud.documentai.v1beta1.Document.Style getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Style> PARSER =
        new com.google.protobuf.AbstractParser<Style>() {
          @java.lang.Override
          public Style parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Style> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Style> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Style getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PageOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta1.Document.Page)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * 1-based index for current
     * [Page][google.cloud.documentai.v1beta1.Document.Page] in a parent
     * [Document][google.cloud.documentai.v1beta1.Document]. Useful when a page
     * is taken out of a [Document][google.cloud.documentai.v1beta1.Document]
     * for individual processing.
     * </pre>
     *
     * <code>int32 page_number = 1;</code>
     *
     * @return The pageNumber.
     */
    int getPageNumber();

    /**
     *
     *
     * <pre>
     * Physical dimension of the page.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.Page.Dimension dimension = 2;</code>
     *
     * @return Whether the dimension field is set.
     */
    boolean hasDimension();
    /**
     *
     *
     * <pre>
     * Physical dimension of the page.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.Page.Dimension dimension = 2;</code>
     *
     * @return The dimension.
     */
    com.google.cloud.documentai.v1beta1.Document.Page.Dimension getDimension();
    /**
     *
     *
     * <pre>
     * Physical dimension of the page.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.Page.Dimension dimension = 2;</code>
     */
    com.google.cloud.documentai.v1beta1.Document.Page.DimensionOrBuilder getDimensionOrBuilder();

    /**
     *
     *
     * <pre>
     * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
     * page.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 3;</code>
     *
     * @return Whether the layout field is set.
     */
    boolean hasLayout();
    /**
     *
     *
     * <pre>
     * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
     * page.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 3;</code>
     *
     * @return The layout.
     */
    com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout();
    /**
     *
     *
     * <pre>
     * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
     * page.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 3;</code>
     */
    com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder getLayoutOrBuilder();

    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
     * </code>
     */
    java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
        getDetectedLanguagesList();
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
     * </code>
     */
    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage getDetectedLanguages(
        int index);
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
     * </code>
     */
    int getDetectedLanguagesCount();
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
        getDetectedLanguagesOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
     * </code>
     */
    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
        getDetectedLanguagesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * A list of visually detected text blocks on the page.
     * A block has a set of lines (collected into paragraphs) that have a common
     * line-spacing and orientation.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
     */
    java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Block> getBlocksList();
    /**
     *
     *
     * <pre>
     * A list of visually detected text blocks on the page.
     * A block has a set of lines (collected into paragraphs) that have a common
     * line-spacing and orientation.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
     */
    com.google.cloud.documentai.v1beta1.Document.Page.Block getBlocks(int index);
    /**
     *
     *
     * <pre>
     * A list of visually detected text blocks on the page.
     * A block has a set of lines (collected into paragraphs) that have a common
     * line-spacing and orientation.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
     */
    int getBlocksCount();
    /**
     *
     *
     * <pre>
     * A list of visually detected text blocks on the page.
     * A block has a set of lines (collected into paragraphs) that have a common
     * line-spacing and orientation.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
     */
    java.util.List<? extends com.google.cloud.documentai.v1beta1.Document.Page.BlockOrBuilder>
        getBlocksOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of visually detected text blocks on the page.
     * A block has a set of lines (collected into paragraphs) that have a common
     * line-spacing and orientation.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
     */
    com.google.cloud.documentai.v1beta1.Document.Page.BlockOrBuilder getBlocksOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * A list of visually detected text paragraphs on the page.
     * A collection of lines that a human would perceive as a paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
     * </code>
     */
    java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Paragraph> getParagraphsList();
    /**
     *
     *
     * <pre>
     * A list of visually detected text paragraphs on the page.
     * A collection of lines that a human would perceive as a paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
     * </code>
     */
    com.google.cloud.documentai.v1beta1.Document.Page.Paragraph getParagraphs(int index);
    /**
     *
     *
     * <pre>
     * A list of visually detected text paragraphs on the page.
     * A collection of lines that a human would perceive as a paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
     * </code>
     */
    int getParagraphsCount();
    /**
     *
     *
     * <pre>
     * A list of visually detected text paragraphs on the page.
     * A collection of lines that a human would perceive as a paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
     * </code>
     */
    java.util.List<? extends com.google.cloud.documentai.v1beta1.Document.Page.ParagraphOrBuilder>
        getParagraphsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of visually detected text paragraphs on the page.
     * A collection of lines that a human would perceive as a paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
     * </code>
     */
    com.google.cloud.documentai.v1beta1.Document.Page.ParagraphOrBuilder getParagraphsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * A list of visually detected text lines on the page.
     * A collection of tokens that a human would perceive as a line.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
     */
    java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Line> getLinesList();
    /**
     *
     *
     * <pre>
     * A list of visually detected text lines on the page.
     * A collection of tokens that a human would perceive as a line.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
     */
    com.google.cloud.documentai.v1beta1.Document.Page.Line getLines(int index);
    /**
     *
     *
     * <pre>
     * A list of visually detected text lines on the page.
     * A collection of tokens that a human would perceive as a line.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
     */
    int getLinesCount();
    /**
     *
     *
     * <pre>
     * A list of visually detected text lines on the page.
     * A collection of tokens that a human would perceive as a line.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
     */
    java.util.List<? extends com.google.cloud.documentai.v1beta1.Document.Page.LineOrBuilder>
        getLinesOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of visually detected text lines on the page.
     * A collection of tokens that a human would perceive as a line.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
     */
    com.google.cloud.documentai.v1beta1.Document.Page.LineOrBuilder getLinesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * A list of visually detected tokens on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
     */
    java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Token> getTokensList();
    /**
     *
     *
     * <pre>
     * A list of visually detected tokens on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
     */
    com.google.cloud.documentai.v1beta1.Document.Page.Token getTokens(int index);
    /**
     *
     *
     * <pre>
     * A list of visually detected tokens on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
     */
    int getTokensCount();
    /**
     *
     *
     * <pre>
     * A list of visually detected tokens on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
     */
    java.util.List<? extends com.google.cloud.documentai.v1beta1.Document.Page.TokenOrBuilder>
        getTokensOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of visually detected tokens on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
     */
    com.google.cloud.documentai.v1beta1.Document.Page.TokenOrBuilder getTokensOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * A list of detected non-text visual elements e.g. checkbox,
     * signature etc. on the page.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta1.Document.Page.VisualElement visual_elements = 9;
     * </code>
     */
    java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.VisualElement>
        getVisualElementsList();
    /**
     *
     *
     * <pre>
     * A list of detected non-text visual elements e.g. checkbox,
     * signature etc. on the page.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta1.Document.Page.VisualElement visual_elements = 9;
     * </code>
     */
    com.google.cloud.documentai.v1beta1.Document.Page.VisualElement getVisualElements(int index);
    /**
     *
     *
     * <pre>
     * A list of detected non-text visual elements e.g. checkbox,
     * signature etc. on the page.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta1.Document.Page.VisualElement visual_elements = 9;
     * </code>
     */
    int getVisualElementsCount();
    /**
     *
     *
     * <pre>
     * A list of detected non-text visual elements e.g. checkbox,
     * signature etc. on the page.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta1.Document.Page.VisualElement visual_elements = 9;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.documentai.v1beta1.Document.Page.VisualElementOrBuilder>
        getVisualElementsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of detected non-text visual elements e.g. checkbox,
     * signature etc. on the page.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta1.Document.Page.VisualElement visual_elements = 9;
     * </code>
     */
    com.google.cloud.documentai.v1beta1.Document.Page.VisualElementOrBuilder
        getVisualElementsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * A list of visually detected tables on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table tables = 10;</code>
     */
    java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Table> getTablesList();
    /**
     *
     *
     * <pre>
     * A list of visually detected tables on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table tables = 10;</code>
     */
    com.google.cloud.documentai.v1beta1.Document.Page.Table getTables(int index);
    /**
     *
     *
     * <pre>
     * A list of visually detected tables on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table tables = 10;</code>
     */
    int getTablesCount();
    /**
     *
     *
     * <pre>
     * A list of visually detected tables on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table tables = 10;</code>
     */
    java.util.List<? extends com.google.cloud.documentai.v1beta1.Document.Page.TableOrBuilder>
        getTablesOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of visually detected tables on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table tables = 10;</code>
     */
    com.google.cloud.documentai.v1beta1.Document.Page.TableOrBuilder getTablesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * A list of visually detected form fields on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.FormField form_fields = 11;
     * </code>
     */
    java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.FormField> getFormFieldsList();
    /**
     *
     *
     * <pre>
     * A list of visually detected form fields on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.FormField form_fields = 11;
     * </code>
     */
    com.google.cloud.documentai.v1beta1.Document.Page.FormField getFormFields(int index);
    /**
     *
     *
     * <pre>
     * A list of visually detected form fields on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.FormField form_fields = 11;
     * </code>
     */
    int getFormFieldsCount();
    /**
     *
     *
     * <pre>
     * A list of visually detected form fields on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.FormField form_fields = 11;
     * </code>
     */
    java.util.List<? extends com.google.cloud.documentai.v1beta1.Document.Page.FormFieldOrBuilder>
        getFormFieldsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of visually detected form fields on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.FormField form_fields = 11;
     * </code>
     */
    com.google.cloud.documentai.v1beta1.Document.Page.FormFieldOrBuilder getFormFieldsOrBuilder(
        int index);
  }
  /**
   *
   *
   * <pre>
   * A page in a [Document][google.cloud.documentai.v1beta1.Document].
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page}
   */
  public static final class Page extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta1.Document.Page)
      PageOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Page.newBuilder() to construct.
    private Page(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Page() {
      detectedLanguages_ = java.util.Collections.emptyList();
      blocks_ = java.util.Collections.emptyList();
      paragraphs_ = java.util.Collections.emptyList();
      lines_ = java.util.Collections.emptyList();
      tokens_ = java.util.Collections.emptyList();
      visualElements_ = java.util.Collections.emptyList();
      tables_ = java.util.Collections.emptyList();
      formFields_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Page();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta1.DocumentProto
          .internal_static_google_cloud_documentai_v1beta1_Document_Page_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta1.DocumentProto
          .internal_static_google_cloud_documentai_v1beta1_Document_Page_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta1.Document.Page.class,
              com.google.cloud.documentai.v1beta1.Document.Page.Builder.class);
    }

    public interface DimensionOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta1.Document.Page.Dimension)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Page width.
       * </pre>
       *
       * <code>float width = 1;</code>
       *
       * @return The width.
       */
      float getWidth();

      /**
       *
       *
       * <pre>
       * Page height.
       * </pre>
       *
       * <code>float height = 2;</code>
       *
       * @return The height.
       */
      float getHeight();

      /**
       *
       *
       * <pre>
       * Dimension unit.
       * </pre>
       *
       * <code>string unit = 3;</code>
       *
       * @return The unit.
       */
      java.lang.String getUnit();
      /**
       *
       *
       * <pre>
       * Dimension unit.
       * </pre>
       *
       * <code>string unit = 3;</code>
       *
       * @return The bytes for unit.
       */
      com.google.protobuf.ByteString getUnitBytes();
    }
    /**
     *
     *
     * <pre>
     * Dimension for the page.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.Dimension}
     */
    public static final class Dimension extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta1.Document.Page.Dimension)
        DimensionOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Dimension.newBuilder() to construct.
      private Dimension(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Dimension() {
        unit_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Dimension();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_Dimension_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_Dimension_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta1.Document.Page.Dimension.class,
                com.google.cloud.documentai.v1beta1.Document.Page.Dimension.Builder.class);
      }

      public static final int WIDTH_FIELD_NUMBER = 1;
      private float width_ = 0F;
      /**
       *
       *
       * <pre>
       * Page width.
       * </pre>
       *
       * <code>float width = 1;</code>
       *
       * @return The width.
       */
      @java.lang.Override
      public float getWidth() {
        return width_;
      }

      public static final int HEIGHT_FIELD_NUMBER = 2;
      private float height_ = 0F;
      /**
       *
       *
       * <pre>
       * Page height.
       * </pre>
       *
       * <code>float height = 2;</code>
       *
       * @return The height.
       */
      @java.lang.Override
      public float getHeight() {
        return height_;
      }

      public static final int UNIT_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object unit_ = "";
      /**
       *
       *
       * <pre>
       * Dimension unit.
       * </pre>
       *
       * <code>string unit = 3;</code>
       *
       * @return The unit.
       */
      @java.lang.Override
      public java.lang.String getUnit() {
        java.lang.Object ref = unit_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          unit_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Dimension unit.
       * </pre>
       *
       * <code>string unit = 3;</code>
       *
       * @return The bytes for unit.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUnitBytes() {
        java.lang.Object ref = unit_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          unit_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (java.lang.Float.floatToRawIntBits(width_) != 0) {
          output.writeFloat(1, width_);
        }
        if (java.lang.Float.floatToRawIntBits(height_) != 0) {
          output.writeFloat(2, height_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, unit_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (java.lang.Float.floatToRawIntBits(width_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, width_);
        }
        if (java.lang.Float.floatToRawIntBits(height_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, height_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, unit_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta1.Document.Page.Dimension)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta1.Document.Page.Dimension other =
            (com.google.cloud.documentai.v1beta1.Document.Page.Dimension) obj;

        if (java.lang.Float.floatToIntBits(getWidth())
            != java.lang.Float.floatToIntBits(other.getWidth())) return false;
        if (java.lang.Float.floatToIntBits(getHeight())
            != java.lang.Float.floatToIntBits(other.getHeight())) return false;
        if (!getUnit().equals(other.getUnit())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + WIDTH_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getWidth());
        hash = (37 * hash) + HEIGHT_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getHeight());
        hash = (37 * hash) + UNIT_FIELD_NUMBER;
        hash = (53 * hash) + getUnit().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Dimension parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Dimension parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Dimension parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Dimension parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Dimension parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Dimension parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Dimension parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Dimension parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Dimension parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Dimension parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Dimension parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Dimension parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta1.Document.Page.Dimension prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Dimension for the page.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.Dimension}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta1.Document.Page.Dimension)
          com.google.cloud.documentai.v1beta1.Document.Page.DimensionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Dimension_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Dimension_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta1.Document.Page.Dimension.class,
                  com.google.cloud.documentai.v1beta1.Document.Page.Dimension.Builder.class);
        }

        // Construct using com.google.cloud.documentai.v1beta1.Document.Page.Dimension.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          width_ = 0F;
          height_ = 0F;
          unit_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Dimension_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Dimension
            getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta1.Document.Page.Dimension.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Dimension build() {
          com.google.cloud.documentai.v1beta1.Document.Page.Dimension result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Dimension buildPartial() {
          com.google.cloud.documentai.v1beta1.Document.Page.Dimension result =
              new com.google.cloud.documentai.v1beta1.Document.Page.Dimension(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.documentai.v1beta1.Document.Page.Dimension result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.width_ = width_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.height_ = height_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.unit_ = unit_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta1.Document.Page.Dimension) {
            return mergeFrom((com.google.cloud.documentai.v1beta1.Document.Page.Dimension) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.documentai.v1beta1.Document.Page.Dimension other) {
          if (other
              == com.google.cloud.documentai.v1beta1.Document.Page.Dimension.getDefaultInstance())
            return this;
          if (other.getWidth() != 0F) {
            setWidth(other.getWidth());
          }
          if (other.getHeight() != 0F) {
            setHeight(other.getHeight());
          }
          if (!other.getUnit().isEmpty()) {
            unit_ = other.unit_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 13:
                  {
                    width_ = input.readFloat();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 13
                case 21:
                  {
                    height_ = input.readFloat();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 21
                case 26:
                  {
                    unit_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private float width_;
        /**
         *
         *
         * <pre>
         * Page width.
         * </pre>
         *
         * <code>float width = 1;</code>
         *
         * @return The width.
         */
        @java.lang.Override
        public float getWidth() {
          return width_;
        }
        /**
         *
         *
         * <pre>
         * Page width.
         * </pre>
         *
         * <code>float width = 1;</code>
         *
         * @param value The width to set.
         * @return This builder for chaining.
         */
        public Builder setWidth(float value) {

          width_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Page width.
         * </pre>
         *
         * <code>float width = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearWidth() {
          bitField0_ = (bitField0_ & ~0x00000001);
          width_ = 0F;
          onChanged();
          return this;
        }

        private float height_;
        /**
         *
         *
         * <pre>
         * Page height.
         * </pre>
         *
         * <code>float height = 2;</code>
         *
         * @return The height.
         */
        @java.lang.Override
        public float getHeight() {
          return height_;
        }
        /**
         *
         *
         * <pre>
         * Page height.
         * </pre>
         *
         * <code>float height = 2;</code>
         *
         * @param value The height to set.
         * @return This builder for chaining.
         */
        public Builder setHeight(float value) {

          height_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Page height.
         * </pre>
         *
         * <code>float height = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearHeight() {
          bitField0_ = (bitField0_ & ~0x00000002);
          height_ = 0F;
          onChanged();
          return this;
        }

        private java.lang.Object unit_ = "";
        /**
         *
         *
         * <pre>
         * Dimension unit.
         * </pre>
         *
         * <code>string unit = 3;</code>
         *
         * @return The unit.
         */
        public java.lang.String getUnit() {
          java.lang.Object ref = unit_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            unit_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Dimension unit.
         * </pre>
         *
         * <code>string unit = 3;</code>
         *
         * @return The bytes for unit.
         */
        public com.google.protobuf.ByteString getUnitBytes() {
          java.lang.Object ref = unit_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            unit_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Dimension unit.
         * </pre>
         *
         * <code>string unit = 3;</code>
         *
         * @param value The unit to set.
         * @return This builder for chaining.
         */
        public Builder setUnit(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          unit_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Dimension unit.
         * </pre>
         *
         * <code>string unit = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUnit() {
          unit_ = getDefaultInstance().getUnit();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Dimension unit.
         * </pre>
         *
         * <code>string unit = 3;</code>
         *
         * @param value The bytes for unit to set.
         * @return This builder for chaining.
         */
        public Builder setUnitBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          unit_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta1.Document.Page.Dimension)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta1.Document.Page.Dimension)
      private static final com.google.cloud.documentai.v1beta1.Document.Page.Dimension
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta1.Document.Page.Dimension();
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Dimension
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Dimension> PARSER =
          new com.google.protobuf.AbstractParser<Dimension>() {
            @java.lang.Override
            public Dimension parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Dimension> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Dimension> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Dimension
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface LayoutOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta1.Document.Page.Layout)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta1.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
       *
       * @return Whether the textAnchor field is set.
       */
      boolean hasTextAnchor();
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta1.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
       *
       * @return The textAnchor.
       */
      com.google.cloud.documentai.v1beta1.Document.TextAnchor getTextAnchor();
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta1.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
       */
      com.google.cloud.documentai.v1beta1.Document.TextAnchorOrBuilder getTextAnchorOrBuilder();

      /**
       *
       *
       * <pre>
       * Confidence of the current
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] within
       * context of the object this layout is for. e.g. confidence can be for a
       * single token, a table, a visual element, etc. depending on context.
       * Range [0, 1].
       * </pre>
       *
       * <code>float confidence = 2;</code>
       *
       * @return The confidence.
       */
      float getConfidence();

      /**
       *
       *
       * <pre>
       * The bounding polygon for the
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.BoundingPoly bounding_poly = 3;</code>
       *
       * @return Whether the boundingPoly field is set.
       */
      boolean hasBoundingPoly();
      /**
       *
       *
       * <pre>
       * The bounding polygon for the
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.BoundingPoly bounding_poly = 3;</code>
       *
       * @return The boundingPoly.
       */
      com.google.cloud.documentai.v1beta1.BoundingPoly getBoundingPoly();
      /**
       *
       *
       * <pre>
       * The bounding polygon for the
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.BoundingPoly bounding_poly = 3;</code>
       */
      com.google.cloud.documentai.v1beta1.BoundingPolyOrBuilder getBoundingPolyOrBuilder();

      /**
       *
       *
       * <pre>
       * Detected orientation for the
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation orientation = 4;
       * </code>
       *
       * @return The enum numeric value on the wire for orientation.
       */
      int getOrientationValue();
      /**
       *
       *
       * <pre>
       * Detected orientation for the
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation orientation = 4;
       * </code>
       *
       * @return The orientation.
       */
      com.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation getOrientation();
    }
    /**
     *
     *
     * <pre>
     * Visual element describing a layout unit on a page.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.Layout}
     */
    public static final class Layout extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta1.Document.Page.Layout)
        LayoutOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Layout.newBuilder() to construct.
      private Layout(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Layout() {
        orientation_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Layout();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_Layout_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_Layout_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta1.Document.Page.Layout.class,
                com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder.class);
      }

      /**
       *
       *
       * <pre>
       * Detected human reading orientation.
       * </pre>
       *
       * Protobuf enum {@code google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation}
       */
      public enum Orientation implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Unspecified orientation.
         * </pre>
         *
         * <code>ORIENTATION_UNSPECIFIED = 0;</code>
         */
        ORIENTATION_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Orientation is aligned with page up.
         * </pre>
         *
         * <code>PAGE_UP = 1;</code>
         */
        PAGE_UP(1),
        /**
         *
         *
         * <pre>
         * Orientation is aligned with page right.
         * Turn the head 90 degrees clockwise from upright to read.
         * </pre>
         *
         * <code>PAGE_RIGHT = 2;</code>
         */
        PAGE_RIGHT(2),
        /**
         *
         *
         * <pre>
         * Orientation is aligned with page down.
         * Turn the head 180 degrees from upright to read.
         * </pre>
         *
         * <code>PAGE_DOWN = 3;</code>
         */
        PAGE_DOWN(3),
        /**
         *
         *
         * <pre>
         * Orientation is aligned with page left.
         * Turn the head 90 degrees counterclockwise from upright to read.
         * </pre>
         *
         * <code>PAGE_LEFT = 4;</code>
         */
        PAGE_LEFT(4),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Unspecified orientation.
         * </pre>
         *
         * <code>ORIENTATION_UNSPECIFIED = 0;</code>
         */
        public static final int ORIENTATION_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Orientation is aligned with page up.
         * </pre>
         *
         * <code>PAGE_UP = 1;</code>
         */
        public static final int PAGE_UP_VALUE = 1;
        /**
         *
         *
         * <pre>
         * Orientation is aligned with page right.
         * Turn the head 90 degrees clockwise from upright to read.
         * </pre>
         *
         * <code>PAGE_RIGHT = 2;</code>
         */
        public static final int PAGE_RIGHT_VALUE = 2;
        /**
         *
         *
         * <pre>
         * Orientation is aligned with page down.
         * Turn the head 180 degrees from upright to read.
         * </pre>
         *
         * <code>PAGE_DOWN = 3;</code>
         */
        public static final int PAGE_DOWN_VALUE = 3;
        /**
         *
         *
         * <pre>
         * Orientation is aligned with page left.
         * Turn the head 90 degrees counterclockwise from upright to read.
         * </pre>
         *
         * <code>PAGE_LEFT = 4;</code>
         */
        public static final int PAGE_LEFT_VALUE = 4;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static Orientation valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static Orientation forNumber(int value) {
          switch (value) {
            case 0:
              return ORIENTATION_UNSPECIFIED;
            case 1:
              return PAGE_UP;
            case 2:
              return PAGE_RIGHT;
            case 3:
              return PAGE_DOWN;
            case 4:
              return PAGE_LEFT;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<Orientation> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<Orientation>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<Orientation>() {
                  public Orientation findValueByNumber(int number) {
                    return Orientation.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final Orientation[] VALUES = values();

        public static Orientation valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private Orientation(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation)
      }

      private int bitField0_;
      public static final int TEXT_ANCHOR_FIELD_NUMBER = 1;
      private com.google.cloud.documentai.v1beta1.Document.TextAnchor textAnchor_;
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta1.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
       *
       * @return Whether the textAnchor field is set.
       */
      @java.lang.Override
      public boolean hasTextAnchor() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta1.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
       *
       * @return The textAnchor.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.TextAnchor getTextAnchor() {
        return textAnchor_ == null
            ? com.google.cloud.documentai.v1beta1.Document.TextAnchor.getDefaultInstance()
            : textAnchor_;
      }
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta1.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.TextAnchorOrBuilder
          getTextAnchorOrBuilder() {
        return textAnchor_ == null
            ? com.google.cloud.documentai.v1beta1.Document.TextAnchor.getDefaultInstance()
            : textAnchor_;
      }

      public static final int CONFIDENCE_FIELD_NUMBER = 2;
      private float confidence_ = 0F;
      /**
       *
       *
       * <pre>
       * Confidence of the current
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] within
       * context of the object this layout is for. e.g. confidence can be for a
       * single token, a table, a visual element, etc. depending on context.
       * Range [0, 1].
       * </pre>
       *
       * <code>float confidence = 2;</code>
       *
       * @return The confidence.
       */
      @java.lang.Override
      public float getConfidence() {
        return confidence_;
      }

      public static final int BOUNDING_POLY_FIELD_NUMBER = 3;
      private com.google.cloud.documentai.v1beta1.BoundingPoly boundingPoly_;
      /**
       *
       *
       * <pre>
       * The bounding polygon for the
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.BoundingPoly bounding_poly = 3;</code>
       *
       * @return Whether the boundingPoly field is set.
       */
      @java.lang.Override
      public boolean hasBoundingPoly() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The bounding polygon for the
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.BoundingPoly bounding_poly = 3;</code>
       *
       * @return The boundingPoly.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.BoundingPoly getBoundingPoly() {
        return boundingPoly_ == null
            ? com.google.cloud.documentai.v1beta1.BoundingPoly.getDefaultInstance()
            : boundingPoly_;
      }
      /**
       *
       *
       * <pre>
       * The bounding polygon for the
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.BoundingPoly bounding_poly = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.BoundingPolyOrBuilder getBoundingPolyOrBuilder() {
        return boundingPoly_ == null
            ? com.google.cloud.documentai.v1beta1.BoundingPoly.getDefaultInstance()
            : boundingPoly_;
      }

      public static final int ORIENTATION_FIELD_NUMBER = 4;
      private int orientation_ = 0;
      /**
       *
       *
       * <pre>
       * Detected orientation for the
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation orientation = 4;
       * </code>
       *
       * @return The enum numeric value on the wire for orientation.
       */
      @java.lang.Override
      public int getOrientationValue() {
        return orientation_;
      }
      /**
       *
       *
       * <pre>
       * Detected orientation for the
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation orientation = 4;
       * </code>
       *
       * @return The orientation.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation getOrientation() {
        com.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation result =
            com.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation.forNumber(
                orientation_);
        return result == null
            ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation.UNRECOGNIZED
            : result;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getTextAnchor());
        }
        if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
          output.writeFloat(2, confidence_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(3, getBoundingPoly());
        }
        if (orientation_
            != com.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation
                .ORIENTATION_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(4, orientation_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTextAnchor());
        }
        if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, confidence_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getBoundingPoly());
        }
        if (orientation_
            != com.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation
                .ORIENTATION_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, orientation_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta1.Document.Page.Layout)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta1.Document.Page.Layout other =
            (com.google.cloud.documentai.v1beta1.Document.Page.Layout) obj;

        if (hasTextAnchor() != other.hasTextAnchor()) return false;
        if (hasTextAnchor()) {
          if (!getTextAnchor().equals(other.getTextAnchor())) return false;
        }
        if (java.lang.Float.floatToIntBits(getConfidence())
            != java.lang.Float.floatToIntBits(other.getConfidence())) return false;
        if (hasBoundingPoly() != other.hasBoundingPoly()) return false;
        if (hasBoundingPoly()) {
          if (!getBoundingPoly().equals(other.getBoundingPoly())) return false;
        }
        if (orientation_ != other.orientation_) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasTextAnchor()) {
          hash = (37 * hash) + TEXT_ANCHOR_FIELD_NUMBER;
          hash = (53 * hash) + getTextAnchor().hashCode();
        }
        hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidence());
        if (hasBoundingPoly()) {
          hash = (37 * hash) + BOUNDING_POLY_FIELD_NUMBER;
          hash = (53 * hash) + getBoundingPoly().hashCode();
        }
        hash = (37 * hash) + ORIENTATION_FIELD_NUMBER;
        hash = (53 * hash) + orientation_;
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Layout parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Layout parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Layout parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Layout parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Layout parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Layout parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Layout parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Layout parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Layout parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Layout parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Layout parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Layout parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta1.Document.Page.Layout prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Visual element describing a layout unit on a page.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.Layout}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta1.Document.Page.Layout)
          com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Layout_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Layout_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta1.Document.Page.Layout.class,
                  com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder.class);
        }

        // Construct using com.google.cloud.documentai.v1beta1.Document.Page.Layout.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getTextAnchorFieldBuilder();
            getBoundingPolyFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          textAnchor_ = null;
          if (textAnchorBuilder_ != null) {
            textAnchorBuilder_.dispose();
            textAnchorBuilder_ = null;
          }
          confidence_ = 0F;
          boundingPoly_ = null;
          if (boundingPolyBuilder_ != null) {
            boundingPolyBuilder_.dispose();
            boundingPolyBuilder_ = null;
          }
          orientation_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Layout_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout
            getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout build() {
          com.google.cloud.documentai.v1beta1.Document.Page.Layout result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout buildPartial() {
          com.google.cloud.documentai.v1beta1.Document.Page.Layout result =
              new com.google.cloud.documentai.v1beta1.Document.Page.Layout(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.documentai.v1beta1.Document.Page.Layout result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.textAnchor_ =
                textAnchorBuilder_ == null ? textAnchor_ : textAnchorBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.confidence_ = confidence_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.boundingPoly_ =
                boundingPolyBuilder_ == null ? boundingPoly_ : boundingPolyBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.orientation_ = orientation_;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta1.Document.Page.Layout) {
            return mergeFrom((com.google.cloud.documentai.v1beta1.Document.Page.Layout) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.documentai.v1beta1.Document.Page.Layout other) {
          if (other
              == com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance())
            return this;
          if (other.hasTextAnchor()) {
            mergeTextAnchor(other.getTextAnchor());
          }
          if (other.getConfidence() != 0F) {
            setConfidence(other.getConfidence());
          }
          if (other.hasBoundingPoly()) {
            mergeBoundingPoly(other.getBoundingPoly());
          }
          if (other.orientation_ != 0) {
            setOrientationValue(other.getOrientationValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getTextAnchorFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 21:
                  {
                    confidence_ = input.readFloat();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 21
                case 26:
                  {
                    input.readMessage(
                        getBoundingPolyFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 32:
                  {
                    orientation_ = input.readEnum();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 32
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.documentai.v1beta1.Document.TextAnchor textAnchor_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.TextAnchor,
                com.google.cloud.documentai.v1beta1.Document.TextAnchor.Builder,
                com.google.cloud.documentai.v1beta1.Document.TextAnchorOrBuilder>
            textAnchorBuilder_;
        /**
         *
         *
         * <pre>
         * Text anchor indexing into the
         * [Document.text][google.cloud.documentai.v1beta1.Document.text].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
         *
         * @return Whether the textAnchor field is set.
         */
        public boolean hasTextAnchor() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Text anchor indexing into the
         * [Document.text][google.cloud.documentai.v1beta1.Document.text].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
         *
         * @return The textAnchor.
         */
        public com.google.cloud.documentai.v1beta1.Document.TextAnchor getTextAnchor() {
          if (textAnchorBuilder_ == null) {
            return textAnchor_ == null
                ? com.google.cloud.documentai.v1beta1.Document.TextAnchor.getDefaultInstance()
                : textAnchor_;
          } else {
            return textAnchorBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Text anchor indexing into the
         * [Document.text][google.cloud.documentai.v1beta1.Document.text].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
         */
        public Builder setTextAnchor(
            com.google.cloud.documentai.v1beta1.Document.TextAnchor value) {
          if (textAnchorBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            textAnchor_ = value;
          } else {
            textAnchorBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Text anchor indexing into the
         * [Document.text][google.cloud.documentai.v1beta1.Document.text].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
         */
        public Builder setTextAnchor(
            com.google.cloud.documentai.v1beta1.Document.TextAnchor.Builder builderForValue) {
          if (textAnchorBuilder_ == null) {
            textAnchor_ = builderForValue.build();
          } else {
            textAnchorBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Text anchor indexing into the
         * [Document.text][google.cloud.documentai.v1beta1.Document.text].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
         */
        public Builder mergeTextAnchor(
            com.google.cloud.documentai.v1beta1.Document.TextAnchor value) {
          if (textAnchorBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && textAnchor_ != null
                && textAnchor_
                    != com.google.cloud.documentai.v1beta1.Document.TextAnchor
                        .getDefaultInstance()) {
              getTextAnchorBuilder().mergeFrom(value);
            } else {
              textAnchor_ = value;
            }
          } else {
            textAnchorBuilder_.mergeFrom(value);
          }
          if (textAnchor_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Text anchor indexing into the
         * [Document.text][google.cloud.documentai.v1beta1.Document.text].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
         */
        public Builder clearTextAnchor() {
          bitField0_ = (bitField0_ & ~0x00000001);
          textAnchor_ = null;
          if (textAnchorBuilder_ != null) {
            textAnchorBuilder_.dispose();
            textAnchorBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Text anchor indexing into the
         * [Document.text][google.cloud.documentai.v1beta1.Document.text].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
         */
        public com.google.cloud.documentai.v1beta1.Document.TextAnchor.Builder
            getTextAnchorBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getTextAnchorFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Text anchor indexing into the
         * [Document.text][google.cloud.documentai.v1beta1.Document.text].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
         */
        public com.google.cloud.documentai.v1beta1.Document.TextAnchorOrBuilder
            getTextAnchorOrBuilder() {
          if (textAnchorBuilder_ != null) {
            return textAnchorBuilder_.getMessageOrBuilder();
          } else {
            return textAnchor_ == null
                ? com.google.cloud.documentai.v1beta1.Document.TextAnchor.getDefaultInstance()
                : textAnchor_;
          }
        }
        /**
         *
         *
         * <pre>
         * Text anchor indexing into the
         * [Document.text][google.cloud.documentai.v1beta1.Document.text].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.TextAnchor text_anchor = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.TextAnchor,
                com.google.cloud.documentai.v1beta1.Document.TextAnchor.Builder,
                com.google.cloud.documentai.v1beta1.Document.TextAnchorOrBuilder>
            getTextAnchorFieldBuilder() {
          if (textAnchorBuilder_ == null) {
            textAnchorBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.Document.TextAnchor,
                    com.google.cloud.documentai.v1beta1.Document.TextAnchor.Builder,
                    com.google.cloud.documentai.v1beta1.Document.TextAnchorOrBuilder>(
                    getTextAnchor(), getParentForChildren(), isClean());
            textAnchor_ = null;
          }
          return textAnchorBuilder_;
        }

        private float confidence_;
        /**
         *
         *
         * <pre>
         * Confidence of the current
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] within
         * context of the object this layout is for. e.g. confidence can be for a
         * single token, a table, a visual element, etc. depending on context.
         * Range [0, 1].
         * </pre>
         *
         * <code>float confidence = 2;</code>
         *
         * @return The confidence.
         */
        @java.lang.Override
        public float getConfidence() {
          return confidence_;
        }
        /**
         *
         *
         * <pre>
         * Confidence of the current
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] within
         * context of the object this layout is for. e.g. confidence can be for a
         * single token, a table, a visual element, etc. depending on context.
         * Range [0, 1].
         * </pre>
         *
         * <code>float confidence = 2;</code>
         *
         * @param value The confidence to set.
         * @return This builder for chaining.
         */
        public Builder setConfidence(float value) {

          confidence_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Confidence of the current
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] within
         * context of the object this layout is for. e.g. confidence can be for a
         * single token, a table, a visual element, etc. depending on context.
         * Range [0, 1].
         * </pre>
         *
         * <code>float confidence = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearConfidence() {
          bitField0_ = (bitField0_ & ~0x00000002);
          confidence_ = 0F;
          onChanged();
          return this;
        }

        private com.google.cloud.documentai.v1beta1.BoundingPoly boundingPoly_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.BoundingPoly,
                com.google.cloud.documentai.v1beta1.BoundingPoly.Builder,
                com.google.cloud.documentai.v1beta1.BoundingPolyOrBuilder>
            boundingPolyBuilder_;
        /**
         *
         *
         * <pre>
         * The bounding polygon for the
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.BoundingPoly bounding_poly = 3;</code>
         *
         * @return Whether the boundingPoly field is set.
         */
        public boolean hasBoundingPoly() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * The bounding polygon for the
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.BoundingPoly bounding_poly = 3;</code>
         *
         * @return The boundingPoly.
         */
        public com.google.cloud.documentai.v1beta1.BoundingPoly getBoundingPoly() {
          if (boundingPolyBuilder_ == null) {
            return boundingPoly_ == null
                ? com.google.cloud.documentai.v1beta1.BoundingPoly.getDefaultInstance()
                : boundingPoly_;
          } else {
            return boundingPolyBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The bounding polygon for the
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.BoundingPoly bounding_poly = 3;</code>
         */
        public Builder setBoundingPoly(com.google.cloud.documentai.v1beta1.BoundingPoly value) {
          if (boundingPolyBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            boundingPoly_ = value;
          } else {
            boundingPolyBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The bounding polygon for the
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.BoundingPoly bounding_poly = 3;</code>
         */
        public Builder setBoundingPoly(
            com.google.cloud.documentai.v1beta1.BoundingPoly.Builder builderForValue) {
          if (boundingPolyBuilder_ == null) {
            boundingPoly_ = builderForValue.build();
          } else {
            boundingPolyBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The bounding polygon for the
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.BoundingPoly bounding_poly = 3;</code>
         */
        public Builder mergeBoundingPoly(com.google.cloud.documentai.v1beta1.BoundingPoly value) {
          if (boundingPolyBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)
                && boundingPoly_ != null
                && boundingPoly_
                    != com.google.cloud.documentai.v1beta1.BoundingPoly.getDefaultInstance()) {
              getBoundingPolyBuilder().mergeFrom(value);
            } else {
              boundingPoly_ = value;
            }
          } else {
            boundingPolyBuilder_.mergeFrom(value);
          }
          if (boundingPoly_ != null) {
            bitField0_ |= 0x00000004;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The bounding polygon for the
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.BoundingPoly bounding_poly = 3;</code>
         */
        public Builder clearBoundingPoly() {
          bitField0_ = (bitField0_ & ~0x00000004);
          boundingPoly_ = null;
          if (boundingPolyBuilder_ != null) {
            boundingPolyBuilder_.dispose();
            boundingPolyBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The bounding polygon for the
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.BoundingPoly bounding_poly = 3;</code>
         */
        public com.google.cloud.documentai.v1beta1.BoundingPoly.Builder getBoundingPolyBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getBoundingPolyFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The bounding polygon for the
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.BoundingPoly bounding_poly = 3;</code>
         */
        public com.google.cloud.documentai.v1beta1.BoundingPolyOrBuilder
            getBoundingPolyOrBuilder() {
          if (boundingPolyBuilder_ != null) {
            return boundingPolyBuilder_.getMessageOrBuilder();
          } else {
            return boundingPoly_ == null
                ? com.google.cloud.documentai.v1beta1.BoundingPoly.getDefaultInstance()
                : boundingPoly_;
          }
        }
        /**
         *
         *
         * <pre>
         * The bounding polygon for the
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.BoundingPoly bounding_poly = 3;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.BoundingPoly,
                com.google.cloud.documentai.v1beta1.BoundingPoly.Builder,
                com.google.cloud.documentai.v1beta1.BoundingPolyOrBuilder>
            getBoundingPolyFieldBuilder() {
          if (boundingPolyBuilder_ == null) {
            boundingPolyBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.BoundingPoly,
                    com.google.cloud.documentai.v1beta1.BoundingPoly.Builder,
                    com.google.cloud.documentai.v1beta1.BoundingPolyOrBuilder>(
                    getBoundingPoly(), getParentForChildren(), isClean());
            boundingPoly_ = null;
          }
          return boundingPolyBuilder_;
        }

        private int orientation_ = 0;
        /**
         *
         *
         * <pre>
         * Detected orientation for the
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation orientation = 4;
         * </code>
         *
         * @return The enum numeric value on the wire for orientation.
         */
        @java.lang.Override
        public int getOrientationValue() {
          return orientation_;
        }
        /**
         *
         *
         * <pre>
         * Detected orientation for the
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation orientation = 4;
         * </code>
         *
         * @param value The enum numeric value on the wire for orientation to set.
         * @return This builder for chaining.
         */
        public Builder setOrientationValue(int value) {
          orientation_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Detected orientation for the
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation orientation = 4;
         * </code>
         *
         * @return The orientation.
         */
        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation
            getOrientation() {
          com.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation result =
              com.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation.forNumber(
                  orientation_);
          return result == null
              ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Detected orientation for the
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation orientation = 4;
         * </code>
         *
         * @param value The orientation to set.
         * @return This builder for chaining.
         */
        public Builder setOrientation(
            com.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000008;
          orientation_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Detected orientation for the
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation orientation = 4;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearOrientation() {
          bitField0_ = (bitField0_ & ~0x00000008);
          orientation_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta1.Document.Page.Layout)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta1.Document.Page.Layout)
      private static final com.google.cloud.documentai.v1beta1.Document.Page.Layout
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta1.Document.Page.Layout();
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Layout getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Layout> PARSER =
          new com.google.protobuf.AbstractParser<Layout>() {
            @java.lang.Override
            public Layout parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Layout> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Layout> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Layout getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface BlockOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta1.Document.Page.Block)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Block][google.cloud.documentai.v1beta1.Document.Page.Block].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      boolean hasLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Block][google.cloud.documentai.v1beta1.Document.Page.Block].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Block][google.cloud.documentai.v1beta1.Document.Page.Block].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder getLayoutOrBuilder();

      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          getDetectedLanguagesList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage getDetectedLanguages(
          int index);
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      int getDetectedLanguagesCount();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * A block has a set of lines (collected into paragraphs) that have a
     * common line-spacing and orientation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.Block}
     */
    public static final class Block extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta1.Document.Page.Block)
        BlockOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Block.newBuilder() to construct.
      private Block(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Block() {
        detectedLanguages_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Block();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_Block_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_Block_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta1.Document.Page.Block.class,
                com.google.cloud.documentai.v1beta1.Document.Page.Block.Builder.class);
      }

      private int bitField0_;
      public static final int LAYOUT_FIELD_NUMBER = 1;
      private com.google.cloud.documentai.v1beta1.Document.Page.Layout layout_;
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Block][google.cloud.documentai.v1beta1.Document.Page.Block].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      @java.lang.Override
      public boolean hasLayout() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Block][google.cloud.documentai.v1beta1.Document.Page.Block].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Block][google.cloud.documentai.v1beta1.Document.Page.Block].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder
          getLayoutOrBuilder() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }

      public static final int DETECTED_LANGUAGES_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          detectedLanguages_;
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          getDetectedLanguagesList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public int getDetectedLanguagesCount() {
        return detectedLanguages_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
          getDetectedLanguages(int index) {
        return detectedLanguages_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index) {
        return detectedLanguages_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getLayout());
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          output.writeMessage(2, detectedLanguages_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLayout());
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, detectedLanguages_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta1.Document.Page.Block)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta1.Document.Page.Block other =
            (com.google.cloud.documentai.v1beta1.Document.Page.Block) obj;

        if (hasLayout() != other.hasLayout()) return false;
        if (hasLayout()) {
          if (!getLayout().equals(other.getLayout())) return false;
        }
        if (!getDetectedLanguagesList().equals(other.getDetectedLanguagesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasLayout()) {
          hash = (37 * hash) + LAYOUT_FIELD_NUMBER;
          hash = (53 * hash) + getLayout().hashCode();
        }
        if (getDetectedLanguagesCount() > 0) {
          hash = (37 * hash) + DETECTED_LANGUAGES_FIELD_NUMBER;
          hash = (53 * hash) + getDetectedLanguagesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Block parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Block parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Block parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Block parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Block parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Block parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Block parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Block parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Block parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Block parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Block parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Block parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta1.Document.Page.Block prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A block has a set of lines (collected into paragraphs) that have a
       * common line-spacing and orientation.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.Block}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta1.Document.Page.Block)
          com.google.cloud.documentai.v1beta1.Document.Page.BlockOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Block_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Block_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta1.Document.Page.Block.class,
                  com.google.cloud.documentai.v1beta1.Document.Page.Block.Builder.class);
        }

        // Construct using com.google.cloud.documentai.v1beta1.Document.Page.Block.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getLayoutFieldBuilder();
            getDetectedLanguagesFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
          } else {
            detectedLanguages_ = null;
            detectedLanguagesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Block_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Block getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta1.Document.Page.Block.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Block build() {
          com.google.cloud.documentai.v1beta1.Document.Page.Block result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Block buildPartial() {
          com.google.cloud.documentai.v1beta1.Document.Page.Block result =
              new com.google.cloud.documentai.v1beta1.Document.Page.Block(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.documentai.v1beta1.Document.Page.Block result) {
          if (detectedLanguagesBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              detectedLanguages_ = java.util.Collections.unmodifiableList(detectedLanguages_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.detectedLanguages_ = detectedLanguages_;
          } else {
            result.detectedLanguages_ = detectedLanguagesBuilder_.build();
          }
        }

        private void buildPartial0(com.google.cloud.documentai.v1beta1.Document.Page.Block result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.layout_ = layoutBuilder_ == null ? layout_ : layoutBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta1.Document.Page.Block) {
            return mergeFrom((com.google.cloud.documentai.v1beta1.Document.Page.Block) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.documentai.v1beta1.Document.Page.Block other) {
          if (other == com.google.cloud.documentai.v1beta1.Document.Page.Block.getDefaultInstance())
            return this;
          if (other.hasLayout()) {
            mergeLayout(other.getLayout());
          }
          if (detectedLanguagesBuilder_ == null) {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguages_.isEmpty()) {
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureDetectedLanguagesIsMutable();
                detectedLanguages_.addAll(other.detectedLanguages_);
              }
              onChanged();
            }
          } else {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguagesBuilder_.isEmpty()) {
                detectedLanguagesBuilder_.dispose();
                detectedLanguagesBuilder_ = null;
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000002);
                detectedLanguagesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDetectedLanguagesFieldBuilder()
                        : null;
              } else {
                detectedLanguagesBuilder_.addAllMessages(other.detectedLanguages_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getLayoutFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                                .parser(),
                            extensionRegistry);
                    if (detectedLanguagesBuilder_ == null) {
                      ensureDetectedLanguagesIsMutable();
                      detectedLanguages_.add(m);
                    } else {
                      detectedLanguagesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.documentai.v1beta1.Document.Page.Layout layout_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>
            layoutBuilder_;
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Block][google.cloud.documentai.v1beta1.Document.Page.Block].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         *
         * @return Whether the layout field is set.
         */
        public boolean hasLayout() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Block][google.cloud.documentai.v1beta1.Document.Page.Block].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         *
         * @return The layout.
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout() {
          if (layoutBuilder_ == null) {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
                : layout_;
          } else {
            return layoutBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Block][google.cloud.documentai.v1beta1.Document.Page.Block].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(com.google.cloud.documentai.v1beta1.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            layout_ = value;
          } else {
            layoutBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Block][google.cloud.documentai.v1beta1.Document.Page.Block].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(
            com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder builderForValue) {
          if (layoutBuilder_ == null) {
            layout_ = builderForValue.build();
          } else {
            layoutBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Block][google.cloud.documentai.v1beta1.Document.Page.Block].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder mergeLayout(com.google.cloud.documentai.v1beta1.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && layout_ != null
                && layout_
                    != com.google.cloud.documentai.v1beta1.Document.Page.Layout
                        .getDefaultInstance()) {
              getLayoutBuilder().mergeFrom(value);
            } else {
              layout_ = value;
            }
          } else {
            layoutBuilder_.mergeFrom(value);
          }
          if (layout_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Block][google.cloud.documentai.v1beta1.Document.Page.Block].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder clearLayout() {
          bitField0_ = (bitField0_ & ~0x00000001);
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Block][google.cloud.documentai.v1beta1.Document.Page.Block].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder getLayoutBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getLayoutFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Block][google.cloud.documentai.v1beta1.Document.Page.Block].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder
            getLayoutOrBuilder() {
          if (layoutBuilder_ != null) {
            return layoutBuilder_.getMessageOrBuilder();
          } else {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
                : layout_;
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Block][google.cloud.documentai.v1beta1.Document.Page.Block].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>
            getLayoutFieldBuilder() {
          if (layoutBuilder_ == null) {
            layoutBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                    com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                    com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>(
                    getLayout(), getParentForChildren(), isClean());
            layout_ = null;
          }
          return layoutBuilder_;
        }

        private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
            detectedLanguages_ = java.util.Collections.emptyList();

        private void ensureDetectedLanguagesIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            detectedLanguages_ =
                new java.util.ArrayList<
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>(
                    detectedLanguages_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            detectedLanguagesBuilder_;

        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
            getDetectedLanguagesList() {
          if (detectedLanguagesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          } else {
            return detectedLanguagesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public int getDetectedLanguagesCount() {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.size();
          } else {
            return detectedLanguagesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
            getDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addAllDetectedLanguages(
            java.lang.Iterable<
                    ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
                values) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, detectedLanguages_);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder clearDetectedLanguages() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            detectedLanguagesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder removeDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.remove(index);
            onChanged();
          } else {
            detectedLanguagesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            getDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
            getDetectedLanguagesOrBuilder(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesOrBuilderList() {
          if (detectedLanguagesBuilder_ != null) {
            return detectedLanguagesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder() {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder>
            getDetectedLanguagesBuilderList() {
          return getDetectedLanguagesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesFieldBuilder() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguagesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>(
                    detectedLanguages_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            detectedLanguages_ = null;
          }
          return detectedLanguagesBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta1.Document.Page.Block)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta1.Document.Page.Block)
      private static final com.google.cloud.documentai.v1beta1.Document.Page.Block DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta1.Document.Page.Block();
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Block getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Block> PARSER =
          new com.google.protobuf.AbstractParser<Block>() {
            @java.lang.Override
            public Block parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Block> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Block> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Block getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ParagraphOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta1.Document.Page.Paragraph)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Paragraph][google.cloud.documentai.v1beta1.Document.Page.Paragraph].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      boolean hasLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Paragraph][google.cloud.documentai.v1beta1.Document.Page.Paragraph].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Paragraph][google.cloud.documentai.v1beta1.Document.Page.Paragraph].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder getLayoutOrBuilder();

      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          getDetectedLanguagesList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage getDetectedLanguages(
          int index);
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      int getDetectedLanguagesCount();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * A collection of lines that a human would perceive as a paragraph.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.Paragraph}
     */
    public static final class Paragraph extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta1.Document.Page.Paragraph)
        ParagraphOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Paragraph.newBuilder() to construct.
      private Paragraph(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Paragraph() {
        detectedLanguages_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Paragraph();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_Paragraph_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_Paragraph_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta1.Document.Page.Paragraph.class,
                com.google.cloud.documentai.v1beta1.Document.Page.Paragraph.Builder.class);
      }

      private int bitField0_;
      public static final int LAYOUT_FIELD_NUMBER = 1;
      private com.google.cloud.documentai.v1beta1.Document.Page.Layout layout_;
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Paragraph][google.cloud.documentai.v1beta1.Document.Page.Paragraph].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      @java.lang.Override
      public boolean hasLayout() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Paragraph][google.cloud.documentai.v1beta1.Document.Page.Paragraph].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Paragraph][google.cloud.documentai.v1beta1.Document.Page.Paragraph].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder
          getLayoutOrBuilder() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }

      public static final int DETECTED_LANGUAGES_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          detectedLanguages_;
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          getDetectedLanguagesList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public int getDetectedLanguagesCount() {
        return detectedLanguages_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
          getDetectedLanguages(int index) {
        return detectedLanguages_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index) {
        return detectedLanguages_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getLayout());
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          output.writeMessage(2, detectedLanguages_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLayout());
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, detectedLanguages_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta1.Document.Page.Paragraph)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta1.Document.Page.Paragraph other =
            (com.google.cloud.documentai.v1beta1.Document.Page.Paragraph) obj;

        if (hasLayout() != other.hasLayout()) return false;
        if (hasLayout()) {
          if (!getLayout().equals(other.getLayout())) return false;
        }
        if (!getDetectedLanguagesList().equals(other.getDetectedLanguagesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasLayout()) {
          hash = (37 * hash) + LAYOUT_FIELD_NUMBER;
          hash = (53 * hash) + getLayout().hashCode();
        }
        if (getDetectedLanguagesCount() > 0) {
          hash = (37 * hash) + DETECTED_LANGUAGES_FIELD_NUMBER;
          hash = (53 * hash) + getDetectedLanguagesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Paragraph parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Paragraph parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Paragraph parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Paragraph parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Paragraph parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Paragraph parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Paragraph parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Paragraph parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Paragraph parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Paragraph parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Paragraph parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Paragraph parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta1.Document.Page.Paragraph prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A collection of lines that a human would perceive as a paragraph.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.Paragraph}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta1.Document.Page.Paragraph)
          com.google.cloud.documentai.v1beta1.Document.Page.ParagraphOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Paragraph_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Paragraph_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta1.Document.Page.Paragraph.class,
                  com.google.cloud.documentai.v1beta1.Document.Page.Paragraph.Builder.class);
        }

        // Construct using com.google.cloud.documentai.v1beta1.Document.Page.Paragraph.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getLayoutFieldBuilder();
            getDetectedLanguagesFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
          } else {
            detectedLanguages_ = null;
            detectedLanguagesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Paragraph_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Paragraph
            getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta1.Document.Page.Paragraph.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Paragraph build() {
          com.google.cloud.documentai.v1beta1.Document.Page.Paragraph result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Paragraph buildPartial() {
          com.google.cloud.documentai.v1beta1.Document.Page.Paragraph result =
              new com.google.cloud.documentai.v1beta1.Document.Page.Paragraph(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.documentai.v1beta1.Document.Page.Paragraph result) {
          if (detectedLanguagesBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              detectedLanguages_ = java.util.Collections.unmodifiableList(detectedLanguages_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.detectedLanguages_ = detectedLanguages_;
          } else {
            result.detectedLanguages_ = detectedLanguagesBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.documentai.v1beta1.Document.Page.Paragraph result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.layout_ = layoutBuilder_ == null ? layout_ : layoutBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta1.Document.Page.Paragraph) {
            return mergeFrom((com.google.cloud.documentai.v1beta1.Document.Page.Paragraph) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.documentai.v1beta1.Document.Page.Paragraph other) {
          if (other
              == com.google.cloud.documentai.v1beta1.Document.Page.Paragraph.getDefaultInstance())
            return this;
          if (other.hasLayout()) {
            mergeLayout(other.getLayout());
          }
          if (detectedLanguagesBuilder_ == null) {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguages_.isEmpty()) {
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureDetectedLanguagesIsMutable();
                detectedLanguages_.addAll(other.detectedLanguages_);
              }
              onChanged();
            }
          } else {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguagesBuilder_.isEmpty()) {
                detectedLanguagesBuilder_.dispose();
                detectedLanguagesBuilder_ = null;
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000002);
                detectedLanguagesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDetectedLanguagesFieldBuilder()
                        : null;
              } else {
                detectedLanguagesBuilder_.addAllMessages(other.detectedLanguages_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getLayoutFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                                .parser(),
                            extensionRegistry);
                    if (detectedLanguagesBuilder_ == null) {
                      ensureDetectedLanguagesIsMutable();
                      detectedLanguages_.add(m);
                    } else {
                      detectedLanguagesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.documentai.v1beta1.Document.Page.Layout layout_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>
            layoutBuilder_;
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Paragraph][google.cloud.documentai.v1beta1.Document.Page.Paragraph].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         *
         * @return Whether the layout field is set.
         */
        public boolean hasLayout() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Paragraph][google.cloud.documentai.v1beta1.Document.Page.Paragraph].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         *
         * @return The layout.
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout() {
          if (layoutBuilder_ == null) {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
                : layout_;
          } else {
            return layoutBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Paragraph][google.cloud.documentai.v1beta1.Document.Page.Paragraph].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(com.google.cloud.documentai.v1beta1.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            layout_ = value;
          } else {
            layoutBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Paragraph][google.cloud.documentai.v1beta1.Document.Page.Paragraph].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(
            com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder builderForValue) {
          if (layoutBuilder_ == null) {
            layout_ = builderForValue.build();
          } else {
            layoutBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Paragraph][google.cloud.documentai.v1beta1.Document.Page.Paragraph].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder mergeLayout(com.google.cloud.documentai.v1beta1.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && layout_ != null
                && layout_
                    != com.google.cloud.documentai.v1beta1.Document.Page.Layout
                        .getDefaultInstance()) {
              getLayoutBuilder().mergeFrom(value);
            } else {
              layout_ = value;
            }
          } else {
            layoutBuilder_.mergeFrom(value);
          }
          if (layout_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Paragraph][google.cloud.documentai.v1beta1.Document.Page.Paragraph].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder clearLayout() {
          bitField0_ = (bitField0_ & ~0x00000001);
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Paragraph][google.cloud.documentai.v1beta1.Document.Page.Paragraph].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder getLayoutBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getLayoutFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Paragraph][google.cloud.documentai.v1beta1.Document.Page.Paragraph].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder
            getLayoutOrBuilder() {
          if (layoutBuilder_ != null) {
            return layoutBuilder_.getMessageOrBuilder();
          } else {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
                : layout_;
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Paragraph][google.cloud.documentai.v1beta1.Document.Page.Paragraph].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>
            getLayoutFieldBuilder() {
          if (layoutBuilder_ == null) {
            layoutBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                    com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                    com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>(
                    getLayout(), getParentForChildren(), isClean());
            layout_ = null;
          }
          return layoutBuilder_;
        }

        private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
            detectedLanguages_ = java.util.Collections.emptyList();

        private void ensureDetectedLanguagesIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            detectedLanguages_ =
                new java.util.ArrayList<
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>(
                    detectedLanguages_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            detectedLanguagesBuilder_;

        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
            getDetectedLanguagesList() {
          if (detectedLanguagesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          } else {
            return detectedLanguagesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public int getDetectedLanguagesCount() {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.size();
          } else {
            return detectedLanguagesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
            getDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addAllDetectedLanguages(
            java.lang.Iterable<
                    ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
                values) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, detectedLanguages_);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder clearDetectedLanguages() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            detectedLanguagesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder removeDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.remove(index);
            onChanged();
          } else {
            detectedLanguagesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            getDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
            getDetectedLanguagesOrBuilder(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesOrBuilderList() {
          if (detectedLanguagesBuilder_ != null) {
            return detectedLanguagesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder() {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder>
            getDetectedLanguagesBuilderList() {
          return getDetectedLanguagesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesFieldBuilder() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguagesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>(
                    detectedLanguages_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            detectedLanguages_ = null;
          }
          return detectedLanguagesBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta1.Document.Page.Paragraph)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta1.Document.Page.Paragraph)
      private static final com.google.cloud.documentai.v1beta1.Document.Page.Paragraph
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta1.Document.Page.Paragraph();
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Paragraph
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Paragraph> PARSER =
          new com.google.protobuf.AbstractParser<Paragraph>() {
            @java.lang.Override
            public Paragraph parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Paragraph> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Paragraph> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Paragraph
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface LineOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta1.Document.Page.Line)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Line][google.cloud.documentai.v1beta1.Document.Page.Line].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      boolean hasLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Line][google.cloud.documentai.v1beta1.Document.Page.Line].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Line][google.cloud.documentai.v1beta1.Document.Page.Line].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder getLayoutOrBuilder();

      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          getDetectedLanguagesList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage getDetectedLanguages(
          int index);
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      int getDetectedLanguagesCount();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * A collection of tokens that a human would perceive as a line.
     * Does not cross column boundaries, can be horizontal, vertical, etc.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.Line}
     */
    public static final class Line extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta1.Document.Page.Line)
        LineOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Line.newBuilder() to construct.
      private Line(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Line() {
        detectedLanguages_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Line();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_Line_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_Line_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta1.Document.Page.Line.class,
                com.google.cloud.documentai.v1beta1.Document.Page.Line.Builder.class);
      }

      private int bitField0_;
      public static final int LAYOUT_FIELD_NUMBER = 1;
      private com.google.cloud.documentai.v1beta1.Document.Page.Layout layout_;
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Line][google.cloud.documentai.v1beta1.Document.Page.Line].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      @java.lang.Override
      public boolean hasLayout() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Line][google.cloud.documentai.v1beta1.Document.Page.Line].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Line][google.cloud.documentai.v1beta1.Document.Page.Line].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder
          getLayoutOrBuilder() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }

      public static final int DETECTED_LANGUAGES_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          detectedLanguages_;
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          getDetectedLanguagesList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public int getDetectedLanguagesCount() {
        return detectedLanguages_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
          getDetectedLanguages(int index) {
        return detectedLanguages_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index) {
        return detectedLanguages_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getLayout());
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          output.writeMessage(2, detectedLanguages_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLayout());
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, detectedLanguages_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta1.Document.Page.Line)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta1.Document.Page.Line other =
            (com.google.cloud.documentai.v1beta1.Document.Page.Line) obj;

        if (hasLayout() != other.hasLayout()) return false;
        if (hasLayout()) {
          if (!getLayout().equals(other.getLayout())) return false;
        }
        if (!getDetectedLanguagesList().equals(other.getDetectedLanguagesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasLayout()) {
          hash = (37 * hash) + LAYOUT_FIELD_NUMBER;
          hash = (53 * hash) + getLayout().hashCode();
        }
        if (getDetectedLanguagesCount() > 0) {
          hash = (37 * hash) + DETECTED_LANGUAGES_FIELD_NUMBER;
          hash = (53 * hash) + getDetectedLanguagesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Line parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Line parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Line parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Line parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Line parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Line parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Line parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Line parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Line parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Line parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Line parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Line parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta1.Document.Page.Line prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A collection of tokens that a human would perceive as a line.
       * Does not cross column boundaries, can be horizontal, vertical, etc.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.Line}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta1.Document.Page.Line)
          com.google.cloud.documentai.v1beta1.Document.Page.LineOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Line_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Line_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta1.Document.Page.Line.class,
                  com.google.cloud.documentai.v1beta1.Document.Page.Line.Builder.class);
        }

        // Construct using com.google.cloud.documentai.v1beta1.Document.Page.Line.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getLayoutFieldBuilder();
            getDetectedLanguagesFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
          } else {
            detectedLanguages_ = null;
            detectedLanguagesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Line_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Line getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta1.Document.Page.Line.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Line build() {
          com.google.cloud.documentai.v1beta1.Document.Page.Line result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Line buildPartial() {
          com.google.cloud.documentai.v1beta1.Document.Page.Line result =
              new com.google.cloud.documentai.v1beta1.Document.Page.Line(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.documentai.v1beta1.Document.Page.Line result) {
          if (detectedLanguagesBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              detectedLanguages_ = java.util.Collections.unmodifiableList(detectedLanguages_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.detectedLanguages_ = detectedLanguages_;
          } else {
            result.detectedLanguages_ = detectedLanguagesBuilder_.build();
          }
        }

        private void buildPartial0(com.google.cloud.documentai.v1beta1.Document.Page.Line result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.layout_ = layoutBuilder_ == null ? layout_ : layoutBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta1.Document.Page.Line) {
            return mergeFrom((com.google.cloud.documentai.v1beta1.Document.Page.Line) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.documentai.v1beta1.Document.Page.Line other) {
          if (other == com.google.cloud.documentai.v1beta1.Document.Page.Line.getDefaultInstance())
            return this;
          if (other.hasLayout()) {
            mergeLayout(other.getLayout());
          }
          if (detectedLanguagesBuilder_ == null) {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguages_.isEmpty()) {
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureDetectedLanguagesIsMutable();
                detectedLanguages_.addAll(other.detectedLanguages_);
              }
              onChanged();
            }
          } else {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguagesBuilder_.isEmpty()) {
                detectedLanguagesBuilder_.dispose();
                detectedLanguagesBuilder_ = null;
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000002);
                detectedLanguagesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDetectedLanguagesFieldBuilder()
                        : null;
              } else {
                detectedLanguagesBuilder_.addAllMessages(other.detectedLanguages_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getLayoutFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                                .parser(),
                            extensionRegistry);
                    if (detectedLanguagesBuilder_ == null) {
                      ensureDetectedLanguagesIsMutable();
                      detectedLanguages_.add(m);
                    } else {
                      detectedLanguagesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.documentai.v1beta1.Document.Page.Layout layout_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>
            layoutBuilder_;
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Line][google.cloud.documentai.v1beta1.Document.Page.Line].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         *
         * @return Whether the layout field is set.
         */
        public boolean hasLayout() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Line][google.cloud.documentai.v1beta1.Document.Page.Line].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         *
         * @return The layout.
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout() {
          if (layoutBuilder_ == null) {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
                : layout_;
          } else {
            return layoutBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Line][google.cloud.documentai.v1beta1.Document.Page.Line].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(com.google.cloud.documentai.v1beta1.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            layout_ = value;
          } else {
            layoutBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Line][google.cloud.documentai.v1beta1.Document.Page.Line].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(
            com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder builderForValue) {
          if (layoutBuilder_ == null) {
            layout_ = builderForValue.build();
          } else {
            layoutBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Line][google.cloud.documentai.v1beta1.Document.Page.Line].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder mergeLayout(com.google.cloud.documentai.v1beta1.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && layout_ != null
                && layout_
                    != com.google.cloud.documentai.v1beta1.Document.Page.Layout
                        .getDefaultInstance()) {
              getLayoutBuilder().mergeFrom(value);
            } else {
              layout_ = value;
            }
          } else {
            layoutBuilder_.mergeFrom(value);
          }
          if (layout_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Line][google.cloud.documentai.v1beta1.Document.Page.Line].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder clearLayout() {
          bitField0_ = (bitField0_ & ~0x00000001);
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Line][google.cloud.documentai.v1beta1.Document.Page.Line].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder getLayoutBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getLayoutFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Line][google.cloud.documentai.v1beta1.Document.Page.Line].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder
            getLayoutOrBuilder() {
          if (layoutBuilder_ != null) {
            return layoutBuilder_.getMessageOrBuilder();
          } else {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
                : layout_;
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Line][google.cloud.documentai.v1beta1.Document.Page.Line].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>
            getLayoutFieldBuilder() {
          if (layoutBuilder_ == null) {
            layoutBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                    com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                    com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>(
                    getLayout(), getParentForChildren(), isClean());
            layout_ = null;
          }
          return layoutBuilder_;
        }

        private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
            detectedLanguages_ = java.util.Collections.emptyList();

        private void ensureDetectedLanguagesIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            detectedLanguages_ =
                new java.util.ArrayList<
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>(
                    detectedLanguages_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            detectedLanguagesBuilder_;

        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
            getDetectedLanguagesList() {
          if (detectedLanguagesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          } else {
            return detectedLanguagesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public int getDetectedLanguagesCount() {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.size();
          } else {
            return detectedLanguagesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
            getDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addAllDetectedLanguages(
            java.lang.Iterable<
                    ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
                values) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, detectedLanguages_);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder clearDetectedLanguages() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            detectedLanguagesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder removeDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.remove(index);
            onChanged();
          } else {
            detectedLanguagesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            getDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
            getDetectedLanguagesOrBuilder(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesOrBuilderList() {
          if (detectedLanguagesBuilder_ != null) {
            return detectedLanguagesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder() {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder>
            getDetectedLanguagesBuilderList() {
          return getDetectedLanguagesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesFieldBuilder() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguagesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>(
                    detectedLanguages_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            detectedLanguages_ = null;
          }
          return detectedLanguagesBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta1.Document.Page.Line)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta1.Document.Page.Line)
      private static final com.google.cloud.documentai.v1beta1.Document.Page.Line DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta1.Document.Page.Line();
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Line getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Line> PARSER =
          new com.google.protobuf.AbstractParser<Line>() {
            @java.lang.Override
            public Line parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Line> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Line> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Line getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface TokenOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta1.Document.Page.Token)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      boolean hasLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder getLayoutOrBuilder();

      /**
       *
       *
       * <pre>
       * Detected break at the end of a
       * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak detected_break = 2;
       * </code>
       *
       * @return Whether the detectedBreak field is set.
       */
      boolean hasDetectedBreak();
      /**
       *
       *
       * <pre>
       * Detected break at the end of a
       * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak detected_break = 2;
       * </code>
       *
       * @return The detectedBreak.
       */
      com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak getDetectedBreak();
      /**
       *
       *
       * <pre>
       * Detected break at the end of a
       * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak detected_break = 2;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreakOrBuilder
          getDetectedBreakOrBuilder();

      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          getDetectedLanguagesList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage getDetectedLanguages(
          int index);
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      int getDetectedLanguagesCount();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * A detected token.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.Token}
     */
    public static final class Token extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta1.Document.Page.Token)
        TokenOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Token.newBuilder() to construct.
      private Token(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Token() {
        detectedLanguages_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Token();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_Token_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_Token_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta1.Document.Page.Token.class,
                com.google.cloud.documentai.v1beta1.Document.Page.Token.Builder.class);
      }

      public interface DetectedBreakOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Detected break type.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type type = 1;
         * </code>
         *
         * @return The enum numeric value on the wire for type.
         */
        int getTypeValue();
        /**
         *
         *
         * <pre>
         * Detected break type.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type type = 1;
         * </code>
         *
         * @return The type.
         */
        com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type getType();
      }
      /**
       *
       *
       * <pre>
       * Detected break at the end of a
       * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak}
       */
      public static final class DetectedBreak extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak)
          DetectedBreakOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use DetectedBreak.newBuilder() to construct.
        private DetectedBreak(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private DetectedBreak() {
          type_ = 0;
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new DetectedBreak();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Token_DetectedBreak_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Token_DetectedBreak_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.class,
                  com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Builder
                      .class);
        }

        /**
         *
         *
         * <pre>
         * Enum to denote the type of break found.
         * </pre>
         *
         * Protobuf enum {@code
         * google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type}
         */
        public enum Type implements com.google.protobuf.ProtocolMessageEnum {
          /**
           *
           *
           * <pre>
           * Unspecified break type.
           * </pre>
           *
           * <code>TYPE_UNSPECIFIED = 0;</code>
           */
          TYPE_UNSPECIFIED(0),
          /**
           *
           *
           * <pre>
           * A single whitespace.
           * </pre>
           *
           * <code>SPACE = 1;</code>
           */
          SPACE(1),
          /**
           *
           *
           * <pre>
           * A wider whitespace.
           * </pre>
           *
           * <code>WIDE_SPACE = 2;</code>
           */
          WIDE_SPACE(2),
          /**
           *
           *
           * <pre>
           * A hyphen that indicates that a token has been split across lines.
           * </pre>
           *
           * <code>HYPHEN = 3;</code>
           */
          HYPHEN(3),
          UNRECOGNIZED(-1),
          ;

          /**
           *
           *
           * <pre>
           * Unspecified break type.
           * </pre>
           *
           * <code>TYPE_UNSPECIFIED = 0;</code>
           */
          public static final int TYPE_UNSPECIFIED_VALUE = 0;
          /**
           *
           *
           * <pre>
           * A single whitespace.
           * </pre>
           *
           * <code>SPACE = 1;</code>
           */
          public static final int SPACE_VALUE = 1;
          /**
           *
           *
           * <pre>
           * A wider whitespace.
           * </pre>
           *
           * <code>WIDE_SPACE = 2;</code>
           */
          public static final int WIDE_SPACE_VALUE = 2;
          /**
           *
           *
           * <pre>
           * A hyphen that indicates that a token has been split across lines.
           * </pre>
           *
           * <code>HYPHEN = 3;</code>
           */
          public static final int HYPHEN_VALUE = 3;

          public final int getNumber() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalArgumentException(
                  "Can't get the number of an unknown enum value.");
            }
            return value;
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static Type valueOf(int value) {
            return forNumber(value);
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           */
          public static Type forNumber(int value) {
            switch (value) {
              case 0:
                return TYPE_UNSPECIFIED;
              case 1:
                return SPACE;
              case 2:
                return WIDE_SPACE;
              case 3:
                return HYPHEN;
              default:
                return null;
            }
          }

          public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
            return internalValueMap;
          }

          private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<Type>() {
                public Type findValueByNumber(int number) {
                  return Type.forNumber(number);
                }
              };

          public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalStateException(
                  "Can't get the descriptor of an unrecognized enum value.");
            }
            return getDescriptor().getValues().get(ordinal());
          }

          public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
            return getDescriptor();
          }

          public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
            return com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
                .getDescriptor()
                .getEnumTypes()
                .get(0);
          }

          private static final Type[] VALUES = values();

          public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != getDescriptor()) {
              throw new java.lang.IllegalArgumentException(
                  "EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
              return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
          }

          private final int value;

          private Type(int value) {
            this.value = value;
          }

          // @@protoc_insertion_point(enum_scope:google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type)
        }

        public static final int TYPE_FIELD_NUMBER = 1;
        private int type_ = 0;
        /**
         *
         *
         * <pre>
         * Detected break type.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type type = 1;
         * </code>
         *
         * @return The enum numeric value on the wire for type.
         */
        @java.lang.Override
        public int getTypeValue() {
          return type_;
        }
        /**
         *
         *
         * <pre>
         * Detected break type.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type type = 1;
         * </code>
         *
         * @return The type.
         */
        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type
            getType() {
          com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type result =
              com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type.forNumber(
                  type_);
          return result == null
              ? com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type
                  .UNRECOGNIZED
              : result;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (type_
              != com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type
                  .TYPE_UNSPECIFIED
                  .getNumber()) {
            output.writeEnum(1, type_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (type_
              != com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type
                  .TYPE_UNSPECIFIED
                  .getNumber()) {
            size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak)) {
            return super.equals(obj);
          }
          com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak other =
              (com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak) obj;

          if (type_ != other.type_) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + TYPE_FIELD_NUMBER;
          hash = (53 * hash) + type_;
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Detected break at the end of a
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak)
            com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreakOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.documentai.v1beta1.DocumentProto
                .internal_static_google_cloud_documentai_v1beta1_Document_Page_Token_DetectedBreak_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.documentai.v1beta1.DocumentProto
                .internal_static_google_cloud_documentai_v1beta1_Document_Page_Token_DetectedBreak_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.class,
                    com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Builder
                        .class);
          }

          // Construct using
          // com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            type_ = 0;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.documentai.v1beta1.DocumentProto
                .internal_static_google_cloud_documentai_v1beta1_Document_Page_Token_DetectedBreak_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
              getDefaultInstanceForType() {
            return com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak build() {
            com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
              buildPartial() {
            com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak result =
                new com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.type_ = type_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak) {
              return mergeFrom(
                  (com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak other) {
            if (other
                == com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
                    .getDefaultInstance()) return this;
            if (other.type_ != 0) {
              setTypeValue(other.getTypeValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8:
                    {
                      type_ = input.readEnum();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 8
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private int type_ = 0;
          /**
           *
           *
           * <pre>
           * Detected break type.
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type type = 1;
           * </code>
           *
           * @return The enum numeric value on the wire for type.
           */
          @java.lang.Override
          public int getTypeValue() {
            return type_;
          }
          /**
           *
           *
           * <pre>
           * Detected break type.
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type type = 1;
           * </code>
           *
           * @param value The enum numeric value on the wire for type to set.
           * @return This builder for chaining.
           */
          public Builder setTypeValue(int value) {
            type_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Detected break type.
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type type = 1;
           * </code>
           *
           * @return The type.
           */
          @java.lang.Override
          public com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type
              getType() {
            com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type result =
                com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type
                    .forNumber(type_);
            return result == null
                ? com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type
                    .UNRECOGNIZED
                : result;
          }
          /**
           *
           *
           * <pre>
           * Detected break type.
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type type = 1;
           * </code>
           *
           * @param value The type to set.
           * @return This builder for chaining.
           */
          public Builder setType(
              com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type value) {
            if (value == null) {
              throw new NullPointerException();
            }
            bitField0_ |= 0x00000001;
            type_ = value.getNumber();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Detected break type.
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type type = 1;
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearType() {
            bitField0_ = (bitField0_ & ~0x00000001);
            type_ = 0;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak)
        private static final com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak();
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<DetectedBreak> PARSER =
            new com.google.protobuf.AbstractParser<DetectedBreak>() {
              @java.lang.Override
              public DetectedBreak parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<DetectedBreak> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<DetectedBreak> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int bitField0_;
      public static final int LAYOUT_FIELD_NUMBER = 1;
      private com.google.cloud.documentai.v1beta1.Document.Page.Layout layout_;
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      @java.lang.Override
      public boolean hasLayout() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder
          getLayoutOrBuilder() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }

      public static final int DETECTED_BREAK_FIELD_NUMBER = 2;
      private com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak detectedBreak_;
      /**
       *
       *
       * <pre>
       * Detected break at the end of a
       * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak detected_break = 2;
       * </code>
       *
       * @return Whether the detectedBreak field is set.
       */
      @java.lang.Override
      public boolean hasDetectedBreak() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Detected break at the end of a
       * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak detected_break = 2;
       * </code>
       *
       * @return The detectedBreak.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
          getDetectedBreak() {
        return detectedBreak_ == null
            ? com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
                .getDefaultInstance()
            : detectedBreak_;
      }
      /**
       *
       *
       * <pre>
       * Detected break at the end of a
       * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak detected_break = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreakOrBuilder
          getDetectedBreakOrBuilder() {
        return detectedBreak_ == null
            ? com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
                .getDefaultInstance()
            : detectedBreak_;
      }

      public static final int DETECTED_LANGUAGES_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          detectedLanguages_;
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          getDetectedLanguagesList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public int getDetectedLanguagesCount() {
        return detectedLanguages_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
          getDetectedLanguages(int index) {
        return detectedLanguages_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index) {
        return detectedLanguages_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getLayout());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getDetectedBreak());
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          output.writeMessage(3, detectedLanguages_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLayout());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDetectedBreak());
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  3, detectedLanguages_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta1.Document.Page.Token)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta1.Document.Page.Token other =
            (com.google.cloud.documentai.v1beta1.Document.Page.Token) obj;

        if (hasLayout() != other.hasLayout()) return false;
        if (hasLayout()) {
          if (!getLayout().equals(other.getLayout())) return false;
        }
        if (hasDetectedBreak() != other.hasDetectedBreak()) return false;
        if (hasDetectedBreak()) {
          if (!getDetectedBreak().equals(other.getDetectedBreak())) return false;
        }
        if (!getDetectedLanguagesList().equals(other.getDetectedLanguagesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasLayout()) {
          hash = (37 * hash) + LAYOUT_FIELD_NUMBER;
          hash = (53 * hash) + getLayout().hashCode();
        }
        if (hasDetectedBreak()) {
          hash = (37 * hash) + DETECTED_BREAK_FIELD_NUMBER;
          hash = (53 * hash) + getDetectedBreak().hashCode();
        }
        if (getDetectedLanguagesCount() > 0) {
          hash = (37 * hash) + DETECTED_LANGUAGES_FIELD_NUMBER;
          hash = (53 * hash) + getDetectedLanguagesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Token parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Token parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Token parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Token parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Token parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Token parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Token parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Token parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Token parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Token parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Token parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Token parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta1.Document.Page.Token prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A detected token.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.Token}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta1.Document.Page.Token)
          com.google.cloud.documentai.v1beta1.Document.Page.TokenOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Token_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Token_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta1.Document.Page.Token.class,
                  com.google.cloud.documentai.v1beta1.Document.Page.Token.Builder.class);
        }

        // Construct using com.google.cloud.documentai.v1beta1.Document.Page.Token.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getLayoutFieldBuilder();
            getDetectedBreakFieldBuilder();
            getDetectedLanguagesFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          detectedBreak_ = null;
          if (detectedBreakBuilder_ != null) {
            detectedBreakBuilder_.dispose();
            detectedBreakBuilder_ = null;
          }
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
          } else {
            detectedLanguages_ = null;
            detectedLanguagesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Token_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Token getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta1.Document.Page.Token.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Token build() {
          com.google.cloud.documentai.v1beta1.Document.Page.Token result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Token buildPartial() {
          com.google.cloud.documentai.v1beta1.Document.Page.Token result =
              new com.google.cloud.documentai.v1beta1.Document.Page.Token(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.documentai.v1beta1.Document.Page.Token result) {
          if (detectedLanguagesBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)) {
              detectedLanguages_ = java.util.Collections.unmodifiableList(detectedLanguages_);
              bitField0_ = (bitField0_ & ~0x00000004);
            }
            result.detectedLanguages_ = detectedLanguages_;
          } else {
            result.detectedLanguages_ = detectedLanguagesBuilder_.build();
          }
        }

        private void buildPartial0(com.google.cloud.documentai.v1beta1.Document.Page.Token result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.layout_ = layoutBuilder_ == null ? layout_ : layoutBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.detectedBreak_ =
                detectedBreakBuilder_ == null ? detectedBreak_ : detectedBreakBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta1.Document.Page.Token) {
            return mergeFrom((com.google.cloud.documentai.v1beta1.Document.Page.Token) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.documentai.v1beta1.Document.Page.Token other) {
          if (other == com.google.cloud.documentai.v1beta1.Document.Page.Token.getDefaultInstance())
            return this;
          if (other.hasLayout()) {
            mergeLayout(other.getLayout());
          }
          if (other.hasDetectedBreak()) {
            mergeDetectedBreak(other.getDetectedBreak());
          }
          if (detectedLanguagesBuilder_ == null) {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguages_.isEmpty()) {
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000004);
              } else {
                ensureDetectedLanguagesIsMutable();
                detectedLanguages_.addAll(other.detectedLanguages_);
              }
              onChanged();
            }
          } else {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguagesBuilder_.isEmpty()) {
                detectedLanguagesBuilder_.dispose();
                detectedLanguagesBuilder_ = null;
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000004);
                detectedLanguagesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDetectedLanguagesFieldBuilder()
                        : null;
              } else {
                detectedLanguagesBuilder_.addAllMessages(other.detectedLanguages_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getLayoutFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        getDetectedBreakFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                                .parser(),
                            extensionRegistry);
                    if (detectedLanguagesBuilder_ == null) {
                      ensureDetectedLanguagesIsMutable();
                      detectedLanguages_.add(m);
                    } else {
                      detectedLanguagesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.documentai.v1beta1.Document.Page.Layout layout_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>
            layoutBuilder_;
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         *
         * @return Whether the layout field is set.
         */
        public boolean hasLayout() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         *
         * @return The layout.
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout() {
          if (layoutBuilder_ == null) {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
                : layout_;
          } else {
            return layoutBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(com.google.cloud.documentai.v1beta1.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            layout_ = value;
          } else {
            layoutBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(
            com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder builderForValue) {
          if (layoutBuilder_ == null) {
            layout_ = builderForValue.build();
          } else {
            layoutBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder mergeLayout(com.google.cloud.documentai.v1beta1.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && layout_ != null
                && layout_
                    != com.google.cloud.documentai.v1beta1.Document.Page.Layout
                        .getDefaultInstance()) {
              getLayoutBuilder().mergeFrom(value);
            } else {
              layout_ = value;
            }
          } else {
            layoutBuilder_.mergeFrom(value);
          }
          if (layout_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder clearLayout() {
          bitField0_ = (bitField0_ & ~0x00000001);
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder getLayoutBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getLayoutFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder
            getLayoutOrBuilder() {
          if (layoutBuilder_ != null) {
            return layoutBuilder_.getMessageOrBuilder();
          } else {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
                : layout_;
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>
            getLayoutFieldBuilder() {
          if (layoutBuilder_ == null) {
            layoutBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                    com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                    com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>(
                    getLayout(), getParentForChildren(), isClean());
            layout_ = null;
          }
          return layoutBuilder_;
        }

        private com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
            detectedBreak_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak,
                com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreakOrBuilder>
            detectedBreakBuilder_;
        /**
         *
         *
         * <pre>
         * Detected break at the end of a
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak detected_break = 2;
         * </code>
         *
         * @return Whether the detectedBreak field is set.
         */
        public boolean hasDetectedBreak() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * Detected break at the end of a
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak detected_break = 2;
         * </code>
         *
         * @return The detectedBreak.
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
            getDetectedBreak() {
          if (detectedBreakBuilder_ == null) {
            return detectedBreak_ == null
                ? com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
                    .getDefaultInstance()
                : detectedBreak_;
          } else {
            return detectedBreakBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Detected break at the end of a
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak detected_break = 2;
         * </code>
         */
        public Builder setDetectedBreak(
            com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak value) {
          if (detectedBreakBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            detectedBreak_ = value;
          } else {
            detectedBreakBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Detected break at the end of a
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak detected_break = 2;
         * </code>
         */
        public Builder setDetectedBreak(
            com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Builder
                builderForValue) {
          if (detectedBreakBuilder_ == null) {
            detectedBreak_ = builderForValue.build();
          } else {
            detectedBreakBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Detected break at the end of a
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak detected_break = 2;
         * </code>
         */
        public Builder mergeDetectedBreak(
            com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak value) {
          if (detectedBreakBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && detectedBreak_ != null
                && detectedBreak_
                    != com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
                        .getDefaultInstance()) {
              getDetectedBreakBuilder().mergeFrom(value);
            } else {
              detectedBreak_ = value;
            }
          } else {
            detectedBreakBuilder_.mergeFrom(value);
          }
          if (detectedBreak_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Detected break at the end of a
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak detected_break = 2;
         * </code>
         */
        public Builder clearDetectedBreak() {
          bitField0_ = (bitField0_ & ~0x00000002);
          detectedBreak_ = null;
          if (detectedBreakBuilder_ != null) {
            detectedBreakBuilder_.dispose();
            detectedBreakBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Detected break at the end of a
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak detected_break = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Builder
            getDetectedBreakBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getDetectedBreakFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Detected break at the end of a
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak detected_break = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreakOrBuilder
            getDetectedBreakOrBuilder() {
          if (detectedBreakBuilder_ != null) {
            return detectedBreakBuilder_.getMessageOrBuilder();
          } else {
            return detectedBreak_ == null
                ? com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
                    .getDefaultInstance()
                : detectedBreak_;
          }
        }
        /**
         *
         *
         * <pre>
         * Detected break at the end of a
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak detected_break = 2;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak,
                com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreakOrBuilder>
            getDetectedBreakFieldBuilder() {
          if (detectedBreakBuilder_ == null) {
            detectedBreakBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak,
                    com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Builder,
                    com.google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreakOrBuilder>(
                    getDetectedBreak(), getParentForChildren(), isClean());
            detectedBreak_ = null;
          }
          return detectedBreakBuilder_;
        }

        private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
            detectedLanguages_ = java.util.Collections.emptyList();

        private void ensureDetectedLanguagesIsMutable() {
          if (!((bitField0_ & 0x00000004) != 0)) {
            detectedLanguages_ =
                new java.util.ArrayList<
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>(
                    detectedLanguages_);
            bitField0_ |= 0x00000004;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            detectedLanguagesBuilder_;

        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
            getDetectedLanguagesList() {
          if (detectedLanguagesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          } else {
            return detectedLanguagesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public int getDetectedLanguagesCount() {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.size();
          } else {
            return detectedLanguagesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
            getDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder addAllDetectedLanguages(
            java.lang.Iterable<
                    ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
                values) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, detectedLanguages_);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder clearDetectedLanguages() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000004);
            onChanged();
          } else {
            detectedLanguagesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder removeDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.remove(index);
            onChanged();
          } else {
            detectedLanguagesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            getDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
            getDetectedLanguagesOrBuilder(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesOrBuilderList() {
          if (detectedLanguagesBuilder_ != null) {
            return detectedLanguagesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder() {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public java.util.List<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder>
            getDetectedLanguagesBuilderList() {
          return getDetectedLanguagesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesFieldBuilder() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguagesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>(
                    detectedLanguages_,
                    ((bitField0_ & 0x00000004) != 0),
                    getParentForChildren(),
                    isClean());
            detectedLanguages_ = null;
          }
          return detectedLanguagesBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta1.Document.Page.Token)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta1.Document.Page.Token)
      private static final com.google.cloud.documentai.v1beta1.Document.Page.Token DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta1.Document.Page.Token();
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Token getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Token> PARSER =
          new com.google.protobuf.AbstractParser<Token>() {
            @java.lang.Override
            public Token parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Token> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Token> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Token getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface VisualElementOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta1.Document.Page.VisualElement)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      boolean hasLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder getLayoutOrBuilder();

      /**
       *
       *
       * <pre>
       * Type of the
       * [VisualElement][google.cloud.documentai.v1beta1.Document.Page.VisualElement].
       * </pre>
       *
       * <code>string type = 2;</code>
       *
       * @return The type.
       */
      java.lang.String getType();
      /**
       *
       *
       * <pre>
       * Type of the
       * [VisualElement][google.cloud.documentai.v1beta1.Document.Page.VisualElement].
       * </pre>
       *
       * <code>string type = 2;</code>
       *
       * @return The bytes for type.
       */
      com.google.protobuf.ByteString getTypeBytes();

      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          getDetectedLanguagesList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage getDetectedLanguages(
          int index);
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      int getDetectedLanguagesCount();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Detected non-text visual elements e.g. checkbox, signature etc. on the
     * page.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.VisualElement}
     */
    public static final class VisualElement extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta1.Document.Page.VisualElement)
        VisualElementOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use VisualElement.newBuilder() to construct.
      private VisualElement(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private VisualElement() {
        type_ = "";
        detectedLanguages_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new VisualElement();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_VisualElement_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_VisualElement_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta1.Document.Page.VisualElement.class,
                com.google.cloud.documentai.v1beta1.Document.Page.VisualElement.Builder.class);
      }

      private int bitField0_;
      public static final int LAYOUT_FIELD_NUMBER = 1;
      private com.google.cloud.documentai.v1beta1.Document.Page.Layout layout_;
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      @java.lang.Override
      public boolean hasLayout() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder
          getLayoutOrBuilder() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }

      public static final int TYPE_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object type_ = "";
      /**
       *
       *
       * <pre>
       * Type of the
       * [VisualElement][google.cloud.documentai.v1beta1.Document.Page.VisualElement].
       * </pre>
       *
       * <code>string type = 2;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          type_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of the
       * [VisualElement][google.cloud.documentai.v1beta1.Document.Page.VisualElement].
       * </pre>
       *
       * <code>string type = 2;</code>
       *
       * @return The bytes for type.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DETECTED_LANGUAGES_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          detectedLanguages_;
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          getDetectedLanguagesList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public int getDetectedLanguagesCount() {
        return detectedLanguages_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
          getDetectedLanguages(int index) {
        return detectedLanguages_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index) {
        return detectedLanguages_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getLayout());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, type_);
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          output.writeMessage(3, detectedLanguages_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLayout());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, type_);
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  3, detectedLanguages_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta1.Document.Page.VisualElement)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta1.Document.Page.VisualElement other =
            (com.google.cloud.documentai.v1beta1.Document.Page.VisualElement) obj;

        if (hasLayout() != other.hasLayout()) return false;
        if (hasLayout()) {
          if (!getLayout().equals(other.getLayout())) return false;
        }
        if (!getType().equals(other.getType())) return false;
        if (!getDetectedLanguagesList().equals(other.getDetectedLanguagesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasLayout()) {
          hash = (37 * hash) + LAYOUT_FIELD_NUMBER;
          hash = (53 * hash) + getLayout().hashCode();
        }
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getType().hashCode();
        if (getDetectedLanguagesCount() > 0) {
          hash = (37 * hash) + DETECTED_LANGUAGES_FIELD_NUMBER;
          hash = (53 * hash) + getDetectedLanguagesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.VisualElement parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.VisualElement parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.VisualElement parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.VisualElement parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.VisualElement parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.VisualElement parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.VisualElement parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.VisualElement parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.VisualElement
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.VisualElement
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.VisualElement parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.VisualElement parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta1.Document.Page.VisualElement prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Detected non-text visual elements e.g. checkbox, signature etc. on the
       * page.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.VisualElement}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta1.Document.Page.VisualElement)
          com.google.cloud.documentai.v1beta1.Document.Page.VisualElementOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_VisualElement_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_VisualElement_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta1.Document.Page.VisualElement.class,
                  com.google.cloud.documentai.v1beta1.Document.Page.VisualElement.Builder.class);
        }

        // Construct using
        // com.google.cloud.documentai.v1beta1.Document.Page.VisualElement.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getLayoutFieldBuilder();
            getDetectedLanguagesFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          type_ = "";
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
          } else {
            detectedLanguages_ = null;
            detectedLanguagesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_VisualElement_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.VisualElement
            getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta1.Document.Page.VisualElement
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.VisualElement build() {
          com.google.cloud.documentai.v1beta1.Document.Page.VisualElement result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.VisualElement buildPartial() {
          com.google.cloud.documentai.v1beta1.Document.Page.VisualElement result =
              new com.google.cloud.documentai.v1beta1.Document.Page.VisualElement(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.documentai.v1beta1.Document.Page.VisualElement result) {
          if (detectedLanguagesBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)) {
              detectedLanguages_ = java.util.Collections.unmodifiableList(detectedLanguages_);
              bitField0_ = (bitField0_ & ~0x00000004);
            }
            result.detectedLanguages_ = detectedLanguages_;
          } else {
            result.detectedLanguages_ = detectedLanguagesBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.documentai.v1beta1.Document.Page.VisualElement result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.layout_ = layoutBuilder_ == null ? layout_ : layoutBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.type_ = type_;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta1.Document.Page.VisualElement) {
            return mergeFrom(
                (com.google.cloud.documentai.v1beta1.Document.Page.VisualElement) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.documentai.v1beta1.Document.Page.VisualElement other) {
          if (other
              == com.google.cloud.documentai.v1beta1.Document.Page.VisualElement
                  .getDefaultInstance()) return this;
          if (other.hasLayout()) {
            mergeLayout(other.getLayout());
          }
          if (!other.getType().isEmpty()) {
            type_ = other.type_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (detectedLanguagesBuilder_ == null) {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguages_.isEmpty()) {
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000004);
              } else {
                ensureDetectedLanguagesIsMutable();
                detectedLanguages_.addAll(other.detectedLanguages_);
              }
              onChanged();
            }
          } else {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguagesBuilder_.isEmpty()) {
                detectedLanguagesBuilder_.dispose();
                detectedLanguagesBuilder_ = null;
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000004);
                detectedLanguagesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDetectedLanguagesFieldBuilder()
                        : null;
              } else {
                detectedLanguagesBuilder_.addAllMessages(other.detectedLanguages_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getLayoutFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    type_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                                .parser(),
                            extensionRegistry);
                    if (detectedLanguagesBuilder_ == null) {
                      ensureDetectedLanguagesIsMutable();
                      detectedLanguages_.add(m);
                    } else {
                      detectedLanguagesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.documentai.v1beta1.Document.Page.Layout layout_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>
            layoutBuilder_;
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         *
         * @return Whether the layout field is set.
         */
        public boolean hasLayout() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         *
         * @return The layout.
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout() {
          if (layoutBuilder_ == null) {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
                : layout_;
          } else {
            return layoutBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(com.google.cloud.documentai.v1beta1.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            layout_ = value;
          } else {
            layoutBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(
            com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder builderForValue) {
          if (layoutBuilder_ == null) {
            layout_ = builderForValue.build();
          } else {
            layoutBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder mergeLayout(com.google.cloud.documentai.v1beta1.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && layout_ != null
                && layout_
                    != com.google.cloud.documentai.v1beta1.Document.Page.Layout
                        .getDefaultInstance()) {
              getLayoutBuilder().mergeFrom(value);
            } else {
              layout_ = value;
            }
          } else {
            layoutBuilder_.mergeFrom(value);
          }
          if (layout_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder clearLayout() {
          bitField0_ = (bitField0_ & ~0x00000001);
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder getLayoutBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getLayoutFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder
            getLayoutOrBuilder() {
          if (layoutBuilder_ != null) {
            return layoutBuilder_.getMessageOrBuilder();
          } else {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
                : layout_;
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>
            getLayoutFieldBuilder() {
          if (layoutBuilder_ == null) {
            layoutBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                    com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                    com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>(
                    getLayout(), getParentForChildren(), isClean());
            layout_ = null;
          }
          return layoutBuilder_;
        }

        private java.lang.Object type_ = "";
        /**
         *
         *
         * <pre>
         * Type of the
         * [VisualElement][google.cloud.documentai.v1beta1.Document.Page.VisualElement].
         * </pre>
         *
         * <code>string type = 2;</code>
         *
         * @return The type.
         */
        public java.lang.String getType() {
          java.lang.Object ref = type_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            type_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Type of the
         * [VisualElement][google.cloud.documentai.v1beta1.Document.Page.VisualElement].
         * </pre>
         *
         * <code>string type = 2;</code>
         *
         * @return The bytes for type.
         */
        public com.google.protobuf.ByteString getTypeBytes() {
          java.lang.Object ref = type_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            type_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Type of the
         * [VisualElement][google.cloud.documentai.v1beta1.Document.Page.VisualElement].
         * </pre>
         *
         * <code>string type = 2;</code>
         *
         * @param value The type to set.
         * @return This builder for chaining.
         */
        public Builder setType(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          type_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Type of the
         * [VisualElement][google.cloud.documentai.v1beta1.Document.Page.VisualElement].
         * </pre>
         *
         * <code>string type = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearType() {
          type_ = getDefaultInstance().getType();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Type of the
         * [VisualElement][google.cloud.documentai.v1beta1.Document.Page.VisualElement].
         * </pre>
         *
         * <code>string type = 2;</code>
         *
         * @param value The bytes for type to set.
         * @return This builder for chaining.
         */
        public Builder setTypeBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          type_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
            detectedLanguages_ = java.util.Collections.emptyList();

        private void ensureDetectedLanguagesIsMutable() {
          if (!((bitField0_ & 0x00000004) != 0)) {
            detectedLanguages_ =
                new java.util.ArrayList<
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>(
                    detectedLanguages_);
            bitField0_ |= 0x00000004;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            detectedLanguagesBuilder_;

        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
            getDetectedLanguagesList() {
          if (detectedLanguagesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          } else {
            return detectedLanguagesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public int getDetectedLanguagesCount() {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.size();
          } else {
            return detectedLanguagesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
            getDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder addAllDetectedLanguages(
            java.lang.Iterable<
                    ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
                values) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, detectedLanguages_);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder clearDetectedLanguages() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000004);
            onChanged();
          } else {
            detectedLanguagesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder removeDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.remove(index);
            onChanged();
          } else {
            detectedLanguagesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            getDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
            getDetectedLanguagesOrBuilder(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesOrBuilderList() {
          if (detectedLanguagesBuilder_ != null) {
            return detectedLanguagesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder() {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public java.util.List<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder>
            getDetectedLanguagesBuilderList() {
          return getDetectedLanguagesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesFieldBuilder() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguagesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>(
                    detectedLanguages_,
                    ((bitField0_ & 0x00000004) != 0),
                    getParentForChildren(),
                    isClean());
            detectedLanguages_ = null;
          }
          return detectedLanguagesBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta1.Document.Page.VisualElement)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta1.Document.Page.VisualElement)
      private static final com.google.cloud.documentai.v1beta1.Document.Page.VisualElement
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta1.Document.Page.VisualElement();
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.VisualElement
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<VisualElement> PARSER =
          new com.google.protobuf.AbstractParser<VisualElement>() {
            @java.lang.Override
            public VisualElement parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<VisualElement> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<VisualElement> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.VisualElement
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface TableOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta1.Document.Page.Table)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Table][google.cloud.documentai.v1beta1.Document.Page.Table].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      boolean hasLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Table][google.cloud.documentai.v1beta1.Document.Page.Table].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Table][google.cloud.documentai.v1beta1.Document.Page.Table].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder getLayoutOrBuilder();

      /**
       *
       *
       * <pre>
       * Header rows of the table.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
       * </code>
       */
      java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow>
          getHeaderRowsList();
      /**
       *
       *
       * <pre>
       * Header rows of the table.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow getHeaderRows(int index);
      /**
       *
       *
       * <pre>
       * Header rows of the table.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
       * </code>
       */
      int getHeaderRowsCount();
      /**
       *
       *
       * <pre>
       * Header rows of the table.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRowOrBuilder>
          getHeaderRowsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Header rows of the table.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRowOrBuilder
          getHeaderRowsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * Body rows of the table.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
       * </code>
       */
      java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow>
          getBodyRowsList();
      /**
       *
       *
       * <pre>
       * Body rows of the table.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow getBodyRows(int index);
      /**
       *
       *
       * <pre>
       * Body rows of the table.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
       * </code>
       */
      int getBodyRowsCount();
      /**
       *
       *
       * <pre>
       * Body rows of the table.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRowOrBuilder>
          getBodyRowsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Body rows of the table.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRowOrBuilder
          getBodyRowsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          getDetectedLanguagesList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage getDetectedLanguages(
          int index);
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      int getDetectedLanguagesCount();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * A table representation similar to HTML table structure.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.Table}
     */
    public static final class Table extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta1.Document.Page.Table)
        TableOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Table.newBuilder() to construct.
      private Table(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Table() {
        headerRows_ = java.util.Collections.emptyList();
        bodyRows_ = java.util.Collections.emptyList();
        detectedLanguages_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Table();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_Table_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_Table_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta1.Document.Page.Table.class,
                com.google.cloud.documentai.v1beta1.Document.Page.Table.Builder.class);
      }

      public interface TableRowOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta1.Document.Page.Table.TableRow)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Cells that make up this row.
         * </pre>
         *
         * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
         * </code>
         */
        java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell>
            getCellsList();
        /**
         *
         *
         * <pre>
         * Cells that make up this row.
         * </pre>
         *
         * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
         * </code>
         */
        com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell getCells(int index);
        /**
         *
         *
         * <pre>
         * Cells that make up this row.
         * </pre>
         *
         * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
         * </code>
         */
        int getCellsCount();
        /**
         *
         *
         * <pre>
         * Cells that make up this row.
         * </pre>
         *
         * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
         * </code>
         */
        java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCellOrBuilder>
            getCellsOrBuilderList();
        /**
         *
         *
         * <pre>
         * Cells that make up this row.
         * </pre>
         *
         * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
         * </code>
         */
        com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCellOrBuilder
            getCellsOrBuilder(int index);
      }
      /**
       *
       *
       * <pre>
       * A row of table cells.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.Table.TableRow}
       */
      public static final class TableRow extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta1.Document.Page.Table.TableRow)
          TableRowOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use TableRow.newBuilder() to construct.
        private TableRow(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private TableRow() {
          cells_ = java.util.Collections.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new TableRow();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Table_TableRow_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Table_TableRow_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.class,
                  com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder.class);
        }

        public static final int CELLS_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell>
            cells_;
        /**
         *
         *
         * <pre>
         * Cells that make up this row.
         * </pre>
         *
         * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
         * </code>
         */
        @java.lang.Override
        public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell>
            getCellsList() {
          return cells_;
        }
        /**
         *
         *
         * <pre>
         * Cells that make up this row.
         * </pre>
         *
         * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
         * </code>
         */
        @java.lang.Override
        public java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCellOrBuilder>
            getCellsOrBuilderList() {
          return cells_;
        }
        /**
         *
         *
         * <pre>
         * Cells that make up this row.
         * </pre>
         *
         * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
         * </code>
         */
        @java.lang.Override
        public int getCellsCount() {
          return cells_.size();
        }
        /**
         *
         *
         * <pre>
         * Cells that make up this row.
         * </pre>
         *
         * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell getCells(
            int index) {
          return cells_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Cells that make up this row.
         * </pre>
         *
         * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCellOrBuilder
            getCellsOrBuilder(int index) {
          return cells_.get(index);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          for (int i = 0; i < cells_.size(); i++) {
            output.writeMessage(1, cells_.get(i));
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          for (int i = 0; i < cells_.size(); i++) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, cells_.get(i));
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow)) {
            return super.equals(obj);
          }
          com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow other =
              (com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow) obj;

          if (!getCellsList().equals(other.getCellsList())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (getCellsCount() > 0) {
            hash = (37 * hash) + CELLS_FIELD_NUMBER;
            hash = (53 * hash) + getCellsList().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * A row of table cells.
         * </pre>
         *
         * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.Table.TableRow}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta1.Document.Page.Table.TableRow)
            com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRowOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.documentai.v1beta1.DocumentProto
                .internal_static_google_cloud_documentai_v1beta1_Document_Page_Table_TableRow_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.documentai.v1beta1.DocumentProto
                .internal_static_google_cloud_documentai_v1beta1_Document_Page_Table_TableRow_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.class,
                    com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder.class);
          }

          // Construct using
          // com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            if (cellsBuilder_ == null) {
              cells_ = java.util.Collections.emptyList();
            } else {
              cells_ = null;
              cellsBuilder_.clear();
            }
            bitField0_ = (bitField0_ & ~0x00000001);
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.documentai.v1beta1.DocumentProto
                .internal_static_google_cloud_documentai_v1beta1_Document_Page_Table_TableRow_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow
              getDefaultInstanceForType() {
            return com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow build() {
            com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow buildPartial() {
            com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow result =
                new com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow(this);
            buildPartialRepeatedFields(result);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartialRepeatedFields(
              com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow result) {
            if (cellsBuilder_ == null) {
              if (((bitField0_ & 0x00000001) != 0)) {
                cells_ = java.util.Collections.unmodifiableList(cells_);
                bitField0_ = (bitField0_ & ~0x00000001);
              }
              result.cells_ = cells_;
            } else {
              result.cells_ = cellsBuilder_.build();
            }
          }

          private void buildPartial0(
              com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow result) {
            int from_bitField0_ = bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow) {
              return mergeFrom(
                  (com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow other) {
            if (other
                == com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow
                    .getDefaultInstance()) return this;
            if (cellsBuilder_ == null) {
              if (!other.cells_.isEmpty()) {
                if (cells_.isEmpty()) {
                  cells_ = other.cells_;
                  bitField0_ = (bitField0_ & ~0x00000001);
                } else {
                  ensureCellsIsMutable();
                  cells_.addAll(other.cells_);
                }
                onChanged();
              }
            } else {
              if (!other.cells_.isEmpty()) {
                if (cellsBuilder_.isEmpty()) {
                  cellsBuilder_.dispose();
                  cellsBuilder_ = null;
                  cells_ = other.cells_;
                  bitField0_ = (bitField0_ & ~0x00000001);
                  cellsBuilder_ =
                      com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                          ? getCellsFieldBuilder()
                          : null;
                } else {
                  cellsBuilder_.addAllMessages(other.cells_);
                }
              }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell m =
                          input.readMessage(
                              com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell
                                  .parser(),
                              extensionRegistry);
                      if (cellsBuilder_ == null) {
                        ensureCellsIsMutable();
                        cells_.add(m);
                      } else {
                        cellsBuilder_.addMessage(m);
                      }
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell>
              cells_ = java.util.Collections.emptyList();

          private void ensureCellsIsMutable() {
            if (!((bitField0_ & 0x00000001) != 0)) {
              cells_ =
                  new java.util.ArrayList<
                      com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell>(cells_);
              bitField0_ |= 0x00000001;
            }
          }

          private com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell,
                  com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell.Builder,
                  com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCellOrBuilder>
              cellsBuilder_;

          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell>
              getCellsList() {
            if (cellsBuilder_ == null) {
              return java.util.Collections.unmodifiableList(cells_);
            } else {
              return cellsBuilder_.getMessageList();
            }
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public int getCellsCount() {
            if (cellsBuilder_ == null) {
              return cells_.size();
            } else {
              return cellsBuilder_.getCount();
            }
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell getCells(
              int index) {
            if (cellsBuilder_ == null) {
              return cells_.get(index);
            } else {
              return cellsBuilder_.getMessage(index);
            }
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public Builder setCells(
              int index, com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell value) {
            if (cellsBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureCellsIsMutable();
              cells_.set(index, value);
              onChanged();
            } else {
              cellsBuilder_.setMessage(index, value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public Builder setCells(
              int index,
              com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell.Builder
                  builderForValue) {
            if (cellsBuilder_ == null) {
              ensureCellsIsMutable();
              cells_.set(index, builderForValue.build());
              onChanged();
            } else {
              cellsBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public Builder addCells(
              com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell value) {
            if (cellsBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureCellsIsMutable();
              cells_.add(value);
              onChanged();
            } else {
              cellsBuilder_.addMessage(value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public Builder addCells(
              int index, com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell value) {
            if (cellsBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureCellsIsMutable();
              cells_.add(index, value);
              onChanged();
            } else {
              cellsBuilder_.addMessage(index, value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public Builder addCells(
              com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell.Builder
                  builderForValue) {
            if (cellsBuilder_ == null) {
              ensureCellsIsMutable();
              cells_.add(builderForValue.build());
              onChanged();
            } else {
              cellsBuilder_.addMessage(builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public Builder addCells(
              int index,
              com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell.Builder
                  builderForValue) {
            if (cellsBuilder_ == null) {
              ensureCellsIsMutable();
              cells_.add(index, builderForValue.build());
              onChanged();
            } else {
              cellsBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public Builder addAllCells(
              java.lang.Iterable<
                      ? extends com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell>
                  values) {
            if (cellsBuilder_ == null) {
              ensureCellsIsMutable();
              com.google.protobuf.AbstractMessageLite.Builder.addAll(values, cells_);
              onChanged();
            } else {
              cellsBuilder_.addAllMessages(values);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public Builder clearCells() {
            if (cellsBuilder_ == null) {
              cells_ = java.util.Collections.emptyList();
              bitField0_ = (bitField0_ & ~0x00000001);
              onChanged();
            } else {
              cellsBuilder_.clear();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public Builder removeCells(int index) {
            if (cellsBuilder_ == null) {
              ensureCellsIsMutable();
              cells_.remove(index);
              onChanged();
            } else {
              cellsBuilder_.remove(index);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell.Builder
              getCellsBuilder(int index) {
            return getCellsFieldBuilder().getBuilder(index);
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCellOrBuilder
              getCellsOrBuilder(int index) {
            if (cellsBuilder_ == null) {
              return cells_.get(index);
            } else {
              return cellsBuilder_.getMessageOrBuilder(index);
            }
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public java.util.List<
                  ? extends
                      com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCellOrBuilder>
              getCellsOrBuilderList() {
            if (cellsBuilder_ != null) {
              return cellsBuilder_.getMessageOrBuilderList();
            } else {
              return java.util.Collections.unmodifiableList(cells_);
            }
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell.Builder
              addCellsBuilder() {
            return getCellsFieldBuilder()
                .addBuilder(
                    com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell
                        .getDefaultInstance());
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell.Builder
              addCellsBuilder(int index) {
            return getCellsFieldBuilder()
                .addBuilder(
                    index,
                    com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell
                        .getDefaultInstance());
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public java.util.List<
                  com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell.Builder>
              getCellsBuilderList() {
            return getCellsFieldBuilder().getBuilderList();
          }

          private com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell,
                  com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell.Builder,
                  com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCellOrBuilder>
              getCellsFieldBuilder() {
            if (cellsBuilder_ == null) {
              cellsBuilder_ =
                  new com.google.protobuf.RepeatedFieldBuilderV3<
                      com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell,
                      com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell.Builder,
                      com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCellOrBuilder>(
                      cells_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
              cells_ = null;
            }
            return cellsBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta1.Document.Page.Table.TableRow)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta1.Document.Page.Table.TableRow)
        private static final com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow();
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<TableRow> PARSER =
            new com.google.protobuf.AbstractParser<TableRow>() {
              @java.lang.Override
              public TableRow parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<TableRow> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<TableRow> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface TableCellOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta1.Document.Page.Table.TableCell)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [TableCell][google.cloud.documentai.v1beta1.Document.Page.Table.TableCell].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         *
         * @return Whether the layout field is set.
         */
        boolean hasLayout();
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [TableCell][google.cloud.documentai.v1beta1.Document.Page.Table.TableCell].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         *
         * @return The layout.
         */
        com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout();
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [TableCell][google.cloud.documentai.v1beta1.Document.Page.Table.TableCell].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder getLayoutOrBuilder();

        /**
         *
         *
         * <pre>
         * How many rows this cell spans.
         * </pre>
         *
         * <code>int32 row_span = 2;</code>
         *
         * @return The rowSpan.
         */
        int getRowSpan();

        /**
         *
         *
         * <pre>
         * How many columns this cell spans.
         * </pre>
         *
         * <code>int32 col_span = 3;</code>
         *
         * @return The colSpan.
         */
        int getColSpan();

        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
            getDetectedLanguagesList();
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage getDetectedLanguages(
            int index);
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        int getDetectedLanguagesCount();
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesOrBuilderList();
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
            getDetectedLanguagesOrBuilder(int index);
      }
      /**
       *
       *
       * <pre>
       * A cell representation inside the table.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.Table.TableCell}
       */
      public static final class TableCell extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta1.Document.Page.Table.TableCell)
          TableCellOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use TableCell.newBuilder() to construct.
        private TableCell(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private TableCell() {
          detectedLanguages_ = java.util.Collections.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new TableCell();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Table_TableCell_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Table_TableCell_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell.class,
                  com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell.Builder.class);
        }

        private int bitField0_;
        public static final int LAYOUT_FIELD_NUMBER = 1;
        private com.google.cloud.documentai.v1beta1.Document.Page.Layout layout_;
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [TableCell][google.cloud.documentai.v1beta1.Document.Page.Table.TableCell].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         *
         * @return Whether the layout field is set.
         */
        @java.lang.Override
        public boolean hasLayout() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [TableCell][google.cloud.documentai.v1beta1.Document.Page.Table.TableCell].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         *
         * @return The layout.
         */
        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout() {
          return layout_ == null
              ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
              : layout_;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [TableCell][google.cloud.documentai.v1beta1.Document.Page.Table.TableCell].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder
            getLayoutOrBuilder() {
          return layout_ == null
              ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
              : layout_;
        }

        public static final int ROW_SPAN_FIELD_NUMBER = 2;
        private int rowSpan_ = 0;
        /**
         *
         *
         * <pre>
         * How many rows this cell spans.
         * </pre>
         *
         * <code>int32 row_span = 2;</code>
         *
         * @return The rowSpan.
         */
        @java.lang.Override
        public int getRowSpan() {
          return rowSpan_;
        }

        public static final int COL_SPAN_FIELD_NUMBER = 3;
        private int colSpan_ = 0;
        /**
         *
         *
         * <pre>
         * How many columns this cell spans.
         * </pre>
         *
         * <code>int32 col_span = 3;</code>
         *
         * @return The colSpan.
         */
        @java.lang.Override
        public int getColSpan() {
          return colSpan_;
        }

        public static final int DETECTED_LANGUAGES_FIELD_NUMBER = 4;

        @SuppressWarnings("serial")
        private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
            detectedLanguages_;
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        @java.lang.Override
        public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
            getDetectedLanguagesList() {
          return detectedLanguages_;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        @java.lang.Override
        public java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesOrBuilderList() {
          return detectedLanguages_;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        @java.lang.Override
        public int getDetectedLanguagesCount() {
          return detectedLanguages_.size();
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
            getDetectedLanguages(int index) {
          return detectedLanguages_.get(index);
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
            getDetectedLanguagesOrBuilder(int index) {
          return detectedLanguages_.get(index);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeMessage(1, getLayout());
          }
          if (rowSpan_ != 0) {
            output.writeInt32(2, rowSpan_);
          }
          if (colSpan_ != 0) {
            output.writeInt32(3, colSpan_);
          }
          for (int i = 0; i < detectedLanguages_.size(); i++) {
            output.writeMessage(4, detectedLanguages_.get(i));
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLayout());
          }
          if (rowSpan_ != 0) {
            size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, rowSpan_);
          }
          if (colSpan_ != 0) {
            size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, colSpan_);
          }
          for (int i = 0; i < detectedLanguages_.size(); i++) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    4, detectedLanguages_.get(i));
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell)) {
            return super.equals(obj);
          }
          com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell other =
              (com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell) obj;

          if (hasLayout() != other.hasLayout()) return false;
          if (hasLayout()) {
            if (!getLayout().equals(other.getLayout())) return false;
          }
          if (getRowSpan() != other.getRowSpan()) return false;
          if (getColSpan() != other.getColSpan()) return false;
          if (!getDetectedLanguagesList().equals(other.getDetectedLanguagesList())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasLayout()) {
            hash = (37 * hash) + LAYOUT_FIELD_NUMBER;
            hash = (53 * hash) + getLayout().hashCode();
          }
          hash = (37 * hash) + ROW_SPAN_FIELD_NUMBER;
          hash = (53 * hash) + getRowSpan();
          hash = (37 * hash) + COL_SPAN_FIELD_NUMBER;
          hash = (53 * hash) + getColSpan();
          if (getDetectedLanguagesCount() > 0) {
            hash = (37 * hash) + DETECTED_LANGUAGES_FIELD_NUMBER;
            hash = (53 * hash) + getDetectedLanguagesList().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * A cell representation inside the table.
         * </pre>
         *
         * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.Table.TableCell}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta1.Document.Page.Table.TableCell)
            com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCellOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.documentai.v1beta1.DocumentProto
                .internal_static_google_cloud_documentai_v1beta1_Document_Page_Table_TableCell_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.documentai.v1beta1.DocumentProto
                .internal_static_google_cloud_documentai_v1beta1_Document_Page_Table_TableCell_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell.class,
                    com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell.Builder
                        .class);
          }

          // Construct using
          // com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
              getLayoutFieldBuilder();
              getDetectedLanguagesFieldBuilder();
            }
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            layout_ = null;
            if (layoutBuilder_ != null) {
              layoutBuilder_.dispose();
              layoutBuilder_ = null;
            }
            rowSpan_ = 0;
            colSpan_ = 0;
            if (detectedLanguagesBuilder_ == null) {
              detectedLanguages_ = java.util.Collections.emptyList();
            } else {
              detectedLanguages_ = null;
              detectedLanguagesBuilder_.clear();
            }
            bitField0_ = (bitField0_ & ~0x00000008);
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.documentai.v1beta1.DocumentProto
                .internal_static_google_cloud_documentai_v1beta1_Document_Page_Table_TableCell_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell
              getDefaultInstanceForType() {
            return com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell build() {
            com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell buildPartial() {
            com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell result =
                new com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell(this);
            buildPartialRepeatedFields(result);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartialRepeatedFields(
              com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell result) {
            if (detectedLanguagesBuilder_ == null) {
              if (((bitField0_ & 0x00000008) != 0)) {
                detectedLanguages_ = java.util.Collections.unmodifiableList(detectedLanguages_);
                bitField0_ = (bitField0_ & ~0x00000008);
              }
              result.detectedLanguages_ = detectedLanguages_;
            } else {
              result.detectedLanguages_ = detectedLanguagesBuilder_.build();
            }
          }

          private void buildPartial0(
              com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell result) {
            int from_bitField0_ = bitField0_;
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.layout_ = layoutBuilder_ == null ? layout_ : layoutBuilder_.build();
              to_bitField0_ |= 0x00000001;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.rowSpan_ = rowSpan_;
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.colSpan_ = colSpan_;
            }
            result.bitField0_ |= to_bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell) {
              return mergeFrom(
                  (com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell other) {
            if (other
                == com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell
                    .getDefaultInstance()) return this;
            if (other.hasLayout()) {
              mergeLayout(other.getLayout());
            }
            if (other.getRowSpan() != 0) {
              setRowSpan(other.getRowSpan());
            }
            if (other.getColSpan() != 0) {
              setColSpan(other.getColSpan());
            }
            if (detectedLanguagesBuilder_ == null) {
              if (!other.detectedLanguages_.isEmpty()) {
                if (detectedLanguages_.isEmpty()) {
                  detectedLanguages_ = other.detectedLanguages_;
                  bitField0_ = (bitField0_ & ~0x00000008);
                } else {
                  ensureDetectedLanguagesIsMutable();
                  detectedLanguages_.addAll(other.detectedLanguages_);
                }
                onChanged();
              }
            } else {
              if (!other.detectedLanguages_.isEmpty()) {
                if (detectedLanguagesBuilder_.isEmpty()) {
                  detectedLanguagesBuilder_.dispose();
                  detectedLanguagesBuilder_ = null;
                  detectedLanguages_ = other.detectedLanguages_;
                  bitField0_ = (bitField0_ & ~0x00000008);
                  detectedLanguagesBuilder_ =
                      com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                          ? getDetectedLanguagesFieldBuilder()
                          : null;
                } else {
                  detectedLanguagesBuilder_.addAllMessages(other.detectedLanguages_);
                }
              }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      input.readMessage(getLayoutFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 16:
                    {
                      rowSpan_ = input.readInt32();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 16
                  case 24:
                    {
                      colSpan_ = input.readInt32();
                      bitField0_ |= 0x00000004;
                      break;
                    } // case 24
                  case 34:
                    {
                      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage m =
                          input.readMessage(
                              com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                                  .parser(),
                              extensionRegistry);
                      if (detectedLanguagesBuilder_ == null) {
                        ensureDetectedLanguagesIsMutable();
                        detectedLanguages_.add(m);
                      } else {
                        detectedLanguagesBuilder_.addMessage(m);
                      }
                      break;
                    } // case 34
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private com.google.cloud.documentai.v1beta1.Document.Page.Layout layout_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                  com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                  com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>
              layoutBuilder_;
          /**
           *
           *
           * <pre>
           * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
           * [TableCell][google.cloud.documentai.v1beta1.Document.Page.Table.TableCell].
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
           *
           * @return Whether the layout field is set.
           */
          public boolean hasLayout() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           *
           *
           * <pre>
           * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
           * [TableCell][google.cloud.documentai.v1beta1.Document.Page.Table.TableCell].
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
           *
           * @return The layout.
           */
          public com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout() {
            if (layoutBuilder_ == null) {
              return layout_ == null
                  ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
                  : layout_;
            } else {
              return layoutBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
           * [TableCell][google.cloud.documentai.v1beta1.Document.Page.Table.TableCell].
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
           */
          public Builder setLayout(com.google.cloud.documentai.v1beta1.Document.Page.Layout value) {
            if (layoutBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              layout_ = value;
            } else {
              layoutBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
           * [TableCell][google.cloud.documentai.v1beta1.Document.Page.Table.TableCell].
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
           */
          public Builder setLayout(
              com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder builderForValue) {
            if (layoutBuilder_ == null) {
              layout_ = builderForValue.build();
            } else {
              layoutBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
           * [TableCell][google.cloud.documentai.v1beta1.Document.Page.Table.TableCell].
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
           */
          public Builder mergeLayout(
              com.google.cloud.documentai.v1beta1.Document.Page.Layout value) {
            if (layoutBuilder_ == null) {
              if (((bitField0_ & 0x00000001) != 0)
                  && layout_ != null
                  && layout_
                      != com.google.cloud.documentai.v1beta1.Document.Page.Layout
                          .getDefaultInstance()) {
                getLayoutBuilder().mergeFrom(value);
              } else {
                layout_ = value;
              }
            } else {
              layoutBuilder_.mergeFrom(value);
            }
            if (layout_ != null) {
              bitField0_ |= 0x00000001;
              onChanged();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
           * [TableCell][google.cloud.documentai.v1beta1.Document.Page.Table.TableCell].
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
           */
          public Builder clearLayout() {
            bitField0_ = (bitField0_ & ~0x00000001);
            layout_ = null;
            if (layoutBuilder_ != null) {
              layoutBuilder_.dispose();
              layoutBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
           * [TableCell][google.cloud.documentai.v1beta1.Document.Page.Table.TableCell].
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
           */
          public com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder
              getLayoutBuilder() {
            bitField0_ |= 0x00000001;
            onChanged();
            return getLayoutFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
           * [TableCell][google.cloud.documentai.v1beta1.Document.Page.Table.TableCell].
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
           */
          public com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder
              getLayoutOrBuilder() {
            if (layoutBuilder_ != null) {
              return layoutBuilder_.getMessageOrBuilder();
            } else {
              return layout_ == null
                  ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
                  : layout_;
            }
          }
          /**
           *
           *
           * <pre>
           * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
           * [TableCell][google.cloud.documentai.v1beta1.Document.Page.Table.TableCell].
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                  com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                  com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>
              getLayoutFieldBuilder() {
            if (layoutBuilder_ == null) {
              layoutBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                      com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                      com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>(
                      getLayout(), getParentForChildren(), isClean());
              layout_ = null;
            }
            return layoutBuilder_;
          }

          private int rowSpan_;
          /**
           *
           *
           * <pre>
           * How many rows this cell spans.
           * </pre>
           *
           * <code>int32 row_span = 2;</code>
           *
           * @return The rowSpan.
           */
          @java.lang.Override
          public int getRowSpan() {
            return rowSpan_;
          }
          /**
           *
           *
           * <pre>
           * How many rows this cell spans.
           * </pre>
           *
           * <code>int32 row_span = 2;</code>
           *
           * @param value The rowSpan to set.
           * @return This builder for chaining.
           */
          public Builder setRowSpan(int value) {

            rowSpan_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * How many rows this cell spans.
           * </pre>
           *
           * <code>int32 row_span = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearRowSpan() {
            bitField0_ = (bitField0_ & ~0x00000002);
            rowSpan_ = 0;
            onChanged();
            return this;
          }

          private int colSpan_;
          /**
           *
           *
           * <pre>
           * How many columns this cell spans.
           * </pre>
           *
           * <code>int32 col_span = 3;</code>
           *
           * @return The colSpan.
           */
          @java.lang.Override
          public int getColSpan() {
            return colSpan_;
          }
          /**
           *
           *
           * <pre>
           * How many columns this cell spans.
           * </pre>
           *
           * <code>int32 col_span = 3;</code>
           *
           * @param value The colSpan to set.
           * @return This builder for chaining.
           */
          public Builder setColSpan(int value) {

            colSpan_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * How many columns this cell spans.
           * </pre>
           *
           * <code>int32 col_span = 3;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearColSpan() {
            bitField0_ = (bitField0_ & ~0x00000004);
            colSpan_ = 0;
            onChanged();
            return this;
          }

          private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
              detectedLanguages_ = java.util.Collections.emptyList();

          private void ensureDetectedLanguagesIsMutable() {
            if (!((bitField0_ & 0x00000008) != 0)) {
              detectedLanguages_ =
                  new java.util.ArrayList<
                      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>(
                      detectedLanguages_);
              bitField0_ |= 0x00000008;
            }
          }

          private com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
              detectedLanguagesBuilder_;

          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
              getDetectedLanguagesList() {
            if (detectedLanguagesBuilder_ == null) {
              return java.util.Collections.unmodifiableList(detectedLanguages_);
            } else {
              return detectedLanguagesBuilder_.getMessageList();
            }
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public int getDetectedLanguagesCount() {
            if (detectedLanguagesBuilder_ == null) {
              return detectedLanguages_.size();
            } else {
              return detectedLanguagesBuilder_.getCount();
            }
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
              getDetectedLanguages(int index) {
            if (detectedLanguagesBuilder_ == null) {
              return detectedLanguages_.get(index);
            } else {
              return detectedLanguagesBuilder_.getMessage(index);
            }
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public Builder setDetectedLanguages(
              int index, com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
            if (detectedLanguagesBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureDetectedLanguagesIsMutable();
              detectedLanguages_.set(index, value);
              onChanged();
            } else {
              detectedLanguagesBuilder_.setMessage(index, value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public Builder setDetectedLanguages(
              int index,
              com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                  builderForValue) {
            if (detectedLanguagesBuilder_ == null) {
              ensureDetectedLanguagesIsMutable();
              detectedLanguages_.set(index, builderForValue.build());
              onChanged();
            } else {
              detectedLanguagesBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public Builder addDetectedLanguages(
              com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
            if (detectedLanguagesBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureDetectedLanguagesIsMutable();
              detectedLanguages_.add(value);
              onChanged();
            } else {
              detectedLanguagesBuilder_.addMessage(value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public Builder addDetectedLanguages(
              int index, com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
            if (detectedLanguagesBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureDetectedLanguagesIsMutable();
              detectedLanguages_.add(index, value);
              onChanged();
            } else {
              detectedLanguagesBuilder_.addMessage(index, value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public Builder addDetectedLanguages(
              com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                  builderForValue) {
            if (detectedLanguagesBuilder_ == null) {
              ensureDetectedLanguagesIsMutable();
              detectedLanguages_.add(builderForValue.build());
              onChanged();
            } else {
              detectedLanguagesBuilder_.addMessage(builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public Builder addDetectedLanguages(
              int index,
              com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                  builderForValue) {
            if (detectedLanguagesBuilder_ == null) {
              ensureDetectedLanguagesIsMutable();
              detectedLanguages_.add(index, builderForValue.build());
              onChanged();
            } else {
              detectedLanguagesBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public Builder addAllDetectedLanguages(
              java.lang.Iterable<
                      ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
                  values) {
            if (detectedLanguagesBuilder_ == null) {
              ensureDetectedLanguagesIsMutable();
              com.google.protobuf.AbstractMessageLite.Builder.addAll(values, detectedLanguages_);
              onChanged();
            } else {
              detectedLanguagesBuilder_.addAllMessages(values);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public Builder clearDetectedLanguages() {
            if (detectedLanguagesBuilder_ == null) {
              detectedLanguages_ = java.util.Collections.emptyList();
              bitField0_ = (bitField0_ & ~0x00000008);
              onChanged();
            } else {
              detectedLanguagesBuilder_.clear();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public Builder removeDetectedLanguages(int index) {
            if (detectedLanguagesBuilder_ == null) {
              ensureDetectedLanguagesIsMutable();
              detectedLanguages_.remove(index);
              onChanged();
            } else {
              detectedLanguagesBuilder_.remove(index);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
              getDetectedLanguagesBuilder(int index) {
            return getDetectedLanguagesFieldBuilder().getBuilder(index);
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
              getDetectedLanguagesOrBuilder(int index) {
            if (detectedLanguagesBuilder_ == null) {
              return detectedLanguages_.get(index);
            } else {
              return detectedLanguagesBuilder_.getMessageOrBuilder(index);
            }
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public java.util.List<
                  ? extends
                      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
              getDetectedLanguagesOrBuilderList() {
            if (detectedLanguagesBuilder_ != null) {
              return detectedLanguagesBuilder_.getMessageOrBuilderList();
            } else {
              return java.util.Collections.unmodifiableList(detectedLanguages_);
            }
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
              addDetectedLanguagesBuilder() {
            return getDetectedLanguagesFieldBuilder()
                .addBuilder(
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                        .getDefaultInstance());
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
              addDetectedLanguagesBuilder(int index) {
            return getDetectedLanguagesFieldBuilder()
                .addBuilder(
                    index,
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                        .getDefaultInstance());
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public java.util.List<
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder>
              getDetectedLanguagesBuilderList() {
            return getDetectedLanguagesFieldBuilder().getBuilderList();
          }

          private com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
              getDetectedLanguagesFieldBuilder() {
            if (detectedLanguagesBuilder_ == null) {
              detectedLanguagesBuilder_ =
                  new com.google.protobuf.RepeatedFieldBuilderV3<
                      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>(
                      detectedLanguages_,
                      ((bitField0_ & 0x00000008) != 0),
                      getParentForChildren(),
                      isClean());
              detectedLanguages_ = null;
            }
            return detectedLanguagesBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta1.Document.Page.Table.TableCell)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta1.Document.Page.Table.TableCell)
        private static final com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell();
        }

        public static com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<TableCell> PARSER =
            new com.google.protobuf.AbstractParser<TableCell>() {
              @java.lang.Override
              public TableCell parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<TableCell> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<TableCell> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableCell
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int bitField0_;
      public static final int LAYOUT_FIELD_NUMBER = 1;
      private com.google.cloud.documentai.v1beta1.Document.Page.Layout layout_;
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Table][google.cloud.documentai.v1beta1.Document.Page.Table].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      @java.lang.Override
      public boolean hasLayout() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Table][google.cloud.documentai.v1beta1.Document.Page.Table].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
       * [Table][google.cloud.documentai.v1beta1.Document.Page.Table].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder
          getLayoutOrBuilder() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }

      public static final int HEADER_ROWS_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow>
          headerRows_;
      /**
       *
       *
       * <pre>
       * Header rows of the table.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow>
          getHeaderRowsList() {
        return headerRows_;
      }
      /**
       *
       *
       * <pre>
       * Header rows of the table.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRowOrBuilder>
          getHeaderRowsOrBuilderList() {
        return headerRows_;
      }
      /**
       *
       *
       * <pre>
       * Header rows of the table.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
       * </code>
       */
      @java.lang.Override
      public int getHeaderRowsCount() {
        return headerRows_.size();
      }
      /**
       *
       *
       * <pre>
       * Header rows of the table.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow getHeaderRows(
          int index) {
        return headerRows_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Header rows of the table.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRowOrBuilder
          getHeaderRowsOrBuilder(int index) {
        return headerRows_.get(index);
      }

      public static final int BODY_ROWS_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow>
          bodyRows_;
      /**
       *
       *
       * <pre>
       * Body rows of the table.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow>
          getBodyRowsList() {
        return bodyRows_;
      }
      /**
       *
       *
       * <pre>
       * Body rows of the table.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRowOrBuilder>
          getBodyRowsOrBuilderList() {
        return bodyRows_;
      }
      /**
       *
       *
       * <pre>
       * Body rows of the table.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
       * </code>
       */
      @java.lang.Override
      public int getBodyRowsCount() {
        return bodyRows_.size();
      }
      /**
       *
       *
       * <pre>
       * Body rows of the table.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow getBodyRows(
          int index) {
        return bodyRows_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Body rows of the table.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRowOrBuilder
          getBodyRowsOrBuilder(int index) {
        return bodyRows_.get(index);
      }

      public static final int DETECTED_LANGUAGES_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          detectedLanguages_;
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          getDetectedLanguagesList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      @java.lang.Override
      public int getDetectedLanguagesCount() {
        return detectedLanguages_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
          getDetectedLanguages(int index) {
        return detectedLanguages_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index) {
        return detectedLanguages_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getLayout());
        }
        for (int i = 0; i < headerRows_.size(); i++) {
          output.writeMessage(2, headerRows_.get(i));
        }
        for (int i = 0; i < bodyRows_.size(); i++) {
          output.writeMessage(3, bodyRows_.get(i));
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          output.writeMessage(4, detectedLanguages_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLayout());
        }
        for (int i = 0; i < headerRows_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, headerRows_.get(i));
        }
        for (int i = 0; i < bodyRows_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, bodyRows_.get(i));
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  4, detectedLanguages_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta1.Document.Page.Table)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta1.Document.Page.Table other =
            (com.google.cloud.documentai.v1beta1.Document.Page.Table) obj;

        if (hasLayout() != other.hasLayout()) return false;
        if (hasLayout()) {
          if (!getLayout().equals(other.getLayout())) return false;
        }
        if (!getHeaderRowsList().equals(other.getHeaderRowsList())) return false;
        if (!getBodyRowsList().equals(other.getBodyRowsList())) return false;
        if (!getDetectedLanguagesList().equals(other.getDetectedLanguagesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasLayout()) {
          hash = (37 * hash) + LAYOUT_FIELD_NUMBER;
          hash = (53 * hash) + getLayout().hashCode();
        }
        if (getHeaderRowsCount() > 0) {
          hash = (37 * hash) + HEADER_ROWS_FIELD_NUMBER;
          hash = (53 * hash) + getHeaderRowsList().hashCode();
        }
        if (getBodyRowsCount() > 0) {
          hash = (37 * hash) + BODY_ROWS_FIELD_NUMBER;
          hash = (53 * hash) + getBodyRowsList().hashCode();
        }
        if (getDetectedLanguagesCount() > 0) {
          hash = (37 * hash) + DETECTED_LANGUAGES_FIELD_NUMBER;
          hash = (53 * hash) + getDetectedLanguagesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Table parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Table parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Table parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Table parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Table parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Table parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Table parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Table parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Table parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Table parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Table parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Table parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta1.Document.Page.Table prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A table representation similar to HTML table structure.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.Table}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta1.Document.Page.Table)
          com.google.cloud.documentai.v1beta1.Document.Page.TableOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Table_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Table_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta1.Document.Page.Table.class,
                  com.google.cloud.documentai.v1beta1.Document.Page.Table.Builder.class);
        }

        // Construct using com.google.cloud.documentai.v1beta1.Document.Page.Table.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getLayoutFieldBuilder();
            getHeaderRowsFieldBuilder();
            getBodyRowsFieldBuilder();
            getDetectedLanguagesFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          if (headerRowsBuilder_ == null) {
            headerRows_ = java.util.Collections.emptyList();
          } else {
            headerRows_ = null;
            headerRowsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          if (bodyRowsBuilder_ == null) {
            bodyRows_ = java.util.Collections.emptyList();
          } else {
            bodyRows_ = null;
            bodyRowsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
          } else {
            detectedLanguages_ = null;
            detectedLanguagesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000008);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_Table_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Table getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta1.Document.Page.Table.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Table build() {
          com.google.cloud.documentai.v1beta1.Document.Page.Table result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.Table buildPartial() {
          com.google.cloud.documentai.v1beta1.Document.Page.Table result =
              new com.google.cloud.documentai.v1beta1.Document.Page.Table(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.documentai.v1beta1.Document.Page.Table result) {
          if (headerRowsBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              headerRows_ = java.util.Collections.unmodifiableList(headerRows_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.headerRows_ = headerRows_;
          } else {
            result.headerRows_ = headerRowsBuilder_.build();
          }
          if (bodyRowsBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)) {
              bodyRows_ = java.util.Collections.unmodifiableList(bodyRows_);
              bitField0_ = (bitField0_ & ~0x00000004);
            }
            result.bodyRows_ = bodyRows_;
          } else {
            result.bodyRows_ = bodyRowsBuilder_.build();
          }
          if (detectedLanguagesBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0)) {
              detectedLanguages_ = java.util.Collections.unmodifiableList(detectedLanguages_);
              bitField0_ = (bitField0_ & ~0x00000008);
            }
            result.detectedLanguages_ = detectedLanguages_;
          } else {
            result.detectedLanguages_ = detectedLanguagesBuilder_.build();
          }
        }

        private void buildPartial0(com.google.cloud.documentai.v1beta1.Document.Page.Table result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.layout_ = layoutBuilder_ == null ? layout_ : layoutBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta1.Document.Page.Table) {
            return mergeFrom((com.google.cloud.documentai.v1beta1.Document.Page.Table) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.documentai.v1beta1.Document.Page.Table other) {
          if (other == com.google.cloud.documentai.v1beta1.Document.Page.Table.getDefaultInstance())
            return this;
          if (other.hasLayout()) {
            mergeLayout(other.getLayout());
          }
          if (headerRowsBuilder_ == null) {
            if (!other.headerRows_.isEmpty()) {
              if (headerRows_.isEmpty()) {
                headerRows_ = other.headerRows_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureHeaderRowsIsMutable();
                headerRows_.addAll(other.headerRows_);
              }
              onChanged();
            }
          } else {
            if (!other.headerRows_.isEmpty()) {
              if (headerRowsBuilder_.isEmpty()) {
                headerRowsBuilder_.dispose();
                headerRowsBuilder_ = null;
                headerRows_ = other.headerRows_;
                bitField0_ = (bitField0_ & ~0x00000002);
                headerRowsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getHeaderRowsFieldBuilder()
                        : null;
              } else {
                headerRowsBuilder_.addAllMessages(other.headerRows_);
              }
            }
          }
          if (bodyRowsBuilder_ == null) {
            if (!other.bodyRows_.isEmpty()) {
              if (bodyRows_.isEmpty()) {
                bodyRows_ = other.bodyRows_;
                bitField0_ = (bitField0_ & ~0x00000004);
              } else {
                ensureBodyRowsIsMutable();
                bodyRows_.addAll(other.bodyRows_);
              }
              onChanged();
            }
          } else {
            if (!other.bodyRows_.isEmpty()) {
              if (bodyRowsBuilder_.isEmpty()) {
                bodyRowsBuilder_.dispose();
                bodyRowsBuilder_ = null;
                bodyRows_ = other.bodyRows_;
                bitField0_ = (bitField0_ & ~0x00000004);
                bodyRowsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getBodyRowsFieldBuilder()
                        : null;
              } else {
                bodyRowsBuilder_.addAllMessages(other.bodyRows_);
              }
            }
          }
          if (detectedLanguagesBuilder_ == null) {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguages_.isEmpty()) {
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000008);
              } else {
                ensureDetectedLanguagesIsMutable();
                detectedLanguages_.addAll(other.detectedLanguages_);
              }
              onChanged();
            }
          } else {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguagesBuilder_.isEmpty()) {
                detectedLanguagesBuilder_.dispose();
                detectedLanguagesBuilder_ = null;
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000008);
                detectedLanguagesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDetectedLanguagesFieldBuilder()
                        : null;
              } else {
                detectedLanguagesBuilder_.addAllMessages(other.detectedLanguages_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getLayoutFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow
                                .parser(),
                            extensionRegistry);
                    if (headerRowsBuilder_ == null) {
                      ensureHeaderRowsIsMutable();
                      headerRows_.add(m);
                    } else {
                      headerRowsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 18
                case 26:
                  {
                    com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow
                                .parser(),
                            extensionRegistry);
                    if (bodyRowsBuilder_ == null) {
                      ensureBodyRowsIsMutable();
                      bodyRows_.add(m);
                    } else {
                      bodyRowsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 26
                case 34:
                  {
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                                .parser(),
                            extensionRegistry);
                    if (detectedLanguagesBuilder_ == null) {
                      ensureDetectedLanguagesIsMutable();
                      detectedLanguages_.add(m);
                    } else {
                      detectedLanguagesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 34
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.documentai.v1beta1.Document.Page.Layout layout_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>
            layoutBuilder_;
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Table][google.cloud.documentai.v1beta1.Document.Page.Table].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         *
         * @return Whether the layout field is set.
         */
        public boolean hasLayout() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Table][google.cloud.documentai.v1beta1.Document.Page.Table].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         *
         * @return The layout.
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout() {
          if (layoutBuilder_ == null) {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
                : layout_;
          } else {
            return layoutBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Table][google.cloud.documentai.v1beta1.Document.Page.Table].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(com.google.cloud.documentai.v1beta1.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            layout_ = value;
          } else {
            layoutBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Table][google.cloud.documentai.v1beta1.Document.Page.Table].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(
            com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder builderForValue) {
          if (layoutBuilder_ == null) {
            layout_ = builderForValue.build();
          } else {
            layoutBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Table][google.cloud.documentai.v1beta1.Document.Page.Table].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder mergeLayout(com.google.cloud.documentai.v1beta1.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && layout_ != null
                && layout_
                    != com.google.cloud.documentai.v1beta1.Document.Page.Layout
                        .getDefaultInstance()) {
              getLayoutBuilder().mergeFrom(value);
            } else {
              layout_ = value;
            }
          } else {
            layoutBuilder_.mergeFrom(value);
          }
          if (layout_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Table][google.cloud.documentai.v1beta1.Document.Page.Table].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public Builder clearLayout() {
          bitField0_ = (bitField0_ & ~0x00000001);
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Table][google.cloud.documentai.v1beta1.Document.Page.Table].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder getLayoutBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getLayoutFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Table][google.cloud.documentai.v1beta1.Document.Page.Table].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder
            getLayoutOrBuilder() {
          if (layoutBuilder_ != null) {
            return layoutBuilder_.getMessageOrBuilder();
          } else {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
                : layout_;
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
         * [Table][google.cloud.documentai.v1beta1.Document.Page.Table].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>
            getLayoutFieldBuilder() {
          if (layoutBuilder_ == null) {
            layoutBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                    com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                    com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>(
                    getLayout(), getParentForChildren(), isClean());
            layout_ = null;
          }
          return layoutBuilder_;
        }

        private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow>
            headerRows_ = java.util.Collections.emptyList();

        private void ensureHeaderRowsIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            headerRows_ =
                new java.util.ArrayList<
                    com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow>(headerRows_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow,
                com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRowOrBuilder>
            headerRowsBuilder_;

        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow>
            getHeaderRowsList() {
          if (headerRowsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(headerRows_);
          } else {
            return headerRowsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public int getHeaderRowsCount() {
          if (headerRowsBuilder_ == null) {
            return headerRows_.size();
          } else {
            return headerRowsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow getHeaderRows(
            int index) {
          if (headerRowsBuilder_ == null) {
            return headerRows_.get(index);
          } else {
            return headerRowsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public Builder setHeaderRows(
            int index, com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow value) {
          if (headerRowsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureHeaderRowsIsMutable();
            headerRows_.set(index, value);
            onChanged();
          } else {
            headerRowsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public Builder setHeaderRows(
            int index,
            com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder
                builderForValue) {
          if (headerRowsBuilder_ == null) {
            ensureHeaderRowsIsMutable();
            headerRows_.set(index, builderForValue.build());
            onChanged();
          } else {
            headerRowsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public Builder addHeaderRows(
            com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow value) {
          if (headerRowsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureHeaderRowsIsMutable();
            headerRows_.add(value);
            onChanged();
          } else {
            headerRowsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public Builder addHeaderRows(
            int index, com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow value) {
          if (headerRowsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureHeaderRowsIsMutable();
            headerRows_.add(index, value);
            onChanged();
          } else {
            headerRowsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public Builder addHeaderRows(
            com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder
                builderForValue) {
          if (headerRowsBuilder_ == null) {
            ensureHeaderRowsIsMutable();
            headerRows_.add(builderForValue.build());
            onChanged();
          } else {
            headerRowsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public Builder addHeaderRows(
            int index,
            com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder
                builderForValue) {
          if (headerRowsBuilder_ == null) {
            ensureHeaderRowsIsMutable();
            headerRows_.add(index, builderForValue.build());
            onChanged();
          } else {
            headerRowsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public Builder addAllHeaderRows(
            java.lang.Iterable<
                    ? extends com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow>
                values) {
          if (headerRowsBuilder_ == null) {
            ensureHeaderRowsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, headerRows_);
            onChanged();
          } else {
            headerRowsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public Builder clearHeaderRows() {
          if (headerRowsBuilder_ == null) {
            headerRows_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            headerRowsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public Builder removeHeaderRows(int index) {
          if (headerRowsBuilder_ == null) {
            ensureHeaderRowsIsMutable();
            headerRows_.remove(index);
            onChanged();
          } else {
            headerRowsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder
            getHeaderRowsBuilder(int index) {
          return getHeaderRowsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRowOrBuilder
            getHeaderRowsOrBuilder(int index) {
          if (headerRowsBuilder_ == null) {
            return headerRows_.get(index);
          } else {
            return headerRowsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public java.util.List<
                ? extends com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRowOrBuilder>
            getHeaderRowsOrBuilderList() {
          if (headerRowsBuilder_ != null) {
            return headerRowsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(headerRows_);
          }
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder
            addHeaderRowsBuilder() {
          return getHeaderRowsFieldBuilder()
              .addBuilder(
                  com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder
            addHeaderRowsBuilder(int index) {
          return getHeaderRowsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public java.util.List<
                com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder>
            getHeaderRowsBuilderList() {
          return getHeaderRowsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow,
                com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRowOrBuilder>
            getHeaderRowsFieldBuilder() {
          if (headerRowsBuilder_ == null) {
            headerRowsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow,
                    com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder,
                    com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRowOrBuilder>(
                    headerRows_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            headerRows_ = null;
          }
          return headerRowsBuilder_;
        }

        private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow>
            bodyRows_ = java.util.Collections.emptyList();

        private void ensureBodyRowsIsMutable() {
          if (!((bitField0_ & 0x00000004) != 0)) {
            bodyRows_ =
                new java.util.ArrayList<
                    com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow>(bodyRows_);
            bitField0_ |= 0x00000004;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow,
                com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRowOrBuilder>
            bodyRowsBuilder_;

        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow>
            getBodyRowsList() {
          if (bodyRowsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(bodyRows_);
          } else {
            return bodyRowsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public int getBodyRowsCount() {
          if (bodyRowsBuilder_ == null) {
            return bodyRows_.size();
          } else {
            return bodyRowsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow getBodyRows(
            int index) {
          if (bodyRowsBuilder_ == null) {
            return bodyRows_.get(index);
          } else {
            return bodyRowsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public Builder setBodyRows(
            int index, com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow value) {
          if (bodyRowsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureBodyRowsIsMutable();
            bodyRows_.set(index, value);
            onChanged();
          } else {
            bodyRowsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public Builder setBodyRows(
            int index,
            com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder
                builderForValue) {
          if (bodyRowsBuilder_ == null) {
            ensureBodyRowsIsMutable();
            bodyRows_.set(index, builderForValue.build());
            onChanged();
          } else {
            bodyRowsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public Builder addBodyRows(
            com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow value) {
          if (bodyRowsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureBodyRowsIsMutable();
            bodyRows_.add(value);
            onChanged();
          } else {
            bodyRowsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public Builder addBodyRows(
            int index, com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow value) {
          if (bodyRowsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureBodyRowsIsMutable();
            bodyRows_.add(index, value);
            onChanged();
          } else {
            bodyRowsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public Builder addBodyRows(
            com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder
                builderForValue) {
          if (bodyRowsBuilder_ == null) {
            ensureBodyRowsIsMutable();
            bodyRows_.add(builderForValue.build());
            onChanged();
          } else {
            bodyRowsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public Builder addBodyRows(
            int index,
            com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder
                builderForValue) {
          if (bodyRowsBuilder_ == null) {
            ensureBodyRowsIsMutable();
            bodyRows_.add(index, builderForValue.build());
            onChanged();
          } else {
            bodyRowsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public Builder addAllBodyRows(
            java.lang.Iterable<
                    ? extends com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow>
                values) {
          if (bodyRowsBuilder_ == null) {
            ensureBodyRowsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, bodyRows_);
            onChanged();
          } else {
            bodyRowsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public Builder clearBodyRows() {
          if (bodyRowsBuilder_ == null) {
            bodyRows_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000004);
            onChanged();
          } else {
            bodyRowsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public Builder removeBodyRows(int index) {
          if (bodyRowsBuilder_ == null) {
            ensureBodyRowsIsMutable();
            bodyRows_.remove(index);
            onChanged();
          } else {
            bodyRowsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder
            getBodyRowsBuilder(int index) {
          return getBodyRowsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRowOrBuilder
            getBodyRowsOrBuilder(int index) {
          if (bodyRowsBuilder_ == null) {
            return bodyRows_.get(index);
          } else {
            return bodyRowsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public java.util.List<
                ? extends com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRowOrBuilder>
            getBodyRowsOrBuilderList() {
          if (bodyRowsBuilder_ != null) {
            return bodyRowsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(bodyRows_);
          }
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder
            addBodyRowsBuilder() {
          return getBodyRowsFieldBuilder()
              .addBuilder(
                  com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder
            addBodyRowsBuilder(int index) {
          return getBodyRowsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public java.util.List<
                com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder>
            getBodyRowsBuilderList() {
          return getBodyRowsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow,
                com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRowOrBuilder>
            getBodyRowsFieldBuilder() {
          if (bodyRowsBuilder_ == null) {
            bodyRowsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow,
                    com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.Builder,
                    com.google.cloud.documentai.v1beta1.Document.Page.Table.TableRowOrBuilder>(
                    bodyRows_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
            bodyRows_ = null;
          }
          return bodyRowsBuilder_;
        }

        private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
            detectedLanguages_ = java.util.Collections.emptyList();

        private void ensureDetectedLanguagesIsMutable() {
          if (!((bitField0_ & 0x00000008) != 0)) {
            detectedLanguages_ =
                new java.util.ArrayList<
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>(
                    detectedLanguages_);
            bitField0_ |= 0x00000008;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            detectedLanguagesBuilder_;

        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
            getDetectedLanguagesList() {
          if (detectedLanguagesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          } else {
            return detectedLanguagesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public int getDetectedLanguagesCount() {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.size();
          } else {
            return detectedLanguagesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
            getDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public Builder addAllDetectedLanguages(
            java.lang.Iterable<
                    ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
                values) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, detectedLanguages_);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public Builder clearDetectedLanguages() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000008);
            onChanged();
          } else {
            detectedLanguagesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public Builder removeDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.remove(index);
            onChanged();
          } else {
            detectedLanguagesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            getDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
            getDetectedLanguagesOrBuilder(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesOrBuilderList() {
          if (detectedLanguagesBuilder_ != null) {
            return detectedLanguagesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder() {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public java.util.List<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder>
            getDetectedLanguagesBuilderList() {
          return getDetectedLanguagesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesFieldBuilder() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguagesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>(
                    detectedLanguages_,
                    ((bitField0_ & 0x00000008) != 0),
                    getParentForChildren(),
                    isClean());
            detectedLanguages_ = null;
          }
          return detectedLanguagesBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta1.Document.Page.Table)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta1.Document.Page.Table)
      private static final com.google.cloud.documentai.v1beta1.Document.Page.Table DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta1.Document.Page.Table();
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.Table getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Table> PARSER =
          new com.google.protobuf.AbstractParser<Table>() {
            @java.lang.Override
            public Table parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Table> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Table> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Table getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface FormFieldOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta1.Document.Page.FormField)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
       * name. e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_name = 1;</code>
       *
       * @return Whether the fieldName field is set.
       */
      boolean hasFieldName();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
       * name. e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_name = 1;</code>
       *
       * @return The fieldName.
       */
      com.google.cloud.documentai.v1beta1.Document.Page.Layout getFieldName();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
       * name. e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_name = 1;</code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder getFieldNameOrBuilder();

      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
       * value.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_value = 2;</code>
       *
       * @return Whether the fieldValue field is set.
       */
      boolean hasFieldValue();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
       * value.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_value = 2;</code>
       *
       * @return The fieldValue.
       */
      com.google.cloud.documentai.v1beta1.Document.Page.Layout getFieldValue();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
       * value.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_value = 2;</code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder getFieldValueOrBuilder();

      /**
       *
       *
       * <pre>
       * A list of detected languages for name together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
       * </code>
       */
      java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          getNameDetectedLanguagesList();
      /**
       *
       *
       * <pre>
       * A list of detected languages for name together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage getNameDetectedLanguages(
          int index);
      /**
       *
       *
       * <pre>
       * A list of detected languages for name together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
       * </code>
       */
      int getNameDetectedLanguagesCount();
      /**
       *
       *
       * <pre>
       * A list of detected languages for name together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
          getNameDetectedLanguagesOrBuilderList();
      /**
       *
       *
       * <pre>
       * A list of detected languages for name together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
          getNameDetectedLanguagesOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * A list of detected languages for value together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
       * </code>
       */
      java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          getValueDetectedLanguagesList();
      /**
       *
       *
       * <pre>
       * A list of detected languages for value together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage getValueDetectedLanguages(
          int index);
      /**
       *
       *
       * <pre>
       * A list of detected languages for value together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
       * </code>
       */
      int getValueDetectedLanguagesCount();
      /**
       *
       *
       * <pre>
       * A list of detected languages for value together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
          getValueDetectedLanguagesOrBuilderList();
      /**
       *
       *
       * <pre>
       * A list of detected languages for value together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
       * </code>
       */
      com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
          getValueDetectedLanguagesOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * A form field detected on the page.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.FormField}
     */
    public static final class FormField extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta1.Document.Page.FormField)
        FormFieldOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use FormField.newBuilder() to construct.
      private FormField(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private FormField() {
        nameDetectedLanguages_ = java.util.Collections.emptyList();
        valueDetectedLanguages_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new FormField();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_FormField_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_FormField_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta1.Document.Page.FormField.class,
                com.google.cloud.documentai.v1beta1.Document.Page.FormField.Builder.class);
      }

      private int bitField0_;
      public static final int FIELD_NAME_FIELD_NUMBER = 1;
      private com.google.cloud.documentai.v1beta1.Document.Page.Layout fieldName_;
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
       * name. e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_name = 1;</code>
       *
       * @return Whether the fieldName field is set.
       */
      @java.lang.Override
      public boolean hasFieldName() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
       * name. e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_name = 1;</code>
       *
       * @return The fieldName.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Layout getFieldName() {
        return fieldName_ == null
            ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
            : fieldName_;
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
       * name. e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_name = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder
          getFieldNameOrBuilder() {
        return fieldName_ == null
            ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
            : fieldName_;
      }

      public static final int FIELD_VALUE_FIELD_NUMBER = 2;
      private com.google.cloud.documentai.v1beta1.Document.Page.Layout fieldValue_;
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
       * value.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_value = 2;</code>
       *
       * @return Whether the fieldValue field is set.
       */
      @java.lang.Override
      public boolean hasFieldValue() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
       * value.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_value = 2;</code>
       *
       * @return The fieldValue.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.Layout getFieldValue() {
        return fieldValue_ == null
            ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
            : fieldValue_;
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
       * value.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_value = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder
          getFieldValueOrBuilder() {
        return fieldValue_ == null
            ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
            : fieldValue_;
      }

      public static final int NAME_DETECTED_LANGUAGES_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          nameDetectedLanguages_;
      /**
       *
       *
       * <pre>
       * A list of detected languages for name together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          getNameDetectedLanguagesList() {
        return nameDetectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages for name together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
          getNameDetectedLanguagesOrBuilderList() {
        return nameDetectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages for name together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public int getNameDetectedLanguagesCount() {
        return nameDetectedLanguages_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages for name together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
          getNameDetectedLanguages(int index) {
        return nameDetectedLanguages_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages for name together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
          getNameDetectedLanguagesOrBuilder(int index) {
        return nameDetectedLanguages_.get(index);
      }

      public static final int VALUE_DETECTED_LANGUAGES_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          valueDetectedLanguages_;
      /**
       *
       *
       * <pre>
       * A list of detected languages for value together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          getValueDetectedLanguagesList() {
        return valueDetectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages for value together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
          getValueDetectedLanguagesOrBuilderList() {
        return valueDetectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages for value together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
       * </code>
       */
      @java.lang.Override
      public int getValueDetectedLanguagesCount() {
        return valueDetectedLanguages_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages for value together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
          getValueDetectedLanguages(int index) {
        return valueDetectedLanguages_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages for value together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
          getValueDetectedLanguagesOrBuilder(int index) {
        return valueDetectedLanguages_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getFieldName());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getFieldValue());
        }
        for (int i = 0; i < nameDetectedLanguages_.size(); i++) {
          output.writeMessage(3, nameDetectedLanguages_.get(i));
        }
        for (int i = 0; i < valueDetectedLanguages_.size(); i++) {
          output.writeMessage(4, valueDetectedLanguages_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getFieldName());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getFieldValue());
        }
        for (int i = 0; i < nameDetectedLanguages_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  3, nameDetectedLanguages_.get(i));
        }
        for (int i = 0; i < valueDetectedLanguages_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  4, valueDetectedLanguages_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta1.Document.Page.FormField)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta1.Document.Page.FormField other =
            (com.google.cloud.documentai.v1beta1.Document.Page.FormField) obj;

        if (hasFieldName() != other.hasFieldName()) return false;
        if (hasFieldName()) {
          if (!getFieldName().equals(other.getFieldName())) return false;
        }
        if (hasFieldValue() != other.hasFieldValue()) return false;
        if (hasFieldValue()) {
          if (!getFieldValue().equals(other.getFieldValue())) return false;
        }
        if (!getNameDetectedLanguagesList().equals(other.getNameDetectedLanguagesList()))
          return false;
        if (!getValueDetectedLanguagesList().equals(other.getValueDetectedLanguagesList()))
          return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasFieldName()) {
          hash = (37 * hash) + FIELD_NAME_FIELD_NUMBER;
          hash = (53 * hash) + getFieldName().hashCode();
        }
        if (hasFieldValue()) {
          hash = (37 * hash) + FIELD_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getFieldValue().hashCode();
        }
        if (getNameDetectedLanguagesCount() > 0) {
          hash = (37 * hash) + NAME_DETECTED_LANGUAGES_FIELD_NUMBER;
          hash = (53 * hash) + getNameDetectedLanguagesList().hashCode();
        }
        if (getValueDetectedLanguagesCount() > 0) {
          hash = (37 * hash) + VALUE_DETECTED_LANGUAGES_FIELD_NUMBER;
          hash = (53 * hash) + getValueDetectedLanguagesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.FormField parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.FormField parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.FormField parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.FormField parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.FormField parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.FormField parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.FormField parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.FormField parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.FormField parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.FormField parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.FormField parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.FormField parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta1.Document.Page.FormField prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A form field detected on the page.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.FormField}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta1.Document.Page.FormField)
          com.google.cloud.documentai.v1beta1.Document.Page.FormFieldOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_FormField_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_FormField_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta1.Document.Page.FormField.class,
                  com.google.cloud.documentai.v1beta1.Document.Page.FormField.Builder.class);
        }

        // Construct using com.google.cloud.documentai.v1beta1.Document.Page.FormField.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getFieldNameFieldBuilder();
            getFieldValueFieldBuilder();
            getNameDetectedLanguagesFieldBuilder();
            getValueDetectedLanguagesFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          fieldName_ = null;
          if (fieldNameBuilder_ != null) {
            fieldNameBuilder_.dispose();
            fieldNameBuilder_ = null;
          }
          fieldValue_ = null;
          if (fieldValueBuilder_ != null) {
            fieldValueBuilder_.dispose();
            fieldValueBuilder_ = null;
          }
          if (nameDetectedLanguagesBuilder_ == null) {
            nameDetectedLanguages_ = java.util.Collections.emptyList();
          } else {
            nameDetectedLanguages_ = null;
            nameDetectedLanguagesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          if (valueDetectedLanguagesBuilder_ == null) {
            valueDetectedLanguages_ = java.util.Collections.emptyList();
          } else {
            valueDetectedLanguages_ = null;
            valueDetectedLanguagesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000008);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_FormField_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.FormField
            getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta1.Document.Page.FormField.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.FormField build() {
          com.google.cloud.documentai.v1beta1.Document.Page.FormField result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.FormField buildPartial() {
          com.google.cloud.documentai.v1beta1.Document.Page.FormField result =
              new com.google.cloud.documentai.v1beta1.Document.Page.FormField(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.documentai.v1beta1.Document.Page.FormField result) {
          if (nameDetectedLanguagesBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)) {
              nameDetectedLanguages_ =
                  java.util.Collections.unmodifiableList(nameDetectedLanguages_);
              bitField0_ = (bitField0_ & ~0x00000004);
            }
            result.nameDetectedLanguages_ = nameDetectedLanguages_;
          } else {
            result.nameDetectedLanguages_ = nameDetectedLanguagesBuilder_.build();
          }
          if (valueDetectedLanguagesBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0)) {
              valueDetectedLanguages_ =
                  java.util.Collections.unmodifiableList(valueDetectedLanguages_);
              bitField0_ = (bitField0_ & ~0x00000008);
            }
            result.valueDetectedLanguages_ = valueDetectedLanguages_;
          } else {
            result.valueDetectedLanguages_ = valueDetectedLanguagesBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.documentai.v1beta1.Document.Page.FormField result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.fieldName_ = fieldNameBuilder_ == null ? fieldName_ : fieldNameBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.fieldValue_ =
                fieldValueBuilder_ == null ? fieldValue_ : fieldValueBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta1.Document.Page.FormField) {
            return mergeFrom((com.google.cloud.documentai.v1beta1.Document.Page.FormField) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.documentai.v1beta1.Document.Page.FormField other) {
          if (other
              == com.google.cloud.documentai.v1beta1.Document.Page.FormField.getDefaultInstance())
            return this;
          if (other.hasFieldName()) {
            mergeFieldName(other.getFieldName());
          }
          if (other.hasFieldValue()) {
            mergeFieldValue(other.getFieldValue());
          }
          if (nameDetectedLanguagesBuilder_ == null) {
            if (!other.nameDetectedLanguages_.isEmpty()) {
              if (nameDetectedLanguages_.isEmpty()) {
                nameDetectedLanguages_ = other.nameDetectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000004);
              } else {
                ensureNameDetectedLanguagesIsMutable();
                nameDetectedLanguages_.addAll(other.nameDetectedLanguages_);
              }
              onChanged();
            }
          } else {
            if (!other.nameDetectedLanguages_.isEmpty()) {
              if (nameDetectedLanguagesBuilder_.isEmpty()) {
                nameDetectedLanguagesBuilder_.dispose();
                nameDetectedLanguagesBuilder_ = null;
                nameDetectedLanguages_ = other.nameDetectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000004);
                nameDetectedLanguagesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getNameDetectedLanguagesFieldBuilder()
                        : null;
              } else {
                nameDetectedLanguagesBuilder_.addAllMessages(other.nameDetectedLanguages_);
              }
            }
          }
          if (valueDetectedLanguagesBuilder_ == null) {
            if (!other.valueDetectedLanguages_.isEmpty()) {
              if (valueDetectedLanguages_.isEmpty()) {
                valueDetectedLanguages_ = other.valueDetectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000008);
              } else {
                ensureValueDetectedLanguagesIsMutable();
                valueDetectedLanguages_.addAll(other.valueDetectedLanguages_);
              }
              onChanged();
            }
          } else {
            if (!other.valueDetectedLanguages_.isEmpty()) {
              if (valueDetectedLanguagesBuilder_.isEmpty()) {
                valueDetectedLanguagesBuilder_.dispose();
                valueDetectedLanguagesBuilder_ = null;
                valueDetectedLanguages_ = other.valueDetectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000008);
                valueDetectedLanguagesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getValueDetectedLanguagesFieldBuilder()
                        : null;
              } else {
                valueDetectedLanguagesBuilder_.addAllMessages(other.valueDetectedLanguages_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getFieldNameFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getFieldValueFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                                .parser(),
                            extensionRegistry);
                    if (nameDetectedLanguagesBuilder_ == null) {
                      ensureNameDetectedLanguagesIsMutable();
                      nameDetectedLanguages_.add(m);
                    } else {
                      nameDetectedLanguagesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 26
                case 34:
                  {
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                                .parser(),
                            extensionRegistry);
                    if (valueDetectedLanguagesBuilder_ == null) {
                      ensureValueDetectedLanguagesIsMutable();
                      valueDetectedLanguages_.add(m);
                    } else {
                      valueDetectedLanguagesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 34
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.documentai.v1beta1.Document.Page.Layout fieldName_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>
            fieldNameBuilder_;
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
         * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
         * name. e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_name = 1;</code>
         *
         * @return Whether the fieldName field is set.
         */
        public boolean hasFieldName() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
         * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
         * name. e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_name = 1;</code>
         *
         * @return The fieldName.
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout getFieldName() {
          if (fieldNameBuilder_ == null) {
            return fieldName_ == null
                ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
                : fieldName_;
          } else {
            return fieldNameBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
         * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
         * name. e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_name = 1;</code>
         */
        public Builder setFieldName(
            com.google.cloud.documentai.v1beta1.Document.Page.Layout value) {
          if (fieldNameBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            fieldName_ = value;
          } else {
            fieldNameBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
         * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
         * name. e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_name = 1;</code>
         */
        public Builder setFieldName(
            com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder builderForValue) {
          if (fieldNameBuilder_ == null) {
            fieldName_ = builderForValue.build();
          } else {
            fieldNameBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
         * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
         * name. e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_name = 1;</code>
         */
        public Builder mergeFieldName(
            com.google.cloud.documentai.v1beta1.Document.Page.Layout value) {
          if (fieldNameBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && fieldName_ != null
                && fieldName_
                    != com.google.cloud.documentai.v1beta1.Document.Page.Layout
                        .getDefaultInstance()) {
              getFieldNameBuilder().mergeFrom(value);
            } else {
              fieldName_ = value;
            }
          } else {
            fieldNameBuilder_.mergeFrom(value);
          }
          if (fieldName_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
         * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
         * name. e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_name = 1;</code>
         */
        public Builder clearFieldName() {
          bitField0_ = (bitField0_ & ~0x00000001);
          fieldName_ = null;
          if (fieldNameBuilder_ != null) {
            fieldNameBuilder_.dispose();
            fieldNameBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
         * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
         * name. e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_name = 1;</code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder
            getFieldNameBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getFieldNameFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
         * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
         * name. e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_name = 1;</code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder
            getFieldNameOrBuilder() {
          if (fieldNameBuilder_ != null) {
            return fieldNameBuilder_.getMessageOrBuilder();
          } else {
            return fieldName_ == null
                ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
                : fieldName_;
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
         * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
         * name. e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_name = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>
            getFieldNameFieldBuilder() {
          if (fieldNameBuilder_ == null) {
            fieldNameBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                    com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                    com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>(
                    getFieldName(), getParentForChildren(), isClean());
            fieldName_ = null;
          }
          return fieldNameBuilder_;
        }

        private com.google.cloud.documentai.v1beta1.Document.Page.Layout fieldValue_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>
            fieldValueBuilder_;
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
         * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
         * value.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_value = 2;</code>
         *
         * @return Whether the fieldValue field is set.
         */
        public boolean hasFieldValue() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
         * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
         * value.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_value = 2;</code>
         *
         * @return The fieldValue.
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout getFieldValue() {
          if (fieldValueBuilder_ == null) {
            return fieldValue_ == null
                ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
                : fieldValue_;
          } else {
            return fieldValueBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
         * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
         * value.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_value = 2;</code>
         */
        public Builder setFieldValue(
            com.google.cloud.documentai.v1beta1.Document.Page.Layout value) {
          if (fieldValueBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            fieldValue_ = value;
          } else {
            fieldValueBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
         * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
         * value.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_value = 2;</code>
         */
        public Builder setFieldValue(
            com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder builderForValue) {
          if (fieldValueBuilder_ == null) {
            fieldValue_ = builderForValue.build();
          } else {
            fieldValueBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
         * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
         * value.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_value = 2;</code>
         */
        public Builder mergeFieldValue(
            com.google.cloud.documentai.v1beta1.Document.Page.Layout value) {
          if (fieldValueBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && fieldValue_ != null
                && fieldValue_
                    != com.google.cloud.documentai.v1beta1.Document.Page.Layout
                        .getDefaultInstance()) {
              getFieldValueBuilder().mergeFrom(value);
            } else {
              fieldValue_ = value;
            }
          } else {
            fieldValueBuilder_.mergeFrom(value);
          }
          if (fieldValue_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
         * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
         * value.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_value = 2;</code>
         */
        public Builder clearFieldValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          fieldValue_ = null;
          if (fieldValueBuilder_ != null) {
            fieldValueBuilder_.dispose();
            fieldValueBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
         * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
         * value.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_value = 2;</code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder
            getFieldValueBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getFieldValueFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
         * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
         * value.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_value = 2;</code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder
            getFieldValueOrBuilder() {
          if (fieldValueBuilder_ != null) {
            return fieldValueBuilder_.getMessageOrBuilder();
          } else {
            return fieldValue_ == null
                ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
                : fieldValue_;
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
         * [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
         * value.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout field_value = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>
            getFieldValueFieldBuilder() {
          if (fieldValueBuilder_ == null) {
            fieldValueBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                    com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                    com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>(
                    getFieldValue(), getParentForChildren(), isClean());
            fieldValue_ = null;
          }
          return fieldValueBuilder_;
        }

        private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
            nameDetectedLanguages_ = java.util.Collections.emptyList();

        private void ensureNameDetectedLanguagesIsMutable() {
          if (!((bitField0_ & 0x00000004) != 0)) {
            nameDetectedLanguages_ =
                new java.util.ArrayList<
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>(
                    nameDetectedLanguages_);
            bitField0_ |= 0x00000004;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            nameDetectedLanguagesBuilder_;

        /**
         *
         *
         * <pre>
         * A list of detected languages for name together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
         * </code>
         */
        public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
            getNameDetectedLanguagesList() {
          if (nameDetectedLanguagesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(nameDetectedLanguages_);
          } else {
            return nameDetectedLanguagesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for name together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
         * </code>
         */
        public int getNameDetectedLanguagesCount() {
          if (nameDetectedLanguagesBuilder_ == null) {
            return nameDetectedLanguages_.size();
          } else {
            return nameDetectedLanguagesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for name together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
            getNameDetectedLanguages(int index) {
          if (nameDetectedLanguagesBuilder_ == null) {
            return nameDetectedLanguages_.get(index);
          } else {
            return nameDetectedLanguagesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for name together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
         * </code>
         */
        public Builder setNameDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (nameDetectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureNameDetectedLanguagesIsMutable();
            nameDetectedLanguages_.set(index, value);
            onChanged();
          } else {
            nameDetectedLanguagesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for name together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
         * </code>
         */
        public Builder setNameDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (nameDetectedLanguagesBuilder_ == null) {
            ensureNameDetectedLanguagesIsMutable();
            nameDetectedLanguages_.set(index, builderForValue.build());
            onChanged();
          } else {
            nameDetectedLanguagesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for name together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
         * </code>
         */
        public Builder addNameDetectedLanguages(
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (nameDetectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureNameDetectedLanguagesIsMutable();
            nameDetectedLanguages_.add(value);
            onChanged();
          } else {
            nameDetectedLanguagesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for name together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
         * </code>
         */
        public Builder addNameDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (nameDetectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureNameDetectedLanguagesIsMutable();
            nameDetectedLanguages_.add(index, value);
            onChanged();
          } else {
            nameDetectedLanguagesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for name together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
         * </code>
         */
        public Builder addNameDetectedLanguages(
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (nameDetectedLanguagesBuilder_ == null) {
            ensureNameDetectedLanguagesIsMutable();
            nameDetectedLanguages_.add(builderForValue.build());
            onChanged();
          } else {
            nameDetectedLanguagesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for name together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
         * </code>
         */
        public Builder addNameDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (nameDetectedLanguagesBuilder_ == null) {
            ensureNameDetectedLanguagesIsMutable();
            nameDetectedLanguages_.add(index, builderForValue.build());
            onChanged();
          } else {
            nameDetectedLanguagesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for name together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
         * </code>
         */
        public Builder addAllNameDetectedLanguages(
            java.lang.Iterable<
                    ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
                values) {
          if (nameDetectedLanguagesBuilder_ == null) {
            ensureNameDetectedLanguagesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nameDetectedLanguages_);
            onChanged();
          } else {
            nameDetectedLanguagesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for name together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
         * </code>
         */
        public Builder clearNameDetectedLanguages() {
          if (nameDetectedLanguagesBuilder_ == null) {
            nameDetectedLanguages_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000004);
            onChanged();
          } else {
            nameDetectedLanguagesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for name together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
         * </code>
         */
        public Builder removeNameDetectedLanguages(int index) {
          if (nameDetectedLanguagesBuilder_ == null) {
            ensureNameDetectedLanguagesIsMutable();
            nameDetectedLanguages_.remove(index);
            onChanged();
          } else {
            nameDetectedLanguagesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for name together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            getNameDetectedLanguagesBuilder(int index) {
          return getNameDetectedLanguagesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for name together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
            getNameDetectedLanguagesOrBuilder(int index) {
          if (nameDetectedLanguagesBuilder_ == null) {
            return nameDetectedLanguages_.get(index);
          } else {
            return nameDetectedLanguagesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for name together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            getNameDetectedLanguagesOrBuilderList() {
          if (nameDetectedLanguagesBuilder_ != null) {
            return nameDetectedLanguagesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(nameDetectedLanguages_);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for name together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            addNameDetectedLanguagesBuilder() {
          return getNameDetectedLanguagesFieldBuilder()
              .addBuilder(
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for name together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            addNameDetectedLanguagesBuilder(int index) {
          return getNameDetectedLanguagesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for name together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage name_detected_languages = 3;
         * </code>
         */
        public java.util.List<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder>
            getNameDetectedLanguagesBuilderList() {
          return getNameDetectedLanguagesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            getNameDetectedLanguagesFieldBuilder() {
          if (nameDetectedLanguagesBuilder_ == null) {
            nameDetectedLanguagesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>(
                    nameDetectedLanguages_,
                    ((bitField0_ & 0x00000004) != 0),
                    getParentForChildren(),
                    isClean());
            nameDetectedLanguages_ = null;
          }
          return nameDetectedLanguagesBuilder_;
        }

        private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
            valueDetectedLanguages_ = java.util.Collections.emptyList();

        private void ensureValueDetectedLanguagesIsMutable() {
          if (!((bitField0_ & 0x00000008) != 0)) {
            valueDetectedLanguages_ =
                new java.util.ArrayList<
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>(
                    valueDetectedLanguages_);
            bitField0_ |= 0x00000008;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            valueDetectedLanguagesBuilder_;

        /**
         *
         *
         * <pre>
         * A list of detected languages for value together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
         * </code>
         */
        public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
            getValueDetectedLanguagesList() {
          if (valueDetectedLanguagesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(valueDetectedLanguages_);
          } else {
            return valueDetectedLanguagesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for value together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
         * </code>
         */
        public int getValueDetectedLanguagesCount() {
          if (valueDetectedLanguagesBuilder_ == null) {
            return valueDetectedLanguages_.size();
          } else {
            return valueDetectedLanguagesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for value together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
            getValueDetectedLanguages(int index) {
          if (valueDetectedLanguagesBuilder_ == null) {
            return valueDetectedLanguages_.get(index);
          } else {
            return valueDetectedLanguagesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for value together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
         * </code>
         */
        public Builder setValueDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (valueDetectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureValueDetectedLanguagesIsMutable();
            valueDetectedLanguages_.set(index, value);
            onChanged();
          } else {
            valueDetectedLanguagesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for value together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
         * </code>
         */
        public Builder setValueDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (valueDetectedLanguagesBuilder_ == null) {
            ensureValueDetectedLanguagesIsMutable();
            valueDetectedLanguages_.set(index, builderForValue.build());
            onChanged();
          } else {
            valueDetectedLanguagesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for value together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
         * </code>
         */
        public Builder addValueDetectedLanguages(
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (valueDetectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureValueDetectedLanguagesIsMutable();
            valueDetectedLanguages_.add(value);
            onChanged();
          } else {
            valueDetectedLanguagesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for value together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
         * </code>
         */
        public Builder addValueDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
          if (valueDetectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureValueDetectedLanguagesIsMutable();
            valueDetectedLanguages_.add(index, value);
            onChanged();
          } else {
            valueDetectedLanguagesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for value together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
         * </code>
         */
        public Builder addValueDetectedLanguages(
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (valueDetectedLanguagesBuilder_ == null) {
            ensureValueDetectedLanguagesIsMutable();
            valueDetectedLanguages_.add(builderForValue.build());
            onChanged();
          } else {
            valueDetectedLanguagesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for value together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
         * </code>
         */
        public Builder addValueDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (valueDetectedLanguagesBuilder_ == null) {
            ensureValueDetectedLanguagesIsMutable();
            valueDetectedLanguages_.add(index, builderForValue.build());
            onChanged();
          } else {
            valueDetectedLanguagesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for value together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
         * </code>
         */
        public Builder addAllValueDetectedLanguages(
            java.lang.Iterable<
                    ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
                values) {
          if (valueDetectedLanguagesBuilder_ == null) {
            ensureValueDetectedLanguagesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, valueDetectedLanguages_);
            onChanged();
          } else {
            valueDetectedLanguagesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for value together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
         * </code>
         */
        public Builder clearValueDetectedLanguages() {
          if (valueDetectedLanguagesBuilder_ == null) {
            valueDetectedLanguages_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000008);
            onChanged();
          } else {
            valueDetectedLanguagesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for value together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
         * </code>
         */
        public Builder removeValueDetectedLanguages(int index) {
          if (valueDetectedLanguagesBuilder_ == null) {
            ensureValueDetectedLanguagesIsMutable();
            valueDetectedLanguages_.remove(index);
            onChanged();
          } else {
            valueDetectedLanguagesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for value together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            getValueDetectedLanguagesBuilder(int index) {
          return getValueDetectedLanguagesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for value together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
            getValueDetectedLanguagesOrBuilder(int index) {
          if (valueDetectedLanguagesBuilder_ == null) {
            return valueDetectedLanguages_.get(index);
          } else {
            return valueDetectedLanguagesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for value together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            getValueDetectedLanguagesOrBuilderList() {
          if (valueDetectedLanguagesBuilder_ != null) {
            return valueDetectedLanguagesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(valueDetectedLanguages_);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for value together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            addValueDetectedLanguagesBuilder() {
          return getValueDetectedLanguagesFieldBuilder()
              .addBuilder(
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for value together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
         * </code>
         */
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
            addValueDetectedLanguagesBuilder(int index) {
          return getValueDetectedLanguagesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages for value together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value_detected_languages = 4;
         * </code>
         */
        public java.util.List<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder>
            getValueDetectedLanguagesBuilderList() {
          return getValueDetectedLanguagesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
            getValueDetectedLanguagesFieldBuilder() {
          if (valueDetectedLanguagesBuilder_ == null) {
            valueDetectedLanguagesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                    com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>(
                    valueDetectedLanguages_,
                    ((bitField0_ & 0x00000008) != 0),
                    getParentForChildren(),
                    isClean());
            valueDetectedLanguages_ = null;
          }
          return valueDetectedLanguagesBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta1.Document.Page.FormField)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta1.Document.Page.FormField)
      private static final com.google.cloud.documentai.v1beta1.Document.Page.FormField
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta1.Document.Page.FormField();
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.FormField
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<FormField> PARSER =
          new com.google.protobuf.AbstractParser<FormField>() {
            @java.lang.Override
            public FormField parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<FormField> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<FormField> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.FormField
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface DetectedLanguageOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
       * information, see
       * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
       * </pre>
       *
       * <code>string language_code = 1;</code>
       *
       * @return The languageCode.
       */
      java.lang.String getLanguageCode();
      /**
       *
       *
       * <pre>
       * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
       * information, see
       * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
       * </pre>
       *
       * <code>string language_code = 1;</code>
       *
       * @return The bytes for languageCode.
       */
      com.google.protobuf.ByteString getLanguageCodeBytes();

      /**
       *
       *
       * <pre>
       * Confidence of detected language. Range [0, 1].
       * </pre>
       *
       * <code>float confidence = 2;</code>
       *
       * @return The confidence.
       */
      float getConfidence();
    }
    /**
     *
     *
     * <pre>
     * Detected language for a structural component.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage}
     */
    public static final class DetectedLanguage extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage)
        DetectedLanguageOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use DetectedLanguage.newBuilder() to construct.
      private DetectedLanguage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private DetectedLanguage() {
        languageCode_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new DetectedLanguage();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_DetectedLanguage_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_DetectedLanguage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.class,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder.class);
      }

      public static final int LANGUAGE_CODE_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object languageCode_ = "";
      /**
       *
       *
       * <pre>
       * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
       * information, see
       * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
       * </pre>
       *
       * <code>string language_code = 1;</code>
       *
       * @return The languageCode.
       */
      @java.lang.Override
      public java.lang.String getLanguageCode() {
        java.lang.Object ref = languageCode_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          languageCode_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
       * information, see
       * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
       * </pre>
       *
       * <code>string language_code = 1;</code>
       *
       * @return The bytes for languageCode.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getLanguageCodeBytes() {
        java.lang.Object ref = languageCode_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          languageCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CONFIDENCE_FIELD_NUMBER = 2;
      private float confidence_ = 0F;
      /**
       *
       *
       * <pre>
       * Confidence of detected language. Range [0, 1].
       * </pre>
       *
       * <code>float confidence = 2;</code>
       *
       * @return The confidence.
       */
      @java.lang.Override
      public float getConfidence() {
        return confidence_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, languageCode_);
        }
        if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
          output.writeFloat(2, confidence_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, languageCode_);
        }
        if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, confidence_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage other =
            (com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage) obj;

        if (!getLanguageCode().equals(other.getLanguageCode())) return false;
        if (java.lang.Float.floatToIntBits(getConfidence())
            != java.lang.Float.floatToIntBits(other.getConfidence())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
        hash = (53 * hash) + getLanguageCode().hashCode();
        hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidence());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Detected language for a structural component.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage)
          com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_DetectedLanguage_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_DetectedLanguage_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.class,
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder.class);
        }

        // Construct using
        // com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          languageCode_ = "";
          confidence_ = 0F;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta1.DocumentProto
              .internal_static_google_cloud_documentai_v1beta1_Document_Page_DetectedLanguage_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
            getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage build() {
          com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage buildPartial() {
          com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage result =
              new com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.languageCode_ = languageCode_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.confidence_ = confidence_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage) {
            return mergeFrom(
                (com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage other) {
          if (other
              == com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                  .getDefaultInstance()) return this;
          if (!other.getLanguageCode().isEmpty()) {
            languageCode_ = other.languageCode_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.getConfidence() != 0F) {
            setConfidence(other.getConfidence());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    languageCode_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 21:
                  {
                    confidence_ = input.readFloat();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 21
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object languageCode_ = "";
        /**
         *
         *
         * <pre>
         * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
         * information, see
         * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
         * </pre>
         *
         * <code>string language_code = 1;</code>
         *
         * @return The languageCode.
         */
        public java.lang.String getLanguageCode() {
          java.lang.Object ref = languageCode_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            languageCode_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
         * information, see
         * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
         * </pre>
         *
         * <code>string language_code = 1;</code>
         *
         * @return The bytes for languageCode.
         */
        public com.google.protobuf.ByteString getLanguageCodeBytes() {
          java.lang.Object ref = languageCode_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            languageCode_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
         * information, see
         * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
         * </pre>
         *
         * <code>string language_code = 1;</code>
         *
         * @param value The languageCode to set.
         * @return This builder for chaining.
         */
        public Builder setLanguageCode(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          languageCode_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
         * information, see
         * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
         * </pre>
         *
         * <code>string language_code = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLanguageCode() {
          languageCode_ = getDefaultInstance().getLanguageCode();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
         * information, see
         * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
         * </pre>
         *
         * <code>string language_code = 1;</code>
         *
         * @param value The bytes for languageCode to set.
         * @return This builder for chaining.
         */
        public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          languageCode_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private float confidence_;
        /**
         *
         *
         * <pre>
         * Confidence of detected language. Range [0, 1].
         * </pre>
         *
         * <code>float confidence = 2;</code>
         *
         * @return The confidence.
         */
        @java.lang.Override
        public float getConfidence() {
          return confidence_;
        }
        /**
         *
         *
         * <pre>
         * Confidence of detected language. Range [0, 1].
         * </pre>
         *
         * <code>float confidence = 2;</code>
         *
         * @param value The confidence to set.
         * @return This builder for chaining.
         */
        public Builder setConfidence(float value) {

          confidence_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Confidence of detected language. Range [0, 1].
         * </pre>
         *
         * <code>float confidence = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearConfidence() {
          bitField0_ = (bitField0_ & ~0x00000002);
          confidence_ = 0F;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage)
      private static final com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage();
      }

      public static com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<DetectedLanguage> PARSER =
          new com.google.protobuf.AbstractParser<DetectedLanguage>() {
            @java.lang.Override
            public DetectedLanguage parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<DetectedLanguage> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<DetectedLanguage> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int PAGE_NUMBER_FIELD_NUMBER = 1;
    private int pageNumber_ = 0;
    /**
     *
     *
     * <pre>
     * 1-based index for current
     * [Page][google.cloud.documentai.v1beta1.Document.Page] in a parent
     * [Document][google.cloud.documentai.v1beta1.Document]. Useful when a page
     * is taken out of a [Document][google.cloud.documentai.v1beta1.Document]
     * for individual processing.
     * </pre>
     *
     * <code>int32 page_number = 1;</code>
     *
     * @return The pageNumber.
     */
    @java.lang.Override
    public int getPageNumber() {
      return pageNumber_;
    }

    public static final int DIMENSION_FIELD_NUMBER = 2;
    private com.google.cloud.documentai.v1beta1.Document.Page.Dimension dimension_;
    /**
     *
     *
     * <pre>
     * Physical dimension of the page.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.Page.Dimension dimension = 2;</code>
     *
     * @return Whether the dimension field is set.
     */
    @java.lang.Override
    public boolean hasDimension() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Physical dimension of the page.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.Page.Dimension dimension = 2;</code>
     *
     * @return The dimension.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Page.Dimension getDimension() {
      return dimension_ == null
          ? com.google.cloud.documentai.v1beta1.Document.Page.Dimension.getDefaultInstance()
          : dimension_;
    }
    /**
     *
     *
     * <pre>
     * Physical dimension of the page.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.Page.Dimension dimension = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Page.DimensionOrBuilder
        getDimensionOrBuilder() {
      return dimension_ == null
          ? com.google.cloud.documentai.v1beta1.Document.Page.Dimension.getDefaultInstance()
          : dimension_;
    }

    public static final int LAYOUT_FIELD_NUMBER = 3;
    private com.google.cloud.documentai.v1beta1.Document.Page.Layout layout_;
    /**
     *
     *
     * <pre>
     * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
     * page.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 3;</code>
     *
     * @return Whether the layout field is set.
     */
    @java.lang.Override
    public boolean hasLayout() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
     * page.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 3;</code>
     *
     * @return The layout.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout() {
      return layout_ == null
          ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
          : layout_;
    }
    /**
     *
     *
     * <pre>
     * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
     * page.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder getLayoutOrBuilder() {
      return layout_ == null
          ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
          : layout_;
    }

    public static final int DETECTED_LANGUAGES_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
        detectedLanguages_;
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
        getDetectedLanguagesList() {
      return detectedLanguages_;
    }
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
        getDetectedLanguagesOrBuilderList() {
      return detectedLanguages_;
    }
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
     * </code>
     */
    @java.lang.Override
    public int getDetectedLanguagesCount() {
      return detectedLanguages_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage getDetectedLanguages(
        int index) {
      return detectedLanguages_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
        getDetectedLanguagesOrBuilder(int index) {
      return detectedLanguages_.get(index);
    }

    public static final int BLOCKS_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Block> blocks_;
    /**
     *
     *
     * <pre>
     * A list of visually detected text blocks on the page.
     * A block has a set of lines (collected into paragraphs) that have a common
     * line-spacing and orientation.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Block> getBlocksList() {
      return blocks_;
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected text blocks on the page.
     * A block has a set of lines (collected into paragraphs) that have a common
     * line-spacing and orientation.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.documentai.v1beta1.Document.Page.BlockOrBuilder>
        getBlocksOrBuilderList() {
      return blocks_;
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected text blocks on the page.
     * A block has a set of lines (collected into paragraphs) that have a common
     * line-spacing and orientation.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
     */
    @java.lang.Override
    public int getBlocksCount() {
      return blocks_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected text blocks on the page.
     * A block has a set of lines (collected into paragraphs) that have a common
     * line-spacing and orientation.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Page.Block getBlocks(int index) {
      return blocks_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected text blocks on the page.
     * A block has a set of lines (collected into paragraphs) that have a common
     * line-spacing and orientation.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Page.BlockOrBuilder getBlocksOrBuilder(
        int index) {
      return blocks_.get(index);
    }

    public static final int PARAGRAPHS_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Paragraph> paragraphs_;
    /**
     *
     *
     * <pre>
     * A list of visually detected text paragraphs on the page.
     * A collection of lines that a human would perceive as a paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Paragraph>
        getParagraphsList() {
      return paragraphs_;
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected text paragraphs on the page.
     * A collection of lines that a human would perceive as a paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.documentai.v1beta1.Document.Page.ParagraphOrBuilder>
        getParagraphsOrBuilderList() {
      return paragraphs_;
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected text paragraphs on the page.
     * A collection of lines that a human would perceive as a paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
     * </code>
     */
    @java.lang.Override
    public int getParagraphsCount() {
      return paragraphs_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected text paragraphs on the page.
     * A collection of lines that a human would perceive as a paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Page.Paragraph getParagraphs(int index) {
      return paragraphs_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected text paragraphs on the page.
     * A collection of lines that a human would perceive as a paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Page.ParagraphOrBuilder
        getParagraphsOrBuilder(int index) {
      return paragraphs_.get(index);
    }

    public static final int LINES_FIELD_NUMBER = 7;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Line> lines_;
    /**
     *
     *
     * <pre>
     * A list of visually detected text lines on the page.
     * A collection of tokens that a human would perceive as a line.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Line> getLinesList() {
      return lines_;
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected text lines on the page.
     * A collection of tokens that a human would perceive as a line.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.documentai.v1beta1.Document.Page.LineOrBuilder>
        getLinesOrBuilderList() {
      return lines_;
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected text lines on the page.
     * A collection of tokens that a human would perceive as a line.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
     */
    @java.lang.Override
    public int getLinesCount() {
      return lines_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected text lines on the page.
     * A collection of tokens that a human would perceive as a line.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Page.Line getLines(int index) {
      return lines_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected text lines on the page.
     * A collection of tokens that a human would perceive as a line.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Page.LineOrBuilder getLinesOrBuilder(
        int index) {
      return lines_.get(index);
    }

    public static final int TOKENS_FIELD_NUMBER = 8;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Token> tokens_;
    /**
     *
     *
     * <pre>
     * A list of visually detected tokens on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Token> getTokensList() {
      return tokens_;
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected tokens on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.documentai.v1beta1.Document.Page.TokenOrBuilder>
        getTokensOrBuilderList() {
      return tokens_;
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected tokens on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
     */
    @java.lang.Override
    public int getTokensCount() {
      return tokens_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected tokens on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Page.Token getTokens(int index) {
      return tokens_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected tokens on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Page.TokenOrBuilder getTokensOrBuilder(
        int index) {
      return tokens_.get(index);
    }

    public static final int VISUAL_ELEMENTS_FIELD_NUMBER = 9;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.VisualElement>
        visualElements_;
    /**
     *
     *
     * <pre>
     * A list of detected non-text visual elements e.g. checkbox,
     * signature etc. on the page.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta1.Document.Page.VisualElement visual_elements = 9;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.VisualElement>
        getVisualElementsList() {
      return visualElements_;
    }
    /**
     *
     *
     * <pre>
     * A list of detected non-text visual elements e.g. checkbox,
     * signature etc. on the page.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta1.Document.Page.VisualElement visual_elements = 9;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.documentai.v1beta1.Document.Page.VisualElementOrBuilder>
        getVisualElementsOrBuilderList() {
      return visualElements_;
    }
    /**
     *
     *
     * <pre>
     * A list of detected non-text visual elements e.g. checkbox,
     * signature etc. on the page.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta1.Document.Page.VisualElement visual_elements = 9;
     * </code>
     */
    @java.lang.Override
    public int getVisualElementsCount() {
      return visualElements_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of detected non-text visual elements e.g. checkbox,
     * signature etc. on the page.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta1.Document.Page.VisualElement visual_elements = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Page.VisualElement getVisualElements(
        int index) {
      return visualElements_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of detected non-text visual elements e.g. checkbox,
     * signature etc. on the page.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta1.Document.Page.VisualElement visual_elements = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Page.VisualElementOrBuilder
        getVisualElementsOrBuilder(int index) {
      return visualElements_.get(index);
    }

    public static final int TABLES_FIELD_NUMBER = 10;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Table> tables_;
    /**
     *
     *
     * <pre>
     * A list of visually detected tables on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table tables = 10;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Table> getTablesList() {
      return tables_;
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected tables on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table tables = 10;</code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.documentai.v1beta1.Document.Page.TableOrBuilder>
        getTablesOrBuilderList() {
      return tables_;
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected tables on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table tables = 10;</code>
     */
    @java.lang.Override
    public int getTablesCount() {
      return tables_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected tables on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table tables = 10;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Page.Table getTables(int index) {
      return tables_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected tables on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Table tables = 10;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Page.TableOrBuilder getTablesOrBuilder(
        int index) {
      return tables_.get(index);
    }

    public static final int FORM_FIELDS_FIELD_NUMBER = 11;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.FormField> formFields_;
    /**
     *
     *
     * <pre>
     * A list of visually detected form fields on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.FormField form_fields = 11;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.FormField>
        getFormFieldsList() {
      return formFields_;
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected form fields on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.FormField form_fields = 11;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.documentai.v1beta1.Document.Page.FormFieldOrBuilder>
        getFormFieldsOrBuilderList() {
      return formFields_;
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected form fields on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.FormField form_fields = 11;
     * </code>
     */
    @java.lang.Override
    public int getFormFieldsCount() {
      return formFields_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected form fields on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.FormField form_fields = 11;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Page.FormField getFormFields(int index) {
      return formFields_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of visually detected form fields on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.FormField form_fields = 11;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta1.Document.Page.FormFieldOrBuilder
        getFormFieldsOrBuilder(int index) {
      return formFields_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (pageNumber_ != 0) {
        output.writeInt32(1, pageNumber_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getDimension());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getLayout());
      }
      for (int i = 0; i < detectedLanguages_.size(); i++) {
        output.writeMessage(4, detectedLanguages_.get(i));
      }
      for (int i = 0; i < blocks_.size(); i++) {
        output.writeMessage(5, blocks_.get(i));
      }
      for (int i = 0; i < paragraphs_.size(); i++) {
        output.writeMessage(6, paragraphs_.get(i));
      }
      for (int i = 0; i < lines_.size(); i++) {
        output.writeMessage(7, lines_.get(i));
      }
      for (int i = 0; i < tokens_.size(); i++) {
        output.writeMessage(8, tokens_.get(i));
      }
      for (int i = 0; i < visualElements_.size(); i++) {
        output.writeMessage(9, visualElements_.get(i));
      }
      for (int i = 0; i < tables_.size(); i++) {
        output.writeMessage(10, tables_.get(i));
      }
      for (int i = 0; i < formFields_.size(); i++) {
        output.writeMessage(11, formFields_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (pageNumber_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, pageNumber_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDimension());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getLayout());
      }
      for (int i = 0; i < detectedLanguages_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(4, detectedLanguages_.get(i));
      }
      for (int i = 0; i < blocks_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, blocks_.get(i));
      }
      for (int i = 0; i < paragraphs_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, paragraphs_.get(i));
      }
      for (int i = 0; i < lines_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, lines_.get(i));
      }
      for (int i = 0; i < tokens_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, tokens_.get(i));
      }
      for (int i = 0; i < visualElements_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, visualElements_.get(i));
      }
      for (int i = 0; i < tables_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, tables_.get(i));
      }
      for (int i = 0; i < formFields_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, formFields_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta1.Document.Page)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta1.Document.Page other =
          (com.google.cloud.documentai.v1beta1.Document.Page) obj;

      if (getPageNumber() != other.getPageNumber()) return false;
      if (hasDimension() != other.hasDimension()) return false;
      if (hasDimension()) {
        if (!getDimension().equals(other.getDimension())) return false;
      }
      if (hasLayout() != other.hasLayout()) return false;
      if (hasLayout()) {
        if (!getLayout().equals(other.getLayout())) return false;
      }
      if (!getDetectedLanguagesList().equals(other.getDetectedLanguagesList())) return false;
      if (!getBlocksList().equals(other.getBlocksList())) return false;
      if (!getParagraphsList().equals(other.getParagraphsList())) return false;
      if (!getLinesList().equals(other.getLinesList())) return false;
      if (!getTokensList().equals(other.getTokensList())) return false;
      if (!getVisualElementsList().equals(other.getVisualElementsList())) return false;
      if (!getTablesList().equals(other.getTablesList())) return false;
      if (!getFormFieldsList().equals(other.getFormFieldsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PAGE_NUMBER_FIELD_NUMBER;
      hash = (53 * hash) + getPageNumber();
      if (hasDimension()) {
        hash = (37 * hash) + DIMENSION_FIELD_NUMBER;
        hash = (53 * hash) + getDimension().hashCode();
      }
      if (hasLayout()) {
        hash = (37 * hash) + LAYOUT_FIELD_NUMBER;
        hash = (53 * hash) + getLayout().hashCode();
      }
      if (getDetectedLanguagesCount() > 0) {
        hash = (37 * hash) + DETECTED_LANGUAGES_FIELD_NUMBER;
        hash = (53 * hash) + getDetectedLanguagesList().hashCode();
      }
      if (getBlocksCount() > 0) {
        hash = (37 * hash) + BLOCKS_FIELD_NUMBER;
        hash = (53 * hash) + getBlocksList().hashCode();
      }
      if (getParagraphsCount() > 0) {
        hash = (37 * hash) + PARAGRAPHS_FIELD_NUMBER;
        hash = (53 * hash) + getParagraphsList().hashCode();
      }
      if (getLinesCount() > 0) {
        hash = (37 * hash) + LINES_FIELD_NUMBER;
        hash = (53 * hash) + getLinesList().hashCode();
      }
      if (getTokensCount() > 0) {
        hash = (37 * hash) + TOKENS_FIELD_NUMBER;
        hash = (53 * hash) + getTokensList().hashCode();
      }
      if (getVisualElementsCount() > 0) {
        hash = (37 * hash) + VISUAL_ELEMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getVisualElementsList().hashCode();
      }
      if (getTablesCount() > 0) {
        hash = (37 * hash) + TABLES_FIELD_NUMBER;
        hash = (53 * hash) + getTablesList().hashCode();
      }
      if (getFormFieldsCount() > 0) {
        hash = (37 * hash) + FORM_FIELDS_FIELD_NUMBER;
        hash = (53 * hash) + getFormFieldsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta1.Document.Page parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Page parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Page parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Page parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Page parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Page parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Page parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Page parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Page parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Page parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Page parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta1.Document.Page parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.documentai.v1beta1.Document.Page prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A page in a [Document][google.cloud.documentai.v1beta1.Document].
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta1.Document.Page}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta1.Document.Page)
        com.google.cloud.documentai.v1beta1.Document.PageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta1.Document.Page.class,
                com.google.cloud.documentai.v1beta1.Document.Page.Builder.class);
      }

      // Construct using com.google.cloud.documentai.v1beta1.Document.Page.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDimensionFieldBuilder();
          getLayoutFieldBuilder();
          getDetectedLanguagesFieldBuilder();
          getBlocksFieldBuilder();
          getParagraphsFieldBuilder();
          getLinesFieldBuilder();
          getTokensFieldBuilder();
          getVisualElementsFieldBuilder();
          getTablesFieldBuilder();
          getFormFieldsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        pageNumber_ = 0;
        dimension_ = null;
        if (dimensionBuilder_ != null) {
          dimensionBuilder_.dispose();
          dimensionBuilder_ = null;
        }
        layout_ = null;
        if (layoutBuilder_ != null) {
          layoutBuilder_.dispose();
          layoutBuilder_ = null;
        }
        if (detectedLanguagesBuilder_ == null) {
          detectedLanguages_ = java.util.Collections.emptyList();
        } else {
          detectedLanguages_ = null;
          detectedLanguagesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        if (blocksBuilder_ == null) {
          blocks_ = java.util.Collections.emptyList();
        } else {
          blocks_ = null;
          blocksBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        if (paragraphsBuilder_ == null) {
          paragraphs_ = java.util.Collections.emptyList();
        } else {
          paragraphs_ = null;
          paragraphsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        if (linesBuilder_ == null) {
          lines_ = java.util.Collections.emptyList();
        } else {
          lines_ = null;
          linesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        if (tokensBuilder_ == null) {
          tokens_ = java.util.Collections.emptyList();
        } else {
          tokens_ = null;
          tokensBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000080);
        if (visualElementsBuilder_ == null) {
          visualElements_ = java.util.Collections.emptyList();
        } else {
          visualElements_ = null;
          visualElementsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000100);
        if (tablesBuilder_ == null) {
          tables_ = java.util.Collections.emptyList();
        } else {
          tables_ = null;
          tablesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000200);
        if (formFieldsBuilder_ == null) {
          formFields_ = java.util.Collections.emptyList();
        } else {
          formFields_ = null;
          formFieldsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000400);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta1.DocumentProto
            .internal_static_google_cloud_documentai_v1beta1_Document_Page_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta1.Document.Page.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page build() {
        com.google.cloud.documentai.v1beta1.Document.Page result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta1.Document.Page buildPartial() {
        com.google.cloud.documentai.v1beta1.Document.Page result =
            new com.google.cloud.documentai.v1beta1.Document.Page(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.documentai.v1beta1.Document.Page result) {
        if (detectedLanguagesBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            detectedLanguages_ = java.util.Collections.unmodifiableList(detectedLanguages_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.detectedLanguages_ = detectedLanguages_;
        } else {
          result.detectedLanguages_ = detectedLanguagesBuilder_.build();
        }
        if (blocksBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)) {
            blocks_ = java.util.Collections.unmodifiableList(blocks_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.blocks_ = blocks_;
        } else {
          result.blocks_ = blocksBuilder_.build();
        }
        if (paragraphsBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)) {
            paragraphs_ = java.util.Collections.unmodifiableList(paragraphs_);
            bitField0_ = (bitField0_ & ~0x00000020);
          }
          result.paragraphs_ = paragraphs_;
        } else {
          result.paragraphs_ = paragraphsBuilder_.build();
        }
        if (linesBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)) {
            lines_ = java.util.Collections.unmodifiableList(lines_);
            bitField0_ = (bitField0_ & ~0x00000040);
          }
          result.lines_ = lines_;
        } else {
          result.lines_ = linesBuilder_.build();
        }
        if (tokensBuilder_ == null) {
          if (((bitField0_ & 0x00000080) != 0)) {
            tokens_ = java.util.Collections.unmodifiableList(tokens_);
            bitField0_ = (bitField0_ & ~0x00000080);
          }
          result.tokens_ = tokens_;
        } else {
          result.tokens_ = tokensBuilder_.build();
        }
        if (visualElementsBuilder_ == null) {
          if (((bitField0_ & 0x00000100) != 0)) {
            visualElements_ = java.util.Collections.unmodifiableList(visualElements_);
            bitField0_ = (bitField0_ & ~0x00000100);
          }
          result.visualElements_ = visualElements_;
        } else {
          result.visualElements_ = visualElementsBuilder_.build();
        }
        if (tablesBuilder_ == null) {
          if (((bitField0_ & 0x00000200) != 0)) {
            tables_ = java.util.Collections.unmodifiableList(tables_);
            bitField0_ = (bitField0_ & ~0x00000200);
          }
          result.tables_ = tables_;
        } else {
          result.tables_ = tablesBuilder_.build();
        }
        if (formFieldsBuilder_ == null) {
          if (((bitField0_ & 0x00000400) != 0)) {
            formFields_ = java.util.Collections.unmodifiableList(formFields_);
            bitField0_ = (bitField0_ & ~0x00000400);
          }
          result.formFields_ = formFields_;
        } else {
          result.formFields_ = formFieldsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.documentai.v1beta1.Document.Page result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.pageNumber_ = pageNumber_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.dimension_ = dimensionBuilder_ == null ? dimension_ : dimensionBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.layout_ = layoutBuilder_ == null ? layout_ : layoutBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1beta1.Document.Page) {
          return mergeFrom((com.google.cloud.documentai.v1beta1.Document.Page) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.documentai.v1beta1.Document.Page other) {
        if (other == com.google.cloud.documentai.v1beta1.Document.Page.getDefaultInstance())
          return this;
        if (other.getPageNumber() != 0) {
          setPageNumber(other.getPageNumber());
        }
        if (other.hasDimension()) {
          mergeDimension(other.getDimension());
        }
        if (other.hasLayout()) {
          mergeLayout(other.getLayout());
        }
        if (detectedLanguagesBuilder_ == null) {
          if (!other.detectedLanguages_.isEmpty()) {
            if (detectedLanguages_.isEmpty()) {
              detectedLanguages_ = other.detectedLanguages_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureDetectedLanguagesIsMutable();
              detectedLanguages_.addAll(other.detectedLanguages_);
            }
            onChanged();
          }
        } else {
          if (!other.detectedLanguages_.isEmpty()) {
            if (detectedLanguagesBuilder_.isEmpty()) {
              detectedLanguagesBuilder_.dispose();
              detectedLanguagesBuilder_ = null;
              detectedLanguages_ = other.detectedLanguages_;
              bitField0_ = (bitField0_ & ~0x00000008);
              detectedLanguagesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDetectedLanguagesFieldBuilder()
                      : null;
            } else {
              detectedLanguagesBuilder_.addAllMessages(other.detectedLanguages_);
            }
          }
        }
        if (blocksBuilder_ == null) {
          if (!other.blocks_.isEmpty()) {
            if (blocks_.isEmpty()) {
              blocks_ = other.blocks_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureBlocksIsMutable();
              blocks_.addAll(other.blocks_);
            }
            onChanged();
          }
        } else {
          if (!other.blocks_.isEmpty()) {
            if (blocksBuilder_.isEmpty()) {
              blocksBuilder_.dispose();
              blocksBuilder_ = null;
              blocks_ = other.blocks_;
              bitField0_ = (bitField0_ & ~0x00000010);
              blocksBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getBlocksFieldBuilder()
                      : null;
            } else {
              blocksBuilder_.addAllMessages(other.blocks_);
            }
          }
        }
        if (paragraphsBuilder_ == null) {
          if (!other.paragraphs_.isEmpty()) {
            if (paragraphs_.isEmpty()) {
              paragraphs_ = other.paragraphs_;
              bitField0_ = (bitField0_ & ~0x00000020);
            } else {
              ensureParagraphsIsMutable();
              paragraphs_.addAll(other.paragraphs_);
            }
            onChanged();
          }
        } else {
          if (!other.paragraphs_.isEmpty()) {
            if (paragraphsBuilder_.isEmpty()) {
              paragraphsBuilder_.dispose();
              paragraphsBuilder_ = null;
              paragraphs_ = other.paragraphs_;
              bitField0_ = (bitField0_ & ~0x00000020);
              paragraphsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getParagraphsFieldBuilder()
                      : null;
            } else {
              paragraphsBuilder_.addAllMessages(other.paragraphs_);
            }
          }
        }
        if (linesBuilder_ == null) {
          if (!other.lines_.isEmpty()) {
            if (lines_.isEmpty()) {
              lines_ = other.lines_;
              bitField0_ = (bitField0_ & ~0x00000040);
            } else {
              ensureLinesIsMutable();
              lines_.addAll(other.lines_);
            }
            onChanged();
          }
        } else {
          if (!other.lines_.isEmpty()) {
            if (linesBuilder_.isEmpty()) {
              linesBuilder_.dispose();
              linesBuilder_ = null;
              lines_ = other.lines_;
              bitField0_ = (bitField0_ & ~0x00000040);
              linesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getLinesFieldBuilder()
                      : null;
            } else {
              linesBuilder_.addAllMessages(other.lines_);
            }
          }
        }
        if (tokensBuilder_ == null) {
          if (!other.tokens_.isEmpty()) {
            if (tokens_.isEmpty()) {
              tokens_ = other.tokens_;
              bitField0_ = (bitField0_ & ~0x00000080);
            } else {
              ensureTokensIsMutable();
              tokens_.addAll(other.tokens_);
            }
            onChanged();
          }
        } else {
          if (!other.tokens_.isEmpty()) {
            if (tokensBuilder_.isEmpty()) {
              tokensBuilder_.dispose();
              tokensBuilder_ = null;
              tokens_ = other.tokens_;
              bitField0_ = (bitField0_ & ~0x00000080);
              tokensBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getTokensFieldBuilder()
                      : null;
            } else {
              tokensBuilder_.addAllMessages(other.tokens_);
            }
          }
        }
        if (visualElementsBuilder_ == null) {
          if (!other.visualElements_.isEmpty()) {
            if (visualElements_.isEmpty()) {
              visualElements_ = other.visualElements_;
              bitField0_ = (bitField0_ & ~0x00000100);
            } else {
              ensureVisualElementsIsMutable();
              visualElements_.addAll(other.visualElements_);
            }
            onChanged();
          }
        } else {
          if (!other.visualElements_.isEmpty()) {
            if (visualElementsBuilder_.isEmpty()) {
              visualElementsBuilder_.dispose();
              visualElementsBuilder_ = null;
              visualElements_ = other.visualElements_;
              bitField0_ = (bitField0_ & ~0x00000100);
              visualElementsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getVisualElementsFieldBuilder()
                      : null;
            } else {
              visualElementsBuilder_.addAllMessages(other.visualElements_);
            }
          }
        }
        if (tablesBuilder_ == null) {
          if (!other.tables_.isEmpty()) {
            if (tables_.isEmpty()) {
              tables_ = other.tables_;
              bitField0_ = (bitField0_ & ~0x00000200);
            } else {
              ensureTablesIsMutable();
              tables_.addAll(other.tables_);
            }
            onChanged();
          }
        } else {
          if (!other.tables_.isEmpty()) {
            if (tablesBuilder_.isEmpty()) {
              tablesBuilder_.dispose();
              tablesBuilder_ = null;
              tables_ = other.tables_;
              bitField0_ = (bitField0_ & ~0x00000200);
              tablesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getTablesFieldBuilder()
                      : null;
            } else {
              tablesBuilder_.addAllMessages(other.tables_);
            }
          }
        }
        if (formFieldsBuilder_ == null) {
          if (!other.formFields_.isEmpty()) {
            if (formFields_.isEmpty()) {
              formFields_ = other.formFields_;
              bitField0_ = (bitField0_ & ~0x00000400);
            } else {
              ensureFormFieldsIsMutable();
              formFields_.addAll(other.formFields_);
            }
            onChanged();
          }
        } else {
          if (!other.formFields_.isEmpty()) {
            if (formFieldsBuilder_.isEmpty()) {
              formFieldsBuilder_.dispose();
              formFieldsBuilder_ = null;
              formFields_ = other.formFields_;
              bitField0_ = (bitField0_ & ~0x00000400);
              formFieldsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getFormFieldsFieldBuilder()
                      : null;
            } else {
              formFieldsBuilder_.addAllMessages(other.formFields_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  pageNumber_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(getDimensionFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getLayoutFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage m =
                      input.readMessage(
                          com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                              .parser(),
                          extensionRegistry);
                  if (detectedLanguagesBuilder_ == null) {
                    ensureDetectedLanguagesIsMutable();
                    detectedLanguages_.add(m);
                  } else {
                    detectedLanguagesBuilder_.addMessage(m);
                  }
                  break;
                } // case 34
              case 42:
                {
                  com.google.cloud.documentai.v1beta1.Document.Page.Block m =
                      input.readMessage(
                          com.google.cloud.documentai.v1beta1.Document.Page.Block.parser(),
                          extensionRegistry);
                  if (blocksBuilder_ == null) {
                    ensureBlocksIsMutable();
                    blocks_.add(m);
                  } else {
                    blocksBuilder_.addMessage(m);
                  }
                  break;
                } // case 42
              case 50:
                {
                  com.google.cloud.documentai.v1beta1.Document.Page.Paragraph m =
                      input.readMessage(
                          com.google.cloud.documentai.v1beta1.Document.Page.Paragraph.parser(),
                          extensionRegistry);
                  if (paragraphsBuilder_ == null) {
                    ensureParagraphsIsMutable();
                    paragraphs_.add(m);
                  } else {
                    paragraphsBuilder_.addMessage(m);
                  }
                  break;
                } // case 50
              case 58:
                {
                  com.google.cloud.documentai.v1beta1.Document.Page.Line m =
                      input.readMessage(
                          com.google.cloud.documentai.v1beta1.Document.Page.Line.parser(),
                          extensionRegistry);
                  if (linesBuilder_ == null) {
                    ensureLinesIsMutable();
                    lines_.add(m);
                  } else {
                    linesBuilder_.addMessage(m);
                  }
                  break;
                } // case 58
              case 66:
                {
                  com.google.cloud.documentai.v1beta1.Document.Page.Token m =
                      input.readMessage(
                          com.google.cloud.documentai.v1beta1.Document.Page.Token.parser(),
                          extensionRegistry);
                  if (tokensBuilder_ == null) {
                    ensureTokensIsMutable();
                    tokens_.add(m);
                  } else {
                    tokensBuilder_.addMessage(m);
                  }
                  break;
                } // case 66
              case 74:
                {
                  com.google.cloud.documentai.v1beta1.Document.Page.VisualElement m =
                      input.readMessage(
                          com.google.cloud.documentai.v1beta1.Document.Page.VisualElement.parser(),
                          extensionRegistry);
                  if (visualElementsBuilder_ == null) {
                    ensureVisualElementsIsMutable();
                    visualElements_.add(m);
                  } else {
                    visualElementsBuilder_.addMessage(m);
                  }
                  break;
                } // case 74
              case 82:
                {
                  com.google.cloud.documentai.v1beta1.Document.Page.Table m =
                      input.readMessage(
                          com.google.cloud.documentai.v1beta1.Document.Page.Table.parser(),
                          extensionRegistry);
                  if (tablesBuilder_ == null) {
                    ensureTablesIsMutable();
                    tables_.add(m);
                  } else {
                    tablesBuilder_.addMessage(m);
                  }
                  break;
                } // case 82
              case 90:
                {
                  com.google.cloud.documentai.v1beta1.Document.Page.FormField m =
                      input.readMessage(
                          com.google.cloud.documentai.v1beta1.Document.Page.FormField.parser(),
                          extensionRegistry);
                  if (formFieldsBuilder_ == null) {
                    ensureFormFieldsIsMutable();
                    formFields_.add(m);
                  } else {
                    formFieldsBuilder_.addMessage(m);
                  }
                  break;
                } // case 90
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int pageNumber_;
      /**
       *
       *
       * <pre>
       * 1-based index for current
       * [Page][google.cloud.documentai.v1beta1.Document.Page] in a parent
       * [Document][google.cloud.documentai.v1beta1.Document]. Useful when a page
       * is taken out of a [Document][google.cloud.documentai.v1beta1.Document]
       * for individual processing.
       * </pre>
       *
       * <code>int32 page_number = 1;</code>
       *
       * @return The pageNumber.
       */
      @java.lang.Override
      public int getPageNumber() {
        return pageNumber_;
      }
      /**
       *
       *
       * <pre>
       * 1-based index for current
       * [Page][google.cloud.documentai.v1beta1.Document.Page] in a parent
       * [Document][google.cloud.documentai.v1beta1.Document]. Useful when a page
       * is taken out of a [Document][google.cloud.documentai.v1beta1.Document]
       * for individual processing.
       * </pre>
       *
       * <code>int32 page_number = 1;</code>
       *
       * @param value The pageNumber to set.
       * @return This builder for chaining.
       */
      public Builder setPageNumber(int value) {

        pageNumber_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * 1-based index for current
       * [Page][google.cloud.documentai.v1beta1.Document.Page] in a parent
       * [Document][google.cloud.documentai.v1beta1.Document]. Useful when a page
       * is taken out of a [Document][google.cloud.documentai.v1beta1.Document]
       * for individual processing.
       * </pre>
       *
       * <code>int32 page_number = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPageNumber() {
        bitField0_ = (bitField0_ & ~0x00000001);
        pageNumber_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.documentai.v1beta1.Document.Page.Dimension dimension_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta1.Document.Page.Dimension,
              com.google.cloud.documentai.v1beta1.Document.Page.Dimension.Builder,
              com.google.cloud.documentai.v1beta1.Document.Page.DimensionOrBuilder>
          dimensionBuilder_;
      /**
       *
       *
       * <pre>
       * Physical dimension of the page.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Dimension dimension = 2;</code>
       *
       * @return Whether the dimension field is set.
       */
      public boolean hasDimension() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Physical dimension of the page.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Dimension dimension = 2;</code>
       *
       * @return The dimension.
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.Dimension getDimension() {
        if (dimensionBuilder_ == null) {
          return dimension_ == null
              ? com.google.cloud.documentai.v1beta1.Document.Page.Dimension.getDefaultInstance()
              : dimension_;
        } else {
          return dimensionBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Physical dimension of the page.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Dimension dimension = 2;</code>
       */
      public Builder setDimension(
          com.google.cloud.documentai.v1beta1.Document.Page.Dimension value) {
        if (dimensionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dimension_ = value;
        } else {
          dimensionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Physical dimension of the page.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Dimension dimension = 2;</code>
       */
      public Builder setDimension(
          com.google.cloud.documentai.v1beta1.Document.Page.Dimension.Builder builderForValue) {
        if (dimensionBuilder_ == null) {
          dimension_ = builderForValue.build();
        } else {
          dimensionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Physical dimension of the page.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Dimension dimension = 2;</code>
       */
      public Builder mergeDimension(
          com.google.cloud.documentai.v1beta1.Document.Page.Dimension value) {
        if (dimensionBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && dimension_ != null
              && dimension_
                  != com.google.cloud.documentai.v1beta1.Document.Page.Dimension
                      .getDefaultInstance()) {
            getDimensionBuilder().mergeFrom(value);
          } else {
            dimension_ = value;
          }
        } else {
          dimensionBuilder_.mergeFrom(value);
        }
        if (dimension_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Physical dimension of the page.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Dimension dimension = 2;</code>
       */
      public Builder clearDimension() {
        bitField0_ = (bitField0_ & ~0x00000002);
        dimension_ = null;
        if (dimensionBuilder_ != null) {
          dimensionBuilder_.dispose();
          dimensionBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Physical dimension of the page.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Dimension dimension = 2;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.Dimension.Builder
          getDimensionBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getDimensionFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Physical dimension of the page.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Dimension dimension = 2;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.DimensionOrBuilder
          getDimensionOrBuilder() {
        if (dimensionBuilder_ != null) {
          return dimensionBuilder_.getMessageOrBuilder();
        } else {
          return dimension_ == null
              ? com.google.cloud.documentai.v1beta1.Document.Page.Dimension.getDefaultInstance()
              : dimension_;
        }
      }
      /**
       *
       *
       * <pre>
       * Physical dimension of the page.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Dimension dimension = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta1.Document.Page.Dimension,
              com.google.cloud.documentai.v1beta1.Document.Page.Dimension.Builder,
              com.google.cloud.documentai.v1beta1.Document.Page.DimensionOrBuilder>
          getDimensionFieldBuilder() {
        if (dimensionBuilder_ == null) {
          dimensionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta1.Document.Page.Dimension,
                  com.google.cloud.documentai.v1beta1.Document.Page.Dimension.Builder,
                  com.google.cloud.documentai.v1beta1.Document.Page.DimensionOrBuilder>(
                  getDimension(), getParentForChildren(), isClean());
          dimension_ = null;
        }
        return dimensionBuilder_;
      }

      private com.google.cloud.documentai.v1beta1.Document.Page.Layout layout_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta1.Document.Page.Layout,
              com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
              com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>
          layoutBuilder_;
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * page.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 3;</code>
       *
       * @return Whether the layout field is set.
       */
      public boolean hasLayout() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * page.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 3;</code>
       *
       * @return The layout.
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.Layout getLayout() {
        if (layoutBuilder_ == null) {
          return layout_ == null
              ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
              : layout_;
        } else {
          return layoutBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * page.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 3;</code>
       */
      public Builder setLayout(com.google.cloud.documentai.v1beta1.Document.Page.Layout value) {
        if (layoutBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          layout_ = value;
        } else {
          layoutBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * page.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 3;</code>
       */
      public Builder setLayout(
          com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder builderForValue) {
        if (layoutBuilder_ == null) {
          layout_ = builderForValue.build();
        } else {
          layoutBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * page.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 3;</code>
       */
      public Builder mergeLayout(com.google.cloud.documentai.v1beta1.Document.Page.Layout value) {
        if (layoutBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && layout_ != null
              && layout_
                  != com.google.cloud.documentai.v1beta1.Document.Page.Layout
                      .getDefaultInstance()) {
            getLayoutBuilder().mergeFrom(value);
          } else {
            layout_ = value;
          }
        } else {
          layoutBuilder_.mergeFrom(value);
        }
        if (layout_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * page.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 3;</code>
       */
      public Builder clearLayout() {
        bitField0_ = (bitField0_ & ~0x00000004);
        layout_ = null;
        if (layoutBuilder_ != null) {
          layoutBuilder_.dispose();
          layoutBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * page.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 3;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder getLayoutBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getLayoutFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * page.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 3;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder
          getLayoutOrBuilder() {
        if (layoutBuilder_ != null) {
          return layoutBuilder_.getMessageOrBuilder();
        } else {
          return layout_ == null
              ? com.google.cloud.documentai.v1beta1.Document.Page.Layout.getDefaultInstance()
              : layout_;
        }
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
       * page.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta1.Document.Page.Layout layout = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta1.Document.Page.Layout,
              com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
              com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>
          getLayoutFieldBuilder() {
        if (layoutBuilder_ == null) {
          layoutBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta1.Document.Page.Layout,
                  com.google.cloud.documentai.v1beta1.Document.Page.Layout.Builder,
                  com.google.cloud.documentai.v1beta1.Document.Page.LayoutOrBuilder>(
                  getLayout(), getParentForChildren(), isClean());
          layout_ = null;
        }
        return layoutBuilder_;
      }

      private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          detectedLanguages_ = java.util.Collections.emptyList();

      private void ensureDetectedLanguagesIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          detectedLanguages_ =
              new java.util.ArrayList<
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>(
                  detectedLanguages_);
          bitField0_ |= 0x00000008;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
              com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
              com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
          detectedLanguagesBuilder_;

      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
          getDetectedLanguagesList() {
        if (detectedLanguagesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(detectedLanguages_);
        } else {
          return detectedLanguagesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      public int getDetectedLanguagesCount() {
        if (detectedLanguagesBuilder_ == null) {
          return detectedLanguages_.size();
        } else {
          return detectedLanguagesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
          getDetectedLanguages(int index) {
        if (detectedLanguagesBuilder_ == null) {
          return detectedLanguages_.get(index);
        } else {
          return detectedLanguagesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      public Builder setDetectedLanguages(
          int index, com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
        if (detectedLanguagesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDetectedLanguagesIsMutable();
          detectedLanguages_.set(index, value);
          onChanged();
        } else {
          detectedLanguagesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      public Builder setDetectedLanguages(
          int index,
          com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
              builderForValue) {
        if (detectedLanguagesBuilder_ == null) {
          ensureDetectedLanguagesIsMutable();
          detectedLanguages_.set(index, builderForValue.build());
          onChanged();
        } else {
          detectedLanguagesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      public Builder addDetectedLanguages(
          com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
        if (detectedLanguagesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDetectedLanguagesIsMutable();
          detectedLanguages_.add(value);
          onChanged();
        } else {
          detectedLanguagesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      public Builder addDetectedLanguages(
          int index, com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage value) {
        if (detectedLanguagesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDetectedLanguagesIsMutable();
          detectedLanguages_.add(index, value);
          onChanged();
        } else {
          detectedLanguagesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      public Builder addDetectedLanguages(
          com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
              builderForValue) {
        if (detectedLanguagesBuilder_ == null) {
          ensureDetectedLanguagesIsMutable();
          detectedLanguages_.add(builderForValue.build());
          onChanged();
        } else {
          detectedLanguagesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      public Builder addDetectedLanguages(
          int index,
          com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
              builderForValue) {
        if (detectedLanguagesBuilder_ == null) {
          ensureDetectedLanguagesIsMutable();
          detectedLanguages_.add(index, builderForValue.build());
          onChanged();
        } else {
          detectedLanguagesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      public Builder addAllDetectedLanguages(
          java.lang.Iterable<
                  ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage>
              values) {
        if (detectedLanguagesBuilder_ == null) {
          ensureDetectedLanguagesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, detectedLanguages_);
          onChanged();
        } else {
          detectedLanguagesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      public Builder clearDetectedLanguages() {
        if (detectedLanguagesBuilder_ == null) {
          detectedLanguages_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          detectedLanguagesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      public Builder removeDetectedLanguages(int index) {
        if (detectedLanguagesBuilder_ == null) {
          ensureDetectedLanguagesIsMutable();
          detectedLanguages_.remove(index);
          onChanged();
        } else {
          detectedLanguagesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
          getDetectedLanguagesBuilder(int index) {
        return getDetectedLanguagesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index) {
        if (detectedLanguagesBuilder_ == null) {
          return detectedLanguages_.get(index);
        } else {
          return detectedLanguagesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList() {
        if (detectedLanguagesBuilder_ != null) {
          return detectedLanguagesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(detectedLanguages_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
          addDetectedLanguagesBuilder() {
        return getDetectedLanguagesFieldBuilder()
            .addBuilder(
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder
          addDetectedLanguagesBuilder(int index) {
        return getDetectedLanguagesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      public java.util.List<
              com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder>
          getDetectedLanguagesBuilderList() {
        return getDetectedLanguagesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
              com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
              com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesFieldBuilder() {
        if (detectedLanguagesBuilder_ == null) {
          detectedLanguagesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage,
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage.Builder,
                  com.google.cloud.documentai.v1beta1.Document.Page.DetectedLanguageOrBuilder>(
                  detectedLanguages_,
                  ((bitField0_ & 0x00000008) != 0),
                  getParentForChildren(),
                  isClean());
          detectedLanguages_ = null;
        }
        return detectedLanguagesBuilder_;
      }

      private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Block> blocks_ =
          java.util.Collections.emptyList();

      private void ensureBlocksIsMutable() {
        if (!((bitField0_ & 0x00000010) != 0)) {
          blocks_ =
              new java.util.ArrayList<com.google.cloud.documentai.v1beta1.Document.Page.Block>(
                  blocks_);
          bitField0_ |= 0x00000010;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.documentai.v1beta1.Document.Page.Block,
              com.google.cloud.documentai.v1beta1.Document.Page.Block.Builder,
              com.google.cloud.documentai.v1beta1.Document.Page.BlockOrBuilder>
          blocksBuilder_;

      /**
       *
       *
       * <pre>
       * A list of visually detected text blocks on the page.
       * A block has a set of lines (collected into paragraphs) that have a common
       * line-spacing and orientation.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
       */
      public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Block>
          getBlocksList() {
        if (blocksBuilder_ == null) {
          return java.util.Collections.unmodifiableList(blocks_);
        } else {
          return blocksBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text blocks on the page.
       * A block has a set of lines (collected into paragraphs) that have a common
       * line-spacing and orientation.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
       */
      public int getBlocksCount() {
        if (blocksBuilder_ == null) {
          return blocks_.size();
        } else {
          return blocksBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text blocks on the page.
       * A block has a set of lines (collected into paragraphs) that have a common
       * line-spacing and orientation.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.Block getBlocks(int index) {
        if (blocksBuilder_ == null) {
          return blocks_.get(index);
        } else {
          return blocksBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text blocks on the page.
       * A block has a set of lines (collected into paragraphs) that have a common
       * line-spacing and orientation.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
       */
      public Builder setBlocks(
          int index, com.google.cloud.documentai.v1beta1.Document.Page.Block value) {
        if (blocksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBlocksIsMutable();
          blocks_.set(index, value);
          onChanged();
        } else {
          blocksBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text blocks on the page.
       * A block has a set of lines (collected into paragraphs) that have a common
       * line-spacing and orientation.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
       */
      public Builder setBlocks(
          int index,
          com.google.cloud.documentai.v1beta1.Document.Page.Block.Builder builderForValue) {
        if (blocksBuilder_ == null) {
          ensureBlocksIsMutable();
          blocks_.set(index, builderForValue.build());
          onChanged();
        } else {
          blocksBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text blocks on the page.
       * A block has a set of lines (collected into paragraphs) that have a common
       * line-spacing and orientation.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
       */
      public Builder addBlocks(com.google.cloud.documentai.v1beta1.Document.Page.Block value) {
        if (blocksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBlocksIsMutable();
          blocks_.add(value);
          onChanged();
        } else {
          blocksBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text blocks on the page.
       * A block has a set of lines (collected into paragraphs) that have a common
       * line-spacing and orientation.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
       */
      public Builder addBlocks(
          int index, com.google.cloud.documentai.v1beta1.Document.Page.Block value) {
        if (blocksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBlocksIsMutable();
          blocks_.add(index, value);
          onChanged();
        } else {
          blocksBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text blocks on the page.
       * A block has a set of lines (collected into paragraphs) that have a common
       * line-spacing and orientation.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
       */
      public Builder addBlocks(
          com.google.cloud.documentai.v1beta1.Document.Page.Block.Builder builderForValue) {
        if (blocksBuilder_ == null) {
          ensureBlocksIsMutable();
          blocks_.add(builderForValue.build());
          onChanged();
        } else {
          blocksBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text blocks on the page.
       * A block has a set of lines (collected into paragraphs) that have a common
       * line-spacing and orientation.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
       */
      public Builder addBlocks(
          int index,
          com.google.cloud.documentai.v1beta1.Document.Page.Block.Builder builderForValue) {
        if (blocksBuilder_ == null) {
          ensureBlocksIsMutable();
          blocks_.add(index, builderForValue.build());
          onChanged();
        } else {
          blocksBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text blocks on the page.
       * A block has a set of lines (collected into paragraphs) that have a common
       * line-spacing and orientation.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
       */
      public Builder addAllBlocks(
          java.lang.Iterable<? extends com.google.cloud.documentai.v1beta1.Document.Page.Block>
              values) {
        if (blocksBuilder_ == null) {
          ensureBlocksIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, blocks_);
          onChanged();
        } else {
          blocksBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text blocks on the page.
       * A block has a set of lines (collected into paragraphs) that have a common
       * line-spacing and orientation.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
       */
      public Builder clearBlocks() {
        if (blocksBuilder_ == null) {
          blocks_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          blocksBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text blocks on the page.
       * A block has a set of lines (collected into paragraphs) that have a common
       * line-spacing and orientation.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
       */
      public Builder removeBlocks(int index) {
        if (blocksBuilder_ == null) {
          ensureBlocksIsMutable();
          blocks_.remove(index);
          onChanged();
        } else {
          blocksBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text blocks on the page.
       * A block has a set of lines (collected into paragraphs) that have a common
       * line-spacing and orientation.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.Block.Builder getBlocksBuilder(
          int index) {
        return getBlocksFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text blocks on the page.
       * A block has a set of lines (collected into paragraphs) that have a common
       * line-spacing and orientation.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.BlockOrBuilder getBlocksOrBuilder(
          int index) {
        if (blocksBuilder_ == null) {
          return blocks_.get(index);
        } else {
          return blocksBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text blocks on the page.
       * A block has a set of lines (collected into paragraphs) that have a common
       * line-spacing and orientation.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
       */
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.BlockOrBuilder>
          getBlocksOrBuilderList() {
        if (blocksBuilder_ != null) {
          return blocksBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(blocks_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text blocks on the page.
       * A block has a set of lines (collected into paragraphs) that have a common
       * line-spacing and orientation.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.Block.Builder addBlocksBuilder() {
        return getBlocksFieldBuilder()
            .addBuilder(
                com.google.cloud.documentai.v1beta1.Document.Page.Block.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text blocks on the page.
       * A block has a set of lines (collected into paragraphs) that have a common
       * line-spacing and orientation.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.Block.Builder addBlocksBuilder(
          int index) {
        return getBlocksFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.documentai.v1beta1.Document.Page.Block.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text blocks on the page.
       * A block has a set of lines (collected into paragraphs) that have a common
       * line-spacing and orientation.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Block blocks = 5;</code>
       */
      public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Block.Builder>
          getBlocksBuilderList() {
        return getBlocksFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.documentai.v1beta1.Document.Page.Block,
              com.google.cloud.documentai.v1beta1.Document.Page.Block.Builder,
              com.google.cloud.documentai.v1beta1.Document.Page.BlockOrBuilder>
          getBlocksFieldBuilder() {
        if (blocksBuilder_ == null) {
          blocksBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.documentai.v1beta1.Document.Page.Block,
                  com.google.cloud.documentai.v1beta1.Document.Page.Block.Builder,
                  com.google.cloud.documentai.v1beta1.Document.Page.BlockOrBuilder>(
                  blocks_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
          blocks_ = null;
        }
        return blocksBuilder_;
      }

      private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Paragraph>
          paragraphs_ = java.util.Collections.emptyList();

      private void ensureParagraphsIsMutable() {
        if (!((bitField0_ & 0x00000020) != 0)) {
          paragraphs_ =
              new java.util.ArrayList<com.google.cloud.documentai.v1beta1.Document.Page.Paragraph>(
                  paragraphs_);
          bitField0_ |= 0x00000020;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.documentai.v1beta1.Document.Page.Paragraph,
              com.google.cloud.documentai.v1beta1.Document.Page.Paragraph.Builder,
              com.google.cloud.documentai.v1beta1.Document.Page.ParagraphOrBuilder>
          paragraphsBuilder_;

      /**
       *
       *
       * <pre>
       * A list of visually detected text paragraphs on the page.
       * A collection of lines that a human would perceive as a paragraph.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
       * </code>
       */
      public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Paragraph>
          getParagraphsList() {
        if (paragraphsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(paragraphs_);
        } else {
          return paragraphsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text paragraphs on the page.
       * A collection of lines that a human would perceive as a paragraph.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
       * </code>
       */
      public int getParagraphsCount() {
        if (paragraphsBuilder_ == null) {
          return paragraphs_.size();
        } else {
          return paragraphsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text paragraphs on the page.
       * A collection of lines that a human would perceive as a paragraph.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
       * </code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.Paragraph getParagraphs(int index) {
        if (paragraphsBuilder_ == null) {
          return paragraphs_.get(index);
        } else {
          return paragraphsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text paragraphs on the page.
       * A collection of lines that a human would perceive as a paragraph.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
       * </code>
       */
      public Builder setParagraphs(
          int index, com.google.cloud.documentai.v1beta1.Document.Page.Paragraph value) {
        if (paragraphsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParagraphsIsMutable();
          paragraphs_.set(index, value);
          onChanged();
        } else {
          paragraphsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text paragraphs on the page.
       * A collection of lines that a human would perceive as a paragraph.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
       * </code>
       */
      public Builder setParagraphs(
          int index,
          com.google.cloud.documentai.v1beta1.Document.Page.Paragraph.Builder builderForValue) {
        if (paragraphsBuilder_ == null) {
          ensureParagraphsIsMutable();
          paragraphs_.set(index, builderForValue.build());
          onChanged();
        } else {
          paragraphsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text paragraphs on the page.
       * A collection of lines that a human would perceive as a paragraph.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
       * </code>
       */
      public Builder addParagraphs(
          com.google.cloud.documentai.v1beta1.Document.Page.Paragraph value) {
        if (paragraphsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParagraphsIsMutable();
          paragraphs_.add(value);
          onChanged();
        } else {
          paragraphsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text paragraphs on the page.
       * A collection of lines that a human would perceive as a paragraph.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
       * </code>
       */
      public Builder addParagraphs(
          int index, com.google.cloud.documentai.v1beta1.Document.Page.Paragraph value) {
        if (paragraphsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParagraphsIsMutable();
          paragraphs_.add(index, value);
          onChanged();
        } else {
          paragraphsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text paragraphs on the page.
       * A collection of lines that a human would perceive as a paragraph.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
       * </code>
       */
      public Builder addParagraphs(
          com.google.cloud.documentai.v1beta1.Document.Page.Paragraph.Builder builderForValue) {
        if (paragraphsBuilder_ == null) {
          ensureParagraphsIsMutable();
          paragraphs_.add(builderForValue.build());
          onChanged();
        } else {
          paragraphsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text paragraphs on the page.
       * A collection of lines that a human would perceive as a paragraph.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
       * </code>
       */
      public Builder addParagraphs(
          int index,
          com.google.cloud.documentai.v1beta1.Document.Page.Paragraph.Builder builderForValue) {
        if (paragraphsBuilder_ == null) {
          ensureParagraphsIsMutable();
          paragraphs_.add(index, builderForValue.build());
          onChanged();
        } else {
          paragraphsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text paragraphs on the page.
       * A collection of lines that a human would perceive as a paragraph.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
       * </code>
       */
      public Builder addAllParagraphs(
          java.lang.Iterable<? extends com.google.cloud.documentai.v1beta1.Document.Page.Paragraph>
              values) {
        if (paragraphsBuilder_ == null) {
          ensureParagraphsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, paragraphs_);
          onChanged();
        } else {
          paragraphsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text paragraphs on the page.
       * A collection of lines that a human would perceive as a paragraph.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
       * </code>
       */
      public Builder clearParagraphs() {
        if (paragraphsBuilder_ == null) {
          paragraphs_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
          onChanged();
        } else {
          paragraphsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text paragraphs on the page.
       * A collection of lines that a human would perceive as a paragraph.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
       * </code>
       */
      public Builder removeParagraphs(int index) {
        if (paragraphsBuilder_ == null) {
          ensureParagraphsIsMutable();
          paragraphs_.remove(index);
          onChanged();
        } else {
          paragraphsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text paragraphs on the page.
       * A collection of lines that a human would perceive as a paragraph.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
       * </code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.Paragraph.Builder
          getParagraphsBuilder(int index) {
        return getParagraphsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text paragraphs on the page.
       * A collection of lines that a human would perceive as a paragraph.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
       * </code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.ParagraphOrBuilder
          getParagraphsOrBuilder(int index) {
        if (paragraphsBuilder_ == null) {
          return paragraphs_.get(index);
        } else {
          return paragraphsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text paragraphs on the page.
       * A collection of lines that a human would perceive as a paragraph.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.ParagraphOrBuilder>
          getParagraphsOrBuilderList() {
        if (paragraphsBuilder_ != null) {
          return paragraphsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(paragraphs_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text paragraphs on the page.
       * A collection of lines that a human would perceive as a paragraph.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
       * </code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.Paragraph.Builder
          addParagraphsBuilder() {
        return getParagraphsFieldBuilder()
            .addBuilder(
                com.google.cloud.documentai.v1beta1.Document.Page.Paragraph.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text paragraphs on the page.
       * A collection of lines that a human would perceive as a paragraph.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
       * </code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.Paragraph.Builder
          addParagraphsBuilder(int index) {
        return getParagraphsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.documentai.v1beta1.Document.Page.Paragraph.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text paragraphs on the page.
       * A collection of lines that a human would perceive as a paragraph.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Paragraph paragraphs = 6;
       * </code>
       */
      public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Paragraph.Builder>
          getParagraphsBuilderList() {
        return getParagraphsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.documentai.v1beta1.Document.Page.Paragraph,
              com.google.cloud.documentai.v1beta1.Document.Page.Paragraph.Builder,
              com.google.cloud.documentai.v1beta1.Document.Page.ParagraphOrBuilder>
          getParagraphsFieldBuilder() {
        if (paragraphsBuilder_ == null) {
          paragraphsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.documentai.v1beta1.Document.Page.Paragraph,
                  com.google.cloud.documentai.v1beta1.Document.Page.Paragraph.Builder,
                  com.google.cloud.documentai.v1beta1.Document.Page.ParagraphOrBuilder>(
                  paragraphs_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
          paragraphs_ = null;
        }
        return paragraphsBuilder_;
      }

      private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Line> lines_ =
          java.util.Collections.emptyList();

      private void ensureLinesIsMutable() {
        if (!((bitField0_ & 0x00000040) != 0)) {
          lines_ =
              new java.util.ArrayList<com.google.cloud.documentai.v1beta1.Document.Page.Line>(
                  lines_);
          bitField0_ |= 0x00000040;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.documentai.v1beta1.Document.Page.Line,
              com.google.cloud.documentai.v1beta1.Document.Page.Line.Builder,
              com.google.cloud.documentai.v1beta1.Document.Page.LineOrBuilder>
          linesBuilder_;

      /**
       *
       *
       * <pre>
       * A list of visually detected text lines on the page.
       * A collection of tokens that a human would perceive as a line.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
       */
      public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Line> getLinesList() {
        if (linesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(lines_);
        } else {
          return linesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text lines on the page.
       * A collection of tokens that a human would perceive as a line.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
       */
      public int getLinesCount() {
        if (linesBuilder_ == null) {
          return lines_.size();
        } else {
          return linesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text lines on the page.
       * A collection of tokens that a human would perceive as a line.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.Line getLines(int index) {
        if (linesBuilder_ == null) {
          return lines_.get(index);
        } else {
          return linesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text lines on the page.
       * A collection of tokens that a human would perceive as a line.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
       */
      public Builder setLines(
          int index, com.google.cloud.documentai.v1beta1.Document.Page.Line value) {
        if (linesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLinesIsMutable();
          lines_.set(index, value);
          onChanged();
        } else {
          linesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text lines on the page.
       * A collection of tokens that a human would perceive as a line.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
       */
      public Builder setLines(
          int index,
          com.google.cloud.documentai.v1beta1.Document.Page.Line.Builder builderForValue) {
        if (linesBuilder_ == null) {
          ensureLinesIsMutable();
          lines_.set(index, builderForValue.build());
          onChanged();
        } else {
          linesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text lines on the page.
       * A collection of tokens that a human would perceive as a line.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
       */
      public Builder addLines(com.google.cloud.documentai.v1beta1.Document.Page.Line value) {
        if (linesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLinesIsMutable();
          lines_.add(value);
          onChanged();
        } else {
          linesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text lines on the page.
       * A collection of tokens that a human would perceive as a line.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
       */
      public Builder addLines(
          int index, com.google.cloud.documentai.v1beta1.Document.Page.Line value) {
        if (linesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLinesIsMutable();
          lines_.add(index, value);
          onChanged();
        } else {
          linesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text lines on the page.
       * A collection of tokens that a human would perceive as a line.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
       */
      public Builder addLines(
          com.google.cloud.documentai.v1beta1.Document.Page.Line.Builder builderForValue) {
        if (linesBuilder_ == null) {
          ensureLinesIsMutable();
          lines_.add(builderForValue.build());
          onChanged();
        } else {
          linesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text lines on the page.
       * A collection of tokens that a human would perceive as a line.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
       */
      public Builder addLines(
          int index,
          com.google.cloud.documentai.v1beta1.Document.Page.Line.Builder builderForValue) {
        if (linesBuilder_ == null) {
          ensureLinesIsMutable();
          lines_.add(index, builderForValue.build());
          onChanged();
        } else {
          linesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text lines on the page.
       * A collection of tokens that a human would perceive as a line.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
       */
      public Builder addAllLines(
          java.lang.Iterable<? extends com.google.cloud.documentai.v1beta1.Document.Page.Line>
              values) {
        if (linesBuilder_ == null) {
          ensureLinesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, lines_);
          onChanged();
        } else {
          linesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text lines on the page.
       * A collection of tokens that a human would perceive as a line.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
       */
      public Builder clearLines() {
        if (linesBuilder_ == null) {
          lines_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
          onChanged();
        } else {
          linesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text lines on the page.
       * A collection of tokens that a human would perceive as a line.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
       */
      public Builder removeLines(int index) {
        if (linesBuilder_ == null) {
          ensureLinesIsMutable();
          lines_.remove(index);
          onChanged();
        } else {
          linesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text lines on the page.
       * A collection of tokens that a human would perceive as a line.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.Line.Builder getLinesBuilder(
          int index) {
        return getLinesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text lines on the page.
       * A collection of tokens that a human would perceive as a line.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.LineOrBuilder getLinesOrBuilder(
          int index) {
        if (linesBuilder_ == null) {
          return lines_.get(index);
        } else {
          return linesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text lines on the page.
       * A collection of tokens that a human would perceive as a line.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
       */
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.LineOrBuilder>
          getLinesOrBuilderList() {
        if (linesBuilder_ != null) {
          return linesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(lines_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text lines on the page.
       * A collection of tokens that a human would perceive as a line.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.Line.Builder addLinesBuilder() {
        return getLinesFieldBuilder()
            .addBuilder(
                com.google.cloud.documentai.v1beta1.Document.Page.Line.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text lines on the page.
       * A collection of tokens that a human would perceive as a line.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.Line.Builder addLinesBuilder(
          int index) {
        return getLinesFieldBuilder()
            .addBuilder(
                index, com.google.cloud.documentai.v1beta1.Document.Page.Line.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected text lines on the page.
       * A collection of tokens that a human would perceive as a line.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Line lines = 7;</code>
       */
      public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Line.Builder>
          getLinesBuilderList() {
        return getLinesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.documentai.v1beta1.Document.Page.Line,
              com.google.cloud.documentai.v1beta1.Document.Page.Line.Builder,
              com.google.cloud.documentai.v1beta1.Document.Page.LineOrBuilder>
          getLinesFieldBuilder() {
        if (linesBuilder_ == null) {
          linesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.documentai.v1beta1.Document.Page.Line,
                  com.google.cloud.documentai.v1beta1.Document.Page.Line.Builder,
                  com.google.cloud.documentai.v1beta1.Document.Page.LineOrBuilder>(
                  lines_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
          lines_ = null;
        }
        return linesBuilder_;
      }

      private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Token> tokens_ =
          java.util.Collections.emptyList();

      private void ensureTokensIsMutable() {
        if (!((bitField0_ & 0x00000080) != 0)) {
          tokens_ =
              new java.util.ArrayList<com.google.cloud.documentai.v1beta1.Document.Page.Token>(
                  tokens_);
          bitField0_ |= 0x00000080;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.documentai.v1beta1.Document.Page.Token,
              com.google.cloud.documentai.v1beta1.Document.Page.Token.Builder,
              com.google.cloud.documentai.v1beta1.Document.Page.TokenOrBuilder>
          tokensBuilder_;

      /**
       *
       *
       * <pre>
       * A list of visually detected tokens on the page.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
       */
      public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Token>
          getTokensList() {
        if (tokensBuilder_ == null) {
          return java.util.Collections.unmodifiableList(tokens_);
        } else {
          return tokensBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected tokens on the page.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
       */
      public int getTokensCount() {
        if (tokensBuilder_ == null) {
          return tokens_.size();
        } else {
          return tokensBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected tokens on the page.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.Token getTokens(int index) {
        if (tokensBuilder_ == null) {
          return tokens_.get(index);
        } else {
          return tokensBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected tokens on the page.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
       */
      public Builder setTokens(
          int index, com.google.cloud.documentai.v1beta1.Document.Page.Token value) {
        if (tokensBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTokensIsMutable();
          tokens_.set(index, value);
          onChanged();
        } else {
          tokensBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected tokens on the page.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
       */
      public Builder setTokens(
          int index,
          com.google.cloud.documentai.v1beta1.Document.Page.Token.Builder builderForValue) {
        if (tokensBuilder_ == null) {
          ensureTokensIsMutable();
          tokens_.set(index, builderForValue.build());
          onChanged();
        } else {
          tokensBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected tokens on the page.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
       */
      public Builder addTokens(com.google.cloud.documentai.v1beta1.Document.Page.Token value) {
        if (tokensBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTokensIsMutable();
          tokens_.add(value);
          onChanged();
        } else {
          tokensBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected tokens on the page.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
       */
      public Builder addTokens(
          int index, com.google.cloud.documentai.v1beta1.Document.Page.Token value) {
        if (tokensBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTokensIsMutable();
          tokens_.add(index, value);
          onChanged();
        } else {
          tokensBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected tokens on the page.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
       */
      public Builder addTokens(
          com.google.cloud.documentai.v1beta1.Document.Page.Token.Builder builderForValue) {
        if (tokensBuilder_ == null) {
          ensureTokensIsMutable();
          tokens_.add(builderForValue.build());
          onChanged();
        } else {
          tokensBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected tokens on the page.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
       */
      public Builder addTokens(
          int index,
          com.google.cloud.documentai.v1beta1.Document.Page.Token.Builder builderForValue) {
        if (tokensBuilder_ == null) {
          ensureTokensIsMutable();
          tokens_.add(index, builderForValue.build());
          onChanged();
        } else {
          tokensBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected tokens on the page.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
       */
      public Builder addAllTokens(
          java.lang.Iterable<? extends com.google.cloud.documentai.v1beta1.Document.Page.Token>
              values) {
        if (tokensBuilder_ == null) {
          ensureTokensIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tokens_);
          onChanged();
        } else {
          tokensBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected tokens on the page.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
       */
      public Builder clearTokens() {
        if (tokensBuilder_ == null) {
          tokens_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000080);
          onChanged();
        } else {
          tokensBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected tokens on the page.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
       */
      public Builder removeTokens(int index) {
        if (tokensBuilder_ == null) {
          ensureTokensIsMutable();
          tokens_.remove(index);
          onChanged();
        } else {
          tokensBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected tokens on the page.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.Token.Builder getTokensBuilder(
          int index) {
        return getTokensFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected tokens on the page.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.TokenOrBuilder getTokensOrBuilder(
          int index) {
        if (tokensBuilder_ == null) {
          return tokens_.get(index);
        } else {
          return tokensBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected tokens on the page.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
       */
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta1.Document.Page.TokenOrBuilder>
          getTokensOrBuilderList() {
        if (tokensBuilder_ != null) {
          return tokensBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(tokens_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected tokens on the page.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.Token.Builder addTokensBuilder() {
        return getTokensFieldBuilder()
            .addBuilder(
                com.google.cloud.documentai.v1beta1.Document.Page.Token.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected tokens on the page.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.Token.Builder addTokensBuilder(
          int index) {
        return getTokensFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.documentai.v1beta1.Document.Page.Token.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of visually detected tokens on the page.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta1.Document.Page.Token tokens = 8;</code>
       */
      public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.Token.Builder>
          getTokensBuilderList() {
        return getTokensFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.documentai.v1beta1.Document.Page.Token,
              com.google.cloud.documentai.v1beta1.Document.Page.Token.Builder,
              com.google.cloud.documentai.v1beta1.Document.Page.TokenOrBuilder>
          getTokensFieldBuilder() {
        if (tokensBuilder_ == null) {
          tokensBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.documentai.v1beta1.Document.Page.Token,
                  com.google.cloud.documentai.v1beta1.Document.Page.Token.Builder,
                  com.google.cloud.documentai.v1beta1.Document.Page.TokenOrBuilder>(
                  tokens_, ((bitField0_ & 0x00000080) != 0), getParentForChildren(), isClean());
          tokens_ = null;
        }
        return tokensBuilder_;
      }

      private java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.VisualElement>
          visualElements_ = java.util.Collections.emptyList();

      private void ensureVisualElementsIsMutable() {
        if (!((bitField0_ & 0x00000100) != 0)) {
          visualElements_ =
              new java.util.ArrayList<
                  com.google.cloud.documentai.v1beta1.Document.Page.VisualElement>(visualElements_);
          bitField0_ |= 0x00000100;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.documentai.v1beta1.Document.Page.VisualElement,
              com.google.cloud.documentai.v1beta1.Document.Page.VisualElement.Builder,
              com.google.cloud.documentai.v1beta1.Document.Page.VisualElementOrBuilder>
          visualElementsBuilder_;

      /**
       *
       *
       * <pre>
       * A list of detected non-text visual elements e.g. checkbox,
       * signature etc. on the page.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.VisualElement visual_elements = 9;
       * </code>
       */
      public java.util.List<com.google.cloud.documentai.v1beta1.Document.Page.VisualElement>
          getVisualElementsList() {
        if (visualElementsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(visualElements_);
        } else {
          return visualElementsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of detected non-text visual elements e.g. checkbox,
       * signature etc. on the page.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.VisualElement visual_elements = 9;
       * </code>
       */
      public int getVisualElementsCount() {
        if (visualElementsBuilder_ == null) {
          return visualElements_.size();
        } else {
          return visualElementsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of detected non-text visual elements e.g. checkbox,
       * signature etc. on the page.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.VisualElement visual_elements = 9;
       * </code>
       */
      public com.google.cloud.documentai.v1beta1.Document.Page.VisualElement getVisualElements(
          int index) {
        if (visualElementsBuilder_ == null) {
          return visualElements_.get(index);
        } else {
          return visualElementsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of detected non-text visual elements e.g. checkbox,
       * signature etc. on the page.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.VisualElement visual_elements = 9;
       * </code>
       */
      public Builder setVisualElements(
          int index, com.google.cloud.documentai.v1beta1.Document.Page.VisualElement value) {
        if (visualElementsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureVisualElementsIsMutable();
          visualElements_.set(index, value);
          onChanged();
        } else {
          visualElementsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of detected non-text visual elements e.g. checkbox,
       * signature etc. on the page.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.VisualElement visual_elements = 9;
       * </code>
       */
      public Builder setVisualElements(
          int index,
          com.google.cloud.documentai.v1beta1.Document.Page.VisualElement.Builder builderForValue) {
        if (visualElementsBuilder_ == null) {
          ensureVisualElementsIsMutable();
          visualElements_.set(index, builderForValue.build());
          onChanged();
        } else {
          visualElementsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of detected non-text visual elements e.g. checkbox,
       * signature etc. on the page.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta1.Document.Page.VisualElement visual_elements = 9;
       * </code>
       */
      public Builder addVisualElements(
          com.google.cloud.documentai.v1beta1.Document.Page.VisualElement value) {
        if (visualElementsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureVisualElementsIsMutable();
          visualElements_.add(value);
          onChanged();
        } else {
          visualElementsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * 