/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta2/document_understanding.proto

package com.google.cloud.documentai.v1beta2;

/**
 *
 *
 * <pre>
 * Request to process one document.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta2.ProcessDocumentRequest}
 */
public final class ProcessDocumentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta2.ProcessDocumentRequest)
    ProcessDocumentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ProcessDocumentRequest.newBuilder() to construct.
  private ProcessDocumentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ProcessDocumentRequest() {
    parent_ = "";
    documentType_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ProcessDocumentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta2.DocumentAiProto
        .internal_static_google_cloud_documentai_v1beta2_ProcessDocumentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta2.DocumentAiProto
        .internal_static_google_cloud_documentai_v1beta2_ProcessDocumentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta2.ProcessDocumentRequest.class,
            com.google.cloud.documentai.v1beta2.ProcessDocumentRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Target project and location to make a call.
   *
   * Format: `projects/{project-id}/locations/{location-id}`.
   *
   * If no location is specified, a region will be chosen automatically.
   * This field is only populated when used in ProcessDocument method.
   * </pre>
   *
   * <code>string parent = 9;</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Target project and location to make a call.
   *
   * Format: `projects/{project-id}/locations/{location-id}`.
   *
   * If no location is specified, a region will be chosen automatically.
   * This field is only populated when used in ProcessDocument method.
   * </pre>
   *
   * <code>string parent = 9;</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUT_CONFIG_FIELD_NUMBER = 1;
  private com.google.cloud.documentai.v1beta2.InputConfig inputConfig_;
  /**
   *
   *
   * <pre>
   * Required. Information about the input file.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta2.InputConfig input_config = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the inputConfig field is set.
   */
  @java.lang.Override
  public boolean hasInputConfig() {
    return inputConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Information about the input file.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta2.InputConfig input_config = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The inputConfig.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta2.InputConfig getInputConfig() {
    return inputConfig_ == null
        ? com.google.cloud.documentai.v1beta2.InputConfig.getDefaultInstance()
        : inputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. Information about the input file.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta2.InputConfig input_config = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta2.InputConfigOrBuilder getInputConfigOrBuilder() {
    return inputConfig_ == null
        ? com.google.cloud.documentai.v1beta2.InputConfig.getDefaultInstance()
        : inputConfig_;
  }

  public static final int OUTPUT_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.documentai.v1beta2.OutputConfig outputConfig_;
  /**
   *
   *
   * <pre>
   * The desired output location. This field is only needed in
   * BatchProcessDocumentsRequest.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta2.OutputConfig output_config = 2;</code>
   *
   * @return Whether the outputConfig field is set.
   */
  @java.lang.Override
  public boolean hasOutputConfig() {
    return outputConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * The desired output location. This field is only needed in
   * BatchProcessDocumentsRequest.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta2.OutputConfig output_config = 2;</code>
   *
   * @return The outputConfig.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta2.OutputConfig getOutputConfig() {
    return outputConfig_ == null
        ? com.google.cloud.documentai.v1beta2.OutputConfig.getDefaultInstance()
        : outputConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired output location. This field is only needed in
   * BatchProcessDocumentsRequest.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta2.OutputConfig output_config = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta2.OutputConfigOrBuilder getOutputConfigOrBuilder() {
    return outputConfig_ == null
        ? com.google.cloud.documentai.v1beta2.OutputConfig.getDefaultInstance()
        : outputConfig_;
  }

  public static final int DOCUMENT_TYPE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object documentType_ = "";
  /**
   *
   *
   * <pre>
   * Specifies a known document type for deeper structure detection. Valid
   * values are currently "general" and "invoice". If not provided, "general"&#92;
   * is used as default. If any other value is given, the request is rejected.
   * </pre>
   *
   * <code>string document_type = 3;</code>
   *
   * @return The documentType.
   */
  @java.lang.Override
  public java.lang.String getDocumentType() {
    java.lang.Object ref = documentType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      documentType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies a known document type for deeper structure detection. Valid
   * values are currently "general" and "invoice". If not provided, "general"&#92;
   * is used as default. If any other value is given, the request is rejected.
   * </pre>
   *
   * <code>string document_type = 3;</code>
   *
   * @return The bytes for documentType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDocumentTypeBytes() {
    java.lang.Object ref = documentType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      documentType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TABLE_EXTRACTION_PARAMS_FIELD_NUMBER = 4;
  private com.google.cloud.documentai.v1beta2.TableExtractionParams tableExtractionParams_;
  /**
   *
   *
   * <pre>
   * Controls table extraction behavior. If not specified, the system will
   * decide reasonable defaults.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta2.TableExtractionParams table_extraction_params = 4;
   * </code>
   *
   * @return Whether the tableExtractionParams field is set.
   */
  @java.lang.Override
  public boolean hasTableExtractionParams() {
    return tableExtractionParams_ != null;
  }
  /**
   *
   *
   * <pre>
   * Controls table extraction behavior. If not specified, the system will
   * decide reasonable defaults.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta2.TableExtractionParams table_extraction_params = 4;
   * </code>
   *
   * @return The tableExtractionParams.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta2.TableExtractionParams getTableExtractionParams() {
    return tableExtractionParams_ == null
        ? com.google.cloud.documentai.v1beta2.TableExtractionParams.getDefaultInstance()
        : tableExtractionParams_;
  }
  /**
   *
   *
   * <pre>
   * Controls table extraction behavior. If not specified, the system will
   * decide reasonable defaults.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta2.TableExtractionParams table_extraction_params = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta2.TableExtractionParamsOrBuilder
      getTableExtractionParamsOrBuilder() {
    return tableExtractionParams_ == null
        ? com.google.cloud.documentai.v1beta2.TableExtractionParams.getDefaultInstance()
        : tableExtractionParams_;
  }

  public static final int FORM_EXTRACTION_PARAMS_FIELD_NUMBER = 5;
  private com.google.cloud.documentai.v1beta2.FormExtractionParams formExtractionParams_;
  /**
   *
   *
   * <pre>
   * Controls form extraction behavior. If not specified, the system will
   * decide reasonable defaults.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta2.FormExtractionParams form_extraction_params = 5;</code>
   *
   * @return Whether the formExtractionParams field is set.
   */
  @java.lang.Override
  public boolean hasFormExtractionParams() {
    return formExtractionParams_ != null;
  }
  /**
   *
   *
   * <pre>
   * Controls form extraction behavior. If not specified, the system will
   * decide reasonable defaults.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta2.FormExtractionParams form_extraction_params = 5;</code>
   *
   * @return The formExtractionParams.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta2.FormExtractionParams getFormExtractionParams() {
    return formExtractionParams_ == null
        ? com.google.cloud.documentai.v1beta2.FormExtractionParams.getDefaultInstance()
        : formExtractionParams_;
  }
  /**
   *
   *
   * <pre>
   * Controls form extraction behavior. If not specified, the system will
   * decide reasonable defaults.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta2.FormExtractionParams form_extraction_params = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta2.FormExtractionParamsOrBuilder
      getFormExtractionParamsOrBuilder() {
    return formExtractionParams_ == null
        ? com.google.cloud.documentai.v1beta2.FormExtractionParams.getDefaultInstance()
        : formExtractionParams_;
  }

  public static final int ENTITY_EXTRACTION_PARAMS_FIELD_NUMBER = 6;
  private com.google.cloud.documentai.v1beta2.EntityExtractionParams entityExtractionParams_;
  /**
   *
   *
   * <pre>
   * Controls entity extraction behavior. If not specified, the system will
   * decide reasonable defaults.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta2.EntityExtractionParams entity_extraction_params = 6;
   * </code>
   *
   * @return Whether the entityExtractionParams field is set.
   */
  @java.lang.Override
  public boolean hasEntityExtractionParams() {
    return entityExtractionParams_ != null;
  }
  /**
   *
   *
   * <pre>
   * Controls entity extraction behavior. If not specified, the system will
   * decide reasonable defaults.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta2.EntityExtractionParams entity_extraction_params = 6;
   * </code>
   *
   * @return The entityExtractionParams.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta2.EntityExtractionParams getEntityExtractionParams() {
    return entityExtractionParams_ == null
        ? com.google.cloud.documentai.v1beta2.EntityExtractionParams.getDefaultInstance()
        : entityExtractionParams_;
  }
  /**
   *
   *
   * <pre>
   * Controls entity extraction behavior. If not specified, the system will
   * decide reasonable defaults.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta2.EntityExtractionParams entity_extraction_params = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta2.EntityExtractionParamsOrBuilder
      getEntityExtractionParamsOrBuilder() {
    return entityExtractionParams_ == null
        ? com.google.cloud.documentai.v1beta2.EntityExtractionParams.getDefaultInstance()
        : entityExtractionParams_;
  }

  public static final int OCR_PARAMS_FIELD_NUMBER = 7;
  private com.google.cloud.documentai.v1beta2.OcrParams ocrParams_;
  /**
   *
   *
   * <pre>
   * Controls OCR behavior. If not specified, the system will decide reasonable
   * defaults.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta2.OcrParams ocr_params = 7;</code>
   *
   * @return Whether the ocrParams field is set.
   */
  @java.lang.Override
  public boolean hasOcrParams() {
    return ocrParams_ != null;
  }
  /**
   *
   *
   * <pre>
   * Controls OCR behavior. If not specified, the system will decide reasonable
   * defaults.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta2.OcrParams ocr_params = 7;</code>
   *
   * @return The ocrParams.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta2.OcrParams getOcrParams() {
    return ocrParams_ == null
        ? com.google.cloud.documentai.v1beta2.OcrParams.getDefaultInstance()
        : ocrParams_;
  }
  /**
   *
   *
   * <pre>
   * Controls OCR behavior. If not specified, the system will decide reasonable
   * defaults.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta2.OcrParams ocr_params = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta2.OcrParamsOrBuilder getOcrParamsOrBuilder() {
    return ocrParams_ == null
        ? com.google.cloud.documentai.v1beta2.OcrParams.getDefaultInstance()
        : ocrParams_;
  }

  public static final int AUTOML_PARAMS_FIELD_NUMBER = 8;
  private com.google.cloud.documentai.v1beta2.AutoMlParams automlParams_;
  /**
   *
   *
   * <pre>
   * Controls AutoML model prediction behavior. AutoMlParams cannot be used
   * together with other Params.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta2.AutoMlParams automl_params = 8;</code>
   *
   * @return Whether the automlParams field is set.
   */
  @java.lang.Override
  public boolean hasAutomlParams() {
    return automlParams_ != null;
  }
  /**
   *
   *
   * <pre>
   * Controls AutoML model prediction behavior. AutoMlParams cannot be used
   * together with other Params.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta2.AutoMlParams automl_params = 8;</code>
   *
   * @return The automlParams.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta2.AutoMlParams getAutomlParams() {
    return automlParams_ == null
        ? com.google.cloud.documentai.v1beta2.AutoMlParams.getDefaultInstance()
        : automlParams_;
  }
  /**
   *
   *
   * <pre>
   * Controls AutoML model prediction behavior. AutoMlParams cannot be used
   * together with other Params.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta2.AutoMlParams automl_params = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta2.AutoMlParamsOrBuilder getAutomlParamsOrBuilder() {
    return automlParams_ == null
        ? com.google.cloud.documentai.v1beta2.AutoMlParams.getDefaultInstance()
        : automlParams_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (inputConfig_ != null) {
      output.writeMessage(1, getInputConfig());
    }
    if (outputConfig_ != null) {
      output.writeMessage(2, getOutputConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(documentType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, documentType_);
    }
    if (tableExtractionParams_ != null) {
      output.writeMessage(4, getTableExtractionParams());
    }
    if (formExtractionParams_ != null) {
      output.writeMessage(5, getFormExtractionParams());
    }
    if (entityExtractionParams_ != null) {
      output.writeMessage(6, getEntityExtractionParams());
    }
    if (ocrParams_ != null) {
      output.writeMessage(7, getOcrParams());
    }
    if (automlParams_ != null) {
      output.writeMessage(8, getAutomlParams());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, parent_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (inputConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getInputConfig());
    }
    if (outputConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOutputConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(documentType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, documentType_);
    }
    if (tableExtractionParams_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTableExtractionParams());
    }
    if (formExtractionParams_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, getFormExtractionParams());
    }
    if (entityExtractionParams_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(6, getEntityExtractionParams());
    }
    if (ocrParams_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getOcrParams());
    }
    if (automlParams_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getAutomlParams());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, parent_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta2.ProcessDocumentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta2.ProcessDocumentRequest other =
        (com.google.cloud.documentai.v1beta2.ProcessDocumentRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasInputConfig() != other.hasInputConfig()) return false;
    if (hasInputConfig()) {
      if (!getInputConfig().equals(other.getInputConfig())) return false;
    }
    if (hasOutputConfig() != other.hasOutputConfig()) return false;
    if (hasOutputConfig()) {
      if (!getOutputConfig().equals(other.getOutputConfig())) return false;
    }
    if (!getDocumentType().equals(other.getDocumentType())) return false;
    if (hasTableExtractionParams() != other.hasTableExtractionParams()) return false;
    if (hasTableExtractionParams()) {
      if (!getTableExtractionParams().equals(other.getTableExtractionParams())) return false;
    }
    if (hasFormExtractionParams() != other.hasFormExtractionParams()) return false;
    if (hasFormExtractionParams()) {
      if (!getFormExtractionParams().equals(other.getFormExtractionParams())) return false;
    }
    if (hasEntityExtractionParams() != other.hasEntityExtractionParams()) return false;
    if (hasEntityExtractionParams()) {
      if (!getEntityExtractionParams().equals(other.getEntityExtractionParams())) return false;
    }
    if (hasOcrParams() != other.hasOcrParams()) return false;
    if (hasOcrParams()) {
      if (!getOcrParams().equals(other.getOcrParams())) return false;
    }
    if (hasAutomlParams() != other.hasAutomlParams()) return false;
    if (hasAutomlParams()) {
      if (!getAutomlParams().equals(other.getAutomlParams())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasInputConfig()) {
      hash = (37 * hash) + INPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInputConfig().hashCode();
    }
    if (hasOutputConfig()) {
      hash = (37 * hash) + OUTPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOutputConfig().hashCode();
    }
    hash = (37 * hash) + DOCUMENT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getDocumentType().hashCode();
    if (hasTableExtractionParams()) {
      hash = (37 * hash) + TABLE_EXTRACTION_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getTableExtractionParams().hashCode();
    }
    if (hasFormExtractionParams()) {
      hash = (37 * hash) + FORM_EXTRACTION_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getFormExtractionParams().hashCode();
    }
    if (hasEntityExtractionParams()) {
      hash = (37 * hash) + ENTITY_EXTRACTION_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getEntityExtractionParams().hashCode();
    }
    if (hasOcrParams()) {
      hash = (37 * hash) + OCR_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getOcrParams().hashCode();
    }
    if (hasAutomlParams()) {
      hash = (37 * hash) + AUTOML_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getAutomlParams().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta2.ProcessDocumentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta2.ProcessDocumentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta2.ProcessDocumentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta2.ProcessDocumentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta2.ProcessDocumentRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta2.ProcessDocumentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta2.ProcessDocumentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta2.ProcessDocumentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta2.ProcessDocumentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta2.ProcessDocumentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta2.ProcessDocumentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta2.ProcessDocumentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.documentai.v1beta2.ProcessDocumentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request to process one document.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta2.ProcessDocumentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta2.ProcessDocumentRequest)
      com.google.cloud.documentai.v1beta2.ProcessDocumentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta2.DocumentAiProto
          .internal_static_google_cloud_documentai_v1beta2_ProcessDocumentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta2.DocumentAiProto
          .internal_static_google_cloud_documentai_v1beta2_ProcessDocumentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta2.ProcessDocumentRequest.class,
              com.google.cloud.documentai.v1beta2.ProcessDocumentRequest.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta2.ProcessDocumentRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      inputConfig_ = null;
      if (inputConfigBuilder_ != null) {
        inputConfigBuilder_.dispose();
        inputConfigBuilder_ = null;
      }
      outputConfig_ = null;
      if (outputConfigBuilder_ != null) {
        outputConfigBuilder_.dispose();
        outputConfigBuilder_ = null;
      }
      documentType_ = "";
      tableExtractionParams_ = null;
      if (tableExtractionParamsBuilder_ != null) {
        tableExtractionParamsBuilder_.dispose();
        tableExtractionParamsBuilder_ = null;
      }
      formExtractionParams_ = null;
      if (formExtractionParamsBuilder_ != null) {
        formExtractionParamsBuilder_.dispose();
        formExtractionParamsBuilder_ = null;
      }
      entityExtractionParams_ = null;
      if (entityExtractionParamsBuilder_ != null) {
        entityExtractionParamsBuilder_.dispose();
        entityExtractionParamsBuilder_ = null;
      }
      ocrParams_ = null;
      if (ocrParamsBuilder_ != null) {
        ocrParamsBuilder_.dispose();
        ocrParamsBuilder_ = null;
      }
      automlParams_ = null;
      if (automlParamsBuilder_ != null) {
        automlParamsBuilder_.dispose();
        automlParamsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta2.DocumentAiProto
          .internal_static_google_cloud_documentai_v1beta2_ProcessDocumentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta2.ProcessDocumentRequest getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta2.ProcessDocumentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta2.ProcessDocumentRequest build() {
      com.google.cloud.documentai.v1beta2.ProcessDocumentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta2.ProcessDocumentRequest buildPartial() {
      com.google.cloud.documentai.v1beta2.ProcessDocumentRequest result =
          new com.google.cloud.documentai.v1beta2.ProcessDocumentRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta2.ProcessDocumentRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.inputConfig_ =
            inputConfigBuilder_ == null ? inputConfig_ : inputConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.outputConfig_ =
            outputConfigBuilder_ == null ? outputConfig_ : outputConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.documentType_ = documentType_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.tableExtractionParams_ =
            tableExtractionParamsBuilder_ == null
                ? tableExtractionParams_
                : tableExtractionParamsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.formExtractionParams_ =
            formExtractionParamsBuilder_ == null
                ? formExtractionParams_
                : formExtractionParamsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.entityExtractionParams_ =
            entityExtractionParamsBuilder_ == null
                ? entityExtractionParams_
                : entityExtractionParamsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.ocrParams_ = ocrParamsBuilder_ == null ? ocrParams_ : ocrParamsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.automlParams_ =
            automlParamsBuilder_ == null ? automlParams_ : automlParamsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta2.ProcessDocumentRequest) {
        return mergeFrom((com.google.cloud.documentai.v1beta2.ProcessDocumentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta2.ProcessDocumentRequest other) {
      if (other == com.google.cloud.documentai.v1beta2.ProcessDocumentRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasInputConfig()) {
        mergeInputConfig(other.getInputConfig());
      }
      if (other.hasOutputConfig()) {
        mergeOutputConfig(other.getOutputConfig());
      }
      if (!other.getDocumentType().isEmpty()) {
        documentType_ = other.documentType_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasTableExtractionParams()) {
        mergeTableExtractionParams(other.getTableExtractionParams());
      }
      if (other.hasFormExtractionParams()) {
        mergeFormExtractionParams(other.getFormExtractionParams());
      }
      if (other.hasEntityExtractionParams()) {
        mergeEntityExtractionParams(other.getEntityExtractionParams());
      }
      if (other.hasOcrParams()) {
        mergeOcrParams(other.getOcrParams());
      }
      if (other.hasAutomlParams()) {
        mergeAutomlParams(other.getAutomlParams());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getInputConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getOutputConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                documentType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getTableExtractionParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getFormExtractionParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getEntityExtractionParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getOcrParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getAutomlParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Target project and location to make a call.
     *
     * Format: `projects/{project-id}/locations/{location-id}`.
     *
     * If no location is specified, a region will be chosen automatically.
     * This field is only populated when used in ProcessDocument method.
     * </pre>
     *
     * <code>string parent = 9;</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Target project and location to make a call.
     *
     * Format: `projects/{project-id}/locations/{location-id}`.
     *
     * If no location is specified, a region will be chosen automatically.
     * This field is only populated when used in ProcessDocument method.
     * </pre>
     *
     * <code>string parent = 9;</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Target project and location to make a call.
     *
     * Format: `projects/{project-id}/locations/{location-id}`.
     *
     * If no location is specified, a region will be chosen automatically.
     * This field is only populated when used in ProcessDocument method.
     * </pre>
     *
     * <code>string parent = 9;</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target project and location to make a call.
     *
     * Format: `projects/{project-id}/locations/{location-id}`.
     *
     * If no location is specified, a region will be chosen automatically.
     * This field is only populated when used in ProcessDocument method.
     * </pre>
     *
     * <code>string parent = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target project and location to make a call.
     *
     * Format: `projects/{project-id}/locations/{location-id}`.
     *
     * If no location is specified, a region will be chosen automatically.
     * This field is only populated when used in ProcessDocument method.
     * </pre>
     *
     * <code>string parent = 9;</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.documentai.v1beta2.InputConfig inputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta2.InputConfig,
            com.google.cloud.documentai.v1beta2.InputConfig.Builder,
            com.google.cloud.documentai.v1beta2.InputConfigOrBuilder>
        inputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Information about the input file.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta2.InputConfig input_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the inputConfig field is set.
     */
    public boolean hasInputConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the input file.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta2.InputConfig input_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The inputConfig.
     */
    public com.google.cloud.documentai.v1beta2.InputConfig getInputConfig() {
      if (inputConfigBuilder_ == null) {
        return inputConfig_ == null
            ? com.google.cloud.documentai.v1beta2.InputConfig.getDefaultInstance()
            : inputConfig_;
      } else {
        return inputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the input file.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta2.InputConfig input_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInputConfig(com.google.cloud.documentai.v1beta2.InputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputConfig_ = value;
      } else {
        inputConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the input file.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta2.InputConfig input_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInputConfig(
        com.google.cloud.documentai.v1beta2.InputConfig.Builder builderForValue) {
      if (inputConfigBuilder_ == null) {
        inputConfig_ = builderForValue.build();
      } else {
        inputConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the input file.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta2.InputConfig input_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeInputConfig(com.google.cloud.documentai.v1beta2.InputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && inputConfig_ != null
            && inputConfig_
                != com.google.cloud.documentai.v1beta2.InputConfig.getDefaultInstance()) {
          getInputConfigBuilder().mergeFrom(value);
        } else {
          inputConfig_ = value;
        }
      } else {
        inputConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the input file.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta2.InputConfig input_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearInputConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      inputConfig_ = null;
      if (inputConfigBuilder_ != null) {
        inputConfigBuilder_.dispose();
        inputConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the input file.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta2.InputConfig input_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.documentai.v1beta2.InputConfig.Builder getInputConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getInputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the input file.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta2.InputConfig input_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.documentai.v1beta2.InputConfigOrBuilder getInputConfigOrBuilder() {
      if (inputConfigBuilder_ != null) {
        return inputConfigBuilder_.getMessageOrBuilder();
      } else {
        return inputConfig_ == null
            ? com.google.cloud.documentai.v1beta2.InputConfig.getDefaultInstance()
            : inputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the input file.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta2.InputConfig input_config = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta2.InputConfig,
            com.google.cloud.documentai.v1beta2.InputConfig.Builder,
            com.google.cloud.documentai.v1beta2.InputConfigOrBuilder>
        getInputConfigFieldBuilder() {
      if (inputConfigBuilder_ == null) {
        inputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta2.InputConfig,
                com.google.cloud.documentai.v1beta2.InputConfig.Builder,
                com.google.cloud.documentai.v1beta2.InputConfigOrBuilder>(
                getInputConfig(), getParentForChildren(), isClean());
        inputConfig_ = null;
      }
      return inputConfigBuilder_;
    }

    private com.google.cloud.documentai.v1beta2.OutputConfig outputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta2.OutputConfig,
            com.google.cloud.documentai.v1beta2.OutputConfig.Builder,
            com.google.cloud.documentai.v1beta2.OutputConfigOrBuilder>
        outputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired output location. This field is only needed in
     * BatchProcessDocumentsRequest.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.OutputConfig output_config = 2;</code>
     *
     * @return Whether the outputConfig field is set.
     */
    public boolean hasOutputConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired output location. This field is only needed in
     * BatchProcessDocumentsRequest.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.OutputConfig output_config = 2;</code>
     *
     * @return The outputConfig.
     */
    public com.google.cloud.documentai.v1beta2.OutputConfig getOutputConfig() {
      if (outputConfigBuilder_ == null) {
        return outputConfig_ == null
            ? com.google.cloud.documentai.v1beta2.OutputConfig.getDefaultInstance()
            : outputConfig_;
      } else {
        return outputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired output location. This field is only needed in
     * BatchProcessDocumentsRequest.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.OutputConfig output_config = 2;</code>
     */
    public Builder setOutputConfig(com.google.cloud.documentai.v1beta2.OutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputConfig_ = value;
      } else {
        outputConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired output location. This field is only needed in
     * BatchProcessDocumentsRequest.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.OutputConfig output_config = 2;</code>
     */
    public Builder setOutputConfig(
        com.google.cloud.documentai.v1beta2.OutputConfig.Builder builderForValue) {
      if (outputConfigBuilder_ == null) {
        outputConfig_ = builderForValue.build();
      } else {
        outputConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired output location. This field is only needed in
     * BatchProcessDocumentsRequest.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.OutputConfig output_config = 2;</code>
     */
    public Builder mergeOutputConfig(com.google.cloud.documentai.v1beta2.OutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && outputConfig_ != null
            && outputConfig_
                != com.google.cloud.documentai.v1beta2.OutputConfig.getDefaultInstance()) {
          getOutputConfigBuilder().mergeFrom(value);
        } else {
          outputConfig_ = value;
        }
      } else {
        outputConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired output location. This field is only needed in
     * BatchProcessDocumentsRequest.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.OutputConfig output_config = 2;</code>
     */
    public Builder clearOutputConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      outputConfig_ = null;
      if (outputConfigBuilder_ != null) {
        outputConfigBuilder_.dispose();
        outputConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired output location. This field is only needed in
     * BatchProcessDocumentsRequest.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.OutputConfig output_config = 2;</code>
     */
    public com.google.cloud.documentai.v1beta2.OutputConfig.Builder getOutputConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getOutputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired output location. This field is only needed in
     * BatchProcessDocumentsRequest.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.OutputConfig output_config = 2;</code>
     */
    public com.google.cloud.documentai.v1beta2.OutputConfigOrBuilder getOutputConfigOrBuilder() {
      if (outputConfigBuilder_ != null) {
        return outputConfigBuilder_.getMessageOrBuilder();
      } else {
        return outputConfig_ == null
            ? com.google.cloud.documentai.v1beta2.OutputConfig.getDefaultInstance()
            : outputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired output location. This field is only needed in
     * BatchProcessDocumentsRequest.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.OutputConfig output_config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta2.OutputConfig,
            com.google.cloud.documentai.v1beta2.OutputConfig.Builder,
            com.google.cloud.documentai.v1beta2.OutputConfigOrBuilder>
        getOutputConfigFieldBuilder() {
      if (outputConfigBuilder_ == null) {
        outputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta2.OutputConfig,
                com.google.cloud.documentai.v1beta2.OutputConfig.Builder,
                com.google.cloud.documentai.v1beta2.OutputConfigOrBuilder>(
                getOutputConfig(), getParentForChildren(), isClean());
        outputConfig_ = null;
      }
      return outputConfigBuilder_;
    }

    private java.lang.Object documentType_ = "";
    /**
     *
     *
     * <pre>
     * Specifies a known document type for deeper structure detection. Valid
     * values are currently "general" and "invoice". If not provided, "general"&#92;
     * is used as default. If any other value is given, the request is rejected.
     * </pre>
     *
     * <code>string document_type = 3;</code>
     *
     * @return The documentType.
     */
    public java.lang.String getDocumentType() {
      java.lang.Object ref = documentType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        documentType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a known document type for deeper structure detection. Valid
     * values are currently "general" and "invoice". If not provided, "general"&#92;
     * is used as default. If any other value is given, the request is rejected.
     * </pre>
     *
     * <code>string document_type = 3;</code>
     *
     * @return The bytes for documentType.
     */
    public com.google.protobuf.ByteString getDocumentTypeBytes() {
      java.lang.Object ref = documentType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        documentType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a known document type for deeper structure detection. Valid
     * values are currently "general" and "invoice". If not provided, "general"&#92;
     * is used as default. If any other value is given, the request is rejected.
     * </pre>
     *
     * <code>string document_type = 3;</code>
     *
     * @param value The documentType to set.
     * @return This builder for chaining.
     */
    public Builder setDocumentType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      documentType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a known document type for deeper structure detection. Valid
     * values are currently "general" and "invoice". If not provided, "general"&#92;
     * is used as default. If any other value is given, the request is rejected.
     * </pre>
     *
     * <code>string document_type = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDocumentType() {
      documentType_ = getDefaultInstance().getDocumentType();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a known document type for deeper structure detection. Valid
     * values are currently "general" and "invoice". If not provided, "general"&#92;
     * is used as default. If any other value is given, the request is rejected.
     * </pre>
     *
     * <code>string document_type = 3;</code>
     *
     * @param value The bytes for documentType to set.
     * @return This builder for chaining.
     */
    public Builder setDocumentTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      documentType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.documentai.v1beta2.TableExtractionParams tableExtractionParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta2.TableExtractionParams,
            com.google.cloud.documentai.v1beta2.TableExtractionParams.Builder,
            com.google.cloud.documentai.v1beta2.TableExtractionParamsOrBuilder>
        tableExtractionParamsBuilder_;
    /**
     *
     *
     * <pre>
     * Controls table extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.TableExtractionParams table_extraction_params = 4;
     * </code>
     *
     * @return Whether the tableExtractionParams field is set.
     */
    public boolean hasTableExtractionParams() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Controls table extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.TableExtractionParams table_extraction_params = 4;
     * </code>
     *
     * @return The tableExtractionParams.
     */
    public com.google.cloud.documentai.v1beta2.TableExtractionParams getTableExtractionParams() {
      if (tableExtractionParamsBuilder_ == null) {
        return tableExtractionParams_ == null
            ? com.google.cloud.documentai.v1beta2.TableExtractionParams.getDefaultInstance()
            : tableExtractionParams_;
      } else {
        return tableExtractionParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Controls table extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.TableExtractionParams table_extraction_params = 4;
     * </code>
     */
    public Builder setTableExtractionParams(
        com.google.cloud.documentai.v1beta2.TableExtractionParams value) {
      if (tableExtractionParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tableExtractionParams_ = value;
      } else {
        tableExtractionParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls table extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.TableExtractionParams table_extraction_params = 4;
     * </code>
     */
    public Builder setTableExtractionParams(
        com.google.cloud.documentai.v1beta2.TableExtractionParams.Builder builderForValue) {
      if (tableExtractionParamsBuilder_ == null) {
        tableExtractionParams_ = builderForValue.build();
      } else {
        tableExtractionParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls table extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.TableExtractionParams table_extraction_params = 4;
     * </code>
     */
    public Builder mergeTableExtractionParams(
        com.google.cloud.documentai.v1beta2.TableExtractionParams value) {
      if (tableExtractionParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && tableExtractionParams_ != null
            && tableExtractionParams_
                != com.google.cloud.documentai.v1beta2.TableExtractionParams.getDefaultInstance()) {
          getTableExtractionParamsBuilder().mergeFrom(value);
        } else {
          tableExtractionParams_ = value;
        }
      } else {
        tableExtractionParamsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls table extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.TableExtractionParams table_extraction_params = 4;
     * </code>
     */
    public Builder clearTableExtractionParams() {
      bitField0_ = (bitField0_ & ~0x00000010);
      tableExtractionParams_ = null;
      if (tableExtractionParamsBuilder_ != null) {
        tableExtractionParamsBuilder_.dispose();
        tableExtractionParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls table extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.TableExtractionParams table_extraction_params = 4;
     * </code>
     */
    public com.google.cloud.documentai.v1beta2.TableExtractionParams.Builder
        getTableExtractionParamsBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getTableExtractionParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Controls table extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.TableExtractionParams table_extraction_params = 4;
     * </code>
     */
    public com.google.cloud.documentai.v1beta2.TableExtractionParamsOrBuilder
        getTableExtractionParamsOrBuilder() {
      if (tableExtractionParamsBuilder_ != null) {
        return tableExtractionParamsBuilder_.getMessageOrBuilder();
      } else {
        return tableExtractionParams_ == null
            ? com.google.cloud.documentai.v1beta2.TableExtractionParams.getDefaultInstance()
            : tableExtractionParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * Controls table extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.TableExtractionParams table_extraction_params = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta2.TableExtractionParams,
            com.google.cloud.documentai.v1beta2.TableExtractionParams.Builder,
            com.google.cloud.documentai.v1beta2.TableExtractionParamsOrBuilder>
        getTableExtractionParamsFieldBuilder() {
      if (tableExtractionParamsBuilder_ == null) {
        tableExtractionParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta2.TableExtractionParams,
                com.google.cloud.documentai.v1beta2.TableExtractionParams.Builder,
                com.google.cloud.documentai.v1beta2.TableExtractionParamsOrBuilder>(
                getTableExtractionParams(), getParentForChildren(), isClean());
        tableExtractionParams_ = null;
      }
      return tableExtractionParamsBuilder_;
    }

    private com.google.cloud.documentai.v1beta2.FormExtractionParams formExtractionParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta2.FormExtractionParams,
            com.google.cloud.documentai.v1beta2.FormExtractionParams.Builder,
            com.google.cloud.documentai.v1beta2.FormExtractionParamsOrBuilder>
        formExtractionParamsBuilder_;
    /**
     *
     *
     * <pre>
     * Controls form extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.FormExtractionParams form_extraction_params = 5;
     * </code>
     *
     * @return Whether the formExtractionParams field is set.
     */
    public boolean hasFormExtractionParams() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Controls form extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.FormExtractionParams form_extraction_params = 5;
     * </code>
     *
     * @return The formExtractionParams.
     */
    public com.google.cloud.documentai.v1beta2.FormExtractionParams getFormExtractionParams() {
      if (formExtractionParamsBuilder_ == null) {
        return formExtractionParams_ == null
            ? com.google.cloud.documentai.v1beta2.FormExtractionParams.getDefaultInstance()
            : formExtractionParams_;
      } else {
        return formExtractionParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Controls form extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.FormExtractionParams form_extraction_params = 5;
     * </code>
     */
    public Builder setFormExtractionParams(
        com.google.cloud.documentai.v1beta2.FormExtractionParams value) {
      if (formExtractionParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        formExtractionParams_ = value;
      } else {
        formExtractionParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls form extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.FormExtractionParams form_extraction_params = 5;
     * </code>
     */
    public Builder setFormExtractionParams(
        com.google.cloud.documentai.v1beta2.FormExtractionParams.Builder builderForValue) {
      if (formExtractionParamsBuilder_ == null) {
        formExtractionParams_ = builderForValue.build();
      } else {
        formExtractionParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls form extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.FormExtractionParams form_extraction_params = 5;
     * </code>
     */
    public Builder mergeFormExtractionParams(
        com.google.cloud.documentai.v1beta2.FormExtractionParams value) {
      if (formExtractionParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && formExtractionParams_ != null
            && formExtractionParams_
                != com.google.cloud.documentai.v1beta2.FormExtractionParams.getDefaultInstance()) {
          getFormExtractionParamsBuilder().mergeFrom(value);
        } else {
          formExtractionParams_ = value;
        }
      } else {
        formExtractionParamsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls form extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.FormExtractionParams form_extraction_params = 5;
     * </code>
     */
    public Builder clearFormExtractionParams() {
      bitField0_ = (bitField0_ & ~0x00000020);
      formExtractionParams_ = null;
      if (formExtractionParamsBuilder_ != null) {
        formExtractionParamsBuilder_.dispose();
        formExtractionParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls form extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.FormExtractionParams form_extraction_params = 5;
     * </code>
     */
    public com.google.cloud.documentai.v1beta2.FormExtractionParams.Builder
        getFormExtractionParamsBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getFormExtractionParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Controls form extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.FormExtractionParams form_extraction_params = 5;
     * </code>
     */
    public com.google.cloud.documentai.v1beta2.FormExtractionParamsOrBuilder
        getFormExtractionParamsOrBuilder() {
      if (formExtractionParamsBuilder_ != null) {
        return formExtractionParamsBuilder_.getMessageOrBuilder();
      } else {
        return formExtractionParams_ == null
            ? com.google.cloud.documentai.v1beta2.FormExtractionParams.getDefaultInstance()
            : formExtractionParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * Controls form extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.FormExtractionParams form_extraction_params = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta2.FormExtractionParams,
            com.google.cloud.documentai.v1beta2.FormExtractionParams.Builder,
            com.google.cloud.documentai.v1beta2.FormExtractionParamsOrBuilder>
        getFormExtractionParamsFieldBuilder() {
      if (formExtractionParamsBuilder_ == null) {
        formExtractionParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta2.FormExtractionParams,
                com.google.cloud.documentai.v1beta2.FormExtractionParams.Builder,
                com.google.cloud.documentai.v1beta2.FormExtractionParamsOrBuilder>(
                getFormExtractionParams(), getParentForChildren(), isClean());
        formExtractionParams_ = null;
      }
      return formExtractionParamsBuilder_;
    }

    private com.google.cloud.documentai.v1beta2.EntityExtractionParams entityExtractionParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta2.EntityExtractionParams,
            com.google.cloud.documentai.v1beta2.EntityExtractionParams.Builder,
            com.google.cloud.documentai.v1beta2.EntityExtractionParamsOrBuilder>
        entityExtractionParamsBuilder_;
    /**
     *
     *
     * <pre>
     * Controls entity extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.EntityExtractionParams entity_extraction_params = 6;
     * </code>
     *
     * @return Whether the entityExtractionParams field is set.
     */
    public boolean hasEntityExtractionParams() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Controls entity extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.EntityExtractionParams entity_extraction_params = 6;
     * </code>
     *
     * @return The entityExtractionParams.
     */
    public com.google.cloud.documentai.v1beta2.EntityExtractionParams getEntityExtractionParams() {
      if (entityExtractionParamsBuilder_ == null) {
        return entityExtractionParams_ == null
            ? com.google.cloud.documentai.v1beta2.EntityExtractionParams.getDefaultInstance()
            : entityExtractionParams_;
      } else {
        return entityExtractionParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Controls entity extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.EntityExtractionParams entity_extraction_params = 6;
     * </code>
     */
    public Builder setEntityExtractionParams(
        com.google.cloud.documentai.v1beta2.EntityExtractionParams value) {
      if (entityExtractionParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entityExtractionParams_ = value;
      } else {
        entityExtractionParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls entity extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.EntityExtractionParams entity_extraction_params = 6;
     * </code>
     */
    public Builder setEntityExtractionParams(
        com.google.cloud.documentai.v1beta2.EntityExtractionParams.Builder builderForValue) {
      if (entityExtractionParamsBuilder_ == null) {
        entityExtractionParams_ = builderForValue.build();
      } else {
        entityExtractionParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls entity extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.EntityExtractionParams entity_extraction_params = 6;
     * </code>
     */
    public Builder mergeEntityExtractionParams(
        com.google.cloud.documentai.v1beta2.EntityExtractionParams value) {
      if (entityExtractionParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && entityExtractionParams_ != null
            && entityExtractionParams_
                != com.google.cloud.documentai.v1beta2.EntityExtractionParams
                    .getDefaultInstance()) {
          getEntityExtractionParamsBuilder().mergeFrom(value);
        } else {
          entityExtractionParams_ = value;
        }
      } else {
        entityExtractionParamsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls entity extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.EntityExtractionParams entity_extraction_params = 6;
     * </code>
     */
    public Builder clearEntityExtractionParams() {
      bitField0_ = (bitField0_ & ~0x00000040);
      entityExtractionParams_ = null;
      if (entityExtractionParamsBuilder_ != null) {
        entityExtractionParamsBuilder_.dispose();
        entityExtractionParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls entity extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.EntityExtractionParams entity_extraction_params = 6;
     * </code>
     */
    public com.google.cloud.documentai.v1beta2.EntityExtractionParams.Builder
        getEntityExtractionParamsBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getEntityExtractionParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Controls entity extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.EntityExtractionParams entity_extraction_params = 6;
     * </code>
     */
    public com.google.cloud.documentai.v1beta2.EntityExtractionParamsOrBuilder
        getEntityExtractionParamsOrBuilder() {
      if (entityExtractionParamsBuilder_ != null) {
        return entityExtractionParamsBuilder_.getMessageOrBuilder();
      } else {
        return entityExtractionParams_ == null
            ? com.google.cloud.documentai.v1beta2.EntityExtractionParams.getDefaultInstance()
            : entityExtractionParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * Controls entity extraction behavior. If not specified, the system will
     * decide reasonable defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.EntityExtractionParams entity_extraction_params = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta2.EntityExtractionParams,
            com.google.cloud.documentai.v1beta2.EntityExtractionParams.Builder,
            com.google.cloud.documentai.v1beta2.EntityExtractionParamsOrBuilder>
        getEntityExtractionParamsFieldBuilder() {
      if (entityExtractionParamsBuilder_ == null) {
        entityExtractionParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta2.EntityExtractionParams,
                com.google.cloud.documentai.v1beta2.EntityExtractionParams.Builder,
                com.google.cloud.documentai.v1beta2.EntityExtractionParamsOrBuilder>(
                getEntityExtractionParams(), getParentForChildren(), isClean());
        entityExtractionParams_ = null;
      }
      return entityExtractionParamsBuilder_;
    }

    private com.google.cloud.documentai.v1beta2.OcrParams ocrParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta2.OcrParams,
            com.google.cloud.documentai.v1beta2.OcrParams.Builder,
            com.google.cloud.documentai.v1beta2.OcrParamsOrBuilder>
        ocrParamsBuilder_;
    /**
     *
     *
     * <pre>
     * Controls OCR behavior. If not specified, the system will decide reasonable
     * defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.OcrParams ocr_params = 7;</code>
     *
     * @return Whether the ocrParams field is set.
     */
    public boolean hasOcrParams() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Controls OCR behavior. If not specified, the system will decide reasonable
     * defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.OcrParams ocr_params = 7;</code>
     *
     * @return The ocrParams.
     */
    public com.google.cloud.documentai.v1beta2.OcrParams getOcrParams() {
      if (ocrParamsBuilder_ == null) {
        return ocrParams_ == null
            ? com.google.cloud.documentai.v1beta2.OcrParams.getDefaultInstance()
            : ocrParams_;
      } else {
        return ocrParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Controls OCR behavior. If not specified, the system will decide reasonable
     * defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.OcrParams ocr_params = 7;</code>
     */
    public Builder setOcrParams(com.google.cloud.documentai.v1beta2.OcrParams value) {
      if (ocrParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ocrParams_ = value;
      } else {
        ocrParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls OCR behavior. If not specified, the system will decide reasonable
     * defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.OcrParams ocr_params = 7;</code>
     */
    public Builder setOcrParams(
        com.google.cloud.documentai.v1beta2.OcrParams.Builder builderForValue) {
      if (ocrParamsBuilder_ == null) {
        ocrParams_ = builderForValue.build();
      } else {
        ocrParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls OCR behavior. If not specified, the system will decide reasonable
     * defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.OcrParams ocr_params = 7;</code>
     */
    public Builder mergeOcrParams(com.google.cloud.documentai.v1beta2.OcrParams value) {
      if (ocrParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && ocrParams_ != null
            && ocrParams_ != com.google.cloud.documentai.v1beta2.OcrParams.getDefaultInstance()) {
          getOcrParamsBuilder().mergeFrom(value);
        } else {
          ocrParams_ = value;
        }
      } else {
        ocrParamsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls OCR behavior. If not specified, the system will decide reasonable
     * defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.OcrParams ocr_params = 7;</code>
     */
    public Builder clearOcrParams() {
      bitField0_ = (bitField0_ & ~0x00000080);
      ocrParams_ = null;
      if (ocrParamsBuilder_ != null) {
        ocrParamsBuilder_.dispose();
        ocrParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls OCR behavior. If not specified, the system will decide reasonable
     * defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.OcrParams ocr_params = 7;</code>
     */
    public com.google.cloud.documentai.v1beta2.OcrParams.Builder getOcrParamsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getOcrParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Controls OCR behavior. If not specified, the system will decide reasonable
     * defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.OcrParams ocr_params = 7;</code>
     */
    public com.google.cloud.documentai.v1beta2.OcrParamsOrBuilder getOcrParamsOrBuilder() {
      if (ocrParamsBuilder_ != null) {
        return ocrParamsBuilder_.getMessageOrBuilder();
      } else {
        return ocrParams_ == null
            ? com.google.cloud.documentai.v1beta2.OcrParams.getDefaultInstance()
            : ocrParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * Controls OCR behavior. If not specified, the system will decide reasonable
     * defaults.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.OcrParams ocr_params = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta2.OcrParams,
            com.google.cloud.documentai.v1beta2.OcrParams.Builder,
            com.google.cloud.documentai.v1beta2.OcrParamsOrBuilder>
        getOcrParamsFieldBuilder() {
      if (ocrParamsBuilder_ == null) {
        ocrParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta2.OcrParams,
                com.google.cloud.documentai.v1beta2.OcrParams.Builder,
                com.google.cloud.documentai.v1beta2.OcrParamsOrBuilder>(
                getOcrParams(), getParentForChildren(), isClean());
        ocrParams_ = null;
      }
      return ocrParamsBuilder_;
    }

    private com.google.cloud.documentai.v1beta2.AutoMlParams automlParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta2.AutoMlParams,
            com.google.cloud.documentai.v1beta2.AutoMlParams.Builder,
            com.google.cloud.documentai.v1beta2.AutoMlParamsOrBuilder>
        automlParamsBuilder_;
    /**
     *
     *
     * <pre>
     * Controls AutoML model prediction behavior. AutoMlParams cannot be used
     * together with other Params.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.AutoMlParams automl_params = 8;</code>
     *
     * @return Whether the automlParams field is set.
     */
    public boolean hasAutomlParams() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Controls AutoML model prediction behavior. AutoMlParams cannot be used
     * together with other Params.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.AutoMlParams automl_params = 8;</code>
     *
     * @return The automlParams.
     */
    public com.google.cloud.documentai.v1beta2.AutoMlParams getAutomlParams() {
      if (automlParamsBuilder_ == null) {
        return automlParams_ == null
            ? com.google.cloud.documentai.v1beta2.AutoMlParams.getDefaultInstance()
            : automlParams_;
      } else {
        return automlParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Controls AutoML model prediction behavior. AutoMlParams cannot be used
     * together with other Params.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.AutoMlParams automl_params = 8;</code>
     */
    public Builder setAutomlParams(com.google.cloud.documentai.v1beta2.AutoMlParams value) {
      if (automlParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        automlParams_ = value;
      } else {
        automlParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls AutoML model prediction behavior. AutoMlParams cannot be used
     * together with other Params.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.AutoMlParams automl_params = 8;</code>
     */
    public Builder setAutomlParams(
        com.google.cloud.documentai.v1beta2.AutoMlParams.Builder builderForValue) {
      if (automlParamsBuilder_ == null) {
        automlParams_ = builderForValue.build();
      } else {
        automlParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls AutoML model prediction behavior. AutoMlParams cannot be used
     * together with other Params.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.AutoMlParams automl_params = 8;</code>
     */
    public Builder mergeAutomlParams(com.google.cloud.documentai.v1beta2.AutoMlParams value) {
      if (automlParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && automlParams_ != null
            && automlParams_
                != com.google.cloud.documentai.v1beta2.AutoMlParams.getDefaultInstance()) {
          getAutomlParamsBuilder().mergeFrom(value);
        } else {
          automlParams_ = value;
        }
      } else {
        automlParamsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls AutoML model prediction behavior. AutoMlParams cannot be used
     * together with other Params.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.AutoMlParams automl_params = 8;</code>
     */
    public Builder clearAutomlParams() {
      bitField0_ = (bitField0_ & ~0x00000100);
      automlParams_ = null;
      if (automlParamsBuilder_ != null) {
        automlParamsBuilder_.dispose();
        automlParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls AutoML model prediction behavior. AutoMlParams cannot be used
     * together with other Params.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.AutoMlParams automl_params = 8;</code>
     */
    public com.google.cloud.documentai.v1beta2.AutoMlParams.Builder getAutomlParamsBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getAutomlParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Controls AutoML model prediction behavior. AutoMlParams cannot be used
     * together with other Params.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.AutoMlParams automl_params = 8;</code>
     */
    public com.google.cloud.documentai.v1beta2.AutoMlParamsOrBuilder getAutomlParamsOrBuilder() {
      if (automlParamsBuilder_ != null) {
        return automlParamsBuilder_.getMessageOrBuilder();
      } else {
        return automlParams_ == null
            ? com.google.cloud.documentai.v1beta2.AutoMlParams.getDefaultInstance()
            : automlParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * Controls AutoML model prediction behavior. AutoMlParams cannot be used
     * together with other Params.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta2.AutoMlParams automl_params = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta2.AutoMlParams,
            com.google.cloud.documentai.v1beta2.AutoMlParams.Builder,
            com.google.cloud.documentai.v1beta2.AutoMlParamsOrBuilder>
        getAutomlParamsFieldBuilder() {
      if (automlParamsBuilder_ == null) {
        automlParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta2.AutoMlParams,
                com.google.cloud.documentai.v1beta2.AutoMlParams.Builder,
                com.google.cloud.documentai.v1beta2.AutoMlParamsOrBuilder>(
                getAutomlParams(), getParentForChildren(), isClean());
        automlParams_ = null;
      }
      return automlParamsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta2.ProcessDocumentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta2.ProcessDocumentRequest)
  private static final com.google.cloud.documentai.v1beta2.ProcessDocumentRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta2.ProcessDocumentRequest();
  }

  public static com.google.cloud.documentai.v1beta2.ProcessDocumentRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ProcessDocumentRequest> PARSER =
      new com.google.protobuf.AbstractParser<ProcessDocumentRequest>() {
        @java.lang.Override
        public ProcessDocumentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ProcessDocumentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ProcessDocumentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta2.ProcessDocumentRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
