/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta2/document_understanding.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.documentai.v1beta2;

/**
 *
 *
 * <pre>
 * Parameters to control table extraction behavior.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta2.TableExtractionParams}
 */
public final class TableExtractionParams extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta2.TableExtractionParams)
    TableExtractionParamsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TableExtractionParams.newBuilder() to construct.
  private TableExtractionParams(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TableExtractionParams() {
    tableBoundHints_ = java.util.Collections.emptyList();
    headerHints_ = com.google.protobuf.LazyStringArrayList.emptyList();
    modelVersion_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TableExtractionParams();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta2.DocumentAiProto
        .internal_static_google_cloud_documentai_v1beta2_TableExtractionParams_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta2.DocumentAiProto
        .internal_static_google_cloud_documentai_v1beta2_TableExtractionParams_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta2.TableExtractionParams.class,
            com.google.cloud.documentai.v1beta2.TableExtractionParams.Builder.class);
  }

  public static final int ENABLED_FIELD_NUMBER = 1;
  private boolean enabled_ = false;
  /**
   *
   *
   * <pre>
   * Whether to enable table extraction.
   * </pre>
   *
   * <code>bool enabled = 1;</code>
   *
   * @return The enabled.
   */
  @java.lang.Override
  public boolean getEnabled() {
    return enabled_;
  }

  public static final int TABLE_BOUND_HINTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.documentai.v1beta2.TableBoundHint> tableBoundHints_;
  /**
   *
   *
   * <pre>
   * Optional. Table bounding box hints that can be provided to complex cases
   * which our algorithm cannot locate the table(s) in.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.documentai.v1beta2.TableBoundHint>
      getTableBoundHintsList() {
    return tableBoundHints_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Table bounding box hints that can be provided to complex cases
   * which our algorithm cannot locate the table(s) in.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.documentai.v1beta2.TableBoundHintOrBuilder>
      getTableBoundHintsOrBuilderList() {
    return tableBoundHints_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Table bounding box hints that can be provided to complex cases
   * which our algorithm cannot locate the table(s) in.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getTableBoundHintsCount() {
    return tableBoundHints_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Table bounding box hints that can be provided to complex cases
   * which our algorithm cannot locate the table(s) in.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta2.TableBoundHint getTableBoundHints(int index) {
    return tableBoundHints_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Table bounding box hints that can be provided to complex cases
   * which our algorithm cannot locate the table(s) in.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta2.TableBoundHintOrBuilder getTableBoundHintsOrBuilder(
      int index) {
    return tableBoundHints_.get(index);
  }

  public static final int HEADER_HINTS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList headerHints_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Reserved for future use.
   * </pre>
   *
   * <code>repeated string header_hints = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the headerHints.
   */
  public com.google.protobuf.ProtocolStringList getHeaderHintsList() {
    return headerHints_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Reserved for future use.
   * </pre>
   *
   * <code>repeated string header_hints = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of headerHints.
   */
  public int getHeaderHintsCount() {
    return headerHints_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Reserved for future use.
   * </pre>
   *
   * <code>repeated string header_hints = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The headerHints at the given index.
   */
  public java.lang.String getHeaderHints(int index) {
    return headerHints_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Reserved for future use.
   * </pre>
   *
   * <code>repeated string header_hints = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the headerHints at the given index.
   */
  public com.google.protobuf.ByteString getHeaderHintsBytes(int index) {
    return headerHints_.getByteString(index);
  }

  public static final int MODEL_VERSION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelVersion_ = "";
  /**
   *
   *
   * <pre>
   * Model version of the table extraction system. Default is "builtin/stable".
   * Specify "builtin/latest" for the latest model.
   * </pre>
   *
   * <code>string model_version = 4;</code>
   *
   * @return The modelVersion.
   */
  @java.lang.Override
  public java.lang.String getModelVersion() {
    java.lang.Object ref = modelVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Model version of the table extraction system. Default is "builtin/stable".
   * Specify "builtin/latest" for the latest model.
   * </pre>
   *
   * <code>string model_version = 4;</code>
   *
   * @return The bytes for modelVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelVersionBytes() {
    java.lang.Object ref = modelVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (enabled_ != false) {
      output.writeBool(1, enabled_);
    }
    for (int i = 0; i < tableBoundHints_.size(); i++) {
      output.writeMessage(2, tableBoundHints_.get(i));
    }
    for (int i = 0; i < headerHints_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, headerHints_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, modelVersion_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (enabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
    }
    for (int i = 0; i < tableBoundHints_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, tableBoundHints_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < headerHints_.size(); i++) {
        dataSize += computeStringSizeNoTag(headerHints_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getHeaderHintsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, modelVersion_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta2.TableExtractionParams)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta2.TableExtractionParams other =
        (com.google.cloud.documentai.v1beta2.TableExtractionParams) obj;

    if (getEnabled() != other.getEnabled()) return false;
    if (!getTableBoundHintsList().equals(other.getTableBoundHintsList())) return false;
    if (!getHeaderHintsList().equals(other.getHeaderHintsList())) return false;
    if (!getModelVersion().equals(other.getModelVersion())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
    if (getTableBoundHintsCount() > 0) {
      hash = (37 * hash) + TABLE_BOUND_HINTS_FIELD_NUMBER;
      hash = (53 * hash) + getTableBoundHintsList().hashCode();
    }
    if (getHeaderHintsCount() > 0) {
      hash = (37 * hash) + HEADER_HINTS_FIELD_NUMBER;
      hash = (53 * hash) + getHeaderHintsList().hashCode();
    }
    hash = (37 * hash) + MODEL_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getModelVersion().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta2.TableExtractionParams parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta2.TableExtractionParams parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta2.TableExtractionParams parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta2.TableExtractionParams parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta2.TableExtractionParams parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta2.TableExtractionParams parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta2.TableExtractionParams parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta2.TableExtractionParams parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta2.TableExtractionParams parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta2.TableExtractionParams parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta2.TableExtractionParams parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta2.TableExtractionParams parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.documentai.v1beta2.TableExtractionParams prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Parameters to control table extraction behavior.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta2.TableExtractionParams}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta2.TableExtractionParams)
      com.google.cloud.documentai.v1beta2.TableExtractionParamsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta2.DocumentAiProto
          .internal_static_google_cloud_documentai_v1beta2_TableExtractionParams_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta2.DocumentAiProto
          .internal_static_google_cloud_documentai_v1beta2_TableExtractionParams_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta2.TableExtractionParams.class,
              com.google.cloud.documentai.v1beta2.TableExtractionParams.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta2.TableExtractionParams.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      enabled_ = false;
      if (tableBoundHintsBuilder_ == null) {
        tableBoundHints_ = java.util.Collections.emptyList();
      } else {
        tableBoundHints_ = null;
        tableBoundHintsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      headerHints_ = com.google.protobuf.LazyStringArrayList.emptyList();
      modelVersion_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta2.DocumentAiProto
          .internal_static_google_cloud_documentai_v1beta2_TableExtractionParams_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta2.TableExtractionParams getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta2.TableExtractionParams.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta2.TableExtractionParams build() {
      com.google.cloud.documentai.v1beta2.TableExtractionParams result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta2.TableExtractionParams buildPartial() {
      com.google.cloud.documentai.v1beta2.TableExtractionParams result =
          new com.google.cloud.documentai.v1beta2.TableExtractionParams(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.documentai.v1beta2.TableExtractionParams result) {
      if (tableBoundHintsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          tableBoundHints_ = java.util.Collections.unmodifiableList(tableBoundHints_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.tableBoundHints_ = tableBoundHints_;
      } else {
        result.tableBoundHints_ = tableBoundHintsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta2.TableExtractionParams result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.enabled_ = enabled_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        headerHints_.makeImmutable();
        result.headerHints_ = headerHints_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.modelVersion_ = modelVersion_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta2.TableExtractionParams) {
        return mergeFrom((com.google.cloud.documentai.v1beta2.TableExtractionParams) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta2.TableExtractionParams other) {
      if (other == com.google.cloud.documentai.v1beta2.TableExtractionParams.getDefaultInstance())
        return this;
      if (other.getEnabled() != false) {
        setEnabled(other.getEnabled());
      }
      if (tableBoundHintsBuilder_ == null) {
        if (!other.tableBoundHints_.isEmpty()) {
          if (tableBoundHints_.isEmpty()) {
            tableBoundHints_ = other.tableBoundHints_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureTableBoundHintsIsMutable();
            tableBoundHints_.addAll(other.tableBoundHints_);
          }
          onChanged();
        }
      } else {
        if (!other.tableBoundHints_.isEmpty()) {
          if (tableBoundHintsBuilder_.isEmpty()) {
            tableBoundHintsBuilder_.dispose();
            tableBoundHintsBuilder_ = null;
            tableBoundHints_ = other.tableBoundHints_;
            bitField0_ = (bitField0_ & ~0x00000002);
            tableBoundHintsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTableBoundHintsFieldBuilder()
                    : null;
          } else {
            tableBoundHintsBuilder_.addAllMessages(other.tableBoundHints_);
          }
        }
      }
      if (!other.headerHints_.isEmpty()) {
        if (headerHints_.isEmpty()) {
          headerHints_ = other.headerHints_;
          bitField0_ |= 0x00000004;
        } else {
          ensureHeaderHintsIsMutable();
          headerHints_.addAll(other.headerHints_);
        }
        onChanged();
      }
      if (!other.getModelVersion().isEmpty()) {
        modelVersion_ = other.modelVersion_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                enabled_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                com.google.cloud.documentai.v1beta2.TableBoundHint m =
                    input.readMessage(
                        com.google.cloud.documentai.v1beta2.TableBoundHint.parser(),
                        extensionRegistry);
                if (tableBoundHintsBuilder_ == null) {
                  ensureTableBoundHintsIsMutable();
                  tableBoundHints_.add(m);
                } else {
                  tableBoundHintsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureHeaderHintsIsMutable();
                headerHints_.add(s);
                break;
              } // case 26
            case 34:
              {
                modelVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean enabled_;
    /**
     *
     *
     * <pre>
     * Whether to enable table extraction.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }
    /**
     *
     *
     * <pre>
     * Whether to enable table extraction.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @param value The enabled to set.
     * @return This builder for chaining.
     */
    public Builder setEnabled(boolean value) {

      enabled_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to enable table extraction.
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnabled() {
      bitField0_ = (bitField0_ & ~0x00000001);
      enabled_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.documentai.v1beta2.TableBoundHint> tableBoundHints_ =
        java.util.Collections.emptyList();

    private void ensureTableBoundHintsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        tableBoundHints_ =
            new java.util.ArrayList<com.google.cloud.documentai.v1beta2.TableBoundHint>(
                tableBoundHints_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta2.TableBoundHint,
            com.google.cloud.documentai.v1beta2.TableBoundHint.Builder,
            com.google.cloud.documentai.v1beta2.TableBoundHintOrBuilder>
        tableBoundHintsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Table bounding box hints that can be provided to complex cases
     * which our algorithm cannot locate the table(s) in.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.documentai.v1beta2.TableBoundHint>
        getTableBoundHintsList() {
      if (tableBoundHintsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tableBoundHints_);
      } else {
        return tableBoundHintsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Table bounding box hints that can be provided to complex cases
     * which our algorithm cannot locate the table(s) in.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getTableBoundHintsCount() {
      if (tableBoundHintsBuilder_ == null) {
        return tableBoundHints_.size();
      } else {
        return tableBoundHintsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Table bounding box hints that can be provided to complex cases
     * which our algorithm cannot locate the table(s) in.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.documentai.v1beta2.TableBoundHint getTableBoundHints(int index) {
      if (tableBoundHintsBuilder_ == null) {
        return tableBoundHints_.get(index);
      } else {
        return tableBoundHintsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Table bounding box hints that can be provided to complex cases
     * which our algorithm cannot locate the table(s) in.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTableBoundHints(
        int index, com.google.cloud.documentai.v1beta2.TableBoundHint value) {
      if (tableBoundHintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTableBoundHintsIsMutable();
        tableBoundHints_.set(index, value);
        onChanged();
      } else {
        tableBoundHintsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Table bounding box hints that can be provided to complex cases
     * which our algorithm cannot locate the table(s) in.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTableBoundHints(
        int index, com.google.cloud.documentai.v1beta2.TableBoundHint.Builder builderForValue) {
      if (tableBoundHintsBuilder_ == null) {
        ensureTableBoundHintsIsMutable();
        tableBoundHints_.set(index, builderForValue.build());
        onChanged();
      } else {
        tableBoundHintsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Table bounding box hints that can be provided to complex cases
     * which our algorithm cannot locate the table(s) in.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addTableBoundHints(com.google.cloud.documentai.v1beta2.TableBoundHint value) {
      if (tableBoundHintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTableBoundHintsIsMutable();
        tableBoundHints_.add(value);
        onChanged();
      } else {
        tableBoundHintsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Table bounding box hints that can be provided to complex cases
     * which our algorithm cannot locate the table(s) in.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addTableBoundHints(
        int index, com.google.cloud.documentai.v1beta2.TableBoundHint value) {
      if (tableBoundHintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTableBoundHintsIsMutable();
        tableBoundHints_.add(index, value);
        onChanged();
      } else {
        tableBoundHintsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Table bounding box hints that can be provided to complex cases
     * which our algorithm cannot locate the table(s) in.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addTableBoundHints(
        com.google.cloud.documentai.v1beta2.TableBoundHint.Builder builderForValue) {
      if (tableBoundHintsBuilder_ == null) {
        ensureTableBoundHintsIsMutable();
        tableBoundHints_.add(builderForValue.build());
        onChanged();
      } else {
        tableBoundHintsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Table bounding box hints that can be provided to complex cases
     * which our algorithm cannot locate the table(s) in.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addTableBoundHints(
        int index, com.google.cloud.documentai.v1beta2.TableBoundHint.Builder builderForValue) {
      if (tableBoundHintsBuilder_ == null) {
        ensureTableBoundHintsIsMutable();
        tableBoundHints_.add(index, builderForValue.build());
        onChanged();
      } else {
        tableBoundHintsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Table bounding box hints that can be provided to complex cases
     * which our algorithm cannot locate the table(s) in.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllTableBoundHints(
        java.lang.Iterable<? extends com.google.cloud.documentai.v1beta2.TableBoundHint> values) {
      if (tableBoundHintsBuilder_ == null) {
        ensureTableBoundHintsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tableBoundHints_);
        onChanged();
      } else {
        tableBoundHintsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Table bounding box hints that can be provided to complex cases
     * which our algorithm cannot locate the table(s) in.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTableBoundHints() {
      if (tableBoundHintsBuilder_ == null) {
        tableBoundHints_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        tableBoundHintsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Table bounding box hints that can be provided to complex cases
     * which our algorithm cannot locate the table(s) in.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeTableBoundHints(int index) {
      if (tableBoundHintsBuilder_ == null) {
        ensureTableBoundHintsIsMutable();
        tableBoundHints_.remove(index);
        onChanged();
      } else {
        tableBoundHintsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Table bounding box hints that can be provided to complex cases
     * which our algorithm cannot locate the table(s) in.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.documentai.v1beta2.TableBoundHint.Builder getTableBoundHintsBuilder(
        int index) {
      return getTableBoundHintsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Table bounding box hints that can be provided to complex cases
     * which our algorithm cannot locate the table(s) in.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.documentai.v1beta2.TableBoundHintOrBuilder getTableBoundHintsOrBuilder(
        int index) {
      if (tableBoundHintsBuilder_ == null) {
        return tableBoundHints_.get(index);
      } else {
        return tableBoundHintsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Table bounding box hints that can be provided to complex cases
     * which our algorithm cannot locate the table(s) in.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.documentai.v1beta2.TableBoundHintOrBuilder>
        getTableBoundHintsOrBuilderList() {
      if (tableBoundHintsBuilder_ != null) {
        return tableBoundHintsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tableBoundHints_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Table bounding box hints that can be provided to complex cases
     * which our algorithm cannot locate the table(s) in.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.documentai.v1beta2.TableBoundHint.Builder addTableBoundHintsBuilder() {
      return getTableBoundHintsFieldBuilder()
          .addBuilder(com.google.cloud.documentai.v1beta2.TableBoundHint.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Table bounding box hints that can be provided to complex cases
     * which our algorithm cannot locate the table(s) in.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.documentai.v1beta2.TableBoundHint.Builder addTableBoundHintsBuilder(
        int index) {
      return getTableBoundHintsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.documentai.v1beta2.TableBoundHint.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Table bounding box hints that can be provided to complex cases
     * which our algorithm cannot locate the table(s) in.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta2.TableBoundHint table_bound_hints = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.documentai.v1beta2.TableBoundHint.Builder>
        getTableBoundHintsBuilderList() {
      return getTableBoundHintsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta2.TableBoundHint,
            com.google.cloud.documentai.v1beta2.TableBoundHint.Builder,
            com.google.cloud.documentai.v1beta2.TableBoundHintOrBuilder>
        getTableBoundHintsFieldBuilder() {
      if (tableBoundHintsBuilder_ == null) {
        tableBoundHintsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta2.TableBoundHint,
                com.google.cloud.documentai.v1beta2.TableBoundHint.Builder,
                com.google.cloud.documentai.v1beta2.TableBoundHintOrBuilder>(
                tableBoundHints_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        tableBoundHints_ = null;
      }
      return tableBoundHintsBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList headerHints_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureHeaderHintsIsMutable() {
      if (!headerHints_.isModifiable()) {
        headerHints_ = new com.google.protobuf.LazyStringArrayList(headerHints_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Optional. Reserved for future use.
     * </pre>
     *
     * <code>repeated string header_hints = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the headerHints.
     */
    public com.google.protobuf.ProtocolStringList getHeaderHintsList() {
      headerHints_.makeImmutable();
      return headerHints_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Reserved for future use.
     * </pre>
     *
     * <code>repeated string header_hints = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of headerHints.
     */
    public int getHeaderHintsCount() {
      return headerHints_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Reserved for future use.
     * </pre>
     *
     * <code>repeated string header_hints = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The headerHints at the given index.
     */
    public java.lang.String getHeaderHints(int index) {
      return headerHints_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Reserved for future use.
     * </pre>
     *
     * <code>repeated string header_hints = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the headerHints at the given index.
     */
    public com.google.protobuf.ByteString getHeaderHintsBytes(int index) {
      return headerHints_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Reserved for future use.
     * </pre>
     *
     * <code>repeated string header_hints = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The headerHints to set.
     * @return This builder for chaining.
     */
    public Builder setHeaderHints(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureHeaderHintsIsMutable();
      headerHints_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Reserved for future use.
     * </pre>
     *
     * <code>repeated string header_hints = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The headerHints to add.
     * @return This builder for chaining.
     */
    public Builder addHeaderHints(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureHeaderHintsIsMutable();
      headerHints_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Reserved for future use.
     * </pre>
     *
     * <code>repeated string header_hints = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The headerHints to add.
     * @return This builder for chaining.
     */
    public Builder addAllHeaderHints(java.lang.Iterable<java.lang.String> values) {
      ensureHeaderHintsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, headerHints_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Reserved for future use.
     * </pre>
     *
     * <code>repeated string header_hints = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHeaderHints() {
      headerHints_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Reserved for future use.
     * </pre>
     *
     * <code>repeated string header_hints = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the headerHints to add.
     * @return This builder for chaining.
     */
    public Builder addHeaderHintsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureHeaderHintsIsMutable();
      headerHints_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object modelVersion_ = "";
    /**
     *
     *
     * <pre>
     * Model version of the table extraction system. Default is "builtin/stable".
     * Specify "builtin/latest" for the latest model.
     * </pre>
     *
     * <code>string model_version = 4;</code>
     *
     * @return The modelVersion.
     */
    public java.lang.String getModelVersion() {
      java.lang.Object ref = modelVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Model version of the table extraction system. Default is "builtin/stable".
     * Specify "builtin/latest" for the latest model.
     * </pre>
     *
     * <code>string model_version = 4;</code>
     *
     * @return The bytes for modelVersion.
     */
    public com.google.protobuf.ByteString getModelVersionBytes() {
      java.lang.Object ref = modelVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Model version of the table extraction system. Default is "builtin/stable".
     * Specify "builtin/latest" for the latest model.
     * </pre>
     *
     * <code>string model_version = 4;</code>
     *
     * @param value The modelVersion to set.
     * @return This builder for chaining.
     */
    public Builder setModelVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelVersion_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model version of the table extraction system. Default is "builtin/stable".
     * Specify "builtin/latest" for the latest model.
     * </pre>
     *
     * <code>string model_version = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelVersion() {
      modelVersion_ = getDefaultInstance().getModelVersion();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Model version of the table extraction system. Default is "builtin/stable".
     * Specify "builtin/latest" for the latest model.
     * </pre>
     *
     * <code>string model_version = 4;</code>
     *
     * @param value The bytes for modelVersion to set.
     * @return This builder for chaining.
     */
    public Builder setModelVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelVersion_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta2.TableExtractionParams)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta2.TableExtractionParams)
  private static final com.google.cloud.documentai.v1beta2.TableExtractionParams DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta2.TableExtractionParams();
  }

  public static com.google.cloud.documentai.v1beta2.TableExtractionParams getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TableExtractionParams> PARSER =
      new com.google.protobuf.AbstractParser<TableExtractionParams>() {
        @java.lang.Override
        public TableExtractionParams parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TableExtractionParams> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TableExtractionParams> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta2.TableExtractionParams getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
