/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document_processor_service.proto

package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * Request message for the process document method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.ProcessRequest}
 */
public final class ProcessRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.ProcessRequest)
    ProcessRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ProcessRequest.newBuilder() to construct.
  private ProcessRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ProcessRequest() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ProcessRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_ProcessRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_ProcessRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.ProcessRequest.class,
            com.google.cloud.documentai.v1beta3.ProcessRequest.Builder.class);
  }

  private int sourceCase_ = 0;
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INLINE_DOCUMENT(4),
    RAW_DOCUMENT(5),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 4:
          return INLINE_DOCUMENT;
        case 5:
          return RAW_DOCUMENT;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int INLINE_DOCUMENT_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * An inline document proto.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
   *
   * @return Whether the inlineDocument field is set.
   */
  @java.lang.Override
  public boolean hasInlineDocument() {
    return sourceCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * An inline document proto.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
   *
   * @return The inlineDocument.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Document getInlineDocument() {
    if (sourceCase_ == 4) {
      return (com.google.cloud.documentai.v1beta3.Document) source_;
    }
    return com.google.cloud.documentai.v1beta3.Document.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An inline document proto.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentOrBuilder getInlineDocumentOrBuilder() {
    if (sourceCase_ == 4) {
      return (com.google.cloud.documentai.v1beta3.Document) source_;
    }
    return com.google.cloud.documentai.v1beta3.Document.getDefaultInstance();
  }

  public static final int RAW_DOCUMENT_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * A raw document content (bytes).
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
   *
   * @return Whether the rawDocument field is set.
   */
  @java.lang.Override
  public boolean hasRawDocument() {
    return sourceCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * A raw document content (bytes).
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
   *
   * @return The rawDocument.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.RawDocument getRawDocument() {
    if (sourceCase_ == 5) {
      return (com.google.cloud.documentai.v1beta3.RawDocument) source_;
    }
    return com.google.cloud.documentai.v1beta3.RawDocument.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A raw document content (bytes).
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.RawDocumentOrBuilder getRawDocumentOrBuilder() {
    if (sourceCase_ == 5) {
      return (com.google.cloud.documentai.v1beta3.RawDocument) source_;
    }
    return com.google.cloud.documentai.v1beta3.RawDocument.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Required. The resource name of the [Processor][google.cloud.documentai.v1beta3.Processor] or
   * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
   * to use for processing. If a [Processor][google.cloud.documentai.v1beta3.Processor] is specified, the server will use
   * its [default version][google.cloud.documentai.v1beta3.Processor.default_processor_version]. Format:
   * `projects/{project}/locations/{location}/processors/{processor}`, or
   * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the [Processor][google.cloud.documentai.v1beta3.Processor] or
   * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
   * to use for processing. If a [Processor][google.cloud.documentai.v1beta3.Processor] is specified, the server will use
   * its [default version][google.cloud.documentai.v1beta3.Processor.default_processor_version]. Format:
   * `projects/{project}/locations/{location}/processors/{processor}`, or
   * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOCUMENT_FIELD_NUMBER = 2;
  private com.google.cloud.documentai.v1beta3.Document document_;
  /**
   *
   *
   * <pre>
   * The document payload, the [content] and [mime_type] fields must be set.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
   *
   * @deprecated google.cloud.documentai.v1beta3.ProcessRequest.document is deprecated. See
   *     google/cloud/documentai/v1beta3/document_processor_service.proto;l=277
   * @return Whether the document field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasDocument() {
    return document_ != null;
  }
  /**
   *
   *
   * <pre>
   * The document payload, the [content] and [mime_type] fields must be set.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
   *
   * @deprecated google.cloud.documentai.v1beta3.ProcessRequest.document is deprecated. See
   *     google/cloud/documentai/v1beta3/document_processor_service.proto;l=277
   * @return The document.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.documentai.v1beta3.Document getDocument() {
    return document_ == null
        ? com.google.cloud.documentai.v1beta3.Document.getDefaultInstance()
        : document_;
  }
  /**
   *
   *
   * <pre>
   * The document payload, the [content] and [mime_type] fields must be set.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.documentai.v1beta3.DocumentOrBuilder getDocumentOrBuilder() {
    return getDocument();
  }

  public static final int SKIP_HUMAN_REVIEW_FIELD_NUMBER = 3;
  private boolean skipHumanReview_;
  /**
   *
   *
   * <pre>
   * Whether Human Review feature should be skipped for this request. Default to
   * false.
   * </pre>
   *
   * <code>bool skip_human_review = 3;</code>
   *
   * @return The skipHumanReview.
   */
  @java.lang.Override
  public boolean getSkipHumanReview() {
    return skipHumanReview_;
  }

  public static final int FIELD_MASK_FIELD_NUMBER = 6;
  private com.google.protobuf.FieldMask fieldMask_;
  /**
   *
   *
   * <pre>
   * Specifies which fields to include in ProcessResponse's document.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask field_mask = 6;</code>
   *
   * @return Whether the fieldMask field is set.
   */
  @java.lang.Override
  public boolean hasFieldMask() {
    return fieldMask_ != null;
  }
  /**
   *
   *
   * <pre>
   * Specifies which fields to include in ProcessResponse's document.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask field_mask = 6;</code>
   *
   * @return The fieldMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getFieldMask() {
    return fieldMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : fieldMask_;
  }
  /**
   *
   *
   * <pre>
   * Specifies which fields to include in ProcessResponse's document.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask field_mask = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getFieldMaskOrBuilder() {
    return getFieldMask();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (document_ != null) {
      output.writeMessage(2, getDocument());
    }
    if (skipHumanReview_ != false) {
      output.writeBool(3, skipHumanReview_);
    }
    if (sourceCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.documentai.v1beta3.Document) source_);
    }
    if (sourceCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.documentai.v1beta3.RawDocument) source_);
    }
    if (fieldMask_ != null) {
      output.writeMessage(6, getFieldMask());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (document_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDocument());
    }
    if (skipHumanReview_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, skipHumanReview_);
    }
    if (sourceCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.documentai.v1beta3.Document) source_);
    }
    if (sourceCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.documentai.v1beta3.RawDocument) source_);
    }
    if (fieldMask_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getFieldMask());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.ProcessRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.ProcessRequest other =
        (com.google.cloud.documentai.v1beta3.ProcessRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasDocument() != other.hasDocument()) return false;
    if (hasDocument()) {
      if (!getDocument().equals(other.getDocument())) return false;
    }
    if (getSkipHumanReview() != other.getSkipHumanReview()) return false;
    if (hasFieldMask() != other.hasFieldMask()) return false;
    if (hasFieldMask()) {
      if (!getFieldMask().equals(other.getFieldMask())) return false;
    }
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 4:
        if (!getInlineDocument().equals(other.getInlineDocument())) return false;
        break;
      case 5:
        if (!getRawDocument().equals(other.getRawDocument())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasDocument()) {
      hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
      hash = (53 * hash) + getDocument().hashCode();
    }
    hash = (37 * hash) + SKIP_HUMAN_REVIEW_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSkipHumanReview());
    if (hasFieldMask()) {
      hash = (37 * hash) + FIELD_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getFieldMask().hashCode();
    }
    switch (sourceCase_) {
      case 4:
        hash = (37 * hash) + INLINE_DOCUMENT_FIELD_NUMBER;
        hash = (53 * hash) + getInlineDocument().hashCode();
        break;
      case 5:
        hash = (37 * hash) + RAW_DOCUMENT_FIELD_NUMBER;
        hash = (53 * hash) + getRawDocument().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.documentai.v1beta3.ProcessRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for the process document method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.ProcessRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.ProcessRequest)
      com.google.cloud.documentai.v1beta3.ProcessRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ProcessRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ProcessRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.ProcessRequest.class,
              com.google.cloud.documentai.v1beta3.ProcessRequest.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.ProcessRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (inlineDocumentBuilder_ != null) {
        inlineDocumentBuilder_.clear();
      }
      if (rawDocumentBuilder_ != null) {
        rawDocumentBuilder_.clear();
      }
      name_ = "";

      if (documentBuilder_ == null) {
        document_ = null;
      } else {
        document_ = null;
        documentBuilder_ = null;
      }
      skipHumanReview_ = false;

      if (fieldMaskBuilder_ == null) {
        fieldMask_ = null;
      } else {
        fieldMask_ = null;
        fieldMaskBuilder_ = null;
      }
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ProcessRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessRequest getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.ProcessRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessRequest build() {
      com.google.cloud.documentai.v1beta3.ProcessRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessRequest buildPartial() {
      com.google.cloud.documentai.v1beta3.ProcessRequest result =
          new com.google.cloud.documentai.v1beta3.ProcessRequest(this);
      if (sourceCase_ == 4) {
        if (inlineDocumentBuilder_ == null) {
          result.source_ = source_;
        } else {
          result.source_ = inlineDocumentBuilder_.build();
        }
      }
      if (sourceCase_ == 5) {
        if (rawDocumentBuilder_ == null) {
          result.source_ = source_;
        } else {
          result.source_ = rawDocumentBuilder_.build();
        }
      }
      result.name_ = name_;
      if (documentBuilder_ == null) {
        result.document_ = document_;
      } else {
        result.document_ = documentBuilder_.build();
      }
      result.skipHumanReview_ = skipHumanReview_;
      if (fieldMaskBuilder_ == null) {
        result.fieldMask_ = fieldMask_;
      } else {
        result.fieldMask_ = fieldMaskBuilder_.build();
      }
      result.sourceCase_ = sourceCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.ProcessRequest) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.ProcessRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.ProcessRequest other) {
      if (other == com.google.cloud.documentai.v1beta3.ProcessRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasDocument()) {
        mergeDocument(other.getDocument());
      }
      if (other.getSkipHumanReview() != false) {
        setSkipHumanReview(other.getSkipHumanReview());
      }
      if (other.hasFieldMask()) {
        mergeFieldMask(other.getFieldMask());
      }
      switch (other.getSourceCase()) {
        case INLINE_DOCUMENT:
          {
            mergeInlineDocument(other.getInlineDocument());
            break;
          }
        case RAW_DOCUMENT:
          {
            mergeRawDocument(other.getRawDocument());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getDocumentFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 24:
              {
                skipHumanReview_ = input.readBool();

                break;
              } // case 24
            case 34:
              {
                input.readMessage(getInlineDocumentFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getRawDocumentFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getFieldMaskFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Document,
            com.google.cloud.documentai.v1beta3.Document.Builder,
            com.google.cloud.documentai.v1beta3.DocumentOrBuilder>
        inlineDocumentBuilder_;
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     *
     * @return Whether the inlineDocument field is set.
     */
    @java.lang.Override
    public boolean hasInlineDocument() {
      return sourceCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     *
     * @return The inlineDocument.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Document getInlineDocument() {
      if (inlineDocumentBuilder_ == null) {
        if (sourceCase_ == 4) {
          return (com.google.cloud.documentai.v1beta3.Document) source_;
        }
        return com.google.cloud.documentai.v1beta3.Document.getDefaultInstance();
      } else {
        if (sourceCase_ == 4) {
          return inlineDocumentBuilder_.getMessage();
        }
        return com.google.cloud.documentai.v1beta3.Document.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    public Builder setInlineDocument(com.google.cloud.documentai.v1beta3.Document value) {
      if (inlineDocumentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        inlineDocumentBuilder_.setMessage(value);
      }
      sourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    public Builder setInlineDocument(
        com.google.cloud.documentai.v1beta3.Document.Builder builderForValue) {
      if (inlineDocumentBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        inlineDocumentBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    public Builder mergeInlineDocument(com.google.cloud.documentai.v1beta3.Document value) {
      if (inlineDocumentBuilder_ == null) {
        if (sourceCase_ == 4
            && source_ != com.google.cloud.documentai.v1beta3.Document.getDefaultInstance()) {
          source_ =
              com.google.cloud.documentai.v1beta3.Document.newBuilder(
                      (com.google.cloud.documentai.v1beta3.Document) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 4) {
          inlineDocumentBuilder_.mergeFrom(value);
        } else {
          inlineDocumentBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    public Builder clearInlineDocument() {
      if (inlineDocumentBuilder_ == null) {
        if (sourceCase_ == 4) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 4) {
          sourceCase_ = 0;
          source_ = null;
        }
        inlineDocumentBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    public com.google.cloud.documentai.v1beta3.Document.Builder getInlineDocumentBuilder() {
      return getInlineDocumentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentOrBuilder getInlineDocumentOrBuilder() {
      if ((sourceCase_ == 4) && (inlineDocumentBuilder_ != null)) {
        return inlineDocumentBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 4) {
          return (com.google.cloud.documentai.v1beta3.Document) source_;
        }
        return com.google.cloud.documentai.v1beta3.Document.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Document,
            com.google.cloud.documentai.v1beta3.Document.Builder,
            com.google.cloud.documentai.v1beta3.DocumentOrBuilder>
        getInlineDocumentFieldBuilder() {
      if (inlineDocumentBuilder_ == null) {
        if (!(sourceCase_ == 4)) {
          source_ = com.google.cloud.documentai.v1beta3.Document.getDefaultInstance();
        }
        inlineDocumentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document,
                com.google.cloud.documentai.v1beta3.Document.Builder,
                com.google.cloud.documentai.v1beta3.DocumentOrBuilder>(
                (com.google.cloud.documentai.v1beta3.Document) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 4;
      onChanged();
      ;
      return inlineDocumentBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.RawDocument,
            com.google.cloud.documentai.v1beta3.RawDocument.Builder,
            com.google.cloud.documentai.v1beta3.RawDocumentOrBuilder>
        rawDocumentBuilder_;
    /**
     *
     *
     * <pre>
     * A raw document content (bytes).
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
     *
     * @return Whether the rawDocument field is set.
     */
    @java.lang.Override
    public boolean hasRawDocument() {
      return sourceCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * A raw document content (bytes).
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
     *
     * @return The rawDocument.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.RawDocument getRawDocument() {
      if (rawDocumentBuilder_ == null) {
        if (sourceCase_ == 5) {
          return (com.google.cloud.documentai.v1beta3.RawDocument) source_;
        }
        return com.google.cloud.documentai.v1beta3.RawDocument.getDefaultInstance();
      } else {
        if (sourceCase_ == 5) {
          return rawDocumentBuilder_.getMessage();
        }
        return com.google.cloud.documentai.v1beta3.RawDocument.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A raw document content (bytes).
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
     */
    public Builder setRawDocument(com.google.cloud.documentai.v1beta3.RawDocument value) {
      if (rawDocumentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        rawDocumentBuilder_.setMessage(value);
      }
      sourceCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A raw document content (bytes).
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
     */
    public Builder setRawDocument(
        com.google.cloud.documentai.v1beta3.RawDocument.Builder builderForValue) {
      if (rawDocumentBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        rawDocumentBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A raw document content (bytes).
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
     */
    public Builder mergeRawDocument(com.google.cloud.documentai.v1beta3.RawDocument value) {
      if (rawDocumentBuilder_ == null) {
        if (sourceCase_ == 5
            && source_ != com.google.cloud.documentai.v1beta3.RawDocument.getDefaultInstance()) {
          source_ =
              com.google.cloud.documentai.v1beta3.RawDocument.newBuilder(
                      (com.google.cloud.documentai.v1beta3.RawDocument) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 5) {
          rawDocumentBuilder_.mergeFrom(value);
        } else {
          rawDocumentBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A raw document content (bytes).
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
     */
    public Builder clearRawDocument() {
      if (rawDocumentBuilder_ == null) {
        if (sourceCase_ == 5) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 5) {
          sourceCase_ = 0;
          source_ = null;
        }
        rawDocumentBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A raw document content (bytes).
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
     */
    public com.google.cloud.documentai.v1beta3.RawDocument.Builder getRawDocumentBuilder() {
      return getRawDocumentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A raw document content (bytes).
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.RawDocumentOrBuilder getRawDocumentOrBuilder() {
      if ((sourceCase_ == 5) && (rawDocumentBuilder_ != null)) {
        return rawDocumentBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 5) {
          return (com.google.cloud.documentai.v1beta3.RawDocument) source_;
        }
        return com.google.cloud.documentai.v1beta3.RawDocument.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A raw document content (bytes).
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.RawDocument,
            com.google.cloud.documentai.v1beta3.RawDocument.Builder,
            com.google.cloud.documentai.v1beta3.RawDocumentOrBuilder>
        getRawDocumentFieldBuilder() {
      if (rawDocumentBuilder_ == null) {
        if (!(sourceCase_ == 5)) {
          source_ = com.google.cloud.documentai.v1beta3.RawDocument.getDefaultInstance();
        }
        rawDocumentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.RawDocument,
                com.google.cloud.documentai.v1beta3.RawDocument.Builder,
                com.google.cloud.documentai.v1beta3.RawDocumentOrBuilder>(
                (com.google.cloud.documentai.v1beta3.RawDocument) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 5;
      onChanged();
      ;
      return rawDocumentBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the [Processor][google.cloud.documentai.v1beta3.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
     * to use for processing. If a [Processor][google.cloud.documentai.v1beta3.Processor] is specified, the server will use
     * its [default version][google.cloud.documentai.v1beta3.Processor.default_processor_version]. Format:
     * `projects/{project}/locations/{location}/processors/{processor}`, or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the [Processor][google.cloud.documentai.v1beta3.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
     * to use for processing. If a [Processor][google.cloud.documentai.v1beta3.Processor] is specified, the server will use
     * its [default version][google.cloud.documentai.v1beta3.Processor.default_processor_version]. Format:
     * `projects/{project}/locations/{location}/processors/{processor}`, or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the [Processor][google.cloud.documentai.v1beta3.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
     * to use for processing. If a [Processor][google.cloud.documentai.v1beta3.Processor] is specified, the server will use
     * its [default version][google.cloud.documentai.v1beta3.Processor.default_processor_version]. Format:
     * `projects/{project}/locations/{location}/processors/{processor}`, or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the [Processor][google.cloud.documentai.v1beta3.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
     * to use for processing. If a [Processor][google.cloud.documentai.v1beta3.Processor] is specified, the server will use
     * its [default version][google.cloud.documentai.v1beta3.Processor.default_processor_version]. Format:
     * `projects/{project}/locations/{location}/processors/{processor}`, or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the [Processor][google.cloud.documentai.v1beta3.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
     * to use for processing. If a [Processor][google.cloud.documentai.v1beta3.Processor] is specified, the server will use
     * its [default version][google.cloud.documentai.v1beta3.Processor.default_processor_version]. Format:
     * `projects/{project}/locations/{location}/processors/{processor}`, or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.documentai.v1beta3.Document document_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Document,
            com.google.cloud.documentai.v1beta3.Document.Builder,
            com.google.cloud.documentai.v1beta3.DocumentOrBuilder>
        documentBuilder_;
    /**
     *
     *
     * <pre>
     * The document payload, the [content] and [mime_type] fields must be set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.documentai.v1beta3.ProcessRequest.document is deprecated. See
     *     google/cloud/documentai/v1beta3/document_processor_service.proto;l=277
     * @return Whether the document field is set.
     */
    @java.lang.Deprecated
    public boolean hasDocument() {
      return documentBuilder_ != null || document_ != null;
    }
    /**
     *
     *
     * <pre>
     * The document payload, the [content] and [mime_type] fields must be set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.documentai.v1beta3.ProcessRequest.document is deprecated. See
     *     google/cloud/documentai/v1beta3/document_processor_service.proto;l=277
     * @return The document.
     */
    @java.lang.Deprecated
    public com.google.cloud.documentai.v1beta3.Document getDocument() {
      if (documentBuilder_ == null) {
        return document_ == null
            ? com.google.cloud.documentai.v1beta3.Document.getDefaultInstance()
            : document_;
      } else {
        return documentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The document payload, the [content] and [mime_type] fields must be set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setDocument(com.google.cloud.documentai.v1beta3.Document value) {
      if (documentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        document_ = value;
        onChanged();
      } else {
        documentBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The document payload, the [content] and [mime_type] fields must be set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setDocument(
        com.google.cloud.documentai.v1beta3.Document.Builder builderForValue) {
      if (documentBuilder_ == null) {
        document_ = builderForValue.build();
        onChanged();
      } else {
        documentBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The document payload, the [content] and [mime_type] fields must be set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder mergeDocument(com.google.cloud.documentai.v1beta3.Document value) {
      if (documentBuilder_ == null) {
        if (document_ != null) {
          document_ =
              com.google.cloud.documentai.v1beta3.Document.newBuilder(document_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          document_ = value;
        }
        onChanged();
      } else {
        documentBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The document payload, the [content] and [mime_type] fields must be set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder clearDocument() {
      if (documentBuilder_ == null) {
        document_ = null;
        onChanged();
      } else {
        document_ = null;
        documentBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The document payload, the [content] and [mime_type] fields must be set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.cloud.documentai.v1beta3.Document.Builder getDocumentBuilder() {

      onChanged();
      return getDocumentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The document payload, the [content] and [mime_type] fields must be set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.cloud.documentai.v1beta3.DocumentOrBuilder getDocumentOrBuilder() {
      if (documentBuilder_ != null) {
        return documentBuilder_.getMessageOrBuilder();
      } else {
        return document_ == null
            ? com.google.cloud.documentai.v1beta3.Document.getDefaultInstance()
            : document_;
      }
    }
    /**
     *
     *
     * <pre>
     * The document payload, the [content] and [mime_type] fields must be set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Document,
            com.google.cloud.documentai.v1beta3.Document.Builder,
            com.google.cloud.documentai.v1beta3.DocumentOrBuilder>
        getDocumentFieldBuilder() {
      if (documentBuilder_ == null) {
        documentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document,
                com.google.cloud.documentai.v1beta3.Document.Builder,
                com.google.cloud.documentai.v1beta3.DocumentOrBuilder>(
                getDocument(), getParentForChildren(), isClean());
        document_ = null;
      }
      return documentBuilder_;
    }

    private boolean skipHumanReview_;
    /**
     *
     *
     * <pre>
     * Whether Human Review feature should be skipped for this request. Default to
     * false.
     * </pre>
     *
     * <code>bool skip_human_review = 3;</code>
     *
     * @return The skipHumanReview.
     */
    @java.lang.Override
    public boolean getSkipHumanReview() {
      return skipHumanReview_;
    }
    /**
     *
     *
     * <pre>
     * Whether Human Review feature should be skipped for this request. Default to
     * false.
     * </pre>
     *
     * <code>bool skip_human_review = 3;</code>
     *
     * @param value The skipHumanReview to set.
     * @return This builder for chaining.
     */
    public Builder setSkipHumanReview(boolean value) {

      skipHumanReview_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether Human Review feature should be skipped for this request. Default to
     * false.
     * </pre>
     *
     * <code>bool skip_human_review = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSkipHumanReview() {

      skipHumanReview_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.FieldMask fieldMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        fieldMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in ProcessResponse's document.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     *
     * @return Whether the fieldMask field is set.
     */
    public boolean hasFieldMask() {
      return fieldMaskBuilder_ != null || fieldMask_ != null;
    }
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in ProcessResponse's document.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     *
     * @return The fieldMask.
     */
    public com.google.protobuf.FieldMask getFieldMask() {
      if (fieldMaskBuilder_ == null) {
        return fieldMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : fieldMask_;
      } else {
        return fieldMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in ProcessResponse's document.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    public Builder setFieldMask(com.google.protobuf.FieldMask value) {
      if (fieldMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fieldMask_ = value;
        onChanged();
      } else {
        fieldMaskBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in ProcessResponse's document.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    public Builder setFieldMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (fieldMaskBuilder_ == null) {
        fieldMask_ = builderForValue.build();
        onChanged();
      } else {
        fieldMaskBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in ProcessResponse's document.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    public Builder mergeFieldMask(com.google.protobuf.FieldMask value) {
      if (fieldMaskBuilder_ == null) {
        if (fieldMask_ != null) {
          fieldMask_ =
              com.google.protobuf.FieldMask.newBuilder(fieldMask_).mergeFrom(value).buildPartial();
        } else {
          fieldMask_ = value;
        }
        onChanged();
      } else {
        fieldMaskBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in ProcessResponse's document.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    public Builder clearFieldMask() {
      if (fieldMaskBuilder_ == null) {
        fieldMask_ = null;
        onChanged();
      } else {
        fieldMask_ = null;
        fieldMaskBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in ProcessResponse's document.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    public com.google.protobuf.FieldMask.Builder getFieldMaskBuilder() {

      onChanged();
      return getFieldMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in ProcessResponse's document.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getFieldMaskOrBuilder() {
      if (fieldMaskBuilder_ != null) {
        return fieldMaskBuilder_.getMessageOrBuilder();
      } else {
        return fieldMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : fieldMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in ProcessResponse's document.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getFieldMaskFieldBuilder() {
      if (fieldMaskBuilder_ == null) {
        fieldMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getFieldMask(), getParentForChildren(), isClean());
        fieldMask_ = null;
      }
      return fieldMaskBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.ProcessRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.ProcessRequest)
  private static final com.google.cloud.documentai.v1beta3.ProcessRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.ProcessRequest();
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ProcessRequest> PARSER =
      new com.google.protobuf.AbstractParser<ProcessRequest>() {
        @java.lang.Override
        public ProcessRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ProcessRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ProcessRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ProcessRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
