/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document_processor_service.proto

package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * Request message for batch process document method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.BatchProcessRequest}
 */
public final class BatchProcessRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.BatchProcessRequest)
    BatchProcessRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchProcessRequest.newBuilder() to construct.
  private BatchProcessRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchProcessRequest() {
    name_ = "";
    inputConfigs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchProcessRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private BatchProcessRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                inputConfigs_ =
                    new java.util.ArrayList<
                        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig>();
                mutable_bitField0_ |= 0x00000001;
              }
              inputConfigs_.add(
                  input.readMessage(
                      com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
                          .parser(),
                      extensionRegistry));
              break;
            }
          case 26:
            {
              com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.Builder
                  subBuilder = null;
              if (outputConfig_ != null) {
                subBuilder = outputConfig_.toBuilder();
              }
              outputConfig_ =
                  input.readMessage(
                      com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(outputConfig_);
                outputConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        inputConfigs_ = java.util.Collections.unmodifiableList(inputConfigs_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.class,
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.Builder.class);
  }

  public interface BatchInputConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The Cloud Storage location as the source of the document.
     * </pre>
     *
     * <code>string gcs_source = 1;</code>
     *
     * @return The gcsSource.
     */
    java.lang.String getGcsSource();
    /**
     *
     *
     * <pre>
     * The Cloud Storage location as the source of the document.
     * </pre>
     *
     * <code>string gcs_source = 1;</code>
     *
     * @return The bytes for gcsSource.
     */
    com.google.protobuf.ByteString getGcsSourceBytes();

    /**
     *
     *
     * <pre>
     * Mimetype of the input. If the input is a raw document, the supported
     * mimetypes are application/pdf, image/tiff, and image/gif.
     * If the input is a [Document] proto, the type should be application/json.
     * </pre>
     *
     * <code>string mime_type = 2;</code>
     *
     * @return The mimeType.
     */
    java.lang.String getMimeType();
    /**
     *
     *
     * <pre>
     * Mimetype of the input. If the input is a raw document, the supported
     * mimetypes are application/pdf, image/tiff, and image/gif.
     * If the input is a [Document] proto, the type should be application/json.
     * </pre>
     *
     * <code>string mime_type = 2;</code>
     *
     * @return The bytes for mimeType.
     */
    com.google.protobuf.ByteString getMimeTypeBytes();
  }
  /**
   *
   *
   * <pre>
   * The message for input config in batch process.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig}
   */
  public static final class BatchInputConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig)
      BatchInputConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BatchInputConfig.newBuilder() to construct.
    private BatchInputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BatchInputConfig() {
      gcsSource_ = "";
      mimeType_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BatchInputConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private BatchInputConfig(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                gcsSource_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                mimeType_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_BatchInputConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_BatchInputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.class,
              com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder
                  .class);
    }

    public static final int GCS_SOURCE_FIELD_NUMBER = 1;
    private volatile java.lang.Object gcsSource_;
    /**
     *
     *
     * <pre>
     * The Cloud Storage location as the source of the document.
     * </pre>
     *
     * <code>string gcs_source = 1;</code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public java.lang.String getGcsSource() {
      java.lang.Object ref = gcsSource_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcsSource_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location as the source of the document.
     * </pre>
     *
     * <code>string gcs_source = 1;</code>
     *
     * @return The bytes for gcsSource.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcsSourceBytes() {
      java.lang.Object ref = gcsSource_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcsSource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MIME_TYPE_FIELD_NUMBER = 2;
    private volatile java.lang.Object mimeType_;
    /**
     *
     *
     * <pre>
     * Mimetype of the input. If the input is a raw document, the supported
     * mimetypes are application/pdf, image/tiff, and image/gif.
     * If the input is a [Document] proto, the type should be application/json.
     * </pre>
     *
     * <code>string mime_type = 2;</code>
     *
     * @return The mimeType.
     */
    @java.lang.Override
    public java.lang.String getMimeType() {
      java.lang.Object ref = mimeType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mimeType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Mimetype of the input. If the input is a raw document, the supported
     * mimetypes are application/pdf, image/tiff, and image/gif.
     * If the input is a [Document] proto, the type should be application/json.
     * </pre>
     *
     * <code>string mime_type = 2;</code>
     *
     * @return The bytes for mimeType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMimeTypeBytes() {
      java.lang.Object ref = mimeType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mimeType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getGcsSourceBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, gcsSource_);
      }
      if (!getMimeTypeBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, mimeType_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getGcsSourceBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, gcsSource_);
      }
      if (!getMimeTypeBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, mimeType_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig other =
          (com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig) obj;

      if (!getGcsSource().equals(other.getGcsSource())) return false;
      if (!getMimeType().equals(other.getMimeType())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getGcsSource().hashCode();
      hash = (37 * hash) + MIME_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getMimeType().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The message for input config in batch process.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig)
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_BatchInputConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_BatchInputConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.class,
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        gcsSource_ = "";

        mimeType_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_BatchInputConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig build() {
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
          buildPartial() {
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig result =
            new com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig(this);
        result.gcsSource_ = gcsSource_;
        result.mimeType_ = mimeType_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig other) {
        if (other
            == com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
                .getDefaultInstance()) return this;
        if (!other.getGcsSource().isEmpty()) {
          gcsSource_ = other.gcsSource_;
          onChanged();
        }
        if (!other.getMimeType().isEmpty()) {
          mimeType_ = other.mimeType_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig parsedMessage =
            null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object gcsSource_ = "";
      /**
       *
       *
       * <pre>
       * The Cloud Storage location as the source of the document.
       * </pre>
       *
       * <code>string gcs_source = 1;</code>
       *
       * @return The gcsSource.
       */
      public java.lang.String getGcsSource() {
        java.lang.Object ref = gcsSource_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gcsSource_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location as the source of the document.
       * </pre>
       *
       * <code>string gcs_source = 1;</code>
       *
       * @return The bytes for gcsSource.
       */
      public com.google.protobuf.ByteString getGcsSourceBytes() {
        java.lang.Object ref = gcsSource_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gcsSource_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location as the source of the document.
       * </pre>
       *
       * <code>string gcs_source = 1;</code>
       *
       * @param value The gcsSource to set.
       * @return This builder for chaining.
       */
      public Builder setGcsSource(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        gcsSource_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location as the source of the document.
       * </pre>
       *
       * <code>string gcs_source = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcsSource() {

        gcsSource_ = getDefaultInstance().getGcsSource();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location as the source of the document.
       * </pre>
       *
       * <code>string gcs_source = 1;</code>
       *
       * @param value The bytes for gcsSource to set.
       * @return This builder for chaining.
       */
      public Builder setGcsSourceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        gcsSource_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object mimeType_ = "";
      /**
       *
       *
       * <pre>
       * Mimetype of the input. If the input is a raw document, the supported
       * mimetypes are application/pdf, image/tiff, and image/gif.
       * If the input is a [Document] proto, the type should be application/json.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @return The mimeType.
       */
      public java.lang.String getMimeType() {
        java.lang.Object ref = mimeType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          mimeType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Mimetype of the input. If the input is a raw document, the supported
       * mimetypes are application/pdf, image/tiff, and image/gif.
       * If the input is a [Document] proto, the type should be application/json.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @return The bytes for mimeType.
       */
      public com.google.protobuf.ByteString getMimeTypeBytes() {
        java.lang.Object ref = mimeType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          mimeType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Mimetype of the input. If the input is a raw document, the supported
       * mimetypes are application/pdf, image/tiff, and image/gif.
       * If the input is a [Document] proto, the type should be application/json.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @param value The mimeType to set.
       * @return This builder for chaining.
       */
      public Builder setMimeType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        mimeType_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Mimetype of the input. If the input is a raw document, the supported
       * mimetypes are application/pdf, image/tiff, and image/gif.
       * If the input is a [Document] proto, the type should be application/json.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMimeType() {

        mimeType_ = getDefaultInstance().getMimeType();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Mimetype of the input. If the input is a raw document, the supported
       * mimetypes are application/pdf, image/tiff, and image/gif.
       * If the input is a [Document] proto, the type should be application/json.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @param value The bytes for mimeType to set.
       * @return This builder for chaining.
       */
      public Builder setMimeTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        mimeType_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig)
    private static final com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig();
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BatchInputConfig> PARSER =
        new com.google.protobuf.AbstractParser<BatchInputConfig>() {
          @java.lang.Override
          public BatchInputConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new BatchInputConfig(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<BatchInputConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BatchInputConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BatchOutputConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The output Cloud Storage directory to put the processed documents.
     * </pre>
     *
     * <code>string gcs_destination = 1;</code>
     *
     * @return The gcsDestination.
     */
    java.lang.String getGcsDestination();
    /**
     *
     *
     * <pre>
     * The output Cloud Storage directory to put the processed documents.
     * </pre>
     *
     * <code>string gcs_destination = 1;</code>
     *
     * @return The bytes for gcsDestination.
     */
    com.google.protobuf.ByteString getGcsDestinationBytes();
  }
  /**
   *
   *
   * <pre>
   * The message for output config in batch process.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig}
   */
  public static final class BatchOutputConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig)
      BatchOutputConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BatchOutputConfig.newBuilder() to construct.
    private BatchOutputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BatchOutputConfig() {
      gcsDestination_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BatchOutputConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private BatchOutputConfig(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                gcsDestination_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_BatchOutputConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_BatchOutputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.class,
              com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.Builder
                  .class);
    }

    public static final int GCS_DESTINATION_FIELD_NUMBER = 1;
    private volatile java.lang.Object gcsDestination_;
    /**
     *
     *
     * <pre>
     * The output Cloud Storage directory to put the processed documents.
     * </pre>
     *
     * <code>string gcs_destination = 1;</code>
     *
     * @return The gcsDestination.
     */
    @java.lang.Override
    public java.lang.String getGcsDestination() {
      java.lang.Object ref = gcsDestination_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcsDestination_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The output Cloud Storage directory to put the processed documents.
     * </pre>
     *
     * <code>string gcs_destination = 1;</code>
     *
     * @return The bytes for gcsDestination.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcsDestinationBytes() {
      java.lang.Object ref = gcsDestination_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcsDestination_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getGcsDestinationBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, gcsDestination_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getGcsDestinationBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, gcsDestination_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig other =
          (com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig) obj;

      if (!getGcsDestination().equals(other.getGcsDestination())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + GCS_DESTINATION_FIELD_NUMBER;
      hash = (53 * hash) + getGcsDestination().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The message for output config in batch process.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig)
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_BatchOutputConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_BatchOutputConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.class,
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        gcsDestination_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_BatchOutputConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig build() {
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
          buildPartial() {
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig result =
            new com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig(this);
        result.gcsDestination_ = gcsDestination_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig other) {
        if (other
            == com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
                .getDefaultInstance()) return this;
        if (!other.getGcsDestination().isEmpty()) {
          gcsDestination_ = other.gcsDestination_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig parsedMessage =
            null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object gcsDestination_ = "";
      /**
       *
       *
       * <pre>
       * The output Cloud Storage directory to put the processed documents.
       * </pre>
       *
       * <code>string gcs_destination = 1;</code>
       *
       * @return The gcsDestination.
       */
      public java.lang.String getGcsDestination() {
        java.lang.Object ref = gcsDestination_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gcsDestination_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The output Cloud Storage directory to put the processed documents.
       * </pre>
       *
       * <code>string gcs_destination = 1;</code>
       *
       * @return The bytes for gcsDestination.
       */
      public com.google.protobuf.ByteString getGcsDestinationBytes() {
        java.lang.Object ref = gcsDestination_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gcsDestination_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The output Cloud Storage directory to put the processed documents.
       * </pre>
       *
       * <code>string gcs_destination = 1;</code>
       *
       * @param value The gcsDestination to set.
       * @return This builder for chaining.
       */
      public Builder setGcsDestination(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        gcsDestination_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The output Cloud Storage directory to put the processed documents.
       * </pre>
       *
       * <code>string gcs_destination = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcsDestination() {

        gcsDestination_ = getDefaultInstance().getGcsDestination();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The output Cloud Storage directory to put the processed documents.
       * </pre>
       *
       * <code>string gcs_destination = 1;</code>
       *
       * @param value The bytes for gcsDestination to set.
       * @return This builder for chaining.
       */
      public Builder setGcsDestinationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        gcsDestination_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig)
    private static final com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig();
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BatchOutputConfig> PARSER =
        new com.google.protobuf.AbstractParser<BatchOutputConfig>() {
          @java.lang.Override
          public BatchOutputConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new BatchOutputConfig(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<BatchOutputConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BatchOutputConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Required. The processor resource name.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The processor resource name.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUT_CONFIGS_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig>
      inputConfigs_;
  /**
   *
   *
   * <pre>
   * The input config for each single document in the batch process.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig>
      getInputConfigsList() {
    return inputConfigs_;
  }
  /**
   *
   *
   * <pre>
   * The input config for each single document in the batch process.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfigOrBuilder>
      getInputConfigsOrBuilderList() {
    return inputConfigs_;
  }
  /**
   *
   *
   * <pre>
   * The input config for each single document in the batch process.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
   * </code>
   */
  @java.lang.Override
  public int getInputConfigsCount() {
    return inputConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * The input config for each single document in the batch process.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig getInputConfigs(
      int index) {
    return inputConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The input config for each single document in the batch process.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfigOrBuilder
      getInputConfigsOrBuilder(int index) {
    return inputConfigs_.get(index);
  }

  public static final int OUTPUT_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig outputConfig_;
  /**
   *
   *
   * <pre>
   * The overall output config for batch process.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3;
   * </code>
   *
   * @return Whether the outputConfig field is set.
   */
  @java.lang.Override
  public boolean hasOutputConfig() {
    return outputConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * The overall output config for batch process.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3;
   * </code>
   *
   * @return The outputConfig.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
      getOutputConfig() {
    return outputConfig_ == null
        ? com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
            .getDefaultInstance()
        : outputConfig_;
  }
  /**
   *
   *
   * <pre>
   * The overall output config for batch process.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfigOrBuilder
      getOutputConfigOrBuilder() {
    return getOutputConfig();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < inputConfigs_.size(); i++) {
      output.writeMessage(2, inputConfigs_.get(i));
    }
    if (outputConfig_ != null) {
      output.writeMessage(3, getOutputConfig());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (int i = 0; i < inputConfigs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, inputConfigs_.get(i));
    }
    if (outputConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getOutputConfig());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.BatchProcessRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.BatchProcessRequest other =
        (com.google.cloud.documentai.v1beta3.BatchProcessRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getInputConfigsList().equals(other.getInputConfigsList())) return false;
    if (hasOutputConfig() != other.hasOutputConfig()) return false;
    if (hasOutputConfig()) {
      if (!getOutputConfig().equals(other.getOutputConfig())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getInputConfigsCount() > 0) {
      hash = (37 * hash) + INPUT_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getInputConfigsList().hashCode();
    }
    if (hasOutputConfig()) {
      hash = (37 * hash) + OUTPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOutputConfig().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.documentai.v1beta3.BatchProcessRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for batch process document method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.BatchProcessRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.BatchProcessRequest)
      com.google.cloud.documentai.v1beta3.BatchProcessRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.BatchProcessRequest.class,
              com.google.cloud.documentai.v1beta3.BatchProcessRequest.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.BatchProcessRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInputConfigsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (inputConfigsBuilder_ == null) {
        inputConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        inputConfigsBuilder_.clear();
      }
      if (outputConfigBuilder_ == null) {
        outputConfig_ = null;
      } else {
        outputConfig_ = null;
        outputConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.BatchProcessRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest build() {
      com.google.cloud.documentai.v1beta3.BatchProcessRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest buildPartial() {
      com.google.cloud.documentai.v1beta3.BatchProcessRequest result =
          new com.google.cloud.documentai.v1beta3.BatchProcessRequest(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      if (inputConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          inputConfigs_ = java.util.Collections.unmodifiableList(inputConfigs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.inputConfigs_ = inputConfigs_;
      } else {
        result.inputConfigs_ = inputConfigsBuilder_.build();
      }
      if (outputConfigBuilder_ == null) {
        result.outputConfig_ = outputConfig_;
      } else {
        result.outputConfig_ = outputConfigBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.BatchProcessRequest) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.BatchProcessRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.BatchProcessRequest other) {
      if (other == com.google.cloud.documentai.v1beta3.BatchProcessRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (inputConfigsBuilder_ == null) {
        if (!other.inputConfigs_.isEmpty()) {
          if (inputConfigs_.isEmpty()) {
            inputConfigs_ = other.inputConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureInputConfigsIsMutable();
            inputConfigs_.addAll(other.inputConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.inputConfigs_.isEmpty()) {
          if (inputConfigsBuilder_.isEmpty()) {
            inputConfigsBuilder_.dispose();
            inputConfigsBuilder_ = null;
            inputConfigs_ = other.inputConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            inputConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInputConfigsFieldBuilder()
                    : null;
          } else {
            inputConfigsBuilder_.addAllMessages(other.inputConfigs_);
          }
        }
      }
      if (other.hasOutputConfig()) {
        mergeOutputConfig(other.getOutputConfig());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.documentai.v1beta3.BatchProcessRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.documentai.v1beta3.BatchProcessRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The processor resource name.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The processor resource name.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The processor resource name.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The processor resource name.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The processor resource name.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig>
        inputConfigs_ = java.util.Collections.emptyList();

    private void ensureInputConfigsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        inputConfigs_ =
            new java.util.ArrayList<
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig>(
                inputConfigs_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig,
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder,
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfigOrBuilder>
        inputConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig>
        getInputConfigsList() {
      if (inputConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(inputConfigs_);
      } else {
        return inputConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
     * </code>
     */
    public int getInputConfigsCount() {
      if (inputConfigsBuilder_ == null) {
        return inputConfigs_.size();
      } else {
        return inputConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig getInputConfigs(
        int index) {
      if (inputConfigsBuilder_ == null) {
        return inputConfigs_.get(index);
      } else {
        return inputConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
     * </code>
     */
    public Builder setInputConfigs(
        int index, com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig value) {
      if (inputConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputConfigsIsMutable();
        inputConfigs_.set(index, value);
        onChanged();
      } else {
        inputConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
     * </code>
     */
    public Builder setInputConfigs(
        int index,
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder
            builderForValue) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        inputConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        inputConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
     * </code>
     */
    public Builder addInputConfigs(
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig value) {
      if (inputConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputConfigsIsMutable();
        inputConfigs_.add(value);
        onChanged();
      } else {
        inputConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
     * </code>
     */
    public Builder addInputConfigs(
        int index, com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig value) {
      if (inputConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputConfigsIsMutable();
        inputConfigs_.add(index, value);
        onChanged();
      } else {
        inputConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
     * </code>
     */
    public Builder addInputConfigs(
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder
            builderForValue) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        inputConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        inputConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
     * </code>
     */
    public Builder addInputConfigs(
        int index,
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder
            builderForValue) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        inputConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        inputConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
     * </code>
     */
    public Builder addAllInputConfigs(
        java.lang.Iterable<
                ? extends com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig>
            values) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, inputConfigs_);
        onChanged();
      } else {
        inputConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
     * </code>
     */
    public Builder clearInputConfigs() {
      if (inputConfigsBuilder_ == null) {
        inputConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        inputConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
     * </code>
     */
    public Builder removeInputConfigs(int index) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        inputConfigs_.remove(index);
        onChanged();
      } else {
        inputConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder
        getInputConfigsBuilder(int index) {
      return getInputConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfigOrBuilder
        getInputConfigsOrBuilder(int index) {
      if (inputConfigsBuilder_ == null) {
        return inputConfigs_.get(index);
      } else {
        return inputConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfigOrBuilder>
        getInputConfigsOrBuilderList() {
      if (inputConfigsBuilder_ != null) {
        return inputConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(inputConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder
        addInputConfigsBuilder() {
      return getInputConfigsFieldBuilder()
          .addBuilder(
              com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder
        addInputConfigsBuilder(int index) {
      return getInputConfigsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2;
     * </code>
     */
    public java.util.List<
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder>
        getInputConfigsBuilderList() {
      return getInputConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig,
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder,
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfigOrBuilder>
        getInputConfigsFieldBuilder() {
      if (inputConfigsBuilder_ == null) {
        inputConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig,
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder,
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfigOrBuilder>(
                inputConfigs_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        inputConfigs_ = null;
      }
      return inputConfigsBuilder_;
    }

    private com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig outputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig,
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.Builder,
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfigOrBuilder>
        outputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3;
     * </code>
     *
     * @return Whether the outputConfig field is set.
     */
    public boolean hasOutputConfig() {
      return outputConfigBuilder_ != null || outputConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3;
     * </code>
     *
     * @return The outputConfig.
     */
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        getOutputConfig() {
      if (outputConfigBuilder_ == null) {
        return outputConfig_ == null
            ? com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
                .getDefaultInstance()
            : outputConfig_;
      } else {
        return outputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3;
     * </code>
     */
    public Builder setOutputConfig(
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputConfig_ = value;
        onChanged();
      } else {
        outputConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3;
     * </code>
     */
    public Builder setOutputConfig(
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.Builder
            builderForValue) {
      if (outputConfigBuilder_ == null) {
        outputConfig_ = builderForValue.build();
        onChanged();
      } else {
        outputConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3;
     * </code>
     */
    public Builder mergeOutputConfig(
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (outputConfig_ != null) {
          outputConfig_ =
              com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.newBuilder(
                      outputConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          outputConfig_ = value;
        }
        onChanged();
      } else {
        outputConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3;
     * </code>
     */
    public Builder clearOutputConfig() {
      if (outputConfigBuilder_ == null) {
        outputConfig_ = null;
        onChanged();
      } else {
        outputConfig_ = null;
        outputConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.Builder
        getOutputConfigBuilder() {

      onChanged();
      return getOutputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfigOrBuilder
        getOutputConfigOrBuilder() {
      if (outputConfigBuilder_ != null) {
        return outputConfigBuilder_.getMessageOrBuilder();
      } else {
        return outputConfig_ == null
            ? com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
                .getDefaultInstance()
            : outputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig,
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.Builder,
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfigOrBuilder>
        getOutputConfigFieldBuilder() {
      if (outputConfigBuilder_ == null) {
        outputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig,
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.Builder,
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfigOrBuilder>(
                getOutputConfig(), getParentForChildren(), isClean());
        outputConfig_ = null;
      }
      return outputConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.BatchProcessRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.BatchProcessRequest)
  private static final com.google.cloud.documentai.v1beta3.BatchProcessRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.BatchProcessRequest();
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchProcessRequest> PARSER =
      new com.google.protobuf.AbstractParser<BatchProcessRequest>() {
        @java.lang.Override
        public BatchProcessRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new BatchProcessRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<BatchProcessRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchProcessRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.BatchProcessRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
