/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document_processor_service.proto

package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * Response message for the process document method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.ProcessResponse}
 */
public final class ProcessResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.ProcessResponse)
    ProcessResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ProcessResponse.newBuilder() to construct.
  private ProcessResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ProcessResponse() {
    humanReviewOperation_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ProcessResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ProcessResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.documentai.v1beta3.Document.Builder subBuilder = null;
              if (document_ != null) {
                subBuilder = document_.toBuilder();
              }
              document_ =
                  input.readMessage(
                      com.google.cloud.documentai.v1beta3.Document.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(document_);
                document_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              humanReviewOperation_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_ProcessResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_ProcessResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.ProcessResponse.class,
            com.google.cloud.documentai.v1beta3.ProcessResponse.Builder.class);
  }

  public static final int DOCUMENT_FIELD_NUMBER = 1;
  private com.google.cloud.documentai.v1beta3.Document document_;
  /**
   *
   *
   * <pre>
   * The document payload, will populate fields based on the processor's
   * behavior.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document document = 1;</code>
   *
   * @return Whether the document field is set.
   */
  @java.lang.Override
  public boolean hasDocument() {
    return document_ != null;
  }
  /**
   *
   *
   * <pre>
   * The document payload, will populate fields based on the processor's
   * behavior.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document document = 1;</code>
   *
   * @return The document.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Document getDocument() {
    return document_ == null
        ? com.google.cloud.documentai.v1beta3.Document.getDefaultInstance()
        : document_;
  }
  /**
   *
   *
   * <pre>
   * The document payload, will populate fields based on the processor's
   * behavior.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document document = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentOrBuilder getDocumentOrBuilder() {
    return getDocument();
  }

  public static final int HUMAN_REVIEW_OPERATION_FIELD_NUMBER = 2;
  private volatile java.lang.Object humanReviewOperation_;
  /**
   *
   *
   * <pre>
   * The name of the operation triggered by the processed document. If the human
   * review process is not triggered, this field will be empty. It has the same
   * response type and metadata as the long running operation returned by
   * ReviewDocument method.
   * </pre>
   *
   * <code>string human_review_operation = 2;</code>
   *
   * @return The humanReviewOperation.
   */
  @java.lang.Override
  public java.lang.String getHumanReviewOperation() {
    java.lang.Object ref = humanReviewOperation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      humanReviewOperation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the operation triggered by the processed document. If the human
   * review process is not triggered, this field will be empty. It has the same
   * response type and metadata as the long running operation returned by
   * ReviewDocument method.
   * </pre>
   *
   * <code>string human_review_operation = 2;</code>
   *
   * @return The bytes for humanReviewOperation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHumanReviewOperationBytes() {
    java.lang.Object ref = humanReviewOperation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      humanReviewOperation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (document_ != null) {
      output.writeMessage(1, getDocument());
    }
    if (!getHumanReviewOperationBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, humanReviewOperation_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (document_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDocument());
    }
    if (!getHumanReviewOperationBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, humanReviewOperation_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.ProcessResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.ProcessResponse other =
        (com.google.cloud.documentai.v1beta3.ProcessResponse) obj;

    if (hasDocument() != other.hasDocument()) return false;
    if (hasDocument()) {
      if (!getDocument().equals(other.getDocument())) return false;
    }
    if (!getHumanReviewOperation().equals(other.getHumanReviewOperation())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDocument()) {
      hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
      hash = (53 * hash) + getDocument().hashCode();
    }
    hash = (37 * hash) + HUMAN_REVIEW_OPERATION_FIELD_NUMBER;
    hash = (53 * hash) + getHumanReviewOperation().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.ProcessResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.documentai.v1beta3.ProcessResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for the process document method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.ProcessResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.ProcessResponse)
      com.google.cloud.documentai.v1beta3.ProcessResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ProcessResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ProcessResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.ProcessResponse.class,
              com.google.cloud.documentai.v1beta3.ProcessResponse.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.ProcessResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (documentBuilder_ == null) {
        document_ = null;
      } else {
        document_ = null;
        documentBuilder_ = null;
      }
      humanReviewOperation_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ProcessResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessResponse getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.ProcessResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessResponse build() {
      com.google.cloud.documentai.v1beta3.ProcessResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessResponse buildPartial() {
      com.google.cloud.documentai.v1beta3.ProcessResponse result =
          new com.google.cloud.documentai.v1beta3.ProcessResponse(this);
      if (documentBuilder_ == null) {
        result.document_ = document_;
      } else {
        result.document_ = documentBuilder_.build();
      }
      result.humanReviewOperation_ = humanReviewOperation_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.ProcessResponse) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.ProcessResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.ProcessResponse other) {
      if (other == com.google.cloud.documentai.v1beta3.ProcessResponse.getDefaultInstance())
        return this;
      if (other.hasDocument()) {
        mergeDocument(other.getDocument());
      }
      if (!other.getHumanReviewOperation().isEmpty()) {
        humanReviewOperation_ = other.humanReviewOperation_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.documentai.v1beta3.ProcessResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.documentai.v1beta3.ProcessResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private com.google.cloud.documentai.v1beta3.Document document_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Document,
            com.google.cloud.documentai.v1beta3.Document.Builder,
            com.google.cloud.documentai.v1beta3.DocumentOrBuilder>
        documentBuilder_;
    /**
     *
     *
     * <pre>
     * The document payload, will populate fields based on the processor's
     * behavior.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 1;</code>
     *
     * @return Whether the document field is set.
     */
    public boolean hasDocument() {
      return documentBuilder_ != null || document_ != null;
    }
    /**
     *
     *
     * <pre>
     * The document payload, will populate fields based on the processor's
     * behavior.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 1;</code>
     *
     * @return The document.
     */
    public com.google.cloud.documentai.v1beta3.Document getDocument() {
      if (documentBuilder_ == null) {
        return document_ == null
            ? com.google.cloud.documentai.v1beta3.Document.getDefaultInstance()
            : document_;
      } else {
        return documentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The document payload, will populate fields based on the processor's
     * behavior.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 1;</code>
     */
    public Builder setDocument(com.google.cloud.documentai.v1beta3.Document value) {
      if (documentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        document_ = value;
        onChanged();
      } else {
        documentBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The document payload, will populate fields based on the processor's
     * behavior.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 1;</code>
     */
    public Builder setDocument(
        com.google.cloud.documentai.v1beta3.Document.Builder builderForValue) {
      if (documentBuilder_ == null) {
        document_ = builderForValue.build();
        onChanged();
      } else {
        documentBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The document payload, will populate fields based on the processor's
     * behavior.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 1;</code>
     */
    public Builder mergeDocument(com.google.cloud.documentai.v1beta3.Document value) {
      if (documentBuilder_ == null) {
        if (document_ != null) {
          document_ =
              com.google.cloud.documentai.v1beta3.Document.newBuilder(document_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          document_ = value;
        }
        onChanged();
      } else {
        documentBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The document payload, will populate fields based on the processor's
     * behavior.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 1;</code>
     */
    public Builder clearDocument() {
      if (documentBuilder_ == null) {
        document_ = null;
        onChanged();
      } else {
        document_ = null;
        documentBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The document payload, will populate fields based on the processor's
     * behavior.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 1;</code>
     */
    public com.google.cloud.documentai.v1beta3.Document.Builder getDocumentBuilder() {

      onChanged();
      return getDocumentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The document payload, will populate fields based on the processor's
     * behavior.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 1;</code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentOrBuilder getDocumentOrBuilder() {
      if (documentBuilder_ != null) {
        return documentBuilder_.getMessageOrBuilder();
      } else {
        return document_ == null
            ? com.google.cloud.documentai.v1beta3.Document.getDefaultInstance()
            : document_;
      }
    }
    /**
     *
     *
     * <pre>
     * The document payload, will populate fields based on the processor's
     * behavior.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Document,
            com.google.cloud.documentai.v1beta3.Document.Builder,
            com.google.cloud.documentai.v1beta3.DocumentOrBuilder>
        getDocumentFieldBuilder() {
      if (documentBuilder_ == null) {
        documentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document,
                com.google.cloud.documentai.v1beta3.Document.Builder,
                com.google.cloud.documentai.v1beta3.DocumentOrBuilder>(
                getDocument(), getParentForChildren(), isClean());
        document_ = null;
      }
      return documentBuilder_;
    }

    private java.lang.Object humanReviewOperation_ = "";
    /**
     *
     *
     * <pre>
     * The name of the operation triggered by the processed document. If the human
     * review process is not triggered, this field will be empty. It has the same
     * response type and metadata as the long running operation returned by
     * ReviewDocument method.
     * </pre>
     *
     * <code>string human_review_operation = 2;</code>
     *
     * @return The humanReviewOperation.
     */
    public java.lang.String getHumanReviewOperation() {
      java.lang.Object ref = humanReviewOperation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        humanReviewOperation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the operation triggered by the processed document. If the human
     * review process is not triggered, this field will be empty. It has the same
     * response type and metadata as the long running operation returned by
     * ReviewDocument method.
     * </pre>
     *
     * <code>string human_review_operation = 2;</code>
     *
     * @return The bytes for humanReviewOperation.
     */
    public com.google.protobuf.ByteString getHumanReviewOperationBytes() {
      java.lang.Object ref = humanReviewOperation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        humanReviewOperation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the operation triggered by the processed document. If the human
     * review process is not triggered, this field will be empty. It has the same
     * response type and metadata as the long running operation returned by
     * ReviewDocument method.
     * </pre>
     *
     * <code>string human_review_operation = 2;</code>
     *
     * @param value The humanReviewOperation to set.
     * @return This builder for chaining.
     */
    public Builder setHumanReviewOperation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      humanReviewOperation_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the operation triggered by the processed document. If the human
     * review process is not triggered, this field will be empty. It has the same
     * response type and metadata as the long running operation returned by
     * ReviewDocument method.
     * </pre>
     *
     * <code>string human_review_operation = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHumanReviewOperation() {

      humanReviewOperation_ = getDefaultInstance().getHumanReviewOperation();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the operation triggered by the processed document. If the human
     * review process is not triggered, this field will be empty. It has the same
     * response type and metadata as the long running operation returned by
     * ReviewDocument method.
     * </pre>
     *
     * <code>string human_review_operation = 2;</code>
     *
     * @param value The bytes for humanReviewOperation to set.
     * @return This builder for chaining.
     */
    public Builder setHumanReviewOperationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      humanReviewOperation_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.ProcessResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.ProcessResponse)
  private static final com.google.cloud.documentai.v1beta3.ProcessResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.ProcessResponse();
  }

  public static com.google.cloud.documentai.v1beta3.ProcessResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ProcessResponse> PARSER =
      new com.google.protobuf.AbstractParser<ProcessResponse>() {
        @java.lang.Override
        public ProcessResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ProcessResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ProcessResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ProcessResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ProcessResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
