/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document_service.proto

package com.google.cloud.documentai.v1beta3;

/** Protobuf type {@code google.cloud.documentai.v1beta3.GetDocumentRequest} */
public final class GetDocumentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.GetDocumentRequest)
    GetDocumentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GetDocumentRequest.newBuilder() to construct.
  private GetDocumentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GetDocumentRequest() {
    dataset_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GetDocumentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
        .internal_static_google_cloud_documentai_v1beta3_GetDocumentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
        .internal_static_google_cloud_documentai_v1beta3_GetDocumentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.GetDocumentRequest.class,
            com.google.cloud.documentai.v1beta3.GetDocumentRequest.Builder.class);
  }

  public static final int DATASET_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataset_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the dataset that the document belongs to .
   * Format:
   * projects/{project}/locations/{location}/processors/{processor}/dataset
   * </pre>
   *
   * <code>
   * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The dataset.
   */
  @java.lang.Override
  public java.lang.String getDataset() {
    java.lang.Object ref = dataset_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataset_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the dataset that the document belongs to .
   * Format:
   * projects/{project}/locations/{location}/processors/{processor}/dataset
   * </pre>
   *
   * <code>
   * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for dataset.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatasetBytes() {
    java.lang.Object ref = dataset_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataset_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOCUMENT_ID_FIELD_NUMBER = 2;
  private com.google.cloud.documentai.v1beta3.DocumentId documentId_;
  /**
   *
   *
   * <pre>
   * Required. Document identifier.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.DocumentId document_id = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the documentId field is set.
   */
  @java.lang.Override
  public boolean hasDocumentId() {
    return documentId_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Document identifier.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.DocumentId document_id = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The documentId.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentId getDocumentId() {
    return documentId_ == null
        ? com.google.cloud.documentai.v1beta3.DocumentId.getDefaultInstance()
        : documentId_;
  }
  /**
   *
   *
   * <pre>
   * Required. Document identifier.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.DocumentId document_id = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder getDocumentIdOrBuilder() {
    return documentId_ == null
        ? com.google.cloud.documentai.v1beta3.DocumentId.getDefaultInstance()
        : documentId_;
  }

  public static final int READ_MASK_FIELD_NUMBER = 3;
  private com.google.protobuf.FieldMask readMask_;
  /**
   *
   *
   * <pre>
   * If set, only fields listed here will be returned. Otherwise, all fields
   * will be returned by default.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask read_mask = 3;</code>
   *
   * @return Whether the readMask field is set.
   */
  @java.lang.Override
  public boolean hasReadMask() {
    return readMask_ != null;
  }
  /**
   *
   *
   * <pre>
   * If set, only fields listed here will be returned. Otherwise, all fields
   * will be returned by default.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask read_mask = 3;</code>
   *
   * @return The readMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getReadMask() {
    return readMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : readMask_;
  }
  /**
   *
   *
   * <pre>
   * If set, only fields listed here will be returned. Otherwise, all fields
   * will be returned by default.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask read_mask = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getReadMaskOrBuilder() {
    return readMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : readMask_;
  }

  public static final int PAGE_RANGE_FIELD_NUMBER = 4;
  private com.google.cloud.documentai.v1beta3.DocumentPageRange pageRange_;
  /**
   *
   *
   * <pre>
   * List of pages for which the fields specified in the `read_mask` must
   * be served.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentPageRange page_range = 4;</code>
   *
   * @return Whether the pageRange field is set.
   */
  @java.lang.Override
  public boolean hasPageRange() {
    return pageRange_ != null;
  }
  /**
   *
   *
   * <pre>
   * List of pages for which the fields specified in the `read_mask` must
   * be served.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentPageRange page_range = 4;</code>
   *
   * @return The pageRange.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentPageRange getPageRange() {
    return pageRange_ == null
        ? com.google.cloud.documentai.v1beta3.DocumentPageRange.getDefaultInstance()
        : pageRange_;
  }
  /**
   *
   *
   * <pre>
   * List of pages for which the fields specified in the `read_mask` must
   * be served.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentPageRange page_range = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentPageRangeOrBuilder getPageRangeOrBuilder() {
    return pageRange_ == null
        ? com.google.cloud.documentai.v1beta3.DocumentPageRange.getDefaultInstance()
        : pageRange_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataset_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dataset_);
    }
    if (documentId_ != null) {
      output.writeMessage(2, getDocumentId());
    }
    if (readMask_ != null) {
      output.writeMessage(3, getReadMask());
    }
    if (pageRange_ != null) {
      output.writeMessage(4, getPageRange());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataset_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dataset_);
    }
    if (documentId_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDocumentId());
    }
    if (readMask_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getReadMask());
    }
    if (pageRange_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPageRange());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.GetDocumentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.GetDocumentRequest other =
        (com.google.cloud.documentai.v1beta3.GetDocumentRequest) obj;

    if (!getDataset().equals(other.getDataset())) return false;
    if (hasDocumentId() != other.hasDocumentId()) return false;
    if (hasDocumentId()) {
      if (!getDocumentId().equals(other.getDocumentId())) return false;
    }
    if (hasReadMask() != other.hasReadMask()) return false;
    if (hasReadMask()) {
      if (!getReadMask().equals(other.getReadMask())) return false;
    }
    if (hasPageRange() != other.hasPageRange()) return false;
    if (hasPageRange()) {
      if (!getPageRange().equals(other.getPageRange())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATASET_FIELD_NUMBER;
    hash = (53 * hash) + getDataset().hashCode();
    if (hasDocumentId()) {
      hash = (37 * hash) + DOCUMENT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentId().hashCode();
    }
    if (hasReadMask()) {
      hash = (37 * hash) + READ_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getReadMask().hashCode();
    }
    if (hasPageRange()) {
      hash = (37 * hash) + PAGE_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getPageRange().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.GetDocumentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.GetDocumentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.GetDocumentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.GetDocumentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.GetDocumentRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.GetDocumentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.GetDocumentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.GetDocumentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.GetDocumentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.GetDocumentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.GetDocumentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.GetDocumentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.documentai.v1beta3.GetDocumentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /** Protobuf type {@code google.cloud.documentai.v1beta3.GetDocumentRequest} */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.GetDocumentRequest)
      com.google.cloud.documentai.v1beta3.GetDocumentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
          .internal_static_google_cloud_documentai_v1beta3_GetDocumentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
          .internal_static_google_cloud_documentai_v1beta3_GetDocumentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.GetDocumentRequest.class,
              com.google.cloud.documentai.v1beta3.GetDocumentRequest.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.GetDocumentRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      dataset_ = "";
      documentId_ = null;
      if (documentIdBuilder_ != null) {
        documentIdBuilder_.dispose();
        documentIdBuilder_ = null;
      }
      readMask_ = null;
      if (readMaskBuilder_ != null) {
        readMaskBuilder_.dispose();
        readMaskBuilder_ = null;
      }
      pageRange_ = null;
      if (pageRangeBuilder_ != null) {
        pageRangeBuilder_.dispose();
        pageRangeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
          .internal_static_google_cloud_documentai_v1beta3_GetDocumentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.GetDocumentRequest getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.GetDocumentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.GetDocumentRequest build() {
      com.google.cloud.documentai.v1beta3.GetDocumentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.GetDocumentRequest buildPartial() {
      com.google.cloud.documentai.v1beta3.GetDocumentRequest result =
          new com.google.cloud.documentai.v1beta3.GetDocumentRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta3.GetDocumentRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.dataset_ = dataset_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.documentId_ = documentIdBuilder_ == null ? documentId_ : documentIdBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.readMask_ = readMaskBuilder_ == null ? readMask_ : readMaskBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.pageRange_ = pageRangeBuilder_ == null ? pageRange_ : pageRangeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.GetDocumentRequest) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.GetDocumentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.GetDocumentRequest other) {
      if (other == com.google.cloud.documentai.v1beta3.GetDocumentRequest.getDefaultInstance())
        return this;
      if (!other.getDataset().isEmpty()) {
        dataset_ = other.dataset_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasDocumentId()) {
        mergeDocumentId(other.getDocumentId());
      }
      if (other.hasReadMask()) {
        mergeReadMask(other.getReadMask());
      }
      if (other.hasPageRange()) {
        mergePageRange(other.getPageRange());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                dataset_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getDocumentIdFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getReadMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getPageRangeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object dataset_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the dataset that the document belongs to .
     * Format:
     * projects/{project}/locations/{location}/processors/{processor}/dataset
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataset.
     */
    public java.lang.String getDataset() {
      java.lang.Object ref = dataset_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataset_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the dataset that the document belongs to .
     * Format:
     * projects/{project}/locations/{location}/processors/{processor}/dataset
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataset.
     */
    public com.google.protobuf.ByteString getDatasetBytes() {
      java.lang.Object ref = dataset_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataset_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the dataset that the document belongs to .
     * Format:
     * projects/{project}/locations/{location}/processors/{processor}/dataset
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The dataset to set.
     * @return This builder for chaining.
     */
    public Builder setDataset(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataset_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the dataset that the document belongs to .
     * Format:
     * projects/{project}/locations/{location}/processors/{processor}/dataset
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataset() {
      dataset_ = getDefaultInstance().getDataset();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the dataset that the document belongs to .
     * Format:
     * projects/{project}/locations/{location}/processors/{processor}/dataset
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for dataset to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataset_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.documentai.v1beta3.DocumentId documentId_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentId,
            com.google.cloud.documentai.v1beta3.DocumentId.Builder,
            com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder>
        documentIdBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Document identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentId document_id = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the documentId field is set.
     */
    public boolean hasDocumentId() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Document identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentId document_id = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The documentId.
     */
    public com.google.cloud.documentai.v1beta3.DocumentId getDocumentId() {
      if (documentIdBuilder_ == null) {
        return documentId_ == null
            ? com.google.cloud.documentai.v1beta3.DocumentId.getDefaultInstance()
            : documentId_;
      } else {
        return documentIdBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Document identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentId document_id = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDocumentId(com.google.cloud.documentai.v1beta3.DocumentId value) {
      if (documentIdBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentId_ = value;
      } else {
        documentIdBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Document identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentId document_id = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDocumentId(
        com.google.cloud.documentai.v1beta3.DocumentId.Builder builderForValue) {
      if (documentIdBuilder_ == null) {
        documentId_ = builderForValue.build();
      } else {
        documentIdBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Document identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentId document_id = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeDocumentId(com.google.cloud.documentai.v1beta3.DocumentId value) {
      if (documentIdBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && documentId_ != null
            && documentId_ != com.google.cloud.documentai.v1beta3.DocumentId.getDefaultInstance()) {
          getDocumentIdBuilder().mergeFrom(value);
        } else {
          documentId_ = value;
        }
      } else {
        documentIdBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Document identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentId document_id = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDocumentId() {
      bitField0_ = (bitField0_ & ~0x00000002);
      documentId_ = null;
      if (documentIdBuilder_ != null) {
        documentIdBuilder_.dispose();
        documentIdBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Document identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentId document_id = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentId.Builder getDocumentIdBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDocumentIdFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Document identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentId document_id = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder getDocumentIdOrBuilder() {
      if (documentIdBuilder_ != null) {
        return documentIdBuilder_.getMessageOrBuilder();
      } else {
        return documentId_ == null
            ? com.google.cloud.documentai.v1beta3.DocumentId.getDefaultInstance()
            : documentId_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Document identifier.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentId document_id = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentId,
            com.google.cloud.documentai.v1beta3.DocumentId.Builder,
            com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder>
        getDocumentIdFieldBuilder() {
      if (documentIdBuilder_ == null) {
        documentIdBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.DocumentId,
                com.google.cloud.documentai.v1beta3.DocumentId.Builder,
                com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder>(
                getDocumentId(), getParentForChildren(), isClean());
        documentId_ = null;
      }
      return documentIdBuilder_;
    }

    private com.google.protobuf.FieldMask readMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        readMaskBuilder_;
    /**
     *
     *
     * <pre>
     * If set, only fields listed here will be returned. Otherwise, all fields
     * will be returned by default.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask read_mask = 3;</code>
     *
     * @return Whether the readMask field is set.
     */
    public boolean hasReadMask() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * If set, only fields listed here will be returned. Otherwise, all fields
     * will be returned by default.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask read_mask = 3;</code>
     *
     * @return The readMask.
     */
    public com.google.protobuf.FieldMask getReadMask() {
      if (readMaskBuilder_ == null) {
        return readMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : readMask_;
      } else {
        return readMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If set, only fields listed here will be returned. Otherwise, all fields
     * will be returned by default.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask read_mask = 3;</code>
     */
    public Builder setReadMask(com.google.protobuf.FieldMask value) {
      if (readMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readMask_ = value;
      } else {
        readMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, only fields listed here will be returned. Otherwise, all fields
     * will be returned by default.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask read_mask = 3;</code>
     */
    public Builder setReadMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (readMaskBuilder_ == null) {
        readMask_ = builderForValue.build();
      } else {
        readMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, only fields listed here will be returned. Otherwise, all fields
     * will be returned by default.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask read_mask = 3;</code>
     */
    public Builder mergeReadMask(com.google.protobuf.FieldMask value) {
      if (readMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && readMask_ != null
            && readMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getReadMaskBuilder().mergeFrom(value);
        } else {
          readMask_ = value;
        }
      } else {
        readMaskBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, only fields listed here will be returned. Otherwise, all fields
     * will be returned by default.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask read_mask = 3;</code>
     */
    public Builder clearReadMask() {
      bitField0_ = (bitField0_ & ~0x00000004);
      readMask_ = null;
      if (readMaskBuilder_ != null) {
        readMaskBuilder_.dispose();
        readMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, only fields listed here will be returned. Otherwise, all fields
     * will be returned by default.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask read_mask = 3;</code>
     */
    public com.google.protobuf.FieldMask.Builder getReadMaskBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getReadMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If set, only fields listed here will be returned. Otherwise, all fields
     * will be returned by default.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask read_mask = 3;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getReadMaskOrBuilder() {
      if (readMaskBuilder_ != null) {
        return readMaskBuilder_.getMessageOrBuilder();
      } else {
        return readMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : readMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * If set, only fields listed here will be returned. Otherwise, all fields
     * will be returned by default.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask read_mask = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getReadMaskFieldBuilder() {
      if (readMaskBuilder_ == null) {
        readMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getReadMask(), getParentForChildren(), isClean());
        readMask_ = null;
      }
      return readMaskBuilder_;
    }

    private com.google.cloud.documentai.v1beta3.DocumentPageRange pageRange_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentPageRange,
            com.google.cloud.documentai.v1beta3.DocumentPageRange.Builder,
            com.google.cloud.documentai.v1beta3.DocumentPageRangeOrBuilder>
        pageRangeBuilder_;
    /**
     *
     *
     * <pre>
     * List of pages for which the fields specified in the `read_mask` must
     * be served.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentPageRange page_range = 4;</code>
     *
     * @return Whether the pageRange field is set.
     */
    public boolean hasPageRange() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * List of pages for which the fields specified in the `read_mask` must
     * be served.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentPageRange page_range = 4;</code>
     *
     * @return The pageRange.
     */
    public com.google.cloud.documentai.v1beta3.DocumentPageRange getPageRange() {
      if (pageRangeBuilder_ == null) {
        return pageRange_ == null
            ? com.google.cloud.documentai.v1beta3.DocumentPageRange.getDefaultInstance()
            : pageRange_;
      } else {
        return pageRangeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * List of pages for which the fields specified in the `read_mask` must
     * be served.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentPageRange page_range = 4;</code>
     */
    public Builder setPageRange(com.google.cloud.documentai.v1beta3.DocumentPageRange value) {
      if (pageRangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pageRange_ = value;
      } else {
        pageRangeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of pages for which the fields specified in the `read_mask` must
     * be served.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentPageRange page_range = 4;</code>
     */
    public Builder setPageRange(
        com.google.cloud.documentai.v1beta3.DocumentPageRange.Builder builderForValue) {
      if (pageRangeBuilder_ == null) {
        pageRange_ = builderForValue.build();
      } else {
        pageRangeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of pages for which the fields specified in the `read_mask` must
     * be served.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentPageRange page_range = 4;</code>
     */
    public Builder mergePageRange(com.google.cloud.documentai.v1beta3.DocumentPageRange value) {
      if (pageRangeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && pageRange_ != null
            && pageRange_
                != com.google.cloud.documentai.v1beta3.DocumentPageRange.getDefaultInstance()) {
          getPageRangeBuilder().mergeFrom(value);
        } else {
          pageRange_ = value;
        }
      } else {
        pageRangeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of pages for which the fields specified in the `read_mask` must
     * be served.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentPageRange page_range = 4;</code>
     */
    public Builder clearPageRange() {
      bitField0_ = (bitField0_ & ~0x00000008);
      pageRange_ = null;
      if (pageRangeBuilder_ != null) {
        pageRangeBuilder_.dispose();
        pageRangeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of pages for which the fields specified in the `read_mask` must
     * be served.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentPageRange page_range = 4;</code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentPageRange.Builder getPageRangeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getPageRangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * List of pages for which the fields specified in the `read_mask` must
     * be served.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentPageRange page_range = 4;</code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentPageRangeOrBuilder getPageRangeOrBuilder() {
      if (pageRangeBuilder_ != null) {
        return pageRangeBuilder_.getMessageOrBuilder();
      } else {
        return pageRange_ == null
            ? com.google.cloud.documentai.v1beta3.DocumentPageRange.getDefaultInstance()
            : pageRange_;
      }
    }
    /**
     *
     *
     * <pre>
     * List of pages for which the fields specified in the `read_mask` must
     * be served.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentPageRange page_range = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentPageRange,
            com.google.cloud.documentai.v1beta3.DocumentPageRange.Builder,
            com.google.cloud.documentai.v1beta3.DocumentPageRangeOrBuilder>
        getPageRangeFieldBuilder() {
      if (pageRangeBuilder_ == null) {
        pageRangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.DocumentPageRange,
                com.google.cloud.documentai.v1beta3.DocumentPageRange.Builder,
                com.google.cloud.documentai.v1beta3.DocumentPageRangeOrBuilder>(
                getPageRange(), getParentForChildren(), isClean());
        pageRange_ = null;
      }
      return pageRangeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.GetDocumentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.GetDocumentRequest)
  private static final com.google.cloud.documentai.v1beta3.GetDocumentRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.GetDocumentRequest();
  }

  public static com.google.cloud.documentai.v1beta3.GetDocumentRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GetDocumentRequest> PARSER =
      new com.google.protobuf.AbstractParser<GetDocumentRequest>() {
        @java.lang.Override
        public GetDocumentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GetDocumentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GetDocumentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.GetDocumentRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
