/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document_service.proto

package com.google.cloud.documentai.v1beta3;

public interface ListDocumentsRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.ListDocumentsRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The resource name of the dataset to be listed.
   * Format:
   * projects/{project}/locations/{location}/processors/{processor}/dataset
   * </pre>
   *
   * <code>
   * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The dataset.
   */
  java.lang.String getDataset();
  /**
   *
   *
   * <pre>
   * Required. The resource name of the dataset to be listed.
   * Format:
   * projects/{project}/locations/{location}/processors/{processor}/dataset
   * </pre>
   *
   * <code>
   * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for dataset.
   */
  com.google.protobuf.ByteString getDatasetBytes();

  /**
   *
   *
   * <pre>
   * The maximum number of documents to return. The service may return
   * fewer than this value.
   * If unspecified, at most 20 documents will be returned.
   * The maximum value is 100; values above 100 will be coerced to 100.
   * </pre>
   *
   * <code>int32 page_size = 2;</code>
   *
   * @return The pageSize.
   */
  int getPageSize();

  /**
   *
   *
   * <pre>
   * A page token, received from a previous `ListDocuments` call.
   * Provide this to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided to `ListDocuments`
   * must match the call that provided the page token.
   * </pre>
   *
   * <code>string page_token = 3;</code>
   *
   * @return The pageToken.
   */
  java.lang.String getPageToken();
  /**
   *
   *
   * <pre>
   * A page token, received from a previous `ListDocuments` call.
   * Provide this to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided to `ListDocuments`
   * must match the call that provided the page token.
   * </pre>
   *
   * <code>string page_token = 3;</code>
   *
   * @return The bytes for pageToken.
   */
  com.google.protobuf.ByteString getPageTokenBytes();

  /**
   *
   *
   * <pre>
   * Optional. Query to filter the documents based on
   * https://google.aip.dev/160.
   * ## Currently support query strings are:
   *
   * `SplitType=DATASET_SPLIT_TEST|DATASET_SPLIT_TRAIN|DATASET_SPLIT_UNASSIGNED`
   * - `LabelingState=DOCUMENT_LABELED|DOCUMENT_UNLABELED|DOCUMENT_AUTO_LABELED`
   * - `DisplayName=&#92;"file_name.pdf&#92;"`
   * - `EntityType=abc/def`
   * - `TagName=&#92;"auto-labeling-running&#92;"|&#92;"sampled&#92;"`
   *
   * Note:
   * - Only `AND`, `=` and `!=` are supported.
   *     e.g. `DisplayName=file_name AND EntityType!=abc` IS supported.
   * - Wildcard `*` is supported only in `DisplayName` filter
   * - No duplicate filter keys are allowed,
   *     e.g. `EntityType=a AND EntityType=b` is NOT supported.
   * - String match is case sensitive (for filter `DisplayName` &amp; `EntityType`).
   * </pre>
   *
   * <code>string filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The filter.
   */
  java.lang.String getFilter();
  /**
   *
   *
   * <pre>
   * Optional. Query to filter the documents based on
   * https://google.aip.dev/160.
   * ## Currently support query strings are:
   *
   * `SplitType=DATASET_SPLIT_TEST|DATASET_SPLIT_TRAIN|DATASET_SPLIT_UNASSIGNED`
   * - `LabelingState=DOCUMENT_LABELED|DOCUMENT_UNLABELED|DOCUMENT_AUTO_LABELED`
   * - `DisplayName=&#92;"file_name.pdf&#92;"`
   * - `EntityType=abc/def`
   * - `TagName=&#92;"auto-labeling-running&#92;"|&#92;"sampled&#92;"`
   *
   * Note:
   * - Only `AND`, `=` and `!=` are supported.
   *     e.g. `DisplayName=file_name AND EntityType!=abc` IS supported.
   * - Wildcard `*` is supported only in `DisplayName` filter
   * - No duplicate filter keys are allowed,
   *     e.g. `EntityType=a AND EntityType=b` is NOT supported.
   * - String match is case sensitive (for filter `DisplayName` &amp; `EntityType`).
   * </pre>
   *
   * <code>string filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for filter.
   */
  com.google.protobuf.ByteString getFilterBytes();

  /**
   *
   *
   * <pre>
   * Optional. Controls if the ListDocuments request requires a total size
   * of matched documents. See ListDocumentsResponse.total_size.
   *
   * Enabling this flag may adversely impact performance.
   *
   * Defaults to false.
   * </pre>
   *
   * <code>bool return_total_size = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The returnTotalSize.
   */
  boolean getReturnTotalSize();

  /**
   *
   *
   * <pre>
   * Optional. Number of results to skip beginning from the `page_token` if
   * provided. https://google.aip.dev/158#skipping-results. It must be a
   * non-negative integer. Negative values wil be rejected. Note that this is
   * not the number of pages to skip. If this value causes the cursor to move
   * past the end of results, `ListDocumentsResponse.document_metadata` and
   * `ListDocumentsResponse.next_page_token` will be empty.
   * </pre>
   *
   * <code>int32 skip = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The skip.
   */
  int getSkip();
}
