/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document.proto

package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * The revision reference specifies which revision on the document to read.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.RevisionRef}
 */
public final class RevisionRef extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.RevisionRef)
    RevisionRefOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RevisionRef.newBuilder() to construct.
  private RevisionRef(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RevisionRef() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RevisionRef();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentProto
        .internal_static_google_cloud_documentai_v1beta3_RevisionRef_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentProto
        .internal_static_google_cloud_documentai_v1beta3_RevisionRef_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.RevisionRef.class,
            com.google.cloud.documentai.v1beta3.RevisionRef.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Some predefined revision cases.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.documentai.v1beta3.RevisionRef.RevisionCase}
   */
  public enum RevisionCase implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified case, fall back to read the `LATEST_HUMAN_REVIEW`.
     * </pre>
     *
     * <code>REVISION_CASE_UNSPECIFIED = 0;</code>
     */
    REVISION_CASE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The latest revision made by a human.
     * </pre>
     *
     * <code>LATEST_HUMAN_REVIEW = 1;</code>
     */
    LATEST_HUMAN_REVIEW(1),
    /**
     *
     *
     * <pre>
     * The latest revision based on timestamp.
     * </pre>
     *
     * <code>LATEST_TIMESTAMP = 2;</code>
     */
    LATEST_TIMESTAMP(2),
    /**
     *
     *
     * <pre>
     * The first (OCR) revision.
     * </pre>
     *
     * <code>BASE_OCR_REVISION = 3;</code>
     */
    BASE_OCR_REVISION(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified case, fall back to read the `LATEST_HUMAN_REVIEW`.
     * </pre>
     *
     * <code>REVISION_CASE_UNSPECIFIED = 0;</code>
     */
    public static final int REVISION_CASE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The latest revision made by a human.
     * </pre>
     *
     * <code>LATEST_HUMAN_REVIEW = 1;</code>
     */
    public static final int LATEST_HUMAN_REVIEW_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The latest revision based on timestamp.
     * </pre>
     *
     * <code>LATEST_TIMESTAMP = 2;</code>
     */
    public static final int LATEST_TIMESTAMP_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The first (OCR) revision.
     * </pre>
     *
     * <code>BASE_OCR_REVISION = 3;</code>
     */
    public static final int BASE_OCR_REVISION_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RevisionCase valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RevisionCase forNumber(int value) {
      switch (value) {
        case 0:
          return REVISION_CASE_UNSPECIFIED;
        case 1:
          return LATEST_HUMAN_REVIEW;
        case 2:
          return LATEST_TIMESTAMP;
        case 3:
          return BASE_OCR_REVISION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RevisionCase> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RevisionCase> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RevisionCase>() {
          public RevisionCase findValueByNumber(int number) {
            return RevisionCase.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.RevisionRef.getDescriptor().getEnumTypes().get(0);
    }

    private static final RevisionCase[] VALUES = values();

    public static RevisionCase valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RevisionCase(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.documentai.v1beta3.RevisionRef.RevisionCase)
  }

  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    REVISION_CASE(1),
    REVISION_ID(2),
    LATEST_PROCESSOR_VERSION(3),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 1:
          return REVISION_CASE;
        case 2:
          return REVISION_ID;
        case 3:
          return LATEST_PROCESSOR_VERSION;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int REVISION_CASE_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Reads the revision by the predefined case.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.RevisionRef.RevisionCase revision_case = 1;</code>
   *
   * @return Whether the revisionCase field is set.
   */
  public boolean hasRevisionCase() {
    return sourceCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Reads the revision by the predefined case.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.RevisionRef.RevisionCase revision_case = 1;</code>
   *
   * @return The enum numeric value on the wire for revisionCase.
   */
  public int getRevisionCaseValue() {
    if (sourceCase_ == 1) {
      return (java.lang.Integer) source_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * Reads the revision by the predefined case.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.RevisionRef.RevisionCase revision_case = 1;</code>
   *
   * @return The revisionCase.
   */
  public com.google.cloud.documentai.v1beta3.RevisionRef.RevisionCase getRevisionCase() {
    if (sourceCase_ == 1) {
      com.google.cloud.documentai.v1beta3.RevisionRef.RevisionCase result =
          com.google.cloud.documentai.v1beta3.RevisionRef.RevisionCase.forNumber(
              (java.lang.Integer) source_);
      return result == null
          ? com.google.cloud.documentai.v1beta3.RevisionRef.RevisionCase.UNRECOGNIZED
          : result;
    }
    return com.google.cloud.documentai.v1beta3.RevisionRef.RevisionCase.REVISION_CASE_UNSPECIFIED;
  }

  public static final int REVISION_ID_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Reads the revision given by the id.
   * </pre>
   *
   * <code>string revision_id = 2;</code>
   *
   * @return Whether the revisionId field is set.
   */
  public boolean hasRevisionId() {
    return sourceCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Reads the revision given by the id.
   * </pre>
   *
   * <code>string revision_id = 2;</code>
   *
   * @return The revisionId.
   */
  public java.lang.String getRevisionId() {
    java.lang.Object ref = "";
    if (sourceCase_ == 2) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (sourceCase_ == 2) {
        source_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Reads the revision given by the id.
   * </pre>
   *
   * <code>string revision_id = 2;</code>
   *
   * @return The bytes for revisionId.
   */
  public com.google.protobuf.ByteString getRevisionIdBytes() {
    java.lang.Object ref = "";
    if (sourceCase_ == 2) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (sourceCase_ == 2) {
        source_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LATEST_PROCESSOR_VERSION_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Reads the revision generated by the processor version.
   * The format takes the full resource name of processor version.
   * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
   * </pre>
   *
   * <code>string latest_processor_version = 3;</code>
   *
   * @return Whether the latestProcessorVersion field is set.
   */
  public boolean hasLatestProcessorVersion() {
    return sourceCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Reads the revision generated by the processor version.
   * The format takes the full resource name of processor version.
   * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
   * </pre>
   *
   * <code>string latest_processor_version = 3;</code>
   *
   * @return The latestProcessorVersion.
   */
  public java.lang.String getLatestProcessorVersion() {
    java.lang.Object ref = "";
    if (sourceCase_ == 3) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (sourceCase_ == 3) {
        source_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Reads the revision generated by the processor version.
   * The format takes the full resource name of processor version.
   * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
   * </pre>
   *
   * <code>string latest_processor_version = 3;</code>
   *
   * @return The bytes for latestProcessorVersion.
   */
  public com.google.protobuf.ByteString getLatestProcessorVersionBytes() {
    java.lang.Object ref = "";
    if (sourceCase_ == 3) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (sourceCase_ == 3) {
        source_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (sourceCase_ == 1) {
      output.writeEnum(1, ((java.lang.Integer) source_));
    }
    if (sourceCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, source_);
    }
    if (sourceCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, source_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (sourceCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(1, ((java.lang.Integer) source_));
    }
    if (sourceCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, source_);
    }
    if (sourceCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, source_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.RevisionRef)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.RevisionRef other =
        (com.google.cloud.documentai.v1beta3.RevisionRef) obj;

    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 1:
        if (getRevisionCaseValue() != other.getRevisionCaseValue()) return false;
        break;
      case 2:
        if (!getRevisionId().equals(other.getRevisionId())) return false;
        break;
      case 3:
        if (!getLatestProcessorVersion().equals(other.getLatestProcessorVersion())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (sourceCase_) {
      case 1:
        hash = (37 * hash) + REVISION_CASE_FIELD_NUMBER;
        hash = (53 * hash) + getRevisionCaseValue();
        break;
      case 2:
        hash = (37 * hash) + REVISION_ID_FIELD_NUMBER;
        hash = (53 * hash) + getRevisionId().hashCode();
        break;
      case 3:
        hash = (37 * hash) + LATEST_PROCESSOR_VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getLatestProcessorVersion().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.RevisionRef parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.RevisionRef parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.RevisionRef parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.RevisionRef parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.RevisionRef parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.RevisionRef parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.RevisionRef parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.RevisionRef parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.RevisionRef parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.RevisionRef parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.RevisionRef parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.RevisionRef parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.documentai.v1beta3.RevisionRef prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The revision reference specifies which revision on the document to read.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.RevisionRef}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.RevisionRef)
      com.google.cloud.documentai.v1beta3.RevisionRefOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentProto
          .internal_static_google_cloud_documentai_v1beta3_RevisionRef_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentProto
          .internal_static_google_cloud_documentai_v1beta3_RevisionRef_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.RevisionRef.class,
              com.google.cloud.documentai.v1beta3.RevisionRef.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.RevisionRef.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentProto
          .internal_static_google_cloud_documentai_v1beta3_RevisionRef_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.RevisionRef getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.RevisionRef.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.RevisionRef build() {
      com.google.cloud.documentai.v1beta3.RevisionRef result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.RevisionRef buildPartial() {
      com.google.cloud.documentai.v1beta3.RevisionRef result =
          new com.google.cloud.documentai.v1beta3.RevisionRef(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta3.RevisionRef result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.documentai.v1beta3.RevisionRef result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.RevisionRef) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.RevisionRef) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.RevisionRef other) {
      if (other == com.google.cloud.documentai.v1beta3.RevisionRef.getDefaultInstance())
        return this;
      switch (other.getSourceCase()) {
        case REVISION_CASE:
          {
            setRevisionCaseValue(other.getRevisionCaseValue());
            break;
          }
        case REVISION_ID:
          {
            sourceCase_ = 2;
            source_ = other.source_;
            onChanged();
            break;
          }
        case LATEST_PROCESSOR_VERSION:
          {
            sourceCase_ = 3;
            source_ = other.source_;
            onChanged();
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                int rawValue = input.readEnum();
                sourceCase_ = 1;
                source_ = rawValue;
                break;
              } // case 8
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                sourceCase_ = 2;
                source_ = s;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                sourceCase_ = 3;
                source_ = s;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Reads the revision by the predefined case.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RevisionRef.RevisionCase revision_case = 1;</code>
     *
     * @return Whether the revisionCase field is set.
     */
    @java.lang.Override
    public boolean hasRevisionCase() {
      return sourceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Reads the revision by the predefined case.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RevisionRef.RevisionCase revision_case = 1;</code>
     *
     * @return The enum numeric value on the wire for revisionCase.
     */
    @java.lang.Override
    public int getRevisionCaseValue() {
      if (sourceCase_ == 1) {
        return ((java.lang.Integer) source_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Reads the revision by the predefined case.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RevisionRef.RevisionCase revision_case = 1;</code>
     *
     * @param value The enum numeric value on the wire for revisionCase to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionCaseValue(int value) {
      sourceCase_ = 1;
      source_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reads the revision by the predefined case.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RevisionRef.RevisionCase revision_case = 1;</code>
     *
     * @return The revisionCase.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.RevisionRef.RevisionCase getRevisionCase() {
      if (sourceCase_ == 1) {
        com.google.cloud.documentai.v1beta3.RevisionRef.RevisionCase result =
            com.google.cloud.documentai.v1beta3.RevisionRef.RevisionCase.forNumber(
                (java.lang.Integer) source_);
        return result == null
            ? com.google.cloud.documentai.v1beta3.RevisionRef.RevisionCase.UNRECOGNIZED
            : result;
      }
      return com.google.cloud.documentai.v1beta3.RevisionRef.RevisionCase.REVISION_CASE_UNSPECIFIED;
    }
    /**
     *
     *
     * <pre>
     * Reads the revision by the predefined case.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RevisionRef.RevisionCase revision_case = 1;</code>
     *
     * @param value The revisionCase to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionCase(
        com.google.cloud.documentai.v1beta3.RevisionRef.RevisionCase value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceCase_ = 1;
      source_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reads the revision by the predefined case.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RevisionRef.RevisionCase revision_case = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRevisionCase() {
      if (sourceCase_ == 1) {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Reads the revision given by the id.
     * </pre>
     *
     * <code>string revision_id = 2;</code>
     *
     * @return Whether the revisionId field is set.
     */
    @java.lang.Override
    public boolean hasRevisionId() {
      return sourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Reads the revision given by the id.
     * </pre>
     *
     * <code>string revision_id = 2;</code>
     *
     * @return The revisionId.
     */
    @java.lang.Override
    public java.lang.String getRevisionId() {
      java.lang.Object ref = "";
      if (sourceCase_ == 2) {
        ref = source_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceCase_ == 2) {
          source_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Reads the revision given by the id.
     * </pre>
     *
     * <code>string revision_id = 2;</code>
     *
     * @return The bytes for revisionId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRevisionIdBytes() {
      java.lang.Object ref = "";
      if (sourceCase_ == 2) {
        ref = source_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceCase_ == 2) {
          source_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Reads the revision given by the id.
     * </pre>
     *
     * <code>string revision_id = 2;</code>
     *
     * @param value The revisionId to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceCase_ = 2;
      source_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reads the revision given by the id.
     * </pre>
     *
     * <code>string revision_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRevisionId() {
      if (sourceCase_ == 2) {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reads the revision given by the id.
     * </pre>
     *
     * <code>string revision_id = 2;</code>
     *
     * @param value The bytes for revisionId to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceCase_ = 2;
      source_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Reads the revision generated by the processor version.
     * The format takes the full resource name of processor version.
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>string latest_processor_version = 3;</code>
     *
     * @return Whether the latestProcessorVersion field is set.
     */
    @java.lang.Override
    public boolean hasLatestProcessorVersion() {
      return sourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Reads the revision generated by the processor version.
     * The format takes the full resource name of processor version.
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>string latest_processor_version = 3;</code>
     *
     * @return The latestProcessorVersion.
     */
    @java.lang.Override
    public java.lang.String getLatestProcessorVersion() {
      java.lang.Object ref = "";
      if (sourceCase_ == 3) {
        ref = source_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceCase_ == 3) {
          source_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Reads the revision generated by the processor version.
     * The format takes the full resource name of processor version.
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>string latest_processor_version = 3;</code>
     *
     * @return The bytes for latestProcessorVersion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLatestProcessorVersionBytes() {
      java.lang.Object ref = "";
      if (sourceCase_ == 3) {
        ref = source_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceCase_ == 3) {
          source_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Reads the revision generated by the processor version.
     * The format takes the full resource name of processor version.
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>string latest_processor_version = 3;</code>
     *
     * @param value The latestProcessorVersion to set.
     * @return This builder for chaining.
     */
    public Builder setLatestProcessorVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceCase_ = 3;
      source_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reads the revision generated by the processor version.
     * The format takes the full resource name of processor version.
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>string latest_processor_version = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLatestProcessorVersion() {
      if (sourceCase_ == 3) {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reads the revision generated by the processor version.
     * The format takes the full resource name of processor version.
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>string latest_processor_version = 3;</code>
     *
     * @param value The bytes for latestProcessorVersion to set.
     * @return This builder for chaining.
     */
    public Builder setLatestProcessorVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceCase_ = 3;
      source_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.RevisionRef)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.RevisionRef)
  private static final com.google.cloud.documentai.v1beta3.RevisionRef DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.RevisionRef();
  }

  public static com.google.cloud.documentai.v1beta3.RevisionRef getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RevisionRef> PARSER =
      new com.google.protobuf.AbstractParser<RevisionRef>() {
        @java.lang.Override
        public RevisionRef parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RevisionRef> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RevisionRef> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.RevisionRef getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
