/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document_processor_service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * The request message for the
 * [ImportProcessorVersion][google.cloud.documentai.v1beta3.DocumentProcessorService.ImportProcessorVersion]
 * method.
 *
 * The Document AI [Service
 * Agent](https://cloud.google.com/iam/docs/service-agents) of the destination
 * project must have [Document AI Editor
 * role](https://cloud.google.com/document-ai/docs/access-control/iam-roles) on
 * the source project.
 *
 * The destination project is specified as part of the
 * [parent][google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.parent]
 * field. The source project is specified as part of the
 * [source][google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.processor_version_source]
 * or
 * [external_processor_version_source][google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.external_processor_version_source]
 * field.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.ImportProcessorVersionRequest}
 */
public final class ImportProcessorVersionRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.ImportProcessorVersionRequest)
    ImportProcessorVersionRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportProcessorVersionRequest.newBuilder() to construct.
  private ImportProcessorVersionRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportProcessorVersionRequest() {
    parent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportProcessorVersionRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_ImportProcessorVersionRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_ImportProcessorVersionRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.class,
            com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.Builder.class);
  }

  public interface ExternalProcessorVersionSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.ExternalProcessorVersionSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The processor version name. Format:
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>string processor_version = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The processorVersion.
     */
    java.lang.String getProcessorVersion();
    /**
     *
     *
     * <pre>
     * Required. The processor version name. Format:
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>string processor_version = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for processorVersion.
     */
    com.google.protobuf.ByteString getProcessorVersionBytes();

    /**
     *
     *
     * <pre>
     * Optional. The Document AI service endpoint. For example,
     * 'https://us-documentai.googleapis.com'
     * </pre>
     *
     * <code>string service_endpoint = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The serviceEndpoint.
     */
    java.lang.String getServiceEndpoint();
    /**
     *
     *
     * <pre>
     * Optional. The Document AI service endpoint. For example,
     * 'https://us-documentai.googleapis.com'
     * </pre>
     *
     * <code>string service_endpoint = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for serviceEndpoint.
     */
    com.google.protobuf.ByteString getServiceEndpointBytes();
  }
  /**
   *
   *
   * <pre>
   * The external source processor version.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.ExternalProcessorVersionSource}
   */
  public static final class ExternalProcessorVersionSource
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.ExternalProcessorVersionSource)
      ExternalProcessorVersionSourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ExternalProcessorVersionSource.newBuilder() to construct.
    private ExternalProcessorVersionSource(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ExternalProcessorVersionSource() {
      processorVersion_ = "";
      serviceEndpoint_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ExternalProcessorVersionSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ImportProcessorVersionRequest_ExternalProcessorVersionSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ImportProcessorVersionRequest_ExternalProcessorVersionSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                  .ExternalProcessorVersionSource.class,
              com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                  .ExternalProcessorVersionSource.Builder.class);
    }

    public static final int PROCESSOR_VERSION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object processorVersion_ = "";
    /**
     *
     *
     * <pre>
     * Required. The processor version name. Format:
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>string processor_version = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The processorVersion.
     */
    @java.lang.Override
    public java.lang.String getProcessorVersion() {
      java.lang.Object ref = processorVersion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        processorVersion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The processor version name. Format:
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>string processor_version = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for processorVersion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProcessorVersionBytes() {
      java.lang.Object ref = processorVersion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        processorVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SERVICE_ENDPOINT_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object serviceEndpoint_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Document AI service endpoint. For example,
     * 'https://us-documentai.googleapis.com'
     * </pre>
     *
     * <code>string service_endpoint = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The serviceEndpoint.
     */
    @java.lang.Override
    public java.lang.String getServiceEndpoint() {
      java.lang.Object ref = serviceEndpoint_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceEndpoint_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Document AI service endpoint. For example,
     * 'https://us-documentai.googleapis.com'
     * </pre>
     *
     * <code>string service_endpoint = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for serviceEndpoint.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceEndpointBytes() {
      java.lang.Object ref = serviceEndpoint_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceEndpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(processorVersion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, processorVersion_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceEndpoint_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, serviceEndpoint_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(processorVersion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, processorVersion_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceEndpoint_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, serviceEndpoint_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
              .ExternalProcessorVersionSource)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
              .ExternalProcessorVersionSource
          other =
              (com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                      .ExternalProcessorVersionSource)
                  obj;

      if (!getProcessorVersion().equals(other.getProcessorVersion())) return false;
      if (!getServiceEndpoint().equals(other.getServiceEndpoint())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PROCESSOR_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getProcessorVersion().hashCode();
      hash = (37 * hash) + SERVICE_ENDPOINT_FIELD_NUMBER;
      hash = (53 * hash) + getServiceEndpoint().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                .ExternalProcessorVersionSource
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The external source processor version.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.ExternalProcessorVersionSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.ExternalProcessorVersionSource)
        com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_ImportProcessorVersionRequest_ExternalProcessorVersionSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_ImportProcessorVersionRequest_ExternalProcessorVersionSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                    .ExternalProcessorVersionSource.class,
                com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                    .ExternalProcessorVersionSource.Builder.class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.ExternalProcessorVersionSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        processorVersion_ = "";
        serviceEndpoint_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_ImportProcessorVersionRequest_ExternalProcessorVersionSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
              .ExternalProcessorVersionSource
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
              .ExternalProcessorVersionSource
          build() {
        com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                .ExternalProcessorVersionSource
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
              .ExternalProcessorVersionSource
          buildPartial() {
        com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                .ExternalProcessorVersionSource
            result =
                new com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                    .ExternalProcessorVersionSource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                  .ExternalProcessorVersionSource
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.processorVersion_ = processorVersion_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.serviceEndpoint_ = serviceEndpoint_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                .ExternalProcessorVersionSource) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                      .ExternalProcessorVersionSource)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                  .ExternalProcessorVersionSource
              other) {
        if (other
            == com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                .ExternalProcessorVersionSource.getDefaultInstance()) return this;
        if (!other.getProcessorVersion().isEmpty()) {
          processorVersion_ = other.processorVersion_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getServiceEndpoint().isEmpty()) {
          serviceEndpoint_ = other.serviceEndpoint_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  processorVersion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  serviceEndpoint_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object processorVersion_ = "";
      /**
       *
       *
       * <pre>
       * Required. The processor version name. Format:
       * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
       * </pre>
       *
       * <code>string processor_version = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The processorVersion.
       */
      public java.lang.String getProcessorVersion() {
        java.lang.Object ref = processorVersion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          processorVersion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The processor version name. Format:
       * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
       * </pre>
       *
       * <code>string processor_version = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for processorVersion.
       */
      public com.google.protobuf.ByteString getProcessorVersionBytes() {
        java.lang.Object ref = processorVersion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          processorVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The processor version name. Format:
       * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
       * </pre>
       *
       * <code>string processor_version = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The processorVersion to set.
       * @return This builder for chaining.
       */
      public Builder setProcessorVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        processorVersion_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The processor version name. Format:
       * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
       * </pre>
       *
       * <code>string processor_version = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProcessorVersion() {
        processorVersion_ = getDefaultInstance().getProcessorVersion();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The processor version name. Format:
       * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
       * </pre>
       *
       * <code>string processor_version = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for processorVersion to set.
       * @return This builder for chaining.
       */
      public Builder setProcessorVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        processorVersion_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object serviceEndpoint_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The Document AI service endpoint. For example,
       * 'https://us-documentai.googleapis.com'
       * </pre>
       *
       * <code>string service_endpoint = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The serviceEndpoint.
       */
      public java.lang.String getServiceEndpoint() {
        java.lang.Object ref = serviceEndpoint_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serviceEndpoint_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The Document AI service endpoint. For example,
       * 'https://us-documentai.googleapis.com'
       * </pre>
       *
       * <code>string service_endpoint = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for serviceEndpoint.
       */
      public com.google.protobuf.ByteString getServiceEndpointBytes() {
        java.lang.Object ref = serviceEndpoint_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          serviceEndpoint_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The Document AI service endpoint. For example,
       * 'https://us-documentai.googleapis.com'
       * </pre>
       *
       * <code>string service_endpoint = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The serviceEndpoint to set.
       * @return This builder for chaining.
       */
      public Builder setServiceEndpoint(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceEndpoint_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The Document AI service endpoint. For example,
       * 'https://us-documentai.googleapis.com'
       * </pre>
       *
       * <code>string service_endpoint = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServiceEndpoint() {
        serviceEndpoint_ = getDefaultInstance().getServiceEndpoint();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The Document AI service endpoint. For example,
       * 'https://us-documentai.googleapis.com'
       * </pre>
       *
       * <code>string service_endpoint = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for serviceEndpoint to set.
       * @return This builder for chaining.
       */
      public Builder setServiceEndpointBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        serviceEndpoint_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.ExternalProcessorVersionSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.ExternalProcessorVersionSource)
    private static final com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
              .ExternalProcessorVersionSource();
    }

    public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ExternalProcessorVersionSource> PARSER =
        new com.google.protobuf.AbstractParser<ExternalProcessorVersionSource>() {
          @java.lang.Override
          public ExternalProcessorVersionSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ExternalProcessorVersionSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ExternalProcessorVersionSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PROCESSOR_VERSION_SOURCE(2),
    EXTERNAL_PROCESSOR_VERSION_SOURCE(3),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return PROCESSOR_VERSION_SOURCE;
        case 3:
          return EXTERNAL_PROCESSOR_VERSION_SOURCE;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int PROCESSOR_VERSION_SOURCE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The source processor version to import from. The source processor version
   * and destination processor need to be in the same environment and region.
   * </pre>
   *
   * <code>string processor_version_source = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the processorVersionSource field is set.
   */
  public boolean hasProcessorVersionSource() {
    return sourceCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The source processor version to import from. The source processor version
   * and destination processor need to be in the same environment and region.
   * </pre>
   *
   * <code>string processor_version_source = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The processorVersionSource.
   */
  public java.lang.String getProcessorVersionSource() {
    java.lang.Object ref = "";
    if (sourceCase_ == 2) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (sourceCase_ == 2) {
        source_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The source processor version to import from. The source processor version
   * and destination processor need to be in the same environment and region.
   * </pre>
   *
   * <code>string processor_version_source = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for processorVersionSource.
   */
  public com.google.protobuf.ByteString getProcessorVersionSourceBytes() {
    java.lang.Object ref = "";
    if (sourceCase_ == 2) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (sourceCase_ == 2) {
        source_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXTERNAL_PROCESSOR_VERSION_SOURCE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The source processor version to import from. It can be from a different
   * environment and region than the destination processor.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.ExternalProcessorVersionSource external_processor_version_source = 3;
   * </code>
   *
   * @return Whether the externalProcessorVersionSource field is set.
   */
  @java.lang.Override
  public boolean hasExternalProcessorVersionSource() {
    return sourceCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The source processor version to import from. It can be from a different
   * environment and region than the destination processor.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.ExternalProcessorVersionSource external_processor_version_source = 3;
   * </code>
   *
   * @return The externalProcessorVersionSource.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
          .ExternalProcessorVersionSource
      getExternalProcessorVersionSource() {
    if (sourceCase_ == 3) {
      return (com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
              .ExternalProcessorVersionSource)
          source_;
    }
    return com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
        .ExternalProcessorVersionSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The source processor version to import from. It can be from a different
   * environment and region than the destination processor.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.ExternalProcessorVersionSource external_processor_version_source = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
          .ExternalProcessorVersionSourceOrBuilder
      getExternalProcessorVersionSourceOrBuilder() {
    if (sourceCase_ == 3) {
      return (com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
              .ExternalProcessorVersionSource)
          source_;
    }
    return com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
        .ExternalProcessorVersionSource.getDefaultInstance();
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The destination processor name to create the processor version
   * in. Format:
   * `projects/{project}/locations/{location}/processors/{processor}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The destination processor name to create the processor version
   * in. Format:
   * `projects/{project}/locations/{location}/processors/{processor}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (sourceCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, source_);
    }
    if (sourceCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                  .ExternalProcessorVersionSource)
              source_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (sourceCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, source_);
    }
    if (sourceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                      .ExternalProcessorVersionSource)
                  source_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest other =
        (com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 2:
        if (!getProcessorVersionSource().equals(other.getProcessorVersionSource())) return false;
        break;
      case 3:
        if (!getExternalProcessorVersionSource().equals(other.getExternalProcessorVersionSource()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    switch (sourceCase_) {
      case 2:
        hash = (37 * hash) + PROCESSOR_VERSION_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getProcessorVersionSource().hashCode();
        break;
      case 3:
        hash = (37 * hash) + EXTERNAL_PROCESSOR_VERSION_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getExternalProcessorVersionSource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request message for the
   * [ImportProcessorVersion][google.cloud.documentai.v1beta3.DocumentProcessorService.ImportProcessorVersion]
   * method.
   *
   * The Document AI [Service
   * Agent](https://cloud.google.com/iam/docs/service-agents) of the destination
   * project must have [Document AI Editor
   * role](https://cloud.google.com/document-ai/docs/access-control/iam-roles) on
   * the source project.
   *
   * The destination project is specified as part of the
   * [parent][google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.parent]
   * field. The source project is specified as part of the
   * [source][google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.processor_version_source]
   * or
   * [external_processor_version_source][google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.external_processor_version_source]
   * field.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.ImportProcessorVersionRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.ImportProcessorVersionRequest)
      com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ImportProcessorVersionRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ImportProcessorVersionRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.class,
              com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (externalProcessorVersionSourceBuilder_ != null) {
        externalProcessorVersionSourceBuilder_.clear();
      }
      parent_ = "";
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ImportProcessorVersionRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
        getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest build() {
      com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest buildPartial() {
      com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest result =
          new com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.parent_ = parent_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 3 && externalProcessorVersionSourceBuilder_ != null) {
        result.source_ = externalProcessorVersionSourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest other) {
      if (other
          == com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      switch (other.getSourceCase()) {
        case PROCESSOR_VERSION_SOURCE:
          {
            sourceCase_ = 2;
            source_ = other.source_;
            onChanged();
            break;
          }
        case EXTERNAL_PROCESSOR_VERSION_SOURCE:
          {
            mergeExternalProcessorVersionSource(other.getExternalProcessorVersionSource());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                sourceCase_ = 2;
                source_ = s;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getExternalProcessorVersionSourceFieldBuilder().getBuilder(),
                    extensionRegistry);
                sourceCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * The source processor version to import from. The source processor version
     * and destination processor need to be in the same environment and region.
     * </pre>
     *
     * <code>string processor_version_source = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the processorVersionSource field is set.
     */
    @java.lang.Override
    public boolean hasProcessorVersionSource() {
      return sourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The source processor version to import from. The source processor version
     * and destination processor need to be in the same environment and region.
     * </pre>
     *
     * <code>string processor_version_source = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The processorVersionSource.
     */
    @java.lang.Override
    public java.lang.String getProcessorVersionSource() {
      java.lang.Object ref = "";
      if (sourceCase_ == 2) {
        ref = source_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceCase_ == 2) {
          source_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The source processor version to import from. The source processor version
     * and destination processor need to be in the same environment and region.
     * </pre>
     *
     * <code>string processor_version_source = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for processorVersionSource.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProcessorVersionSourceBytes() {
      java.lang.Object ref = "";
      if (sourceCase_ == 2) {
        ref = source_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceCase_ == 2) {
          source_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The source processor version to import from. The source processor version
     * and destination processor need to be in the same environment and region.
     * </pre>
     *
     * <code>string processor_version_source = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The processorVersionSource to set.
     * @return This builder for chaining.
     */
    public Builder setProcessorVersionSource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceCase_ = 2;
      source_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The source processor version to import from. The source processor version
     * and destination processor need to be in the same environment and region.
     * </pre>
     *
     * <code>string processor_version_source = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProcessorVersionSource() {
      if (sourceCase_ == 2) {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The source processor version to import from. The source processor version
     * and destination processor need to be in the same environment and region.
     * </pre>
     *
     * <code>string processor_version_source = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for processorVersionSource to set.
     * @return This builder for chaining.
     */
    public Builder setProcessorVersionSourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceCase_ = 2;
      source_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                .ExternalProcessorVersionSource,
            com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                .ExternalProcessorVersionSource.Builder,
            com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                .ExternalProcessorVersionSourceOrBuilder>
        externalProcessorVersionSourceBuilder_;
    /**
     *
     *
     * <pre>
     * The source processor version to import from. It can be from a different
     * environment and region than the destination processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.ExternalProcessorVersionSource external_processor_version_source = 3;
     * </code>
     *
     * @return Whether the externalProcessorVersionSource field is set.
     */
    @java.lang.Override
    public boolean hasExternalProcessorVersionSource() {
      return sourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The source processor version to import from. It can be from a different
     * environment and region than the destination processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.ExternalProcessorVersionSource external_processor_version_source = 3;
     * </code>
     *
     * @return The externalProcessorVersionSource.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource
        getExternalProcessorVersionSource() {
      if (externalProcessorVersionSourceBuilder_ == null) {
        if (sourceCase_ == 3) {
          return (com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                  .ExternalProcessorVersionSource)
              source_;
        }
        return com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 3) {
          return externalProcessorVersionSourceBuilder_.getMessage();
        }
        return com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The source processor version to import from. It can be from a different
     * environment and region than the destination processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.ExternalProcessorVersionSource external_processor_version_source = 3;
     * </code>
     */
    public Builder setExternalProcessorVersionSource(
        com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                .ExternalProcessorVersionSource
            value) {
      if (externalProcessorVersionSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        externalProcessorVersionSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The source processor version to import from. It can be from a different
     * environment and region than the destination processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.ExternalProcessorVersionSource external_processor_version_source = 3;
     * </code>
     */
    public Builder setExternalProcessorVersionSource(
        com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                .ExternalProcessorVersionSource.Builder
            builderForValue) {
      if (externalProcessorVersionSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        externalProcessorVersionSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The source processor version to import from. It can be from a different
     * environment and region than the destination processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.ExternalProcessorVersionSource external_processor_version_source = 3;
     * </code>
     */
    public Builder mergeExternalProcessorVersionSource(
        com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                .ExternalProcessorVersionSource
            value) {
      if (externalProcessorVersionSourceBuilder_ == null) {
        if (sourceCase_ == 3
            && source_
                != com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                    .ExternalProcessorVersionSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                  .ExternalProcessorVersionSource.newBuilder(
                      (com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                              .ExternalProcessorVersionSource)
                          source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 3) {
          externalProcessorVersionSourceBuilder_.mergeFrom(value);
        } else {
          externalProcessorVersionSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The source processor version to import from. It can be from a different
     * environment and region than the destination processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.ExternalProcessorVersionSource external_processor_version_source = 3;
     * </code>
     */
    public Builder clearExternalProcessorVersionSource() {
      if (externalProcessorVersionSourceBuilder_ == null) {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
        }
        externalProcessorVersionSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The source processor version to import from. It can be from a different
     * environment and region than the destination processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.ExternalProcessorVersionSource external_processor_version_source = 3;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource.Builder
        getExternalProcessorVersionSourceBuilder() {
      return getExternalProcessorVersionSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The source processor version to import from. It can be from a different
     * environment and region than the destination processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.ExternalProcessorVersionSource external_processor_version_source = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSourceOrBuilder
        getExternalProcessorVersionSourceOrBuilder() {
      if ((sourceCase_ == 3) && (externalProcessorVersionSourceBuilder_ != null)) {
        return externalProcessorVersionSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 3) {
          return (com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                  .ExternalProcessorVersionSource)
              source_;
        }
        return com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
            .ExternalProcessorVersionSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The source processor version to import from. It can be from a different
     * environment and region than the destination processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ImportProcessorVersionRequest.ExternalProcessorVersionSource external_processor_version_source = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                .ExternalProcessorVersionSource,
            com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                .ExternalProcessorVersionSource.Builder,
            com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                .ExternalProcessorVersionSourceOrBuilder>
        getExternalProcessorVersionSourceFieldBuilder() {
      if (externalProcessorVersionSourceBuilder_ == null) {
        if (!(sourceCase_ == 3)) {
          source_ =
              com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                  .ExternalProcessorVersionSource.getDefaultInstance();
        }
        externalProcessorVersionSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                    .ExternalProcessorVersionSource,
                com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                    .ExternalProcessorVersionSource.Builder,
                com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                    .ExternalProcessorVersionSourceOrBuilder>(
                (com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
                        .ExternalProcessorVersionSource)
                    source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 3;
      onChanged();
      return externalProcessorVersionSourceBuilder_;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The destination processor name to create the processor version
     * in. Format:
     * `projects/{project}/locations/{location}/processors/{processor}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The destination processor name to create the processor version
     * in. Format:
     * `projects/{project}/locations/{location}/processors/{processor}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The destination processor name to create the processor version
     * in. Format:
     * `projects/{project}/locations/{location}/processors/{processor}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The destination processor name to create the processor version
     * in. Format:
     * `projects/{project}/locations/{location}/processors/{processor}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The destination processor name to create the processor version
     * in. Format:
     * `projects/{project}/locations/{location}/processors/{processor}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.ImportProcessorVersionRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.ImportProcessorVersionRequest)
  private static final com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest();
  }

  public static com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportProcessorVersionRequest> PARSER =
      new com.google.protobuf.AbstractParser<ImportProcessorVersionRequest>() {
        @java.lang.Override
        public ImportProcessorVersionRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportProcessorVersionRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportProcessorVersionRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ImportProcessorVersionRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
