/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document_processor_service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * Request message for the
 * [TrainProcessorVersion][google.cloud.documentai.v1beta3.DocumentProcessorService.TrainProcessorVersion]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.TrainProcessorVersionRequest}
 */
public final class TrainProcessorVersionRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.TrainProcessorVersionRequest)
    TrainProcessorVersionRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TrainProcessorVersionRequest.newBuilder() to construct.
  private TrainProcessorVersionRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TrainProcessorVersionRequest() {
    parent_ = "";
    baseProcessorVersion_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TrainProcessorVersionRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.class,
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.Builder.class);
  }

  public interface InputDataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The documents used for training the new version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig training_documents = 3;
     * </code>
     *
     * @return Whether the trainingDocuments field is set.
     */
    boolean hasTrainingDocuments();
    /**
     *
     *
     * <pre>
     * The documents used for training the new version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig training_documents = 3;
     * </code>
     *
     * @return The trainingDocuments.
     */
    com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig getTrainingDocuments();
    /**
     *
     *
     * <pre>
     * The documents used for training the new version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig training_documents = 3;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder
        getTrainingDocumentsOrBuilder();

    /**
     *
     *
     * <pre>
     * The documents used for testing the trained version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig test_documents = 4;</code>
     *
     * @return Whether the testDocuments field is set.
     */
    boolean hasTestDocuments();
    /**
     *
     *
     * <pre>
     * The documents used for testing the trained version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig test_documents = 4;</code>
     *
     * @return The testDocuments.
     */
    com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig getTestDocuments();
    /**
     *
     *
     * <pre>
     * The documents used for testing the trained version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig test_documents = 4;</code>
     */
    com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder
        getTestDocumentsOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The input data used to train a new
   * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData}
   */
  public static final class InputData extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData)
      InputDataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use InputData.newBuilder() to construct.
    private InputData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InputData() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InputData();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionRequest_InputData_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionRequest_InputData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData.class,
              com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData.Builder
                  .class);
    }

    private int bitField0_;
    public static final int TRAINING_DOCUMENTS_FIELD_NUMBER = 3;
    private com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig trainingDocuments_;
    /**
     *
     *
     * <pre>
     * The documents used for training the new version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig training_documents = 3;
     * </code>
     *
     * @return Whether the trainingDocuments field is set.
     */
    @java.lang.Override
    public boolean hasTrainingDocuments() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The documents used for training the new version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig training_documents = 3;
     * </code>
     *
     * @return The trainingDocuments.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig getTrainingDocuments() {
      return trainingDocuments_ == null
          ? com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.getDefaultInstance()
          : trainingDocuments_;
    }
    /**
     *
     *
     * <pre>
     * The documents used for training the new version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig training_documents = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder
        getTrainingDocumentsOrBuilder() {
      return trainingDocuments_ == null
          ? com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.getDefaultInstance()
          : trainingDocuments_;
    }

    public static final int TEST_DOCUMENTS_FIELD_NUMBER = 4;
    private com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig testDocuments_;
    /**
     *
     *
     * <pre>
     * The documents used for testing the trained version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig test_documents = 4;</code>
     *
     * @return Whether the testDocuments field is set.
     */
    @java.lang.Override
    public boolean hasTestDocuments() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The documents used for testing the trained version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig test_documents = 4;</code>
     *
     * @return The testDocuments.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig getTestDocuments() {
      return testDocuments_ == null
          ? com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.getDefaultInstance()
          : testDocuments_;
    }
    /**
     *
     *
     * <pre>
     * The documents used for testing the trained version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig test_documents = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder
        getTestDocumentsOrBuilder() {
      return testDocuments_ == null
          ? com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.getDefaultInstance()
          : testDocuments_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getTrainingDocuments());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(4, getTestDocuments());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTrainingDocuments());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTestDocuments());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData other =
          (com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData) obj;

      if (hasTrainingDocuments() != other.hasTrainingDocuments()) return false;
      if (hasTrainingDocuments()) {
        if (!getTrainingDocuments().equals(other.getTrainingDocuments())) return false;
      }
      if (hasTestDocuments() != other.hasTestDocuments()) return false;
      if (hasTestDocuments()) {
        if (!getTestDocuments().equals(other.getTestDocuments())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasTrainingDocuments()) {
        hash = (37 * hash) + TRAINING_DOCUMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getTrainingDocuments().hashCode();
      }
      if (hasTestDocuments()) {
        hash = (37 * hash) + TEST_DOCUMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getTestDocuments().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The input data used to train a new
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData)
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputDataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionRequest_InputData_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionRequest_InputData_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData.class,
                com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getTrainingDocumentsFieldBuilder();
          getTestDocumentsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        trainingDocuments_ = null;
        if (trainingDocumentsBuilder_ != null) {
          trainingDocumentsBuilder_.dispose();
          trainingDocumentsBuilder_ = null;
        }
        testDocuments_ = null;
        if (testDocumentsBuilder_ != null) {
          testDocumentsBuilder_.dispose();
          testDocumentsBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionRequest_InputData_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData build() {
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
          buildPartial() {
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData result =
            new com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.trainingDocuments_ =
              trainingDocumentsBuilder_ == null
                  ? trainingDocuments_
                  : trainingDocumentsBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.testDocuments_ =
              testDocumentsBuilder_ == null ? testDocuments_ : testDocumentsBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData other) {
        if (other
            == com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
                .getDefaultInstance()) return this;
        if (other.hasTrainingDocuments()) {
          mergeTrainingDocuments(other.getTrainingDocuments());
        }
        if (other.hasTestDocuments()) {
          mergeTestDocuments(other.getTestDocuments());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 26:
                {
                  input.readMessage(
                      getTrainingDocumentsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getTestDocumentsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig trainingDocuments_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig,
              com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.Builder,
              com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder>
          trainingDocumentsBuilder_;
      /**
       *
       *
       * <pre>
       * The documents used for training the new version.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig training_documents = 3;
       * </code>
       *
       * @return Whether the trainingDocuments field is set.
       */
      public boolean hasTrainingDocuments() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The documents used for training the new version.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig training_documents = 3;
       * </code>
       *
       * @return The trainingDocuments.
       */
      public com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig getTrainingDocuments() {
        if (trainingDocumentsBuilder_ == null) {
          return trainingDocuments_ == null
              ? com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.getDefaultInstance()
              : trainingDocuments_;
        } else {
          return trainingDocumentsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The documents used for training the new version.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig training_documents = 3;
       * </code>
       */
      public Builder setTrainingDocuments(
          com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig value) {
        if (trainingDocumentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          trainingDocuments_ = value;
        } else {
          trainingDocumentsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The documents used for training the new version.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig training_documents = 3;
       * </code>
       */
      public Builder setTrainingDocuments(
          com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.Builder builderForValue) {
        if (trainingDocumentsBuilder_ == null) {
          trainingDocuments_ = builderForValue.build();
        } else {
          trainingDocumentsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The documents used for training the new version.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig training_documents = 3;
       * </code>
       */
      public Builder mergeTrainingDocuments(
          com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig value) {
        if (trainingDocumentsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && trainingDocuments_ != null
              && trainingDocuments_
                  != com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig
                      .getDefaultInstance()) {
            getTrainingDocumentsBuilder().mergeFrom(value);
          } else {
            trainingDocuments_ = value;
          }
        } else {
          trainingDocumentsBuilder_.mergeFrom(value);
        }
        if (trainingDocuments_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The documents used for training the new version.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig training_documents = 3;
       * </code>
       */
      public Builder clearTrainingDocuments() {
        bitField0_ = (bitField0_ & ~0x00000001);
        trainingDocuments_ = null;
        if (trainingDocumentsBuilder_ != null) {
          trainingDocumentsBuilder_.dispose();
          trainingDocumentsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The documents used for training the new version.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig training_documents = 3;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.Builder
          getTrainingDocumentsBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getTrainingDocumentsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The documents used for training the new version.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig training_documents = 3;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder
          getTrainingDocumentsOrBuilder() {
        if (trainingDocumentsBuilder_ != null) {
          return trainingDocumentsBuilder_.getMessageOrBuilder();
        } else {
          return trainingDocuments_ == null
              ? com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.getDefaultInstance()
              : trainingDocuments_;
        }
      }
      /**
       *
       *
       * <pre>
       * The documents used for training the new version.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig training_documents = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig,
              com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.Builder,
              com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder>
          getTrainingDocumentsFieldBuilder() {
        if (trainingDocumentsBuilder_ == null) {
          trainingDocumentsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig,
                  com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.Builder,
                  com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder>(
                  getTrainingDocuments(), getParentForChildren(), isClean());
          trainingDocuments_ = null;
        }
        return trainingDocumentsBuilder_;
      }

      private com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig testDocuments_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig,
              com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.Builder,
              com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder>
          testDocumentsBuilder_;
      /**
       *
       *
       * <pre>
       * The documents used for testing the trained version.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig test_documents = 4;</code>
       *
       * @return Whether the testDocuments field is set.
       */
      public boolean hasTestDocuments() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The documents used for testing the trained version.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig test_documents = 4;</code>
       *
       * @return The testDocuments.
       */
      public com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig getTestDocuments() {
        if (testDocumentsBuilder_ == null) {
          return testDocuments_ == null
              ? com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.getDefaultInstance()
              : testDocuments_;
        } else {
          return testDocumentsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The documents used for testing the trained version.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig test_documents = 4;</code>
       */
      public Builder setTestDocuments(
          com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig value) {
        if (testDocumentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          testDocuments_ = value;
        } else {
          testDocumentsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The documents used for testing the trained version.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig test_documents = 4;</code>
       */
      public Builder setTestDocuments(
          com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.Builder builderForValue) {
        if (testDocumentsBuilder_ == null) {
          testDocuments_ = builderForValue.build();
        } else {
          testDocumentsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The documents used for testing the trained version.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig test_documents = 4;</code>
       */
      public Builder mergeTestDocuments(
          com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig value) {
        if (testDocumentsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && testDocuments_ != null
              && testDocuments_
                  != com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig
                      .getDefaultInstance()) {
            getTestDocumentsBuilder().mergeFrom(value);
          } else {
            testDocuments_ = value;
          }
        } else {
          testDocumentsBuilder_.mergeFrom(value);
        }
        if (testDocuments_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The documents used for testing the trained version.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig test_documents = 4;</code>
       */
      public Builder clearTestDocuments() {
        bitField0_ = (bitField0_ & ~0x00000002);
        testDocuments_ = null;
        if (testDocumentsBuilder_ != null) {
          testDocumentsBuilder_.dispose();
          testDocumentsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The documents used for testing the trained version.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig test_documents = 4;</code>
       */
      public com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.Builder
          getTestDocumentsBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getTestDocumentsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The documents used for testing the trained version.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig test_documents = 4;</code>
       */
      public com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder
          getTestDocumentsOrBuilder() {
        if (testDocumentsBuilder_ != null) {
          return testDocumentsBuilder_.getMessageOrBuilder();
        } else {
          return testDocuments_ == null
              ? com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.getDefaultInstance()
              : testDocuments_;
        }
      }
      /**
       *
       *
       * <pre>
       * The documents used for testing the trained version.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig test_documents = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig,
              com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.Builder,
              com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder>
          getTestDocumentsFieldBuilder() {
        if (testDocumentsBuilder_ == null) {
          testDocumentsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig,
                  com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.Builder,
                  com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder>(
                  getTestDocuments(), getParentForChildren(), isClean());
          testDocuments_ = null;
        }
        return testDocumentsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData)
    private static final com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData();
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InputData> PARSER =
        new com.google.protobuf.AbstractParser<InputData>() {
          @java.lang.Override
          public InputData parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InputData> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InputData> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CustomDocumentExtractionOptionsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Training method to use for CDE training.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions.TrainingMethod training_method = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for trainingMethod.
     */
    int getTrainingMethodValue();
    /**
     *
     *
     * <pre>
     * Training method to use for CDE training.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions.TrainingMethod training_method = 3;
     * </code>
     *
     * @return The trainingMethod.
     */
    com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions
            .TrainingMethod
        getTrainingMethod();
  }
  /**
   *
   *
   * <pre>
   * Options to control the training of the Custom Document Extraction (CDE)
   * Processor.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions}
   */
  public static final class CustomDocumentExtractionOptions
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions)
      CustomDocumentExtractionOptionsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CustomDocumentExtractionOptions.newBuilder() to construct.
    private CustomDocumentExtractionOptions(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CustomDocumentExtractionOptions() {
      trainingMethod_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CustomDocumentExtractionOptions();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionRequest_CustomDocumentExtractionOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionRequest_CustomDocumentExtractionOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                  .CustomDocumentExtractionOptions.class,
              com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                  .CustomDocumentExtractionOptions.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Training Method for CDE. `TRAINING_METHOD_UNSPECIFIED` will fall back to
     * `MODEL_BASED`.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions.TrainingMethod}
     */
    public enum TrainingMethod implements com.google.protobuf.ProtocolMessageEnum {
      /** <code>TRAINING_METHOD_UNSPECIFIED = 0;</code> */
      TRAINING_METHOD_UNSPECIFIED(0),
      /** <code>MODEL_BASED = 1;</code> */
      MODEL_BASED(1),
      /** <code>TEMPLATE_BASED = 2;</code> */
      TEMPLATE_BASED(2),
      UNRECOGNIZED(-1),
      ;

      /** <code>TRAINING_METHOD_UNSPECIFIED = 0;</code> */
      public static final int TRAINING_METHOD_UNSPECIFIED_VALUE = 0;
      /** <code>MODEL_BASED = 1;</code> */
      public static final int MODEL_BASED_VALUE = 1;
      /** <code>TEMPLATE_BASED = 2;</code> */
      public static final int TEMPLATE_BASED_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static TrainingMethod valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static TrainingMethod forNumber(int value) {
        switch (value) {
          case 0:
            return TRAINING_METHOD_UNSPECIFIED;
          case 1:
            return MODEL_BASED;
          case 2:
            return TEMPLATE_BASED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<TrainingMethod> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<TrainingMethod>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<TrainingMethod>() {
                public TrainingMethod findValueByNumber(int number) {
                  return TrainingMethod.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final TrainingMethod[] VALUES = values();

      public static TrainingMethod valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private TrainingMethod(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions.TrainingMethod)
    }

    public static final int TRAINING_METHOD_FIELD_NUMBER = 3;
    private int trainingMethod_ = 0;
    /**
     *
     *
     * <pre>
     * Training method to use for CDE training.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions.TrainingMethod training_method = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for trainingMethod.
     */
    @java.lang.Override
    public int getTrainingMethodValue() {
      return trainingMethod_;
    }
    /**
     *
     *
     * <pre>
     * Training method to use for CDE training.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions.TrainingMethod training_method = 3;
     * </code>
     *
     * @return The trainingMethod.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions.TrainingMethod
        getTrainingMethod() {
      com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
              .CustomDocumentExtractionOptions.TrainingMethod
          result =
              com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                  .CustomDocumentExtractionOptions.TrainingMethod.forNumber(trainingMethod_);
      return result == null
          ? com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
              .CustomDocumentExtractionOptions.TrainingMethod.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (trainingMethod_
          != com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
              .CustomDocumentExtractionOptions.TrainingMethod.TRAINING_METHOD_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, trainingMethod_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (trainingMethod_
          != com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
              .CustomDocumentExtractionOptions.TrainingMethod.TRAINING_METHOD_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, trainingMethod_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
              .CustomDocumentExtractionOptions)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
              .CustomDocumentExtractionOptions
          other =
              (com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                      .CustomDocumentExtractionOptions)
                  obj;

      if (trainingMethod_ != other.trainingMethod_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TRAINING_METHOD_FIELD_NUMBER;
      hash = (53 * hash) + trainingMethod_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                .CustomDocumentExtractionOptions
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Options to control the training of the Custom Document Extraction (CDE)
     * Processor.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions)
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionRequest_CustomDocumentExtractionOptions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionRequest_CustomDocumentExtractionOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                    .CustomDocumentExtractionOptions.class,
                com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                    .CustomDocumentExtractionOptions.Builder.class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        trainingMethod_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionRequest_CustomDocumentExtractionOptions_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
              .CustomDocumentExtractionOptions
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
              .CustomDocumentExtractionOptions
          build() {
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                .CustomDocumentExtractionOptions
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
              .CustomDocumentExtractionOptions
          buildPartial() {
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                .CustomDocumentExtractionOptions
            result =
                new com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                    .CustomDocumentExtractionOptions(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                  .CustomDocumentExtractionOptions
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.trainingMethod_ = trainingMethod_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                .CustomDocumentExtractionOptions) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                      .CustomDocumentExtractionOptions)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                  .CustomDocumentExtractionOptions
              other) {
        if (other
            == com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                .CustomDocumentExtractionOptions.getDefaultInstance()) return this;
        if (other.trainingMethod_ != 0) {
          setTrainingMethodValue(other.getTrainingMethodValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 24:
                {
                  trainingMethod_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int trainingMethod_ = 0;
      /**
       *
       *
       * <pre>
       * Training method to use for CDE training.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions.TrainingMethod training_method = 3;
       * </code>
       *
       * @return The enum numeric value on the wire for trainingMethod.
       */
      @java.lang.Override
      public int getTrainingMethodValue() {
        return trainingMethod_;
      }
      /**
       *
       *
       * <pre>
       * Training method to use for CDE training.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions.TrainingMethod training_method = 3;
       * </code>
       *
       * @param value The enum numeric value on the wire for trainingMethod to set.
       * @return This builder for chaining.
       */
      public Builder setTrainingMethodValue(int value) {
        trainingMethod_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Training method to use for CDE training.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions.TrainingMethod training_method = 3;
       * </code>
       *
       * @return The trainingMethod.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
              .CustomDocumentExtractionOptions.TrainingMethod
          getTrainingMethod() {
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                .CustomDocumentExtractionOptions.TrainingMethod
            result =
                com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                    .CustomDocumentExtractionOptions.TrainingMethod.forNumber(trainingMethod_);
        return result == null
            ? com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                .CustomDocumentExtractionOptions.TrainingMethod.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Training method to use for CDE training.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions.TrainingMethod training_method = 3;
       * </code>
       *
       * @param value The trainingMethod to set.
       * @return This builder for chaining.
       */
      public Builder setTrainingMethod(
          com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                  .CustomDocumentExtractionOptions.TrainingMethod
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        trainingMethod_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Training method to use for CDE training.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions.TrainingMethod training_method = 3;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTrainingMethod() {
        bitField0_ = (bitField0_ & ~0x00000001);
        trainingMethod_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions)
    private static final com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
              .CustomDocumentExtractionOptions();
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CustomDocumentExtractionOptions> PARSER =
        new com.google.protobuf.AbstractParser<CustomDocumentExtractionOptions>() {
          @java.lang.Override
          public CustomDocumentExtractionOptions parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CustomDocumentExtractionOptions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CustomDocumentExtractionOptions> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int processorFlagsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object processorFlags_;

  public enum ProcessorFlagsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CUSTOM_DOCUMENT_EXTRACTION_OPTIONS(5),
    PROCESSORFLAGS_NOT_SET(0);
    private final int value;

    private ProcessorFlagsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ProcessorFlagsCase valueOf(int value) {
      return forNumber(value);
    }

    public static ProcessorFlagsCase forNumber(int value) {
      switch (value) {
        case 5:
          return CUSTOM_DOCUMENT_EXTRACTION_OPTIONS;
        case 0:
          return PROCESSORFLAGS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ProcessorFlagsCase getProcessorFlagsCase() {
    return ProcessorFlagsCase.forNumber(processorFlagsCase_);
  }

  public static final int CUSTOM_DOCUMENT_EXTRACTION_OPTIONS_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Options to control Custom Document Extraction (CDE) Processor.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions custom_document_extraction_options = 5;
   * </code>
   *
   * @return Whether the customDocumentExtractionOptions field is set.
   */
  @java.lang.Override
  public boolean hasCustomDocumentExtractionOptions() {
    return processorFlagsCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Options to control Custom Document Extraction (CDE) Processor.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions custom_document_extraction_options = 5;
   * </code>
   *
   * @return The customDocumentExtractionOptions.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
          .CustomDocumentExtractionOptions
      getCustomDocumentExtractionOptions() {
    if (processorFlagsCase_ == 5) {
      return (com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
              .CustomDocumentExtractionOptions)
          processorFlags_;
    }
    return com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
        .CustomDocumentExtractionOptions.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Options to control Custom Document Extraction (CDE) Processor.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions custom_document_extraction_options = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
          .CustomDocumentExtractionOptionsOrBuilder
      getCustomDocumentExtractionOptionsOrBuilder() {
    if (processorFlagsCase_ == 5) {
      return (com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
              .CustomDocumentExtractionOptions)
          processorFlags_;
    }
    return com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
        .CustomDocumentExtractionOptions.getDefaultInstance();
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The parent (project, location and processor) to create the new
   * version for. Format:
   * `projects/{project}/locations/{location}/processors/{processor}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent (project, location and processor) to create the new
   * version for. Format:
   * `projects/{project}/locations/{location}/processors/{processor}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROCESSOR_VERSION_FIELD_NUMBER = 2;
  private com.google.cloud.documentai.v1beta3.ProcessorVersion processorVersion_;
  /**
   *
   *
   * <pre>
   * Required. The processor version to be created.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.ProcessorVersion processor_version = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the processorVersion field is set.
   */
  @java.lang.Override
  public boolean hasProcessorVersion() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The processor version to be created.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.ProcessorVersion processor_version = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The processorVersion.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ProcessorVersion getProcessorVersion() {
    return processorVersion_ == null
        ? com.google.cloud.documentai.v1beta3.ProcessorVersion.getDefaultInstance()
        : processorVersion_;
  }
  /**
   *
   *
   * <pre>
   * Required. The processor version to be created.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.ProcessorVersion processor_version = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ProcessorVersionOrBuilder
      getProcessorVersionOrBuilder() {
    return processorVersion_ == null
        ? com.google.cloud.documentai.v1beta3.ProcessorVersion.getDefaultInstance()
        : processorVersion_;
  }

  public static final int DOCUMENT_SCHEMA_FIELD_NUMBER = 10;
  private com.google.cloud.documentai.v1beta3.DocumentSchema documentSchema_;
  /**
   *
   *
   * <pre>
   * Optional. The schema the processor version will be trained with.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.DocumentSchema document_schema = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the documentSchema field is set.
   */
  @java.lang.Override
  public boolean hasDocumentSchema() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The schema the processor version will be trained with.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.DocumentSchema document_schema = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The documentSchema.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentSchema getDocumentSchema() {
    return documentSchema_ == null
        ? com.google.cloud.documentai.v1beta3.DocumentSchema.getDefaultInstance()
        : documentSchema_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The schema the processor version will be trained with.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.DocumentSchema document_schema = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentSchemaOrBuilder getDocumentSchemaOrBuilder() {
    return documentSchema_ == null
        ? com.google.cloud.documentai.v1beta3.DocumentSchema.getDefaultInstance()
        : documentSchema_;
  }

  public static final int INPUT_DATA_FIELD_NUMBER = 4;
  private com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData inputData_;
  /**
   *
   *
   * <pre>
   * Optional. The input data used to train the
   * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData input_data = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the inputData field is set.
   */
  @java.lang.Override
  public boolean hasInputData() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The input data used to train the
   * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData input_data = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The inputData.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData getInputData() {
    return inputData_ == null
        ? com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
            .getDefaultInstance()
        : inputData_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The input data used to train the
   * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData input_data = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputDataOrBuilder
      getInputDataOrBuilder() {
    return inputData_ == null
        ? com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
            .getDefaultInstance()
        : inputData_;
  }

  public static final int BASE_PROCESSOR_VERSION_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object baseProcessorVersion_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The processor version to use as a base for training. This
   * processor version must be a child of `parent`. Format:
   * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`.
   * </pre>
   *
   * <code>string base_processor_version = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The baseProcessorVersion.
   */
  @java.lang.Override
  public java.lang.String getBaseProcessorVersion() {
    java.lang.Object ref = baseProcessorVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      baseProcessorVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The processor version to use as a base for training. This
   * processor version must be a child of `parent`. Format:
   * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`.
   * </pre>
   *
   * <code>string base_processor_version = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for baseProcessorVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBaseProcessorVersionBytes() {
    java.lang.Object ref = baseProcessorVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      baseProcessorVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getProcessorVersion());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getInputData());
    }
    if (processorFlagsCase_ == 5) {
      output.writeMessage(
          5,
          (com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                  .CustomDocumentExtractionOptions)
              processorFlags_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(baseProcessorVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, baseProcessorVersion_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(10, getDocumentSchema());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getProcessorVersion());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getInputData());
    }
    if (processorFlagsCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5,
              (com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                      .CustomDocumentExtractionOptions)
                  processorFlags_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(baseProcessorVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, baseProcessorVersion_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getDocumentSchema());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest other =
        (com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasProcessorVersion() != other.hasProcessorVersion()) return false;
    if (hasProcessorVersion()) {
      if (!getProcessorVersion().equals(other.getProcessorVersion())) return false;
    }
    if (hasDocumentSchema() != other.hasDocumentSchema()) return false;
    if (hasDocumentSchema()) {
      if (!getDocumentSchema().equals(other.getDocumentSchema())) return false;
    }
    if (hasInputData() != other.hasInputData()) return false;
    if (hasInputData()) {
      if (!getInputData().equals(other.getInputData())) return false;
    }
    if (!getBaseProcessorVersion().equals(other.getBaseProcessorVersion())) return false;
    if (!getProcessorFlagsCase().equals(other.getProcessorFlagsCase())) return false;
    switch (processorFlagsCase_) {
      case 5:
        if (!getCustomDocumentExtractionOptions()
            .equals(other.getCustomDocumentExtractionOptions())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasProcessorVersion()) {
      hash = (37 * hash) + PROCESSOR_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getProcessorVersion().hashCode();
    }
    if (hasDocumentSchema()) {
      hash = (37 * hash) + DOCUMENT_SCHEMA_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentSchema().hashCode();
    }
    if (hasInputData()) {
      hash = (37 * hash) + INPUT_DATA_FIELD_NUMBER;
      hash = (53 * hash) + getInputData().hashCode();
    }
    hash = (37 * hash) + BASE_PROCESSOR_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getBaseProcessorVersion().hashCode();
    switch (processorFlagsCase_) {
      case 5:
        hash = (37 * hash) + CUSTOM_DOCUMENT_EXTRACTION_OPTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getCustomDocumentExtractionOptions().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for the
   * [TrainProcessorVersion][google.cloud.documentai.v1beta3.DocumentProcessorService.TrainProcessorVersion]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.TrainProcessorVersionRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.TrainProcessorVersionRequest)
      com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.class,
              com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getProcessorVersionFieldBuilder();
        getDocumentSchemaFieldBuilder();
        getInputDataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (customDocumentExtractionOptionsBuilder_ != null) {
        customDocumentExtractionOptionsBuilder_.clear();
      }
      parent_ = "";
      processorVersion_ = null;
      if (processorVersionBuilder_ != null) {
        processorVersionBuilder_.dispose();
        processorVersionBuilder_ = null;
      }
      documentSchema_ = null;
      if (documentSchemaBuilder_ != null) {
        documentSchemaBuilder_.dispose();
        documentSchemaBuilder_ = null;
      }
      inputData_ = null;
      if (inputDataBuilder_ != null) {
        inputDataBuilder_.dispose();
        inputDataBuilder_ = null;
      }
      baseProcessorVersion_ = "";
      processorFlagsCase_ = 0;
      processorFlags_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
        getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest build() {
      com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest buildPartial() {
      com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest result =
          new com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.parent_ = parent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.processorVersion_ =
            processorVersionBuilder_ == null ? processorVersion_ : processorVersionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.documentSchema_ =
            documentSchemaBuilder_ == null ? documentSchema_ : documentSchemaBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.inputData_ = inputDataBuilder_ == null ? inputData_ : inputDataBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.baseProcessorVersion_ = baseProcessorVersion_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest result) {
      result.processorFlagsCase_ = processorFlagsCase_;
      result.processorFlags_ = this.processorFlags_;
      if (processorFlagsCase_ == 5 && customDocumentExtractionOptionsBuilder_ != null) {
        result.processorFlags_ = customDocumentExtractionOptionsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest other) {
      if (other
          == com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasProcessorVersion()) {
        mergeProcessorVersion(other.getProcessorVersion());
      }
      if (other.hasDocumentSchema()) {
        mergeDocumentSchema(other.getDocumentSchema());
      }
      if (other.hasInputData()) {
        mergeInputData(other.getInputData());
      }
      if (!other.getBaseProcessorVersion().isEmpty()) {
        baseProcessorVersion_ = other.baseProcessorVersion_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      switch (other.getProcessorFlagsCase()) {
        case CUSTOM_DOCUMENT_EXTRACTION_OPTIONS:
          {
            mergeCustomDocumentExtractionOptions(other.getCustomDocumentExtractionOptions());
            break;
          }
        case PROCESSORFLAGS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getProcessorVersionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 34:
              {
                input.readMessage(getInputDataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getCustomDocumentExtractionOptionsFieldBuilder().getBuilder(),
                    extensionRegistry);
                processorFlagsCase_ = 5;
                break;
              } // case 42
            case 66:
              {
                baseProcessorVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 66
            case 82:
              {
                input.readMessage(getDocumentSchemaFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int processorFlagsCase_ = 0;
    private java.lang.Object processorFlags_;

    public ProcessorFlagsCase getProcessorFlagsCase() {
      return ProcessorFlagsCase.forNumber(processorFlagsCase_);
    }

    public Builder clearProcessorFlags() {
      processorFlagsCase_ = 0;
      processorFlags_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                .CustomDocumentExtractionOptions,
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                .CustomDocumentExtractionOptions.Builder,
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                .CustomDocumentExtractionOptionsOrBuilder>
        customDocumentExtractionOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Options to control Custom Document Extraction (CDE) Processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions custom_document_extraction_options = 5;
     * </code>
     *
     * @return Whether the customDocumentExtractionOptions field is set.
     */
    @java.lang.Override
    public boolean hasCustomDocumentExtractionOptions() {
      return processorFlagsCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Options to control Custom Document Extraction (CDE) Processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions custom_document_extraction_options = 5;
     * </code>
     *
     * @return The customDocumentExtractionOptions.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions
        getCustomDocumentExtractionOptions() {
      if (customDocumentExtractionOptionsBuilder_ == null) {
        if (processorFlagsCase_ == 5) {
          return (com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                  .CustomDocumentExtractionOptions)
              processorFlags_;
        }
        return com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions.getDefaultInstance();
      } else {
        if (processorFlagsCase_ == 5) {
          return customDocumentExtractionOptionsBuilder_.getMessage();
        }
        return com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Options to control Custom Document Extraction (CDE) Processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions custom_document_extraction_options = 5;
     * </code>
     */
    public Builder setCustomDocumentExtractionOptions(
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                .CustomDocumentExtractionOptions
            value) {
      if (customDocumentExtractionOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        processorFlags_ = value;
        onChanged();
      } else {
        customDocumentExtractionOptionsBuilder_.setMessage(value);
      }
      processorFlagsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options to control Custom Document Extraction (CDE) Processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions custom_document_extraction_options = 5;
     * </code>
     */
    public Builder setCustomDocumentExtractionOptions(
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                .CustomDocumentExtractionOptions.Builder
            builderForValue) {
      if (customDocumentExtractionOptionsBuilder_ == null) {
        processorFlags_ = builderForValue.build();
        onChanged();
      } else {
        customDocumentExtractionOptionsBuilder_.setMessage(builderForValue.build());
      }
      processorFlagsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options to control Custom Document Extraction (CDE) Processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions custom_document_extraction_options = 5;
     * </code>
     */
    public Builder mergeCustomDocumentExtractionOptions(
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                .CustomDocumentExtractionOptions
            value) {
      if (customDocumentExtractionOptionsBuilder_ == null) {
        if (processorFlagsCase_ == 5
            && processorFlags_
                != com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                    .CustomDocumentExtractionOptions.getDefaultInstance()) {
          processorFlags_ =
              com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                  .CustomDocumentExtractionOptions.newBuilder(
                      (com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                              .CustomDocumentExtractionOptions)
                          processorFlags_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          processorFlags_ = value;
        }
        onChanged();
      } else {
        if (processorFlagsCase_ == 5) {
          customDocumentExtractionOptionsBuilder_.mergeFrom(value);
        } else {
          customDocumentExtractionOptionsBuilder_.setMessage(value);
        }
      }
      processorFlagsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options to control Custom Document Extraction (CDE) Processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions custom_document_extraction_options = 5;
     * </code>
     */
    public Builder clearCustomDocumentExtractionOptions() {
      if (customDocumentExtractionOptionsBuilder_ == null) {
        if (processorFlagsCase_ == 5) {
          processorFlagsCase_ = 0;
          processorFlags_ = null;
          onChanged();
        }
      } else {
        if (processorFlagsCase_ == 5) {
          processorFlagsCase_ = 0;
          processorFlags_ = null;
        }
        customDocumentExtractionOptionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options to control Custom Document Extraction (CDE) Processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions custom_document_extraction_options = 5;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions.Builder
        getCustomDocumentExtractionOptionsBuilder() {
      return getCustomDocumentExtractionOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Options to control Custom Document Extraction (CDE) Processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions custom_document_extraction_options = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptionsOrBuilder
        getCustomDocumentExtractionOptionsOrBuilder() {
      if ((processorFlagsCase_ == 5) && (customDocumentExtractionOptionsBuilder_ != null)) {
        return customDocumentExtractionOptionsBuilder_.getMessageOrBuilder();
      } else {
        if (processorFlagsCase_ == 5) {
          return (com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                  .CustomDocumentExtractionOptions)
              processorFlags_;
        }
        return com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
            .CustomDocumentExtractionOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Options to control Custom Document Extraction (CDE) Processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.CustomDocumentExtractionOptions custom_document_extraction_options = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                .CustomDocumentExtractionOptions,
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                .CustomDocumentExtractionOptions.Builder,
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                .CustomDocumentExtractionOptionsOrBuilder>
        getCustomDocumentExtractionOptionsFieldBuilder() {
      if (customDocumentExtractionOptionsBuilder_ == null) {
        if (!(processorFlagsCase_ == 5)) {
          processorFlags_ =
              com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                  .CustomDocumentExtractionOptions.getDefaultInstance();
        }
        customDocumentExtractionOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                    .CustomDocumentExtractionOptions,
                com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                    .CustomDocumentExtractionOptions.Builder,
                com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                    .CustomDocumentExtractionOptionsOrBuilder>(
                (com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                        .CustomDocumentExtractionOptions)
                    processorFlags_,
                getParentForChildren(),
                isClean());
        processorFlags_ = null;
      }
      processorFlagsCase_ = 5;
      onChanged();
      return customDocumentExtractionOptionsBuilder_;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent (project, location and processor) to create the new
     * version for. Format:
     * `projects/{project}/locations/{location}/processors/{processor}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent (project, location and processor) to create the new
     * version for. Format:
     * `projects/{project}/locations/{location}/processors/{processor}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent (project, location and processor) to create the new
     * version for. Format:
     * `projects/{project}/locations/{location}/processors/{processor}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent (project, location and processor) to create the new
     * version for. Format:
     * `projects/{project}/locations/{location}/processors/{processor}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent (project, location and processor) to create the new
     * version for. Format:
     * `projects/{project}/locations/{location}/processors/{processor}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.documentai.v1beta3.ProcessorVersion processorVersion_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ProcessorVersion,
            com.google.cloud.documentai.v1beta3.ProcessorVersion.Builder,
            com.google.cloud.documentai.v1beta3.ProcessorVersionOrBuilder>
        processorVersionBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The processor version to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessorVersion processor_version = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the processorVersion field is set.
     */
    public boolean hasProcessorVersion() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The processor version to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessorVersion processor_version = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The processorVersion.
     */
    public com.google.cloud.documentai.v1beta3.ProcessorVersion getProcessorVersion() {
      if (processorVersionBuilder_ == null) {
        return processorVersion_ == null
            ? com.google.cloud.documentai.v1beta3.ProcessorVersion.getDefaultInstance()
            : processorVersion_;
      } else {
        return processorVersionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The processor version to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessorVersion processor_version = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setProcessorVersion(com.google.cloud.documentai.v1beta3.ProcessorVersion value) {
      if (processorVersionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        processorVersion_ = value;
      } else {
        processorVersionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The processor version to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessorVersion processor_version = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setProcessorVersion(
        com.google.cloud.documentai.v1beta3.ProcessorVersion.Builder builderForValue) {
      if (processorVersionBuilder_ == null) {
        processorVersion_ = builderForValue.build();
      } else {
        processorVersionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The processor version to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessorVersion processor_version = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeProcessorVersion(
        com.google.cloud.documentai.v1beta3.ProcessorVersion value) {
      if (processorVersionBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && processorVersion_ != null
            && processorVersion_
                != com.google.cloud.documentai.v1beta3.ProcessorVersion.getDefaultInstance()) {
          getProcessorVersionBuilder().mergeFrom(value);
        } else {
          processorVersion_ = value;
        }
      } else {
        processorVersionBuilder_.mergeFrom(value);
      }
      if (processorVersion_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The processor version to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessorVersion processor_version = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearProcessorVersion() {
      bitField0_ = (bitField0_ & ~0x00000004);
      processorVersion_ = null;
      if (processorVersionBuilder_ != null) {
        processorVersionBuilder_.dispose();
        processorVersionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The processor version to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessorVersion processor_version = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ProcessorVersion.Builder
        getProcessorVersionBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getProcessorVersionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The processor version to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessorVersion processor_version = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ProcessorVersionOrBuilder
        getProcessorVersionOrBuilder() {
      if (processorVersionBuilder_ != null) {
        return processorVersionBuilder_.getMessageOrBuilder();
      } else {
        return processorVersion_ == null
            ? com.google.cloud.documentai.v1beta3.ProcessorVersion.getDefaultInstance()
            : processorVersion_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The processor version to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessorVersion processor_version = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ProcessorVersion,
            com.google.cloud.documentai.v1beta3.ProcessorVersion.Builder,
            com.google.cloud.documentai.v1beta3.ProcessorVersionOrBuilder>
        getProcessorVersionFieldBuilder() {
      if (processorVersionBuilder_ == null) {
        processorVersionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.ProcessorVersion,
                com.google.cloud.documentai.v1beta3.ProcessorVersion.Builder,
                com.google.cloud.documentai.v1beta3.ProcessorVersionOrBuilder>(
                getProcessorVersion(), getParentForChildren(), isClean());
        processorVersion_ = null;
      }
      return processorVersionBuilder_;
    }

    private com.google.cloud.documentai.v1beta3.DocumentSchema documentSchema_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentSchema,
            com.google.cloud.documentai.v1beta3.DocumentSchema.Builder,
            com.google.cloud.documentai.v1beta3.DocumentSchemaOrBuilder>
        documentSchemaBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The schema the processor version will be trained with.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentSchema document_schema = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the documentSchema field is set.
     */
    public boolean hasDocumentSchema() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The schema the processor version will be trained with.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentSchema document_schema = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The documentSchema.
     */
    public com.google.cloud.documentai.v1beta3.DocumentSchema getDocumentSchema() {
      if (documentSchemaBuilder_ == null) {
        return documentSchema_ == null
            ? com.google.cloud.documentai.v1beta3.DocumentSchema.getDefaultInstance()
            : documentSchema_;
      } else {
        return documentSchemaBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The schema the processor version will be trained with.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentSchema document_schema = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDocumentSchema(com.google.cloud.documentai.v1beta3.DocumentSchema value) {
      if (documentSchemaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentSchema_ = value;
      } else {
        documentSchemaBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The schema the processor version will be trained with.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentSchema document_schema = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDocumentSchema(
        com.google.cloud.documentai.v1beta3.DocumentSchema.Builder builderForValue) {
      if (documentSchemaBuilder_ == null) {
        documentSchema_ = builderForValue.build();
      } else {
        documentSchemaBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The schema the processor version will be trained with.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentSchema document_schema = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDocumentSchema(com.google.cloud.documentai.v1beta3.DocumentSchema value) {
      if (documentSchemaBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && documentSchema_ != null
            && documentSchema_
                != com.google.cloud.documentai.v1beta3.DocumentSchema.getDefaultInstance()) {
          getDocumentSchemaBuilder().mergeFrom(value);
        } else {
          documentSchema_ = value;
        }
      } else {
        documentSchemaBuilder_.mergeFrom(value);
      }
      if (documentSchema_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The schema the processor version will be trained with.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentSchema document_schema = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDocumentSchema() {
      bitField0_ = (bitField0_ & ~0x00000008);
      documentSchema_ = null;
      if (documentSchemaBuilder_ != null) {
        documentSchemaBuilder_.dispose();
        documentSchemaBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The schema the processor version will be trained with.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentSchema document_schema = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentSchema.Builder getDocumentSchemaBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getDocumentSchemaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The schema the processor version will be trained with.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentSchema document_schema = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentSchemaOrBuilder
        getDocumentSchemaOrBuilder() {
      if (documentSchemaBuilder_ != null) {
        return documentSchemaBuilder_.getMessageOrBuilder();
      } else {
        return documentSchema_ == null
            ? com.google.cloud.documentai.v1beta3.DocumentSchema.getDefaultInstance()
            : documentSchema_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The schema the processor version will be trained with.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentSchema document_schema = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentSchema,
            com.google.cloud.documentai.v1beta3.DocumentSchema.Builder,
            com.google.cloud.documentai.v1beta3.DocumentSchemaOrBuilder>
        getDocumentSchemaFieldBuilder() {
      if (documentSchemaBuilder_ == null) {
        documentSchemaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.DocumentSchema,
                com.google.cloud.documentai.v1beta3.DocumentSchema.Builder,
                com.google.cloud.documentai.v1beta3.DocumentSchemaOrBuilder>(
                getDocumentSchema(), getParentForChildren(), isClean());
        documentSchema_ = null;
      }
      return documentSchemaBuilder_;
    }

    private com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData inputData_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData,
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData.Builder,
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputDataOrBuilder>
        inputDataBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The input data used to train the
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData input_data = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the inputData field is set.
     */
    public boolean hasInputData() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The input data used to train the
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData input_data = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The inputData.
     */
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
        getInputData() {
      if (inputDataBuilder_ == null) {
        return inputData_ == null
            ? com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
                .getDefaultInstance()
            : inputData_;
      } else {
        return inputDataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The input data used to train the
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData input_data = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInputData(
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData value) {
      if (inputDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputData_ = value;
      } else {
        inputDataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The input data used to train the
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData input_data = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInputData(
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData.Builder
            builderForValue) {
      if (inputDataBuilder_ == null) {
        inputData_ = builderForValue.build();
      } else {
        inputDataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The input data used to train the
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData input_data = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeInputData(
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData value) {
      if (inputDataBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && inputData_ != null
            && inputData_
                != com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
                    .getDefaultInstance()) {
          getInputDataBuilder().mergeFrom(value);
        } else {
          inputData_ = value;
        }
      } else {
        inputDataBuilder_.mergeFrom(value);
      }
      if (inputData_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The input data used to train the
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData input_data = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearInputData() {
      bitField0_ = (bitField0_ & ~0x00000010);
      inputData_ = null;
      if (inputDataBuilder_ != null) {
        inputDataBuilder_.dispose();
        inputDataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The input data used to train the
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData input_data = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData.Builder
        getInputDataBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getInputDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The input data used to train the
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData input_data = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputDataOrBuilder
        getInputDataOrBuilder() {
      if (inputDataBuilder_ != null) {
        return inputDataBuilder_.getMessageOrBuilder();
      } else {
        return inputData_ == null
            ? com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData
                .getDefaultInstance()
            : inputData_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The input data used to train the
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData input_data = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData,
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData.Builder,
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputDataOrBuilder>
        getInputDataFieldBuilder() {
      if (inputDataBuilder_ == null) {
        inputDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData,
                com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest.InputData.Builder,
                com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
                    .InputDataOrBuilder>(getInputData(), getParentForChildren(), isClean());
        inputData_ = null;
      }
      return inputDataBuilder_;
    }

    private java.lang.Object baseProcessorVersion_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The processor version to use as a base for training. This
     * processor version must be a child of `parent`. Format:
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`.
     * </pre>
     *
     * <code>string base_processor_version = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The baseProcessorVersion.
     */
    public java.lang.String getBaseProcessorVersion() {
      java.lang.Object ref = baseProcessorVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        baseProcessorVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The processor version to use as a base for training. This
     * processor version must be a child of `parent`. Format:
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`.
     * </pre>
     *
     * <code>string base_processor_version = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for baseProcessorVersion.
     */
    public com.google.protobuf.ByteString getBaseProcessorVersionBytes() {
      java.lang.Object ref = baseProcessorVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        baseProcessorVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The processor version to use as a base for training. This
     * processor version must be a child of `parent`. Format:
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`.
     * </pre>
     *
     * <code>string base_processor_version = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The baseProcessorVersion to set.
     * @return This builder for chaining.
     */
    public Builder setBaseProcessorVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      baseProcessorVersion_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The processor version to use as a base for training. This
     * processor version must be a child of `parent`. Format:
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`.
     * </pre>
     *
     * <code>string base_processor_version = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBaseProcessorVersion() {
      baseProcessorVersion_ = getDefaultInstance().getBaseProcessorVersion();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The processor version to use as a base for training. This
     * processor version must be a child of `parent`. Format:
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`.
     * </pre>
     *
     * <code>string base_processor_version = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for baseProcessorVersion to set.
     * @return This builder for chaining.
     */
    public Builder setBaseProcessorVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      baseProcessorVersion_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.TrainProcessorVersionRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.TrainProcessorVersionRequest)
  private static final com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest();
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TrainProcessorVersionRequest> PARSER =
      new com.google.protobuf.AbstractParser<TrainProcessorVersionRequest>() {
        @java.lang.Override
        public TrainProcessorVersionRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TrainProcessorVersionRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TrainProcessorVersionRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.TrainProcessorVersionRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
