/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document_processor_service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * The long-running operation metadata for
 * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments].
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.BatchProcessMetadata}
 */
public final class BatchProcessMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.BatchProcessMetadata)
    BatchProcessMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchProcessMetadata.newBuilder() to construct.
  private BatchProcessMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchProcessMetadata() {
    state_ = 0;
    stateMessage_ = "";
    individualProcessStatuses_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchProcessMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_BatchProcessMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_BatchProcessMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.BatchProcessMetadata.class,
            com.google.cloud.documentai.v1beta3.BatchProcessMetadata.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible states of the batch processing operation.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.documentai.v1beta3.BatchProcessMetadata.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default value. This value is used if the state is omitted.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Request operation is waiting for scheduling.
     * </pre>
     *
     * <code>WAITING = 1;</code>
     */
    WAITING(1),
    /**
     *
     *
     * <pre>
     * Request is being processed.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * The batch processing completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 3;</code>
     */
    SUCCEEDED(3),
    /**
     *
     *
     * <pre>
     * The batch processing was being cancelled.
     * </pre>
     *
     * <code>CANCELLING = 4;</code>
     */
    CANCELLING(4),
    /**
     *
     *
     * <pre>
     * The batch processing was cancelled.
     * </pre>
     *
     * <code>CANCELLED = 5;</code>
     */
    CANCELLED(5),
    /**
     *
     *
     * <pre>
     * The batch processing has failed.
     * </pre>
     *
     * <code>FAILED = 6;</code>
     */
    FAILED(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default value. This value is used if the state is omitted.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Request operation is waiting for scheduling.
     * </pre>
     *
     * <code>WAITING = 1;</code>
     */
    public static final int WAITING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Request is being processed.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The batch processing completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 3;</code>
     */
    public static final int SUCCEEDED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The batch processing was being cancelled.
     * </pre>
     *
     * <code>CANCELLING = 4;</code>
     */
    public static final int CANCELLING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The batch processing was cancelled.
     * </pre>
     *
     * <code>CANCELLED = 5;</code>
     */
    public static final int CANCELLED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The batch processing has failed.
     * </pre>
     *
     * <code>FAILED = 6;</code>
     */
    public static final int FAILED_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return WAITING;
        case 2:
          return RUNNING;
        case 3:
          return SUCCEEDED;
        case 4:
          return CANCELLING;
        case 5:
          return CANCELLED;
        case 6:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.BatchProcessMetadata.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.documentai.v1beta3.BatchProcessMetadata.State)
  }

  public interface IndividualProcessStatusOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The source of the document, same as the
     * [input_gcs_source][google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.input_gcs_source]
     * field in the request when the batch process started.
     * </pre>
     *
     * <code>string input_gcs_source = 1;</code>
     *
     * @return The inputGcsSource.
     */
    java.lang.String getInputGcsSource();
    /**
     *
     *
     * <pre>
     * The source of the document, same as the
     * [input_gcs_source][google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.input_gcs_source]
     * field in the request when the batch process started.
     * </pre>
     *
     * <code>string input_gcs_source = 1;</code>
     *
     * @return The bytes for inputGcsSource.
     */
    com.google.protobuf.ByteString getInputGcsSourceBytes();

    /**
     *
     *
     * <pre>
     * The status processing the document.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     *
     * @return Whether the status field is set.
     */
    boolean hasStatus();
    /**
     *
     *
     * <pre>
     * The status processing the document.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     *
     * @return The status.
     */
    com.google.rpc.Status getStatus();
    /**
     *
     *
     * <pre>
     * The status processing the document.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    com.google.rpc.StatusOrBuilder getStatusOrBuilder();

    /**
     *
     *
     * <pre>
     * The Cloud Storage output destination (in the request as
     * [DocumentOutputConfig.GcsOutputConfig.gcs_uri][google.cloud.documentai.v1beta3.DocumentOutputConfig.GcsOutputConfig.gcs_uri])
     * of the processed document if it was successful, otherwise empty.
     * </pre>
     *
     * <code>string output_gcs_destination = 3;</code>
     *
     * @return The outputGcsDestination.
     */
    java.lang.String getOutputGcsDestination();
    /**
     *
     *
     * <pre>
     * The Cloud Storage output destination (in the request as
     * [DocumentOutputConfig.GcsOutputConfig.gcs_uri][google.cloud.documentai.v1beta3.DocumentOutputConfig.GcsOutputConfig.gcs_uri])
     * of the processed document if it was successful, otherwise empty.
     * </pre>
     *
     * <code>string output_gcs_destination = 3;</code>
     *
     * @return The bytes for outputGcsDestination.
     */
    com.google.protobuf.ByteString getOutputGcsDestinationBytes();

    /**
     *
     *
     * <pre>
     * The name of the operation triggered by the processed document. If the
     * human review process isn't triggered, this field will be empty. It has
     * the same response type and metadata as the long-running operation
     * returned by the
     * [ReviewDocument][google.cloud.documentai.v1beta3.DocumentProcessorService.ReviewDocument]
     * method.
     * </pre>
     *
     * <code>string human_review_operation = 4 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.human_review_operation
     *     is deprecated. See google/cloud/documentai/v1beta3/document_processor_service.proto;l=597
     * @return The humanReviewOperation.
     */
    @java.lang.Deprecated
    java.lang.String getHumanReviewOperation();
    /**
     *
     *
     * <pre>
     * The name of the operation triggered by the processed document. If the
     * human review process isn't triggered, this field will be empty. It has
     * the same response type and metadata as the long-running operation
     * returned by the
     * [ReviewDocument][google.cloud.documentai.v1beta3.DocumentProcessorService.ReviewDocument]
     * method.
     * </pre>
     *
     * <code>string human_review_operation = 4 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.human_review_operation
     *     is deprecated. See google/cloud/documentai/v1beta3/document_processor_service.proto;l=597
     * @return The bytes for humanReviewOperation.
     */
    @java.lang.Deprecated
    com.google.protobuf.ByteString getHumanReviewOperationBytes();

    /**
     *
     *
     * <pre>
     * The status of human review on the processed document.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.HumanReviewStatus human_review_status = 5;</code>
     *
     * @return Whether the humanReviewStatus field is set.
     */
    boolean hasHumanReviewStatus();
    /**
     *
     *
     * <pre>
     * The status of human review on the processed document.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.HumanReviewStatus human_review_status = 5;</code>
     *
     * @return The humanReviewStatus.
     */
    com.google.cloud.documentai.v1beta3.HumanReviewStatus getHumanReviewStatus();
    /**
     *
     *
     * <pre>
     * The status of human review on the processed document.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.HumanReviewStatus human_review_status = 5;</code>
     */
    com.google.cloud.documentai.v1beta3.HumanReviewStatusOrBuilder getHumanReviewStatusOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The status of a each individual document in the batch process.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus}
   */
  public static final class IndividualProcessStatus extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus)
      IndividualProcessStatusOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IndividualProcessStatus.newBuilder() to construct.
    private IndividualProcessStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IndividualProcessStatus() {
      inputGcsSource_ = "";
      outputGcsDestination_ = "";
      humanReviewOperation_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new IndividualProcessStatus();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_BatchProcessMetadata_IndividualProcessStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_BatchProcessMetadata_IndividualProcessStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
                  .class,
              com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
                  .Builder.class);
    }

    private int bitField0_;
    public static final int INPUT_GCS_SOURCE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object inputGcsSource_ = "";
    /**
     *
     *
     * <pre>
     * The source of the document, same as the
     * [input_gcs_source][google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.input_gcs_source]
     * field in the request when the batch process started.
     * </pre>
     *
     * <code>string input_gcs_source = 1;</code>
     *
     * @return The inputGcsSource.
     */
    @java.lang.Override
    public java.lang.String getInputGcsSource() {
      java.lang.Object ref = inputGcsSource_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        inputGcsSource_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The source of the document, same as the
     * [input_gcs_source][google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.input_gcs_source]
     * field in the request when the batch process started.
     * </pre>
     *
     * <code>string input_gcs_source = 1;</code>
     *
     * @return The bytes for inputGcsSource.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInputGcsSourceBytes() {
      java.lang.Object ref = inputGcsSource_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        inputGcsSource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATUS_FIELD_NUMBER = 2;
    private com.google.rpc.Status status_;
    /**
     *
     *
     * <pre>
     * The status processing the document.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     *
     * @return Whether the status field is set.
     */
    @java.lang.Override
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The status processing the document.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.rpc.Status getStatus() {
      return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
    }
    /**
     *
     *
     * <pre>
     * The status processing the document.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    @java.lang.Override
    public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
      return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
    }

    public static final int OUTPUT_GCS_DESTINATION_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object outputGcsDestination_ = "";
    /**
     *
     *
     * <pre>
     * The Cloud Storage output destination (in the request as
     * [DocumentOutputConfig.GcsOutputConfig.gcs_uri][google.cloud.documentai.v1beta3.DocumentOutputConfig.GcsOutputConfig.gcs_uri])
     * of the processed document if it was successful, otherwise empty.
     * </pre>
     *
     * <code>string output_gcs_destination = 3;</code>
     *
     * @return The outputGcsDestination.
     */
    @java.lang.Override
    public java.lang.String getOutputGcsDestination() {
      java.lang.Object ref = outputGcsDestination_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        outputGcsDestination_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage output destination (in the request as
     * [DocumentOutputConfig.GcsOutputConfig.gcs_uri][google.cloud.documentai.v1beta3.DocumentOutputConfig.GcsOutputConfig.gcs_uri])
     * of the processed document if it was successful, otherwise empty.
     * </pre>
     *
     * <code>string output_gcs_destination = 3;</code>
     *
     * @return The bytes for outputGcsDestination.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOutputGcsDestinationBytes() {
      java.lang.Object ref = outputGcsDestination_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        outputGcsDestination_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int HUMAN_REVIEW_OPERATION_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object humanReviewOperation_ = "";
    /**
     *
     *
     * <pre>
     * The name of the operation triggered by the processed document. If the
     * human review process isn't triggered, this field will be empty. It has
     * the same response type and metadata as the long-running operation
     * returned by the
     * [ReviewDocument][google.cloud.documentai.v1beta3.DocumentProcessorService.ReviewDocument]
     * method.
     * </pre>
     *
     * <code>string human_review_operation = 4 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.human_review_operation
     *     is deprecated. See google/cloud/documentai/v1beta3/document_processor_service.proto;l=597
     * @return The humanReviewOperation.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.lang.String getHumanReviewOperation() {
      java.lang.Object ref = humanReviewOperation_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        humanReviewOperation_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the operation triggered by the processed document. If the
     * human review process isn't triggered, this field will be empty. It has
     * the same response type and metadata as the long-running operation
     * returned by the
     * [ReviewDocument][google.cloud.documentai.v1beta3.DocumentProcessorService.ReviewDocument]
     * method.
     * </pre>
     *
     * <code>string human_review_operation = 4 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.human_review_operation
     *     is deprecated. See google/cloud/documentai/v1beta3/document_processor_service.proto;l=597
     * @return The bytes for humanReviewOperation.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getHumanReviewOperationBytes() {
      java.lang.Object ref = humanReviewOperation_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        humanReviewOperation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int HUMAN_REVIEW_STATUS_FIELD_NUMBER = 5;
    private com.google.cloud.documentai.v1beta3.HumanReviewStatus humanReviewStatus_;
    /**
     *
     *
     * <pre>
     * The status of human review on the processed document.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.HumanReviewStatus human_review_status = 5;</code>
     *
     * @return Whether the humanReviewStatus field is set.
     */
    @java.lang.Override
    public boolean hasHumanReviewStatus() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The status of human review on the processed document.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.HumanReviewStatus human_review_status = 5;</code>
     *
     * @return The humanReviewStatus.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.HumanReviewStatus getHumanReviewStatus() {
      return humanReviewStatus_ == null
          ? com.google.cloud.documentai.v1beta3.HumanReviewStatus.getDefaultInstance()
          : humanReviewStatus_;
    }
    /**
     *
     *
     * <pre>
     * The status of human review on the processed document.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.HumanReviewStatus human_review_status = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.HumanReviewStatusOrBuilder
        getHumanReviewStatusOrBuilder() {
      return humanReviewStatus_ == null
          ? com.google.cloud.documentai.v1beta3.HumanReviewStatus.getDefaultInstance()
          : humanReviewStatus_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputGcsSource_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, inputGcsSource_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getStatus());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputGcsDestination_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, outputGcsDestination_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(humanReviewOperation_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, humanReviewOperation_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(5, getHumanReviewStatus());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputGcsSource_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, inputGcsSource_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStatus());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputGcsDestination_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, outputGcsDestination_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(humanReviewOperation_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, humanReviewOperation_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getHumanReviewStatus());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus other =
          (com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus) obj;

      if (!getInputGcsSource().equals(other.getInputGcsSource())) return false;
      if (hasStatus() != other.hasStatus()) return false;
      if (hasStatus()) {
        if (!getStatus().equals(other.getStatus())) return false;
      }
      if (!getOutputGcsDestination().equals(other.getOutputGcsDestination())) return false;
      if (!getHumanReviewOperation().equals(other.getHumanReviewOperation())) return false;
      if (hasHumanReviewStatus() != other.hasHumanReviewStatus()) return false;
      if (hasHumanReviewStatus()) {
        if (!getHumanReviewStatus().equals(other.getHumanReviewStatus())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + INPUT_GCS_SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getInputGcsSource().hashCode();
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      hash = (37 * hash) + OUTPUT_GCS_DESTINATION_FIELD_NUMBER;
      hash = (53 * hash) + getOutputGcsDestination().hashCode();
      hash = (37 * hash) + HUMAN_REVIEW_OPERATION_FIELD_NUMBER;
      hash = (53 * hash) + getHumanReviewOperation().hashCode();
      if (hasHumanReviewStatus()) {
        hash = (37 * hash) + HUMAN_REVIEW_STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getHumanReviewStatus().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The status of a each individual document in the batch process.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus)
        com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatusOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_BatchProcessMetadata_IndividualProcessStatus_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_BatchProcessMetadata_IndividualProcessStatus_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
                    .class,
                com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getStatusFieldBuilder();
          getHumanReviewStatusFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        inputGcsSource_ = "";
        status_ = null;
        if (statusBuilder_ != null) {
          statusBuilder_.dispose();
          statusBuilder_ = null;
        }
        outputGcsDestination_ = "";
        humanReviewOperation_ = "";
        humanReviewStatus_ = null;
        if (humanReviewStatusBuilder_ != null) {
          humanReviewStatusBuilder_.dispose();
          humanReviewStatusBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_BatchProcessMetadata_IndividualProcessStatus_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
          build() {
        com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
          buildPartial() {
        com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus result =
            new com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.inputGcsSource_ = inputGcsSource_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.outputGcsDestination_ = outputGcsDestination_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.humanReviewOperation_ = humanReviewOperation_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.humanReviewStatus_ =
              humanReviewStatusBuilder_ == null
                  ? humanReviewStatus_
                  : humanReviewStatusBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus other) {
        if (other
            == com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
                .getDefaultInstance()) return this;
        if (!other.getInputGcsSource().isEmpty()) {
          inputGcsSource_ = other.inputGcsSource_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasStatus()) {
          mergeStatus(other.getStatus());
        }
        if (!other.getOutputGcsDestination().isEmpty()) {
          outputGcsDestination_ = other.outputGcsDestination_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getHumanReviewOperation().isEmpty()) {
          humanReviewOperation_ = other.humanReviewOperation_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (other.hasHumanReviewStatus()) {
          mergeHumanReviewStatus(other.getHumanReviewStatus());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  inputGcsSource_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  outputGcsDestination_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  humanReviewOperation_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(
                      getHumanReviewStatusFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object inputGcsSource_ = "";
      /**
       *
       *
       * <pre>
       * The source of the document, same as the
       * [input_gcs_source][google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.input_gcs_source]
       * field in the request when the batch process started.
       * </pre>
       *
       * <code>string input_gcs_source = 1;</code>
       *
       * @return The inputGcsSource.
       */
      public java.lang.String getInputGcsSource() {
        java.lang.Object ref = inputGcsSource_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          inputGcsSource_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The source of the document, same as the
       * [input_gcs_source][google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.input_gcs_source]
       * field in the request when the batch process started.
       * </pre>
       *
       * <code>string input_gcs_source = 1;</code>
       *
       * @return The bytes for inputGcsSource.
       */
      public com.google.protobuf.ByteString getInputGcsSourceBytes() {
        java.lang.Object ref = inputGcsSource_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          inputGcsSource_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The source of the document, same as the
       * [input_gcs_source][google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.input_gcs_source]
       * field in the request when the batch process started.
       * </pre>
       *
       * <code>string input_gcs_source = 1;</code>
       *
       * @param value The inputGcsSource to set.
       * @return This builder for chaining.
       */
      public Builder setInputGcsSource(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputGcsSource_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The source of the document, same as the
       * [input_gcs_source][google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.input_gcs_source]
       * field in the request when the batch process started.
       * </pre>
       *
       * <code>string input_gcs_source = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInputGcsSource() {
        inputGcsSource_ = getDefaultInstance().getInputGcsSource();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The source of the document, same as the
       * [input_gcs_source][google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.input_gcs_source]
       * field in the request when the batch process started.
       * </pre>
       *
       * <code>string input_gcs_source = 1;</code>
       *
       * @param value The bytes for inputGcsSource to set.
       * @return This builder for chaining.
       */
      public Builder setInputGcsSourceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        inputGcsSource_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.rpc.Status status_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          statusBuilder_;
      /**
       *
       *
       * <pre>
       * The status processing the document.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       *
       * @return Whether the status field is set.
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The status processing the document.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       *
       * @return The status.
       */
      public com.google.rpc.Status getStatus() {
        if (statusBuilder_ == null) {
          return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
        } else {
          return statusBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The status processing the document.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public Builder setStatus(com.google.rpc.Status value) {
        if (statusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          status_ = value;
        } else {
          statusBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The status processing the document.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public Builder setStatus(com.google.rpc.Status.Builder builderForValue) {
        if (statusBuilder_ == null) {
          status_ = builderForValue.build();
        } else {
          statusBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The status processing the document.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public Builder mergeStatus(com.google.rpc.Status value) {
        if (statusBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && status_ != null
              && status_ != com.google.rpc.Status.getDefaultInstance()) {
            getStatusBuilder().mergeFrom(value);
          } else {
            status_ = value;
          }
        } else {
          statusBuilder_.mergeFrom(value);
        }
        if (status_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The status processing the document.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000002);
        status_ = null;
        if (statusBuilder_ != null) {
          statusBuilder_.dispose();
          statusBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The status processing the document.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public com.google.rpc.Status.Builder getStatusBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getStatusFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The status processing the document.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
        if (statusBuilder_ != null) {
          return statusBuilder_.getMessageOrBuilder();
        } else {
          return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
        }
      }
      /**
       *
       *
       * <pre>
       * The status processing the document.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          getStatusFieldBuilder() {
        if (statusBuilder_ == null) {
          statusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.rpc.Status,
                  com.google.rpc.Status.Builder,
                  com.google.rpc.StatusOrBuilder>(getStatus(), getParentForChildren(), isClean());
          status_ = null;
        }
        return statusBuilder_;
      }

      private java.lang.Object outputGcsDestination_ = "";
      /**
       *
       *
       * <pre>
       * The Cloud Storage output destination (in the request as
       * [DocumentOutputConfig.GcsOutputConfig.gcs_uri][google.cloud.documentai.v1beta3.DocumentOutputConfig.GcsOutputConfig.gcs_uri])
       * of the processed document if it was successful, otherwise empty.
       * </pre>
       *
       * <code>string output_gcs_destination = 3;</code>
       *
       * @return The outputGcsDestination.
       */
      public java.lang.String getOutputGcsDestination() {
        java.lang.Object ref = outputGcsDestination_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          outputGcsDestination_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage output destination (in the request as
       * [DocumentOutputConfig.GcsOutputConfig.gcs_uri][google.cloud.documentai.v1beta3.DocumentOutputConfig.GcsOutputConfig.gcs_uri])
       * of the processed document if it was successful, otherwise empty.
       * </pre>
       *
       * <code>string output_gcs_destination = 3;</code>
       *
       * @return The bytes for outputGcsDestination.
       */
      public com.google.protobuf.ByteString getOutputGcsDestinationBytes() {
        java.lang.Object ref = outputGcsDestination_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          outputGcsDestination_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage output destination (in the request as
       * [DocumentOutputConfig.GcsOutputConfig.gcs_uri][google.cloud.documentai.v1beta3.DocumentOutputConfig.GcsOutputConfig.gcs_uri])
       * of the processed document if it was successful, otherwise empty.
       * </pre>
       *
       * <code>string output_gcs_destination = 3;</code>
       *
       * @param value The outputGcsDestination to set.
       * @return This builder for chaining.
       */
      public Builder setOutputGcsDestination(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputGcsDestination_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage output destination (in the request as
       * [DocumentOutputConfig.GcsOutputConfig.gcs_uri][google.cloud.documentai.v1beta3.DocumentOutputConfig.GcsOutputConfig.gcs_uri])
       * of the processed document if it was successful, otherwise empty.
       * </pre>
       *
       * <code>string output_gcs_destination = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOutputGcsDestination() {
        outputGcsDestination_ = getDefaultInstance().getOutputGcsDestination();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage output destination (in the request as
       * [DocumentOutputConfig.GcsOutputConfig.gcs_uri][google.cloud.documentai.v1beta3.DocumentOutputConfig.GcsOutputConfig.gcs_uri])
       * of the processed document if it was successful, otherwise empty.
       * </pre>
       *
       * <code>string output_gcs_destination = 3;</code>
       *
       * @param value The bytes for outputGcsDestination to set.
       * @return This builder for chaining.
       */
      public Builder setOutputGcsDestinationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        outputGcsDestination_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object humanReviewOperation_ = "";
      /**
       *
       *
       * <pre>
       * The name of the operation triggered by the processed document. If the
       * human review process isn't triggered, this field will be empty. It has
       * the same response type and metadata as the long-running operation
       * returned by the
       * [ReviewDocument][google.cloud.documentai.v1beta3.DocumentProcessorService.ReviewDocument]
       * method.
       * </pre>
       *
       * <code>string human_review_operation = 4 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.human_review_operation
       *     is deprecated. See
       *     google/cloud/documentai/v1beta3/document_processor_service.proto;l=597
       * @return The humanReviewOperation.
       */
      @java.lang.Deprecated
      public java.lang.String getHumanReviewOperation() {
        java.lang.Object ref = humanReviewOperation_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          humanReviewOperation_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the operation triggered by the processed document. If the
       * human review process isn't triggered, this field will be empty. It has
       * the same response type and metadata as the long-running operation
       * returned by the
       * [ReviewDocument][google.cloud.documentai.v1beta3.DocumentProcessorService.ReviewDocument]
       * method.
       * </pre>
       *
       * <code>string human_review_operation = 4 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.human_review_operation
       *     is deprecated. See
       *     google/cloud/documentai/v1beta3/document_processor_service.proto;l=597
       * @return The bytes for humanReviewOperation.
       */
      @java.lang.Deprecated
      public com.google.protobuf.ByteString getHumanReviewOperationBytes() {
        java.lang.Object ref = humanReviewOperation_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          humanReviewOperation_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the operation triggered by the processed document. If the
       * human review process isn't triggered, this field will be empty. It has
       * the same response type and metadata as the long-running operation
       * returned by the
       * [ReviewDocument][google.cloud.documentai.v1beta3.DocumentProcessorService.ReviewDocument]
       * method.
       * </pre>
       *
       * <code>string human_review_operation = 4 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.human_review_operation
       *     is deprecated. See
       *     google/cloud/documentai/v1beta3/document_processor_service.proto;l=597
       * @param value The humanReviewOperation to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setHumanReviewOperation(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        humanReviewOperation_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the operation triggered by the processed document. If the
       * human review process isn't triggered, this field will be empty. It has
       * the same response type and metadata as the long-running operation
       * returned by the
       * [ReviewDocument][google.cloud.documentai.v1beta3.DocumentProcessorService.ReviewDocument]
       * method.
       * </pre>
       *
       * <code>string human_review_operation = 4 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.human_review_operation
       *     is deprecated. See
       *     google/cloud/documentai/v1beta3/document_processor_service.proto;l=597
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearHumanReviewOperation() {
        humanReviewOperation_ = getDefaultInstance().getHumanReviewOperation();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the operation triggered by the processed document. If the
       * human review process isn't triggered, this field will be empty. It has
       * the same response type and metadata as the long-running operation
       * returned by the
       * [ReviewDocument][google.cloud.documentai.v1beta3.DocumentProcessorService.ReviewDocument]
       * method.
       * </pre>
       *
       * <code>string human_review_operation = 4 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.human_review_operation
       *     is deprecated. See
       *     google/cloud/documentai/v1beta3/document_processor_service.proto;l=597
       * @param value The bytes for humanReviewOperation to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setHumanReviewOperationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        humanReviewOperation_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private com.google.cloud.documentai.v1beta3.HumanReviewStatus humanReviewStatus_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.HumanReviewStatus,
              com.google.cloud.documentai.v1beta3.HumanReviewStatus.Builder,
              com.google.cloud.documentai.v1beta3.HumanReviewStatusOrBuilder>
          humanReviewStatusBuilder_;
      /**
       *
       *
       * <pre>
       * The status of human review on the processed document.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.HumanReviewStatus human_review_status = 5;</code>
       *
       * @return Whether the humanReviewStatus field is set.
       */
      public boolean hasHumanReviewStatus() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * The status of human review on the processed document.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.HumanReviewStatus human_review_status = 5;</code>
       *
       * @return The humanReviewStatus.
       */
      public com.google.cloud.documentai.v1beta3.HumanReviewStatus getHumanReviewStatus() {
        if (humanReviewStatusBuilder_ == null) {
          return humanReviewStatus_ == null
              ? com.google.cloud.documentai.v1beta3.HumanReviewStatus.getDefaultInstance()
              : humanReviewStatus_;
        } else {
          return humanReviewStatusBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The status of human review on the processed document.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.HumanReviewStatus human_review_status = 5;</code>
       */
      public Builder setHumanReviewStatus(
          com.google.cloud.documentai.v1beta3.HumanReviewStatus value) {
        if (humanReviewStatusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          humanReviewStatus_ = value;
        } else {
          humanReviewStatusBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The status of human review on the processed document.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.HumanReviewStatus human_review_status = 5;</code>
       */
      public Builder setHumanReviewStatus(
          com.google.cloud.documentai.v1beta3.HumanReviewStatus.Builder builderForValue) {
        if (humanReviewStatusBuilder_ == null) {
          humanReviewStatus_ = builderForValue.build();
        } else {
          humanReviewStatusBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The status of human review on the processed document.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.HumanReviewStatus human_review_status = 5;</code>
       */
      public Builder mergeHumanReviewStatus(
          com.google.cloud.documentai.v1beta3.HumanReviewStatus value) {
        if (humanReviewStatusBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && humanReviewStatus_ != null
              && humanReviewStatus_
                  != com.google.cloud.documentai.v1beta3.HumanReviewStatus.getDefaultInstance()) {
            getHumanReviewStatusBuilder().mergeFrom(value);
          } else {
            humanReviewStatus_ = value;
          }
        } else {
          humanReviewStatusBuilder_.mergeFrom(value);
        }
        if (humanReviewStatus_ != null) {
          bitField0_ |= 0x00000010;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The status of human review on the processed document.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.HumanReviewStatus human_review_status = 5;</code>
       */
      public Builder clearHumanReviewStatus() {
        bitField0_ = (bitField0_ & ~0x00000010);
        humanReviewStatus_ = null;
        if (humanReviewStatusBuilder_ != null) {
          humanReviewStatusBuilder_.dispose();
          humanReviewStatusBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The status of human review on the processed document.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.HumanReviewStatus human_review_status = 5;</code>
       */
      public com.google.cloud.documentai.v1beta3.HumanReviewStatus.Builder
          getHumanReviewStatusBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getHumanReviewStatusFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The status of human review on the processed document.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.HumanReviewStatus human_review_status = 5;</code>
       */
      public com.google.cloud.documentai.v1beta3.HumanReviewStatusOrBuilder
          getHumanReviewStatusOrBuilder() {
        if (humanReviewStatusBuilder_ != null) {
          return humanReviewStatusBuilder_.getMessageOrBuilder();
        } else {
          return humanReviewStatus_ == null
              ? com.google.cloud.documentai.v1beta3.HumanReviewStatus.getDefaultInstance()
              : humanReviewStatus_;
        }
      }
      /**
       *
       *
       * <pre>
       * The status of human review on the processed document.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.HumanReviewStatus human_review_status = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.HumanReviewStatus,
              com.google.cloud.documentai.v1beta3.HumanReviewStatus.Builder,
              com.google.cloud.documentai.v1beta3.HumanReviewStatusOrBuilder>
          getHumanReviewStatusFieldBuilder() {
        if (humanReviewStatusBuilder_ == null) {
          humanReviewStatusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.HumanReviewStatus,
                  com.google.cloud.documentai.v1beta3.HumanReviewStatus.Builder,
                  com.google.cloud.documentai.v1beta3.HumanReviewStatusOrBuilder>(
                  getHumanReviewStatus(), getParentForChildren(), isClean());
          humanReviewStatus_ = null;
        }
        return humanReviewStatusBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus)
    private static final com.google.cloud.documentai.v1beta3.BatchProcessMetadata
            .IndividualProcessStatus
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus();
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IndividualProcessStatus> PARSER =
        new com.google.protobuf.AbstractParser<IndividualProcessStatus>() {
          @java.lang.Override
          public IndividualProcessStatus parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<IndividualProcessStatus> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IndividualProcessStatus> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int STATE_FIELD_NUMBER = 1;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * The state of the current batch processing.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.BatchProcessMetadata.State state = 1;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * The state of the current batch processing.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.BatchProcessMetadata.State state = 1;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.BatchProcessMetadata.State getState() {
    com.google.cloud.documentai.v1beta3.BatchProcessMetadata.State result =
        com.google.cloud.documentai.v1beta3.BatchProcessMetadata.State.forNumber(state_);
    return result == null
        ? com.google.cloud.documentai.v1beta3.BatchProcessMetadata.State.UNRECOGNIZED
        : result;
  }

  public static final int STATE_MESSAGE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stateMessage_ = "";
  /**
   *
   *
   * <pre>
   * A message providing more details about the current state of processing.
   * For example, the error message if the operation is failed.
   * </pre>
   *
   * <code>string state_message = 2;</code>
   *
   * @return The stateMessage.
   */
  @java.lang.Override
  public java.lang.String getStateMessage() {
    java.lang.Object ref = stateMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stateMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A message providing more details about the current state of processing.
   * For example, the error message if the operation is failed.
   * </pre>
   *
   * <code>string state_message = 2;</code>
   *
   * @return The bytes for stateMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateMessageBytes() {
    java.lang.Object ref = stateMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stateMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * The creation time of the operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The creation time of the operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * The creation time of the operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * The last update time of the operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4;</code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The last update time of the operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4;</code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * The last update time of the operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int INDIVIDUAL_PROCESS_STATUSES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus>
      individualProcessStatuses_;
  /**
   *
   *
   * <pre>
   * The list of response details of each document.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus>
      getIndividualProcessStatusesList() {
    return individualProcessStatuses_;
  }
  /**
   *
   *
   * <pre>
   * The list of response details of each document.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.documentai.v1beta3.BatchProcessMetadata
                  .IndividualProcessStatusOrBuilder>
      getIndividualProcessStatusesOrBuilderList() {
    return individualProcessStatuses_;
  }
  /**
   *
   *
   * <pre>
   * The list of response details of each document.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
   * </code>
   */
  @java.lang.Override
  public int getIndividualProcessStatusesCount() {
    return individualProcessStatuses_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of response details of each document.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
      getIndividualProcessStatuses(int index) {
    return individualProcessStatuses_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of response details of each document.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatusOrBuilder
      getIndividualProcessStatusesOrBuilder(int index) {
    return individualProcessStatuses_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (state_
        != com.google.cloud.documentai.v1beta3.BatchProcessMetadata.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, stateMessage_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getUpdateTime());
    }
    for (int i = 0; i < individualProcessStatuses_.size(); i++) {
      output.writeMessage(5, individualProcessStatuses_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (state_
        != com.google.cloud.documentai.v1beta3.BatchProcessMetadata.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, stateMessage_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    for (int i = 0; i < individualProcessStatuses_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, individualProcessStatuses_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.BatchProcessMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.BatchProcessMetadata other =
        (com.google.cloud.documentai.v1beta3.BatchProcessMetadata) obj;

    if (state_ != other.state_) return false;
    if (!getStateMessage().equals(other.getStateMessage())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getIndividualProcessStatusesList().equals(other.getIndividualProcessStatusesList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + STATE_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getStateMessage().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (getIndividualProcessStatusesCount() > 0) {
      hash = (37 * hash) + INDIVIDUAL_PROCESS_STATUSES_FIELD_NUMBER;
      hash = (53 * hash) + getIndividualProcessStatusesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.documentai.v1beta3.BatchProcessMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The long-running operation metadata for
   * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments].
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.BatchProcessMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.BatchProcessMetadata)
      com.google.cloud.documentai.v1beta3.BatchProcessMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_BatchProcessMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_BatchProcessMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.BatchProcessMetadata.class,
              com.google.cloud.documentai.v1beta3.BatchProcessMetadata.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.BatchProcessMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getIndividualProcessStatusesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      state_ = 0;
      stateMessage_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      if (individualProcessStatusesBuilder_ == null) {
        individualProcessStatuses_ = java.util.Collections.emptyList();
      } else {
        individualProcessStatuses_ = null;
        individualProcessStatusesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_BatchProcessMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchProcessMetadata getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.BatchProcessMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchProcessMetadata build() {
      com.google.cloud.documentai.v1beta3.BatchProcessMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchProcessMetadata buildPartial() {
      com.google.cloud.documentai.v1beta3.BatchProcessMetadata result =
          new com.google.cloud.documentai.v1beta3.BatchProcessMetadata(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.documentai.v1beta3.BatchProcessMetadata result) {
      if (individualProcessStatusesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          individualProcessStatuses_ =
              java.util.Collections.unmodifiableList(individualProcessStatuses_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.individualProcessStatuses_ = individualProcessStatuses_;
      } else {
        result.individualProcessStatuses_ = individualProcessStatusesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta3.BatchProcessMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.stateMessage_ = stateMessage_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.BatchProcessMetadata) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.BatchProcessMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.BatchProcessMetadata other) {
      if (other == com.google.cloud.documentai.v1beta3.BatchProcessMetadata.getDefaultInstance())
        return this;
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getStateMessage().isEmpty()) {
        stateMessage_ = other.stateMessage_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (individualProcessStatusesBuilder_ == null) {
        if (!other.individualProcessStatuses_.isEmpty()) {
          if (individualProcessStatuses_.isEmpty()) {
            individualProcessStatuses_ = other.individualProcessStatuses_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureIndividualProcessStatusesIsMutable();
            individualProcessStatuses_.addAll(other.individualProcessStatuses_);
          }
          onChanged();
        }
      } else {
        if (!other.individualProcessStatuses_.isEmpty()) {
          if (individualProcessStatusesBuilder_.isEmpty()) {
            individualProcessStatusesBuilder_.dispose();
            individualProcessStatusesBuilder_ = null;
            individualProcessStatuses_ = other.individualProcessStatuses_;
            bitField0_ = (bitField0_ & ~0x00000010);
            individualProcessStatusesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getIndividualProcessStatusesFieldBuilder()
                    : null;
          } else {
            individualProcessStatusesBuilder_.addAllMessages(other.individualProcessStatuses_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                stateMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus m =
                    input.readMessage(
                        com.google.cloud.documentai.v1beta3.BatchProcessMetadata
                            .IndividualProcessStatus.parser(),
                        extensionRegistry);
                if (individualProcessStatusesBuilder_ == null) {
                  ensureIndividualProcessStatusesIsMutable();
                  individualProcessStatuses_.add(m);
                } else {
                  individualProcessStatusesBuilder_.addMessage(m);
                }
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * The state of the current batch processing.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchProcessMetadata.State state = 1;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * The state of the current batch processing.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchProcessMetadata.State state = 1;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the current batch processing.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchProcessMetadata.State state = 1;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchProcessMetadata.State getState() {
      com.google.cloud.documentai.v1beta3.BatchProcessMetadata.State result =
          com.google.cloud.documentai.v1beta3.BatchProcessMetadata.State.forNumber(state_);
      return result == null
          ? com.google.cloud.documentai.v1beta3.BatchProcessMetadata.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The state of the current batch processing.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchProcessMetadata.State state = 1;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.documentai.v1beta3.BatchProcessMetadata.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the current batch processing.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchProcessMetadata.State state = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000001);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object stateMessage_ = "";
    /**
     *
     *
     * <pre>
     * A message providing more details about the current state of processing.
     * For example, the error message if the operation is failed.
     * </pre>
     *
     * <code>string state_message = 2;</code>
     *
     * @return The stateMessage.
     */
    public java.lang.String getStateMessage() {
      java.lang.Object ref = stateMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A message providing more details about the current state of processing.
     * For example, the error message if the operation is failed.
     * </pre>
     *
     * <code>string state_message = 2;</code>
     *
     * @return The bytes for stateMessage.
     */
    public com.google.protobuf.ByteString getStateMessageBytes() {
      java.lang.Object ref = stateMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stateMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A message providing more details about the current state of processing.
     * For example, the error message if the operation is failed.
     * </pre>
     *
     * <code>string state_message = 2;</code>
     *
     * @param value The stateMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStateMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stateMessage_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A message providing more details about the current state of processing.
     * For example, the error message if the operation is failed.
     * </pre>
     *
     * <code>string state_message = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStateMessage() {
      stateMessage_ = getDefaultInstance().getStateMessage();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A message providing more details about the current state of processing.
     * For example, the error message if the operation is failed.
     * </pre>
     *
     * <code>string state_message = 2;</code>
     *
     * @param value The bytes for stateMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStateMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stateMessage_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The creation time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The creation time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The creation time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The creation time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The creation time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The creation time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The creation time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The creation time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The creation time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The last update time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The last update time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The last update time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last update time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last update time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last update time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last update time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The last update time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The last update time of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.util.List<
            com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus>
        individualProcessStatuses_ = java.util.Collections.emptyList();

    private void ensureIndividualProcessStatusesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        individualProcessStatuses_ =
            new java.util.ArrayList<
                com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus>(
                individualProcessStatuses_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus,
            com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
                .Builder,
            com.google.cloud.documentai.v1beta3.BatchProcessMetadata
                .IndividualProcessStatusOrBuilder>
        individualProcessStatusesBuilder_;

    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
     * </code>
     */
    public java.util.List<
            com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus>
        getIndividualProcessStatusesList() {
      if (individualProcessStatusesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(individualProcessStatuses_);
      } else {
        return individualProcessStatusesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
     * </code>
     */
    public int getIndividualProcessStatusesCount() {
      if (individualProcessStatusesBuilder_ == null) {
        return individualProcessStatuses_.size();
      } else {
        return individualProcessStatusesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
        getIndividualProcessStatuses(int index) {
      if (individualProcessStatusesBuilder_ == null) {
        return individualProcessStatuses_.get(index);
      } else {
        return individualProcessStatusesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
     * </code>
     */
    public Builder setIndividualProcessStatuses(
        int index,
        com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus value) {
      if (individualProcessStatusesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIndividualProcessStatusesIsMutable();
        individualProcessStatuses_.set(index, value);
        onChanged();
      } else {
        individualProcessStatusesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
     * </code>
     */
    public Builder setIndividualProcessStatuses(
        int index,
        com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.Builder
            builderForValue) {
      if (individualProcessStatusesBuilder_ == null) {
        ensureIndividualProcessStatusesIsMutable();
        individualProcessStatuses_.set(index, builderForValue.build());
        onChanged();
      } else {
        individualProcessStatusesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
     * </code>
     */
    public Builder addIndividualProcessStatuses(
        com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus value) {
      if (individualProcessStatusesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIndividualProcessStatusesIsMutable();
        individualProcessStatuses_.add(value);
        onChanged();
      } else {
        individualProcessStatusesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
     * </code>
     */
    public Builder addIndividualProcessStatuses(
        int index,
        com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus value) {
      if (individualProcessStatusesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIndividualProcessStatusesIsMutable();
        individualProcessStatuses_.add(index, value);
        onChanged();
      } else {
        individualProcessStatusesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
     * </code>
     */
    public Builder addIndividualProcessStatuses(
        com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.Builder
            builderForValue) {
      if (individualProcessStatusesBuilder_ == null) {
        ensureIndividualProcessStatusesIsMutable();
        individualProcessStatuses_.add(builderForValue.build());
        onChanged();
      } else {
        individualProcessStatusesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
     * </code>
     */
    public Builder addIndividualProcessStatuses(
        int index,
        com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.Builder
            builderForValue) {
      if (individualProcessStatusesBuilder_ == null) {
        ensureIndividualProcessStatusesIsMutable();
        individualProcessStatuses_.add(index, builderForValue.build());
        onChanged();
      } else {
        individualProcessStatusesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
     * </code>
     */
    public Builder addAllIndividualProcessStatuses(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.documentai.v1beta3.BatchProcessMetadata
                        .IndividualProcessStatus>
            values) {
      if (individualProcessStatusesBuilder_ == null) {
        ensureIndividualProcessStatusesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, individualProcessStatuses_);
        onChanged();
      } else {
        individualProcessStatusesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
     * </code>
     */
    public Builder clearIndividualProcessStatuses() {
      if (individualProcessStatusesBuilder_ == null) {
        individualProcessStatuses_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        individualProcessStatusesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
     * </code>
     */
    public Builder removeIndividualProcessStatuses(int index) {
      if (individualProcessStatusesBuilder_ == null) {
        ensureIndividualProcessStatusesIsMutable();
        individualProcessStatuses_.remove(index);
        onChanged();
      } else {
        individualProcessStatusesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.Builder
        getIndividualProcessStatusesBuilder(int index) {
      return getIndividualProcessStatusesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatusOrBuilder
        getIndividualProcessStatusesOrBuilder(int index) {
      if (individualProcessStatusesBuilder_ == null) {
        return individualProcessStatuses_.get(index);
      } else {
        return individualProcessStatusesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.documentai.v1beta3.BatchProcessMetadata
                    .IndividualProcessStatusOrBuilder>
        getIndividualProcessStatusesOrBuilderList() {
      if (individualProcessStatusesBuilder_ != null) {
        return individualProcessStatusesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(individualProcessStatuses_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.Builder
        addIndividualProcessStatusesBuilder() {
      return getIndividualProcessStatusesFieldBuilder()
          .addBuilder(
              com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.Builder
        addIndividualProcessStatusesBuilder(int index) {
      return getIndividualProcessStatusesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus individual_process_statuses = 5;
     * </code>
     */
    public java.util.List<
            com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
                .Builder>
        getIndividualProcessStatusesBuilderList() {
      return getIndividualProcessStatusesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus,
            com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
                .Builder,
            com.google.cloud.documentai.v1beta3.BatchProcessMetadata
                .IndividualProcessStatusOrBuilder>
        getIndividualProcessStatusesFieldBuilder() {
      if (individualProcessStatusesBuilder_ == null) {
        individualProcessStatusesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus,
                com.google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
                    .Builder,
                com.google.cloud.documentai.v1beta3.BatchProcessMetadata
                    .IndividualProcessStatusOrBuilder>(
                individualProcessStatuses_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        individualProcessStatuses_ = null;
      }
      return individualProcessStatusesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.BatchProcessMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.BatchProcessMetadata)
  private static final com.google.cloud.documentai.v1beta3.BatchProcessMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.BatchProcessMetadata();
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchProcessMetadata> PARSER =
      new com.google.protobuf.AbstractParser<BatchProcessMetadata>() {
        @java.lang.Override
        public BatchProcessMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchProcessMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchProcessMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.BatchProcessMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
