/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document_processor_service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * Request message for
 * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments].
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.BatchProcessRequest}
 */
public final class BatchProcessRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.BatchProcessRequest)
    BatchProcessRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchProcessRequest.newBuilder() to construct.
  private BatchProcessRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchProcessRequest() {
    name_ = "";
    inputConfigs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchProcessRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 9:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.class,
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.Builder.class);
  }

  @java.lang.Deprecated
  public interface BatchInputConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The Cloud Storage location as the source of the document.
     * </pre>
     *
     * <code>string gcs_source = 1;</code>
     *
     * @return The gcsSource.
     */
    java.lang.String getGcsSource();
    /**
     *
     *
     * <pre>
     * The Cloud Storage location as the source of the document.
     * </pre>
     *
     * <code>string gcs_source = 1;</code>
     *
     * @return The bytes for gcsSource.
     */
    com.google.protobuf.ByteString getGcsSourceBytes();

    /**
     *
     *
     * <pre>
     * An IANA published [media type (MIME
     * type)](https://www.iana.org/assignments/media-types/media-types.xhtml) of
     * the input. If the input is a raw document, refer to [supported file
     * types](https://cloud.google.com/document-ai/docs/file-types) for the list
     * of media types. If the input is a
     * [Document][google.cloud.documentai.v1beta3.Document], the type should be
     * `application/json`.
     * </pre>
     *
     * <code>string mime_type = 2;</code>
     *
     * @return The mimeType.
     */
    java.lang.String getMimeType();
    /**
     *
     *
     * <pre>
     * An IANA published [media type (MIME
     * type)](https://www.iana.org/assignments/media-types/media-types.xhtml) of
     * the input. If the input is a raw document, refer to [supported file
     * types](https://cloud.google.com/document-ai/docs/file-types) for the list
     * of media types. If the input is a
     * [Document][google.cloud.documentai.v1beta3.Document], the type should be
     * `application/json`.
     * </pre>
     *
     * <code>string mime_type = 2;</code>
     *
     * @return The bytes for mimeType.
     */
    com.google.protobuf.ByteString getMimeTypeBytes();
  }
  /**
   *
   *
   * <pre>
   * The message for input config in batch process.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig}
   */
  @java.lang.Deprecated
  public static final class BatchInputConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig)
      BatchInputConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BatchInputConfig.newBuilder() to construct.
    private BatchInputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BatchInputConfig() {
      gcsSource_ = "";
      mimeType_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BatchInputConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_BatchInputConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_BatchInputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.class,
              com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder
                  .class);
    }

    public static final int GCS_SOURCE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object gcsSource_ = "";
    /**
     *
     *
     * <pre>
     * The Cloud Storage location as the source of the document.
     * </pre>
     *
     * <code>string gcs_source = 1;</code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public java.lang.String getGcsSource() {
      java.lang.Object ref = gcsSource_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcsSource_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage location as the source of the document.
     * </pre>
     *
     * <code>string gcs_source = 1;</code>
     *
     * @return The bytes for gcsSource.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcsSourceBytes() {
      java.lang.Object ref = gcsSource_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcsSource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MIME_TYPE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object mimeType_ = "";
    /**
     *
     *
     * <pre>
     * An IANA published [media type (MIME
     * type)](https://www.iana.org/assignments/media-types/media-types.xhtml) of
     * the input. If the input is a raw document, refer to [supported file
     * types](https://cloud.google.com/document-ai/docs/file-types) for the list
     * of media types. If the input is a
     * [Document][google.cloud.documentai.v1beta3.Document], the type should be
     * `application/json`.
     * </pre>
     *
     * <code>string mime_type = 2;</code>
     *
     * @return The mimeType.
     */
    @java.lang.Override
    public java.lang.String getMimeType() {
      java.lang.Object ref = mimeType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mimeType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * An IANA published [media type (MIME
     * type)](https://www.iana.org/assignments/media-types/media-types.xhtml) of
     * the input. If the input is a raw document, refer to [supported file
     * types](https://cloud.google.com/document-ai/docs/file-types) for the list
     * of media types. If the input is a
     * [Document][google.cloud.documentai.v1beta3.Document], the type should be
     * `application/json`.
     * </pre>
     *
     * <code>string mime_type = 2;</code>
     *
     * @return The bytes for mimeType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMimeTypeBytes() {
      java.lang.Object ref = mimeType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mimeType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsSource_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, gcsSource_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mimeType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, mimeType_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsSource_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, gcsSource_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mimeType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, mimeType_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig other =
          (com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig) obj;

      if (!getGcsSource().equals(other.getGcsSource())) return false;
      if (!getMimeType().equals(other.getMimeType())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getGcsSource().hashCode();
      hash = (37 * hash) + MIME_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getMimeType().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The message for input config in batch process.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig)
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_BatchInputConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_BatchInputConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.class,
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        gcsSource_ = "";
        mimeType_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_BatchInputConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig build() {
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
          buildPartial() {
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig result =
            new com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.gcsSource_ = gcsSource_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.mimeType_ = mimeType_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig other) {
        if (other
            == com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
                .getDefaultInstance()) return this;
        if (!other.getGcsSource().isEmpty()) {
          gcsSource_ = other.gcsSource_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getMimeType().isEmpty()) {
          mimeType_ = other.mimeType_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  gcsSource_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  mimeType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object gcsSource_ = "";
      /**
       *
       *
       * <pre>
       * The Cloud Storage location as the source of the document.
       * </pre>
       *
       * <code>string gcs_source = 1;</code>
       *
       * @return The gcsSource.
       */
      public java.lang.String getGcsSource() {
        java.lang.Object ref = gcsSource_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gcsSource_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location as the source of the document.
       * </pre>
       *
       * <code>string gcs_source = 1;</code>
       *
       * @return The bytes for gcsSource.
       */
      public com.google.protobuf.ByteString getGcsSourceBytes() {
        java.lang.Object ref = gcsSource_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gcsSource_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location as the source of the document.
       * </pre>
       *
       * <code>string gcs_source = 1;</code>
       *
       * @param value The gcsSource to set.
       * @return This builder for chaining.
       */
      public Builder setGcsSource(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        gcsSource_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location as the source of the document.
       * </pre>
       *
       * <code>string gcs_source = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcsSource() {
        gcsSource_ = getDefaultInstance().getGcsSource();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage location as the source of the document.
       * </pre>
       *
       * <code>string gcs_source = 1;</code>
       *
       * @param value The bytes for gcsSource to set.
       * @return This builder for chaining.
       */
      public Builder setGcsSourceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        gcsSource_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object mimeType_ = "";
      /**
       *
       *
       * <pre>
       * An IANA published [media type (MIME
       * type)](https://www.iana.org/assignments/media-types/media-types.xhtml) of
       * the input. If the input is a raw document, refer to [supported file
       * types](https://cloud.google.com/document-ai/docs/file-types) for the list
       * of media types. If the input is a
       * [Document][google.cloud.documentai.v1beta3.Document], the type should be
       * `application/json`.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @return The mimeType.
       */
      public java.lang.String getMimeType() {
        java.lang.Object ref = mimeType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          mimeType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * An IANA published [media type (MIME
       * type)](https://www.iana.org/assignments/media-types/media-types.xhtml) of
       * the input. If the input is a raw document, refer to [supported file
       * types](https://cloud.google.com/document-ai/docs/file-types) for the list
       * of media types. If the input is a
       * [Document][google.cloud.documentai.v1beta3.Document], the type should be
       * `application/json`.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @return The bytes for mimeType.
       */
      public com.google.protobuf.ByteString getMimeTypeBytes() {
        java.lang.Object ref = mimeType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          mimeType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * An IANA published [media type (MIME
       * type)](https://www.iana.org/assignments/media-types/media-types.xhtml) of
       * the input. If the input is a raw document, refer to [supported file
       * types](https://cloud.google.com/document-ai/docs/file-types) for the list
       * of media types. If the input is a
       * [Document][google.cloud.documentai.v1beta3.Document], the type should be
       * `application/json`.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @param value The mimeType to set.
       * @return This builder for chaining.
       */
      public Builder setMimeType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        mimeType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An IANA published [media type (MIME
       * type)](https://www.iana.org/assignments/media-types/media-types.xhtml) of
       * the input. If the input is a raw document, refer to [supported file
       * types](https://cloud.google.com/document-ai/docs/file-types) for the list
       * of media types. If the input is a
       * [Document][google.cloud.documentai.v1beta3.Document], the type should be
       * `application/json`.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMimeType() {
        mimeType_ = getDefaultInstance().getMimeType();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An IANA published [media type (MIME
       * type)](https://www.iana.org/assignments/media-types/media-types.xhtml) of
       * the input. If the input is a raw document, refer to [supported file
       * types](https://cloud.google.com/document-ai/docs/file-types) for the list
       * of media types. If the input is a
       * [Document][google.cloud.documentai.v1beta3.Document], the type should be
       * `application/json`.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @param value The bytes for mimeType to set.
       * @return This builder for chaining.
       */
      public Builder setMimeTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        mimeType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig)
    private static final com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig();
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BatchInputConfig> PARSER =
        new com.google.protobuf.AbstractParser<BatchInputConfig>() {
          @java.lang.Override
          public BatchInputConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BatchInputConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BatchInputConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  @java.lang.Deprecated
  public interface BatchOutputConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The output Cloud Storage directory to put the processed documents.
     * </pre>
     *
     * <code>string gcs_destination = 1;</code>
     *
     * @return The gcsDestination.
     */
    java.lang.String getGcsDestination();
    /**
     *
     *
     * <pre>
     * The output Cloud Storage directory to put the processed documents.
     * </pre>
     *
     * <code>string gcs_destination = 1;</code>
     *
     * @return The bytes for gcsDestination.
     */
    com.google.protobuf.ByteString getGcsDestinationBytes();
  }
  /**
   *
   *
   * <pre>
   * The output configuration in the
   * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig}
   */
  @java.lang.Deprecated
  public static final class BatchOutputConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig)
      BatchOutputConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BatchOutputConfig.newBuilder() to construct.
    private BatchOutputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BatchOutputConfig() {
      gcsDestination_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BatchOutputConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_BatchOutputConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_BatchOutputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.class,
              com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.Builder
                  .class);
    }

    public static final int GCS_DESTINATION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object gcsDestination_ = "";
    /**
     *
     *
     * <pre>
     * The output Cloud Storage directory to put the processed documents.
     * </pre>
     *
     * <code>string gcs_destination = 1;</code>
     *
     * @return The gcsDestination.
     */
    @java.lang.Override
    public java.lang.String getGcsDestination() {
      java.lang.Object ref = gcsDestination_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcsDestination_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The output Cloud Storage directory to put the processed documents.
     * </pre>
     *
     * <code>string gcs_destination = 1;</code>
     *
     * @return The bytes for gcsDestination.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcsDestinationBytes() {
      java.lang.Object ref = gcsDestination_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcsDestination_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsDestination_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, gcsDestination_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsDestination_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, gcsDestination_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig other =
          (com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig) obj;

      if (!getGcsDestination().equals(other.getGcsDestination())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + GCS_DESTINATION_FIELD_NUMBER;
      hash = (53 * hash) + getGcsDestination().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The output configuration in the
     * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
     * method.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig)
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_BatchOutputConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_BatchOutputConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.class,
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        gcsDestination_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_BatchOutputConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig build() {
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
          buildPartial() {
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig result =
            new com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.gcsDestination_ = gcsDestination_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig other) {
        if (other
            == com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
                .getDefaultInstance()) return this;
        if (!other.getGcsDestination().isEmpty()) {
          gcsDestination_ = other.gcsDestination_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  gcsDestination_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object gcsDestination_ = "";
      /**
       *
       *
       * <pre>
       * The output Cloud Storage directory to put the processed documents.
       * </pre>
       *
       * <code>string gcs_destination = 1;</code>
       *
       * @return The gcsDestination.
       */
      public java.lang.String getGcsDestination() {
        java.lang.Object ref = gcsDestination_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gcsDestination_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The output Cloud Storage directory to put the processed documents.
       * </pre>
       *
       * <code>string gcs_destination = 1;</code>
       *
       * @return The bytes for gcsDestination.
       */
      public com.google.protobuf.ByteString getGcsDestinationBytes() {
        java.lang.Object ref = gcsDestination_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gcsDestination_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The output Cloud Storage directory to put the processed documents.
       * </pre>
       *
       * <code>string gcs_destination = 1;</code>
       *
       * @param value The gcsDestination to set.
       * @return This builder for chaining.
       */
      public Builder setGcsDestination(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        gcsDestination_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The output Cloud Storage directory to put the processed documents.
       * </pre>
       *
       * <code>string gcs_destination = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcsDestination() {
        gcsDestination_ = getDefaultInstance().getGcsDestination();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The output Cloud Storage directory to put the processed documents.
       * </pre>
       *
       * <code>string gcs_destination = 1;</code>
       *
       * @param value The bytes for gcsDestination to set.
       * @return This builder for chaining.
       */
      public Builder setGcsDestinationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        gcsDestination_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig)
    private static final com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig();
    }

    public static com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BatchOutputConfig> PARSER =
        new com.google.protobuf.AbstractParser<BatchOutputConfig>() {
          @java.lang.Override
          public BatchOutputConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BatchOutputConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BatchOutputConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of
   * [Processor][google.cloud.documentai.v1beta3.Processor] or
   * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
   * Format: `projects/{project}/locations/{location}/processors/{processor}`,
   * or
   * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of
   * [Processor][google.cloud.documentai.v1beta3.Processor] or
   * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
   * Format: `projects/{project}/locations/{location}/processors/{processor}`,
   * or
   * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUT_CONFIGS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig>
      inputConfigs_;
  /**
   *
   *
   * <pre>
   * The input config for each single document in the batch process.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig>
      getInputConfigsList() {
    return inputConfigs_;
  }
  /**
   *
   *
   * <pre>
   * The input config for each single document in the batch process.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<
          ? extends
              com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfigOrBuilder>
      getInputConfigsOrBuilderList() {
    return inputConfigs_;
  }
  /**
   *
   *
   * <pre>
   * The input config for each single document in the batch process.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getInputConfigsCount() {
    return inputConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * The input config for each single document in the batch process.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig getInputConfigs(
      int index) {
    return inputConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The input config for each single document in the batch process.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfigOrBuilder
      getInputConfigsOrBuilder(int index) {
    return inputConfigs_.get(index);
  }

  public static final int OUTPUT_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig outputConfig_;
  /**
   *
   *
   * <pre>
   * The overall output config for batch process.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.documentai.v1beta3.BatchProcessRequest.output_config is deprecated.
   *     See google/cloud/documentai/v1beta3/document_processor_service.proto;l=541
   * @return Whether the outputConfig field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasOutputConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The overall output config for batch process.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.documentai.v1beta3.BatchProcessRequest.output_config is deprecated.
   *     See google/cloud/documentai/v1beta3/document_processor_service.proto;l=541
   * @return The outputConfig.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
      getOutputConfig() {
    return outputConfig_ == null
        ? com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
            .getDefaultInstance()
        : outputConfig_;
  }
  /**
   *
   *
   * <pre>
   * The overall output config for batch process.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfigOrBuilder
      getOutputConfigOrBuilder() {
    return outputConfig_ == null
        ? com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
            .getDefaultInstance()
        : outputConfig_;
  }

  public static final int INPUT_DOCUMENTS_FIELD_NUMBER = 5;
  private com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig inputDocuments_;
  /**
   *
   *
   * <pre>
   * The input documents for the
   * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
   * method.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig input_documents = 5;</code>
   *
   * @return Whether the inputDocuments field is set.
   */
  @java.lang.Override
  public boolean hasInputDocuments() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The input documents for the
   * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
   * method.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig input_documents = 5;</code>
   *
   * @return The inputDocuments.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig getInputDocuments() {
    return inputDocuments_ == null
        ? com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.getDefaultInstance()
        : inputDocuments_;
  }
  /**
   *
   *
   * <pre>
   * The input documents for the
   * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
   * method.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig input_documents = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder
      getInputDocumentsOrBuilder() {
    return inputDocuments_ == null
        ? com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.getDefaultInstance()
        : inputDocuments_;
  }

  public static final int DOCUMENT_OUTPUT_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.documentai.v1beta3.DocumentOutputConfig documentOutputConfig_;
  /**
   *
   *
   * <pre>
   * The output configuration for the
   * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
   * method.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentOutputConfig document_output_config = 6;</code>
   *
   * @return Whether the documentOutputConfig field is set.
   */
  @java.lang.Override
  public boolean hasDocumentOutputConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The output configuration for the
   * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
   * method.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentOutputConfig document_output_config = 6;</code>
   *
   * @return The documentOutputConfig.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentOutputConfig getDocumentOutputConfig() {
    return documentOutputConfig_ == null
        ? com.google.cloud.documentai.v1beta3.DocumentOutputConfig.getDefaultInstance()
        : documentOutputConfig_;
  }
  /**
   *
   *
   * <pre>
   * The output configuration for the
   * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
   * method.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentOutputConfig document_output_config = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentOutputConfigOrBuilder
      getDocumentOutputConfigOrBuilder() {
    return documentOutputConfig_ == null
        ? com.google.cloud.documentai.v1beta3.DocumentOutputConfig.getDefaultInstance()
        : documentOutputConfig_;
  }

  public static final int SKIP_HUMAN_REVIEW_FIELD_NUMBER = 4;
  private boolean skipHumanReview_ = false;
  /**
   *
   *
   * <pre>
   * Whether human review should be skipped for this request. Default to
   * `false`.
   * </pre>
   *
   * <code>bool skip_human_review = 4;</code>
   *
   * @return The skipHumanReview.
   */
  @java.lang.Override
  public boolean getSkipHumanReview() {
    return skipHumanReview_;
  }

  public static final int PROCESS_OPTIONS_FIELD_NUMBER = 7;
  private com.google.cloud.documentai.v1beta3.ProcessOptions processOptions_;
  /**
   *
   *
   * <pre>
   * Inference-time options for the process API
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
   *
   * @return Whether the processOptions field is set.
   */
  @java.lang.Override
  public boolean hasProcessOptions() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Inference-time options for the process API
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
   *
   * @return The processOptions.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ProcessOptions getProcessOptions() {
    return processOptions_ == null
        ? com.google.cloud.documentai.v1beta3.ProcessOptions.getDefaultInstance()
        : processOptions_;
  }
  /**
   *
   *
   * <pre>
   * Inference-time options for the process API
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ProcessOptionsOrBuilder getProcessOptionsOrBuilder() {
    return processOptions_ == null
        ? com.google.cloud.documentai.v1beta3.ProcessOptions.getDefaultInstance()
        : processOptions_;
  }

  public static final int LABELS_FIELD_NUMBER = 9;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
                .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata for the request.
   *
   * Label keys and values can be no longer than 63 characters
   * (Unicode codepoints) and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. International characters are allowed.
   * Label values are optional. Label keys must start with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata for the request.
   *
   * Label keys and values can be no longer than 63 characters
   * (Unicode codepoints) and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. International characters are allowed.
   * Label values are optional. Label keys must start with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata for the request.
   *
   * Label keys and values can be no longer than 63 characters
   * (Unicode codepoints) and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. International characters are allowed.
   * Label values are optional. Label keys must start with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata for the request.
   *
   * Label keys and values can be no longer than 63 characters
   * (Unicode codepoints) and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. International characters are allowed.
   * Label values are optional. Label keys must start with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < inputConfigs_.size(); i++) {
      output.writeMessage(2, inputConfigs_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getOutputConfig());
    }
    if (skipHumanReview_ != false) {
      output.writeBool(4, skipHumanReview_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getInputDocuments());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(6, getDocumentOutputConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(7, getProcessOptions());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 9);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (int i = 0; i < inputConfigs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, inputConfigs_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getOutputConfig());
    }
    if (skipHumanReview_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, skipHumanReview_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getInputDocuments());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDocumentOutputConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getProcessOptions());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, labels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.BatchProcessRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.BatchProcessRequest other =
        (com.google.cloud.documentai.v1beta3.BatchProcessRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getInputConfigsList().equals(other.getInputConfigsList())) return false;
    if (hasOutputConfig() != other.hasOutputConfig()) return false;
    if (hasOutputConfig()) {
      if (!getOutputConfig().equals(other.getOutputConfig())) return false;
    }
    if (hasInputDocuments() != other.hasInputDocuments()) return false;
    if (hasInputDocuments()) {
      if (!getInputDocuments().equals(other.getInputDocuments())) return false;
    }
    if (hasDocumentOutputConfig() != other.hasDocumentOutputConfig()) return false;
    if (hasDocumentOutputConfig()) {
      if (!getDocumentOutputConfig().equals(other.getDocumentOutputConfig())) return false;
    }
    if (getSkipHumanReview() != other.getSkipHumanReview()) return false;
    if (hasProcessOptions() != other.hasProcessOptions()) return false;
    if (hasProcessOptions()) {
      if (!getProcessOptions().equals(other.getProcessOptions())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getInputConfigsCount() > 0) {
      hash = (37 * hash) + INPUT_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getInputConfigsList().hashCode();
    }
    if (hasOutputConfig()) {
      hash = (37 * hash) + OUTPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOutputConfig().hashCode();
    }
    if (hasInputDocuments()) {
      hash = (37 * hash) + INPUT_DOCUMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getInputDocuments().hashCode();
    }
    if (hasDocumentOutputConfig()) {
      hash = (37 * hash) + DOCUMENT_OUTPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentOutputConfig().hashCode();
    }
    hash = (37 * hash) + SKIP_HUMAN_REVIEW_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSkipHumanReview());
    if (hasProcessOptions()) {
      hash = (37 * hash) + PROCESS_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getProcessOptions().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.documentai.v1beta3.BatchProcessRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments].
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.BatchProcessRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.BatchProcessRequest)
      com.google.cloud.documentai.v1beta3.BatchProcessRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 9:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 9:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.BatchProcessRequest.class,
              com.google.cloud.documentai.v1beta3.BatchProcessRequest.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.BatchProcessRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInputConfigsFieldBuilder();
        getOutputConfigFieldBuilder();
        getInputDocumentsFieldBuilder();
        getDocumentOutputConfigFieldBuilder();
        getProcessOptionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (inputConfigsBuilder_ == null) {
        inputConfigs_ = java.util.Collections.emptyList();
      } else {
        inputConfigs_ = null;
        inputConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      outputConfig_ = null;
      if (outputConfigBuilder_ != null) {
        outputConfigBuilder_.dispose();
        outputConfigBuilder_ = null;
      }
      inputDocuments_ = null;
      if (inputDocumentsBuilder_ != null) {
        inputDocumentsBuilder_.dispose();
        inputDocumentsBuilder_ = null;
      }
      documentOutputConfig_ = null;
      if (documentOutputConfigBuilder_ != null) {
        documentOutputConfigBuilder_.dispose();
        documentOutputConfigBuilder_ = null;
      }
      skipHumanReview_ = false;
      processOptions_ = null;
      if (processOptionsBuilder_ != null) {
        processOptionsBuilder_.dispose();
        processOptionsBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_BatchProcessRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.BatchProcessRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest build() {
      com.google.cloud.documentai.v1beta3.BatchProcessRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest buildPartial() {
      com.google.cloud.documentai.v1beta3.BatchProcessRequest result =
          new com.google.cloud.documentai.v1beta3.BatchProcessRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.documentai.v1beta3.BatchProcessRequest result) {
      if (inputConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          inputConfigs_ = java.util.Collections.unmodifiableList(inputConfigs_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.inputConfigs_ = inputConfigs_;
      } else {
        result.inputConfigs_ = inputConfigsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta3.BatchProcessRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.outputConfig_ =
            outputConfigBuilder_ == null ? outputConfig_ : outputConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.inputDocuments_ =
            inputDocumentsBuilder_ == null ? inputDocuments_ : inputDocumentsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.documentOutputConfig_ =
            documentOutputConfigBuilder_ == null
                ? documentOutputConfig_
                : documentOutputConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.skipHumanReview_ = skipHumanReview_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.processOptions_ =
            processOptionsBuilder_ == null ? processOptions_ : processOptionsBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.BatchProcessRequest) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.BatchProcessRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.BatchProcessRequest other) {
      if (other == com.google.cloud.documentai.v1beta3.BatchProcessRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (inputConfigsBuilder_ == null) {
        if (!other.inputConfigs_.isEmpty()) {
          if (inputConfigs_.isEmpty()) {
            inputConfigs_ = other.inputConfigs_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureInputConfigsIsMutable();
            inputConfigs_.addAll(other.inputConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.inputConfigs_.isEmpty()) {
          if (inputConfigsBuilder_.isEmpty()) {
            inputConfigsBuilder_.dispose();
            inputConfigsBuilder_ = null;
            inputConfigs_ = other.inputConfigs_;
            bitField0_ = (bitField0_ & ~0x00000002);
            inputConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInputConfigsFieldBuilder()
                    : null;
          } else {
            inputConfigsBuilder_.addAllMessages(other.inputConfigs_);
          }
        }
      }
      if (other.hasOutputConfig()) {
        mergeOutputConfig(other.getOutputConfig());
      }
      if (other.hasInputDocuments()) {
        mergeInputDocuments(other.getInputDocuments());
      }
      if (other.hasDocumentOutputConfig()) {
        mergeDocumentOutputConfig(other.getDocumentOutputConfig());
      }
      if (other.getSkipHumanReview() != false) {
        setSkipHumanReview(other.getSkipHumanReview());
      }
      if (other.hasProcessOptions()) {
        mergeProcessOptions(other.getProcessOptions());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000080;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig m =
                    input.readMessage(
                        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
                            .parser(),
                        extensionRegistry);
                if (inputConfigsBuilder_ == null) {
                  ensureInputConfigsIsMutable();
                  inputConfigs_.add(m);
                } else {
                  inputConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getOutputConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                skipHumanReview_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getInputDocumentsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getDocumentOutputConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getProcessOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 74:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of
     * [Processor][google.cloud.documentai.v1beta3.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
     * Format: `projects/{project}/locations/{location}/processors/{processor}`,
     * or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of
     * [Processor][google.cloud.documentai.v1beta3.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
     * Format: `projects/{project}/locations/{location}/processors/{processor}`,
     * or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of
     * [Processor][google.cloud.documentai.v1beta3.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
     * Format: `projects/{project}/locations/{location}/processors/{processor}`,
     * or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of
     * [Processor][google.cloud.documentai.v1beta3.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
     * Format: `projects/{project}/locations/{location}/processors/{processor}`,
     * or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of
     * [Processor][google.cloud.documentai.v1beta3.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
     * Format: `projects/{project}/locations/{location}/processors/{processor}`,
     * or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig>
        inputConfigs_ = java.util.Collections.emptyList();

    private void ensureInputConfigsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        inputConfigs_ =
            new java.util.ArrayList<
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig>(
                inputConfigs_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig,
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder,
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfigOrBuilder>
        inputConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig>
        getInputConfigsList() {
      if (inputConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(inputConfigs_);
      } else {
        return inputConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public int getInputConfigsCount() {
      if (inputConfigsBuilder_ == null) {
        return inputConfigs_.size();
      } else {
        return inputConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig getInputConfigs(
        int index) {
      if (inputConfigsBuilder_ == null) {
        return inputConfigs_.get(index);
      } else {
        return inputConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setInputConfigs(
        int index, com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig value) {
      if (inputConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputConfigsIsMutable();
        inputConfigs_.set(index, value);
        onChanged();
      } else {
        inputConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setInputConfigs(
        int index,
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder
            builderForValue) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        inputConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        inputConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addInputConfigs(
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig value) {
      if (inputConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputConfigsIsMutable();
        inputConfigs_.add(value);
        onChanged();
      } else {
        inputConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addInputConfigs(
        int index, com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig value) {
      if (inputConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputConfigsIsMutable();
        inputConfigs_.add(index, value);
        onChanged();
      } else {
        inputConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addInputConfigs(
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder
            builderForValue) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        inputConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        inputConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addInputConfigs(
        int index,
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder
            builderForValue) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        inputConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        inputConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addAllInputConfigs(
        java.lang.Iterable<
                ? extends com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig>
            values) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, inputConfigs_);
        onChanged();
      } else {
        inputConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearInputConfigs() {
      if (inputConfigsBuilder_ == null) {
        inputConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        inputConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder removeInputConfigs(int index) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        inputConfigs_.remove(index);
        onChanged();
      } else {
        inputConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder
        getInputConfigsBuilder(int index) {
      return getInputConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfigOrBuilder
        getInputConfigsOrBuilder(int index) {
      if (inputConfigsBuilder_ == null) {
        return inputConfigs_.get(index);
      } else {
        return inputConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<
            ? extends
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfigOrBuilder>
        getInputConfigsOrBuilderList() {
      if (inputConfigsBuilder_ != null) {
        return inputConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(inputConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder
        addInputConfigsBuilder() {
      return getInputConfigsFieldBuilder()
          .addBuilder(
              com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder
        addInputConfigsBuilder(int index) {
      return getInputConfigsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The input config for each single document in the batch process.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig input_configs = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder>
        getInputConfigsBuilderList() {
      return getInputConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig,
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder,
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfigOrBuilder>
        getInputConfigsFieldBuilder() {
      if (inputConfigsBuilder_ == null) {
        inputConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig,
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig.Builder,
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfigOrBuilder>(
                inputConfigs_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        inputConfigs_ = null;
      }
      return inputConfigsBuilder_;
    }

    private com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig outputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig,
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.Builder,
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfigOrBuilder>
        outputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.documentai.v1beta3.BatchProcessRequest.output_config is deprecated.
     *     See google/cloud/documentai/v1beta3/document_processor_service.proto;l=541
     * @return Whether the outputConfig field is set.
     */
    @java.lang.Deprecated
    public boolean hasOutputConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.documentai.v1beta3.BatchProcessRequest.output_config is deprecated.
     *     See google/cloud/documentai/v1beta3/document_processor_service.proto;l=541
     * @return The outputConfig.
     */
    @java.lang.Deprecated
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
        getOutputConfig() {
      if (outputConfigBuilder_ == null) {
        return outputConfig_ == null
            ? com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
                .getDefaultInstance()
            : outputConfig_;
      } else {
        return outputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setOutputConfig(
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputConfig_ = value;
      } else {
        outputConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setOutputConfig(
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.Builder
            builderForValue) {
      if (outputConfigBuilder_ == null) {
        outputConfig_ = builderForValue.build();
      } else {
        outputConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder mergeOutputConfig(
        com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && outputConfig_ != null
            && outputConfig_
                != com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
                    .getDefaultInstance()) {
          getOutputConfigBuilder().mergeFrom(value);
        } else {
          outputConfig_ = value;
        }
      } else {
        outputConfigBuilder_.mergeFrom(value);
      }
      if (outputConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearOutputConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      outputConfig_ = null;
      if (outputConfigBuilder_ != null) {
        outputConfigBuilder_.dispose();
        outputConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.Builder
        getOutputConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getOutputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfigOrBuilder
        getOutputConfigOrBuilder() {
      if (outputConfigBuilder_ != null) {
        return outputConfigBuilder_.getMessageOrBuilder();
      } else {
        return outputConfig_ == null
            ? com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
                .getDefaultInstance()
            : outputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig output_config = 3 [deprecated = true];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig,
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.Builder,
            com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfigOrBuilder>
        getOutputConfigFieldBuilder() {
      if (outputConfigBuilder_ == null) {
        outputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig,
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig.Builder,
                com.google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfigOrBuilder>(
                getOutputConfig(), getParentForChildren(), isClean());
        outputConfig_ = null;
      }
      return outputConfigBuilder_;
    }

    private com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig inputDocuments_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig,
            com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.Builder,
            com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder>
        inputDocumentsBuilder_;
    /**
     *
     *
     * <pre>
     * The input documents for the
     * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
     * method.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig input_documents = 5;</code>
     *
     * @return Whether the inputDocuments field is set.
     */
    public boolean hasInputDocuments() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The input documents for the
     * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
     * method.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig input_documents = 5;</code>
     *
     * @return The inputDocuments.
     */
    public com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig getInputDocuments() {
      if (inputDocumentsBuilder_ == null) {
        return inputDocuments_ == null
            ? com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.getDefaultInstance()
            : inputDocuments_;
      } else {
        return inputDocumentsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The input documents for the
     * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
     * method.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig input_documents = 5;</code>
     */
    public Builder setInputDocuments(
        com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig value) {
      if (inputDocumentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputDocuments_ = value;
      } else {
        inputDocumentsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input documents for the
     * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
     * method.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig input_documents = 5;</code>
     */
    public Builder setInputDocuments(
        com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.Builder builderForValue) {
      if (inputDocumentsBuilder_ == null) {
        inputDocuments_ = builderForValue.build();
      } else {
        inputDocumentsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input documents for the
     * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
     * method.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig input_documents = 5;</code>
     */
    public Builder mergeInputDocuments(
        com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig value) {
      if (inputDocumentsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && inputDocuments_ != null
            && inputDocuments_
                != com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig
                    .getDefaultInstance()) {
          getInputDocumentsBuilder().mergeFrom(value);
        } else {
          inputDocuments_ = value;
        }
      } else {
        inputDocumentsBuilder_.mergeFrom(value);
      }
      if (inputDocuments_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input documents for the
     * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
     * method.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig input_documents = 5;</code>
     */
    public Builder clearInputDocuments() {
      bitField0_ = (bitField0_ & ~0x00000008);
      inputDocuments_ = null;
      if (inputDocumentsBuilder_ != null) {
        inputDocumentsBuilder_.dispose();
        inputDocumentsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input documents for the
     * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
     * method.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig input_documents = 5;</code>
     */
    public com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.Builder
        getInputDocumentsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getInputDocumentsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The input documents for the
     * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
     * method.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig input_documents = 5;</code>
     */
    public com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder
        getInputDocumentsOrBuilder() {
      if (inputDocumentsBuilder_ != null) {
        return inputDocumentsBuilder_.getMessageOrBuilder();
      } else {
        return inputDocuments_ == null
            ? com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.getDefaultInstance()
            : inputDocuments_;
      }
    }
    /**
     *
     *
     * <pre>
     * The input documents for the
     * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
     * method.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig input_documents = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig,
            com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.Builder,
            com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder>
        getInputDocumentsFieldBuilder() {
      if (inputDocumentsBuilder_ == null) {
        inputDocumentsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig,
                com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.Builder,
                com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder>(
                getInputDocuments(), getParentForChildren(), isClean());
        inputDocuments_ = null;
      }
      return inputDocumentsBuilder_;
    }

    private com.google.cloud.documentai.v1beta3.DocumentOutputConfig documentOutputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentOutputConfig,
            com.google.cloud.documentai.v1beta3.DocumentOutputConfig.Builder,
            com.google.cloud.documentai.v1beta3.DocumentOutputConfigOrBuilder>
        documentOutputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The output configuration for the
     * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
     * method.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentOutputConfig document_output_config = 6;
     * </code>
     *
     * @return Whether the documentOutputConfig field is set.
     */
    public boolean hasDocumentOutputConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The output configuration for the
     * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
     * method.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentOutputConfig document_output_config = 6;
     * </code>
     *
     * @return The documentOutputConfig.
     */
    public com.google.cloud.documentai.v1beta3.DocumentOutputConfig getDocumentOutputConfig() {
      if (documentOutputConfigBuilder_ == null) {
        return documentOutputConfig_ == null
            ? com.google.cloud.documentai.v1beta3.DocumentOutputConfig.getDefaultInstance()
            : documentOutputConfig_;
      } else {
        return documentOutputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The output configuration for the
     * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
     * method.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentOutputConfig document_output_config = 6;
     * </code>
     */
    public Builder setDocumentOutputConfig(
        com.google.cloud.documentai.v1beta3.DocumentOutputConfig value) {
      if (documentOutputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentOutputConfig_ = value;
      } else {
        documentOutputConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The output configuration for the
     * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
     * method.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentOutputConfig document_output_config = 6;
     * </code>
     */
    public Builder setDocumentOutputConfig(
        com.google.cloud.documentai.v1beta3.DocumentOutputConfig.Builder builderForValue) {
      if (documentOutputConfigBuilder_ == null) {
        documentOutputConfig_ = builderForValue.build();
      } else {
        documentOutputConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The output configuration for the
     * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
     * method.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentOutputConfig document_output_config = 6;
     * </code>
     */
    public Builder mergeDocumentOutputConfig(
        com.google.cloud.documentai.v1beta3.DocumentOutputConfig value) {
      if (documentOutputConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && documentOutputConfig_ != null
            && documentOutputConfig_
                != com.google.cloud.documentai.v1beta3.DocumentOutputConfig.getDefaultInstance()) {
          getDocumentOutputConfigBuilder().mergeFrom(value);
        } else {
          documentOutputConfig_ = value;
        }
      } else {
        documentOutputConfigBuilder_.mergeFrom(value);
      }
      if (documentOutputConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The output configuration for the
     * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
     * method.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentOutputConfig document_output_config = 6;
     * </code>
     */
    public Builder clearDocumentOutputConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      documentOutputConfig_ = null;
      if (documentOutputConfigBuilder_ != null) {
        documentOutputConfigBuilder_.dispose();
        documentOutputConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The output configuration for the
     * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
     * method.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentOutputConfig document_output_config = 6;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentOutputConfig.Builder
        getDocumentOutputConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getDocumentOutputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The output configuration for the
     * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
     * method.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentOutputConfig document_output_config = 6;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentOutputConfigOrBuilder
        getDocumentOutputConfigOrBuilder() {
      if (documentOutputConfigBuilder_ != null) {
        return documentOutputConfigBuilder_.getMessageOrBuilder();
      } else {
        return documentOutputConfig_ == null
            ? com.google.cloud.documentai.v1beta3.DocumentOutputConfig.getDefaultInstance()
            : documentOutputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The output configuration for the
     * [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments]
     * method.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentOutputConfig document_output_config = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentOutputConfig,
            com.google.cloud.documentai.v1beta3.DocumentOutputConfig.Builder,
            com.google.cloud.documentai.v1beta3.DocumentOutputConfigOrBuilder>
        getDocumentOutputConfigFieldBuilder() {
      if (documentOutputConfigBuilder_ == null) {
        documentOutputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.DocumentOutputConfig,
                com.google.cloud.documentai.v1beta3.DocumentOutputConfig.Builder,
                com.google.cloud.documentai.v1beta3.DocumentOutputConfigOrBuilder>(
                getDocumentOutputConfig(), getParentForChildren(), isClean());
        documentOutputConfig_ = null;
      }
      return documentOutputConfigBuilder_;
    }

    private boolean skipHumanReview_;
    /**
     *
     *
     * <pre>
     * Whether human review should be skipped for this request. Default to
     * `false`.
     * </pre>
     *
     * <code>bool skip_human_review = 4;</code>
     *
     * @return The skipHumanReview.
     */
    @java.lang.Override
    public boolean getSkipHumanReview() {
      return skipHumanReview_;
    }
    /**
     *
     *
     * <pre>
     * Whether human review should be skipped for this request. Default to
     * `false`.
     * </pre>
     *
     * <code>bool skip_human_review = 4;</code>
     *
     * @param value The skipHumanReview to set.
     * @return This builder for chaining.
     */
    public Builder setSkipHumanReview(boolean value) {

      skipHumanReview_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether human review should be skipped for this request. Default to
     * `false`.
     * </pre>
     *
     * <code>bool skip_human_review = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSkipHumanReview() {
      bitField0_ = (bitField0_ & ~0x00000020);
      skipHumanReview_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.documentai.v1beta3.ProcessOptions processOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ProcessOptions,
            com.google.cloud.documentai.v1beta3.ProcessOptions.Builder,
            com.google.cloud.documentai.v1beta3.ProcessOptionsOrBuilder>
        processOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Inference-time options for the process API
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
     *
     * @return Whether the processOptions field is set.
     */
    public boolean hasProcessOptions() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Inference-time options for the process API
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
     *
     * @return The processOptions.
     */
    public com.google.cloud.documentai.v1beta3.ProcessOptions getProcessOptions() {
      if (processOptionsBuilder_ == null) {
        return processOptions_ == null
            ? com.google.cloud.documentai.v1beta3.ProcessOptions.getDefaultInstance()
            : processOptions_;
      } else {
        return processOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Inference-time options for the process API
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
     */
    public Builder setProcessOptions(com.google.cloud.documentai.v1beta3.ProcessOptions value) {
      if (processOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        processOptions_ = value;
      } else {
        processOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inference-time options for the process API
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
     */
    public Builder setProcessOptions(
        com.google.cloud.documentai.v1beta3.ProcessOptions.Builder builderForValue) {
      if (processOptionsBuilder_ == null) {
        processOptions_ = builderForValue.build();
      } else {
        processOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inference-time options for the process API
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
     */
    public Builder mergeProcessOptions(com.google.cloud.documentai.v1beta3.ProcessOptions value) {
      if (processOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && processOptions_ != null
            && processOptions_
                != com.google.cloud.documentai.v1beta3.ProcessOptions.getDefaultInstance()) {
          getProcessOptionsBuilder().mergeFrom(value);
        } else {
          processOptions_ = value;
        }
      } else {
        processOptionsBuilder_.mergeFrom(value);
      }
      if (processOptions_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inference-time options for the process API
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
     */
    public Builder clearProcessOptions() {
      bitField0_ = (bitField0_ & ~0x00000040);
      processOptions_ = null;
      if (processOptionsBuilder_ != null) {
        processOptionsBuilder_.dispose();
        processOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inference-time options for the process API
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
     */
    public com.google.cloud.documentai.v1beta3.ProcessOptions.Builder getProcessOptionsBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getProcessOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Inference-time options for the process API
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
     */
    public com.google.cloud.documentai.v1beta3.ProcessOptionsOrBuilder
        getProcessOptionsOrBuilder() {
      if (processOptionsBuilder_ != null) {
        return processOptionsBuilder_.getMessageOrBuilder();
      } else {
        return processOptions_ == null
            ? com.google.cloud.documentai.v1beta3.ProcessOptions.getDefaultInstance()
            : processOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Inference-time options for the process API
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ProcessOptions,
            com.google.cloud.documentai.v1beta3.ProcessOptions.Builder,
            com.google.cloud.documentai.v1beta3.ProcessOptionsOrBuilder>
        getProcessOptionsFieldBuilder() {
      if (processOptionsBuilder_ == null) {
        processOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.ProcessOptions,
                com.google.cloud.documentai.v1beta3.ProcessOptions.Builder,
                com.google.cloud.documentai.v1beta3.ProcessOptionsOrBuilder>(
                getProcessOptions(), getParentForChildren(), isClean());
        processOptions_ = null;
      }
      return processOptionsBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are allowed.
     * Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are allowed.
     * Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are allowed.
     * Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are allowed.
     * Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000080);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are allowed.
     * Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000080;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are allowed.
     * Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000080;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are allowed.
     * Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000080;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.BatchProcessRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.BatchProcessRequest)
  private static final com.google.cloud.documentai.v1beta3.BatchProcessRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.BatchProcessRequest();
  }

  public static com.google.cloud.documentai.v1beta3.BatchProcessRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchProcessRequest> PARSER =
      new com.google.protobuf.AbstractParser<BatchProcessRequest>() {
        @java.lang.Override
        public BatchProcessRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchProcessRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchProcessRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.BatchProcessRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
