/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/dataset.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * A singleton resource under a
 * [Processor][google.cloud.documentai.v1beta3.Processor] which configures a
 * collection of documents.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.Dataset}
 */
public final class Dataset extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Dataset)
    DatasetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Dataset.newBuilder() to construct.
  private Dataset(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Dataset() {
    name_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Dataset();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DatasetProto
        .internal_static_google_cloud_documentai_v1beta3_Dataset_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DatasetProto
        .internal_static_google_cloud_documentai_v1beta3_Dataset_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.Dataset.class,
            com.google.cloud.documentai.v1beta3.Dataset.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Different states of a dataset.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.documentai.v1beta3.Dataset.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default unspecified enum, should not be used.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Dataset has not been initialized.
     * </pre>
     *
     * <code>UNINITIALIZED = 1;</code>
     */
    UNINITIALIZED(1),
    /**
     *
     *
     * <pre>
     * Dataset is being initialized.
     * </pre>
     *
     * <code>INITIALIZING = 2;</code>
     */
    INITIALIZING(2),
    /**
     *
     *
     * <pre>
     * Dataset has been initialized.
     * </pre>
     *
     * <code>INITIALIZED = 3;</code>
     */
    INITIALIZED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default unspecified enum, should not be used.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Dataset has not been initialized.
     * </pre>
     *
     * <code>UNINITIALIZED = 1;</code>
     */
    public static final int UNINITIALIZED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Dataset is being initialized.
     * </pre>
     *
     * <code>INITIALIZING = 2;</code>
     */
    public static final int INITIALIZING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Dataset has been initialized.
     * </pre>
     *
     * <code>INITIALIZED = 3;</code>
     */
    public static final int INITIALIZED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return UNINITIALIZED;
        case 2:
          return INITIALIZING;
        case 3:
          return INITIALIZED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.Dataset.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.documentai.v1beta3.Dataset.State)
  }

  public interface GCSManagedConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage URI (a directory) where the documents
     * belonging to the dataset must be stored.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.GcsPrefix gcs_prefix = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the gcsPrefix field is set.
     */
    boolean hasGcsPrefix();
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage URI (a directory) where the documents
     * belonging to the dataset must be stored.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.GcsPrefix gcs_prefix = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The gcsPrefix.
     */
    com.google.cloud.documentai.v1beta3.GcsPrefix getGcsPrefix();
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage URI (a directory) where the documents
     * belonging to the dataset must be stored.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.GcsPrefix gcs_prefix = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.documentai.v1beta3.GcsPrefixOrBuilder getGcsPrefixOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Configuration specific to the Cloud Storage-based implementation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig}
   */
  public static final class GCSManagedConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig)
      GCSManagedConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GCSManagedConfig.newBuilder() to construct.
    private GCSManagedConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GCSManagedConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GCSManagedConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_Dataset_GCSManagedConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_Dataset_GCSManagedConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig.class,
              com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig.Builder.class);
    }

    private int bitField0_;
    public static final int GCS_PREFIX_FIELD_NUMBER = 1;
    private com.google.cloud.documentai.v1beta3.GcsPrefix gcsPrefix_;
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage URI (a directory) where the documents
     * belonging to the dataset must be stored.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.GcsPrefix gcs_prefix = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the gcsPrefix field is set.
     */
    @java.lang.Override
    public boolean hasGcsPrefix() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage URI (a directory) where the documents
     * belonging to the dataset must be stored.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.GcsPrefix gcs_prefix = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The gcsPrefix.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.GcsPrefix getGcsPrefix() {
      return gcsPrefix_ == null
          ? com.google.cloud.documentai.v1beta3.GcsPrefix.getDefaultInstance()
          : gcsPrefix_;
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage URI (a directory) where the documents
     * belonging to the dataset must be stored.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.GcsPrefix gcs_prefix = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.GcsPrefixOrBuilder getGcsPrefixOrBuilder() {
      return gcsPrefix_ == null
          ? com.google.cloud.documentai.v1beta3.GcsPrefix.getDefaultInstance()
          : gcsPrefix_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getGcsPrefix());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getGcsPrefix());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig other =
          (com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig) obj;

      if (hasGcsPrefix() != other.hasGcsPrefix()) return false;
      if (hasGcsPrefix()) {
        if (!getGcsPrefix().equals(other.getGcsPrefix())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasGcsPrefix()) {
        hash = (37 * hash) + GCS_PREFIX_FIELD_NUMBER;
        hash = (53 * hash) + getGcsPrefix().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration specific to the Cloud Storage-based implementation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig)
        com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_Dataset_GCSManagedConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_Dataset_GCSManagedConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig.class,
                com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig.Builder.class);
      }

      // Construct using com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getGcsPrefixFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        gcsPrefix_ = null;
        if (gcsPrefixBuilder_ != null) {
          gcsPrefixBuilder_.dispose();
          gcsPrefixBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_Dataset_GCSManagedConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig build() {
        com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig buildPartial() {
        com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig result =
            new com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.gcsPrefix_ = gcsPrefixBuilder_ == null ? gcsPrefix_ : gcsPrefixBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig) {
          return mergeFrom((com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig other) {
        if (other
            == com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig.getDefaultInstance())
          return this;
        if (other.hasGcsPrefix()) {
          mergeGcsPrefix(other.getGcsPrefix());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getGcsPrefixFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.documentai.v1beta3.GcsPrefix gcsPrefix_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.GcsPrefix,
              com.google.cloud.documentai.v1beta3.GcsPrefix.Builder,
              com.google.cloud.documentai.v1beta3.GcsPrefixOrBuilder>
          gcsPrefixBuilder_;
      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage URI (a directory) where the documents
       * belonging to the dataset must be stored.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.GcsPrefix gcs_prefix = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the gcsPrefix field is set.
       */
      public boolean hasGcsPrefix() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage URI (a directory) where the documents
       * belonging to the dataset must be stored.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.GcsPrefix gcs_prefix = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The gcsPrefix.
       */
      public com.google.cloud.documentai.v1beta3.GcsPrefix getGcsPrefix() {
        if (gcsPrefixBuilder_ == null) {
          return gcsPrefix_ == null
              ? com.google.cloud.documentai.v1beta3.GcsPrefix.getDefaultInstance()
              : gcsPrefix_;
        } else {
          return gcsPrefixBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage URI (a directory) where the documents
       * belonging to the dataset must be stored.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.GcsPrefix gcs_prefix = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setGcsPrefix(com.google.cloud.documentai.v1beta3.GcsPrefix value) {
        if (gcsPrefixBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          gcsPrefix_ = value;
        } else {
          gcsPrefixBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage URI (a directory) where the documents
       * belonging to the dataset must be stored.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.GcsPrefix gcs_prefix = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setGcsPrefix(
          com.google.cloud.documentai.v1beta3.GcsPrefix.Builder builderForValue) {
        if (gcsPrefixBuilder_ == null) {
          gcsPrefix_ = builderForValue.build();
        } else {
          gcsPrefixBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage URI (a directory) where the documents
       * belonging to the dataset must be stored.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.GcsPrefix gcs_prefix = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeGcsPrefix(com.google.cloud.documentai.v1beta3.GcsPrefix value) {
        if (gcsPrefixBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && gcsPrefix_ != null
              && gcsPrefix_ != com.google.cloud.documentai.v1beta3.GcsPrefix.getDefaultInstance()) {
            getGcsPrefixBuilder().mergeFrom(value);
          } else {
            gcsPrefix_ = value;
          }
        } else {
          gcsPrefixBuilder_.mergeFrom(value);
        }
        if (gcsPrefix_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage URI (a directory) where the documents
       * belonging to the dataset must be stored.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.GcsPrefix gcs_prefix = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearGcsPrefix() {
        bitField0_ = (bitField0_ & ~0x00000001);
        gcsPrefix_ = null;
        if (gcsPrefixBuilder_ != null) {
          gcsPrefixBuilder_.dispose();
          gcsPrefixBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage URI (a directory) where the documents
       * belonging to the dataset must be stored.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.GcsPrefix gcs_prefix = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.GcsPrefix.Builder getGcsPrefixBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getGcsPrefixFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage URI (a directory) where the documents
       * belonging to the dataset must be stored.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.GcsPrefix gcs_prefix = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.GcsPrefixOrBuilder getGcsPrefixOrBuilder() {
        if (gcsPrefixBuilder_ != null) {
          return gcsPrefixBuilder_.getMessageOrBuilder();
        } else {
          return gcsPrefix_ == null
              ? com.google.cloud.documentai.v1beta3.GcsPrefix.getDefaultInstance()
              : gcsPrefix_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage URI (a directory) where the documents
       * belonging to the dataset must be stored.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.GcsPrefix gcs_prefix = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.GcsPrefix,
              com.google.cloud.documentai.v1beta3.GcsPrefix.Builder,
              com.google.cloud.documentai.v1beta3.GcsPrefixOrBuilder>
          getGcsPrefixFieldBuilder() {
        if (gcsPrefixBuilder_ == null) {
          gcsPrefixBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.GcsPrefix,
                  com.google.cloud.documentai.v1beta3.GcsPrefix.Builder,
                  com.google.cloud.documentai.v1beta3.GcsPrefixOrBuilder>(
                  getGcsPrefix(), getParentForChildren(), isClean());
          gcsPrefix_ = null;
        }
        return gcsPrefixBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig)
    private static final com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig();
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GCSManagedConfig> PARSER =
        new com.google.protobuf.AbstractParser<GCSManagedConfig>() {
          @java.lang.Override
          public GCSManagedConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GCSManagedConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GCSManagedConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DocumentWarehouseConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The collection in Document AI Warehouse associated with the
     * dataset.
     * </pre>
     *
     * <code>string collection = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The collection.
     */
    java.lang.String getCollection();
    /**
     *
     *
     * <pre>
     * Output only. The collection in Document AI Warehouse associated with the
     * dataset.
     * </pre>
     *
     * <code>string collection = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for collection.
     */
    com.google.protobuf.ByteString getCollectionBytes();

    /**
     *
     *
     * <pre>
     * Output only. The schema in Document AI Warehouse associated with the
     * dataset.
     * </pre>
     *
     * <code>
     * string schema = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The schema.
     */
    java.lang.String getSchema();
    /**
     *
     *
     * <pre>
     * Output only. The schema in Document AI Warehouse associated with the
     * dataset.
     * </pre>
     *
     * <code>
     * string schema = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for schema.
     */
    com.google.protobuf.ByteString getSchemaBytes();
  }
  /**
   *
   *
   * <pre>
   * Configuration specific to the Document AI Warehouse-based implementation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig}
   */
  public static final class DocumentWarehouseConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig)
      DocumentWarehouseConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DocumentWarehouseConfig.newBuilder() to construct.
    private DocumentWarehouseConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DocumentWarehouseConfig() {
      collection_ = "";
      schema_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DocumentWarehouseConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_Dataset_DocumentWarehouseConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_Dataset_DocumentWarehouseConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig.class,
              com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig.Builder.class);
    }

    public static final int COLLECTION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object collection_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The collection in Document AI Warehouse associated with the
     * dataset.
     * </pre>
     *
     * <code>string collection = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The collection.
     */
    @java.lang.Override
    public java.lang.String getCollection() {
      java.lang.Object ref = collection_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        collection_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The collection in Document AI Warehouse associated with the
     * dataset.
     * </pre>
     *
     * <code>string collection = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for collection.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCollectionBytes() {
      java.lang.Object ref = collection_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        collection_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCHEMA_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object schema_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The schema in Document AI Warehouse associated with the
     * dataset.
     * </pre>
     *
     * <code>
     * string schema = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The schema.
     */
    @java.lang.Override
    public java.lang.String getSchema() {
      java.lang.Object ref = schema_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schema_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The schema in Document AI Warehouse associated with the
     * dataset.
     * </pre>
     *
     * <code>
     * string schema = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for schema.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSchemaBytes() {
      java.lang.Object ref = schema_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schema_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(collection_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, collection_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schema_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, schema_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(collection_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, collection_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schema_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, schema_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig other =
          (com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig) obj;

      if (!getCollection().equals(other.getCollection())) return false;
      if (!getSchema().equals(other.getSchema())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + COLLECTION_FIELD_NUMBER;
      hash = (53 * hash) + getCollection().hashCode();
      hash = (37 * hash) + SCHEMA_FIELD_NUMBER;
      hash = (53 * hash) + getSchema().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration specific to the Document AI Warehouse-based implementation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig)
        com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_Dataset_DocumentWarehouseConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_Dataset_DocumentWarehouseConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig.class,
                com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        collection_ = "";
        schema_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_Dataset_DocumentWarehouseConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig build() {
        com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig buildPartial() {
        com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig result =
            new com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.collection_ = collection_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.schema_ = schema_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig other) {
        if (other
            == com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig
                .getDefaultInstance()) return this;
        if (!other.getCollection().isEmpty()) {
          collection_ = other.collection_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getSchema().isEmpty()) {
          schema_ = other.schema_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  collection_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  schema_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object collection_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The collection in Document AI Warehouse associated with the
       * dataset.
       * </pre>
       *
       * <code>string collection = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The collection.
       */
      public java.lang.String getCollection() {
        java.lang.Object ref = collection_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          collection_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The collection in Document AI Warehouse associated with the
       * dataset.
       * </pre>
       *
       * <code>string collection = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for collection.
       */
      public com.google.protobuf.ByteString getCollectionBytes() {
        java.lang.Object ref = collection_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          collection_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The collection in Document AI Warehouse associated with the
       * dataset.
       * </pre>
       *
       * <code>string collection = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The collection to set.
       * @return This builder for chaining.
       */
      public Builder setCollection(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        collection_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The collection in Document AI Warehouse associated with the
       * dataset.
       * </pre>
       *
       * <code>string collection = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCollection() {
        collection_ = getDefaultInstance().getCollection();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The collection in Document AI Warehouse associated with the
       * dataset.
       * </pre>
       *
       * <code>string collection = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for collection to set.
       * @return This builder for chaining.
       */
      public Builder setCollectionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        collection_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object schema_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The schema in Document AI Warehouse associated with the
       * dataset.
       * </pre>
       *
       * <code>
       * string schema = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The schema.
       */
      public java.lang.String getSchema() {
        java.lang.Object ref = schema_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          schema_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The schema in Document AI Warehouse associated with the
       * dataset.
       * </pre>
       *
       * <code>
       * string schema = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for schema.
       */
      public com.google.protobuf.ByteString getSchemaBytes() {
        java.lang.Object ref = schema_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          schema_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The schema in Document AI Warehouse associated with the
       * dataset.
       * </pre>
       *
       * <code>
       * string schema = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The schema to set.
       * @return This builder for chaining.
       */
      public Builder setSchema(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        schema_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The schema in Document AI Warehouse associated with the
       * dataset.
       * </pre>
       *
       * <code>
       * string schema = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSchema() {
        schema_ = getDefaultInstance().getSchema();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The schema in Document AI Warehouse associated with the
       * dataset.
       * </pre>
       *
       * <code>
       * string schema = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for schema to set.
       * @return This builder for chaining.
       */
      public Builder setSchemaBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        schema_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig)
    private static final com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig();
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DocumentWarehouseConfig> PARSER =
        new com.google.protobuf.AbstractParser<DocumentWarehouseConfig>() {
          @java.lang.Override
          public DocumentWarehouseConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DocumentWarehouseConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DocumentWarehouseConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface UnmanagedDatasetConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Configuration specific to an unmanaged dataset.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig}
   */
  public static final class UnmanagedDatasetConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig)
      UnmanagedDatasetConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UnmanagedDatasetConfig.newBuilder() to construct.
    private UnmanagedDatasetConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UnmanagedDatasetConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UnmanagedDatasetConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_Dataset_UnmanagedDatasetConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_Dataset_UnmanagedDatasetConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig.class,
              com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig other =
          (com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration specific to an unmanaged dataset.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig)
        com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_Dataset_UnmanagedDatasetConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_Dataset_UnmanagedDatasetConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig.class,
                com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_Dataset_UnmanagedDatasetConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig build() {
        com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig buildPartial() {
        com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig result =
            new com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig other) {
        if (other
            == com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig
                .getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig)
    private static final com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig();
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UnmanagedDatasetConfig> PARSER =
        new com.google.protobuf.AbstractParser<UnmanagedDatasetConfig>() {
          @java.lang.Override
          public UnmanagedDatasetConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UnmanagedDatasetConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UnmanagedDatasetConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SpannerIndexingConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Configuration specific to spanner-based indexing.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig}
   */
  public static final class SpannerIndexingConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig)
      SpannerIndexingConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SpannerIndexingConfig.newBuilder() to construct.
    private SpannerIndexingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SpannerIndexingConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SpannerIndexingConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_Dataset_SpannerIndexingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_Dataset_SpannerIndexingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig.class,
              com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig other =
          (com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration specific to spanner-based indexing.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig)
        com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_Dataset_SpannerIndexingConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_Dataset_SpannerIndexingConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig.class,
                com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_Dataset_SpannerIndexingConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig build() {
        com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig buildPartial() {
        com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig result =
            new com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig other) {
        if (other
            == com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig
                .getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig)
    private static final com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig();
    }

    public static com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SpannerIndexingConfig> PARSER =
        new com.google.protobuf.AbstractParser<SpannerIndexingConfig>() {
          @java.lang.Override
          public SpannerIndexingConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SpannerIndexingConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SpannerIndexingConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int storageSourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object storageSource_;

  public enum StorageSourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_MANAGED_CONFIG(3),
    @java.lang.Deprecated
    DOCUMENT_WAREHOUSE_CONFIG(5),
    UNMANAGED_DATASET_CONFIG(6),
    STORAGESOURCE_NOT_SET(0);
    private final int value;

    private StorageSourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StorageSourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static StorageSourceCase forNumber(int value) {
      switch (value) {
        case 3:
          return GCS_MANAGED_CONFIG;
        case 5:
          return DOCUMENT_WAREHOUSE_CONFIG;
        case 6:
          return UNMANAGED_DATASET_CONFIG;
        case 0:
          return STORAGESOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public StorageSourceCase getStorageSourceCase() {
    return StorageSourceCase.forNumber(storageSourceCase_);
  }

  private int indexingSourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object indexingSource_;

  public enum IndexingSourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SPANNER_INDEXING_CONFIG(4),
    INDEXINGSOURCE_NOT_SET(0);
    private final int value;

    private IndexingSourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IndexingSourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static IndexingSourceCase forNumber(int value) {
      switch (value) {
        case 4:
          return SPANNER_INDEXING_CONFIG;
        case 0:
          return INDEXINGSOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public IndexingSourceCase getIndexingSourceCase() {
    return IndexingSourceCase.forNumber(indexingSourceCase_);
  }

  public static final int GCS_MANAGED_CONFIG_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Optional. User-managed Cloud Storage dataset configuration. Use this
   * configuration if the dataset documents are stored under a user-managed
   * Cloud Storage location.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig gcs_managed_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the gcsManagedConfig field is set.
   */
  @java.lang.Override
  public boolean hasGcsManagedConfig() {
    return storageSourceCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Optional. User-managed Cloud Storage dataset configuration. Use this
   * configuration if the dataset documents are stored under a user-managed
   * Cloud Storage location.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig gcs_managed_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The gcsManagedConfig.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig getGcsManagedConfig() {
    if (storageSourceCase_ == 3) {
      return (com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig) storageSource_;
    }
    return com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. User-managed Cloud Storage dataset configuration. Use this
   * configuration if the dataset documents are stored under a user-managed
   * Cloud Storage location.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig gcs_managed_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfigOrBuilder
      getGcsManagedConfigOrBuilder() {
    if (storageSourceCase_ == 3) {
      return (com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig) storageSource_;
    }
    return com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig.getDefaultInstance();
  }

  public static final int DOCUMENT_WAREHOUSE_CONFIG_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Optional. Deprecated. Warehouse-based dataset configuration is not
   * supported.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig document_warehouse_config = 5 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @deprecated google.cloud.documentai.v1beta3.Dataset.document_warehouse_config is deprecated.
   *     See google/cloud/documentai/v1beta3/dataset.proto;l=98
   * @return Whether the documentWarehouseConfig field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasDocumentWarehouseConfig() {
    return storageSourceCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Optional. Deprecated. Warehouse-based dataset configuration is not
   * supported.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig document_warehouse_config = 5 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @deprecated google.cloud.documentai.v1beta3.Dataset.document_warehouse_config is deprecated.
   *     See google/cloud/documentai/v1beta3/dataset.proto;l=98
   * @return The documentWarehouseConfig.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig
      getDocumentWarehouseConfig() {
    if (storageSourceCase_ == 5) {
      return (com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig) storageSource_;
    }
    return com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Deprecated. Warehouse-based dataset configuration is not
   * supported.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig document_warehouse_config = 5 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfigOrBuilder
      getDocumentWarehouseConfigOrBuilder() {
    if (storageSourceCase_ == 5) {
      return (com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig) storageSource_;
    }
    return com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig.getDefaultInstance();
  }

  public static final int UNMANAGED_DATASET_CONFIG_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Optional. Unmanaged dataset configuration. Use this configuration if the
   * dataset documents are managed by the document service internally (not
   * user-managed).
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig unmanaged_dataset_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the unmanagedDatasetConfig field is set.
   */
  @java.lang.Override
  public boolean hasUnmanagedDatasetConfig() {
    return storageSourceCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Optional. Unmanaged dataset configuration. Use this configuration if the
   * dataset documents are managed by the document service internally (not
   * user-managed).
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig unmanaged_dataset_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The unmanagedDatasetConfig.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig
      getUnmanagedDatasetConfig() {
    if (storageSourceCase_ == 6) {
      return (com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig) storageSource_;
    }
    return com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Unmanaged dataset configuration. Use this configuration if the
   * dataset documents are managed by the document service internally (not
   * user-managed).
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig unmanaged_dataset_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfigOrBuilder
      getUnmanagedDatasetConfigOrBuilder() {
    if (storageSourceCase_ == 6) {
      return (com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig) storageSource_;
    }
    return com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig.getDefaultInstance();
  }

  public static final int SPANNER_INDEXING_CONFIG_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Optional. A lightweight indexing source with low latency and high
   * reliability, but lacking advanced features like CMEK and content-based
   * search.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig spanner_indexing_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the spannerIndexingConfig field is set.
   */
  @java.lang.Override
  public boolean hasSpannerIndexingConfig() {
    return indexingSourceCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Optional. A lightweight indexing source with low latency and high
   * reliability, but lacking advanced features like CMEK and content-based
   * search.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig spanner_indexing_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The spannerIndexingConfig.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig
      getSpannerIndexingConfig() {
    if (indexingSourceCase_ == 4) {
      return (com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig) indexingSource_;
    }
    return com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. A lightweight indexing source with low latency and high
   * reliability, but lacking advanced features like CMEK and content-based
   * search.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig spanner_indexing_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfigOrBuilder
      getSpannerIndexingConfigOrBuilder() {
    if (indexingSourceCase_ == 4) {
      return (com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig) indexingSource_;
    }
    return com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Dataset resource name.
   * Format:
   * `projects/{project}/locations/{location}/processors/{processor}/dataset`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Dataset resource name.
   * Format:
   * `projects/{project}/locations/{location}/processors/{processor}/dataset`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 2;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Required. State of the dataset. Ignored when updating dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.Dataset.State state = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Required. State of the dataset. Ignored when updating dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.Dataset.State state = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Dataset.State getState() {
    com.google.cloud.documentai.v1beta3.Dataset.State result =
        com.google.cloud.documentai.v1beta3.Dataset.State.forNumber(state_);
    return result == null ? com.google.cloud.documentai.v1beta3.Dataset.State.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (state_ != com.google.cloud.documentai.v1beta3.Dataset.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, state_);
    }
    if (storageSourceCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig) storageSource_);
    }
    if (indexingSourceCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig) indexingSource_);
    }
    if (storageSourceCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig) storageSource_);
    }
    if (storageSourceCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig) storageSource_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (state_ != com.google.cloud.documentai.v1beta3.Dataset.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
    }
    if (storageSourceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig) storageSource_);
    }
    if (indexingSourceCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4,
              (com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig) indexingSource_);
    }
    if (storageSourceCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5,
              (com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig) storageSource_);
    }
    if (storageSourceCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6,
              (com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig) storageSource_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.Dataset)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.Dataset other =
        (com.google.cloud.documentai.v1beta3.Dataset) obj;

    if (!getName().equals(other.getName())) return false;
    if (state_ != other.state_) return false;
    if (!getStorageSourceCase().equals(other.getStorageSourceCase())) return false;
    switch (storageSourceCase_) {
      case 3:
        if (!getGcsManagedConfig().equals(other.getGcsManagedConfig())) return false;
        break;
      case 5:
        if (!getDocumentWarehouseConfig().equals(other.getDocumentWarehouseConfig())) return false;
        break;
      case 6:
        if (!getUnmanagedDatasetConfig().equals(other.getUnmanagedDatasetConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getIndexingSourceCase().equals(other.getIndexingSourceCase())) return false;
    switch (indexingSourceCase_) {
      case 4:
        if (!getSpannerIndexingConfig().equals(other.getSpannerIndexingConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    switch (storageSourceCase_) {
      case 3:
        hash = (37 * hash) + GCS_MANAGED_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getGcsManagedConfig().hashCode();
        break;
      case 5:
        hash = (37 * hash) + DOCUMENT_WAREHOUSE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getDocumentWarehouseConfig().hashCode();
        break;
      case 6:
        hash = (37 * hash) + UNMANAGED_DATASET_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getUnmanagedDatasetConfig().hashCode();
        break;
      case 0:
      default:
    }
    switch (indexingSourceCase_) {
      case 4:
        hash = (37 * hash) + SPANNER_INDEXING_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getSpannerIndexingConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.Dataset parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.Dataset parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.Dataset parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.Dataset parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.Dataset parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.Dataset parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.Dataset parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.Dataset parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.Dataset parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.Dataset parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.Dataset parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.Dataset parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.documentai.v1beta3.Dataset prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A singleton resource under a
   * [Processor][google.cloud.documentai.v1beta3.Processor] which configures a
   * collection of documents.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.Dataset}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Dataset)
      com.google.cloud.documentai.v1beta3.DatasetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_Dataset_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_Dataset_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.Dataset.class,
              com.google.cloud.documentai.v1beta3.Dataset.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.Dataset.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (gcsManagedConfigBuilder_ != null) {
        gcsManagedConfigBuilder_.clear();
      }
      if (documentWarehouseConfigBuilder_ != null) {
        documentWarehouseConfigBuilder_.clear();
      }
      if (unmanagedDatasetConfigBuilder_ != null) {
        unmanagedDatasetConfigBuilder_.clear();
      }
      if (spannerIndexingConfigBuilder_ != null) {
        spannerIndexingConfigBuilder_.clear();
      }
      name_ = "";
      state_ = 0;
      storageSourceCase_ = 0;
      storageSource_ = null;
      indexingSourceCase_ = 0;
      indexingSource_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_Dataset_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Dataset getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.Dataset.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Dataset build() {
      com.google.cloud.documentai.v1beta3.Dataset result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Dataset buildPartial() {
      com.google.cloud.documentai.v1beta3.Dataset result =
          new com.google.cloud.documentai.v1beta3.Dataset(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta3.Dataset result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.state_ = state_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.documentai.v1beta3.Dataset result) {
      result.storageSourceCase_ = storageSourceCase_;
      result.storageSource_ = this.storageSource_;
      if (storageSourceCase_ == 3 && gcsManagedConfigBuilder_ != null) {
        result.storageSource_ = gcsManagedConfigBuilder_.build();
      }
      if (storageSourceCase_ == 5 && documentWarehouseConfigBuilder_ != null) {
        result.storageSource_ = documentWarehouseConfigBuilder_.build();
      }
      if (storageSourceCase_ == 6 && unmanagedDatasetConfigBuilder_ != null) {
        result.storageSource_ = unmanagedDatasetConfigBuilder_.build();
      }
      result.indexingSourceCase_ = indexingSourceCase_;
      result.indexingSource_ = this.indexingSource_;
      if (indexingSourceCase_ == 4 && spannerIndexingConfigBuilder_ != null) {
        result.indexingSource_ = spannerIndexingConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.Dataset) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.Dataset) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.Dataset other) {
      if (other == com.google.cloud.documentai.v1beta3.Dataset.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      switch (other.getStorageSourceCase()) {
        case GCS_MANAGED_CONFIG:
          {
            mergeGcsManagedConfig(other.getGcsManagedConfig());
            break;
          }
        case DOCUMENT_WAREHOUSE_CONFIG:
          {
            mergeDocumentWarehouseConfig(other.getDocumentWarehouseConfig());
            break;
          }
        case UNMANAGED_DATASET_CONFIG:
          {
            mergeUnmanagedDatasetConfig(other.getUnmanagedDatasetConfig());
            break;
          }
        case STORAGESOURCE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getIndexingSourceCase()) {
        case SPANNER_INDEXING_CONFIG:
          {
            mergeSpannerIndexingConfig(other.getSpannerIndexingConfig());
            break;
          }
        case INDEXINGSOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 10
            case 16:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(
                    getGcsManagedConfigFieldBuilder().getBuilder(), extensionRegistry);
                storageSourceCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getSpannerIndexingConfigFieldBuilder().getBuilder(), extensionRegistry);
                indexingSourceCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getDocumentWarehouseConfigFieldBuilder().getBuilder(), extensionRegistry);
                storageSourceCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getUnmanagedDatasetConfigFieldBuilder().getBuilder(), extensionRegistry);
                storageSourceCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int storageSourceCase_ = 0;
    private java.lang.Object storageSource_;

    public StorageSourceCase getStorageSourceCase() {
      return StorageSourceCase.forNumber(storageSourceCase_);
    }

    public Builder clearStorageSource() {
      storageSourceCase_ = 0;
      storageSource_ = null;
      onChanged();
      return this;
    }

    private int indexingSourceCase_ = 0;
    private java.lang.Object indexingSource_;

    public IndexingSourceCase getIndexingSourceCase() {
      return IndexingSourceCase.forNumber(indexingSourceCase_);
    }

    public Builder clearIndexingSource() {
      indexingSourceCase_ = 0;
      indexingSource_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig,
            com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig.Builder,
            com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfigOrBuilder>
        gcsManagedConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. User-managed Cloud Storage dataset configuration. Use this
     * configuration if the dataset documents are stored under a user-managed
     * Cloud Storage location.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig gcs_managed_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the gcsManagedConfig field is set.
     */
    @java.lang.Override
    public boolean hasGcsManagedConfig() {
      return storageSourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-managed Cloud Storage dataset configuration. Use this
     * configuration if the dataset documents are stored under a user-managed
     * Cloud Storage location.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig gcs_managed_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The gcsManagedConfig.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig getGcsManagedConfig() {
      if (gcsManagedConfigBuilder_ == null) {
        if (storageSourceCase_ == 3) {
          return (com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig) storageSource_;
        }
        return com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig.getDefaultInstance();
      } else {
        if (storageSourceCase_ == 3) {
          return gcsManagedConfigBuilder_.getMessage();
        }
        return com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-managed Cloud Storage dataset configuration. Use this
     * configuration if the dataset documents are stored under a user-managed
     * Cloud Storage location.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig gcs_managed_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGcsManagedConfig(
        com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig value) {
      if (gcsManagedConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        storageSource_ = value;
        onChanged();
      } else {
        gcsManagedConfigBuilder_.setMessage(value);
      }
      storageSourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-managed Cloud Storage dataset configuration. Use this
     * configuration if the dataset documents are stored under a user-managed
     * Cloud Storage location.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig gcs_managed_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGcsManagedConfig(
        com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig.Builder builderForValue) {
      if (gcsManagedConfigBuilder_ == null) {
        storageSource_ = builderForValue.build();
        onChanged();
      } else {
        gcsManagedConfigBuilder_.setMessage(builderForValue.build());
      }
      storageSourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-managed Cloud Storage dataset configuration. Use this
     * configuration if the dataset documents are stored under a user-managed
     * Cloud Storage location.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig gcs_managed_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGcsManagedConfig(
        com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig value) {
      if (gcsManagedConfigBuilder_ == null) {
        if (storageSourceCase_ == 3
            && storageSource_
                != com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig
                    .getDefaultInstance()) {
          storageSource_ =
              com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig.newBuilder(
                      (com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig) storageSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          storageSource_ = value;
        }
        onChanged();
      } else {
        if (storageSourceCase_ == 3) {
          gcsManagedConfigBuilder_.mergeFrom(value);
        } else {
          gcsManagedConfigBuilder_.setMessage(value);
        }
      }
      storageSourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-managed Cloud Storage dataset configuration. Use this
     * configuration if the dataset documents are stored under a user-managed
     * Cloud Storage location.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig gcs_managed_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGcsManagedConfig() {
      if (gcsManagedConfigBuilder_ == null) {
        if (storageSourceCase_ == 3) {
          storageSourceCase_ = 0;
          storageSource_ = null;
          onChanged();
        }
      } else {
        if (storageSourceCase_ == 3) {
          storageSourceCase_ = 0;
          storageSource_ = null;
        }
        gcsManagedConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-managed Cloud Storage dataset configuration. Use this
     * configuration if the dataset documents are stored under a user-managed
     * Cloud Storage location.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig gcs_managed_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig.Builder
        getGcsManagedConfigBuilder() {
      return getGcsManagedConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. User-managed Cloud Storage dataset configuration. Use this
     * configuration if the dataset documents are stored under a user-managed
     * Cloud Storage location.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig gcs_managed_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfigOrBuilder
        getGcsManagedConfigOrBuilder() {
      if ((storageSourceCase_ == 3) && (gcsManagedConfigBuilder_ != null)) {
        return gcsManagedConfigBuilder_.getMessageOrBuilder();
      } else {
        if (storageSourceCase_ == 3) {
          return (com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig) storageSource_;
        }
        return com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-managed Cloud Storage dataset configuration. Use this
     * configuration if the dataset documents are stored under a user-managed
     * Cloud Storage location.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig gcs_managed_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig,
            com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig.Builder,
            com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfigOrBuilder>
        getGcsManagedConfigFieldBuilder() {
      if (gcsManagedConfigBuilder_ == null) {
        if (!(storageSourceCase_ == 3)) {
          storageSource_ =
              com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig.getDefaultInstance();
        }
        gcsManagedConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig,
                com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig.Builder,
                com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfigOrBuilder>(
                (com.google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig) storageSource_,
                getParentForChildren(),
                isClean());
        storageSource_ = null;
      }
      storageSourceCase_ = 3;
      onChanged();
      return gcsManagedConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig,
            com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig.Builder,
            com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfigOrBuilder>
        documentWarehouseConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Deprecated. Warehouse-based dataset configuration is not
     * supported.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig document_warehouse_config = 5 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.documentai.v1beta3.Dataset.document_warehouse_config is deprecated.
     *     See google/cloud/documentai/v1beta3/dataset.proto;l=98
     * @return Whether the documentWarehouseConfig field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean hasDocumentWarehouseConfig() {
      return storageSourceCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deprecated. Warehouse-based dataset configuration is not
     * supported.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig document_warehouse_config = 5 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.documentai.v1beta3.Dataset.document_warehouse_config is deprecated.
     *     See google/cloud/documentai/v1beta3/dataset.proto;l=98
     * @return The documentWarehouseConfig.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig
        getDocumentWarehouseConfig() {
      if (documentWarehouseConfigBuilder_ == null) {
        if (storageSourceCase_ == 5) {
          return (com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig)
              storageSource_;
        }
        return com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig
            .getDefaultInstance();
      } else {
        if (storageSourceCase_ == 5) {
          return documentWarehouseConfigBuilder_.getMessage();
        }
        return com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Deprecated. Warehouse-based dataset configuration is not
     * supported.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig document_warehouse_config = 5 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setDocumentWarehouseConfig(
        com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig value) {
      if (documentWarehouseConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        storageSource_ = value;
        onChanged();
      } else {
        documentWarehouseConfigBuilder_.setMessage(value);
      }
      storageSourceCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deprecated. Warehouse-based dataset configuration is not
     * supported.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig document_warehouse_config = 5 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setDocumentWarehouseConfig(
        com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig.Builder
            builderForValue) {
      if (documentWarehouseConfigBuilder_ == null) {
        storageSource_ = builderForValue.build();
        onChanged();
      } else {
        documentWarehouseConfigBuilder_.setMessage(builderForValue.build());
      }
      storageSourceCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deprecated. Warehouse-based dataset configuration is not
     * supported.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig document_warehouse_config = 5 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Deprecated
    public Builder mergeDocumentWarehouseConfig(
        com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig value) {
      if (documentWarehouseConfigBuilder_ == null) {
        if (storageSourceCase_ == 5
            && storageSource_
                != com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig
                    .getDefaultInstance()) {
          storageSource_ =
              com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig.newBuilder(
                      (com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig)
                          storageSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          storageSource_ = value;
        }
        onChanged();
      } else {
        if (storageSourceCase_ == 5) {
          documentWarehouseConfigBuilder_.mergeFrom(value);
        } else {
          documentWarehouseConfigBuilder_.setMessage(value);
        }
      }
      storageSourceCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deprecated. Warehouse-based dataset configuration is not
     * supported.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig document_warehouse_config = 5 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearDocumentWarehouseConfig() {
      if (documentWarehouseConfigBuilder_ == null) {
        if (storageSourceCase_ == 5) {
          storageSourceCase_ = 0;
          storageSource_ = null;
          onChanged();
        }
      } else {
        if (storageSourceCase_ == 5) {
          storageSourceCase_ = 0;
          storageSource_ = null;
        }
        documentWarehouseConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Deprecated. Warehouse-based dataset configuration is not
     * supported.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig document_warehouse_config = 5 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig.Builder
        getDocumentWarehouseConfigBuilder() {
      return getDocumentWarehouseConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Deprecated. Warehouse-based dataset configuration is not
     * supported.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig document_warehouse_config = 5 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfigOrBuilder
        getDocumentWarehouseConfigOrBuilder() {
      if ((storageSourceCase_ == 5) && (documentWarehouseConfigBuilder_ != null)) {
        return documentWarehouseConfigBuilder_.getMessageOrBuilder();
      } else {
        if (storageSourceCase_ == 5) {
          return (com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig)
              storageSource_;
        }
        return com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Deprecated. Warehouse-based dataset configuration is not
     * supported.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig document_warehouse_config = 5 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig,
            com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig.Builder,
            com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfigOrBuilder>
        getDocumentWarehouseConfigFieldBuilder() {
      if (documentWarehouseConfigBuilder_ == null) {
        if (!(storageSourceCase_ == 5)) {
          storageSource_ =
              com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig
                  .getDefaultInstance();
        }
        documentWarehouseConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig,
                com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig.Builder,
                com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfigOrBuilder>(
                (com.google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig)
                    storageSource_,
                getParentForChildren(),
                isClean());
        storageSource_ = null;
      }
      storageSourceCase_ = 5;
      onChanged();
      return documentWarehouseConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig,
            com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig.Builder,
            com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfigOrBuilder>
        unmanagedDatasetConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Unmanaged dataset configuration. Use this configuration if the
     * dataset documents are managed by the document service internally (not
     * user-managed).
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig unmanaged_dataset_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the unmanagedDatasetConfig field is set.
     */
    @java.lang.Override
    public boolean hasUnmanagedDatasetConfig() {
      return storageSourceCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Optional. Unmanaged dataset configuration. Use this configuration if the
     * dataset documents are managed by the document service internally (not
     * user-managed).
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig unmanaged_dataset_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The unmanagedDatasetConfig.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig
        getUnmanagedDatasetConfig() {
      if (unmanagedDatasetConfigBuilder_ == null) {
        if (storageSourceCase_ == 6) {
          return (com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig)
              storageSource_;
        }
        return com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig
            .getDefaultInstance();
      } else {
        if (storageSourceCase_ == 6) {
          return unmanagedDatasetConfigBuilder_.getMessage();
        }
        return com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Unmanaged dataset configuration. Use this configuration if the
     * dataset documents are managed by the document service internally (not
     * user-managed).
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig unmanaged_dataset_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setUnmanagedDatasetConfig(
        com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig value) {
      if (unmanagedDatasetConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        storageSource_ = value;
        onChanged();
      } else {
        unmanagedDatasetConfigBuilder_.setMessage(value);
      }
      storageSourceCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Unmanaged dataset configuration. Use this configuration if the
     * dataset documents are managed by the document service internally (not
     * user-managed).
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig unmanaged_dataset_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setUnmanagedDatasetConfig(
        com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig.Builder
            builderForValue) {
      if (unmanagedDatasetConfigBuilder_ == null) {
        storageSource_ = builderForValue.build();
        onChanged();
      } else {
        unmanagedDatasetConfigBuilder_.setMessage(builderForValue.build());
      }
      storageSourceCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Unmanaged dataset configuration. Use this configuration if the
     * dataset documents are managed by the document service internally (not
     * user-managed).
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig unmanaged_dataset_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeUnmanagedDatasetConfig(
        com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig value) {
      if (unmanagedDatasetConfigBuilder_ == null) {
        if (storageSourceCase_ == 6
            && storageSource_
                != com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig
                    .getDefaultInstance()) {
          storageSource_ =
              com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig.newBuilder(
                      (com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig)
                          storageSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          storageSource_ = value;
        }
        onChanged();
      } else {
        if (storageSourceCase_ == 6) {
          unmanagedDatasetConfigBuilder_.mergeFrom(value);
        } else {
          unmanagedDatasetConfigBuilder_.setMessage(value);
        }
      }
      storageSourceCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Unmanaged dataset configuration. Use this configuration if the
     * dataset documents are managed by the document service internally (not
     * user-managed).
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig unmanaged_dataset_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearUnmanagedDatasetConfig() {
      if (unmanagedDatasetConfigBuilder_ == null) {
        if (storageSourceCase_ == 6) {
          storageSourceCase_ = 0;
          storageSource_ = null;
          onChanged();
        }
      } else {
        if (storageSourceCase_ == 6) {
          storageSourceCase_ = 0;
          storageSource_ = null;
        }
        unmanagedDatasetConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Unmanaged dataset configuration. Use this configuration if the
     * dataset documents are managed by the document service internally (not
     * user-managed).
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig unmanaged_dataset_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig.Builder
        getUnmanagedDatasetConfigBuilder() {
      return getUnmanagedDatasetConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Unmanaged dataset configuration. Use this configuration if the
     * dataset documents are managed by the document service internally (not
     * user-managed).
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig unmanaged_dataset_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfigOrBuilder
        getUnmanagedDatasetConfigOrBuilder() {
      if ((storageSourceCase_ == 6) && (unmanagedDatasetConfigBuilder_ != null)) {
        return unmanagedDatasetConfigBuilder_.getMessageOrBuilder();
      } else {
        if (storageSourceCase_ == 6) {
          return (com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig)
              storageSource_;
        }
        return com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Unmanaged dataset configuration. Use this configuration if the
     * dataset documents are managed by the document service internally (not
     * user-managed).
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig unmanaged_dataset_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig,
            com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig.Builder,
            com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfigOrBuilder>
        getUnmanagedDatasetConfigFieldBuilder() {
      if (unmanagedDatasetConfigBuilder_ == null) {
        if (!(storageSourceCase_ == 6)) {
          storageSource_ =
              com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig
                  .getDefaultInstance();
        }
        unmanagedDatasetConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig,
                com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig.Builder,
                com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfigOrBuilder>(
                (com.google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig) storageSource_,
                getParentForChildren(),
                isClean());
        storageSource_ = null;
      }
      storageSourceCase_ = 6;
      onChanged();
      return unmanagedDatasetConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig,
            com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig.Builder,
            com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfigOrBuilder>
        spannerIndexingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. A lightweight indexing source with low latency and high
     * reliability, but lacking advanced features like CMEK and content-based
     * search.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig spanner_indexing_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the spannerIndexingConfig field is set.
     */
    @java.lang.Override
    public boolean hasSpannerIndexingConfig() {
      return indexingSourceCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Optional. A lightweight indexing source with low latency and high
     * reliability, but lacking advanced features like CMEK and content-based
     * search.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig spanner_indexing_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The spannerIndexingConfig.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig
        getSpannerIndexingConfig() {
      if (spannerIndexingConfigBuilder_ == null) {
        if (indexingSourceCase_ == 4) {
          return (com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig)
              indexingSource_;
        }
        return com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig
            .getDefaultInstance();
      } else {
        if (indexingSourceCase_ == 4) {
          return spannerIndexingConfigBuilder_.getMessage();
        }
        return com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A lightweight indexing source with low latency and high
     * reliability, but lacking advanced features like CMEK and content-based
     * search.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig spanner_indexing_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSpannerIndexingConfig(
        com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig value) {
      if (spannerIndexingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        indexingSource_ = value;
        onChanged();
      } else {
        spannerIndexingConfigBuilder_.setMessage(value);
      }
      indexingSourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A lightweight indexing source with low latency and high
     * reliability, but lacking advanced features like CMEK and content-based
     * search.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig spanner_indexing_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSpannerIndexingConfig(
        com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig.Builder builderForValue) {
      if (spannerIndexingConfigBuilder_ == null) {
        indexingSource_ = builderForValue.build();
        onChanged();
      } else {
        spannerIndexingConfigBuilder_.setMessage(builderForValue.build());
      }
      indexingSourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A lightweight indexing source with low latency and high
     * reliability, but lacking advanced features like CMEK and content-based
     * search.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig spanner_indexing_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSpannerIndexingConfig(
        com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig value) {
      if (spannerIndexingConfigBuilder_ == null) {
        if (indexingSourceCase_ == 4
            && indexingSource_
                != com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig
                    .getDefaultInstance()) {
          indexingSource_ =
              com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig.newBuilder(
                      (com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig)
                          indexingSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          indexingSource_ = value;
        }
        onChanged();
      } else {
        if (indexingSourceCase_ == 4) {
          spannerIndexingConfigBuilder_.mergeFrom(value);
        } else {
          spannerIndexingConfigBuilder_.setMessage(value);
        }
      }
      indexingSourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A lightweight indexing source with low latency and high
     * reliability, but lacking advanced features like CMEK and content-based
     * search.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig spanner_indexing_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSpannerIndexingConfig() {
      if (spannerIndexingConfigBuilder_ == null) {
        if (indexingSourceCase_ == 4) {
          indexingSourceCase_ = 0;
          indexingSource_ = null;
          onChanged();
        }
      } else {
        if (indexingSourceCase_ == 4) {
          indexingSourceCase_ = 0;
          indexingSource_ = null;
        }
        spannerIndexingConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A lightweight indexing source with low latency and high
     * reliability, but lacking advanced features like CMEK and content-based
     * search.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig spanner_indexing_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig.Builder
        getSpannerIndexingConfigBuilder() {
      return getSpannerIndexingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. A lightweight indexing source with low latency and high
     * reliability, but lacking advanced features like CMEK and content-based
     * search.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig spanner_indexing_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfigOrBuilder
        getSpannerIndexingConfigOrBuilder() {
      if ((indexingSourceCase_ == 4) && (spannerIndexingConfigBuilder_ != null)) {
        return spannerIndexingConfigBuilder_.getMessageOrBuilder();
      } else {
        if (indexingSourceCase_ == 4) {
          return (com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig)
              indexingSource_;
        }
        return com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A lightweight indexing source with low latency and high
     * reliability, but lacking advanced features like CMEK and content-based
     * search.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig spanner_indexing_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig,
            com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig.Builder,
            com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfigOrBuilder>
        getSpannerIndexingConfigFieldBuilder() {
      if (spannerIndexingConfigBuilder_ == null) {
        if (!(indexingSourceCase_ == 4)) {
          indexingSource_ =
              com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig
                  .getDefaultInstance();
        }
        spannerIndexingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig,
                com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig.Builder,
                com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfigOrBuilder>(
                (com.google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig) indexingSource_,
                getParentForChildren(),
                isClean());
        indexingSource_ = null;
      }
      indexingSourceCase_ = 4;
      onChanged();
      return spannerIndexingConfigBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Dataset resource name.
     * Format:
     * `projects/{project}/locations/{location}/processors/{processor}/dataset`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Dataset resource name.
     * Format:
     * `projects/{project}/locations/{location}/processors/{processor}/dataset`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Dataset resource name.
     * Format:
     * `projects/{project}/locations/{location}/processors/{processor}/dataset`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Dataset resource name.
     * Format:
     * `projects/{project}/locations/{location}/processors/{processor}/dataset`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Dataset resource name.
     * Format:
     * `projects/{project}/locations/{location}/processors/{processor}/dataset`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Required. State of the dataset. Ignored when updating dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.State state = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Required. State of the dataset. Ignored when updating dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.State state = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. State of the dataset. Ignored when updating dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.State state = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Dataset.State getState() {
      com.google.cloud.documentai.v1beta3.Dataset.State result =
          com.google.cloud.documentai.v1beta3.Dataset.State.forNumber(state_);
      return result == null
          ? com.google.cloud.documentai.v1beta3.Dataset.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. State of the dataset. Ignored when updating dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.State state = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.documentai.v1beta3.Dataset.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. State of the dataset. Ignored when updating dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Dataset.State state = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      state_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Dataset)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Dataset)
  private static final com.google.cloud.documentai.v1beta3.Dataset DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Dataset();
  }

  public static com.google.cloud.documentai.v1beta3.Dataset getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Dataset> PARSER =
      new com.google.protobuf.AbstractParser<Dataset>() {
        @java.lang.Override
        public Dataset parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Dataset> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Dataset> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Dataset getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
