/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document_schema.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * The schema defines the output of the processed document by a processor.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.DocumentSchema}
 */
public final class DocumentSchema extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.DocumentSchema)
    DocumentSchemaOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DocumentSchema.newBuilder() to construct.
  private DocumentSchema(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DocumentSchema() {
    displayName_ = "";
    description_ = "";
    entityTypes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DocumentSchema();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
        .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
        .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.DocumentSchema.class,
            com.google.cloud.documentai.v1beta3.DocumentSchema.Builder.class);
  }

  public interface EntityTypeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.DocumentSchema.EntityType)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If specified, lists all the possible values for this entity.  This
     * should not be more than a handful of values.  If the number of values
     * is &gt;10 or could change frequently use the `EntityType.value_ontology`
     * field and specify a list of all possible values in a value ontology
     * file.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues enum_values = 14;
     * </code>
     *
     * @return Whether the enumValues field is set.
     */
    boolean hasEnumValues();
    /**
     *
     *
     * <pre>
     * If specified, lists all the possible values for this entity.  This
     * should not be more than a handful of values.  If the number of values
     * is &gt;10 or could change frequently use the `EntityType.value_ontology`
     * field and specify a list of all possible values in a value ontology
     * file.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues enum_values = 14;
     * </code>
     *
     * @return The enumValues.
     */
    com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues getEnumValues();
    /**
     *
     *
     * <pre>
     * If specified, lists all the possible values for this entity.  This
     * should not be more than a handful of values.  If the number of values
     * is &gt;10 or could change frequently use the `EntityType.value_ontology`
     * field and specify a list of all possible values in a value ontology
     * file.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues enum_values = 14;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValuesOrBuilder
        getEnumValuesOrBuilder();

    /**
     *
     *
     * <pre>
     * User defined name for the type.
     * </pre>
     *
     * <code>string display_name = 13;</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();
    /**
     *
     *
     * <pre>
     * User defined name for the type.
     * </pre>
     *
     * <code>string display_name = 13;</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * Name of the type. It must be unique within the schema file and
     * cannot be a "Common Type".  The following naming conventions are used:
     *
     * - Use `snake_casing`.
     * - Name matching is case-sensitive.
     * - Maximum 64 characters.
     * - Must start with a letter.
     * - Allowed characters: ASCII letters `[a-z0-9_-]`.  (For backward
     *   compatibility internal infrastructure and tooling can handle any ascii
     *   character.)
     * - The `/` is sometimes used to denote a property of a type.  For example
     *   `line_item/amount`.  This convention is deprecated, but will still be
     *   honored for backward compatibility.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Name of the type. It must be unique within the schema file and
     * cannot be a "Common Type".  The following naming conventions are used:
     *
     * - Use `snake_casing`.
     * - Name matching is case-sensitive.
     * - Maximum 64 characters.
     * - Must start with a letter.
     * - Allowed characters: ASCII letters `[a-z0-9_-]`.  (For backward
     *   compatibility internal infrastructure and tooling can handle any ascii
     *   character.)
     * - The `/` is sometimes used to denote a property of a type.  For example
     *   `line_item/amount`.  This convention is deprecated, but will still be
     *   honored for backward compatibility.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * The entity type that this type is derived from.  For now, one and only
     * one should be set.
     * </pre>
     *
     * <code>repeated string base_types = 2;</code>
     *
     * @return A list containing the baseTypes.
     */
    java.util.List<java.lang.String> getBaseTypesList();
    /**
     *
     *
     * <pre>
     * The entity type that this type is derived from.  For now, one and only
     * one should be set.
     * </pre>
     *
     * <code>repeated string base_types = 2;</code>
     *
     * @return The count of baseTypes.
     */
    int getBaseTypesCount();
    /**
     *
     *
     * <pre>
     * The entity type that this type is derived from.  For now, one and only
     * one should be set.
     * </pre>
     *
     * <code>repeated string base_types = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The baseTypes at the given index.
     */
    java.lang.String getBaseTypes(int index);
    /**
     *
     *
     * <pre>
     * The entity type that this type is derived from.  For now, one and only
     * one should be set.
     * </pre>
     *
     * <code>repeated string base_types = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the baseTypes at the given index.
     */
    com.google.protobuf.ByteString getBaseTypesBytes(int index);

    /**
     *
     *
     * <pre>
     * Description the nested structure, or composition of an entity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
     * </code>
     */
    java.util.List<com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property>
        getPropertiesList();
    /**
     *
     *
     * <pre>
     * Description the nested structure, or composition of an entity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property getProperties(int index);
    /**
     *
     *
     * <pre>
     * Description the nested structure, or composition of an entity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
     * </code>
     */
    int getPropertiesCount();
    /**
     *
     *
     * <pre>
     * Description the nested structure, or composition of an entity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.PropertyOrBuilder>
        getPropertiesOrBuilderList();
    /**
     *
     *
     * <pre>
     * Description the nested structure, or composition of an entity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.PropertyOrBuilder
        getPropertiesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Metadata for the entity type.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.EntityTypeMetadata entity_type_metadata = 11;</code>
     *
     * @return Whether the entityTypeMetadata field is set.
     */
    boolean hasEntityTypeMetadata();
    /**
     *
     *
     * <pre>
     * Metadata for the entity type.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.EntityTypeMetadata entity_type_metadata = 11;</code>
     *
     * @return The entityTypeMetadata.
     */
    com.google.cloud.documentai.v1beta3.EntityTypeMetadata getEntityTypeMetadata();
    /**
     *
     *
     * <pre>
     * Metadata for the entity type.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.EntityTypeMetadata entity_type_metadata = 11;</code>
     */
    com.google.cloud.documentai.v1beta3.EntityTypeMetadataOrBuilder
        getEntityTypeMetadataOrBuilder();

    com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.ValueSourceCase
        getValueSourceCase();
  }
  /**
   *
   *
   * <pre>
   * EntityType is the wrapper of a label of the corresponding model with
   * detailed attributes and limitations for entity-based processors. Multiple
   * types can also compose a dependency tree to represent nested types.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.DocumentSchema.EntityType}
   */
  public static final class EntityType extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.DocumentSchema.EntityType)
      EntityTypeOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use EntityType.newBuilder() to construct.
    private EntityType(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private EntityType() {
      displayName_ = "";
      name_ = "";
      baseTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      properties_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new EntityType();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
          .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_EntityType_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
          .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_EntityType_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.class,
              com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Builder.class);
    }

    public interface EnumValuesOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The individual values that this enum values type can include.
       * </pre>
       *
       * <code>repeated string values = 1;</code>
       *
       * @return A list containing the values.
       */
      java.util.List<java.lang.String> getValuesList();
      /**
       *
       *
       * <pre>
       * The individual values that this enum values type can include.
       * </pre>
       *
       * <code>repeated string values = 1;</code>
       *
       * @return The count of values.
       */
      int getValuesCount();
      /**
       *
       *
       * <pre>
       * The individual values that this enum values type can include.
       * </pre>
       *
       * <code>repeated string values = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The values at the given index.
       */
      java.lang.String getValues(int index);
      /**
       *
       *
       * <pre>
       * The individual values that this enum values type can include.
       * </pre>
       *
       * <code>repeated string values = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the values at the given index.
       */
      com.google.protobuf.ByteString getValuesBytes(int index);
    }
    /**
     *
     *
     * <pre>
     * Defines the a list of enum values.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues}
     */
    public static final class EnumValues extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues)
        EnumValuesOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use EnumValues.newBuilder() to construct.
      private EnumValues(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private EnumValues() {
        values_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new EnumValues();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
            .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_EntityType_EnumValues_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
            .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_EntityType_EnumValues_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues.class,
                com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues.Builder
                    .class);
      }

      public static final int VALUES_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList values_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * The individual values that this enum values type can include.
       * </pre>
       *
       * <code>repeated string values = 1;</code>
       *
       * @return A list containing the values.
       */
      public com.google.protobuf.ProtocolStringList getValuesList() {
        return values_;
      }
      /**
       *
       *
       * <pre>
       * The individual values that this enum values type can include.
       * </pre>
       *
       * <code>repeated string values = 1;</code>
       *
       * @return The count of values.
       */
      public int getValuesCount() {
        return values_.size();
      }
      /**
       *
       *
       * <pre>
       * The individual values that this enum values type can include.
       * </pre>
       *
       * <code>repeated string values = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The values at the given index.
       */
      public java.lang.String getValues(int index) {
        return values_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The individual values that this enum values type can include.
       * </pre>
       *
       * <code>repeated string values = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the values at the given index.
       */
      public com.google.protobuf.ByteString getValuesBytes(int index) {
        return values_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < values_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, values_.getRaw(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < values_.size(); i++) {
            dataSize += computeStringSizeNoTag(values_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getValuesList().size();
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues other =
            (com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues) obj;

        if (!getValuesList().equals(other.getValuesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getValuesCount() > 0) {
          hash = (37 * hash) + VALUES_FIELD_NUMBER;
          hash = (53 * hash) + getValuesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Defines the a list of enum values.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues)
          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValuesOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
              .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_EntityType_EnumValues_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
              .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_EntityType_EnumValues_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues.class,
                  com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          values_ = com.google.protobuf.LazyStringArrayList.emptyList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
              .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_EntityType_EnumValues_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
            getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues build() {
          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
            buildPartial() {
          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues result =
              new com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            values_.makeImmutable();
            result.values_ = values_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues) {
            return mergeFrom(
                (com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues other) {
          if (other
              == com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
                  .getDefaultInstance()) return this;
          if (!other.values_.isEmpty()) {
            if (values_.isEmpty()) {
              values_ = other.values_;
              bitField0_ |= 0x00000001;
            } else {
              ensureValuesIsMutable();
              values_.addAll(other.values_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureValuesIsMutable();
                    values_.add(s);
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringArrayList values_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureValuesIsMutable() {
          if (!values_.isModifiable()) {
            values_ = new com.google.protobuf.LazyStringArrayList(values_);
          }
          bitField0_ |= 0x00000001;
        }
        /**
         *
         *
         * <pre>
         * The individual values that this enum values type can include.
         * </pre>
         *
         * <code>repeated string values = 1;</code>
         *
         * @return A list containing the values.
         */
        public com.google.protobuf.ProtocolStringList getValuesList() {
          values_.makeImmutable();
          return values_;
        }
        /**
         *
         *
         * <pre>
         * The individual values that this enum values type can include.
         * </pre>
         *
         * <code>repeated string values = 1;</code>
         *
         * @return The count of values.
         */
        public int getValuesCount() {
          return values_.size();
        }
        /**
         *
         *
         * <pre>
         * The individual values that this enum values type can include.
         * </pre>
         *
         * <code>repeated string values = 1;</code>
         *
         * @param index The index of the element to return.
         * @return The values at the given index.
         */
        public java.lang.String getValues(int index) {
          return values_.get(index);
        }
        /**
         *
         *
         * <pre>
         * The individual values that this enum values type can include.
         * </pre>
         *
         * <code>repeated string values = 1;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the values at the given index.
         */
        public com.google.protobuf.ByteString getValuesBytes(int index) {
          return values_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * The individual values that this enum values type can include.
         * </pre>
         *
         * <code>repeated string values = 1;</code>
         *
         * @param index The index to set the value at.
         * @param value The values to set.
         * @return This builder for chaining.
         */
        public Builder setValues(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.set(index, value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The individual values that this enum values type can include.
         * </pre>
         *
         * <code>repeated string values = 1;</code>
         *
         * @param value The values to add.
         * @return This builder for chaining.
         */
        public Builder addValues(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The individual values that this enum values type can include.
         * </pre>
         *
         * <code>repeated string values = 1;</code>
         *
         * @param values The values to add.
         * @return This builder for chaining.
         */
        public Builder addAllValues(java.lang.Iterable<java.lang.String> values) {
          ensureValuesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The individual values that this enum values type can include.
         * </pre>
         *
         * <code>repeated string values = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearValues() {
          values_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The individual values that this enum values type can include.
         * </pre>
         *
         * <code>repeated string values = 1;</code>
         *
         * @param value The bytes of the values to add.
         * @return This builder for chaining.
         */
        public Builder addValuesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureValuesIsMutable();
          values_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues)
      private static final com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues();
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<EnumValues> PARSER =
          new com.google.protobuf.AbstractParser<EnumValues>() {
            @java.lang.Override
            public EnumValues parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<EnumValues> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<EnumValues> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface PropertyOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The name of the property.  Follows the same guidelines as the
       * EntityType name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      java.lang.String getName();
      /**
       *
       *
       * <pre>
       * The name of the property.  Follows the same guidelines as the
       * EntityType name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      com.google.protobuf.ByteString getNameBytes();

      /**
       *
       *
       * <pre>
       * User defined name for the property.
       * </pre>
       *
       * <code>string display_name = 6;</code>
       *
       * @return The displayName.
       */
      java.lang.String getDisplayName();
      /**
       *
       *
       * <pre>
       * User defined name for the property.
       * </pre>
       *
       * <code>string display_name = 6;</code>
       *
       * @return The bytes for displayName.
       */
      com.google.protobuf.ByteString getDisplayNameBytes();

      /**
       *
       *
       * <pre>
       * A reference to the value type of the property.  This type is subject
       * to the same conventions as the `Entity.base_types` field.
       * </pre>
       *
       * <code>string value_type = 2;</code>
       *
       * @return The valueType.
       */
      java.lang.String getValueType();
      /**
       *
       *
       * <pre>
       * A reference to the value type of the property.  This type is subject
       * to the same conventions as the `Entity.base_types` field.
       * </pre>
       *
       * <code>string value_type = 2;</code>
       *
       * @return The bytes for valueType.
       */
      com.google.protobuf.ByteString getValueTypeBytes();

      /**
       *
       *
       * <pre>
       * Occurrence type limits the number of instances an entity type appears
       * in the document.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.OccurrenceType occurrence_type = 3;
       * </code>
       *
       * @return The enum numeric value on the wire for occurrenceType.
       */
      int getOccurrenceTypeValue();
      /**
       *
       *
       * <pre>
       * Occurrence type limits the number of instances an entity type appears
       * in the document.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.OccurrenceType occurrence_type = 3;
       * </code>
       *
       * @return The occurrenceType.
       */
      com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.OccurrenceType
          getOccurrenceType();

      /**
       *
       *
       * <pre>
       * Any additional metadata about the property can be added here.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.PropertyMetadata property_metadata = 5;</code>
       *
       * @return Whether the propertyMetadata field is set.
       */
      boolean hasPropertyMetadata();
      /**
       *
       *
       * <pre>
       * Any additional metadata about the property can be added here.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.PropertyMetadata property_metadata = 5;</code>
       *
       * @return The propertyMetadata.
       */
      com.google.cloud.documentai.v1beta3.PropertyMetadata getPropertyMetadata();
      /**
       *
       *
       * <pre>
       * Any additional metadata about the property can be added here.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.PropertyMetadata property_metadata = 5;</code>
       */
      com.google.cloud.documentai.v1beta3.PropertyMetadataOrBuilder getPropertyMetadataOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * Defines properties that can be part of the entity type.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property}
     */
    public static final class Property extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property)
        PropertyOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Property.newBuilder() to construct.
      private Property(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Property() {
        name_ = "";
        displayName_ = "";
        valueType_ = "";
        occurrenceType_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Property();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
            .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_EntityType_Property_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
            .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_EntityType_Property_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.class,
                com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.Builder
                    .class);
      }

      /**
       *
       *
       * <pre>
       * Types of occurrences of the entity type in the document.  This
       * represents the number of instances, not mentions, of an entity.
       * For example, a bank statement might only have one
       * `account_number`, but this account number can be mentioned in several
       * places on the document.  In this case, the `account_number` is
       * considered a `REQUIRED_ONCE` entity type. If, on the other hand, we
       * expect a bank statement to contain the status of multiple different
       * accounts for the customers, the occurrence type is set to
       * `REQUIRED_MULTIPLE`.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.OccurrenceType}
       */
      public enum OccurrenceType implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Unspecified occurrence type.
         * </pre>
         *
         * <code>OCCURRENCE_TYPE_UNSPECIFIED = 0;</code>
         */
        OCCURRENCE_TYPE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * There will be zero or one instance of this entity type.  The same
         * entity instance may be mentioned multiple times.
         * </pre>
         *
         * <code>OPTIONAL_ONCE = 1;</code>
         */
        OPTIONAL_ONCE(1),
        /**
         *
         *
         * <pre>
         * The entity type will appear zero or multiple times.
         * </pre>
         *
         * <code>OPTIONAL_MULTIPLE = 2;</code>
         */
        OPTIONAL_MULTIPLE(2),
        /**
         *
         *
         * <pre>
         * The entity type will only appear exactly once.  The same
         * entity instance may be mentioned multiple times.
         * </pre>
         *
         * <code>REQUIRED_ONCE = 3;</code>
         */
        REQUIRED_ONCE(3),
        /**
         *
         *
         * <pre>
         * The entity type will appear once or more times.
         * </pre>
         *
         * <code>REQUIRED_MULTIPLE = 4;</code>
         */
        REQUIRED_MULTIPLE(4),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Unspecified occurrence type.
         * </pre>
         *
         * <code>OCCURRENCE_TYPE_UNSPECIFIED = 0;</code>
         */
        public static final int OCCURRENCE_TYPE_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * There will be zero or one instance of this entity type.  The same
         * entity instance may be mentioned multiple times.
         * </pre>
         *
         * <code>OPTIONAL_ONCE = 1;</code>
         */
        public static final int OPTIONAL_ONCE_VALUE = 1;
        /**
         *
         *
         * <pre>
         * The entity type will appear zero or multiple times.
         * </pre>
         *
         * <code>OPTIONAL_MULTIPLE = 2;</code>
         */
        public static final int OPTIONAL_MULTIPLE_VALUE = 2;
        /**
         *
         *
         * <pre>
         * The entity type will only appear exactly once.  The same
         * entity instance may be mentioned multiple times.
         * </pre>
         *
         * <code>REQUIRED_ONCE = 3;</code>
         */
        public static final int REQUIRED_ONCE_VALUE = 3;
        /**
         *
         *
         * <pre>
         * The entity type will appear once or more times.
         * </pre>
         *
         * <code>REQUIRED_MULTIPLE = 4;</code>
         */
        public static final int REQUIRED_MULTIPLE_VALUE = 4;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static OccurrenceType valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static OccurrenceType forNumber(int value) {
          switch (value) {
            case 0:
              return OCCURRENCE_TYPE_UNSPECIFIED;
            case 1:
              return OPTIONAL_ONCE;
            case 2:
              return OPTIONAL_MULTIPLE;
            case 3:
              return REQUIRED_ONCE;
            case 4:
              return REQUIRED_MULTIPLE;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<OccurrenceType>
            internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<OccurrenceType>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<OccurrenceType>() {
                  public OccurrenceType findValueByNumber(int number) {
                    return OccurrenceType.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
              .getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final OccurrenceType[] VALUES = values();

        public static OccurrenceType valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private OccurrenceType(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.OccurrenceType)
      }

      private int bitField0_;
      public static final int NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * The name of the property.  Follows the same guidelines as the
       * EntityType name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      @java.lang.Override
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the property.  Follows the same guidelines as the
       * EntityType name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DISPLAY_NAME_FIELD_NUMBER = 6;

      @SuppressWarnings("serial")
      private volatile java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * User defined name for the property.
       * </pre>
       *
       * <code>string display_name = 6;</code>
       *
       * @return The displayName.
       */
      @java.lang.Override
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * User defined name for the property.
       * </pre>
       *
       * <code>string display_name = 6;</code>
       *
       * @return The bytes for displayName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int VALUE_TYPE_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object valueType_ = "";
      /**
       *
       *
       * <pre>
       * A reference to the value type of the property.  This type is subject
       * to the same conventions as the `Entity.base_types` field.
       * </pre>
       *
       * <code>string value_type = 2;</code>
       *
       * @return The valueType.
       */
      @java.lang.Override
      public java.lang.String getValueType() {
        java.lang.Object ref = valueType_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          valueType_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * A reference to the value type of the property.  This type is subject
       * to the same conventions as the `Entity.base_types` field.
       * </pre>
       *
       * <code>string value_type = 2;</code>
       *
       * @return The bytes for valueType.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getValueTypeBytes() {
        java.lang.Object ref = valueType_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          valueType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int OCCURRENCE_TYPE_FIELD_NUMBER = 3;
      private int occurrenceType_ = 0;
      /**
       *
       *
       * <pre>
       * Occurrence type limits the number of instances an entity type appears
       * in the document.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.OccurrenceType occurrence_type = 3;
       * </code>
       *
       * @return The enum numeric value on the wire for occurrenceType.
       */
      @java.lang.Override
      public int getOccurrenceTypeValue() {
        return occurrenceType_;
      }
      /**
       *
       *
       * <pre>
       * Occurrence type limits the number of instances an entity type appears
       * in the document.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.OccurrenceType occurrence_type = 3;
       * </code>
       *
       * @return The occurrenceType.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.OccurrenceType
          getOccurrenceType() {
        com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.OccurrenceType
            result =
                com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
                    .OccurrenceType.forNumber(occurrenceType_);
        return result == null
            ? com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.OccurrenceType
                .UNRECOGNIZED
            : result;
      }

      public static final int PROPERTY_METADATA_FIELD_NUMBER = 5;
      private com.google.cloud.documentai.v1beta3.PropertyMetadata propertyMetadata_;
      /**
       *
       *
       * <pre>
       * Any additional metadata about the property can be added here.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.PropertyMetadata property_metadata = 5;</code>
       *
       * @return Whether the propertyMetadata field is set.
       */
      @java.lang.Override
      public boolean hasPropertyMetadata() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Any additional metadata about the property can be added here.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.PropertyMetadata property_metadata = 5;</code>
       *
       * @return The propertyMetadata.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.PropertyMetadata getPropertyMetadata() {
        return propertyMetadata_ == null
            ? com.google.cloud.documentai.v1beta3.PropertyMetadata.getDefaultInstance()
            : propertyMetadata_;
      }
      /**
       *
       *
       * <pre>
       * Any additional metadata about the property can be added here.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.PropertyMetadata property_metadata = 5;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.PropertyMetadataOrBuilder
          getPropertyMetadataOrBuilder() {
        return propertyMetadata_ == null
            ? com.google.cloud.documentai.v1beta3.PropertyMetadata.getDefaultInstance()
            : propertyMetadata_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(valueType_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, valueType_);
        }
        if (occurrenceType_
            != com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.OccurrenceType
                .OCCURRENCE_TYPE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(3, occurrenceType_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(5, getPropertyMetadata());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 6, displayName_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(valueType_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, valueType_);
        }
        if (occurrenceType_
            != com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.OccurrenceType
                .OCCURRENCE_TYPE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, occurrenceType_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(5, getPropertyMetadata());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, displayName_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property other =
            (com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property) obj;

        if (!getName().equals(other.getName())) return false;
        if (!getDisplayName().equals(other.getDisplayName())) return false;
        if (!getValueType().equals(other.getValueType())) return false;
        if (occurrenceType_ != other.occurrenceType_) return false;
        if (hasPropertyMetadata() != other.hasPropertyMetadata()) return false;
        if (hasPropertyMetadata()) {
          if (!getPropertyMetadata().equals(other.getPropertyMetadata())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
        hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getDisplayName().hashCode();
        hash = (37 * hash) + VALUE_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getValueType().hashCode();
        hash = (37 * hash) + OCCURRENCE_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + occurrenceType_;
        if (hasPropertyMetadata()) {
          hash = (37 * hash) + PROPERTY_METADATA_FIELD_NUMBER;
          hash = (53 * hash) + getPropertyMetadata().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Defines properties that can be part of the entity type.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property)
          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.PropertyOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
              .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_EntityType_Property_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
              .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_EntityType_Property_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.class,
                  com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getPropertyMetadataFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          name_ = "";
          displayName_ = "";
          valueType_ = "";
          occurrenceType_ = 0;
          propertyMetadata_ = null;
          if (propertyMetadataBuilder_ != null) {
            propertyMetadataBuilder_.dispose();
            propertyMetadataBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
              .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_EntityType_Property_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
            getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property build() {
          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
            buildPartial() {
          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property result =
              new com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.name_ = name_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.displayName_ = displayName_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.valueType_ = valueType_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.occurrenceType_ = occurrenceType_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.propertyMetadata_ =
                propertyMetadataBuilder_ == null
                    ? propertyMetadata_
                    : propertyMetadataBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property) {
            return mergeFrom(
                (com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property other) {
          if (other
              == com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
                  .getDefaultInstance()) return this;
          if (!other.getName().isEmpty()) {
            name_ = other.name_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getDisplayName().isEmpty()) {
            displayName_ = other.displayName_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (!other.getValueType().isEmpty()) {
            valueType_ = other.valueType_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          if (other.occurrenceType_ != 0) {
            setOccurrenceTypeValue(other.getOccurrenceTypeValue());
          }
          if (other.hasPropertyMetadata()) {
            mergePropertyMetadata(other.getPropertyMetadata());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    name_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    valueType_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 18
                case 24:
                  {
                    occurrenceType_ = input.readEnum();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 24
                case 42:
                  {
                    input.readMessage(
                        getPropertyMetadataFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 42
                case 50:
                  {
                    displayName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 50
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object name_ = "";
        /**
         *
         *
         * <pre>
         * The name of the property.  Follows the same guidelines as the
         * EntityType name.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The name.
         */
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the property.  Follows the same guidelines as the
         * EntityType name.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The bytes for name.
         */
        public com.google.protobuf.ByteString getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the property.  Follows the same guidelines as the
         * EntityType name.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The name to set.
         * @return This builder for chaining.
         */
        public Builder setName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          name_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the property.  Follows the same guidelines as the
         * EntityType name.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearName() {
          name_ = getDefaultInstance().getName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the property.  Follows the same guidelines as the
         * EntityType name.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The bytes for name to set.
         * @return This builder for chaining.
         */
        public Builder setNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          name_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object displayName_ = "";
        /**
         *
         *
         * <pre>
         * User defined name for the property.
         * </pre>
         *
         * <code>string display_name = 6;</code>
         *
         * @return The displayName.
         */
        public java.lang.String getDisplayName() {
          java.lang.Object ref = displayName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            displayName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * User defined name for the property.
         * </pre>
         *
         * <code>string display_name = 6;</code>
         *
         * @return The bytes for displayName.
         */
        public com.google.protobuf.ByteString getDisplayNameBytes() {
          java.lang.Object ref = displayName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            displayName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * User defined name for the property.
         * </pre>
         *
         * <code>string display_name = 6;</code>
         *
         * @param value The displayName to set.
         * @return This builder for chaining.
         */
        public Builder setDisplayName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          displayName_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * User defined name for the property.
         * </pre>
         *
         * <code>string display_name = 6;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDisplayName() {
          displayName_ = getDefaultInstance().getDisplayName();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * User defined name for the property.
         * </pre>
         *
         * <code>string display_name = 6;</code>
         *
         * @param value The bytes for displayName to set.
         * @return This builder for chaining.
         */
        public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          displayName_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private java.lang.Object valueType_ = "";
        /**
         *
         *
         * <pre>
         * A reference to the value type of the property.  This type is subject
         * to the same conventions as the `Entity.base_types` field.
         * </pre>
         *
         * <code>string value_type = 2;</code>
         *
         * @return The valueType.
         */
        public java.lang.String getValueType() {
          java.lang.Object ref = valueType_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            valueType_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * A reference to the value type of the property.  This type is subject
         * to the same conventions as the `Entity.base_types` field.
         * </pre>
         *
         * <code>string value_type = 2;</code>
         *
         * @return The bytes for valueType.
         */
        public com.google.protobuf.ByteString getValueTypeBytes() {
          java.lang.Object ref = valueType_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            valueType_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * A reference to the value type of the property.  This type is subject
         * to the same conventions as the `Entity.base_types` field.
         * </pre>
         *
         * <code>string value_type = 2;</code>
         *
         * @param value The valueType to set.
         * @return This builder for chaining.
         */
        public Builder setValueType(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          valueType_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A reference to the value type of the property.  This type is subject
         * to the same conventions as the `Entity.base_types` field.
         * </pre>
         *
         * <code>string value_type = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearValueType() {
          valueType_ = getDefaultInstance().getValueType();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A reference to the value type of the property.  This type is subject
         * to the same conventions as the `Entity.base_types` field.
         * </pre>
         *
         * <code>string value_type = 2;</code>
         *
         * @param value The bytes for valueType to set.
         * @return This builder for chaining.
         */
        public Builder setValueTypeBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          valueType_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private int occurrenceType_ = 0;
        /**
         *
         *
         * <pre>
         * Occurrence type limits the number of instances an entity type appears
         * in the document.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.OccurrenceType occurrence_type = 3;
         * </code>
         *
         * @return The enum numeric value on the wire for occurrenceType.
         */
        @java.lang.Override
        public int getOccurrenceTypeValue() {
          return occurrenceType_;
        }
        /**
         *
         *
         * <pre>
         * Occurrence type limits the number of instances an entity type appears
         * in the document.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.OccurrenceType occurrence_type = 3;
         * </code>
         *
         * @param value The enum numeric value on the wire for occurrenceType to set.
         * @return This builder for chaining.
         */
        public Builder setOccurrenceTypeValue(int value) {
          occurrenceType_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Occurrence type limits the number of instances an entity type appears
         * in the document.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.OccurrenceType occurrence_type = 3;
         * </code>
         *
         * @return The occurrenceType.
         */
        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.OccurrenceType
            getOccurrenceType() {
          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.OccurrenceType
              result =
                  com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
                      .OccurrenceType.forNumber(occurrenceType_);
          return result == null
              ? com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
                  .OccurrenceType.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Occurrence type limits the number of instances an entity type appears
         * in the document.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.OccurrenceType occurrence_type = 3;
         * </code>
         *
         * @param value The occurrenceType to set.
         * @return This builder for chaining.
         */
        public Builder setOccurrenceType(
            com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.OccurrenceType
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000008;
          occurrenceType_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Occurrence type limits the number of instances an entity type appears
         * in the document.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.OccurrenceType occurrence_type = 3;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearOccurrenceType() {
          bitField0_ = (bitField0_ & ~0x00000008);
          occurrenceType_ = 0;
          onChanged();
          return this;
        }

        private com.google.cloud.documentai.v1beta3.PropertyMetadata propertyMetadata_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.PropertyMetadata,
                com.google.cloud.documentai.v1beta3.PropertyMetadata.Builder,
                com.google.cloud.documentai.v1beta3.PropertyMetadataOrBuilder>
            propertyMetadataBuilder_;
        /**
         *
         *
         * <pre>
         * Any additional metadata about the property can be added here.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.PropertyMetadata property_metadata = 5;</code>
         *
         * @return Whether the propertyMetadata field is set.
         */
        public boolean hasPropertyMetadata() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         *
         *
         * <pre>
         * Any additional metadata about the property can be added here.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.PropertyMetadata property_metadata = 5;</code>
         *
         * @return The propertyMetadata.
         */
        public com.google.cloud.documentai.v1beta3.PropertyMetadata getPropertyMetadata() {
          if (propertyMetadataBuilder_ == null) {
            return propertyMetadata_ == null
                ? com.google.cloud.documentai.v1beta3.PropertyMetadata.getDefaultInstance()
                : propertyMetadata_;
          } else {
            return propertyMetadataBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Any additional metadata about the property can be added here.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.PropertyMetadata property_metadata = 5;</code>
         */
        public Builder setPropertyMetadata(
            com.google.cloud.documentai.v1beta3.PropertyMetadata value) {
          if (propertyMetadataBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            propertyMetadata_ = value;
          } else {
            propertyMetadataBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Any additional metadata about the property can be added here.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.PropertyMetadata property_metadata = 5;</code>
         */
        public Builder setPropertyMetadata(
            com.google.cloud.documentai.v1beta3.PropertyMetadata.Builder builderForValue) {
          if (propertyMetadataBuilder_ == null) {
            propertyMetadata_ = builderForValue.build();
          } else {
            propertyMetadataBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Any additional metadata about the property can be added here.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.PropertyMetadata property_metadata = 5;</code>
         */
        public Builder mergePropertyMetadata(
            com.google.cloud.documentai.v1beta3.PropertyMetadata value) {
          if (propertyMetadataBuilder_ == null) {
            if (((bitField0_ & 0x00000010) != 0)
                && propertyMetadata_ != null
                && propertyMetadata_
                    != com.google.cloud.documentai.v1beta3.PropertyMetadata.getDefaultInstance()) {
              getPropertyMetadataBuilder().mergeFrom(value);
            } else {
              propertyMetadata_ = value;
            }
          } else {
            propertyMetadataBuilder_.mergeFrom(value);
          }
          if (propertyMetadata_ != null) {
            bitField0_ |= 0x00000010;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Any additional metadata about the property can be added here.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.PropertyMetadata property_metadata = 5;</code>
         */
        public Builder clearPropertyMetadata() {
          bitField0_ = (bitField0_ & ~0x00000010);
          propertyMetadata_ = null;
          if (propertyMetadataBuilder_ != null) {
            propertyMetadataBuilder_.dispose();
            propertyMetadataBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Any additional metadata about the property can be added here.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.PropertyMetadata property_metadata = 5;</code>
         */
        public com.google.cloud.documentai.v1beta3.PropertyMetadata.Builder
            getPropertyMetadataBuilder() {
          bitField0_ |= 0x00000010;
          onChanged();
          return getPropertyMetadataFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Any additional metadata about the property can be added here.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.PropertyMetadata property_metadata = 5;</code>
         */
        public com.google.cloud.documentai.v1beta3.PropertyMetadataOrBuilder
            getPropertyMetadataOrBuilder() {
          if (propertyMetadataBuilder_ != null) {
            return propertyMetadataBuilder_.getMessageOrBuilder();
          } else {
            return propertyMetadata_ == null
                ? com.google.cloud.documentai.v1beta3.PropertyMetadata.getDefaultInstance()
                : propertyMetadata_;
          }
        }
        /**
         *
         *
         * <pre>
         * Any additional metadata about the property can be added here.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.PropertyMetadata property_metadata = 5;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.PropertyMetadata,
                com.google.cloud.documentai.v1beta3.PropertyMetadata.Builder,
                com.google.cloud.documentai.v1beta3.PropertyMetadataOrBuilder>
            getPropertyMetadataFieldBuilder() {
          if (propertyMetadataBuilder_ == null) {
            propertyMetadataBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.PropertyMetadata,
                    com.google.cloud.documentai.v1beta3.PropertyMetadata.Builder,
                    com.google.cloud.documentai.v1beta3.PropertyMetadataOrBuilder>(
                    getPropertyMetadata(), getParentForChildren(), isClean());
            propertyMetadata_ = null;
          }
          return propertyMetadataBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property)
      private static final com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property();
      }

      public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Property> PARSER =
          new com.google.protobuf.AbstractParser<Property>() {
            @java.lang.Override
            public Property parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Property> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Property> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    private int valueSourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object valueSource_;

    public enum ValueSourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      ENUM_VALUES(14),
      VALUESOURCE_NOT_SET(0);
      private final int value;

      private ValueSourceCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ValueSourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static ValueSourceCase forNumber(int value) {
        switch (value) {
          case 14:
            return ENUM_VALUES;
          case 0:
            return VALUESOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ValueSourceCase getValueSourceCase() {
      return ValueSourceCase.forNumber(valueSourceCase_);
    }

    public static final int ENUM_VALUES_FIELD_NUMBER = 14;
    /**
     *
     *
     * <pre>
     * If specified, lists all the possible values for this entity.  This
     * should not be more than a handful of values.  If the number of values
     * is &gt;10 or could change frequently use the `EntityType.value_ontology`
     * field and specify a list of all possible values in a value ontology
     * file.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues enum_values = 14;
     * </code>
     *
     * @return Whether the enumValues field is set.
     */
    @java.lang.Override
    public boolean hasEnumValues() {
      return valueSourceCase_ == 14;
    }
    /**
     *
     *
     * <pre>
     * If specified, lists all the possible values for this entity.  This
     * should not be more than a handful of values.  If the number of values
     * is &gt;10 or could change frequently use the `EntityType.value_ontology`
     * field and specify a list of all possible values in a value ontology
     * file.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues enum_values = 14;
     * </code>
     *
     * @return The enumValues.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
        getEnumValues() {
      if (valueSourceCase_ == 14) {
        return (com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues)
            valueSource_;
      }
      return com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * If specified, lists all the possible values for this entity.  This
     * should not be more than a handful of values.  If the number of values
     * is &gt;10 or could change frequently use the `EntityType.value_ontology`
     * field and specify a list of all possible values in a value ontology
     * file.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues enum_values = 14;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValuesOrBuilder
        getEnumValuesOrBuilder() {
      if (valueSourceCase_ == 14) {
        return (com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues)
            valueSource_;
      }
      return com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
          .getDefaultInstance();
    }

    public static final int DISPLAY_NAME_FIELD_NUMBER = 13;

    @SuppressWarnings("serial")
    private volatile java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * User defined name for the type.
     * </pre>
     *
     * <code>string display_name = 13;</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * User defined name for the type.
     * </pre>
     *
     * <code>string display_name = 13;</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the type. It must be unique within the schema file and
     * cannot be a "Common Type".  The following naming conventions are used:
     *
     * - Use `snake_casing`.
     * - Name matching is case-sensitive.
     * - Maximum 64 characters.
     * - Must start with a letter.
     * - Allowed characters: ASCII letters `[a-z0-9_-]`.  (For backward
     *   compatibility internal infrastructure and tooling can handle any ascii
     *   character.)
     * - The `/` is sometimes used to denote a property of a type.  For example
     *   `line_item/amount`.  This convention is deprecated, but will still be
     *   honored for backward compatibility.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the type. It must be unique within the schema file and
     * cannot be a "Common Type".  The following naming conventions are used:
     *
     * - Use `snake_casing`.
     * - Name matching is case-sensitive.
     * - Maximum 64 characters.
     * - Must start with a letter.
     * - Allowed characters: ASCII letters `[a-z0-9_-]`.  (For backward
     *   compatibility internal infrastructure and tooling can handle any ascii
     *   character.)
     * - The `/` is sometimes used to denote a property of a type.  For example
     *   `line_item/amount`.  This convention is deprecated, but will still be
     *   honored for backward compatibility.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int BASE_TYPES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList baseTypes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * The entity type that this type is derived from.  For now, one and only
     * one should be set.
     * </pre>
     *
     * <code>repeated string base_types = 2;</code>
     *
     * @return A list containing the baseTypes.
     */
    public com.google.protobuf.ProtocolStringList getBaseTypesList() {
      return baseTypes_;
    }
    /**
     *
     *
     * <pre>
     * The entity type that this type is derived from.  For now, one and only
     * one should be set.
     * </pre>
     *
     * <code>repeated string base_types = 2;</code>
     *
     * @return The count of baseTypes.
     */
    public int getBaseTypesCount() {
      return baseTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * The entity type that this type is derived from.  For now, one and only
     * one should be set.
     * </pre>
     *
     * <code>repeated string base_types = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The baseTypes at the given index.
     */
    public java.lang.String getBaseTypes(int index) {
      return baseTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The entity type that this type is derived from.  For now, one and only
     * one should be set.
     * </pre>
     *
     * <code>repeated string base_types = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the baseTypes at the given index.
     */
    public com.google.protobuf.ByteString getBaseTypesBytes(int index) {
      return baseTypes_.getByteString(index);
    }

    public static final int PROPERTIES_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property>
        properties_;
    /**
     *
     *
     * <pre>
     * Description the nested structure, or composition of an entity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property>
        getPropertiesList() {
      return properties_;
    }
    /**
     *
     *
     * <pre>
     * Description the nested structure, or composition of an entity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.PropertyOrBuilder>
        getPropertiesOrBuilderList() {
      return properties_;
    }
    /**
     *
     *
     * <pre>
     * Description the nested structure, or composition of an entity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
     * </code>
     */
    @java.lang.Override
    public int getPropertiesCount() {
      return properties_.size();
    }
    /**
     *
     *
     * <pre>
     * Description the nested structure, or composition of an entity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property getProperties(
        int index) {
      return properties_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Description the nested structure, or composition of an entity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.PropertyOrBuilder
        getPropertiesOrBuilder(int index) {
      return properties_.get(index);
    }

    public static final int ENTITY_TYPE_METADATA_FIELD_NUMBER = 11;
    private com.google.cloud.documentai.v1beta3.EntityTypeMetadata entityTypeMetadata_;
    /**
     *
     *
     * <pre>
     * Metadata for the entity type.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.EntityTypeMetadata entity_type_metadata = 11;</code>
     *
     * @return Whether the entityTypeMetadata field is set.
     */
    @java.lang.Override
    public boolean hasEntityTypeMetadata() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Metadata for the entity type.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.EntityTypeMetadata entity_type_metadata = 11;</code>
     *
     * @return The entityTypeMetadata.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.EntityTypeMetadata getEntityTypeMetadata() {
      return entityTypeMetadata_ == null
          ? com.google.cloud.documentai.v1beta3.EntityTypeMetadata.getDefaultInstance()
          : entityTypeMetadata_;
    }
    /**
     *
     *
     * <pre>
     * Metadata for the entity type.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.EntityTypeMetadata entity_type_metadata = 11;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.EntityTypeMetadataOrBuilder
        getEntityTypeMetadataOrBuilder() {
      return entityTypeMetadata_ == null
          ? com.google.cloud.documentai.v1beta3.EntityTypeMetadata.getDefaultInstance()
          : entityTypeMetadata_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      for (int i = 0; i < baseTypes_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, baseTypes_.getRaw(i));
      }
      for (int i = 0; i < properties_.size(); i++) {
        output.writeMessage(6, properties_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(11, getEntityTypeMetadata());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 13, displayName_);
      }
      if (valueSourceCase_ == 14) {
        output.writeMessage(
            14,
            (com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues)
                valueSource_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < baseTypes_.size(); i++) {
          dataSize += computeStringSizeNoTag(baseTypes_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getBaseTypesList().size();
      }
      for (int i = 0; i < properties_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, properties_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(11, getEntityTypeMetadata());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, displayName_);
      }
      if (valueSourceCase_ == 14) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                14,
                (com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues)
                    valueSource_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType other =
          (com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType) obj;

      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (!getName().equals(other.getName())) return false;
      if (!getBaseTypesList().equals(other.getBaseTypesList())) return false;
      if (!getPropertiesList().equals(other.getPropertiesList())) return false;
      if (hasEntityTypeMetadata() != other.hasEntityTypeMetadata()) return false;
      if (hasEntityTypeMetadata()) {
        if (!getEntityTypeMetadata().equals(other.getEntityTypeMetadata())) return false;
      }
      if (!getValueSourceCase().equals(other.getValueSourceCase())) return false;
      switch (valueSourceCase_) {
        case 14:
          if (!getEnumValues().equals(other.getEnumValues())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      if (getBaseTypesCount() > 0) {
        hash = (37 * hash) + BASE_TYPES_FIELD_NUMBER;
        hash = (53 * hash) + getBaseTypesList().hashCode();
      }
      if (getPropertiesCount() > 0) {
        hash = (37 * hash) + PROPERTIES_FIELD_NUMBER;
        hash = (53 * hash) + getPropertiesList().hashCode();
      }
      if (hasEntityTypeMetadata()) {
        hash = (37 * hash) + ENTITY_TYPE_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getEntityTypeMetadata().hashCode();
      }
      switch (valueSourceCase_) {
        case 14:
          hash = (37 * hash) + ENUM_VALUES_FIELD_NUMBER;
          hash = (53 * hash) + getEnumValues().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * EntityType is the wrapper of a label of the corresponding model with
     * detailed attributes and limitations for entity-based processors. Multiple
     * types can also compose a dependency tree to represent nested types.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.DocumentSchema.EntityType}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.DocumentSchema.EntityType)
        com.google.cloud.documentai.v1beta3.DocumentSchema.EntityTypeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
            .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_EntityType_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
            .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_EntityType_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.class,
                com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Builder.class);
      }

      // Construct using com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getPropertiesFieldBuilder();
          getEntityTypeMetadataFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (enumValuesBuilder_ != null) {
          enumValuesBuilder_.clear();
        }
        displayName_ = "";
        name_ = "";
        baseTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        if (propertiesBuilder_ == null) {
          properties_ = java.util.Collections.emptyList();
        } else {
          properties_ = null;
          propertiesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        entityTypeMetadata_ = null;
        if (entityTypeMetadataBuilder_ != null) {
          entityTypeMetadataBuilder_.dispose();
          entityTypeMetadataBuilder_ = null;
        }
        valueSourceCase_ = 0;
        valueSource_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
            .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_EntityType_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType build() {
        com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType buildPartial() {
        com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType result =
            new com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType result) {
        if (propertiesBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)) {
            properties_ = java.util.Collections.unmodifiableList(properties_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.properties_ = properties_;
        } else {
          result.properties_ = propertiesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.displayName_ = displayName_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          baseTypes_.makeImmutable();
          result.baseTypes_ = baseTypes_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.entityTypeMetadata_ =
              entityTypeMetadataBuilder_ == null
                  ? entityTypeMetadata_
                  : entityTypeMetadataBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType result) {
        result.valueSourceCase_ = valueSourceCase_;
        result.valueSource_ = this.valueSource_;
        if (valueSourceCase_ == 14 && enumValuesBuilder_ != null) {
          result.valueSource_ = enumValuesBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType) {
          return mergeFrom((com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType other) {
        if (other
            == com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.getDefaultInstance())
          return this;
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.baseTypes_.isEmpty()) {
          if (baseTypes_.isEmpty()) {
            baseTypes_ = other.baseTypes_;
            bitField0_ |= 0x00000008;
          } else {
            ensureBaseTypesIsMutable();
            baseTypes_.addAll(other.baseTypes_);
          }
          onChanged();
        }
        if (propertiesBuilder_ == null) {
          if (!other.properties_.isEmpty()) {
            if (properties_.isEmpty()) {
              properties_ = other.properties_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensurePropertiesIsMutable();
              properties_.addAll(other.properties_);
            }
            onChanged();
          }
        } else {
          if (!other.properties_.isEmpty()) {
            if (propertiesBuilder_.isEmpty()) {
              propertiesBuilder_.dispose();
              propertiesBuilder_ = null;
              properties_ = other.properties_;
              bitField0_ = (bitField0_ & ~0x00000010);
              propertiesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getPropertiesFieldBuilder()
                      : null;
            } else {
              propertiesBuilder_.addAllMessages(other.properties_);
            }
          }
        }
        if (other.hasEntityTypeMetadata()) {
          mergeEntityTypeMetadata(other.getEntityTypeMetadata());
        }
        switch (other.getValueSourceCase()) {
          case ENUM_VALUES:
            {
              mergeEnumValues(other.getEnumValues());
              break;
            }
          case VALUESOURCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureBaseTypesIsMutable();
                  baseTypes_.add(s);
                  break;
                } // case 18
              case 50:
                {
                  com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property m =
                      input.readMessage(
                          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
                              .parser(),
                          extensionRegistry);
                  if (propertiesBuilder_ == null) {
                    ensurePropertiesIsMutable();
                    properties_.add(m);
                  } else {
                    propertiesBuilder_.addMessage(m);
                  }
                  break;
                } // case 50
              case 90:
                {
                  input.readMessage(
                      getEntityTypeMetadataFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 90
              case 106:
                {
                  displayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 106
              case 114:
                {
                  input.readMessage(getEnumValuesFieldBuilder().getBuilder(), extensionRegistry);
                  valueSourceCase_ = 14;
                  break;
                } // case 114
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int valueSourceCase_ = 0;
      private java.lang.Object valueSource_;

      public ValueSourceCase getValueSourceCase() {
        return ValueSourceCase.forNumber(valueSourceCase_);
      }

      public Builder clearValueSource() {
        valueSourceCase_ = 0;
        valueSource_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues,
              com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues.Builder,
              com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValuesOrBuilder>
          enumValuesBuilder_;
      /**
       *
       *
       * <pre>
       * If specified, lists all the possible values for this entity.  This
       * should not be more than a handful of values.  If the number of values
       * is &gt;10 or could change frequently use the `EntityType.value_ontology`
       * field and specify a list of all possible values in a value ontology
       * file.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues enum_values = 14;
       * </code>
       *
       * @return Whether the enumValues field is set.
       */
      @java.lang.Override
      public boolean hasEnumValues() {
        return valueSourceCase_ == 14;
      }
      /**
       *
       *
       * <pre>
       * If specified, lists all the possible values for this entity.  This
       * should not be more than a handful of values.  If the number of values
       * is &gt;10 or could change frequently use the `EntityType.value_ontology`
       * field and specify a list of all possible values in a value ontology
       * file.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues enum_values = 14;
       * </code>
       *
       * @return The enumValues.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
          getEnumValues() {
        if (enumValuesBuilder_ == null) {
          if (valueSourceCase_ == 14) {
            return (com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues)
                valueSource_;
          }
          return com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
              .getDefaultInstance();
        } else {
          if (valueSourceCase_ == 14) {
            return enumValuesBuilder_.getMessage();
          }
          return com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * If specified, lists all the possible values for this entity.  This
       * should not be more than a handful of values.  If the number of values
       * is &gt;10 or could change frequently use the `EntityType.value_ontology`
       * field and specify a list of all possible values in a value ontology
       * file.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues enum_values = 14;
       * </code>
       */
      public Builder setEnumValues(
          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues value) {
        if (enumValuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          valueSource_ = value;
          onChanged();
        } else {
          enumValuesBuilder_.setMessage(value);
        }
        valueSourceCase_ = 14;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If specified, lists all the possible values for this entity.  This
       * should not be more than a handful of values.  If the number of values
       * is &gt;10 or could change frequently use the `EntityType.value_ontology`
       * field and specify a list of all possible values in a value ontology
       * file.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues enum_values = 14;
       * </code>
       */
      public Builder setEnumValues(
          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues.Builder
              builderForValue) {
        if (enumValuesBuilder_ == null) {
          valueSource_ = builderForValue.build();
          onChanged();
        } else {
          enumValuesBuilder_.setMessage(builderForValue.build());
        }
        valueSourceCase_ = 14;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If specified, lists all the possible values for this entity.  This
       * should not be more than a handful of values.  If the number of values
       * is &gt;10 or could change frequently use the `EntityType.value_ontology`
       * field and specify a list of all possible values in a value ontology
       * file.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues enum_values = 14;
       * </code>
       */
      public Builder mergeEnumValues(
          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues value) {
        if (enumValuesBuilder_ == null) {
          if (valueSourceCase_ == 14
              && valueSource_
                  != com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
                      .getDefaultInstance()) {
            valueSource_ =
                com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues.newBuilder(
                        (com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues)
                            valueSource_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            valueSource_ = value;
          }
          onChanged();
        } else {
          if (valueSourceCase_ == 14) {
            enumValuesBuilder_.mergeFrom(value);
          } else {
            enumValuesBuilder_.setMessage(value);
          }
        }
        valueSourceCase_ = 14;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If specified, lists all the possible values for this entity.  This
       * should not be more than a handful of values.  If the number of values
       * is &gt;10 or could change frequently use the `EntityType.value_ontology`
       * field and specify a list of all possible values in a value ontology
       * file.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues enum_values = 14;
       * </code>
       */
      public Builder clearEnumValues() {
        if (enumValuesBuilder_ == null) {
          if (valueSourceCase_ == 14) {
            valueSourceCase_ = 0;
            valueSource_ = null;
            onChanged();
          }
        } else {
          if (valueSourceCase_ == 14) {
            valueSourceCase_ = 0;
            valueSource_ = null;
          }
          enumValuesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * If specified, lists all the possible values for this entity.  This
       * should not be more than a handful of values.  If the number of values
       * is &gt;10 or could change frequently use the `EntityType.value_ontology`
       * field and specify a list of all possible values in a value ontology
       * file.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues enum_values = 14;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues.Builder
          getEnumValuesBuilder() {
        return getEnumValuesFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If specified, lists all the possible values for this entity.  This
       * should not be more than a handful of values.  If the number of values
       * is &gt;10 or could change frequently use the `EntityType.value_ontology`
       * field and specify a list of all possible values in a value ontology
       * file.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues enum_values = 14;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValuesOrBuilder
          getEnumValuesOrBuilder() {
        if ((valueSourceCase_ == 14) && (enumValuesBuilder_ != null)) {
          return enumValuesBuilder_.getMessageOrBuilder();
        } else {
          if (valueSourceCase_ == 14) {
            return (com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues)
                valueSource_;
          }
          return com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * If specified, lists all the possible values for this entity.  This
       * should not be more than a handful of values.  If the number of values
       * is &gt;10 or could change frequently use the `EntityType.value_ontology`
       * field and specify a list of all possible values in a value ontology
       * file.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues enum_values = 14;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues,
              com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues.Builder,
              com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValuesOrBuilder>
          getEnumValuesFieldBuilder() {
        if (enumValuesBuilder_ == null) {
          if (!(valueSourceCase_ == 14)) {
            valueSource_ =
                com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues
                    .getDefaultInstance();
          }
          enumValuesBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues,
                  com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues.Builder,
                  com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType
                      .EnumValuesOrBuilder>(
                  (com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.EnumValues)
                      valueSource_,
                  getParentForChildren(),
                  isClean());
          valueSource_ = null;
        }
        valueSourceCase_ = 14;
        onChanged();
        return enumValuesBuilder_;
      }

      private java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * User defined name for the type.
       * </pre>
       *
       * <code>string display_name = 13;</code>
       *
       * @return The displayName.
       */
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * User defined name for the type.
       * </pre>
       *
       * <code>string display_name = 13;</code>
       *
       * @return The bytes for displayName.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * User defined name for the type.
       * </pre>
       *
       * <code>string display_name = 13;</code>
       *
       * @param value The displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        displayName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * User defined name for the type.
       * </pre>
       *
       * <code>string display_name = 13;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayName() {
        displayName_ = getDefaultInstance().getDisplayName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * User defined name for the type.
       * </pre>
       *
       * <code>string display_name = 13;</code>
       *
       * @param value The bytes for displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        displayName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Name of the type. It must be unique within the schema file and
       * cannot be a "Common Type".  The following naming conventions are used:
       *
       * - Use `snake_casing`.
       * - Name matching is case-sensitive.
       * - Maximum 64 characters.
       * - Must start with a letter.
       * - Allowed characters: ASCII letters `[a-z0-9_-]`.  (For backward
       *   compatibility internal infrastructure and tooling can handle any ascii
       *   character.)
       * - The `/` is sometimes used to denote a property of a type.  For example
       *   `line_item/amount`.  This convention is deprecated, but will still be
       *   honored for backward compatibility.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the type. It must be unique within the schema file and
       * cannot be a "Common Type".  The following naming conventions are used:
       *
       * - Use `snake_casing`.
       * - Name matching is case-sensitive.
       * - Maximum 64 characters.
       * - Must start with a letter.
       * - Allowed characters: ASCII letters `[a-z0-9_-]`.  (For backward
       *   compatibility internal infrastructure and tooling can handle any ascii
       *   character.)
       * - The `/` is sometimes used to denote a property of a type.  For example
       *   `line_item/amount`.  This convention is deprecated, but will still be
       *   honored for backward compatibility.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the type. It must be unique within the schema file and
       * cannot be a "Common Type".  The following naming conventions are used:
       *
       * - Use `snake_casing`.
       * - Name matching is case-sensitive.
       * - Maximum 64 characters.
       * - Must start with a letter.
       * - Allowed characters: ASCII letters `[a-z0-9_-]`.  (For backward
       *   compatibility internal infrastructure and tooling can handle any ascii
       *   character.)
       * - The `/` is sometimes used to denote a property of a type.  For example
       *   `line_item/amount`.  This convention is deprecated, but will still be
       *   honored for backward compatibility.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of the type. It must be unique within the schema file and
       * cannot be a "Common Type".  The following naming conventions are used:
       *
       * - Use `snake_casing`.
       * - Name matching is case-sensitive.
       * - Maximum 64 characters.
       * - Must start with a letter.
       * - Allowed characters: ASCII letters `[a-z0-9_-]`.  (For backward
       *   compatibility internal infrastructure and tooling can handle any ascii
       *   character.)
       * - The `/` is sometimes used to denote a property of a type.  For example
       *   `line_item/amount`.  This convention is deprecated, but will still be
       *   honored for backward compatibility.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of the type. It must be unique within the schema file and
       * cannot be a "Common Type".  The following naming conventions are used:
       *
       * - Use `snake_casing`.
       * - Name matching is case-sensitive.
       * - Maximum 64 characters.
       * - Must start with a letter.
       * - Allowed characters: ASCII letters `[a-z0-9_-]`.  (For backward
       *   compatibility internal infrastructure and tooling can handle any ascii
       *   character.)
       * - The `/` is sometimes used to denote a property of a type.  For example
       *   `line_item/amount`.  This convention is deprecated, but will still be
       *   honored for backward compatibility.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList baseTypes_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureBaseTypesIsMutable() {
        if (!baseTypes_.isModifiable()) {
          baseTypes_ = new com.google.protobuf.LazyStringArrayList(baseTypes_);
        }
        bitField0_ |= 0x00000008;
      }
      /**
       *
       *
       * <pre>
       * The entity type that this type is derived from.  For now, one and only
       * one should be set.
       * </pre>
       *
       * <code>repeated string base_types = 2;</code>
       *
       * @return A list containing the baseTypes.
       */
      public com.google.protobuf.ProtocolStringList getBaseTypesList() {
        baseTypes_.makeImmutable();
        return baseTypes_;
      }
      /**
       *
       *
       * <pre>
       * The entity type that this type is derived from.  For now, one and only
       * one should be set.
       * </pre>
       *
       * <code>repeated string base_types = 2;</code>
       *
       * @return The count of baseTypes.
       */
      public int getBaseTypesCount() {
        return baseTypes_.size();
      }
      /**
       *
       *
       * <pre>
       * The entity type that this type is derived from.  For now, one and only
       * one should be set.
       * </pre>
       *
       * <code>repeated string base_types = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The baseTypes at the given index.
       */
      public java.lang.String getBaseTypes(int index) {
        return baseTypes_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The entity type that this type is derived from.  For now, one and only
       * one should be set.
       * </pre>
       *
       * <code>repeated string base_types = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the baseTypes at the given index.
       */
      public com.google.protobuf.ByteString getBaseTypesBytes(int index) {
        return baseTypes_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The entity type that this type is derived from.  For now, one and only
       * one should be set.
       * </pre>
       *
       * <code>repeated string base_types = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The baseTypes to set.
       * @return This builder for chaining.
       */
      public Builder setBaseTypes(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBaseTypesIsMutable();
        baseTypes_.set(index, value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The entity type that this type is derived from.  For now, one and only
       * one should be set.
       * </pre>
       *
       * <code>repeated string base_types = 2;</code>
       *
       * @param value The baseTypes to add.
       * @return This builder for chaining.
       */
      public Builder addBaseTypes(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBaseTypesIsMutable();
        baseTypes_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The entity type that this type is derived from.  For now, one and only
       * one should be set.
       * </pre>
       *
       * <code>repeated string base_types = 2;</code>
       *
       * @param values The baseTypes to add.
       * @return This builder for chaining.
       */
      public Builder addAllBaseTypes(java.lang.Iterable<java.lang.String> values) {
        ensureBaseTypesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, baseTypes_);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The entity type that this type is derived from.  For now, one and only
       * one should be set.
       * </pre>
       *
       * <code>repeated string base_types = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBaseTypes() {
        baseTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The entity type that this type is derived from.  For now, one and only
       * one should be set.
       * </pre>
       *
       * <code>repeated string base_types = 2;</code>
       *
       * @param value The bytes of the baseTypes to add.
       * @return This builder for chaining.
       */
      public Builder addBaseTypesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureBaseTypesIsMutable();
        baseTypes_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property>
          properties_ = java.util.Collections.emptyList();

      private void ensurePropertiesIsMutable() {
        if (!((bitField0_ & 0x00000010) != 0)) {
          properties_ =
              new java.util.ArrayList<
                  com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property>(
                  properties_);
          bitField0_ |= 0x00000010;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property,
              com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.Builder,
              com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.PropertyOrBuilder>
          propertiesBuilder_;

      /**
       *
       *
       * <pre>
       * Description the nested structure, or composition of an entity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
       * </code>
       */
      public java.util.List<com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property>
          getPropertiesList() {
        if (propertiesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(properties_);
        } else {
          return propertiesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Description the nested structure, or composition of an entity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
       * </code>
       */
      public int getPropertiesCount() {
        if (propertiesBuilder_ == null) {
          return properties_.size();
        } else {
          return propertiesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Description the nested structure, or composition of an entity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property getProperties(
          int index) {
        if (propertiesBuilder_ == null) {
          return properties_.get(index);
        } else {
          return propertiesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Description the nested structure, or composition of an entity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
       * </code>
       */
      public Builder setProperties(
          int index, com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property value) {
        if (propertiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePropertiesIsMutable();
          properties_.set(index, value);
          onChanged();
        } else {
          propertiesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description the nested structure, or composition of an entity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
       * </code>
       */
      public Builder setProperties(
          int index,
          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.Builder
              builderForValue) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          properties_.set(index, builderForValue.build());
          onChanged();
        } else {
          propertiesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description the nested structure, or composition of an entity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
       * </code>
       */
      public Builder addProperties(
          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property value) {
        if (propertiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePropertiesIsMutable();
          properties_.add(value);
          onChanged();
        } else {
          propertiesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description the nested structure, or composition of an entity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
       * </code>
       */
      public Builder addProperties(
          int index, com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property value) {
        if (propertiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePropertiesIsMutable();
          properties_.add(index, value);
          onChanged();
        } else {
          propertiesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description the nested structure, or composition of an entity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
       * </code>
       */
      public Builder addProperties(
          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.Builder
              builderForValue) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          properties_.add(builderForValue.build());
          onChanged();
        } else {
          propertiesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description the nested structure, or composition of an entity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
       * </code>
       */
      public Builder addProperties(
          int index,
          com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.Builder
              builderForValue) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          properties_.add(index, builderForValue.build());
          onChanged();
        } else {
          propertiesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description the nested structure, or composition of an entity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
       * </code>
       */
      public Builder addAllProperties(
          java.lang.Iterable<
                  ? extends com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property>
              values) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, properties_);
          onChanged();
        } else {
          propertiesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description the nested structure, or composition of an entity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
       * </code>
       */
      public Builder clearProperties() {
        if (propertiesBuilder_ == null) {
          properties_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          propertiesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description the nested structure, or composition of an entity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
       * </code>
       */
      public Builder removeProperties(int index) {
        if (propertiesBuilder_ == null) {
          ensurePropertiesIsMutable();
          properties_.remove(index);
          onChanged();
        } else {
          propertiesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Description the nested structure, or composition of an entity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.Builder
          getPropertiesBuilder(int index) {
        return getPropertiesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Description the nested structure, or composition of an entity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.PropertyOrBuilder
          getPropertiesOrBuilder(int index) {
        if (propertiesBuilder_ == null) {
          return properties_.get(index);
        } else {
          return propertiesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Description the nested structure, or composition of an entity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.PropertyOrBuilder>
          getPropertiesOrBuilderList() {
        if (propertiesBuilder_ != null) {
          return propertiesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(properties_);
        }
      }
      /**
       *
       *
       * <pre>
       * Description the nested structure, or composition of an entity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.Builder
          addPropertiesBuilder() {
        return getPropertiesFieldBuilder()
            .addBuilder(
                com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Description the nested structure, or composition of an entity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.Builder
          addPropertiesBuilder(int index) {
        return getPropertiesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Description the nested structure, or composition of an entity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property properties = 6;
       * </code>
       */
      public java.util.List<
              com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.Builder>
          getPropertiesBuilderList() {
        return getPropertiesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property,
              com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.Builder,
              com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.PropertyOrBuilder>
          getPropertiesFieldBuilder() {
        if (propertiesBuilder_ == null) {
          propertiesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property,
                  com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Property.Builder,
                  com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.PropertyOrBuilder>(
                  properties_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
          properties_ = null;
        }
        return propertiesBuilder_;
      }

      private com.google.cloud.documentai.v1beta3.EntityTypeMetadata entityTypeMetadata_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.EntityTypeMetadata,
              com.google.cloud.documentai.v1beta3.EntityTypeMetadata.Builder,
              com.google.cloud.documentai.v1beta3.EntityTypeMetadataOrBuilder>
          entityTypeMetadataBuilder_;
      /**
       *
       *
       * <pre>
       * Metadata for the entity type.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.EntityTypeMetadata entity_type_metadata = 11;</code>
       *
       * @return Whether the entityTypeMetadata field is set.
       */
      public boolean hasEntityTypeMetadata() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * Metadata for the entity type.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.EntityTypeMetadata entity_type_metadata = 11;</code>
       *
       * @return The entityTypeMetadata.
       */
      public com.google.cloud.documentai.v1beta3.EntityTypeMetadata getEntityTypeMetadata() {
        if (entityTypeMetadataBuilder_ == null) {
          return entityTypeMetadata_ == null
              ? com.google.cloud.documentai.v1beta3.EntityTypeMetadata.getDefaultInstance()
              : entityTypeMetadata_;
        } else {
          return entityTypeMetadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Metadata for the entity type.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.EntityTypeMetadata entity_type_metadata = 11;</code>
       */
      public Builder setEntityTypeMetadata(
          com.google.cloud.documentai.v1beta3.EntityTypeMetadata value) {
        if (entityTypeMetadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          entityTypeMetadata_ = value;
        } else {
          entityTypeMetadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metadata for the entity type.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.EntityTypeMetadata entity_type_metadata = 11;</code>
       */
      public Builder setEntityTypeMetadata(
          com.google.cloud.documentai.v1beta3.EntityTypeMetadata.Builder builderForValue) {
        if (entityTypeMetadataBuilder_ == null) {
          entityTypeMetadata_ = builderForValue.build();
        } else {
          entityTypeMetadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metadata for the entity type.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.EntityTypeMetadata entity_type_metadata = 11;</code>
       */
      public Builder mergeEntityTypeMetadata(
          com.google.cloud.documentai.v1beta3.EntityTypeMetadata value) {
        if (entityTypeMetadataBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && entityTypeMetadata_ != null
              && entityTypeMetadata_
                  != com.google.cloud.documentai.v1beta3.EntityTypeMetadata.getDefaultInstance()) {
            getEntityTypeMetadataBuilder().mergeFrom(value);
          } else {
            entityTypeMetadata_ = value;
          }
        } else {
          entityTypeMetadataBuilder_.mergeFrom(value);
        }
        if (entityTypeMetadata_ != null) {
          bitField0_ |= 0x00000020;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metadata for the entity type.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.EntityTypeMetadata entity_type_metadata = 11;</code>
       */
      public Builder clearEntityTypeMetadata() {
        bitField0_ = (bitField0_ & ~0x00000020);
        entityTypeMetadata_ = null;
        if (entityTypeMetadataBuilder_ != null) {
          entityTypeMetadataBuilder_.dispose();
          entityTypeMetadataBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metadata for the entity type.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.EntityTypeMetadata entity_type_metadata = 11;</code>
       */
      public com.google.cloud.documentai.v1beta3.EntityTypeMetadata.Builder
          getEntityTypeMetadataBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getEntityTypeMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Metadata for the entity type.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.EntityTypeMetadata entity_type_metadata = 11;</code>
       */
      public com.google.cloud.documentai.v1beta3.EntityTypeMetadataOrBuilder
          getEntityTypeMetadataOrBuilder() {
        if (entityTypeMetadataBuilder_ != null) {
          return entityTypeMetadataBuilder_.getMessageOrBuilder();
        } else {
          return entityTypeMetadata_ == null
              ? com.google.cloud.documentai.v1beta3.EntityTypeMetadata.getDefaultInstance()
              : entityTypeMetadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Metadata for the entity type.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.EntityTypeMetadata entity_type_metadata = 11;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.EntityTypeMetadata,
              com.google.cloud.documentai.v1beta3.EntityTypeMetadata.Builder,
              com.google.cloud.documentai.v1beta3.EntityTypeMetadataOrBuilder>
          getEntityTypeMetadataFieldBuilder() {
        if (entityTypeMetadataBuilder_ == null) {
          entityTypeMetadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.EntityTypeMetadata,
                  com.google.cloud.documentai.v1beta3.EntityTypeMetadata.Builder,
                  com.google.cloud.documentai.v1beta3.EntityTypeMetadataOrBuilder>(
                  getEntityTypeMetadata(), getParentForChildren(), isClean());
          entityTypeMetadata_ = null;
        }
        return entityTypeMetadataBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.DocumentSchema.EntityType)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.DocumentSchema.EntityType)
    private static final com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType();
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EntityType> PARSER =
        new com.google.protobuf.AbstractParser<EntityType>() {
          @java.lang.Override
          public EntityType parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<EntityType> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EntityType> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.DocumentSchema.Metadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If true, a `document` entity type can be applied to subdocument
     * (splitting). Otherwise, it can only be applied to the entire document
     * (classification).
     * </pre>
     *
     * <code>bool document_splitter = 1;</code>
     *
     * @return The documentSplitter.
     */
    boolean getDocumentSplitter();

    /**
     *
     *
     * <pre>
     * If true, on a given page, there can be multiple `document` annotations
     * covering it.
     * </pre>
     *
     * <code>bool document_allow_multiple_labels = 2;</code>
     *
     * @return The documentAllowMultipleLabels.
     */
    boolean getDocumentAllowMultipleLabels();

    /**
     *
     *
     * <pre>
     * If set, all the nested entities must be prefixed with the parents.
     * </pre>
     *
     * <code>bool prefixed_naming_on_properties = 6;</code>
     *
     * @return The prefixedNamingOnProperties.
     */
    boolean getPrefixedNamingOnProperties();

    /**
     *
     *
     * <pre>
     * If set, we will skip the naming format validation in the schema. So the
     * string values in `DocumentSchema.EntityType.name` and
     * `DocumentSchema.EntityType.Property.name` will not be checked.
     * </pre>
     *
     * <code>bool skip_naming_validation = 7;</code>
     *
     * @return The skipNamingValidation.
     */
    boolean getSkipNamingValidation();
  }
  /**
   *
   *
   * <pre>
   * Metadata for global schema behavior.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.DocumentSchema.Metadata}
   */
  public static final class Metadata extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.DocumentSchema.Metadata)
      MetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Metadata.newBuilder() to construct.
    private Metadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Metadata() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Metadata();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
          .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_Metadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
          .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_Metadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata.class,
              com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata.Builder.class);
    }

    public static final int DOCUMENT_SPLITTER_FIELD_NUMBER = 1;
    private boolean documentSplitter_ = false;
    /**
     *
     *
     * <pre>
     * If true, a `document` entity type can be applied to subdocument
     * (splitting). Otherwise, it can only be applied to the entire document
     * (classification).
     * </pre>
     *
     * <code>bool document_splitter = 1;</code>
     *
     * @return The documentSplitter.
     */
    @java.lang.Override
    public boolean getDocumentSplitter() {
      return documentSplitter_;
    }

    public static final int DOCUMENT_ALLOW_MULTIPLE_LABELS_FIELD_NUMBER = 2;
    private boolean documentAllowMultipleLabels_ = false;
    /**
     *
     *
     * <pre>
     * If true, on a given page, there can be multiple `document` annotations
     * covering it.
     * </pre>
     *
     * <code>bool document_allow_multiple_labels = 2;</code>
     *
     * @return The documentAllowMultipleLabels.
     */
    @java.lang.Override
    public boolean getDocumentAllowMultipleLabels() {
      return documentAllowMultipleLabels_;
    }

    public static final int PREFIXED_NAMING_ON_PROPERTIES_FIELD_NUMBER = 6;
    private boolean prefixedNamingOnProperties_ = false;
    /**
     *
     *
     * <pre>
     * If set, all the nested entities must be prefixed with the parents.
     * </pre>
     *
     * <code>bool prefixed_naming_on_properties = 6;</code>
     *
     * @return The prefixedNamingOnProperties.
     */
    @java.lang.Override
    public boolean getPrefixedNamingOnProperties() {
      return prefixedNamingOnProperties_;
    }

    public static final int SKIP_NAMING_VALIDATION_FIELD_NUMBER = 7;
    private boolean skipNamingValidation_ = false;
    /**
     *
     *
     * <pre>
     * If set, we will skip the naming format validation in the schema. So the
     * string values in `DocumentSchema.EntityType.name` and
     * `DocumentSchema.EntityType.Property.name` will not be checked.
     * </pre>
     *
     * <code>bool skip_naming_validation = 7;</code>
     *
     * @return The skipNamingValidation.
     */
    @java.lang.Override
    public boolean getSkipNamingValidation() {
      return skipNamingValidation_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (documentSplitter_ != false) {
        output.writeBool(1, documentSplitter_);
      }
      if (documentAllowMultipleLabels_ != false) {
        output.writeBool(2, documentAllowMultipleLabels_);
      }
      if (prefixedNamingOnProperties_ != false) {
        output.writeBool(6, prefixedNamingOnProperties_);
      }
      if (skipNamingValidation_ != false) {
        output.writeBool(7, skipNamingValidation_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (documentSplitter_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, documentSplitter_);
      }
      if (documentAllowMultipleLabels_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(2, documentAllowMultipleLabels_);
      }
      if (prefixedNamingOnProperties_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(6, prefixedNamingOnProperties_);
      }
      if (skipNamingValidation_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, skipNamingValidation_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata other =
          (com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata) obj;

      if (getDocumentSplitter() != other.getDocumentSplitter()) return false;
      if (getDocumentAllowMultipleLabels() != other.getDocumentAllowMultipleLabels()) return false;
      if (getPrefixedNamingOnProperties() != other.getPrefixedNamingOnProperties()) return false;
      if (getSkipNamingValidation() != other.getSkipNamingValidation()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DOCUMENT_SPLITTER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDocumentSplitter());
      hash = (37 * hash) + DOCUMENT_ALLOW_MULTIPLE_LABELS_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDocumentAllowMultipleLabels());
      hash = (37 * hash) + PREFIXED_NAMING_ON_PROPERTIES_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPrefixedNamingOnProperties());
      hash = (37 * hash) + SKIP_NAMING_VALIDATION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSkipNamingValidation());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Metadata for global schema behavior.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.DocumentSchema.Metadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.DocumentSchema.Metadata)
        com.google.cloud.documentai.v1beta3.DocumentSchema.MetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
            .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_Metadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
            .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_Metadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata.class,
                com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata.Builder.class);
      }

      // Construct using com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        documentSplitter_ = false;
        documentAllowMultipleLabels_ = false;
        prefixedNamingOnProperties_ = false;
        skipNamingValidation_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
            .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_Metadata_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata build() {
        com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata buildPartial() {
        com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata result =
            new com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.documentSplitter_ = documentSplitter_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.documentAllowMultipleLabels_ = documentAllowMultipleLabels_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.prefixedNamingOnProperties_ = prefixedNamingOnProperties_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.skipNamingValidation_ = skipNamingValidation_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata) {
          return mergeFrom((com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata other) {
        if (other
            == com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata.getDefaultInstance())
          return this;
        if (other.getDocumentSplitter() != false) {
          setDocumentSplitter(other.getDocumentSplitter());
        }
        if (other.getDocumentAllowMultipleLabels() != false) {
          setDocumentAllowMultipleLabels(other.getDocumentAllowMultipleLabels());
        }
        if (other.getPrefixedNamingOnProperties() != false) {
          setPrefixedNamingOnProperties(other.getPrefixedNamingOnProperties());
        }
        if (other.getSkipNamingValidation() != false) {
          setSkipNamingValidation(other.getSkipNamingValidation());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  documentSplitter_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  documentAllowMultipleLabels_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 48:
                {
                  prefixedNamingOnProperties_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 48
              case 56:
                {
                  skipNamingValidation_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 56
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean documentSplitter_;
      /**
       *
       *
       * <pre>
       * If true, a `document` entity type can be applied to subdocument
       * (splitting). Otherwise, it can only be applied to the entire document
       * (classification).
       * </pre>
       *
       * <code>bool document_splitter = 1;</code>
       *
       * @return The documentSplitter.
       */
      @java.lang.Override
      public boolean getDocumentSplitter() {
        return documentSplitter_;
      }
      /**
       *
       *
       * <pre>
       * If true, a `document` entity type can be applied to subdocument
       * (splitting). Otherwise, it can only be applied to the entire document
       * (classification).
       * </pre>
       *
       * <code>bool document_splitter = 1;</code>
       *
       * @param value The documentSplitter to set.
       * @return This builder for chaining.
       */
      public Builder setDocumentSplitter(boolean value) {

        documentSplitter_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If true, a `document` entity type can be applied to subdocument
       * (splitting). Otherwise, it can only be applied to the entire document
       * (classification).
       * </pre>
       *
       * <code>bool document_splitter = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDocumentSplitter() {
        bitField0_ = (bitField0_ & ~0x00000001);
        documentSplitter_ = false;
        onChanged();
        return this;
      }

      private boolean documentAllowMultipleLabels_;
      /**
       *
       *
       * <pre>
       * If true, on a given page, there can be multiple `document` annotations
       * covering it.
       * </pre>
       *
       * <code>bool document_allow_multiple_labels = 2;</code>
       *
       * @return The documentAllowMultipleLabels.
       */
      @java.lang.Override
      public boolean getDocumentAllowMultipleLabels() {
        return documentAllowMultipleLabels_;
      }
      /**
       *
       *
       * <pre>
       * If true, on a given page, there can be multiple `document` annotations
       * covering it.
       * </pre>
       *
       * <code>bool document_allow_multiple_labels = 2;</code>
       *
       * @param value The documentAllowMultipleLabels to set.
       * @return This builder for chaining.
       */
      public Builder setDocumentAllowMultipleLabels(boolean value) {

        documentAllowMultipleLabels_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If true, on a given page, there can be multiple `document` annotations
       * covering it.
       * </pre>
       *
       * <code>bool document_allow_multiple_labels = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDocumentAllowMultipleLabels() {
        bitField0_ = (bitField0_ & ~0x00000002);
        documentAllowMultipleLabels_ = false;
        onChanged();
        return this;
      }

      private boolean prefixedNamingOnProperties_;
      /**
       *
       *
       * <pre>
       * If set, all the nested entities must be prefixed with the parents.
       * </pre>
       *
       * <code>bool prefixed_naming_on_properties = 6;</code>
       *
       * @return The prefixedNamingOnProperties.
       */
      @java.lang.Override
      public boolean getPrefixedNamingOnProperties() {
        return prefixedNamingOnProperties_;
      }
      /**
       *
       *
       * <pre>
       * If set, all the nested entities must be prefixed with the parents.
       * </pre>
       *
       * <code>bool prefixed_naming_on_properties = 6;</code>
       *
       * @param value The prefixedNamingOnProperties to set.
       * @return This builder for chaining.
       */
      public Builder setPrefixedNamingOnProperties(boolean value) {

        prefixedNamingOnProperties_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, all the nested entities must be prefixed with the parents.
       * </pre>
       *
       * <code>bool prefixed_naming_on_properties = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPrefixedNamingOnProperties() {
        bitField0_ = (bitField0_ & ~0x00000004);
        prefixedNamingOnProperties_ = false;
        onChanged();
        return this;
      }

      private boolean skipNamingValidation_;
      /**
       *
       *
       * <pre>
       * If set, we will skip the naming format validation in the schema. So the
       * string values in `DocumentSchema.EntityType.name` and
       * `DocumentSchema.EntityType.Property.name` will not be checked.
       * </pre>
       *
       * <code>bool skip_naming_validation = 7;</code>
       *
       * @return The skipNamingValidation.
       */
      @java.lang.Override
      public boolean getSkipNamingValidation() {
        return skipNamingValidation_;
      }
      /**
       *
       *
       * <pre>
       * If set, we will skip the naming format validation in the schema. So the
       * string values in `DocumentSchema.EntityType.name` and
       * `DocumentSchema.EntityType.Property.name` will not be checked.
       * </pre>
       *
       * <code>bool skip_naming_validation = 7;</code>
       *
       * @param value The skipNamingValidation to set.
       * @return This builder for chaining.
       */
      public Builder setSkipNamingValidation(boolean value) {

        skipNamingValidation_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, we will skip the naming format validation in the schema. So the
       * string values in `DocumentSchema.EntityType.name` and
       * `DocumentSchema.EntityType.Property.name` will not be checked.
       * </pre>
       *
       * <code>bool skip_naming_validation = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSkipNamingValidation() {
        bitField0_ = (bitField0_ & ~0x00000008);
        skipNamingValidation_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.DocumentSchema.Metadata)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.DocumentSchema.Metadata)
    private static final com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata();
    }

    public static com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Metadata> PARSER =
        new com.google.protobuf.AbstractParser<Metadata>() {
          @java.lang.Override
          public Metadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Metadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Metadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Display name to show to users.
   * </pre>
   *
   * <code>string display_name = 1;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Display name to show to users.
   * </pre>
   *
   * <code>string display_name = 1;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Description of the schema.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Description of the schema.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENTITY_TYPES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType>
      entityTypes_;
  /**
   *
   *
   * <pre>
   * Entity types of the schema.
   * </pre>
   *
   * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType>
      getEntityTypesList() {
    return entityTypes_;
  }
  /**
   *
   *
   * <pre>
   * Entity types of the schema.
   * </pre>
   *
   * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.documentai.v1beta3.DocumentSchema.EntityTypeOrBuilder>
      getEntityTypesOrBuilderList() {
    return entityTypes_;
  }
  /**
   *
   *
   * <pre>
   * Entity types of the schema.
   * </pre>
   *
   * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
   * </code>
   */
  @java.lang.Override
  public int getEntityTypesCount() {
    return entityTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * Entity types of the schema.
   * </pre>
   *
   * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType getEntityTypes(int index) {
    return entityTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Entity types of the schema.
   * </pre>
   *
   * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityTypeOrBuilder
      getEntityTypesOrBuilder(int index) {
    return entityTypes_.get(index);
  }

  public static final int METADATA_FIELD_NUMBER = 4;
  private com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata metadata_;
  /**
   *
   *
   * <pre>
   * Metadata of the schema.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentSchema.Metadata metadata = 4;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Metadata of the schema.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentSchema.Metadata metadata = 4;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata getMetadata() {
    return metadata_ == null
        ? com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata.getDefaultInstance()
        : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Metadata of the schema.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentSchema.Metadata metadata = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentSchema.MetadataOrBuilder
      getMetadataOrBuilder() {
    return metadata_ == null
        ? com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata.getDefaultInstance()
        : metadata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    for (int i = 0; i < entityTypes_.size(); i++) {
      output.writeMessage(3, entityTypes_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getMetadata());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    for (int i = 0; i < entityTypes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, entityTypes_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getMetadata());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.DocumentSchema)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.DocumentSchema other =
        (com.google.cloud.documentai.v1beta3.DocumentSchema) obj;

    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getEntityTypesList().equals(other.getEntityTypesList())) return false;
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getEntityTypesCount() > 0) {
      hash = (37 * hash) + ENTITY_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getEntityTypesList().hashCode();
    }
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.DocumentSchema parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentSchema parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentSchema parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentSchema parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentSchema parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentSchema parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentSchema parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentSchema parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentSchema parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentSchema parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentSchema parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentSchema parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.documentai.v1beta3.DocumentSchema prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The schema defines the output of the processed document by a processor.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.DocumentSchema}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.DocumentSchema)
      com.google.cloud.documentai.v1beta3.DocumentSchemaOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
          .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
          .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.DocumentSchema.class,
              com.google.cloud.documentai.v1beta3.DocumentSchema.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.DocumentSchema.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEntityTypesFieldBuilder();
        getMetadataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      displayName_ = "";
      description_ = "";
      if (entityTypesBuilder_ == null) {
        entityTypes_ = java.util.Collections.emptyList();
      } else {
        entityTypes_ = null;
        entityTypesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentSchema
          .internal_static_google_cloud_documentai_v1beta3_DocumentSchema_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentSchema getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.DocumentSchema.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentSchema build() {
      com.google.cloud.documentai.v1beta3.DocumentSchema result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentSchema buildPartial() {
      com.google.cloud.documentai.v1beta3.DocumentSchema result =
          new com.google.cloud.documentai.v1beta3.DocumentSchema(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.documentai.v1beta3.DocumentSchema result) {
      if (entityTypesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          entityTypes_ = java.util.Collections.unmodifiableList(entityTypes_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.entityTypes_ = entityTypes_;
      } else {
        result.entityTypes_ = entityTypesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta3.DocumentSchema result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.DocumentSchema) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.DocumentSchema) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.DocumentSchema other) {
      if (other == com.google.cloud.documentai.v1beta3.DocumentSchema.getDefaultInstance())
        return this;
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (entityTypesBuilder_ == null) {
        if (!other.entityTypes_.isEmpty()) {
          if (entityTypes_.isEmpty()) {
            entityTypes_ = other.entityTypes_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureEntityTypesIsMutable();
            entityTypes_.addAll(other.entityTypes_);
          }
          onChanged();
        }
      } else {
        if (!other.entityTypes_.isEmpty()) {
          if (entityTypesBuilder_.isEmpty()) {
            entityTypesBuilder_.dispose();
            entityTypesBuilder_ = null;
            entityTypes_ = other.entityTypes_;
            bitField0_ = (bitField0_ & ~0x00000004);
            entityTypesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEntityTypesFieldBuilder()
                    : null;
          } else {
            entityTypesBuilder_.addAllMessages(other.entityTypes_);
          }
        }
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType m =
                    input.readMessage(
                        com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.parser(),
                        extensionRegistry);
                if (entityTypesBuilder_ == null) {
                  ensureEntityTypesIsMutable();
                  entityTypes_.add(m);
                } else {
                  entityTypesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Display name to show to users.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display name to show to users.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display name to show to users.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display name to show to users.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display name to show to users.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Description of the schema.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the schema.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the schema.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the schema.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the schema.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType>
        entityTypes_ = java.util.Collections.emptyList();

    private void ensureEntityTypesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        entityTypes_ =
            new java.util.ArrayList<com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType>(
                entityTypes_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType,
            com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Builder,
            com.google.cloud.documentai.v1beta3.DocumentSchema.EntityTypeOrBuilder>
        entityTypesBuilder_;

    /**
     *
     *
     * <pre>
     * Entity types of the schema.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType>
        getEntityTypesList() {
      if (entityTypesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(entityTypes_);
      } else {
        return entityTypesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Entity types of the schema.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
     * </code>
     */
    public int getEntityTypesCount() {
      if (entityTypesBuilder_ == null) {
        return entityTypes_.size();
      } else {
        return entityTypesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Entity types of the schema.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType getEntityTypes(int index) {
      if (entityTypesBuilder_ == null) {
        return entityTypes_.get(index);
      } else {
        return entityTypesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Entity types of the schema.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
     * </code>
     */
    public Builder setEntityTypes(
        int index, com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType value) {
      if (entityTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntityTypesIsMutable();
        entityTypes_.set(index, value);
        onChanged();
      } else {
        entityTypesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity types of the schema.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
     * </code>
     */
    public Builder setEntityTypes(
        int index,
        com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Builder builderForValue) {
      if (entityTypesBuilder_ == null) {
        ensureEntityTypesIsMutable();
        entityTypes_.set(index, builderForValue.build());
        onChanged();
      } else {
        entityTypesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity types of the schema.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
     * </code>
     */
    public Builder addEntityTypes(
        com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType value) {
      if (entityTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntityTypesIsMutable();
        entityTypes_.add(value);
        onChanged();
      } else {
        entityTypesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity types of the schema.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
     * </code>
     */
    public Builder addEntityTypes(
        int index, com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType value) {
      if (entityTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntityTypesIsMutable();
        entityTypes_.add(index, value);
        onChanged();
      } else {
        entityTypesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity types of the schema.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
     * </code>
     */
    public Builder addEntityTypes(
        com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Builder builderForValue) {
      if (entityTypesBuilder_ == null) {
        ensureEntityTypesIsMutable();
        entityTypes_.add(builderForValue.build());
        onChanged();
      } else {
        entityTypesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity types of the schema.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
     * </code>
     */
    public Builder addEntityTypes(
        int index,
        com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Builder builderForValue) {
      if (entityTypesBuilder_ == null) {
        ensureEntityTypesIsMutable();
        entityTypes_.add(index, builderForValue.build());
        onChanged();
      } else {
        entityTypesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity types of the schema.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
     * </code>
     */
    public Builder addAllEntityTypes(
        java.lang.Iterable<? extends com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType>
            values) {
      if (entityTypesBuilder_ == null) {
        ensureEntityTypesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, entityTypes_);
        onChanged();
      } else {
        entityTypesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity types of the schema.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
     * </code>
     */
    public Builder clearEntityTypes() {
      if (entityTypesBuilder_ == null) {
        entityTypes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        entityTypesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity types of the schema.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
     * </code>
     */
    public Builder removeEntityTypes(int index) {
      if (entityTypesBuilder_ == null) {
        ensureEntityTypesIsMutable();
        entityTypes_.remove(index);
        onChanged();
      } else {
        entityTypesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity types of the schema.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Builder
        getEntityTypesBuilder(int index) {
      return getEntityTypesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Entity types of the schema.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityTypeOrBuilder
        getEntityTypesOrBuilder(int index) {
      if (entityTypesBuilder_ == null) {
        return entityTypes_.get(index);
      } else {
        return entityTypesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Entity types of the schema.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.documentai.v1beta3.DocumentSchema.EntityTypeOrBuilder>
        getEntityTypesOrBuilderList() {
      if (entityTypesBuilder_ != null) {
        return entityTypesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(entityTypes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Entity types of the schema.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Builder
        addEntityTypesBuilder() {
      return getEntityTypesFieldBuilder()
          .addBuilder(
              com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Entity types of the schema.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Builder
        addEntityTypesBuilder(int index) {
      return getEntityTypesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Entity types of the schema.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.DocumentSchema.EntityType entity_types = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Builder>
        getEntityTypesBuilderList() {
      return getEntityTypesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType,
            com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Builder,
            com.google.cloud.documentai.v1beta3.DocumentSchema.EntityTypeOrBuilder>
        getEntityTypesFieldBuilder() {
      if (entityTypesBuilder_ == null) {
        entityTypesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType,
                com.google.cloud.documentai.v1beta3.DocumentSchema.EntityType.Builder,
                com.google.cloud.documentai.v1beta3.DocumentSchema.EntityTypeOrBuilder>(
                entityTypes_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        entityTypes_ = null;
      }
      return entityTypesBuilder_;
    }

    private com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata,
            com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata.Builder,
            com.google.cloud.documentai.v1beta3.DocumentSchema.MetadataOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata of the schema.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema.Metadata metadata = 4;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Metadata of the schema.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema.Metadata metadata = 4;</code>
     *
     * @return The metadata.
     */
    public com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata of the schema.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema.Metadata metadata = 4;</code>
     */
    public Builder setMetadata(com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata of the schema.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema.Metadata metadata = 4;</code>
     */
    public Builder setMetadata(
        com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata of the schema.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema.Metadata metadata = 4;</code>
     */
    public Builder mergeMetadata(
        com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && metadata_ != null
            && metadata_
                != com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata
                    .getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      if (metadata_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata of the schema.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema.Metadata metadata = 4;</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000008);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata of the schema.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema.Metadata metadata = 4;</code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata.Builder
        getMetadataBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata of the schema.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema.Metadata metadata = 4;</code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentSchema.MetadataOrBuilder
        getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata.getDefaultInstance()
            : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata of the schema.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema.Metadata metadata = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata,
            com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata.Builder,
            com.google.cloud.documentai.v1beta3.DocumentSchema.MetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata,
                com.google.cloud.documentai.v1beta3.DocumentSchema.Metadata.Builder,
                com.google.cloud.documentai.v1beta3.DocumentSchema.MetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.DocumentSchema)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.DocumentSchema)
  private static final com.google.cloud.documentai.v1beta3.DocumentSchema DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.DocumentSchema();
  }

  public static com.google.cloud.documentai.v1beta3.DocumentSchema getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DocumentSchema> PARSER =
      new com.google.protobuf.AbstractParser<DocumentSchema>() {
        @java.lang.Override
        public DocumentSchema parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DocumentSchema> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DocumentSchema> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentSchema getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
