/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/evaluation.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * An evaluation of a ProcessorVersion's performance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.Evaluation}
 */
public final class Evaluation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Evaluation)
    EvaluationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Evaluation.newBuilder() to construct.
  private Evaluation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Evaluation() {
    name_ = "";
    kmsKeyName_ = "";
    kmsKeyVersionName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Evaluation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
        .internal_static_google_cloud_documentai_v1beta3_Evaluation_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetEntityMetrics();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
        .internal_static_google_cloud_documentai_v1beta3_Evaluation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.Evaluation.class,
            com.google.cloud.documentai.v1beta3.Evaluation.Builder.class);
  }

  public interface CountersOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Evaluation.Counters)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * How many documents were sent for evaluation.
     * </pre>
     *
     * <code>int32 input_documents_count = 1;</code>
     *
     * @return The inputDocumentsCount.
     */
    int getInputDocumentsCount();

    /**
     *
     *
     * <pre>
     * How many documents were not included in the evaluation as they didn't
     * pass validation.
     * </pre>
     *
     * <code>int32 invalid_documents_count = 2;</code>
     *
     * @return The invalidDocumentsCount.
     */
    int getInvalidDocumentsCount();

    /**
     *
     *
     * <pre>
     * How many documents were not included in the evaluation as Document AI
     * failed to process them.
     * </pre>
     *
     * <code>int32 failed_documents_count = 3;</code>
     *
     * @return The failedDocumentsCount.
     */
    int getFailedDocumentsCount();

    /**
     *
     *
     * <pre>
     * How many documents were used in the evaluation.
     * </pre>
     *
     * <code>int32 evaluated_documents_count = 4;</code>
     *
     * @return The evaluatedDocumentsCount.
     */
    int getEvaluatedDocumentsCount();
  }
  /**
   *
   *
   * <pre>
   * Evaluation counters for the documents that were used.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.Evaluation.Counters}
   */
  public static final class Counters extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Evaluation.Counters)
      CountersOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Counters.newBuilder() to construct.
    private Counters(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Counters() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Counters();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
          .internal_static_google_cloud_documentai_v1beta3_Evaluation_Counters_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
          .internal_static_google_cloud_documentai_v1beta3_Evaluation_Counters_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.Evaluation.Counters.class,
              com.google.cloud.documentai.v1beta3.Evaluation.Counters.Builder.class);
    }

    public static final int INPUT_DOCUMENTS_COUNT_FIELD_NUMBER = 1;
    private int inputDocumentsCount_ = 0;
    /**
     *
     *
     * <pre>
     * How many documents were sent for evaluation.
     * </pre>
     *
     * <code>int32 input_documents_count = 1;</code>
     *
     * @return The inputDocumentsCount.
     */
    @java.lang.Override
    public int getInputDocumentsCount() {
      return inputDocumentsCount_;
    }

    public static final int INVALID_DOCUMENTS_COUNT_FIELD_NUMBER = 2;
    private int invalidDocumentsCount_ = 0;
    /**
     *
     *
     * <pre>
     * How many documents were not included in the evaluation as they didn't
     * pass validation.
     * </pre>
     *
     * <code>int32 invalid_documents_count = 2;</code>
     *
     * @return The invalidDocumentsCount.
     */
    @java.lang.Override
    public int getInvalidDocumentsCount() {
      return invalidDocumentsCount_;
    }

    public static final int FAILED_DOCUMENTS_COUNT_FIELD_NUMBER = 3;
    private int failedDocumentsCount_ = 0;
    /**
     *
     *
     * <pre>
     * How many documents were not included in the evaluation as Document AI
     * failed to process them.
     * </pre>
     *
     * <code>int32 failed_documents_count = 3;</code>
     *
     * @return The failedDocumentsCount.
     */
    @java.lang.Override
    public int getFailedDocumentsCount() {
      return failedDocumentsCount_;
    }

    public static final int EVALUATED_DOCUMENTS_COUNT_FIELD_NUMBER = 4;
    private int evaluatedDocumentsCount_ = 0;
    /**
     *
     *
     * <pre>
     * How many documents were used in the evaluation.
     * </pre>
     *
     * <code>int32 evaluated_documents_count = 4;</code>
     *
     * @return The evaluatedDocumentsCount.
     */
    @java.lang.Override
    public int getEvaluatedDocumentsCount() {
      return evaluatedDocumentsCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (inputDocumentsCount_ != 0) {
        output.writeInt32(1, inputDocumentsCount_);
      }
      if (invalidDocumentsCount_ != 0) {
        output.writeInt32(2, invalidDocumentsCount_);
      }
      if (failedDocumentsCount_ != 0) {
        output.writeInt32(3, failedDocumentsCount_);
      }
      if (evaluatedDocumentsCount_ != 0) {
        output.writeInt32(4, evaluatedDocumentsCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (inputDocumentsCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, inputDocumentsCount_);
      }
      if (invalidDocumentsCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, invalidDocumentsCount_);
      }
      if (failedDocumentsCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, failedDocumentsCount_);
      }
      if (evaluatedDocumentsCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, evaluatedDocumentsCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta3.Evaluation.Counters)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.Evaluation.Counters other =
          (com.google.cloud.documentai.v1beta3.Evaluation.Counters) obj;

      if (getInputDocumentsCount() != other.getInputDocumentsCount()) return false;
      if (getInvalidDocumentsCount() != other.getInvalidDocumentsCount()) return false;
      if (getFailedDocumentsCount() != other.getFailedDocumentsCount()) return false;
      if (getEvaluatedDocumentsCount() != other.getEvaluatedDocumentsCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + INPUT_DOCUMENTS_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getInputDocumentsCount();
      hash = (37 * hash) + INVALID_DOCUMENTS_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getInvalidDocumentsCount();
      hash = (37 * hash) + FAILED_DOCUMENTS_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getFailedDocumentsCount();
      hash = (37 * hash) + EVALUATED_DOCUMENTS_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getEvaluatedDocumentsCount();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Counters parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Counters parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Counters parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Counters parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Counters parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Counters parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Counters parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Counters parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Counters parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Counters parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Counters parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Counters parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.Evaluation.Counters prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Evaluation counters for the documents that were used.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Evaluation.Counters}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Evaluation.Counters)
        com.google.cloud.documentai.v1beta3.Evaluation.CountersOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
            .internal_static_google_cloud_documentai_v1beta3_Evaluation_Counters_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
            .internal_static_google_cloud_documentai_v1beta3_Evaluation_Counters_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Evaluation.Counters.class,
                com.google.cloud.documentai.v1beta3.Evaluation.Counters.Builder.class);
      }

      // Construct using com.google.cloud.documentai.v1beta3.Evaluation.Counters.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        inputDocumentsCount_ = 0;
        invalidDocumentsCount_ = 0;
        failedDocumentsCount_ = 0;
        evaluatedDocumentsCount_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
            .internal_static_google_cloud_documentai_v1beta3_Evaluation_Counters_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Evaluation.Counters getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.Evaluation.Counters.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Evaluation.Counters build() {
        com.google.cloud.documentai.v1beta3.Evaluation.Counters result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Evaluation.Counters buildPartial() {
        com.google.cloud.documentai.v1beta3.Evaluation.Counters result =
            new com.google.cloud.documentai.v1beta3.Evaluation.Counters(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.documentai.v1beta3.Evaluation.Counters result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.inputDocumentsCount_ = inputDocumentsCount_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.invalidDocumentsCount_ = invalidDocumentsCount_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.failedDocumentsCount_ = failedDocumentsCount_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.evaluatedDocumentsCount_ = evaluatedDocumentsCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1beta3.Evaluation.Counters) {
          return mergeFrom((com.google.cloud.documentai.v1beta3.Evaluation.Counters) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.documentai.v1beta3.Evaluation.Counters other) {
        if (other == com.google.cloud.documentai.v1beta3.Evaluation.Counters.getDefaultInstance())
          return this;
        if (other.getInputDocumentsCount() != 0) {
          setInputDocumentsCount(other.getInputDocumentsCount());
        }
        if (other.getInvalidDocumentsCount() != 0) {
          setInvalidDocumentsCount(other.getInvalidDocumentsCount());
        }
        if (other.getFailedDocumentsCount() != 0) {
          setFailedDocumentsCount(other.getFailedDocumentsCount());
        }
        if (other.getEvaluatedDocumentsCount() != 0) {
          setEvaluatedDocumentsCount(other.getEvaluatedDocumentsCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  inputDocumentsCount_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  invalidDocumentsCount_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  failedDocumentsCount_ = input.readInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 32:
                {
                  evaluatedDocumentsCount_ = input.readInt32();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int inputDocumentsCount_;
      /**
       *
       *
       * <pre>
       * How many documents were sent for evaluation.
       * </pre>
       *
       * <code>int32 input_documents_count = 1;</code>
       *
       * @return The inputDocumentsCount.
       */
      @java.lang.Override
      public int getInputDocumentsCount() {
        return inputDocumentsCount_;
      }
      /**
       *
       *
       * <pre>
       * How many documents were sent for evaluation.
       * </pre>
       *
       * <code>int32 input_documents_count = 1;</code>
       *
       * @param value The inputDocumentsCount to set.
       * @return This builder for chaining.
       */
      public Builder setInputDocumentsCount(int value) {

        inputDocumentsCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * How many documents were sent for evaluation.
       * </pre>
       *
       * <code>int32 input_documents_count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInputDocumentsCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        inputDocumentsCount_ = 0;
        onChanged();
        return this;
      }

      private int invalidDocumentsCount_;
      /**
       *
       *
       * <pre>
       * How many documents were not included in the evaluation as they didn't
       * pass validation.
       * </pre>
       *
       * <code>int32 invalid_documents_count = 2;</code>
       *
       * @return The invalidDocumentsCount.
       */
      @java.lang.Override
      public int getInvalidDocumentsCount() {
        return invalidDocumentsCount_;
      }
      /**
       *
       *
       * <pre>
       * How many documents were not included in the evaluation as they didn't
       * pass validation.
       * </pre>
       *
       * <code>int32 invalid_documents_count = 2;</code>
       *
       * @param value The invalidDocumentsCount to set.
       * @return This builder for chaining.
       */
      public Builder setInvalidDocumentsCount(int value) {

        invalidDocumentsCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * How many documents were not included in the evaluation as they didn't
       * pass validation.
       * </pre>
       *
       * <code>int32 invalid_documents_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInvalidDocumentsCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        invalidDocumentsCount_ = 0;
        onChanged();
        return this;
      }

      private int failedDocumentsCount_;
      /**
       *
       *
       * <pre>
       * How many documents were not included in the evaluation as Document AI
       * failed to process them.
       * </pre>
       *
       * <code>int32 failed_documents_count = 3;</code>
       *
       * @return The failedDocumentsCount.
       */
      @java.lang.Override
      public int getFailedDocumentsCount() {
        return failedDocumentsCount_;
      }
      /**
       *
       *
       * <pre>
       * How many documents were not included in the evaluation as Document AI
       * failed to process them.
       * </pre>
       *
       * <code>int32 failed_documents_count = 3;</code>
       *
       * @param value The failedDocumentsCount to set.
       * @return This builder for chaining.
       */
      public Builder setFailedDocumentsCount(int value) {

        failedDocumentsCount_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * How many documents were not included in the evaluation as Document AI
       * failed to process them.
       * </pre>
       *
       * <code>int32 failed_documents_count = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFailedDocumentsCount() {
        bitField0_ = (bitField0_ & ~0x00000004);
        failedDocumentsCount_ = 0;
        onChanged();
        return this;
      }

      private int evaluatedDocumentsCount_;
      /**
       *
       *
       * <pre>
       * How many documents were used in the evaluation.
       * </pre>
       *
       * <code>int32 evaluated_documents_count = 4;</code>
       *
       * @return The evaluatedDocumentsCount.
       */
      @java.lang.Override
      public int getEvaluatedDocumentsCount() {
        return evaluatedDocumentsCount_;
      }
      /**
       *
       *
       * <pre>
       * How many documents were used in the evaluation.
       * </pre>
       *
       * <code>int32 evaluated_documents_count = 4;</code>
       *
       * @param value The evaluatedDocumentsCount to set.
       * @return This builder for chaining.
       */
      public Builder setEvaluatedDocumentsCount(int value) {

        evaluatedDocumentsCount_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * How many documents were used in the evaluation.
       * </pre>
       *
       * <code>int32 evaluated_documents_count = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEvaluatedDocumentsCount() {
        bitField0_ = (bitField0_ & ~0x00000008);
        evaluatedDocumentsCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Evaluation.Counters)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Evaluation.Counters)
    private static final com.google.cloud.documentai.v1beta3.Evaluation.Counters DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Evaluation.Counters();
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Counters getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Counters> PARSER =
        new com.google.protobuf.AbstractParser<Counters>() {
          @java.lang.Override
          public Counters parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Counters> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Counters> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Evaluation.Counters getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MetricsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Evaluation.Metrics)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The calculated precision.
     * </pre>
     *
     * <code>float precision = 1;</code>
     *
     * @return The precision.
     */
    float getPrecision();

    /**
     *
     *
     * <pre>
     * The calculated recall.
     * </pre>
     *
     * <code>float recall = 2;</code>
     *
     * @return The recall.
     */
    float getRecall();

    /**
     *
     *
     * <pre>
     * The calculated f1 score.
     * </pre>
     *
     * <code>float f1_score = 3;</code>
     *
     * @return The f1Score.
     */
    float getF1Score();

    /**
     *
     *
     * <pre>
     * The amount of occurrences in predicted documents.
     * </pre>
     *
     * <code>int32 predicted_occurrences_count = 4;</code>
     *
     * @return The predictedOccurrencesCount.
     */
    int getPredictedOccurrencesCount();

    /**
     *
     *
     * <pre>
     * The amount of occurrences in ground truth documents.
     * </pre>
     *
     * <code>int32 ground_truth_occurrences_count = 5;</code>
     *
     * @return The groundTruthOccurrencesCount.
     */
    int getGroundTruthOccurrencesCount();

    /**
     *
     *
     * <pre>
     * The amount of documents with a predicted occurrence.
     * </pre>
     *
     * <code>int32 predicted_document_count = 10;</code>
     *
     * @return The predictedDocumentCount.
     */
    int getPredictedDocumentCount();

    /**
     *
     *
     * <pre>
     * The amount of documents with a ground truth occurrence.
     * </pre>
     *
     * <code>int32 ground_truth_document_count = 11;</code>
     *
     * @return The groundTruthDocumentCount.
     */
    int getGroundTruthDocumentCount();

    /**
     *
     *
     * <pre>
     * The amount of true positives.
     * </pre>
     *
     * <code>int32 true_positives_count = 6;</code>
     *
     * @return The truePositivesCount.
     */
    int getTruePositivesCount();

    /**
     *
     *
     * <pre>
     * The amount of false positives.
     * </pre>
     *
     * <code>int32 false_positives_count = 7;</code>
     *
     * @return The falsePositivesCount.
     */
    int getFalsePositivesCount();

    /**
     *
     *
     * <pre>
     * The amount of false negatives.
     * </pre>
     *
     * <code>int32 false_negatives_count = 8;</code>
     *
     * @return The falseNegativesCount.
     */
    int getFalseNegativesCount();

    /**
     *
     *
     * <pre>
     * The amount of documents that had an occurrence of this label.
     * </pre>
     *
     * <code>int32 total_documents_count = 9;</code>
     *
     * @return The totalDocumentsCount.
     */
    int getTotalDocumentsCount();
  }
  /**
   *
   *
   * <pre>
   * Evaluation metrics, either in aggregate or about a specific entity.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.Evaluation.Metrics}
   */
  public static final class Metrics extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Evaluation.Metrics)
      MetricsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Metrics.newBuilder() to construct.
    private Metrics(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Metrics() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Metrics();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
          .internal_static_google_cloud_documentai_v1beta3_Evaluation_Metrics_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
          .internal_static_google_cloud_documentai_v1beta3_Evaluation_Metrics_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.Evaluation.Metrics.class,
              com.google.cloud.documentai.v1beta3.Evaluation.Metrics.Builder.class);
    }

    public static final int PRECISION_FIELD_NUMBER = 1;
    private float precision_ = 0F;
    /**
     *
     *
     * <pre>
     * The calculated precision.
     * </pre>
     *
     * <code>float precision = 1;</code>
     *
     * @return The precision.
     */
    @java.lang.Override
    public float getPrecision() {
      return precision_;
    }

    public static final int RECALL_FIELD_NUMBER = 2;
    private float recall_ = 0F;
    /**
     *
     *
     * <pre>
     * The calculated recall.
     * </pre>
     *
     * <code>float recall = 2;</code>
     *
     * @return The recall.
     */
    @java.lang.Override
    public float getRecall() {
      return recall_;
    }

    public static final int F1_SCORE_FIELD_NUMBER = 3;
    private float f1Score_ = 0F;
    /**
     *
     *
     * <pre>
     * The calculated f1 score.
     * </pre>
     *
     * <code>float f1_score = 3;</code>
     *
     * @return The f1Score.
     */
    @java.lang.Override
    public float getF1Score() {
      return f1Score_;
    }

    public static final int PREDICTED_OCCURRENCES_COUNT_FIELD_NUMBER = 4;
    private int predictedOccurrencesCount_ = 0;
    /**
     *
     *
     * <pre>
     * The amount of occurrences in predicted documents.
     * </pre>
     *
     * <code>int32 predicted_occurrences_count = 4;</code>
     *
     * @return The predictedOccurrencesCount.
     */
    @java.lang.Override
    public int getPredictedOccurrencesCount() {
      return predictedOccurrencesCount_;
    }

    public static final int GROUND_TRUTH_OCCURRENCES_COUNT_FIELD_NUMBER = 5;
    private int groundTruthOccurrencesCount_ = 0;
    /**
     *
     *
     * <pre>
     * The amount of occurrences in ground truth documents.
     * </pre>
     *
     * <code>int32 ground_truth_occurrences_count = 5;</code>
     *
     * @return The groundTruthOccurrencesCount.
     */
    @java.lang.Override
    public int getGroundTruthOccurrencesCount() {
      return groundTruthOccurrencesCount_;
    }

    public static final int PREDICTED_DOCUMENT_COUNT_FIELD_NUMBER = 10;
    private int predictedDocumentCount_ = 0;
    /**
     *
     *
     * <pre>
     * The amount of documents with a predicted occurrence.
     * </pre>
     *
     * <code>int32 predicted_document_count = 10;</code>
     *
     * @return The predictedDocumentCount.
     */
    @java.lang.Override
    public int getPredictedDocumentCount() {
      return predictedDocumentCount_;
    }

    public static final int GROUND_TRUTH_DOCUMENT_COUNT_FIELD_NUMBER = 11;
    private int groundTruthDocumentCount_ = 0;
    /**
     *
     *
     * <pre>
     * The amount of documents with a ground truth occurrence.
     * </pre>
     *
     * <code>int32 ground_truth_document_count = 11;</code>
     *
     * @return The groundTruthDocumentCount.
     */
    @java.lang.Override
    public int getGroundTruthDocumentCount() {
      return groundTruthDocumentCount_;
    }

    public static final int TRUE_POSITIVES_COUNT_FIELD_NUMBER = 6;
    private int truePositivesCount_ = 0;
    /**
     *
     *
     * <pre>
     * The amount of true positives.
     * </pre>
     *
     * <code>int32 true_positives_count = 6;</code>
     *
     * @return The truePositivesCount.
     */
    @java.lang.Override
    public int getTruePositivesCount() {
      return truePositivesCount_;
    }

    public static final int FALSE_POSITIVES_COUNT_FIELD_NUMBER = 7;
    private int falsePositivesCount_ = 0;
    /**
     *
     *
     * <pre>
     * The amount of false positives.
     * </pre>
     *
     * <code>int32 false_positives_count = 7;</code>
     *
     * @return The falsePositivesCount.
     */
    @java.lang.Override
    public int getFalsePositivesCount() {
      return falsePositivesCount_;
    }

    public static final int FALSE_NEGATIVES_COUNT_FIELD_NUMBER = 8;
    private int falseNegativesCount_ = 0;
    /**
     *
     *
     * <pre>
     * The amount of false negatives.
     * </pre>
     *
     * <code>int32 false_negatives_count = 8;</code>
     *
     * @return The falseNegativesCount.
     */
    @java.lang.Override
    public int getFalseNegativesCount() {
      return falseNegativesCount_;
    }

    public static final int TOTAL_DOCUMENTS_COUNT_FIELD_NUMBER = 9;
    private int totalDocumentsCount_ = 0;
    /**
     *
     *
     * <pre>
     * The amount of documents that had an occurrence of this label.
     * </pre>
     *
     * <code>int32 total_documents_count = 9;</code>
     *
     * @return The totalDocumentsCount.
     */
    @java.lang.Override
    public int getTotalDocumentsCount() {
      return totalDocumentsCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Float.floatToRawIntBits(precision_) != 0) {
        output.writeFloat(1, precision_);
      }
      if (java.lang.Float.floatToRawIntBits(recall_) != 0) {
        output.writeFloat(2, recall_);
      }
      if (java.lang.Float.floatToRawIntBits(f1Score_) != 0) {
        output.writeFloat(3, f1Score_);
      }
      if (predictedOccurrencesCount_ != 0) {
        output.writeInt32(4, predictedOccurrencesCount_);
      }
      if (groundTruthOccurrencesCount_ != 0) {
        output.writeInt32(5, groundTruthOccurrencesCount_);
      }
      if (truePositivesCount_ != 0) {
        output.writeInt32(6, truePositivesCount_);
      }
      if (falsePositivesCount_ != 0) {
        output.writeInt32(7, falsePositivesCount_);
      }
      if (falseNegativesCount_ != 0) {
        output.writeInt32(8, falseNegativesCount_);
      }
      if (totalDocumentsCount_ != 0) {
        output.writeInt32(9, totalDocumentsCount_);
      }
      if (predictedDocumentCount_ != 0) {
        output.writeInt32(10, predictedDocumentCount_);
      }
      if (groundTruthDocumentCount_ != 0) {
        output.writeInt32(11, groundTruthDocumentCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Float.floatToRawIntBits(precision_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, precision_);
      }
      if (java.lang.Float.floatToRawIntBits(recall_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, recall_);
      }
      if (java.lang.Float.floatToRawIntBits(f1Score_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, f1Score_);
      }
      if (predictedOccurrencesCount_ != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(4, predictedOccurrencesCount_);
      }
      if (groundTruthOccurrencesCount_ != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(5, groundTruthOccurrencesCount_);
      }
      if (truePositivesCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, truePositivesCount_);
      }
      if (falsePositivesCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, falsePositivesCount_);
      }
      if (falseNegativesCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, falseNegativesCount_);
      }
      if (totalDocumentsCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(9, totalDocumentsCount_);
      }
      if (predictedDocumentCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(10, predictedDocumentCount_);
      }
      if (groundTruthDocumentCount_ != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(11, groundTruthDocumentCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta3.Evaluation.Metrics)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.Evaluation.Metrics other =
          (com.google.cloud.documentai.v1beta3.Evaluation.Metrics) obj;

      if (java.lang.Float.floatToIntBits(getPrecision())
          != java.lang.Float.floatToIntBits(other.getPrecision())) return false;
      if (java.lang.Float.floatToIntBits(getRecall())
          != java.lang.Float.floatToIntBits(other.getRecall())) return false;
      if (java.lang.Float.floatToIntBits(getF1Score())
          != java.lang.Float.floatToIntBits(other.getF1Score())) return false;
      if (getPredictedOccurrencesCount() != other.getPredictedOccurrencesCount()) return false;
      if (getGroundTruthOccurrencesCount() != other.getGroundTruthOccurrencesCount()) return false;
      if (getPredictedDocumentCount() != other.getPredictedDocumentCount()) return false;
      if (getGroundTruthDocumentCount() != other.getGroundTruthDocumentCount()) return false;
      if (getTruePositivesCount() != other.getTruePositivesCount()) return false;
      if (getFalsePositivesCount() != other.getFalsePositivesCount()) return false;
      if (getFalseNegativesCount() != other.getFalseNegativesCount()) return false;
      if (getTotalDocumentsCount() != other.getTotalDocumentsCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PRECISION_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getPrecision());
      hash = (37 * hash) + RECALL_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getRecall());
      hash = (37 * hash) + F1_SCORE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getF1Score());
      hash = (37 * hash) + PREDICTED_OCCURRENCES_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getPredictedOccurrencesCount();
      hash = (37 * hash) + GROUND_TRUTH_OCCURRENCES_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getGroundTruthOccurrencesCount();
      hash = (37 * hash) + PREDICTED_DOCUMENT_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getPredictedDocumentCount();
      hash = (37 * hash) + GROUND_TRUTH_DOCUMENT_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getGroundTruthDocumentCount();
      hash = (37 * hash) + TRUE_POSITIVES_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getTruePositivesCount();
      hash = (37 * hash) + FALSE_POSITIVES_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getFalsePositivesCount();
      hash = (37 * hash) + FALSE_NEGATIVES_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getFalseNegativesCount();
      hash = (37 * hash) + TOTAL_DOCUMENTS_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getTotalDocumentsCount();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Metrics parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Metrics parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Metrics parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Metrics parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Metrics parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Metrics parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Metrics parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Metrics parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Metrics parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Metrics parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Metrics parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Metrics parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.Evaluation.Metrics prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Evaluation metrics, either in aggregate or about a specific entity.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Evaluation.Metrics}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Evaluation.Metrics)
        com.google.cloud.documentai.v1beta3.Evaluation.MetricsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
            .internal_static_google_cloud_documentai_v1beta3_Evaluation_Metrics_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
            .internal_static_google_cloud_documentai_v1beta3_Evaluation_Metrics_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Evaluation.Metrics.class,
                com.google.cloud.documentai.v1beta3.Evaluation.Metrics.Builder.class);
      }

      // Construct using com.google.cloud.documentai.v1beta3.Evaluation.Metrics.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        precision_ = 0F;
        recall_ = 0F;
        f1Score_ = 0F;
        predictedOccurrencesCount_ = 0;
        groundTruthOccurrencesCount_ = 0;
        predictedDocumentCount_ = 0;
        groundTruthDocumentCount_ = 0;
        truePositivesCount_ = 0;
        falsePositivesCount_ = 0;
        falseNegativesCount_ = 0;
        totalDocumentsCount_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
            .internal_static_google_cloud_documentai_v1beta3_Evaluation_Metrics_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Evaluation.Metrics getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.Evaluation.Metrics.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Evaluation.Metrics build() {
        com.google.cloud.documentai.v1beta3.Evaluation.Metrics result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Evaluation.Metrics buildPartial() {
        com.google.cloud.documentai.v1beta3.Evaluation.Metrics result =
            new com.google.cloud.documentai.v1beta3.Evaluation.Metrics(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.documentai.v1beta3.Evaluation.Metrics result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.precision_ = precision_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.recall_ = recall_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.f1Score_ = f1Score_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.predictedOccurrencesCount_ = predictedOccurrencesCount_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.groundTruthOccurrencesCount_ = groundTruthOccurrencesCount_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.predictedDocumentCount_ = predictedDocumentCount_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.groundTruthDocumentCount_ = groundTruthDocumentCount_;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.truePositivesCount_ = truePositivesCount_;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.falsePositivesCount_ = falsePositivesCount_;
        }
        if (((from_bitField0_ & 0x00000200) != 0)) {
          result.falseNegativesCount_ = falseNegativesCount_;
        }
        if (((from_bitField0_ & 0x00000400) != 0)) {
          result.totalDocumentsCount_ = totalDocumentsCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1beta3.Evaluation.Metrics) {
          return mergeFrom((com.google.cloud.documentai.v1beta3.Evaluation.Metrics) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.documentai.v1beta3.Evaluation.Metrics other) {
        if (other == com.google.cloud.documentai.v1beta3.Evaluation.Metrics.getDefaultInstance())
          return this;
        if (other.getPrecision() != 0F) {
          setPrecision(other.getPrecision());
        }
        if (other.getRecall() != 0F) {
          setRecall(other.getRecall());
        }
        if (other.getF1Score() != 0F) {
          setF1Score(other.getF1Score());
        }
        if (other.getPredictedOccurrencesCount() != 0) {
          setPredictedOccurrencesCount(other.getPredictedOccurrencesCount());
        }
        if (other.getGroundTruthOccurrencesCount() != 0) {
          setGroundTruthOccurrencesCount(other.getGroundTruthOccurrencesCount());
        }
        if (other.getPredictedDocumentCount() != 0) {
          setPredictedDocumentCount(other.getPredictedDocumentCount());
        }
        if (other.getGroundTruthDocumentCount() != 0) {
          setGroundTruthDocumentCount(other.getGroundTruthDocumentCount());
        }
        if (other.getTruePositivesCount() != 0) {
          setTruePositivesCount(other.getTruePositivesCount());
        }
        if (other.getFalsePositivesCount() != 0) {
          setFalsePositivesCount(other.getFalsePositivesCount());
        }
        if (other.getFalseNegativesCount() != 0) {
          setFalseNegativesCount(other.getFalseNegativesCount());
        }
        if (other.getTotalDocumentsCount() != 0) {
          setTotalDocumentsCount(other.getTotalDocumentsCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 13:
                {
                  precision_ = input.readFloat();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 13
              case 21:
                {
                  recall_ = input.readFloat();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 21
              case 29:
                {
                  f1Score_ = input.readFloat();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 29
              case 32:
                {
                  predictedOccurrencesCount_ = input.readInt32();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 40:
                {
                  groundTruthOccurrencesCount_ = input.readInt32();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              case 48:
                {
                  truePositivesCount_ = input.readInt32();
                  bitField0_ |= 0x00000080;
                  break;
                } // case 48
              case 56:
                {
                  falsePositivesCount_ = input.readInt32();
                  bitField0_ |= 0x00000100;
                  break;
                } // case 56
              case 64:
                {
                  falseNegativesCount_ = input.readInt32();
                  bitField0_ |= 0x00000200;
                  break;
                } // case 64
              case 72:
                {
                  totalDocumentsCount_ = input.readInt32();
                  bitField0_ |= 0x00000400;
                  break;
                } // case 72
              case 80:
                {
                  predictedDocumentCount_ = input.readInt32();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 80
              case 88:
                {
                  groundTruthDocumentCount_ = input.readInt32();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 88
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private float precision_;
      /**
       *
       *
       * <pre>
       * The calculated precision.
       * </pre>
       *
       * <code>float precision = 1;</code>
       *
       * @return The precision.
       */
      @java.lang.Override
      public float getPrecision() {
        return precision_;
      }
      /**
       *
       *
       * <pre>
       * The calculated precision.
       * </pre>
       *
       * <code>float precision = 1;</code>
       *
       * @param value The precision to set.
       * @return This builder for chaining.
       */
      public Builder setPrecision(float value) {

        precision_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The calculated precision.
       * </pre>
       *
       * <code>float precision = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPrecision() {
        bitField0_ = (bitField0_ & ~0x00000001);
        precision_ = 0F;
        onChanged();
        return this;
      }

      private float recall_;
      /**
       *
       *
       * <pre>
       * The calculated recall.
       * </pre>
       *
       * <code>float recall = 2;</code>
       *
       * @return The recall.
       */
      @java.lang.Override
      public float getRecall() {
        return recall_;
      }
      /**
       *
       *
       * <pre>
       * The calculated recall.
       * </pre>
       *
       * <code>float recall = 2;</code>
       *
       * @param value The recall to set.
       * @return This builder for chaining.
       */
      public Builder setRecall(float value) {

        recall_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The calculated recall.
       * </pre>
       *
       * <code>float recall = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRecall() {
        bitField0_ = (bitField0_ & ~0x00000002);
        recall_ = 0F;
        onChanged();
        return this;
      }

      private float f1Score_;
      /**
       *
       *
       * <pre>
       * The calculated f1 score.
       * </pre>
       *
       * <code>float f1_score = 3;</code>
       *
       * @return The f1Score.
       */
      @java.lang.Override
      public float getF1Score() {
        return f1Score_;
      }
      /**
       *
       *
       * <pre>
       * The calculated f1 score.
       * </pre>
       *
       * <code>float f1_score = 3;</code>
       *
       * @param value The f1Score to set.
       * @return This builder for chaining.
       */
      public Builder setF1Score(float value) {

        f1Score_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The calculated f1 score.
       * </pre>
       *
       * <code>float f1_score = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearF1Score() {
        bitField0_ = (bitField0_ & ~0x00000004);
        f1Score_ = 0F;
        onChanged();
        return this;
      }

      private int predictedOccurrencesCount_;
      /**
       *
       *
       * <pre>
       * The amount of occurrences in predicted documents.
       * </pre>
       *
       * <code>int32 predicted_occurrences_count = 4;</code>
       *
       * @return The predictedOccurrencesCount.
       */
      @java.lang.Override
      public int getPredictedOccurrencesCount() {
        return predictedOccurrencesCount_;
      }
      /**
       *
       *
       * <pre>
       * The amount of occurrences in predicted documents.
       * </pre>
       *
       * <code>int32 predicted_occurrences_count = 4;</code>
       *
       * @param value The predictedOccurrencesCount to set.
       * @return This builder for chaining.
       */
      public Builder setPredictedOccurrencesCount(int value) {

        predictedOccurrencesCount_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The amount of occurrences in predicted documents.
       * </pre>
       *
       * <code>int32 predicted_occurrences_count = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPredictedOccurrencesCount() {
        bitField0_ = (bitField0_ & ~0x00000008);
        predictedOccurrencesCount_ = 0;
        onChanged();
        return this;
      }

      private int groundTruthOccurrencesCount_;
      /**
       *
       *
       * <pre>
       * The amount of occurrences in ground truth documents.
       * </pre>
       *
       * <code>int32 ground_truth_occurrences_count = 5;</code>
       *
       * @return The groundTruthOccurrencesCount.
       */
      @java.lang.Override
      public int getGroundTruthOccurrencesCount() {
        return groundTruthOccurrencesCount_;
      }
      /**
       *
       *
       * <pre>
       * The amount of occurrences in ground truth documents.
       * </pre>
       *
       * <code>int32 ground_truth_occurrences_count = 5;</code>
       *
       * @param value The groundTruthOccurrencesCount to set.
       * @return This builder for chaining.
       */
      public Builder setGroundTruthOccurrencesCount(int value) {

        groundTruthOccurrencesCount_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The amount of occurrences in ground truth documents.
       * </pre>
       *
       * <code>int32 ground_truth_occurrences_count = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGroundTruthOccurrencesCount() {
        bitField0_ = (bitField0_ & ~0x00000010);
        groundTruthOccurrencesCount_ = 0;
        onChanged();
        return this;
      }

      private int predictedDocumentCount_;
      /**
       *
       *
       * <pre>
       * The amount of documents with a predicted occurrence.
       * </pre>
       *
       * <code>int32 predicted_document_count = 10;</code>
       *
       * @return The predictedDocumentCount.
       */
      @java.lang.Override
      public int getPredictedDocumentCount() {
        return predictedDocumentCount_;
      }
      /**
       *
       *
       * <pre>
       * The amount of documents with a predicted occurrence.
       * </pre>
       *
       * <code>int32 predicted_document_count = 10;</code>
       *
       * @param value The predictedDocumentCount to set.
       * @return This builder for chaining.
       */
      public Builder setPredictedDocumentCount(int value) {

        predictedDocumentCount_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The amount of documents with a predicted occurrence.
       * </pre>
       *
       * <code>int32 predicted_document_count = 10;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPredictedDocumentCount() {
        bitField0_ = (bitField0_ & ~0x00000020);
        predictedDocumentCount_ = 0;
        onChanged();
        return this;
      }

      private int groundTruthDocumentCount_;
      /**
       *
       *
       * <pre>
       * The amount of documents with a ground truth occurrence.
       * </pre>
       *
       * <code>int32 ground_truth_document_count = 11;</code>
       *
       * @return The groundTruthDocumentCount.
       */
      @java.lang.Override
      public int getGroundTruthDocumentCount() {
        return groundTruthDocumentCount_;
      }
      /**
       *
       *
       * <pre>
       * The amount of documents with a ground truth occurrence.
       * </pre>
       *
       * <code>int32 ground_truth_document_count = 11;</code>
       *
       * @param value The groundTruthDocumentCount to set.
       * @return This builder for chaining.
       */
      public Builder setGroundTruthDocumentCount(int value) {

        groundTruthDocumentCount_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The amount of documents with a ground truth occurrence.
       * </pre>
       *
       * <code>int32 ground_truth_document_count = 11;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGroundTruthDocumentCount() {
        bitField0_ = (bitField0_ & ~0x00000040);
        groundTruthDocumentCount_ = 0;
        onChanged();
        return this;
      }

      private int truePositivesCount_;
      /**
       *
       *
       * <pre>
       * The amount of true positives.
       * </pre>
       *
       * <code>int32 true_positives_count = 6;</code>
       *
       * @return The truePositivesCount.
       */
      @java.lang.Override
      public int getTruePositivesCount() {
        return truePositivesCount_;
      }
      /**
       *
       *
       * <pre>
       * The amount of true positives.
       * </pre>
       *
       * <code>int32 true_positives_count = 6;</code>
       *
       * @param value The truePositivesCount to set.
       * @return This builder for chaining.
       */
      public Builder setTruePositivesCount(int value) {

        truePositivesCount_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The amount of true positives.
       * </pre>
       *
       * <code>int32 true_positives_count = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTruePositivesCount() {
        bitField0_ = (bitField0_ & ~0x00000080);
        truePositivesCount_ = 0;
        onChanged();
        return this;
      }

      private int falsePositivesCount_;
      /**
       *
       *
       * <pre>
       * The amount of false positives.
       * </pre>
       *
       * <code>int32 false_positives_count = 7;</code>
       *
       * @return The falsePositivesCount.
       */
      @java.lang.Override
      public int getFalsePositivesCount() {
        return falsePositivesCount_;
      }
      /**
       *
       *
       * <pre>
       * The amount of false positives.
       * </pre>
       *
       * <code>int32 false_positives_count = 7;</code>
       *
       * @param value The falsePositivesCount to set.
       * @return This builder for chaining.
       */
      public Builder setFalsePositivesCount(int value) {

        falsePositivesCount_ = value;
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The amount of false positives.
       * </pre>
       *
       * <code>int32 false_positives_count = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFalsePositivesCount() {
        bitField0_ = (bitField0_ & ~0x00000100);
        falsePositivesCount_ = 0;
        onChanged();
        return this;
      }

      private int falseNegativesCount_;
      /**
       *
       *
       * <pre>
       * The amount of false negatives.
       * </pre>
       *
       * <code>int32 false_negatives_count = 8;</code>
       *
       * @return The falseNegativesCount.
       */
      @java.lang.Override
      public int getFalseNegativesCount() {
        return falseNegativesCount_;
      }
      /**
       *
       *
       * <pre>
       * The amount of false negatives.
       * </pre>
       *
       * <code>int32 false_negatives_count = 8;</code>
       *
       * @param value The falseNegativesCount to set.
       * @return This builder for chaining.
       */
      public Builder setFalseNegativesCount(int value) {

        falseNegativesCount_ = value;
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The amount of false negatives.
       * </pre>
       *
       * <code>int32 false_negatives_count = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFalseNegativesCount() {
        bitField0_ = (bitField0_ & ~0x00000200);
        falseNegativesCount_ = 0;
        onChanged();
        return this;
      }

      private int totalDocumentsCount_;
      /**
       *
       *
       * <pre>
       * The amount of documents that had an occurrence of this label.
       * </pre>
       *
       * <code>int32 total_documents_count = 9;</code>
       *
       * @return The totalDocumentsCount.
       */
      @java.lang.Override
      public int getTotalDocumentsCount() {
        return totalDocumentsCount_;
      }
      /**
       *
       *
       * <pre>
       * The amount of documents that had an occurrence of this label.
       * </pre>
       *
       * <code>int32 total_documents_count = 9;</code>
       *
       * @param value The totalDocumentsCount to set.
       * @return This builder for chaining.
       */
      public Builder setTotalDocumentsCount(int value) {

        totalDocumentsCount_ = value;
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The amount of documents that had an occurrence of this label.
       * </pre>
       *
       * <code>int32 total_documents_count = 9;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTotalDocumentsCount() {
        bitField0_ = (bitField0_ & ~0x00000400);
        totalDocumentsCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Evaluation.Metrics)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Evaluation.Metrics)
    private static final com.google.cloud.documentai.v1beta3.Evaluation.Metrics DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Evaluation.Metrics();
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.Metrics getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Metrics> PARSER =
        new com.google.protobuf.AbstractParser<Metrics>() {
          @java.lang.Override
          public Metrics parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Metrics> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Metrics> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Evaluation.Metrics getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ConfidenceLevelMetricsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The confidence level.
     * </pre>
     *
     * <code>float confidence_level = 1;</code>
     *
     * @return The confidenceLevel.
     */
    float getConfidenceLevel();

    /**
     *
     *
     * <pre>
     * The metrics at the specific confidence level.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Evaluation.Metrics metrics = 2;</code>
     *
     * @return Whether the metrics field is set.
     */
    boolean hasMetrics();
    /**
     *
     *
     * <pre>
     * The metrics at the specific confidence level.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Evaluation.Metrics metrics = 2;</code>
     *
     * @return The metrics.
     */
    com.google.cloud.documentai.v1beta3.Evaluation.Metrics getMetrics();
    /**
     *
     *
     * <pre>
     * The metrics at the specific confidence level.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Evaluation.Metrics metrics = 2;</code>
     */
    com.google.cloud.documentai.v1beta3.Evaluation.MetricsOrBuilder getMetricsOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Evaluations metrics, at a specific confidence level.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics}
   */
  public static final class ConfidenceLevelMetrics extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics)
      ConfidenceLevelMetricsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ConfidenceLevelMetrics.newBuilder() to construct.
    private ConfidenceLevelMetrics(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConfidenceLevelMetrics() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConfidenceLevelMetrics();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
          .internal_static_google_cloud_documentai_v1beta3_Evaluation_ConfidenceLevelMetrics_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
          .internal_static_google_cloud_documentai_v1beta3_Evaluation_ConfidenceLevelMetrics_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.class,
              com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder.class);
    }

    private int bitField0_;
    public static final int CONFIDENCE_LEVEL_FIELD_NUMBER = 1;
    private float confidenceLevel_ = 0F;
    /**
     *
     *
     * <pre>
     * The confidence level.
     * </pre>
     *
     * <code>float confidence_level = 1;</code>
     *
     * @return The confidenceLevel.
     */
    @java.lang.Override
    public float getConfidenceLevel() {
      return confidenceLevel_;
    }

    public static final int METRICS_FIELD_NUMBER = 2;
    private com.google.cloud.documentai.v1beta3.Evaluation.Metrics metrics_;
    /**
     *
     *
     * <pre>
     * The metrics at the specific confidence level.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Evaluation.Metrics metrics = 2;</code>
     *
     * @return Whether the metrics field is set.
     */
    @java.lang.Override
    public boolean hasMetrics() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The metrics at the specific confidence level.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Evaluation.Metrics metrics = 2;</code>
     *
     * @return The metrics.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Evaluation.Metrics getMetrics() {
      return metrics_ == null
          ? com.google.cloud.documentai.v1beta3.Evaluation.Metrics.getDefaultInstance()
          : metrics_;
    }
    /**
     *
     *
     * <pre>
     * The metrics at the specific confidence level.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Evaluation.Metrics metrics = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Evaluation.MetricsOrBuilder getMetricsOrBuilder() {
      return metrics_ == null
          ? com.google.cloud.documentai.v1beta3.Evaluation.Metrics.getDefaultInstance()
          : metrics_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Float.floatToRawIntBits(confidenceLevel_) != 0) {
        output.writeFloat(1, confidenceLevel_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getMetrics());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Float.floatToRawIntBits(confidenceLevel_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, confidenceLevel_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMetrics());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics other =
          (com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics) obj;

      if (java.lang.Float.floatToIntBits(getConfidenceLevel())
          != java.lang.Float.floatToIntBits(other.getConfidenceLevel())) return false;
      if (hasMetrics() != other.hasMetrics()) return false;
      if (hasMetrics()) {
        if (!getMetrics().equals(other.getMetrics())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CONFIDENCE_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidenceLevel());
      if (hasMetrics()) {
        hash = (37 * hash) + METRICS_FIELD_NUMBER;
        hash = (53 * hash) + getMetrics().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Evaluations metrics, at a specific confidence level.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics)
        com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetricsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
            .internal_static_google_cloud_documentai_v1beta3_Evaluation_ConfidenceLevelMetrics_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
            .internal_static_google_cloud_documentai_v1beta3_Evaluation_ConfidenceLevelMetrics_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.class,
                com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetricsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        confidenceLevel_ = 0F;
        metrics_ = null;
        if (metricsBuilder_ != null) {
          metricsBuilder_.dispose();
          metricsBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
            .internal_static_google_cloud_documentai_v1beta3_Evaluation_ConfidenceLevelMetrics_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics build() {
        com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics buildPartial() {
        com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics result =
            new com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.confidenceLevel_ = confidenceLevel_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.metrics_ = metricsBuilder_ == null ? metrics_ : metricsBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics other) {
        if (other
            == com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics
                .getDefaultInstance()) return this;
        if (other.getConfidenceLevel() != 0F) {
          setConfidenceLevel(other.getConfidenceLevel());
        }
        if (other.hasMetrics()) {
          mergeMetrics(other.getMetrics());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 13:
                {
                  confidenceLevel_ = input.readFloat();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 13
              case 18:
                {
                  input.readMessage(getMetricsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private float confidenceLevel_;
      /**
       *
       *
       * <pre>
       * The confidence level.
       * </pre>
       *
       * <code>float confidence_level = 1;</code>
       *
       * @return The confidenceLevel.
       */
      @java.lang.Override
      public float getConfidenceLevel() {
        return confidenceLevel_;
      }
      /**
       *
       *
       * <pre>
       * The confidence level.
       * </pre>
       *
       * <code>float confidence_level = 1;</code>
       *
       * @param value The confidenceLevel to set.
       * @return This builder for chaining.
       */
      public Builder setConfidenceLevel(float value) {

        confidenceLevel_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The confidence level.
       * </pre>
       *
       * <code>float confidence_level = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearConfidenceLevel() {
        bitField0_ = (bitField0_ & ~0x00000001);
        confidenceLevel_ = 0F;
        onChanged();
        return this;
      }

      private com.google.cloud.documentai.v1beta3.Evaluation.Metrics metrics_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.Evaluation.Metrics,
              com.google.cloud.documentai.v1beta3.Evaluation.Metrics.Builder,
              com.google.cloud.documentai.v1beta3.Evaluation.MetricsOrBuilder>
          metricsBuilder_;
      /**
       *
       *
       * <pre>
       * The metrics at the specific confidence level.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Evaluation.Metrics metrics = 2;</code>
       *
       * @return Whether the metrics field is set.
       */
      public boolean hasMetrics() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The metrics at the specific confidence level.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Evaluation.Metrics metrics = 2;</code>
       *
       * @return The metrics.
       */
      public com.google.cloud.documentai.v1beta3.Evaluation.Metrics getMetrics() {
        if (metricsBuilder_ == null) {
          return metrics_ == null
              ? com.google.cloud.documentai.v1beta3.Evaluation.Metrics.getDefaultInstance()
              : metrics_;
        } else {
          return metricsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The metrics at the specific confidence level.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Evaluation.Metrics metrics = 2;</code>
       */
      public Builder setMetrics(com.google.cloud.documentai.v1beta3.Evaluation.Metrics value) {
        if (metricsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metrics_ = value;
        } else {
          metricsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The metrics at the specific confidence level.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Evaluation.Metrics metrics = 2;</code>
       */
      public Builder setMetrics(
          com.google.cloud.documentai.v1beta3.Evaluation.Metrics.Builder builderForValue) {
        if (metricsBuilder_ == null) {
          metrics_ = builderForValue.build();
        } else {
          metricsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The metrics at the specific confidence level.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Evaluation.Metrics metrics = 2;</code>
       */
      public Builder mergeMetrics(com.google.cloud.documentai.v1beta3.Evaluation.Metrics value) {
        if (metricsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && metrics_ != null
              && metrics_
                  != com.google.cloud.documentai.v1beta3.Evaluation.Metrics.getDefaultInstance()) {
            getMetricsBuilder().mergeFrom(value);
          } else {
            metrics_ = value;
          }
        } else {
          metricsBuilder_.mergeFrom(value);
        }
        if (metrics_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The metrics at the specific confidence level.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Evaluation.Metrics metrics = 2;</code>
       */
      public Builder clearMetrics() {
        bitField0_ = (bitField0_ & ~0x00000002);
        metrics_ = null;
        if (metricsBuilder_ != null) {
          metricsBuilder_.dispose();
          metricsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The metrics at the specific confidence level.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Evaluation.Metrics metrics = 2;</code>
       */
      public com.google.cloud.documentai.v1beta3.Evaluation.Metrics.Builder getMetricsBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getMetricsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The metrics at the specific confidence level.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Evaluation.Metrics metrics = 2;</code>
       */
      public com.google.cloud.documentai.v1beta3.Evaluation.MetricsOrBuilder getMetricsOrBuilder() {
        if (metricsBuilder_ != null) {
          return metricsBuilder_.getMessageOrBuilder();
        } else {
          return metrics_ == null
              ? com.google.cloud.documentai.v1beta3.Evaluation.Metrics.getDefaultInstance()
              : metrics_;
        }
      }
      /**
       *
       *
       * <pre>
       * The metrics at the specific confidence level.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Evaluation.Metrics metrics = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.Evaluation.Metrics,
              com.google.cloud.documentai.v1beta3.Evaluation.Metrics.Builder,
              com.google.cloud.documentai.v1beta3.Evaluation.MetricsOrBuilder>
          getMetricsFieldBuilder() {
        if (metricsBuilder_ == null) {
          metricsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.Evaluation.Metrics,
                  com.google.cloud.documentai.v1beta3.Evaluation.Metrics.Builder,
                  com.google.cloud.documentai.v1beta3.Evaluation.MetricsOrBuilder>(
                  getMetrics(), getParentForChildren(), isClean());
          metrics_ = null;
        }
        return metricsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics)
    private static final com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics();
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConfidenceLevelMetrics> PARSER =
        new com.google.protobuf.AbstractParser<ConfidenceLevelMetrics>() {
          @java.lang.Override
          public ConfidenceLevelMetrics parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ConfidenceLevelMetrics> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConfidenceLevelMetrics> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MultiConfidenceMetricsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Metrics across confidence levels with fuzzy matching enabled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
     * </code>
     */
    java.util.List<com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics>
        getConfidenceLevelMetricsList();
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels with fuzzy matching enabled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics getConfidenceLevelMetrics(
        int index);
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels with fuzzy matching enabled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
     * </code>
     */
    int getConfidenceLevelMetricsCount();
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels with fuzzy matching enabled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetricsOrBuilder>
        getConfidenceLevelMetricsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels with fuzzy matching enabled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetricsOrBuilder
        getConfidenceLevelMetricsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Metrics across confidence levels with only exact matching.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
     * </code>
     */
    java.util.List<com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics>
        getConfidenceLevelMetricsExactList();
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels with only exact matching.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics
        getConfidenceLevelMetricsExact(int index);
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels with only exact matching.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
     * </code>
     */
    int getConfidenceLevelMetricsExactCount();
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels with only exact matching.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetricsOrBuilder>
        getConfidenceLevelMetricsExactOrBuilderList();
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels with only exact matching.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetricsOrBuilder
        getConfidenceLevelMetricsExactOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * The calculated area under the precision recall curve (AUPRC), computed by
     * integrating over all confidence thresholds.
     * </pre>
     *
     * <code>float auprc = 2;</code>
     *
     * @return The auprc.
     */
    float getAuprc();

    /**
     *
     *
     * <pre>
     * The Estimated Calibration Error (ECE) of the confidence of the predicted
     * entities.
     * </pre>
     *
     * <code>float estimated_calibration_error = 3;</code>
     *
     * @return The estimatedCalibrationError.
     */
    float getEstimatedCalibrationError();

    /**
     *
     *
     * <pre>
     * The AUPRC for metrics with fuzzy matching disabled, i.e., exact matching
     * only.
     * </pre>
     *
     * <code>float auprc_exact = 5;</code>
     *
     * @return The auprcExact.
     */
    float getAuprcExact();

    /**
     *
     *
     * <pre>
     * The ECE for the predicted entities with fuzzy matching disabled, i.e.,
     * exact matching only.
     * </pre>
     *
     * <code>float estimated_calibration_error_exact = 6;</code>
     *
     * @return The estimatedCalibrationErrorExact.
     */
    float getEstimatedCalibrationErrorExact();

    /**
     *
     *
     * <pre>
     * The metrics type for the label.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType metrics_type = 7;
     * </code>
     *
     * @return The enum numeric value on the wire for metricsType.
     */
    int getMetricsTypeValue();
    /**
     *
     *
     * <pre>
     * The metrics type for the label.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType metrics_type = 7;
     * </code>
     *
     * @return The metricsType.
     */
    com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType
        getMetricsType();
  }
  /**
   *
   *
   * <pre>
   * Metrics across multiple confidence levels.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics}
   */
  public static final class MultiConfidenceMetrics extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics)
      MultiConfidenceMetricsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MultiConfidenceMetrics.newBuilder() to construct.
    private MultiConfidenceMetrics(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MultiConfidenceMetrics() {
      confidenceLevelMetrics_ = java.util.Collections.emptyList();
      confidenceLevelMetricsExact_ = java.util.Collections.emptyList();
      metricsType_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MultiConfidenceMetrics();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
          .internal_static_google_cloud_documentai_v1beta3_Evaluation_MultiConfidenceMetrics_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
          .internal_static_google_cloud_documentai_v1beta3_Evaluation_MultiConfidenceMetrics_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.class,
              com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * A type that determines how metrics should be interpreted.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType}
     */
    public enum MetricsType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * The metrics type is unspecified. By default, metrics without a
       * particular specification are for leaf entity types (i.e., top-level
       * entity types without child types, or child types which are not
       * parent types themselves).
       * </pre>
       *
       * <code>METRICS_TYPE_UNSPECIFIED = 0;</code>
       */
      METRICS_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Indicates whether metrics for this particular label type represent an
       * aggregate of metrics for other types instead of being based on actual
       * TP/FP/FN values for the label type. Metrics for parent (i.e., non-leaf)
       * entity types are an aggregate of metrics for their children.
       * </pre>
       *
       * <code>AGGREGATE = 1;</code>
       */
      AGGREGATE(1),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * The metrics type is unspecified. By default, metrics without a
       * particular specification are for leaf entity types (i.e., top-level
       * entity types without child types, or child types which are not
       * parent types themselves).
       * </pre>
       *
       * <code>METRICS_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int METRICS_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Indicates whether metrics for this particular label type represent an
       * aggregate of metrics for other types instead of being based on actual
       * TP/FP/FN values for the label type. Metrics for parent (i.e., non-leaf)
       * entity types are an aggregate of metrics for their children.
       * </pre>
       *
       * <code>AGGREGATE = 1;</code>
       */
      public static final int AGGREGATE_VALUE = 1;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static MetricsType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static MetricsType forNumber(int value) {
        switch (value) {
          case 0:
            return METRICS_TYPE_UNSPECIFIED;
          case 1:
            return AGGREGATE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<MetricsType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<MetricsType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<MetricsType>() {
            public MetricsType findValueByNumber(int number) {
              return MetricsType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final MetricsType[] VALUES = values();

      public static MetricsType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private MetricsType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType)
    }

    public static final int CONFIDENCE_LEVEL_METRICS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics>
        confidenceLevelMetrics_;
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels with fuzzy matching enabled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics>
        getConfidenceLevelMetricsList() {
      return confidenceLevelMetrics_;
    }
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels with fuzzy matching enabled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetricsOrBuilder>
        getConfidenceLevelMetricsOrBuilderList() {
      return confidenceLevelMetrics_;
    }
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels with fuzzy matching enabled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
     * </code>
     */
    @java.lang.Override
    public int getConfidenceLevelMetricsCount() {
      return confidenceLevelMetrics_.size();
    }
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels with fuzzy matching enabled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics
        getConfidenceLevelMetrics(int index) {
      return confidenceLevelMetrics_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels with fuzzy matching enabled.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetricsOrBuilder
        getConfidenceLevelMetricsOrBuilder(int index) {
      return confidenceLevelMetrics_.get(index);
    }

    public static final int CONFIDENCE_LEVEL_METRICS_EXACT_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics>
        confidenceLevelMetricsExact_;
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels with only exact matching.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics>
        getConfidenceLevelMetricsExactList() {
      return confidenceLevelMetricsExact_;
    }
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels with only exact matching.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetricsOrBuilder>
        getConfidenceLevelMetricsExactOrBuilderList() {
      return confidenceLevelMetricsExact_;
    }
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels with only exact matching.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
     * </code>
     */
    @java.lang.Override
    public int getConfidenceLevelMetricsExactCount() {
      return confidenceLevelMetricsExact_.size();
    }
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels with only exact matching.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics
        getConfidenceLevelMetricsExact(int index) {
      return confidenceLevelMetricsExact_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels with only exact matching.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetricsOrBuilder
        getConfidenceLevelMetricsExactOrBuilder(int index) {
      return confidenceLevelMetricsExact_.get(index);
    }

    public static final int AUPRC_FIELD_NUMBER = 2;
    private float auprc_ = 0F;
    /**
     *
     *
     * <pre>
     * The calculated area under the precision recall curve (AUPRC), computed by
     * integrating over all confidence thresholds.
     * </pre>
     *
     * <code>float auprc = 2;</code>
     *
     * @return The auprc.
     */
    @java.lang.Override
    public float getAuprc() {
      return auprc_;
    }

    public static final int ESTIMATED_CALIBRATION_ERROR_FIELD_NUMBER = 3;
    private float estimatedCalibrationError_ = 0F;
    /**
     *
     *
     * <pre>
     * The Estimated Calibration Error (ECE) of the confidence of the predicted
     * entities.
     * </pre>
     *
     * <code>float estimated_calibration_error = 3;</code>
     *
     * @return The estimatedCalibrationError.
     */
    @java.lang.Override
    public float getEstimatedCalibrationError() {
      return estimatedCalibrationError_;
    }

    public static final int AUPRC_EXACT_FIELD_NUMBER = 5;
    private float auprcExact_ = 0F;
    /**
     *
     *
     * <pre>
     * The AUPRC for metrics with fuzzy matching disabled, i.e., exact matching
     * only.
     * </pre>
     *
     * <code>float auprc_exact = 5;</code>
     *
     * @return The auprcExact.
     */
    @java.lang.Override
    public float getAuprcExact() {
      return auprcExact_;
    }

    public static final int ESTIMATED_CALIBRATION_ERROR_EXACT_FIELD_NUMBER = 6;
    private float estimatedCalibrationErrorExact_ = 0F;
    /**
     *
     *
     * <pre>
     * The ECE for the predicted entities with fuzzy matching disabled, i.e.,
     * exact matching only.
     * </pre>
     *
     * <code>float estimated_calibration_error_exact = 6;</code>
     *
     * @return The estimatedCalibrationErrorExact.
     */
    @java.lang.Override
    public float getEstimatedCalibrationErrorExact() {
      return estimatedCalibrationErrorExact_;
    }

    public static final int METRICS_TYPE_FIELD_NUMBER = 7;
    private int metricsType_ = 0;
    /**
     *
     *
     * <pre>
     * The metrics type for the label.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType metrics_type = 7;
     * </code>
     *
     * @return The enum numeric value on the wire for metricsType.
     */
    @java.lang.Override
    public int getMetricsTypeValue() {
      return metricsType_;
    }
    /**
     *
     *
     * <pre>
     * The metrics type for the label.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType metrics_type = 7;
     * </code>
     *
     * @return The metricsType.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType
        getMetricsType() {
      com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType result =
          com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType
              .forNumber(metricsType_);
      return result == null
          ? com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < confidenceLevelMetrics_.size(); i++) {
        output.writeMessage(1, confidenceLevelMetrics_.get(i));
      }
      if (java.lang.Float.floatToRawIntBits(auprc_) != 0) {
        output.writeFloat(2, auprc_);
      }
      if (java.lang.Float.floatToRawIntBits(estimatedCalibrationError_) != 0) {
        output.writeFloat(3, estimatedCalibrationError_);
      }
      for (int i = 0; i < confidenceLevelMetricsExact_.size(); i++) {
        output.writeMessage(4, confidenceLevelMetricsExact_.get(i));
      }
      if (java.lang.Float.floatToRawIntBits(auprcExact_) != 0) {
        output.writeFloat(5, auprcExact_);
      }
      if (java.lang.Float.floatToRawIntBits(estimatedCalibrationErrorExact_) != 0) {
        output.writeFloat(6, estimatedCalibrationErrorExact_);
      }
      if (metricsType_
          != com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType
              .METRICS_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(7, metricsType_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < confidenceLevelMetrics_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, confidenceLevelMetrics_.get(i));
      }
      if (java.lang.Float.floatToRawIntBits(auprc_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, auprc_);
      }
      if (java.lang.Float.floatToRawIntBits(estimatedCalibrationError_) != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeFloatSize(3, estimatedCalibrationError_);
      }
      for (int i = 0; i < confidenceLevelMetricsExact_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, confidenceLevelMetricsExact_.get(i));
      }
      if (java.lang.Float.floatToRawIntBits(auprcExact_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(5, auprcExact_);
      }
      if (java.lang.Float.floatToRawIntBits(estimatedCalibrationErrorExact_) != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeFloatSize(
                6, estimatedCalibrationErrorExact_);
      }
      if (metricsType_
          != com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType
              .METRICS_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, metricsType_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics other =
          (com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics) obj;

      if (!getConfidenceLevelMetricsList().equals(other.getConfidenceLevelMetricsList()))
        return false;
      if (!getConfidenceLevelMetricsExactList().equals(other.getConfidenceLevelMetricsExactList()))
        return false;
      if (java.lang.Float.floatToIntBits(getAuprc())
          != java.lang.Float.floatToIntBits(other.getAuprc())) return false;
      if (java.lang.Float.floatToIntBits(getEstimatedCalibrationError())
          != java.lang.Float.floatToIntBits(other.getEstimatedCalibrationError())) return false;
      if (java.lang.Float.floatToIntBits(getAuprcExact())
          != java.lang.Float.floatToIntBits(other.getAuprcExact())) return false;
      if (java.lang.Float.floatToIntBits(getEstimatedCalibrationErrorExact())
          != java.lang.Float.floatToIntBits(other.getEstimatedCalibrationErrorExact()))
        return false;
      if (metricsType_ != other.metricsType_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getConfidenceLevelMetricsCount() > 0) {
        hash = (37 * hash) + CONFIDENCE_LEVEL_METRICS_FIELD_NUMBER;
        hash = (53 * hash) + getConfidenceLevelMetricsList().hashCode();
      }
      if (getConfidenceLevelMetricsExactCount() > 0) {
        hash = (37 * hash) + CONFIDENCE_LEVEL_METRICS_EXACT_FIELD_NUMBER;
        hash = (53 * hash) + getConfidenceLevelMetricsExactList().hashCode();
      }
      hash = (37 * hash) + AUPRC_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getAuprc());
      hash = (37 * hash) + ESTIMATED_CALIBRATION_ERROR_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getEstimatedCalibrationError());
      hash = (37 * hash) + AUPRC_EXACT_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getAuprcExact());
      hash = (37 * hash) + ESTIMATED_CALIBRATION_ERROR_EXACT_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getEstimatedCalibrationErrorExact());
      hash = (37 * hash) + METRICS_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + metricsType_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Metrics across multiple confidence levels.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics)
        com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetricsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
            .internal_static_google_cloud_documentai_v1beta3_Evaluation_MultiConfidenceMetrics_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
            .internal_static_google_cloud_documentai_v1beta3_Evaluation_MultiConfidenceMetrics_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.class,
                com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (confidenceLevelMetricsBuilder_ == null) {
          confidenceLevelMetrics_ = java.util.Collections.emptyList();
        } else {
          confidenceLevelMetrics_ = null;
          confidenceLevelMetricsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (confidenceLevelMetricsExactBuilder_ == null) {
          confidenceLevelMetricsExact_ = java.util.Collections.emptyList();
        } else {
          confidenceLevelMetricsExact_ = null;
          confidenceLevelMetricsExactBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        auprc_ = 0F;
        estimatedCalibrationError_ = 0F;
        auprcExact_ = 0F;
        estimatedCalibrationErrorExact_ = 0F;
        metricsType_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
            .internal_static_google_cloud_documentai_v1beta3_Evaluation_MultiConfidenceMetrics_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics build() {
        com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics buildPartial() {
        com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics result =
            new com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics result) {
        if (confidenceLevelMetricsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            confidenceLevelMetrics_ =
                java.util.Collections.unmodifiableList(confidenceLevelMetrics_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.confidenceLevelMetrics_ = confidenceLevelMetrics_;
        } else {
          result.confidenceLevelMetrics_ = confidenceLevelMetricsBuilder_.build();
        }
        if (confidenceLevelMetricsExactBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            confidenceLevelMetricsExact_ =
                java.util.Collections.unmodifiableList(confidenceLevelMetricsExact_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.confidenceLevelMetricsExact_ = confidenceLevelMetricsExact_;
        } else {
          result.confidenceLevelMetricsExact_ = confidenceLevelMetricsExactBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.auprc_ = auprc_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.estimatedCalibrationError_ = estimatedCalibrationError_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.auprcExact_ = auprcExact_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.estimatedCalibrationErrorExact_ = estimatedCalibrationErrorExact_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.metricsType_ = metricsType_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics other) {
        if (other
            == com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics
                .getDefaultInstance()) return this;
        if (confidenceLevelMetricsBuilder_ == null) {
          if (!other.confidenceLevelMetrics_.isEmpty()) {
            if (confidenceLevelMetrics_.isEmpty()) {
              confidenceLevelMetrics_ = other.confidenceLevelMetrics_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureConfidenceLevelMetricsIsMutable();
              confidenceLevelMetrics_.addAll(other.confidenceLevelMetrics_);
            }
            onChanged();
          }
        } else {
          if (!other.confidenceLevelMetrics_.isEmpty()) {
            if (confidenceLevelMetricsBuilder_.isEmpty()) {
              confidenceLevelMetricsBuilder_.dispose();
              confidenceLevelMetricsBuilder_ = null;
              confidenceLevelMetrics_ = other.confidenceLevelMetrics_;
              bitField0_ = (bitField0_ & ~0x00000001);
              confidenceLevelMetricsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getConfidenceLevelMetricsFieldBuilder()
                      : null;
            } else {
              confidenceLevelMetricsBuilder_.addAllMessages(other.confidenceLevelMetrics_);
            }
          }
        }
        if (confidenceLevelMetricsExactBuilder_ == null) {
          if (!other.confidenceLevelMetricsExact_.isEmpty()) {
            if (confidenceLevelMetricsExact_.isEmpty()) {
              confidenceLevelMetricsExact_ = other.confidenceLevelMetricsExact_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureConfidenceLevelMetricsExactIsMutable();
              confidenceLevelMetricsExact_.addAll(other.confidenceLevelMetricsExact_);
            }
            onChanged();
          }
        } else {
          if (!other.confidenceLevelMetricsExact_.isEmpty()) {
            if (confidenceLevelMetricsExactBuilder_.isEmpty()) {
              confidenceLevelMetricsExactBuilder_.dispose();
              confidenceLevelMetricsExactBuilder_ = null;
              confidenceLevelMetricsExact_ = other.confidenceLevelMetricsExact_;
              bitField0_ = (bitField0_ & ~0x00000002);
              confidenceLevelMetricsExactBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getConfidenceLevelMetricsExactFieldBuilder()
                      : null;
            } else {
              confidenceLevelMetricsExactBuilder_.addAllMessages(
                  other.confidenceLevelMetricsExact_);
            }
          }
        }
        if (other.getAuprc() != 0F) {
          setAuprc(other.getAuprc());
        }
        if (other.getEstimatedCalibrationError() != 0F) {
          setEstimatedCalibrationError(other.getEstimatedCalibrationError());
        }
        if (other.getAuprcExact() != 0F) {
          setAuprcExact(other.getAuprcExact());
        }
        if (other.getEstimatedCalibrationErrorExact() != 0F) {
          setEstimatedCalibrationErrorExact(other.getEstimatedCalibrationErrorExact());
        }
        if (other.metricsType_ != 0) {
          setMetricsTypeValue(other.getMetricsTypeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics m =
                      input.readMessage(
                          com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics
                              .parser(),
                          extensionRegistry);
                  if (confidenceLevelMetricsBuilder_ == null) {
                    ensureConfidenceLevelMetricsIsMutable();
                    confidenceLevelMetrics_.add(m);
                  } else {
                    confidenceLevelMetricsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 21:
                {
                  auprc_ = input.readFloat();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 21
              case 29:
                {
                  estimatedCalibrationError_ = input.readFloat();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 29
              case 34:
                {
                  com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics m =
                      input.readMessage(
                          com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics
                              .parser(),
                          extensionRegistry);
                  if (confidenceLevelMetricsExactBuilder_ == null) {
                    ensureConfidenceLevelMetricsExactIsMutable();
                    confidenceLevelMetricsExact_.add(m);
                  } else {
                    confidenceLevelMetricsExactBuilder_.addMessage(m);
                  }
                  break;
                } // case 34
              case 45:
                {
                  auprcExact_ = input.readFloat();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 45
              case 53:
                {
                  estimatedCalibrationErrorExact_ = input.readFloat();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 53
              case 56:
                {
                  metricsType_ = input.readEnum();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 56
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics>
          confidenceLevelMetrics_ = java.util.Collections.emptyList();

      private void ensureConfidenceLevelMetricsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          confidenceLevelMetrics_ =
              new java.util.ArrayList<
                  com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics>(
                  confidenceLevelMetrics_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics,
              com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder,
              com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetricsOrBuilder>
          confidenceLevelMetricsBuilder_;

      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with fuzzy matching enabled.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics>
          getConfidenceLevelMetricsList() {
        if (confidenceLevelMetricsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(confidenceLevelMetrics_);
        } else {
          return confidenceLevelMetricsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with fuzzy matching enabled.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
       * </code>
       */
      public int getConfidenceLevelMetricsCount() {
        if (confidenceLevelMetricsBuilder_ == null) {
          return confidenceLevelMetrics_.size();
        } else {
          return confidenceLevelMetricsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with fuzzy matching enabled.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics
          getConfidenceLevelMetrics(int index) {
        if (confidenceLevelMetricsBuilder_ == null) {
          return confidenceLevelMetrics_.get(index);
        } else {
          return confidenceLevelMetricsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with fuzzy matching enabled.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
       * </code>
       */
      public Builder setConfidenceLevelMetrics(
          int index, com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics value) {
        if (confidenceLevelMetricsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConfidenceLevelMetricsIsMutable();
          confidenceLevelMetrics_.set(index, value);
          onChanged();
        } else {
          confidenceLevelMetricsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with fuzzy matching enabled.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
       * </code>
       */
      public Builder setConfidenceLevelMetrics(
          int index,
          com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder
              builderForValue) {
        if (confidenceLevelMetricsBuilder_ == null) {
          ensureConfidenceLevelMetricsIsMutable();
          confidenceLevelMetrics_.set(index, builderForValue.build());
          onChanged();
        } else {
          confidenceLevelMetricsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with fuzzy matching enabled.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
       * </code>
       */
      public Builder addConfidenceLevelMetrics(
          com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics value) {
        if (confidenceLevelMetricsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConfidenceLevelMetricsIsMutable();
          confidenceLevelMetrics_.add(value);
          onChanged();
        } else {
          confidenceLevelMetricsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with fuzzy matching enabled.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
       * </code>
       */
      public Builder addConfidenceLevelMetrics(
          int index, com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics value) {
        if (confidenceLevelMetricsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConfidenceLevelMetricsIsMutable();
          confidenceLevelMetrics_.add(index, value);
          onChanged();
        } else {
          confidenceLevelMetricsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with fuzzy matching enabled.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
       * </code>
       */
      public Builder addConfidenceLevelMetrics(
          com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder
              builderForValue) {
        if (confidenceLevelMetricsBuilder_ == null) {
          ensureConfidenceLevelMetricsIsMutable();
          confidenceLevelMetrics_.add(builderForValue.build());
          onChanged();
        } else {
          confidenceLevelMetricsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with fuzzy matching enabled.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
       * </code>
       */
      public Builder addConfidenceLevelMetrics(
          int index,
          com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder
              builderForValue) {
        if (confidenceLevelMetricsBuilder_ == null) {
          ensureConfidenceLevelMetricsIsMutable();
          confidenceLevelMetrics_.add(index, builderForValue.build());
          onChanged();
        } else {
          confidenceLevelMetricsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with fuzzy matching enabled.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
       * </code>
       */
      public Builder addAllConfidenceLevelMetrics(
          java.lang.Iterable<
                  ? extends com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics>
              values) {
        if (confidenceLevelMetricsBuilder_ == null) {
          ensureConfidenceLevelMetricsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, confidenceLevelMetrics_);
          onChanged();
        } else {
          confidenceLevelMetricsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with fuzzy matching enabled.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
       * </code>
       */
      public Builder clearConfidenceLevelMetrics() {
        if (confidenceLevelMetricsBuilder_ == null) {
          confidenceLevelMetrics_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          confidenceLevelMetricsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with fuzzy matching enabled.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
       * </code>
       */
      public Builder removeConfidenceLevelMetrics(int index) {
        if (confidenceLevelMetricsBuilder_ == null) {
          ensureConfidenceLevelMetricsIsMutable();
          confidenceLevelMetrics_.remove(index);
          onChanged();
        } else {
          confidenceLevelMetricsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with fuzzy matching enabled.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder
          getConfidenceLevelMetricsBuilder(int index) {
        return getConfidenceLevelMetricsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with fuzzy matching enabled.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetricsOrBuilder
          getConfidenceLevelMetricsOrBuilder(int index) {
        if (confidenceLevelMetricsBuilder_ == null) {
          return confidenceLevelMetrics_.get(index);
        } else {
          return confidenceLevelMetricsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with fuzzy matching enabled.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetricsOrBuilder>
          getConfidenceLevelMetricsOrBuilderList() {
        if (confidenceLevelMetricsBuilder_ != null) {
          return confidenceLevelMetricsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(confidenceLevelMetrics_);
        }
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with fuzzy matching enabled.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder
          addConfidenceLevelMetricsBuilder() {
        return getConfidenceLevelMetricsFieldBuilder()
            .addBuilder(
                com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with fuzzy matching enabled.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder
          addConfidenceLevelMetricsBuilder(int index) {
        return getConfidenceLevelMetricsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with fuzzy matching enabled.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder>
          getConfidenceLevelMetricsBuilderList() {
        return getConfidenceLevelMetricsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics,
              com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder,
              com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetricsOrBuilder>
          getConfidenceLevelMetricsFieldBuilder() {
        if (confidenceLevelMetricsBuilder_ == null) {
          confidenceLevelMetricsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics,
                  com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder,
                  com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetricsOrBuilder>(
                  confidenceLevelMetrics_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          confidenceLevelMetrics_ = null;
        }
        return confidenceLevelMetricsBuilder_;
      }

      private java.util.List<com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics>
          confidenceLevelMetricsExact_ = java.util.Collections.emptyList();

      private void ensureConfidenceLevelMetricsExactIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          confidenceLevelMetricsExact_ =
              new java.util.ArrayList<
                  com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics>(
                  confidenceLevelMetricsExact_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics,
              com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder,
              com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetricsOrBuilder>
          confidenceLevelMetricsExactBuilder_;

      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with only exact matching.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
       * </code>
       */
      public java.util.List<com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics>
          getConfidenceLevelMetricsExactList() {
        if (confidenceLevelMetricsExactBuilder_ == null) {
          return java.util.Collections.unmodifiableList(confidenceLevelMetricsExact_);
        } else {
          return confidenceLevelMetricsExactBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with only exact matching.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
       * </code>
       */
      public int getConfidenceLevelMetricsExactCount() {
        if (confidenceLevelMetricsExactBuilder_ == null) {
          return confidenceLevelMetricsExact_.size();
        } else {
          return confidenceLevelMetricsExactBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with only exact matching.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics
          getConfidenceLevelMetricsExact(int index) {
        if (confidenceLevelMetricsExactBuilder_ == null) {
          return confidenceLevelMetricsExact_.get(index);
        } else {
          return confidenceLevelMetricsExactBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with only exact matching.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
       * </code>
       */
      public Builder setConfidenceLevelMetricsExact(
          int index, com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics value) {
        if (confidenceLevelMetricsExactBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConfidenceLevelMetricsExactIsMutable();
          confidenceLevelMetricsExact_.set(index, value);
          onChanged();
        } else {
          confidenceLevelMetricsExactBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with only exact matching.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
       * </code>
       */
      public Builder setConfidenceLevelMetricsExact(
          int index,
          com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder
              builderForValue) {
        if (confidenceLevelMetricsExactBuilder_ == null) {
          ensureConfidenceLevelMetricsExactIsMutable();
          confidenceLevelMetricsExact_.set(index, builderForValue.build());
          onChanged();
        } else {
          confidenceLevelMetricsExactBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with only exact matching.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
       * </code>
       */
      public Builder addConfidenceLevelMetricsExact(
          com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics value) {
        if (confidenceLevelMetricsExactBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConfidenceLevelMetricsExactIsMutable();
          confidenceLevelMetricsExact_.add(value);
          onChanged();
        } else {
          confidenceLevelMetricsExactBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with only exact matching.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
       * </code>
       */
      public Builder addConfidenceLevelMetricsExact(
          int index, com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics value) {
        if (confidenceLevelMetricsExactBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConfidenceLevelMetricsExactIsMutable();
          confidenceLevelMetricsExact_.add(index, value);
          onChanged();
        } else {
          confidenceLevelMetricsExactBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with only exact matching.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
       * </code>
       */
      public Builder addConfidenceLevelMetricsExact(
          com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder
              builderForValue) {
        if (confidenceLevelMetricsExactBuilder_ == null) {
          ensureConfidenceLevelMetricsExactIsMutable();
          confidenceLevelMetricsExact_.add(builderForValue.build());
          onChanged();
        } else {
          confidenceLevelMetricsExactBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with only exact matching.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
       * </code>
       */
      public Builder addConfidenceLevelMetricsExact(
          int index,
          com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder
              builderForValue) {
        if (confidenceLevelMetricsExactBuilder_ == null) {
          ensureConfidenceLevelMetricsExactIsMutable();
          confidenceLevelMetricsExact_.add(index, builderForValue.build());
          onChanged();
        } else {
          confidenceLevelMetricsExactBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with only exact matching.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
       * </code>
       */
      public Builder addAllConfidenceLevelMetricsExact(
          java.lang.Iterable<
                  ? extends com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics>
              values) {
        if (confidenceLevelMetricsExactBuilder_ == null) {
          ensureConfidenceLevelMetricsExactIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, confidenceLevelMetricsExact_);
          onChanged();
        } else {
          confidenceLevelMetricsExactBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with only exact matching.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
       * </code>
       */
      public Builder clearConfidenceLevelMetricsExact() {
        if (confidenceLevelMetricsExactBuilder_ == null) {
          confidenceLevelMetricsExact_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          confidenceLevelMetricsExactBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with only exact matching.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
       * </code>
       */
      public Builder removeConfidenceLevelMetricsExact(int index) {
        if (confidenceLevelMetricsExactBuilder_ == null) {
          ensureConfidenceLevelMetricsExactIsMutable();
          confidenceLevelMetricsExact_.remove(index);
          onChanged();
        } else {
          confidenceLevelMetricsExactBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with only exact matching.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder
          getConfidenceLevelMetricsExactBuilder(int index) {
        return getConfidenceLevelMetricsExactFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with only exact matching.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetricsOrBuilder
          getConfidenceLevelMetricsExactOrBuilder(int index) {
        if (confidenceLevelMetricsExactBuilder_ == null) {
          return confidenceLevelMetricsExact_.get(index);
        } else {
          return confidenceLevelMetricsExactBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with only exact matching.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetricsOrBuilder>
          getConfidenceLevelMetricsExactOrBuilderList() {
        if (confidenceLevelMetricsExactBuilder_ != null) {
          return confidenceLevelMetricsExactBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(confidenceLevelMetricsExact_);
        }
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with only exact matching.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder
          addConfidenceLevelMetricsExactBuilder() {
        return getConfidenceLevelMetricsExactFieldBuilder()
            .addBuilder(
                com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with only exact matching.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder
          addConfidenceLevelMetricsExactBuilder(int index) {
        return getConfidenceLevelMetricsExactFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Metrics across confidence levels with only exact matching.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics confidence_level_metrics_exact = 4;
       * </code>
       */
      public java.util.List<
              com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder>
          getConfidenceLevelMetricsExactBuilderList() {
        return getConfidenceLevelMetricsExactFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics,
              com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder,
              com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetricsOrBuilder>
          getConfidenceLevelMetricsExactFieldBuilder() {
        if (confidenceLevelMetricsExactBuilder_ == null) {
          confidenceLevelMetricsExactBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics,
                  com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetrics.Builder,
                  com.google.cloud.documentai.v1beta3.Evaluation.ConfidenceLevelMetricsOrBuilder>(
                  confidenceLevelMetricsExact_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          confidenceLevelMetricsExact_ = null;
        }
        return confidenceLevelMetricsExactBuilder_;
      }

      private float auprc_;
      /**
       *
       *
       * <pre>
       * The calculated area under the precision recall curve (AUPRC), computed by
       * integrating over all confidence thresholds.
       * </pre>
       *
       * <code>float auprc = 2;</code>
       *
       * @return The auprc.
       */
      @java.lang.Override
      public float getAuprc() {
        return auprc_;
      }
      /**
       *
       *
       * <pre>
       * The calculated area under the precision recall curve (AUPRC), computed by
       * integrating over all confidence thresholds.
       * </pre>
       *
       * <code>float auprc = 2;</code>
       *
       * @param value The auprc to set.
       * @return This builder for chaining.
       */
      public Builder setAuprc(float value) {

        auprc_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The calculated area under the precision recall curve (AUPRC), computed by
       * integrating over all confidence thresholds.
       * </pre>
       *
       * <code>float auprc = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAuprc() {
        bitField0_ = (bitField0_ & ~0x00000004);
        auprc_ = 0F;
        onChanged();
        return this;
      }

      private float estimatedCalibrationError_;
      /**
       *
       *
       * <pre>
       * The Estimated Calibration Error (ECE) of the confidence of the predicted
       * entities.
       * </pre>
       *
       * <code>float estimated_calibration_error = 3;</code>
       *
       * @return The estimatedCalibrationError.
       */
      @java.lang.Override
      public float getEstimatedCalibrationError() {
        return estimatedCalibrationError_;
      }
      /**
       *
       *
       * <pre>
       * The Estimated Calibration Error (ECE) of the confidence of the predicted
       * entities.
       * </pre>
       *
       * <code>float estimated_calibration_error = 3;</code>
       *
       * @param value The estimatedCalibrationError to set.
       * @return This builder for chaining.
       */
      public Builder setEstimatedCalibrationError(float value) {

        estimatedCalibrationError_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Estimated Calibration Error (ECE) of the confidence of the predicted
       * entities.
       * </pre>
       *
       * <code>float estimated_calibration_error = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEstimatedCalibrationError() {
        bitField0_ = (bitField0_ & ~0x00000008);
        estimatedCalibrationError_ = 0F;
        onChanged();
        return this;
      }

      private float auprcExact_;
      /**
       *
       *
       * <pre>
       * The AUPRC for metrics with fuzzy matching disabled, i.e., exact matching
       * only.
       * </pre>
       *
       * <code>float auprc_exact = 5;</code>
       *
       * @return The auprcExact.
       */
      @java.lang.Override
      public float getAuprcExact() {
        return auprcExact_;
      }
      /**
       *
       *
       * <pre>
       * The AUPRC for metrics with fuzzy matching disabled, i.e., exact matching
       * only.
       * </pre>
       *
       * <code>float auprc_exact = 5;</code>
       *
       * @param value The auprcExact to set.
       * @return This builder for chaining.
       */
      public Builder setAuprcExact(float value) {

        auprcExact_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The AUPRC for metrics with fuzzy matching disabled, i.e., exact matching
       * only.
       * </pre>
       *
       * <code>float auprc_exact = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAuprcExact() {
        bitField0_ = (bitField0_ & ~0x00000010);
        auprcExact_ = 0F;
        onChanged();
        return this;
      }

      private float estimatedCalibrationErrorExact_;
      /**
       *
       *
       * <pre>
       * The ECE for the predicted entities with fuzzy matching disabled, i.e.,
       * exact matching only.
       * </pre>
       *
       * <code>float estimated_calibration_error_exact = 6;</code>
       *
       * @return The estimatedCalibrationErrorExact.
       */
      @java.lang.Override
      public float getEstimatedCalibrationErrorExact() {
        return estimatedCalibrationErrorExact_;
      }
      /**
       *
       *
       * <pre>
       * The ECE for the predicted entities with fuzzy matching disabled, i.e.,
       * exact matching only.
       * </pre>
       *
       * <code>float estimated_calibration_error_exact = 6;</code>
       *
       * @param value The estimatedCalibrationErrorExact to set.
       * @return This builder for chaining.
       */
      public Builder setEstimatedCalibrationErrorExact(float value) {

        estimatedCalibrationErrorExact_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ECE for the predicted entities with fuzzy matching disabled, i.e.,
       * exact matching only.
       * </pre>
       *
       * <code>float estimated_calibration_error_exact = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEstimatedCalibrationErrorExact() {
        bitField0_ = (bitField0_ & ~0x00000020);
        estimatedCalibrationErrorExact_ = 0F;
        onChanged();
        return this;
      }

      private int metricsType_ = 0;
      /**
       *
       *
       * <pre>
       * The metrics type for the label.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType metrics_type = 7;
       * </code>
       *
       * @return The enum numeric value on the wire for metricsType.
       */
      @java.lang.Override
      public int getMetricsTypeValue() {
        return metricsType_;
      }
      /**
       *
       *
       * <pre>
       * The metrics type for the label.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType metrics_type = 7;
       * </code>
       *
       * @param value The enum numeric value on the wire for metricsType to set.
       * @return This builder for chaining.
       */
      public Builder setMetricsTypeValue(int value) {
        metricsType_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The metrics type for the label.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType metrics_type = 7;
       * </code>
       *
       * @return The metricsType.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType
          getMetricsType() {
        com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType result =
            com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType
                .forNumber(metricsType_);
        return result == null
            ? com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The metrics type for the label.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType metrics_type = 7;
       * </code>
       *
       * @param value The metricsType to set.
       * @return This builder for chaining.
       */
      public Builder setMetricsType(
          com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000040;
        metricsType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The metrics type for the label.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.MetricsType metrics_type = 7;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMetricsType() {
        bitField0_ = (bitField0_ & ~0x00000040);
        metricsType_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics)
    private static final com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics();
    }

    public static com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MultiConfidenceMetrics> PARSER =
        new com.google.protobuf.AbstractParser<MultiConfidenceMetrics>() {
          @java.lang.Override
          public MultiConfidenceMetrics parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MultiConfidenceMetrics> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MultiConfidenceMetrics> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the evaluation.
   * Format:
   * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}/evaluations/{evaluation}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the evaluation.
   * Format:
   * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}/evaluations/{evaluation}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * The time that the evaluation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time that the evaluation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * The time that the evaluation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int DOCUMENT_COUNTERS_FIELD_NUMBER = 5;
  private com.google.cloud.documentai.v1beta3.Evaluation.Counters documentCounters_;
  /**
   *
   *
   * <pre>
   * Counters for the documents used in the evaluation.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Evaluation.Counters document_counters = 5;</code>
   *
   * @return Whether the documentCounters field is set.
   */
  @java.lang.Override
  public boolean hasDocumentCounters() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Counters for the documents used in the evaluation.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Evaluation.Counters document_counters = 5;</code>
   *
   * @return The documentCounters.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Evaluation.Counters getDocumentCounters() {
    return documentCounters_ == null
        ? com.google.cloud.documentai.v1beta3.Evaluation.Counters.getDefaultInstance()
        : documentCounters_;
  }
  /**
   *
   *
   * <pre>
   * Counters for the documents used in the evaluation.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Evaluation.Counters document_counters = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Evaluation.CountersOrBuilder
      getDocumentCountersOrBuilder() {
    return documentCounters_ == null
        ? com.google.cloud.documentai.v1beta3.Evaluation.Counters.getDefaultInstance()
        : documentCounters_;
  }

  public static final int ALL_ENTITIES_METRICS_FIELD_NUMBER = 3;
  private com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics allEntitiesMetrics_;
  /**
   *
   *
   * <pre>
   * Metrics for all the entities in aggregate.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics all_entities_metrics = 3;
   * </code>
   *
   * @return Whether the allEntitiesMetrics field is set.
   */
  @java.lang.Override
  public boolean hasAllEntitiesMetrics() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Metrics for all the entities in aggregate.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics all_entities_metrics = 3;
   * </code>
   *
   * @return The allEntitiesMetrics.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics
      getAllEntitiesMetrics() {
    return allEntitiesMetrics_ == null
        ? com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.getDefaultInstance()
        : allEntitiesMetrics_;
  }
  /**
   *
   *
   * <pre>
   * Metrics for all the entities in aggregate.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics all_entities_metrics = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetricsOrBuilder
      getAllEntitiesMetricsOrBuilder() {
    return allEntitiesMetrics_ == null
        ? com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.getDefaultInstance()
        : allEntitiesMetrics_;
  }

  public static final int ENTITY_METRICS_FIELD_NUMBER = 4;

  private static final class EntityMetricsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String,
                    com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics>
                    newDefaultInstance(
                        com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
                            .internal_static_google_cloud_documentai_v1beta3_Evaluation_EntityMetricsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics>
      entityMetrics_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics>
      internalGetEntityMetrics() {
    if (entityMetrics_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          EntityMetricsDefaultEntryHolder.defaultEntry);
    }
    return entityMetrics_;
  }

  public int getEntityMetricsCount() {
    return internalGetEntityMetrics().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Metrics across confidence levels, for different entities.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics&gt; entity_metrics = 4;
   * </code>
   */
  @java.lang.Override
  public boolean containsEntityMetrics(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetEntityMetrics().getMap().containsKey(key);
  }
  /** Use {@link #getEntityMetricsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String, com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics>
      getEntityMetrics() {
    return getEntityMetricsMap();
  }
  /**
   *
   *
   * <pre>
   * Metrics across confidence levels, for different entities.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics&gt; entity_metrics = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String, com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics>
      getEntityMetricsMap() {
    return internalGetEntityMetrics().getMap();
  }
  /**
   *
   *
   * <pre>
   * Metrics across confidence levels, for different entities.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics&gt; entity_metrics = 4;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics
      getEntityMetricsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics>
        map = internalGetEntityMetrics().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Metrics across confidence levels, for different entities.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics&gt; entity_metrics = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics
      getEntityMetricsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics>
        map = internalGetEntityMetrics().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int KMS_KEY_NAME_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKeyName_ = "";
  /**
   *
   *
   * <pre>
   * The KMS key name used for encryption.
   * </pre>
   *
   * <code>string kms_key_name = 6;</code>
   *
   * @return The kmsKeyName.
   */
  @java.lang.Override
  public java.lang.String getKmsKeyName() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKeyName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The KMS key name used for encryption.
   * </pre>
   *
   * <code>string kms_key_name = 6;</code>
   *
   * @return The bytes for kmsKeyName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyNameBytes() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKeyName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KMS_KEY_VERSION_NAME_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKeyVersionName_ = "";
  /**
   *
   *
   * <pre>
   * The KMS key version with which data is encrypted.
   * </pre>
   *
   * <code>string kms_key_version_name = 7;</code>
   *
   * @return The kmsKeyVersionName.
   */
  @java.lang.Override
  public java.lang.String getKmsKeyVersionName() {
    java.lang.Object ref = kmsKeyVersionName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKeyVersionName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The KMS key version with which data is encrypted.
   * </pre>
   *
   * <code>string kms_key_version_name = 7;</code>
   *
   * @return The bytes for kmsKeyVersionName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyVersionNameBytes() {
    java.lang.Object ref = kmsKeyVersionName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKeyVersionName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(3, getAllEntitiesMetrics());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetEntityMetrics(), EntityMetricsDefaultEntryHolder.defaultEntry, 4);
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getDocumentCounters());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, kmsKeyName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyVersionName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, kmsKeyVersionName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAllEntitiesMetrics());
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics>
        entry : internalGetEntityMetrics().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics>
          entityMetrics__ =
              EntityMetricsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, entityMetrics__);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDocumentCounters());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, kmsKeyName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyVersionName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, kmsKeyVersionName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.Evaluation)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.Evaluation other =
        (com.google.cloud.documentai.v1beta3.Evaluation) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasDocumentCounters() != other.hasDocumentCounters()) return false;
    if (hasDocumentCounters()) {
      if (!getDocumentCounters().equals(other.getDocumentCounters())) return false;
    }
    if (hasAllEntitiesMetrics() != other.hasAllEntitiesMetrics()) return false;
    if (hasAllEntitiesMetrics()) {
      if (!getAllEntitiesMetrics().equals(other.getAllEntitiesMetrics())) return false;
    }
    if (!internalGetEntityMetrics().equals(other.internalGetEntityMetrics())) return false;
    if (!getKmsKeyName().equals(other.getKmsKeyName())) return false;
    if (!getKmsKeyVersionName().equals(other.getKmsKeyVersionName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasDocumentCounters()) {
      hash = (37 * hash) + DOCUMENT_COUNTERS_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentCounters().hashCode();
    }
    if (hasAllEntitiesMetrics()) {
      hash = (37 * hash) + ALL_ENTITIES_METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getAllEntitiesMetrics().hashCode();
    }
    if (!internalGetEntityMetrics().getMap().isEmpty()) {
      hash = (37 * hash) + ENTITY_METRICS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetEntityMetrics().hashCode();
    }
    hash = (37 * hash) + KMS_KEY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKeyName().hashCode();
    hash = (37 * hash) + KMS_KEY_VERSION_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKeyVersionName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.Evaluation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.Evaluation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.Evaluation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.Evaluation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.Evaluation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.Evaluation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.Evaluation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.Evaluation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.Evaluation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.Evaluation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.Evaluation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.Evaluation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.documentai.v1beta3.Evaluation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An evaluation of a ProcessorVersion's performance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.Evaluation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Evaluation)
      com.google.cloud.documentai.v1beta3.EvaluationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
          .internal_static_google_cloud_documentai_v1beta3_Evaluation_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetEntityMetrics();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableEntityMetrics();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
          .internal_static_google_cloud_documentai_v1beta3_Evaluation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.Evaluation.class,
              com.google.cloud.documentai.v1beta3.Evaluation.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.Evaluation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getDocumentCountersFieldBuilder();
        getAllEntitiesMetricsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      documentCounters_ = null;
      if (documentCountersBuilder_ != null) {
        documentCountersBuilder_.dispose();
        documentCountersBuilder_ = null;
      }
      allEntitiesMetrics_ = null;
      if (allEntitiesMetricsBuilder_ != null) {
        allEntitiesMetricsBuilder_.dispose();
        allEntitiesMetricsBuilder_ = null;
      }
      internalGetMutableEntityMetrics().clear();
      kmsKeyName_ = "";
      kmsKeyVersionName_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentAiEvaluation
          .internal_static_google_cloud_documentai_v1beta3_Evaluation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Evaluation getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.Evaluation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Evaluation build() {
      com.google.cloud.documentai.v1beta3.Evaluation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Evaluation buildPartial() {
      com.google.cloud.documentai.v1beta3.Evaluation result =
          new com.google.cloud.documentai.v1beta3.Evaluation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta3.Evaluation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.documentCounters_ =
            documentCountersBuilder_ == null ? documentCounters_ : documentCountersBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.allEntitiesMetrics_ =
            allEntitiesMetricsBuilder_ == null
                ? allEntitiesMetrics_
                : allEntitiesMetricsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.entityMetrics_ =
            internalGetEntityMetrics().build(EntityMetricsDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.kmsKeyName_ = kmsKeyName_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.kmsKeyVersionName_ = kmsKeyVersionName_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.Evaluation) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.Evaluation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.Evaluation other) {
      if (other == com.google.cloud.documentai.v1beta3.Evaluation.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasDocumentCounters()) {
        mergeDocumentCounters(other.getDocumentCounters());
      }
      if (other.hasAllEntitiesMetrics()) {
        mergeAllEntitiesMetrics(other.getAllEntitiesMetrics());
      }
      internalGetMutableEntityMetrics().mergeFrom(other.internalGetEntityMetrics());
      bitField0_ |= 0x00000010;
      if (!other.getKmsKeyName().isEmpty()) {
        kmsKeyName_ = other.kmsKeyName_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getKmsKeyVersionName().isEmpty()) {
        kmsKeyVersionName_ = other.kmsKeyVersionName_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getAllEntitiesMetricsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics>
                    entityMetrics__ =
                        input.readMessage(
                            EntityMetricsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableEntityMetrics()
                    .ensureBuilderMap()
                    .put(entityMetrics__.getKey(), entityMetrics__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getDocumentCountersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 42
            case 50:
              {
                kmsKeyName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                kmsKeyVersionName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the evaluation.
     * Format:
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}/evaluations/{evaluation}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the evaluation.
     * Format:
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}/evaluations/{evaluation}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the evaluation.
     * Format:
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}/evaluations/{evaluation}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the evaluation.
     * Format:
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}/evaluations/{evaluation}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the evaluation.
     * Format:
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}/evaluations/{evaluation}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time that the evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time that the evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time that the evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time that the evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time that the evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time that the evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time that the evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time that the evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time that the evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.cloud.documentai.v1beta3.Evaluation.Counters documentCounters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Evaluation.Counters,
            com.google.cloud.documentai.v1beta3.Evaluation.Counters.Builder,
            com.google.cloud.documentai.v1beta3.Evaluation.CountersOrBuilder>
        documentCountersBuilder_;
    /**
     *
     *
     * <pre>
     * Counters for the documents used in the evaluation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Evaluation.Counters document_counters = 5;</code>
     *
     * @return Whether the documentCounters field is set.
     */
    public boolean hasDocumentCounters() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Counters for the documents used in the evaluation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Evaluation.Counters document_counters = 5;</code>
     *
     * @return The documentCounters.
     */
    public com.google.cloud.documentai.v1beta3.Evaluation.Counters getDocumentCounters() {
      if (documentCountersBuilder_ == null) {
        return documentCounters_ == null
            ? com.google.cloud.documentai.v1beta3.Evaluation.Counters.getDefaultInstance()
            : documentCounters_;
      } else {
        return documentCountersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Counters for the documents used in the evaluation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Evaluation.Counters document_counters = 5;</code>
     */
    public Builder setDocumentCounters(
        com.google.cloud.documentai.v1beta3.Evaluation.Counters value) {
      if (documentCountersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentCounters_ = value;
      } else {
        documentCountersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Counters for the documents used in the evaluation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Evaluation.Counters document_counters = 5;</code>
     */
    public Builder setDocumentCounters(
        com.google.cloud.documentai.v1beta3.Evaluation.Counters.Builder builderForValue) {
      if (documentCountersBuilder_ == null) {
        documentCounters_ = builderForValue.build();
      } else {
        documentCountersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Counters for the documents used in the evaluation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Evaluation.Counters document_counters = 5;</code>
     */
    public Builder mergeDocumentCounters(
        com.google.cloud.documentai.v1beta3.Evaluation.Counters value) {
      if (documentCountersBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && documentCounters_ != null
            && documentCounters_
                != com.google.cloud.documentai.v1beta3.Evaluation.Counters.getDefaultInstance()) {
          getDocumentCountersBuilder().mergeFrom(value);
        } else {
          documentCounters_ = value;
        }
      } else {
        documentCountersBuilder_.mergeFrom(value);
      }
      if (documentCounters_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Counters for the documents used in the evaluation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Evaluation.Counters document_counters = 5;</code>
     */
    public Builder clearDocumentCounters() {
      bitField0_ = (bitField0_ & ~0x00000004);
      documentCounters_ = null;
      if (documentCountersBuilder_ != null) {
        documentCountersBuilder_.dispose();
        documentCountersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Counters for the documents used in the evaluation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Evaluation.Counters document_counters = 5;</code>
     */
    public com.google.cloud.documentai.v1beta3.Evaluation.Counters.Builder
        getDocumentCountersBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDocumentCountersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Counters for the documents used in the evaluation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Evaluation.Counters document_counters = 5;</code>
     */
    public com.google.cloud.documentai.v1beta3.Evaluation.CountersOrBuilder
        getDocumentCountersOrBuilder() {
      if (documentCountersBuilder_ != null) {
        return documentCountersBuilder_.getMessageOrBuilder();
      } else {
        return documentCounters_ == null
            ? com.google.cloud.documentai.v1beta3.Evaluation.Counters.getDefaultInstance()
            : documentCounters_;
      }
    }
    /**
     *
     *
     * <pre>
     * Counters for the documents used in the evaluation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Evaluation.Counters document_counters = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Evaluation.Counters,
            com.google.cloud.documentai.v1beta3.Evaluation.Counters.Builder,
            com.google.cloud.documentai.v1beta3.Evaluation.CountersOrBuilder>
        getDocumentCountersFieldBuilder() {
      if (documentCountersBuilder_ == null) {
        documentCountersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Evaluation.Counters,
                com.google.cloud.documentai.v1beta3.Evaluation.Counters.Builder,
                com.google.cloud.documentai.v1beta3.Evaluation.CountersOrBuilder>(
                getDocumentCounters(), getParentForChildren(), isClean());
        documentCounters_ = null;
      }
      return documentCountersBuilder_;
    }

    private com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics
        allEntitiesMetrics_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics,
            com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.Builder,
            com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetricsOrBuilder>
        allEntitiesMetricsBuilder_;
    /**
     *
     *
     * <pre>
     * Metrics for all the entities in aggregate.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics all_entities_metrics = 3;
     * </code>
     *
     * @return Whether the allEntitiesMetrics field is set.
     */
    public boolean hasAllEntitiesMetrics() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Metrics for all the entities in aggregate.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics all_entities_metrics = 3;
     * </code>
     *
     * @return The allEntitiesMetrics.
     */
    public com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics
        getAllEntitiesMetrics() {
      if (allEntitiesMetricsBuilder_ == null) {
        return allEntitiesMetrics_ == null
            ? com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics
                .getDefaultInstance()
            : allEntitiesMetrics_;
      } else {
        return allEntitiesMetricsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics for all the entities in aggregate.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics all_entities_metrics = 3;
     * </code>
     */
    public Builder setAllEntitiesMetrics(
        com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics value) {
      if (allEntitiesMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        allEntitiesMetrics_ = value;
      } else {
        allEntitiesMetricsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics for all the entities in aggregate.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics all_entities_metrics = 3;
     * </code>
     */
    public Builder setAllEntitiesMetrics(
        com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.Builder
            builderForValue) {
      if (allEntitiesMetricsBuilder_ == null) {
        allEntitiesMetrics_ = builderForValue.build();
      } else {
        allEntitiesMetricsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics for all the entities in aggregate.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics all_entities_metrics = 3;
     * </code>
     */
    public Builder mergeAllEntitiesMetrics(
        com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics value) {
      if (allEntitiesMetricsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && allEntitiesMetrics_ != null
            && allEntitiesMetrics_
                != com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics
                    .getDefaultInstance()) {
          getAllEntitiesMetricsBuilder().mergeFrom(value);
        } else {
          allEntitiesMetrics_ = value;
        }
      } else {
        allEntitiesMetricsBuilder_.mergeFrom(value);
      }
      if (allEntitiesMetrics_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics for all the entities in aggregate.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics all_entities_metrics = 3;
     * </code>
     */
    public Builder clearAllEntitiesMetrics() {
      bitField0_ = (bitField0_ & ~0x00000008);
      allEntitiesMetrics_ = null;
      if (allEntitiesMetricsBuilder_ != null) {
        allEntitiesMetricsBuilder_.dispose();
        allEntitiesMetricsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics for all the entities in aggregate.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics all_entities_metrics = 3;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.Builder
        getAllEntitiesMetricsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getAllEntitiesMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metrics for all the entities in aggregate.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics all_entities_metrics = 3;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetricsOrBuilder
        getAllEntitiesMetricsOrBuilder() {
      if (allEntitiesMetricsBuilder_ != null) {
        return allEntitiesMetricsBuilder_.getMessageOrBuilder();
      } else {
        return allEntitiesMetrics_ == null
            ? com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics
                .getDefaultInstance()
            : allEntitiesMetrics_;
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics for all the entities in aggregate.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics all_entities_metrics = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics,
            com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.Builder,
            com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetricsOrBuilder>
        getAllEntitiesMetricsFieldBuilder() {
      if (allEntitiesMetricsBuilder_ == null) {
        allEntitiesMetricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics,
                com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.Builder,
                com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetricsOrBuilder>(
                getAllEntitiesMetrics(), getParentForChildren(), isClean());
        allEntitiesMetrics_ = null;
      }
      return allEntitiesMetricsBuilder_;
    }

    private static final class EntityMetricsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetricsOrBuilder,
            com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics> {
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics build(
          com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetricsOrBuilder val) {
        if (val instanceof com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics) {
          return (com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics) val;
        }
        return ((com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.Builder) val)
            .build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics>
          defaultEntry() {
        return EntityMetricsDefaultEntryHolder.defaultEntry;
      }
    };

    private static final EntityMetricsConverter entityMetricsConverter =
        new EntityMetricsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetricsOrBuilder,
            com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics,
            com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.Builder>
        entityMetrics_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetricsOrBuilder,
            com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics,
            com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.Builder>
        internalGetEntityMetrics() {
      if (entityMetrics_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(entityMetricsConverter);
      }
      return entityMetrics_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetricsOrBuilder,
            com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics,
            com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.Builder>
        internalGetMutableEntityMetrics() {
      if (entityMetrics_ == null) {
        entityMetrics_ = new com.google.protobuf.MapFieldBuilder<>(entityMetricsConverter);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return entityMetrics_;
    }

    public int getEntityMetricsCount() {
      return internalGetEntityMetrics().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels, for different entities.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics&gt; entity_metrics = 4;
     * </code>
     */
    @java.lang.Override
    public boolean containsEntityMetrics(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetEntityMetrics().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getEntityMetricsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics>
        getEntityMetrics() {
      return getEntityMetricsMap();
    }
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels, for different entities.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics&gt; entity_metrics = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics>
        getEntityMetricsMap() {
      return internalGetEntityMetrics().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels, for different entities.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics&gt; entity_metrics = 4;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics
        getEntityMetricsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetricsOrBuilder>
          map = internalGetMutableEntityMetrics().ensureBuilderMap();
      return map.containsKey(key) ? entityMetricsConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels, for different entities.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics&gt; entity_metrics = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics
        getEntityMetricsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetricsOrBuilder>
          map = internalGetMutableEntityMetrics().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return entityMetricsConverter.build(map.get(key));
    }

    public Builder clearEntityMetrics() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableEntityMetrics().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels, for different entities.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics&gt; entity_metrics = 4;
     * </code>
     */
    public Builder removeEntityMetrics(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableEntityMetrics().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics>
        getMutableEntityMetrics() {
      bitField0_ |= 0x00000010;
      return internalGetMutableEntityMetrics().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels, for different entities.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics&gt; entity_metrics = 4;
     * </code>
     */
    public Builder putEntityMetrics(
        java.lang.String key,
        com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableEntityMetrics().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels, for different entities.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics&gt; entity_metrics = 4;
     * </code>
     */
    public Builder putAllEntityMetrics(
        java.util.Map<
                java.lang.String,
                com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics>
            values) {
      for (java.util.Map.Entry<
              java.lang.String,
              com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableEntityMetrics().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics across confidence levels, for different entities.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics&gt; entity_metrics = 4;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.Builder
        putEntityMetricsBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String,
              com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetricsOrBuilder>
          builderMap = internalGetMutableEntityMetrics().ensureBuilderMap();
      com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetricsOrBuilder entry =
          builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics) {
        entry =
            ((com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics) entry)
                .toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.documentai.v1beta3.Evaluation.MultiConfidenceMetrics.Builder) entry;
    }

    private java.lang.Object kmsKeyName_ = "";
    /**
     *
     *
     * <pre>
     * The KMS key name used for encryption.
     * </pre>
     *
     * <code>string kms_key_name = 6;</code>
     *
     * @return The kmsKeyName.
     */
    public java.lang.String getKmsKeyName() {
      java.lang.Object ref = kmsKeyName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The KMS key name used for encryption.
     * </pre>
     *
     * <code>string kms_key_name = 6;</code>
     *
     * @return The bytes for kmsKeyName.
     */
    public com.google.protobuf.ByteString getKmsKeyNameBytes() {
      java.lang.Object ref = kmsKeyName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The KMS key name used for encryption.
     * </pre>
     *
     * <code>string kms_key_name = 6;</code>
     *
     * @param value The kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKeyName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The KMS key name used for encryption.
     * </pre>
     *
     * <code>string kms_key_name = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKeyName() {
      kmsKeyName_ = getDefaultInstance().getKmsKeyName();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The KMS key name used for encryption.
     * </pre>
     *
     * <code>string kms_key_name = 6;</code>
     *
     * @param value The bytes for kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKeyName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKeyVersionName_ = "";
    /**
     *
     *
     * <pre>
     * The KMS key version with which data is encrypted.
     * </pre>
     *
     * <code>string kms_key_version_name = 7;</code>
     *
     * @return The kmsKeyVersionName.
     */
    public java.lang.String getKmsKeyVersionName() {
      java.lang.Object ref = kmsKeyVersionName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyVersionName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The KMS key version with which data is encrypted.
     * </pre>
     *
     * <code>string kms_key_version_name = 7;</code>
     *
     * @return The bytes for kmsKeyVersionName.
     */
    public com.google.protobuf.ByteString getKmsKeyVersionNameBytes() {
      java.lang.Object ref = kmsKeyVersionName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyVersionName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The KMS key version with which data is encrypted.
     * </pre>
     *
     * <code>string kms_key_version_name = 7;</code>
     *
     * @param value The kmsKeyVersionName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyVersionName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKeyVersionName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The KMS key version with which data is encrypted.
     * </pre>
     *
     * <code>string kms_key_version_name = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKeyVersionName() {
      kmsKeyVersionName_ = getDefaultInstance().getKmsKeyVersionName();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The KMS key version with which data is encrypted.
     * </pre>
     *
     * <code>string kms_key_version_name = 7;</code>
     *
     * @param value The bytes for kmsKeyVersionName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyVersionNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKeyVersionName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Evaluation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Evaluation)
  private static final com.google.cloud.documentai.v1beta3.Evaluation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Evaluation();
  }

  public static com.google.cloud.documentai.v1beta3.Evaluation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Evaluation> PARSER =
      new com.google.protobuf.AbstractParser<Evaluation>() {
        @java.lang.Override
        public Evaluation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Evaluation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Evaluation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Evaluation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
