/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document_service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.documentai.v1beta3;

/** Protobuf type {@code google.cloud.documentai.v1beta3.ImportDocumentsRequest} */
public final class ImportDocumentsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.ImportDocumentsRequest)
    ImportDocumentsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportDocumentsRequest.newBuilder() to construct.
  private ImportDocumentsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportDocumentsRequest() {
    dataset_ = "";
    batchDocumentsImportConfigs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportDocumentsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
        .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
        .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.class,
            com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.Builder.class);
  }

  public interface BatchDocumentsImportConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Target dataset split where the documents must be stored.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DatasetSplitType dataset_split = 2;</code>
     *
     * @return Whether the datasetSplit field is set.
     */
    boolean hasDatasetSplit();
    /**
     *
     *
     * <pre>
     * Target dataset split where the documents must be stored.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DatasetSplitType dataset_split = 2;</code>
     *
     * @return The enum numeric value on the wire for datasetSplit.
     */
    int getDatasetSplitValue();
    /**
     *
     *
     * <pre>
     * Target dataset split where the documents must be stored.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DatasetSplitType dataset_split = 2;</code>
     *
     * @return The datasetSplit.
     */
    com.google.cloud.documentai.v1beta3.DatasetSplitType getDatasetSplit();

    /**
     *
     *
     * <pre>
     * If set, documents will be automatically split into training and test
     * split category with the specified ratio.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig auto_split_config = 3;
     * </code>
     *
     * @return Whether the autoSplitConfig field is set.
     */
    boolean hasAutoSplitConfig();
    /**
     *
     *
     * <pre>
     * If set, documents will be automatically split into training and test
     * split category with the specified ratio.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig auto_split_config = 3;
     * </code>
     *
     * @return The autoSplitConfig.
     */
    com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
            .AutoSplitConfig
        getAutoSplitConfig();
    /**
     *
     *
     * <pre>
     * If set, documents will be automatically split into training and test
     * split category with the specified ratio.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig auto_split_config = 3;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
            .AutoSplitConfigOrBuilder
        getAutoSplitConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * The common config to specify a set of documents used as input.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig batch_input_config = 1;
     * </code>
     *
     * @return Whether the batchInputConfig field is set.
     */
    boolean hasBatchInputConfig();
    /**
     *
     *
     * <pre>
     * The common config to specify a set of documents used as input.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig batch_input_config = 1;
     * </code>
     *
     * @return The batchInputConfig.
     */
    com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig getBatchInputConfig();
    /**
     *
     *
     * <pre>
     * The common config to specify a set of documents used as input.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig batch_input_config = 1;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder
        getBatchInputConfigOrBuilder();

    com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
            .SplitTypeConfigCase
        getSplitTypeConfigCase();
  }
  /**
   *
   *
   * <pre>
   * Config for importing documents.
   * Each batch can have its own dataset split type.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig}
   */
  public static final class BatchDocumentsImportConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig)
      BatchDocumentsImportConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BatchDocumentsImportConfig.newBuilder() to construct.
    private BatchDocumentsImportConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BatchDocumentsImportConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BatchDocumentsImportConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
          .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsRequest_BatchDocumentsImportConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
          .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsRequest_BatchDocumentsImportConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                  .class,
              com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                  .Builder.class);
    }

    public interface AutoSplitConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Ratio of training dataset split.
       * </pre>
       *
       * <code>float training_split_ratio = 1;</code>
       *
       * @return The trainingSplitRatio.
       */
      float getTrainingSplitRatio();
    }
    /**
     *
     *
     * <pre>
     * The config for auto-split.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig}
     */
    public static final class AutoSplitConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig)
        AutoSplitConfigOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use AutoSplitConfig.newBuilder() to construct.
      private AutoSplitConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private AutoSplitConfig() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new AutoSplitConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
            .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
            .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                    .BatchDocumentsImportConfig.AutoSplitConfig.class,
                com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                    .BatchDocumentsImportConfig.AutoSplitConfig.Builder.class);
      }

      public static final int TRAINING_SPLIT_RATIO_FIELD_NUMBER = 1;
      private float trainingSplitRatio_ = 0F;
      /**
       *
       *
       * <pre>
       * Ratio of training dataset split.
       * </pre>
       *
       * <code>float training_split_ratio = 1;</code>
       *
       * @return The trainingSplitRatio.
       */
      @java.lang.Override
      public float getTrainingSplitRatio() {
        return trainingSplitRatio_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (java.lang.Float.floatToRawIntBits(trainingSplitRatio_) != 0) {
          output.writeFloat(1, trainingSplitRatio_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (java.lang.Float.floatToRawIntBits(trainingSplitRatio_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, trainingSplitRatio_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                .AutoSplitConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                .AutoSplitConfig
            other =
                (com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                        .BatchDocumentsImportConfig.AutoSplitConfig)
                    obj;

        if (java.lang.Float.floatToIntBits(getTrainingSplitRatio())
            != java.lang.Float.floatToIntBits(other.getTrainingSplitRatio())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TRAINING_SPLIT_RATIO_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getTrainingSplitRatio());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
              .BatchDocumentsImportConfig.AutoSplitConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
              .BatchDocumentsImportConfig.AutoSplitConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
              .BatchDocumentsImportConfig.AutoSplitConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
              .BatchDocumentsImportConfig.AutoSplitConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
              .BatchDocumentsImportConfig.AutoSplitConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
              .BatchDocumentsImportConfig.AutoSplitConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
              .BatchDocumentsImportConfig.AutoSplitConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
              .BatchDocumentsImportConfig.AutoSplitConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
              .BatchDocumentsImportConfig.AutoSplitConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
              .BatchDocumentsImportConfig.AutoSplitConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
              .BatchDocumentsImportConfig.AutoSplitConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
              .BatchDocumentsImportConfig.AutoSplitConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                  .AutoSplitConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The config for auto-split.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig)
          com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
              .AutoSplitConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
              .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
              .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                      .BatchDocumentsImportConfig.AutoSplitConfig.class,
                  com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                      .BatchDocumentsImportConfig.AutoSplitConfig.Builder.class);
        }

        // Construct using
        // com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          trainingSplitRatio_ = 0F;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
              .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                .AutoSplitConfig
            getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
              .BatchDocumentsImportConfig.AutoSplitConfig.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                .AutoSplitConfig
            build() {
          com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                  .AutoSplitConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                .AutoSplitConfig
            buildPartial() {
          com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                  .AutoSplitConfig
              result =
                  new com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                      .BatchDocumentsImportConfig.AutoSplitConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                    .AutoSplitConfig
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.trainingSplitRatio_ = trainingSplitRatio_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                  .AutoSplitConfig) {
            return mergeFrom(
                (com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                        .BatchDocumentsImportConfig.AutoSplitConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                    .AutoSplitConfig
                other) {
          if (other
              == com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                  .BatchDocumentsImportConfig.AutoSplitConfig.getDefaultInstance()) return this;
          if (other.getTrainingSplitRatio() != 0F) {
            setTrainingSplitRatio(other.getTrainingSplitRatio());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 13:
                  {
                    trainingSplitRatio_ = input.readFloat();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 13
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private float trainingSplitRatio_;
        /**
         *
         *
         * <pre>
         * Ratio of training dataset split.
         * </pre>
         *
         * <code>float training_split_ratio = 1;</code>
         *
         * @return The trainingSplitRatio.
         */
        @java.lang.Override
        public float getTrainingSplitRatio() {
          return trainingSplitRatio_;
        }
        /**
         *
         *
         * <pre>
         * Ratio of training dataset split.
         * </pre>
         *
         * <code>float training_split_ratio = 1;</code>
         *
         * @param value The trainingSplitRatio to set.
         * @return This builder for chaining.
         */
        public Builder setTrainingSplitRatio(float value) {

          trainingSplitRatio_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Ratio of training dataset split.
         * </pre>
         *
         * <code>float training_split_ratio = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTrainingSplitRatio() {
          bitField0_ = (bitField0_ & ~0x00000001);
          trainingSplitRatio_ = 0F;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig)
      private static final com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
              .BatchDocumentsImportConfig.AutoSplitConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                .BatchDocumentsImportConfig.AutoSplitConfig();
      }

      public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
              .BatchDocumentsImportConfig.AutoSplitConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<AutoSplitConfig> PARSER =
          new com.google.protobuf.AbstractParser<AutoSplitConfig>() {
            @java.lang.Override
            public AutoSplitConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<AutoSplitConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<AutoSplitConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
              .AutoSplitConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    private int splitTypeConfigCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object splitTypeConfig_;

    public enum SplitTypeConfigCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      DATASET_SPLIT(2),
      AUTO_SPLIT_CONFIG(3),
      SPLITTYPECONFIG_NOT_SET(0);
      private final int value;

      private SplitTypeConfigCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SplitTypeConfigCase valueOf(int value) {
        return forNumber(value);
      }

      public static SplitTypeConfigCase forNumber(int value) {
        switch (value) {
          case 2:
            return DATASET_SPLIT;
          case 3:
            return AUTO_SPLIT_CONFIG;
          case 0:
            return SPLITTYPECONFIG_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public SplitTypeConfigCase getSplitTypeConfigCase() {
      return SplitTypeConfigCase.forNumber(splitTypeConfigCase_);
    }

    public static final int DATASET_SPLIT_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Target dataset split where the documents must be stored.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DatasetSplitType dataset_split = 2;</code>
     *
     * @return Whether the datasetSplit field is set.
     */
    public boolean hasDatasetSplit() {
      return splitTypeConfigCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Target dataset split where the documents must be stored.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DatasetSplitType dataset_split = 2;</code>
     *
     * @return The enum numeric value on the wire for datasetSplit.
     */
    public int getDatasetSplitValue() {
      if (splitTypeConfigCase_ == 2) {
        return (java.lang.Integer) splitTypeConfig_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Target dataset split where the documents must be stored.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DatasetSplitType dataset_split = 2;</code>
     *
     * @return The datasetSplit.
     */
    public com.google.cloud.documentai.v1beta3.DatasetSplitType getDatasetSplit() {
      if (splitTypeConfigCase_ == 2) {
        com.google.cloud.documentai.v1beta3.DatasetSplitType result =
            com.google.cloud.documentai.v1beta3.DatasetSplitType.forNumber(
                (java.lang.Integer) splitTypeConfig_);
        return result == null
            ? com.google.cloud.documentai.v1beta3.DatasetSplitType.UNRECOGNIZED
            : result;
      }
      return com.google.cloud.documentai.v1beta3.DatasetSplitType.DATASET_SPLIT_TYPE_UNSPECIFIED;
    }

    public static final int AUTO_SPLIT_CONFIG_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * If set, documents will be automatically split into training and test
     * split category with the specified ratio.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig auto_split_config = 3;
     * </code>
     *
     * @return Whether the autoSplitConfig field is set.
     */
    @java.lang.Override
    public boolean hasAutoSplitConfig() {
      return splitTypeConfigCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * If set, documents will be automatically split into training and test
     * split category with the specified ratio.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig auto_split_config = 3;
     * </code>
     *
     * @return The autoSplitConfig.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
            .AutoSplitConfig
        getAutoSplitConfig() {
      if (splitTypeConfigCase_ == 3) {
        return (com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                .BatchDocumentsImportConfig.AutoSplitConfig)
            splitTypeConfig_;
      }
      return com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
          .AutoSplitConfig.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * If set, documents will be automatically split into training and test
     * split category with the specified ratio.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig auto_split_config = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
            .AutoSplitConfigOrBuilder
        getAutoSplitConfigOrBuilder() {
      if (splitTypeConfigCase_ == 3) {
        return (com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                .BatchDocumentsImportConfig.AutoSplitConfig)
            splitTypeConfig_;
      }
      return com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
          .AutoSplitConfig.getDefaultInstance();
    }

    public static final int BATCH_INPUT_CONFIG_FIELD_NUMBER = 1;
    private com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig batchInputConfig_;
    /**
     *
     *
     * <pre>
     * The common config to specify a set of documents used as input.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig batch_input_config = 1;
     * </code>
     *
     * @return Whether the batchInputConfig field is set.
     */
    @java.lang.Override
    public boolean hasBatchInputConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The common config to specify a set of documents used as input.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig batch_input_config = 1;
     * </code>
     *
     * @return The batchInputConfig.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig getBatchInputConfig() {
      return batchInputConfig_ == null
          ? com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.getDefaultInstance()
          : batchInputConfig_;
    }
    /**
     *
     *
     * <pre>
     * The common config to specify a set of documents used as input.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig batch_input_config = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder
        getBatchInputConfigOrBuilder() {
      return batchInputConfig_ == null
          ? com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.getDefaultInstance()
          : batchInputConfig_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getBatchInputConfig());
      }
      if (splitTypeConfigCase_ == 2) {
        output.writeEnum(2, ((java.lang.Integer) splitTypeConfig_));
      }
      if (splitTypeConfigCase_ == 3) {
        output.writeMessage(
            3,
            (com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                    .AutoSplitConfig)
                splitTypeConfig_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getBatchInputConfig());
      }
      if (splitTypeConfigCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeEnumSize(
                2, ((java.lang.Integer) splitTypeConfig_));
      }
      if (splitTypeConfigCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3,
                (com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                        .BatchDocumentsImportConfig.AutoSplitConfig)
                    splitTypeConfig_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig other =
          (com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig)
              obj;

      if (hasBatchInputConfig() != other.hasBatchInputConfig()) return false;
      if (hasBatchInputConfig()) {
        if (!getBatchInputConfig().equals(other.getBatchInputConfig())) return false;
      }
      if (!getSplitTypeConfigCase().equals(other.getSplitTypeConfigCase())) return false;
      switch (splitTypeConfigCase_) {
        case 2:
          if (getDatasetSplitValue() != other.getDatasetSplitValue()) return false;
          break;
        case 3:
          if (!getAutoSplitConfig().equals(other.getAutoSplitConfig())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasBatchInputConfig()) {
        hash = (37 * hash) + BATCH_INPUT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getBatchInputConfig().hashCode();
      }
      switch (splitTypeConfigCase_) {
        case 2:
          hash = (37 * hash) + DATASET_SPLIT_FIELD_NUMBER;
          hash = (53 * hash) + getDatasetSplitValue();
          break;
        case 3:
          hash = (37 * hash) + AUTO_SPLIT_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getAutoSplitConfig().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
            .BatchDocumentsImportConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
            .BatchDocumentsImportConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
            .BatchDocumentsImportConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
            .BatchDocumentsImportConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
            .BatchDocumentsImportConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
            .BatchDocumentsImportConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
            .BatchDocumentsImportConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
            .BatchDocumentsImportConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
            .BatchDocumentsImportConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
            .BatchDocumentsImportConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
            .BatchDocumentsImportConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
            .BatchDocumentsImportConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Config for importing documents.
     * Each batch can have its own dataset split type.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig)
        com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
            .BatchDocumentsImportConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
            .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsRequest_BatchDocumentsImportConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
            .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsRequest_BatchDocumentsImportConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                    .BatchDocumentsImportConfig.class,
                com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                    .BatchDocumentsImportConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getBatchInputConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (autoSplitConfigBuilder_ != null) {
          autoSplitConfigBuilder_.clear();
        }
        batchInputConfig_ = null;
        if (batchInputConfigBuilder_ != null) {
          batchInputConfigBuilder_.dispose();
          batchInputConfigBuilder_ = null;
        }
        splitTypeConfigCase_ = 0;
        splitTypeConfig_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
            .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsRequest_BatchDocumentsImportConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
          build() {
        com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
          buildPartial() {
        com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
            result =
                new com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                    .BatchDocumentsImportConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
              result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.batchInputConfig_ =
              batchInputConfigBuilder_ == null
                  ? batchInputConfig_
                  : batchInputConfigBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
              result) {
        result.splitTypeConfigCase_ = splitTypeConfigCase_;
        result.splitTypeConfig_ = this.splitTypeConfig_;
        if (splitTypeConfigCase_ == 3 && autoSplitConfigBuilder_ != null) {
          result.splitTypeConfig_ = autoSplitConfigBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                      .BatchDocumentsImportConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
              other) {
        if (other
            == com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                .getDefaultInstance()) return this;
        if (other.hasBatchInputConfig()) {
          mergeBatchInputConfig(other.getBatchInputConfig());
        }
        switch (other.getSplitTypeConfigCase()) {
          case DATASET_SPLIT:
            {
              setDatasetSplitValue(other.getDatasetSplitValue());
              break;
            }
          case AUTO_SPLIT_CONFIG:
            {
              mergeAutoSplitConfig(other.getAutoSplitConfig());
              break;
            }
          case SPLITTYPECONFIG_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getBatchInputConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 10
              case 16:
                {
                  int rawValue = input.readEnum();
                  splitTypeConfigCase_ = 2;
                  splitTypeConfig_ = rawValue;
                  break;
                } // case 16
              case 26:
                {
                  input.readMessage(
                      getAutoSplitConfigFieldBuilder().getBuilder(), extensionRegistry);
                  splitTypeConfigCase_ = 3;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int splitTypeConfigCase_ = 0;
      private java.lang.Object splitTypeConfig_;

      public SplitTypeConfigCase getSplitTypeConfigCase() {
        return SplitTypeConfigCase.forNumber(splitTypeConfigCase_);
      }

      public Builder clearSplitTypeConfig() {
        splitTypeConfigCase_ = 0;
        splitTypeConfig_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Target dataset split where the documents must be stored.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.DatasetSplitType dataset_split = 2;</code>
       *
       * @return Whether the datasetSplit field is set.
       */
      @java.lang.Override
      public boolean hasDatasetSplit() {
        return splitTypeConfigCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Target dataset split where the documents must be stored.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.DatasetSplitType dataset_split = 2;</code>
       *
       * @return The enum numeric value on the wire for datasetSplit.
       */
      @java.lang.Override
      public int getDatasetSplitValue() {
        if (splitTypeConfigCase_ == 2) {
          return ((java.lang.Integer) splitTypeConfig_).intValue();
        }
        return 0;
      }
      /**
       *
       *
       * <pre>
       * Target dataset split where the documents must be stored.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.DatasetSplitType dataset_split = 2;</code>
       *
       * @param value The enum numeric value on the wire for datasetSplit to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetSplitValue(int value) {
        splitTypeConfigCase_ = 2;
        splitTypeConfig_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Target dataset split where the documents must be stored.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.DatasetSplitType dataset_split = 2;</code>
       *
       * @return The datasetSplit.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.DatasetSplitType getDatasetSplit() {
        if (splitTypeConfigCase_ == 2) {
          com.google.cloud.documentai.v1beta3.DatasetSplitType result =
              com.google.cloud.documentai.v1beta3.DatasetSplitType.forNumber(
                  (java.lang.Integer) splitTypeConfig_);
          return result == null
              ? com.google.cloud.documentai.v1beta3.DatasetSplitType.UNRECOGNIZED
              : result;
        }
        return com.google.cloud.documentai.v1beta3.DatasetSplitType.DATASET_SPLIT_TYPE_UNSPECIFIED;
      }
      /**
       *
       *
       * <pre>
       * Target dataset split where the documents must be stored.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.DatasetSplitType dataset_split = 2;</code>
       *
       * @param value The datasetSplit to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetSplit(com.google.cloud.documentai.v1beta3.DatasetSplitType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        splitTypeConfigCase_ = 2;
        splitTypeConfig_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Target dataset split where the documents must be stored.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.DatasetSplitType dataset_split = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDatasetSplit() {
        if (splitTypeConfigCase_ == 2) {
          splitTypeConfigCase_ = 0;
          splitTypeConfig_ = null;
          onChanged();
        }
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                  .AutoSplitConfig,
              com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                  .AutoSplitConfig.Builder,
              com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                  .AutoSplitConfigOrBuilder>
          autoSplitConfigBuilder_;
      /**
       *
       *
       * <pre>
       * If set, documents will be automatically split into training and test
       * split category with the specified ratio.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig auto_split_config = 3;
       * </code>
       *
       * @return Whether the autoSplitConfig field is set.
       */
      @java.lang.Override
      public boolean hasAutoSplitConfig() {
        return splitTypeConfigCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * If set, documents will be automatically split into training and test
       * split category with the specified ratio.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig auto_split_config = 3;
       * </code>
       *
       * @return The autoSplitConfig.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
              .AutoSplitConfig
          getAutoSplitConfig() {
        if (autoSplitConfigBuilder_ == null) {
          if (splitTypeConfigCase_ == 3) {
            return (com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                    .BatchDocumentsImportConfig.AutoSplitConfig)
                splitTypeConfig_;
          }
          return com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
              .BatchDocumentsImportConfig.AutoSplitConfig.getDefaultInstance();
        } else {
          if (splitTypeConfigCase_ == 3) {
            return autoSplitConfigBuilder_.getMessage();
          }
          return com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
              .BatchDocumentsImportConfig.AutoSplitConfig.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * If set, documents will be automatically split into training and test
       * split category with the specified ratio.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig auto_split_config = 3;
       * </code>
       */
      public Builder setAutoSplitConfig(
          com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                  .AutoSplitConfig
              value) {
        if (autoSplitConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          splitTypeConfig_ = value;
          onChanged();
        } else {
          autoSplitConfigBuilder_.setMessage(value);
        }
        splitTypeConfigCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, documents will be automatically split into training and test
       * split category with the specified ratio.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig auto_split_config = 3;
       * </code>
       */
      public Builder setAutoSplitConfig(
          com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                  .AutoSplitConfig.Builder
              builderForValue) {
        if (autoSplitConfigBuilder_ == null) {
          splitTypeConfig_ = builderForValue.build();
          onChanged();
        } else {
          autoSplitConfigBuilder_.setMessage(builderForValue.build());
        }
        splitTypeConfigCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, documents will be automatically split into training and test
       * split category with the specified ratio.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig auto_split_config = 3;
       * </code>
       */
      public Builder mergeAutoSplitConfig(
          com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                  .AutoSplitConfig
              value) {
        if (autoSplitConfigBuilder_ == null) {
          if (splitTypeConfigCase_ == 3
              && splitTypeConfig_
                  != com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                      .BatchDocumentsImportConfig.AutoSplitConfig.getDefaultInstance()) {
            splitTypeConfig_ =
                com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                    .BatchDocumentsImportConfig.AutoSplitConfig.newBuilder(
                        (com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                                .BatchDocumentsImportConfig.AutoSplitConfig)
                            splitTypeConfig_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            splitTypeConfig_ = value;
          }
          onChanged();
        } else {
          if (splitTypeConfigCase_ == 3) {
            autoSplitConfigBuilder_.mergeFrom(value);
          } else {
            autoSplitConfigBuilder_.setMessage(value);
          }
        }
        splitTypeConfigCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, documents will be automatically split into training and test
       * split category with the specified ratio.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig auto_split_config = 3;
       * </code>
       */
      public Builder clearAutoSplitConfig() {
        if (autoSplitConfigBuilder_ == null) {
          if (splitTypeConfigCase_ == 3) {
            splitTypeConfigCase_ = 0;
            splitTypeConfig_ = null;
            onChanged();
          }
        } else {
          if (splitTypeConfigCase_ == 3) {
            splitTypeConfigCase_ = 0;
            splitTypeConfig_ = null;
          }
          autoSplitConfigBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, documents will be automatically split into training and test
       * split category with the specified ratio.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig auto_split_config = 3;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
              .AutoSplitConfig.Builder
          getAutoSplitConfigBuilder() {
        return getAutoSplitConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If set, documents will be automatically split into training and test
       * split category with the specified ratio.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig auto_split_config = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
              .AutoSplitConfigOrBuilder
          getAutoSplitConfigOrBuilder() {
        if ((splitTypeConfigCase_ == 3) && (autoSplitConfigBuilder_ != null)) {
          return autoSplitConfigBuilder_.getMessageOrBuilder();
        } else {
          if (splitTypeConfigCase_ == 3) {
            return (com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                    .BatchDocumentsImportConfig.AutoSplitConfig)
                splitTypeConfig_;
          }
          return com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
              .BatchDocumentsImportConfig.AutoSplitConfig.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * If set, documents will be automatically split into training and test
       * split category with the specified ratio.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig auto_split_config = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                  .AutoSplitConfig,
              com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                  .AutoSplitConfig.Builder,
              com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                  .AutoSplitConfigOrBuilder>
          getAutoSplitConfigFieldBuilder() {
        if (autoSplitConfigBuilder_ == null) {
          if (!(splitTypeConfigCase_ == 3)) {
            splitTypeConfig_ =
                com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                    .BatchDocumentsImportConfig.AutoSplitConfig.getDefaultInstance();
          }
          autoSplitConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                      .BatchDocumentsImportConfig.AutoSplitConfig,
                  com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                      .BatchDocumentsImportConfig.AutoSplitConfig.Builder,
                  com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                      .BatchDocumentsImportConfig.AutoSplitConfigOrBuilder>(
                  (com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                          .BatchDocumentsImportConfig.AutoSplitConfig)
                      splitTypeConfig_,
                  getParentForChildren(),
                  isClean());
          splitTypeConfig_ = null;
        }
        splitTypeConfigCase_ = 3;
        onChanged();
        return autoSplitConfigBuilder_;
      }

      private com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig batchInputConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig,
              com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.Builder,
              com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder>
          batchInputConfigBuilder_;
      /**
       *
       *
       * <pre>
       * The common config to specify a set of documents used as input.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig batch_input_config = 1;
       * </code>
       *
       * @return Whether the batchInputConfig field is set.
       */
      public boolean hasBatchInputConfig() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The common config to specify a set of documents used as input.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig batch_input_config = 1;
       * </code>
       *
       * @return The batchInputConfig.
       */
      public com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig getBatchInputConfig() {
        if (batchInputConfigBuilder_ == null) {
          return batchInputConfig_ == null
              ? com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.getDefaultInstance()
              : batchInputConfig_;
        } else {
          return batchInputConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The common config to specify a set of documents used as input.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig batch_input_config = 1;
       * </code>
       */
      public Builder setBatchInputConfig(
          com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig value) {
        if (batchInputConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          batchInputConfig_ = value;
        } else {
          batchInputConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The common config to specify a set of documents used as input.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig batch_input_config = 1;
       * </code>
       */
      public Builder setBatchInputConfig(
          com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.Builder builderForValue) {
        if (batchInputConfigBuilder_ == null) {
          batchInputConfig_ = builderForValue.build();
        } else {
          batchInputConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The common config to specify a set of documents used as input.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig batch_input_config = 1;
       * </code>
       */
      public Builder mergeBatchInputConfig(
          com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig value) {
        if (batchInputConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && batchInputConfig_ != null
              && batchInputConfig_
                  != com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig
                      .getDefaultInstance()) {
            getBatchInputConfigBuilder().mergeFrom(value);
          } else {
            batchInputConfig_ = value;
          }
        } else {
          batchInputConfigBuilder_.mergeFrom(value);
        }
        if (batchInputConfig_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The common config to specify a set of documents used as input.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig batch_input_config = 1;
       * </code>
       */
      public Builder clearBatchInputConfig() {
        bitField0_ = (bitField0_ & ~0x00000004);
        batchInputConfig_ = null;
        if (batchInputConfigBuilder_ != null) {
          batchInputConfigBuilder_.dispose();
          batchInputConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The common config to specify a set of documents used as input.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig batch_input_config = 1;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.Builder
          getBatchInputConfigBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getBatchInputConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The common config to specify a set of documents used as input.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig batch_input_config = 1;
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder
          getBatchInputConfigOrBuilder() {
        if (batchInputConfigBuilder_ != null) {
          return batchInputConfigBuilder_.getMessageOrBuilder();
        } else {
          return batchInputConfig_ == null
              ? com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.getDefaultInstance()
              : batchInputConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * The common config to specify a set of documents used as input.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig batch_input_config = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig,
              com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.Builder,
              com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder>
          getBatchInputConfigFieldBuilder() {
        if (batchInputConfigBuilder_ == null) {
          batchInputConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig,
                  com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfig.Builder,
                  com.google.cloud.documentai.v1beta3.BatchDocumentsInputConfigOrBuilder>(
                  getBatchInputConfig(), getParentForChildren(), isClean());
          batchInputConfig_ = null;
        }
        return batchInputConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig)
    private static final com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
            .BatchDocumentsImportConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
              .BatchDocumentsImportConfig();
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
            .BatchDocumentsImportConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BatchDocumentsImportConfig> PARSER =
        new com.google.protobuf.AbstractParser<BatchDocumentsImportConfig>() {
          @java.lang.Override
          public BatchDocumentsImportConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BatchDocumentsImportConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BatchDocumentsImportConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int DATASET_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataset_ = "";
  /**
   *
   *
   * <pre>
   * Required. The dataset resource name.
   * Format:
   * projects/{project}/locations/{location}/processors/{processor}/dataset
   * </pre>
   *
   * <code>
   * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The dataset.
   */
  @java.lang.Override
  public java.lang.String getDataset() {
    java.lang.Object ref = dataset_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataset_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The dataset resource name.
   * Format:
   * projects/{project}/locations/{location}/processors/{processor}/dataset
   * </pre>
   *
   * <code>
   * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for dataset.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatasetBytes() {
    java.lang.Object ref = dataset_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataset_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BATCH_DOCUMENTS_IMPORT_CONFIGS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig>
      batchDocumentsImportConfigs_;
  /**
   *
   *
   * <pre>
   * Required. The Cloud Storage uri containing raw documents that must be
   * imported.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig>
      getBatchDocumentsImportConfigsList() {
    return batchDocumentsImportConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Required. The Cloud Storage uri containing raw documents that must be
   * imported.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                  .BatchDocumentsImportConfigOrBuilder>
      getBatchDocumentsImportConfigsOrBuilderList() {
    return batchDocumentsImportConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Required. The Cloud Storage uri containing raw documents that must be
   * imported.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getBatchDocumentsImportConfigsCount() {
    return batchDocumentsImportConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The Cloud Storage uri containing raw documents that must be
   * imported.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
      getBatchDocumentsImportConfigs(int index) {
    return batchDocumentsImportConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The Cloud Storage uri containing raw documents that must be
   * imported.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
          .BatchDocumentsImportConfigOrBuilder
      getBatchDocumentsImportConfigsOrBuilder(int index) {
    return batchDocumentsImportConfigs_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataset_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dataset_);
    }
    for (int i = 0; i < batchDocumentsImportConfigs_.size(); i++) {
      output.writeMessage(4, batchDocumentsImportConfigs_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataset_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dataset_);
    }
    for (int i = 0; i < batchDocumentsImportConfigs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, batchDocumentsImportConfigs_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.ImportDocumentsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.ImportDocumentsRequest other =
        (com.google.cloud.documentai.v1beta3.ImportDocumentsRequest) obj;

    if (!getDataset().equals(other.getDataset())) return false;
    if (!getBatchDocumentsImportConfigsList().equals(other.getBatchDocumentsImportConfigsList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATASET_FIELD_NUMBER;
    hash = (53 * hash) + getDataset().hashCode();
    if (getBatchDocumentsImportConfigsCount() > 0) {
      hash = (37 * hash) + BATCH_DOCUMENTS_IMPORT_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getBatchDocumentsImportConfigsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.documentai.v1beta3.ImportDocumentsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /** Protobuf type {@code google.cloud.documentai.v1beta3.ImportDocumentsRequest} */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.ImportDocumentsRequest)
      com.google.cloud.documentai.v1beta3.ImportDocumentsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
          .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
          .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.class,
              com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      dataset_ = "";
      if (batchDocumentsImportConfigsBuilder_ == null) {
        batchDocumentsImportConfigs_ = java.util.Collections.emptyList();
      } else {
        batchDocumentsImportConfigs_ = null;
        batchDocumentsImportConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
          .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest build() {
      com.google.cloud.documentai.v1beta3.ImportDocumentsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest buildPartial() {
      com.google.cloud.documentai.v1beta3.ImportDocumentsRequest result =
          new com.google.cloud.documentai.v1beta3.ImportDocumentsRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.documentai.v1beta3.ImportDocumentsRequest result) {
      if (batchDocumentsImportConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          batchDocumentsImportConfigs_ =
              java.util.Collections.unmodifiableList(batchDocumentsImportConfigs_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.batchDocumentsImportConfigs_ = batchDocumentsImportConfigs_;
      } else {
        result.batchDocumentsImportConfigs_ = batchDocumentsImportConfigsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta3.ImportDocumentsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.dataset_ = dataset_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.ImportDocumentsRequest) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.ImportDocumentsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.ImportDocumentsRequest other) {
      if (other == com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.getDefaultInstance())
        return this;
      if (!other.getDataset().isEmpty()) {
        dataset_ = other.dataset_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (batchDocumentsImportConfigsBuilder_ == null) {
        if (!other.batchDocumentsImportConfigs_.isEmpty()) {
          if (batchDocumentsImportConfigs_.isEmpty()) {
            batchDocumentsImportConfigs_ = other.batchDocumentsImportConfigs_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureBatchDocumentsImportConfigsIsMutable();
            batchDocumentsImportConfigs_.addAll(other.batchDocumentsImportConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.batchDocumentsImportConfigs_.isEmpty()) {
          if (batchDocumentsImportConfigsBuilder_.isEmpty()) {
            batchDocumentsImportConfigsBuilder_.dispose();
            batchDocumentsImportConfigsBuilder_ = null;
            batchDocumentsImportConfigs_ = other.batchDocumentsImportConfigs_;
            bitField0_ = (bitField0_ & ~0x00000002);
            batchDocumentsImportConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBatchDocumentsImportConfigsFieldBuilder()
                    : null;
          } else {
            batchDocumentsImportConfigsBuilder_.addAllMessages(other.batchDocumentsImportConfigs_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                dataset_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 34:
              {
                com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                        .BatchDocumentsImportConfig
                    m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                                .BatchDocumentsImportConfig.parser(),
                            extensionRegistry);
                if (batchDocumentsImportConfigsBuilder_ == null) {
                  ensureBatchDocumentsImportConfigsIsMutable();
                  batchDocumentsImportConfigs_.add(m);
                } else {
                  batchDocumentsImportConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object dataset_ = "";
    /**
     *
     *
     * <pre>
     * Required. The dataset resource name.
     * Format:
     * projects/{project}/locations/{location}/processors/{processor}/dataset
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataset.
     */
    public java.lang.String getDataset() {
      java.lang.Object ref = dataset_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataset_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The dataset resource name.
     * Format:
     * projects/{project}/locations/{location}/processors/{processor}/dataset
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataset.
     */
    public com.google.protobuf.ByteString getDatasetBytes() {
      java.lang.Object ref = dataset_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataset_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The dataset resource name.
     * Format:
     * projects/{project}/locations/{location}/processors/{processor}/dataset
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The dataset to set.
     * @return This builder for chaining.
     */
    public Builder setDataset(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataset_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The dataset resource name.
     * Format:
     * projects/{project}/locations/{location}/processors/{processor}/dataset
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataset() {
      dataset_ = getDefaultInstance().getDataset();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The dataset resource name.
     * Format:
     * projects/{project}/locations/{location}/processors/{processor}/dataset
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for dataset to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataset_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig>
        batchDocumentsImportConfigs_ = java.util.Collections.emptyList();

    private void ensureBatchDocumentsImportConfigsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        batchDocumentsImportConfigs_ =
            new java.util.ArrayList<
                com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                    .BatchDocumentsImportConfig>(batchDocumentsImportConfigs_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig,
            com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                .Builder,
            com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                .BatchDocumentsImportConfigOrBuilder>
        batchDocumentsImportConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage uri containing raw documents that must be
     * imported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig>
        getBatchDocumentsImportConfigsList() {
      if (batchDocumentsImportConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(batchDocumentsImportConfigs_);
      } else {
        return batchDocumentsImportConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage uri containing raw documents that must be
     * imported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getBatchDocumentsImportConfigsCount() {
      if (batchDocumentsImportConfigsBuilder_ == null) {
        return batchDocumentsImportConfigs_.size();
      } else {
        return batchDocumentsImportConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage uri containing raw documents that must be
     * imported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
        getBatchDocumentsImportConfigs(int index) {
      if (batchDocumentsImportConfigsBuilder_ == null) {
        return batchDocumentsImportConfigs_.get(index);
      } else {
        return batchDocumentsImportConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage uri containing raw documents that must be
     * imported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setBatchDocumentsImportConfigs(
        int index,
        com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
            value) {
      if (batchDocumentsImportConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBatchDocumentsImportConfigsIsMutable();
        batchDocumentsImportConfigs_.set(index, value);
        onChanged();
      } else {
        batchDocumentsImportConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage uri containing raw documents that must be
     * imported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setBatchDocumentsImportConfigs(
        int index,
        com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                .Builder
            builderForValue) {
      if (batchDocumentsImportConfigsBuilder_ == null) {
        ensureBatchDocumentsImportConfigsIsMutable();
        batchDocumentsImportConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        batchDocumentsImportConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage uri containing raw documents that must be
     * imported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addBatchDocumentsImportConfigs(
        com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
            value) {
      if (batchDocumentsImportConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBatchDocumentsImportConfigsIsMutable();
        batchDocumentsImportConfigs_.add(value);
        onChanged();
      } else {
        batchDocumentsImportConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage uri containing raw documents that must be
     * imported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addBatchDocumentsImportConfigs(
        int index,
        com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
            value) {
      if (batchDocumentsImportConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBatchDocumentsImportConfigsIsMutable();
        batchDocumentsImportConfigs_.add(index, value);
        onChanged();
      } else {
        batchDocumentsImportConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage uri containing raw documents that must be
     * imported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addBatchDocumentsImportConfigs(
        com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                .Builder
            builderForValue) {
      if (batchDocumentsImportConfigsBuilder_ == null) {
        ensureBatchDocumentsImportConfigsIsMutable();
        batchDocumentsImportConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        batchDocumentsImportConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage uri containing raw documents that must be
     * imported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addBatchDocumentsImportConfigs(
        int index,
        com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                .Builder
            builderForValue) {
      if (batchDocumentsImportConfigsBuilder_ == null) {
        ensureBatchDocumentsImportConfigsIsMutable();
        batchDocumentsImportConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        batchDocumentsImportConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage uri containing raw documents that must be
     * imported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllBatchDocumentsImportConfigs(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                        .BatchDocumentsImportConfig>
            values) {
      if (batchDocumentsImportConfigsBuilder_ == null) {
        ensureBatchDocumentsImportConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, batchDocumentsImportConfigs_);
        onChanged();
      } else {
        batchDocumentsImportConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage uri containing raw documents that must be
     * imported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearBatchDocumentsImportConfigs() {
      if (batchDocumentsImportConfigsBuilder_ == null) {
        batchDocumentsImportConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        batchDocumentsImportConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage uri containing raw documents that must be
     * imported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeBatchDocumentsImportConfigs(int index) {
      if (batchDocumentsImportConfigsBuilder_ == null) {
        ensureBatchDocumentsImportConfigsIsMutable();
        batchDocumentsImportConfigs_.remove(index);
        onChanged();
      } else {
        batchDocumentsImportConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage uri containing raw documents that must be
     * imported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
            .Builder
        getBatchDocumentsImportConfigsBuilder(int index) {
      return getBatchDocumentsImportConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage uri containing raw documents that must be
     * imported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
            .BatchDocumentsImportConfigOrBuilder
        getBatchDocumentsImportConfigsOrBuilder(int index) {
      if (batchDocumentsImportConfigsBuilder_ == null) {
        return batchDocumentsImportConfigs_.get(index);
      } else {
        return batchDocumentsImportConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage uri containing raw documents that must be
     * imported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                    .BatchDocumentsImportConfigOrBuilder>
        getBatchDocumentsImportConfigsOrBuilderList() {
      if (batchDocumentsImportConfigsBuilder_ != null) {
        return batchDocumentsImportConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(batchDocumentsImportConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage uri containing raw documents that must be
     * imported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
            .Builder
        addBatchDocumentsImportConfigsBuilder() {
      return getBatchDocumentsImportConfigsFieldBuilder()
          .addBuilder(
              com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage uri containing raw documents that must be
     * imported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
            .Builder
        addBatchDocumentsImportConfigsBuilder(int index) {
      return getBatchDocumentsImportConfigsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage uri containing raw documents that must be
     * imported.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig batch_documents_import_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                .Builder>
        getBatchDocumentsImportConfigsBuilderList() {
      return getBatchDocumentsImportConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig,
            com.google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
                .Builder,
            com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                .BatchDocumentsImportConfigOrBuilder>
        getBatchDocumentsImportConfigsFieldBuilder() {
      if (batchDocumentsImportConfigsBuilder_ == null) {
        batchDocumentsImportConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                    .BatchDocumentsImportConfig,
                com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                    .BatchDocumentsImportConfig.Builder,
                com.google.cloud.documentai.v1beta3.ImportDocumentsRequest
                    .BatchDocumentsImportConfigOrBuilder>(
                batchDocumentsImportConfigs_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        batchDocumentsImportConfigs_ = null;
      }
      return batchDocumentsImportConfigsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.ImportDocumentsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.ImportDocumentsRequest)
  private static final com.google.cloud.documentai.v1beta3.ImportDocumentsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.ImportDocumentsRequest();
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportDocumentsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ImportDocumentsRequest>() {
        @java.lang.Override
        public ImportDocumentsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportDocumentsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportDocumentsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ImportDocumentsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
