/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document_service.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * Metadata about a document.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.DocumentMetadata}
 */
public final class DocumentMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.DocumentMetadata)
    DocumentMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DocumentMetadata.newBuilder() to construct.
  private DocumentMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DocumentMetadata() {
    datasetType_ = 0;
    labelingState_ = 0;
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DocumentMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
        .internal_static_google_cloud_documentai_v1beta3_DocumentMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
        .internal_static_google_cloud_documentai_v1beta3_DocumentMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.DocumentMetadata.class,
            com.google.cloud.documentai.v1beta3.DocumentMetadata.Builder.class);
  }

  private int bitField0_;
  public static final int DOCUMENT_ID_FIELD_NUMBER = 1;
  private com.google.cloud.documentai.v1beta3.DocumentId documentId_;
  /**
   *
   *
   * <pre>
   * Document identifier.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentId document_id = 1;</code>
   *
   * @return Whether the documentId field is set.
   */
  @java.lang.Override
  public boolean hasDocumentId() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Document identifier.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentId document_id = 1;</code>
   *
   * @return The documentId.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentId getDocumentId() {
    return documentId_ == null
        ? com.google.cloud.documentai.v1beta3.DocumentId.getDefaultInstance()
        : documentId_;
  }
  /**
   *
   *
   * <pre>
   * Document identifier.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentId document_id = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder getDocumentIdOrBuilder() {
    return documentId_ == null
        ? com.google.cloud.documentai.v1beta3.DocumentId.getDefaultInstance()
        : documentId_;
  }

  public static final int PAGE_COUNT_FIELD_NUMBER = 2;
  private int pageCount_ = 0;
  /**
   *
   *
   * <pre>
   * Number of pages in the document.
   * </pre>
   *
   * <code>int32 page_count = 2;</code>
   *
   * @return The pageCount.
   */
  @java.lang.Override
  public int getPageCount() {
    return pageCount_;
  }

  public static final int DATASET_TYPE_FIELD_NUMBER = 3;
  private int datasetType_ = 0;
  /**
   *
   *
   * <pre>
   * Type of the dataset split to which the document belongs.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DatasetSplitType dataset_type = 3;</code>
   *
   * @return The enum numeric value on the wire for datasetType.
   */
  @java.lang.Override
  public int getDatasetTypeValue() {
    return datasetType_;
  }
  /**
   *
   *
   * <pre>
   * Type of the dataset split to which the document belongs.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DatasetSplitType dataset_type = 3;</code>
   *
   * @return The datasetType.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DatasetSplitType getDatasetType() {
    com.google.cloud.documentai.v1beta3.DatasetSplitType result =
        com.google.cloud.documentai.v1beta3.DatasetSplitType.forNumber(datasetType_);
    return result == null
        ? com.google.cloud.documentai.v1beta3.DatasetSplitType.UNRECOGNIZED
        : result;
  }

  public static final int LABELING_STATE_FIELD_NUMBER = 5;
  private int labelingState_ = 0;
  /**
   *
   *
   * <pre>
   * Labeling state of the document.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentLabelingState labeling_state = 5;</code>
   *
   * @return The enum numeric value on the wire for labelingState.
   */
  @java.lang.Override
  public int getLabelingStateValue() {
    return labelingState_;
  }
  /**
   *
   *
   * <pre>
   * Labeling state of the document.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentLabelingState labeling_state = 5;</code>
   *
   * @return The labelingState.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentLabelingState getLabelingState() {
    com.google.cloud.documentai.v1beta3.DocumentLabelingState result =
        com.google.cloud.documentai.v1beta3.DocumentLabelingState.forNumber(labelingState_);
    return result == null
        ? com.google.cloud.documentai.v1beta3.DocumentLabelingState.UNRECOGNIZED
        : result;
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The display name of the document.
   * </pre>
   *
   * <code>string display_name = 6;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of the document.
   * </pre>
   *
   * <code>string display_name = 6;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getDocumentId());
    }
    if (pageCount_ != 0) {
      output.writeInt32(2, pageCount_);
    }
    if (datasetType_
        != com.google.cloud.documentai.v1beta3.DatasetSplitType.DATASET_SPLIT_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, datasetType_);
    }
    if (labelingState_
        != com.google.cloud.documentai.v1beta3.DocumentLabelingState
            .DOCUMENT_LABELING_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, labelingState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, displayName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDocumentId());
    }
    if (pageCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, pageCount_);
    }
    if (datasetType_
        != com.google.cloud.documentai.v1beta3.DatasetSplitType.DATASET_SPLIT_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, datasetType_);
    }
    if (labelingState_
        != com.google.cloud.documentai.v1beta3.DocumentLabelingState
            .DOCUMENT_LABELING_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, labelingState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, displayName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.DocumentMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.DocumentMetadata other =
        (com.google.cloud.documentai.v1beta3.DocumentMetadata) obj;

    if (hasDocumentId() != other.hasDocumentId()) return false;
    if (hasDocumentId()) {
      if (!getDocumentId().equals(other.getDocumentId())) return false;
    }
    if (getPageCount() != other.getPageCount()) return false;
    if (datasetType_ != other.datasetType_) return false;
    if (labelingState_ != other.labelingState_) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDocumentId()) {
      hash = (37 * hash) + DOCUMENT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentId().hashCode();
    }
    hash = (37 * hash) + PAGE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getPageCount();
    hash = (37 * hash) + DATASET_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + datasetType_;
    hash = (37 * hash) + LABELING_STATE_FIELD_NUMBER;
    hash = (53 * hash) + labelingState_;
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.DocumentMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.documentai.v1beta3.DocumentMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata about a document.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.DocumentMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.DocumentMetadata)
      com.google.cloud.documentai.v1beta3.DocumentMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
          .internal_static_google_cloud_documentai_v1beta3_DocumentMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
          .internal_static_google_cloud_documentai_v1beta3_DocumentMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.DocumentMetadata.class,
              com.google.cloud.documentai.v1beta3.DocumentMetadata.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.DocumentMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDocumentIdFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      documentId_ = null;
      if (documentIdBuilder_ != null) {
        documentIdBuilder_.dispose();
        documentIdBuilder_ = null;
      }
      pageCount_ = 0;
      datasetType_ = 0;
      labelingState_ = 0;
      displayName_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
          .internal_static_google_cloud_documentai_v1beta3_DocumentMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentMetadata getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.DocumentMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentMetadata build() {
      com.google.cloud.documentai.v1beta3.DocumentMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentMetadata buildPartial() {
      com.google.cloud.documentai.v1beta3.DocumentMetadata result =
          new com.google.cloud.documentai.v1beta3.DocumentMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta3.DocumentMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.documentId_ = documentIdBuilder_ == null ? documentId_ : documentIdBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.pageCount_ = pageCount_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.datasetType_ = datasetType_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labelingState_ = labelingState_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.displayName_ = displayName_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.DocumentMetadata) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.DocumentMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.DocumentMetadata other) {
      if (other == com.google.cloud.documentai.v1beta3.DocumentMetadata.getDefaultInstance())
        return this;
      if (other.hasDocumentId()) {
        mergeDocumentId(other.getDocumentId());
      }
      if (other.getPageCount() != 0) {
        setPageCount(other.getPageCount());
      }
      if (other.datasetType_ != 0) {
        setDatasetTypeValue(other.getDatasetTypeValue());
      }
      if (other.labelingState_ != 0) {
        setLabelingStateValue(other.getLabelingStateValue());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getDocumentIdFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                pageCount_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                datasetType_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 40:
              {
                labelingState_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            case 50:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.documentai.v1beta3.DocumentId documentId_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentId,
            com.google.cloud.documentai.v1beta3.DocumentId.Builder,
            com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder>
        documentIdBuilder_;
    /**
     *
     *
     * <pre>
     * Document identifier.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId document_id = 1;</code>
     *
     * @return Whether the documentId field is set.
     */
    public boolean hasDocumentId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Document identifier.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId document_id = 1;</code>
     *
     * @return The documentId.
     */
    public com.google.cloud.documentai.v1beta3.DocumentId getDocumentId() {
      if (documentIdBuilder_ == null) {
        return documentId_ == null
            ? com.google.cloud.documentai.v1beta3.DocumentId.getDefaultInstance()
            : documentId_;
      } else {
        return documentIdBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Document identifier.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId document_id = 1;</code>
     */
    public Builder setDocumentId(com.google.cloud.documentai.v1beta3.DocumentId value) {
      if (documentIdBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentId_ = value;
      } else {
        documentIdBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Document identifier.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId document_id = 1;</code>
     */
    public Builder setDocumentId(
        com.google.cloud.documentai.v1beta3.DocumentId.Builder builderForValue) {
      if (documentIdBuilder_ == null) {
        documentId_ = builderForValue.build();
      } else {
        documentIdBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Document identifier.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId document_id = 1;</code>
     */
    public Builder mergeDocumentId(com.google.cloud.documentai.v1beta3.DocumentId value) {
      if (documentIdBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && documentId_ != null
            && documentId_ != com.google.cloud.documentai.v1beta3.DocumentId.getDefaultInstance()) {
          getDocumentIdBuilder().mergeFrom(value);
        } else {
          documentId_ = value;
        }
      } else {
        documentIdBuilder_.mergeFrom(value);
      }
      if (documentId_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Document identifier.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId document_id = 1;</code>
     */
    public Builder clearDocumentId() {
      bitField0_ = (bitField0_ & ~0x00000001);
      documentId_ = null;
      if (documentIdBuilder_ != null) {
        documentIdBuilder_.dispose();
        documentIdBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Document identifier.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId document_id = 1;</code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentId.Builder getDocumentIdBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getDocumentIdFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Document identifier.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId document_id = 1;</code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder getDocumentIdOrBuilder() {
      if (documentIdBuilder_ != null) {
        return documentIdBuilder_.getMessageOrBuilder();
      } else {
        return documentId_ == null
            ? com.google.cloud.documentai.v1beta3.DocumentId.getDefaultInstance()
            : documentId_;
      }
    }
    /**
     *
     *
     * <pre>
     * Document identifier.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId document_id = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentId,
            com.google.cloud.documentai.v1beta3.DocumentId.Builder,
            com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder>
        getDocumentIdFieldBuilder() {
      if (documentIdBuilder_ == null) {
        documentIdBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.DocumentId,
                com.google.cloud.documentai.v1beta3.DocumentId.Builder,
                com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder>(
                getDocumentId(), getParentForChildren(), isClean());
        documentId_ = null;
      }
      return documentIdBuilder_;
    }

    private int pageCount_;
    /**
     *
     *
     * <pre>
     * Number of pages in the document.
     * </pre>
     *
     * <code>int32 page_count = 2;</code>
     *
     * @return The pageCount.
     */
    @java.lang.Override
    public int getPageCount() {
      return pageCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of pages in the document.
     * </pre>
     *
     * <code>int32 page_count = 2;</code>
     *
     * @param value The pageCount to set.
     * @return This builder for chaining.
     */
    public Builder setPageCount(int value) {

      pageCount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of pages in the document.
     * </pre>
     *
     * <code>int32 page_count = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageCount() {
      bitField0_ = (bitField0_ & ~0x00000002);
      pageCount_ = 0;
      onChanged();
      return this;
    }

    private int datasetType_ = 0;
    /**
     *
     *
     * <pre>
     * Type of the dataset split to which the document belongs.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DatasetSplitType dataset_type = 3;</code>
     *
     * @return The enum numeric value on the wire for datasetType.
     */
    @java.lang.Override
    public int getDatasetTypeValue() {
      return datasetType_;
    }
    /**
     *
     *
     * <pre>
     * Type of the dataset split to which the document belongs.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DatasetSplitType dataset_type = 3;</code>
     *
     * @param value The enum numeric value on the wire for datasetType to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetTypeValue(int value) {
      datasetType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the dataset split to which the document belongs.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DatasetSplitType dataset_type = 3;</code>
     *
     * @return The datasetType.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DatasetSplitType getDatasetType() {
      com.google.cloud.documentai.v1beta3.DatasetSplitType result =
          com.google.cloud.documentai.v1beta3.DatasetSplitType.forNumber(datasetType_);
      return result == null
          ? com.google.cloud.documentai.v1beta3.DatasetSplitType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Type of the dataset split to which the document belongs.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DatasetSplitType dataset_type = 3;</code>
     *
     * @param value The datasetType to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetType(com.google.cloud.documentai.v1beta3.DatasetSplitType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      datasetType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the dataset split to which the document belongs.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DatasetSplitType dataset_type = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatasetType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      datasetType_ = 0;
      onChanged();
      return this;
    }

    private int labelingState_ = 0;
    /**
     *
     *
     * <pre>
     * Labeling state of the document.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentLabelingState labeling_state = 5;</code>
     *
     * @return The enum numeric value on the wire for labelingState.
     */
    @java.lang.Override
    public int getLabelingStateValue() {
      return labelingState_;
    }
    /**
     *
     *
     * <pre>
     * Labeling state of the document.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentLabelingState labeling_state = 5;</code>
     *
     * @param value The enum numeric value on the wire for labelingState to set.
     * @return This builder for chaining.
     */
    public Builder setLabelingStateValue(int value) {
      labelingState_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labeling state of the document.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentLabelingState labeling_state = 5;</code>
     *
     * @return The labelingState.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentLabelingState getLabelingState() {
      com.google.cloud.documentai.v1beta3.DocumentLabelingState result =
          com.google.cloud.documentai.v1beta3.DocumentLabelingState.forNumber(labelingState_);
      return result == null
          ? com.google.cloud.documentai.v1beta3.DocumentLabelingState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Labeling state of the document.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentLabelingState labeling_state = 5;</code>
     *
     * @param value The labelingState to set.
     * @return This builder for chaining.
     */
    public Builder setLabelingState(
        com.google.cloud.documentai.v1beta3.DocumentLabelingState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      labelingState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labeling state of the document.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentLabelingState labeling_state = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabelingState() {
      bitField0_ = (bitField0_ & ~0x00000008);
      labelingState_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the document.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the document.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the document.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the document.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the document.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.DocumentMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.DocumentMetadata)
  private static final com.google.cloud.documentai.v1beta3.DocumentMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.DocumentMetadata();
  }

  public static com.google.cloud.documentai.v1beta3.DocumentMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DocumentMetadata> PARSER =
      new com.google.protobuf.AbstractParser<DocumentMetadata>() {
        @java.lang.Override
        public DocumentMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DocumentMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DocumentMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
