/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document_io.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * Config for Document OCR.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.OcrConfig}
 */
public final class OcrConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.OcrConfig)
    OcrConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OcrConfig.newBuilder() to construct.
  private OcrConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OcrConfig() {
    advancedOcrOptions_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OcrConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentIoProto
        .internal_static_google_cloud_documentai_v1beta3_OcrConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentIoProto
        .internal_static_google_cloud_documentai_v1beta3_OcrConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.OcrConfig.class,
            com.google.cloud.documentai.v1beta3.OcrConfig.Builder.class);
  }

  public interface HintsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.OcrConfig.Hints)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * List of BCP-47 language codes to use for OCR. In most cases, not
     * specifying it yields the best results since it enables automatic language
     * detection. For languages based on the Latin alphabet, setting hints is
     * not needed. In rare cases, when the language of the text in the
     * image is known, setting a hint will help get better results (although it
     * will be a significant hindrance if the hint is wrong).
     * </pre>
     *
     * <code>repeated string language_hints = 1;</code>
     *
     * @return A list containing the languageHints.
     */
    java.util.List<java.lang.String> getLanguageHintsList();
    /**
     *
     *
     * <pre>
     * List of BCP-47 language codes to use for OCR. In most cases, not
     * specifying it yields the best results since it enables automatic language
     * detection. For languages based on the Latin alphabet, setting hints is
     * not needed. In rare cases, when the language of the text in the
     * image is known, setting a hint will help get better results (although it
     * will be a significant hindrance if the hint is wrong).
     * </pre>
     *
     * <code>repeated string language_hints = 1;</code>
     *
     * @return The count of languageHints.
     */
    int getLanguageHintsCount();
    /**
     *
     *
     * <pre>
     * List of BCP-47 language codes to use for OCR. In most cases, not
     * specifying it yields the best results since it enables automatic language
     * detection. For languages based on the Latin alphabet, setting hints is
     * not needed. In rare cases, when the language of the text in the
     * image is known, setting a hint will help get better results (although it
     * will be a significant hindrance if the hint is wrong).
     * </pre>
     *
     * <code>repeated string language_hints = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The languageHints at the given index.
     */
    java.lang.String getLanguageHints(int index);
    /**
     *
     *
     * <pre>
     * List of BCP-47 language codes to use for OCR. In most cases, not
     * specifying it yields the best results since it enables automatic language
     * detection. For languages based on the Latin alphabet, setting hints is
     * not needed. In rare cases, when the language of the text in the
     * image is known, setting a hint will help get better results (although it
     * will be a significant hindrance if the hint is wrong).
     * </pre>
     *
     * <code>repeated string language_hints = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the languageHints at the given index.
     */
    com.google.protobuf.ByteString getLanguageHintsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Hints for OCR Engine
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.OcrConfig.Hints}
   */
  public static final class Hints extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.OcrConfig.Hints)
      HintsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Hints.newBuilder() to construct.
    private Hints(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Hints() {
      languageHints_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Hints();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentIoProto
          .internal_static_google_cloud_documentai_v1beta3_OcrConfig_Hints_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentIoProto
          .internal_static_google_cloud_documentai_v1beta3_OcrConfig_Hints_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.OcrConfig.Hints.class,
              com.google.cloud.documentai.v1beta3.OcrConfig.Hints.Builder.class);
    }

    public static final int LANGUAGE_HINTS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList languageHints_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * List of BCP-47 language codes to use for OCR. In most cases, not
     * specifying it yields the best results since it enables automatic language
     * detection. For languages based on the Latin alphabet, setting hints is
     * not needed. In rare cases, when the language of the text in the
     * image is known, setting a hint will help get better results (although it
     * will be a significant hindrance if the hint is wrong).
     * </pre>
     *
     * <code>repeated string language_hints = 1;</code>
     *
     * @return A list containing the languageHints.
     */
    public com.google.protobuf.ProtocolStringList getLanguageHintsList() {
      return languageHints_;
    }
    /**
     *
     *
     * <pre>
     * List of BCP-47 language codes to use for OCR. In most cases, not
     * specifying it yields the best results since it enables automatic language
     * detection. For languages based on the Latin alphabet, setting hints is
     * not needed. In rare cases, when the language of the text in the
     * image is known, setting a hint will help get better results (although it
     * will be a significant hindrance if the hint is wrong).
     * </pre>
     *
     * <code>repeated string language_hints = 1;</code>
     *
     * @return The count of languageHints.
     */
    public int getLanguageHintsCount() {
      return languageHints_.size();
    }
    /**
     *
     *
     * <pre>
     * List of BCP-47 language codes to use for OCR. In most cases, not
     * specifying it yields the best results since it enables automatic language
     * detection. For languages based on the Latin alphabet, setting hints is
     * not needed. In rare cases, when the language of the text in the
     * image is known, setting a hint will help get better results (although it
     * will be a significant hindrance if the hint is wrong).
     * </pre>
     *
     * <code>repeated string language_hints = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The languageHints at the given index.
     */
    public java.lang.String getLanguageHints(int index) {
      return languageHints_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of BCP-47 language codes to use for OCR. In most cases, not
     * specifying it yields the best results since it enables automatic language
     * detection. For languages based on the Latin alphabet, setting hints is
     * not needed. In rare cases, when the language of the text in the
     * image is known, setting a hint will help get better results (although it
     * will be a significant hindrance if the hint is wrong).
     * </pre>
     *
     * <code>repeated string language_hints = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the languageHints at the given index.
     */
    public com.google.protobuf.ByteString getLanguageHintsBytes(int index) {
      return languageHints_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < languageHints_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, languageHints_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < languageHints_.size(); i++) {
          dataSize += computeStringSizeNoTag(languageHints_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getLanguageHintsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta3.OcrConfig.Hints)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.OcrConfig.Hints other =
          (com.google.cloud.documentai.v1beta3.OcrConfig.Hints) obj;

      if (!getLanguageHintsList().equals(other.getLanguageHintsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getLanguageHintsCount() > 0) {
        hash = (37 * hash) + LANGUAGE_HINTS_FIELD_NUMBER;
        hash = (53 * hash) + getLanguageHintsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.Hints parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.Hints parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.Hints parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.Hints parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.Hints parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.Hints parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.Hints parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.Hints parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.Hints parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.Hints parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.Hints parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.Hints parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.OcrConfig.Hints prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Hints for OCR Engine
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.OcrConfig.Hints}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.OcrConfig.Hints)
        com.google.cloud.documentai.v1beta3.OcrConfig.HintsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentIoProto
            .internal_static_google_cloud_documentai_v1beta3_OcrConfig_Hints_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentIoProto
            .internal_static_google_cloud_documentai_v1beta3_OcrConfig_Hints_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.OcrConfig.Hints.class,
                com.google.cloud.documentai.v1beta3.OcrConfig.Hints.Builder.class);
      }

      // Construct using com.google.cloud.documentai.v1beta3.OcrConfig.Hints.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        languageHints_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentIoProto
            .internal_static_google_cloud_documentai_v1beta3_OcrConfig_Hints_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.OcrConfig.Hints getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.OcrConfig.Hints.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.OcrConfig.Hints build() {
        com.google.cloud.documentai.v1beta3.OcrConfig.Hints result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.OcrConfig.Hints buildPartial() {
        com.google.cloud.documentai.v1beta3.OcrConfig.Hints result =
            new com.google.cloud.documentai.v1beta3.OcrConfig.Hints(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.documentai.v1beta3.OcrConfig.Hints result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          languageHints_.makeImmutable();
          result.languageHints_ = languageHints_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1beta3.OcrConfig.Hints) {
          return mergeFrom((com.google.cloud.documentai.v1beta3.OcrConfig.Hints) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.documentai.v1beta3.OcrConfig.Hints other) {
        if (other == com.google.cloud.documentai.v1beta3.OcrConfig.Hints.getDefaultInstance())
          return this;
        if (!other.languageHints_.isEmpty()) {
          if (languageHints_.isEmpty()) {
            languageHints_ = other.languageHints_;
            bitField0_ |= 0x00000001;
          } else {
            ensureLanguageHintsIsMutable();
            languageHints_.addAll(other.languageHints_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureLanguageHintsIsMutable();
                  languageHints_.add(s);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList languageHints_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureLanguageHintsIsMutable() {
        if (!languageHints_.isModifiable()) {
          languageHints_ = new com.google.protobuf.LazyStringArrayList(languageHints_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * List of BCP-47 language codes to use for OCR. In most cases, not
       * specifying it yields the best results since it enables automatic language
       * detection. For languages based on the Latin alphabet, setting hints is
       * not needed. In rare cases, when the language of the text in the
       * image is known, setting a hint will help get better results (although it
       * will be a significant hindrance if the hint is wrong).
       * </pre>
       *
       * <code>repeated string language_hints = 1;</code>
       *
       * @return A list containing the languageHints.
       */
      public com.google.protobuf.ProtocolStringList getLanguageHintsList() {
        languageHints_.makeImmutable();
        return languageHints_;
      }
      /**
       *
       *
       * <pre>
       * List of BCP-47 language codes to use for OCR. In most cases, not
       * specifying it yields the best results since it enables automatic language
       * detection. For languages based on the Latin alphabet, setting hints is
       * not needed. In rare cases, when the language of the text in the
       * image is known, setting a hint will help get better results (although it
       * will be a significant hindrance if the hint is wrong).
       * </pre>
       *
       * <code>repeated string language_hints = 1;</code>
       *
       * @return The count of languageHints.
       */
      public int getLanguageHintsCount() {
        return languageHints_.size();
      }
      /**
       *
       *
       * <pre>
       * List of BCP-47 language codes to use for OCR. In most cases, not
       * specifying it yields the best results since it enables automatic language
       * detection. For languages based on the Latin alphabet, setting hints is
       * not needed. In rare cases, when the language of the text in the
       * image is known, setting a hint will help get better results (although it
       * will be a significant hindrance if the hint is wrong).
       * </pre>
       *
       * <code>repeated string language_hints = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The languageHints at the given index.
       */
      public java.lang.String getLanguageHints(int index) {
        return languageHints_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of BCP-47 language codes to use for OCR. In most cases, not
       * specifying it yields the best results since it enables automatic language
       * detection. For languages based on the Latin alphabet, setting hints is
       * not needed. In rare cases, when the language of the text in the
       * image is known, setting a hint will help get better results (although it
       * will be a significant hindrance if the hint is wrong).
       * </pre>
       *
       * <code>repeated string language_hints = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the languageHints at the given index.
       */
      public com.google.protobuf.ByteString getLanguageHintsBytes(int index) {
        return languageHints_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * List of BCP-47 language codes to use for OCR. In most cases, not
       * specifying it yields the best results since it enables automatic language
       * detection. For languages based on the Latin alphabet, setting hints is
       * not needed. In rare cases, when the language of the text in the
       * image is known, setting a hint will help get better results (although it
       * will be a significant hindrance if the hint is wrong).
       * </pre>
       *
       * <code>repeated string language_hints = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The languageHints to set.
       * @return This builder for chaining.
       */
      public Builder setLanguageHints(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLanguageHintsIsMutable();
        languageHints_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of BCP-47 language codes to use for OCR. In most cases, not
       * specifying it yields the best results since it enables automatic language
       * detection. For languages based on the Latin alphabet, setting hints is
       * not needed. In rare cases, when the language of the text in the
       * image is known, setting a hint will help get better results (although it
       * will be a significant hindrance if the hint is wrong).
       * </pre>
       *
       * <code>repeated string language_hints = 1;</code>
       *
       * @param value The languageHints to add.
       * @return This builder for chaining.
       */
      public Builder addLanguageHints(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLanguageHintsIsMutable();
        languageHints_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of BCP-47 language codes to use for OCR. In most cases, not
       * specifying it yields the best results since it enables automatic language
       * detection. For languages based on the Latin alphabet, setting hints is
       * not needed. In rare cases, when the language of the text in the
       * image is known, setting a hint will help get better results (although it
       * will be a significant hindrance if the hint is wrong).
       * </pre>
       *
       * <code>repeated string language_hints = 1;</code>
       *
       * @param values The languageHints to add.
       * @return This builder for chaining.
       */
      public Builder addAllLanguageHints(java.lang.Iterable<java.lang.String> values) {
        ensureLanguageHintsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, languageHints_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of BCP-47 language codes to use for OCR. In most cases, not
       * specifying it yields the best results since it enables automatic language
       * detection. For languages based on the Latin alphabet, setting hints is
       * not needed. In rare cases, when the language of the text in the
       * image is known, setting a hint will help get better results (although it
       * will be a significant hindrance if the hint is wrong).
       * </pre>
       *
       * <code>repeated string language_hints = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLanguageHints() {
        languageHints_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of BCP-47 language codes to use for OCR. In most cases, not
       * specifying it yields the best results since it enables automatic language
       * detection. For languages based on the Latin alphabet, setting hints is
       * not needed. In rare cases, when the language of the text in the
       * image is known, setting a hint will help get better results (although it
       * will be a significant hindrance if the hint is wrong).
       * </pre>
       *
       * <code>repeated string language_hints = 1;</code>
       *
       * @param value The bytes of the languageHints to add.
       * @return This builder for chaining.
       */
      public Builder addLanguageHintsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureLanguageHintsIsMutable();
        languageHints_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.OcrConfig.Hints)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.OcrConfig.Hints)
    private static final com.google.cloud.documentai.v1beta3.OcrConfig.Hints DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.OcrConfig.Hints();
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.Hints getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Hints> PARSER =
        new com.google.protobuf.AbstractParser<Hints>() {
          @java.lang.Override
          public Hints parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Hints> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Hints> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.OcrConfig.Hints getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PremiumFeaturesOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Turn on selection mark detector in OCR engine. Only available in OCR 2.0
     * (and later) processors.
     * </pre>
     *
     * <code>bool enable_selection_mark_detection = 3;</code>
     *
     * @return The enableSelectionMarkDetection.
     */
    boolean getEnableSelectionMarkDetection();

    /**
     *
     *
     * <pre>
     * Turn on font identification model and return font style information.
     * </pre>
     *
     * <code>bool compute_style_info = 4;</code>
     *
     * @return The computeStyleInfo.
     */
    boolean getComputeStyleInfo();

    /**
     *
     *
     * <pre>
     * Turn on the model that can extract LaTeX math formulas.
     * </pre>
     *
     * <code>bool enable_math_ocr = 5;</code>
     *
     * @return The enableMathOcr.
     */
    boolean getEnableMathOcr();
  }
  /**
   *
   *
   * <pre>
   * Configurations for premium OCR features.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures}
   */
  public static final class PremiumFeatures extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures)
      PremiumFeaturesOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PremiumFeatures.newBuilder() to construct.
    private PremiumFeatures(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PremiumFeatures() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PremiumFeatures();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentIoProto
          .internal_static_google_cloud_documentai_v1beta3_OcrConfig_PremiumFeatures_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentIoProto
          .internal_static_google_cloud_documentai_v1beta3_OcrConfig_PremiumFeatures_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.class,
              com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.Builder.class);
    }

    public static final int ENABLE_SELECTION_MARK_DETECTION_FIELD_NUMBER = 3;
    private boolean enableSelectionMarkDetection_ = false;
    /**
     *
     *
     * <pre>
     * Turn on selection mark detector in OCR engine. Only available in OCR 2.0
     * (and later) processors.
     * </pre>
     *
     * <code>bool enable_selection_mark_detection = 3;</code>
     *
     * @return The enableSelectionMarkDetection.
     */
    @java.lang.Override
    public boolean getEnableSelectionMarkDetection() {
      return enableSelectionMarkDetection_;
    }

    public static final int COMPUTE_STYLE_INFO_FIELD_NUMBER = 4;
    private boolean computeStyleInfo_ = false;
    /**
     *
     *
     * <pre>
     * Turn on font identification model and return font style information.
     * </pre>
     *
     * <code>bool compute_style_info = 4;</code>
     *
     * @return The computeStyleInfo.
     */
    @java.lang.Override
    public boolean getComputeStyleInfo() {
      return computeStyleInfo_;
    }

    public static final int ENABLE_MATH_OCR_FIELD_NUMBER = 5;
    private boolean enableMathOcr_ = false;
    /**
     *
     *
     * <pre>
     * Turn on the model that can extract LaTeX math formulas.
     * </pre>
     *
     * <code>bool enable_math_ocr = 5;</code>
     *
     * @return The enableMathOcr.
     */
    @java.lang.Override
    public boolean getEnableMathOcr() {
      return enableMathOcr_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enableSelectionMarkDetection_ != false) {
        output.writeBool(3, enableSelectionMarkDetection_);
      }
      if (computeStyleInfo_ != false) {
        output.writeBool(4, computeStyleInfo_);
      }
      if (enableMathOcr_ != false) {
        output.writeBool(5, enableMathOcr_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enableSelectionMarkDetection_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(3, enableSelectionMarkDetection_);
      }
      if (computeStyleInfo_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, computeStyleInfo_);
      }
      if (enableMathOcr_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, enableMathOcr_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures other =
          (com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures) obj;

      if (getEnableSelectionMarkDetection() != other.getEnableSelectionMarkDetection())
        return false;
      if (getComputeStyleInfo() != other.getComputeStyleInfo()) return false;
      if (getEnableMathOcr() != other.getEnableMathOcr()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLE_SELECTION_MARK_DETECTION_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableSelectionMarkDetection());
      hash = (37 * hash) + COMPUTE_STYLE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getComputeStyleInfo());
      hash = (37 * hash) + ENABLE_MATH_OCR_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableMathOcr());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configurations for premium OCR features.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures)
        com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeaturesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentIoProto
            .internal_static_google_cloud_documentai_v1beta3_OcrConfig_PremiumFeatures_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentIoProto
            .internal_static_google_cloud_documentai_v1beta3_OcrConfig_PremiumFeatures_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.class,
                com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.Builder.class);
      }

      // Construct using com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enableSelectionMarkDetection_ = false;
        computeStyleInfo_ = false;
        enableMathOcr_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentIoProto
            .internal_static_google_cloud_documentai_v1beta3_OcrConfig_PremiumFeatures_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures build() {
        com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures buildPartial() {
        com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures result =
            new com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enableSelectionMarkDetection_ = enableSelectionMarkDetection_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.computeStyleInfo_ = computeStyleInfo_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.enableMathOcr_ = enableMathOcr_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures) {
          return mergeFrom((com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures other) {
        if (other
            == com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.getDefaultInstance())
          return this;
        if (other.getEnableSelectionMarkDetection() != false) {
          setEnableSelectionMarkDetection(other.getEnableSelectionMarkDetection());
        }
        if (other.getComputeStyleInfo() != false) {
          setComputeStyleInfo(other.getComputeStyleInfo());
        }
        if (other.getEnableMathOcr() != false) {
          setEnableMathOcr(other.getEnableMathOcr());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 24:
                {
                  enableSelectionMarkDetection_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 24
              case 32:
                {
                  computeStyleInfo_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 32
              case 40:
                {
                  enableMathOcr_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 40
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enableSelectionMarkDetection_;
      /**
       *
       *
       * <pre>
       * Turn on selection mark detector in OCR engine. Only available in OCR 2.0
       * (and later) processors.
       * </pre>
       *
       * <code>bool enable_selection_mark_detection = 3;</code>
       *
       * @return The enableSelectionMarkDetection.
       */
      @java.lang.Override
      public boolean getEnableSelectionMarkDetection() {
        return enableSelectionMarkDetection_;
      }
      /**
       *
       *
       * <pre>
       * Turn on selection mark detector in OCR engine. Only available in OCR 2.0
       * (and later) processors.
       * </pre>
       *
       * <code>bool enable_selection_mark_detection = 3;</code>
       *
       * @param value The enableSelectionMarkDetection to set.
       * @return This builder for chaining.
       */
      public Builder setEnableSelectionMarkDetection(boolean value) {

        enableSelectionMarkDetection_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Turn on selection mark detector in OCR engine. Only available in OCR 2.0
       * (and later) processors.
       * </pre>
       *
       * <code>bool enable_selection_mark_detection = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableSelectionMarkDetection() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enableSelectionMarkDetection_ = false;
        onChanged();
        return this;
      }

      private boolean computeStyleInfo_;
      /**
       *
       *
       * <pre>
       * Turn on font identification model and return font style information.
       * </pre>
       *
       * <code>bool compute_style_info = 4;</code>
       *
       * @return The computeStyleInfo.
       */
      @java.lang.Override
      public boolean getComputeStyleInfo() {
        return computeStyleInfo_;
      }
      /**
       *
       *
       * <pre>
       * Turn on font identification model and return font style information.
       * </pre>
       *
       * <code>bool compute_style_info = 4;</code>
       *
       * @param value The computeStyleInfo to set.
       * @return This builder for chaining.
       */
      public Builder setComputeStyleInfo(boolean value) {

        computeStyleInfo_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Turn on font identification model and return font style information.
       * </pre>
       *
       * <code>bool compute_style_info = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearComputeStyleInfo() {
        bitField0_ = (bitField0_ & ~0x00000002);
        computeStyleInfo_ = false;
        onChanged();
        return this;
      }

      private boolean enableMathOcr_;
      /**
       *
       *
       * <pre>
       * Turn on the model that can extract LaTeX math formulas.
       * </pre>
       *
       * <code>bool enable_math_ocr = 5;</code>
       *
       * @return The enableMathOcr.
       */
      @java.lang.Override
      public boolean getEnableMathOcr() {
        return enableMathOcr_;
      }
      /**
       *
       *
       * <pre>
       * Turn on the model that can extract LaTeX math formulas.
       * </pre>
       *
       * <code>bool enable_math_ocr = 5;</code>
       *
       * @param value The enableMathOcr to set.
       * @return This builder for chaining.
       */
      public Builder setEnableMathOcr(boolean value) {

        enableMathOcr_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Turn on the model that can extract LaTeX math formulas.
       * </pre>
       *
       * <code>bool enable_math_ocr = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableMathOcr() {
        bitField0_ = (bitField0_ & ~0x00000004);
        enableMathOcr_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures)
    private static final com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures();
    }

    public static com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PremiumFeatures> PARSER =
        new com.google.protobuf.AbstractParser<PremiumFeatures>() {
          @java.lang.Override
          public PremiumFeatures parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PremiumFeatures> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PremiumFeatures> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int HINTS_FIELD_NUMBER = 2;
  private com.google.cloud.documentai.v1beta3.OcrConfig.Hints hints_;
  /**
   *
   *
   * <pre>
   * Hints for the OCR model.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.OcrConfig.Hints hints = 2;</code>
   *
   * @return Whether the hints field is set.
   */
  @java.lang.Override
  public boolean hasHints() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Hints for the OCR model.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.OcrConfig.Hints hints = 2;</code>
   *
   * @return The hints.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.OcrConfig.Hints getHints() {
    return hints_ == null
        ? com.google.cloud.documentai.v1beta3.OcrConfig.Hints.getDefaultInstance()
        : hints_;
  }
  /**
   *
   *
   * <pre>
   * Hints for the OCR model.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.OcrConfig.Hints hints = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.OcrConfig.HintsOrBuilder getHintsOrBuilder() {
    return hints_ == null
        ? com.google.cloud.documentai.v1beta3.OcrConfig.Hints.getDefaultInstance()
        : hints_;
  }

  public static final int ENABLE_NATIVE_PDF_PARSING_FIELD_NUMBER = 3;
  private boolean enableNativePdfParsing_ = false;
  /**
   *
   *
   * <pre>
   * Enables special handling for PDFs with existing text information. Results
   * in better text extraction quality in such PDF inputs.
   * </pre>
   *
   * <code>bool enable_native_pdf_parsing = 3;</code>
   *
   * @return The enableNativePdfParsing.
   */
  @java.lang.Override
  public boolean getEnableNativePdfParsing() {
    return enableNativePdfParsing_;
  }

  public static final int ENABLE_IMAGE_QUALITY_SCORES_FIELD_NUMBER = 4;
  private boolean enableImageQualityScores_ = false;
  /**
   *
   *
   * <pre>
   * Enables intelligent document quality scores after OCR. Can help with
   * diagnosing why OCR responses are of poor quality for a given input.
   * Adds additional latency comparable to regular OCR to the process call.
   * </pre>
   *
   * <code>bool enable_image_quality_scores = 4;</code>
   *
   * @return The enableImageQualityScores.
   */
  @java.lang.Override
  public boolean getEnableImageQualityScores() {
    return enableImageQualityScores_;
  }

  public static final int ADVANCED_OCR_OPTIONS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList advancedOcrOptions_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of advanced OCR options to further fine-tune OCR behavior. Current
   * valid values are:
   *
   * - `legacy_layout`: a heuristics layout detection algorithm, which serves as
   * an alternative to the current ML-based layout detection algorithm.
   * Customers can choose the best suitable layout algorithm based on their
   * situation.
   * </pre>
   *
   * <code>repeated string advanced_ocr_options = 5;</code>
   *
   * @return A list containing the advancedOcrOptions.
   */
  public com.google.protobuf.ProtocolStringList getAdvancedOcrOptionsList() {
    return advancedOcrOptions_;
  }
  /**
   *
   *
   * <pre>
   * A list of advanced OCR options to further fine-tune OCR behavior. Current
   * valid values are:
   *
   * - `legacy_layout`: a heuristics layout detection algorithm, which serves as
   * an alternative to the current ML-based layout detection algorithm.
   * Customers can choose the best suitable layout algorithm based on their
   * situation.
   * </pre>
   *
   * <code>repeated string advanced_ocr_options = 5;</code>
   *
   * @return The count of advancedOcrOptions.
   */
  public int getAdvancedOcrOptionsCount() {
    return advancedOcrOptions_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of advanced OCR options to further fine-tune OCR behavior. Current
   * valid values are:
   *
   * - `legacy_layout`: a heuristics layout detection algorithm, which serves as
   * an alternative to the current ML-based layout detection algorithm.
   * Customers can choose the best suitable layout algorithm based on their
   * situation.
   * </pre>
   *
   * <code>repeated string advanced_ocr_options = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The advancedOcrOptions at the given index.
   */
  public java.lang.String getAdvancedOcrOptions(int index) {
    return advancedOcrOptions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of advanced OCR options to further fine-tune OCR behavior. Current
   * valid values are:
   *
   * - `legacy_layout`: a heuristics layout detection algorithm, which serves as
   * an alternative to the current ML-based layout detection algorithm.
   * Customers can choose the best suitable layout algorithm based on their
   * situation.
   * </pre>
   *
   * <code>repeated string advanced_ocr_options = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the advancedOcrOptions at the given index.
   */
  public com.google.protobuf.ByteString getAdvancedOcrOptionsBytes(int index) {
    return advancedOcrOptions_.getByteString(index);
  }

  public static final int ENABLE_SYMBOL_FIELD_NUMBER = 6;
  private boolean enableSymbol_ = false;
  /**
   *
   *
   * <pre>
   * Includes symbol level OCR information if set to true.
   * </pre>
   *
   * <code>bool enable_symbol = 6;</code>
   *
   * @return The enableSymbol.
   */
  @java.lang.Override
  public boolean getEnableSymbol() {
    return enableSymbol_;
  }

  public static final int COMPUTE_STYLE_INFO_FIELD_NUMBER = 8;
  private boolean computeStyleInfo_ = false;
  /**
   *
   *
   * <pre>
   * Turn on font identification model and return font style information.
   * Deprecated, use
   * [PremiumFeatures.compute_style_info][google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.compute_style_info]
   * instead.
   * </pre>
   *
   * <code>bool compute_style_info = 8 [deprecated = true];</code>
   *
   * @deprecated google.cloud.documentai.v1beta3.OcrConfig.compute_style_info is deprecated. See
   *     google/cloud/documentai/v1beta3/document_io.proto;l=165
   * @return The computeStyleInfo.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean getComputeStyleInfo() {
    return computeStyleInfo_;
  }

  public static final int DISABLE_CHARACTER_BOXES_DETECTION_FIELD_NUMBER = 10;
  private boolean disableCharacterBoxesDetection_ = false;
  /**
   *
   *
   * <pre>
   * Turn off character box detector in OCR engine. Character box detection is
   * enabled by default in OCR 2.0 (and later) processors.
   * </pre>
   *
   * <code>bool disable_character_boxes_detection = 10;</code>
   *
   * @return The disableCharacterBoxesDetection.
   */
  @java.lang.Override
  public boolean getDisableCharacterBoxesDetection() {
    return disableCharacterBoxesDetection_;
  }

  public static final int PREMIUM_FEATURES_FIELD_NUMBER = 11;
  private com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures premiumFeatures_;
  /**
   *
   *
   * <pre>
   * Configurations for premium OCR features.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures premium_features = 11;</code>
   *
   * @return Whether the premiumFeatures field is set.
   */
  @java.lang.Override
  public boolean hasPremiumFeatures() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configurations for premium OCR features.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures premium_features = 11;</code>
   *
   * @return The premiumFeatures.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures getPremiumFeatures() {
    return premiumFeatures_ == null
        ? com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.getDefaultInstance()
        : premiumFeatures_;
  }
  /**
   *
   *
   * <pre>
   * Configurations for premium OCR features.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures premium_features = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeaturesOrBuilder
      getPremiumFeaturesOrBuilder() {
    return premiumFeatures_ == null
        ? com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.getDefaultInstance()
        : premiumFeatures_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getHints());
    }
    if (enableNativePdfParsing_ != false) {
      output.writeBool(3, enableNativePdfParsing_);
    }
    if (enableImageQualityScores_ != false) {
      output.writeBool(4, enableImageQualityScores_);
    }
    for (int i = 0; i < advancedOcrOptions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, advancedOcrOptions_.getRaw(i));
    }
    if (enableSymbol_ != false) {
      output.writeBool(6, enableSymbol_);
    }
    if (computeStyleInfo_ != false) {
      output.writeBool(8, computeStyleInfo_);
    }
    if (disableCharacterBoxesDetection_ != false) {
      output.writeBool(10, disableCharacterBoxesDetection_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(11, getPremiumFeatures());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getHints());
    }
    if (enableNativePdfParsing_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, enableNativePdfParsing_);
    }
    if (enableImageQualityScores_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, enableImageQualityScores_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < advancedOcrOptions_.size(); i++) {
        dataSize += computeStringSizeNoTag(advancedOcrOptions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAdvancedOcrOptionsList().size();
    }
    if (enableSymbol_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, enableSymbol_);
    }
    if (computeStyleInfo_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, computeStyleInfo_);
    }
    if (disableCharacterBoxesDetection_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              10, disableCharacterBoxesDetection_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getPremiumFeatures());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.OcrConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.OcrConfig other =
        (com.google.cloud.documentai.v1beta3.OcrConfig) obj;

    if (hasHints() != other.hasHints()) return false;
    if (hasHints()) {
      if (!getHints().equals(other.getHints())) return false;
    }
    if (getEnableNativePdfParsing() != other.getEnableNativePdfParsing()) return false;
    if (getEnableImageQualityScores() != other.getEnableImageQualityScores()) return false;
    if (!getAdvancedOcrOptionsList().equals(other.getAdvancedOcrOptionsList())) return false;
    if (getEnableSymbol() != other.getEnableSymbol()) return false;
    if (getComputeStyleInfo() != other.getComputeStyleInfo()) return false;
    if (getDisableCharacterBoxesDetection() != other.getDisableCharacterBoxesDetection())
      return false;
    if (hasPremiumFeatures() != other.hasPremiumFeatures()) return false;
    if (hasPremiumFeatures()) {
      if (!getPremiumFeatures().equals(other.getPremiumFeatures())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasHints()) {
      hash = (37 * hash) + HINTS_FIELD_NUMBER;
      hash = (53 * hash) + getHints().hashCode();
    }
    hash = (37 * hash) + ENABLE_NATIVE_PDF_PARSING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableNativePdfParsing());
    hash = (37 * hash) + ENABLE_IMAGE_QUALITY_SCORES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableImageQualityScores());
    if (getAdvancedOcrOptionsCount() > 0) {
      hash = (37 * hash) + ADVANCED_OCR_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getAdvancedOcrOptionsList().hashCode();
    }
    hash = (37 * hash) + ENABLE_SYMBOL_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableSymbol());
    hash = (37 * hash) + COMPUTE_STYLE_INFO_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getComputeStyleInfo());
    hash = (37 * hash) + DISABLE_CHARACTER_BOXES_DETECTION_FIELD_NUMBER;
    hash =
        (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableCharacterBoxesDetection());
    if (hasPremiumFeatures()) {
      hash = (37 * hash) + PREMIUM_FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getPremiumFeatures().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.OcrConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.OcrConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.OcrConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.OcrConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.OcrConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.OcrConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.OcrConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.OcrConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.OcrConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.OcrConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.OcrConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.OcrConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.documentai.v1beta3.OcrConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Config for Document OCR.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.OcrConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.OcrConfig)
      com.google.cloud.documentai.v1beta3.OcrConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentIoProto
          .internal_static_google_cloud_documentai_v1beta3_OcrConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentIoProto
          .internal_static_google_cloud_documentai_v1beta3_OcrConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.OcrConfig.class,
              com.google.cloud.documentai.v1beta3.OcrConfig.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.OcrConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getHintsFieldBuilder();
        getPremiumFeaturesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      hints_ = null;
      if (hintsBuilder_ != null) {
        hintsBuilder_.dispose();
        hintsBuilder_ = null;
      }
      enableNativePdfParsing_ = false;
      enableImageQualityScores_ = false;
      advancedOcrOptions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      enableSymbol_ = false;
      computeStyleInfo_ = false;
      disableCharacterBoxesDetection_ = false;
      premiumFeatures_ = null;
      if (premiumFeaturesBuilder_ != null) {
        premiumFeaturesBuilder_.dispose();
        premiumFeaturesBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentIoProto
          .internal_static_google_cloud_documentai_v1beta3_OcrConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.OcrConfig getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.OcrConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.OcrConfig build() {
      com.google.cloud.documentai.v1beta3.OcrConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.OcrConfig buildPartial() {
      com.google.cloud.documentai.v1beta3.OcrConfig result =
          new com.google.cloud.documentai.v1beta3.OcrConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta3.OcrConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.hints_ = hintsBuilder_ == null ? hints_ : hintsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.enableNativePdfParsing_ = enableNativePdfParsing_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.enableImageQualityScores_ = enableImageQualityScores_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        advancedOcrOptions_.makeImmutable();
        result.advancedOcrOptions_ = advancedOcrOptions_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.enableSymbol_ = enableSymbol_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.computeStyleInfo_ = computeStyleInfo_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.disableCharacterBoxesDetection_ = disableCharacterBoxesDetection_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.premiumFeatures_ =
            premiumFeaturesBuilder_ == null ? premiumFeatures_ : premiumFeaturesBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.OcrConfig) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.OcrConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.OcrConfig other) {
      if (other == com.google.cloud.documentai.v1beta3.OcrConfig.getDefaultInstance()) return this;
      if (other.hasHints()) {
        mergeHints(other.getHints());
      }
      if (other.getEnableNativePdfParsing() != false) {
        setEnableNativePdfParsing(other.getEnableNativePdfParsing());
      }
      if (other.getEnableImageQualityScores() != false) {
        setEnableImageQualityScores(other.getEnableImageQualityScores());
      }
      if (!other.advancedOcrOptions_.isEmpty()) {
        if (advancedOcrOptions_.isEmpty()) {
          advancedOcrOptions_ = other.advancedOcrOptions_;
          bitField0_ |= 0x00000008;
        } else {
          ensureAdvancedOcrOptionsIsMutable();
          advancedOcrOptions_.addAll(other.advancedOcrOptions_);
        }
        onChanged();
      }
      if (other.getEnableSymbol() != false) {
        setEnableSymbol(other.getEnableSymbol());
      }
      if (other.getComputeStyleInfo() != false) {
        setComputeStyleInfo(other.getComputeStyleInfo());
      }
      if (other.getDisableCharacterBoxesDetection() != false) {
        setDisableCharacterBoxesDetection(other.getDisableCharacterBoxesDetection());
      }
      if (other.hasPremiumFeatures()) {
        mergePremiumFeatures(other.getPremiumFeatures());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getHintsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 18
            case 24:
              {
                enableNativePdfParsing_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 24
            case 32:
              {
                enableImageQualityScores_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAdvancedOcrOptionsIsMutable();
                advancedOcrOptions_.add(s);
                break;
              } // case 42
            case 48:
              {
                enableSymbol_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            case 64:
              {
                computeStyleInfo_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 64
            case 80:
              {
                disableCharacterBoxesDetection_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 80
            case 90:
              {
                input.readMessage(getPremiumFeaturesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.documentai.v1beta3.OcrConfig.Hints hints_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.OcrConfig.Hints,
            com.google.cloud.documentai.v1beta3.OcrConfig.Hints.Builder,
            com.google.cloud.documentai.v1beta3.OcrConfig.HintsOrBuilder>
        hintsBuilder_;
    /**
     *
     *
     * <pre>
     * Hints for the OCR model.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig.Hints hints = 2;</code>
     *
     * @return Whether the hints field is set.
     */
    public boolean hasHints() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Hints for the OCR model.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig.Hints hints = 2;</code>
     *
     * @return The hints.
     */
    public com.google.cloud.documentai.v1beta3.OcrConfig.Hints getHints() {
      if (hintsBuilder_ == null) {
        return hints_ == null
            ? com.google.cloud.documentai.v1beta3.OcrConfig.Hints.getDefaultInstance()
            : hints_;
      } else {
        return hintsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Hints for the OCR model.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig.Hints hints = 2;</code>
     */
    public Builder setHints(com.google.cloud.documentai.v1beta3.OcrConfig.Hints value) {
      if (hintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        hints_ = value;
      } else {
        hintsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hints for the OCR model.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig.Hints hints = 2;</code>
     */
    public Builder setHints(
        com.google.cloud.documentai.v1beta3.OcrConfig.Hints.Builder builderForValue) {
      if (hintsBuilder_ == null) {
        hints_ = builderForValue.build();
      } else {
        hintsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hints for the OCR model.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig.Hints hints = 2;</code>
     */
    public Builder mergeHints(com.google.cloud.documentai.v1beta3.OcrConfig.Hints value) {
      if (hintsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && hints_ != null
            && hints_ != com.google.cloud.documentai.v1beta3.OcrConfig.Hints.getDefaultInstance()) {
          getHintsBuilder().mergeFrom(value);
        } else {
          hints_ = value;
        }
      } else {
        hintsBuilder_.mergeFrom(value);
      }
      if (hints_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hints for the OCR model.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig.Hints hints = 2;</code>
     */
    public Builder clearHints() {
      bitField0_ = (bitField0_ & ~0x00000001);
      hints_ = null;
      if (hintsBuilder_ != null) {
        hintsBuilder_.dispose();
        hintsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hints for the OCR model.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig.Hints hints = 2;</code>
     */
    public com.google.cloud.documentai.v1beta3.OcrConfig.Hints.Builder getHintsBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getHintsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Hints for the OCR model.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig.Hints hints = 2;</code>
     */
    public com.google.cloud.documentai.v1beta3.OcrConfig.HintsOrBuilder getHintsOrBuilder() {
      if (hintsBuilder_ != null) {
        return hintsBuilder_.getMessageOrBuilder();
      } else {
        return hints_ == null
            ? com.google.cloud.documentai.v1beta3.OcrConfig.Hints.getDefaultInstance()
            : hints_;
      }
    }
    /**
     *
     *
     * <pre>
     * Hints for the OCR model.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig.Hints hints = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.OcrConfig.Hints,
            com.google.cloud.documentai.v1beta3.OcrConfig.Hints.Builder,
            com.google.cloud.documentai.v1beta3.OcrConfig.HintsOrBuilder>
        getHintsFieldBuilder() {
      if (hintsBuilder_ == null) {
        hintsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.OcrConfig.Hints,
                com.google.cloud.documentai.v1beta3.OcrConfig.Hints.Builder,
                com.google.cloud.documentai.v1beta3.OcrConfig.HintsOrBuilder>(
                getHints(), getParentForChildren(), isClean());
        hints_ = null;
      }
      return hintsBuilder_;
    }

    private boolean enableNativePdfParsing_;
    /**
     *
     *
     * <pre>
     * Enables special handling for PDFs with existing text information. Results
     * in better text extraction quality in such PDF inputs.
     * </pre>
     *
     * <code>bool enable_native_pdf_parsing = 3;</code>
     *
     * @return The enableNativePdfParsing.
     */
    @java.lang.Override
    public boolean getEnableNativePdfParsing() {
      return enableNativePdfParsing_;
    }
    /**
     *
     *
     * <pre>
     * Enables special handling for PDFs with existing text information. Results
     * in better text extraction quality in such PDF inputs.
     * </pre>
     *
     * <code>bool enable_native_pdf_parsing = 3;</code>
     *
     * @param value The enableNativePdfParsing to set.
     * @return This builder for chaining.
     */
    public Builder setEnableNativePdfParsing(boolean value) {

      enableNativePdfParsing_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enables special handling for PDFs with existing text information. Results
     * in better text extraction quality in such PDF inputs.
     * </pre>
     *
     * <code>bool enable_native_pdf_parsing = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableNativePdfParsing() {
      bitField0_ = (bitField0_ & ~0x00000002);
      enableNativePdfParsing_ = false;
      onChanged();
      return this;
    }

    private boolean enableImageQualityScores_;
    /**
     *
     *
     * <pre>
     * Enables intelligent document quality scores after OCR. Can help with
     * diagnosing why OCR responses are of poor quality for a given input.
     * Adds additional latency comparable to regular OCR to the process call.
     * </pre>
     *
     * <code>bool enable_image_quality_scores = 4;</code>
     *
     * @return The enableImageQualityScores.
     */
    @java.lang.Override
    public boolean getEnableImageQualityScores() {
      return enableImageQualityScores_;
    }
    /**
     *
     *
     * <pre>
     * Enables intelligent document quality scores after OCR. Can help with
     * diagnosing why OCR responses are of poor quality for a given input.
     * Adds additional latency comparable to regular OCR to the process call.
     * </pre>
     *
     * <code>bool enable_image_quality_scores = 4;</code>
     *
     * @param value The enableImageQualityScores to set.
     * @return This builder for chaining.
     */
    public Builder setEnableImageQualityScores(boolean value) {

      enableImageQualityScores_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enables intelligent document quality scores after OCR. Can help with
     * diagnosing why OCR responses are of poor quality for a given input.
     * Adds additional latency comparable to regular OCR to the process call.
     * </pre>
     *
     * <code>bool enable_image_quality_scores = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableImageQualityScores() {
      bitField0_ = (bitField0_ & ~0x00000004);
      enableImageQualityScores_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList advancedOcrOptions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAdvancedOcrOptionsIsMutable() {
      if (!advancedOcrOptions_.isModifiable()) {
        advancedOcrOptions_ = new com.google.protobuf.LazyStringArrayList(advancedOcrOptions_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * A list of advanced OCR options to further fine-tune OCR behavior. Current
     * valid values are:
     *
     * - `legacy_layout`: a heuristics layout detection algorithm, which serves as
     * an alternative to the current ML-based layout detection algorithm.
     * Customers can choose the best suitable layout algorithm based on their
     * situation.
     * </pre>
     *
     * <code>repeated string advanced_ocr_options = 5;</code>
     *
     * @return A list containing the advancedOcrOptions.
     */
    public com.google.protobuf.ProtocolStringList getAdvancedOcrOptionsList() {
      advancedOcrOptions_.makeImmutable();
      return advancedOcrOptions_;
    }
    /**
     *
     *
     * <pre>
     * A list of advanced OCR options to further fine-tune OCR behavior. Current
     * valid values are:
     *
     * - `legacy_layout`: a heuristics layout detection algorithm, which serves as
     * an alternative to the current ML-based layout detection algorithm.
     * Customers can choose the best suitable layout algorithm based on their
     * situation.
     * </pre>
     *
     * <code>repeated string advanced_ocr_options = 5;</code>
     *
     * @return The count of advancedOcrOptions.
     */
    public int getAdvancedOcrOptionsCount() {
      return advancedOcrOptions_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of advanced OCR options to further fine-tune OCR behavior. Current
     * valid values are:
     *
     * - `legacy_layout`: a heuristics layout detection algorithm, which serves as
     * an alternative to the current ML-based layout detection algorithm.
     * Customers can choose the best suitable layout algorithm based on their
     * situation.
     * </pre>
     *
     * <code>repeated string advanced_ocr_options = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The advancedOcrOptions at the given index.
     */
    public java.lang.String getAdvancedOcrOptions(int index) {
      return advancedOcrOptions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of advanced OCR options to further fine-tune OCR behavior. Current
     * valid values are:
     *
     * - `legacy_layout`: a heuristics layout detection algorithm, which serves as
     * an alternative to the current ML-based layout detection algorithm.
     * Customers can choose the best suitable layout algorithm based on their
     * situation.
     * </pre>
     *
     * <code>repeated string advanced_ocr_options = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the advancedOcrOptions at the given index.
     */
    public com.google.protobuf.ByteString getAdvancedOcrOptionsBytes(int index) {
      return advancedOcrOptions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of advanced OCR options to further fine-tune OCR behavior. Current
     * valid values are:
     *
     * - `legacy_layout`: a heuristics layout detection algorithm, which serves as
     * an alternative to the current ML-based layout detection algorithm.
     * Customers can choose the best suitable layout algorithm based on their
     * situation.
     * </pre>
     *
     * <code>repeated string advanced_ocr_options = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The advancedOcrOptions to set.
     * @return This builder for chaining.
     */
    public Builder setAdvancedOcrOptions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAdvancedOcrOptionsIsMutable();
      advancedOcrOptions_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of advanced OCR options to further fine-tune OCR behavior. Current
     * valid values are:
     *
     * - `legacy_layout`: a heuristics layout detection algorithm, which serves as
     * an alternative to the current ML-based layout detection algorithm.
     * Customers can choose the best suitable layout algorithm based on their
     * situation.
     * </pre>
     *
     * <code>repeated string advanced_ocr_options = 5;</code>
     *
     * @param value The advancedOcrOptions to add.
     * @return This builder for chaining.
     */
    public Builder addAdvancedOcrOptions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAdvancedOcrOptionsIsMutable();
      advancedOcrOptions_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of advanced OCR options to further fine-tune OCR behavior. Current
     * valid values are:
     *
     * - `legacy_layout`: a heuristics layout detection algorithm, which serves as
     * an alternative to the current ML-based layout detection algorithm.
     * Customers can choose the best suitable layout algorithm based on their
     * situation.
     * </pre>
     *
     * <code>repeated string advanced_ocr_options = 5;</code>
     *
     * @param values The advancedOcrOptions to add.
     * @return This builder for chaining.
     */
    public Builder addAllAdvancedOcrOptions(java.lang.Iterable<java.lang.String> values) {
      ensureAdvancedOcrOptionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, advancedOcrOptions_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of advanced OCR options to further fine-tune OCR behavior. Current
     * valid values are:
     *
     * - `legacy_layout`: a heuristics layout detection algorithm, which serves as
     * an alternative to the current ML-based layout detection algorithm.
     * Customers can choose the best suitable layout algorithm based on their
     * situation.
     * </pre>
     *
     * <code>repeated string advanced_ocr_options = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdvancedOcrOptions() {
      advancedOcrOptions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of advanced OCR options to further fine-tune OCR behavior. Current
     * valid values are:
     *
     * - `legacy_layout`: a heuristics layout detection algorithm, which serves as
     * an alternative to the current ML-based layout detection algorithm.
     * Customers can choose the best suitable layout algorithm based on their
     * situation.
     * </pre>
     *
     * <code>repeated string advanced_ocr_options = 5;</code>
     *
     * @param value The bytes of the advancedOcrOptions to add.
     * @return This builder for chaining.
     */
    public Builder addAdvancedOcrOptionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAdvancedOcrOptionsIsMutable();
      advancedOcrOptions_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean enableSymbol_;
    /**
     *
     *
     * <pre>
     * Includes symbol level OCR information if set to true.
     * </pre>
     *
     * <code>bool enable_symbol = 6;</code>
     *
     * @return The enableSymbol.
     */
    @java.lang.Override
    public boolean getEnableSymbol() {
      return enableSymbol_;
    }
    /**
     *
     *
     * <pre>
     * Includes symbol level OCR information if set to true.
     * </pre>
     *
     * <code>bool enable_symbol = 6;</code>
     *
     * @param value The enableSymbol to set.
     * @return This builder for chaining.
     */
    public Builder setEnableSymbol(boolean value) {

      enableSymbol_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Includes symbol level OCR information if set to true.
     * </pre>
     *
     * <code>bool enable_symbol = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableSymbol() {
      bitField0_ = (bitField0_ & ~0x00000010);
      enableSymbol_ = false;
      onChanged();
      return this;
    }

    private boolean computeStyleInfo_;
    /**
     *
     *
     * <pre>
     * Turn on font identification model and return font style information.
     * Deprecated, use
     * [PremiumFeatures.compute_style_info][google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.compute_style_info]
     * instead.
     * </pre>
     *
     * <code>bool compute_style_info = 8 [deprecated = true];</code>
     *
     * @deprecated google.cloud.documentai.v1beta3.OcrConfig.compute_style_info is deprecated. See
     *     google/cloud/documentai/v1beta3/document_io.proto;l=165
     * @return The computeStyleInfo.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getComputeStyleInfo() {
      return computeStyleInfo_;
    }
    /**
     *
     *
     * <pre>
     * Turn on font identification model and return font style information.
     * Deprecated, use
     * [PremiumFeatures.compute_style_info][google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.compute_style_info]
     * instead.
     * </pre>
     *
     * <code>bool compute_style_info = 8 [deprecated = true];</code>
     *
     * @deprecated google.cloud.documentai.v1beta3.OcrConfig.compute_style_info is deprecated. See
     *     google/cloud/documentai/v1beta3/document_io.proto;l=165
     * @param value The computeStyleInfo to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setComputeStyleInfo(boolean value) {

      computeStyleInfo_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Turn on font identification model and return font style information.
     * Deprecated, use
     * [PremiumFeatures.compute_style_info][google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.compute_style_info]
     * instead.
     * </pre>
     *
     * <code>bool compute_style_info = 8 [deprecated = true];</code>
     *
     * @deprecated google.cloud.documentai.v1beta3.OcrConfig.compute_style_info is deprecated. See
     *     google/cloud/documentai/v1beta3/document_io.proto;l=165
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearComputeStyleInfo() {
      bitField0_ = (bitField0_ & ~0x00000020);
      computeStyleInfo_ = false;
      onChanged();
      return this;
    }

    private boolean disableCharacterBoxesDetection_;
    /**
     *
     *
     * <pre>
     * Turn off character box detector in OCR engine. Character box detection is
     * enabled by default in OCR 2.0 (and later) processors.
     * </pre>
     *
     * <code>bool disable_character_boxes_detection = 10;</code>
     *
     * @return The disableCharacterBoxesDetection.
     */
    @java.lang.Override
    public boolean getDisableCharacterBoxesDetection() {
      return disableCharacterBoxesDetection_;
    }
    /**
     *
     *
     * <pre>
     * Turn off character box detector in OCR engine. Character box detection is
     * enabled by default in OCR 2.0 (and later) processors.
     * </pre>
     *
     * <code>bool disable_character_boxes_detection = 10;</code>
     *
     * @param value The disableCharacterBoxesDetection to set.
     * @return This builder for chaining.
     */
    public Builder setDisableCharacterBoxesDetection(boolean value) {

      disableCharacterBoxesDetection_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Turn off character box detector in OCR engine. Character box detection is
     * enabled by default in OCR 2.0 (and later) processors.
     * </pre>
     *
     * <code>bool disable_character_boxes_detection = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableCharacterBoxesDetection() {
      bitField0_ = (bitField0_ & ~0x00000040);
      disableCharacterBoxesDetection_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures premiumFeatures_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures,
            com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.Builder,
            com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeaturesOrBuilder>
        premiumFeaturesBuilder_;
    /**
     *
     *
     * <pre>
     * Configurations for premium OCR features.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures premium_features = 11;
     * </code>
     *
     * @return Whether the premiumFeatures field is set.
     */
    public boolean hasPremiumFeatures() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configurations for premium OCR features.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures premium_features = 11;
     * </code>
     *
     * @return The premiumFeatures.
     */
    public com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures getPremiumFeatures() {
      if (premiumFeaturesBuilder_ == null) {
        return premiumFeatures_ == null
            ? com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.getDefaultInstance()
            : premiumFeatures_;
      } else {
        return premiumFeaturesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configurations for premium OCR features.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures premium_features = 11;
     * </code>
     */
    public Builder setPremiumFeatures(
        com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures value) {
      if (premiumFeaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        premiumFeatures_ = value;
      } else {
        premiumFeaturesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for premium OCR features.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures premium_features = 11;
     * </code>
     */
    public Builder setPremiumFeatures(
        com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.Builder builderForValue) {
      if (premiumFeaturesBuilder_ == null) {
        premiumFeatures_ = builderForValue.build();
      } else {
        premiumFeaturesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for premium OCR features.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures premium_features = 11;
     * </code>
     */
    public Builder mergePremiumFeatures(
        com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures value) {
      if (premiumFeaturesBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && premiumFeatures_ != null
            && premiumFeatures_
                != com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures
                    .getDefaultInstance()) {
          getPremiumFeaturesBuilder().mergeFrom(value);
        } else {
          premiumFeatures_ = value;
        }
      } else {
        premiumFeaturesBuilder_.mergeFrom(value);
      }
      if (premiumFeatures_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for premium OCR features.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures premium_features = 11;
     * </code>
     */
    public Builder clearPremiumFeatures() {
      bitField0_ = (bitField0_ & ~0x00000080);
      premiumFeatures_ = null;
      if (premiumFeaturesBuilder_ != null) {
        premiumFeaturesBuilder_.dispose();
        premiumFeaturesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configurations for premium OCR features.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures premium_features = 11;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.Builder
        getPremiumFeaturesBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getPremiumFeaturesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configurations for premium OCR features.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures premium_features = 11;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeaturesOrBuilder
        getPremiumFeaturesOrBuilder() {
      if (premiumFeaturesBuilder_ != null) {
        return premiumFeaturesBuilder_.getMessageOrBuilder();
      } else {
        return premiumFeatures_ == null
            ? com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.getDefaultInstance()
            : premiumFeatures_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configurations for premium OCR features.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures premium_features = 11;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures,
            com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.Builder,
            com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeaturesOrBuilder>
        getPremiumFeaturesFieldBuilder() {
      if (premiumFeaturesBuilder_ == null) {
        premiumFeaturesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures,
                com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.Builder,
                com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeaturesOrBuilder>(
                getPremiumFeatures(), getParentForChildren(), isClean());
        premiumFeatures_ = null;
      }
      return premiumFeaturesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.OcrConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.OcrConfig)
  private static final com.google.cloud.documentai.v1beta3.OcrConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.OcrConfig();
  }

  public static com.google.cloud.documentai.v1beta3.OcrConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OcrConfig> PARSER =
      new com.google.protobuf.AbstractParser<OcrConfig>() {
        @java.lang.Override
        public OcrConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OcrConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OcrConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.OcrConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
