/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document_io.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.documentai.v1beta3;

public interface OcrConfigOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.OcrConfig)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Hints for the OCR model.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.OcrConfig.Hints hints = 2;</code>
   *
   * @return Whether the hints field is set.
   */
  boolean hasHints();
  /**
   *
   *
   * <pre>
   * Hints for the OCR model.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.OcrConfig.Hints hints = 2;</code>
   *
   * @return The hints.
   */
  com.google.cloud.documentai.v1beta3.OcrConfig.Hints getHints();
  /**
   *
   *
   * <pre>
   * Hints for the OCR model.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.OcrConfig.Hints hints = 2;</code>
   */
  com.google.cloud.documentai.v1beta3.OcrConfig.HintsOrBuilder getHintsOrBuilder();

  /**
   *
   *
   * <pre>
   * Enables special handling for PDFs with existing text information. Results
   * in better text extraction quality in such PDF inputs.
   * </pre>
   *
   * <code>bool enable_native_pdf_parsing = 3;</code>
   *
   * @return The enableNativePdfParsing.
   */
  boolean getEnableNativePdfParsing();

  /**
   *
   *
   * <pre>
   * Enables intelligent document quality scores after OCR. Can help with
   * diagnosing why OCR responses are of poor quality for a given input.
   * Adds additional latency comparable to regular OCR to the process call.
   * </pre>
   *
   * <code>bool enable_image_quality_scores = 4;</code>
   *
   * @return The enableImageQualityScores.
   */
  boolean getEnableImageQualityScores();

  /**
   *
   *
   * <pre>
   * A list of advanced OCR options to further fine-tune OCR behavior. Current
   * valid values are:
   *
   * - `legacy_layout`: a heuristics layout detection algorithm, which serves as
   * an alternative to the current ML-based layout detection algorithm.
   * Customers can choose the best suitable layout algorithm based on their
   * situation.
   * </pre>
   *
   * <code>repeated string advanced_ocr_options = 5;</code>
   *
   * @return A list containing the advancedOcrOptions.
   */
  java.util.List<java.lang.String> getAdvancedOcrOptionsList();
  /**
   *
   *
   * <pre>
   * A list of advanced OCR options to further fine-tune OCR behavior. Current
   * valid values are:
   *
   * - `legacy_layout`: a heuristics layout detection algorithm, which serves as
   * an alternative to the current ML-based layout detection algorithm.
   * Customers can choose the best suitable layout algorithm based on their
   * situation.
   * </pre>
   *
   * <code>repeated string advanced_ocr_options = 5;</code>
   *
   * @return The count of advancedOcrOptions.
   */
  int getAdvancedOcrOptionsCount();
  /**
   *
   *
   * <pre>
   * A list of advanced OCR options to further fine-tune OCR behavior. Current
   * valid values are:
   *
   * - `legacy_layout`: a heuristics layout detection algorithm, which serves as
   * an alternative to the current ML-based layout detection algorithm.
   * Customers can choose the best suitable layout algorithm based on their
   * situation.
   * </pre>
   *
   * <code>repeated string advanced_ocr_options = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The advancedOcrOptions at the given index.
   */
  java.lang.String getAdvancedOcrOptions(int index);
  /**
   *
   *
   * <pre>
   * A list of advanced OCR options to further fine-tune OCR behavior. Current
   * valid values are:
   *
   * - `legacy_layout`: a heuristics layout detection algorithm, which serves as
   * an alternative to the current ML-based layout detection algorithm.
   * Customers can choose the best suitable layout algorithm based on their
   * situation.
   * </pre>
   *
   * <code>repeated string advanced_ocr_options = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the advancedOcrOptions at the given index.
   */
  com.google.protobuf.ByteString getAdvancedOcrOptionsBytes(int index);

  /**
   *
   *
   * <pre>
   * Includes symbol level OCR information if set to true.
   * </pre>
   *
   * <code>bool enable_symbol = 6;</code>
   *
   * @return The enableSymbol.
   */
  boolean getEnableSymbol();

  /**
   *
   *
   * <pre>
   * Turn on font identification model and return font style information.
   * Deprecated, use
   * [PremiumFeatures.compute_style_info][google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures.compute_style_info]
   * instead.
   * </pre>
   *
   * <code>bool compute_style_info = 8 [deprecated = true];</code>
   *
   * @deprecated google.cloud.documentai.v1beta3.OcrConfig.compute_style_info is deprecated. See
   *     google/cloud/documentai/v1beta3/document_io.proto;l=165
   * @return The computeStyleInfo.
   */
  @java.lang.Deprecated
  boolean getComputeStyleInfo();

  /**
   *
   *
   * <pre>
   * Turn off character box detector in OCR engine. Character box detection is
   * enabled by default in OCR 2.0 (and later) processors.
   * </pre>
   *
   * <code>bool disable_character_boxes_detection = 10;</code>
   *
   * @return The disableCharacterBoxesDetection.
   */
  boolean getDisableCharacterBoxesDetection();

  /**
   *
   *
   * <pre>
   * Configurations for premium OCR features.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures premium_features = 11;</code>
   *
   * @return Whether the premiumFeatures field is set.
   */
  boolean hasPremiumFeatures();
  /**
   *
   *
   * <pre>
   * Configurations for premium OCR features.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures premium_features = 11;</code>
   *
   * @return The premiumFeatures.
   */
  com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures getPremiumFeatures();
  /**
   *
   *
   * <pre>
   * Configurations for premium OCR features.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeatures premium_features = 11;</code>
   */
  com.google.cloud.documentai.v1beta3.OcrConfig.PremiumFeaturesOrBuilder
      getPremiumFeaturesOrBuilder();
}
