/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document_processor_service.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * Request message for the
 * [ProcessDocument][google.cloud.documentai.v1beta3.DocumentProcessorService.ProcessDocument]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.ProcessRequest}
 */
public final class ProcessRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.ProcessRequest)
    ProcessRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ProcessRequest.newBuilder() to construct.
  private ProcessRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ProcessRequest() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ProcessRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_ProcessRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 10:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_ProcessRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.ProcessRequest.class,
            com.google.cloud.documentai.v1beta3.ProcessRequest.Builder.class);
  }

  private int bitField0_;
  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INLINE_DOCUMENT(4),
    RAW_DOCUMENT(5),
    GCS_DOCUMENT(8),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 4:
          return INLINE_DOCUMENT;
        case 5:
          return RAW_DOCUMENT;
        case 8:
          return GCS_DOCUMENT;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int INLINE_DOCUMENT_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * An inline document proto.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
   *
   * @return Whether the inlineDocument field is set.
   */
  @java.lang.Override
  public boolean hasInlineDocument() {
    return sourceCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * An inline document proto.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
   *
   * @return The inlineDocument.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Document getInlineDocument() {
    if (sourceCase_ == 4) {
      return (com.google.cloud.documentai.v1beta3.Document) source_;
    }
    return com.google.cloud.documentai.v1beta3.Document.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An inline document proto.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentOrBuilder getInlineDocumentOrBuilder() {
    if (sourceCase_ == 4) {
      return (com.google.cloud.documentai.v1beta3.Document) source_;
    }
    return com.google.cloud.documentai.v1beta3.Document.getDefaultInstance();
  }

  public static final int RAW_DOCUMENT_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * A raw document content (bytes).
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
   *
   * @return Whether the rawDocument field is set.
   */
  @java.lang.Override
  public boolean hasRawDocument() {
    return sourceCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * A raw document content (bytes).
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
   *
   * @return The rawDocument.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.RawDocument getRawDocument() {
    if (sourceCase_ == 5) {
      return (com.google.cloud.documentai.v1beta3.RawDocument) source_;
    }
    return com.google.cloud.documentai.v1beta3.RawDocument.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A raw document content (bytes).
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.RawDocumentOrBuilder getRawDocumentOrBuilder() {
    if (sourceCase_ == 5) {
      return (com.google.cloud.documentai.v1beta3.RawDocument) source_;
    }
    return com.google.cloud.documentai.v1beta3.RawDocument.getDefaultInstance();
  }

  public static final int GCS_DOCUMENT_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * A raw document on Google Cloud Storage.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.GcsDocument gcs_document = 8;</code>
   *
   * @return Whether the gcsDocument field is set.
   */
  @java.lang.Override
  public boolean hasGcsDocument() {
    return sourceCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * A raw document on Google Cloud Storage.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.GcsDocument gcs_document = 8;</code>
   *
   * @return The gcsDocument.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.GcsDocument getGcsDocument() {
    if (sourceCase_ == 8) {
      return (com.google.cloud.documentai.v1beta3.GcsDocument) source_;
    }
    return com.google.cloud.documentai.v1beta3.GcsDocument.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A raw document on Google Cloud Storage.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.GcsDocument gcs_document = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.GcsDocumentOrBuilder getGcsDocumentOrBuilder() {
    if (sourceCase_ == 8) {
      return (com.google.cloud.documentai.v1beta3.GcsDocument) source_;
    }
    return com.google.cloud.documentai.v1beta3.GcsDocument.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the
   * [Processor][google.cloud.documentai.v1beta3.Processor] or
   * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
   * to use for processing. If a
   * [Processor][google.cloud.documentai.v1beta3.Processor] is specified, the
   * server will use its [default
   * version][google.cloud.documentai.v1beta3.Processor.default_processor_version].
   * Format: `projects/{project}/locations/{location}/processors/{processor}`,
   * or
   * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the
   * [Processor][google.cloud.documentai.v1beta3.Processor] or
   * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
   * to use for processing. If a
   * [Processor][google.cloud.documentai.v1beta3.Processor] is specified, the
   * server will use its [default
   * version][google.cloud.documentai.v1beta3.Processor.default_processor_version].
   * Format: `projects/{project}/locations/{location}/processors/{processor}`,
   * or
   * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOCUMENT_FIELD_NUMBER = 2;
  private com.google.cloud.documentai.v1beta3.Document document_;
  /**
   *
   *
   * <pre>
   * The document payload, the
   * [content][google.cloud.documentai.v1beta3.Document.content] and
   * [mime_type][google.cloud.documentai.v1beta3.Document.mime_type] fields must
   * be set.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
   *
   * @deprecated google.cloud.documentai.v1beta3.ProcessRequest.document is deprecated. See
   *     google/cloud/documentai/v1beta3/document_processor_service.proto;l=447
   * @return Whether the document field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasDocument() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The document payload, the
   * [content][google.cloud.documentai.v1beta3.Document.content] and
   * [mime_type][google.cloud.documentai.v1beta3.Document.mime_type] fields must
   * be set.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
   *
   * @deprecated google.cloud.documentai.v1beta3.ProcessRequest.document is deprecated. See
   *     google/cloud/documentai/v1beta3/document_processor_service.proto;l=447
   * @return The document.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.documentai.v1beta3.Document getDocument() {
    return document_ == null
        ? com.google.cloud.documentai.v1beta3.Document.getDefaultInstance()
        : document_;
  }
  /**
   *
   *
   * <pre>
   * The document payload, the
   * [content][google.cloud.documentai.v1beta3.Document.content] and
   * [mime_type][google.cloud.documentai.v1beta3.Document.mime_type] fields must
   * be set.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.documentai.v1beta3.DocumentOrBuilder getDocumentOrBuilder() {
    return document_ == null
        ? com.google.cloud.documentai.v1beta3.Document.getDefaultInstance()
        : document_;
  }

  public static final int SKIP_HUMAN_REVIEW_FIELD_NUMBER = 3;
  private boolean skipHumanReview_ = false;
  /**
   *
   *
   * <pre>
   * Whether human review should be skipped for this request. Default to
   * `false`.
   * </pre>
   *
   * <code>bool skip_human_review = 3;</code>
   *
   * @return The skipHumanReview.
   */
  @java.lang.Override
  public boolean getSkipHumanReview() {
    return skipHumanReview_;
  }

  public static final int FIELD_MASK_FIELD_NUMBER = 6;
  private com.google.protobuf.FieldMask fieldMask_;
  /**
   *
   *
   * <pre>
   * Specifies which fields to include in the
   * [ProcessResponse.document][google.cloud.documentai.v1beta3.ProcessResponse.document]
   * output. Only supports top-level document and pages field, so it must be in
   * the form of `{document_field_name}` or `pages.{page_field_name}`.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask field_mask = 6;</code>
   *
   * @return Whether the fieldMask field is set.
   */
  @java.lang.Override
  public boolean hasFieldMask() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies which fields to include in the
   * [ProcessResponse.document][google.cloud.documentai.v1beta3.ProcessResponse.document]
   * output. Only supports top-level document and pages field, so it must be in
   * the form of `{document_field_name}` or `pages.{page_field_name}`.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask field_mask = 6;</code>
   *
   * @return The fieldMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getFieldMask() {
    return fieldMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : fieldMask_;
  }
  /**
   *
   *
   * <pre>
   * Specifies which fields to include in the
   * [ProcessResponse.document][google.cloud.documentai.v1beta3.ProcessResponse.document]
   * output. Only supports top-level document and pages field, so it must be in
   * the form of `{document_field_name}` or `pages.{page_field_name}`.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask field_mask = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getFieldMaskOrBuilder() {
    return fieldMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : fieldMask_;
  }

  public static final int PROCESS_OPTIONS_FIELD_NUMBER = 7;
  private com.google.cloud.documentai.v1beta3.ProcessOptions processOptions_;
  /**
   *
   *
   * <pre>
   * Inference-time options for the process API
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
   *
   * @return Whether the processOptions field is set.
   */
  @java.lang.Override
  public boolean hasProcessOptions() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Inference-time options for the process API
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
   *
   * @return The processOptions.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ProcessOptions getProcessOptions() {
    return processOptions_ == null
        ? com.google.cloud.documentai.v1beta3.ProcessOptions.getDefaultInstance()
        : processOptions_;
  }
  /**
   *
   *
   * <pre>
   * Inference-time options for the process API
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ProcessOptionsOrBuilder getProcessOptionsOrBuilder() {
    return processOptions_ == null
        ? com.google.cloud.documentai.v1beta3.ProcessOptions.getDefaultInstance()
        : processOptions_;
  }

  public static final int LABELS_FIELD_NUMBER = 10;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
                .internal_static_google_cloud_documentai_v1beta3_ProcessRequest_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata for the request.
   *
   * Label keys and values can be no longer than 63 characters
   * (Unicode codepoints) and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. International characters are allowed.
   * Label values are optional. Label keys must start with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata for the request.
   *
   * Label keys and values can be no longer than 63 characters
   * (Unicode codepoints) and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. International characters are allowed.
   * Label values are optional. Label keys must start with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata for the request.
   *
   * Label keys and values can be no longer than 63 characters
   * (Unicode codepoints) and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. International characters are allowed.
   * Label values are optional. Label keys must start with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata for the request.
   *
   * Label keys and values can be no longer than 63 characters
   * (Unicode codepoints) and can only contain lowercase letters, numeric
   * characters, underscores, and dashes. International characters are allowed.
   * Label values are optional. Label keys must start with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getDocument());
    }
    if (skipHumanReview_ != false) {
      output.writeBool(3, skipHumanReview_);
    }
    if (sourceCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.documentai.v1beta3.Document) source_);
    }
    if (sourceCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.documentai.v1beta3.RawDocument) source_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getFieldMask());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getProcessOptions());
    }
    if (sourceCase_ == 8) {
      output.writeMessage(8, (com.google.cloud.documentai.v1beta3.GcsDocument) source_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 10);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDocument());
    }
    if (skipHumanReview_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, skipHumanReview_);
    }
    if (sourceCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.documentai.v1beta3.Document) source_);
    }
    if (sourceCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.documentai.v1beta3.RawDocument) source_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getFieldMask());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getProcessOptions());
    }
    if (sourceCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.documentai.v1beta3.GcsDocument) source_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, labels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.ProcessRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.ProcessRequest other =
        (com.google.cloud.documentai.v1beta3.ProcessRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasDocument() != other.hasDocument()) return false;
    if (hasDocument()) {
      if (!getDocument().equals(other.getDocument())) return false;
    }
    if (getSkipHumanReview() != other.getSkipHumanReview()) return false;
    if (hasFieldMask() != other.hasFieldMask()) return false;
    if (hasFieldMask()) {
      if (!getFieldMask().equals(other.getFieldMask())) return false;
    }
    if (hasProcessOptions() != other.hasProcessOptions()) return false;
    if (hasProcessOptions()) {
      if (!getProcessOptions().equals(other.getProcessOptions())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 4:
        if (!getInlineDocument().equals(other.getInlineDocument())) return false;
        break;
      case 5:
        if (!getRawDocument().equals(other.getRawDocument())) return false;
        break;
      case 8:
        if (!getGcsDocument().equals(other.getGcsDocument())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasDocument()) {
      hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
      hash = (53 * hash) + getDocument().hashCode();
    }
    hash = (37 * hash) + SKIP_HUMAN_REVIEW_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSkipHumanReview());
    if (hasFieldMask()) {
      hash = (37 * hash) + FIELD_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getFieldMask().hashCode();
    }
    if (hasProcessOptions()) {
      hash = (37 * hash) + PROCESS_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getProcessOptions().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    switch (sourceCase_) {
      case 4:
        hash = (37 * hash) + INLINE_DOCUMENT_FIELD_NUMBER;
        hash = (53 * hash) + getInlineDocument().hashCode();
        break;
      case 5:
        hash = (37 * hash) + RAW_DOCUMENT_FIELD_NUMBER;
        hash = (53 * hash) + getRawDocument().hashCode();
        break;
      case 8:
        hash = (37 * hash) + GCS_DOCUMENT_FIELD_NUMBER;
        hash = (53 * hash) + getGcsDocument().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.documentai.v1beta3.ProcessRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for the
   * [ProcessDocument][google.cloud.documentai.v1beta3.DocumentProcessorService.ProcessDocument]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.ProcessRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.ProcessRequest)
      com.google.cloud.documentai.v1beta3.ProcessRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ProcessRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 10:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 10:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ProcessRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.ProcessRequest.class,
              com.google.cloud.documentai.v1beta3.ProcessRequest.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.ProcessRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDocumentFieldBuilder();
        getFieldMaskFieldBuilder();
        getProcessOptionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (inlineDocumentBuilder_ != null) {
        inlineDocumentBuilder_.clear();
      }
      if (rawDocumentBuilder_ != null) {
        rawDocumentBuilder_.clear();
      }
      if (gcsDocumentBuilder_ != null) {
        gcsDocumentBuilder_.clear();
      }
      name_ = "";
      document_ = null;
      if (documentBuilder_ != null) {
        documentBuilder_.dispose();
        documentBuilder_ = null;
      }
      skipHumanReview_ = false;
      fieldMask_ = null;
      if (fieldMaskBuilder_ != null) {
        fieldMaskBuilder_.dispose();
        fieldMaskBuilder_ = null;
      }
      processOptions_ = null;
      if (processOptionsBuilder_ != null) {
        processOptionsBuilder_.dispose();
        processOptionsBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ProcessRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessRequest getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.ProcessRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessRequest build() {
      com.google.cloud.documentai.v1beta3.ProcessRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessRequest buildPartial() {
      com.google.cloud.documentai.v1beta3.ProcessRequest result =
          new com.google.cloud.documentai.v1beta3.ProcessRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta3.ProcessRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.document_ = documentBuilder_ == null ? document_ : documentBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.skipHumanReview_ = skipHumanReview_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.fieldMask_ = fieldMaskBuilder_ == null ? fieldMask_ : fieldMaskBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.processOptions_ =
            processOptionsBuilder_ == null ? processOptions_ : processOptionsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.documentai.v1beta3.ProcessRequest result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 4 && inlineDocumentBuilder_ != null) {
        result.source_ = inlineDocumentBuilder_.build();
      }
      if (sourceCase_ == 5 && rawDocumentBuilder_ != null) {
        result.source_ = rawDocumentBuilder_.build();
      }
      if (sourceCase_ == 8 && gcsDocumentBuilder_ != null) {
        result.source_ = gcsDocumentBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.ProcessRequest) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.ProcessRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.ProcessRequest other) {
      if (other == com.google.cloud.documentai.v1beta3.ProcessRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasDocument()) {
        mergeDocument(other.getDocument());
      }
      if (other.getSkipHumanReview() != false) {
        setSkipHumanReview(other.getSkipHumanReview());
      }
      if (other.hasFieldMask()) {
        mergeFieldMask(other.getFieldMask());
      }
      if (other.hasProcessOptions()) {
        mergeProcessOptions(other.getProcessOptions());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000100;
      switch (other.getSourceCase()) {
        case INLINE_DOCUMENT:
          {
            mergeInlineDocument(other.getInlineDocument());
            break;
          }
        case RAW_DOCUMENT:
          {
            mergeRawDocument(other.getRawDocument());
            break;
          }
        case GCS_DOCUMENT:
          {
            mergeGcsDocument(other.getGcsDocument());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getDocumentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 18
            case 24:
              {
                skipHumanReview_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getInlineDocumentFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getRawDocumentFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getFieldMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getProcessOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getGcsDocumentFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 8;
                break;
              } // case 66
            case 82:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Document,
            com.google.cloud.documentai.v1beta3.Document.Builder,
            com.google.cloud.documentai.v1beta3.DocumentOrBuilder>
        inlineDocumentBuilder_;
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     *
     * @return Whether the inlineDocument field is set.
     */
    @java.lang.Override
    public boolean hasInlineDocument() {
      return sourceCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     *
     * @return The inlineDocument.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Document getInlineDocument() {
      if (inlineDocumentBuilder_ == null) {
        if (sourceCase_ == 4) {
          return (com.google.cloud.documentai.v1beta3.Document) source_;
        }
        return com.google.cloud.documentai.v1beta3.Document.getDefaultInstance();
      } else {
        if (sourceCase_ == 4) {
          return inlineDocumentBuilder_.getMessage();
        }
        return com.google.cloud.documentai.v1beta3.Document.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    public Builder setInlineDocument(com.google.cloud.documentai.v1beta3.Document value) {
      if (inlineDocumentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        inlineDocumentBuilder_.setMessage(value);
      }
      sourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    public Builder setInlineDocument(
        com.google.cloud.documentai.v1beta3.Document.Builder builderForValue) {
      if (inlineDocumentBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        inlineDocumentBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    public Builder mergeInlineDocument(com.google.cloud.documentai.v1beta3.Document value) {
      if (inlineDocumentBuilder_ == null) {
        if (sourceCase_ == 4
            && source_ != com.google.cloud.documentai.v1beta3.Document.getDefaultInstance()) {
          source_ =
              com.google.cloud.documentai.v1beta3.Document.newBuilder(
                      (com.google.cloud.documentai.v1beta3.Document) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 4) {
          inlineDocumentBuilder_.mergeFrom(value);
        } else {
          inlineDocumentBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    public Builder clearInlineDocument() {
      if (inlineDocumentBuilder_ == null) {
        if (sourceCase_ == 4) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 4) {
          sourceCase_ = 0;
          source_ = null;
        }
        inlineDocumentBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    public com.google.cloud.documentai.v1beta3.Document.Builder getInlineDocumentBuilder() {
      return getInlineDocumentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentOrBuilder getInlineDocumentOrBuilder() {
      if ((sourceCase_ == 4) && (inlineDocumentBuilder_ != null)) {
        return inlineDocumentBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 4) {
          return (com.google.cloud.documentai.v1beta3.Document) source_;
        }
        return com.google.cloud.documentai.v1beta3.Document.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Document,
            com.google.cloud.documentai.v1beta3.Document.Builder,
            com.google.cloud.documentai.v1beta3.DocumentOrBuilder>
        getInlineDocumentFieldBuilder() {
      if (inlineDocumentBuilder_ == null) {
        if (!(sourceCase_ == 4)) {
          source_ = com.google.cloud.documentai.v1beta3.Document.getDefaultInstance();
        }
        inlineDocumentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document,
                com.google.cloud.documentai.v1beta3.Document.Builder,
                com.google.cloud.documentai.v1beta3.DocumentOrBuilder>(
                (com.google.cloud.documentai.v1beta3.Document) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 4;
      onChanged();
      return inlineDocumentBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.RawDocument,
            com.google.cloud.documentai.v1beta3.RawDocument.Builder,
            com.google.cloud.documentai.v1beta3.RawDocumentOrBuilder>
        rawDocumentBuilder_;
    /**
     *
     *
     * <pre>
     * A raw document content (bytes).
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
     *
     * @return Whether the rawDocument field is set.
     */
    @java.lang.Override
    public boolean hasRawDocument() {
      return sourceCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * A raw document content (bytes).
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
     *
     * @return The rawDocument.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.RawDocument getRawDocument() {
      if (rawDocumentBuilder_ == null) {
        if (sourceCase_ == 5) {
          return (com.google.cloud.documentai.v1beta3.RawDocument) source_;
        }
        return com.google.cloud.documentai.v1beta3.RawDocument.getDefaultInstance();
      } else {
        if (sourceCase_ == 5) {
          return rawDocumentBuilder_.getMessage();
        }
        return com.google.cloud.documentai.v1beta3.RawDocument.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A raw document content (bytes).
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
     */
    public Builder setRawDocument(com.google.cloud.documentai.v1beta3.RawDocument value) {
      if (rawDocumentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        rawDocumentBuilder_.setMessage(value);
      }
      sourceCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A raw document content (bytes).
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
     */
    public Builder setRawDocument(
        com.google.cloud.documentai.v1beta3.RawDocument.Builder builderForValue) {
      if (rawDocumentBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        rawDocumentBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A raw document content (bytes).
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
     */
    public Builder mergeRawDocument(com.google.cloud.documentai.v1beta3.RawDocument value) {
      if (rawDocumentBuilder_ == null) {
        if (sourceCase_ == 5
            && source_ != com.google.cloud.documentai.v1beta3.RawDocument.getDefaultInstance()) {
          source_ =
              com.google.cloud.documentai.v1beta3.RawDocument.newBuilder(
                      (com.google.cloud.documentai.v1beta3.RawDocument) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 5) {
          rawDocumentBuilder_.mergeFrom(value);
        } else {
          rawDocumentBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A raw document content (bytes).
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
     */
    public Builder clearRawDocument() {
      if (rawDocumentBuilder_ == null) {
        if (sourceCase_ == 5) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 5) {
          sourceCase_ = 0;
          source_ = null;
        }
        rawDocumentBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A raw document content (bytes).
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
     */
    public com.google.cloud.documentai.v1beta3.RawDocument.Builder getRawDocumentBuilder() {
      return getRawDocumentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A raw document content (bytes).
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.RawDocumentOrBuilder getRawDocumentOrBuilder() {
      if ((sourceCase_ == 5) && (rawDocumentBuilder_ != null)) {
        return rawDocumentBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 5) {
          return (com.google.cloud.documentai.v1beta3.RawDocument) source_;
        }
        return com.google.cloud.documentai.v1beta3.RawDocument.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A raw document content (bytes).
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RawDocument raw_document = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.RawDocument,
            com.google.cloud.documentai.v1beta3.RawDocument.Builder,
            com.google.cloud.documentai.v1beta3.RawDocumentOrBuilder>
        getRawDocumentFieldBuilder() {
      if (rawDocumentBuilder_ == null) {
        if (!(sourceCase_ == 5)) {
          source_ = com.google.cloud.documentai.v1beta3.RawDocument.getDefaultInstance();
        }
        rawDocumentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.RawDocument,
                com.google.cloud.documentai.v1beta3.RawDocument.Builder,
                com.google.cloud.documentai.v1beta3.RawDocumentOrBuilder>(
                (com.google.cloud.documentai.v1beta3.RawDocument) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 5;
      onChanged();
      return rawDocumentBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.GcsDocument,
            com.google.cloud.documentai.v1beta3.GcsDocument.Builder,
            com.google.cloud.documentai.v1beta3.GcsDocumentOrBuilder>
        gcsDocumentBuilder_;
    /**
     *
     *
     * <pre>
     * A raw document on Google Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.GcsDocument gcs_document = 8;</code>
     *
     * @return Whether the gcsDocument field is set.
     */
    @java.lang.Override
    public boolean hasGcsDocument() {
      return sourceCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * A raw document on Google Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.GcsDocument gcs_document = 8;</code>
     *
     * @return The gcsDocument.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.GcsDocument getGcsDocument() {
      if (gcsDocumentBuilder_ == null) {
        if (sourceCase_ == 8) {
          return (com.google.cloud.documentai.v1beta3.GcsDocument) source_;
        }
        return com.google.cloud.documentai.v1beta3.GcsDocument.getDefaultInstance();
      } else {
        if (sourceCase_ == 8) {
          return gcsDocumentBuilder_.getMessage();
        }
        return com.google.cloud.documentai.v1beta3.GcsDocument.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A raw document on Google Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.GcsDocument gcs_document = 8;</code>
     */
    public Builder setGcsDocument(com.google.cloud.documentai.v1beta3.GcsDocument value) {
      if (gcsDocumentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        gcsDocumentBuilder_.setMessage(value);
      }
      sourceCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A raw document on Google Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.GcsDocument gcs_document = 8;</code>
     */
    public Builder setGcsDocument(
        com.google.cloud.documentai.v1beta3.GcsDocument.Builder builderForValue) {
      if (gcsDocumentBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        gcsDocumentBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A raw document on Google Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.GcsDocument gcs_document = 8;</code>
     */
    public Builder mergeGcsDocument(com.google.cloud.documentai.v1beta3.GcsDocument value) {
      if (gcsDocumentBuilder_ == null) {
        if (sourceCase_ == 8
            && source_ != com.google.cloud.documentai.v1beta3.GcsDocument.getDefaultInstance()) {
          source_ =
              com.google.cloud.documentai.v1beta3.GcsDocument.newBuilder(
                      (com.google.cloud.documentai.v1beta3.GcsDocument) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 8) {
          gcsDocumentBuilder_.mergeFrom(value);
        } else {
          gcsDocumentBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A raw document on Google Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.GcsDocument gcs_document = 8;</code>
     */
    public Builder clearGcsDocument() {
      if (gcsDocumentBuilder_ == null) {
        if (sourceCase_ == 8) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 8) {
          sourceCase_ = 0;
          source_ = null;
        }
        gcsDocumentBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A raw document on Google Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.GcsDocument gcs_document = 8;</code>
     */
    public com.google.cloud.documentai.v1beta3.GcsDocument.Builder getGcsDocumentBuilder() {
      return getGcsDocumentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A raw document on Google Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.GcsDocument gcs_document = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.GcsDocumentOrBuilder getGcsDocumentOrBuilder() {
      if ((sourceCase_ == 8) && (gcsDocumentBuilder_ != null)) {
        return gcsDocumentBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 8) {
          return (com.google.cloud.documentai.v1beta3.GcsDocument) source_;
        }
        return com.google.cloud.documentai.v1beta3.GcsDocument.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A raw document on Google Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.GcsDocument gcs_document = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.GcsDocument,
            com.google.cloud.documentai.v1beta3.GcsDocument.Builder,
            com.google.cloud.documentai.v1beta3.GcsDocumentOrBuilder>
        getGcsDocumentFieldBuilder() {
      if (gcsDocumentBuilder_ == null) {
        if (!(sourceCase_ == 8)) {
          source_ = com.google.cloud.documentai.v1beta3.GcsDocument.getDefaultInstance();
        }
        gcsDocumentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.GcsDocument,
                com.google.cloud.documentai.v1beta3.GcsDocument.Builder,
                com.google.cloud.documentai.v1beta3.GcsDocumentOrBuilder>(
                (com.google.cloud.documentai.v1beta3.GcsDocument) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 8;
      onChanged();
      return gcsDocumentBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [Processor][google.cloud.documentai.v1beta3.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
     * to use for processing. If a
     * [Processor][google.cloud.documentai.v1beta3.Processor] is specified, the
     * server will use its [default
     * version][google.cloud.documentai.v1beta3.Processor.default_processor_version].
     * Format: `projects/{project}/locations/{location}/processors/{processor}`,
     * or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [Processor][google.cloud.documentai.v1beta3.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
     * to use for processing. If a
     * [Processor][google.cloud.documentai.v1beta3.Processor] is specified, the
     * server will use its [default
     * version][google.cloud.documentai.v1beta3.Processor.default_processor_version].
     * Format: `projects/{project}/locations/{location}/processors/{processor}`,
     * or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [Processor][google.cloud.documentai.v1beta3.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
     * to use for processing. If a
     * [Processor][google.cloud.documentai.v1beta3.Processor] is specified, the
     * server will use its [default
     * version][google.cloud.documentai.v1beta3.Processor.default_processor_version].
     * Format: `projects/{project}/locations/{location}/processors/{processor}`,
     * or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [Processor][google.cloud.documentai.v1beta3.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
     * to use for processing. If a
     * [Processor][google.cloud.documentai.v1beta3.Processor] is specified, the
     * server will use its [default
     * version][google.cloud.documentai.v1beta3.Processor.default_processor_version].
     * Format: `projects/{project}/locations/{location}/processors/{processor}`,
     * or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [Processor][google.cloud.documentai.v1beta3.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
     * to use for processing. If a
     * [Processor][google.cloud.documentai.v1beta3.Processor] is specified, the
     * server will use its [default
     * version][google.cloud.documentai.v1beta3.Processor.default_processor_version].
     * Format: `projects/{project}/locations/{location}/processors/{processor}`,
     * or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.documentai.v1beta3.Document document_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Document,
            com.google.cloud.documentai.v1beta3.Document.Builder,
            com.google.cloud.documentai.v1beta3.DocumentOrBuilder>
        documentBuilder_;
    /**
     *
     *
     * <pre>
     * The document payload, the
     * [content][google.cloud.documentai.v1beta3.Document.content] and
     * [mime_type][google.cloud.documentai.v1beta3.Document.mime_type] fields must
     * be set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.documentai.v1beta3.ProcessRequest.document is deprecated. See
     *     google/cloud/documentai/v1beta3/document_processor_service.proto;l=447
     * @return Whether the document field is set.
     */
    @java.lang.Deprecated
    public boolean hasDocument() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The document payload, the
     * [content][google.cloud.documentai.v1beta3.Document.content] and
     * [mime_type][google.cloud.documentai.v1beta3.Document.mime_type] fields must
     * be set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.documentai.v1beta3.ProcessRequest.document is deprecated. See
     *     google/cloud/documentai/v1beta3/document_processor_service.proto;l=447
     * @return The document.
     */
    @java.lang.Deprecated
    public com.google.cloud.documentai.v1beta3.Document getDocument() {
      if (documentBuilder_ == null) {
        return document_ == null
            ? com.google.cloud.documentai.v1beta3.Document.getDefaultInstance()
            : document_;
      } else {
        return documentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The document payload, the
     * [content][google.cloud.documentai.v1beta3.Document.content] and
     * [mime_type][google.cloud.documentai.v1beta3.Document.mime_type] fields must
     * be set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setDocument(com.google.cloud.documentai.v1beta3.Document value) {
      if (documentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        document_ = value;
      } else {
        documentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The document payload, the
     * [content][google.cloud.documentai.v1beta3.Document.content] and
     * [mime_type][google.cloud.documentai.v1beta3.Document.mime_type] fields must
     * be set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setDocument(
        com.google.cloud.documentai.v1beta3.Document.Builder builderForValue) {
      if (documentBuilder_ == null) {
        document_ = builderForValue.build();
      } else {
        documentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The document payload, the
     * [content][google.cloud.documentai.v1beta3.Document.content] and
     * [mime_type][google.cloud.documentai.v1beta3.Document.mime_type] fields must
     * be set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder mergeDocument(com.google.cloud.documentai.v1beta3.Document value) {
      if (documentBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && document_ != null
            && document_ != com.google.cloud.documentai.v1beta3.Document.getDefaultInstance()) {
          getDocumentBuilder().mergeFrom(value);
        } else {
          document_ = value;
        }
      } else {
        documentBuilder_.mergeFrom(value);
      }
      if (document_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The document payload, the
     * [content][google.cloud.documentai.v1beta3.Document.content] and
     * [mime_type][google.cloud.documentai.v1beta3.Document.mime_type] fields must
     * be set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder clearDocument() {
      bitField0_ = (bitField0_ & ~0x00000010);
      document_ = null;
      if (documentBuilder_ != null) {
        documentBuilder_.dispose();
        documentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The document payload, the
     * [content][google.cloud.documentai.v1beta3.Document.content] and
     * [mime_type][google.cloud.documentai.v1beta3.Document.mime_type] fields must
     * be set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.cloud.documentai.v1beta3.Document.Builder getDocumentBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getDocumentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The document payload, the
     * [content][google.cloud.documentai.v1beta3.Document.content] and
     * [mime_type][google.cloud.documentai.v1beta3.Document.mime_type] fields must
     * be set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.cloud.documentai.v1beta3.DocumentOrBuilder getDocumentOrBuilder() {
      if (documentBuilder_ != null) {
        return documentBuilder_.getMessageOrBuilder();
      } else {
        return document_ == null
            ? com.google.cloud.documentai.v1beta3.Document.getDefaultInstance()
            : document_;
      }
    }
    /**
     *
     *
     * <pre>
     * The document payload, the
     * [content][google.cloud.documentai.v1beta3.Document.content] and
     * [mime_type][google.cloud.documentai.v1beta3.Document.mime_type] fields must
     * be set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Document,
            com.google.cloud.documentai.v1beta3.Document.Builder,
            com.google.cloud.documentai.v1beta3.DocumentOrBuilder>
        getDocumentFieldBuilder() {
      if (documentBuilder_ == null) {
        documentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document,
                com.google.cloud.documentai.v1beta3.Document.Builder,
                com.google.cloud.documentai.v1beta3.DocumentOrBuilder>(
                getDocument(), getParentForChildren(), isClean());
        document_ = null;
      }
      return documentBuilder_;
    }

    private boolean skipHumanReview_;
    /**
     *
     *
     * <pre>
     * Whether human review should be skipped for this request. Default to
     * `false`.
     * </pre>
     *
     * <code>bool skip_human_review = 3;</code>
     *
     * @return The skipHumanReview.
     */
    @java.lang.Override
    public boolean getSkipHumanReview() {
      return skipHumanReview_;
    }
    /**
     *
     *
     * <pre>
     * Whether human review should be skipped for this request. Default to
     * `false`.
     * </pre>
     *
     * <code>bool skip_human_review = 3;</code>
     *
     * @param value The skipHumanReview to set.
     * @return This builder for chaining.
     */
    public Builder setSkipHumanReview(boolean value) {

      skipHumanReview_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether human review should be skipped for this request. Default to
     * `false`.
     * </pre>
     *
     * <code>bool skip_human_review = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSkipHumanReview() {
      bitField0_ = (bitField0_ & ~0x00000020);
      skipHumanReview_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.FieldMask fieldMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        fieldMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in the
     * [ProcessResponse.document][google.cloud.documentai.v1beta3.ProcessResponse.document]
     * output. Only supports top-level document and pages field, so it must be in
     * the form of `{document_field_name}` or `pages.{page_field_name}`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     *
     * @return Whether the fieldMask field is set.
     */
    public boolean hasFieldMask() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in the
     * [ProcessResponse.document][google.cloud.documentai.v1beta3.ProcessResponse.document]
     * output. Only supports top-level document and pages field, so it must be in
     * the form of `{document_field_name}` or `pages.{page_field_name}`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     *
     * @return The fieldMask.
     */
    public com.google.protobuf.FieldMask getFieldMask() {
      if (fieldMaskBuilder_ == null) {
        return fieldMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : fieldMask_;
      } else {
        return fieldMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in the
     * [ProcessResponse.document][google.cloud.documentai.v1beta3.ProcessResponse.document]
     * output. Only supports top-level document and pages field, so it must be in
     * the form of `{document_field_name}` or `pages.{page_field_name}`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    public Builder setFieldMask(com.google.protobuf.FieldMask value) {
      if (fieldMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fieldMask_ = value;
      } else {
        fieldMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in the
     * [ProcessResponse.document][google.cloud.documentai.v1beta3.ProcessResponse.document]
     * output. Only supports top-level document and pages field, so it must be in
     * the form of `{document_field_name}` or `pages.{page_field_name}`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    public Builder setFieldMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (fieldMaskBuilder_ == null) {
        fieldMask_ = builderForValue.build();
      } else {
        fieldMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in the
     * [ProcessResponse.document][google.cloud.documentai.v1beta3.ProcessResponse.document]
     * output. Only supports top-level document and pages field, so it must be in
     * the form of `{document_field_name}` or `pages.{page_field_name}`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    public Builder mergeFieldMask(com.google.protobuf.FieldMask value) {
      if (fieldMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && fieldMask_ != null
            && fieldMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getFieldMaskBuilder().mergeFrom(value);
        } else {
          fieldMask_ = value;
        }
      } else {
        fieldMaskBuilder_.mergeFrom(value);
      }
      if (fieldMask_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in the
     * [ProcessResponse.document][google.cloud.documentai.v1beta3.ProcessResponse.document]
     * output. Only supports top-level document and pages field, so it must be in
     * the form of `{document_field_name}` or `pages.{page_field_name}`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    public Builder clearFieldMask() {
      bitField0_ = (bitField0_ & ~0x00000040);
      fieldMask_ = null;
      if (fieldMaskBuilder_ != null) {
        fieldMaskBuilder_.dispose();
        fieldMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in the
     * [ProcessResponse.document][google.cloud.documentai.v1beta3.ProcessResponse.document]
     * output. Only supports top-level document and pages field, so it must be in
     * the form of `{document_field_name}` or `pages.{page_field_name}`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    public com.google.protobuf.FieldMask.Builder getFieldMaskBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getFieldMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in the
     * [ProcessResponse.document][google.cloud.documentai.v1beta3.ProcessResponse.document]
     * output. Only supports top-level document and pages field, so it must be in
     * the form of `{document_field_name}` or `pages.{page_field_name}`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getFieldMaskOrBuilder() {
      if (fieldMaskBuilder_ != null) {
        return fieldMaskBuilder_.getMessageOrBuilder();
      } else {
        return fieldMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : fieldMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in the
     * [ProcessResponse.document][google.cloud.documentai.v1beta3.ProcessResponse.document]
     * output. Only supports top-level document and pages field, so it must be in
     * the form of `{document_field_name}` or `pages.{page_field_name}`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getFieldMaskFieldBuilder() {
      if (fieldMaskBuilder_ == null) {
        fieldMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getFieldMask(), getParentForChildren(), isClean());
        fieldMask_ = null;
      }
      return fieldMaskBuilder_;
    }

    private com.google.cloud.documentai.v1beta3.ProcessOptions processOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ProcessOptions,
            com.google.cloud.documentai.v1beta3.ProcessOptions.Builder,
            com.google.cloud.documentai.v1beta3.ProcessOptionsOrBuilder>
        processOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Inference-time options for the process API
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
     *
     * @return Whether the processOptions field is set.
     */
    public boolean hasProcessOptions() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Inference-time options for the process API
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
     *
     * @return The processOptions.
     */
    public com.google.cloud.documentai.v1beta3.ProcessOptions getProcessOptions() {
      if (processOptionsBuilder_ == null) {
        return processOptions_ == null
            ? com.google.cloud.documentai.v1beta3.ProcessOptions.getDefaultInstance()
            : processOptions_;
      } else {
        return processOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Inference-time options for the process API
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
     */
    public Builder setProcessOptions(com.google.cloud.documentai.v1beta3.ProcessOptions value) {
      if (processOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        processOptions_ = value;
      } else {
        processOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inference-time options for the process API
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
     */
    public Builder setProcessOptions(
        com.google.cloud.documentai.v1beta3.ProcessOptions.Builder builderForValue) {
      if (processOptionsBuilder_ == null) {
        processOptions_ = builderForValue.build();
      } else {
        processOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inference-time options for the process API
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
     */
    public Builder mergeProcessOptions(com.google.cloud.documentai.v1beta3.ProcessOptions value) {
      if (processOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && processOptions_ != null
            && processOptions_
                != com.google.cloud.documentai.v1beta3.ProcessOptions.getDefaultInstance()) {
          getProcessOptionsBuilder().mergeFrom(value);
        } else {
          processOptions_ = value;
        }
      } else {
        processOptionsBuilder_.mergeFrom(value);
      }
      if (processOptions_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inference-time options for the process API
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
     */
    public Builder clearProcessOptions() {
      bitField0_ = (bitField0_ & ~0x00000080);
      processOptions_ = null;
      if (processOptionsBuilder_ != null) {
        processOptionsBuilder_.dispose();
        processOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inference-time options for the process API
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
     */
    public com.google.cloud.documentai.v1beta3.ProcessOptions.Builder getProcessOptionsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getProcessOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Inference-time options for the process API
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
     */
    public com.google.cloud.documentai.v1beta3.ProcessOptionsOrBuilder
        getProcessOptionsOrBuilder() {
      if (processOptionsBuilder_ != null) {
        return processOptionsBuilder_.getMessageOrBuilder();
      } else {
        return processOptions_ == null
            ? com.google.cloud.documentai.v1beta3.ProcessOptions.getDefaultInstance()
            : processOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Inference-time options for the process API
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ProcessOptions process_options = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ProcessOptions,
            com.google.cloud.documentai.v1beta3.ProcessOptions.Builder,
            com.google.cloud.documentai.v1beta3.ProcessOptionsOrBuilder>
        getProcessOptionsFieldBuilder() {
      if (processOptionsBuilder_ == null) {
        processOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.ProcessOptions,
                com.google.cloud.documentai.v1beta3.ProcessOptions.Builder,
                com.google.cloud.documentai.v1beta3.ProcessOptionsOrBuilder>(
                getProcessOptions(), getParentForChildren(), isClean());
        processOptions_ = null;
      }
      return processOptionsBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are allowed.
     * Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are allowed.
     * Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are allowed.
     * Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are allowed.
     * Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000100);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are allowed.
     * Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000100;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are allowed.
     * Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     *
     * Label keys and values can be no longer than 63 characters
     * (Unicode codepoints) and can only contain lowercase letters, numeric
     * characters, underscores, and dashes. International characters are allowed.
     * Label values are optional. Label keys must start with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000100;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.ProcessRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.ProcessRequest)
  private static final com.google.cloud.documentai.v1beta3.ProcessRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.ProcessRequest();
  }

  public static com.google.cloud.documentai.v1beta3.ProcessRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ProcessRequest> PARSER =
      new com.google.protobuf.AbstractParser<ProcessRequest>() {
        @java.lang.Override
        public ProcessRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ProcessRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ProcessRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ProcessRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
