/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/barcode.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * Encodes the detailed information of a barcode.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.Barcode}
 */
public final class Barcode extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Barcode)
    BarcodeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Barcode.newBuilder() to construct.
  private Barcode(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Barcode() {
    format_ = "";
    valueFormat_ = "";
    rawValue_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Barcode();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.BarcodeProto
        .internal_static_google_cloud_documentai_v1beta3_Barcode_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.BarcodeProto
        .internal_static_google_cloud_documentai_v1beta3_Barcode_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.Barcode.class,
            com.google.cloud.documentai.v1beta3.Barcode.Builder.class);
  }

  public static final int FORMAT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object format_ = "";
  /**
   *
   *
   * <pre>
   * Format of a barcode.
   * The supported formats are:
   *
   * - `CODE_128`: Code 128 type.
   * - `CODE_39`: Code 39 type.
   * - `CODE_93`: Code 93 type.
   * - `CODABAR`: Codabar type.
   * - `DATA_MATRIX`: 2D Data Matrix type.
   * - `ITF`: ITF type.
   * - `EAN_13`: EAN-13 type.
   * - `EAN_8`: EAN-8 type.
   * - `QR_CODE`: 2D QR code type.
   * - `UPC_A`: UPC-A type.
   * - `UPC_E`: UPC-E type.
   * - `PDF417`: PDF417 type.
   * - `AZTEC`: 2D Aztec code type.
   * - `DATABAR`: GS1 DataBar code type.
   * </pre>
   *
   * <code>string format = 1;</code>
   *
   * @return The format.
   */
  @java.lang.Override
  public java.lang.String getFormat() {
    java.lang.Object ref = format_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      format_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Format of a barcode.
   * The supported formats are:
   *
   * - `CODE_128`: Code 128 type.
   * - `CODE_39`: Code 39 type.
   * - `CODE_93`: Code 93 type.
   * - `CODABAR`: Codabar type.
   * - `DATA_MATRIX`: 2D Data Matrix type.
   * - `ITF`: ITF type.
   * - `EAN_13`: EAN-13 type.
   * - `EAN_8`: EAN-8 type.
   * - `QR_CODE`: 2D QR code type.
   * - `UPC_A`: UPC-A type.
   * - `UPC_E`: UPC-E type.
   * - `PDF417`: PDF417 type.
   * - `AZTEC`: 2D Aztec code type.
   * - `DATABAR`: GS1 DataBar code type.
   * </pre>
   *
   * <code>string format = 1;</code>
   *
   * @return The bytes for format.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFormatBytes() {
    java.lang.Object ref = format_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      format_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALUE_FORMAT_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object valueFormat_ = "";
  /**
   *
   *
   * <pre>
   * Value format describes the format of the value that a barcode
   * encodes.
   * The supported formats are:
   *
   * - `CONTACT_INFO`: Contact information.
   * - `EMAIL`: Email address.
   * - `ISBN`: ISBN identifier.
   * - `PHONE`: Phone number.
   * - `PRODUCT`: Product.
   * - `SMS`: SMS message.
   * - `TEXT`: Text string.
   * - `URL`: URL address.
   * - `WIFI`: Wifi information.
   * - `GEO`: Geo-localization.
   * - `CALENDAR_EVENT`: Calendar event.
   * - `DRIVER_LICENSE`: Driver's license.
   * </pre>
   *
   * <code>string value_format = 2;</code>
   *
   * @return The valueFormat.
   */
  @java.lang.Override
  public java.lang.String getValueFormat() {
    java.lang.Object ref = valueFormat_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      valueFormat_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Value format describes the format of the value that a barcode
   * encodes.
   * The supported formats are:
   *
   * - `CONTACT_INFO`: Contact information.
   * - `EMAIL`: Email address.
   * - `ISBN`: ISBN identifier.
   * - `PHONE`: Phone number.
   * - `PRODUCT`: Product.
   * - `SMS`: SMS message.
   * - `TEXT`: Text string.
   * - `URL`: URL address.
   * - `WIFI`: Wifi information.
   * - `GEO`: Geo-localization.
   * - `CALENDAR_EVENT`: Calendar event.
   * - `DRIVER_LICENSE`: Driver's license.
   * </pre>
   *
   * <code>string value_format = 2;</code>
   *
   * @return The bytes for valueFormat.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getValueFormatBytes() {
    java.lang.Object ref = valueFormat_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      valueFormat_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RAW_VALUE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rawValue_ = "";
  /**
   *
   *
   * <pre>
   * Raw value encoded in the barcode.
   * For example: `'MEBKM:TITLE:Google;URL:https://www.google.com;;'`.
   * </pre>
   *
   * <code>string raw_value = 3;</code>
   *
   * @return The rawValue.
   */
  @java.lang.Override
  public java.lang.String getRawValue() {
    java.lang.Object ref = rawValue_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rawValue_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Raw value encoded in the barcode.
   * For example: `'MEBKM:TITLE:Google;URL:https://www.google.com;;'`.
   * </pre>
   *
   * <code>string raw_value = 3;</code>
   *
   * @return The bytes for rawValue.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRawValueBytes() {
    java.lang.Object ref = rawValue_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rawValue_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(format_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, format_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(valueFormat_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, valueFormat_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rawValue_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, rawValue_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(format_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, format_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(valueFormat_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, valueFormat_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rawValue_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, rawValue_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.Barcode)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.Barcode other =
        (com.google.cloud.documentai.v1beta3.Barcode) obj;

    if (!getFormat().equals(other.getFormat())) return false;
    if (!getValueFormat().equals(other.getValueFormat())) return false;
    if (!getRawValue().equals(other.getRawValue())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + getFormat().hashCode();
    hash = (37 * hash) + VALUE_FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + getValueFormat().hashCode();
    hash = (37 * hash) + RAW_VALUE_FIELD_NUMBER;
    hash = (53 * hash) + getRawValue().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.Barcode parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.Barcode parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.Barcode parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.Barcode parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.Barcode parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.Barcode parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.Barcode parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.Barcode parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.Barcode parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.Barcode parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.Barcode parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.Barcode parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.documentai.v1beta3.Barcode prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Encodes the detailed information of a barcode.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.Barcode}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Barcode)
      com.google.cloud.documentai.v1beta3.BarcodeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.BarcodeProto
          .internal_static_google_cloud_documentai_v1beta3_Barcode_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.BarcodeProto
          .internal_static_google_cloud_documentai_v1beta3_Barcode_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.Barcode.class,
              com.google.cloud.documentai.v1beta3.Barcode.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.Barcode.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      format_ = "";
      valueFormat_ = "";
      rawValue_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.BarcodeProto
          .internal_static_google_cloud_documentai_v1beta3_Barcode_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Barcode getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.Barcode.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Barcode build() {
      com.google.cloud.documentai.v1beta3.Barcode result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Barcode buildPartial() {
      com.google.cloud.documentai.v1beta3.Barcode result =
          new com.google.cloud.documentai.v1beta3.Barcode(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta3.Barcode result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.format_ = format_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.valueFormat_ = valueFormat_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.rawValue_ = rawValue_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.Barcode) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.Barcode) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.Barcode other) {
      if (other == com.google.cloud.documentai.v1beta3.Barcode.getDefaultInstance()) return this;
      if (!other.getFormat().isEmpty()) {
        format_ = other.format_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getValueFormat().isEmpty()) {
        valueFormat_ = other.valueFormat_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getRawValue().isEmpty()) {
        rawValue_ = other.rawValue_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                format_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                valueFormat_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                rawValue_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object format_ = "";
    /**
     *
     *
     * <pre>
     * Format of a barcode.
     * The supported formats are:
     *
     * - `CODE_128`: Code 128 type.
     * - `CODE_39`: Code 39 type.
     * - `CODE_93`: Code 93 type.
     * - `CODABAR`: Codabar type.
     * - `DATA_MATRIX`: 2D Data Matrix type.
     * - `ITF`: ITF type.
     * - `EAN_13`: EAN-13 type.
     * - `EAN_8`: EAN-8 type.
     * - `QR_CODE`: 2D QR code type.
     * - `UPC_A`: UPC-A type.
     * - `UPC_E`: UPC-E type.
     * - `PDF417`: PDF417 type.
     * - `AZTEC`: 2D Aztec code type.
     * - `DATABAR`: GS1 DataBar code type.
     * </pre>
     *
     * <code>string format = 1;</code>
     *
     * @return The format.
     */
    public java.lang.String getFormat() {
      java.lang.Object ref = format_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        format_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Format of a barcode.
     * The supported formats are:
     *
     * - `CODE_128`: Code 128 type.
     * - `CODE_39`: Code 39 type.
     * - `CODE_93`: Code 93 type.
     * - `CODABAR`: Codabar type.
     * - `DATA_MATRIX`: 2D Data Matrix type.
     * - `ITF`: ITF type.
     * - `EAN_13`: EAN-13 type.
     * - `EAN_8`: EAN-8 type.
     * - `QR_CODE`: 2D QR code type.
     * - `UPC_A`: UPC-A type.
     * - `UPC_E`: UPC-E type.
     * - `PDF417`: PDF417 type.
     * - `AZTEC`: 2D Aztec code type.
     * - `DATABAR`: GS1 DataBar code type.
     * </pre>
     *
     * <code>string format = 1;</code>
     *
     * @return The bytes for format.
     */
    public com.google.protobuf.ByteString getFormatBytes() {
      java.lang.Object ref = format_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        format_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Format of a barcode.
     * The supported formats are:
     *
     * - `CODE_128`: Code 128 type.
     * - `CODE_39`: Code 39 type.
     * - `CODE_93`: Code 93 type.
     * - `CODABAR`: Codabar type.
     * - `DATA_MATRIX`: 2D Data Matrix type.
     * - `ITF`: ITF type.
     * - `EAN_13`: EAN-13 type.
     * - `EAN_8`: EAN-8 type.
     * - `QR_CODE`: 2D QR code type.
     * - `UPC_A`: UPC-A type.
     * - `UPC_E`: UPC-E type.
     * - `PDF417`: PDF417 type.
     * - `AZTEC`: 2D Aztec code type.
     * - `DATABAR`: GS1 DataBar code type.
     * </pre>
     *
     * <code>string format = 1;</code>
     *
     * @param value The format to set.
     * @return This builder for chaining.
     */
    public Builder setFormat(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      format_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Format of a barcode.
     * The supported formats are:
     *
     * - `CODE_128`: Code 128 type.
     * - `CODE_39`: Code 39 type.
     * - `CODE_93`: Code 93 type.
     * - `CODABAR`: Codabar type.
     * - `DATA_MATRIX`: 2D Data Matrix type.
     * - `ITF`: ITF type.
     * - `EAN_13`: EAN-13 type.
     * - `EAN_8`: EAN-8 type.
     * - `QR_CODE`: 2D QR code type.
     * - `UPC_A`: UPC-A type.
     * - `UPC_E`: UPC-E type.
     * - `PDF417`: PDF417 type.
     * - `AZTEC`: 2D Aztec code type.
     * - `DATABAR`: GS1 DataBar code type.
     * </pre>
     *
     * <code>string format = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFormat() {
      format_ = getDefaultInstance().getFormat();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Format of a barcode.
     * The supported formats are:
     *
     * - `CODE_128`: Code 128 type.
     * - `CODE_39`: Code 39 type.
     * - `CODE_93`: Code 93 type.
     * - `CODABAR`: Codabar type.
     * - `DATA_MATRIX`: 2D Data Matrix type.
     * - `ITF`: ITF type.
     * - `EAN_13`: EAN-13 type.
     * - `EAN_8`: EAN-8 type.
     * - `QR_CODE`: 2D QR code type.
     * - `UPC_A`: UPC-A type.
     * - `UPC_E`: UPC-E type.
     * - `PDF417`: PDF417 type.
     * - `AZTEC`: 2D Aztec code type.
     * - `DATABAR`: GS1 DataBar code type.
     * </pre>
     *
     * <code>string format = 1;</code>
     *
     * @param value The bytes for format to set.
     * @return This builder for chaining.
     */
    public Builder setFormatBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      format_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object valueFormat_ = "";
    /**
     *
     *
     * <pre>
     * Value format describes the format of the value that a barcode
     * encodes.
     * The supported formats are:
     *
     * - `CONTACT_INFO`: Contact information.
     * - `EMAIL`: Email address.
     * - `ISBN`: ISBN identifier.
     * - `PHONE`: Phone number.
     * - `PRODUCT`: Product.
     * - `SMS`: SMS message.
     * - `TEXT`: Text string.
     * - `URL`: URL address.
     * - `WIFI`: Wifi information.
     * - `GEO`: Geo-localization.
     * - `CALENDAR_EVENT`: Calendar event.
     * - `DRIVER_LICENSE`: Driver's license.
     * </pre>
     *
     * <code>string value_format = 2;</code>
     *
     * @return The valueFormat.
     */
    public java.lang.String getValueFormat() {
      java.lang.Object ref = valueFormat_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        valueFormat_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Value format describes the format of the value that a barcode
     * encodes.
     * The supported formats are:
     *
     * - `CONTACT_INFO`: Contact information.
     * - `EMAIL`: Email address.
     * - `ISBN`: ISBN identifier.
     * - `PHONE`: Phone number.
     * - `PRODUCT`: Product.
     * - `SMS`: SMS message.
     * - `TEXT`: Text string.
     * - `URL`: URL address.
     * - `WIFI`: Wifi information.
     * - `GEO`: Geo-localization.
     * - `CALENDAR_EVENT`: Calendar event.
     * - `DRIVER_LICENSE`: Driver's license.
     * </pre>
     *
     * <code>string value_format = 2;</code>
     *
     * @return The bytes for valueFormat.
     */
    public com.google.protobuf.ByteString getValueFormatBytes() {
      java.lang.Object ref = valueFormat_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        valueFormat_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Value format describes the format of the value that a barcode
     * encodes.
     * The supported formats are:
     *
     * - `CONTACT_INFO`: Contact information.
     * - `EMAIL`: Email address.
     * - `ISBN`: ISBN identifier.
     * - `PHONE`: Phone number.
     * - `PRODUCT`: Product.
     * - `SMS`: SMS message.
     * - `TEXT`: Text string.
     * - `URL`: URL address.
     * - `WIFI`: Wifi information.
     * - `GEO`: Geo-localization.
     * - `CALENDAR_EVENT`: Calendar event.
     * - `DRIVER_LICENSE`: Driver's license.
     * </pre>
     *
     * <code>string value_format = 2;</code>
     *
     * @param value The valueFormat to set.
     * @return This builder for chaining.
     */
    public Builder setValueFormat(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      valueFormat_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Value format describes the format of the value that a barcode
     * encodes.
     * The supported formats are:
     *
     * - `CONTACT_INFO`: Contact information.
     * - `EMAIL`: Email address.
     * - `ISBN`: ISBN identifier.
     * - `PHONE`: Phone number.
     * - `PRODUCT`: Product.
     * - `SMS`: SMS message.
     * - `TEXT`: Text string.
     * - `URL`: URL address.
     * - `WIFI`: Wifi information.
     * - `GEO`: Geo-localization.
     * - `CALENDAR_EVENT`: Calendar event.
     * - `DRIVER_LICENSE`: Driver's license.
     * </pre>
     *
     * <code>string value_format = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValueFormat() {
      valueFormat_ = getDefaultInstance().getValueFormat();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Value format describes the format of the value that a barcode
     * encodes.
     * The supported formats are:
     *
     * - `CONTACT_INFO`: Contact information.
     * - `EMAIL`: Email address.
     * - `ISBN`: ISBN identifier.
     * - `PHONE`: Phone number.
     * - `PRODUCT`: Product.
     * - `SMS`: SMS message.
     * - `TEXT`: Text string.
     * - `URL`: URL address.
     * - `WIFI`: Wifi information.
     * - `GEO`: Geo-localization.
     * - `CALENDAR_EVENT`: Calendar event.
     * - `DRIVER_LICENSE`: Driver's license.
     * </pre>
     *
     * <code>string value_format = 2;</code>
     *
     * @param value The bytes for valueFormat to set.
     * @return This builder for chaining.
     */
    public Builder setValueFormatBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      valueFormat_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object rawValue_ = "";
    /**
     *
     *
     * <pre>
     * Raw value encoded in the barcode.
     * For example: `'MEBKM:TITLE:Google;URL:https://www.google.com;;'`.
     * </pre>
     *
     * <code>string raw_value = 3;</code>
     *
     * @return The rawValue.
     */
    public java.lang.String getRawValue() {
      java.lang.Object ref = rawValue_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rawValue_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Raw value encoded in the barcode.
     * For example: `'MEBKM:TITLE:Google;URL:https://www.google.com;;'`.
     * </pre>
     *
     * <code>string raw_value = 3;</code>
     *
     * @return The bytes for rawValue.
     */
    public com.google.protobuf.ByteString getRawValueBytes() {
      java.lang.Object ref = rawValue_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rawValue_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Raw value encoded in the barcode.
     * For example: `'MEBKM:TITLE:Google;URL:https://www.google.com;;'`.
     * </pre>
     *
     * <code>string raw_value = 3;</code>
     *
     * @param value The rawValue to set.
     * @return This builder for chaining.
     */
    public Builder setRawValue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rawValue_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Raw value encoded in the barcode.
     * For example: `'MEBKM:TITLE:Google;URL:https://www.google.com;;'`.
     * </pre>
     *
     * <code>string raw_value = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRawValue() {
      rawValue_ = getDefaultInstance().getRawValue();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Raw value encoded in the barcode.
     * For example: `'MEBKM:TITLE:Google;URL:https://www.google.com;;'`.
     * </pre>
     *
     * <code>string raw_value = 3;</code>
     *
     * @param value The bytes for rawValue to set.
     * @return This builder for chaining.
     */
    public Builder setRawValueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rawValue_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Barcode)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Barcode)
  private static final com.google.cloud.documentai.v1beta3.Barcode DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Barcode();
  }

  public static com.google.cloud.documentai.v1beta3.Barcode getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Barcode> PARSER =
      new com.google.protobuf.AbstractParser<Barcode>() {
        @java.lang.Override
        public Barcode parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Barcode> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Barcode> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Barcode getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
