/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document_service.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * Metadata of the import document operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.ImportDocumentsMetadata}
 */
public final class ImportDocumentsMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.ImportDocumentsMetadata)
    ImportDocumentsMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportDocumentsMetadata.newBuilder() to construct.
  private ImportDocumentsMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportDocumentsMetadata() {
    individualImportStatuses_ = java.util.Collections.emptyList();
    importConfigValidationResults_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportDocumentsMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
        .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
        .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.class,
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.Builder.class);
  }

  public interface IndividualImportStatusOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The source Cloud Storage URI of the document.
     * </pre>
     *
     * <code>string input_gcs_source = 1;</code>
     *
     * @return The inputGcsSource.
     */
    java.lang.String getInputGcsSource();
    /**
     *
     *
     * <pre>
     * The source Cloud Storage URI of the document.
     * </pre>
     *
     * <code>string input_gcs_source = 1;</code>
     *
     * @return The bytes for inputGcsSource.
     */
    com.google.protobuf.ByteString getInputGcsSourceBytes();

    /**
     *
     *
     * <pre>
     * The status of the importing of the document.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     *
     * @return Whether the status field is set.
     */
    boolean hasStatus();
    /**
     *
     *
     * <pre>
     * The status of the importing of the document.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     *
     * @return The status.
     */
    com.google.rpc.Status getStatus();
    /**
     *
     *
     * <pre>
     * The status of the importing of the document.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    com.google.rpc.StatusOrBuilder getStatusOrBuilder();

    /**
     *
     *
     * <pre>
     * The document id of imported document if it was successful, otherwise
     * empty.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId output_document_id = 4;</code>
     *
     * @return Whether the outputDocumentId field is set.
     */
    boolean hasOutputDocumentId();
    /**
     *
     *
     * <pre>
     * The document id of imported document if it was successful, otherwise
     * empty.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId output_document_id = 4;</code>
     *
     * @return The outputDocumentId.
     */
    com.google.cloud.documentai.v1beta3.DocumentId getOutputDocumentId();
    /**
     *
     *
     * <pre>
     * The document id of imported document if it was successful, otherwise
     * empty.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId output_document_id = 4;</code>
     */
    com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder getOutputDocumentIdOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The status of each individual document in the import process.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus}
   */
  public static final class IndividualImportStatus extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus)
      IndividualImportStatusOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IndividualImportStatus.newBuilder() to construct.
    private IndividualImportStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IndividualImportStatus() {
      inputGcsSource_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new IndividualImportStatus();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
          .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsMetadata_IndividualImportStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
          .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsMetadata_IndividualImportStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
                  .class,
              com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
                  .Builder.class);
    }

    private int bitField0_;
    public static final int INPUT_GCS_SOURCE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object inputGcsSource_ = "";
    /**
     *
     *
     * <pre>
     * The source Cloud Storage URI of the document.
     * </pre>
     *
     * <code>string input_gcs_source = 1;</code>
     *
     * @return The inputGcsSource.
     */
    @java.lang.Override
    public java.lang.String getInputGcsSource() {
      java.lang.Object ref = inputGcsSource_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        inputGcsSource_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The source Cloud Storage URI of the document.
     * </pre>
     *
     * <code>string input_gcs_source = 1;</code>
     *
     * @return The bytes for inputGcsSource.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInputGcsSourceBytes() {
      java.lang.Object ref = inputGcsSource_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        inputGcsSource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATUS_FIELD_NUMBER = 2;
    private com.google.rpc.Status status_;
    /**
     *
     *
     * <pre>
     * The status of the importing of the document.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     *
     * @return Whether the status field is set.
     */
    @java.lang.Override
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The status of the importing of the document.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.rpc.Status getStatus() {
      return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
    }
    /**
     *
     *
     * <pre>
     * The status of the importing of the document.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    @java.lang.Override
    public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
      return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
    }

    public static final int OUTPUT_DOCUMENT_ID_FIELD_NUMBER = 4;
    private com.google.cloud.documentai.v1beta3.DocumentId outputDocumentId_;
    /**
     *
     *
     * <pre>
     * The document id of imported document if it was successful, otherwise
     * empty.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId output_document_id = 4;</code>
     *
     * @return Whether the outputDocumentId field is set.
     */
    @java.lang.Override
    public boolean hasOutputDocumentId() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The document id of imported document if it was successful, otherwise
     * empty.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId output_document_id = 4;</code>
     *
     * @return The outputDocumentId.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentId getOutputDocumentId() {
      return outputDocumentId_ == null
          ? com.google.cloud.documentai.v1beta3.DocumentId.getDefaultInstance()
          : outputDocumentId_;
    }
    /**
     *
     *
     * <pre>
     * The document id of imported document if it was successful, otherwise
     * empty.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId output_document_id = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder getOutputDocumentIdOrBuilder() {
      return outputDocumentId_ == null
          ? com.google.cloud.documentai.v1beta3.DocumentId.getDefaultInstance()
          : outputDocumentId_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputGcsSource_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, inputGcsSource_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getStatus());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(4, getOutputDocumentId());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputGcsSource_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, inputGcsSource_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStatus());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getOutputDocumentId());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus other =
          (com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus) obj;

      if (!getInputGcsSource().equals(other.getInputGcsSource())) return false;
      if (hasStatus() != other.hasStatus()) return false;
      if (hasStatus()) {
        if (!getStatus().equals(other.getStatus())) return false;
      }
      if (hasOutputDocumentId() != other.hasOutputDocumentId()) return false;
      if (hasOutputDocumentId()) {
        if (!getOutputDocumentId().equals(other.getOutputDocumentId())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + INPUT_GCS_SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getInputGcsSource().hashCode();
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      if (hasOutputDocumentId()) {
        hash = (37 * hash) + OUTPUT_DOCUMENT_ID_FIELD_NUMBER;
        hash = (53 * hash) + getOutputDocumentId().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The status of each individual document in the import process.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus)
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
            .IndividualImportStatusOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
            .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsMetadata_IndividualImportStatus_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
            .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsMetadata_IndividualImportStatus_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
                    .class,
                com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getStatusFieldBuilder();
          getOutputDocumentIdFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        inputGcsSource_ = "";
        status_ = null;
        if (statusBuilder_ != null) {
          statusBuilder_.dispose();
          statusBuilder_ = null;
        }
        outputDocumentId_ = null;
        if (outputDocumentIdBuilder_ != null) {
          outputDocumentIdBuilder_.dispose();
          outputDocumentIdBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
            .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsMetadata_IndividualImportStatus_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
          build() {
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
          buildPartial() {
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus result =
            new com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.inputGcsSource_ = inputGcsSource_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.outputDocumentId_ =
              outputDocumentIdBuilder_ == null
                  ? outputDocumentId_
                  : outputDocumentIdBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
              other) {
        if (other
            == com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
                .getDefaultInstance()) return this;
        if (!other.getInputGcsSource().isEmpty()) {
          inputGcsSource_ = other.inputGcsSource_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasStatus()) {
          mergeStatus(other.getStatus());
        }
        if (other.hasOutputDocumentId()) {
          mergeOutputDocumentId(other.getOutputDocumentId());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  inputGcsSource_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 34:
                {
                  input.readMessage(
                      getOutputDocumentIdFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object inputGcsSource_ = "";
      /**
       *
       *
       * <pre>
       * The source Cloud Storage URI of the document.
       * </pre>
       *
       * <code>string input_gcs_source = 1;</code>
       *
       * @return The inputGcsSource.
       */
      public java.lang.String getInputGcsSource() {
        java.lang.Object ref = inputGcsSource_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          inputGcsSource_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The source Cloud Storage URI of the document.
       * </pre>
       *
       * <code>string input_gcs_source = 1;</code>
       *
       * @return The bytes for inputGcsSource.
       */
      public com.google.protobuf.ByteString getInputGcsSourceBytes() {
        java.lang.Object ref = inputGcsSource_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          inputGcsSource_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The source Cloud Storage URI of the document.
       * </pre>
       *
       * <code>string input_gcs_source = 1;</code>
       *
       * @param value The inputGcsSource to set.
       * @return This builder for chaining.
       */
      public Builder setInputGcsSource(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputGcsSource_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The source Cloud Storage URI of the document.
       * </pre>
       *
       * <code>string input_gcs_source = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInputGcsSource() {
        inputGcsSource_ = getDefaultInstance().getInputGcsSource();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The source Cloud Storage URI of the document.
       * </pre>
       *
       * <code>string input_gcs_source = 1;</code>
       *
       * @param value The bytes for inputGcsSource to set.
       * @return This builder for chaining.
       */
      public Builder setInputGcsSourceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        inputGcsSource_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.rpc.Status status_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          statusBuilder_;
      /**
       *
       *
       * <pre>
       * The status of the importing of the document.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       *
       * @return Whether the status field is set.
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The status of the importing of the document.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       *
       * @return The status.
       */
      public com.google.rpc.Status getStatus() {
        if (statusBuilder_ == null) {
          return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
        } else {
          return statusBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The status of the importing of the document.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public Builder setStatus(com.google.rpc.Status value) {
        if (statusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          status_ = value;
        } else {
          statusBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The status of the importing of the document.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public Builder setStatus(com.google.rpc.Status.Builder builderForValue) {
        if (statusBuilder_ == null) {
          status_ = builderForValue.build();
        } else {
          statusBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The status of the importing of the document.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public Builder mergeStatus(com.google.rpc.Status value) {
        if (statusBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && status_ != null
              && status_ != com.google.rpc.Status.getDefaultInstance()) {
            getStatusBuilder().mergeFrom(value);
          } else {
            status_ = value;
          }
        } else {
          statusBuilder_.mergeFrom(value);
        }
        if (status_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The status of the importing of the document.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000002);
        status_ = null;
        if (statusBuilder_ != null) {
          statusBuilder_.dispose();
          statusBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The status of the importing of the document.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public com.google.rpc.Status.Builder getStatusBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getStatusFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The status of the importing of the document.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
        if (statusBuilder_ != null) {
          return statusBuilder_.getMessageOrBuilder();
        } else {
          return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
        }
      }
      /**
       *
       *
       * <pre>
       * The status of the importing of the document.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          getStatusFieldBuilder() {
        if (statusBuilder_ == null) {
          statusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.rpc.Status,
                  com.google.rpc.Status.Builder,
                  com.google.rpc.StatusOrBuilder>(getStatus(), getParentForChildren(), isClean());
          status_ = null;
        }
        return statusBuilder_;
      }

      private com.google.cloud.documentai.v1beta3.DocumentId outputDocumentId_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.DocumentId,
              com.google.cloud.documentai.v1beta3.DocumentId.Builder,
              com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder>
          outputDocumentIdBuilder_;
      /**
       *
       *
       * <pre>
       * The document id of imported document if it was successful, otherwise
       * empty.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.DocumentId output_document_id = 4;</code>
       *
       * @return Whether the outputDocumentId field is set.
       */
      public boolean hasOutputDocumentId() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The document id of imported document if it was successful, otherwise
       * empty.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.DocumentId output_document_id = 4;</code>
       *
       * @return The outputDocumentId.
       */
      public com.google.cloud.documentai.v1beta3.DocumentId getOutputDocumentId() {
        if (outputDocumentIdBuilder_ == null) {
          return outputDocumentId_ == null
              ? com.google.cloud.documentai.v1beta3.DocumentId.getDefaultInstance()
              : outputDocumentId_;
        } else {
          return outputDocumentIdBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The document id of imported document if it was successful, otherwise
       * empty.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.DocumentId output_document_id = 4;</code>
       */
      public Builder setOutputDocumentId(com.google.cloud.documentai.v1beta3.DocumentId value) {
        if (outputDocumentIdBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          outputDocumentId_ = value;
        } else {
          outputDocumentIdBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The document id of imported document if it was successful, otherwise
       * empty.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.DocumentId output_document_id = 4;</code>
       */
      public Builder setOutputDocumentId(
          com.google.cloud.documentai.v1beta3.DocumentId.Builder builderForValue) {
        if (outputDocumentIdBuilder_ == null) {
          outputDocumentId_ = builderForValue.build();
        } else {
          outputDocumentIdBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The document id of imported document if it was successful, otherwise
       * empty.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.DocumentId output_document_id = 4;</code>
       */
      public Builder mergeOutputDocumentId(com.google.cloud.documentai.v1beta3.DocumentId value) {
        if (outputDocumentIdBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && outputDocumentId_ != null
              && outputDocumentId_
                  != com.google.cloud.documentai.v1beta3.DocumentId.getDefaultInstance()) {
            getOutputDocumentIdBuilder().mergeFrom(value);
          } else {
            outputDocumentId_ = value;
          }
        } else {
          outputDocumentIdBuilder_.mergeFrom(value);
        }
        if (outputDocumentId_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The document id of imported document if it was successful, otherwise
       * empty.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.DocumentId output_document_id = 4;</code>
       */
      public Builder clearOutputDocumentId() {
        bitField0_ = (bitField0_ & ~0x00000004);
        outputDocumentId_ = null;
        if (outputDocumentIdBuilder_ != null) {
          outputDocumentIdBuilder_.dispose();
          outputDocumentIdBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The document id of imported document if it was successful, otherwise
       * empty.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.DocumentId output_document_id = 4;</code>
       */
      public com.google.cloud.documentai.v1beta3.DocumentId.Builder getOutputDocumentIdBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getOutputDocumentIdFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The document id of imported document if it was successful, otherwise
       * empty.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.DocumentId output_document_id = 4;</code>
       */
      public com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder
          getOutputDocumentIdOrBuilder() {
        if (outputDocumentIdBuilder_ != null) {
          return outputDocumentIdBuilder_.getMessageOrBuilder();
        } else {
          return outputDocumentId_ == null
              ? com.google.cloud.documentai.v1beta3.DocumentId.getDefaultInstance()
              : outputDocumentId_;
        }
      }
      /**
       *
       *
       * <pre>
       * The document id of imported document if it was successful, otherwise
       * empty.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.DocumentId output_document_id = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.DocumentId,
              com.google.cloud.documentai.v1beta3.DocumentId.Builder,
              com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder>
          getOutputDocumentIdFieldBuilder() {
        if (outputDocumentIdBuilder_ == null) {
          outputDocumentIdBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.DocumentId,
                  com.google.cloud.documentai.v1beta3.DocumentId.Builder,
                  com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder>(
                  getOutputDocumentId(), getParentForChildren(), isClean());
          outputDocumentId_ = null;
        }
        return outputDocumentIdBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus)
    private static final com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
            .IndividualImportStatus
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus();
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IndividualImportStatus> PARSER =
        new com.google.protobuf.AbstractParser<IndividualImportStatus>() {
          @java.lang.Override
          public IndividualImportStatus parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<IndividualImportStatus> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IndividualImportStatus> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ImportConfigValidationResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The source Cloud Storage URI specified in the import config.
     * </pre>
     *
     * <code>string input_gcs_source = 1;</code>
     *
     * @return The inputGcsSource.
     */
    java.lang.String getInputGcsSource();
    /**
     *
     *
     * <pre>
     * The source Cloud Storage URI specified in the import config.
     * </pre>
     *
     * <code>string input_gcs_source = 1;</code>
     *
     * @return The bytes for inputGcsSource.
     */
    com.google.protobuf.ByteString getInputGcsSourceBytes();

    /**
     *
     *
     * <pre>
     * The validation status of import config.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     *
     * @return Whether the status field is set.
     */
    boolean hasStatus();
    /**
     *
     *
     * <pre>
     * The validation status of import config.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     *
     * @return The status.
     */
    com.google.rpc.Status getStatus();
    /**
     *
     *
     * <pre>
     * The validation status of import config.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    com.google.rpc.StatusOrBuilder getStatusOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The validation status of each import config. Status is set to an error if
   * there are no documents to import in the `import_config`, or `OK` if the
   * operation will try to proceed with at least one document.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult}
   */
  public static final class ImportConfigValidationResult
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult)
      ImportConfigValidationResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ImportConfigValidationResult.newBuilder() to construct.
    private ImportConfigValidationResult(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ImportConfigValidationResult() {
      inputGcsSource_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ImportConfigValidationResult();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
          .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsMetadata_ImportConfigValidationResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
          .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsMetadata_ImportConfigValidationResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                  .ImportConfigValidationResult.class,
              com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                  .ImportConfigValidationResult.Builder.class);
    }

    private int bitField0_;
    public static final int INPUT_GCS_SOURCE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object inputGcsSource_ = "";
    /**
     *
     *
     * <pre>
     * The source Cloud Storage URI specified in the import config.
     * </pre>
     *
     * <code>string input_gcs_source = 1;</code>
     *
     * @return The inputGcsSource.
     */
    @java.lang.Override
    public java.lang.String getInputGcsSource() {
      java.lang.Object ref = inputGcsSource_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        inputGcsSource_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The source Cloud Storage URI specified in the import config.
     * </pre>
     *
     * <code>string input_gcs_source = 1;</code>
     *
     * @return The bytes for inputGcsSource.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInputGcsSourceBytes() {
      java.lang.Object ref = inputGcsSource_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        inputGcsSource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATUS_FIELD_NUMBER = 2;
    private com.google.rpc.Status status_;
    /**
     *
     *
     * <pre>
     * The validation status of import config.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     *
     * @return Whether the status field is set.
     */
    @java.lang.Override
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The validation status of import config.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.rpc.Status getStatus() {
      return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
    }
    /**
     *
     *
     * <pre>
     * The validation status of import config.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    @java.lang.Override
    public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
      return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputGcsSource_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, inputGcsSource_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getStatus());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputGcsSource_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, inputGcsSource_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStatus());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
              .ImportConfigValidationResult)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
          other =
              (com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                      .ImportConfigValidationResult)
                  obj;

      if (!getInputGcsSource().equals(other.getInputGcsSource())) return false;
      if (hasStatus() != other.hasStatus()) return false;
      if (hasStatus()) {
        if (!getStatus().equals(other.getStatus())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + INPUT_GCS_SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getInputGcsSource().hashCode();
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
            .ImportConfigValidationResult
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
            .ImportConfigValidationResult
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
            .ImportConfigValidationResult
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
            .ImportConfigValidationResult
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
            .ImportConfigValidationResult
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
            .ImportConfigValidationResult
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
            .ImportConfigValidationResult
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
            .ImportConfigValidationResult
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
            .ImportConfigValidationResult
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
            .ImportConfigValidationResult
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
            .ImportConfigValidationResult
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
            .ImportConfigValidationResult
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The validation status of each import config. Status is set to an error if
     * there are no documents to import in the `import_config`, or `OK` if the
     * operation will try to proceed with at least one document.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult)
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
            .ImportConfigValidationResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
            .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsMetadata_ImportConfigValidationResult_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
            .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsMetadata_ImportConfigValidationResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                    .ImportConfigValidationResult.class,
                com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                    .ImportConfigValidationResult.Builder.class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getStatusFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        inputGcsSource_ = "";
        status_ = null;
        if (statusBuilder_ != null) {
          statusBuilder_.dispose();
          statusBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
            .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsMetadata_ImportConfigValidationResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
              .ImportConfigValidationResult
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
            .ImportConfigValidationResult.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
              .ImportConfigValidationResult
          build() {
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
              .ImportConfigValidationResult
          buildPartial() {
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
            result =
                new com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                    .ImportConfigValidationResult(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.inputGcsSource_ = inputGcsSource_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                .ImportConfigValidationResult) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                      .ImportConfigValidationResult)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
              other) {
        if (other
            == com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                .ImportConfigValidationResult.getDefaultInstance()) return this;
        if (!other.getInputGcsSource().isEmpty()) {
          inputGcsSource_ = other.inputGcsSource_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasStatus()) {
          mergeStatus(other.getStatus());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  inputGcsSource_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object inputGcsSource_ = "";
      /**
       *
       *
       * <pre>
       * The source Cloud Storage URI specified in the import config.
       * </pre>
       *
       * <code>string input_gcs_source = 1;</code>
       *
       * @return The inputGcsSource.
       */
      public java.lang.String getInputGcsSource() {
        java.lang.Object ref = inputGcsSource_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          inputGcsSource_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The source Cloud Storage URI specified in the import config.
       * </pre>
       *
       * <code>string input_gcs_source = 1;</code>
       *
       * @return The bytes for inputGcsSource.
       */
      public com.google.protobuf.ByteString getInputGcsSourceBytes() {
        java.lang.Object ref = inputGcsSource_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          inputGcsSource_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The source Cloud Storage URI specified in the import config.
       * </pre>
       *
       * <code>string input_gcs_source = 1;</code>
       *
       * @param value The inputGcsSource to set.
       * @return This builder for chaining.
       */
      public Builder setInputGcsSource(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputGcsSource_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The source Cloud Storage URI specified in the import config.
       * </pre>
       *
       * <code>string input_gcs_source = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInputGcsSource() {
        inputGcsSource_ = getDefaultInstance().getInputGcsSource();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The source Cloud Storage URI specified in the import config.
       * </pre>
       *
       * <code>string input_gcs_source = 1;</code>
       *
       * @param value The bytes for inputGcsSource to set.
       * @return This builder for chaining.
       */
      public Builder setInputGcsSourceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        inputGcsSource_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.rpc.Status status_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          statusBuilder_;
      /**
       *
       *
       * <pre>
       * The validation status of import config.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       *
       * @return Whether the status field is set.
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The validation status of import config.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       *
       * @return The status.
       */
      public com.google.rpc.Status getStatus() {
        if (statusBuilder_ == null) {
          return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
        } else {
          return statusBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The validation status of import config.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public Builder setStatus(com.google.rpc.Status value) {
        if (statusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          status_ = value;
        } else {
          statusBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The validation status of import config.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public Builder setStatus(com.google.rpc.Status.Builder builderForValue) {
        if (statusBuilder_ == null) {
          status_ = builderForValue.build();
        } else {
          statusBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The validation status of import config.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public Builder mergeStatus(com.google.rpc.Status value) {
        if (statusBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && status_ != null
              && status_ != com.google.rpc.Status.getDefaultInstance()) {
            getStatusBuilder().mergeFrom(value);
          } else {
            status_ = value;
          }
        } else {
          statusBuilder_.mergeFrom(value);
        }
        if (status_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The validation status of import config.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000002);
        status_ = null;
        if (statusBuilder_ != null) {
          statusBuilder_.dispose();
          statusBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The validation status of import config.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public com.google.rpc.Status.Builder getStatusBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getStatusFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The validation status of import config.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
        if (statusBuilder_ != null) {
          return statusBuilder_.getMessageOrBuilder();
        } else {
          return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
        }
      }
      /**
       *
       *
       * <pre>
       * The validation status of import config.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          getStatusFieldBuilder() {
        if (statusBuilder_ == null) {
          statusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.rpc.Status,
                  com.google.rpc.Status.Builder,
                  com.google.rpc.StatusOrBuilder>(getStatus(), getParentForChildren(), isClean());
          status_ = null;
        }
        return statusBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult)
    private static final com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
            .ImportConfigValidationResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
              .ImportConfigValidationResult();
    }

    public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
            .ImportConfigValidationResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ImportConfigValidationResult> PARSER =
        new com.google.protobuf.AbstractParser<ImportConfigValidationResult>() {
          @java.lang.Override
          public ImportConfigValidationResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ImportConfigValidationResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ImportConfigValidationResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int COMMON_METADATA_FIELD_NUMBER = 1;
  private com.google.cloud.documentai.v1beta3.CommonOperationMetadata commonMetadata_;
  /**
   *
   *
   * <pre>
   * The basic metadata of the long-running operation.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
   *
   * @return Whether the commonMetadata field is set.
   */
  @java.lang.Override
  public boolean hasCommonMetadata() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The basic metadata of the long-running operation.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
   *
   * @return The commonMetadata.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.CommonOperationMetadata getCommonMetadata() {
    return commonMetadata_ == null
        ? com.google.cloud.documentai.v1beta3.CommonOperationMetadata.getDefaultInstance()
        : commonMetadata_;
  }
  /**
   *
   *
   * <pre>
   * The basic metadata of the long-running operation.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.CommonOperationMetadataOrBuilder
      getCommonMetadataOrBuilder() {
    return commonMetadata_ == null
        ? com.google.cloud.documentai.v1beta3.CommonOperationMetadata.getDefaultInstance()
        : commonMetadata_;
  }

  public static final int INDIVIDUAL_IMPORT_STATUSES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus>
      individualImportStatuses_;
  /**
   *
   *
   * <pre>
   * The list of response details of each document.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus>
      getIndividualImportStatusesList() {
    return individualImportStatuses_;
  }
  /**
   *
   *
   * <pre>
   * The list of response details of each document.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                  .IndividualImportStatusOrBuilder>
      getIndividualImportStatusesOrBuilderList() {
    return individualImportStatuses_;
  }
  /**
   *
   *
   * <pre>
   * The list of response details of each document.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
   * </code>
   */
  @java.lang.Override
  public int getIndividualImportStatusesCount() {
    return individualImportStatuses_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of response details of each document.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
      getIndividualImportStatuses(int index) {
    return individualImportStatuses_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of response details of each document.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatusOrBuilder
      getIndividualImportStatusesOrBuilder(int index) {
    return individualImportStatuses_.get(index);
  }

  public static final int IMPORT_CONFIG_VALIDATION_RESULTS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult>
      importConfigValidationResults_;
  /**
   *
   *
   * <pre>
   * Validation statuses of the batch documents import config.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult>
      getImportConfigValidationResultsList() {
    return importConfigValidationResults_;
  }
  /**
   *
   *
   * <pre>
   * Validation statuses of the batch documents import config.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                  .ImportConfigValidationResultOrBuilder>
      getImportConfigValidationResultsOrBuilderList() {
    return importConfigValidationResults_;
  }
  /**
   *
   *
   * <pre>
   * Validation statuses of the batch documents import config.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
   * </code>
   */
  @java.lang.Override
  public int getImportConfigValidationResultsCount() {
    return importConfigValidationResults_.size();
  }
  /**
   *
   *
   * <pre>
   * Validation statuses of the batch documents import config.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
      getImportConfigValidationResults(int index) {
    return importConfigValidationResults_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Validation statuses of the batch documents import config.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
          .ImportConfigValidationResultOrBuilder
      getImportConfigValidationResultsOrBuilder(int index) {
    return importConfigValidationResults_.get(index);
  }

  public static final int TOTAL_DOCUMENT_COUNT_FIELD_NUMBER = 3;
  private int totalDocumentCount_ = 0;
  /**
   *
   *
   * <pre>
   * Total number of the documents that are qualified for importing.
   * </pre>
   *
   * <code>int32 total_document_count = 3;</code>
   *
   * @return The totalDocumentCount.
   */
  @java.lang.Override
  public int getTotalDocumentCount() {
    return totalDocumentCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getCommonMetadata());
    }
    for (int i = 0; i < individualImportStatuses_.size(); i++) {
      output.writeMessage(2, individualImportStatuses_.get(i));
    }
    if (totalDocumentCount_ != 0) {
      output.writeInt32(3, totalDocumentCount_);
    }
    for (int i = 0; i < importConfigValidationResults_.size(); i++) {
      output.writeMessage(4, importConfigValidationResults_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCommonMetadata());
    }
    for (int i = 0; i < individualImportStatuses_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, individualImportStatuses_.get(i));
    }
    if (totalDocumentCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, totalDocumentCount_);
    }
    for (int i = 0; i < importConfigValidationResults_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, importConfigValidationResults_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata other =
        (com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata) obj;

    if (hasCommonMetadata() != other.hasCommonMetadata()) return false;
    if (hasCommonMetadata()) {
      if (!getCommonMetadata().equals(other.getCommonMetadata())) return false;
    }
    if (!getIndividualImportStatusesList().equals(other.getIndividualImportStatusesList()))
      return false;
    if (!getImportConfigValidationResultsList()
        .equals(other.getImportConfigValidationResultsList())) return false;
    if (getTotalDocumentCount() != other.getTotalDocumentCount()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCommonMetadata()) {
      hash = (37 * hash) + COMMON_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getCommonMetadata().hashCode();
    }
    if (getIndividualImportStatusesCount() > 0) {
      hash = (37 * hash) + INDIVIDUAL_IMPORT_STATUSES_FIELD_NUMBER;
      hash = (53 * hash) + getIndividualImportStatusesList().hashCode();
    }
    if (getImportConfigValidationResultsCount() > 0) {
      hash = (37 * hash) + IMPORT_CONFIG_VALIDATION_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getImportConfigValidationResultsList().hashCode();
    }
    hash = (37 * hash) + TOTAL_DOCUMENT_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getTotalDocumentCount();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata of the import document operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.ImportDocumentsMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.ImportDocumentsMetadata)
      com.google.cloud.documentai.v1beta3.ImportDocumentsMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
          .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
          .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.class,
              com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCommonMetadataFieldBuilder();
        getIndividualImportStatusesFieldBuilder();
        getImportConfigValidationResultsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      commonMetadata_ = null;
      if (commonMetadataBuilder_ != null) {
        commonMetadataBuilder_.dispose();
        commonMetadataBuilder_ = null;
      }
      if (individualImportStatusesBuilder_ == null) {
        individualImportStatuses_ = java.util.Collections.emptyList();
      } else {
        individualImportStatuses_ = null;
        individualImportStatusesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (importConfigValidationResultsBuilder_ == null) {
        importConfigValidationResults_ = java.util.Collections.emptyList();
      } else {
        importConfigValidationResults_ = null;
        importConfigValidationResultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      totalDocumentCount_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentAiDocumentService
          .internal_static_google_cloud_documentai_v1beta3_ImportDocumentsMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata build() {
      com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata buildPartial() {
      com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata result =
          new com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata result) {
      if (individualImportStatusesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          individualImportStatuses_ =
              java.util.Collections.unmodifiableList(individualImportStatuses_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.individualImportStatuses_ = individualImportStatuses_;
      } else {
        result.individualImportStatuses_ = individualImportStatusesBuilder_.build();
      }
      if (importConfigValidationResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          importConfigValidationResults_ =
              java.util.Collections.unmodifiableList(importConfigValidationResults_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.importConfigValidationResults_ = importConfigValidationResults_;
      } else {
        result.importConfigValidationResults_ = importConfigValidationResultsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.commonMetadata_ =
            commonMetadataBuilder_ == null ? commonMetadata_ : commonMetadataBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.totalDocumentCount_ = totalDocumentCount_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata other) {
      if (other == com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.getDefaultInstance())
        return this;
      if (other.hasCommonMetadata()) {
        mergeCommonMetadata(other.getCommonMetadata());
      }
      if (individualImportStatusesBuilder_ == null) {
        if (!other.individualImportStatuses_.isEmpty()) {
          if (individualImportStatuses_.isEmpty()) {
            individualImportStatuses_ = other.individualImportStatuses_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureIndividualImportStatusesIsMutable();
            individualImportStatuses_.addAll(other.individualImportStatuses_);
          }
          onChanged();
        }
      } else {
        if (!other.individualImportStatuses_.isEmpty()) {
          if (individualImportStatusesBuilder_.isEmpty()) {
            individualImportStatusesBuilder_.dispose();
            individualImportStatusesBuilder_ = null;
            individualImportStatuses_ = other.individualImportStatuses_;
            bitField0_ = (bitField0_ & ~0x00000002);
            individualImportStatusesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getIndividualImportStatusesFieldBuilder()
                    : null;
          } else {
            individualImportStatusesBuilder_.addAllMessages(other.individualImportStatuses_);
          }
        }
      }
      if (importConfigValidationResultsBuilder_ == null) {
        if (!other.importConfigValidationResults_.isEmpty()) {
          if (importConfigValidationResults_.isEmpty()) {
            importConfigValidationResults_ = other.importConfigValidationResults_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureImportConfigValidationResultsIsMutable();
            importConfigValidationResults_.addAll(other.importConfigValidationResults_);
          }
          onChanged();
        }
      } else {
        if (!other.importConfigValidationResults_.isEmpty()) {
          if (importConfigValidationResultsBuilder_.isEmpty()) {
            importConfigValidationResultsBuilder_.dispose();
            importConfigValidationResultsBuilder_ = null;
            importConfigValidationResults_ = other.importConfigValidationResults_;
            bitField0_ = (bitField0_ & ~0x00000004);
            importConfigValidationResultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getImportConfigValidationResultsFieldBuilder()
                    : null;
          } else {
            importConfigValidationResultsBuilder_.addAllMessages(
                other.importConfigValidationResults_);
          }
        }
      }
      if (other.getTotalDocumentCount() != 0) {
        setTotalDocumentCount(other.getTotalDocumentCount());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCommonMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
                    m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                                .IndividualImportStatus.parser(),
                            extensionRegistry);
                if (individualImportStatusesBuilder_ == null) {
                  ensureIndividualImportStatusesIsMutable();
                  individualImportStatuses_.add(m);
                } else {
                  individualImportStatusesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                totalDocumentCount_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 24
            case 34:
              {
                com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                        .ImportConfigValidationResult
                    m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                                .ImportConfigValidationResult.parser(),
                            extensionRegistry);
                if (importConfigValidationResultsBuilder_ == null) {
                  ensureImportConfigValidationResultsIsMutable();
                  importConfigValidationResults_.add(m);
                } else {
                  importConfigValidationResultsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.documentai.v1beta3.CommonOperationMetadata commonMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.CommonOperationMetadata,
            com.google.cloud.documentai.v1beta3.CommonOperationMetadata.Builder,
            com.google.cloud.documentai.v1beta3.CommonOperationMetadataOrBuilder>
        commonMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * The basic metadata of the long-running operation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
     *
     * @return Whether the commonMetadata field is set.
     */
    public boolean hasCommonMetadata() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The basic metadata of the long-running operation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
     *
     * @return The commonMetadata.
     */
    public com.google.cloud.documentai.v1beta3.CommonOperationMetadata getCommonMetadata() {
      if (commonMetadataBuilder_ == null) {
        return commonMetadata_ == null
            ? com.google.cloud.documentai.v1beta3.CommonOperationMetadata.getDefaultInstance()
            : commonMetadata_;
      } else {
        return commonMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The basic metadata of the long-running operation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
     */
    public Builder setCommonMetadata(
        com.google.cloud.documentai.v1beta3.CommonOperationMetadata value) {
      if (commonMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commonMetadata_ = value;
      } else {
        commonMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The basic metadata of the long-running operation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
     */
    public Builder setCommonMetadata(
        com.google.cloud.documentai.v1beta3.CommonOperationMetadata.Builder builderForValue) {
      if (commonMetadataBuilder_ == null) {
        commonMetadata_ = builderForValue.build();
      } else {
        commonMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The basic metadata of the long-running operation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
     */
    public Builder mergeCommonMetadata(
        com.google.cloud.documentai.v1beta3.CommonOperationMetadata value) {
      if (commonMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && commonMetadata_ != null
            && commonMetadata_
                != com.google.cloud.documentai.v1beta3.CommonOperationMetadata
                    .getDefaultInstance()) {
          getCommonMetadataBuilder().mergeFrom(value);
        } else {
          commonMetadata_ = value;
        }
      } else {
        commonMetadataBuilder_.mergeFrom(value);
      }
      if (commonMetadata_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The basic metadata of the long-running operation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
     */
    public Builder clearCommonMetadata() {
      bitField0_ = (bitField0_ & ~0x00000001);
      commonMetadata_ = null;
      if (commonMetadataBuilder_ != null) {
        commonMetadataBuilder_.dispose();
        commonMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The basic metadata of the long-running operation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
     */
    public com.google.cloud.documentai.v1beta3.CommonOperationMetadata.Builder
        getCommonMetadataBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCommonMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The basic metadata of the long-running operation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
     */
    public com.google.cloud.documentai.v1beta3.CommonOperationMetadataOrBuilder
        getCommonMetadataOrBuilder() {
      if (commonMetadataBuilder_ != null) {
        return commonMetadataBuilder_.getMessageOrBuilder();
      } else {
        return commonMetadata_ == null
            ? com.google.cloud.documentai.v1beta3.CommonOperationMetadata.getDefaultInstance()
            : commonMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * The basic metadata of the long-running operation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.CommonOperationMetadata,
            com.google.cloud.documentai.v1beta3.CommonOperationMetadata.Builder,
            com.google.cloud.documentai.v1beta3.CommonOperationMetadataOrBuilder>
        getCommonMetadataFieldBuilder() {
      if (commonMetadataBuilder_ == null) {
        commonMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.CommonOperationMetadata,
                com.google.cloud.documentai.v1beta3.CommonOperationMetadata.Builder,
                com.google.cloud.documentai.v1beta3.CommonOperationMetadataOrBuilder>(
                getCommonMetadata(), getParentForChildren(), isClean());
        commonMetadata_ = null;
      }
      return commonMetadataBuilder_;
    }

    private java.util.List<
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus>
        individualImportStatuses_ = java.util.Collections.emptyList();

    private void ensureIndividualImportStatusesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        individualImportStatuses_ =
            new java.util.ArrayList<
                com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus>(
                individualImportStatuses_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus,
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
                .Builder,
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                .IndividualImportStatusOrBuilder>
        individualImportStatusesBuilder_;

    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
     * </code>
     */
    public java.util.List<
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus>
        getIndividualImportStatusesList() {
      if (individualImportStatusesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(individualImportStatuses_);
      } else {
        return individualImportStatusesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
     * </code>
     */
    public int getIndividualImportStatusesCount() {
      if (individualImportStatusesBuilder_ == null) {
        return individualImportStatuses_.size();
      } else {
        return individualImportStatusesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
        getIndividualImportStatuses(int index) {
      if (individualImportStatusesBuilder_ == null) {
        return individualImportStatuses_.get(index);
      } else {
        return individualImportStatusesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
     * </code>
     */
    public Builder setIndividualImportStatuses(
        int index,
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus value) {
      if (individualImportStatusesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIndividualImportStatusesIsMutable();
        individualImportStatuses_.set(index, value);
        onChanged();
      } else {
        individualImportStatusesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
     * </code>
     */
    public Builder setIndividualImportStatuses(
        int index,
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus.Builder
            builderForValue) {
      if (individualImportStatusesBuilder_ == null) {
        ensureIndividualImportStatusesIsMutable();
        individualImportStatuses_.set(index, builderForValue.build());
        onChanged();
      } else {
        individualImportStatusesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
     * </code>
     */
    public Builder addIndividualImportStatuses(
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus value) {
      if (individualImportStatusesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIndividualImportStatusesIsMutable();
        individualImportStatuses_.add(value);
        onChanged();
      } else {
        individualImportStatusesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
     * </code>
     */
    public Builder addIndividualImportStatuses(
        int index,
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus value) {
      if (individualImportStatusesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIndividualImportStatusesIsMutable();
        individualImportStatuses_.add(index, value);
        onChanged();
      } else {
        individualImportStatusesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
     * </code>
     */
    public Builder addIndividualImportStatuses(
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus.Builder
            builderForValue) {
      if (individualImportStatusesBuilder_ == null) {
        ensureIndividualImportStatusesIsMutable();
        individualImportStatuses_.add(builderForValue.build());
        onChanged();
      } else {
        individualImportStatusesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
     * </code>
     */
    public Builder addIndividualImportStatuses(
        int index,
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus.Builder
            builderForValue) {
      if (individualImportStatusesBuilder_ == null) {
        ensureIndividualImportStatusesIsMutable();
        individualImportStatuses_.add(index, builderForValue.build());
        onChanged();
      } else {
        individualImportStatusesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
     * </code>
     */
    public Builder addAllIndividualImportStatuses(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                        .IndividualImportStatus>
            values) {
      if (individualImportStatusesBuilder_ == null) {
        ensureIndividualImportStatusesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, individualImportStatuses_);
        onChanged();
      } else {
        individualImportStatusesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
     * </code>
     */
    public Builder clearIndividualImportStatuses() {
      if (individualImportStatusesBuilder_ == null) {
        individualImportStatuses_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        individualImportStatusesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
     * </code>
     */
    public Builder removeIndividualImportStatuses(int index) {
      if (individualImportStatusesBuilder_ == null) {
        ensureIndividualImportStatusesIsMutable();
        individualImportStatuses_.remove(index);
        onChanged();
      } else {
        individualImportStatusesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
            .Builder
        getIndividualImportStatusesBuilder(int index) {
      return getIndividualImportStatusesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
            .IndividualImportStatusOrBuilder
        getIndividualImportStatusesOrBuilder(int index) {
      if (individualImportStatusesBuilder_ == null) {
        return individualImportStatuses_.get(index);
      } else {
        return individualImportStatusesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                    .IndividualImportStatusOrBuilder>
        getIndividualImportStatusesOrBuilderList() {
      if (individualImportStatusesBuilder_ != null) {
        return individualImportStatusesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(individualImportStatuses_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
            .Builder
        addIndividualImportStatusesBuilder() {
      return getIndividualImportStatusesFieldBuilder()
          .addBuilder(
              com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
            .Builder
        addIndividualImportStatusesBuilder(int index) {
      return getIndividualImportStatusesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of response details of each document.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus individual_import_statuses = 2;
     * </code>
     */
    public java.util.List<
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
                .Builder>
        getIndividualImportStatusesBuilderList() {
      return getIndividualImportStatusesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus,
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
                .Builder,
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                .IndividualImportStatusOrBuilder>
        getIndividualImportStatusesFieldBuilder() {
      if (individualImportStatusesBuilder_ == null) {
        individualImportStatusesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus,
                com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
                    .Builder,
                com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                    .IndividualImportStatusOrBuilder>(
                individualImportStatuses_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        individualImportStatuses_ = null;
      }
      return individualImportStatusesBuilder_;
    }

    private java.util.List<
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                .ImportConfigValidationResult>
        importConfigValidationResults_ = java.util.Collections.emptyList();

    private void ensureImportConfigValidationResultsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        importConfigValidationResults_ =
            new java.util.ArrayList<
                com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                    .ImportConfigValidationResult>(importConfigValidationResults_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                .ImportConfigValidationResult,
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
                .Builder,
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                .ImportConfigValidationResultOrBuilder>
        importConfigValidationResultsBuilder_;

    /**
     *
     *
     * <pre>
     * Validation statuses of the batch documents import config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
     * </code>
     */
    public java.util.List<
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                .ImportConfigValidationResult>
        getImportConfigValidationResultsList() {
      if (importConfigValidationResultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(importConfigValidationResults_);
      } else {
        return importConfigValidationResultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Validation statuses of the batch documents import config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
     * </code>
     */
    public int getImportConfigValidationResultsCount() {
      if (importConfigValidationResultsBuilder_ == null) {
        return importConfigValidationResults_.size();
      } else {
        return importConfigValidationResultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Validation statuses of the batch documents import config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
        getImportConfigValidationResults(int index) {
      if (importConfigValidationResultsBuilder_ == null) {
        return importConfigValidationResults_.get(index);
      } else {
        return importConfigValidationResultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Validation statuses of the batch documents import config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
     * </code>
     */
    public Builder setImportConfigValidationResults(
        int index,
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
            value) {
      if (importConfigValidationResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImportConfigValidationResultsIsMutable();
        importConfigValidationResults_.set(index, value);
        onChanged();
      } else {
        importConfigValidationResultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Validation statuses of the batch documents import config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
     * </code>
     */
    public Builder setImportConfigValidationResults(
        int index,
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
                .Builder
            builderForValue) {
      if (importConfigValidationResultsBuilder_ == null) {
        ensureImportConfigValidationResultsIsMutable();
        importConfigValidationResults_.set(index, builderForValue.build());
        onChanged();
      } else {
        importConfigValidationResultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Validation statuses of the batch documents import config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
     * </code>
     */
    public Builder addImportConfigValidationResults(
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
            value) {
      if (importConfigValidationResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImportConfigValidationResultsIsMutable();
        importConfigValidationResults_.add(value);
        onChanged();
      } else {
        importConfigValidationResultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Validation statuses of the batch documents import config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
     * </code>
     */
    public Builder addImportConfigValidationResults(
        int index,
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
            value) {
      if (importConfigValidationResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImportConfigValidationResultsIsMutable();
        importConfigValidationResults_.add(index, value);
        onChanged();
      } else {
        importConfigValidationResultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Validation statuses of the batch documents import config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
     * </code>
     */
    public Builder addImportConfigValidationResults(
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
                .Builder
            builderForValue) {
      if (importConfigValidationResultsBuilder_ == null) {
        ensureImportConfigValidationResultsIsMutable();
        importConfigValidationResults_.add(builderForValue.build());
        onChanged();
      } else {
        importConfigValidationResultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Validation statuses of the batch documents import config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
     * </code>
     */
    public Builder addImportConfigValidationResults(
        int index,
        com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
                .Builder
            builderForValue) {
      if (importConfigValidationResultsBuilder_ == null) {
        ensureImportConfigValidationResultsIsMutable();
        importConfigValidationResults_.add(index, builderForValue.build());
        onChanged();
      } else {
        importConfigValidationResultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Validation statuses of the batch documents import config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
     * </code>
     */
    public Builder addAllImportConfigValidationResults(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                        .ImportConfigValidationResult>
            values) {
      if (importConfigValidationResultsBuilder_ == null) {
        ensureImportConfigValidationResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, importConfigValidationResults_);
        onChanged();
      } else {
        importConfigValidationResultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Validation statuses of the batch documents import config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
     * </code>
     */
    public Builder clearImportConfigValidationResults() {
      if (importConfigValidationResultsBuilder_ == null) {
        importConfigValidationResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        importConfigValidationResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Validation statuses of the batch documents import config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
     * </code>
     */
    public Builder removeImportConfigValidationResults(int index) {
      if (importConfigValidationResultsBuilder_ == null) {
        ensureImportConfigValidationResultsIsMutable();
        importConfigValidationResults_.remove(index);
        onChanged();
      } else {
        importConfigValidationResultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Validation statuses of the batch documents import config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
            .Builder
        getImportConfigValidationResultsBuilder(int index) {
      return getImportConfigValidationResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Validation statuses of the batch documents import config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
            .ImportConfigValidationResultOrBuilder
        getImportConfigValidationResultsOrBuilder(int index) {
      if (importConfigValidationResultsBuilder_ == null) {
        return importConfigValidationResults_.get(index);
      } else {
        return importConfigValidationResultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Validation statuses of the batch documents import config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                    .ImportConfigValidationResultOrBuilder>
        getImportConfigValidationResultsOrBuilderList() {
      if (importConfigValidationResultsBuilder_ != null) {
        return importConfigValidationResultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(importConfigValidationResults_);
      }
    }
    /**
     *
     *
     * <pre>
     * Validation statuses of the batch documents import config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
            .Builder
        addImportConfigValidationResultsBuilder() {
      return getImportConfigValidationResultsFieldBuilder()
          .addBuilder(
              com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                  .ImportConfigValidationResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Validation statuses of the batch documents import config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
            .Builder
        addImportConfigValidationResultsBuilder(int index) {
      return getImportConfigValidationResultsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                  .ImportConfigValidationResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Validation statuses of the batch documents import config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult import_config_validation_results = 4;
     * </code>
     */
    public java.util.List<
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
                .Builder>
        getImportConfigValidationResultsBuilderList() {
      return getImportConfigValidationResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                .ImportConfigValidationResult,
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
                .Builder,
            com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                .ImportConfigValidationResultOrBuilder>
        getImportConfigValidationResultsFieldBuilder() {
      if (importConfigValidationResultsBuilder_ == null) {
        importConfigValidationResultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                    .ImportConfigValidationResult,
                com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                    .ImportConfigValidationResult.Builder,
                com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata
                    .ImportConfigValidationResultOrBuilder>(
                importConfigValidationResults_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        importConfigValidationResults_ = null;
      }
      return importConfigValidationResultsBuilder_;
    }

    private int totalDocumentCount_;
    /**
     *
     *
     * <pre>
     * Total number of the documents that are qualified for importing.
     * </pre>
     *
     * <code>int32 total_document_count = 3;</code>
     *
     * @return The totalDocumentCount.
     */
    @java.lang.Override
    public int getTotalDocumentCount() {
      return totalDocumentCount_;
    }
    /**
     *
     *
     * <pre>
     * Total number of the documents that are qualified for importing.
     * </pre>
     *
     * <code>int32 total_document_count = 3;</code>
     *
     * @param value The totalDocumentCount to set.
     * @return This builder for chaining.
     */
    public Builder setTotalDocumentCount(int value) {

      totalDocumentCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total number of the documents that are qualified for importing.
     * </pre>
     *
     * <code>int32 total_document_count = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalDocumentCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      totalDocumentCount_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.ImportDocumentsMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.ImportDocumentsMetadata)
  private static final com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata();
  }

  public static com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportDocumentsMetadata> PARSER =
      new com.google.protobuf.AbstractParser<ImportDocumentsMetadata>() {
        @java.lang.Override
        public ImportDocumentsMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportDocumentsMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportDocumentsMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
