/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/processor.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * The first-class citizen for Document AI. Each processor defines how to
 * extract structural information from a document.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.Processor}
 */
public final class Processor extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Processor)
    ProcessorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Processor.newBuilder() to construct.
  private Processor(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Processor() {
    name_ = "";
    type_ = "";
    displayName_ = "";
    state_ = 0;
    defaultProcessorVersion_ = "";
    processorVersionAliases_ = java.util.Collections.emptyList();
    processEndpoint_ = "";
    kmsKeyName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Processor();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessor
        .internal_static_google_cloud_documentai_v1beta3_Processor_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessor
        .internal_static_google_cloud_documentai_v1beta3_Processor_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.Processor.class,
            com.google.cloud.documentai.v1beta3.Processor.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The possible states of the processor.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.documentai.v1beta3.Processor.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The processor is in an unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The processor is enabled, i.e., has an enabled version which can
     * currently serve processing requests and all the feature dependencies have
     * been successfully initialized.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    ENABLED(1),
    /**
     *
     *
     * <pre>
     * The processor is disabled.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    DISABLED(2),
    /**
     *
     *
     * <pre>
     * The processor is being enabled, will become `ENABLED` if successful.
     * </pre>
     *
     * <code>ENABLING = 3;</code>
     */
    ENABLING(3),
    /**
     *
     *
     * <pre>
     * The processor is being disabled, will become `DISABLED` if successful.
     * </pre>
     *
     * <code>DISABLING = 4;</code>
     */
    DISABLING(4),
    /**
     *
     *
     * <pre>
     * The processor is being created, will become either `ENABLED` (for
     * successful creation) or `FAILED` (for failed ones).
     * Once a processor is in this state, it can then be used for document
     * processing, but the feature dependencies of the processor might not be
     * fully created yet.
     * </pre>
     *
     * <code>CREATING = 5;</code>
     */
    CREATING(5),
    /**
     *
     *
     * <pre>
     * The processor failed during creation or initialization of feature
     * dependencies. The user should delete the processor and recreate one as
     * all the functionalities of the processor are disabled.
     * </pre>
     *
     * <code>FAILED = 6;</code>
     */
    FAILED(6),
    /**
     *
     *
     * <pre>
     * The processor is being deleted, will be removed if successful.
     * </pre>
     *
     * <code>DELETING = 7;</code>
     */
    DELETING(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The processor is in an unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The processor is enabled, i.e., has an enabled version which can
     * currently serve processing requests and all the feature dependencies have
     * been successfully initialized.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    public static final int ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The processor is disabled.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    public static final int DISABLED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The processor is being enabled, will become `ENABLED` if successful.
     * </pre>
     *
     * <code>ENABLING = 3;</code>
     */
    public static final int ENABLING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The processor is being disabled, will become `DISABLED` if successful.
     * </pre>
     *
     * <code>DISABLING = 4;</code>
     */
    public static final int DISABLING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The processor is being created, will become either `ENABLED` (for
     * successful creation) or `FAILED` (for failed ones).
     * Once a processor is in this state, it can then be used for document
     * processing, but the feature dependencies of the processor might not be
     * fully created yet.
     * </pre>
     *
     * <code>CREATING = 5;</code>
     */
    public static final int CREATING_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The processor failed during creation or initialization of feature
     * dependencies. The user should delete the processor and recreate one as
     * all the functionalities of the processor are disabled.
     * </pre>
     *
     * <code>FAILED = 6;</code>
     */
    public static final int FAILED_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The processor is being deleted, will be removed if successful.
     * </pre>
     *
     * <code>DELETING = 7;</code>
     */
    public static final int DELETING_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return ENABLED;
        case 2:
          return DISABLED;
        case 3:
          return ENABLING;
        case 4:
          return DISABLING;
        case 5:
          return CREATING;
        case 6:
          return FAILED;
        case 7:
          return DELETING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.Processor.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.documentai.v1beta3.Processor.State)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The resource name of the processor.
   * Format: `projects/{project}/locations/{location}/processors/{processor}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The resource name of the processor.
   * Format: `projects/{project}/locations/{location}/processors/{processor}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
   * To get a list of processor types, see
   * [FetchProcessorTypes][google.cloud.documentai.v1beta3.DocumentProcessorService.FetchProcessorTypes].
   * </pre>
   *
   * <code>string type = 2;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
   * To get a list of processor types, see
   * [FetchProcessorTypes][google.cloud.documentai.v1beta3.DocumentProcessorService.FetchProcessorTypes].
   * </pre>
   *
   * <code>string type = 2;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The display name of the processor.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of the processor.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state of the processor.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.Processor.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of the processor.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.Processor.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Processor.State getState() {
    com.google.cloud.documentai.v1beta3.Processor.State result =
        com.google.cloud.documentai.v1beta3.Processor.State.forNumber(state_);
    return result == null
        ? com.google.cloud.documentai.v1beta3.Processor.State.UNRECOGNIZED
        : result;
  }

  public static final int DEFAULT_PROCESSOR_VERSION_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultProcessorVersion_ = "";
  /**
   *
   *
   * <pre>
   * The default processor version.
   * </pre>
   *
   * <code>string default_processor_version = 9 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The defaultProcessorVersion.
   */
  @java.lang.Override
  public java.lang.String getDefaultProcessorVersion() {
    java.lang.Object ref = defaultProcessorVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultProcessorVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The default processor version.
   * </pre>
   *
   * <code>string default_processor_version = 9 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for defaultProcessorVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultProcessorVersionBytes() {
    java.lang.Object ref = defaultProcessorVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultProcessorVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROCESSOR_VERSION_ALIASES_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.documentai.v1beta3.ProcessorVersionAlias>
      processorVersionAliases_;
  /**
   *
   *
   * <pre>
   * Output only. The processor version aliases.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.documentai.v1beta3.ProcessorVersionAlias>
      getProcessorVersionAliasesList() {
    return processorVersionAliases_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The processor version aliases.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.documentai.v1beta3.ProcessorVersionAliasOrBuilder>
      getProcessorVersionAliasesOrBuilderList() {
    return processorVersionAliases_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The processor version aliases.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getProcessorVersionAliasesCount() {
    return processorVersionAliases_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The processor version aliases.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ProcessorVersionAlias getProcessorVersionAliases(
      int index) {
    return processorVersionAliases_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The processor version aliases.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ProcessorVersionAliasOrBuilder
      getProcessorVersionAliasesOrBuilder(int index) {
    return processorVersionAliases_.get(index);
  }

  public static final int PROCESS_ENDPOINT_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object processEndpoint_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The http endpoint that can be called to invoke
   * processing.
   * </pre>
   *
   * <code>
   * string process_endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The processEndpoint.
   */
  @java.lang.Override
  public java.lang.String getProcessEndpoint() {
    java.lang.Object ref = processEndpoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      processEndpoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The http endpoint that can be called to invoke
   * processing.
   * </pre>
   *
   * <code>
   * string process_endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for processEndpoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProcessEndpointBytes() {
    java.lang.Object ref = processEndpoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      processEndpoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * The time the processor was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time the processor was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * The time the processor was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int KMS_KEY_NAME_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKeyName_ = "";
  /**
   *
   *
   * <pre>
   * The [KMS key](https://cloud.google.com/security-key-management) used for
   * encryption and decryption in CMEK scenarios.
   * </pre>
   *
   * <code>string kms_key_name = 8;</code>
   *
   * @return The kmsKeyName.
   */
  @java.lang.Override
  public java.lang.String getKmsKeyName() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKeyName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The [KMS key](https://cloud.google.com/security-key-management) used for
   * encryption and decryption in CMEK scenarios.
   * </pre>
   *
   * <code>string kms_key_name = 8;</code>
   *
   * @return The bytes for kmsKeyName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyNameBytes() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKeyName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 12;
  private boolean satisfiesPzs_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int SATISFIES_PZI_FIELD_NUMBER = 13;
  private boolean satisfiesPzi_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzi = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzi.
   */
  @java.lang.Override
  public boolean getSatisfiesPzi() {
    return satisfiesPzi_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
    }
    if (state_
        != com.google.cloud.documentai.v1beta3.Processor.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(processEndpoint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, processEndpoint_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, kmsKeyName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultProcessorVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, defaultProcessorVersion_);
    }
    for (int i = 0; i < processorVersionAliases_.size(); i++) {
      output.writeMessage(10, processorVersionAliases_.get(i));
    }
    if (satisfiesPzs_ != false) {
      output.writeBool(12, satisfiesPzs_);
    }
    if (satisfiesPzi_ != false) {
      output.writeBool(13, satisfiesPzi_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
    }
    if (state_
        != com.google.cloud.documentai.v1beta3.Processor.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(processEndpoint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, processEndpoint_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, kmsKeyName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultProcessorVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, defaultProcessorVersion_);
    }
    for (int i = 0; i < processorVersionAliases_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, processorVersionAliases_.get(i));
    }
    if (satisfiesPzs_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(12, satisfiesPzs_);
    }
    if (satisfiesPzi_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, satisfiesPzi_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.Processor)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.Processor other =
        (com.google.cloud.documentai.v1beta3.Processor) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getType().equals(other.getType())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (state_ != other.state_) return false;
    if (!getDefaultProcessorVersion().equals(other.getDefaultProcessorVersion())) return false;
    if (!getProcessorVersionAliasesList().equals(other.getProcessorVersionAliasesList()))
      return false;
    if (!getProcessEndpoint().equals(other.getProcessEndpoint())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getKmsKeyName().equals(other.getKmsKeyName())) return false;
    if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    if (getSatisfiesPzi() != other.getSatisfiesPzi()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + DEFAULT_PROCESSOR_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultProcessorVersion().hashCode();
    if (getProcessorVersionAliasesCount() > 0) {
      hash = (37 * hash) + PROCESSOR_VERSION_ALIASES_FIELD_NUMBER;
      hash = (53 * hash) + getProcessorVersionAliasesList().hashCode();
    }
    hash = (37 * hash) + PROCESS_ENDPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getProcessEndpoint().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + KMS_KEY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKeyName().hashCode();
    hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    hash = (37 * hash) + SATISFIES_PZI_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzi());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.Processor parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.Processor parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.Processor parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.Processor parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.Processor parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.Processor parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.Processor parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.Processor parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.Processor parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.Processor parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.Processor parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.Processor parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.documentai.v1beta3.Processor prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The first-class citizen for Document AI. Each processor defines how to
   * extract structural information from a document.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.Processor}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Processor)
      com.google.cloud.documentai.v1beta3.ProcessorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessor
          .internal_static_google_cloud_documentai_v1beta3_Processor_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessor
          .internal_static_google_cloud_documentai_v1beta3_Processor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.Processor.class,
              com.google.cloud.documentai.v1beta3.Processor.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.Processor.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getProcessorVersionAliasesFieldBuilder();
        getCreateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      type_ = "";
      displayName_ = "";
      state_ = 0;
      defaultProcessorVersion_ = "";
      if (processorVersionAliasesBuilder_ == null) {
        processorVersionAliases_ = java.util.Collections.emptyList();
      } else {
        processorVersionAliases_ = null;
        processorVersionAliasesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      processEndpoint_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      kmsKeyName_ = "";
      satisfiesPzs_ = false;
      satisfiesPzi_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessor
          .internal_static_google_cloud_documentai_v1beta3_Processor_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Processor getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.Processor.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Processor build() {
      com.google.cloud.documentai.v1beta3.Processor result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Processor buildPartial() {
      com.google.cloud.documentai.v1beta3.Processor result =
          new com.google.cloud.documentai.v1beta3.Processor(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.documentai.v1beta3.Processor result) {
      if (processorVersionAliasesBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          processorVersionAliases_ =
              java.util.Collections.unmodifiableList(processorVersionAliases_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.processorVersionAliases_ = processorVersionAliases_;
      } else {
        result.processorVersionAliases_ = processorVersionAliasesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta3.Processor result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.defaultProcessorVersion_ = defaultProcessorVersion_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.processEndpoint_ = processEndpoint_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.kmsKeyName_ = kmsKeyName_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.satisfiesPzi_ = satisfiesPzi_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.Processor) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.Processor) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.Processor other) {
      if (other == com.google.cloud.documentai.v1beta3.Processor.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getDefaultProcessorVersion().isEmpty()) {
        defaultProcessorVersion_ = other.defaultProcessorVersion_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (processorVersionAliasesBuilder_ == null) {
        if (!other.processorVersionAliases_.isEmpty()) {
          if (processorVersionAliases_.isEmpty()) {
            processorVersionAliases_ = other.processorVersionAliases_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureProcessorVersionAliasesIsMutable();
            processorVersionAliases_.addAll(other.processorVersionAliases_);
          }
          onChanged();
        }
      } else {
        if (!other.processorVersionAliases_.isEmpty()) {
          if (processorVersionAliasesBuilder_.isEmpty()) {
            processorVersionAliasesBuilder_.dispose();
            processorVersionAliasesBuilder_ = null;
            processorVersionAliases_ = other.processorVersionAliases_;
            bitField0_ = (bitField0_ & ~0x00000020);
            processorVersionAliasesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getProcessorVersionAliasesFieldBuilder()
                    : null;
          } else {
            processorVersionAliasesBuilder_.addAllMessages(other.processorVersionAliases_);
          }
        }
      }
      if (!other.getProcessEndpoint().isEmpty()) {
        processEndpoint_ = other.processEndpoint_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (!other.getKmsKeyName().isEmpty()) {
        kmsKeyName_ = other.kmsKeyName_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.getSatisfiesPzs() != false) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.getSatisfiesPzi() != false) {
        setSatisfiesPzi(other.getSatisfiesPzi());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 50:
              {
                processEndpoint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                kmsKeyName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                defaultProcessorVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 74
            case 82:
              {
                com.google.cloud.documentai.v1beta3.ProcessorVersionAlias m =
                    input.readMessage(
                        com.google.cloud.documentai.v1beta3.ProcessorVersionAlias.parser(),
                        extensionRegistry);
                if (processorVersionAliasesBuilder_ == null) {
                  ensureProcessorVersionAliasesIsMutable();
                  processorVersionAliases_.add(m);
                } else {
                  processorVersionAliasesBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 96:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 96
            case 104:
              {
                satisfiesPzi_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 104
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The resource name of the processor.
     * Format: `projects/{project}/locations/{location}/processors/{processor}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The resource name of the processor.
     * Format: `projects/{project}/locations/{location}/processors/{processor}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The resource name of the processor.
     * Format: `projects/{project}/locations/{location}/processors/{processor}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The resource name of the processor.
     * Format: `projects/{project}/locations/{location}/processors/{processor}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The resource name of the processor.
     * Format: `projects/{project}/locations/{location}/processors/{processor}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
     * To get a list of processor types, see
     * [FetchProcessorTypes][google.cloud.documentai.v1beta3.DocumentProcessorService.FetchProcessorTypes].
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
     * To get a list of processor types, see
     * [FetchProcessorTypes][google.cloud.documentai.v1beta3.DocumentProcessorService.FetchProcessorTypes].
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
     * To get a list of processor types, see
     * [FetchProcessorTypes][google.cloud.documentai.v1beta3.DocumentProcessorService.FetchProcessorTypes].
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
     * To get a list of processor types, see
     * [FetchProcessorTypes][google.cloud.documentai.v1beta3.DocumentProcessorService.FetchProcessorTypes].
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
     * To get a list of processor types, see
     * [FetchProcessorTypes][google.cloud.documentai.v1beta3.DocumentProcessorService.FetchProcessorTypes].
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the processor.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the processor.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the processor.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the processor.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the processor.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of the processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Processor.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Processor.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Processor.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Processor.State getState() {
      com.google.cloud.documentai.v1beta3.Processor.State result =
          com.google.cloud.documentai.v1beta3.Processor.State.forNumber(state_);
      return result == null
          ? com.google.cloud.documentai.v1beta3.Processor.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Processor.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.documentai.v1beta3.Processor.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Processor.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000008);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object defaultProcessorVersion_ = "";
    /**
     *
     *
     * <pre>
     * The default processor version.
     * </pre>
     *
     * <code>string default_processor_version = 9 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The defaultProcessorVersion.
     */
    public java.lang.String getDefaultProcessorVersion() {
      java.lang.Object ref = defaultProcessorVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultProcessorVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The default processor version.
     * </pre>
     *
     * <code>string default_processor_version = 9 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for defaultProcessorVersion.
     */
    public com.google.protobuf.ByteString getDefaultProcessorVersionBytes() {
      java.lang.Object ref = defaultProcessorVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultProcessorVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The default processor version.
     * </pre>
     *
     * <code>string default_processor_version = 9 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The defaultProcessorVersion to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultProcessorVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      defaultProcessorVersion_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default processor version.
     * </pre>
     *
     * <code>string default_processor_version = 9 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultProcessorVersion() {
      defaultProcessorVersion_ = getDefaultInstance().getDefaultProcessorVersion();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default processor version.
     * </pre>
     *
     * <code>string default_processor_version = 9 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for defaultProcessorVersion to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultProcessorVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      defaultProcessorVersion_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.documentai.v1beta3.ProcessorVersionAlias>
        processorVersionAliases_ = java.util.Collections.emptyList();

    private void ensureProcessorVersionAliasesIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        processorVersionAliases_ =
            new java.util.ArrayList<com.google.cloud.documentai.v1beta3.ProcessorVersionAlias>(
                processorVersionAliases_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ProcessorVersionAlias,
            com.google.cloud.documentai.v1beta3.ProcessorVersionAlias.Builder,
            com.google.cloud.documentai.v1beta3.ProcessorVersionAliasOrBuilder>
        processorVersionAliasesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The processor version aliases.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.documentai.v1beta3.ProcessorVersionAlias>
        getProcessorVersionAliasesList() {
      if (processorVersionAliasesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(processorVersionAliases_);
      } else {
        return processorVersionAliasesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The processor version aliases.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getProcessorVersionAliasesCount() {
      if (processorVersionAliasesBuilder_ == null) {
        return processorVersionAliases_.size();
      } else {
        return processorVersionAliasesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The processor version aliases.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ProcessorVersionAlias getProcessorVersionAliases(
        int index) {
      if (processorVersionAliasesBuilder_ == null) {
        return processorVersionAliases_.get(index);
      } else {
        return processorVersionAliasesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The processor version aliases.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setProcessorVersionAliases(
        int index, com.google.cloud.documentai.v1beta3.ProcessorVersionAlias value) {
      if (processorVersionAliasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProcessorVersionAliasesIsMutable();
        processorVersionAliases_.set(index, value);
        onChanged();
      } else {
        processorVersionAliasesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The processor version aliases.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setProcessorVersionAliases(
        int index,
        com.google.cloud.documentai.v1beta3.ProcessorVersionAlias.Builder builderForValue) {
      if (processorVersionAliasesBuilder_ == null) {
        ensureProcessorVersionAliasesIsMutable();
        processorVersionAliases_.set(index, builderForValue.build());
        onChanged();
      } else {
        processorVersionAliasesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The processor version aliases.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addProcessorVersionAliases(
        com.google.cloud.documentai.v1beta3.ProcessorVersionAlias value) {
      if (processorVersionAliasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProcessorVersionAliasesIsMutable();
        processorVersionAliases_.add(value);
        onChanged();
      } else {
        processorVersionAliasesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The processor version aliases.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addProcessorVersionAliases(
        int index, com.google.cloud.documentai.v1beta3.ProcessorVersionAlias value) {
      if (processorVersionAliasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProcessorVersionAliasesIsMutable();
        processorVersionAliases_.add(index, value);
        onChanged();
      } else {
        processorVersionAliasesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The processor version aliases.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addProcessorVersionAliases(
        com.google.cloud.documentai.v1beta3.ProcessorVersionAlias.Builder builderForValue) {
      if (processorVersionAliasesBuilder_ == null) {
        ensureProcessorVersionAliasesIsMutable();
        processorVersionAliases_.add(builderForValue.build());
        onChanged();
      } else {
        processorVersionAliasesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The processor version aliases.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addProcessorVersionAliases(
        int index,
        com.google.cloud.documentai.v1beta3.ProcessorVersionAlias.Builder builderForValue) {
      if (processorVersionAliasesBuilder_ == null) {
        ensureProcessorVersionAliasesIsMutable();
        processorVersionAliases_.add(index, builderForValue.build());
        onChanged();
      } else {
        processorVersionAliasesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The processor version aliases.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllProcessorVersionAliases(
        java.lang.Iterable<? extends com.google.cloud.documentai.v1beta3.ProcessorVersionAlias>
            values) {
      if (processorVersionAliasesBuilder_ == null) {
        ensureProcessorVersionAliasesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, processorVersionAliases_);
        onChanged();
      } else {
        processorVersionAliasesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The processor version aliases.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearProcessorVersionAliases() {
      if (processorVersionAliasesBuilder_ == null) {
        processorVersionAliases_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        processorVersionAliasesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The processor version aliases.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeProcessorVersionAliases(int index) {
      if (processorVersionAliasesBuilder_ == null) {
        ensureProcessorVersionAliasesIsMutable();
        processorVersionAliases_.remove(index);
        onChanged();
      } else {
        processorVersionAliasesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The processor version aliases.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ProcessorVersionAlias.Builder
        getProcessorVersionAliasesBuilder(int index) {
      return getProcessorVersionAliasesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The processor version aliases.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ProcessorVersionAliasOrBuilder
        getProcessorVersionAliasesOrBuilder(int index) {
      if (processorVersionAliasesBuilder_ == null) {
        return processorVersionAliases_.get(index);
      } else {
        return processorVersionAliasesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The processor version aliases.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.documentai.v1beta3.ProcessorVersionAliasOrBuilder>
        getProcessorVersionAliasesOrBuilderList() {
      if (processorVersionAliasesBuilder_ != null) {
        return processorVersionAliasesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(processorVersionAliases_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The processor version aliases.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ProcessorVersionAlias.Builder
        addProcessorVersionAliasesBuilder() {
      return getProcessorVersionAliasesFieldBuilder()
          .addBuilder(
              com.google.cloud.documentai.v1beta3.ProcessorVersionAlias.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The processor version aliases.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ProcessorVersionAlias.Builder
        addProcessorVersionAliasesBuilder(int index) {
      return getProcessorVersionAliasesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.documentai.v1beta3.ProcessorVersionAlias.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The processor version aliases.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorVersionAlias processor_version_aliases = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.documentai.v1beta3.ProcessorVersionAlias.Builder>
        getProcessorVersionAliasesBuilderList() {
      return getProcessorVersionAliasesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ProcessorVersionAlias,
            com.google.cloud.documentai.v1beta3.ProcessorVersionAlias.Builder,
            com.google.cloud.documentai.v1beta3.ProcessorVersionAliasOrBuilder>
        getProcessorVersionAliasesFieldBuilder() {
      if (processorVersionAliasesBuilder_ == null) {
        processorVersionAliasesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.ProcessorVersionAlias,
                com.google.cloud.documentai.v1beta3.ProcessorVersionAlias.Builder,
                com.google.cloud.documentai.v1beta3.ProcessorVersionAliasOrBuilder>(
                processorVersionAliases_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        processorVersionAliases_ = null;
      }
      return processorVersionAliasesBuilder_;
    }

    private java.lang.Object processEndpoint_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The http endpoint that can be called to invoke
     * processing.
     * </pre>
     *
     * <code>
     * string process_endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The processEndpoint.
     */
    public java.lang.String getProcessEndpoint() {
      java.lang.Object ref = processEndpoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        processEndpoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The http endpoint that can be called to invoke
     * processing.
     * </pre>
     *
     * <code>
     * string process_endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for processEndpoint.
     */
    public com.google.protobuf.ByteString getProcessEndpointBytes() {
      java.lang.Object ref = processEndpoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        processEndpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The http endpoint that can be called to invoke
     * processing.
     * </pre>
     *
     * <code>
     * string process_endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The processEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setProcessEndpoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      processEndpoint_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The http endpoint that can be called to invoke
     * processing.
     * </pre>
     *
     * <code>
     * string process_endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProcessEndpoint() {
      processEndpoint_ = getDefaultInstance().getProcessEndpoint();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The http endpoint that can be called to invoke
     * processing.
     * </pre>
     *
     * <code>
     * string process_endpoint = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for processEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setProcessEndpointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      processEndpoint_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time the processor was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time the processor was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time the processor was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the processor was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the processor was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the processor was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the processor was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time the processor was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time the processor was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private java.lang.Object kmsKeyName_ = "";
    /**
     *
     *
     * <pre>
     * The [KMS key](https://cloud.google.com/security-key-management) used for
     * encryption and decryption in CMEK scenarios.
     * </pre>
     *
     * <code>string kms_key_name = 8;</code>
     *
     * @return The kmsKeyName.
     */
    public java.lang.String getKmsKeyName() {
      java.lang.Object ref = kmsKeyName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [KMS key](https://cloud.google.com/security-key-management) used for
     * encryption and decryption in CMEK scenarios.
     * </pre>
     *
     * <code>string kms_key_name = 8;</code>
     *
     * @return The bytes for kmsKeyName.
     */
    public com.google.protobuf.ByteString getKmsKeyNameBytes() {
      java.lang.Object ref = kmsKeyName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [KMS key](https://cloud.google.com/security-key-management) used for
     * encryption and decryption in CMEK scenarios.
     * </pre>
     *
     * <code>string kms_key_name = 8;</code>
     *
     * @param value The kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKeyName_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [KMS key](https://cloud.google.com/security-key-management) used for
     * encryption and decryption in CMEK scenarios.
     * </pre>
     *
     * <code>string kms_key_name = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKeyName() {
      kmsKeyName_ = getDefaultInstance().getKmsKeyName();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [KMS key](https://cloud.google.com/security-key-management) used for
     * encryption and decryption in CMEK scenarios.
     * </pre>
     *
     * <code>string kms_key_name = 8;</code>
     *
     * @param value The bytes for kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKeyName_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private boolean satisfiesPzs_;
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x00000200);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private boolean satisfiesPzi_;
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzi.
     */
    @java.lang.Override
    public boolean getSatisfiesPzi() {
      return satisfiesPzi_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzi to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzi(boolean value) {

      satisfiesPzi_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzi() {
      bitField0_ = (bitField0_ & ~0x00000400);
      satisfiesPzi_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Processor)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Processor)
  private static final com.google.cloud.documentai.v1beta3.Processor DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Processor();
  }

  public static com.google.cloud.documentai.v1beta3.Processor getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Processor> PARSER =
      new com.google.protobuf.AbstractParser<Processor>() {
        @java.lang.Override
        public Processor parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Processor> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Processor> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Processor getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
