/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/processor_type.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * A processor type is responsible for performing a certain document
 * understanding task on a certain type of document.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.ProcessorType}
 */
public final class ProcessorType extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.ProcessorType)
    ProcessorTypeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ProcessorType.newBuilder() to construct.
  private ProcessorType(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ProcessorType() {
    name_ = "";
    type_ = "";
    category_ = "";
    availableLocations_ = java.util.Collections.emptyList();
    launchStage_ = 0;
    sampleDocumentUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ProcessorType();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorType
        .internal_static_google_cloud_documentai_v1beta3_ProcessorType_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorType
        .internal_static_google_cloud_documentai_v1beta3_ProcessorType_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.ProcessorType.class,
            com.google.cloud.documentai.v1beta3.ProcessorType.Builder.class);
  }

  public interface LocationInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.ProcessorType.LocationInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The location ID. For supported locations, refer to [regional and
     * multi-regional support](/document-ai/docs/regions).
     * </pre>
     *
     * <code>string location_id = 1;</code>
     *
     * @return The locationId.
     */
    java.lang.String getLocationId();
    /**
     *
     *
     * <pre>
     * The location ID. For supported locations, refer to [regional and
     * multi-regional support](/document-ai/docs/regions).
     * </pre>
     *
     * <code>string location_id = 1;</code>
     *
     * @return The bytes for locationId.
     */
    com.google.protobuf.ByteString getLocationIdBytes();
  }
  /**
   *
   *
   * <pre>
   * The location information about where the processor is available.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.ProcessorType.LocationInfo}
   */
  public static final class LocationInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.ProcessorType.LocationInfo)
      LocationInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use LocationInfo.newBuilder() to construct.
    private LocationInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LocationInfo() {
      locationId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LocationInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorType
          .internal_static_google_cloud_documentai_v1beta3_ProcessorType_LocationInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorType
          .internal_static_google_cloud_documentai_v1beta3_ProcessorType_LocationInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo.class,
              com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo.Builder.class);
    }

    public static final int LOCATION_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object locationId_ = "";
    /**
     *
     *
     * <pre>
     * The location ID. For supported locations, refer to [regional and
     * multi-regional support](/document-ai/docs/regions).
     * </pre>
     *
     * <code>string location_id = 1;</code>
     *
     * @return The locationId.
     */
    @java.lang.Override
    public java.lang.String getLocationId() {
      java.lang.Object ref = locationId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locationId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The location ID. For supported locations, refer to [regional and
     * multi-regional support](/document-ai/docs/regions).
     * </pre>
     *
     * <code>string location_id = 1;</code>
     *
     * @return The bytes for locationId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLocationIdBytes() {
      java.lang.Object ref = locationId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, locationId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, locationId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo other =
          (com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo) obj;

      if (!getLocationId().equals(other.getLocationId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LOCATION_ID_FIELD_NUMBER;
      hash = (53 * hash) + getLocationId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The location information about where the processor is available.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.ProcessorType.LocationInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.ProcessorType.LocationInfo)
        com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorType
            .internal_static_google_cloud_documentai_v1beta3_ProcessorType_LocationInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorType
            .internal_static_google_cloud_documentai_v1beta3_ProcessorType_LocationInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo.class,
                com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo.Builder.class);
      }

      // Construct using com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        locationId_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorType
            .internal_static_google_cloud_documentai_v1beta3_ProcessorType_LocationInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo build() {
        com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo buildPartial() {
        com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo result =
            new com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.locationId_ = locationId_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo) {
          return mergeFrom((com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo other) {
        if (other
            == com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo.getDefaultInstance())
          return this;
        if (!other.getLocationId().isEmpty()) {
          locationId_ = other.locationId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  locationId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object locationId_ = "";
      /**
       *
       *
       * <pre>
       * The location ID. For supported locations, refer to [regional and
       * multi-regional support](/document-ai/docs/regions).
       * </pre>
       *
       * <code>string location_id = 1;</code>
       *
       * @return The locationId.
       */
      public java.lang.String getLocationId() {
        java.lang.Object ref = locationId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          locationId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The location ID. For supported locations, refer to [regional and
       * multi-regional support](/document-ai/docs/regions).
       * </pre>
       *
       * <code>string location_id = 1;</code>
       *
       * @return The bytes for locationId.
       */
      public com.google.protobuf.ByteString getLocationIdBytes() {
        java.lang.Object ref = locationId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          locationId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The location ID. For supported locations, refer to [regional and
       * multi-regional support](/document-ai/docs/regions).
       * </pre>
       *
       * <code>string location_id = 1;</code>
       *
       * @param value The locationId to set.
       * @return This builder for chaining.
       */
      public Builder setLocationId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        locationId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The location ID. For supported locations, refer to [regional and
       * multi-regional support](/document-ai/docs/regions).
       * </pre>
       *
       * <code>string location_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLocationId() {
        locationId_ = getDefaultInstance().getLocationId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The location ID. For supported locations, refer to [regional and
       * multi-regional support](/document-ai/docs/regions).
       * </pre>
       *
       * <code>string location_id = 1;</code>
       *
       * @param value The bytes for locationId to set.
       * @return This builder for chaining.
       */
      public Builder setLocationIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        locationId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.ProcessorType.LocationInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.ProcessorType.LocationInfo)
    private static final com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo();
    }

    public static com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LocationInfo> PARSER =
        new com.google.protobuf.AbstractParser<LocationInfo>() {
          @java.lang.Override
          public LocationInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LocationInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LocationInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the processor type.
   * Format: `projects/{project}/processorTypes/{processor_type}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the processor type.
   * Format: `projects/{project}/processorTypes/{processor_type}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
   * </pre>
   *
   * <code>string type = 2;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
   * </pre>
   *
   * <code>string type = 2;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CATEGORY_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object category_ = "";
  /**
   *
   *
   * <pre>
   * The processor category, used by UI to group processor types.
   * </pre>
   *
   * <code>string category = 3;</code>
   *
   * @return The category.
   */
  @java.lang.Override
  public java.lang.String getCategory() {
    java.lang.Object ref = category_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      category_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The processor category, used by UI to group processor types.
   * </pre>
   *
   * <code>string category = 3;</code>
   *
   * @return The bytes for category.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCategoryBytes() {
    java.lang.Object ref = category_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      category_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AVAILABLE_LOCATIONS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo>
      availableLocations_;
  /**
   *
   *
   * <pre>
   * The locations in which this processor is available.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo>
      getAvailableLocationsList() {
    return availableLocations_;
  }
  /**
   *
   *
   * <pre>
   * The locations in which this processor is available.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfoOrBuilder>
      getAvailableLocationsOrBuilderList() {
    return availableLocations_;
  }
  /**
   *
   *
   * <pre>
   * The locations in which this processor is available.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
   * </code>
   */
  @java.lang.Override
  public int getAvailableLocationsCount() {
    return availableLocations_.size();
  }
  /**
   *
   *
   * <pre>
   * The locations in which this processor is available.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo getAvailableLocations(
      int index) {
    return availableLocations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The locations in which this processor is available.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfoOrBuilder
      getAvailableLocationsOrBuilder(int index) {
    return availableLocations_.get(index);
  }

  public static final int ALLOW_CREATION_FIELD_NUMBER = 6;
  private boolean allowCreation_ = false;
  /**
   *
   *
   * <pre>
   * Whether the processor type allows creation. If true, users can create a
   * processor of this processor type. Otherwise, users need to request access.
   * </pre>
   *
   * <code>bool allow_creation = 6;</code>
   *
   * @return The allowCreation.
   */
  @java.lang.Override
  public boolean getAllowCreation() {
    return allowCreation_;
  }

  public static final int LAUNCH_STAGE_FIELD_NUMBER = 8;
  private int launchStage_ = 0;
  /**
   *
   *
   * <pre>
   * Launch stage of the processor type
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 8;</code>
   *
   * @return The enum numeric value on the wire for launchStage.
   */
  @java.lang.Override
  public int getLaunchStageValue() {
    return launchStage_;
  }
  /**
   *
   *
   * <pre>
   * Launch stage of the processor type
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 8;</code>
   *
   * @return The launchStage.
   */
  @java.lang.Override
  public com.google.api.LaunchStage getLaunchStage() {
    com.google.api.LaunchStage result = com.google.api.LaunchStage.forNumber(launchStage_);
    return result == null ? com.google.api.LaunchStage.UNRECOGNIZED : result;
  }

  public static final int SAMPLE_DOCUMENT_URIS_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList sampleDocumentUris_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A set of Cloud Storage URIs of sample documents for this processor.
   * </pre>
   *
   * <code>repeated string sample_document_uris = 9;</code>
   *
   * @return A list containing the sampleDocumentUris.
   */
  public com.google.protobuf.ProtocolStringList getSampleDocumentUrisList() {
    return sampleDocumentUris_;
  }
  /**
   *
   *
   * <pre>
   * A set of Cloud Storage URIs of sample documents for this processor.
   * </pre>
   *
   * <code>repeated string sample_document_uris = 9;</code>
   *
   * @return The count of sampleDocumentUris.
   */
  public int getSampleDocumentUrisCount() {
    return sampleDocumentUris_.size();
  }
  /**
   *
   *
   * <pre>
   * A set of Cloud Storage URIs of sample documents for this processor.
   * </pre>
   *
   * <code>repeated string sample_document_uris = 9;</code>
   *
   * @param index The index of the element to return.
   * @return The sampleDocumentUris at the given index.
   */
  public java.lang.String getSampleDocumentUris(int index) {
    return sampleDocumentUris_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A set of Cloud Storage URIs of sample documents for this processor.
   * </pre>
   *
   * <code>repeated string sample_document_uris = 9;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sampleDocumentUris at the given index.
   */
  public com.google.protobuf.ByteString getSampleDocumentUrisBytes(int index) {
    return sampleDocumentUris_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(category_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, category_);
    }
    for (int i = 0; i < availableLocations_.size(); i++) {
      output.writeMessage(4, availableLocations_.get(i));
    }
    if (allowCreation_ != false) {
      output.writeBool(6, allowCreation_);
    }
    if (launchStage_ != com.google.api.LaunchStage.LAUNCH_STAGE_UNSPECIFIED.getNumber()) {
      output.writeEnum(8, launchStage_);
    }
    for (int i = 0; i < sampleDocumentUris_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, sampleDocumentUris_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(category_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, category_);
    }
    for (int i = 0; i < availableLocations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, availableLocations_.get(i));
    }
    if (allowCreation_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, allowCreation_);
    }
    if (launchStage_ != com.google.api.LaunchStage.LAUNCH_STAGE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, launchStage_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sampleDocumentUris_.size(); i++) {
        dataSize += computeStringSizeNoTag(sampleDocumentUris_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSampleDocumentUrisList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.ProcessorType)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.ProcessorType other =
        (com.google.cloud.documentai.v1beta3.ProcessorType) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getType().equals(other.getType())) return false;
    if (!getCategory().equals(other.getCategory())) return false;
    if (!getAvailableLocationsList().equals(other.getAvailableLocationsList())) return false;
    if (getAllowCreation() != other.getAllowCreation()) return false;
    if (launchStage_ != other.launchStage_) return false;
    if (!getSampleDocumentUrisList().equals(other.getSampleDocumentUrisList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    hash = (37 * hash) + CATEGORY_FIELD_NUMBER;
    hash = (53 * hash) + getCategory().hashCode();
    if (getAvailableLocationsCount() > 0) {
      hash = (37 * hash) + AVAILABLE_LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getAvailableLocationsList().hashCode();
    }
    hash = (37 * hash) + ALLOW_CREATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowCreation());
    hash = (37 * hash) + LAUNCH_STAGE_FIELD_NUMBER;
    hash = (53 * hash) + launchStage_;
    if (getSampleDocumentUrisCount() > 0) {
      hash = (37 * hash) + SAMPLE_DOCUMENT_URIS_FIELD_NUMBER;
      hash = (53 * hash) + getSampleDocumentUrisList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.ProcessorType parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessorType parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessorType parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessorType parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessorType parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessorType parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessorType parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessorType parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessorType parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessorType parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessorType parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessorType parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.documentai.v1beta3.ProcessorType prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A processor type is responsible for performing a certain document
   * understanding task on a certain type of document.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.ProcessorType}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.ProcessorType)
      com.google.cloud.documentai.v1beta3.ProcessorTypeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorType
          .internal_static_google_cloud_documentai_v1beta3_ProcessorType_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorType
          .internal_static_google_cloud_documentai_v1beta3_ProcessorType_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.ProcessorType.class,
              com.google.cloud.documentai.v1beta3.ProcessorType.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.ProcessorType.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      type_ = "";
      category_ = "";
      if (availableLocationsBuilder_ == null) {
        availableLocations_ = java.util.Collections.emptyList();
      } else {
        availableLocations_ = null;
        availableLocationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      allowCreation_ = false;
      launchStage_ = 0;
      sampleDocumentUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorType
          .internal_static_google_cloud_documentai_v1beta3_ProcessorType_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessorType getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.ProcessorType.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessorType build() {
      com.google.cloud.documentai.v1beta3.ProcessorType result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessorType buildPartial() {
      com.google.cloud.documentai.v1beta3.ProcessorType result =
          new com.google.cloud.documentai.v1beta3.ProcessorType(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.documentai.v1beta3.ProcessorType result) {
      if (availableLocationsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          availableLocations_ = java.util.Collections.unmodifiableList(availableLocations_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.availableLocations_ = availableLocations_;
      } else {
        result.availableLocations_ = availableLocationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta3.ProcessorType result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.category_ = category_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.allowCreation_ = allowCreation_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.launchStage_ = launchStage_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        sampleDocumentUris_.makeImmutable();
        result.sampleDocumentUris_ = sampleDocumentUris_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.ProcessorType) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.ProcessorType) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.ProcessorType other) {
      if (other == com.google.cloud.documentai.v1beta3.ProcessorType.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getCategory().isEmpty()) {
        category_ = other.category_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (availableLocationsBuilder_ == null) {
        if (!other.availableLocations_.isEmpty()) {
          if (availableLocations_.isEmpty()) {
            availableLocations_ = other.availableLocations_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureAvailableLocationsIsMutable();
            availableLocations_.addAll(other.availableLocations_);
          }
          onChanged();
        }
      } else {
        if (!other.availableLocations_.isEmpty()) {
          if (availableLocationsBuilder_.isEmpty()) {
            availableLocationsBuilder_.dispose();
            availableLocationsBuilder_ = null;
            availableLocations_ = other.availableLocations_;
            bitField0_ = (bitField0_ & ~0x00000008);
            availableLocationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAvailableLocationsFieldBuilder()
                    : null;
          } else {
            availableLocationsBuilder_.addAllMessages(other.availableLocations_);
          }
        }
      }
      if (other.getAllowCreation() != false) {
        setAllowCreation(other.getAllowCreation());
      }
      if (other.launchStage_ != 0) {
        setLaunchStageValue(other.getLaunchStageValue());
      }
      if (!other.sampleDocumentUris_.isEmpty()) {
        if (sampleDocumentUris_.isEmpty()) {
          sampleDocumentUris_ = other.sampleDocumentUris_;
          bitField0_ |= 0x00000040;
        } else {
          ensureSampleDocumentUrisIsMutable();
          sampleDocumentUris_.addAll(other.sampleDocumentUris_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                category_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo m =
                    input.readMessage(
                        com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo.parser(),
                        extensionRegistry);
                if (availableLocationsBuilder_ == null) {
                  ensureAvailableLocationsIsMutable();
                  availableLocations_.add(m);
                } else {
                  availableLocationsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 48:
              {
                allowCreation_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            case 64:
              {
                launchStage_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 64
            case 74:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSampleDocumentUrisIsMutable();
                sampleDocumentUris_.add(s);
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the processor type.
     * Format: `projects/{project}/processorTypes/{processor_type}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the processor type.
     * Format: `projects/{project}/processorTypes/{processor_type}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the processor type.
     * Format: `projects/{project}/processorTypes/{processor_type}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the processor type.
     * Format: `projects/{project}/processorTypes/{processor_type}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the processor type.
     * Format: `projects/{project}/processorTypes/{processor_type}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
     * </pre>
     *
     * <code>string type = 2;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object category_ = "";
    /**
     *
     *
     * <pre>
     * The processor category, used by UI to group processor types.
     * </pre>
     *
     * <code>string category = 3;</code>
     *
     * @return The category.
     */
    public java.lang.String getCategory() {
      java.lang.Object ref = category_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        category_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The processor category, used by UI to group processor types.
     * </pre>
     *
     * <code>string category = 3;</code>
     *
     * @return The bytes for category.
     */
    public com.google.protobuf.ByteString getCategoryBytes() {
      java.lang.Object ref = category_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        category_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The processor category, used by UI to group processor types.
     * </pre>
     *
     * <code>string category = 3;</code>
     *
     * @param value The category to set.
     * @return This builder for chaining.
     */
    public Builder setCategory(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      category_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The processor category, used by UI to group processor types.
     * </pre>
     *
     * <code>string category = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCategory() {
      category_ = getDefaultInstance().getCategory();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The processor category, used by UI to group processor types.
     * </pre>
     *
     * <code>string category = 3;</code>
     *
     * @param value The bytes for category to set.
     * @return This builder for chaining.
     */
    public Builder setCategoryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      category_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo>
        availableLocations_ = java.util.Collections.emptyList();

    private void ensureAvailableLocationsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        availableLocations_ =
            new java.util.ArrayList<com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo>(
                availableLocations_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo,
            com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo.Builder,
            com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfoOrBuilder>
        availableLocationsBuilder_;

    /**
     *
     *
     * <pre>
     * The locations in which this processor is available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo>
        getAvailableLocationsList() {
      if (availableLocationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(availableLocations_);
      } else {
        return availableLocationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The locations in which this processor is available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
     * </code>
     */
    public int getAvailableLocationsCount() {
      if (availableLocationsBuilder_ == null) {
        return availableLocations_.size();
      } else {
        return availableLocationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The locations in which this processor is available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo getAvailableLocations(
        int index) {
      if (availableLocationsBuilder_ == null) {
        return availableLocations_.get(index);
      } else {
        return availableLocationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The locations in which this processor is available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
     * </code>
     */
    public Builder setAvailableLocations(
        int index, com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo value) {
      if (availableLocationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAvailableLocationsIsMutable();
        availableLocations_.set(index, value);
        onChanged();
      } else {
        availableLocationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The locations in which this processor is available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
     * </code>
     */
    public Builder setAvailableLocations(
        int index,
        com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo.Builder builderForValue) {
      if (availableLocationsBuilder_ == null) {
        ensureAvailableLocationsIsMutable();
        availableLocations_.set(index, builderForValue.build());
        onChanged();
      } else {
        availableLocationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The locations in which this processor is available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
     * </code>
     */
    public Builder addAvailableLocations(
        com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo value) {
      if (availableLocationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAvailableLocationsIsMutable();
        availableLocations_.add(value);
        onChanged();
      } else {
        availableLocationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The locations in which this processor is available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
     * </code>
     */
    public Builder addAvailableLocations(
        int index, com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo value) {
      if (availableLocationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAvailableLocationsIsMutable();
        availableLocations_.add(index, value);
        onChanged();
      } else {
        availableLocationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The locations in which this processor is available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
     * </code>
     */
    public Builder addAvailableLocations(
        com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo.Builder builderForValue) {
      if (availableLocationsBuilder_ == null) {
        ensureAvailableLocationsIsMutable();
        availableLocations_.add(builderForValue.build());
        onChanged();
      } else {
        availableLocationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The locations in which this processor is available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
     * </code>
     */
    public Builder addAvailableLocations(
        int index,
        com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo.Builder builderForValue) {
      if (availableLocationsBuilder_ == null) {
        ensureAvailableLocationsIsMutable();
        availableLocations_.add(index, builderForValue.build());
        onChanged();
      } else {
        availableLocationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The locations in which this processor is available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
     * </code>
     */
    public Builder addAllAvailableLocations(
        java.lang.Iterable<? extends com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo>
            values) {
      if (availableLocationsBuilder_ == null) {
        ensureAvailableLocationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, availableLocations_);
        onChanged();
      } else {
        availableLocationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The locations in which this processor is available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
     * </code>
     */
    public Builder clearAvailableLocations() {
      if (availableLocationsBuilder_ == null) {
        availableLocations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        availableLocationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The locations in which this processor is available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
     * </code>
     */
    public Builder removeAvailableLocations(int index) {
      if (availableLocationsBuilder_ == null) {
        ensureAvailableLocationsIsMutable();
        availableLocations_.remove(index);
        onChanged();
      } else {
        availableLocationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The locations in which this processor is available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo.Builder
        getAvailableLocationsBuilder(int index) {
      return getAvailableLocationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The locations in which this processor is available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfoOrBuilder
        getAvailableLocationsOrBuilder(int index) {
      if (availableLocationsBuilder_ == null) {
        return availableLocations_.get(index);
      } else {
        return availableLocationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The locations in which this processor is available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfoOrBuilder>
        getAvailableLocationsOrBuilderList() {
      if (availableLocationsBuilder_ != null) {
        return availableLocationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(availableLocations_);
      }
    }
    /**
     *
     *
     * <pre>
     * The locations in which this processor is available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo.Builder
        addAvailableLocationsBuilder() {
      return getAvailableLocationsFieldBuilder()
          .addBuilder(
              com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The locations in which this processor is available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo.Builder
        addAvailableLocationsBuilder(int index) {
      return getAvailableLocationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The locations in which this processor is available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.ProcessorType.LocationInfo available_locations = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo.Builder>
        getAvailableLocationsBuilderList() {
      return getAvailableLocationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo,
            com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo.Builder,
            com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfoOrBuilder>
        getAvailableLocationsFieldBuilder() {
      if (availableLocationsBuilder_ == null) {
        availableLocationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo,
                com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfo.Builder,
                com.google.cloud.documentai.v1beta3.ProcessorType.LocationInfoOrBuilder>(
                availableLocations_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        availableLocations_ = null;
      }
      return availableLocationsBuilder_;
    }

    private boolean allowCreation_;
    /**
     *
     *
     * <pre>
     * Whether the processor type allows creation. If true, users can create a
     * processor of this processor type. Otherwise, users need to request access.
     * </pre>
     *
     * <code>bool allow_creation = 6;</code>
     *
     * @return The allowCreation.
     */
    @java.lang.Override
    public boolean getAllowCreation() {
      return allowCreation_;
    }
    /**
     *
     *
     * <pre>
     * Whether the processor type allows creation. If true, users can create a
     * processor of this processor type. Otherwise, users need to request access.
     * </pre>
     *
     * <code>bool allow_creation = 6;</code>
     *
     * @param value The allowCreation to set.
     * @return This builder for chaining.
     */
    public Builder setAllowCreation(boolean value) {

      allowCreation_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the processor type allows creation. If true, users can create a
     * processor of this processor type. Otherwise, users need to request access.
     * </pre>
     *
     * <code>bool allow_creation = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowCreation() {
      bitField0_ = (bitField0_ & ~0x00000010);
      allowCreation_ = false;
      onChanged();
      return this;
    }

    private int launchStage_ = 0;
    /**
     *
     *
     * <pre>
     * Launch stage of the processor type
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 8;</code>
     *
     * @return The enum numeric value on the wire for launchStage.
     */
    @java.lang.Override
    public int getLaunchStageValue() {
      return launchStage_;
    }
    /**
     *
     *
     * <pre>
     * Launch stage of the processor type
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 8;</code>
     *
     * @param value The enum numeric value on the wire for launchStage to set.
     * @return This builder for chaining.
     */
    public Builder setLaunchStageValue(int value) {
      launchStage_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Launch stage of the processor type
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 8;</code>
     *
     * @return The launchStage.
     */
    @java.lang.Override
    public com.google.api.LaunchStage getLaunchStage() {
      com.google.api.LaunchStage result = com.google.api.LaunchStage.forNumber(launchStage_);
      return result == null ? com.google.api.LaunchStage.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Launch stage of the processor type
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 8;</code>
     *
     * @param value The launchStage to set.
     * @return This builder for chaining.
     */
    public Builder setLaunchStage(com.google.api.LaunchStage value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      launchStage_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Launch stage of the processor type
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLaunchStage() {
      bitField0_ = (bitField0_ & ~0x00000020);
      launchStage_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList sampleDocumentUris_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSampleDocumentUrisIsMutable() {
      if (!sampleDocumentUris_.isModifiable()) {
        sampleDocumentUris_ = new com.google.protobuf.LazyStringArrayList(sampleDocumentUris_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     *
     *
     * <pre>
     * A set of Cloud Storage URIs of sample documents for this processor.
     * </pre>
     *
     * <code>repeated string sample_document_uris = 9;</code>
     *
     * @return A list containing the sampleDocumentUris.
     */
    public com.google.protobuf.ProtocolStringList getSampleDocumentUrisList() {
      sampleDocumentUris_.makeImmutable();
      return sampleDocumentUris_;
    }
    /**
     *
     *
     * <pre>
     * A set of Cloud Storage URIs of sample documents for this processor.
     * </pre>
     *
     * <code>repeated string sample_document_uris = 9;</code>
     *
     * @return The count of sampleDocumentUris.
     */
    public int getSampleDocumentUrisCount() {
      return sampleDocumentUris_.size();
    }
    /**
     *
     *
     * <pre>
     * A set of Cloud Storage URIs of sample documents for this processor.
     * </pre>
     *
     * <code>repeated string sample_document_uris = 9;</code>
     *
     * @param index The index of the element to return.
     * @return The sampleDocumentUris at the given index.
     */
    public java.lang.String getSampleDocumentUris(int index) {
      return sampleDocumentUris_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A set of Cloud Storage URIs of sample documents for this processor.
     * </pre>
     *
     * <code>repeated string sample_document_uris = 9;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the sampleDocumentUris at the given index.
     */
    public com.google.protobuf.ByteString getSampleDocumentUrisBytes(int index) {
      return sampleDocumentUris_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A set of Cloud Storage URIs of sample documents for this processor.
     * </pre>
     *
     * <code>repeated string sample_document_uris = 9;</code>
     *
     * @param index The index to set the value at.
     * @param value The sampleDocumentUris to set.
     * @return This builder for chaining.
     */
    public Builder setSampleDocumentUris(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSampleDocumentUrisIsMutable();
      sampleDocumentUris_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of Cloud Storage URIs of sample documents for this processor.
     * </pre>
     *
     * <code>repeated string sample_document_uris = 9;</code>
     *
     * @param value The sampleDocumentUris to add.
     * @return This builder for chaining.
     */
    public Builder addSampleDocumentUris(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSampleDocumentUrisIsMutable();
      sampleDocumentUris_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of Cloud Storage URIs of sample documents for this processor.
     * </pre>
     *
     * <code>repeated string sample_document_uris = 9;</code>
     *
     * @param values The sampleDocumentUris to add.
     * @return This builder for chaining.
     */
    public Builder addAllSampleDocumentUris(java.lang.Iterable<java.lang.String> values) {
      ensureSampleDocumentUrisIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sampleDocumentUris_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of Cloud Storage URIs of sample documents for this processor.
     * </pre>
     *
     * <code>repeated string sample_document_uris = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSampleDocumentUris() {
      sampleDocumentUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of Cloud Storage URIs of sample documents for this processor.
     * </pre>
     *
     * <code>repeated string sample_document_uris = 9;</code>
     *
     * @param value The bytes of the sampleDocumentUris to add.
     * @return This builder for chaining.
     */
    public Builder addSampleDocumentUrisBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSampleDocumentUrisIsMutable();
      sampleDocumentUris_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.ProcessorType)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.ProcessorType)
  private static final com.google.cloud.documentai.v1beta3.ProcessorType DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.ProcessorType();
  }

  public static com.google.cloud.documentai.v1beta3.ProcessorType getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ProcessorType> PARSER =
      new com.google.protobuf.AbstractParser<ProcessorType>() {
        @java.lang.Override
        public ProcessorType parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ProcessorType> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ProcessorType> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ProcessorType getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
